"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.read = void 0;
const fs_1 = require("fs");
const utils_1 = require("../utils");
const READ_CACHE = {};
const READ_CACHE_TIME = {};
async function read(filePath) {
    try {
        const stat = await fs_1.promises.stat(filePath);
        const modifiedTime = stat.mtime.getTime();
        if (READ_CACHE_TIME[filePath] === modifiedTime) {
            return READ_CACHE[filePath];
        }
        const contents = await fs_1.promises.readFile(filePath, 'utf-8');
        const normalisedContents = (0, utils_1.normaliseNewlines)(contents);
        READ_CACHE[filePath] = normalisedContents;
        READ_CACHE_TIME[filePath] = modifiedTime;
        return normalisedContents;
    }
    catch (_a) {
        return null;
    }
}
exports.read = read;
//# sourceMappingURL=reader.js.map