"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createGlobals = void 0;
const config_1 = require("./config");
const fs_1 = require("./fs");
const reporters_1 = require("./reporters");
const results_1 = require("./results");
async function createGlobals(options = {}) {
    const reporter = (0, reporters_1.loadDefaultReporter)();
    const versionControl = (0, fs_1.createVersionControl)();
    try {
        const config = await (0, config_1.createConfig)(options, versionControl);
        if (config.cache) {
            await versionControl.enableCache(config.cachePath);
        }
        const resultsFile = await results_1.BettererResultsFileΩ.create(config.resultsPath, versionControl);
        return { config, resultsFile, versionControl };
    }
    catch (error) {
        await versionControl.destroy();
        await reporter.configError(options, error);
        throw error;
    }
}
exports.createGlobals = createGlobals;
//# sourceMappingURL=globals.js.map