"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.loadSilentReporter = exports.loadReporters = exports.loadDefaultReporter = void 0;
const tslib_1 = require("tslib");
const errors_1 = require("@betterer/errors");
const path = (0, tslib_1.__importStar)(require("path"));
const require_1 = require("../require");
const utils_1 = require("../utils");
const reporter_1 = require("./reporter");
const DEFAULT_REPORTER = '@betterer/reporter';
const HOOK_NAMES = Object.getOwnPropertyNames(reporter_1.BettererReporterΩ.prototype);
function loadDefaultReporter() {
    const module = (0, require_1.requireUncached)(DEFAULT_REPORTER);
    return new reporter_1.BettererReporterΩ([module.reporter]);
}
exports.loadDefaultReporter = loadDefaultReporter;
function loadReporters(reporters, cwd) {
    if (reporters.length === 0) {
        return loadDefaultReporter();
    }
    return new reporter_1.BettererReporterΩ(reporters.map((reporter) => {
        if ((0, utils_1.isString)(reporter)) {
            reporter = resolveReporter(cwd, reporter);
            try {
                const module = (0, require_1.requireUncached)(reporter);
                if (!module || !module.reporter) {
                    throw new errors_1.BettererError(`"${reporter}" didn't create a reporter. 😔`);
                }
                validate(module.reporter);
                return module.reporter;
            }
            catch (error) {
                throw new errors_1.BettererError(`could not require "${reporter}". 😔`, error);
            }
        }
        validate(reporter);
        return reporter;
    }));
}
exports.loadReporters = loadReporters;
function loadSilentReporter() {
    return new reporter_1.BettererReporterΩ([]);
}
exports.loadSilentReporter = loadSilentReporter;
function validate(result) {
    const reporter = result;
    Object.keys(reporter).forEach((key) => {
        const hookName = key;
        if (!HOOK_NAMES.includes(hookName)) {
            throw new errors_1.BettererError(`"${hookName}" is not a valid reporter hook name. 😔`);
        }
        if (!(0, utils_1.isFunction)(reporter[hookName])) {
            throw new errors_1.BettererError(`"${hookName}" is not a function. 😔`);
        }
    });
}
function resolveReporter(cwd, reporter) {
    try {
        // Local file:
        return require.resolve(path.resolve(cwd, reporter));
    }
    catch (_a) {
        // npm module:
        return reporter;
    }
}
//# sourceMappingURL=loader.js.map