import { BettererError } from '@betterer/errors';
import { BettererContext } from '../context';
import { BettererContextSummary } from '../context/types';
import { BettererRun, BettererRunSummary } from '../run';
import { BettererSuite, BettererSuiteSummary } from '../suite';
import { BettererReporter } from './types';
export declare class BettererReporterΩ implements BettererReporter {
    private _reporters;
    constructor(_reporters: Array<BettererReporter>);
    configError(invalidConfig: unknown, error: BettererError): Promise<void>;
    contextStart(context: BettererContext, lifecycle: Promise<BettererContextSummary>): Promise<void>;
    contextEnd(contextSummary: BettererContextSummary): Promise<void>;
    contextError(context: BettererContext, error: BettererError): Promise<void>;
    suiteStart(suite: BettererSuite, lifecycle: Promise<BettererSuiteSummary>): Promise<void>;
    suiteEnd(suiteSummary: BettererSuiteSummary): Promise<void>;
    suiteError(suite: BettererSuite, error: BettererError): Promise<void>;
    runStart(run: BettererRun, lifecycle: Promise<BettererRunSummary>): Promise<void>;
    runEnd(run: BettererRunSummary): Promise<void>;
    runError(run: BettererRun, error: BettererError): Promise<void>;
}
//# sourceMappingURL=reporter.d.ts.map