"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BettererMergerΩ = void 0;
const config_1 = require("../config");
const fs_1 = require("../fs");
const merge_1 = require("./merge");
const parse_1 = require("./parse");
const print_1 = require("./print");
class BettererMergerΩ {
    constructor(_contents, _resultsPath) {
        this._contents = _contents;
        this._resultsPath = _resultsPath;
    }
    static async create(options) {
        const { contents, resultsPath } = await (0, config_1.createMergeConfig)(options);
        return new BettererMergerΩ(contents, resultsPath);
    }
    async merge() {
        let merged;
        if (this._contents.length === 2) {
            const [ours, theirs] = this._contents;
            merged = (0, merge_1.mergeResults)(ours, theirs);
        }
        else {
            merged = await (0, parse_1.parseResults)(this._resultsPath);
        }
        await (0, fs_1.write)((0, print_1.printResults)(merged), this._resultsPath);
    }
}
exports.BettererMergerΩ = BettererMergerΩ;
//# sourceMappingURL=merger.js.map