"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BettererRunSummaryΩ = exports.BettererRunStatus = void 0;
var BettererRunStatus;
(function (BettererRunStatus) {
    BettererRunStatus[BettererRunStatus["better"] = 0] = "better";
    BettererRunStatus[BettererRunStatus["failed"] = 1] = "failed";
    BettererRunStatus[BettererRunStatus["new"] = 2] = "new";
    BettererRunStatus[BettererRunStatus["same"] = 3] = "same";
    BettererRunStatus[BettererRunStatus["skipped"] = 4] = "skipped";
    BettererRunStatus[BettererRunStatus["update"] = 5] = "update";
    BettererRunStatus[BettererRunStatus["worse"] = 6] = "worse";
})(BettererRunStatus = exports.BettererRunStatus || (exports.BettererRunStatus = {}));
class BettererRunSummaryΩ {
    constructor(run, result, baseline, expected, status, isComplete, isExpired, delta, diff, error, printed, timestamp) {
        this.result = result;
        this.baseline = baseline;
        this.expected = expected;
        this.isComplete = isComplete;
        this.isExpired = isExpired;
        this.delta = delta;
        this.diff = diff;
        this.error = error;
        this.printed = printed;
        this.timestamp = timestamp;
        this.name = run.name;
        this.filePaths = run.filePaths;
        this.isBetter = status === BettererRunStatus.better;
        this.isFailed = status === BettererRunStatus.failed;
        this.isNew = status === BettererRunStatus.new;
        this.isSame = status === BettererRunStatus.same;
        this.isSkipped = status === BettererRunStatus.skipped;
        this.isUpdated = status === BettererRunStatus.update;
        this.isWorse = status === BettererRunStatus.worse;
    }
}
exports.BettererRunSummaryΩ = BettererRunSummaryΩ;
//# sourceMappingURL=run-summary.js.map