import { BettererWorkerRunConfig } from '../config';
import { BettererFilePaths, BettererVersionControlWorker } from '../fs';
import { BettererResultΩ } from '../results';
import { BettererTestMeta } from '../test';
import { BettererRunWorkerPoolΩ } from './run-worker-pool';
import { BettererRun, BettererRunSummary } from './types';
export declare class BettererRunΩ implements BettererRun {
    name: string;
    private _workerHandle;
    testMeta: BettererTestMeta;
    baseline: BettererResultΩ | null;
    expected: BettererResultΩ | null;
    filePaths: BettererFilePaths | null;
    readonly isNew: boolean;
    readonly isSkipped: boolean;
    private constructor();
    static create(runWorkerPool: BettererRunWorkerPoolΩ, testName: string, config: BettererWorkerRunConfig, filePaths: BettererFilePaths, versionControl: BettererVersionControlWorker): Promise<BettererRunΩ>;
    run(isSkipped: boolean): Promise<BettererRunSummary>;
}
export declare type BettererRunsΩ = ReadonlyArray<BettererRunΩ>;
//# sourceMappingURL=run.d.ts.map