import { BettererConfig, BettererWorkerRunConfig } from '../config';
import { BettererFilePaths, BettererVersionControlWorker } from '../fs';
import { BettererResultΩ } from '../results';
import { BettererTestConfig, BettererTestMeta } from '../test';
import { BettererGlobals } from '../types';
import { BettererRun, BettererRunSummary } from './types';
export declare class BettererWorkerRunΩ implements BettererRun {
    readonly name: string;
    readonly globals: BettererGlobals;
    readonly testMeta: BettererTestMeta;
    readonly test: BettererTestConfig;
    readonly config: BettererConfig;
    readonly isNew: boolean;
    readonly isSkipped: boolean;
    filePaths: BettererFilePaths | null;
    private _baseline;
    private _expected;
    private constructor();
    get baseline(): BettererResultΩ;
    get expected(): BettererResultΩ;
    static create(runConfig: BettererWorkerRunConfig, name: string, versionControl: BettererVersionControlWorker): Promise<BettererWorkerRunΩ>;
    run(filePaths: BettererFilePaths | null, isSkipped: boolean, timestamp: number): Promise<BettererRunSummary>;
    private _deserialise;
    private _run;
}
//# sourceMappingURL=worker-run.d.ts.map