"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.defaultDiffer = exports.createGoal = exports.createDeadline = exports.createTestConfig = void 0;
const errors_1 = require("@betterer/errors");
const logger_1 = require("@betterer/logger");
const prettier_1 = require("prettier");
const utils_1 = require("../utils");
function createTestConfig(options) {
    if (options.constraint == null) {
        throw new errors_1.BettererError('for a test to work, it must have a `constraint` function. ❌');
    }
    if (options.test == null) {
        throw new errors_1.BettererError('for a test to work, it must have a `test` function. ❌');
    }
    const deadline = createDeadline(options);
    const goal = createGoal(options);
    if (isComplex(options)) {
        return Object.assign(Object.assign({ configPath: '', printer: defaultPrinter, progress: defaultProgress }, options), { goal,
            deadline });
    }
    return Object.assign(Object.assign({}, options), { configPath: '', differ: defaultDiffer, printer: defaultPrinter, progress: defaultProgress, serialiser: {
            deserialise: defaultDeserialiser,
            serialise: defaultSerialiser
        }, goal,
        deadline });
}
exports.createTestConfig = createTestConfig;
function createDeadline(options) {
    const { deadline } = options;
    if (deadline == null) {
        return Infinity;
    }
    const maybeDate = new Date(deadline).getTime();
    return !isNaN(maybeDate) ? maybeDate : Infinity;
}
exports.createDeadline = createDeadline;
function createGoal(options) {
    const { goal } = options;
    if (goal == null) {
        return () => false;
    }
    if ((0, utils_1.isFunction)(goal)) {
        return goal;
    }
    return (value) => value === goal;
}
exports.createGoal = createGoal;
function isComplex(options) {
    const maybeComplex = options;
    return !!maybeComplex.differ && !!maybeComplex.serialiser;
}
function defaultDiffer(expected, result) {
    const diff = (0, logger_1.diff__)(expected, result, { aAnnotation: 'Expected', bAnnotation: 'Result' });
    const logs = diff ? [{ error: diff }] : [];
    return {
        diff: null,
        logs
    };
}
exports.defaultDiffer = defaultDiffer;
function defaultPrinter(serialised) {
    return (0, prettier_1.format)(JSON.stringify(serialised), { parser: 'json' });
}
function defaultProgress() {
    return null;
}
function defaultDeserialiser(serialised) {
    return serialised;
}
function defaultSerialiser(deserialised) {
    return deserialised;
}
//# sourceMappingURL=config.js.map