"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.constraint = void 0;
const constraints_1 = require("@betterer/constraints");
const differ_1 = require("./differ");
function constraint(result, expected) {
    const { diff } = (0, differ_1.differ)(expected, result);
    const filePaths = Object.keys(diff);
    if (filePaths.length === 0) {
        return constraints_1.BettererConstraintResult.same;
    }
    const hasNew = filePaths.filter((filePath) => { var _a; return !!((_a = diff[filePath].new) === null || _a === void 0 ? void 0 : _a.length); });
    if (hasNew.length) {
        return constraints_1.BettererConstraintResult.worse;
    }
    const hasFixed = filePaths.filter((filePath) => { var _a; return !!((_a = diff[filePath].fixed) === null || _a === void 0 ? void 0 : _a.length); });
    if (hasFixed.length) {
        return constraints_1.BettererConstraintResult.better;
    }
    return constraints_1.BettererConstraintResult.same;
}
exports.constraint = constraint;
//# sourceMappingURL=constraint.js.map