"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.progress = void 0;
function progress(baseline, result) {
    if (result == null) {
        return null;
    }
    const resultIssues = countIssues(result);
    if (baseline == null) {
        return {
            baseline: null,
            result: resultIssues,
            diff: 0
        };
    }
    const baselineIssues = countIssues(baseline);
    return {
        baseline: baselineIssues,
        diff: resultIssues - baselineIssues,
        result: resultIssues
    };
}
exports.progress = progress;
function countIssues(result) {
    return result.files.reduce((sum, file) => sum + file.issues.length, 0);
}
//# sourceMappingURL=progress.js.map