"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.serialise = exports.deserialise = void 0;
const tslib_1 = require("tslib");
const path = (0, tslib_1.__importStar)(require("path"));
const fs_1 = require("../../fs");
const file_test_result_1 = require("./file-test-result");
function deserialise(serialised, resultsPath) {
    const resolver = new fs_1.BettererFileResolverΩ(path.dirname(resultsPath));
    const deserialised = new file_test_result_1.BettererFileTestResultΩ(resolver, resultsPath);
    Object.keys(serialised).map((key) => {
        const [relativePath, fileHash] = key.split(':');
        const issues = serialised[key].map((issue) => {
            const [line, column, length, message, hash] = issue;
            return { line, column, length, message, hash };
        });
        const absolutePath = resolver.resolve(relativePath);
        key = `${relativePath}:${fileHash}`;
        deserialised.addExpected({ absolutePath, key, hash: fileHash, issues });
    });
    return deserialised;
}
exports.deserialise = deserialise;
function serialise(result) {
    const resultΩ = result;
    return resultΩ.files
        .filter((file) => file.issues.length)
        .sort((fileA, fileB) => {
        if (fileA.absolutePath < fileB.absolutePath) {
            return -1;
        }
        if (fileA.absolutePath > fileB.absolutePath) {
            return 1;
        }
        return 0;
    })
        .reduce((serialised, file) => {
        serialised[file.key] = sortLinesAndColumns(file.issues).map((issue) => [
            issue.line,
            issue.column,
            issue.length,
            issue.message,
            issue.hash
        ]);
        return serialised;
    }, {});
}
exports.serialise = serialise;
function sortLinesAndColumns(issues) {
    return [...issues].sort((a, b) => (a.line !== b.line ? a.line - b.line : a.column - b.column));
}
//# sourceMappingURL=serialiser.js.map