"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.loadTestMeta = void 0;
const errors_1 = require("@betterer/errors");
const require_1 = require("../require");
const utils_1 = require("../utils");
function loadTestMeta(config) {
    let testMetaMap = {};
    config.configPaths.map((configPath) => {
        const testMeta = loadTestMetaFromConfig(configPath);
        testMetaMap = Object.assign(Object.assign({}, testMetaMap), testMeta);
    });
    return testMetaMap;
}
exports.loadTestMeta = loadTestMeta;
function loadTestMetaFromConfig(configPath) {
    try {
        const testMeta = {};
        const exports = (0, require_1.requireUncached)(configPath);
        Object.keys(exports).forEach((name) => {
            const factory = exports[name];
            if (!(0, utils_1.isFunction)(factory)) {
                throw new errors_1.BettererError(`"${name}" must be a function.`);
            }
            testMeta[name] = { name, configPath, factory };
        });
        return testMeta;
    }
    catch (error) {
        throw new errors_1.BettererError(`could not import config from "${configPath}". 😔`, error);
    }
}
//# sourceMappingURL=loader.js.map