"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getTime = exports.flatten = exports.normaliseNewlines = exports.defer = exports.normalisedPath = exports.isUndefined = exports.isRegExp = exports.isString = exports.isNumber = exports.isFunction = exports.isBoolean = void 0;
const tslib_1 = require("tslib");
const assert_1 = (0, tslib_1.__importDefault)(require("assert"));
const path = (0, tslib_1.__importStar)(require("path"));
function isBoolean(value) {
    return typeof value === 'boolean';
}
exports.isBoolean = isBoolean;
function isFunction(value) {
    return typeof value === 'function';
}
exports.isFunction = isFunction;
function isNumber(value) {
    return typeof value === 'number';
}
exports.isNumber = isNumber;
function isString(value) {
    return typeof value === 'string';
}
exports.isString = isString;
function isRegExp(value) {
    return Object.prototype.toString.call(value) === '[object RegExp]';
}
exports.isRegExp = isRegExp;
function isUndefined(value) {
    return typeof value === 'undefined';
}
exports.isUndefined = isUndefined;
function normalisedPath(filePath) {
    return path.sep === path.posix.sep ? filePath : filePath.split(path.sep).join(path.posix.sep);
}
exports.normalisedPath = normalisedPath;
function defer() {
    let resolve = null;
    let reject = null;
    const promise = new Promise((res, rej) => {
        resolve = res;
        reject = rej;
    });
    // Catch here to avoid global unhandledRejection:
    promise.catch(() => void 0);
    (0, assert_1.default)(resolve);
    (0, assert_1.default)(reject);
    return { promise, resolve, reject };
}
exports.defer = defer;
const NEW_LINE = '\n';
const NEW_LINES = /\r\n|\r|\n/g;
function normaliseNewlines(str) {
    return str.replace(NEW_LINES, NEW_LINE);
}
exports.normaliseNewlines = normaliseNewlines;
function flatten(toFlatten) {
    const flattened = [];
    toFlatten.forEach((t) => {
        if (isItem(t)) {
            flattened.push(t);
        }
        else {
            flattened.push(...t);
        }
    });
    return flattened;
}
exports.flatten = flatten;
function isItem(pattern) {
    return !Array.isArray(pattern);
}
function getTime() {
    return Date.now();
}
exports.getTime = getTime;
//# sourceMappingURL=utils.js.map