import EventEmitter, { EmitterParam } from "@scena/event-emitter";
export declare function getKey(keyCode: number): string;
export declare function getCombi(e: KeyboardEvent, key?: string): string[];
export declare function getModifierCombi(e: KeyboardEvent): string[];
export interface KeyControllerEvent extends EmitterParam {
    inputEvent: KeyboardEvent;
    isToggle: boolean;
    key: string;
    keyCode: number;
    ctrlKey: boolean;
    altKey: boolean;
    shiftKey: boolean;
    metaKey: boolean;
}
declare class KeyController extends EventEmitter<{
    blur: {};
    [key: string]: object;
}> {
    private container;
    static get global(): KeyController;
    static setGlobal(): KeyController;
    ctrlKey: boolean;
    altKey: boolean;
    shiftKey: boolean;
    metaKey: boolean;
    constructor(container?: Window | Document | HTMLElement);
    clear: () => this;
    destroy(): void;
    keydown(comb: string | string[], callback: (e: KeyControllerEvent) => void): this;
    keydown(callback: (e: KeyControllerEvent) => void): this;
    offKeydown(comb: string | string[], callback?: (e: KeyControllerEvent) => void): this;
    offKeydown(callback: (e: KeyControllerEvent) => void): this;
    offKeyup(comb: string | string[], callback?: (e: KeyControllerEvent) => void): this;
    offKeyup(callback: (e: KeyControllerEvent) => void): this;
    keyup(comb: string | string[], callback: (e: KeyControllerEvent) => void): this;
    keyup(callback: (e: KeyControllerEvent) => void): this;
    private addEvent;
    private removeEvent;
    private triggerEvent;
    private keydownEvent;
    private keyupEvent;
    private blur;
}
export default KeyController;
