function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

import "core-js/modules/es.object.to-string.js";
import "core-js/modules/es.array.iterator.js";
import "core-js/modules/web.dom-collections.iterator.js";
import "core-js/modules/es.function.name.js";
import "core-js/modules/es.array.join.js";
import "core-js/modules/es.array.concat.js";
import "core-js/modules/es.object.assign.js";
import "core-js/modules/web.dom-collections.for-each.js";
import "core-js/modules/es.symbol.js";
import "core-js/modules/es.symbol.description.js";
import "core-js/modules/es.symbol.iterator.js";
import "core-js/modules/es.string.iterator.js";
import "core-js/modules/es.array.slice.js";
import "core-js/modules/es.array.from.js";
import { hasDocgen, extractComponentProps } from '../../lib/docgen';
import { convert } from '../../lib/convert';
var SECTIONS = ['props', 'events', 'slots'];
/**
 * Check if "@values" tag is defined within docgenInfo.
 * If true, then propDef is mutated.
 */

function isEnum(propDef, docgenInfo) {
  // cast as any, since "values" doesn't exist in DocgenInfo type
  var _ref = docgenInfo,
      type = _ref.type,
      values = _ref.values;
  var matched = Array.isArray(values) && values.length && type.name !== 'enum';
  if (!matched) return false;
  var enumString = values.join(', ');
  var summary = propDef.type.summary;
  summary = summary ? "".concat(summary, ": ").concat(enumString) : enumString;
  Object.assign(propDef.type, Object.assign({}, propDef.type, {
    name: 'enum',
    value: values,
    summary: summary
  }));
  return propDef;
}
/**
 * @returns {Array} result
 * @returns {PropDef} result.def - propDef
 * @returns {boolean} result.isChanged - flag whether propDef is mutated or not.
 *  this is needed to prevent sbType from performing convert(docgenInfo).
 */


function verifyPropDef(propDef, docgenInfo) {
  var def = propDef;
  var isChanged = false; // another callback can be added here.
  // callback is mutually exclusive from each other.

  var callbacks = [isEnum];

  for (var i = 0, len = callbacks.length; i < len; i += 1) {
    var matched = callbacks[i](propDef, docgenInfo);

    if (matched) {
      def = matched;
      isChanged = true;
    }
  }

  return [def, isChanged];
}

export var extractArgTypes = function extractArgTypes(component) {
  if (!hasDocgen(component)) {
    return null;
  }

  var results = {};
  SECTIONS.forEach(function (section) {
    var props = extractComponentProps(component, section);
    props.forEach(function (_ref2) {
      var propDef = _ref2.propDef,
          docgenInfo = _ref2.docgenInfo,
          jsDocTags = _ref2.jsDocTags;

      var _verifyPropDef = verifyPropDef(propDef, docgenInfo),
          _verifyPropDef2 = _slicedToArray(_verifyPropDef, 2),
          result = _verifyPropDef2[0],
          isPropDefChanged = _verifyPropDef2[1];

      var name = result.name,
          type = result.type,
          description = result.description,
          defaultSummary = result.defaultValue,
          required = result.required;
      var sbType;

      if (isPropDefChanged) {
        sbType = type;
      } else {
        sbType = section === 'props' ? convert(docgenInfo) : {
          name: 'void'
        };
      }

      results[name] = {
        name: name,
        description: description,
        type: Object.assign({
          required: required
        }, sbType),
        table: {
          type: type,
          jsDocTags: jsDocTags,
          defaultValue: defaultSummary,
          category: section
        }
      };
    });
  });
  return results;
};