"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const path_1 = require("path");
const cross_spawn_1 = require("cross-spawn");
const bin = (nameOrPath) => {
    if (0 <= nameOrPath.indexOf(path_1.sep)) {
        return path_1.isAbsolute(nameOrPath) ? nameOrPath : path_1.resolve(nameOrPath);
    }
    const binDir = cross_spawn_1.sync('npm', ['bin'], { cwd: process.cwd() }).stdout.toString().trim();
    return path_1.resolve(binDir, /^win/.test(process.platform) ? `${nameOrPath}.cmd` : nameOrPath);
};
// require support
module.exports = bin;
exports.default = bin;
