import { CodeEditorSuggestionItem } from '@grafana/ui';
import { DataQuery } from '@grafana/data';
import { MonacoOptions } from '@grafana/ui/components/Monaco/types';
declare type EditorProps = {
    width?: number | string;
    height?: number | string;
    readOnly?: boolean;
    showMiniMap?: boolean;
    showLineNumbers?: boolean;
    monacoOptions?: MonacoOptions;
};
declare type Props<TQuery extends DataQuery> = {
    query: TQuery;
    language: string;
    editorProps?: EditorProps;
    onChange: (value: TQuery) => void;
    onRunQuery: () => void;
    getSuggestions: (query: TQuery) => CodeEditorSuggestionItem[];
};
export declare function QueryCodeEditor<TQuery extends DataQuery>(props: Props<TQuery>): JSX.Element;
export {};
