# @daybrush/utils  [![npm version](https://badge.fury.io/js/%40daybrush%2Futils.svg)](https://badge.fury.io/js/%40daybrush%2Futils)

utils for Daybush

[**API Documentation**](https://daybrush.com/utils/release/latest/doc/index.html)

```
$ npm i @daybrush/utils
```

```js
import {TRANSFORM, requestAnimationFrame, splitComma} from "@daybrush/utils";
```

### [Consts](http://daybrush.com/utils/release/latest/doc/Consts.html)
* document
* OBJECT
* PROPERTY
* STRING
* UNDEFINED
* FUNCTION
* ARRAY
* IS_WINDOW

### [Cross Browser](http://daybrush.com/utils/release/latest/doc/CrossBrowser.html)
* TRANSFORM
* FILTER
* ANIMATION
* KEYFRAMES
* getCrossBrowserProperty
* now
* requestAnimationFrame

### [Color](http://daybrush.com/utils/release/latest/doc/Color.html)
* RGB
* RGBA
* HSL
* HSLA
* COLOR_MODELS
* cutHex
* hexToRGBA
* hslToRGBA
* stringToRGBA
* toFullHex

### [DOM](http://daybrush.com/utils/release/latest/doc/DOM.html)
* $
* hasClass
* removeClass
* addClass
* fromCSS

### [Utils](http://daybrush.com/utils/release/latest/doc/Utils.html)
* splitUnit
* splitComma
* splitSpace
* splitBracket
* isUndefined
* isFunction
* isObject
* isArray
* isString
* camelize
* decamelize
* toArray
* dot
