"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DebugLoggerΩ = void 0;
var tslib_1 = require("tslib");
var fs = tslib_1.__importStar(require("fs"));
var path = tslib_1.__importStar(require("path"));
var util_1 = require("util");
var index = 0;
var DebugLoggerΩ = /** @class */ (function () {
    function DebugLoggerΩ(options) {
        this._depth = 0;
        var _a = options.header, header = _a === void 0 ? '' : _a;
        this._time = options.time || false;
        this._values = options.values || false;
        this._logger = options.logger || this._getLogger(options.logPath);
        this._raw((header + " starting " + Date.now()).trimStart());
        this._name = index++;
    }
    DebugLoggerΩ.prototype.name = function () {
        return this._name;
    };
    DebugLoggerΩ.prototype._raw = function (logString) {
        this._logger(logString);
    };
    DebugLoggerΩ.prototype.start = function (name, args) {
        this._depth += 1;
        var debugString = this._printDepth(name);
        if (this._values) {
            debugString += " args: " + this._printObject(args);
        }
        this._logger(debugString);
    };
    DebugLoggerΩ.prototype.end = function (name, startTime, endTime, result) {
        var debugString = this._printDepth(name);
        if (this._time) {
            debugString += " time: " + (endTime - startTime) + "ms";
        }
        if (this._values) {
            debugString += " return: " + this._printObject(result);
        }
        this._logger(debugString);
        this._depth -= 1;
    };
    DebugLoggerΩ.prototype._getLogger = function (relativeLogPath) {
        if (relativeLogPath) {
            var _a = path.parse(relativeLogPath), dir = _a.dir, name_1 = _a.name, ext = _a.ext;
            var logPath = "" + dir + path.sep + name_1 + "." + Date.now() + ext;
            var absoluteLogPath_1 = path.resolve(process.cwd(), logPath);
            return function (logString) {
                fs.appendFileSync(absoluteLogPath_1, logString + "\n");
            };
        }
        else {
            return function (logString) {
                process.stdout.write(logString + "\n");
            };
        }
    };
    DebugLoggerΩ.prototype._printDepth = function (name) {
        return '▸'.repeat(this._depth) + " " + name;
    };
    DebugLoggerΩ.prototype._printObject = function (object) {
        return util_1.inspect(object, { getters: true, depth: Infinity }).replace(/\n/g, '');
    };
    return DebugLoggerΩ;
}());
exports.DebugLoggerΩ = DebugLoggerΩ;
//# sourceMappingURL=logger.js.map