"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.DocCodeSpan = void 0;
var DocNode_1 = require("./DocNode");
var DocExcerpt_1 = require("./DocExcerpt");
/**
 * Represents CommonMark-style code span, i.e. code surrounded by
 * backtick characters.
 */
var DocCodeSpan = /** @class */ (function (_super) {
    __extends(DocCodeSpan, _super);
    /**
     * Don't call this directly.  Instead use {@link TSDocParser}
     * @internal
     */
    function DocCodeSpan(parameters) {
        var _this = _super.call(this, parameters) || this;
        if (DocNode_1.DocNode.isParsedParameters(parameters)) {
            _this._openingDelimiterExcerpt = new DocExcerpt_1.DocExcerpt({
                configuration: _this.configuration,
                excerptKind: DocExcerpt_1.ExcerptKind.CodeSpan_OpeningDelimiter,
                content: parameters.openingDelimiterExcerpt
            });
            _this._codeExcerpt = new DocExcerpt_1.DocExcerpt({
                configuration: _this.configuration,
                excerptKind: DocExcerpt_1.ExcerptKind.CodeSpan_Code,
                content: parameters.codeExcerpt
            });
            _this._closingDelimiterExcerpt = new DocExcerpt_1.DocExcerpt({
                configuration: _this.configuration,
                excerptKind: DocExcerpt_1.ExcerptKind.CodeSpan_ClosingDelimiter,
                content: parameters.closingDelimiterExcerpt
            });
        }
        else {
            _this._code = parameters.code;
        }
        return _this;
    }
    Object.defineProperty(DocCodeSpan.prototype, "kind", {
        /** @override */
        get: function () {
            return DocNode_1.DocNodeKind.CodeSpan;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(DocCodeSpan.prototype, "code", {
        /**
         * The text that should be rendered as code, excluding the backtick delimiters.
         */
        get: function () {
            if (this._code === undefined) {
                this._code = this._codeExcerpt.content.toString();
            }
            return this._code;
        },
        enumerable: false,
        configurable: true
    });
    /** @override */
    DocCodeSpan.prototype.onGetChildNodes = function () {
        return [this._openingDelimiterExcerpt, this._codeExcerpt, this._closingDelimiterExcerpt];
    };
    return DocCodeSpan;
}(DocNode_1.DocNode));
exports.DocCodeSpan = DocCodeSpan;
//# sourceMappingURL=DocCodeSpan.js.map