"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SuiteSummary = void 0;
const render_1 = require("@betterer/render");
const messages_1 = require("../../messages");
const TEXT_COLOURS = {
    better: 'greenBright',
    changed: 'red',
    checked: 'gray',
    completed: 'greenBright',
    expired: 'brightRed',
    failed: 'brightRed',
    new: 'gray',
    obsolete: 'brightRed',
    same: 'brightYellow',
    skipped: 'brightYellow',
    updated: 'white',
    worse: 'red'
};
exports.SuiteSummary = (0, render_1.memo)(function SuiteSummary({ context, suiteSummary }) {
    const better = suiteSummary.better.length;
    const completed = suiteSummary.completed.length;
    const expired = suiteSummary.expired.length;
    const failed = suiteSummary.failed.length;
    const neww = suiteSummary.new.length;
    const ran = suiteSummary.ran.length;
    const same = suiteSummary.same.length;
    const skipped = suiteSummary.skipped.length;
    const updated = suiteSummary.updated.length;
    const worse = suiteSummary.worse.length;
    return (render_1.React.createElement(render_1.React.Fragment, null,
        render_1.React.createElement(render_1.Box, { flexDirection: "column", paddingBottom: 1 },
            render_1.React.createElement(render_1.Text, { color: TEXT_COLOURS.checked }, (0, messages_1.testChecked)(tests(ran))),
            neww ? render_1.React.createElement(render_1.Text, { color: TEXT_COLOURS.new }, (0, messages_1.testNew)(tests(neww))) : null,
            better ? render_1.React.createElement(render_1.Text, { color: TEXT_COLOURS.better }, (0, messages_1.testBetter)(tests(better))) : null,
            completed ? render_1.React.createElement(render_1.Text, { color: TEXT_COLOURS.completed }, (0, messages_1.testComplete)(tests(completed))) : null,
            same ? render_1.React.createElement(render_1.Text, { color: TEXT_COLOURS.same }, (0, messages_1.testSame)(tests(same))) : null,
            failed ? render_1.React.createElement(render_1.Text, { color: TEXT_COLOURS.failed }, (0, messages_1.testFailed)(tests(failed))) : null,
            skipped ? render_1.React.createElement(render_1.Text, { color: TEXT_COLOURS.skipped }, (0, messages_1.testSkipped)(tests(skipped))) : null,
            updated ? render_1.React.createElement(render_1.Text, { color: TEXT_COLOURS.updated }, (0, messages_1.testUpdated)(tests(updated))) : null,
            worse ? (render_1.React.createElement(render_1.React.Fragment, null,
                render_1.React.createElement(render_1.Box, { paddingBottom: 1 },
                    render_1.React.createElement(render_1.Text, { color: TEXT_COLOURS.worse }, (0, messages_1.testWorse)(tests(worse)))),
                !context.config.strict && render_1.React.createElement(render_1.Text, null, (0, messages_1.updateInstructions)()))) : null,
            expired ? render_1.React.createElement(render_1.Text, { color: TEXT_COLOURS.expired },
                (0, messages_1.testExpired)(tests(expired)),
                ")") : null),
        context.config.ci && suiteSummary.changed.length ? (render_1.React.createElement(render_1.Box, { flexDirection: "column", paddingBottom: 1 },
            render_1.React.createElement(render_1.Text, { color: TEXT_COLOURS.changed }, (0, messages_1.unexpectedChanges)()),
            render_1.React.createElement(render_1.Box, { flexDirection: "column", padding: 1 }, suiteSummary.changed.map((name) => (render_1.React.createElement(render_1.Text, { key: name },
                "\"",
                name,
                "\"")))),
            render_1.React.createElement(render_1.Text, { color: TEXT_COLOURS.changed }, (0, messages_1.unexpectedChangesInstructions)()))) : null));
});
function tests(n) {
    return n === 1 ? `${n} test` : `${n} tests`;
}
//# sourceMappingURL=SuiteSummary.js.map