"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.useTask = void 0;
const errors_1 = require("@betterer/errors");
const logger_1 = require("@betterer/logger");
const messages_1 = require("../../messages");
const utils_1 = require("../../utils");
const deltas_1 = require("./deltas");
const TASKS = new Map();
function useTask(run) {
    const existingTask = TASKS.get(run);
    if (existingTask) {
        return existingTask;
    }
    const task = async (logger) => {
        const name = (0, utils_1.quote)(run.name);
        await logger.progress((0, messages_1.testRunning)(name));
        const runSummary = await run.lifecycle;
        if (runSummary.isExpired) {
            await logger.warn((0, messages_1.testExpired)(name));
        }
        const delta = (0, deltas_1.getDelta)(runSummary);
        if (runSummary.isComplete) {
            return (0, messages_1.testComplete)(name, runSummary.isNew);
        }
        if (runSummary.isBetter) {
            return (0, messages_1.testBetter)(name, delta);
        }
        if (runSummary.isFailed) {
            throw new errors_1.BettererError((0, messages_1.testFailed)(name));
        }
        if (runSummary.isNew) {
            return (0, messages_1.testNew)(name, delta);
        }
        if (runSummary.isSkipped) {
            return (0, messages_1.testSkipped)(name, delta);
        }
        if (runSummary.isSame) {
            return (0, messages_1.testSame)(name, delta);
        }
        if (runSummary.isUpdated && runSummary.diff) {
            await (0, logger_1.log__)(runSummary.diff.logs, logger);
            return (0, messages_1.testUpdated)(name, delta);
        }
        if (runSummary.isWorse && runSummary.diff) {
            await (0, logger_1.log__)(runSummary.diff.logs, logger);
            throw new errors_1.BettererError((0, messages_1.testWorse)(name, delta));
        }
        return;
    };
    TASKS.set(run, task);
    return task;
}
exports.useTask = useTask;
//# sourceMappingURL=tasks.js.map