"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.WatchFiles = void 0;
const render_1 = require("@betterer/render");
const messages_1 = require("../../messages");
const config_1 = require("../config");
exports.WatchFiles = (0, render_1.memo)(function WatchFiles(props) {
    const { context, editField, suite, running } = props;
    const { filePaths } = suite;
    const isTestChange = context.config.configPaths.some((configPath) => filePaths.includes(configPath));
    return (render_1.React.createElement(render_1.React.Fragment, null,
        render_1.React.createElement(config_1.Config, { context: context, editField: editField }),
        (filePaths === null || filePaths === void 0 ? void 0 : filePaths.length) ? (render_1.React.createElement(render_1.React.Fragment, null,
            isTestChange ? (render_1.React.createElement(render_1.Box, { paddingBottom: 1 },
                render_1.React.createElement(render_1.Text, null, (0, messages_1.testsChanged)()))) : (render_1.React.createElement(render_1.Box, { paddingBottom: 1 },
                render_1.React.createElement(render_1.Text, null, running ? (0, messages_1.filesChecking)(filePaths.length) : (0, messages_1.filesChecked)(filePaths.length)))),
            render_1.React.createElement(render_1.Box, { flexDirection: "column", paddingBottom: 1 }, filePaths.map((filePath) => (render_1.React.createElement(render_1.Text, { key: filePath },
                "\u30FB ",
                filePath)))))) : null));
});
//# sourceMappingURL=WatchFiles.js.map