"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createStore = void 0;
const actions_1 = require("./actions");
function createStore(context) {
    const reducer = (state, action) => {
        switch (action.name) {
            case actions_1.CONTEXT_END: {
                return Object.assign(Object.assign({}, state), { contextSummary: action.contextSummary });
            }
            case actions_1.SUITE_START: {
                return {
                    context: state.context,
                    suite: action.suite
                };
            }
            case actions_1.SUITE_END: {
                return {
                    context: state.context,
                    suiteSummary: action.suiteSummary
                };
            }
        }
    };
    let state = { context };
    return function dispatch(action) {
        if (!action) {
            return state;
        }
        state = reducer(state, action);
        return state;
    };
}
exports.createStore = createStore;
//# sourceMappingURL=store.js.map