"use strict";

var _KnobManager = _interopRequireDefault(require("./KnobManager"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

jest.mock('global', function () {
  return {
    navigator: {
      userAgent: 'browser',
      platform: ''
    },
    window: {
      __STORYBOOK_CLIENT_API__: undefined,
      addEventListener: jest.fn(),
      location: {
        search: ''
      },
      history: {
        replaceState: jest.fn()
      }
    },
    document: {
      addEventListener: jest.fn(),
      getElementById: jest.fn().mockReturnValue({}),
      body: {
        classList: {
          add: jest.fn(),
          remove: jest.fn()
        }
      },
      documentElement: {},
      location: {
        search: '?id=kind--story'
      }
    }
  };
});
describe('KnobManager', function () {
  describe('knob()', function () {
    describe('when the knob is present in the knobStore', function () {
      var testManager = new _KnobManager["default"]();
      beforeEach(function () {
        testManager.knobStore = {
          set: jest.fn(),
          update: jest.fn(),
          get: function get() {
            return {
              defaultValue: 'default value',
              name: 'foo',
              type: 'string',
              value: 'current value'
            };
          }
        };
      });
      it('should return the existing knob value when types match', function () {
        var defaultKnob = {
          name: 'foo',
          type: 'string',
          value: 'default value'
        };
        var knob = testManager.knob('foo', defaultKnob);
        expect(knob).toEqual('current value');
        expect(testManager.knobStore.set).not.toHaveBeenCalled();
      });
      it('should update the existing knob options when types match', function () {
        var defaultKnob = {
          name: 'foo',
          type: 'string',
          value: 'default value',
          foo: 'foo'
        };
        testManager.knob('foo', defaultKnob);
        expect(testManager.knobStore.update).toHaveBeenCalledWith('foo', expect.objectContaining({
          foo: 'foo'
        }));
      });
      it('should return the new default knob value when type has changed', function () {
        var defaultKnob = {
          name: 'foo',
          value: true,
          type: 'boolean'
        };
        testManager.knob('foo', defaultKnob);

        var newKnob = _objectSpread(_objectSpread({}, defaultKnob), {}, {
          label: 'foo',
          defaultValue: defaultKnob.value
        });

        expect(testManager.knobStore.set).toHaveBeenCalledWith('foo', newKnob);
      });
    });
    describe('when the knob is not present in the knobStore', function () {
      var testManager = new _KnobManager["default"]();
      beforeEach(function () {
        testManager.knobStore = {
          set: jest.fn(),
          get: jest.fn()
        };
        testManager.knobStore.get.mockImplementationOnce(function () {
          return undefined;
        }).mockImplementationOnce(function () {
          return 'normal value';
        });
      });
      it('should return the new default knob value when default has changed', function () {
        var defaultKnob = {
          name: 'foo',
          value: 'normal value'
        };
        testManager.knob('foo', defaultKnob);

        var newKnob = _objectSpread(_objectSpread({}, defaultKnob), {}, {
          label: 'foo',
          defaultValue: defaultKnob.value
        });

        expect(testManager.knobStore.set).toHaveBeenCalledWith('foo', newKnob);
      });
    });
  });
});