/**
 * Copyright (c) 2021 OceanBase
 * OceanBase CE is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *          http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
#include "lib/charset/ob_mysql_global.h"

extern const int MIN_JA_HAN_PAGE = 0x4E;
extern const int MAX_JA_HAN_PAGE = 0x9F;

uint16 ja_han_page4E[]= {
  /* Number of CEs for each character. */
  1, 1, 2, 1, 2, 2, 2, 1, 1, 1, 1, 1, 2, 1, 1, 2,
  1, 1, 2, 2, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 1, 2,
  2, 1, 2, 2, 2, 2, 1, 2, 2, 2, 1, 2, 2, 1, 2, 2,
  2, 1, 1, 2, 2, 2, 1, 2, 1, 1, 2, 1, 1, 2, 2, 1,
  2, 2, 1, 1, 2, 1, 2, 2, 2, 2, 2, 1, 2, 1, 1, 1,
  2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 2, 2, 2, 1, 1, 1,
  2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 1, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2,
  1, 2, 1, 2, 2, 1, 1, 2, 1, 1, 1, 1, 1, 2, 1, 2,
  2, 1, 1, 2, 1, 1, 2, 2, 1, 1, 2, 1, 1, 2, 1, 1,
  1, 1, 1, 2, 1, 1, 1, 2, 1, 2, 2, 1, 1, 1, 1, 2,
  1, 2, 2, 1, 2, 2, 1, 2, 2, 2, 1, 2, 2, 2, 2, 2,
  1, 1, 1, 2, 1, 2, 1, 1, 2, 2, 1, 1, 2, 1, 1, 1,
  2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 1, 1,
  2, 2, 2, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 1, 1, 2,
  1, 2, 1, 2, 2, 2, 1, 1, 2, 2, 2, 1, 2, 2, 2, 2,

  /* Primary weight 1 for each character. */
  0x54EF,   /* U+4E00 */
  0x5BF7,   /* U+4E01 */
  0xFB40,   /* U+4E02 */
  0x5922,   /* U+4E03 */
  0xFB40,   /* U+4E04 */
  0xFB40,   /* U+4E05 */
  0xFB40,   /* U+4E06 */
  0x5EE9,   /* U+4E07 */
  0x5A0D,   /* U+4E08 */
  0x58BD,   /* U+4E09 */
  0x5A0C,   /* U+4E0A */
  0x557B,   /* U+4E0B */
  0xFB40,   /* U+4E0C */
  0x5E05,   /* U+4E0D */
  0x5F68,   /* U+4E0E */
  0xFB40,   /* U+4E0F */
  0x603A,   /* U+4E10 */
  0x5510,   /* U+4E11 */
  0xFB40,   /* U+4E12 */
  0xFB40,   /* U+4E13 */
  0x560B,   /* U+4E14 */
  0x603B,   /* U+4E15 */
  0x5A87,   /* U+4E16 */
  0x6116,   /* U+4E17 */
  0x56AF,   /* U+4E18 */
  0x5E49,   /* U+4E19 */
  0xFB40,   /* U+4E1A */
  0xFB40,   /* U+4E1B */
  0xFB40,   /* U+4E1C */
  0xFB40,   /* U+4E1D */
  0x5A0E,   /* U+4E1E */
  0xFB40,   /* U+4E1F */
  0xFB40,   /* U+4E20 */
  0x5FC5,   /* U+4E21 */
  0xFB40,   /* U+4E22 */
  0xFB40,   /* U+4E23 */
  0xFB40,   /* U+4E24 */
  0xFB40,   /* U+4E25 */
  0x5E51,   /* U+4E26 */
  0xFB40,   /* U+4E27 */
  0xFB40,   /* U+4E28 */
  0xFB40,   /* U+4E29 */
  0x603C,   /* U+4E2A */
  0xFB40,   /* U+4E2B */
  0xFB40,   /* U+4E2C */
  0x5BE3,   /* U+4E2D */
  0xFB40,   /* U+4E2E */
  0xFB40,   /* U+4E2F */
  0xFB40,   /* U+4E30 */
  0x603D,   /* U+4E31 */
  0x5731,   /* U+4E32 */
  0xFB40,   /* U+4E33 */
  0xFB40,   /* U+4E34 */
  0xFB40,   /* U+4E35 */
  0x603E,   /* U+4E36 */
  0xFB40,   /* U+4E37 */
  0x5658,   /* U+4E38 */
  0x5BAD,   /* U+4E39 */
  0xFB40,   /* U+4E3A */
  0x5952,   /* U+4E3B */
  0x603F,   /* U+4E3C */
  0xFB40,   /* U+4E3D */
  0xFB40,   /* U+4E3E */
  0x6040,   /* U+4E3F */
  0xFB40,   /* U+4E40 */
  0xFB40,   /* U+4E41 */
  0x6041,   /* U+4E42 */
  0x5D2A,   /* U+4E43 */
  0xFB40,   /* U+4E44 */
  0x56B0,   /* U+4E45 */
  0xFB40,   /* U+4E46 */
  0xFB40,   /* U+4E47 */
  0xFB40,   /* U+4E48 */
  0xFB40,   /* U+4E49 */
  0xFB40,   /* U+4E4A */
  0x5D2C,   /* U+4E4B */
  0xFB40,   /* U+4E4C */
  0x5CFA,   /* U+4E4D */
  0x57B6,   /* U+4E4E */
  0x5EA0,   /* U+4E4F */
  0xFB40,   /* U+4E50 */
  0xFB40,   /* U+4E51 */
  0xFB40,   /* U+4E52 */
  0xFB40,   /* U+4E53 */
  0xFB40,   /* U+4E54 */
  0x698F,   /* U+4E55 */
  0x6042,   /* U+4E56 */
  0x5A0F,   /* U+4E57 */
  0x6043,   /* U+4E58 */
  0x5574,   /* U+4E59 */
  0xFB40,   /* U+4E5A */
  0xFB40,   /* U+4E5B */
  0xFB40,   /* U+4E5C */
  0x571C,   /* U+4E5D */
  0x57E3,   /* U+4E5E */
  0x5F34,   /* U+4E5F */
  0xFB40,   /* U+4E60 */
  0xFB40,   /* U+4E61 */
  0x6272,   /* U+4E62 */
  0xFB40,   /* U+4E63 */
  0xFB40,   /* U+4E64 */
  0xFB40,   /* U+4E65 */
  0xFB40,   /* U+4E66 */
  0xFB40,   /* U+4E67 */
  0xFB40,   /* U+4E68 */
  0xFB40,   /* U+4E69 */
  0xFB40,   /* U+4E6A */
  0xFB40,   /* U+4E6B */
  0xFB40,   /* U+4E6C */
  0xFB40,   /* U+4E6D */
  0xFB40,   /* U+4E6E */
  0xFB40,   /* U+4E6F */
  0xFB40,   /* U+4E70 */
  0x5F99,   /* U+4E71 */
  0xFB40,   /* U+4E72 */
  0x5D14,   /* U+4E73 */
  0xFB40,   /* U+4E74 */
  0xFB40,   /* U+4E75 */
  0xFB40,   /* U+4E76 */
  0xFB40,   /* U+4E77 */
  0xFB40,   /* U+4E78 */
  0xFB40,   /* U+4E79 */
  0xFB40,   /* U+4E7A */
  0xFB40,   /* U+4E7B */
  0xFB40,   /* U+4E7C */
  0xFB40,   /* U+4E7D */
  0x5620,   /* U+4E7E */
  0xFB40,   /* U+4E7F */
  0x568E,   /* U+4E80 */
  0xFB40,   /* U+4E81 */
  0x6044,   /* U+4E82 */
  0xFB40,   /* U+4E83 */
  0xFB40,   /* U+4E84 */
  0x6045,   /* U+4E85 */
  0x5FC2,   /* U+4E86 */
  0xFB40,   /* U+4E87 */
  0x5F66,   /* U+4E88 */
  0x5B29,   /* U+4E89 */
  0x6047,   /* U+4E8A */
  0x5903,   /* U+4E8B */
  0x5D0A,   /* U+4E8C */
  0xFB40,   /* U+4E8D */
  0x604A,   /* U+4E8E */
  0xFB40,   /* U+4E8F */
  0xFB40,   /* U+4E90 */
  0x551F,   /* U+4E91 */
  0x57D2,   /* U+4E92 */
  0xFB40,   /* U+4E93 */
  0x57D1,   /* U+4E94 */
  0x54E9,   /* U+4E95 */
  0xFB40,   /* U+4E96 */
  0xFB40,   /* U+4E97 */
  0x6030,   /* U+4E98 */
  0x602F,   /* U+4E99 */
  0xFB40,   /* U+4E9A */
  0x5862,   /* U+4E9B */
  0x54A4,   /* U+4E9C */
  0xFB40,   /* U+4E9D */
  0x604B,   /* U+4E9E */
  0x604C,   /* U+4E9F */
  0x604D,   /* U+4EA0 */
  0x5EA1,   /* U+4EA1 */
  0x604E,   /* U+4EA2 */
  0xFB40,   /* U+4EA3 */
  0x57E5,   /* U+4EA4 */
  0x54EA,   /* U+4EA5 */
  0x5EDF,   /* U+4EA6 */
  0xFB40,   /* U+4EA7 */
  0x56D5,   /* U+4EA8 */
  0xFB40,   /* U+4EA9 */
  0xFB40,   /* U+4EAA */
  0x56D6,   /* U+4EAB */
  0x56D7,   /* U+4EAC */
  0x5C3D,   /* U+4EAD */
  0x5FC3,   /* U+4EAE */
  0xFB40,   /* U+4EAF */
  0x604F,   /* U+4EB0 */
  0xFB40,   /* U+4EB1 */
  0xFB40,   /* U+4EB2 */
  0x6050,   /* U+4EB3 */
  0xFB40,   /* U+4EB4 */
  0xFB40,   /* U+4EB5 */
  0x6051,   /* U+4EB6 */
  0xFB40,   /* U+4EB7 */
  0xFB40,   /* U+4EB8 */
  0xFB40,   /* U+4EB9 */
  0x5A52,   /* U+4EBA */
  0xFB40,   /* U+4EBB */
  0xFB40,   /* U+4EBC */
  0xFB40,   /* U+4EBD */
  0xFB40,   /* U+4EBE */
  0xFB40,   /* U+4EBF */
  0x5983,   /* U+4EC0 */
  0x5A53,   /* U+4EC1 */
  0x6056,   /* U+4EC2 */
  0xFB40,   /* U+4EC3 */
  0x6054,   /* U+4EC4 */
  0xFB40,   /* U+4EC5 */
  0x6055,   /* U+4EC6 */
  0x56B1,   /* U+4EC7 */
  0xFB40,   /* U+4EC8 */
  0xFB40,   /* U+4EC9 */
  0x5852,   /* U+4ECA */
  0x55AF,   /* U+4ECB */
  0xFB40,   /* U+4ECC */
  0x6053,   /* U+4ECD */
  0x6052,   /* U+4ECE */
  0x5E38,   /* U+4ECF */
  0xFB40,   /* U+4ED0 */
  0xFB40,   /* U+4ED1 */
  0xFB40,   /* U+4ED2 */
  0xFB40,   /* U+4ED3 */
  0x58D3,   /* U+4ED4 */
  0x58D2,   /* U+4ED5 */
  0x5B5D,   /* U+4ED6 */
  0x6057,   /* U+4ED7 */
  0x5E06,   /* U+4ED8 */
  0x5ACA,   /* U+4ED9 */
  0xFB40,   /* U+4EDA */
  0xFB40,   /* U+4EDB */
  0xFB40,   /* U+4EDC */
  0xFB40,   /* U+4EDD */
  0x6058,   /* U+4EDE */
  0x605A,   /* U+4EDF */
  0xFB40,   /* U+4EE0 */
  0xFB40,   /* U+4EE1 */
  0xFB40,   /* U+4EE2 */
  0x5B84,   /* U+4EE3 */
  0x5FE8,   /* U+4EE4 */
  0x54CD,   /* U+4EE5 */
  0xFB40,   /* U+4EE6 */
  0xFB40,   /* U+4EE7 */
  0xFB40,   /* U+4EE8 */
  0xFB40,   /* U+4EE9 */
  0xFB40,   /* U+4EEA */
  0xFB40,   /* U+4EEB */
  0xFB40,   /* U+4EEC */
  0x6059,   /* U+4EED */
  0x557D,   /* U+4EEE */
  0xFB40,   /* U+4EEF */
  0x56FB,   /* U+4EF0 */
  0xFB40,   /* U+4EF1 */
  0x5BE4,   /* U+4EF2 */
  0xFB40,   /* U+4EF3 */
  0xFB40,   /* U+4EF4 */
  0xFB40,   /* U+4EF5 */
  0x5784,   /* U+4EF6 */
  0x605B,   /* U+4EF7 */
  0xFB40,   /* U+4EF8 */
  0xFB40,   /* U+4EF9 */
  0xFB40,   /* U+4EFA */
  0x5D19,   /* U+4EFB */
  0xFB40,   /* U+4EFC */
  0xFB40,   /* U+4EFD */
  0xFB40,   /* U+4EFE */
  0xFB40,   /* U+4EFF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+4E00 */
  0x0020,   /* U+4E01 */
  0x0020,   /* U+4E02 */
  0x0020,   /* U+4E03 */
  0x0020,   /* U+4E04 */
  0x0020,   /* U+4E05 */
  0x0020,   /* U+4E06 */
  0x0020,   /* U+4E07 */
  0x0020,   /* U+4E08 */
  0x0020,   /* U+4E09 */
  0x0020,   /* U+4E0A */
  0x0020,   /* U+4E0B */
  0x0020,   /* U+4E0C */
  0x0020,   /* U+4E0D */
  0x0020,   /* U+4E0E */
  0x0020,   /* U+4E0F */
  0x0020,   /* U+4E10 */
  0x0020,   /* U+4E11 */
  0x0020,   /* U+4E12 */
  0x0020,   /* U+4E13 */
  0x0020,   /* U+4E14 */
  0x0020,   /* U+4E15 */
  0x0020,   /* U+4E16 */
  0x0020,   /* U+4E17 */
  0x0020,   /* U+4E18 */
  0x0020,   /* U+4E19 */
  0x0020,   /* U+4E1A */
  0x0020,   /* U+4E1B */
  0x0020,   /* U+4E1C */
  0x0020,   /* U+4E1D */
  0x0020,   /* U+4E1E */
  0x0020,   /* U+4E1F */
  0x0020,   /* U+4E20 */
  0x0020,   /* U+4E21 */
  0x0020,   /* U+4E22 */
  0x0020,   /* U+4E23 */
  0x0020,   /* U+4E24 */
  0x0020,   /* U+4E25 */
  0x0020,   /* U+4E26 */
  0x0020,   /* U+4E27 */
  0x0020,   /* U+4E28 */
  0x0020,   /* U+4E29 */
  0x0020,   /* U+4E2A */
  0x0020,   /* U+4E2B */
  0x0020,   /* U+4E2C */
  0x0020,   /* U+4E2D */
  0x0020,   /* U+4E2E */
  0x0020,   /* U+4E2F */
  0x0020,   /* U+4E30 */
  0x0020,   /* U+4E31 */
  0x0020,   /* U+4E32 */
  0x0020,   /* U+4E33 */
  0x0020,   /* U+4E34 */
  0x0020,   /* U+4E35 */
  0x0020,   /* U+4E36 */
  0x0020,   /* U+4E37 */
  0x0020,   /* U+4E38 */
  0x0020,   /* U+4E39 */
  0x0020,   /* U+4E3A */
  0x0020,   /* U+4E3B */
  0x0020,   /* U+4E3C */
  0x0020,   /* U+4E3D */
  0x0020,   /* U+4E3E */
  0x0020,   /* U+4E3F */
  0x0020,   /* U+4E40 */
  0x0020,   /* U+4E41 */
  0x0020,   /* U+4E42 */
  0x0020,   /* U+4E43 */
  0x0020,   /* U+4E44 */
  0x0020,   /* U+4E45 */
  0x0020,   /* U+4E46 */
  0x0020,   /* U+4E47 */
  0x0020,   /* U+4E48 */
  0x0020,   /* U+4E49 */
  0x0020,   /* U+4E4A */
  0x0020,   /* U+4E4B */
  0x0020,   /* U+4E4C */
  0x0020,   /* U+4E4D */
  0x0020,   /* U+4E4E */
  0x0020,   /* U+4E4F */
  0x0020,   /* U+4E50 */
  0x0020,   /* U+4E51 */
  0x0020,   /* U+4E52 */
  0x0020,   /* U+4E53 */
  0x0020,   /* U+4E54 */
  0x0020,   /* U+4E55 */
  0x0020,   /* U+4E56 */
  0x0020,   /* U+4E57 */
  0x0020,   /* U+4E58 */
  0x0020,   /* U+4E59 */
  0x0020,   /* U+4E5A */
  0x0020,   /* U+4E5B */
  0x0020,   /* U+4E5C */
  0x0020,   /* U+4E5D */
  0x0020,   /* U+4E5E */
  0x0020,   /* U+4E5F */
  0x0020,   /* U+4E60 */
  0x0020,   /* U+4E61 */
  0x0020,   /* U+4E62 */
  0x0020,   /* U+4E63 */
  0x0020,   /* U+4E64 */
  0x0020,   /* U+4E65 */
  0x0020,   /* U+4E66 */
  0x0020,   /* U+4E67 */
  0x0020,   /* U+4E68 */
  0x0020,   /* U+4E69 */
  0x0020,   /* U+4E6A */
  0x0020,   /* U+4E6B */
  0x0020,   /* U+4E6C */
  0x0020,   /* U+4E6D */
  0x0020,   /* U+4E6E */
  0x0020,   /* U+4E6F */
  0x0020,   /* U+4E70 */
  0x0020,   /* U+4E71 */
  0x0020,   /* U+4E72 */
  0x0020,   /* U+4E73 */
  0x0020,   /* U+4E74 */
  0x0020,   /* U+4E75 */
  0x0020,   /* U+4E76 */
  0x0020,   /* U+4E77 */
  0x0020,   /* U+4E78 */
  0x0020,   /* U+4E79 */
  0x0020,   /* U+4E7A */
  0x0020,   /* U+4E7B */
  0x0020,   /* U+4E7C */
  0x0020,   /* U+4E7D */
  0x0020,   /* U+4E7E */
  0x0020,   /* U+4E7F */
  0x0020,   /* U+4E80 */
  0x0020,   /* U+4E81 */
  0x0020,   /* U+4E82 */
  0x0020,   /* U+4E83 */
  0x0020,   /* U+4E84 */
  0x0020,   /* U+4E85 */
  0x0020,   /* U+4E86 */
  0x0020,   /* U+4E87 */
  0x0020,   /* U+4E88 */
  0x0020,   /* U+4E89 */
  0x0020,   /* U+4E8A */
  0x0020,   /* U+4E8B */
  0x0020,   /* U+4E8C */
  0x0020,   /* U+4E8D */
  0x0020,   /* U+4E8E */
  0x0020,   /* U+4E8F */
  0x0020,   /* U+4E90 */
  0x0020,   /* U+4E91 */
  0x0020,   /* U+4E92 */
  0x0020,   /* U+4E93 */
  0x0020,   /* U+4E94 */
  0x0020,   /* U+4E95 */
  0x0020,   /* U+4E96 */
  0x0020,   /* U+4E97 */
  0x0020,   /* U+4E98 */
  0x0020,   /* U+4E99 */
  0x0020,   /* U+4E9A */
  0x0020,   /* U+4E9B */
  0x0020,   /* U+4E9C */
  0x0020,   /* U+4E9D */
  0x0020,   /* U+4E9E */
  0x0020,   /* U+4E9F */
  0x0020,   /* U+4EA0 */
  0x0020,   /* U+4EA1 */
  0x0020,   /* U+4EA2 */
  0x0020,   /* U+4EA3 */
  0x0020,   /* U+4EA4 */
  0x0020,   /* U+4EA5 */
  0x0020,   /* U+4EA6 */
  0x0020,   /* U+4EA7 */
  0x0020,   /* U+4EA8 */
  0x0020,   /* U+4EA9 */
  0x0020,   /* U+4EAA */
  0x0020,   /* U+4EAB */
  0x0020,   /* U+4EAC */
  0x0020,   /* U+4EAD */
  0x0020,   /* U+4EAE */
  0x0020,   /* U+4EAF */
  0x0020,   /* U+4EB0 */
  0x0020,   /* U+4EB1 */
  0x0020,   /* U+4EB2 */
  0x0020,   /* U+4EB3 */
  0x0020,   /* U+4EB4 */
  0x0020,   /* U+4EB5 */
  0x0020,   /* U+4EB6 */
  0x0020,   /* U+4EB7 */
  0x0020,   /* U+4EB8 */
  0x0020,   /* U+4EB9 */
  0x0020,   /* U+4EBA */
  0x0020,   /* U+4EBB */
  0x0020,   /* U+4EBC */
  0x0020,   /* U+4EBD */
  0x0020,   /* U+4EBE */
  0x0020,   /* U+4EBF */
  0x0020,   /* U+4EC0 */
  0x0020,   /* U+4EC1 */
  0x0020,   /* U+4EC2 */
  0x0020,   /* U+4EC3 */
  0x0020,   /* U+4EC4 */
  0x0020,   /* U+4EC5 */
  0x0020,   /* U+4EC6 */
  0x0020,   /* U+4EC7 */
  0x0020,   /* U+4EC8 */
  0x0020,   /* U+4EC9 */
  0x0020,   /* U+4ECA */
  0x0020,   /* U+4ECB */
  0x0020,   /* U+4ECC */
  0x0020,   /* U+4ECD */
  0x0020,   /* U+4ECE */
  0x0020,   /* U+4ECF */
  0x0020,   /* U+4ED0 */
  0x0020,   /* U+4ED1 */
  0x0020,   /* U+4ED2 */
  0x0020,   /* U+4ED3 */
  0x0020,   /* U+4ED4 */
  0x0020,   /* U+4ED5 */
  0x0020,   /* U+4ED6 */
  0x0020,   /* U+4ED7 */
  0x0020,   /* U+4ED8 */
  0x0020,   /* U+4ED9 */
  0x0020,   /* U+4EDA */
  0x0020,   /* U+4EDB */
  0x0020,   /* U+4EDC */
  0x0020,   /* U+4EDD */
  0x0020,   /* U+4EDE */
  0x0020,   /* U+4EDF */
  0x0020,   /* U+4EE0 */
  0x0020,   /* U+4EE1 */
  0x0020,   /* U+4EE2 */
  0x0020,   /* U+4EE3 */
  0x0020,   /* U+4EE4 */
  0x0020,   /* U+4EE5 */
  0x0020,   /* U+4EE6 */
  0x0020,   /* U+4EE7 */
  0x0020,   /* U+4EE8 */
  0x0020,   /* U+4EE9 */
  0x0020,   /* U+4EEA */
  0x0020,   /* U+4EEB */
  0x0020,   /* U+4EEC */
  0x0020,   /* U+4EED */
  0x0020,   /* U+4EEE */
  0x0020,   /* U+4EEF */
  0x0020,   /* U+4EF0 */
  0x0020,   /* U+4EF1 */
  0x0020,   /* U+4EF2 */
  0x0020,   /* U+4EF3 */
  0x0020,   /* U+4EF4 */
  0x0020,   /* U+4EF5 */
  0x0020,   /* U+4EF6 */
  0x0020,   /* U+4EF7 */
  0x0020,   /* U+4EF8 */
  0x0020,   /* U+4EF9 */
  0x0020,   /* U+4EFA */
  0x0020,   /* U+4EFB */
  0x0020,   /* U+4EFC */
  0x0020,   /* U+4EFD */
  0x0020,   /* U+4EFE */
  0x0020,   /* U+4EFF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+4E00 */
  0x0002,   /* U+4E01 */
  0x0002,   /* U+4E02 */
  0x0002,   /* U+4E03 */
  0x0002,   /* U+4E04 */
  0x0002,   /* U+4E05 */
  0x0002,   /* U+4E06 */
  0x0002,   /* U+4E07 */
  0x0002,   /* U+4E08 */
  0x0002,   /* U+4E09 */
  0x0002,   /* U+4E0A */
  0x0002,   /* U+4E0B */
  0x0002,   /* U+4E0C */
  0x0002,   /* U+4E0D */
  0x0002,   /* U+4E0E */
  0x0002,   /* U+4E0F */
  0x0002,   /* U+4E10 */
  0x0002,   /* U+4E11 */
  0x0002,   /* U+4E12 */
  0x0002,   /* U+4E13 */
  0x0002,   /* U+4E14 */
  0x0002,   /* U+4E15 */
  0x0002,   /* U+4E16 */
  0x0002,   /* U+4E17 */
  0x0002,   /* U+4E18 */
  0x0002,   /* U+4E19 */
  0x0002,   /* U+4E1A */
  0x0002,   /* U+4E1B */
  0x0002,   /* U+4E1C */
  0x0002,   /* U+4E1D */
  0x0002,   /* U+4E1E */
  0x0002,   /* U+4E1F */
  0x0002,   /* U+4E20 */
  0x0002,   /* U+4E21 */
  0x0002,   /* U+4E22 */
  0x0002,   /* U+4E23 */
  0x0002,   /* U+4E24 */
  0x0002,   /* U+4E25 */
  0x0002,   /* U+4E26 */
  0x0002,   /* U+4E27 */
  0x0002,   /* U+4E28 */
  0x0002,   /* U+4E29 */
  0x0002,   /* U+4E2A */
  0x0002,   /* U+4E2B */
  0x0002,   /* U+4E2C */
  0x0002,   /* U+4E2D */
  0x0002,   /* U+4E2E */
  0x0002,   /* U+4E2F */
  0x0002,   /* U+4E30 */
  0x0002,   /* U+4E31 */
  0x0002,   /* U+4E32 */
  0x0002,   /* U+4E33 */
  0x0002,   /* U+4E34 */
  0x0002,   /* U+4E35 */
  0x0002,   /* U+4E36 */
  0x0002,   /* U+4E37 */
  0x0002,   /* U+4E38 */
  0x0002,   /* U+4E39 */
  0x0002,   /* U+4E3A */
  0x0002,   /* U+4E3B */
  0x0002,   /* U+4E3C */
  0x0002,   /* U+4E3D */
  0x0002,   /* U+4E3E */
  0x0002,   /* U+4E3F */
  0x0002,   /* U+4E40 */
  0x0002,   /* U+4E41 */
  0x0002,   /* U+4E42 */
  0x0002,   /* U+4E43 */
  0x0002,   /* U+4E44 */
  0x0002,   /* U+4E45 */
  0x0002,   /* U+4E46 */
  0x0002,   /* U+4E47 */
  0x0002,   /* U+4E48 */
  0x0002,   /* U+4E49 */
  0x0002,   /* U+4E4A */
  0x0002,   /* U+4E4B */
  0x0002,   /* U+4E4C */
  0x0002,   /* U+4E4D */
  0x0002,   /* U+4E4E */
  0x0002,   /* U+4E4F */
  0x0002,   /* U+4E50 */
  0x0002,   /* U+4E51 */
  0x0002,   /* U+4E52 */
  0x0002,   /* U+4E53 */
  0x0002,   /* U+4E54 */
  0x0002,   /* U+4E55 */
  0x0002,   /* U+4E56 */
  0x0002,   /* U+4E57 */
  0x0002,   /* U+4E58 */
  0x0002,   /* U+4E59 */
  0x0002,   /* U+4E5A */
  0x0002,   /* U+4E5B */
  0x0002,   /* U+4E5C */
  0x0002,   /* U+4E5D */
  0x0002,   /* U+4E5E */
  0x0002,   /* U+4E5F */
  0x0002,   /* U+4E60 */
  0x0002,   /* U+4E61 */
  0x0002,   /* U+4E62 */
  0x0002,   /* U+4E63 */
  0x0002,   /* U+4E64 */
  0x0002,   /* U+4E65 */
  0x0002,   /* U+4E66 */
  0x0002,   /* U+4E67 */
  0x0002,   /* U+4E68 */
  0x0002,   /* U+4E69 */
  0x0002,   /* U+4E6A */
  0x0002,   /* U+4E6B */
  0x0002,   /* U+4E6C */
  0x0002,   /* U+4E6D */
  0x0002,   /* U+4E6E */
  0x0002,   /* U+4E6F */
  0x0002,   /* U+4E70 */
  0x0002,   /* U+4E71 */
  0x0002,   /* U+4E72 */
  0x0002,   /* U+4E73 */
  0x0002,   /* U+4E74 */
  0x0002,   /* U+4E75 */
  0x0002,   /* U+4E76 */
  0x0002,   /* U+4E77 */
  0x0002,   /* U+4E78 */
  0x0002,   /* U+4E79 */
  0x0002,   /* U+4E7A */
  0x0002,   /* U+4E7B */
  0x0002,   /* U+4E7C */
  0x0002,   /* U+4E7D */
  0x0002,   /* U+4E7E */
  0x0002,   /* U+4E7F */
  0x0002,   /* U+4E80 */
  0x0002,   /* U+4E81 */
  0x0002,   /* U+4E82 */
  0x0002,   /* U+4E83 */
  0x0002,   /* U+4E84 */
  0x0002,   /* U+4E85 */
  0x0002,   /* U+4E86 */
  0x0002,   /* U+4E87 */
  0x0002,   /* U+4E88 */
  0x0002,   /* U+4E89 */
  0x0002,   /* U+4E8A */
  0x0002,   /* U+4E8B */
  0x0002,   /* U+4E8C */
  0x0002,   /* U+4E8D */
  0x0002,   /* U+4E8E */
  0x0002,   /* U+4E8F */
  0x0002,   /* U+4E90 */
  0x0002,   /* U+4E91 */
  0x0002,   /* U+4E92 */
  0x0002,   /* U+4E93 */
  0x0002,   /* U+4E94 */
  0x0002,   /* U+4E95 */
  0x0002,   /* U+4E96 */
  0x0002,   /* U+4E97 */
  0x0002,   /* U+4E98 */
  0x0002,   /* U+4E99 */
  0x0002,   /* U+4E9A */
  0x0002,   /* U+4E9B */
  0x0002,   /* U+4E9C */
  0x0002,   /* U+4E9D */
  0x0002,   /* U+4E9E */
  0x0002,   /* U+4E9F */
  0x0002,   /* U+4EA0 */
  0x0002,   /* U+4EA1 */
  0x0002,   /* U+4EA2 */
  0x0002,   /* U+4EA3 */
  0x0002,   /* U+4EA4 */
  0x0002,   /* U+4EA5 */
  0x0002,   /* U+4EA6 */
  0x0002,   /* U+4EA7 */
  0x0002,   /* U+4EA8 */
  0x0002,   /* U+4EA9 */
  0x0002,   /* U+4EAA */
  0x0002,   /* U+4EAB */
  0x0002,   /* U+4EAC */
  0x0002,   /* U+4EAD */
  0x0002,   /* U+4EAE */
  0x0002,   /* U+4EAF */
  0x0002,   /* U+4EB0 */
  0x0002,   /* U+4EB1 */
  0x0002,   /* U+4EB2 */
  0x0002,   /* U+4EB3 */
  0x0002,   /* U+4EB4 */
  0x0002,   /* U+4EB5 */
  0x0002,   /* U+4EB6 */
  0x0002,   /* U+4EB7 */
  0x0002,   /* U+4EB8 */
  0x0002,   /* U+4EB9 */
  0x0002,   /* U+4EBA */
  0x0002,   /* U+4EBB */
  0x0002,   /* U+4EBC */
  0x0002,   /* U+4EBD */
  0x0002,   /* U+4EBE */
  0x0002,   /* U+4EBF */
  0x0002,   /* U+4EC0 */
  0x0002,   /* U+4EC1 */
  0x0002,   /* U+4EC2 */
  0x0002,   /* U+4EC3 */
  0x0002,   /* U+4EC4 */
  0x0002,   /* U+4EC5 */
  0x0002,   /* U+4EC6 */
  0x0002,   /* U+4EC7 */
  0x0002,   /* U+4EC8 */
  0x0002,   /* U+4EC9 */
  0x0002,   /* U+4ECA */
  0x0002,   /* U+4ECB */
  0x0002,   /* U+4ECC */
  0x0002,   /* U+4ECD */
  0x0002,   /* U+4ECE */
  0x0002,   /* U+4ECF */
  0x0002,   /* U+4ED0 */
  0x0002,   /* U+4ED1 */
  0x0002,   /* U+4ED2 */
  0x0002,   /* U+4ED3 */
  0x0002,   /* U+4ED4 */
  0x0002,   /* U+4ED5 */
  0x0002,   /* U+4ED6 */
  0x0002,   /* U+4ED7 */
  0x0002,   /* U+4ED8 */
  0x0002,   /* U+4ED9 */
  0x0002,   /* U+4EDA */
  0x0002,   /* U+4EDB */
  0x0002,   /* U+4EDC */
  0x0002,   /* U+4EDD */
  0x0002,   /* U+4EDE */
  0x0002,   /* U+4EDF */
  0x0002,   /* U+4EE0 */
  0x0002,   /* U+4EE1 */
  0x0002,   /* U+4EE2 */
  0x0002,   /* U+4EE3 */
  0x0002,   /* U+4EE4 */
  0x0002,   /* U+4EE5 */
  0x0002,   /* U+4EE6 */
  0x0002,   /* U+4EE7 */
  0x0002,   /* U+4EE8 */
  0x0002,   /* U+4EE9 */
  0x0002,   /* U+4EEA */
  0x0002,   /* U+4EEB */
  0x0002,   /* U+4EEC */
  0x0002,   /* U+4EED */
  0x0002,   /* U+4EEE */
  0x0002,   /* U+4EEF */
  0x0002,   /* U+4EF0 */
  0x0002,   /* U+4EF1 */
  0x0002,   /* U+4EF2 */
  0x0002,   /* U+4EF3 */
  0x0002,   /* U+4EF4 */
  0x0002,   /* U+4EF5 */
  0x0002,   /* U+4EF6 */
  0x0002,   /* U+4EF7 */
  0x0002,   /* U+4EF8 */
  0x0002,   /* U+4EF9 */
  0x0002,   /* U+4EFA */
  0x0002,   /* U+4EFB */
  0x0002,   /* U+4EFC */
  0x0002,   /* U+4EFD */
  0x0002,   /* U+4EFE */
  0x0002,   /* U+4EFF */

  /* Primary weight 2 for each character. */
  0x0000,   /* U+4E00 */
  0x0000,   /* U+4E01 */
  0xCE02,   /* U+4E02 */
  0x0000,   /* U+4E03 */
  0xCE04,   /* U+4E04 */
  0xCE05,   /* U+4E05 */
  0xCE06,   /* U+4E06 */
  0x0000,   /* U+4E07 */
  0x0000,   /* U+4E08 */
  0x0000,   /* U+4E09 */
  0x0000,   /* U+4E0A */
  0x0000,   /* U+4E0B */
  0xCE0C,   /* U+4E0C */
  0x0000,   /* U+4E0D */
  0x0000,   /* U+4E0E */
  0xCE0F,   /* U+4E0F */
  0x0000,   /* U+4E10 */
  0x0000,   /* U+4E11 */
  0xCE12,   /* U+4E12 */
  0xCE13,   /* U+4E13 */
  0x0000,   /* U+4E14 */
  0x0000,   /* U+4E15 */
  0x0000,   /* U+4E16 */
  0x0000,   /* U+4E17 */
  0x0000,   /* U+4E18 */
  0x0000,   /* U+4E19 */
  0xCE1A,   /* U+4E1A */
  0xCE1B,   /* U+4E1B */
  0xCE1C,   /* U+4E1C */
  0xCE1D,   /* U+4E1D */
  0x0000,   /* U+4E1E */
  0xCE1F,   /* U+4E1F */
  0xCE20,   /* U+4E20 */
  0x0000,   /* U+4E21 */
  0xCE22,   /* U+4E22 */
  0xCE23,   /* U+4E23 */
  0xCE24,   /* U+4E24 */
  0xCE25,   /* U+4E25 */
  0x0000,   /* U+4E26 */
  0xCE27,   /* U+4E27 */
  0xCE28,   /* U+4E28 */
  0xCE29,   /* U+4E29 */
  0x0000,   /* U+4E2A */
  0xCE2B,   /* U+4E2B */
  0xCE2C,   /* U+4E2C */
  0x0000,   /* U+4E2D */
  0xCE2E,   /* U+4E2E */
  0xCE2F,   /* U+4E2F */
  0xCE30,   /* U+4E30 */
  0x0000,   /* U+4E31 */
  0x0000,   /* U+4E32 */
  0xCE33,   /* U+4E33 */
  0xCE34,   /* U+4E34 */
  0xCE35,   /* U+4E35 */
  0x0000,   /* U+4E36 */
  0xCE37,   /* U+4E37 */
  0x0000,   /* U+4E38 */
  0x0000,   /* U+4E39 */
  0xCE3A,   /* U+4E3A */
  0x0000,   /* U+4E3B */
  0x0000,   /* U+4E3C */
  0xCE3D,   /* U+4E3D */
  0xCE3E,   /* U+4E3E */
  0x0000,   /* U+4E3F */
  0xCE40,   /* U+4E40 */
  0xCE41,   /* U+4E41 */
  0x0000,   /* U+4E42 */
  0x0000,   /* U+4E43 */
  0xCE44,   /* U+4E44 */
  0x0000,   /* U+4E45 */
  0xCE46,   /* U+4E46 */
  0xCE47,   /* U+4E47 */
  0xCE48,   /* U+4E48 */
  0xCE49,   /* U+4E49 */
  0xCE4A,   /* U+4E4A */
  0x0000,   /* U+4E4B */
  0xCE4C,   /* U+4E4C */
  0x0000,   /* U+4E4D */
  0x0000,   /* U+4E4E */
  0x0000,   /* U+4E4F */
  0xCE50,   /* U+4E50 */
  0xCE51,   /* U+4E51 */
  0xCE52,   /* U+4E52 */
  0xCE53,   /* U+4E53 */
  0xCE54,   /* U+4E54 */
  0x0000,   /* U+4E55 */
  0x0000,   /* U+4E56 */
  0x0000,   /* U+4E57 */
  0x0000,   /* U+4E58 */
  0x0000,   /* U+4E59 */
  0xCE5A,   /* U+4E5A */
  0xCE5B,   /* U+4E5B */
  0xCE5C,   /* U+4E5C */
  0x0000,   /* U+4E5D */
  0x0000,   /* U+4E5E */
  0x0000,   /* U+4E5F */
  0xCE60,   /* U+4E60 */
  0xCE61,   /* U+4E61 */
  0x0000,   /* U+4E62 */
  0xCE63,   /* U+4E63 */
  0xCE64,   /* U+4E64 */
  0xCE65,   /* U+4E65 */
  0xCE66,   /* U+4E66 */
  0xCE67,   /* U+4E67 */
  0xCE68,   /* U+4E68 */
  0xCE69,   /* U+4E69 */
  0xCE6A,   /* U+4E6A */
  0xCE6B,   /* U+4E6B */
  0xCE6C,   /* U+4E6C */
  0xCE6D,   /* U+4E6D */
  0xCE6E,   /* U+4E6E */
  0xCE6F,   /* U+4E6F */
  0xCE70,   /* U+4E70 */
  0x0000,   /* U+4E71 */
  0xCE72,   /* U+4E72 */
  0x0000,   /* U+4E73 */
  0xCE74,   /* U+4E74 */
  0xCE75,   /* U+4E75 */
  0xCE76,   /* U+4E76 */
  0xCE77,   /* U+4E77 */
  0xCE78,   /* U+4E78 */
  0xCE79,   /* U+4E79 */
  0xCE7A,   /* U+4E7A */
  0xCE7B,   /* U+4E7B */
  0xCE7C,   /* U+4E7C */
  0xCE7D,   /* U+4E7D */
  0x0000,   /* U+4E7E */
  0xCE7F,   /* U+4E7F */
  0x0000,   /* U+4E80 */
  0xCE81,   /* U+4E81 */
  0x0000,   /* U+4E82 */
  0xCE83,   /* U+4E83 */
  0xCE84,   /* U+4E84 */
  0x0000,   /* U+4E85 */
  0x0000,   /* U+4E86 */
  0xCE87,   /* U+4E87 */
  0x0000,   /* U+4E88 */
  0x0000,   /* U+4E89 */
  0x0000,   /* U+4E8A */
  0x0000,   /* U+4E8B */
  0x0000,   /* U+4E8C */
  0xCE8D,   /* U+4E8D */
  0x0000,   /* U+4E8E */
  0xCE8F,   /* U+4E8F */
  0xCE90,   /* U+4E90 */
  0x0000,   /* U+4E91 */
  0x0000,   /* U+4E92 */
  0xCE93,   /* U+4E93 */
  0x0000,   /* U+4E94 */
  0x0000,   /* U+4E95 */
  0xCE96,   /* U+4E96 */
  0xCE97,   /* U+4E97 */
  0x0000,   /* U+4E98 */
  0x0000,   /* U+4E99 */
  0xCE9A,   /* U+4E9A */
  0x0000,   /* U+4E9B */
  0x0000,   /* U+4E9C */
  0xCE9D,   /* U+4E9D */
  0x0000,   /* U+4E9E */
  0x0000,   /* U+4E9F */
  0x0000,   /* U+4EA0 */
  0x0000,   /* U+4EA1 */
  0x0000,   /* U+4EA2 */
  0xCEA3,   /* U+4EA3 */
  0x0000,   /* U+4EA4 */
  0x0000,   /* U+4EA5 */
  0x0000,   /* U+4EA6 */
  0xCEA7,   /* U+4EA7 */
  0x0000,   /* U+4EA8 */
  0xCEA9,   /* U+4EA9 */
  0xCEAA,   /* U+4EAA */
  0x0000,   /* U+4EAB */
  0x0000,   /* U+4EAC */
  0x0000,   /* U+4EAD */
  0x0000,   /* U+4EAE */
  0xCEAF,   /* U+4EAF */
  0x0000,   /* U+4EB0 */
  0xCEB1,   /* U+4EB1 */
  0xCEB2,   /* U+4EB2 */
  0x0000,   /* U+4EB3 */
  0xCEB4,   /* U+4EB4 */
  0xCEB5,   /* U+4EB5 */
  0x0000,   /* U+4EB6 */
  0xCEB7,   /* U+4EB7 */
  0xCEB8,   /* U+4EB8 */
  0xCEB9,   /* U+4EB9 */
  0x0000,   /* U+4EBA */
  0xCEBB,   /* U+4EBB */
  0xCEBC,   /* U+4EBC */
  0xCEBD,   /* U+4EBD */
  0xCEBE,   /* U+4EBE */
  0xCEBF,   /* U+4EBF */
  0x0000,   /* U+4EC0 */
  0x0000,   /* U+4EC1 */
  0x0000,   /* U+4EC2 */
  0xCEC3,   /* U+4EC3 */
  0x0000,   /* U+4EC4 */
  0xCEC5,   /* U+4EC5 */
  0x0000,   /* U+4EC6 */
  0x0000,   /* U+4EC7 */
  0xCEC8,   /* U+4EC8 */
  0xCEC9,   /* U+4EC9 */
  0x0000,   /* U+4ECA */
  0x0000,   /* U+4ECB */
  0xCECC,   /* U+4ECC */
  0x0000,   /* U+4ECD */
  0x0000,   /* U+4ECE */
  0x0000,   /* U+4ECF */
  0xCED0,   /* U+4ED0 */
  0xCED1,   /* U+4ED1 */
  0xCED2,   /* U+4ED2 */
  0xCED3,   /* U+4ED3 */
  0x0000,   /* U+4ED4 */
  0x0000,   /* U+4ED5 */
  0x0000,   /* U+4ED6 */
  0x0000,   /* U+4ED7 */
  0x0000,   /* U+4ED8 */
  0x0000,   /* U+4ED9 */
  0xCEDA,   /* U+4EDA */
  0xCEDB,   /* U+4EDB */
  0xCEDC,   /* U+4EDC */
  0xCEDD,   /* U+4EDD */
  0x0000,   /* U+4EDE */
  0x0000,   /* U+4EDF */
  0xCEE0,   /* U+4EE0 */
  0xCEE1,   /* U+4EE1 */
  0xCEE2,   /* U+4EE2 */
  0x0000,   /* U+4EE3 */
  0x0000,   /* U+4EE4 */
  0x0000,   /* U+4EE5 */
  0xCEE6,   /* U+4EE6 */
  0xCEE7,   /* U+4EE7 */
  0xCEE8,   /* U+4EE8 */
  0xCEE9,   /* U+4EE9 */
  0xCEEA,   /* U+4EEA */
  0xCEEB,   /* U+4EEB */
  0xCEEC,   /* U+4EEC */
  0x0000,   /* U+4EED */
  0x0000,   /* U+4EEE */
  0xCEEF,   /* U+4EEF */
  0x0000,   /* U+4EF0 */
  0xCEF1,   /* U+4EF1 */
  0x0000,   /* U+4EF2 */
  0xCEF3,   /* U+4EF3 */
  0xCEF4,   /* U+4EF4 */
  0xCEF5,   /* U+4EF5 */
  0x0000,   /* U+4EF6 */
  0x0000,   /* U+4EF7 */
  0xCEF8,   /* U+4EF8 */
  0xCEF9,   /* U+4EF9 */
  0xCEFA,   /* U+4EFA */
  0x0000,   /* U+4EFB */
  0xCEFC,   /* U+4EFC */
  0xCEFD,   /* U+4EFD */
  0xCEFE,   /* U+4EFE */
  0xCEFF,   /* U+4EFF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+4E00 */
  0x0000,   /* U+4E01 */
  0x0000,   /* U+4E02 */
  0x0000,   /* U+4E03 */
  0x0000,   /* U+4E04 */
  0x0000,   /* U+4E05 */
  0x0000,   /* U+4E06 */
  0x0000,   /* U+4E07 */
  0x0000,   /* U+4E08 */
  0x0000,   /* U+4E09 */
  0x0000,   /* U+4E0A */
  0x0000,   /* U+4E0B */
  0x0000,   /* U+4E0C */
  0x0000,   /* U+4E0D */
  0x0000,   /* U+4E0E */
  0x0000,   /* U+4E0F */
  0x0000,   /* U+4E10 */
  0x0000,   /* U+4E11 */
  0x0000,   /* U+4E12 */
  0x0000,   /* U+4E13 */
  0x0000,   /* U+4E14 */
  0x0000,   /* U+4E15 */
  0x0000,   /* U+4E16 */
  0x0000,   /* U+4E17 */
  0x0000,   /* U+4E18 */
  0x0000,   /* U+4E19 */
  0x0000,   /* U+4E1A */
  0x0000,   /* U+4E1B */
  0x0000,   /* U+4E1C */
  0x0000,   /* U+4E1D */
  0x0000,   /* U+4E1E */
  0x0000,   /* U+4E1F */
  0x0000,   /* U+4E20 */
  0x0000,   /* U+4E21 */
  0x0000,   /* U+4E22 */
  0x0000,   /* U+4E23 */
  0x0000,   /* U+4E24 */
  0x0000,   /* U+4E25 */
  0x0000,   /* U+4E26 */
  0x0000,   /* U+4E27 */
  0x0000,   /* U+4E28 */
  0x0000,   /* U+4E29 */
  0x0000,   /* U+4E2A */
  0x0000,   /* U+4E2B */
  0x0000,   /* U+4E2C */
  0x0000,   /* U+4E2D */
  0x0000,   /* U+4E2E */
  0x0000,   /* U+4E2F */
  0x0000,   /* U+4E30 */
  0x0000,   /* U+4E31 */
  0x0000,   /* U+4E32 */
  0x0000,   /* U+4E33 */
  0x0000,   /* U+4E34 */
  0x0000,   /* U+4E35 */
  0x0000,   /* U+4E36 */
  0x0000,   /* U+4E37 */
  0x0000,   /* U+4E38 */
  0x0000,   /* U+4E39 */
  0x0000,   /* U+4E3A */
  0x0000,   /* U+4E3B */
  0x0000,   /* U+4E3C */
  0x0000,   /* U+4E3D */
  0x0000,   /* U+4E3E */
  0x0000,   /* U+4E3F */
  0x0000,   /* U+4E40 */
  0x0000,   /* U+4E41 */
  0x0000,   /* U+4E42 */
  0x0000,   /* U+4E43 */
  0x0000,   /* U+4E44 */
  0x0000,   /* U+4E45 */
  0x0000,   /* U+4E46 */
  0x0000,   /* U+4E47 */
  0x0000,   /* U+4E48 */
  0x0000,   /* U+4E49 */
  0x0000,   /* U+4E4A */
  0x0000,   /* U+4E4B */
  0x0000,   /* U+4E4C */
  0x0000,   /* U+4E4D */
  0x0000,   /* U+4E4E */
  0x0000,   /* U+4E4F */
  0x0000,   /* U+4E50 */
  0x0000,   /* U+4E51 */
  0x0000,   /* U+4E52 */
  0x0000,   /* U+4E53 */
  0x0000,   /* U+4E54 */
  0x0000,   /* U+4E55 */
  0x0000,   /* U+4E56 */
  0x0000,   /* U+4E57 */
  0x0000,   /* U+4E58 */
  0x0000,   /* U+4E59 */
  0x0000,   /* U+4E5A */
  0x0000,   /* U+4E5B */
  0x0000,   /* U+4E5C */
  0x0000,   /* U+4E5D */
  0x0000,   /* U+4E5E */
  0x0000,   /* U+4E5F */
  0x0000,   /* U+4E60 */
  0x0000,   /* U+4E61 */
  0x0000,   /* U+4E62 */
  0x0000,   /* U+4E63 */
  0x0000,   /* U+4E64 */
  0x0000,   /* U+4E65 */
  0x0000,   /* U+4E66 */
  0x0000,   /* U+4E67 */
  0x0000,   /* U+4E68 */
  0x0000,   /* U+4E69 */
  0x0000,   /* U+4E6A */
  0x0000,   /* U+4E6B */
  0x0000,   /* U+4E6C */
  0x0000,   /* U+4E6D */
  0x0000,   /* U+4E6E */
  0x0000,   /* U+4E6F */
  0x0000,   /* U+4E70 */
  0x0000,   /* U+4E71 */
  0x0000,   /* U+4E72 */
  0x0000,   /* U+4E73 */
  0x0000,   /* U+4E74 */
  0x0000,   /* U+4E75 */
  0x0000,   /* U+4E76 */
  0x0000,   /* U+4E77 */
  0x0000,   /* U+4E78 */
  0x0000,   /* U+4E79 */
  0x0000,   /* U+4E7A */
  0x0000,   /* U+4E7B */
  0x0000,   /* U+4E7C */
  0x0000,   /* U+4E7D */
  0x0000,   /* U+4E7E */
  0x0000,   /* U+4E7F */
  0x0000,   /* U+4E80 */
  0x0000,   /* U+4E81 */
  0x0000,   /* U+4E82 */
  0x0000,   /* U+4E83 */
  0x0000,   /* U+4E84 */
  0x0000,   /* U+4E85 */
  0x0000,   /* U+4E86 */
  0x0000,   /* U+4E87 */
  0x0000,   /* U+4E88 */
  0x0000,   /* U+4E89 */
  0x0000,   /* U+4E8A */
  0x0000,   /* U+4E8B */
  0x0000,   /* U+4E8C */
  0x0000,   /* U+4E8D */
  0x0000,   /* U+4E8E */
  0x0000,   /* U+4E8F */
  0x0000,   /* U+4E90 */
  0x0000,   /* U+4E91 */
  0x0000,   /* U+4E92 */
  0x0000,   /* U+4E93 */
  0x0000,   /* U+4E94 */
  0x0000,   /* U+4E95 */
  0x0000,   /* U+4E96 */
  0x0000,   /* U+4E97 */
  0x0000,   /* U+4E98 */
  0x0000,   /* U+4E99 */
  0x0000,   /* U+4E9A */
  0x0000,   /* U+4E9B */
  0x0000,   /* U+4E9C */
  0x0000,   /* U+4E9D */
  0x0000,   /* U+4E9E */
  0x0000,   /* U+4E9F */
  0x0000,   /* U+4EA0 */
  0x0000,   /* U+4EA1 */
  0x0000,   /* U+4EA2 */
  0x0000,   /* U+4EA3 */
  0x0000,   /* U+4EA4 */
  0x0000,   /* U+4EA5 */
  0x0000,   /* U+4EA6 */
  0x0000,   /* U+4EA7 */
  0x0000,   /* U+4EA8 */
  0x0000,   /* U+4EA9 */
  0x0000,   /* U+4EAA */
  0x0000,   /* U+4EAB */
  0x0000,   /* U+4EAC */
  0x0000,   /* U+4EAD */
  0x0000,   /* U+4EAE */
  0x0000,   /* U+4EAF */
  0x0000,   /* U+4EB0 */
  0x0000,   /* U+4EB1 */
  0x0000,   /* U+4EB2 */
  0x0000,   /* U+4EB3 */
  0x0000,   /* U+4EB4 */
  0x0000,   /* U+4EB5 */
  0x0000,   /* U+4EB6 */
  0x0000,   /* U+4EB7 */
  0x0000,   /* U+4EB8 */
  0x0000,   /* U+4EB9 */
  0x0000,   /* U+4EBA */
  0x0000,   /* U+4EBB */
  0x0000,   /* U+4EBC */
  0x0000,   /* U+4EBD */
  0x0000,   /* U+4EBE */
  0x0000,   /* U+4EBF */
  0x0000,   /* U+4EC0 */
  0x0000,   /* U+4EC1 */
  0x0000,   /* U+4EC2 */
  0x0000,   /* U+4EC3 */
  0x0000,   /* U+4EC4 */
  0x0000,   /* U+4EC5 */
  0x0000,   /* U+4EC6 */
  0x0000,   /* U+4EC7 */
  0x0000,   /* U+4EC8 */
  0x0000,   /* U+4EC9 */
  0x0000,   /* U+4ECA */
  0x0000,   /* U+4ECB */
  0x0000,   /* U+4ECC */
  0x0000,   /* U+4ECD */
  0x0000,   /* U+4ECE */
  0x0000,   /* U+4ECF */
  0x0000,   /* U+4ED0 */
  0x0000,   /* U+4ED1 */
  0x0000,   /* U+4ED2 */
  0x0000,   /* U+4ED3 */
  0x0000,   /* U+4ED4 */
  0x0000,   /* U+4ED5 */
  0x0000,   /* U+4ED6 */
  0x0000,   /* U+4ED7 */
  0x0000,   /* U+4ED8 */
  0x0000,   /* U+4ED9 */
  0x0000,   /* U+4EDA */
  0x0000,   /* U+4EDB */
  0x0000,   /* U+4EDC */
  0x0000,   /* U+4EDD */
  0x0000,   /* U+4EDE */
  0x0000,   /* U+4EDF */
  0x0000,   /* U+4EE0 */
  0x0000,   /* U+4EE1 */
  0x0000,   /* U+4EE2 */
  0x0000,   /* U+4EE3 */
  0x0000,   /* U+4EE4 */
  0x0000,   /* U+4EE5 */
  0x0000,   /* U+4EE6 */
  0x0000,   /* U+4EE7 */
  0x0000,   /* U+4EE8 */
  0x0000,   /* U+4EE9 */
  0x0000,   /* U+4EEA */
  0x0000,   /* U+4EEB */
  0x0000,   /* U+4EEC */
  0x0000,   /* U+4EED */
  0x0000,   /* U+4EEE */
  0x0000,   /* U+4EEF */
  0x0000,   /* U+4EF0 */
  0x0000,   /* U+4EF1 */
  0x0000,   /* U+4EF2 */
  0x0000,   /* U+4EF3 */
  0x0000,   /* U+4EF4 */
  0x0000,   /* U+4EF5 */
  0x0000,   /* U+4EF6 */
  0x0000,   /* U+4EF7 */
  0x0000,   /* U+4EF8 */
  0x0000,   /* U+4EF9 */
  0x0000,   /* U+4EFA */
  0x0000,   /* U+4EFB */
  0x0000,   /* U+4EFC */
  0x0000,   /* U+4EFD */
  0x0000,   /* U+4EFE */
  0x0000,   /* U+4EFF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+4E00 */
  0x0000,   /* U+4E01 */
  0x0000,   /* U+4E02 */
  0x0000,   /* U+4E03 */
  0x0000,   /* U+4E04 */
  0x0000,   /* U+4E05 */
  0x0000,   /* U+4E06 */
  0x0000,   /* U+4E07 */
  0x0000,   /* U+4E08 */
  0x0000,   /* U+4E09 */
  0x0000,   /* U+4E0A */
  0x0000,   /* U+4E0B */
  0x0000,   /* U+4E0C */
  0x0000,   /* U+4E0D */
  0x0000,   /* U+4E0E */
  0x0000,   /* U+4E0F */
  0x0000,   /* U+4E10 */
  0x0000,   /* U+4E11 */
  0x0000,   /* U+4E12 */
  0x0000,   /* U+4E13 */
  0x0000,   /* U+4E14 */
  0x0000,   /* U+4E15 */
  0x0000,   /* U+4E16 */
  0x0000,   /* U+4E17 */
  0x0000,   /* U+4E18 */
  0x0000,   /* U+4E19 */
  0x0000,   /* U+4E1A */
  0x0000,   /* U+4E1B */
  0x0000,   /* U+4E1C */
  0x0000,   /* U+4E1D */
  0x0000,   /* U+4E1E */
  0x0000,   /* U+4E1F */
  0x0000,   /* U+4E20 */
  0x0000,   /* U+4E21 */
  0x0000,   /* U+4E22 */
  0x0000,   /* U+4E23 */
  0x0000,   /* U+4E24 */
  0x0000,   /* U+4E25 */
  0x0000,   /* U+4E26 */
  0x0000,   /* U+4E27 */
  0x0000,   /* U+4E28 */
  0x0000,   /* U+4E29 */
  0x0000,   /* U+4E2A */
  0x0000,   /* U+4E2B */
  0x0000,   /* U+4E2C */
  0x0000,   /* U+4E2D */
  0x0000,   /* U+4E2E */
  0x0000,   /* U+4E2F */
  0x0000,   /* U+4E30 */
  0x0000,   /* U+4E31 */
  0x0000,   /* U+4E32 */
  0x0000,   /* U+4E33 */
  0x0000,   /* U+4E34 */
  0x0000,   /* U+4E35 */
  0x0000,   /* U+4E36 */
  0x0000,   /* U+4E37 */
  0x0000,   /* U+4E38 */
  0x0000,   /* U+4E39 */
  0x0000,   /* U+4E3A */
  0x0000,   /* U+4E3B */
  0x0000,   /* U+4E3C */
  0x0000,   /* U+4E3D */
  0x0000,   /* U+4E3E */
  0x0000,   /* U+4E3F */
  0x0000,   /* U+4E40 */
  0x0000,   /* U+4E41 */
  0x0000,   /* U+4E42 */
  0x0000,   /* U+4E43 */
  0x0000,   /* U+4E44 */
  0x0000,   /* U+4E45 */
  0x0000,   /* U+4E46 */
  0x0000,   /* U+4E47 */
  0x0000,   /* U+4E48 */
  0x0000,   /* U+4E49 */
  0x0000,   /* U+4E4A */
  0x0000,   /* U+4E4B */
  0x0000,   /* U+4E4C */
  0x0000,   /* U+4E4D */
  0x0000,   /* U+4E4E */
  0x0000,   /* U+4E4F */
  0x0000,   /* U+4E50 */
  0x0000,   /* U+4E51 */
  0x0000,   /* U+4E52 */
  0x0000,   /* U+4E53 */
  0x0000,   /* U+4E54 */
  0x0000,   /* U+4E55 */
  0x0000,   /* U+4E56 */
  0x0000,   /* U+4E57 */
  0x0000,   /* U+4E58 */
  0x0000,   /* U+4E59 */
  0x0000,   /* U+4E5A */
  0x0000,   /* U+4E5B */
  0x0000,   /* U+4E5C */
  0x0000,   /* U+4E5D */
  0x0000,   /* U+4E5E */
  0x0000,   /* U+4E5F */
  0x0000,   /* U+4E60 */
  0x0000,   /* U+4E61 */
  0x0000,   /* U+4E62 */
  0x0000,   /* U+4E63 */
  0x0000,   /* U+4E64 */
  0x0000,   /* U+4E65 */
  0x0000,   /* U+4E66 */
  0x0000,   /* U+4E67 */
  0x0000,   /* U+4E68 */
  0x0000,   /* U+4E69 */
  0x0000,   /* U+4E6A */
  0x0000,   /* U+4E6B */
  0x0000,   /* U+4E6C */
  0x0000,   /* U+4E6D */
  0x0000,   /* U+4E6E */
  0x0000,   /* U+4E6F */
  0x0000,   /* U+4E70 */
  0x0000,   /* U+4E71 */
  0x0000,   /* U+4E72 */
  0x0000,   /* U+4E73 */
  0x0000,   /* U+4E74 */
  0x0000,   /* U+4E75 */
  0x0000,   /* U+4E76 */
  0x0000,   /* U+4E77 */
  0x0000,   /* U+4E78 */
  0x0000,   /* U+4E79 */
  0x0000,   /* U+4E7A */
  0x0000,   /* U+4E7B */
  0x0000,   /* U+4E7C */
  0x0000,   /* U+4E7D */
  0x0000,   /* U+4E7E */
  0x0000,   /* U+4E7F */
  0x0000,   /* U+4E80 */
  0x0000,   /* U+4E81 */
  0x0000,   /* U+4E82 */
  0x0000,   /* U+4E83 */
  0x0000,   /* U+4E84 */
  0x0000,   /* U+4E85 */
  0x0000,   /* U+4E86 */
  0x0000,   /* U+4E87 */
  0x0000,   /* U+4E88 */
  0x0000,   /* U+4E89 */
  0x0000,   /* U+4E8A */
  0x0000,   /* U+4E8B */
  0x0000,   /* U+4E8C */
  0x0000,   /* U+4E8D */
  0x0000,   /* U+4E8E */
  0x0000,   /* U+4E8F */
  0x0000,   /* U+4E90 */
  0x0000,   /* U+4E91 */
  0x0000,   /* U+4E92 */
  0x0000,   /* U+4E93 */
  0x0000,   /* U+4E94 */
  0x0000,   /* U+4E95 */
  0x0000,   /* U+4E96 */
  0x0000,   /* U+4E97 */
  0x0000,   /* U+4E98 */
  0x0000,   /* U+4E99 */
  0x0000,   /* U+4E9A */
  0x0000,   /* U+4E9B */
  0x0000,   /* U+4E9C */
  0x0000,   /* U+4E9D */
  0x0000,   /* U+4E9E */
  0x0000,   /* U+4E9F */
  0x0000,   /* U+4EA0 */
  0x0000,   /* U+4EA1 */
  0x0000,   /* U+4EA2 */
  0x0000,   /* U+4EA3 */
  0x0000,   /* U+4EA4 */
  0x0000,   /* U+4EA5 */
  0x0000,   /* U+4EA6 */
  0x0000,   /* U+4EA7 */
  0x0000,   /* U+4EA8 */
  0x0000,   /* U+4EA9 */
  0x0000,   /* U+4EAA */
  0x0000,   /* U+4EAB */
  0x0000,   /* U+4EAC */
  0x0000,   /* U+4EAD */
  0x0000,   /* U+4EAE */
  0x0000,   /* U+4EAF */
  0x0000,   /* U+4EB0 */
  0x0000,   /* U+4EB1 */
  0x0000,   /* U+4EB2 */
  0x0000,   /* U+4EB3 */
  0x0000,   /* U+4EB4 */
  0x0000,   /* U+4EB5 */
  0x0000,   /* U+4EB6 */
  0x0000,   /* U+4EB7 */
  0x0000,   /* U+4EB8 */
  0x0000,   /* U+4EB9 */
  0x0000,   /* U+4EBA */
  0x0000,   /* U+4EBB */
  0x0000,   /* U+4EBC */
  0x0000,   /* U+4EBD */
  0x0000,   /* U+4EBE */
  0x0000,   /* U+4EBF */
  0x0000,   /* U+4EC0 */
  0x0000,   /* U+4EC1 */
  0x0000,   /* U+4EC2 */
  0x0000,   /* U+4EC3 */
  0x0000,   /* U+4EC4 */
  0x0000,   /* U+4EC5 */
  0x0000,   /* U+4EC6 */
  0x0000,   /* U+4EC7 */
  0x0000,   /* U+4EC8 */
  0x0000,   /* U+4EC9 */
  0x0000,   /* U+4ECA */
  0x0000,   /* U+4ECB */
  0x0000,   /* U+4ECC */
  0x0000,   /* U+4ECD */
  0x0000,   /* U+4ECE */
  0x0000,   /* U+4ECF */
  0x0000,   /* U+4ED0 */
  0x0000,   /* U+4ED1 */
  0x0000,   /* U+4ED2 */
  0x0000,   /* U+4ED3 */
  0x0000,   /* U+4ED4 */
  0x0000,   /* U+4ED5 */
  0x0000,   /* U+4ED6 */
  0x0000,   /* U+4ED7 */
  0x0000,   /* U+4ED8 */
  0x0000,   /* U+4ED9 */
  0x0000,   /* U+4EDA */
  0x0000,   /* U+4EDB */
  0x0000,   /* U+4EDC */
  0x0000,   /* U+4EDD */
  0x0000,   /* U+4EDE */
  0x0000,   /* U+4EDF */
  0x0000,   /* U+4EE0 */
  0x0000,   /* U+4EE1 */
  0x0000,   /* U+4EE2 */
  0x0000,   /* U+4EE3 */
  0x0000,   /* U+4EE4 */
  0x0000,   /* U+4EE5 */
  0x0000,   /* U+4EE6 */
  0x0000,   /* U+4EE7 */
  0x0000,   /* U+4EE8 */
  0x0000,   /* U+4EE9 */
  0x0000,   /* U+4EEA */
  0x0000,   /* U+4EEB */
  0x0000,   /* U+4EEC */
  0x0000,   /* U+4EED */
  0x0000,   /* U+4EEE */
  0x0000,   /* U+4EEF */
  0x0000,   /* U+4EF0 */
  0x0000,   /* U+4EF1 */
  0x0000,   /* U+4EF2 */
  0x0000,   /* U+4EF3 */
  0x0000,   /* U+4EF4 */
  0x0000,   /* U+4EF5 */
  0x0000,   /* U+4EF6 */
  0x0000,   /* U+4EF7 */
  0x0000,   /* U+4EF8 */
  0x0000,   /* U+4EF9 */
  0x0000,   /* U+4EFA */
  0x0000,   /* U+4EFB */
  0x0000,   /* U+4EFC */
  0x0000,   /* U+4EFD */
  0x0000,   /* U+4EFE */
  0x0000,   /* U+4EFF */
};

uint16 ja_han_page4F[]= {
  /* Number of CEs for each character. */
  2, 1, 2, 2, 2, 2, 2, 2, 2, 1, 1, 2, 2, 1, 1, 1,
  1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 1, 1, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1,
  1, 2, 2, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 1, 2, 2,
  2, 2, 2, 1, 2, 2, 1, 1, 2, 2, 2, 2, 2, 1, 1, 1,
  1, 1, 2, 1, 2, 1, 2, 1, 2, 1, 1, 1, 1, 1, 1, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 1,
  1, 2, 2, 1, 2, 1, 1, 2, 2, 2, 2, 1, 1, 2, 2, 1,
  2, 2, 2, 1, 2, 2, 1, 2, 1, 2, 2, 1, 2, 1, 2, 1,
  2, 1, 2, 2, 2, 2, 1, 2, 1, 2, 2, 1, 2, 1, 2, 2,
  1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 1, 1, 1,
  2, 2, 2, 2, 2, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 1,
  2, 2, 1, 1, 1, 2, 2, 2, 2, 2, 1, 2, 2, 2, 1, 2,
  1, 1, 2, 2, 1, 2, 2, 1, 1, 2, 1, 1, 2, 1, 2, 1,
  2, 1, 2, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1,
  2, 2, 2, 1, 2, 1, 1, 2, 1, 2, 1, 2, 2, 2, 1, 2,

  /* Primary weight 1 for each character. */
  0xFB40,   /* U+4F00 */
  0x5666,   /* U+4F01 */
  0xFB40,   /* U+4F02 */
  0xFB40,   /* U+4F03 */
  0xFB40,   /* U+4F04 */
  0xFB40,   /* U+4F05 */
  0xFB40,   /* U+4F06 */
  0xFB40,   /* U+4F07 */
  0xFB40,   /* U+4F08 */
  0x605C,   /* U+4F09 */
  0x54CE,   /* U+4F0A */
  0xFB40,   /* U+4F0B */
  0xFB40,   /* U+4F0C */
  0x57D3,   /* U+4F0D */
  0x5667,   /* U+4F0E */
  0x5E2B,   /* U+4F0F */
  0x5D85,   /* U+4F10 */
  0x56B2,   /* U+4F11 */
  0xFB40,   /* U+4F12 */
  0xFB40,   /* U+4F13 */
  0xFB40,   /* U+4F14 */
  0xFB40,   /* U+4F15 */
  0xFB40,   /* U+4F16 */
  0xFB40,   /* U+4F17 */
  0xFB40,   /* U+4F18 */
  0xFB40,   /* U+4F19 */
  0x55B0,   /* U+4F1A */
  0xFB40,   /* U+4F1B */
  0x607F,   /* U+4F1C */
  0x5C7A,   /* U+4F1D */
  0xFB40,   /* U+4F1E */
  0xFB40,   /* U+4F1F */
  0xFB40,   /* U+4F20 */
  0xFB40,   /* U+4F21 */
  0xFB40,   /* U+4F22 */
  0xFB40,   /* U+4F23 */
  0xFB40,   /* U+4F24 */
  0xFB40,   /* U+4F25 */
  0xFB40,   /* U+4F26 */
  0xFB40,   /* U+4F27 */
  0xFB40,   /* U+4F28 */
  0xFB40,   /* U+4F29 */
  0xFB40,   /* U+4F2A */
  0xFB40,   /* U+4F2B */
  0xFB40,   /* U+4F2C */
  0xFB40,   /* U+4F2D */
  0xFB40,   /* U+4F2E */
  0x5D61,   /* U+4F2F */
  0x605E,   /* U+4F30 */
  0xFB40,   /* U+4F31 */
  0xFB40,   /* U+4F32 */
  0xFB40,   /* U+4F33 */
  0x5D8F,   /* U+4F34 */
  0xFB40,   /* U+4F35 */
  0x5FE9,   /* U+4F36 */
  0xFB40,   /* U+4F37 */
  0x5A32,   /* U+4F38 */
  0xFB40,   /* U+4F39 */
  0x58D4,   /* U+4F3A */
  0xFB40,   /* U+4F3B */
  0x5904,   /* U+4F3C */
  0x557F,   /* U+4F3D */
  0xFB40,   /* U+4F3E */
  0xFB40,   /* U+4F3F */
  0xFB40,   /* U+4F40 */
  0xFB40,   /* U+4F41 */
  0xFB40,   /* U+4F42 */
  0x5C2C,   /* U+4F43 */
  0xFB40,   /* U+4F44 */
  0xFB40,   /* U+4F45 */
  0x5B9F,   /* U+4F46 */
  0x6062,   /* U+4F47 */
  0xFB40,   /* U+4F48 */
  0xFB40,   /* U+4F49 */
  0xFB40,   /* U+4F4A */
  0xFB40,   /* U+4F4B */
  0xFB40,   /* U+4F4C */
  0x54CF,   /* U+4F4D */
  0x5C3E,   /* U+4F4E */
  0x5984,   /* U+4F4F */
  0x5863,   /* U+4F50 */
  0x5F4D,   /* U+4F51 */
  0xFB40,   /* U+4F52 */
  0x5B6D,   /* U+4F53 */
  0xFB40,   /* U+4F54 */
  0x557E,   /* U+4F55 */
  0xFB40,   /* U+4F56 */
  0x6061,   /* U+4F57 */
  0xFB40,   /* U+4F58 */
  0x5F67,   /* U+4F59 */
  0x605D,   /* U+4F5A */
  0x605F,   /* U+4F5B */
  0x589D,   /* U+4F5C */
  0x6060,   /* U+4F5D */
  0x6212,   /* U+4F5E */
  0xFB40,   /* U+4F5F */
  0xFB40,   /* U+4F60 */
  0xFB40,   /* U+4F61 */
  0xFB40,   /* U+4F62 */
  0xFB40,   /* U+4F63 */
  0xFB40,   /* U+4F64 */
  0xFB40,   /* U+4F65 */
  0xFB40,   /* U+4F66 */
  0xFB40,   /* U+4F67 */
  0xFB40,   /* U+4F68 */
  0x6068,   /* U+4F69 */
  0xFB40,   /* U+4F6A */
  0xFB40,   /* U+4F6B */
  0xFB40,   /* U+4F6C */
  0xFB40,   /* U+4F6D */
  0xFB40,   /* U+4F6E */
  0x606B,   /* U+4F6F */
  0x6069,   /* U+4F70 */
  0xFB40,   /* U+4F71 */
  0xFB40,   /* U+4F72 */
  0x5581,   /* U+4F73 */
  0xFB40,   /* U+4F74 */
  0x5E4A,   /* U+4F75 */
  0x6063,   /* U+4F76 */
  0xFB40,   /* U+4F77 */
  0xFB40,   /* U+4F78 */
  0xFB40,   /* U+4F79 */
  0xFB40,   /* U+4F7A */
  0x6067,   /* U+4F7B */
  0x57E6,   /* U+4F7C */
  0xFB40,   /* U+4F7D */
  0xFB40,   /* U+4F7E */
  0x58D5,   /* U+4F7F */
  0xFB40,   /* U+4F80 */
  0xFB40,   /* U+4F81 */
  0xFB40,   /* U+4F82 */
  0x5621,   /* U+4F83 */
  0xFB40,   /* U+4F84 */
  0xFB40,   /* U+4F85 */
  0x606C,   /* U+4F86 */
  0xFB40,   /* U+4F87 */
  0x6064,   /* U+4F88 */
  0xFB40,   /* U+4F89 */
  0xFB40,   /* U+4F8A */
  0x5FEA,   /* U+4F8B */
  0xFB40,   /* U+4F8C */
  0x5905,   /* U+4F8D */
  0xFB40,   /* U+4F8E */
  0x6065,   /* U+4F8F */
  0xFB40,   /* U+4F90 */
  0x606A,   /* U+4F91 */
  0xFB40,   /* U+4F92 */
  0xFB40,   /* U+4F93 */
  0xFB40,   /* U+4F94 */
  0xFB40,   /* U+4F95 */
  0x606D,   /* U+4F96 */
  0xFB40,   /* U+4F97 */
  0x6066,   /* U+4F98 */
  0xFB40,   /* U+4F99 */
  0xFB40,   /* U+4F9A */
  0x56D8,   /* U+4F9B */
  0xFB40,   /* U+4F9C */
  0x54D0,   /* U+4F9D */
  0xFB40,   /* U+4F9E */
  0xFB40,   /* U+4F9F */
  0x56D9,   /* U+4FA0 */
  0x5580,   /* U+4FA1 */
  0xFB40,   /* U+4FA2 */
  0xFB40,   /* U+4FA3 */
  0xFB40,   /* U+4FA4 */
  0xFB40,   /* U+4FA5 */
  0xFB40,   /* U+4FA6 */
  0xFB40,   /* U+4FA7 */
  0xFB40,   /* U+4FA8 */
  0xFB40,   /* U+4FA9 */
  0xFB40,   /* U+4FAA */
  0x6213,   /* U+4FAB */
  0xFB40,   /* U+4FAC */
  0x5EE6,   /* U+4FAD */
  0x5E1F,   /* U+4FAE */
  0x57E7,   /* U+4FAF */
  0xFB40,   /* U+4FB0 */
  0xFB40,   /* U+4FB1 */
  0xFB40,   /* U+4FB2 */
  0xFB40,   /* U+4FB3 */
  0xFB40,   /* U+4FB4 */
  0x5A34,   /* U+4FB5 */
  0x5FBE,   /* U+4FB6 */
  0xFB40,   /* U+4FB7 */
  0xFB40,   /* U+4FB8 */
  0xFB40,   /* U+4FB9 */
  0xFB40,   /* U+4FBA */
  0xFB40,   /* U+4FBB */
  0xFB40,   /* U+4FBC */
  0xFB40,   /* U+4FBD */
  0xFB40,   /* U+4FBE */
  0x5E67,   /* U+4FBF */
  0xFB40,   /* U+4FC0 */
  0xFB40,   /* U+4FC1 */
  0x574D,   /* U+4FC2 */
  0x5B44,   /* U+4FC3 */
  0x55A3,   /* U+4FC4 */
  0xFB40,   /* U+4FC5 */
  0xFB40,   /* U+4FC6 */
  0xFB40,   /* U+4FC7 */
  0xFB40,   /* U+4FC8 */
  0xFB40,   /* U+4FC9 */
  0x599C,   /* U+4FCA */
  0xFB40,   /* U+4FCB */
  0xFB40,   /* U+4FCC */
  0xFB40,   /* U+4FCD */
  0x6071,   /* U+4FCE */
  0xFB40,   /* U+4FCF */
  0x6076,   /* U+4FD0 */
  0x6074,   /* U+4FD1 */
  0xFB40,   /* U+4FD2 */
  0xFB40,   /* U+4FD3 */
  0x606F,   /* U+4FD4 */
  0xFB40,   /* U+4FD5 */
  0xFB40,   /* U+4FD6 */
  0x5B4E,   /* U+4FD7 */
  0x6072,   /* U+4FD8 */
  0xFB40,   /* U+4FD9 */
  0x6075,   /* U+4FDA */
  0x6073,   /* U+4FDB */
  0xFB40,   /* U+4FDC */
  0x5E6C,   /* U+4FDD */
  0xFB40,   /* U+4FDE */
  0x6070,   /* U+4FDF */
  0xFB40,   /* U+4FE0 */
  0x5A33,   /* U+4FE1 */
  0xFB40,   /* U+4FE2 */
  0x5EE0,   /* U+4FE3 */
  0x6077,   /* U+4FE4 */
  0x6078,   /* U+4FE5 */
  0xFB40,   /* U+4FE6 */
  0xFB40,   /* U+4FE7 */
  0xFB40,   /* U+4FE8 */
  0xFB40,   /* U+4FE9 */
  0xFB40,   /* U+4FEA */
  0xFB40,   /* U+4FEB */
  0xFB40,   /* U+4FEC */
  0xFB40,   /* U+4FED */
  0x596D,   /* U+4FEE */
  0x6085,   /* U+4FEF */
  0xFB40,   /* U+4FF0 */
  0xFB40,   /* U+4FF1 */
  0xFB40,   /* U+4FF2 */
  0x5D45,   /* U+4FF3 */
  0xFB40,   /* U+4FF4 */
  0x5DE7,   /* U+4FF5 */
  0x6080,   /* U+4FF6 */
  0xFB40,   /* U+4FF7 */
  0x5E7F,   /* U+4FF8 */
  0xFB40,   /* U+4FF9 */
  0x5575,   /* U+4FFA */
  0xFB40,   /* U+4FFB */
  0xFB40,   /* U+4FFC */
  0xFB40,   /* U+4FFD */
  0x6084,   /* U+4FFE */
  0xFB40,   /* U+4FFF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+4F00 */
  0x0020,   /* U+4F01 */
  0x0020,   /* U+4F02 */
  0x0020,   /* U+4F03 */
  0x0020,   /* U+4F04 */
  0x0020,   /* U+4F05 */
  0x0020,   /* U+4F06 */
  0x0020,   /* U+4F07 */
  0x0020,   /* U+4F08 */
  0x0020,   /* U+4F09 */
  0x0020,   /* U+4F0A */
  0x0020,   /* U+4F0B */
  0x0020,   /* U+4F0C */
  0x0020,   /* U+4F0D */
  0x0020,   /* U+4F0E */
  0x0020,   /* U+4F0F */
  0x0020,   /* U+4F10 */
  0x0020,   /* U+4F11 */
  0x0020,   /* U+4F12 */
  0x0020,   /* U+4F13 */
  0x0020,   /* U+4F14 */
  0x0020,   /* U+4F15 */
  0x0020,   /* U+4F16 */
  0x0020,   /* U+4F17 */
  0x0020,   /* U+4F18 */
  0x0020,   /* U+4F19 */
  0x0020,   /* U+4F1A */
  0x0020,   /* U+4F1B */
  0x0020,   /* U+4F1C */
  0x0020,   /* U+4F1D */
  0x0020,   /* U+4F1E */
  0x0020,   /* U+4F1F */
  0x0020,   /* U+4F20 */
  0x0020,   /* U+4F21 */
  0x0020,   /* U+4F22 */
  0x0020,   /* U+4F23 */
  0x0020,   /* U+4F24 */
  0x0020,   /* U+4F25 */
  0x0020,   /* U+4F26 */
  0x0020,   /* U+4F27 */
  0x0020,   /* U+4F28 */
  0x0020,   /* U+4F29 */
  0x0020,   /* U+4F2A */
  0x0020,   /* U+4F2B */
  0x0020,   /* U+4F2C */
  0x0020,   /* U+4F2D */
  0x0020,   /* U+4F2E */
  0x0020,   /* U+4F2F */
  0x0020,   /* U+4F30 */
  0x0020,   /* U+4F31 */
  0x0020,   /* U+4F32 */
  0x0020,   /* U+4F33 */
  0x0020,   /* U+4F34 */
  0x0020,   /* U+4F35 */
  0x0020,   /* U+4F36 */
  0x0020,   /* U+4F37 */
  0x0020,   /* U+4F38 */
  0x0020,   /* U+4F39 */
  0x0020,   /* U+4F3A */
  0x0020,   /* U+4F3B */
  0x0020,   /* U+4F3C */
  0x0020,   /* U+4F3D */
  0x0020,   /* U+4F3E */
  0x0020,   /* U+4F3F */
  0x0020,   /* U+4F40 */
  0x0020,   /* U+4F41 */
  0x0020,   /* U+4F42 */
  0x0020,   /* U+4F43 */
  0x0020,   /* U+4F44 */
  0x0020,   /* U+4F45 */
  0x0020,   /* U+4F46 */
  0x0020,   /* U+4F47 */
  0x0020,   /* U+4F48 */
  0x0020,   /* U+4F49 */
  0x0020,   /* U+4F4A */
  0x0020,   /* U+4F4B */
  0x0020,   /* U+4F4C */
  0x0020,   /* U+4F4D */
  0x0020,   /* U+4F4E */
  0x0020,   /* U+4F4F */
  0x0020,   /* U+4F50 */
  0x0020,   /* U+4F51 */
  0x0020,   /* U+4F52 */
  0x0020,   /* U+4F53 */
  0x0020,   /* U+4F54 */
  0x0020,   /* U+4F55 */
  0x0020,   /* U+4F56 */
  0x0020,   /* U+4F57 */
  0x0020,   /* U+4F58 */
  0x0020,   /* U+4F59 */
  0x0020,   /* U+4F5A */
  0x0020,   /* U+4F5B */
  0x0020,   /* U+4F5C */
  0x0020,   /* U+4F5D */
  0x0020,   /* U+4F5E */
  0x0020,   /* U+4F5F */
  0x0020,   /* U+4F60 */
  0x0020,   /* U+4F61 */
  0x0020,   /* U+4F62 */
  0x0020,   /* U+4F63 */
  0x0020,   /* U+4F64 */
  0x0020,   /* U+4F65 */
  0x0020,   /* U+4F66 */
  0x0020,   /* U+4F67 */
  0x0020,   /* U+4F68 */
  0x0020,   /* U+4F69 */
  0x0020,   /* U+4F6A */
  0x0020,   /* U+4F6B */
  0x0020,   /* U+4F6C */
  0x0020,   /* U+4F6D */
  0x0020,   /* U+4F6E */
  0x0020,   /* U+4F6F */
  0x0020,   /* U+4F70 */
  0x0020,   /* U+4F71 */
  0x0020,   /* U+4F72 */
  0x0020,   /* U+4F73 */
  0x0020,   /* U+4F74 */
  0x0020,   /* U+4F75 */
  0x0020,   /* U+4F76 */
  0x0020,   /* U+4F77 */
  0x0020,   /* U+4F78 */
  0x0020,   /* U+4F79 */
  0x0020,   /* U+4F7A */
  0x0020,   /* U+4F7B */
  0x0020,   /* U+4F7C */
  0x0020,   /* U+4F7D */
  0x0020,   /* U+4F7E */
  0x0020,   /* U+4F7F */
  0x0020,   /* U+4F80 */
  0x0020,   /* U+4F81 */
  0x0020,   /* U+4F82 */
  0x0020,   /* U+4F83 */
  0x0020,   /* U+4F84 */
  0x0020,   /* U+4F85 */
  0x0020,   /* U+4F86 */
  0x0020,   /* U+4F87 */
  0x0020,   /* U+4F88 */
  0x0020,   /* U+4F89 */
  0x0020,   /* U+4F8A */
  0x0020,   /* U+4F8B */
  0x0020,   /* U+4F8C */
  0x0020,   /* U+4F8D */
  0x0020,   /* U+4F8E */
  0x0020,   /* U+4F8F */
  0x0020,   /* U+4F90 */
  0x0020,   /* U+4F91 */
  0x0020,   /* U+4F92 */
  0x0020,   /* U+4F93 */
  0x0020,   /* U+4F94 */
  0x0020,   /* U+4F95 */
  0x0020,   /* U+4F96 */
  0x0020,   /* U+4F97 */
  0x0020,   /* U+4F98 */
  0x0020,   /* U+4F99 */
  0x0020,   /* U+4F9A */
  0x0020,   /* U+4F9B */
  0x0020,   /* U+4F9C */
  0x0020,   /* U+4F9D */
  0x0020,   /* U+4F9E */
  0x0020,   /* U+4F9F */
  0x0020,   /* U+4FA0 */
  0x0020,   /* U+4FA1 */
  0x0020,   /* U+4FA2 */
  0x0020,   /* U+4FA3 */
  0x0020,   /* U+4FA4 */
  0x0020,   /* U+4FA5 */
  0x0020,   /* U+4FA6 */
  0x0020,   /* U+4FA7 */
  0x0020,   /* U+4FA8 */
  0x0020,   /* U+4FA9 */
  0x0020,   /* U+4FAA */
  0x0020,   /* U+4FAB */
  0x0020,   /* U+4FAC */
  0x0020,   /* U+4FAD */
  0x0020,   /* U+4FAE */
  0x0020,   /* U+4FAF */
  0x0020,   /* U+4FB0 */
  0x0020,   /* U+4FB1 */
  0x0020,   /* U+4FB2 */
  0x0020,   /* U+4FB3 */
  0x0020,   /* U+4FB4 */
  0x0020,   /* U+4FB5 */
  0x0020,   /* U+4FB6 */
  0x0020,   /* U+4FB7 */
  0x0020,   /* U+4FB8 */
  0x0020,   /* U+4FB9 */
  0x0020,   /* U+4FBA */
  0x0020,   /* U+4FBB */
  0x0020,   /* U+4FBC */
  0x0020,   /* U+4FBD */
  0x0020,   /* U+4FBE */
  0x0020,   /* U+4FBF */
  0x0020,   /* U+4FC0 */
  0x0020,   /* U+4FC1 */
  0x0020,   /* U+4FC2 */
  0x0020,   /* U+4FC3 */
  0x0020,   /* U+4FC4 */
  0x0020,   /* U+4FC5 */
  0x0020,   /* U+4FC6 */
  0x0020,   /* U+4FC7 */
  0x0020,   /* U+4FC8 */
  0x0020,   /* U+4FC9 */
  0x0020,   /* U+4FCA */
  0x0020,   /* U+4FCB */
  0x0020,   /* U+4FCC */
  0x0020,   /* U+4FCD */
  0x0020,   /* U+4FCE */
  0x0020,   /* U+4FCF */
  0x0020,   /* U+4FD0 */
  0x0020,   /* U+4FD1 */
  0x0020,   /* U+4FD2 */
  0x0020,   /* U+4FD3 */
  0x0020,   /* U+4FD4 */
  0x0020,   /* U+4FD5 */
  0x0020,   /* U+4FD6 */
  0x0020,   /* U+4FD7 */
  0x0020,   /* U+4FD8 */
  0x0020,   /* U+4FD9 */
  0x0020,   /* U+4FDA */
  0x0020,   /* U+4FDB */
  0x0020,   /* U+4FDC */
  0x0020,   /* U+4FDD */
  0x0020,   /* U+4FDE */
  0x0020,   /* U+4FDF */
  0x0020,   /* U+4FE0 */
  0x0020,   /* U+4FE1 */
  0x0020,   /* U+4FE2 */
  0x0020,   /* U+4FE3 */
  0x0020,   /* U+4FE4 */
  0x0020,   /* U+4FE5 */
  0x0020,   /* U+4FE6 */
  0x0020,   /* U+4FE7 */
  0x0020,   /* U+4FE8 */
  0x0020,   /* U+4FE9 */
  0x0020,   /* U+4FEA */
  0x0020,   /* U+4FEB */
  0x0020,   /* U+4FEC */
  0x0020,   /* U+4FED */
  0x0020,   /* U+4FEE */
  0x0020,   /* U+4FEF */
  0x0020,   /* U+4FF0 */
  0x0020,   /* U+4FF1 */
  0x0020,   /* U+4FF2 */
  0x0020,   /* U+4FF3 */
  0x0020,   /* U+4FF4 */
  0x0020,   /* U+4FF5 */
  0x0020,   /* U+4FF6 */
  0x0020,   /* U+4FF7 */
  0x0020,   /* U+4FF8 */
  0x0020,   /* U+4FF9 */
  0x0020,   /* U+4FFA */
  0x0020,   /* U+4FFB */
  0x0020,   /* U+4FFC */
  0x0020,   /* U+4FFD */
  0x0020,   /* U+4FFE */
  0x0020,   /* U+4FFF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+4F00 */
  0x0002,   /* U+4F01 */
  0x0002,   /* U+4F02 */
  0x0002,   /* U+4F03 */
  0x0002,   /* U+4F04 */
  0x0002,   /* U+4F05 */
  0x0002,   /* U+4F06 */
  0x0002,   /* U+4F07 */
  0x0002,   /* U+4F08 */
  0x0002,   /* U+4F09 */
  0x0002,   /* U+4F0A */
  0x0002,   /* U+4F0B */
  0x0002,   /* U+4F0C */
  0x0002,   /* U+4F0D */
  0x0002,   /* U+4F0E */
  0x0002,   /* U+4F0F */
  0x0002,   /* U+4F10 */
  0x0002,   /* U+4F11 */
  0x0002,   /* U+4F12 */
  0x0002,   /* U+4F13 */
  0x0002,   /* U+4F14 */
  0x0002,   /* U+4F15 */
  0x0002,   /* U+4F16 */
  0x0002,   /* U+4F17 */
  0x0002,   /* U+4F18 */
  0x0002,   /* U+4F19 */
  0x0002,   /* U+4F1A */
  0x0002,   /* U+4F1B */
  0x0002,   /* U+4F1C */
  0x0002,   /* U+4F1D */
  0x0002,   /* U+4F1E */
  0x0002,   /* U+4F1F */
  0x0002,   /* U+4F20 */
  0x0002,   /* U+4F21 */
  0x0002,   /* U+4F22 */
  0x0002,   /* U+4F23 */
  0x0002,   /* U+4F24 */
  0x0002,   /* U+4F25 */
  0x0002,   /* U+4F26 */
  0x0002,   /* U+4F27 */
  0x0002,   /* U+4F28 */
  0x0002,   /* U+4F29 */
  0x0002,   /* U+4F2A */
  0x0002,   /* U+4F2B */
  0x0002,   /* U+4F2C */
  0x0002,   /* U+4F2D */
  0x0002,   /* U+4F2E */
  0x0002,   /* U+4F2F */
  0x0002,   /* U+4F30 */
  0x0002,   /* U+4F31 */
  0x0002,   /* U+4F32 */
  0x0002,   /* U+4F33 */
  0x0002,   /* U+4F34 */
  0x0002,   /* U+4F35 */
  0x0002,   /* U+4F36 */
  0x0002,   /* U+4F37 */
  0x0002,   /* U+4F38 */
  0x0002,   /* U+4F39 */
  0x0002,   /* U+4F3A */
  0x0002,   /* U+4F3B */
  0x0002,   /* U+4F3C */
  0x0002,   /* U+4F3D */
  0x0002,   /* U+4F3E */
  0x0002,   /* U+4F3F */
  0x0002,   /* U+4F40 */
  0x0002,   /* U+4F41 */
  0x0002,   /* U+4F42 */
  0x0002,   /* U+4F43 */
  0x0002,   /* U+4F44 */
  0x0002,   /* U+4F45 */
  0x0002,   /* U+4F46 */
  0x0002,   /* U+4F47 */
  0x0002,   /* U+4F48 */
  0x0002,   /* U+4F49 */
  0x0002,   /* U+4F4A */
  0x0002,   /* U+4F4B */
  0x0002,   /* U+4F4C */
  0x0002,   /* U+4F4D */
  0x0002,   /* U+4F4E */
  0x0002,   /* U+4F4F */
  0x0002,   /* U+4F50 */
  0x0002,   /* U+4F51 */
  0x0002,   /* U+4F52 */
  0x0002,   /* U+4F53 */
  0x0002,   /* U+4F54 */
  0x0002,   /* U+4F55 */
  0x0002,   /* U+4F56 */
  0x0002,   /* U+4F57 */
  0x0002,   /* U+4F58 */
  0x0002,   /* U+4F59 */
  0x0002,   /* U+4F5A */
  0x0002,   /* U+4F5B */
  0x0002,   /* U+4F5C */
  0x0002,   /* U+4F5D */
  0x0002,   /* U+4F5E */
  0x0002,   /* U+4F5F */
  0x0002,   /* U+4F60 */
  0x0002,   /* U+4F61 */
  0x0002,   /* U+4F62 */
  0x0002,   /* U+4F63 */
  0x0002,   /* U+4F64 */
  0x0002,   /* U+4F65 */
  0x0002,   /* U+4F66 */
  0x0002,   /* U+4F67 */
  0x0002,   /* U+4F68 */
  0x0002,   /* U+4F69 */
  0x0002,   /* U+4F6A */
  0x0002,   /* U+4F6B */
  0x0002,   /* U+4F6C */
  0x0002,   /* U+4F6D */
  0x0002,   /* U+4F6E */
  0x0002,   /* U+4F6F */
  0x0002,   /* U+4F70 */
  0x0002,   /* U+4F71 */
  0x0002,   /* U+4F72 */
  0x0002,   /* U+4F73 */
  0x0002,   /* U+4F74 */
  0x0002,   /* U+4F75 */
  0x0002,   /* U+4F76 */
  0x0002,   /* U+4F77 */
  0x0002,   /* U+4F78 */
  0x0002,   /* U+4F79 */
  0x0002,   /* U+4F7A */
  0x0002,   /* U+4F7B */
  0x0002,   /* U+4F7C */
  0x0002,   /* U+4F7D */
  0x0002,   /* U+4F7E */
  0x0002,   /* U+4F7F */
  0x0002,   /* U+4F80 */
  0x0002,   /* U+4F81 */
  0x0002,   /* U+4F82 */
  0x0002,   /* U+4F83 */
  0x0002,   /* U+4F84 */
  0x0002,   /* U+4F85 */
  0x0002,   /* U+4F86 */
  0x0002,   /* U+4F87 */
  0x0002,   /* U+4F88 */
  0x0002,   /* U+4F89 */
  0x0002,   /* U+4F8A */
  0x0002,   /* U+4F8B */
  0x0002,   /* U+4F8C */
  0x0002,   /* U+4F8D */
  0x0002,   /* U+4F8E */
  0x0002,   /* U+4F8F */
  0x0002,   /* U+4F90 */
  0x0002,   /* U+4F91 */
  0x0002,   /* U+4F92 */
  0x0002,   /* U+4F93 */
  0x0002,   /* U+4F94 */
  0x0002,   /* U+4F95 */
  0x0002,   /* U+4F96 */
  0x0002,   /* U+4F97 */
  0x0002,   /* U+4F98 */
  0x0002,   /* U+4F99 */
  0x0002,   /* U+4F9A */
  0x0002,   /* U+4F9B */
  0x0002,   /* U+4F9C */
  0x0002,   /* U+4F9D */
  0x0002,   /* U+4F9E */
  0x0002,   /* U+4F9F */
  0x0002,   /* U+4FA0 */
  0x0002,   /* U+4FA1 */
  0x0002,   /* U+4FA2 */
  0x0002,   /* U+4FA3 */
  0x0002,   /* U+4FA4 */
  0x0002,   /* U+4FA5 */
  0x0002,   /* U+4FA6 */
  0x0002,   /* U+4FA7 */
  0x0002,   /* U+4FA8 */
  0x0002,   /* U+4FA9 */
  0x0002,   /* U+4FAA */
  0x0002,   /* U+4FAB */
  0x0002,   /* U+4FAC */
  0x0002,   /* U+4FAD */
  0x0002,   /* U+4FAE */
  0x0002,   /* U+4FAF */
  0x0002,   /* U+4FB0 */
  0x0002,   /* U+4FB1 */
  0x0002,   /* U+4FB2 */
  0x0002,   /* U+4FB3 */
  0x0002,   /* U+4FB4 */
  0x0002,   /* U+4FB5 */
  0x0002,   /* U+4FB6 */
  0x0002,   /* U+4FB7 */
  0x0002,   /* U+4FB8 */
  0x0002,   /* U+4FB9 */
  0x0002,   /* U+4FBA */
  0x0002,   /* U+4FBB */
  0x0002,   /* U+4FBC */
  0x0002,   /* U+4FBD */
  0x0002,   /* U+4FBE */
  0x0002,   /* U+4FBF */
  0x0002,   /* U+4FC0 */
  0x0002,   /* U+4FC1 */
  0x0002,   /* U+4FC2 */
  0x0002,   /* U+4FC3 */
  0x0002,   /* U+4FC4 */
  0x0002,   /* U+4FC5 */
  0x0002,   /* U+4FC6 */
  0x0002,   /* U+4FC7 */
  0x0002,   /* U+4FC8 */
  0x0002,   /* U+4FC9 */
  0x0002,   /* U+4FCA */
  0x0002,   /* U+4FCB */
  0x0002,   /* U+4FCC */
  0x0002,   /* U+4FCD */
  0x0002,   /* U+4FCE */
  0x0002,   /* U+4FCF */
  0x0002,   /* U+4FD0 */
  0x0002,   /* U+4FD1 */
  0x0002,   /* U+4FD2 */
  0x0002,   /* U+4FD3 */
  0x0002,   /* U+4FD4 */
  0x0002,   /* U+4FD5 */
  0x0002,   /* U+4FD6 */
  0x0002,   /* U+4FD7 */
  0x0002,   /* U+4FD8 */
  0x0002,   /* U+4FD9 */
  0x0002,   /* U+4FDA */
  0x0002,   /* U+4FDB */
  0x0002,   /* U+4FDC */
  0x0002,   /* U+4FDD */
  0x0002,   /* U+4FDE */
  0x0002,   /* U+4FDF */
  0x0002,   /* U+4FE0 */
  0x0002,   /* U+4FE1 */
  0x0002,   /* U+4FE2 */
  0x0002,   /* U+4FE3 */
  0x0002,   /* U+4FE4 */
  0x0002,   /* U+4FE5 */
  0x0002,   /* U+4FE6 */
  0x0002,   /* U+4FE7 */
  0x0002,   /* U+4FE8 */
  0x0002,   /* U+4FE9 */
  0x0002,   /* U+4FEA */
  0x0002,   /* U+4FEB */
  0x0002,   /* U+4FEC */
  0x0002,   /* U+4FED */
  0x0002,   /* U+4FEE */
  0x0002,   /* U+4FEF */
  0x0002,   /* U+4FF0 */
  0x0002,   /* U+4FF1 */
  0x0002,   /* U+4FF2 */
  0x0002,   /* U+4FF3 */
  0x0002,   /* U+4FF4 */
  0x0002,   /* U+4FF5 */
  0x0002,   /* U+4FF6 */
  0x0002,   /* U+4FF7 */
  0x0002,   /* U+4FF8 */
  0x0002,   /* U+4FF9 */
  0x0002,   /* U+4FFA */
  0x0002,   /* U+4FFB */
  0x0002,   /* U+4FFC */
  0x0002,   /* U+4FFD */
  0x0002,   /* U+4FFE */
  0x0002,   /* U+4FFF */

  /* Primary weight 2 for each character. */
  0xCF00,   /* U+4F00 */
  0x0000,   /* U+4F01 */
  0xCF02,   /* U+4F02 */
  0xCF03,   /* U+4F03 */
  0xCF04,   /* U+4F04 */
  0xCF05,   /* U+4F05 */
  0xCF06,   /* U+4F06 */
  0xCF07,   /* U+4F07 */
  0xCF08,   /* U+4F08 */
  0x0000,   /* U+4F09 */
  0x0000,   /* U+4F0A */
  0xCF0B,   /* U+4F0B */
  0xCF0C,   /* U+4F0C */
  0x0000,   /* U+4F0D */
  0x0000,   /* U+4F0E */
  0x0000,   /* U+4F0F */
  0x0000,   /* U+4F10 */
  0x0000,   /* U+4F11 */
  0xCF12,   /* U+4F12 */
  0xCF13,   /* U+4F13 */
  0xCF14,   /* U+4F14 */
  0xCF15,   /* U+4F15 */
  0xCF16,   /* U+4F16 */
  0xCF17,   /* U+4F17 */
  0xCF18,   /* U+4F18 */
  0xCF19,   /* U+4F19 */
  0x0000,   /* U+4F1A */
  0xCF1B,   /* U+4F1B */
  0x0000,   /* U+4F1C */
  0x0000,   /* U+4F1D */
  0xCF1E,   /* U+4F1E */
  0xCF1F,   /* U+4F1F */
  0xCF20,   /* U+4F20 */
  0xCF21,   /* U+4F21 */
  0xCF22,   /* U+4F22 */
  0xCF23,   /* U+4F23 */
  0xCF24,   /* U+4F24 */
  0xCF25,   /* U+4F25 */
  0xCF26,   /* U+4F26 */
  0xCF27,   /* U+4F27 */
  0xCF28,   /* U+4F28 */
  0xCF29,   /* U+4F29 */
  0xCF2A,   /* U+4F2A */
  0xCF2B,   /* U+4F2B */
  0xCF2C,   /* U+4F2C */
  0xCF2D,   /* U+4F2D */
  0xCF2E,   /* U+4F2E */
  0x0000,   /* U+4F2F */
  0x0000,   /* U+4F30 */
  0xCF31,   /* U+4F31 */
  0xCF32,   /* U+4F32 */
  0xCF33,   /* U+4F33 */
  0x0000,   /* U+4F34 */
  0xCF35,   /* U+4F35 */
  0x0000,   /* U+4F36 */
  0xCF37,   /* U+4F37 */
  0x0000,   /* U+4F38 */
  0xCF39,   /* U+4F39 */
  0x0000,   /* U+4F3A */
  0xCF3B,   /* U+4F3B */
  0x0000,   /* U+4F3C */
  0x0000,   /* U+4F3D */
  0xCF3E,   /* U+4F3E */
  0xCF3F,   /* U+4F3F */
  0xCF40,   /* U+4F40 */
  0xCF41,   /* U+4F41 */
  0xCF42,   /* U+4F42 */
  0x0000,   /* U+4F43 */
  0xCF44,   /* U+4F44 */
  0xCF45,   /* U+4F45 */
  0x0000,   /* U+4F46 */
  0x0000,   /* U+4F47 */
  0xCF48,   /* U+4F48 */
  0xCF49,   /* U+4F49 */
  0xCF4A,   /* U+4F4A */
  0xCF4B,   /* U+4F4B */
  0xCF4C,   /* U+4F4C */
  0x0000,   /* U+4F4D */
  0x0000,   /* U+4F4E */
  0x0000,   /* U+4F4F */
  0x0000,   /* U+4F50 */
  0x0000,   /* U+4F51 */
  0xCF52,   /* U+4F52 */
  0x0000,   /* U+4F53 */
  0xCF54,   /* U+4F54 */
  0x0000,   /* U+4F55 */
  0xCF56,   /* U+4F56 */
  0x0000,   /* U+4F57 */
  0xCF58,   /* U+4F58 */
  0x0000,   /* U+4F59 */
  0x0000,   /* U+4F5A */
  0x0000,   /* U+4F5B */
  0x0000,   /* U+4F5C */
  0x0000,   /* U+4F5D */
  0x0000,   /* U+4F5E */
  0xCF5F,   /* U+4F5F */
  0xCF60,   /* U+4F60 */
  0xCF61,   /* U+4F61 */
  0xCF62,   /* U+4F62 */
  0xCF63,   /* U+4F63 */
  0xCF64,   /* U+4F64 */
  0xCF65,   /* U+4F65 */
  0xCF66,   /* U+4F66 */
  0xCF67,   /* U+4F67 */
  0xCF68,   /* U+4F68 */
  0x0000,   /* U+4F69 */
  0xCF6A,   /* U+4F6A */
  0xCF6B,   /* U+4F6B */
  0xCF6C,   /* U+4F6C */
  0xCF6D,   /* U+4F6D */
  0xCF6E,   /* U+4F6E */
  0x0000,   /* U+4F6F */
  0x0000,   /* U+4F70 */
  0xCF71,   /* U+4F71 */
  0xCF72,   /* U+4F72 */
  0x0000,   /* U+4F73 */
  0xCF74,   /* U+4F74 */
  0x0000,   /* U+4F75 */
  0x0000,   /* U+4F76 */
  0xCF77,   /* U+4F77 */
  0xCF78,   /* U+4F78 */
  0xCF79,   /* U+4F79 */
  0xCF7A,   /* U+4F7A */
  0x0000,   /* U+4F7B */
  0x0000,   /* U+4F7C */
  0xCF7D,   /* U+4F7D */
  0xCF7E,   /* U+4F7E */
  0x0000,   /* U+4F7F */
  0xCF80,   /* U+4F80 */
  0xCF81,   /* U+4F81 */
  0xCF82,   /* U+4F82 */
  0x0000,   /* U+4F83 */
  0xCF84,   /* U+4F84 */
  0xCF85,   /* U+4F85 */
  0x0000,   /* U+4F86 */
  0xCF87,   /* U+4F87 */
  0x0000,   /* U+4F88 */
  0xCF89,   /* U+4F89 */
  0xCF8A,   /* U+4F8A */
  0x0000,   /* U+4F8B */
  0xCF8C,   /* U+4F8C */
  0x0000,   /* U+4F8D */
  0xCF8E,   /* U+4F8E */
  0x0000,   /* U+4F8F */
  0xCF90,   /* U+4F90 */
  0x0000,   /* U+4F91 */
  0xCF92,   /* U+4F92 */
  0xCF93,   /* U+4F93 */
  0xCF94,   /* U+4F94 */
  0xCF95,   /* U+4F95 */
  0x0000,   /* U+4F96 */
  0xCF97,   /* U+4F97 */
  0x0000,   /* U+4F98 */
  0xCF99,   /* U+4F99 */
  0xCF9A,   /* U+4F9A */
  0x0000,   /* U+4F9B */
  0xCF9C,   /* U+4F9C */
  0x0000,   /* U+4F9D */
  0xCF9E,   /* U+4F9E */
  0xCF9F,   /* U+4F9F */
  0x0000,   /* U+4FA0 */
  0x0000,   /* U+4FA1 */
  0xCFA2,   /* U+4FA2 */
  0xCFA3,   /* U+4FA3 */
  0xCFA4,   /* U+4FA4 */
  0xCFA5,   /* U+4FA5 */
  0xCFA6,   /* U+4FA6 */
  0xCFA7,   /* U+4FA7 */
  0xCFA8,   /* U+4FA8 */
  0xCFA9,   /* U+4FA9 */
  0xCFAA,   /* U+4FAA */
  0x0000,   /* U+4FAB */
  0xCFAC,   /* U+4FAC */
  0x0000,   /* U+4FAD */
  0x0000,   /* U+4FAE */
  0x0000,   /* U+4FAF */
  0xCFB0,   /* U+4FB0 */
  0xCFB1,   /* U+4FB1 */
  0xCFB2,   /* U+4FB2 */
  0xCFB3,   /* U+4FB3 */
  0xCFB4,   /* U+4FB4 */
  0x0000,   /* U+4FB5 */
  0x0000,   /* U+4FB6 */
  0xCFB7,   /* U+4FB7 */
  0xCFB8,   /* U+4FB8 */
  0xCFB9,   /* U+4FB9 */
  0xCFBA,   /* U+4FBA */
  0xCFBB,   /* U+4FBB */
  0xCFBC,   /* U+4FBC */
  0xCFBD,   /* U+4FBD */
  0xCFBE,   /* U+4FBE */
  0x0000,   /* U+4FBF */
  0xCFC0,   /* U+4FC0 */
  0xCFC1,   /* U+4FC1 */
  0x0000,   /* U+4FC2 */
  0x0000,   /* U+4FC3 */
  0x0000,   /* U+4FC4 */
  0xCFC5,   /* U+4FC5 */
  0xCFC6,   /* U+4FC6 */
  0xCFC7,   /* U+4FC7 */
  0xCFC8,   /* U+4FC8 */
  0xCFC9,   /* U+4FC9 */
  0x0000,   /* U+4FCA */
  0xCFCB,   /* U+4FCB */
  0xCFCC,   /* U+4FCC */
  0xCFCD,   /* U+4FCD */
  0x0000,   /* U+4FCE */
  0xCFCF,   /* U+4FCF */
  0x0000,   /* U+4FD0 */
  0x0000,   /* U+4FD1 */
  0xCFD2,   /* U+4FD2 */
  0xCFD3,   /* U+4FD3 */
  0x0000,   /* U+4FD4 */
  0xCFD5,   /* U+4FD5 */
  0xCFD6,   /* U+4FD6 */
  0x0000,   /* U+4FD7 */
  0x0000,   /* U+4FD8 */
  0xCFD9,   /* U+4FD9 */
  0x0000,   /* U+4FDA */
  0x0000,   /* U+4FDB */
  0xCFDC,   /* U+4FDC */
  0x0000,   /* U+4FDD */
  0xCFDE,   /* U+4FDE */
  0x0000,   /* U+4FDF */
  0xCFE0,   /* U+4FE0 */
  0x0000,   /* U+4FE1 */
  0xCFE2,   /* U+4FE2 */
  0x0000,   /* U+4FE3 */
  0x0000,   /* U+4FE4 */
  0x0000,   /* U+4FE5 */
  0xCFE6,   /* U+4FE6 */
  0xCFE7,   /* U+4FE7 */
  0xCFE8,   /* U+4FE8 */
  0xCFE9,   /* U+4FE9 */
  0xCFEA,   /* U+4FEA */
  0xCFEB,   /* U+4FEB */
  0xCFEC,   /* U+4FEC */
  0xCFED,   /* U+4FED */
  0x0000,   /* U+4FEE */
  0x0000,   /* U+4FEF */
  0xCFF0,   /* U+4FF0 */
  0xCFF1,   /* U+4FF1 */
  0xCFF2,   /* U+4FF2 */
  0x0000,   /* U+4FF3 */
  0xCFF4,   /* U+4FF4 */
  0x0000,   /* U+4FF5 */
  0x0000,   /* U+4FF6 */
  0xCFF7,   /* U+4FF7 */
  0x0000,   /* U+4FF8 */
  0xCFF9,   /* U+4FF9 */
  0x0000,   /* U+4FFA */
  0xCFFB,   /* U+4FFB */
  0xCFFC,   /* U+4FFC */
  0xCFFD,   /* U+4FFD */
  0x0000,   /* U+4FFE */
  0xCFFF,   /* U+4FFF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+4F00 */
  0x0000,   /* U+4F01 */
  0x0000,   /* U+4F02 */
  0x0000,   /* U+4F03 */
  0x0000,   /* U+4F04 */
  0x0000,   /* U+4F05 */
  0x0000,   /* U+4F06 */
  0x0000,   /* U+4F07 */
  0x0000,   /* U+4F08 */
  0x0000,   /* U+4F09 */
  0x0000,   /* U+4F0A */
  0x0000,   /* U+4F0B */
  0x0000,   /* U+4F0C */
  0x0000,   /* U+4F0D */
  0x0000,   /* U+4F0E */
  0x0000,   /* U+4F0F */
  0x0000,   /* U+4F10 */
  0x0000,   /* U+4F11 */
  0x0000,   /* U+4F12 */
  0x0000,   /* U+4F13 */
  0x0000,   /* U+4F14 */
  0x0000,   /* U+4F15 */
  0x0000,   /* U+4F16 */
  0x0000,   /* U+4F17 */
  0x0000,   /* U+4F18 */
  0x0000,   /* U+4F19 */
  0x0000,   /* U+4F1A */
  0x0000,   /* U+4F1B */
  0x0000,   /* U+4F1C */
  0x0000,   /* U+4F1D */
  0x0000,   /* U+4F1E */
  0x0000,   /* U+4F1F */
  0x0000,   /* U+4F20 */
  0x0000,   /* U+4F21 */
  0x0000,   /* U+4F22 */
  0x0000,   /* U+4F23 */
  0x0000,   /* U+4F24 */
  0x0000,   /* U+4F25 */
  0x0000,   /* U+4F26 */
  0x0000,   /* U+4F27 */
  0x0000,   /* U+4F28 */
  0x0000,   /* U+4F29 */
  0x0000,   /* U+4F2A */
  0x0000,   /* U+4F2B */
  0x0000,   /* U+4F2C */
  0x0000,   /* U+4F2D */
  0x0000,   /* U+4F2E */
  0x0000,   /* U+4F2F */
  0x0000,   /* U+4F30 */
  0x0000,   /* U+4F31 */
  0x0000,   /* U+4F32 */
  0x0000,   /* U+4F33 */
  0x0000,   /* U+4F34 */
  0x0000,   /* U+4F35 */
  0x0000,   /* U+4F36 */
  0x0000,   /* U+4F37 */
  0x0000,   /* U+4F38 */
  0x0000,   /* U+4F39 */
  0x0000,   /* U+4F3A */
  0x0000,   /* U+4F3B */
  0x0000,   /* U+4F3C */
  0x0000,   /* U+4F3D */
  0x0000,   /* U+4F3E */
  0x0000,   /* U+4F3F */
  0x0000,   /* U+4F40 */
  0x0000,   /* U+4F41 */
  0x0000,   /* U+4F42 */
  0x0000,   /* U+4F43 */
  0x0000,   /* U+4F44 */
  0x0000,   /* U+4F45 */
  0x0000,   /* U+4F46 */
  0x0000,   /* U+4F47 */
  0x0000,   /* U+4F48 */
  0x0000,   /* U+4F49 */
  0x0000,   /* U+4F4A */
  0x0000,   /* U+4F4B */
  0x0000,   /* U+4F4C */
  0x0000,   /* U+4F4D */
  0x0000,   /* U+4F4E */
  0x0000,   /* U+4F4F */
  0x0000,   /* U+4F50 */
  0x0000,   /* U+4F51 */
  0x0000,   /* U+4F52 */
  0x0000,   /* U+4F53 */
  0x0000,   /* U+4F54 */
  0x0000,   /* U+4F55 */
  0x0000,   /* U+4F56 */
  0x0000,   /* U+4F57 */
  0x0000,   /* U+4F58 */
  0x0000,   /* U+4F59 */
  0x0000,   /* U+4F5A */
  0x0000,   /* U+4F5B */
  0x0000,   /* U+4F5C */
  0x0000,   /* U+4F5D */
  0x0000,   /* U+4F5E */
  0x0000,   /* U+4F5F */
  0x0000,   /* U+4F60 */
  0x0000,   /* U+4F61 */
  0x0000,   /* U+4F62 */
  0x0000,   /* U+4F63 */
  0x0000,   /* U+4F64 */
  0x0000,   /* U+4F65 */
  0x0000,   /* U+4F66 */
  0x0000,   /* U+4F67 */
  0x0000,   /* U+4F68 */
  0x0000,   /* U+4F69 */
  0x0000,   /* U+4F6A */
  0x0000,   /* U+4F6B */
  0x0000,   /* U+4F6C */
  0x0000,   /* U+4F6D */
  0x0000,   /* U+4F6E */
  0x0000,   /* U+4F6F */
  0x0000,   /* U+4F70 */
  0x0000,   /* U+4F71 */
  0x0000,   /* U+4F72 */
  0x0000,   /* U+4F73 */
  0x0000,   /* U+4F74 */
  0x0000,   /* U+4F75 */
  0x0000,   /* U+4F76 */
  0x0000,   /* U+4F77 */
  0x0000,   /* U+4F78 */
  0x0000,   /* U+4F79 */
  0x0000,   /* U+4F7A */
  0x0000,   /* U+4F7B */
  0x0000,   /* U+4F7C */
  0x0000,   /* U+4F7D */
  0x0000,   /* U+4F7E */
  0x0000,   /* U+4F7F */
  0x0000,   /* U+4F80 */
  0x0000,   /* U+4F81 */
  0x0000,   /* U+4F82 */
  0x0000,   /* U+4F83 */
  0x0000,   /* U+4F84 */
  0x0000,   /* U+4F85 */
  0x0000,   /* U+4F86 */
  0x0000,   /* U+4F87 */
  0x0000,   /* U+4F88 */
  0x0000,   /* U+4F89 */
  0x0000,   /* U+4F8A */
  0x0000,   /* U+4F8B */
  0x0000,   /* U+4F8C */
  0x0000,   /* U+4F8D */
  0x0000,   /* U+4F8E */
  0x0000,   /* U+4F8F */
  0x0000,   /* U+4F90 */
  0x0000,   /* U+4F91 */
  0x0000,   /* U+4F92 */
  0x0000,   /* U+4F93 */
  0x0000,   /* U+4F94 */
  0x0000,   /* U+4F95 */
  0x0000,   /* U+4F96 */
  0x0000,   /* U+4F97 */
  0x0000,   /* U+4F98 */
  0x0000,   /* U+4F99 */
  0x0000,   /* U+4F9A */
  0x0000,   /* U+4F9B */
  0x0000,   /* U+4F9C */
  0x0000,   /* U+4F9D */
  0x0000,   /* U+4F9E */
  0x0000,   /* U+4F9F */
  0x0000,   /* U+4FA0 */
  0x0000,   /* U+4FA1 */
  0x0000,   /* U+4FA2 */
  0x0000,   /* U+4FA3 */
  0x0000,   /* U+4FA4 */
  0x0000,   /* U+4FA5 */
  0x0000,   /* U+4FA6 */
  0x0000,   /* U+4FA7 */
  0x0000,   /* U+4FA8 */
  0x0000,   /* U+4FA9 */
  0x0000,   /* U+4FAA */
  0x0000,   /* U+4FAB */
  0x0000,   /* U+4FAC */
  0x0000,   /* U+4FAD */
  0x0000,   /* U+4FAE */
  0x0000,   /* U+4FAF */
  0x0000,   /* U+4FB0 */
  0x0000,   /* U+4FB1 */
  0x0000,   /* U+4FB2 */
  0x0000,   /* U+4FB3 */
  0x0000,   /* U+4FB4 */
  0x0000,   /* U+4FB5 */
  0x0000,   /* U+4FB6 */
  0x0000,   /* U+4FB7 */
  0x0000,   /* U+4FB8 */
  0x0000,   /* U+4FB9 */
  0x0000,   /* U+4FBA */
  0x0000,   /* U+4FBB */
  0x0000,   /* U+4FBC */
  0x0000,   /* U+4FBD */
  0x0000,   /* U+4FBE */
  0x0000,   /* U+4FBF */
  0x0000,   /* U+4FC0 */
  0x0000,   /* U+4FC1 */
  0x0000,   /* U+4FC2 */
  0x0000,   /* U+4FC3 */
  0x0000,   /* U+4FC4 */
  0x0000,   /* U+4FC5 */
  0x0000,   /* U+4FC6 */
  0x0000,   /* U+4FC7 */
  0x0000,   /* U+4FC8 */
  0x0000,   /* U+4FC9 */
  0x0000,   /* U+4FCA */
  0x0000,   /* U+4FCB */
  0x0000,   /* U+4FCC */
  0x0000,   /* U+4FCD */
  0x0000,   /* U+4FCE */
  0x0000,   /* U+4FCF */
  0x0000,   /* U+4FD0 */
  0x0000,   /* U+4FD1 */
  0x0000,   /* U+4FD2 */
  0x0000,   /* U+4FD3 */
  0x0000,   /* U+4FD4 */
  0x0000,   /* U+4FD5 */
  0x0000,   /* U+4FD6 */
  0x0000,   /* U+4FD7 */
  0x0000,   /* U+4FD8 */
  0x0000,   /* U+4FD9 */
  0x0000,   /* U+4FDA */
  0x0000,   /* U+4FDB */
  0x0000,   /* U+4FDC */
  0x0000,   /* U+4FDD */
  0x0000,   /* U+4FDE */
  0x0000,   /* U+4FDF */
  0x0000,   /* U+4FE0 */
  0x0000,   /* U+4FE1 */
  0x0000,   /* U+4FE2 */
  0x0000,   /* U+4FE3 */
  0x0000,   /* U+4FE4 */
  0x0000,   /* U+4FE5 */
  0x0000,   /* U+4FE6 */
  0x0000,   /* U+4FE7 */
  0x0000,   /* U+4FE8 */
  0x0000,   /* U+4FE9 */
  0x0000,   /* U+4FEA */
  0x0000,   /* U+4FEB */
  0x0000,   /* U+4FEC */
  0x0000,   /* U+4FED */
  0x0000,   /* U+4FEE */
  0x0000,   /* U+4FEF */
  0x0000,   /* U+4FF0 */
  0x0000,   /* U+4FF1 */
  0x0000,   /* U+4FF2 */
  0x0000,   /* U+4FF3 */
  0x0000,   /* U+4FF4 */
  0x0000,   /* U+4FF5 */
  0x0000,   /* U+4FF6 */
  0x0000,   /* U+4FF7 */
  0x0000,   /* U+4FF8 */
  0x0000,   /* U+4FF9 */
  0x0000,   /* U+4FFA */
  0x0000,   /* U+4FFB */
  0x0000,   /* U+4FFC */
  0x0000,   /* U+4FFD */
  0x0000,   /* U+4FFE */
  0x0000,   /* U+4FFF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+4F00 */
  0x0000,   /* U+4F01 */
  0x0000,   /* U+4F02 */
  0x0000,   /* U+4F03 */
  0x0000,   /* U+4F04 */
  0x0000,   /* U+4F05 */
  0x0000,   /* U+4F06 */
  0x0000,   /* U+4F07 */
  0x0000,   /* U+4F08 */
  0x0000,   /* U+4F09 */
  0x0000,   /* U+4F0A */
  0x0000,   /* U+4F0B */
  0x0000,   /* U+4F0C */
  0x0000,   /* U+4F0D */
  0x0000,   /* U+4F0E */
  0x0000,   /* U+4F0F */
  0x0000,   /* U+4F10 */
  0x0000,   /* U+4F11 */
  0x0000,   /* U+4F12 */
  0x0000,   /* U+4F13 */
  0x0000,   /* U+4F14 */
  0x0000,   /* U+4F15 */
  0x0000,   /* U+4F16 */
  0x0000,   /* U+4F17 */
  0x0000,   /* U+4F18 */
  0x0000,   /* U+4F19 */
  0x0000,   /* U+4F1A */
  0x0000,   /* U+4F1B */
  0x0000,   /* U+4F1C */
  0x0000,   /* U+4F1D */
  0x0000,   /* U+4F1E */
  0x0000,   /* U+4F1F */
  0x0000,   /* U+4F20 */
  0x0000,   /* U+4F21 */
  0x0000,   /* U+4F22 */
  0x0000,   /* U+4F23 */
  0x0000,   /* U+4F24 */
  0x0000,   /* U+4F25 */
  0x0000,   /* U+4F26 */
  0x0000,   /* U+4F27 */
  0x0000,   /* U+4F28 */
  0x0000,   /* U+4F29 */
  0x0000,   /* U+4F2A */
  0x0000,   /* U+4F2B */
  0x0000,   /* U+4F2C */
  0x0000,   /* U+4F2D */
  0x0000,   /* U+4F2E */
  0x0000,   /* U+4F2F */
  0x0000,   /* U+4F30 */
  0x0000,   /* U+4F31 */
  0x0000,   /* U+4F32 */
  0x0000,   /* U+4F33 */
  0x0000,   /* U+4F34 */
  0x0000,   /* U+4F35 */
  0x0000,   /* U+4F36 */
  0x0000,   /* U+4F37 */
  0x0000,   /* U+4F38 */
  0x0000,   /* U+4F39 */
  0x0000,   /* U+4F3A */
  0x0000,   /* U+4F3B */
  0x0000,   /* U+4F3C */
  0x0000,   /* U+4F3D */
  0x0000,   /* U+4F3E */
  0x0000,   /* U+4F3F */
  0x0000,   /* U+4F40 */
  0x0000,   /* U+4F41 */
  0x0000,   /* U+4F42 */
  0x0000,   /* U+4F43 */
  0x0000,   /* U+4F44 */
  0x0000,   /* U+4F45 */
  0x0000,   /* U+4F46 */
  0x0000,   /* U+4F47 */
  0x0000,   /* U+4F48 */
  0x0000,   /* U+4F49 */
  0x0000,   /* U+4F4A */
  0x0000,   /* U+4F4B */
  0x0000,   /* U+4F4C */
  0x0000,   /* U+4F4D */
  0x0000,   /* U+4F4E */
  0x0000,   /* U+4F4F */
  0x0000,   /* U+4F50 */
  0x0000,   /* U+4F51 */
  0x0000,   /* U+4F52 */
  0x0000,   /* U+4F53 */
  0x0000,   /* U+4F54 */
  0x0000,   /* U+4F55 */
  0x0000,   /* U+4F56 */
  0x0000,   /* U+4F57 */
  0x0000,   /* U+4F58 */
  0x0000,   /* U+4F59 */
  0x0000,   /* U+4F5A */
  0x0000,   /* U+4F5B */
  0x0000,   /* U+4F5C */
  0x0000,   /* U+4F5D */
  0x0000,   /* U+4F5E */
  0x0000,   /* U+4F5F */
  0x0000,   /* U+4F60 */
  0x0000,   /* U+4F61 */
  0x0000,   /* U+4F62 */
  0x0000,   /* U+4F63 */
  0x0000,   /* U+4F64 */
  0x0000,   /* U+4F65 */
  0x0000,   /* U+4F66 */
  0x0000,   /* U+4F67 */
  0x0000,   /* U+4F68 */
  0x0000,   /* U+4F69 */
  0x0000,   /* U+4F6A */
  0x0000,   /* U+4F6B */
  0x0000,   /* U+4F6C */
  0x0000,   /* U+4F6D */
  0x0000,   /* U+4F6E */
  0x0000,   /* U+4F6F */
  0x0000,   /* U+4F70 */
  0x0000,   /* U+4F71 */
  0x0000,   /* U+4F72 */
  0x0000,   /* U+4F73 */
  0x0000,   /* U+4F74 */
  0x0000,   /* U+4F75 */
  0x0000,   /* U+4F76 */
  0x0000,   /* U+4F77 */
  0x0000,   /* U+4F78 */
  0x0000,   /* U+4F79 */
  0x0000,   /* U+4F7A */
  0x0000,   /* U+4F7B */
  0x0000,   /* U+4F7C */
  0x0000,   /* U+4F7D */
  0x0000,   /* U+4F7E */
  0x0000,   /* U+4F7F */
  0x0000,   /* U+4F80 */
  0x0000,   /* U+4F81 */
  0x0000,   /* U+4F82 */
  0x0000,   /* U+4F83 */
  0x0000,   /* U+4F84 */
  0x0000,   /* U+4F85 */
  0x0000,   /* U+4F86 */
  0x0000,   /* U+4F87 */
  0x0000,   /* U+4F88 */
  0x0000,   /* U+4F89 */
  0x0000,   /* U+4F8A */
  0x0000,   /* U+4F8B */
  0x0000,   /* U+4F8C */
  0x0000,   /* U+4F8D */
  0x0000,   /* U+4F8E */
  0x0000,   /* U+4F8F */
  0x0000,   /* U+4F90 */
  0x0000,   /* U+4F91 */
  0x0000,   /* U+4F92 */
  0x0000,   /* U+4F93 */
  0x0000,   /* U+4F94 */
  0x0000,   /* U+4F95 */
  0x0000,   /* U+4F96 */
  0x0000,   /* U+4F97 */
  0x0000,   /* U+4F98 */
  0x0000,   /* U+4F99 */
  0x0000,   /* U+4F9A */
  0x0000,   /* U+4F9B */
  0x0000,   /* U+4F9C */
  0x0000,   /* U+4F9D */
  0x0000,   /* U+4F9E */
  0x0000,   /* U+4F9F */
  0x0000,   /* U+4FA0 */
  0x0000,   /* U+4FA1 */
  0x0000,   /* U+4FA2 */
  0x0000,   /* U+4FA3 */
  0x0000,   /* U+4FA4 */
  0x0000,   /* U+4FA5 */
  0x0000,   /* U+4FA6 */
  0x0000,   /* U+4FA7 */
  0x0000,   /* U+4FA8 */
  0x0000,   /* U+4FA9 */
  0x0000,   /* U+4FAA */
  0x0000,   /* U+4FAB */
  0x0000,   /* U+4FAC */
  0x0000,   /* U+4FAD */
  0x0000,   /* U+4FAE */
  0x0000,   /* U+4FAF */
  0x0000,   /* U+4FB0 */
  0x0000,   /* U+4FB1 */
  0x0000,   /* U+4FB2 */
  0x0000,   /* U+4FB3 */
  0x0000,   /* U+4FB4 */
  0x0000,   /* U+4FB5 */
  0x0000,   /* U+4FB6 */
  0x0000,   /* U+4FB7 */
  0x0000,   /* U+4FB8 */
  0x0000,   /* U+4FB9 */
  0x0000,   /* U+4FBA */
  0x0000,   /* U+4FBB */
  0x0000,   /* U+4FBC */
  0x0000,   /* U+4FBD */
  0x0000,   /* U+4FBE */
  0x0000,   /* U+4FBF */
  0x0000,   /* U+4FC0 */
  0x0000,   /* U+4FC1 */
  0x0000,   /* U+4FC2 */
  0x0000,   /* U+4FC3 */
  0x0000,   /* U+4FC4 */
  0x0000,   /* U+4FC5 */
  0x0000,   /* U+4FC6 */
  0x0000,   /* U+4FC7 */
  0x0000,   /* U+4FC8 */
  0x0000,   /* U+4FC9 */
  0x0000,   /* U+4FCA */
  0x0000,   /* U+4FCB */
  0x0000,   /* U+4FCC */
  0x0000,   /* U+4FCD */
  0x0000,   /* U+4FCE */
  0x0000,   /* U+4FCF */
  0x0000,   /* U+4FD0 */
  0x0000,   /* U+4FD1 */
  0x0000,   /* U+4FD2 */
  0x0000,   /* U+4FD3 */
  0x0000,   /* U+4FD4 */
  0x0000,   /* U+4FD5 */
  0x0000,   /* U+4FD6 */
  0x0000,   /* U+4FD7 */
  0x0000,   /* U+4FD8 */
  0x0000,   /* U+4FD9 */
  0x0000,   /* U+4FDA */
  0x0000,   /* U+4FDB */
  0x0000,   /* U+4FDC */
  0x0000,   /* U+4FDD */
  0x0000,   /* U+4FDE */
  0x0000,   /* U+4FDF */
  0x0000,   /* U+4FE0 */
  0x0000,   /* U+4FE1 */
  0x0000,   /* U+4FE2 */
  0x0000,   /* U+4FE3 */
  0x0000,   /* U+4FE4 */
  0x0000,   /* U+4FE5 */
  0x0000,   /* U+4FE6 */
  0x0000,   /* U+4FE7 */
  0x0000,   /* U+4FE8 */
  0x0000,   /* U+4FE9 */
  0x0000,   /* U+4FEA */
  0x0000,   /* U+4FEB */
  0x0000,   /* U+4FEC */
  0x0000,   /* U+4FED */
  0x0000,   /* U+4FEE */
  0x0000,   /* U+4FEF */
  0x0000,   /* U+4FF0 */
  0x0000,   /* U+4FF1 */
  0x0000,   /* U+4FF2 */
  0x0000,   /* U+4FF3 */
  0x0000,   /* U+4FF4 */
  0x0000,   /* U+4FF5 */
  0x0000,   /* U+4FF6 */
  0x0000,   /* U+4FF7 */
  0x0000,   /* U+4FF8 */
  0x0000,   /* U+4FF9 */
  0x0000,   /* U+4FFA */
  0x0000,   /* U+4FFB */
  0x0000,   /* U+4FFC */
  0x0000,   /* U+4FFD */
  0x0000,   /* U+4FFE */
  0x0000,   /* U+4FFF */
};

uint16 ja_han_page50[]= {
  /* Number of CEs for each character. */
  2, 2, 2, 2, 2, 1, 1, 2, 2, 1, 2, 1, 2, 1, 2, 1,
  2, 1, 1, 2, 1, 2, 1, 2, 2, 1, 1, 2, 2, 2, 2, 1,
  2, 1, 2, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 2, 2,
  2, 2, 2, 2, 2, 2, 1, 2, 2, 1, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 1, 2, 2, 2, 1, 1, 1, 2, 2, 2, 2, 2, 1,
  1, 2, 2, 2, 2, 1, 1, 2, 2, 2, 1, 2, 1, 2, 2, 2,
  2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2,
  2, 2, 1, 2, 1, 1, 1, 2, 1, 2, 2, 2, 2, 1, 2, 2,
  1, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2,
  2, 1, 2, 2, 2, 2, 2, 2, 1, 1, 1, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 2, 2,
  2, 2, 1, 1, 1, 1, 2, 1, 2, 2, 2, 2, 2, 2, 1, 2,
  2, 2, 1, 2, 2, 1, 2, 2, 2, 1, 1, 2, 2, 1, 2, 1,
  2, 1, 2, 2, 2, 1, 1, 2, 2, 2, 1, 2, 2, 2, 1, 2,
  2, 2, 2, 1, 2, 1, 2, 1, 2, 2, 2, 2, 2, 1, 1, 2,
  2, 2, 2, 2, 2, 1, 2, 2, 2, 1, 2, 1, 2, 2, 2, 2,

  /* Primary weight 1 for each character. */
  0xFB40,   /* U+5000 */
  0xFB40,   /* U+5001 */
  0xFB40,   /* U+5002 */
  0xFB40,   /* U+5003 */
  0xFB40,   /* U+5004 */
  0x607E,   /* U+5005 */
  0x6087,   /* U+5006 */
  0xFB40,   /* U+5007 */
  0xFB40,   /* U+5008 */
  0x5B13,   /* U+5009 */
  0xFB40,   /* U+500A */
  0x57B7,   /* U+500B */
  0xFB40,   /* U+500C */
  0x5D51,   /* U+500D */
  0xFB40,   /* U+500E */
  0x663F,   /* U+500F */
  0xFB40,   /* U+5010 */
  0x6086,   /* U+5011 */
  0x5C96,   /* U+5012 */
  0xFB40,   /* U+5013 */
  0x607B,   /* U+5014 */
  0xFB40,   /* U+5015 */
  0x57E9,   /* U+5016 */
  0xFB40,   /* U+5017 */
  0xFB40,   /* U+5018 */
  0x57E8,   /* U+5019 */
  0x6079,   /* U+501A */
  0xFB40,   /* U+501B */
  0xFB40,   /* U+501C */
  0xFB40,   /* U+501D */
  0xFB40,   /* U+501E */
  0x5945,   /* U+501F */
  0xFB40,   /* U+5020 */
  0x6081,   /* U+5021 */
  0xFB40,   /* U+5022 */
  0x5E7E,   /* U+5023 */
  0x5BCA,   /* U+5024 */
  0x607D,   /* U+5025 */
  0x5786,   /* U+5026 */
  0xFB40,   /* U+5027 */
  0x607A,   /* U+5028 */
  0x6082,   /* U+5029 */
  0x607C,   /* U+502A */
  0x5FD8,   /* U+502B */
  0x6083,   /* U+502C */
  0x6026,   /* U+502D */
  0xFB40,   /* U+502E */
  0xFB40,   /* U+502F */
  0xFB40,   /* U+5030 */
  0xFB40,   /* U+5031 */
  0xFB40,   /* U+5032 */
  0xFB40,   /* U+5033 */
  0xFB40,   /* U+5034 */
  0xFB40,   /* U+5035 */
  0x571D,   /* U+5036 */
  0xFB40,   /* U+5037 */
  0xFB40,   /* U+5038 */
  0x5785,   /* U+5039 */
  0xFB40,   /* U+503A */
  0xFB40,   /* U+503B */
  0xFB40,   /* U+503C */
  0xFB40,   /* U+503D */
  0xFB40,   /* U+503E */
  0xFB40,   /* U+503F */
  0xFB40,   /* U+5040 */
  0xFB40,   /* U+5041 */
  0xFB40,   /* U+5042 */
  0x6088,   /* U+5043 */
  0xFB40,   /* U+5044 */
  0xFB40,   /* U+5045 */
  0xFB40,   /* U+5046 */
  0x6089,   /* U+5047 */
  0x608D,   /* U+5048 */
  0x54D1,   /* U+5049 */
  0xFB40,   /* U+504A */
  0xFB40,   /* U+504B */
  0xFB40,   /* U+504C */
  0xFB40,   /* U+504D */
  0xFB40,   /* U+504E */
  0x5E5F,   /* U+504F */
  0x608C,   /* U+5050 */
  0xFB40,   /* U+5051 */
  0xFB40,   /* U+5052 */
  0xFB40,   /* U+5053 */
  0xFB40,   /* U+5054 */
  0x608B,   /* U+5055 */
  0x608F,   /* U+5056 */
  0xFB40,   /* U+5057 */
  0xFB40,   /* U+5058 */
  0xFB40,   /* U+5059 */
  0x608E,   /* U+505A */
  0xFB40,   /* U+505B */
  0x5C3F,   /* U+505C */
  0xFB40,   /* U+505D */
  0xFB40,   /* U+505E */
  0xFB40,   /* U+505F */
  0xFB40,   /* U+5060 */
  0xFB40,   /* U+5061 */
  0xFB40,   /* U+5062 */
  0xFB40,   /* U+5063 */
  0xFB40,   /* U+5064 */
  0x5787,   /* U+5065 */
  0xFB40,   /* U+5066 */
  0xFB40,   /* U+5067 */
  0xFB40,   /* U+5068 */
  0xFB40,   /* U+5069 */
  0xFB40,   /* U+506A */
  0xFB40,   /* U+506B */
  0x6090,   /* U+506C */
  0xFB40,   /* U+506D */
  0xFB40,   /* U+506E */
  0xFB40,   /* U+506F */
  0xFB40,   /* U+5070 */
  0xFB40,   /* U+5071 */
  0x5930,   /* U+5072 */
  0xFB40,   /* U+5073 */
  0x5B45,   /* U+5074 */
  0x5C40,   /* U+5075 */
  0x572D,   /* U+5076 */
  0xFB40,   /* U+5077 */
  0x6091,   /* U+5078 */
  0xFB40,   /* U+5079 */
  0xFB40,   /* U+507A */
  0xFB40,   /* U+507B */
  0xFB40,   /* U+507C */
  0x568F,   /* U+507D */
  0xFB40,   /* U+507E */
  0xFB40,   /* U+507F */
  0x6092,   /* U+5080 */
  0xFB40,   /* U+5081 */
  0xFB40,   /* U+5082 */
  0xFB40,   /* U+5083 */
  0xFB40,   /* U+5084 */
  0x6094,   /* U+5085 */
  0xFB40,   /* U+5086 */
  0xFB40,   /* U+5087 */
  0xFB40,   /* U+5088 */
  0xFB40,   /* U+5089 */
  0xFB40,   /* U+508A */
  0xFB40,   /* U+508B */
  0xFB40,   /* U+508C */
  0x5EA2,   /* U+508D */
  0xFB40,   /* U+508E */
  0xFB40,   /* U+508F */
  0xFB40,   /* U+5090 */
  0x577B,   /* U+5091 */
  0xFB40,   /* U+5092 */
  0xFB40,   /* U+5093 */
  0xFB40,   /* U+5094 */
  0xFB40,   /* U+5095 */
  0xFB40,   /* U+5096 */
  0xFB40,   /* U+5097 */
  0x58BE,   /* U+5098 */
  0x5DCA,   /* U+5099 */
  0x6093,   /* U+509A */
  0xFB40,   /* U+509B */
  0xFB40,   /* U+509C */
  0xFB40,   /* U+509D */
  0xFB40,   /* U+509E */
  0xFB40,   /* U+509F */
  0xFB40,   /* U+50A0 */
  0xFB40,   /* U+50A1 */
  0xFB40,   /* U+50A2 */
  0xFB40,   /* U+50A3 */
  0xFB40,   /* U+50A4 */
  0xFB40,   /* U+50A5 */
  0xFB40,   /* U+50A6 */
  0xFB40,   /* U+50A7 */
  0xFB40,   /* U+50A8 */
  0xFB40,   /* U+50A9 */
  0xFB40,   /* U+50AA */
  0xFB40,   /* U+50AB */
  0x5874,   /* U+50AC */
  0x5F6C,   /* U+50AD */
  0xFB40,   /* U+50AE */
  0xFB40,   /* U+50AF */
  0xFB40,   /* U+50B0 */
  0xFB40,   /* U+50B1 */
  0x6096,   /* U+50B2 */
  0x6099,   /* U+50B3 */
  0x6095,   /* U+50B4 */
  0x5873,   /* U+50B5 */
  0xFB40,   /* U+50B6 */
  0x59C6,   /* U+50B7 */
  0xFB40,   /* U+50B8 */
  0xFB40,   /* U+50B9 */
  0xFB40,   /* U+50BA */
  0xFB40,   /* U+50BB */
  0xFB40,   /* U+50BC */
  0xFB40,   /* U+50BD */
  0x574E,   /* U+50BE */
  0xFB40,   /* U+50BF */
  0xFB40,   /* U+50C0 */
  0xFB40,   /* U+50C1 */
  0x609A,   /* U+50C2 */
  0xFB40,   /* U+50C3 */
  0xFB40,   /* U+50C4 */
  0x5706,   /* U+50C5 */
  0xFB40,   /* U+50C6 */
  0xFB40,   /* U+50C7 */
  0xFB40,   /* U+50C8 */
  0x6097,   /* U+50C9 */
  0x6098,   /* U+50CA */
  0xFB40,   /* U+50CB */
  0xFB40,   /* U+50CC */
  0x5CC6,   /* U+50CD */
  0xFB40,   /* U+50CE */
  0x5B3D,   /* U+50CF */
  0xFB40,   /* U+50D0 */
  0x56DA,   /* U+50D1 */
  0xFB40,   /* U+50D2 */
  0xFB40,   /* U+50D3 */
  0xFB40,   /* U+50D4 */
  0x5EBA,   /* U+50D5 */
  0x609B,   /* U+50D6 */
  0xFB40,   /* U+50D7 */
  0xFB40,   /* U+50D8 */
  0xFB40,   /* U+50D9 */
  0x5FC4,   /* U+50DA */
  0xFB40,   /* U+50DB */
  0xFB40,   /* U+50DC */
  0xFB40,   /* U+50DD */
  0x609C,   /* U+50DE */
  0xFB40,   /* U+50DF */
  0xFB40,   /* U+50E0 */
  0xFB40,   /* U+50E1 */
  0xFB40,   /* U+50E2 */
  0x609F,   /* U+50E3 */
  0xFB40,   /* U+50E4 */
  0x609D,   /* U+50E5 */
  0xFB40,   /* U+50E6 */
  0x5B0F,   /* U+50E7 */
  0xFB40,   /* U+50E8 */
  0xFB40,   /* U+50E9 */
  0xFB40,   /* U+50EA */
  0xFB40,   /* U+50EB */
  0xFB40,   /* U+50EC */
  0x609E,   /* U+50ED */
  0x60A0,   /* U+50EE */
  0xFB40,   /* U+50EF */
  0xFB40,   /* U+50F0 */
  0xFB40,   /* U+50F1 */
  0xFB40,   /* U+50F2 */
  0xFB40,   /* U+50F3 */
  0xFB40,   /* U+50F4 */
  0x60A2,   /* U+50F5 */
  0xFB40,   /* U+50F6 */
  0xFB40,   /* U+50F7 */
  0xFB40,   /* U+50F8 */
  0x60A1,   /* U+50F9 */
  0xFB40,   /* U+50FA */
  0x5E57,   /* U+50FB */
  0xFB40,   /* U+50FC */
  0xFB40,   /* U+50FD */
  0xFB40,   /* U+50FE */
  0xFB40,   /* U+50FF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+5000 */
  0x0020,   /* U+5001 */
  0x0020,   /* U+5002 */
  0x0020,   /* U+5003 */
  0x0020,   /* U+5004 */
  0x0020,   /* U+5005 */
  0x0020,   /* U+5006 */
  0x0020,   /* U+5007 */
  0x0020,   /* U+5008 */
  0x0020,   /* U+5009 */
  0x0020,   /* U+500A */
  0x0020,   /* U+500B */
  0x0020,   /* U+500C */
  0x0020,   /* U+500D */
  0x0020,   /* U+500E */
  0x0020,   /* U+500F */
  0x0020,   /* U+5010 */
  0x0020,   /* U+5011 */
  0x0020,   /* U+5012 */
  0x0020,   /* U+5013 */
  0x0020,   /* U+5014 */
  0x0020,   /* U+5015 */
  0x0020,   /* U+5016 */
  0x0020,   /* U+5017 */
  0x0020,   /* U+5018 */
  0x0020,   /* U+5019 */
  0x0020,   /* U+501A */
  0x0020,   /* U+501B */
  0x0020,   /* U+501C */
  0x0020,   /* U+501D */
  0x0020,   /* U+501E */
  0x0020,   /* U+501F */
  0x0020,   /* U+5020 */
  0x0020,   /* U+5021 */
  0x0020,   /* U+5022 */
  0x0020,   /* U+5023 */
  0x0020,   /* U+5024 */
  0x0020,   /* U+5025 */
  0x0020,   /* U+5026 */
  0x0020,   /* U+5027 */
  0x0020,   /* U+5028 */
  0x0020,   /* U+5029 */
  0x0020,   /* U+502A */
  0x0020,   /* U+502B */
  0x0020,   /* U+502C */
  0x0020,   /* U+502D */
  0x0020,   /* U+502E */
  0x0020,   /* U+502F */
  0x0020,   /* U+5030 */
  0x0020,   /* U+5031 */
  0x0020,   /* U+5032 */
  0x0020,   /* U+5033 */
  0x0020,   /* U+5034 */
  0x0020,   /* U+5035 */
  0x0020,   /* U+5036 */
  0x0020,   /* U+5037 */
  0x0020,   /* U+5038 */
  0x0020,   /* U+5039 */
  0x0020,   /* U+503A */
  0x0020,   /* U+503B */
  0x0020,   /* U+503C */
  0x0020,   /* U+503D */
  0x0020,   /* U+503E */
  0x0020,   /* U+503F */
  0x0020,   /* U+5040 */
  0x0020,   /* U+5041 */
  0x0020,   /* U+5042 */
  0x0020,   /* U+5043 */
  0x0020,   /* U+5044 */
  0x0020,   /* U+5045 */
  0x0020,   /* U+5046 */
  0x0020,   /* U+5047 */
  0x0020,   /* U+5048 */
  0x0020,   /* U+5049 */
  0x0020,   /* U+504A */
  0x0020,   /* U+504B */
  0x0020,   /* U+504C */
  0x0020,   /* U+504D */
  0x0020,   /* U+504E */
  0x0020,   /* U+504F */
  0x0020,   /* U+5050 */
  0x0020,   /* U+5051 */
  0x0020,   /* U+5052 */
  0x0020,   /* U+5053 */
  0x0020,   /* U+5054 */
  0x0020,   /* U+5055 */
  0x0020,   /* U+5056 */
  0x0020,   /* U+5057 */
  0x0020,   /* U+5058 */
  0x0020,   /* U+5059 */
  0x0020,   /* U+505A */
  0x0020,   /* U+505B */
  0x0020,   /* U+505C */
  0x0020,   /* U+505D */
  0x0020,   /* U+505E */
  0x0020,   /* U+505F */
  0x0020,   /* U+5060 */
  0x0020,   /* U+5061 */
  0x0020,   /* U+5062 */
  0x0020,   /* U+5063 */
  0x0020,   /* U+5064 */
  0x0020,   /* U+5065 */
  0x0020,   /* U+5066 */
  0x0020,   /* U+5067 */
  0x0020,   /* U+5068 */
  0x0020,   /* U+5069 */
  0x0020,   /* U+506A */
  0x0020,   /* U+506B */
  0x0020,   /* U+506C */
  0x0020,   /* U+506D */
  0x0020,   /* U+506E */
  0x0020,   /* U+506F */
  0x0020,   /* U+5070 */
  0x0020,   /* U+5071 */
  0x0020,   /* U+5072 */
  0x0020,   /* U+5073 */
  0x0020,   /* U+5074 */
  0x0020,   /* U+5075 */
  0x0020,   /* U+5076 */
  0x0020,   /* U+5077 */
  0x0020,   /* U+5078 */
  0x0020,   /* U+5079 */
  0x0020,   /* U+507A */
  0x0020,   /* U+507B */
  0x0020,   /* U+507C */
  0x0020,   /* U+507D */
  0x0020,   /* U+507E */
  0x0020,   /* U+507F */
  0x0020,   /* U+5080 */
  0x0020,   /* U+5081 */
  0x0020,   /* U+5082 */
  0x0020,   /* U+5083 */
  0x0020,   /* U+5084 */
  0x0020,   /* U+5085 */
  0x0020,   /* U+5086 */
  0x0020,   /* U+5087 */
  0x0020,   /* U+5088 */
  0x0020,   /* U+5089 */
  0x0020,   /* U+508A */
  0x0020,   /* U+508B */
  0x0020,   /* U+508C */
  0x0020,   /* U+508D */
  0x0020,   /* U+508E */
  0x0020,   /* U+508F */
  0x0020,   /* U+5090 */
  0x0020,   /* U+5091 */
  0x0020,   /* U+5092 */
  0x0020,   /* U+5093 */
  0x0020,   /* U+5094 */
  0x0020,   /* U+5095 */
  0x0020,   /* U+5096 */
  0x0020,   /* U+5097 */
  0x0020,   /* U+5098 */
  0x0020,   /* U+5099 */
  0x0020,   /* U+509A */
  0x0020,   /* U+509B */
  0x0020,   /* U+509C */
  0x0020,   /* U+509D */
  0x0020,   /* U+509E */
  0x0020,   /* U+509F */
  0x0020,   /* U+50A0 */
  0x0020,   /* U+50A1 */
  0x0020,   /* U+50A2 */
  0x0020,   /* U+50A3 */
  0x0020,   /* U+50A4 */
  0x0020,   /* U+50A5 */
  0x0020,   /* U+50A6 */
  0x0020,   /* U+50A7 */
  0x0020,   /* U+50A8 */
  0x0020,   /* U+50A9 */
  0x0020,   /* U+50AA */
  0x0020,   /* U+50AB */
  0x0020,   /* U+50AC */
  0x0020,   /* U+50AD */
  0x0020,   /* U+50AE */
  0x0020,   /* U+50AF */
  0x0020,   /* U+50B0 */
  0x0020,   /* U+50B1 */
  0x0020,   /* U+50B2 */
  0x0020,   /* U+50B3 */
  0x0020,   /* U+50B4 */
  0x0020,   /* U+50B5 */
  0x0020,   /* U+50B6 */
  0x0020,   /* U+50B7 */
  0x0020,   /* U+50B8 */
  0x0020,   /* U+50B9 */
  0x0020,   /* U+50BA */
  0x0020,   /* U+50BB */
  0x0020,   /* U+50BC */
  0x0020,   /* U+50BD */
  0x0020,   /* U+50BE */
  0x0020,   /* U+50BF */
  0x0020,   /* U+50C0 */
  0x0020,   /* U+50C1 */
  0x0020,   /* U+50C2 */
  0x0020,   /* U+50C3 */
  0x0020,   /* U+50C4 */
  0x0020,   /* U+50C5 */
  0x0020,   /* U+50C6 */
  0x0020,   /* U+50C7 */
  0x0020,   /* U+50C8 */
  0x0020,   /* U+50C9 */
  0x0020,   /* U+50CA */
  0x0020,   /* U+50CB */
  0x0020,   /* U+50CC */
  0x0020,   /* U+50CD */
  0x0020,   /* U+50CE */
  0x0020,   /* U+50CF */
  0x0020,   /* U+50D0 */
  0x0020,   /* U+50D1 */
  0x0020,   /* U+50D2 */
  0x0020,   /* U+50D3 */
  0x0020,   /* U+50D4 */
  0x0020,   /* U+50D5 */
  0x0020,   /* U+50D6 */
  0x0020,   /* U+50D7 */
  0x0020,   /* U+50D8 */
  0x0020,   /* U+50D9 */
  0x0020,   /* U+50DA */
  0x0020,   /* U+50DB */
  0x0020,   /* U+50DC */
  0x0020,   /* U+50DD */
  0x0020,   /* U+50DE */
  0x0020,   /* U+50DF */
  0x0020,   /* U+50E0 */
  0x0020,   /* U+50E1 */
  0x0020,   /* U+50E2 */
  0x0020,   /* U+50E3 */
  0x0020,   /* U+50E4 */
  0x0020,   /* U+50E5 */
  0x0020,   /* U+50E6 */
  0x0020,   /* U+50E7 */
  0x0020,   /* U+50E8 */
  0x0020,   /* U+50E9 */
  0x0020,   /* U+50EA */
  0x0020,   /* U+50EB */
  0x0020,   /* U+50EC */
  0x0020,   /* U+50ED */
  0x0020,   /* U+50EE */
  0x0020,   /* U+50EF */
  0x0020,   /* U+50F0 */
  0x0020,   /* U+50F1 */
  0x0020,   /* U+50F2 */
  0x0020,   /* U+50F3 */
  0x0020,   /* U+50F4 */
  0x0020,   /* U+50F5 */
  0x0020,   /* U+50F6 */
  0x0020,   /* U+50F7 */
  0x0020,   /* U+50F8 */
  0x0020,   /* U+50F9 */
  0x0020,   /* U+50FA */
  0x0020,   /* U+50FB */
  0x0020,   /* U+50FC */
  0x0020,   /* U+50FD */
  0x0020,   /* U+50FE */
  0x0020,   /* U+50FF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+5000 */
  0x0002,   /* U+5001 */
  0x0002,   /* U+5002 */
  0x0002,   /* U+5003 */
  0x0002,   /* U+5004 */
  0x0002,   /* U+5005 */
  0x0002,   /* U+5006 */
  0x0002,   /* U+5007 */
  0x0002,   /* U+5008 */
  0x0002,   /* U+5009 */
  0x0002,   /* U+500A */
  0x0002,   /* U+500B */
  0x0002,   /* U+500C */
  0x0002,   /* U+500D */
  0x0002,   /* U+500E */
  0x0002,   /* U+500F */
  0x0002,   /* U+5010 */
  0x0002,   /* U+5011 */
  0x0002,   /* U+5012 */
  0x0002,   /* U+5013 */
  0x0002,   /* U+5014 */
  0x0002,   /* U+5015 */
  0x0002,   /* U+5016 */
  0x0002,   /* U+5017 */
  0x0002,   /* U+5018 */
  0x0002,   /* U+5019 */
  0x0002,   /* U+501A */
  0x0002,   /* U+501B */
  0x0002,   /* U+501C */
  0x0002,   /* U+501D */
  0x0002,   /* U+501E */
  0x0002,   /* U+501F */
  0x0002,   /* U+5020 */
  0x0002,   /* U+5021 */
  0x0002,   /* U+5022 */
  0x0002,   /* U+5023 */
  0x0002,   /* U+5024 */
  0x0002,   /* U+5025 */
  0x0002,   /* U+5026 */
  0x0002,   /* U+5027 */
  0x0002,   /* U+5028 */
  0x0002,   /* U+5029 */
  0x0002,   /* U+502A */
  0x0002,   /* U+502B */
  0x0002,   /* U+502C */
  0x0002,   /* U+502D */
  0x0002,   /* U+502E */
  0x0002,   /* U+502F */
  0x0002,   /* U+5030 */
  0x0002,   /* U+5031 */
  0x0002,   /* U+5032 */
  0x0002,   /* U+5033 */
  0x0002,   /* U+5034 */
  0x0002,   /* U+5035 */
  0x0002,   /* U+5036 */
  0x0002,   /* U+5037 */
  0x0002,   /* U+5038 */
  0x0002,   /* U+5039 */
  0x0002,   /* U+503A */
  0x0002,   /* U+503B */
  0x0002,   /* U+503C */
  0x0002,   /* U+503D */
  0x0002,   /* U+503E */
  0x0002,   /* U+503F */
  0x0002,   /* U+5040 */
  0x0002,   /* U+5041 */
  0x0002,   /* U+5042 */
  0x0002,   /* U+5043 */
  0x0002,   /* U+5044 */
  0x0002,   /* U+5045 */
  0x0002,   /* U+5046 */
  0x0002,   /* U+5047 */
  0x0002,   /* U+5048 */
  0x0002,   /* U+5049 */
  0x0002,   /* U+504A */
  0x0002,   /* U+504B */
  0x0002,   /* U+504C */
  0x0002,   /* U+504D */
  0x0002,   /* U+504E */
  0x0002,   /* U+504F */
  0x0002,   /* U+5050 */
  0x0002,   /* U+5051 */
  0x0002,   /* U+5052 */
  0x0002,   /* U+5053 */
  0x0002,   /* U+5054 */
  0x0002,   /* U+5055 */
  0x0002,   /* U+5056 */
  0x0002,   /* U+5057 */
  0x0002,   /* U+5058 */
  0x0002,   /* U+5059 */
  0x0002,   /* U+505A */
  0x0002,   /* U+505B */
  0x0002,   /* U+505C */
  0x0002,   /* U+505D */
  0x0002,   /* U+505E */
  0x0002,   /* U+505F */
  0x0002,   /* U+5060 */
  0x0002,   /* U+5061 */
  0x0002,   /* U+5062 */
  0x0002,   /* U+5063 */
  0x0002,   /* U+5064 */
  0x0002,   /* U+5065 */
  0x0002,   /* U+5066 */
  0x0002,   /* U+5067 */
  0x0002,   /* U+5068 */
  0x0002,   /* U+5069 */
  0x0002,   /* U+506A */
  0x0002,   /* U+506B */
  0x0002,   /* U+506C */
  0x0002,   /* U+506D */
  0x0002,   /* U+506E */
  0x0002,   /* U+506F */
  0x0002,   /* U+5070 */
  0x0002,   /* U+5071 */
  0x0002,   /* U+5072 */
  0x0002,   /* U+5073 */
  0x0002,   /* U+5074 */
  0x0002,   /* U+5075 */
  0x0002,   /* U+5076 */
  0x0002,   /* U+5077 */
  0x0002,   /* U+5078 */
  0x0002,   /* U+5079 */
  0x0002,   /* U+507A */
  0x0002,   /* U+507B */
  0x0002,   /* U+507C */
  0x0002,   /* U+507D */
  0x0002,   /* U+507E */
  0x0002,   /* U+507F */
  0x0002,   /* U+5080 */
  0x0002,   /* U+5081 */
  0x0002,   /* U+5082 */
  0x0002,   /* U+5083 */
  0x0002,   /* U+5084 */
  0x0002,   /* U+5085 */
  0x0002,   /* U+5086 */
  0x0002,   /* U+5087 */
  0x0002,   /* U+5088 */
  0x0002,   /* U+5089 */
  0x0002,   /* U+508A */
  0x0002,   /* U+508B */
  0x0002,   /* U+508C */
  0x0002,   /* U+508D */
  0x0002,   /* U+508E */
  0x0002,   /* U+508F */
  0x0002,   /* U+5090 */
  0x0002,   /* U+5091 */
  0x0002,   /* U+5092 */
  0x0002,   /* U+5093 */
  0x0002,   /* U+5094 */
  0x0002,   /* U+5095 */
  0x0002,   /* U+5096 */
  0x0002,   /* U+5097 */
  0x0002,   /* U+5098 */
  0x0002,   /* U+5099 */
  0x0002,   /* U+509A */
  0x0002,   /* U+509B */
  0x0002,   /* U+509C */
  0x0002,   /* U+509D */
  0x0002,   /* U+509E */
  0x0002,   /* U+509F */
  0x0002,   /* U+50A0 */
  0x0002,   /* U+50A1 */
  0x0002,   /* U+50A2 */
  0x0002,   /* U+50A3 */
  0x0002,   /* U+50A4 */
  0x0002,   /* U+50A5 */
  0x0002,   /* U+50A6 */
  0x0002,   /* U+50A7 */
  0x0002,   /* U+50A8 */
  0x0002,   /* U+50A9 */
  0x0002,   /* U+50AA */
  0x0002,   /* U+50AB */
  0x0002,   /* U+50AC */
  0x0002,   /* U+50AD */
  0x0002,   /* U+50AE */
  0x0002,   /* U+50AF */
  0x0002,   /* U+50B0 */
  0x0002,   /* U+50B1 */
  0x0002,   /* U+50B2 */
  0x0002,   /* U+50B3 */
  0x0002,   /* U+50B4 */
  0x0002,   /* U+50B5 */
  0x0002,   /* U+50B6 */
  0x0002,   /* U+50B7 */
  0x0002,   /* U+50B8 */
  0x0002,   /* U+50B9 */
  0x0002,   /* U+50BA */
  0x0002,   /* U+50BB */
  0x0002,   /* U+50BC */
  0x0002,   /* U+50BD */
  0x0002,   /* U+50BE */
  0x0002,   /* U+50BF */
  0x0002,   /* U+50C0 */
  0x0002,   /* U+50C1 */
  0x0002,   /* U+50C2 */
  0x0002,   /* U+50C3 */
  0x0002,   /* U+50C4 */
  0x0002,   /* U+50C5 */
  0x0002,   /* U+50C6 */
  0x0002,   /* U+50C7 */
  0x0002,   /* U+50C8 */
  0x0002,   /* U+50C9 */
  0x0002,   /* U+50CA */
  0x0002,   /* U+50CB */
  0x0002,   /* U+50CC */
  0x0002,   /* U+50CD */
  0x0002,   /* U+50CE */
  0x0002,   /* U+50CF */
  0x0002,   /* U+50D0 */
  0x0002,   /* U+50D1 */
  0x0002,   /* U+50D2 */
  0x0002,   /* U+50D3 */
  0x0002,   /* U+50D4 */
  0x0002,   /* U+50D5 */
  0x0002,   /* U+50D6 */
  0x0002,   /* U+50D7 */
  0x0002,   /* U+50D8 */
  0x0002,   /* U+50D9 */
  0x0002,   /* U+50DA */
  0x0002,   /* U+50DB */
  0x0002,   /* U+50DC */
  0x0002,   /* U+50DD */
  0x0002,   /* U+50DE */
  0x0002,   /* U+50DF */
  0x0002,   /* U+50E0 */
  0x0002,   /* U+50E1 */
  0x0002,   /* U+50E2 */
  0x0002,   /* U+50E3 */
  0x0002,   /* U+50E4 */
  0x0002,   /* U+50E5 */
  0x0002,   /* U+50E6 */
  0x0002,   /* U+50E7 */
  0x0002,   /* U+50E8 */
  0x0002,   /* U+50E9 */
  0x0002,   /* U+50EA */
  0x0002,   /* U+50EB */
  0x0002,   /* U+50EC */
  0x0002,   /* U+50ED */
  0x0002,   /* U+50EE */
  0x0002,   /* U+50EF */
  0x0002,   /* U+50F0 */
  0x0002,   /* U+50F1 */
  0x0002,   /* U+50F2 */
  0x0002,   /* U+50F3 */
  0x0002,   /* U+50F4 */
  0x0002,   /* U+50F5 */
  0x0002,   /* U+50F6 */
  0x0002,   /* U+50F7 */
  0x0002,   /* U+50F8 */
  0x0002,   /* U+50F9 */
  0x0002,   /* U+50FA */
  0x0002,   /* U+50FB */
  0x0002,   /* U+50FC */
  0x0002,   /* U+50FD */
  0x0002,   /* U+50FE */
  0x0002,   /* U+50FF */

  /* Primary weight 2 for each character. */
  0xD000,   /* U+5000 */
  0xD001,   /* U+5001 */
  0xD002,   /* U+5002 */
  0xD003,   /* U+5003 */
  0xD004,   /* U+5004 */
  0x0000,   /* U+5005 */
  0x0000,   /* U+5006 */
  0xD007,   /* U+5007 */
  0xD008,   /* U+5008 */
  0x0000,   /* U+5009 */
  0xD00A,   /* U+500A */
  0x0000,   /* U+500B */
  0xD00C,   /* U+500C */
  0x0000,   /* U+500D */
  0xD00E,   /* U+500E */
  0x0000,   /* U+500F */
  0xD010,   /* U+5010 */
  0x0000,   /* U+5011 */
  0x0000,   /* U+5012 */
  0xD013,   /* U+5013 */
  0x0000,   /* U+5014 */
  0xD015,   /* U+5015 */
  0x0000,   /* U+5016 */
  0xD017,   /* U+5017 */
  0xD018,   /* U+5018 */
  0x0000,   /* U+5019 */
  0x0000,   /* U+501A */
  0xD01B,   /* U+501B */
  0xD01C,   /* U+501C */
  0xD01D,   /* U+501D */
  0xD01E,   /* U+501E */
  0x0000,   /* U+501F */
  0xD020,   /* U+5020 */
  0x0000,   /* U+5021 */
  0xD022,   /* U+5022 */
  0x0000,   /* U+5023 */
  0x0000,   /* U+5024 */
  0x0000,   /* U+5025 */
  0x0000,   /* U+5026 */
  0xD027,   /* U+5027 */
  0x0000,   /* U+5028 */
  0x0000,   /* U+5029 */
  0x0000,   /* U+502A */
  0x0000,   /* U+502B */
  0x0000,   /* U+502C */
  0x0000,   /* U+502D */
  0xD02E,   /* U+502E */
  0xD02F,   /* U+502F */
  0xD030,   /* U+5030 */
  0xD031,   /* U+5031 */
  0xD032,   /* U+5032 */
  0xD033,   /* U+5033 */
  0xD034,   /* U+5034 */
  0xD035,   /* U+5035 */
  0x0000,   /* U+5036 */
  0xD037,   /* U+5037 */
  0xD038,   /* U+5038 */
  0x0000,   /* U+5039 */
  0xD03A,   /* U+503A */
  0xD03B,   /* U+503B */
  0xD03C,   /* U+503C */
  0xD03D,   /* U+503D */
  0xD03E,   /* U+503E */
  0xD03F,   /* U+503F */
  0xD040,   /* U+5040 */
  0xD041,   /* U+5041 */
  0xD042,   /* U+5042 */
  0x0000,   /* U+5043 */
  0xD044,   /* U+5044 */
  0xD045,   /* U+5045 */
  0xD046,   /* U+5046 */
  0x0000,   /* U+5047 */
  0x0000,   /* U+5048 */
  0x0000,   /* U+5049 */
  0xD04A,   /* U+504A */
  0xD04B,   /* U+504B */
  0xD04C,   /* U+504C */
  0xD04D,   /* U+504D */
  0xD04E,   /* U+504E */
  0x0000,   /* U+504F */
  0x0000,   /* U+5050 */
  0xD051,   /* U+5051 */
  0xD052,   /* U+5052 */
  0xD053,   /* U+5053 */
  0xD054,   /* U+5054 */
  0x0000,   /* U+5055 */
  0x0000,   /* U+5056 */
  0xD057,   /* U+5057 */
  0xD058,   /* U+5058 */
  0xD059,   /* U+5059 */
  0x0000,   /* U+505A */
  0xD05B,   /* U+505B */
  0x0000,   /* U+505C */
  0xD05D,   /* U+505D */
  0xD05E,   /* U+505E */
  0xD05F,   /* U+505F */
  0xD060,   /* U+5060 */
  0xD061,   /* U+5061 */
  0xD062,   /* U+5062 */
  0xD063,   /* U+5063 */
  0xD064,   /* U+5064 */
  0x0000,   /* U+5065 */
  0xD066,   /* U+5066 */
  0xD067,   /* U+5067 */
  0xD068,   /* U+5068 */
  0xD069,   /* U+5069 */
  0xD06A,   /* U+506A */
  0xD06B,   /* U+506B */
  0x0000,   /* U+506C */
  0xD06D,   /* U+506D */
  0xD06E,   /* U+506E */
  0xD06F,   /* U+506F */
  0xD070,   /* U+5070 */
  0xD071,   /* U+5071 */
  0x0000,   /* U+5072 */
  0xD073,   /* U+5073 */
  0x0000,   /* U+5074 */
  0x0000,   /* U+5075 */
  0x0000,   /* U+5076 */
  0xD077,   /* U+5077 */
  0x0000,   /* U+5078 */
  0xD079,   /* U+5079 */
  0xD07A,   /* U+507A */
  0xD07B,   /* U+507B */
  0xD07C,   /* U+507C */
  0x0000,   /* U+507D */
  0xD07E,   /* U+507E */
  0xD07F,   /* U+507F */
  0x0000,   /* U+5080 */
  0xD081,   /* U+5081 */
  0xD082,   /* U+5082 */
  0xD083,   /* U+5083 */
  0xD084,   /* U+5084 */
  0x0000,   /* U+5085 */
  0xD086,   /* U+5086 */
  0xD087,   /* U+5087 */
  0xD088,   /* U+5088 */
  0xD089,   /* U+5089 */
  0xD08A,   /* U+508A */
  0xD08B,   /* U+508B */
  0xD08C,   /* U+508C */
  0x0000,   /* U+508D */
  0xD08E,   /* U+508E */
  0xD08F,   /* U+508F */
  0xD090,   /* U+5090 */
  0x0000,   /* U+5091 */
  0xD092,   /* U+5092 */
  0xD093,   /* U+5093 */
  0xD094,   /* U+5094 */
  0xD095,   /* U+5095 */
  0xD096,   /* U+5096 */
  0xD097,   /* U+5097 */
  0x0000,   /* U+5098 */
  0x0000,   /* U+5099 */
  0x0000,   /* U+509A */
  0xD09B,   /* U+509B */
  0xD09C,   /* U+509C */
  0xD09D,   /* U+509D */
  0xD09E,   /* U+509E */
  0xD09F,   /* U+509F */
  0xD0A0,   /* U+50A0 */
  0xD0A1,   /* U+50A1 */
  0xD0A2,   /* U+50A2 */
  0xD0A3,   /* U+50A3 */
  0xD0A4,   /* U+50A4 */
  0xD0A5,   /* U+50A5 */
  0xD0A6,   /* U+50A6 */
  0xD0A7,   /* U+50A7 */
  0xD0A8,   /* U+50A8 */
  0xD0A9,   /* U+50A9 */
  0xD0AA,   /* U+50AA */
  0xD0AB,   /* U+50AB */
  0x0000,   /* U+50AC */
  0x0000,   /* U+50AD */
  0xD0AE,   /* U+50AE */
  0xD0AF,   /* U+50AF */
  0xD0B0,   /* U+50B0 */
  0xD0B1,   /* U+50B1 */
  0x0000,   /* U+50B2 */
  0x0000,   /* U+50B3 */
  0x0000,   /* U+50B4 */
  0x0000,   /* U+50B5 */
  0xD0B6,   /* U+50B6 */
  0x0000,   /* U+50B7 */
  0xD0B8,   /* U+50B8 */
  0xD0B9,   /* U+50B9 */
  0xD0BA,   /* U+50BA */
  0xD0BB,   /* U+50BB */
  0xD0BC,   /* U+50BC */
  0xD0BD,   /* U+50BD */
  0x0000,   /* U+50BE */
  0xD0BF,   /* U+50BF */
  0xD0C0,   /* U+50C0 */
  0xD0C1,   /* U+50C1 */
  0x0000,   /* U+50C2 */
  0xD0C3,   /* U+50C3 */
  0xD0C4,   /* U+50C4 */
  0x0000,   /* U+50C5 */
  0xD0C6,   /* U+50C6 */
  0xD0C7,   /* U+50C7 */
  0xD0C8,   /* U+50C8 */
  0x0000,   /* U+50C9 */
  0x0000,   /* U+50CA */
  0xD0CB,   /* U+50CB */
  0xD0CC,   /* U+50CC */
  0x0000,   /* U+50CD */
  0xD0CE,   /* U+50CE */
  0x0000,   /* U+50CF */
  0xD0D0,   /* U+50D0 */
  0x0000,   /* U+50D1 */
  0xD0D2,   /* U+50D2 */
  0xD0D3,   /* U+50D3 */
  0xD0D4,   /* U+50D4 */
  0x0000,   /* U+50D5 */
  0x0000,   /* U+50D6 */
  0xD0D7,   /* U+50D7 */
  0xD0D8,   /* U+50D8 */
  0xD0D9,   /* U+50D9 */
  0x0000,   /* U+50DA */
  0xD0DB,   /* U+50DB */
  0xD0DC,   /* U+50DC */
  0xD0DD,   /* U+50DD */
  0x0000,   /* U+50DE */
  0xD0DF,   /* U+50DF */
  0xD0E0,   /* U+50E0 */
  0xD0E1,   /* U+50E1 */
  0xD0E2,   /* U+50E2 */
  0x0000,   /* U+50E3 */
  0xD0E4,   /* U+50E4 */
  0x0000,   /* U+50E5 */
  0xD0E6,   /* U+50E6 */
  0x0000,   /* U+50E7 */
  0xD0E8,   /* U+50E8 */
  0xD0E9,   /* U+50E9 */
  0xD0EA,   /* U+50EA */
  0xD0EB,   /* U+50EB */
  0xD0EC,   /* U+50EC */
  0x0000,   /* U+50ED */
  0x0000,   /* U+50EE */
  0xD0EF,   /* U+50EF */
  0xD0F0,   /* U+50F0 */
  0xD0F1,   /* U+50F1 */
  0xD0F2,   /* U+50F2 */
  0xD0F3,   /* U+50F3 */
  0xD0F4,   /* U+50F4 */
  0x0000,   /* U+50F5 */
  0xD0F6,   /* U+50F6 */
  0xD0F7,   /* U+50F7 */
  0xD0F8,   /* U+50F8 */
  0x0000,   /* U+50F9 */
  0xD0FA,   /* U+50FA */
  0x0000,   /* U+50FB */
  0xD0FC,   /* U+50FC */
  0xD0FD,   /* U+50FD */
  0xD0FE,   /* U+50FE */
  0xD0FF,   /* U+50FF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+5000 */
  0x0000,   /* U+5001 */
  0x0000,   /* U+5002 */
  0x0000,   /* U+5003 */
  0x0000,   /* U+5004 */
  0x0000,   /* U+5005 */
  0x0000,   /* U+5006 */
  0x0000,   /* U+5007 */
  0x0000,   /* U+5008 */
  0x0000,   /* U+5009 */
  0x0000,   /* U+500A */
  0x0000,   /* U+500B */
  0x0000,   /* U+500C */
  0x0000,   /* U+500D */
  0x0000,   /* U+500E */
  0x0000,   /* U+500F */
  0x0000,   /* U+5010 */
  0x0000,   /* U+5011 */
  0x0000,   /* U+5012 */
  0x0000,   /* U+5013 */
  0x0000,   /* U+5014 */
  0x0000,   /* U+5015 */
  0x0000,   /* U+5016 */
  0x0000,   /* U+5017 */
  0x0000,   /* U+5018 */
  0x0000,   /* U+5019 */
  0x0000,   /* U+501A */
  0x0000,   /* U+501B */
  0x0000,   /* U+501C */
  0x0000,   /* U+501D */
  0x0000,   /* U+501E */
  0x0000,   /* U+501F */
  0x0000,   /* U+5020 */
  0x0000,   /* U+5021 */
  0x0000,   /* U+5022 */
  0x0000,   /* U+5023 */
  0x0000,   /* U+5024 */
  0x0000,   /* U+5025 */
  0x0000,   /* U+5026 */
  0x0000,   /* U+5027 */
  0x0000,   /* U+5028 */
  0x0000,   /* U+5029 */
  0x0000,   /* U+502A */
  0x0000,   /* U+502B */
  0x0000,   /* U+502C */
  0x0000,   /* U+502D */
  0x0000,   /* U+502E */
  0x0000,   /* U+502F */
  0x0000,   /* U+5030 */
  0x0000,   /* U+5031 */
  0x0000,   /* U+5032 */
  0x0000,   /* U+5033 */
  0x0000,   /* U+5034 */
  0x0000,   /* U+5035 */
  0x0000,   /* U+5036 */
  0x0000,   /* U+5037 */
  0x0000,   /* U+5038 */
  0x0000,   /* U+5039 */
  0x0000,   /* U+503A */
  0x0000,   /* U+503B */
  0x0000,   /* U+503C */
  0x0000,   /* U+503D */
  0x0000,   /* U+503E */
  0x0000,   /* U+503F */
  0x0000,   /* U+5040 */
  0x0000,   /* U+5041 */
  0x0000,   /* U+5042 */
  0x0000,   /* U+5043 */
  0x0000,   /* U+5044 */
  0x0000,   /* U+5045 */
  0x0000,   /* U+5046 */
  0x0000,   /* U+5047 */
  0x0000,   /* U+5048 */
  0x0000,   /* U+5049 */
  0x0000,   /* U+504A */
  0x0000,   /* U+504B */
  0x0000,   /* U+504C */
  0x0000,   /* U+504D */
  0x0000,   /* U+504E */
  0x0000,   /* U+504F */
  0x0000,   /* U+5050 */
  0x0000,   /* U+5051 */
  0x0000,   /* U+5052 */
  0x0000,   /* U+5053 */
  0x0000,   /* U+5054 */
  0x0000,   /* U+5055 */
  0x0000,   /* U+5056 */
  0x0000,   /* U+5057 */
  0x0000,   /* U+5058 */
  0x0000,   /* U+5059 */
  0x0000,   /* U+505A */
  0x0000,   /* U+505B */
  0x0000,   /* U+505C */
  0x0000,   /* U+505D */
  0x0000,   /* U+505E */
  0x0000,   /* U+505F */
  0x0000,   /* U+5060 */
  0x0000,   /* U+5061 */
  0x0000,   /* U+5062 */
  0x0000,   /* U+5063 */
  0x0000,   /* U+5064 */
  0x0000,   /* U+5065 */
  0x0000,   /* U+5066 */
  0x0000,   /* U+5067 */
  0x0000,   /* U+5068 */
  0x0000,   /* U+5069 */
  0x0000,   /* U+506A */
  0x0000,   /* U+506B */
  0x0000,   /* U+506C */
  0x0000,   /* U+506D */
  0x0000,   /* U+506E */
  0x0000,   /* U+506F */
  0x0000,   /* U+5070 */
  0x0000,   /* U+5071 */
  0x0000,   /* U+5072 */
  0x0000,   /* U+5073 */
  0x0000,   /* U+5074 */
  0x0000,   /* U+5075 */
  0x0000,   /* U+5076 */
  0x0000,   /* U+5077 */
  0x0000,   /* U+5078 */
  0x0000,   /* U+5079 */
  0x0000,   /* U+507A */
  0x0000,   /* U+507B */
  0x0000,   /* U+507C */
  0x0000,   /* U+507D */
  0x0000,   /* U+507E */
  0x0000,   /* U+507F */
  0x0000,   /* U+5080 */
  0x0000,   /* U+5081 */
  0x0000,   /* U+5082 */
  0x0000,   /* U+5083 */
  0x0000,   /* U+5084 */
  0x0000,   /* U+5085 */
  0x0000,   /* U+5086 */
  0x0000,   /* U+5087 */
  0x0000,   /* U+5088 */
  0x0000,   /* U+5089 */
  0x0000,   /* U+508A */
  0x0000,   /* U+508B */
  0x0000,   /* U+508C */
  0x0000,   /* U+508D */
  0x0000,   /* U+508E */
  0x0000,   /* U+508F */
  0x0000,   /* U+5090 */
  0x0000,   /* U+5091 */
  0x0000,   /* U+5092 */
  0x0000,   /* U+5093 */
  0x0000,   /* U+5094 */
  0x0000,   /* U+5095 */
  0x0000,   /* U+5096 */
  0x0000,   /* U+5097 */
  0x0000,   /* U+5098 */
  0x0000,   /* U+5099 */
  0x0000,   /* U+509A */
  0x0000,   /* U+509B */
  0x0000,   /* U+509C */
  0x0000,   /* U+509D */
  0x0000,   /* U+509E */
  0x0000,   /* U+509F */
  0x0000,   /* U+50A0 */
  0x0000,   /* U+50A1 */
  0x0000,   /* U+50A2 */
  0x0000,   /* U+50A3 */
  0x0000,   /* U+50A4 */
  0x0000,   /* U+50A5 */
  0x0000,   /* U+50A6 */
  0x0000,   /* U+50A7 */
  0x0000,   /* U+50A8 */
  0x0000,   /* U+50A9 */
  0x0000,   /* U+50AA */
  0x0000,   /* U+50AB */
  0x0000,   /* U+50AC */
  0x0000,   /* U+50AD */
  0x0000,   /* U+50AE */
  0x0000,   /* U+50AF */
  0x0000,   /* U+50B0 */
  0x0000,   /* U+50B1 */
  0x0000,   /* U+50B2 */
  0x0000,   /* U+50B3 */
  0x0000,   /* U+50B4 */
  0x0000,   /* U+50B5 */
  0x0000,   /* U+50B6 */
  0x0000,   /* U+50B7 */
  0x0000,   /* U+50B8 */
  0x0000,   /* U+50B9 */
  0x0000,   /* U+50BA */
  0x0000,   /* U+50BB */
  0x0000,   /* U+50BC */
  0x0000,   /* U+50BD */
  0x0000,   /* U+50BE */
  0x0000,   /* U+50BF */
  0x0000,   /* U+50C0 */
  0x0000,   /* U+50C1 */
  0x0000,   /* U+50C2 */
  0x0000,   /* U+50C3 */
  0x0000,   /* U+50C4 */
  0x0000,   /* U+50C5 */
  0x0000,   /* U+50C6 */
  0x0000,   /* U+50C7 */
  0x0000,   /* U+50C8 */
  0x0000,   /* U+50C9 */
  0x0000,   /* U+50CA */
  0x0000,   /* U+50CB */
  0x0000,   /* U+50CC */
  0x0000,   /* U+50CD */
  0x0000,   /* U+50CE */
  0x0000,   /* U+50CF */
  0x0000,   /* U+50D0 */
  0x0000,   /* U+50D1 */
  0x0000,   /* U+50D2 */
  0x0000,   /* U+50D3 */
  0x0000,   /* U+50D4 */
  0x0000,   /* U+50D5 */
  0x0000,   /* U+50D6 */
  0x0000,   /* U+50D7 */
  0x0000,   /* U+50D8 */
  0x0000,   /* U+50D9 */
  0x0000,   /* U+50DA */
  0x0000,   /* U+50DB */
  0x0000,   /* U+50DC */
  0x0000,   /* U+50DD */
  0x0000,   /* U+50DE */
  0x0000,   /* U+50DF */
  0x0000,   /* U+50E0 */
  0x0000,   /* U+50E1 */
  0x0000,   /* U+50E2 */
  0x0000,   /* U+50E3 */
  0x0000,   /* U+50E4 */
  0x0000,   /* U+50E5 */
  0x0000,   /* U+50E6 */
  0x0000,   /* U+50E7 */
  0x0000,   /* U+50E8 */
  0x0000,   /* U+50E9 */
  0x0000,   /* U+50EA */
  0x0000,   /* U+50EB */
  0x0000,   /* U+50EC */
  0x0000,   /* U+50ED */
  0x0000,   /* U+50EE */
  0x0000,   /* U+50EF */
  0x0000,   /* U+50F0 */
  0x0000,   /* U+50F1 */
  0x0000,   /* U+50F2 */
  0x0000,   /* U+50F3 */
  0x0000,   /* U+50F4 */
  0x0000,   /* U+50F5 */
  0x0000,   /* U+50F6 */
  0x0000,   /* U+50F7 */
  0x0000,   /* U+50F8 */
  0x0000,   /* U+50F9 */
  0x0000,   /* U+50FA */
  0x0000,   /* U+50FB */
  0x0000,   /* U+50FC */
  0x0000,   /* U+50FD */
  0x0000,   /* U+50FE */
  0x0000,   /* U+50FF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+5000 */
  0x0000,   /* U+5001 */
  0x0000,   /* U+5002 */
  0x0000,   /* U+5003 */
  0x0000,   /* U+5004 */
  0x0000,   /* U+5005 */
  0x0000,   /* U+5006 */
  0x0000,   /* U+5007 */
  0x0000,   /* U+5008 */
  0x0000,   /* U+5009 */
  0x0000,   /* U+500A */
  0x0000,   /* U+500B */
  0x0000,   /* U+500C */
  0x0000,   /* U+500D */
  0x0000,   /* U+500E */
  0x0000,   /* U+500F */
  0x0000,   /* U+5010 */
  0x0000,   /* U+5011 */
  0x0000,   /* U+5012 */
  0x0000,   /* U+5013 */
  0x0000,   /* U+5014 */
  0x0000,   /* U+5015 */
  0x0000,   /* U+5016 */
  0x0000,   /* U+5017 */
  0x0000,   /* U+5018 */
  0x0000,   /* U+5019 */
  0x0000,   /* U+501A */
  0x0000,   /* U+501B */
  0x0000,   /* U+501C */
  0x0000,   /* U+501D */
  0x0000,   /* U+501E */
  0x0000,   /* U+501F */
  0x0000,   /* U+5020 */
  0x0000,   /* U+5021 */
  0x0000,   /* U+5022 */
  0x0000,   /* U+5023 */
  0x0000,   /* U+5024 */
  0x0000,   /* U+5025 */
  0x0000,   /* U+5026 */
  0x0000,   /* U+5027 */
  0x0000,   /* U+5028 */
  0x0000,   /* U+5029 */
  0x0000,   /* U+502A */
  0x0000,   /* U+502B */
  0x0000,   /* U+502C */
  0x0000,   /* U+502D */
  0x0000,   /* U+502E */
  0x0000,   /* U+502F */
  0x0000,   /* U+5030 */
  0x0000,   /* U+5031 */
  0x0000,   /* U+5032 */
  0x0000,   /* U+5033 */
  0x0000,   /* U+5034 */
  0x0000,   /* U+5035 */
  0x0000,   /* U+5036 */
  0x0000,   /* U+5037 */
  0x0000,   /* U+5038 */
  0x0000,   /* U+5039 */
  0x0000,   /* U+503A */
  0x0000,   /* U+503B */
  0x0000,   /* U+503C */
  0x0000,   /* U+503D */
  0x0000,   /* U+503E */
  0x0000,   /* U+503F */
  0x0000,   /* U+5040 */
  0x0000,   /* U+5041 */
  0x0000,   /* U+5042 */
  0x0000,   /* U+5043 */
  0x0000,   /* U+5044 */
  0x0000,   /* U+5045 */
  0x0000,   /* U+5046 */
  0x0000,   /* U+5047 */
  0x0000,   /* U+5048 */
  0x0000,   /* U+5049 */
  0x0000,   /* U+504A */
  0x0000,   /* U+504B */
  0x0000,   /* U+504C */
  0x0000,   /* U+504D */
  0x0000,   /* U+504E */
  0x0000,   /* U+504F */
  0x0000,   /* U+5050 */
  0x0000,   /* U+5051 */
  0x0000,   /* U+5052 */
  0x0000,   /* U+5053 */
  0x0000,   /* U+5054 */
  0x0000,   /* U+5055 */
  0x0000,   /* U+5056 */
  0x0000,   /* U+5057 */
  0x0000,   /* U+5058 */
  0x0000,   /* U+5059 */
  0x0000,   /* U+505A */
  0x0000,   /* U+505B */
  0x0000,   /* U+505C */
  0x0000,   /* U+505D */
  0x0000,   /* U+505E */
  0x0000,   /* U+505F */
  0x0000,   /* U+5060 */
  0x0000,   /* U+5061 */
  0x0000,   /* U+5062 */
  0x0000,   /* U+5063 */
  0x0000,   /* U+5064 */
  0x0000,   /* U+5065 */
  0x0000,   /* U+5066 */
  0x0000,   /* U+5067 */
  0x0000,   /* U+5068 */
  0x0000,   /* U+5069 */
  0x0000,   /* U+506A */
  0x0000,   /* U+506B */
  0x0000,   /* U+506C */
  0x0000,   /* U+506D */
  0x0000,   /* U+506E */
  0x0000,   /* U+506F */
  0x0000,   /* U+5070 */
  0x0000,   /* U+5071 */
  0x0000,   /* U+5072 */
  0x0000,   /* U+5073 */
  0x0000,   /* U+5074 */
  0x0000,   /* U+5075 */
  0x0000,   /* U+5076 */
  0x0000,   /* U+5077 */
  0x0000,   /* U+5078 */
  0x0000,   /* U+5079 */
  0x0000,   /* U+507A */
  0x0000,   /* U+507B */
  0x0000,   /* U+507C */
  0x0000,   /* U+507D */
  0x0000,   /* U+507E */
  0x0000,   /* U+507F */
  0x0000,   /* U+5080 */
  0x0000,   /* U+5081 */
  0x0000,   /* U+5082 */
  0x0000,   /* U+5083 */
  0x0000,   /* U+5084 */
  0x0000,   /* U+5085 */
  0x0000,   /* U+5086 */
  0x0000,   /* U+5087 */
  0x0000,   /* U+5088 */
  0x0000,   /* U+5089 */
  0x0000,   /* U+508A */
  0x0000,   /* U+508B */
  0x0000,   /* U+508C */
  0x0000,   /* U+508D */
  0x0000,   /* U+508E */
  0x0000,   /* U+508F */
  0x0000,   /* U+5090 */
  0x0000,   /* U+5091 */
  0x0000,   /* U+5092 */
  0x0000,   /* U+5093 */
  0x0000,   /* U+5094 */
  0x0000,   /* U+5095 */
  0x0000,   /* U+5096 */
  0x0000,   /* U+5097 */
  0x0000,   /* U+5098 */
  0x0000,   /* U+5099 */
  0x0000,   /* U+509A */
  0x0000,   /* U+509B */
  0x0000,   /* U+509C */
  0x0000,   /* U+509D */
  0x0000,   /* U+509E */
  0x0000,   /* U+509F */
  0x0000,   /* U+50A0 */
  0x0000,   /* U+50A1 */
  0x0000,   /* U+50A2 */
  0x0000,   /* U+50A3 */
  0x0000,   /* U+50A4 */
  0x0000,   /* U+50A5 */
  0x0000,   /* U+50A6 */
  0x0000,   /* U+50A7 */
  0x0000,   /* U+50A8 */
  0x0000,   /* U+50A9 */
  0x0000,   /* U+50AA */
  0x0000,   /* U+50AB */
  0x0000,   /* U+50AC */
  0x0000,   /* U+50AD */
  0x0000,   /* U+50AE */
  0x0000,   /* U+50AF */
  0x0000,   /* U+50B0 */
  0x0000,   /* U+50B1 */
  0x0000,   /* U+50B2 */
  0x0000,   /* U+50B3 */
  0x0000,   /* U+50B4 */
  0x0000,   /* U+50B5 */
  0x0000,   /* U+50B6 */
  0x0000,   /* U+50B7 */
  0x0000,   /* U+50B8 */
  0x0000,   /* U+50B9 */
  0x0000,   /* U+50BA */
  0x0000,   /* U+50BB */
  0x0000,   /* U+50BC */
  0x0000,   /* U+50BD */
  0x0000,   /* U+50BE */
  0x0000,   /* U+50BF */
  0x0000,   /* U+50C0 */
  0x0000,   /* U+50C1 */
  0x0000,   /* U+50C2 */
  0x0000,   /* U+50C3 */
  0x0000,   /* U+50C4 */
  0x0000,   /* U+50C5 */
  0x0000,   /* U+50C6 */
  0x0000,   /* U+50C7 */
  0x0000,   /* U+50C8 */
  0x0000,   /* U+50C9 */
  0x0000,   /* U+50CA */
  0x0000,   /* U+50CB */
  0x0000,   /* U+50CC */
  0x0000,   /* U+50CD */
  0x0000,   /* U+50CE */
  0x0000,   /* U+50CF */
  0x0000,   /* U+50D0 */
  0x0000,   /* U+50D1 */
  0x0000,   /* U+50D2 */
  0x0000,   /* U+50D3 */
  0x0000,   /* U+50D4 */
  0x0000,   /* U+50D5 */
  0x0000,   /* U+50D6 */
  0x0000,   /* U+50D7 */
  0x0000,   /* U+50D8 */
  0x0000,   /* U+50D9 */
  0x0000,   /* U+50DA */
  0x0000,   /* U+50DB */
  0x0000,   /* U+50DC */
  0x0000,   /* U+50DD */
  0x0000,   /* U+50DE */
  0x0000,   /* U+50DF */
  0x0000,   /* U+50E0 */
  0x0000,   /* U+50E1 */
  0x0000,   /* U+50E2 */
  0x0000,   /* U+50E3 */
  0x0000,   /* U+50E4 */
  0x0000,   /* U+50E5 */
  0x0000,   /* U+50E6 */
  0x0000,   /* U+50E7 */
  0x0000,   /* U+50E8 */
  0x0000,   /* U+50E9 */
  0x0000,   /* U+50EA */
  0x0000,   /* U+50EB */
  0x0000,   /* U+50EC */
  0x0000,   /* U+50ED */
  0x0000,   /* U+50EE */
  0x0000,   /* U+50EF */
  0x0000,   /* U+50F0 */
  0x0000,   /* U+50F1 */
  0x0000,   /* U+50F2 */
  0x0000,   /* U+50F3 */
  0x0000,   /* U+50F4 */
  0x0000,   /* U+50F5 */
  0x0000,   /* U+50F6 */
  0x0000,   /* U+50F7 */
  0x0000,   /* U+50F8 */
  0x0000,   /* U+50F9 */
  0x0000,   /* U+50FA */
  0x0000,   /* U+50FB */
  0x0000,   /* U+50FC */
  0x0000,   /* U+50FD */
  0x0000,   /* U+50FE */
  0x0000,   /* U+50FF */
};

uint16 ja_han_page51[]= {
  /* Number of CEs for each character. */
  1, 1, 1, 2, 1, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2,
  2, 2, 1, 2, 1, 1, 1, 2, 1, 2, 1, 2, 2, 2, 2, 1,
  2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2,
  2, 2, 1, 2, 2, 2, 2, 1, 2, 2, 1, 1, 1, 2, 2, 1,
  1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 2,
  1, 2, 1, 2, 1, 2, 2, 2, 2, 2, 1, 2, 1, 2, 2, 2,
  2, 2, 1, 2, 2, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 2,
  2, 1, 2, 2, 2, 1, 1, 1, 1, 2, 2, 2, 1, 2, 2, 2,
  1, 2, 1, 2, 2, 1, 1, 2, 2, 1, 1, 2, 1, 1, 2, 1,
  1, 1, 1, 1, 2, 1, 1, 1, 2, 1, 2, 2, 2, 2, 2, 2,
  1, 2, 1, 2, 1, 1, 1, 2, 1, 1, 1, 1, 1, 2, 2, 2,
  1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 1, 2, 2,
  2, 2, 2, 2, 1, 1, 1, 2, 2, 1, 2, 1, 1, 1, 2, 2,
  2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 1, 1, 1, 2, 2,
  1, 1, 2, 2, 2, 2, 1, 1, 2, 1, 1, 2, 2, 1, 2, 2,
  1, 1, 2, 2, 2, 1, 1, 2, 1, 1, 1, 2, 2, 1, 1, 2,

  /* Primary weight 1 for each character. */
  0x5690,   /* U+5100 */
  0x60A4,   /* U+5101 */
  0x60A5,   /* U+5102 */
  0xFB40,   /* U+5103 */
  0x556E,   /* U+5104 */
  0xFB40,   /* U+5105 */
  0xFB40,   /* U+5106 */
  0xFB40,   /* U+5107 */
  0xFB40,   /* U+5108 */
  0x60A3,   /* U+5109 */
  0xFB40,   /* U+510A */
  0xFB40,   /* U+510B */
  0xFB40,   /* U+510C */
  0xFB40,   /* U+510D */
  0xFB40,   /* U+510E */
  0xFB40,   /* U+510F */
  0xFB40,   /* U+5110 */
  0xFB40,   /* U+5111 */
  0x595F,   /* U+5112 */
  0xFB40,   /* U+5113 */
  0x60A8,   /* U+5114 */
  0x60A7,   /* U+5115 */
  0x60A6,   /* U+5116 */
  0xFB40,   /* U+5117 */
  0x606E,   /* U+5118 */
  0xFB40,   /* U+5119 */
  0x60A9,   /* U+511A */
  0xFB40,   /* U+511B */
  0xFB40,   /* U+511C */
  0xFB40,   /* U+511D */
  0xFB40,   /* U+511E */
  0x59C7,   /* U+511F */
  0xFB40,   /* U+5120 */
  0x60AA,   /* U+5121 */
  0xFB40,   /* U+5122 */
  0xFB40,   /* U+5123 */
  0xFB40,   /* U+5124 */
  0xFB40,   /* U+5125 */
  0xFB40,   /* U+5126 */
  0xFB40,   /* U+5127 */
  0xFB40,   /* U+5128 */
  0xFB40,   /* U+5129 */
  0x5F4E,   /* U+512A */
  0xFB40,   /* U+512B */
  0xFB40,   /* U+512C */
  0xFB40,   /* U+512D */
  0xFB40,   /* U+512E */
  0xFB40,   /* U+512F */
  0xFB40,   /* U+5130 */
  0xFB40,   /* U+5131 */
  0x5F24,   /* U+5132 */
  0xFB40,   /* U+5133 */
  0xFB40,   /* U+5134 */
  0xFB40,   /* U+5135 */
  0xFB40,   /* U+5136 */
  0x60AC,   /* U+5137 */
  0xFB40,   /* U+5138 */
  0xFB40,   /* U+5139 */
  0x60AB,   /* U+513A */
  0x60AE,   /* U+513B */
  0x60AD,   /* U+513C */
  0xFB40,   /* U+513D */
  0xFB40,   /* U+513E */
  0x60AF,   /* U+513F */
  0x60B0,   /* U+5140 */
  0x54F7,   /* U+5141 */
  0xFB40,   /* U+5142 */
  0x57A8,   /* U+5143 */
  0x5750,   /* U+5144 */
  0x5985,   /* U+5145 */
  0x5BF8,   /* U+5146 */
  0x56DB,   /* U+5147 */
  0x5ACB,   /* U+5148 */
  0x57EA,   /* U+5149 */
  0xFB40,   /* U+514A */
  0x583F,   /* U+514B */
  0x60B2,   /* U+514C */
  0x5F13,   /* U+514D */
  0x5C7F,   /* U+514E */
  0xFB40,   /* U+514F */
  0x5906,   /* U+5150 */
  0xFB40,   /* U+5151 */
  0x60B1,   /* U+5152 */
  0xFB40,   /* U+5153 */
  0x60B3,   /* U+5154 */
  0xFB40,   /* U+5155 */
  0xFB40,   /* U+5156 */
  0xFB40,   /* U+5157 */
  0xFB40,   /* U+5158 */
  0xFB40,   /* U+5159 */
  0x5C97,   /* U+515A */
  0xFB40,   /* U+515B */
  0x5612,   /* U+515C */
  0xFB40,   /* U+515D */
  0xFB40,   /* U+515E */
  0xFB40,   /* U+515F */
  0xFB40,   /* U+5160 */
  0xFB40,   /* U+5161 */
  0x60B4,   /* U+5162 */
  0xFB40,   /* U+5163 */
  0xFB40,   /* U+5164 */
  0x5D15,   /* U+5165 */
  0xFB40,   /* U+5166 */
  0xFB40,   /* U+5167 */
  0x5AF5,   /* U+5168 */
  0x60B6,   /* U+5169 */
  0x60B7,   /* U+516A */
  0x5D7F,   /* U+516B */
  0x57EB,   /* U+516C */
  0x6020,   /* U+516D */
  0x60B8,   /* U+516E */
  0xFB40,   /* U+516F */
  0xFB40,   /* U+5170 */
  0x56DD,   /* U+5171 */
  0xFB40,   /* U+5172 */
  0xFB40,   /* U+5173 */
  0xFB40,   /* U+5174 */
  0x5E4B,   /* U+5175 */
  0x5B55,   /* U+5176 */
  0x5728,   /* U+5177 */
  0x5C6E,   /* U+5178 */
  0xFB40,   /* U+5179 */
  0xFB40,   /* U+517A */
  0xFB40,   /* U+517B */
  0x5788,   /* U+517C */
  0xFB40,   /* U+517D */
  0xFB40,   /* U+517E */
  0xFB40,   /* U+517F */
  0x60B9,   /* U+5180 */
  0xFB40,   /* U+5181 */
  0x60BA,   /* U+5182 */
  0xFB40,   /* U+5183 */
  0xFB40,   /* U+5184 */
  0x5CF9,   /* U+5185 */
  0x5540,   /* U+5186 */
  0xFB40,   /* U+5187 */
  0xFB40,   /* U+5188 */
  0x60BD,   /* U+5189 */
  0x58AC,   /* U+518A */
  0xFB40,   /* U+518B */
  0x60BC,   /* U+518C */
  0x5875,   /* U+518D */
  0xFB40,   /* U+518E */
  0x60BE,   /* U+518F */
  0x689A,   /* U+5190 */
  0x60BF,   /* U+5191 */
  0x5EAE,   /* U+5192 */
  0x60C0,   /* U+5193 */
  0xFB40,   /* U+5194 */
  0x60C1,   /* U+5195 */
  0x60C2,   /* U+5196 */
  0x5A10,   /* U+5197 */
  0xFB40,   /* U+5198 */
  0x5937,   /* U+5199 */
  0xFB40,   /* U+519A */
  0xFB40,   /* U+519B */
  0xFB40,   /* U+519C */
  0xFB40,   /* U+519D */
  0xFB40,   /* U+519E */
  0xFB40,   /* U+519F */
  0x5622,   /* U+51A0 */
  0xFB40,   /* U+51A1 */
  0x60C5,   /* U+51A2 */
  0xFB40,   /* U+51A3 */
  0x60C3,   /* U+51A4 */
  0x5F08,   /* U+51A5 */
  0x60C4,   /* U+51A6 */
  0xFB40,   /* U+51A7 */
  0x5E0B,   /* U+51A8 */
  0x60C6,   /* U+51A9 */
  0x60C7,   /* U+51AA */
  0x60C8,   /* U+51AB */
  0x5C98,   /* U+51AC */
  0xFB40,   /* U+51AD */
  0xFB40,   /* U+51AE */
  0xFB40,   /* U+51AF */
  0x60CC,   /* U+51B0 */
  0x60CA,   /* U+51B1 */
  0x60CB,   /* U+51B2 */
  0x60C9,   /* U+51B3 */
  0x5892,   /* U+51B4 */
  0x60CD,   /* U+51B5 */
  0x5F35,   /* U+51B6 */
  0x5FEB,   /* U+51B7 */
  0xFB40,   /* U+51B8 */
  0xFB40,   /* U+51B9 */
  0xFB40,   /* U+51BA */
  0xFB40,   /* U+51BB */
  0xFB40,   /* U+51BC */
  0x60CE,   /* U+51BD */
  0xFB40,   /* U+51BE */
  0xFB40,   /* U+51BF */
  0xFB40,   /* U+51C0 */
  0xFB40,   /* U+51C1 */
  0xFB40,   /* U+51C2 */
  0xFB40,   /* U+51C3 */
  0x5A8B,   /* U+51C4 */
  0x60CF,   /* U+51C5 */
  0x59A3,   /* U+51C6 */
  0xFB40,   /* U+51C7 */
  0xFB40,   /* U+51C8 */
  0x60D0,   /* U+51C9 */
  0xFB40,   /* U+51CA */
  0x5BF9,   /* U+51CB */
  0x5FC6,   /* U+51CC */
  0x5C99,   /* U+51CD */
  0xFB40,   /* U+51CE */
  0xFB40,   /* U+51CF */
  0xFB40,   /* U+51D0 */
  0xFB40,   /* U+51D1 */
  0xFB40,   /* U+51D2 */
  0xFB40,   /* U+51D3 */
  0xFB40,   /* U+51D4 */
  0xFB40,   /* U+51D5 */
  0x6119,   /* U+51D6 */
  0xFB40,   /* U+51D7 */
  0xFB40,   /* U+51D8 */
  0xFB40,   /* U+51D9 */
  0xFB40,   /* U+51DA */
  0x60D1,   /* U+51DB */
  0x6D75,   /* U+51DC */
  0x56FC,   /* U+51DD */
  0xFB40,   /* U+51DE */
  0xFB40,   /* U+51DF */
  0x60D2,   /* U+51E0 */
  0x5ECB,   /* U+51E1 */
  0xFB40,   /* U+51E2 */
  0xFB40,   /* U+51E3 */
  0xFB40,   /* U+51E4 */
  0xFB40,   /* U+51E5 */
  0x59B1,   /* U+51E6 */
  0x5B9B,   /* U+51E7 */
  0xFB40,   /* U+51E8 */
  0x60D4,   /* U+51E9 */
  0x5CFB,   /* U+51EA */
  0xFB40,   /* U+51EB */
  0xFB40,   /* U+51EC */
  0x60D5,   /* U+51ED */
  0xFB40,   /* U+51EE */
  0xFB40,   /* U+51EF */
  0x60D6,   /* U+51F0 */
  0x55CB,   /* U+51F1 */
  0xFB40,   /* U+51F2 */
  0xFB40,   /* U+51F3 */
  0xFB40,   /* U+51F4 */
  0x60D7,   /* U+51F5 */
  0x56DE,   /* U+51F6 */
  0xFB40,   /* U+51F7 */
  0x5CE3,   /* U+51F8 */
  0x555B,   /* U+51F9 */
  0x5999,   /* U+51FA */
  0xFB40,   /* U+51FB */
  0xFB40,   /* U+51FC */
  0x5D74,   /* U+51FD */
  0x60D8,   /* U+51FE */
  0xFB40,   /* U+51FF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+5100 */
  0x0020,   /* U+5101 */
  0x0020,   /* U+5102 */
  0x0020,   /* U+5103 */
  0x0020,   /* U+5104 */
  0x0020,   /* U+5105 */
  0x0020,   /* U+5106 */
  0x0020,   /* U+5107 */
  0x0020,   /* U+5108 */
  0x0020,   /* U+5109 */
  0x0020,   /* U+510A */
  0x0020,   /* U+510B */
  0x0020,   /* U+510C */
  0x0020,   /* U+510D */
  0x0020,   /* U+510E */
  0x0020,   /* U+510F */
  0x0020,   /* U+5110 */
  0x0020,   /* U+5111 */
  0x0020,   /* U+5112 */
  0x0020,   /* U+5113 */
  0x0020,   /* U+5114 */
  0x0020,   /* U+5115 */
  0x0020,   /* U+5116 */
  0x0020,   /* U+5117 */
  0x0020,   /* U+5118 */
  0x0020,   /* U+5119 */
  0x0020,   /* U+511A */
  0x0020,   /* U+511B */
  0x0020,   /* U+511C */
  0x0020,   /* U+511D */
  0x0020,   /* U+511E */
  0x0020,   /* U+511F */
  0x0020,   /* U+5120 */
  0x0020,   /* U+5121 */
  0x0020,   /* U+5122 */
  0x0020,   /* U+5123 */
  0x0020,   /* U+5124 */
  0x0020,   /* U+5125 */
  0x0020,   /* U+5126 */
  0x0020,   /* U+5127 */
  0x0020,   /* U+5128 */
  0x0020,   /* U+5129 */
  0x0020,   /* U+512A */
  0x0020,   /* U+512B */
  0x0020,   /* U+512C */
  0x0020,   /* U+512D */
  0x0020,   /* U+512E */
  0x0020,   /* U+512F */
  0x0020,   /* U+5130 */
  0x0020,   /* U+5131 */
  0x0020,   /* U+5132 */
  0x0020,   /* U+5133 */
  0x0020,   /* U+5134 */
  0x0020,   /* U+5135 */
  0x0020,   /* U+5136 */
  0x0020,   /* U+5137 */
  0x0020,   /* U+5138 */
  0x0020,   /* U+5139 */
  0x0020,   /* U+513A */
  0x0020,   /* U+513B */
  0x0020,   /* U+513C */
  0x0020,   /* U+513D */
  0x0020,   /* U+513E */
  0x0020,   /* U+513F */
  0x0020,   /* U+5140 */
  0x0020,   /* U+5141 */
  0x0020,   /* U+5142 */
  0x0020,   /* U+5143 */
  0x0020,   /* U+5144 */
  0x0020,   /* U+5145 */
  0x0020,   /* U+5146 */
  0x0020,   /* U+5147 */
  0x0020,   /* U+5148 */
  0x0020,   /* U+5149 */
  0x0020,   /* U+514A */
  0x0020,   /* U+514B */
  0x0020,   /* U+514C */
  0x0020,   /* U+514D */
  0x0020,   /* U+514E */
  0x0020,   /* U+514F */
  0x0020,   /* U+5150 */
  0x0020,   /* U+5151 */
  0x0020,   /* U+5152 */
  0x0020,   /* U+5153 */
  0x0020,   /* U+5154 */
  0x0020,   /* U+5155 */
  0x0020,   /* U+5156 */
  0x0020,   /* U+5157 */
  0x0020,   /* U+5158 */
  0x0020,   /* U+5159 */
  0x0020,   /* U+515A */
  0x0020,   /* U+515B */
  0x0020,   /* U+515C */
  0x0020,   /* U+515D */
  0x0020,   /* U+515E */
  0x0020,   /* U+515F */
  0x0020,   /* U+5160 */
  0x0020,   /* U+5161 */
  0x0020,   /* U+5162 */
  0x0020,   /* U+5163 */
  0x0020,   /* U+5164 */
  0x0020,   /* U+5165 */
  0x0020,   /* U+5166 */
  0x0020,   /* U+5167 */
  0x0020,   /* U+5168 */
  0x0020,   /* U+5169 */
  0x0020,   /* U+516A */
  0x0020,   /* U+516B */
  0x0020,   /* U+516C */
  0x0020,   /* U+516D */
  0x0020,   /* U+516E */
  0x0020,   /* U+516F */
  0x0020,   /* U+5170 */
  0x0020,   /* U+5171 */
  0x0020,   /* U+5172 */
  0x0020,   /* U+5173 */
  0x0020,   /* U+5174 */
  0x0020,   /* U+5175 */
  0x0020,   /* U+5176 */
  0x0020,   /* U+5177 */
  0x0020,   /* U+5178 */
  0x0020,   /* U+5179 */
  0x0020,   /* U+517A */
  0x0020,   /* U+517B */
  0x0020,   /* U+517C */
  0x0020,   /* U+517D */
  0x0020,   /* U+517E */
  0x0020,   /* U+517F */
  0x0020,   /* U+5180 */
  0x0020,   /* U+5181 */
  0x0020,   /* U+5182 */
  0x0020,   /* U+5183 */
  0x0020,   /* U+5184 */
  0x0020,   /* U+5185 */
  0x0020,   /* U+5186 */
  0x0020,   /* U+5187 */
  0x0020,   /* U+5188 */
  0x0020,   /* U+5189 */
  0x0020,   /* U+518A */
  0x0020,   /* U+518B */
  0x0020,   /* U+518C */
  0x0020,   /* U+518D */
  0x0020,   /* U+518E */
  0x0020,   /* U+518F */
  0x0020,   /* U+5190 */
  0x0020,   /* U+5191 */
  0x0020,   /* U+5192 */
  0x0020,   /* U+5193 */
  0x0020,   /* U+5194 */
  0x0020,   /* U+5195 */
  0x0020,   /* U+5196 */
  0x0020,   /* U+5197 */
  0x0020,   /* U+5198 */
  0x0020,   /* U+5199 */
  0x0020,   /* U+519A */
  0x0020,   /* U+519B */
  0x0020,   /* U+519C */
  0x0020,   /* U+519D */
  0x0020,   /* U+519E */
  0x0020,   /* U+519F */
  0x0020,   /* U+51A0 */
  0x0020,   /* U+51A1 */
  0x0020,   /* U+51A2 */
  0x0020,   /* U+51A3 */
  0x0020,   /* U+51A4 */
  0x0020,   /* U+51A5 */
  0x0020,   /* U+51A6 */
  0x0020,   /* U+51A7 */
  0x0020,   /* U+51A8 */
  0x0020,   /* U+51A9 */
  0x0020,   /* U+51AA */
  0x0020,   /* U+51AB */
  0x0020,   /* U+51AC */
  0x0020,   /* U+51AD */
  0x0020,   /* U+51AE */
  0x0020,   /* U+51AF */
  0x0020,   /* U+51B0 */
  0x0020,   /* U+51B1 */
  0x0020,   /* U+51B2 */
  0x0020,   /* U+51B3 */
  0x0020,   /* U+51B4 */
  0x0020,   /* U+51B5 */
  0x0020,   /* U+51B6 */
  0x0020,   /* U+51B7 */
  0x0020,   /* U+51B8 */
  0x0020,   /* U+51B9 */
  0x0020,   /* U+51BA */
  0x0020,   /* U+51BB */
  0x0020,   /* U+51BC */
  0x0020,   /* U+51BD */
  0x0020,   /* U+51BE */
  0x0020,   /* U+51BF */
  0x0020,   /* U+51C0 */
  0x0020,   /* U+51C1 */
  0x0020,   /* U+51C2 */
  0x0020,   /* U+51C3 */
  0x0020,   /* U+51C4 */
  0x0020,   /* U+51C5 */
  0x0020,   /* U+51C6 */
  0x0020,   /* U+51C7 */
  0x0020,   /* U+51C8 */
  0x0020,   /* U+51C9 */
  0x0020,   /* U+51CA */
  0x0020,   /* U+51CB */
  0x0020,   /* U+51CC */
  0x0020,   /* U+51CD */
  0x0020,   /* U+51CE */
  0x0020,   /* U+51CF */
  0x0020,   /* U+51D0 */
  0x0020,   /* U+51D1 */
  0x0020,   /* U+51D2 */
  0x0020,   /* U+51D3 */
  0x0020,   /* U+51D4 */
  0x0020,   /* U+51D5 */
  0x0020,   /* U+51D6 */
  0x0020,   /* U+51D7 */
  0x0020,   /* U+51D8 */
  0x0020,   /* U+51D9 */
  0x0020,   /* U+51DA */
  0x0020,   /* U+51DB */
  0x0020,   /* U+51DC */
  0x0020,   /* U+51DD */
  0x0020,   /* U+51DE */
  0x0020,   /* U+51DF */
  0x0020,   /* U+51E0 */
  0x0020,   /* U+51E1 */
  0x0020,   /* U+51E2 */
  0x0020,   /* U+51E3 */
  0x0020,   /* U+51E4 */
  0x0020,   /* U+51E5 */
  0x0020,   /* U+51E6 */
  0x0020,   /* U+51E7 */
  0x0020,   /* U+51E8 */
  0x0020,   /* U+51E9 */
  0x0020,   /* U+51EA */
  0x0020,   /* U+51EB */
  0x0020,   /* U+51EC */
  0x0020,   /* U+51ED */
  0x0020,   /* U+51EE */
  0x0020,   /* U+51EF */
  0x0020,   /* U+51F0 */
  0x0020,   /* U+51F1 */
  0x0020,   /* U+51F2 */
  0x0020,   /* U+51F3 */
  0x0020,   /* U+51F4 */
  0x0020,   /* U+51F5 */
  0x0020,   /* U+51F6 */
  0x0020,   /* U+51F7 */
  0x0020,   /* U+51F8 */
  0x0020,   /* U+51F9 */
  0x0020,   /* U+51FA */
  0x0020,   /* U+51FB */
  0x0020,   /* U+51FC */
  0x0020,   /* U+51FD */
  0x0020,   /* U+51FE */
  0x0020,   /* U+51FF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+5100 */
  0x0002,   /* U+5101 */
  0x0002,   /* U+5102 */
  0x0002,   /* U+5103 */
  0x0002,   /* U+5104 */
  0x0002,   /* U+5105 */
  0x0002,   /* U+5106 */
  0x0002,   /* U+5107 */
  0x0002,   /* U+5108 */
  0x0002,   /* U+5109 */
  0x0002,   /* U+510A */
  0x0002,   /* U+510B */
  0x0002,   /* U+510C */
  0x0002,   /* U+510D */
  0x0002,   /* U+510E */
  0x0002,   /* U+510F */
  0x0002,   /* U+5110 */
  0x0002,   /* U+5111 */
  0x0002,   /* U+5112 */
  0x0002,   /* U+5113 */
  0x0002,   /* U+5114 */
  0x0002,   /* U+5115 */
  0x0002,   /* U+5116 */
  0x0002,   /* U+5117 */
  0x0002,   /* U+5118 */
  0x0002,   /* U+5119 */
  0x0002,   /* U+511A */
  0x0002,   /* U+511B */
  0x0002,   /* U+511C */
  0x0002,   /* U+511D */
  0x0002,   /* U+511E */
  0x0002,   /* U+511F */
  0x0002,   /* U+5120 */
  0x0002,   /* U+5121 */
  0x0002,   /* U+5122 */
  0x0002,   /* U+5123 */
  0x0002,   /* U+5124 */
  0x0002,   /* U+5125 */
  0x0002,   /* U+5126 */
  0x0002,   /* U+5127 */
  0x0002,   /* U+5128 */
  0x0002,   /* U+5129 */
  0x0002,   /* U+512A */
  0x0002,   /* U+512B */
  0x0002,   /* U+512C */
  0x0002,   /* U+512D */
  0x0002,   /* U+512E */
  0x0002,   /* U+512F */
  0x0002,   /* U+5130 */
  0x0002,   /* U+5131 */
  0x0002,   /* U+5132 */
  0x0002,   /* U+5133 */
  0x0002,   /* U+5134 */
  0x0002,   /* U+5135 */
  0x0002,   /* U+5136 */
  0x0002,   /* U+5137 */
  0x0002,   /* U+5138 */
  0x0002,   /* U+5139 */
  0x0002,   /* U+513A */
  0x0002,   /* U+513B */
  0x0002,   /* U+513C */
  0x0002,   /* U+513D */
  0x0002,   /* U+513E */
  0x0002,   /* U+513F */
  0x0002,   /* U+5140 */
  0x0002,   /* U+5141 */
  0x0002,   /* U+5142 */
  0x0002,   /* U+5143 */
  0x0002,   /* U+5144 */
  0x0002,   /* U+5145 */
  0x0002,   /* U+5146 */
  0x0002,   /* U+5147 */
  0x0002,   /* U+5148 */
  0x0002,   /* U+5149 */
  0x0002,   /* U+514A */
  0x0002,   /* U+514B */
  0x0002,   /* U+514C */
  0x0002,   /* U+514D */
  0x0002,   /* U+514E */
  0x0002,   /* U+514F */
  0x0002,   /* U+5150 */
  0x0002,   /* U+5151 */
  0x0002,   /* U+5152 */
  0x0002,   /* U+5153 */
  0x0002,   /* U+5154 */
  0x0002,   /* U+5155 */
  0x0002,   /* U+5156 */
  0x0002,   /* U+5157 */
  0x0002,   /* U+5158 */
  0x0002,   /* U+5159 */
  0x0002,   /* U+515A */
  0x0002,   /* U+515B */
  0x0002,   /* U+515C */
  0x0002,   /* U+515D */
  0x0002,   /* U+515E */
  0x0002,   /* U+515F */
  0x0002,   /* U+5160 */
  0x0002,   /* U+5161 */
  0x0002,   /* U+5162 */
  0x0002,   /* U+5163 */
  0x0002,   /* U+5164 */
  0x0002,   /* U+5165 */
  0x0002,   /* U+5166 */
  0x0002,   /* U+5167 */
  0x0002,   /* U+5168 */
  0x0002,   /* U+5169 */
  0x0002,   /* U+516A */
  0x0002,   /* U+516B */
  0x0002,   /* U+516C */
  0x0002,   /* U+516D */
  0x0002,   /* U+516E */
  0x0002,   /* U+516F */
  0x0002,   /* U+5170 */
  0x0002,   /* U+5171 */
  0x0002,   /* U+5172 */
  0x0002,   /* U+5173 */
  0x0002,   /* U+5174 */
  0x0002,   /* U+5175 */
  0x0002,   /* U+5176 */
  0x0002,   /* U+5177 */
  0x0002,   /* U+5178 */
  0x0002,   /* U+5179 */
  0x0002,   /* U+517A */
  0x0002,   /* U+517B */
  0x0002,   /* U+517C */
  0x0002,   /* U+517D */
  0x0002,   /* U+517E */
  0x0002,   /* U+517F */
  0x0002,   /* U+5180 */
  0x0002,   /* U+5181 */
  0x0002,   /* U+5182 */
  0x0002,   /* U+5183 */
  0x0002,   /* U+5184 */
  0x0002,   /* U+5185 */
  0x0002,   /* U+5186 */
  0x0002,   /* U+5187 */
  0x0002,   /* U+5188 */
  0x0002,   /* U+5189 */
  0x0002,   /* U+518A */
  0x0002,   /* U+518B */
  0x0002,   /* U+518C */
  0x0002,   /* U+518D */
  0x0002,   /* U+518E */
  0x0002,   /* U+518F */
  0x0002,   /* U+5190 */
  0x0002,   /* U+5191 */
  0x0002,   /* U+5192 */
  0x0002,   /* U+5193 */
  0x0002,   /* U+5194 */
  0x0002,   /* U+5195 */
  0x0002,   /* U+5196 */
  0x0002,   /* U+5197 */
  0x0002,   /* U+5198 */
  0x0002,   /* U+5199 */
  0x0002,   /* U+519A */
  0x0002,   /* U+519B */
  0x0002,   /* U+519C */
  0x0002,   /* U+519D */
  0x0002,   /* U+519E */
  0x0002,   /* U+519F */
  0x0002,   /* U+51A0 */
  0x0002,   /* U+51A1 */
  0x0002,   /* U+51A2 */
  0x0002,   /* U+51A3 */
  0x0002,   /* U+51A4 */
  0x0002,   /* U+51A5 */
  0x0002,   /* U+51A6 */
  0x0002,   /* U+51A7 */
  0x0002,   /* U+51A8 */
  0x0002,   /* U+51A9 */
  0x0002,   /* U+51AA */
  0x0002,   /* U+51AB */
  0x0002,   /* U+51AC */
  0x0002,   /* U+51AD */
  0x0002,   /* U+51AE */
  0x0002,   /* U+51AF */
  0x0002,   /* U+51B0 */
  0x0002,   /* U+51B1 */
  0x0002,   /* U+51B2 */
  0x0002,   /* U+51B3 */
  0x0002,   /* U+51B4 */
  0x0002,   /* U+51B5 */
  0x0002,   /* U+51B6 */
  0x0002,   /* U+51B7 */
  0x0002,   /* U+51B8 */
  0x0002,   /* U+51B9 */
  0x0002,   /* U+51BA */
  0x0002,   /* U+51BB */
  0x0002,   /* U+51BC */
  0x0002,   /* U+51BD */
  0x0002,   /* U+51BE */
  0x0002,   /* U+51BF */
  0x0002,   /* U+51C0 */
  0x0002,   /* U+51C1 */
  0x0002,   /* U+51C2 */
  0x0002,   /* U+51C3 */
  0x0002,   /* U+51C4 */
  0x0002,   /* U+51C5 */
  0x0002,   /* U+51C6 */
  0x0002,   /* U+51C7 */
  0x0002,   /* U+51C8 */
  0x0002,   /* U+51C9 */
  0x0002,   /* U+51CA */
  0x0002,   /* U+51CB */
  0x0002,   /* U+51CC */
  0x0002,   /* U+51CD */
  0x0002,   /* U+51CE */
  0x0002,   /* U+51CF */
  0x0002,   /* U+51D0 */
  0x0002,   /* U+51D1 */
  0x0002,   /* U+51D2 */
  0x0002,   /* U+51D3 */
  0x0002,   /* U+51D4 */
  0x0002,   /* U+51D5 */
  0x0002,   /* U+51D6 */
  0x0002,   /* U+51D7 */
  0x0002,   /* U+51D8 */
  0x0002,   /* U+51D9 */
  0x0002,   /* U+51DA */
  0x0002,   /* U+51DB */
  0x0002,   /* U+51DC */
  0x0002,   /* U+51DD */
  0x0002,   /* U+51DE */
  0x0002,   /* U+51DF */
  0x0002,   /* U+51E0 */
  0x0002,   /* U+51E1 */
  0x0002,   /* U+51E2 */
  0x0002,   /* U+51E3 */
  0x0002,   /* U+51E4 */
  0x0002,   /* U+51E5 */
  0x0002,   /* U+51E6 */
  0x0002,   /* U+51E7 */
  0x0002,   /* U+51E8 */
  0x0002,   /* U+51E9 */
  0x0002,   /* U+51EA */
  0x0002,   /* U+51EB */
  0x0002,   /* U+51EC */
  0x0002,   /* U+51ED */
  0x0002,   /* U+51EE */
  0x0002,   /* U+51EF */
  0x0002,   /* U+51F0 */
  0x0002,   /* U+51F1 */
  0x0002,   /* U+51F2 */
  0x0002,   /* U+51F3 */
  0x0002,   /* U+51F4 */
  0x0002,   /* U+51F5 */
  0x0002,   /* U+51F6 */
  0x0002,   /* U+51F7 */
  0x0002,   /* U+51F8 */
  0x0002,   /* U+51F9 */
  0x0002,   /* U+51FA */
  0x0002,   /* U+51FB */
  0x0002,   /* U+51FC */
  0x0002,   /* U+51FD */
  0x0002,   /* U+51FE */
  0x0002,   /* U+51FF */

  /* Primary weight 2 for each character. */
  0x0000,   /* U+5100 */
  0x0000,   /* U+5101 */
  0x0000,   /* U+5102 */
  0xD103,   /* U+5103 */
  0x0000,   /* U+5104 */
  0xD105,   /* U+5105 */
  0xD106,   /* U+5106 */
  0xD107,   /* U+5107 */
  0xD108,   /* U+5108 */
  0x0000,   /* U+5109 */
  0xD10A,   /* U+510A */
  0xD10B,   /* U+510B */
  0xD10C,   /* U+510C */
  0xD10D,   /* U+510D */
  0xD10E,   /* U+510E */
  0xD10F,   /* U+510F */
  0xD110,   /* U+5110 */
  0xD111,   /* U+5111 */
  0x0000,   /* U+5112 */
  0xD113,   /* U+5113 */
  0x0000,   /* U+5114 */
  0x0000,   /* U+5115 */
  0x0000,   /* U+5116 */
  0xD117,   /* U+5117 */
  0x0000,   /* U+5118 */
  0xD119,   /* U+5119 */
  0x0000,   /* U+511A */
  0xD11B,   /* U+511B */
  0xD11C,   /* U+511C */
  0xD11D,   /* U+511D */
  0xD11E,   /* U+511E */
  0x0000,   /* U+511F */
  0xD120,   /* U+5120 */
  0x0000,   /* U+5121 */
  0xD122,   /* U+5122 */
  0xD123,   /* U+5123 */
  0xD124,   /* U+5124 */
  0xD125,   /* U+5125 */
  0xD126,   /* U+5126 */
  0xD127,   /* U+5127 */
  0xD128,   /* U+5128 */
  0xD129,   /* U+5129 */
  0x0000,   /* U+512A */
  0xD12B,   /* U+512B */
  0xD12C,   /* U+512C */
  0xD12D,   /* U+512D */
  0xD12E,   /* U+512E */
  0xD12F,   /* U+512F */
  0xD130,   /* U+5130 */
  0xD131,   /* U+5131 */
  0x0000,   /* U+5132 */
  0xD133,   /* U+5133 */
  0xD134,   /* U+5134 */
  0xD135,   /* U+5135 */
  0xD136,   /* U+5136 */
  0x0000,   /* U+5137 */
  0xD138,   /* U+5138 */
  0xD139,   /* U+5139 */
  0x0000,   /* U+513A */
  0x0000,   /* U+513B */
  0x0000,   /* U+513C */
  0xD13D,   /* U+513D */
  0xD13E,   /* U+513E */
  0x0000,   /* U+513F */
  0x0000,   /* U+5140 */
  0x0000,   /* U+5141 */
  0xD142,   /* U+5142 */
  0x0000,   /* U+5143 */
  0x0000,   /* U+5144 */
  0x0000,   /* U+5145 */
  0x0000,   /* U+5146 */
  0x0000,   /* U+5147 */
  0x0000,   /* U+5148 */
  0x0000,   /* U+5149 */
  0xD14A,   /* U+514A */
  0x0000,   /* U+514B */
  0x0000,   /* U+514C */
  0x0000,   /* U+514D */
  0x0000,   /* U+514E */
  0xD14F,   /* U+514F */
  0x0000,   /* U+5150 */
  0xD151,   /* U+5151 */
  0x0000,   /* U+5152 */
  0xD153,   /* U+5153 */
  0x0000,   /* U+5154 */
  0xD155,   /* U+5155 */
  0xD156,   /* U+5156 */
  0xD157,   /* U+5157 */
  0xD158,   /* U+5158 */
  0xD159,   /* U+5159 */
  0x0000,   /* U+515A */
  0xD15B,   /* U+515B */
  0x0000,   /* U+515C */
  0xD15D,   /* U+515D */
  0xD15E,   /* U+515E */
  0xD15F,   /* U+515F */
  0xD160,   /* U+5160 */
  0xD161,   /* U+5161 */
  0x0000,   /* U+5162 */
  0xD163,   /* U+5163 */
  0xD164,   /* U+5164 */
  0x0000,   /* U+5165 */
  0xD166,   /* U+5166 */
  0xD167,   /* U+5167 */
  0x0000,   /* U+5168 */
  0x0000,   /* U+5169 */
  0x0000,   /* U+516A */
  0x0000,   /* U+516B */
  0x0000,   /* U+516C */
  0x0000,   /* U+516D */
  0x0000,   /* U+516E */
  0xD16F,   /* U+516F */
  0xD170,   /* U+5170 */
  0x0000,   /* U+5171 */
  0xD172,   /* U+5172 */
  0xD173,   /* U+5173 */
  0xD174,   /* U+5174 */
  0x0000,   /* U+5175 */
  0x0000,   /* U+5176 */
  0x0000,   /* U+5177 */
  0x0000,   /* U+5178 */
  0xD179,   /* U+5179 */
  0xD17A,   /* U+517A */
  0xD17B,   /* U+517B */
  0x0000,   /* U+517C */
  0xD17D,   /* U+517D */
  0xD17E,   /* U+517E */
  0xD17F,   /* U+517F */
  0x0000,   /* U+5180 */
  0xD181,   /* U+5181 */
  0x0000,   /* U+5182 */
  0xD183,   /* U+5183 */
  0xD184,   /* U+5184 */
  0x0000,   /* U+5185 */
  0x0000,   /* U+5186 */
  0xD187,   /* U+5187 */
  0xD188,   /* U+5188 */
  0x0000,   /* U+5189 */
  0x0000,   /* U+518A */
  0xD18B,   /* U+518B */
  0x0000,   /* U+518C */
  0x0000,   /* U+518D */
  0xD18E,   /* U+518E */
  0x0000,   /* U+518F */
  0x0000,   /* U+5190 */
  0x0000,   /* U+5191 */
  0x0000,   /* U+5192 */
  0x0000,   /* U+5193 */
  0xD194,   /* U+5194 */
  0x0000,   /* U+5195 */
  0x0000,   /* U+5196 */
  0x0000,   /* U+5197 */
  0xD198,   /* U+5198 */
  0x0000,   /* U+5199 */
  0xD19A,   /* U+519A */
  0xD19B,   /* U+519B */
  0xD19C,   /* U+519C */
  0xD19D,   /* U+519D */
  0xD19E,   /* U+519E */
  0xD19F,   /* U+519F */
  0x0000,   /* U+51A0 */
  0xD1A1,   /* U+51A1 */
  0x0000,   /* U+51A2 */
  0xD1A3,   /* U+51A3 */
  0x0000,   /* U+51A4 */
  0x0000,   /* U+51A5 */
  0x0000,   /* U+51A6 */
  0xD1A7,   /* U+51A7 */
  0x0000,   /* U+51A8 */
  0x0000,   /* U+51A9 */
  0x0000,   /* U+51AA */
  0x0000,   /* U+51AB */
  0x0000,   /* U+51AC */
  0xD1AD,   /* U+51AD */
  0xD1AE,   /* U+51AE */
  0xD1AF,   /* U+51AF */
  0x0000,   /* U+51B0 */
  0x0000,   /* U+51B1 */
  0x0000,   /* U+51B2 */
  0x0000,   /* U+51B3 */
  0x0000,   /* U+51B4 */
  0x0000,   /* U+51B5 */
  0x0000,   /* U+51B6 */
  0x0000,   /* U+51B7 */
  0xD1B8,   /* U+51B8 */
  0xD1B9,   /* U+51B9 */
  0xD1BA,   /* U+51BA */
  0xD1BB,   /* U+51BB */
  0xD1BC,   /* U+51BC */
  0x0000,   /* U+51BD */
  0xD1BE,   /* U+51BE */
  0xD1BF,   /* U+51BF */
  0xD1C0,   /* U+51C0 */
  0xD1C1,   /* U+51C1 */
  0xD1C2,   /* U+51C2 */
  0xD1C3,   /* U+51C3 */
  0x0000,   /* U+51C4 */
  0x0000,   /* U+51C5 */
  0x0000,   /* U+51C6 */
  0xD1C7,   /* U+51C7 */
  0xD1C8,   /* U+51C8 */
  0x0000,   /* U+51C9 */
  0xD1CA,   /* U+51CA */
  0x0000,   /* U+51CB */
  0x0000,   /* U+51CC */
  0x0000,   /* U+51CD */
  0xD1CE,   /* U+51CE */
  0xD1CF,   /* U+51CF */
  0xD1D0,   /* U+51D0 */
  0xD1D1,   /* U+51D1 */
  0xD1D2,   /* U+51D2 */
  0xD1D3,   /* U+51D3 */
  0xD1D4,   /* U+51D4 */
  0xD1D5,   /* U+51D5 */
  0x0000,   /* U+51D6 */
  0xD1D7,   /* U+51D7 */
  0xD1D8,   /* U+51D8 */
  0xD1D9,   /* U+51D9 */
  0xD1DA,   /* U+51DA */
  0x0000,   /* U+51DB */
  0x0000,   /* U+51DC */
  0x0000,   /* U+51DD */
  0xD1DE,   /* U+51DE */
  0xD1DF,   /* U+51DF */
  0x0000,   /* U+51E0 */
  0x0000,   /* U+51E1 */
  0xD1E2,   /* U+51E2 */
  0xD1E3,   /* U+51E3 */
  0xD1E4,   /* U+51E4 */
  0xD1E5,   /* U+51E5 */
  0x0000,   /* U+51E6 */
  0x0000,   /* U+51E7 */
  0xD1E8,   /* U+51E8 */
  0x0000,   /* U+51E9 */
  0x0000,   /* U+51EA */
  0xD1EB,   /* U+51EB */
  0xD1EC,   /* U+51EC */
  0x0000,   /* U+51ED */
  0xD1EE,   /* U+51EE */
  0xD1EF,   /* U+51EF */
  0x0000,   /* U+51F0 */
  0x0000,   /* U+51F1 */
  0xD1F2,   /* U+51F2 */
  0xD1F3,   /* U+51F3 */
  0xD1F4,   /* U+51F4 */
  0x0000,   /* U+51F5 */
  0x0000,   /* U+51F6 */
  0xD1F7,   /* U+51F7 */
  0x0000,   /* U+51F8 */
  0x0000,   /* U+51F9 */
  0x0000,   /* U+51FA */
  0xD1FB,   /* U+51FB */
  0xD1FC,   /* U+51FC */
  0x0000,   /* U+51FD */
  0x0000,   /* U+51FE */
  0xD1FF,   /* U+51FF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+5100 */
  0x0000,   /* U+5101 */
  0x0000,   /* U+5102 */
  0x0000,   /* U+5103 */
  0x0000,   /* U+5104 */
  0x0000,   /* U+5105 */
  0x0000,   /* U+5106 */
  0x0000,   /* U+5107 */
  0x0000,   /* U+5108 */
  0x0000,   /* U+5109 */
  0x0000,   /* U+510A */
  0x0000,   /* U+510B */
  0x0000,   /* U+510C */
  0x0000,   /* U+510D */
  0x0000,   /* U+510E */
  0x0000,   /* U+510F */
  0x0000,   /* U+5110 */
  0x0000,   /* U+5111 */
  0x0000,   /* U+5112 */
  0x0000,   /* U+5113 */
  0x0000,   /* U+5114 */
  0x0000,   /* U+5115 */
  0x0000,   /* U+5116 */
  0x0000,   /* U+5117 */
  0x0000,   /* U+5118 */
  0x0000,   /* U+5119 */
  0x0000,   /* U+511A */
  0x0000,   /* U+511B */
  0x0000,   /* U+511C */
  0x0000,   /* U+511D */
  0x0000,   /* U+511E */
  0x0000,   /* U+511F */
  0x0000,   /* U+5120 */
  0x0000,   /* U+5121 */
  0x0000,   /* U+5122 */
  0x0000,   /* U+5123 */
  0x0000,   /* U+5124 */
  0x0000,   /* U+5125 */
  0x0000,   /* U+5126 */
  0x0000,   /* U+5127 */
  0x0000,   /* U+5128 */
  0x0000,   /* U+5129 */
  0x0000,   /* U+512A */
  0x0000,   /* U+512B */
  0x0000,   /* U+512C */
  0x0000,   /* U+512D */
  0x0000,   /* U+512E */
  0x0000,   /* U+512F */
  0x0000,   /* U+5130 */
  0x0000,   /* U+5131 */
  0x0000,   /* U+5132 */
  0x0000,   /* U+5133 */
  0x0000,   /* U+5134 */
  0x0000,   /* U+5135 */
  0x0000,   /* U+5136 */
  0x0000,   /* U+5137 */
  0x0000,   /* U+5138 */
  0x0000,   /* U+5139 */
  0x0000,   /* U+513A */
  0x0000,   /* U+513B */
  0x0000,   /* U+513C */
  0x0000,   /* U+513D */
  0x0000,   /* U+513E */
  0x0000,   /* U+513F */
  0x0000,   /* U+5140 */
  0x0000,   /* U+5141 */
  0x0000,   /* U+5142 */
  0x0000,   /* U+5143 */
  0x0000,   /* U+5144 */
  0x0000,   /* U+5145 */
  0x0000,   /* U+5146 */
  0x0000,   /* U+5147 */
  0x0000,   /* U+5148 */
  0x0000,   /* U+5149 */
  0x0000,   /* U+514A */
  0x0000,   /* U+514B */
  0x0000,   /* U+514C */
  0x0000,   /* U+514D */
  0x0000,   /* U+514E */
  0x0000,   /* U+514F */
  0x0000,   /* U+5150 */
  0x0000,   /* U+5151 */
  0x0000,   /* U+5152 */
  0x0000,   /* U+5153 */
  0x0000,   /* U+5154 */
  0x0000,   /* U+5155 */
  0x0000,   /* U+5156 */
  0x0000,   /* U+5157 */
  0x0000,   /* U+5158 */
  0x0000,   /* U+5159 */
  0x0000,   /* U+515A */
  0x0000,   /* U+515B */
  0x0000,   /* U+515C */
  0x0000,   /* U+515D */
  0x0000,   /* U+515E */
  0x0000,   /* U+515F */
  0x0000,   /* U+5160 */
  0x0000,   /* U+5161 */
  0x0000,   /* U+5162 */
  0x0000,   /* U+5163 */
  0x0000,   /* U+5164 */
  0x0000,   /* U+5165 */
  0x0000,   /* U+5166 */
  0x0000,   /* U+5167 */
  0x0000,   /* U+5168 */
  0x0000,   /* U+5169 */
  0x0000,   /* U+516A */
  0x0000,   /* U+516B */
  0x0000,   /* U+516C */
  0x0000,   /* U+516D */
  0x0000,   /* U+516E */
  0x0000,   /* U+516F */
  0x0000,   /* U+5170 */
  0x0000,   /* U+5171 */
  0x0000,   /* U+5172 */
  0x0000,   /* U+5173 */
  0x0000,   /* U+5174 */
  0x0000,   /* U+5175 */
  0x0000,   /* U+5176 */
  0x0000,   /* U+5177 */
  0x0000,   /* U+5178 */
  0x0000,   /* U+5179 */
  0x0000,   /* U+517A */
  0x0000,   /* U+517B */
  0x0000,   /* U+517C */
  0x0000,   /* U+517D */
  0x0000,   /* U+517E */
  0x0000,   /* U+517F */
  0x0000,   /* U+5180 */
  0x0000,   /* U+5181 */
  0x0000,   /* U+5182 */
  0x0000,   /* U+5183 */
  0x0000,   /* U+5184 */
  0x0000,   /* U+5185 */
  0x0000,   /* U+5186 */
  0x0000,   /* U+5187 */
  0x0000,   /* U+5188 */
  0x0000,   /* U+5189 */
  0x0000,   /* U+518A */
  0x0000,   /* U+518B */
  0x0000,   /* U+518C */
  0x0000,   /* U+518D */
  0x0000,   /* U+518E */
  0x0000,   /* U+518F */
  0x0000,   /* U+5190 */
  0x0000,   /* U+5191 */
  0x0000,   /* U+5192 */
  0x0000,   /* U+5193 */
  0x0000,   /* U+5194 */
  0x0000,   /* U+5195 */
  0x0000,   /* U+5196 */
  0x0000,   /* U+5197 */
  0x0000,   /* U+5198 */
  0x0000,   /* U+5199 */
  0x0000,   /* U+519A */
  0x0000,   /* U+519B */
  0x0000,   /* U+519C */
  0x0000,   /* U+519D */
  0x0000,   /* U+519E */
  0x0000,   /* U+519F */
  0x0000,   /* U+51A0 */
  0x0000,   /* U+51A1 */
  0x0000,   /* U+51A2 */
  0x0000,   /* U+51A3 */
  0x0000,   /* U+51A4 */
  0x0000,   /* U+51A5 */
  0x0000,   /* U+51A6 */
  0x0000,   /* U+51A7 */
  0x0000,   /* U+51A8 */
  0x0000,   /* U+51A9 */
  0x0000,   /* U+51AA */
  0x0000,   /* U+51AB */
  0x0000,   /* U+51AC */
  0x0000,   /* U+51AD */
  0x0000,   /* U+51AE */
  0x0000,   /* U+51AF */
  0x0000,   /* U+51B0 */
  0x0000,   /* U+51B1 */
  0x0000,   /* U+51B2 */
  0x0000,   /* U+51B3 */
  0x0000,   /* U+51B4 */
  0x0000,   /* U+51B5 */
  0x0000,   /* U+51B6 */
  0x0000,   /* U+51B7 */
  0x0000,   /* U+51B8 */
  0x0000,   /* U+51B9 */
  0x0000,   /* U+51BA */
  0x0000,   /* U+51BB */
  0x0000,   /* U+51BC */
  0x0000,   /* U+51BD */
  0x0000,   /* U+51BE */
  0x0000,   /* U+51BF */
  0x0000,   /* U+51C0 */
  0x0000,   /* U+51C1 */
  0x0000,   /* U+51C2 */
  0x0000,   /* U+51C3 */
  0x0000,   /* U+51C4 */
  0x0000,   /* U+51C5 */
  0x0000,   /* U+51C6 */
  0x0000,   /* U+51C7 */
  0x0000,   /* U+51C8 */
  0x0000,   /* U+51C9 */
  0x0000,   /* U+51CA */
  0x0000,   /* U+51CB */
  0x0000,   /* U+51CC */
  0x0000,   /* U+51CD */
  0x0000,   /* U+51CE */
  0x0000,   /* U+51CF */
  0x0000,   /* U+51D0 */
  0x0000,   /* U+51D1 */
  0x0000,   /* U+51D2 */
  0x0000,   /* U+51D3 */
  0x0000,   /* U+51D4 */
  0x0000,   /* U+51D5 */
  0x0000,   /* U+51D6 */
  0x0000,   /* U+51D7 */
  0x0000,   /* U+51D8 */
  0x0000,   /* U+51D9 */
  0x0000,   /* U+51DA */
  0x0000,   /* U+51DB */
  0x0000,   /* U+51DC */
  0x0000,   /* U+51DD */
  0x0000,   /* U+51DE */
  0x0000,   /* U+51DF */
  0x0000,   /* U+51E0 */
  0x0000,   /* U+51E1 */
  0x0000,   /* U+51E2 */
  0x0000,   /* U+51E3 */
  0x0000,   /* U+51E4 */
  0x0000,   /* U+51E5 */
  0x0000,   /* U+51E6 */
  0x0000,   /* U+51E7 */
  0x0000,   /* U+51E8 */
  0x0000,   /* U+51E9 */
  0x0000,   /* U+51EA */
  0x0000,   /* U+51EB */
  0x0000,   /* U+51EC */
  0x0000,   /* U+51ED */
  0x0000,   /* U+51EE */
  0x0000,   /* U+51EF */
  0x0000,   /* U+51F0 */
  0x0000,   /* U+51F1 */
  0x0000,   /* U+51F2 */
  0x0000,   /* U+51F3 */
  0x0000,   /* U+51F4 */
  0x0000,   /* U+51F5 */
  0x0000,   /* U+51F6 */
  0x0000,   /* U+51F7 */
  0x0000,   /* U+51F8 */
  0x0000,   /* U+51F9 */
  0x0000,   /* U+51FA */
  0x0000,   /* U+51FB */
  0x0000,   /* U+51FC */
  0x0000,   /* U+51FD */
  0x0000,   /* U+51FE */
  0x0000,   /* U+51FF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+5100 */
  0x0000,   /* U+5101 */
  0x0000,   /* U+5102 */
  0x0000,   /* U+5103 */
  0x0000,   /* U+5104 */
  0x0000,   /* U+5105 */
  0x0000,   /* U+5106 */
  0x0000,   /* U+5107 */
  0x0000,   /* U+5108 */
  0x0000,   /* U+5109 */
  0x0000,   /* U+510A */
  0x0000,   /* U+510B */
  0x0000,   /* U+510C */
  0x0000,   /* U+510D */
  0x0000,   /* U+510E */
  0x0000,   /* U+510F */
  0x0000,   /* U+5110 */
  0x0000,   /* U+5111 */
  0x0000,   /* U+5112 */
  0x0000,   /* U+5113 */
  0x0000,   /* U+5114 */
  0x0000,   /* U+5115 */
  0x0000,   /* U+5116 */
  0x0000,   /* U+5117 */
  0x0000,   /* U+5118 */
  0x0000,   /* U+5119 */
  0x0000,   /* U+511A */
  0x0000,   /* U+511B */
  0x0000,   /* U+511C */
  0x0000,   /* U+511D */
  0x0000,   /* U+511E */
  0x0000,   /* U+511F */
  0x0000,   /* U+5120 */
  0x0000,   /* U+5121 */
  0x0000,   /* U+5122 */
  0x0000,   /* U+5123 */
  0x0000,   /* U+5124 */
  0x0000,   /* U+5125 */
  0x0000,   /* U+5126 */
  0x0000,   /* U+5127 */
  0x0000,   /* U+5128 */
  0x0000,   /* U+5129 */
  0x0000,   /* U+512A */
  0x0000,   /* U+512B */
  0x0000,   /* U+512C */
  0x0000,   /* U+512D */
  0x0000,   /* U+512E */
  0x0000,   /* U+512F */
  0x0000,   /* U+5130 */
  0x0000,   /* U+5131 */
  0x0000,   /* U+5132 */
  0x0000,   /* U+5133 */
  0x0000,   /* U+5134 */
  0x0000,   /* U+5135 */
  0x0000,   /* U+5136 */
  0x0000,   /* U+5137 */
  0x0000,   /* U+5138 */
  0x0000,   /* U+5139 */
  0x0000,   /* U+513A */
  0x0000,   /* U+513B */
  0x0000,   /* U+513C */
  0x0000,   /* U+513D */
  0x0000,   /* U+513E */
  0x0000,   /* U+513F */
  0x0000,   /* U+5140 */
  0x0000,   /* U+5141 */
  0x0000,   /* U+5142 */
  0x0000,   /* U+5143 */
  0x0000,   /* U+5144 */
  0x0000,   /* U+5145 */
  0x0000,   /* U+5146 */
  0x0000,   /* U+5147 */
  0x0000,   /* U+5148 */
  0x0000,   /* U+5149 */
  0x0000,   /* U+514A */
  0x0000,   /* U+514B */
  0x0000,   /* U+514C */
  0x0000,   /* U+514D */
  0x0000,   /* U+514E */
  0x0000,   /* U+514F */
  0x0000,   /* U+5150 */
  0x0000,   /* U+5151 */
  0x0000,   /* U+5152 */
  0x0000,   /* U+5153 */
  0x0000,   /* U+5154 */
  0x0000,   /* U+5155 */
  0x0000,   /* U+5156 */
  0x0000,   /* U+5157 */
  0x0000,   /* U+5158 */
  0x0000,   /* U+5159 */
  0x0000,   /* U+515A */
  0x0000,   /* U+515B */
  0x0000,   /* U+515C */
  0x0000,   /* U+515D */
  0x0000,   /* U+515E */
  0x0000,   /* U+515F */
  0x0000,   /* U+5160 */
  0x0000,   /* U+5161 */
  0x0000,   /* U+5162 */
  0x0000,   /* U+5163 */
  0x0000,   /* U+5164 */
  0x0000,   /* U+5165 */
  0x0000,   /* U+5166 */
  0x0000,   /* U+5167 */
  0x0000,   /* U+5168 */
  0x0000,   /* U+5169 */
  0x0000,   /* U+516A */
  0x0000,   /* U+516B */
  0x0000,   /* U+516C */
  0x0000,   /* U+516D */
  0x0000,   /* U+516E */
  0x0000,   /* U+516F */
  0x0000,   /* U+5170 */
  0x0000,   /* U+5171 */
  0x0000,   /* U+5172 */
  0x0000,   /* U+5173 */
  0x0000,   /* U+5174 */
  0x0000,   /* U+5175 */
  0x0000,   /* U+5176 */
  0x0000,   /* U+5177 */
  0x0000,   /* U+5178 */
  0x0000,   /* U+5179 */
  0x0000,   /* U+517A */
  0x0000,   /* U+517B */
  0x0000,   /* U+517C */
  0x0000,   /* U+517D */
  0x0000,   /* U+517E */
  0x0000,   /* U+517F */
  0x0000,   /* U+5180 */
  0x0000,   /* U+5181 */
  0x0000,   /* U+5182 */
  0x0000,   /* U+5183 */
  0x0000,   /* U+5184 */
  0x0000,   /* U+5185 */
  0x0000,   /* U+5186 */
  0x0000,   /* U+5187 */
  0x0000,   /* U+5188 */
  0x0000,   /* U+5189 */
  0x0000,   /* U+518A */
  0x0000,   /* U+518B */
  0x0000,   /* U+518C */
  0x0000,   /* U+518D */
  0x0000,   /* U+518E */
  0x0000,   /* U+518F */
  0x0000,   /* U+5190 */
  0x0000,   /* U+5191 */
  0x0000,   /* U+5192 */
  0x0000,   /* U+5193 */
  0x0000,   /* U+5194 */
  0x0000,   /* U+5195 */
  0x0000,   /* U+5196 */
  0x0000,   /* U+5197 */
  0x0000,   /* U+5198 */
  0x0000,   /* U+5199 */
  0x0000,   /* U+519A */
  0x0000,   /* U+519B */
  0x0000,   /* U+519C */
  0x0000,   /* U+519D */
  0x0000,   /* U+519E */
  0x0000,   /* U+519F */
  0x0000,   /* U+51A0 */
  0x0000,   /* U+51A1 */
  0x0000,   /* U+51A2 */
  0x0000,   /* U+51A3 */
  0x0000,   /* U+51A4 */
  0x0000,   /* U+51A5 */
  0x0000,   /* U+51A6 */
  0x0000,   /* U+51A7 */
  0x0000,   /* U+51A8 */
  0x0000,   /* U+51A9 */
  0x0000,   /* U+51AA */
  0x0000,   /* U+51AB */
  0x0000,   /* U+51AC */
  0x0000,   /* U+51AD */
  0x0000,   /* U+51AE */
  0x0000,   /* U+51AF */
  0x0000,   /* U+51B0 */
  0x0000,   /* U+51B1 */
  0x0000,   /* U+51B2 */
  0x0000,   /* U+51B3 */
  0x0000,   /* U+51B4 */
  0x0000,   /* U+51B5 */
  0x0000,   /* U+51B6 */
  0x0000,   /* U+51B7 */
  0x0000,   /* U+51B8 */
  0x0000,   /* U+51B9 */
  0x0000,   /* U+51BA */
  0x0000,   /* U+51BB */
  0x0000,   /* U+51BC */
  0x0000,   /* U+51BD */
  0x0000,   /* U+51BE */
  0x0000,   /* U+51BF */
  0x0000,   /* U+51C0 */
  0x0000,   /* U+51C1 */
  0x0000,   /* U+51C2 */
  0x0000,   /* U+51C3 */
  0x0000,   /* U+51C4 */
  0x0000,   /* U+51C5 */
  0x0000,   /* U+51C6 */
  0x0000,   /* U+51C7 */
  0x0000,   /* U+51C8 */
  0x0000,   /* U+51C9 */
  0x0000,   /* U+51CA */
  0x0000,   /* U+51CB */
  0x0000,   /* U+51CC */
  0x0000,   /* U+51CD */
  0x0000,   /* U+51CE */
  0x0000,   /* U+51CF */
  0x0000,   /* U+51D0 */
  0x0000,   /* U+51D1 */
  0x0000,   /* U+51D2 */
  0x0000,   /* U+51D3 */
  0x0000,   /* U+51D4 */
  0x0000,   /* U+51D5 */
  0x0000,   /* U+51D6 */
  0x0000,   /* U+51D7 */
  0x0000,   /* U+51D8 */
  0x0000,   /* U+51D9 */
  0x0000,   /* U+51DA */
  0x0000,   /* U+51DB */
  0x0000,   /* U+51DC */
  0x0000,   /* U+51DD */
  0x0000,   /* U+51DE */
  0x0000,   /* U+51DF */
  0x0000,   /* U+51E0 */
  0x0000,   /* U+51E1 */
  0x0000,   /* U+51E2 */
  0x0000,   /* U+51E3 */
  0x0000,   /* U+51E4 */
  0x0000,   /* U+51E5 */
  0x0000,   /* U+51E6 */
  0x0000,   /* U+51E7 */
  0x0000,   /* U+51E8 */
  0x0000,   /* U+51E9 */
  0x0000,   /* U+51EA */
  0x0000,   /* U+51EB */
  0x0000,   /* U+51EC */
  0x0000,   /* U+51ED */
  0x0000,   /* U+51EE */
  0x0000,   /* U+51EF */
  0x0000,   /* U+51F0 */
  0x0000,   /* U+51F1 */
  0x0000,   /* U+51F2 */
  0x0000,   /* U+51F3 */
  0x0000,   /* U+51F4 */
  0x0000,   /* U+51F5 */
  0x0000,   /* U+51F6 */
  0x0000,   /* U+51F7 */
  0x0000,   /* U+51F8 */
  0x0000,   /* U+51F9 */
  0x0000,   /* U+51FA */
  0x0000,   /* U+51FB */
  0x0000,   /* U+51FC */
  0x0000,   /* U+51FD */
  0x0000,   /* U+51FE */
  0x0000,   /* U+51FF */
};

uint16 ja_han_page52[]= {
  /* Number of CEs for each character. */
  1, 2, 2, 1, 1, 2, 1, 1, 1, 2, 1, 1, 2, 2, 1, 2,
  2, 1, 2, 2, 1, 2, 2, 1, 2, 2, 2, 2, 2, 1, 2, 2,
  2, 2, 2, 2, 1, 1, 2, 1, 2, 1, 1, 2, 2, 2, 1, 2,
  1, 2, 2, 1, 2, 2, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2,
  2, 2, 2, 1, 1, 2, 2, 1, 2, 2, 1, 1, 1, 1, 2, 1,
  2, 2, 2, 2, 1, 2, 1, 2, 2, 2, 2, 1, 2, 2, 1, 2,
  2, 2, 2, 1, 1, 1, 2, 2, 2, 1, 1, 2, 2, 2, 2, 1,
  1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 1, 2, 1,
  2, 2, 2, 1, 2, 2, 2, 1, 1, 1, 2, 2, 2, 1, 2, 2,
  2, 1, 1, 2, 1, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 1,
  1, 2, 2, 1, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 2, 2,
  2, 1, 2, 2, 1, 1, 2, 2, 2, 1, 2, 2, 1, 2, 1, 2,
  2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 2, 2, 1, 2, 2,
  2, 2, 1, 2, 2, 1, 2, 1, 1, 1, 2, 2, 2, 1, 1, 1,
  1, 2, 1, 1, 1, 2, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 1, 1, 2, 1, 2, 2, 1, 1, 1, 2, 2, 2, 1, 1,

  /* Primary weight 1 for each character. */
  0x5C9A,   /* U+5200 */
  0xFB40,   /* U+5201 */
  0xFB40,   /* U+5202 */
  0x5A54,   /* U+5203 */
  0x60D9,   /* U+5204 */
  0xFB40,   /* U+5205 */
  0x5E3B,   /* U+5206 */
  0x5ABD,   /* U+5207 */
  0x561D,   /* U+5208 */
  0xFB40,   /* U+5209 */
  0x5624,   /* U+520A */
  0x60DA,   /* U+520B */
  0xFB40,   /* U+520C */
  0xFB40,   /* U+520D */
  0x60DC,   /* U+520E */
  0xFB40,   /* U+520F */
  0xFB40,   /* U+5210 */
  0x574F,   /* U+5211 */
  0xFB40,   /* U+5212 */
  0xFB40,   /* U+5213 */
  0x60DB,   /* U+5214 */
  0xFB40,   /* U+5215 */
  0xFB40,   /* U+5216 */
  0x5FFA,   /* U+5217 */
  0xFB40,   /* U+5218 */
  0xFB40,   /* U+5219 */
  0xFB40,   /* U+521A */
  0xFB40,   /* U+521B */
  0xFB40,   /* U+521C */
  0x59B2,   /* U+521D */
  0xFB40,   /* U+521E */
  0xFB40,   /* U+521F */
  0xFB40,   /* U+5220 */
  0xFB40,   /* U+5221 */
  0xFB40,   /* U+5222 */
  0xFB40,   /* U+5223 */
  0x5D90,   /* U+5224 */
  0x5E5B,   /* U+5225 */
  0xFB40,   /* U+5226 */
  0x60DD,   /* U+5227 */
  0xFB40,   /* U+5228 */
  0x5FA1,   /* U+5229 */
  0x60DE,   /* U+522A */
  0xFB40,   /* U+522B */
  0xFB40,   /* U+522C */
  0xFB40,   /* U+522D */
  0x60DF,   /* U+522E */
  0xFB40,   /* U+522F */
  0x5CB7,   /* U+5230 */
  0xFB40,   /* U+5231 */
  0xFB40,   /* U+5232 */
  0x60E0,   /* U+5233 */
  0xFB40,   /* U+5234 */
  0xFB40,   /* U+5235 */
  0x5A8C,   /* U+5236 */
  0x58AD,   /* U+5237 */
  0x5789,   /* U+5238 */
  0x60E1,   /* U+5239 */
  0x58D6,   /* U+523A */
  0x5840,   /* U+523B */
  0xFB40,   /* U+523C */
  0xFB40,   /* U+523D */
  0xFB40,   /* U+523E */
  0xFB40,   /* U+523F */
  0xFB40,   /* U+5240 */
  0xFB40,   /* U+5241 */
  0xFB40,   /* U+5242 */
  0x5C41,   /* U+5243 */
  0x60E3,   /* U+5244 */
  0xFB40,   /* U+5245 */
  0xFB40,   /* U+5246 */
  0x5B46,   /* U+5247 */
  0xFB40,   /* U+5248 */
  0xFB40,   /* U+5249 */
  0x589E,   /* U+524A */
  0x60E4,   /* U+524B */
  0x60E5,   /* U+524C */
  0x5AF1,   /* U+524D */
  0xFB40,   /* U+524E */
  0x60E2,   /* U+524F */
  0xFB40,   /* U+5250 */
  0xFB40,   /* U+5251 */
  0xFB40,   /* U+5252 */
  0xFB40,   /* U+5253 */
  0x60E7,   /* U+5254 */
  0xFB40,   /* U+5255 */
  0x5EA3,   /* U+5256 */
  0xFB40,   /* U+5257 */
  0xFB40,   /* U+5258 */
  0xFB40,   /* U+5259 */
  0xFB40,   /* U+525A */
  0x5835,   /* U+525B */
  0xFB40,   /* U+525C */
  0xFB40,   /* U+525D */
  0x60E6,   /* U+525E */
  0xFB40,   /* U+525F */
  0xFB40,   /* U+5260 */
  0xFB40,   /* U+5261 */
  0xFB40,   /* U+5262 */
  0x578A,   /* U+5263 */
  0x588D,   /* U+5264 */
  0x5D62,   /* U+5265 */
  0xFB40,   /* U+5266 */
  0xFB40,   /* U+5267 */
  0xFB40,   /* U+5268 */
  0x60EA,   /* U+5269 */
  0x60E8,   /* U+526A */
  0xFB40,   /* U+526B */
  0xFB40,   /* U+526C */
  0xFB40,   /* U+526D */
  0xFB40,   /* U+526E */
  0x5E2C,   /* U+526F */
  0x5A11,   /* U+5270 */
  0x60F1,   /* U+5271 */
  0x5601,   /* U+5272 */
  0x60EB,   /* U+5273 */
  0x60E9,   /* U+5274 */
  0x5B10,   /* U+5275 */
  0xFB40,   /* U+5276 */
  0xFB40,   /* U+5277 */
  0xFB40,   /* U+5278 */
  0xFB40,   /* U+5279 */
  0xFB40,   /* U+527A */
  0xFB40,   /* U+527B */
  0xFB40,   /* U+527C */
  0x60ED,   /* U+527D */
  0xFB40,   /* U+527E */
  0x60EC,   /* U+527F */
  0xFB40,   /* U+5280 */
  0xFB40,   /* U+5281 */
  0xFB40,   /* U+5282 */
  0x55E1,   /* U+5283 */
  0xFB40,   /* U+5284 */
  0xFB40,   /* U+5285 */
  0xFB40,   /* U+5286 */
  0x5775,   /* U+5287 */
  0x60F2,   /* U+5288 */
  0x5FB4,   /* U+5289 */
  0xFB40,   /* U+528A */
  0xFB40,   /* U+528B */
  0xFB40,   /* U+528C */
  0x60EE,   /* U+528D */
  0xFB40,   /* U+528E */
  0xFB40,   /* U+528F */
  0xFB40,   /* U+5290 */
  0x60F3,   /* U+5291 */
  0x60F0,   /* U+5292 */
  0xFB40,   /* U+5293 */
  0x60EF,   /* U+5294 */
  0xFB40,   /* U+5295 */
  0xFB40,   /* U+5296 */
  0xFB40,   /* U+5297 */
  0xFB40,   /* U+5298 */
  0xFB40,   /* U+5299 */
  0xFB40,   /* U+529A */
  0x5FD6,   /* U+529B */
  0xFB40,   /* U+529C */
  0xFB40,   /* U+529D */
  0xFB40,   /* U+529E */
  0x57EC,   /* U+529F */
  0x5582,   /* U+52A0 */
  0xFB40,   /* U+52A1 */
  0xFB40,   /* U+52A2 */
  0x5FFB,   /* U+52A3 */
  0xFB40,   /* U+52A4 */
  0xFB40,   /* U+52A5 */
  0xFB40,   /* U+52A6 */
  0xFB40,   /* U+52A7 */
  0xFB40,   /* U+52A8 */
  0x59BE,   /* U+52A9 */
  0x5C91,   /* U+52AA */
  0x5836,   /* U+52AB */
  0x60F6,   /* U+52AC */
  0x60F7,   /* U+52AD */
  0xFB40,   /* U+52AE */
  0xFB40,   /* U+52AF */
  0xFB40,   /* U+52B0 */
  0x5FEC,   /* U+52B1 */
  0xFB40,   /* U+52B2 */
  0xFB40,   /* U+52B3 */
  0x6010,   /* U+52B4 */
  0x60F9,   /* U+52B5 */
  0xFB40,   /* U+52B6 */
  0xFB40,   /* U+52B7 */
  0xFB40,   /* U+52B8 */
  0x57ED,   /* U+52B9 */
  0xFB40,   /* U+52BA */
  0xFB40,   /* U+52BB */
  0x60F8,   /* U+52BC */
  0xFB40,   /* U+52BD */
  0x55CC,   /* U+52BE */
  0xFB40,   /* U+52BF */
  0xFB40,   /* U+52C0 */
  0x60FA,   /* U+52C1 */
  0xFB40,   /* U+52C2 */
  0x5EC3,   /* U+52C3 */
  0xFB40,   /* U+52C4 */
  0x5C17,   /* U+52C5 */
  0xFB40,   /* U+52C6 */
  0x5F4F,   /* U+52C7 */
  0xFB40,   /* U+52C8 */
  0x5E68,   /* U+52C9 */
  0xFB40,   /* U+52CA */
  0xFB40,   /* U+52CB */
  0xFB40,   /* U+52CC */
  0x60FB,   /* U+52CD */
  0xFB40,   /* U+52CE */
  0xFB40,   /* U+52CF */
  0xFB40,   /* U+52D0 */
  0xFB40,   /* U+52D1 */
  0x6C2D,   /* U+52D2 */
  0xFB40,   /* U+52D3 */
  0xFB40,   /* U+52D4 */
  0x5CC7,   /* U+52D5 */
  0xFB40,   /* U+52D6 */
  0x60FC,   /* U+52D7 */
  0x5625,   /* U+52D8 */
  0x5EFE,   /* U+52D9 */
  0xFB40,   /* U+52DA */
  0xFB40,   /* U+52DB */
  0xFB40,   /* U+52DC */
  0x59C8,   /* U+52DD */
  0x60FD,   /* U+52DE */
  0x5E76,   /* U+52DF */
  0x6101,   /* U+52E0 */
  0xFB40,   /* U+52E1 */
  0x5A8D,   /* U+52E2 */
  0x60FE,   /* U+52E3 */
  0x5707,   /* U+52E4 */
  0xFB40,   /* U+52E5 */
  0x60FF,   /* U+52E6 */
  0x5626,   /* U+52E7 */
  0xFB40,   /* U+52E8 */
  0xFB40,   /* U+52E9 */
  0xFB40,   /* U+52EA */
  0xFB40,   /* U+52EB */
  0xFB40,   /* U+52EC */
  0xFB40,   /* U+52ED */
  0xFB40,   /* U+52EE */
  0xFB40,   /* U+52EF */
  0xFB40,   /* U+52F0 */
  0xFB40,   /* U+52F1 */
  0x5743,   /* U+52F2 */
  0x6102,   /* U+52F3 */
  0xFB40,   /* U+52F4 */
  0x6103,   /* U+52F5 */
  0xFB40,   /* U+52F6 */
  0xFB40,   /* U+52F7 */
  0x6104,   /* U+52F8 */
  0x6105,   /* U+52F9 */
  0x5946,   /* U+52FA */
  0xFB40,   /* U+52FB */
  0xFB40,   /* U+52FC */
  0xFB40,   /* U+52FD */
  0x57EE,   /* U+52FE */
  0x5F29,   /* U+52FF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+5200 */
  0x0020,   /* U+5201 */
  0x0020,   /* U+5202 */
  0x0020,   /* U+5203 */
  0x0020,   /* U+5204 */
  0x0020,   /* U+5205 */
  0x0020,   /* U+5206 */
  0x0020,   /* U+5207 */
  0x0020,   /* U+5208 */
  0x0020,   /* U+5209 */
  0x0020,   /* U+520A */
  0x0020,   /* U+520B */
  0x0020,   /* U+520C */
  0x0020,   /* U+520D */
  0x0020,   /* U+520E */
  0x0020,   /* U+520F */
  0x0020,   /* U+5210 */
  0x0020,   /* U+5211 */
  0x0020,   /* U+5212 */
  0x0020,   /* U+5213 */
  0x0020,   /* U+5214 */
  0x0020,   /* U+5215 */
  0x0020,   /* U+5216 */
  0x0020,   /* U+5217 */
  0x0020,   /* U+5218 */
  0x0020,   /* U+5219 */
  0x0020,   /* U+521A */
  0x0020,   /* U+521B */
  0x0020,   /* U+521C */
  0x0020,   /* U+521D */
  0x0020,   /* U+521E */
  0x0020,   /* U+521F */
  0x0020,   /* U+5220 */
  0x0020,   /* U+5221 */
  0x0020,   /* U+5222 */
  0x0020,   /* U+5223 */
  0x0020,   /* U+5224 */
  0x0020,   /* U+5225 */
  0x0020,   /* U+5226 */
  0x0020,   /* U+5227 */
  0x0020,   /* U+5228 */
  0x0020,   /* U+5229 */
  0x0020,   /* U+522A */
  0x0020,   /* U+522B */
  0x0020,   /* U+522C */
  0x0020,   /* U+522D */
  0x0020,   /* U+522E */
  0x0020,   /* U+522F */
  0x0020,   /* U+5230 */
  0x0020,   /* U+5231 */
  0x0020,   /* U+5232 */
  0x0020,   /* U+5233 */
  0x0020,   /* U+5234 */
  0x0020,   /* U+5235 */
  0x0020,   /* U+5236 */
  0x0020,   /* U+5237 */
  0x0020,   /* U+5238 */
  0x0020,   /* U+5239 */
  0x0020,   /* U+523A */
  0x0020,   /* U+523B */
  0x0020,   /* U+523C */
  0x0020,   /* U+523D */
  0x0020,   /* U+523E */
  0x0020,   /* U+523F */
  0x0020,   /* U+5240 */
  0x0020,   /* U+5241 */
  0x0020,   /* U+5242 */
  0x0020,   /* U+5243 */
  0x0020,   /* U+5244 */
  0x0020,   /* U+5245 */
  0x0020,   /* U+5246 */
  0x0020,   /* U+5247 */
  0x0020,   /* U+5248 */
  0x0020,   /* U+5249 */
  0x0020,   /* U+524A */
  0x0020,   /* U+524B */
  0x0020,   /* U+524C */
  0x0020,   /* U+524D */
  0x0020,   /* U+524E */
  0x0020,   /* U+524F */
  0x0020,   /* U+5250 */
  0x0020,   /* U+5251 */
  0x0020,   /* U+5252 */
  0x0020,   /* U+5253 */
  0x0020,   /* U+5254 */
  0x0020,   /* U+5255 */
  0x0020,   /* U+5256 */
  0x0020,   /* U+5257 */
  0x0020,   /* U+5258 */
  0x0020,   /* U+5259 */
  0x0020,   /* U+525A */
  0x0020,   /* U+525B */
  0x0020,   /* U+525C */
  0x0020,   /* U+525D */
  0x0020,   /* U+525E */
  0x0020,   /* U+525F */
  0x0020,   /* U+5260 */
  0x0020,   /* U+5261 */
  0x0020,   /* U+5262 */
  0x0020,   /* U+5263 */
  0x0020,   /* U+5264 */
  0x0020,   /* U+5265 */
  0x0020,   /* U+5266 */
  0x0020,   /* U+5267 */
  0x0020,   /* U+5268 */
  0x0020,   /* U+5269 */
  0x0020,   /* U+526A */
  0x0020,   /* U+526B */
  0x0020,   /* U+526C */
  0x0020,   /* U+526D */
  0x0020,   /* U+526E */
  0x0020,   /* U+526F */
  0x0020,   /* U+5270 */
  0x0020,   /* U+5271 */
  0x0020,   /* U+5272 */
  0x0020,   /* U+5273 */
  0x0020,   /* U+5274 */
  0x0020,   /* U+5275 */
  0x0020,   /* U+5276 */
  0x0020,   /* U+5277 */
  0x0020,   /* U+5278 */
  0x0020,   /* U+5279 */
  0x0020,   /* U+527A */
  0x0020,   /* U+527B */
  0x0020,   /* U+527C */
  0x0020,   /* U+527D */
  0x0020,   /* U+527E */
  0x0020,   /* U+527F */
  0x0020,   /* U+5280 */
  0x0020,   /* U+5281 */
  0x0020,   /* U+5282 */
  0x0020,   /* U+5283 */
  0x0020,   /* U+5284 */
  0x0020,   /* U+5285 */
  0x0020,   /* U+5286 */
  0x0020,   /* U+5287 */
  0x0020,   /* U+5288 */
  0x0020,   /* U+5289 */
  0x0020,   /* U+528A */
  0x0020,   /* U+528B */
  0x0020,   /* U+528C */
  0x0020,   /* U+528D */
  0x0020,   /* U+528E */
  0x0020,   /* U+528F */
  0x0020,   /* U+5290 */
  0x0020,   /* U+5291 */
  0x0020,   /* U+5292 */
  0x0020,   /* U+5293 */
  0x0020,   /* U+5294 */
  0x0020,   /* U+5295 */
  0x0020,   /* U+5296 */
  0x0020,   /* U+5297 */
  0x0020,   /* U+5298 */
  0x0020,   /* U+5299 */
  0x0020,   /* U+529A */
  0x0020,   /* U+529B */
  0x0020,   /* U+529C */
  0x0020,   /* U+529D */
  0x0020,   /* U+529E */
  0x0020,   /* U+529F */
  0x0020,   /* U+52A0 */
  0x0020,   /* U+52A1 */
  0x0020,   /* U+52A2 */
  0x0020,   /* U+52A3 */
  0x0020,   /* U+52A4 */
  0x0020,   /* U+52A5 */
  0x0020,   /* U+52A6 */
  0x0020,   /* U+52A7 */
  0x0020,   /* U+52A8 */
  0x0020,   /* U+52A9 */
  0x0020,   /* U+52AA */
  0x0020,   /* U+52AB */
  0x0020,   /* U+52AC */
  0x0020,   /* U+52AD */
  0x0020,   /* U+52AE */
  0x0020,   /* U+52AF */
  0x0020,   /* U+52B0 */
  0x0020,   /* U+52B1 */
  0x0020,   /* U+52B2 */
  0x0020,   /* U+52B3 */
  0x0020,   /* U+52B4 */
  0x0020,   /* U+52B5 */
  0x0020,   /* U+52B6 */
  0x0020,   /* U+52B7 */
  0x0020,   /* U+52B8 */
  0x0020,   /* U+52B9 */
  0x0020,   /* U+52BA */
  0x0020,   /* U+52BB */
  0x0020,   /* U+52BC */
  0x0020,   /* U+52BD */
  0x0020,   /* U+52BE */
  0x0020,   /* U+52BF */
  0x0020,   /* U+52C0 */
  0x0020,   /* U+52C1 */
  0x0020,   /* U+52C2 */
  0x0020,   /* U+52C3 */
  0x0020,   /* U+52C4 */
  0x0020,   /* U+52C5 */
  0x0020,   /* U+52C6 */
  0x0020,   /* U+52C7 */
  0x0020,   /* U+52C8 */
  0x0020,   /* U+52C9 */
  0x0020,   /* U+52CA */
  0x0020,   /* U+52CB */
  0x0020,   /* U+52CC */
  0x0020,   /* U+52CD */
  0x0020,   /* U+52CE */
  0x0020,   /* U+52CF */
  0x0020,   /* U+52D0 */
  0x0020,   /* U+52D1 */
  0x0020,   /* U+52D2 */
  0x0020,   /* U+52D3 */
  0x0020,   /* U+52D4 */
  0x0020,   /* U+52D5 */
  0x0020,   /* U+52D6 */
  0x0020,   /* U+52D7 */
  0x0020,   /* U+52D8 */
  0x0020,   /* U+52D9 */
  0x0020,   /* U+52DA */
  0x0020,   /* U+52DB */
  0x0020,   /* U+52DC */
  0x0020,   /* U+52DD */
  0x0020,   /* U+52DE */
  0x0020,   /* U+52DF */
  0x0020,   /* U+52E0 */
  0x0020,   /* U+52E1 */
  0x0020,   /* U+52E2 */
  0x0020,   /* U+52E3 */
  0x0020,   /* U+52E4 */
  0x0020,   /* U+52E5 */
  0x0020,   /* U+52E6 */
  0x0020,   /* U+52E7 */
  0x0020,   /* U+52E8 */
  0x0020,   /* U+52E9 */
  0x0020,   /* U+52EA */
  0x0020,   /* U+52EB */
  0x0020,   /* U+52EC */
  0x0020,   /* U+52ED */
  0x0020,   /* U+52EE */
  0x0020,   /* U+52EF */
  0x0020,   /* U+52F0 */
  0x0020,   /* U+52F1 */
  0x0020,   /* U+52F2 */
  0x0020,   /* U+52F3 */
  0x0020,   /* U+52F4 */
  0x0020,   /* U+52F5 */
  0x0020,   /* U+52F6 */
  0x0020,   /* U+52F7 */
  0x0020,   /* U+52F8 */
  0x0020,   /* U+52F9 */
  0x0020,   /* U+52FA */
  0x0020,   /* U+52FB */
  0x0020,   /* U+52FC */
  0x0020,   /* U+52FD */
  0x0020,   /* U+52FE */
  0x0020,   /* U+52FF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+5200 */
  0x0002,   /* U+5201 */
  0x0002,   /* U+5202 */
  0x0002,   /* U+5203 */
  0x0002,   /* U+5204 */
  0x0002,   /* U+5205 */
  0x0002,   /* U+5206 */
  0x0002,   /* U+5207 */
  0x0002,   /* U+5208 */
  0x0002,   /* U+5209 */
  0x0002,   /* U+520A */
  0x0002,   /* U+520B */
  0x0002,   /* U+520C */
  0x0002,   /* U+520D */
  0x0002,   /* U+520E */
  0x0002,   /* U+520F */
  0x0002,   /* U+5210 */
  0x0002,   /* U+5211 */
  0x0002,   /* U+5212 */
  0x0002,   /* U+5213 */
  0x0002,   /* U+5214 */
  0x0002,   /* U+5215 */
  0x0002,   /* U+5216 */
  0x0002,   /* U+5217 */
  0x0002,   /* U+5218 */
  0x0002,   /* U+5219 */
  0x0002,   /* U+521A */
  0x0002,   /* U+521B */
  0x0002,   /* U+521C */
  0x0002,   /* U+521D */
  0x0002,   /* U+521E */
  0x0002,   /* U+521F */
  0x0002,   /* U+5220 */
  0x0002,   /* U+5221 */
  0x0002,   /* U+5222 */
  0x0002,   /* U+5223 */
  0x0002,   /* U+5224 */
  0x0002,   /* U+5225 */
  0x0002,   /* U+5226 */
  0x0002,   /* U+5227 */
  0x0002,   /* U+5228 */
  0x0002,   /* U+5229 */
  0x0002,   /* U+522A */
  0x0002,   /* U+522B */
  0x0002,   /* U+522C */
  0x0002,   /* U+522D */
  0x0002,   /* U+522E */
  0x0002,   /* U+522F */
  0x0002,   /* U+5230 */
  0x0002,   /* U+5231 */
  0x0002,   /* U+5232 */
  0x0002,   /* U+5233 */
  0x0002,   /* U+5234 */
  0x0002,   /* U+5235 */
  0x0002,   /* U+5236 */
  0x0002,   /* U+5237 */
  0x0002,   /* U+5238 */
  0x0002,   /* U+5239 */
  0x0002,   /* U+523A */
  0x0002,   /* U+523B */
  0x0002,   /* U+523C */
  0x0002,   /* U+523D */
  0x0002,   /* U+523E */
  0x0002,   /* U+523F */
  0x0002,   /* U+5240 */
  0x0002,   /* U+5241 */
  0x0002,   /* U+5242 */
  0x0002,   /* U+5243 */
  0x0002,   /* U+5244 */
  0x0002,   /* U+5245 */
  0x0002,   /* U+5246 */
  0x0002,   /* U+5247 */
  0x0002,   /* U+5248 */
  0x0002,   /* U+5249 */
  0x0002,   /* U+524A */
  0x0002,   /* U+524B */
  0x0002,   /* U+524C */
  0x0002,   /* U+524D */
  0x0002,   /* U+524E */
  0x0002,   /* U+524F */
  0x0002,   /* U+5250 */
  0x0002,   /* U+5251 */
  0x0002,   /* U+5252 */
  0x0002,   /* U+5253 */
  0x0002,   /* U+5254 */
  0x0002,   /* U+5255 */
  0x0002,   /* U+5256 */
  0x0002,   /* U+5257 */
  0x0002,   /* U+5258 */
  0x0002,   /* U+5259 */
  0x0002,   /* U+525A */
  0x0002,   /* U+525B */
  0x0002,   /* U+525C */
  0x0002,   /* U+525D */
  0x0002,   /* U+525E */
  0x0002,   /* U+525F */
  0x0002,   /* U+5260 */
  0x0002,   /* U+5261 */
  0x0002,   /* U+5262 */
  0x0002,   /* U+5263 */
  0x0002,   /* U+5264 */
  0x0002,   /* U+5265 */
  0x0002,   /* U+5266 */
  0x0002,   /* U+5267 */
  0x0002,   /* U+5268 */
  0x0002,   /* U+5269 */
  0x0002,   /* U+526A */
  0x0002,   /* U+526B */
  0x0002,   /* U+526C */
  0x0002,   /* U+526D */
  0x0002,   /* U+526E */
  0x0002,   /* U+526F */
  0x0002,   /* U+5270 */
  0x0002,   /* U+5271 */
  0x0002,   /* U+5272 */
  0x0002,   /* U+5273 */
  0x0002,   /* U+5274 */
  0x0002,   /* U+5275 */
  0x0002,   /* U+5276 */
  0x0002,   /* U+5277 */
  0x0002,   /* U+5278 */
  0x0002,   /* U+5279 */
  0x0002,   /* U+527A */
  0x0002,   /* U+527B */
  0x0002,   /* U+527C */
  0x0002,   /* U+527D */
  0x0002,   /* U+527E */
  0x0002,   /* U+527F */
  0x0002,   /* U+5280 */
  0x0002,   /* U+5281 */
  0x0002,   /* U+5282 */
  0x0002,   /* U+5283 */
  0x0002,   /* U+5284 */
  0x0002,   /* U+5285 */
  0x0002,   /* U+5286 */
  0x0002,   /* U+5287 */
  0x0002,   /* U+5288 */
  0x0002,   /* U+5289 */
  0x0002,   /* U+528A */
  0x0002,   /* U+528B */
  0x0002,   /* U+528C */
  0x0002,   /* U+528D */
  0x0002,   /* U+528E */
  0x0002,   /* U+528F */
  0x0002,   /* U+5290 */
  0x0002,   /* U+5291 */
  0x0002,   /* U+5292 */
  0x0002,   /* U+5293 */
  0x0002,   /* U+5294 */
  0x0002,   /* U+5295 */
  0x0002,   /* U+5296 */
  0x0002,   /* U+5297 */
  0x0002,   /* U+5298 */
  0x0002,   /* U+5299 */
  0x0002,   /* U+529A */
  0x0002,   /* U+529B */
  0x0002,   /* U+529C */
  0x0002,   /* U+529D */
  0x0002,   /* U+529E */
  0x0002,   /* U+529F */
  0x0002,   /* U+52A0 */
  0x0002,   /* U+52A1 */
  0x0002,   /* U+52A2 */
  0x0002,   /* U+52A3 */
  0x0002,   /* U+52A4 */
  0x0002,   /* U+52A5 */
  0x0002,   /* U+52A6 */
  0x0002,   /* U+52A7 */
  0x0002,   /* U+52A8 */
  0x0002,   /* U+52A9 */
  0x0002,   /* U+52AA */
  0x0002,   /* U+52AB */
  0x0002,   /* U+52AC */
  0x0002,   /* U+52AD */
  0x0002,   /* U+52AE */
  0x0002,   /* U+52AF */
  0x0002,   /* U+52B0 */
  0x0002,   /* U+52B1 */
  0x0002,   /* U+52B2 */
  0x0002,   /* U+52B3 */
  0x0002,   /* U+52B4 */
  0x0002,   /* U+52B5 */
  0x0002,   /* U+52B6 */
  0x0002,   /* U+52B7 */
  0x0002,   /* U+52B8 */
  0x0002,   /* U+52B9 */
  0x0002,   /* U+52BA */
  0x0002,   /* U+52BB */
  0x0002,   /* U+52BC */
  0x0002,   /* U+52BD */
  0x0002,   /* U+52BE */
  0x0002,   /* U+52BF */
  0x0002,   /* U+52C0 */
  0x0002,   /* U+52C1 */
  0x0002,   /* U+52C2 */
  0x0002,   /* U+52C3 */
  0x0002,   /* U+52C4 */
  0x0002,   /* U+52C5 */
  0x0002,   /* U+52C6 */
  0x0002,   /* U+52C7 */
  0x0002,   /* U+52C8 */
  0x0002,   /* U+52C9 */
  0x0002,   /* U+52CA */
  0x0002,   /* U+52CB */
  0x0002,   /* U+52CC */
  0x0002,   /* U+52CD */
  0x0002,   /* U+52CE */
  0x0002,   /* U+52CF */
  0x0002,   /* U+52D0 */
  0x0002,   /* U+52D1 */
  0x0002,   /* U+52D2 */
  0x0002,   /* U+52D3 */
  0x0002,   /* U+52D4 */
  0x0002,   /* U+52D5 */
  0x0002,   /* U+52D6 */
  0x0002,   /* U+52D7 */
  0x0002,   /* U+52D8 */
  0x0002,   /* U+52D9 */
  0x0002,   /* U+52DA */
  0x0002,   /* U+52DB */
  0x0002,   /* U+52DC */
  0x0002,   /* U+52DD */
  0x0002,   /* U+52DE */
  0x0002,   /* U+52DF */
  0x0002,   /* U+52E0 */
  0x0002,   /* U+52E1 */
  0x0002,   /* U+52E2 */
  0x0002,   /* U+52E3 */
  0x0002,   /* U+52E4 */
  0x0002,   /* U+52E5 */
  0x0002,   /* U+52E6 */
  0x0002,   /* U+52E7 */
  0x0002,   /* U+52E8 */
  0x0002,   /* U+52E9 */
  0x0002,   /* U+52EA */
  0x0002,   /* U+52EB */
  0x0002,   /* U+52EC */
  0x0002,   /* U+52ED */
  0x0002,   /* U+52EE */
  0x0002,   /* U+52EF */
  0x0002,   /* U+52F0 */
  0x0002,   /* U+52F1 */
  0x0002,   /* U+52F2 */
  0x0002,   /* U+52F3 */
  0x0002,   /* U+52F4 */
  0x0002,   /* U+52F5 */
  0x0002,   /* U+52F6 */
  0x0002,   /* U+52F7 */
  0x0002,   /* U+52F8 */
  0x0002,   /* U+52F9 */
  0x0002,   /* U+52FA */
  0x0002,   /* U+52FB */
  0x0002,   /* U+52FC */
  0x0002,   /* U+52FD */
  0x0002,   /* U+52FE */
  0x0002,   /* U+52FF */

  /* Primary weight 2 for each character. */
  0x0000,   /* U+5200 */
  0xD201,   /* U+5201 */
  0xD202,   /* U+5202 */
  0x0000,   /* U+5203 */
  0x0000,   /* U+5204 */
  0xD205,   /* U+5205 */
  0x0000,   /* U+5206 */
  0x0000,   /* U+5207 */
  0x0000,   /* U+5208 */
  0xD209,   /* U+5209 */
  0x0000,   /* U+520A */
  0x0000,   /* U+520B */
  0xD20C,   /* U+520C */
  0xD20D,   /* U+520D */
  0x0000,   /* U+520E */
  0xD20F,   /* U+520F */
  0xD210,   /* U+5210 */
  0x0000,   /* U+5211 */
  0xD212,   /* U+5212 */
  0xD213,   /* U+5213 */
  0x0000,   /* U+5214 */
  0xD215,   /* U+5215 */
  0xD216,   /* U+5216 */
  0x0000,   /* U+5217 */
  0xD218,   /* U+5218 */
  0xD219,   /* U+5219 */
  0xD21A,   /* U+521A */
  0xD21B,   /* U+521B */
  0xD21C,   /* U+521C */
  0x0000,   /* U+521D */
  0xD21E,   /* U+521E */
  0xD21F,   /* U+521F */
  0xD220,   /* U+5220 */
  0xD221,   /* U+5221 */
  0xD222,   /* U+5222 */
  0xD223,   /* U+5223 */
  0x0000,   /* U+5224 */
  0x0000,   /* U+5225 */
  0xD226,   /* U+5226 */
  0x0000,   /* U+5227 */
  0xD228,   /* U+5228 */
  0x0000,   /* U+5229 */
  0x0000,   /* U+522A */
  0xD22B,   /* U+522B */
  0xD22C,   /* U+522C */
  0xD22D,   /* U+522D */
  0x0000,   /* U+522E */
  0xD22F,   /* U+522F */
  0x0000,   /* U+5230 */
  0xD231,   /* U+5231 */
  0xD232,   /* U+5232 */
  0x0000,   /* U+5233 */
  0xD234,   /* U+5234 */
  0xD235,   /* U+5235 */
  0x0000,   /* U+5236 */
  0x0000,   /* U+5237 */
  0x0000,   /* U+5238 */
  0x0000,   /* U+5239 */
  0x0000,   /* U+523A */
  0x0000,   /* U+523B */
  0xD23C,   /* U+523C */
  0xD23D,   /* U+523D */
  0xD23E,   /* U+523E */
  0xD23F,   /* U+523F */
  0xD240,   /* U+5240 */
  0xD241,   /* U+5241 */
  0xD242,   /* U+5242 */
  0x0000,   /* U+5243 */
  0x0000,   /* U+5244 */
  0xD245,   /* U+5245 */
  0xD246,   /* U+5246 */
  0x0000,   /* U+5247 */
  0xD248,   /* U+5248 */
  0xD249,   /* U+5249 */
  0x0000,   /* U+524A */
  0x0000,   /* U+524B */
  0x0000,   /* U+524C */
  0x0000,   /* U+524D */
  0xD24E,   /* U+524E */
  0x0000,   /* U+524F */
  0xD250,   /* U+5250 */
  0xD251,   /* U+5251 */
  0xD252,   /* U+5252 */
  0xD253,   /* U+5253 */
  0x0000,   /* U+5254 */
  0xD255,   /* U+5255 */
  0x0000,   /* U+5256 */
  0xD257,   /* U+5257 */
  0xD258,   /* U+5258 */
  0xD259,   /* U+5259 */
  0xD25A,   /* U+525A */
  0x0000,   /* U+525B */
  0xD25C,   /* U+525C */
  0xD25D,   /* U+525D */
  0x0000,   /* U+525E */
  0xD25F,   /* U+525F */
  0xD260,   /* U+5260 */
  0xD261,   /* U+5261 */
  0xD262,   /* U+5262 */
  0x0000,   /* U+5263 */
  0x0000,   /* U+5264 */
  0x0000,   /* U+5265 */
  0xD266,   /* U+5266 */
  0xD267,   /* U+5267 */
  0xD268,   /* U+5268 */
  0x0000,   /* U+5269 */
  0x0000,   /* U+526A */
  0xD26B,   /* U+526B */
  0xD26C,   /* U+526C */
  0xD26D,   /* U+526D */
  0xD26E,   /* U+526E */
  0x0000,   /* U+526F */
  0x0000,   /* U+5270 */
  0x0000,   /* U+5271 */
  0x0000,   /* U+5272 */
  0x0000,   /* U+5273 */
  0x0000,   /* U+5274 */
  0x0000,   /* U+5275 */
  0xD276,   /* U+5276 */
  0xD277,   /* U+5277 */
  0xD278,   /* U+5278 */
  0xD279,   /* U+5279 */
  0xD27A,   /* U+527A */
  0xD27B,   /* U+527B */
  0xD27C,   /* U+527C */
  0x0000,   /* U+527D */
  0xD27E,   /* U+527E */
  0x0000,   /* U+527F */
  0xD280,   /* U+5280 */
  0xD281,   /* U+5281 */
  0xD282,   /* U+5282 */
  0x0000,   /* U+5283 */
  0xD284,   /* U+5284 */
  0xD285,   /* U+5285 */
  0xD286,   /* U+5286 */
  0x0000,   /* U+5287 */
  0x0000,   /* U+5288 */
  0x0000,   /* U+5289 */
  0xD28A,   /* U+528A */
  0xD28B,   /* U+528B */
  0xD28C,   /* U+528C */
  0x0000,   /* U+528D */
  0xD28E,   /* U+528E */
  0xD28F,   /* U+528F */
  0xD290,   /* U+5290 */
  0x0000,   /* U+5291 */
  0x0000,   /* U+5292 */
  0xD293,   /* U+5293 */
  0x0000,   /* U+5294 */
  0xD295,   /* U+5295 */
  0xD296,   /* U+5296 */
  0xD297,   /* U+5297 */
  0xD298,   /* U+5298 */
  0xD299,   /* U+5299 */
  0xD29A,   /* U+529A */
  0x0000,   /* U+529B */
  0xD29C,   /* U+529C */
  0xD29D,   /* U+529D */
  0xD29E,   /* U+529E */
  0x0000,   /* U+529F */
  0x0000,   /* U+52A0 */
  0xD2A1,   /* U+52A1 */
  0xD2A2,   /* U+52A2 */
  0x0000,   /* U+52A3 */
  0xD2A4,   /* U+52A4 */
  0xD2A5,   /* U+52A5 */
  0xD2A6,   /* U+52A6 */
  0xD2A7,   /* U+52A7 */
  0xD2A8,   /* U+52A8 */
  0x0000,   /* U+52A9 */
  0x0000,   /* U+52AA */
  0x0000,   /* U+52AB */
  0x0000,   /* U+52AC */
  0x0000,   /* U+52AD */
  0xD2AE,   /* U+52AE */
  0xD2AF,   /* U+52AF */
  0xD2B0,   /* U+52B0 */
  0x0000,   /* U+52B1 */
  0xD2B2,   /* U+52B2 */
  0xD2B3,   /* U+52B3 */
  0x0000,   /* U+52B4 */
  0x0000,   /* U+52B5 */
  0xD2B6,   /* U+52B6 */
  0xD2B7,   /* U+52B7 */
  0xD2B8,   /* U+52B8 */
  0x0000,   /* U+52B9 */
  0xD2BA,   /* U+52BA */
  0xD2BB,   /* U+52BB */
  0x0000,   /* U+52BC */
  0xD2BD,   /* U+52BD */
  0x0000,   /* U+52BE */
  0xD2BF,   /* U+52BF */
  0xD2C0,   /* U+52C0 */
  0x0000,   /* U+52C1 */
  0xD2C2,   /* U+52C2 */
  0x0000,   /* U+52C3 */
  0xD2C4,   /* U+52C4 */
  0x0000,   /* U+52C5 */
  0xD2C6,   /* U+52C6 */
  0x0000,   /* U+52C7 */
  0xD2C8,   /* U+52C8 */
  0x0000,   /* U+52C9 */
  0xD2CA,   /* U+52CA */
  0xD2CB,   /* U+52CB */
  0xD2CC,   /* U+52CC */
  0x0000,   /* U+52CD */
  0xD2CE,   /* U+52CE */
  0xD2CF,   /* U+52CF */
  0xD2D0,   /* U+52D0 */
  0xD2D1,   /* U+52D1 */
  0x0000,   /* U+52D2 */
  0xD2D3,   /* U+52D3 */
  0xD2D4,   /* U+52D4 */
  0x0000,   /* U+52D5 */
  0xD2D6,   /* U+52D6 */
  0x0000,   /* U+52D7 */
  0x0000,   /* U+52D8 */
  0x0000,   /* U+52D9 */
  0xD2DA,   /* U+52DA */
  0xD2DB,   /* U+52DB */
  0xD2DC,   /* U+52DC */
  0x0000,   /* U+52DD */
  0x0000,   /* U+52DE */
  0x0000,   /* U+52DF */
  0x0000,   /* U+52E0 */
  0xD2E1,   /* U+52E1 */
  0x0000,   /* U+52E2 */
  0x0000,   /* U+52E3 */
  0x0000,   /* U+52E4 */
  0xD2E5,   /* U+52E5 */
  0x0000,   /* U+52E6 */
  0x0000,   /* U+52E7 */
  0xD2E8,   /* U+52E8 */
  0xD2E9,   /* U+52E9 */
  0xD2EA,   /* U+52EA */
  0xD2EB,   /* U+52EB */
  0xD2EC,   /* U+52EC */
  0xD2ED,   /* U+52ED */
  0xD2EE,   /* U+52EE */
  0xD2EF,   /* U+52EF */
  0xD2F0,   /* U+52F0 */
  0xD2F1,   /* U+52F1 */
  0x0000,   /* U+52F2 */
  0x0000,   /* U+52F3 */
  0xD2F4,   /* U+52F4 */
  0x0000,   /* U+52F5 */
  0xD2F6,   /* U+52F6 */
  0xD2F7,   /* U+52F7 */
  0x0000,   /* U+52F8 */
  0x0000,   /* U+52F9 */
  0x0000,   /* U+52FA */
  0xD2FB,   /* U+52FB */
  0xD2FC,   /* U+52FC */
  0xD2FD,   /* U+52FD */
  0x0000,   /* U+52FE */
  0x0000,   /* U+52FF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+5200 */
  0x0000,   /* U+5201 */
  0x0000,   /* U+5202 */
  0x0000,   /* U+5203 */
  0x0000,   /* U+5204 */
  0x0000,   /* U+5205 */
  0x0000,   /* U+5206 */
  0x0000,   /* U+5207 */
  0x0000,   /* U+5208 */
  0x0000,   /* U+5209 */
  0x0000,   /* U+520A */
  0x0000,   /* U+520B */
  0x0000,   /* U+520C */
  0x0000,   /* U+520D */
  0x0000,   /* U+520E */
  0x0000,   /* U+520F */
  0x0000,   /* U+5210 */
  0x0000,   /* U+5211 */
  0x0000,   /* U+5212 */
  0x0000,   /* U+5213 */
  0x0000,   /* U+5214 */
  0x0000,   /* U+5215 */
  0x0000,   /* U+5216 */
  0x0000,   /* U+5217 */
  0x0000,   /* U+5218 */
  0x0000,   /* U+5219 */
  0x0000,   /* U+521A */
  0x0000,   /* U+521B */
  0x0000,   /* U+521C */
  0x0000,   /* U+521D */
  0x0000,   /* U+521E */
  0x0000,   /* U+521F */
  0x0000,   /* U+5220 */
  0x0000,   /* U+5221 */
  0x0000,   /* U+5222 */
  0x0000,   /* U+5223 */
  0x0000,   /* U+5224 */
  0x0000,   /* U+5225 */
  0x0000,   /* U+5226 */
  0x0000,   /* U+5227 */
  0x0000,   /* U+5228 */
  0x0000,   /* U+5229 */
  0x0000,   /* U+522A */
  0x0000,   /* U+522B */
  0x0000,   /* U+522C */
  0x0000,   /* U+522D */
  0x0000,   /* U+522E */
  0x0000,   /* U+522F */
  0x0000,   /* U+5230 */
  0x0000,   /* U+5231 */
  0x0000,   /* U+5232 */
  0x0000,   /* U+5233 */
  0x0000,   /* U+5234 */
  0x0000,   /* U+5235 */
  0x0000,   /* U+5236 */
  0x0000,   /* U+5237 */
  0x0000,   /* U+5238 */
  0x0000,   /* U+5239 */
  0x0000,   /* U+523A */
  0x0000,   /* U+523B */
  0x0000,   /* U+523C */
  0x0000,   /* U+523D */
  0x0000,   /* U+523E */
  0x0000,   /* U+523F */
  0x0000,   /* U+5240 */
  0x0000,   /* U+5241 */
  0x0000,   /* U+5242 */
  0x0000,   /* U+5243 */
  0x0000,   /* U+5244 */
  0x0000,   /* U+5245 */
  0x0000,   /* U+5246 */
  0x0000,   /* U+5247 */
  0x0000,   /* U+5248 */
  0x0000,   /* U+5249 */
  0x0000,   /* U+524A */
  0x0000,   /* U+524B */
  0x0000,   /* U+524C */
  0x0000,   /* U+524D */
  0x0000,   /* U+524E */
  0x0000,   /* U+524F */
  0x0000,   /* U+5250 */
  0x0000,   /* U+5251 */
  0x0000,   /* U+5252 */
  0x0000,   /* U+5253 */
  0x0000,   /* U+5254 */
  0x0000,   /* U+5255 */
  0x0000,   /* U+5256 */
  0x0000,   /* U+5257 */
  0x0000,   /* U+5258 */
  0x0000,   /* U+5259 */
  0x0000,   /* U+525A */
  0x0000,   /* U+525B */
  0x0000,   /* U+525C */
  0x0000,   /* U+525D */
  0x0000,   /* U+525E */
  0x0000,   /* U+525F */
  0x0000,   /* U+5260 */
  0x0000,   /* U+5261 */
  0x0000,   /* U+5262 */
  0x0000,   /* U+5263 */
  0x0000,   /* U+5264 */
  0x0000,   /* U+5265 */
  0x0000,   /* U+5266 */
  0x0000,   /* U+5267 */
  0x0000,   /* U+5268 */
  0x0000,   /* U+5269 */
  0x0000,   /* U+526A */
  0x0000,   /* U+526B */
  0x0000,   /* U+526C */
  0x0000,   /* U+526D */
  0x0000,   /* U+526E */
  0x0000,   /* U+526F */
  0x0000,   /* U+5270 */
  0x0000,   /* U+5271 */
  0x0000,   /* U+5272 */
  0x0000,   /* U+5273 */
  0x0000,   /* U+5274 */
  0x0000,   /* U+5275 */
  0x0000,   /* U+5276 */
  0x0000,   /* U+5277 */
  0x0000,   /* U+5278 */
  0x0000,   /* U+5279 */
  0x0000,   /* U+527A */
  0x0000,   /* U+527B */
  0x0000,   /* U+527C */
  0x0000,   /* U+527D */
  0x0000,   /* U+527E */
  0x0000,   /* U+527F */
  0x0000,   /* U+5280 */
  0x0000,   /* U+5281 */
  0x0000,   /* U+5282 */
  0x0000,   /* U+5283 */
  0x0000,   /* U+5284 */
  0x0000,   /* U+5285 */
  0x0000,   /* U+5286 */
  0x0000,   /* U+5287 */
  0x0000,   /* U+5288 */
  0x0000,   /* U+5289 */
  0x0000,   /* U+528A */
  0x0000,   /* U+528B */
  0x0000,   /* U+528C */
  0x0000,   /* U+528D */
  0x0000,   /* U+528E */
  0x0000,   /* U+528F */
  0x0000,   /* U+5290 */
  0x0000,   /* U+5291 */
  0x0000,   /* U+5292 */
  0x0000,   /* U+5293 */
  0x0000,   /* U+5294 */
  0x0000,   /* U+5295 */
  0x0000,   /* U+5296 */
  0x0000,   /* U+5297 */
  0x0000,   /* U+5298 */
  0x0000,   /* U+5299 */
  0x0000,   /* U+529A */
  0x0000,   /* U+529B */
  0x0000,   /* U+529C */
  0x0000,   /* U+529D */
  0x0000,   /* U+529E */
  0x0000,   /* U+529F */
  0x0000,   /* U+52A0 */
  0x0000,   /* U+52A1 */
  0x0000,   /* U+52A2 */
  0x0000,   /* U+52A3 */
  0x0000,   /* U+52A4 */
  0x0000,   /* U+52A5 */
  0x0000,   /* U+52A6 */
  0x0000,   /* U+52A7 */
  0x0000,   /* U+52A8 */
  0x0000,   /* U+52A9 */
  0x0000,   /* U+52AA */
  0x0000,   /* U+52AB */
  0x0000,   /* U+52AC */
  0x0000,   /* U+52AD */
  0x0000,   /* U+52AE */
  0x0000,   /* U+52AF */
  0x0000,   /* U+52B0 */
  0x0000,   /* U+52B1 */
  0x0000,   /* U+52B2 */
  0x0000,   /* U+52B3 */
  0x0000,   /* U+52B4 */
  0x0000,   /* U+52B5 */
  0x0000,   /* U+52B6 */
  0x0000,   /* U+52B7 */
  0x0000,   /* U+52B8 */
  0x0000,   /* U+52B9 */
  0x0000,   /* U+52BA */
  0x0000,   /* U+52BB */
  0x0000,   /* U+52BC */
  0x0000,   /* U+52BD */
  0x0000,   /* U+52BE */
  0x0000,   /* U+52BF */
  0x0000,   /* U+52C0 */
  0x0000,   /* U+52C1 */
  0x0000,   /* U+52C2 */
  0x0000,   /* U+52C3 */
  0x0000,   /* U+52C4 */
  0x0000,   /* U+52C5 */
  0x0000,   /* U+52C6 */
  0x0000,   /* U+52C7 */
  0x0000,   /* U+52C8 */
  0x0000,   /* U+52C9 */
  0x0000,   /* U+52CA */
  0x0000,   /* U+52CB */
  0x0000,   /* U+52CC */
  0x0000,   /* U+52CD */
  0x0000,   /* U+52CE */
  0x0000,   /* U+52CF */
  0x0000,   /* U+52D0 */
  0x0000,   /* U+52D1 */
  0x0000,   /* U+52D2 */
  0x0000,   /* U+52D3 */
  0x0000,   /* U+52D4 */
  0x0000,   /* U+52D5 */
  0x0000,   /* U+52D6 */
  0x0000,   /* U+52D7 */
  0x0000,   /* U+52D8 */
  0x0000,   /* U+52D9 */
  0x0000,   /* U+52DA */
  0x0000,   /* U+52DB */
  0x0000,   /* U+52DC */
  0x0000,   /* U+52DD */
  0x0000,   /* U+52DE */
  0x0000,   /* U+52DF */
  0x0000,   /* U+52E0 */
  0x0000,   /* U+52E1 */
  0x0000,   /* U+52E2 */
  0x0000,   /* U+52E3 */
  0x0000,   /* U+52E4 */
  0x0000,   /* U+52E5 */
  0x0000,   /* U+52E6 */
  0x0000,   /* U+52E7 */
  0x0000,   /* U+52E8 */
  0x0000,   /* U+52E9 */
  0x0000,   /* U+52EA */
  0x0000,   /* U+52EB */
  0x0000,   /* U+52EC */
  0x0000,   /* U+52ED */
  0x0000,   /* U+52EE */
  0x0000,   /* U+52EF */
  0x0000,   /* U+52F0 */
  0x0000,   /* U+52F1 */
  0x0000,   /* U+52F2 */
  0x0000,   /* U+52F3 */
  0x0000,   /* U+52F4 */
  0x0000,   /* U+52F5 */
  0x0000,   /* U+52F6 */
  0x0000,   /* U+52F7 */
  0x0000,   /* U+52F8 */
  0x0000,   /* U+52F9 */
  0x0000,   /* U+52FA */
  0x0000,   /* U+52FB */
  0x0000,   /* U+52FC */
  0x0000,   /* U+52FD */
  0x0000,   /* U+52FE */
  0x0000,   /* U+52FF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+5200 */
  0x0000,   /* U+5201 */
  0x0000,   /* U+5202 */
  0x0000,   /* U+5203 */
  0x0000,   /* U+5204 */
  0x0000,   /* U+5205 */
  0x0000,   /* U+5206 */
  0x0000,   /* U+5207 */
  0x0000,   /* U+5208 */
  0x0000,   /* U+5209 */
  0x0000,   /* U+520A */
  0x0000,   /* U+520B */
  0x0000,   /* U+520C */
  0x0000,   /* U+520D */
  0x0000,   /* U+520E */
  0x0000,   /* U+520F */
  0x0000,   /* U+5210 */
  0x0000,   /* U+5211 */
  0x0000,   /* U+5212 */
  0x0000,   /* U+5213 */
  0x0000,   /* U+5214 */
  0x0000,   /* U+5215 */
  0x0000,   /* U+5216 */
  0x0000,   /* U+5217 */
  0x0000,   /* U+5218 */
  0x0000,   /* U+5219 */
  0x0000,   /* U+521A */
  0x0000,   /* U+521B */
  0x0000,   /* U+521C */
  0x0000,   /* U+521D */
  0x0000,   /* U+521E */
  0x0000,   /* U+521F */
  0x0000,   /* U+5220 */
  0x0000,   /* U+5221 */
  0x0000,   /* U+5222 */
  0x0000,   /* U+5223 */
  0x0000,   /* U+5224 */
  0x0000,   /* U+5225 */
  0x0000,   /* U+5226 */
  0x0000,   /* U+5227 */
  0x0000,   /* U+5228 */
  0x0000,   /* U+5229 */
  0x0000,   /* U+522A */
  0x0000,   /* U+522B */
  0x0000,   /* U+522C */
  0x0000,   /* U+522D */
  0x0000,   /* U+522E */
  0x0000,   /* U+522F */
  0x0000,   /* U+5230 */
  0x0000,   /* U+5231 */
  0x0000,   /* U+5232 */
  0x0000,   /* U+5233 */
  0x0000,   /* U+5234 */
  0x0000,   /* U+5235 */
  0x0000,   /* U+5236 */
  0x0000,   /* U+5237 */
  0x0000,   /* U+5238 */
  0x0000,   /* U+5239 */
  0x0000,   /* U+523A */
  0x0000,   /* U+523B */
  0x0000,   /* U+523C */
  0x0000,   /* U+523D */
  0x0000,   /* U+523E */
  0x0000,   /* U+523F */
  0x0000,   /* U+5240 */
  0x0000,   /* U+5241 */
  0x0000,   /* U+5242 */
  0x0000,   /* U+5243 */
  0x0000,   /* U+5244 */
  0x0000,   /* U+5245 */
  0x0000,   /* U+5246 */
  0x0000,   /* U+5247 */
  0x0000,   /* U+5248 */
  0x0000,   /* U+5249 */
  0x0000,   /* U+524A */
  0x0000,   /* U+524B */
  0x0000,   /* U+524C */
  0x0000,   /* U+524D */
  0x0000,   /* U+524E */
  0x0000,   /* U+524F */
  0x0000,   /* U+5250 */
  0x0000,   /* U+5251 */
  0x0000,   /* U+5252 */
  0x0000,   /* U+5253 */
  0x0000,   /* U+5254 */
  0x0000,   /* U+5255 */
  0x0000,   /* U+5256 */
  0x0000,   /* U+5257 */
  0x0000,   /* U+5258 */
  0x0000,   /* U+5259 */
  0x0000,   /* U+525A */
  0x0000,   /* U+525B */
  0x0000,   /* U+525C */
  0x0000,   /* U+525D */
  0x0000,   /* U+525E */
  0x0000,   /* U+525F */
  0x0000,   /* U+5260 */
  0x0000,   /* U+5261 */
  0x0000,   /* U+5262 */
  0x0000,   /* U+5263 */
  0x0000,   /* U+5264 */
  0x0000,   /* U+5265 */
  0x0000,   /* U+5266 */
  0x0000,   /* U+5267 */
  0x0000,   /* U+5268 */
  0x0000,   /* U+5269 */
  0x0000,   /* U+526A */
  0x0000,   /* U+526B */
  0x0000,   /* U+526C */
  0x0000,   /* U+526D */
  0x0000,   /* U+526E */
  0x0000,   /* U+526F */
  0x0000,   /* U+5270 */
  0x0000,   /* U+5271 */
  0x0000,   /* U+5272 */
  0x0000,   /* U+5273 */
  0x0000,   /* U+5274 */
  0x0000,   /* U+5275 */
  0x0000,   /* U+5276 */
  0x0000,   /* U+5277 */
  0x0000,   /* U+5278 */
  0x0000,   /* U+5279 */
  0x0000,   /* U+527A */
  0x0000,   /* U+527B */
  0x0000,   /* U+527C */
  0x0000,   /* U+527D */
  0x0000,   /* U+527E */
  0x0000,   /* U+527F */
  0x0000,   /* U+5280 */
  0x0000,   /* U+5281 */
  0x0000,   /* U+5282 */
  0x0000,   /* U+5283 */
  0x0000,   /* U+5284 */
  0x0000,   /* U+5285 */
  0x0000,   /* U+5286 */
  0x0000,   /* U+5287 */
  0x0000,   /* U+5288 */
  0x0000,   /* U+5289 */
  0x0000,   /* U+528A */
  0x0000,   /* U+528B */
  0x0000,   /* U+528C */
  0x0000,   /* U+528D */
  0x0000,   /* U+528E */
  0x0000,   /* U+528F */
  0x0000,   /* U+5290 */
  0x0000,   /* U+5291 */
  0x0000,   /* U+5292 */
  0x0000,   /* U+5293 */
  0x0000,   /* U+5294 */
  0x0000,   /* U+5295 */
  0x0000,   /* U+5296 */
  0x0000,   /* U+5297 */
  0x0000,   /* U+5298 */
  0x0000,   /* U+5299 */
  0x0000,   /* U+529A */
  0x0000,   /* U+529B */
  0x0000,   /* U+529C */
  0x0000,   /* U+529D */
  0x0000,   /* U+529E */
  0x0000,   /* U+529F */
  0x0000,   /* U+52A0 */
  0x0000,   /* U+52A1 */
  0x0000,   /* U+52A2 */
  0x0000,   /* U+52A3 */
  0x0000,   /* U+52A4 */
  0x0000,   /* U+52A5 */
  0x0000,   /* U+52A6 */
  0x0000,   /* U+52A7 */
  0x0000,   /* U+52A8 */
  0x0000,   /* U+52A9 */
  0x0000,   /* U+52AA */
  0x0000,   /* U+52AB */
  0x0000,   /* U+52AC */
  0x0000,   /* U+52AD */
  0x0000,   /* U+52AE */
  0x0000,   /* U+52AF */
  0x0000,   /* U+52B0 */
  0x0000,   /* U+52B1 */
  0x0000,   /* U+52B2 */
  0x0000,   /* U+52B3 */
  0x0000,   /* U+52B4 */
  0x0000,   /* U+52B5 */
  0x0000,   /* U+52B6 */
  0x0000,   /* U+52B7 */
  0x0000,   /* U+52B8 */
  0x0000,   /* U+52B9 */
  0x0000,   /* U+52BA */
  0x0000,   /* U+52BB */
  0x0000,   /* U+52BC */
  0x0000,   /* U+52BD */
  0x0000,   /* U+52BE */
  0x0000,   /* U+52BF */
  0x0000,   /* U+52C0 */
  0x0000,   /* U+52C1 */
  0x0000,   /* U+52C2 */
  0x0000,   /* U+52C3 */
  0x0000,   /* U+52C4 */
  0x0000,   /* U+52C5 */
  0x0000,   /* U+52C6 */
  0x0000,   /* U+52C7 */
  0x0000,   /* U+52C8 */
  0x0000,   /* U+52C9 */
  0x0000,   /* U+52CA */
  0x0000,   /* U+52CB */
  0x0000,   /* U+52CC */
  0x0000,   /* U+52CD */
  0x0000,   /* U+52CE */
  0x0000,   /* U+52CF */
  0x0000,   /* U+52D0 */
  0x0000,   /* U+52D1 */
  0x0000,   /* U+52D2 */
  0x0000,   /* U+52D3 */
  0x0000,   /* U+52D4 */
  0x0000,   /* U+52D5 */
  0x0000,   /* U+52D6 */
  0x0000,   /* U+52D7 */
  0x0000,   /* U+52D8 */
  0x0000,   /* U+52D9 */
  0x0000,   /* U+52DA */
  0x0000,   /* U+52DB */
  0x0000,   /* U+52DC */
  0x0000,   /* U+52DD */
  0x0000,   /* U+52DE */
  0x0000,   /* U+52DF */
  0x0000,   /* U+52E0 */
  0x0000,   /* U+52E1 */
  0x0000,   /* U+52E2 */
  0x0000,   /* U+52E3 */
  0x0000,   /* U+52E4 */
  0x0000,   /* U+52E5 */
  0x0000,   /* U+52E6 */
  0x0000,   /* U+52E7 */
  0x0000,   /* U+52E8 */
  0x0000,   /* U+52E9 */
  0x0000,   /* U+52EA */
  0x0000,   /* U+52EB */
  0x0000,   /* U+52EC */
  0x0000,   /* U+52ED */
  0x0000,   /* U+52EE */
  0x0000,   /* U+52EF */
  0x0000,   /* U+52F0 */
  0x0000,   /* U+52F1 */
  0x0000,   /* U+52F2 */
  0x0000,   /* U+52F3 */
  0x0000,   /* U+52F4 */
  0x0000,   /* U+52F5 */
  0x0000,   /* U+52F6 */
  0x0000,   /* U+52F7 */
  0x0000,   /* U+52F8 */
  0x0000,   /* U+52F9 */
  0x0000,   /* U+52FA */
  0x0000,   /* U+52FB */
  0x0000,   /* U+52FC */
  0x0000,   /* U+52FD */
  0x0000,   /* U+52FE */
  0x0000,   /* U+52FF */
};

uint16 ja_han_page53[]= {
  /* Number of CEs for each character. */
  2, 1, 1, 2, 2, 1, 1, 2, 1, 2, 2, 2, 2, 1, 2, 1,
  1, 2, 2, 2, 2, 1, 1, 1, 2, 1, 1, 2, 2, 1, 2, 2,
  1, 1, 2, 1, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 1,
  2, 1, 2, 1, 2, 2, 2, 2, 1, 1, 1, 1, 2, 2, 2, 1,
  1, 1, 2, 1, 2, 1, 1, 1, 1, 1, 1, 2, 2, 1, 2, 2,
  2, 1, 1, 1, 1, 2, 2, 1, 1, 2, 1, 2, 1, 2, 1, 2,
  1, 2, 2, 2, 2, 2, 1, 2, 2, 1, 2, 2, 2, 2, 1, 1,
  1, 1, 2, 1, 1, 1, 2, 1, 1, 2, 2, 1, 2, 2, 2, 1,
  2, 2, 1, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 1, 2, 1, 2, 1, 2, 2, 2, 2, 1,
  1, 2, 2, 2, 2, 1, 1, 2, 1, 1, 2, 2, 2, 1, 1, 2,
  1, 2, 2, 1, 2, 2, 1, 2, 2, 2, 2, 1, 2, 2, 2, 2,
  2, 2, 1, 1, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 2,
  2, 2, 2, 2, 1, 2, 1, 1, 2, 1, 2, 1, 2, 2, 2, 1,
  2, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 2, 2, 1, 1, 1, 2, 1, 2, 2, 2, 2, 2,

  /* Primary weight 1 for each character. */
  0xFB40,   /* U+5300 */
  0x5F33,   /* U+5301 */
  0x5D0E,   /* U+5302 */
  0xFB40,   /* U+5303 */
  0xFB40,   /* U+5304 */
  0x5E80,   /* U+5305 */
  0x6106,   /* U+5306 */
  0xFB40,   /* U+5307 */
  0x6107,   /* U+5308 */
  0xFB40,   /* U+5309 */
  0xFB40,   /* U+530A */
  0xFB40,   /* U+530B */
  0xFB40,   /* U+530C */
  0x6109,   /* U+530D */
  0xFB40,   /* U+530E */
  0x610B,   /* U+530F */
  0x610A,   /* U+5310 */
  0xFB40,   /* U+5311 */
  0xFB40,   /* U+5312 */
  0xFB40,   /* U+5313 */
  0xFB40,   /* U+5314 */
  0x610C,   /* U+5315 */
  0x557C,   /* U+5316 */
  0x5EB9,   /* U+5317 */
  0xFB40,   /* U+5318 */
  0x58AB,   /* U+5319 */
  0x610D,   /* U+531A */
  0xFB40,   /* U+531B */
  0xFB40,   /* U+531C */
  0x5B1A,   /* U+531D */
  0xFB40,   /* U+531E */
  0xFB40,   /* U+531F */
  0x59C9,   /* U+5320 */
  0x56E0,   /* U+5321 */
  0xFB40,   /* U+5322 */
  0x610E,   /* U+5323 */
  0xFB40,   /* U+5324 */
  0xFB40,   /* U+5325 */
  0xFB40,   /* U+5326 */
  0xFB40,   /* U+5327 */
  0xFB40,   /* U+5328 */
  0xFB40,   /* U+5329 */
  0x5DAE,   /* U+532A */
  0xFB40,   /* U+532B */
  0xFB40,   /* U+532C */
  0xFB40,   /* U+532D */
  0xFB40,   /* U+532E */
  0x610F,   /* U+532F */
  0xFB40,   /* U+5330 */
  0x6110,   /* U+5331 */
  0xFB40,   /* U+5332 */
  0x6111,   /* U+5333 */
  0xFB40,   /* U+5334 */
  0xFB40,   /* U+5335 */
  0xFB40,   /* U+5336 */
  0xFB40,   /* U+5337 */
  0x6112,   /* U+5338 */
  0x5DD5,   /* U+5339 */
  0x571F,   /* U+533A */
  0x54E8,   /* U+533B */
  0xFB40,   /* U+533C */
  0xFB40,   /* U+533D */
  0xFB40,   /* U+533E */
  0x5CD6,   /* U+533F */
  0x6113,   /* U+5340 */
  0x5986,   /* U+5341 */
  0xFB40,   /* U+5342 */
  0x5ACC,   /* U+5343 */
  0xFB40,   /* U+5344 */
  0x6115,   /* U+5345 */
  0x6114,   /* U+5346 */
  0x59CA,   /* U+5347 */
  0x57D4,   /* U+5348 */
  0x6117,   /* U+5349 */
  0x5D91,   /* U+534A */
  0xFB40,   /* U+534B */
  0xFB40,   /* U+534C */
  0x6118,   /* U+534D */
  0xFB40,   /* U+534E */
  0xFB40,   /* U+534F */
  0xFB40,   /* U+5350 */
  0x5DAF,   /* U+5351 */
  0x5B53,   /* U+5352 */
  0x5B8D,   /* U+5353 */
  0x56DF,   /* U+5354 */
  0xFB40,   /* U+5355 */
  0xFB40,   /* U+5356 */
  0x5D05,   /* U+5357 */
  0x5BAE,   /* U+5358 */
  0xFB40,   /* U+5359 */
  0x5D63,   /* U+535A */
  0xFB40,   /* U+535B */
  0x5EBB,   /* U+535C */
  0xFB40,   /* U+535D */
  0x611A,   /* U+535E */
  0xFB40,   /* U+535F */
  0x5ACD,   /* U+5360 */
  0xFB40,   /* U+5361 */
  0xFB40,   /* U+5362 */
  0xFB40,   /* U+5363 */
  0xFB40,   /* U+5364 */
  0xFB40,   /* U+5365 */
  0x574A,   /* U+5366 */
  0xFB40,   /* U+5367 */
  0xFB40,   /* U+5368 */
  0x611B,   /* U+5369 */
  0xFB40,   /* U+536A */
  0xFB40,   /* U+536B */
  0xFB40,   /* U+536C */
  0xFB40,   /* U+536D */
  0x611C,   /* U+536E */
  0x550D,   /* U+536F */
  0x54F8,   /* U+5370 */
  0x5668,   /* U+5371 */
  0xFB40,   /* U+5372 */
  0x5B47,   /* U+5373 */
  0x56AA,   /* U+5374 */
  0x5F9A,   /* U+5375 */
  0xFB40,   /* U+5376 */
  0x611F,   /* U+5377 */
  0x5576,   /* U+5378 */
  0xFB40,   /* U+5379 */
  0xFB40,   /* U+537A */
  0x611E,   /* U+537B */
  0xFB40,   /* U+537C */
  0xFB40,   /* U+537D */
  0xFB40,   /* U+537E */
  0x56E1,   /* U+537F */
  0xFB40,   /* U+5380 */
  0xFB40,   /* U+5381 */
  0x6120,   /* U+5382 */
  0xFB40,   /* U+5383 */
  0x5F3C,   /* U+5384 */
  0xFB40,   /* U+5385 */
  0xFB40,   /* U+5386 */
  0xFB40,   /* U+5387 */
  0xFB40,   /* U+5388 */
  0xFB40,   /* U+5389 */
  0xFB40,   /* U+538A */
  0xFB40,   /* U+538B */
  0xFB40,   /* U+538C */
  0xFB40,   /* U+538D */
  0xFB40,   /* U+538E */
  0xFB40,   /* U+538F */
  0xFB40,   /* U+5390 */
  0xFB40,   /* U+5391 */
  0xFB40,   /* U+5392 */
  0xFB40,   /* U+5393 */
  0xFB40,   /* U+5394 */
  0xFB40,   /* U+5395 */
  0x6121,   /* U+5396 */
  0xFB40,   /* U+5397 */
  0x5FD9,   /* U+5398 */
  0xFB40,   /* U+5399 */
  0x57EF,   /* U+539A */
  0xFB40,   /* U+539B */
  0xFB40,   /* U+539C */
  0xFB40,   /* U+539D */
  0xFB40,   /* U+539E */
  0x57A9,   /* U+539F */
  0x6122,   /* U+53A0 */
  0xFB40,   /* U+53A1 */
  0xFB40,   /* U+53A2 */
  0xFB40,   /* U+53A3 */
  0xFB40,   /* U+53A4 */
  0x6124,   /* U+53A5 */
  0x6123,   /* U+53A6 */
  0xFB40,   /* U+53A7 */
  0x5A64,   /* U+53A8 */
  0x551A,   /* U+53A9 */
  0xFB40,   /* U+53AA */
  0xFB40,   /* U+53AB */
  0xFB40,   /* U+53AC */
  0x553F,   /* U+53AD */
  0x6125,   /* U+53AE */
  0xFB40,   /* U+53AF */
  0x6126,   /* U+53B0 */
  0xFB40,   /* U+53B1 */
  0xFB40,   /* U+53B2 */
  0x57AA,   /* U+53B3 */
  0xFB40,   /* U+53B4 */
  0xFB40,   /* U+53B5 */
  0x6127,   /* U+53B6 */
  0xFB40,   /* U+53B7 */
  0xFB40,   /* U+53B8 */
  0xFB40,   /* U+53B9 */
  0xFB40,   /* U+53BA */
  0x56C7,   /* U+53BB */
  0xFB40,   /* U+53BC */
  0xFB40,   /* U+53BD */
  0xFB40,   /* U+53BE */
  0xFB40,   /* U+53BF */
  0xFB40,   /* U+53C0 */
  0xFB40,   /* U+53C1 */
  0x58BF,   /* U+53C2 */
  0x6128,   /* U+53C3 */
  0xFB40,   /* U+53C4 */
  0xFB40,   /* U+53C5 */
  0xFB40,   /* U+53C6 */
  0xFB40,   /* U+53C7 */
  0x5EE1,   /* U+53C8 */
  0x5864,   /* U+53C9 */
  0x56B3,   /* U+53CA */
  0x5F50,   /* U+53CB */
  0x5B11,   /* U+53CC */
  0x5D92,   /* U+53CD */
  0x5968,   /* U+53CE */
  0xFB40,   /* U+53CF */
  0xFB40,   /* U+53D0 */
  0xFB40,   /* U+53D1 */
  0xFB40,   /* U+53D2 */
  0xFB40,   /* U+53D3 */
  0x5990,   /* U+53D4 */
  0xFB40,   /* U+53D5 */
  0x5953,   /* U+53D6 */
  0x5960,   /* U+53D7 */
  0xFB40,   /* U+53D8 */
  0x59BF,   /* U+53D9 */
  0xFB40,   /* U+53DA */
  0x5D93,   /* U+53DB */
  0xFB40,   /* U+53DC */
  0xFB40,   /* U+53DD */
  0xFB40,   /* U+53DE */
  0x612B,   /* U+53DF */
  0xFB40,   /* U+53E0 */
  0x5524,   /* U+53E1 */
  0x5B12,   /* U+53E2 */
  0x57F0,   /* U+53E3 */
  0x57B8,   /* U+53E4 */
  0x571E,   /* U+53E5 */
  0xFB40,   /* U+53E6 */
  0xFB40,   /* U+53E7 */
  0x612F,   /* U+53E8 */
  0x5B9E,   /* U+53E9 */
  0x5B9D,   /* U+53EA */
  0x56E2,   /* U+53EB */
  0x59CB,   /* U+53EC */
  0x6130,   /* U+53ED */
  0x612E,   /* U+53EE */
  0x5583,   /* U+53EF */
  0x5B85,   /* U+53F0 */
  0x5923,   /* U+53F1 */
  0x58D8,   /* U+53F2 */
  0x5507,   /* U+53F3 */
  0xFB40,   /* U+53F4 */
  0xFB40,   /* U+53F5 */
  0x560D,   /* U+53F6 */
  0x5837,   /* U+53F7 */
  0x58D7,   /* U+53F8 */
  0xFB40,   /* U+53F9 */
  0x6131,   /* U+53FA */
  0xFB40,   /* U+53FB */
  0xFB40,   /* U+53FC */
  0xFB40,   /* U+53FD */
  0xFB40,   /* U+53FE */
  0xFB40,   /* U+53FF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+5300 */
  0x0020,   /* U+5301 */
  0x0020,   /* U+5302 */
  0x0020,   /* U+5303 */
  0x0020,   /* U+5304 */
  0x0020,   /* U+5305 */
  0x0020,   /* U+5306 */
  0x0020,   /* U+5307 */
  0x0020,   /* U+5308 */
  0x0020,   /* U+5309 */
  0x0020,   /* U+530A */
  0x0020,   /* U+530B */
  0x0020,   /* U+530C */
  0x0020,   /* U+530D */
  0x0020,   /* U+530E */
  0x0020,   /* U+530F */
  0x0020,   /* U+5310 */
  0x0020,   /* U+5311 */
  0x0020,   /* U+5312 */
  0x0020,   /* U+5313 */
  0x0020,   /* U+5314 */
  0x0020,   /* U+5315 */
  0x0020,   /* U+5316 */
  0x0020,   /* U+5317 */
  0x0020,   /* U+5318 */
  0x0020,   /* U+5319 */
  0x0020,   /* U+531A */
  0x0020,   /* U+531B */
  0x0020,   /* U+531C */
  0x0020,   /* U+531D */
  0x0020,   /* U+531E */
  0x0020,   /* U+531F */
  0x0020,   /* U+5320 */
  0x0020,   /* U+5321 */
  0x0020,   /* U+5322 */
  0x0020,   /* U+5323 */
  0x0020,   /* U+5324 */
  0x0020,   /* U+5325 */
  0x0020,   /* U+5326 */
  0x0020,   /* U+5327 */
  0x0020,   /* U+5328 */
  0x0020,   /* U+5329 */
  0x0020,   /* U+532A */
  0x0020,   /* U+532B */
  0x0020,   /* U+532C */
  0x0020,   /* U+532D */
  0x0020,   /* U+532E */
  0x0020,   /* U+532F */
  0x0020,   /* U+5330 */
  0x0020,   /* U+5331 */
  0x0020,   /* U+5332 */
  0x0020,   /* U+5333 */
  0x0020,   /* U+5334 */
  0x0020,   /* U+5335 */
  0x0020,   /* U+5336 */
  0x0020,   /* U+5337 */
  0x0020,   /* U+5338 */
  0x0020,   /* U+5339 */
  0x0020,   /* U+533A */
  0x0020,   /* U+533B */
  0x0020,   /* U+533C */
  0x0020,   /* U+533D */
  0x0020,   /* U+533E */
  0x0020,   /* U+533F */
  0x0020,   /* U+5340 */
  0x0020,   /* U+5341 */
  0x0020,   /* U+5342 */
  0x0020,   /* U+5343 */
  0x0020,   /* U+5344 */
  0x0020,   /* U+5345 */
  0x0020,   /* U+5346 */
  0x0020,   /* U+5347 */
  0x0020,   /* U+5348 */
  0x0020,   /* U+5349 */
  0x0020,   /* U+534A */
  0x0020,   /* U+534B */
  0x0020,   /* U+534C */
  0x0020,   /* U+534D */
  0x0020,   /* U+534E */
  0x0020,   /* U+534F */
  0x0020,   /* U+5350 */
  0x0020,   /* U+5351 */
  0x0020,   /* U+5352 */
  0x0020,   /* U+5353 */
  0x0020,   /* U+5354 */
  0x0020,   /* U+5355 */
  0x0020,   /* U+5356 */
  0x0020,   /* U+5357 */
  0x0020,   /* U+5358 */
  0x0020,   /* U+5359 */
  0x0020,   /* U+535A */
  0x0020,   /* U+535B */
  0x0020,   /* U+535C */
  0x0020,   /* U+535D */
  0x0020,   /* U+535E */
  0x0020,   /* U+535F */
  0x0020,   /* U+5360 */
  0x0020,   /* U+5361 */
  0x0020,   /* U+5362 */
  0x0020,   /* U+5363 */
  0x0020,   /* U+5364 */
  0x0020,   /* U+5365 */
  0x0020,   /* U+5366 */
  0x0020,   /* U+5367 */
  0x0020,   /* U+5368 */
  0x0020,   /* U+5369 */
  0x0020,   /* U+536A */
  0x0020,   /* U+536B */
  0x0020,   /* U+536C */
  0x0020,   /* U+536D */
  0x0020,   /* U+536E */
  0x0020,   /* U+536F */
  0x0020,   /* U+5370 */
  0x0020,   /* U+5371 */
  0x0020,   /* U+5372 */
  0x0020,   /* U+5373 */
  0x0020,   /* U+5374 */
  0x0020,   /* U+5375 */
  0x0020,   /* U+5376 */
  0x0020,   /* U+5377 */
  0x0020,   /* U+5378 */
  0x0020,   /* U+5379 */
  0x0020,   /* U+537A */
  0x0020,   /* U+537B */
  0x0020,   /* U+537C */
  0x0020,   /* U+537D */
  0x0020,   /* U+537E */
  0x0020,   /* U+537F */
  0x0020,   /* U+5380 */
  0x0020,   /* U+5381 */
  0x0020,   /* U+5382 */
  0x0020,   /* U+5383 */
  0x0020,   /* U+5384 */
  0x0020,   /* U+5385 */
  0x0020,   /* U+5386 */
  0x0020,   /* U+5387 */
  0x0020,   /* U+5388 */
  0x0020,   /* U+5389 */
  0x0020,   /* U+538A */
  0x0020,   /* U+538B */
  0x0020,   /* U+538C */
  0x0020,   /* U+538D */
  0x0020,   /* U+538E */
  0x0020,   /* U+538F */
  0x0020,   /* U+5390 */
  0x0020,   /* U+5391 */
  0x0020,   /* U+5392 */
  0x0020,   /* U+5393 */
  0x0020,   /* U+5394 */
  0x0020,   /* U+5395 */
  0x0020,   /* U+5396 */
  0x0020,   /* U+5397 */
  0x0020,   /* U+5398 */
  0x0020,   /* U+5399 */
  0x0020,   /* U+539A */
  0x0020,   /* U+539B */
  0x0020,   /* U+539C */
  0x0020,   /* U+539D */
  0x0020,   /* U+539E */
  0x0020,   /* U+539F */
  0x0020,   /* U+53A0 */
  0x0020,   /* U+53A1 */
  0x0020,   /* U+53A2 */
  0x0020,   /* U+53A3 */
  0x0020,   /* U+53A4 */
  0x0020,   /* U+53A5 */
  0x0020,   /* U+53A6 */
  0x0020,   /* U+53A7 */
  0x0020,   /* U+53A8 */
  0x0020,   /* U+53A9 */
  0x0020,   /* U+53AA */
  0x0020,   /* U+53AB */
  0x0020,   /* U+53AC */
  0x0020,   /* U+53AD */
  0x0020,   /* U+53AE */
  0x0020,   /* U+53AF */
  0x0020,   /* U+53B0 */
  0x0020,   /* U+53B1 */
  0x0020,   /* U+53B2 */
  0x0020,   /* U+53B3 */
  0x0020,   /* U+53B4 */
  0x0020,   /* U+53B5 */
  0x0020,   /* U+53B6 */
  0x0020,   /* U+53B7 */
  0x0020,   /* U+53B8 */
  0x0020,   /* U+53B9 */
  0x0020,   /* U+53BA */
  0x0020,   /* U+53BB */
  0x0020,   /* U+53BC */
  0x0020,   /* U+53BD */
  0x0020,   /* U+53BE */
  0x0020,   /* U+53BF */
  0x0020,   /* U+53C0 */
  0x0020,   /* U+53C1 */
  0x0020,   /* U+53C2 */
  0x0020,   /* U+53C3 */
  0x0020,   /* U+53C4 */
  0x0020,   /* U+53C5 */
  0x0020,   /* U+53C6 */
  0x0020,   /* U+53C7 */
  0x0020,   /* U+53C8 */
  0x0020,   /* U+53C9 */
  0x0020,   /* U+53CA */
  0x0020,   /* U+53CB */
  0x0020,   /* U+53CC */
  0x0020,   /* U+53CD */
  0x0020,   /* U+53CE */
  0x0020,   /* U+53CF */
  0x0020,   /* U+53D0 */
  0x0020,   /* U+53D1 */
  0x0020,   /* U+53D2 */
  0x0020,   /* U+53D3 */
  0x0020,   /* U+53D4 */
  0x0020,   /* U+53D5 */
  0x0020,   /* U+53D6 */
  0x0020,   /* U+53D7 */
  0x0020,   /* U+53D8 */
  0x0020,   /* U+53D9 */
  0x0020,   /* U+53DA */
  0x0020,   /* U+53DB */
  0x0020,   /* U+53DC */
  0x0020,   /* U+53DD */
  0x0020,   /* U+53DE */
  0x0020,   /* U+53DF */
  0x0020,   /* U+53E0 */
  0x0020,   /* U+53E1 */
  0x0020,   /* U+53E2 */
  0x0020,   /* U+53E3 */
  0x0020,   /* U+53E4 */
  0x0020,   /* U+53E5 */
  0x0020,   /* U+53E6 */
  0x0020,   /* U+53E7 */
  0x0020,   /* U+53E8 */
  0x0020,   /* U+53E9 */
  0x0020,   /* U+53EA */
  0x0020,   /* U+53EB */
  0x0020,   /* U+53EC */
  0x0020,   /* U+53ED */
  0x0020,   /* U+53EE */
  0x0020,   /* U+53EF */
  0x0020,   /* U+53F0 */
  0x0020,   /* U+53F1 */
  0x0020,   /* U+53F2 */
  0x0020,   /* U+53F3 */
  0x0020,   /* U+53F4 */
  0x0020,   /* U+53F5 */
  0x0020,   /* U+53F6 */
  0x0020,   /* U+53F7 */
  0x0020,   /* U+53F8 */
  0x0020,   /* U+53F9 */
  0x0020,   /* U+53FA */
  0x0020,   /* U+53FB */
  0x0020,   /* U+53FC */
  0x0020,   /* U+53FD */
  0x0020,   /* U+53FE */
  0x0020,   /* U+53FF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+5300 */
  0x0002,   /* U+5301 */
  0x0002,   /* U+5302 */
  0x0002,   /* U+5303 */
  0x0002,   /* U+5304 */
  0x0002,   /* U+5305 */
  0x0002,   /* U+5306 */
  0x0002,   /* U+5307 */
  0x0002,   /* U+5308 */
  0x0002,   /* U+5309 */
  0x0002,   /* U+530A */
  0x0002,   /* U+530B */
  0x0002,   /* U+530C */
  0x0002,   /* U+530D */
  0x0002,   /* U+530E */
  0x0002,   /* U+530F */
  0x0002,   /* U+5310 */
  0x0002,   /* U+5311 */
  0x0002,   /* U+5312 */
  0x0002,   /* U+5313 */
  0x0002,   /* U+5314 */
  0x0002,   /* U+5315 */
  0x0002,   /* U+5316 */
  0x0002,   /* U+5317 */
  0x0002,   /* U+5318 */
  0x0002,   /* U+5319 */
  0x0002,   /* U+531A */
  0x0002,   /* U+531B */
  0x0002,   /* U+531C */
  0x0002,   /* U+531D */
  0x0002,   /* U+531E */
  0x0002,   /* U+531F */
  0x0002,   /* U+5320 */
  0x0002,   /* U+5321 */
  0x0002,   /* U+5322 */
  0x0002,   /* U+5323 */
  0x0002,   /* U+5324 */
  0x0002,   /* U+5325 */
  0x0002,   /* U+5326 */
  0x0002,   /* U+5327 */
  0x0002,   /* U+5328 */
  0x0002,   /* U+5329 */
  0x0002,   /* U+532A */
  0x0002,   /* U+532B */
  0x0002,   /* U+532C */
  0x0002,   /* U+532D */
  0x0002,   /* U+532E */
  0x0002,   /* U+532F */
  0x0002,   /* U+5330 */
  0x0002,   /* U+5331 */
  0x0002,   /* U+5332 */
  0x0002,   /* U+5333 */
  0x0002,   /* U+5334 */
  0x0002,   /* U+5335 */
  0x0002,   /* U+5336 */
  0x0002,   /* U+5337 */
  0x0002,   /* U+5338 */
  0x0002,   /* U+5339 */
  0x0002,   /* U+533A */
  0x0002,   /* U+533B */
  0x0002,   /* U+533C */
  0x0002,   /* U+533D */
  0x0002,   /* U+533E */
  0x0002,   /* U+533F */
  0x0002,   /* U+5340 */
  0x0002,   /* U+5341 */
  0x0002,   /* U+5342 */
  0x0002,   /* U+5343 */
  0x0002,   /* U+5344 */
  0x0002,   /* U+5345 */
  0x0002,   /* U+5346 */
  0x0002,   /* U+5347 */
  0x0002,   /* U+5348 */
  0x0002,   /* U+5349 */
  0x0002,   /* U+534A */
  0x0002,   /* U+534B */
  0x0002,   /* U+534C */
  0x0002,   /* U+534D */
  0x0002,   /* U+534E */
  0x0002,   /* U+534F */
  0x0002,   /* U+5350 */
  0x0002,   /* U+5351 */
  0x0002,   /* U+5352 */
  0x0002,   /* U+5353 */
  0x0002,   /* U+5354 */
  0x0002,   /* U+5355 */
  0x0002,   /* U+5356 */
  0x0002,   /* U+5357 */
  0x0002,   /* U+5358 */
  0x0002,   /* U+5359 */
  0x0002,   /* U+535A */
  0x0002,   /* U+535B */
  0x0002,   /* U+535C */
  0x0002,   /* U+535D */
  0x0002,   /* U+535E */
  0x0002,   /* U+535F */
  0x0002,   /* U+5360 */
  0x0002,   /* U+5361 */
  0x0002,   /* U+5362 */
  0x0002,   /* U+5363 */
  0x0002,   /* U+5364 */
  0x0002,   /* U+5365 */
  0x0002,   /* U+5366 */
  0x0002,   /* U+5367 */
  0x0002,   /* U+5368 */
  0x0002,   /* U+5369 */
  0x0002,   /* U+536A */
  0x0002,   /* U+536B */
  0x0002,   /* U+536C */
  0x0002,   /* U+536D */
  0x0002,   /* U+536E */
  0x0002,   /* U+536F */
  0x0002,   /* U+5370 */
  0x0002,   /* U+5371 */
  0x0002,   /* U+5372 */
  0x0002,   /* U+5373 */
  0x0002,   /* U+5374 */
  0x0002,   /* U+5375 */
  0x0002,   /* U+5376 */
  0x0002,   /* U+5377 */
  0x0002,   /* U+5378 */
  0x0002,   /* U+5379 */
  0x0002,   /* U+537A */
  0x0002,   /* U+537B */
  0x0002,   /* U+537C */
  0x0002,   /* U+537D */
  0x0002,   /* U+537E */
  0x0002,   /* U+537F */
  0x0002,   /* U+5380 */
  0x0002,   /* U+5381 */
  0x0002,   /* U+5382 */
  0x0002,   /* U+5383 */
  0x0002,   /* U+5384 */
  0x0002,   /* U+5385 */
  0x0002,   /* U+5386 */
  0x0002,   /* U+5387 */
  0x0002,   /* U+5388 */
  0x0002,   /* U+5389 */
  0x0002,   /* U+538A */
  0x0002,   /* U+538B */
  0x0002,   /* U+538C */
  0x0002,   /* U+538D */
  0x0002,   /* U+538E */
  0x0002,   /* U+538F */
  0x0002,   /* U+5390 */
  0x0002,   /* U+5391 */
  0x0002,   /* U+5392 */
  0x0002,   /* U+5393 */
  0x0002,   /* U+5394 */
  0x0002,   /* U+5395 */
  0x0002,   /* U+5396 */
  0x0002,   /* U+5397 */
  0x0002,   /* U+5398 */
  0x0002,   /* U+5399 */
  0x0002,   /* U+539A */
  0x0002,   /* U+539B */
  0x0002,   /* U+539C */
  0x0002,   /* U+539D */
  0x0002,   /* U+539E */
  0x0002,   /* U+539F */
  0x0002,   /* U+53A0 */
  0x0002,   /* U+53A1 */
  0x0002,   /* U+53A2 */
  0x0002,   /* U+53A3 */
  0x0002,   /* U+53A4 */
  0x0002,   /* U+53A5 */
  0x0002,   /* U+53A6 */
  0x0002,   /* U+53A7 */
  0x0002,   /* U+53A8 */
  0x0002,   /* U+53A9 */
  0x0002,   /* U+53AA */
  0x0002,   /* U+53AB */
  0x0002,   /* U+53AC */
  0x0002,   /* U+53AD */
  0x0002,   /* U+53AE */
  0x0002,   /* U+53AF */
  0x0002,   /* U+53B0 */
  0x0002,   /* U+53B1 */
  0x0002,   /* U+53B2 */
  0x0002,   /* U+53B3 */
  0x0002,   /* U+53B4 */
  0x0002,   /* U+53B5 */
  0x0002,   /* U+53B6 */
  0x0002,   /* U+53B7 */
  0x0002,   /* U+53B8 */
  0x0002,   /* U+53B9 */
  0x0002,   /* U+53BA */
  0x0002,   /* U+53BB */
  0x0002,   /* U+53BC */
  0x0002,   /* U+53BD */
  0x0002,   /* U+53BE */
  0x0002,   /* U+53BF */
  0x0002,   /* U+53C0 */
  0x0002,   /* U+53C1 */
  0x0002,   /* U+53C2 */
  0x0002,   /* U+53C3 */
  0x0002,   /* U+53C4 */
  0x0002,   /* U+53C5 */
  0x0002,   /* U+53C6 */
  0x0002,   /* U+53C7 */
  0x0002,   /* U+53C8 */
  0x0002,   /* U+53C9 */
  0x0002,   /* U+53CA */
  0x0002,   /* U+53CB */
  0x0002,   /* U+53CC */
  0x0002,   /* U+53CD */
  0x0002,   /* U+53CE */
  0x0002,   /* U+53CF */
  0x0002,   /* U+53D0 */
  0x0002,   /* U+53D1 */
  0x0002,   /* U+53D2 */
  0x0002,   /* U+53D3 */
  0x0002,   /* U+53D4 */
  0x0002,   /* U+53D5 */
  0x0002,   /* U+53D6 */
  0x0002,   /* U+53D7 */
  0x0002,   /* U+53D8 */
  0x0002,   /* U+53D9 */
  0x0002,   /* U+53DA */
  0x0002,   /* U+53DB */
  0x0002,   /* U+53DC */
  0x0002,   /* U+53DD */
  0x0002,   /* U+53DE */
  0x0002,   /* U+53DF */
  0x0002,   /* U+53E0 */
  0x0002,   /* U+53E1 */
  0x0002,   /* U+53E2 */
  0x0002,   /* U+53E3 */
  0x0002,   /* U+53E4 */
  0x0002,   /* U+53E5 */
  0x0002,   /* U+53E6 */
  0x0002,   /* U+53E7 */
  0x0002,   /* U+53E8 */
  0x0002,   /* U+53E9 */
  0x0002,   /* U+53EA */
  0x0002,   /* U+53EB */
  0x0002,   /* U+53EC */
  0x0002,   /* U+53ED */
  0x0002,   /* U+53EE */
  0x0002,   /* U+53EF */
  0x0002,   /* U+53F0 */
  0x0002,   /* U+53F1 */
  0x0002,   /* U+53F2 */
  0x0002,   /* U+53F3 */
  0x0002,   /* U+53F4 */
  0x0002,   /* U+53F5 */
  0x0002,   /* U+53F6 */
  0x0002,   /* U+53F7 */
  0x0002,   /* U+53F8 */
  0x0002,   /* U+53F9 */
  0x0002,   /* U+53FA */
  0x0002,   /* U+53FB */
  0x0002,   /* U+53FC */
  0x0002,   /* U+53FD */
  0x0002,   /* U+53FE */
  0x0002,   /* U+53FF */

  /* Primary weight 2 for each character. */
  0xD300,   /* U+5300 */
  0x0000,   /* U+5301 */
  0x0000,   /* U+5302 */
  0xD303,   /* U+5303 */
  0xD304,   /* U+5304 */
  0x0000,   /* U+5305 */
  0x0000,   /* U+5306 */
  0xD307,   /* U+5307 */
  0x0000,   /* U+5308 */
  0xD309,   /* U+5309 */
  0xD30A,   /* U+530A */
  0xD30B,   /* U+530B */
  0xD30C,   /* U+530C */
  0x0000,   /* U+530D */
  0xD30E,   /* U+530E */
  0x0000,   /* U+530F */
  0x0000,   /* U+5310 */
  0xD311,   /* U+5311 */
  0xD312,   /* U+5312 */
  0xD313,   /* U+5313 */
  0xD314,   /* U+5314 */
  0x0000,   /* U+5315 */
  0x0000,   /* U+5316 */
  0x0000,   /* U+5317 */
  0xD318,   /* U+5318 */
  0x0000,   /* U+5319 */
  0x0000,   /* U+531A */
  0xD31B,   /* U+531B */
  0xD31C,   /* U+531C */
  0x0000,   /* U+531D */
  0xD31E,   /* U+531E */
  0xD31F,   /* U+531F */
  0x0000,   /* U+5320 */
  0x0000,   /* U+5321 */
  0xD322,   /* U+5322 */
  0x0000,   /* U+5323 */
  0xD324,   /* U+5324 */
  0xD325,   /* U+5325 */
  0xD326,   /* U+5326 */
  0xD327,   /* U+5327 */
  0xD328,   /* U+5328 */
  0xD329,   /* U+5329 */
  0x0000,   /* U+532A */
  0xD32B,   /* U+532B */
  0xD32C,   /* U+532C */
  0xD32D,   /* U+532D */
  0xD32E,   /* U+532E */
  0x0000,   /* U+532F */
  0xD330,   /* U+5330 */
  0x0000,   /* U+5331 */
  0xD332,   /* U+5332 */
  0x0000,   /* U+5333 */
  0xD334,   /* U+5334 */
  0xD335,   /* U+5335 */
  0xD336,   /* U+5336 */
  0xD337,   /* U+5337 */
  0x0000,   /* U+5338 */
  0x0000,   /* U+5339 */
  0x0000,   /* U+533A */
  0x0000,   /* U+533B */
  0xD33C,   /* U+533C */
  0xD33D,   /* U+533D */
  0xD33E,   /* U+533E */
  0x0000,   /* U+533F */
  0x0000,   /* U+5340 */
  0x0000,   /* U+5341 */
  0xD342,   /* U+5342 */
  0x0000,   /* U+5343 */
  0xD344,   /* U+5344 */
  0x0000,   /* U+5345 */
  0x0000,   /* U+5346 */
  0x0000,   /* U+5347 */
  0x0000,   /* U+5348 */
  0x0000,   /* U+5349 */
  0x0000,   /* U+534A */
  0xD34B,   /* U+534B */
  0xD34C,   /* U+534C */
  0x0000,   /* U+534D */
  0xD34E,   /* U+534E */
  0xD34F,   /* U+534F */
  0xD350,   /* U+5350 */
  0x0000,   /* U+5351 */
  0x0000,   /* U+5352 */
  0x0000,   /* U+5353 */
  0x0000,   /* U+5354 */
  0xD355,   /* U+5355 */
  0xD356,   /* U+5356 */
  0x0000,   /* U+5357 */
  0x0000,   /* U+5358 */
  0xD359,   /* U+5359 */
  0x0000,   /* U+535A */
  0xD35B,   /* U+535B */
  0x0000,   /* U+535C */
  0xD35D,   /* U+535D */
  0x0000,   /* U+535E */
  0xD35F,   /* U+535F */
  0x0000,   /* U+5360 */
  0xD361,   /* U+5361 */
  0xD362,   /* U+5362 */
  0xD363,   /* U+5363 */
  0xD364,   /* U+5364 */
  0xD365,   /* U+5365 */
  0x0000,   /* U+5366 */
  0xD367,   /* U+5367 */
  0xD368,   /* U+5368 */
  0x0000,   /* U+5369 */
  0xD36A,   /* U+536A */
  0xD36B,   /* U+536B */
  0xD36C,   /* U+536C */
  0xD36D,   /* U+536D */
  0x0000,   /* U+536E */
  0x0000,   /* U+536F */
  0x0000,   /* U+5370 */
  0x0000,   /* U+5371 */
  0xD372,   /* U+5372 */
  0x0000,   /* U+5373 */
  0x0000,   /* U+5374 */
  0x0000,   /* U+5375 */
  0xD376,   /* U+5376 */
  0x0000,   /* U+5377 */
  0x0000,   /* U+5378 */
  0xD379,   /* U+5379 */
  0xD37A,   /* U+537A */
  0x0000,   /* U+537B */
  0xD37C,   /* U+537C */
  0xD37D,   /* U+537D */
  0xD37E,   /* U+537E */
  0x0000,   /* U+537F */
  0xD380,   /* U+5380 */
  0xD381,   /* U+5381 */
  0x0000,   /* U+5382 */
  0xD383,   /* U+5383 */
  0x0000,   /* U+5384 */
  0xD385,   /* U+5385 */
  0xD386,   /* U+5386 */
  0xD387,   /* U+5387 */
  0xD388,   /* U+5388 */
  0xD389,   /* U+5389 */
  0xD38A,   /* U+538A */
  0xD38B,   /* U+538B */
  0xD38C,   /* U+538C */
  0xD38D,   /* U+538D */
  0xD38E,   /* U+538E */
  0xD38F,   /* U+538F */
  0xD390,   /* U+5390 */
  0xD391,   /* U+5391 */
  0xD392,   /* U+5392 */
  0xD393,   /* U+5393 */
  0xD394,   /* U+5394 */
  0xD395,   /* U+5395 */
  0x0000,   /* U+5396 */
  0xD397,   /* U+5397 */
  0x0000,   /* U+5398 */
  0xD399,   /* U+5399 */
  0x0000,   /* U+539A */
  0xD39B,   /* U+539B */
  0xD39C,   /* U+539C */
  0xD39D,   /* U+539D */
  0xD39E,   /* U+539E */
  0x0000,   /* U+539F */
  0x0000,   /* U+53A0 */
  0xD3A1,   /* U+53A1 */
  0xD3A2,   /* U+53A2 */
  0xD3A3,   /* U+53A3 */
  0xD3A4,   /* U+53A4 */
  0x0000,   /* U+53A5 */
  0x0000,   /* U+53A6 */
  0xD3A7,   /* U+53A7 */
  0x0000,   /* U+53A8 */
  0x0000,   /* U+53A9 */
  0xD3AA,   /* U+53AA */
  0xD3AB,   /* U+53AB */
  0xD3AC,   /* U+53AC */
  0x0000,   /* U+53AD */
  0x0000,   /* U+53AE */
  0xD3AF,   /* U+53AF */
  0x0000,   /* U+53B0 */
  0xD3B1,   /* U+53B1 */
  0xD3B2,   /* U+53B2 */
  0x0000,   /* U+53B3 */
  0xD3B4,   /* U+53B4 */
  0xD3B5,   /* U+53B5 */
  0x0000,   /* U+53B6 */
  0xD3B7,   /* U+53B7 */
  0xD3B8,   /* U+53B8 */
  0xD3B9,   /* U+53B9 */
  0xD3BA,   /* U+53BA */
  0x0000,   /* U+53BB */
  0xD3BC,   /* U+53BC */
  0xD3BD,   /* U+53BD */
  0xD3BE,   /* U+53BE */
  0xD3BF,   /* U+53BF */
  0xD3C0,   /* U+53C0 */
  0xD3C1,   /* U+53C1 */
  0x0000,   /* U+53C2 */
  0x0000,   /* U+53C3 */
  0xD3C4,   /* U+53C4 */
  0xD3C5,   /* U+53C5 */
  0xD3C6,   /* U+53C6 */
  0xD3C7,   /* U+53C7 */
  0x0000,   /* U+53C8 */
  0x0000,   /* U+53C9 */
  0x0000,   /* U+53CA */
  0x0000,   /* U+53CB */
  0x0000,   /* U+53CC */
  0x0000,   /* U+53CD */
  0x0000,   /* U+53CE */
  0xD3CF,   /* U+53CF */
  0xD3D0,   /* U+53D0 */
  0xD3D1,   /* U+53D1 */
  0xD3D2,   /* U+53D2 */
  0xD3D3,   /* U+53D3 */
  0x0000,   /* U+53D4 */
  0xD3D5,   /* U+53D5 */
  0x0000,   /* U+53D6 */
  0x0000,   /* U+53D7 */
  0xD3D8,   /* U+53D8 */
  0x0000,   /* U+53D9 */
  0xD3DA,   /* U+53DA */
  0x0000,   /* U+53DB */
  0xD3DC,   /* U+53DC */
  0xD3DD,   /* U+53DD */
  0xD3DE,   /* U+53DE */
  0x0000,   /* U+53DF */
  0xD3E0,   /* U+53E0 */
  0x0000,   /* U+53E1 */
  0x0000,   /* U+53E2 */
  0x0000,   /* U+53E3 */
  0x0000,   /* U+53E4 */
  0x0000,   /* U+53E5 */
  0xD3E6,   /* U+53E6 */
  0xD3E7,   /* U+53E7 */
  0x0000,   /* U+53E8 */
  0x0000,   /* U+53E9 */
  0x0000,   /* U+53EA */
  0x0000,   /* U+53EB */
  0x0000,   /* U+53EC */
  0x0000,   /* U+53ED */
  0x0000,   /* U+53EE */
  0x0000,   /* U+53EF */
  0x0000,   /* U+53F0 */
  0x0000,   /* U+53F1 */
  0x0000,   /* U+53F2 */
  0x0000,   /* U+53F3 */
  0xD3F4,   /* U+53F4 */
  0xD3F5,   /* U+53F5 */
  0x0000,   /* U+53F6 */
  0x0000,   /* U+53F7 */
  0x0000,   /* U+53F8 */
  0xD3F9,   /* U+53F9 */
  0x0000,   /* U+53FA */
  0xD3FB,   /* U+53FB */
  0xD3FC,   /* U+53FC */
  0xD3FD,   /* U+53FD */
  0xD3FE,   /* U+53FE */
  0xD3FF,   /* U+53FF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+5300 */
  0x0000,   /* U+5301 */
  0x0000,   /* U+5302 */
  0x0000,   /* U+5303 */
  0x0000,   /* U+5304 */
  0x0000,   /* U+5305 */
  0x0000,   /* U+5306 */
  0x0000,   /* U+5307 */
  0x0000,   /* U+5308 */
  0x0000,   /* U+5309 */
  0x0000,   /* U+530A */
  0x0000,   /* U+530B */
  0x0000,   /* U+530C */
  0x0000,   /* U+530D */
  0x0000,   /* U+530E */
  0x0000,   /* U+530F */
  0x0000,   /* U+5310 */
  0x0000,   /* U+5311 */
  0x0000,   /* U+5312 */
  0x0000,   /* U+5313 */
  0x0000,   /* U+5314 */
  0x0000,   /* U+5315 */
  0x0000,   /* U+5316 */
  0x0000,   /* U+5317 */
  0x0000,   /* U+5318 */
  0x0000,   /* U+5319 */
  0x0000,   /* U+531A */
  0x0000,   /* U+531B */
  0x0000,   /* U+531C */
  0x0000,   /* U+531D */
  0x0000,   /* U+531E */
  0x0000,   /* U+531F */
  0x0000,   /* U+5320 */
  0x0000,   /* U+5321 */
  0x0000,   /* U+5322 */
  0x0000,   /* U+5323 */
  0x0000,   /* U+5324 */
  0x0000,   /* U+5325 */
  0x0000,   /* U+5326 */
  0x0000,   /* U+5327 */
  0x0000,   /* U+5328 */
  0x0000,   /* U+5329 */
  0x0000,   /* U+532A */
  0x0000,   /* U+532B */
  0x0000,   /* U+532C */
  0x0000,   /* U+532D */
  0x0000,   /* U+532E */
  0x0000,   /* U+532F */
  0x0000,   /* U+5330 */
  0x0000,   /* U+5331 */
  0x0000,   /* U+5332 */
  0x0000,   /* U+5333 */
  0x0000,   /* U+5334 */
  0x0000,   /* U+5335 */
  0x0000,   /* U+5336 */
  0x0000,   /* U+5337 */
  0x0000,   /* U+5338 */
  0x0000,   /* U+5339 */
  0x0000,   /* U+533A */
  0x0000,   /* U+533B */
  0x0000,   /* U+533C */
  0x0000,   /* U+533D */
  0x0000,   /* U+533E */
  0x0000,   /* U+533F */
  0x0000,   /* U+5340 */
  0x0000,   /* U+5341 */
  0x0000,   /* U+5342 */
  0x0000,   /* U+5343 */
  0x0000,   /* U+5344 */
  0x0000,   /* U+5345 */
  0x0000,   /* U+5346 */
  0x0000,   /* U+5347 */
  0x0000,   /* U+5348 */
  0x0000,   /* U+5349 */
  0x0000,   /* U+534A */
  0x0000,   /* U+534B */
  0x0000,   /* U+534C */
  0x0000,   /* U+534D */
  0x0000,   /* U+534E */
  0x0000,   /* U+534F */
  0x0000,   /* U+5350 */
  0x0000,   /* U+5351 */
  0x0000,   /* U+5352 */
  0x0000,   /* U+5353 */
  0x0000,   /* U+5354 */
  0x0000,   /* U+5355 */
  0x0000,   /* U+5356 */
  0x0000,   /* U+5357 */
  0x0000,   /* U+5358 */
  0x0000,   /* U+5359 */
  0x0000,   /* U+535A */
  0x0000,   /* U+535B */
  0x0000,   /* U+535C */
  0x0000,   /* U+535D */
  0x0000,   /* U+535E */
  0x0000,   /* U+535F */
  0x0000,   /* U+5360 */
  0x0000,   /* U+5361 */
  0x0000,   /* U+5362 */
  0x0000,   /* U+5363 */
  0x0000,   /* U+5364 */
  0x0000,   /* U+5365 */
  0x0000,   /* U+5366 */
  0x0000,   /* U+5367 */
  0x0000,   /* U+5368 */
  0x0000,   /* U+5369 */
  0x0000,   /* U+536A */
  0x0000,   /* U+536B */
  0x0000,   /* U+536C */
  0x0000,   /* U+536D */
  0x0000,   /* U+536E */
  0x0000,   /* U+536F */
  0x0000,   /* U+5370 */
  0x0000,   /* U+5371 */
  0x0000,   /* U+5372 */
  0x0000,   /* U+5373 */
  0x0000,   /* U+5374 */
  0x0000,   /* U+5375 */
  0x0000,   /* U+5376 */
  0x0000,   /* U+5377 */
  0x0000,   /* U+5378 */
  0x0000,   /* U+5379 */
  0x0000,   /* U+537A */
  0x0000,   /* U+537B */
  0x0000,   /* U+537C */
  0x0000,   /* U+537D */
  0x0000,   /* U+537E */
  0x0000,   /* U+537F */
  0x0000,   /* U+5380 */
  0x0000,   /* U+5381 */
  0x0000,   /* U+5382 */
  0x0000,   /* U+5383 */
  0x0000,   /* U+5384 */
  0x0000,   /* U+5385 */
  0x0000,   /* U+5386 */
  0x0000,   /* U+5387 */
  0x0000,   /* U+5388 */
  0x0000,   /* U+5389 */
  0x0000,   /* U+538A */
  0x0000,   /* U+538B */
  0x0000,   /* U+538C */
  0x0000,   /* U+538D */
  0x0000,   /* U+538E */
  0x0000,   /* U+538F */
  0x0000,   /* U+5390 */
  0x0000,   /* U+5391 */
  0x0000,   /* U+5392 */
  0x0000,   /* U+5393 */
  0x0000,   /* U+5394 */
  0x0000,   /* U+5395 */
  0x0000,   /* U+5396 */
  0x0000,   /* U+5397 */
  0x0000,   /* U+5398 */
  0x0000,   /* U+5399 */
  0x0000,   /* U+539A */
  0x0000,   /* U+539B */
  0x0000,   /* U+539C */
  0x0000,   /* U+539D */
  0x0000,   /* U+539E */
  0x0000,   /* U+539F */
  0x0000,   /* U+53A0 */
  0x0000,   /* U+53A1 */
  0x0000,   /* U+53A2 */
  0x0000,   /* U+53A3 */
  0x0000,   /* U+53A4 */
  0x0000,   /* U+53A5 */
  0x0000,   /* U+53A6 */
  0x0000,   /* U+53A7 */
  0x0000,   /* U+53A8 */
  0x0000,   /* U+53A9 */
  0x0000,   /* U+53AA */
  0x0000,   /* U+53AB */
  0x0000,   /* U+53AC */
  0x0000,   /* U+53AD */
  0x0000,   /* U+53AE */
  0x0000,   /* U+53AF */
  0x0000,   /* U+53B0 */
  0x0000,   /* U+53B1 */
  0x0000,   /* U+53B2 */
  0x0000,   /* U+53B3 */
  0x0000,   /* U+53B4 */
  0x0000,   /* U+53B5 */
  0x0000,   /* U+53B6 */
  0x0000,   /* U+53B7 */
  0x0000,   /* U+53B8 */
  0x0000,   /* U+53B9 */
  0x0000,   /* U+53BA */
  0x0000,   /* U+53BB */
  0x0000,   /* U+53BC */
  0x0000,   /* U+53BD */
  0x0000,   /* U+53BE */
  0x0000,   /* U+53BF */
  0x0000,   /* U+53C0 */
  0x0000,   /* U+53C1 */
  0x0000,   /* U+53C2 */
  0x0000,   /* U+53C3 */
  0x0000,   /* U+53C4 */
  0x0000,   /* U+53C5 */
  0x0000,   /* U+53C6 */
  0x0000,   /* U+53C7 */
  0x0000,   /* U+53C8 */
  0x0000,   /* U+53C9 */
  0x0000,   /* U+53CA */
  0x0000,   /* U+53CB */
  0x0000,   /* U+53CC */
  0x0000,   /* U+53CD */
  0x0000,   /* U+53CE */
  0x0000,   /* U+53CF */
  0x0000,   /* U+53D0 */
  0x0000,   /* U+53D1 */
  0x0000,   /* U+53D2 */
  0x0000,   /* U+53D3 */
  0x0000,   /* U+53D4 */
  0x0000,   /* U+53D5 */
  0x0000,   /* U+53D6 */
  0x0000,   /* U+53D7 */
  0x0000,   /* U+53D8 */
  0x0000,   /* U+53D9 */
  0x0000,   /* U+53DA */
  0x0000,   /* U+53DB */
  0x0000,   /* U+53DC */
  0x0000,   /* U+53DD */
  0x0000,   /* U+53DE */
  0x0000,   /* U+53DF */
  0x0000,   /* U+53E0 */
  0x0000,   /* U+53E1 */
  0x0000,   /* U+53E2 */
  0x0000,   /* U+53E3 */
  0x0000,   /* U+53E4 */
  0x0000,   /* U+53E5 */
  0x0000,   /* U+53E6 */
  0x0000,   /* U+53E7 */
  0x0000,   /* U+53E8 */
  0x0000,   /* U+53E9 */
  0x0000,   /* U+53EA */
  0x0000,   /* U+53EB */
  0x0000,   /* U+53EC */
  0x0000,   /* U+53ED */
  0x0000,   /* U+53EE */
  0x0000,   /* U+53EF */
  0x0000,   /* U+53F0 */
  0x0000,   /* U+53F1 */
  0x0000,   /* U+53F2 */
  0x0000,   /* U+53F3 */
  0x0000,   /* U+53F4 */
  0x0000,   /* U+53F5 */
  0x0000,   /* U+53F6 */
  0x0000,   /* U+53F7 */
  0x0000,   /* U+53F8 */
  0x0000,   /* U+53F9 */
  0x0000,   /* U+53FA */
  0x0000,   /* U+53FB */
  0x0000,   /* U+53FC */
  0x0000,   /* U+53FD */
  0x0000,   /* U+53FE */
  0x0000,   /* U+53FF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+5300 */
  0x0000,   /* U+5301 */
  0x0000,   /* U+5302 */
  0x0000,   /* U+5303 */
  0x0000,   /* U+5304 */
  0x0000,   /* U+5305 */
  0x0000,   /* U+5306 */
  0x0000,   /* U+5307 */
  0x0000,   /* U+5308 */
  0x0000,   /* U+5309 */
  0x0000,   /* U+530A */
  0x0000,   /* U+530B */
  0x0000,   /* U+530C */
  0x0000,   /* U+530D */
  0x0000,   /* U+530E */
  0x0000,   /* U+530F */
  0x0000,   /* U+5310 */
  0x0000,   /* U+5311 */
  0x0000,   /* U+5312 */
  0x0000,   /* U+5313 */
  0x0000,   /* U+5314 */
  0x0000,   /* U+5315 */
  0x0000,   /* U+5316 */
  0x0000,   /* U+5317 */
  0x0000,   /* U+5318 */
  0x0000,   /* U+5319 */
  0x0000,   /* U+531A */
  0x0000,   /* U+531B */
  0x0000,   /* U+531C */
  0x0000,   /* U+531D */
  0x0000,   /* U+531E */
  0x0000,   /* U+531F */
  0x0000,   /* U+5320 */
  0x0000,   /* U+5321 */
  0x0000,   /* U+5322 */
  0x0000,   /* U+5323 */
  0x0000,   /* U+5324 */
  0x0000,   /* U+5325 */
  0x0000,   /* U+5326 */
  0x0000,   /* U+5327 */
  0x0000,   /* U+5328 */
  0x0000,   /* U+5329 */
  0x0000,   /* U+532A */
  0x0000,   /* U+532B */
  0x0000,   /* U+532C */
  0x0000,   /* U+532D */
  0x0000,   /* U+532E */
  0x0000,   /* U+532F */
  0x0000,   /* U+5330 */
  0x0000,   /* U+5331 */
  0x0000,   /* U+5332 */
  0x0000,   /* U+5333 */
  0x0000,   /* U+5334 */
  0x0000,   /* U+5335 */
  0x0000,   /* U+5336 */
  0x0000,   /* U+5337 */
  0x0000,   /* U+5338 */
  0x0000,   /* U+5339 */
  0x0000,   /* U+533A */
  0x0000,   /* U+533B */
  0x0000,   /* U+533C */
  0x0000,   /* U+533D */
  0x0000,   /* U+533E */
  0x0000,   /* U+533F */
  0x0000,   /* U+5340 */
  0x0000,   /* U+5341 */
  0x0000,   /* U+5342 */
  0x0000,   /* U+5343 */
  0x0000,   /* U+5344 */
  0x0000,   /* U+5345 */
  0x0000,   /* U+5346 */
  0x0000,   /* U+5347 */
  0x0000,   /* U+5348 */
  0x0000,   /* U+5349 */
  0x0000,   /* U+534A */
  0x0000,   /* U+534B */
  0x0000,   /* U+534C */
  0x0000,   /* U+534D */
  0x0000,   /* U+534E */
  0x0000,   /* U+534F */
  0x0000,   /* U+5350 */
  0x0000,   /* U+5351 */
  0x0000,   /* U+5352 */
  0x0000,   /* U+5353 */
  0x0000,   /* U+5354 */
  0x0000,   /* U+5355 */
  0x0000,   /* U+5356 */
  0x0000,   /* U+5357 */
  0x0000,   /* U+5358 */
  0x0000,   /* U+5359 */
  0x0000,   /* U+535A */
  0x0000,   /* U+535B */
  0x0000,   /* U+535C */
  0x0000,   /* U+535D */
  0x0000,   /* U+535E */
  0x0000,   /* U+535F */
  0x0000,   /* U+5360 */
  0x0000,   /* U+5361 */
  0x0000,   /* U+5362 */
  0x0000,   /* U+5363 */
  0x0000,   /* U+5364 */
  0x0000,   /* U+5365 */
  0x0000,   /* U+5366 */
  0x0000,   /* U+5367 */
  0x0000,   /* U+5368 */
  0x0000,   /* U+5369 */
  0x0000,   /* U+536A */
  0x0000,   /* U+536B */
  0x0000,   /* U+536C */
  0x0000,   /* U+536D */
  0x0000,   /* U+536E */
  0x0000,   /* U+536F */
  0x0000,   /* U+5370 */
  0x0000,   /* U+5371 */
  0x0000,   /* U+5372 */
  0x0000,   /* U+5373 */
  0x0000,   /* U+5374 */
  0x0000,   /* U+5375 */
  0x0000,   /* U+5376 */
  0x0000,   /* U+5377 */
  0x0000,   /* U+5378 */
  0x0000,   /* U+5379 */
  0x0000,   /* U+537A */
  0x0000,   /* U+537B */
  0x0000,   /* U+537C */
  0x0000,   /* U+537D */
  0x0000,   /* U+537E */
  0x0000,   /* U+537F */
  0x0000,   /* U+5380 */
  0x0000,   /* U+5381 */
  0x0000,   /* U+5382 */
  0x0000,   /* U+5383 */
  0x0000,   /* U+5384 */
  0x0000,   /* U+5385 */
  0x0000,   /* U+5386 */
  0x0000,   /* U+5387 */
  0x0000,   /* U+5388 */
  0x0000,   /* U+5389 */
  0x0000,   /* U+538A */
  0x0000,   /* U+538B */
  0x0000,   /* U+538C */
  0x0000,   /* U+538D */
  0x0000,   /* U+538E */
  0x0000,   /* U+538F */
  0x0000,   /* U+5390 */
  0x0000,   /* U+5391 */
  0x0000,   /* U+5392 */
  0x0000,   /* U+5393 */
  0x0000,   /* U+5394 */
  0x0000,   /* U+5395 */
  0x0000,   /* U+5396 */
  0x0000,   /* U+5397 */
  0x0000,   /* U+5398 */
  0x0000,   /* U+5399 */
  0x0000,   /* U+539A */
  0x0000,   /* U+539B */
  0x0000,   /* U+539C */
  0x0000,   /* U+539D */
  0x0000,   /* U+539E */
  0x0000,   /* U+539F */
  0x0000,   /* U+53A0 */
  0x0000,   /* U+53A1 */
  0x0000,   /* U+53A2 */
  0x0000,   /* U+53A3 */
  0x0000,   /* U+53A4 */
  0x0000,   /* U+53A5 */
  0x0000,   /* U+53A6 */
  0x0000,   /* U+53A7 */
  0x0000,   /* U+53A8 */
  0x0000,   /* U+53A9 */
  0x0000,   /* U+53AA */
  0x0000,   /* U+53AB */
  0x0000,   /* U+53AC */
  0x0000,   /* U+53AD */
  0x0000,   /* U+53AE */
  0x0000,   /* U+53AF */
  0x0000,   /* U+53B0 */
  0x0000,   /* U+53B1 */
  0x0000,   /* U+53B2 */
  0x0000,   /* U+53B3 */
  0x0000,   /* U+53B4 */
  0x0000,   /* U+53B5 */
  0x0000,   /* U+53B6 */
  0x0000,   /* U+53B7 */
  0x0000,   /* U+53B8 */
  0x0000,   /* U+53B9 */
  0x0000,   /* U+53BA */
  0x0000,   /* U+53BB */
  0x0000,   /* U+53BC */
  0x0000,   /* U+53BD */
  0x0000,   /* U+53BE */
  0x0000,   /* U+53BF */
  0x0000,   /* U+53C0 */
  0x0000,   /* U+53C1 */
  0x0000,   /* U+53C2 */
  0x0000,   /* U+53C3 */
  0x0000,   /* U+53C4 */
  0x0000,   /* U+53C5 */
  0x0000,   /* U+53C6 */
  0x0000,   /* U+53C7 */
  0x0000,   /* U+53C8 */
  0x0000,   /* U+53C9 */
  0x0000,   /* U+53CA */
  0x0000,   /* U+53CB */
  0x0000,   /* U+53CC */
  0x0000,   /* U+53CD */
  0x0000,   /* U+53CE */
  0x0000,   /* U+53CF */
  0x0000,   /* U+53D0 */
  0x0000,   /* U+53D1 */
  0x0000,   /* U+53D2 */
  0x0000,   /* U+53D3 */
  0x0000,   /* U+53D4 */
  0x0000,   /* U+53D5 */
  0x0000,   /* U+53D6 */
  0x0000,   /* U+53D7 */
  0x0000,   /* U+53D8 */
  0x0000,   /* U+53D9 */
  0x0000,   /* U+53DA */
  0x0000,   /* U+53DB */
  0x0000,   /* U+53DC */
  0x0000,   /* U+53DD */
  0x0000,   /* U+53DE */
  0x0000,   /* U+53DF */
  0x0000,   /* U+53E0 */
  0x0000,   /* U+53E1 */
  0x0000,   /* U+53E2 */
  0x0000,   /* U+53E3 */
  0x0000,   /* U+53E4 */
  0x0000,   /* U+53E5 */
  0x0000,   /* U+53E6 */
  0x0000,   /* U+53E7 */
  0x0000,   /* U+53E8 */
  0x0000,   /* U+53E9 */
  0x0000,   /* U+53EA */
  0x0000,   /* U+53EB */
  0x0000,   /* U+53EC */
  0x0000,   /* U+53ED */
  0x0000,   /* U+53EE */
  0x0000,   /* U+53EF */
  0x0000,   /* U+53F0 */
  0x0000,   /* U+53F1 */
  0x0000,   /* U+53F2 */
  0x0000,   /* U+53F3 */
  0x0000,   /* U+53F4 */
  0x0000,   /* U+53F5 */
  0x0000,   /* U+53F6 */
  0x0000,   /* U+53F7 */
  0x0000,   /* U+53F8 */
  0x0000,   /* U+53F9 */
  0x0000,   /* U+53FA */
  0x0000,   /* U+53FB */
  0x0000,   /* U+53FC */
  0x0000,   /* U+53FD */
  0x0000,   /* U+53FE */
  0x0000,   /* U+53FF */
};

uint16 ja_han_page54[]= {
  /* Number of CEs for each character. */
  2, 1, 2, 1, 1, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 1, 2, 1,
  1, 2, 2, 2, 2, 2, 1, 2, 2, 1, 2, 1, 1, 1, 1, 2,
  2, 2, 2, 2, 2, 2, 1, 2, 1, 1, 2, 1, 1, 1, 1, 2,
  1, 2, 1, 2, 2, 2, 1, 2, 1, 1, 1, 2, 2, 2, 1, 2,
  2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1,
  2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 1, 2, 2, 2, 2, 2,
  1, 1, 2, 1, 2, 1, 1, 1, 2, 2, 2, 1, 1, 1, 2, 2,
  1, 2, 2, 2, 1, 2, 1, 2, 2, 2, 2, 1, 1, 2, 1, 1,
  1, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 1, 2, 1, 1, 2, 2, 1, 2, 2, 1, 1, 2, 2, 1,
  2, 2, 1, 1, 2, 2, 2, 2, 1, 2, 2, 2, 1, 1, 1, 2,
  1, 1, 1, 2, 1, 2, 2, 1, 1, 1, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2,
  2, 1, 1, 2, 2, 1, 1, 2, 1, 1, 2, 2, 2, 1, 1, 2,
  2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 1, 2, 2,

  /* Primary weight 1 for each character. */
  0xFB40,   /* U+5400 */
  0x6132,   /* U+5401 */
  0xFB40,   /* U+5402 */
  0x56A2,   /* U+5403 */
  0x55E3,   /* U+5404 */
  0xFB40,   /* U+5405 */
  0xFB40,   /* U+5406 */
  0xFB40,   /* U+5407 */
  0x5838,   /* U+5408 */
  0x56A1,   /* U+5409 */
  0x5C3A,   /* U+540A */
  0x5506,   /* U+540B */
  0x5CC8,   /* U+540C */
  0x5F09,   /* U+540D */
  0x57F2,   /* U+540E */
  0x5FA2,   /* U+540F */
  0x5C80,   /* U+5410 */
  0x57F1,   /* U+5411 */
  0xFB40,   /* U+5412 */
  0xFB40,   /* U+5413 */
  0xFB40,   /* U+5414 */
  0xFB40,   /* U+5415 */
  0xFB40,   /* U+5416 */
  0xFB40,   /* U+5417 */
  0xFB40,   /* U+5418 */
  0xFB40,   /* U+5419 */
  0xFB40,   /* U+541A */
  0x5744,   /* U+541B */
  0xFB40,   /* U+541C */
  0x613B,   /* U+541D */
  0xFB40,   /* U+541E */
  0x571A,   /* U+541F */
  0x5EB7,   /* U+5420 */
  0xFB40,   /* U+5421 */
  0xFB40,   /* U+5422 */
  0xFB40,   /* U+5423 */
  0xFB40,   /* U+5424 */
  0xFB40,   /* U+5425 */
  0x5DB0,   /* U+5426 */
  0xFB40,   /* U+5427 */
  0xFB40,   /* U+5428 */
  0x613A,   /* U+5429 */
  0xFB40,   /* U+542A */
  0x5659,   /* U+542B */
  0x6135,   /* U+542C */
  0x6136,   /* U+542D */
  0x6138,   /* U+542E */
  0xFB40,   /* U+542F */
  0xFB40,   /* U+5430 */
  0xFB40,   /* U+5431 */
  0xFB40,   /* U+5432 */
  0xFB40,   /* U+5433 */
  0xFB40,   /* U+5434 */
  0xFB40,   /* U+5435 */
  0x6139,   /* U+5436 */
  0xFB40,   /* U+5437 */
  0x56B4,   /* U+5438 */
  0x5A66,   /* U+5439 */
  0xFB40,   /* U+543A */
  0x5E3C,   /* U+543B */
  0x6137,   /* U+543C */
  0x6133,   /* U+543D */
  0x57D6,   /* U+543E */
  0xFB40,   /* U+543F */
  0x6134,   /* U+5440 */
  0xFB40,   /* U+5441 */
  0x6009,   /* U+5442 */
  0xFB40,   /* U+5443 */
  0xFB40,   /* U+5444 */
  0xFB40,   /* U+5445 */
  0x5E81,   /* U+5446 */
  0xFB40,   /* U+5447 */
  0x5C43,   /* U+5448 */
  0x57D5,   /* U+5449 */
  0x5841,   /* U+544A */
  0xFB40,   /* U+544B */
  0xFB40,   /* U+544C */
  0xFB40,   /* U+544D */
  0x613C,   /* U+544E */
  0xFB40,   /* U+544F */
  0xFB40,   /* U+5450 */
  0x5CF4,   /* U+5451 */
  0xFB40,   /* U+5452 */
  0xFB40,   /* U+5453 */
  0xFB40,   /* U+5454 */
  0xFB40,   /* U+5455 */
  0xFB40,   /* U+5456 */
  0xFB40,   /* U+5457 */
  0xFB40,   /* U+5458 */
  0xFB40,   /* U+5459 */
  0xFB40,   /* U+545A */
  0xFB40,   /* U+545B */
  0xFB40,   /* U+545C */
  0xFB40,   /* U+545D */
  0xFB40,   /* U+545E */
  0x6140,   /* U+545F */
  0xFB40,   /* U+5460 */
  0xFB40,   /* U+5461 */
  0xFB40,   /* U+5462 */
  0xFB40,   /* U+5463 */
  0xFB40,   /* U+5464 */
  0xFB40,   /* U+5465 */
  0xFB40,   /* U+5466 */
  0xFB40,   /* U+5467 */
  0x5969,   /* U+5468 */
  0xFB40,   /* U+5469 */
  0x5961,   /* U+546A */
  0xFB40,   /* U+546B */
  0xFB40,   /* U+546C */
  0xFB40,   /* U+546D */
  0xFB40,   /* U+546E */
  0xFB40,   /* U+546F */
  0x6143,   /* U+5470 */
  0x6141,   /* U+5471 */
  0xFB40,   /* U+5472 */
  0x5EEE,   /* U+5473 */
  0xFB40,   /* U+5474 */
  0x613E,   /* U+5475 */
  0x6147,   /* U+5476 */
  0x6142,   /* U+5477 */
  0xFB40,   /* U+5478 */
  0xFB40,   /* U+5479 */
  0xFB40,   /* U+547A */
  0x6145,   /* U+547B */
  0x57B9,   /* U+547C */
  0x5F0A,   /* U+547D */
  0xFB40,   /* U+547E */
  0xFB40,   /* U+547F */
  0x6146,   /* U+5480 */
  0xFB40,   /* U+5481 */
  0xFB40,   /* U+5482 */
  0xFB40,   /* U+5483 */
  0x6148,   /* U+5484 */
  0xFB40,   /* U+5485 */
  0x614A,   /* U+5486 */
  0xFB40,   /* U+5487 */
  0xFB40,   /* U+5488 */
  0xFB40,   /* U+5489 */
  0xFB40,   /* U+548A */
  0x589F,   /* U+548B */
  0x6027,   /* U+548C */
  0xFB40,   /* U+548D */
  0x613F,   /* U+548E */
  0x613D,   /* U+548F */
  0x6149,   /* U+5490 */
  0xFB40,   /* U+5491 */
  0x6144,   /* U+5492 */
  0xFB40,   /* U+5493 */
  0xFB40,   /* U+5494 */
  0xFB40,   /* U+5495 */
  0xFB40,   /* U+5496 */
  0xFB40,   /* U+5497 */
  0xFB40,   /* U+5498 */
  0xFB40,   /* U+5499 */
  0xFB40,   /* U+549A */
  0xFB40,   /* U+549B */
  0xFB40,   /* U+549C */
  0xFB40,   /* U+549D */
  0xFB40,   /* U+549E */
  0xFB40,   /* U+549F */
  0xFB40,   /* U+54A0 */
  0xFB40,   /* U+54A1 */
  0x614C,   /* U+54A2 */
  0xFB40,   /* U+54A3 */
  0x6155,   /* U+54A4 */
  0x614E,   /* U+54A5 */
  0xFB40,   /* U+54A6 */
  0xFB40,   /* U+54A7 */
  0x6152,   /* U+54A8 */
  0xFB40,   /* U+54A9 */
  0xFB40,   /* U+54AA */
  0x6153,   /* U+54AB */
  0x614F,   /* U+54AC */
  0xFB40,   /* U+54AD */
  0xFB40,   /* U+54AE */
  0x6170,   /* U+54AF */
  0xFB40,   /* U+54B0 */
  0xFB40,   /* U+54B1 */
  0x5898,   /* U+54B2 */
  0x55CE,   /* U+54B3 */
  0xFB40,   /* U+54B4 */
  0xFB40,   /* U+54B5 */
  0xFB40,   /* U+54B6 */
  0xFB40,   /* U+54B7 */
  0x614D,   /* U+54B8 */
  0xFB40,   /* U+54B9 */
  0xFB40,   /* U+54BA */
  0xFB40,   /* U+54BB */
  0x6157,   /* U+54BC */
  0x54F9,   /* U+54BD */
  0x6156,   /* U+54BE */
  0xFB40,   /* U+54BF */
  0x54A8,   /* U+54C0 */
  0x5DFB,   /* U+54C1 */
  0x6154,   /* U+54C2 */
  0xFB40,   /* U+54C3 */
  0x6150,   /* U+54C4 */
  0xFB40,   /* U+54C5 */
  0xFB40,   /* U+54C6 */
  0x614B,   /* U+54C7 */
  0x6151,   /* U+54C8 */
  0x5877,   /* U+54C9 */
  0xFB40,   /* U+54CA */
  0xFB40,   /* U+54CB */
  0xFB40,   /* U+54CC */
  0xFB40,   /* U+54CD */
  0xFB40,   /* U+54CE */
  0xFB40,   /* U+54CF */
  0xFB40,   /* U+54D0 */
  0xFB40,   /* U+54D1 */
  0xFB40,   /* U+54D2 */
  0xFB40,   /* U+54D3 */
  0xFB40,   /* U+54D4 */
  0xFB40,   /* U+54D5 */
  0xFB40,   /* U+54D6 */
  0xFB40,   /* U+54D7 */
  0x6158,   /* U+54D8 */
  0xFB40,   /* U+54D9 */
  0xFB40,   /* U+54DA */
  0xFB40,   /* U+54DB */
  0xFB40,   /* U+54DC */
  0xFB40,   /* U+54DD */
  0xFB40,   /* U+54DE */
  0xFB40,   /* U+54DF */
  0xFB40,   /* U+54E0 */
  0x54FA,   /* U+54E1 */
  0x6161,   /* U+54E2 */
  0xFB40,   /* U+54E3 */
  0xFB40,   /* U+54E4 */
  0x6159,   /* U+54E5 */
  0x615A,   /* U+54E6 */
  0xFB40,   /* U+54E7 */
  0x59CC,   /* U+54E8 */
  0x5ED6,   /* U+54E9 */
  0xFB40,   /* U+54EA */
  0xFB40,   /* U+54EB */
  0xFB40,   /* U+54EC */
  0x615F,   /* U+54ED */
  0x615E,   /* U+54EE */
  0xFB40,   /* U+54EF */
  0xFB40,   /* U+54F0 */
  0xFB40,   /* U+54F1 */
  0x5C68,   /* U+54F2 */
  0xFB40,   /* U+54F3 */
  0xFB40,   /* U+54F4 */
  0xFB40,   /* U+54F5 */
  0xFB40,   /* U+54F6 */
  0xFB40,   /* U+54F7 */
  0xFB40,   /* U+54F8 */
  0xFB40,   /* U+54F9 */
  0x6160,   /* U+54FA */
  0xFB40,   /* U+54FB */
  0xFB40,   /* U+54FC */
  0x615D,   /* U+54FD */
  0xFB40,   /* U+54FE */
  0xFB40,   /* U+54FF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+5400 */
  0x0020,   /* U+5401 */
  0x0020,   /* U+5402 */
  0x0020,   /* U+5403 */
  0x0020,   /* U+5404 */
  0x0020,   /* U+5405 */
  0x0020,   /* U+5406 */
  0x0020,   /* U+5407 */
  0x0020,   /* U+5408 */
  0x0020,   /* U+5409 */
  0x0020,   /* U+540A */
  0x0020,   /* U+540B */
  0x0020,   /* U+540C */
  0x0020,   /* U+540D */
  0x0020,   /* U+540E */
  0x0020,   /* U+540F */
  0x0020,   /* U+5410 */
  0x0020,   /* U+5411 */
  0x0020,   /* U+5412 */
  0x0020,   /* U+5413 */
  0x0020,   /* U+5414 */
  0x0020,   /* U+5415 */
  0x0020,   /* U+5416 */
  0x0020,   /* U+5417 */
  0x0020,   /* U+5418 */
  0x0020,   /* U+5419 */
  0x0020,   /* U+541A */
  0x0020,   /* U+541B */
  0x0020,   /* U+541C */
  0x0020,   /* U+541D */
  0x0020,   /* U+541E */
  0x0020,   /* U+541F */
  0x0020,   /* U+5420 */
  0x0020,   /* U+5421 */
  0x0020,   /* U+5422 */
  0x0020,   /* U+5423 */
  0x0020,   /* U+5424 */
  0x0020,   /* U+5425 */
  0x0020,   /* U+5426 */
  0x0020,   /* U+5427 */
  0x0020,   /* U+5428 */
  0x0020,   /* U+5429 */
  0x0020,   /* U+542A */
  0x0020,   /* U+542B */
  0x0020,   /* U+542C */
  0x0020,   /* U+542D */
  0x0020,   /* U+542E */
  0x0020,   /* U+542F */
  0x0020,   /* U+5430 */
  0x0020,   /* U+5431 */
  0x0020,   /* U+5432 */
  0x0020,   /* U+5433 */
  0x0020,   /* U+5434 */
  0x0020,   /* U+5435 */
  0x0020,   /* U+5436 */
  0x0020,   /* U+5437 */
  0x0020,   /* U+5438 */
  0x0020,   /* U+5439 */
  0x0020,   /* U+543A */
  0x0020,   /* U+543B */
  0x0020,   /* U+543C */
  0x0020,   /* U+543D */
  0x0020,   /* U+543E */
  0x0020,   /* U+543F */
  0x0020,   /* U+5440 */
  0x0020,   /* U+5441 */
  0x0020,   /* U+5442 */
  0x0020,   /* U+5443 */
  0x0020,   /* U+5444 */
  0x0020,   /* U+5445 */
  0x0020,   /* U+5446 */
  0x0020,   /* U+5447 */
  0x0020,   /* U+5448 */
  0x0020,   /* U+5449 */
  0x0020,   /* U+544A */
  0x0020,   /* U+544B */
  0x0020,   /* U+544C */
  0x0020,   /* U+544D */
  0x0020,   /* U+544E */
  0x0020,   /* U+544F */
  0x0020,   /* U+5450 */
  0x0020,   /* U+5451 */
  0x0020,   /* U+5452 */
  0x0020,   /* U+5453 */
  0x0020,   /* U+5454 */
  0x0020,   /* U+5455 */
  0x0020,   /* U+5456 */
  0x0020,   /* U+5457 */
  0x0020,   /* U+5458 */
  0x0020,   /* U+5459 */
  0x0020,   /* U+545A */
  0x0020,   /* U+545B */
  0x0020,   /* U+545C */
  0x0020,   /* U+545D */
  0x0020,   /* U+545E */
  0x0020,   /* U+545F */
  0x0020,   /* U+5460 */
  0x0020,   /* U+5461 */
  0x0020,   /* U+5462 */
  0x0020,   /* U+5463 */
  0x0020,   /* U+5464 */
  0x0020,   /* U+5465 */
  0x0020,   /* U+5466 */
  0x0020,   /* U+5467 */
  0x0020,   /* U+5468 */
  0x0020,   /* U+5469 */
  0x0020,   /* U+546A */
  0x0020,   /* U+546B */
  0x0020,   /* U+546C */
  0x0020,   /* U+546D */
  0x0020,   /* U+546E */
  0x0020,   /* U+546F */
  0x0020,   /* U+5470 */
  0x0020,   /* U+5471 */
  0x0020,   /* U+5472 */
  0x0020,   /* U+5473 */
  0x0020,   /* U+5474 */
  0x0020,   /* U+5475 */
  0x0020,   /* U+5476 */
  0x0020,   /* U+5477 */
  0x0020,   /* U+5478 */
  0x0020,   /* U+5479 */
  0x0020,   /* U+547A */
  0x0020,   /* U+547B */
  0x0020,   /* U+547C */
  0x0020,   /* U+547D */
  0x0020,   /* U+547E */
  0x0020,   /* U+547F */
  0x0020,   /* U+5480 */
  0x0020,   /* U+5481 */
  0x0020,   /* U+5482 */
  0x0020,   /* U+5483 */
  0x0020,   /* U+5484 */
  0x0020,   /* U+5485 */
  0x0020,   /* U+5486 */
  0x0020,   /* U+5487 */
  0x0020,   /* U+5488 */
  0x0020,   /* U+5489 */
  0x0020,   /* U+548A */
  0x0020,   /* U+548B */
  0x0020,   /* U+548C */
  0x0020,   /* U+548D */
  0x0020,   /* U+548E */
  0x0020,   /* U+548F */
  0x0020,   /* U+5490 */
  0x0020,   /* U+5491 */
  0x0020,   /* U+5492 */
  0x0020,   /* U+5493 */
  0x0020,   /* U+5494 */
  0x0020,   /* U+5495 */
  0x0020,   /* U+5496 */
  0x0020,   /* U+5497 */
  0x0020,   /* U+5498 */
  0x0020,   /* U+5499 */
  0x0020,   /* U+549A */
  0x0020,   /* U+549B */
  0x0020,   /* U+549C */
  0x0020,   /* U+549D */
  0x0020,   /* U+549E */
  0x0020,   /* U+549F */
  0x0020,   /* U+54A0 */
  0x0020,   /* U+54A1 */
  0x0020,   /* U+54A2 */
  0x0020,   /* U+54A3 */
  0x0020,   /* U+54A4 */
  0x0020,   /* U+54A5 */
  0x0020,   /* U+54A6 */
  0x0020,   /* U+54A7 */
  0x0020,   /* U+54A8 */
  0x0020,   /* U+54A9 */
  0x0020,   /* U+54AA */
  0x0020,   /* U+54AB */
  0x0020,   /* U+54AC */
  0x0020,   /* U+54AD */
  0x0020,   /* U+54AE */
  0x0020,   /* U+54AF */
  0x0020,   /* U+54B0 */
  0x0020,   /* U+54B1 */
  0x0020,   /* U+54B2 */
  0x0020,   /* U+54B3 */
  0x0020,   /* U+54B4 */
  0x0020,   /* U+54B5 */
  0x0020,   /* U+54B6 */
  0x0020,   /* U+54B7 */
  0x0020,   /* U+54B8 */
  0x0020,   /* U+54B9 */
  0x0020,   /* U+54BA */
  0x0020,   /* U+54BB */
  0x0020,   /* U+54BC */
  0x0020,   /* U+54BD */
  0x0020,   /* U+54BE */
  0x0020,   /* U+54BF */
  0x0020,   /* U+54C0 */
  0x0020,   /* U+54C1 */
  0x0020,   /* U+54C2 */
  0x0020,   /* U+54C3 */
  0x0020,   /* U+54C4 */
  0x0020,   /* U+54C5 */
  0x0020,   /* U+54C6 */
  0x0020,   /* U+54C7 */
  0x0020,   /* U+54C8 */
  0x0020,   /* U+54C9 */
  0x0020,   /* U+54CA */
  0x0020,   /* U+54CB */
  0x0020,   /* U+54CC */
  0x0020,   /* U+54CD */
  0x0020,   /* U+54CE */
  0x0020,   /* U+54CF */
  0x0020,   /* U+54D0 */
  0x0020,   /* U+54D1 */
  0x0020,   /* U+54D2 */
  0x0020,   /* U+54D3 */
  0x0020,   /* U+54D4 */
  0x0020,   /* U+54D5 */
  0x0020,   /* U+54D6 */
  0x0020,   /* U+54D7 */
  0x0020,   /* U+54D8 */
  0x0020,   /* U+54D9 */
  0x0020,   /* U+54DA */
  0x0020,   /* U+54DB */
  0x0020,   /* U+54DC */
  0x0020,   /* U+54DD */
  0x0020,   /* U+54DE */
  0x0020,   /* U+54DF */
  0x0020,   /* U+54E0 */
  0x0020,   /* U+54E1 */
  0x0020,   /* U+54E2 */
  0x0020,   /* U+54E3 */
  0x0020,   /* U+54E4 */
  0x0020,   /* U+54E5 */
  0x0020,   /* U+54E6 */
  0x0020,   /* U+54E7 */
  0x0020,   /* U+54E8 */
  0x0020,   /* U+54E9 */
  0x0020,   /* U+54EA */
  0x0020,   /* U+54EB */
  0x0020,   /* U+54EC */
  0x0020,   /* U+54ED */
  0x0020,   /* U+54EE */
  0x0020,   /* U+54EF */
  0x0020,   /* U+54F0 */
  0x0020,   /* U+54F1 */
  0x0020,   /* U+54F2 */
  0x0020,   /* U+54F3 */
  0x0020,   /* U+54F4 */
  0x0020,   /* U+54F5 */
  0x0020,   /* U+54F6 */
  0x0020,   /* U+54F7 */
  0x0020,   /* U+54F8 */
  0x0020,   /* U+54F9 */
  0x0020,   /* U+54FA */
  0x0020,   /* U+54FB */
  0x0020,   /* U+54FC */
  0x0020,   /* U+54FD */
  0x0020,   /* U+54FE */
  0x0020,   /* U+54FF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+5400 */
  0x0002,   /* U+5401 */
  0x0002,   /* U+5402 */
  0x0002,   /* U+5403 */
  0x0002,   /* U+5404 */
  0x0002,   /* U+5405 */
  0x0002,   /* U+5406 */
  0x0002,   /* U+5407 */
  0x0002,   /* U+5408 */
  0x0002,   /* U+5409 */
  0x0002,   /* U+540A */
  0x0002,   /* U+540B */
  0x0002,   /* U+540C */
  0x0002,   /* U+540D */
  0x0002,   /* U+540E */
  0x0002,   /* U+540F */
  0x0002,   /* U+5410 */
  0x0002,   /* U+5411 */
  0x0002,   /* U+5412 */
  0x0002,   /* U+5413 */
  0x0002,   /* U+5414 */
  0x0002,   /* U+5415 */
  0x0002,   /* U+5416 */
  0x0002,   /* U+5417 */
  0x0002,   /* U+5418 */
  0x0002,   /* U+5419 */
  0x0002,   /* U+541A */
  0x0002,   /* U+541B */
  0x0002,   /* U+541C */
  0x0002,   /* U+541D */
  0x0002,   /* U+541E */
  0x0002,   /* U+541F */
  0x0002,   /* U+5420 */
  0x0002,   /* U+5421 */
  0x0002,   /* U+5422 */
  0x0002,   /* U+5423 */
  0x0002,   /* U+5424 */
  0x0002,   /* U+5425 */
  0x0002,   /* U+5426 */
  0x0002,   /* U+5427 */
  0x0002,   /* U+5428 */
  0x0002,   /* U+5429 */
  0x0002,   /* U+542A */
  0x0002,   /* U+542B */
  0x0002,   /* U+542C */
  0x0002,   /* U+542D */
  0x0002,   /* U+542E */
  0x0002,   /* U+542F */
  0x0002,   /* U+5430 */
  0x0002,   /* U+5431 */
  0x0002,   /* U+5432 */
  0x0002,   /* U+5433 */
  0x0002,   /* U+5434 */
  0x0002,   /* U+5435 */
  0x0002,   /* U+5436 */
  0x0002,   /* U+5437 */
  0x0002,   /* U+5438 */
  0x0002,   /* U+5439 */
  0x0002,   /* U+543A */
  0x0002,   /* U+543B */
  0x0002,   /* U+543C */
  0x0002,   /* U+543D */
  0x0002,   /* U+543E */
  0x0002,   /* U+543F */
  0x0002,   /* U+5440 */
  0x0002,   /* U+5441 */
  0x0002,   /* U+5442 */
  0x0002,   /* U+5443 */
  0x0002,   /* U+5444 */
  0x0002,   /* U+5445 */
  0x0002,   /* U+5446 */
  0x0002,   /* U+5447 */
  0x0002,   /* U+5448 */
  0x0002,   /* U+5449 */
  0x0002,   /* U+544A */
  0x0002,   /* U+544B */
  0x0002,   /* U+544C */
  0x0002,   /* U+544D */
  0x0002,   /* U+544E */
  0x0002,   /* U+544F */
  0x0002,   /* U+5450 */
  0x0002,   /* U+5451 */
  0x0002,   /* U+5452 */
  0x0002,   /* U+5453 */
  0x0002,   /* U+5454 */
  0x0002,   /* U+5455 */
  0x0002,   /* U+5456 */
  0x0002,   /* U+5457 */
  0x0002,   /* U+5458 */
  0x0002,   /* U+5459 */
  0x0002,   /* U+545A */
  0x0002,   /* U+545B */
  0x0002,   /* U+545C */
  0x0002,   /* U+545D */
  0x0002,   /* U+545E */
  0x0002,   /* U+545F */
  0x0002,   /* U+5460 */
  0x0002,   /* U+5461 */
  0x0002,   /* U+5462 */
  0x0002,   /* U+5463 */
  0x0002,   /* U+5464 */
  0x0002,   /* U+5465 */
  0x0002,   /* U+5466 */
  0x0002,   /* U+5467 */
  0x0002,   /* U+5468 */
  0x0002,   /* U+5469 */
  0x0002,   /* U+546A */
  0x0002,   /* U+546B */
  0x0002,   /* U+546C */
  0x0002,   /* U+546D */
  0x0002,   /* U+546E */
  0x0002,   /* U+546F */
  0x0002,   /* U+5470 */
  0x0002,   /* U+5471 */
  0x0002,   /* U+5472 */
  0x0002,   /* U+5473 */
  0x0002,   /* U+5474 */
  0x0002,   /* U+5475 */
  0x0002,   /* U+5476 */
  0x0002,   /* U+5477 */
  0x0002,   /* U+5478 */
  0x0002,   /* U+5479 */
  0x0002,   /* U+547A */
  0x0002,   /* U+547B */
  0x0002,   /* U+547C */
  0x0002,   /* U+547D */
  0x0002,   /* U+547E */
  0x0002,   /* U+547F */
  0x0002,   /* U+5480 */
  0x0002,   /* U+5481 */
  0x0002,   /* U+5482 */
  0x0002,   /* U+5483 */
  0x0002,   /* U+5484 */
  0x0002,   /* U+5485 */
  0x0002,   /* U+5486 */
  0x0002,   /* U+5487 */
  0x0002,   /* U+5488 */
  0x0002,   /* U+5489 */
  0x0002,   /* U+548A */
  0x0002,   /* U+548B */
  0x0002,   /* U+548C */
  0x0002,   /* U+548D */
  0x0002,   /* U+548E */
  0x0002,   /* U+548F */
  0x0002,   /* U+5490 */
  0x0002,   /* U+5491 */
  0x0002,   /* U+5492 */
  0x0002,   /* U+5493 */
  0x0002,   /* U+5494 */
  0x0002,   /* U+5495 */
  0x0002,   /* U+5496 */
  0x0002,   /* U+5497 */
  0x0002,   /* U+5498 */
  0x0002,   /* U+5499 */
  0x0002,   /* U+549A */
  0x0002,   /* U+549B */
  0x0002,   /* U+549C */
  0x0002,   /* U+549D */
  0x0002,   /* U+549E */
  0x0002,   /* U+549F */
  0x0002,   /* U+54A0 */
  0x0002,   /* U+54A1 */
  0x0002,   /* U+54A2 */
  0x0002,   /* U+54A3 */
  0x0002,   /* U+54A4 */
  0x0002,   /* U+54A5 */
  0x0002,   /* U+54A6 */
  0x0002,   /* U+54A7 */
  0x0002,   /* U+54A8 */
  0x0002,   /* U+54A9 */
  0x0002,   /* U+54AA */
  0x0002,   /* U+54AB */
  0x0002,   /* U+54AC */
  0x0002,   /* U+54AD */
  0x0002,   /* U+54AE */
  0x0002,   /* U+54AF */
  0x0002,   /* U+54B0 */
  0x0002,   /* U+54B1 */
  0x0002,   /* U+54B2 */
  0x0002,   /* U+54B3 */
  0x0002,   /* U+54B4 */
  0x0002,   /* U+54B5 */
  0x0002,   /* U+54B6 */
  0x0002,   /* U+54B7 */
  0x0002,   /* U+54B8 */
  0x0002,   /* U+54B9 */
  0x0002,   /* U+54BA */
  0x0002,   /* U+54BB */
  0x0002,   /* U+54BC */
  0x0002,   /* U+54BD */
  0x0002,   /* U+54BE */
  0x0002,   /* U+54BF */
  0x0002,   /* U+54C0 */
  0x0002,   /* U+54C1 */
  0x0002,   /* U+54C2 */
  0x0002,   /* U+54C3 */
  0x0002,   /* U+54C4 */
  0x0002,   /* U+54C5 */
  0x0002,   /* U+54C6 */
  0x0002,   /* U+54C7 */
  0x0002,   /* U+54C8 */
  0x0002,   /* U+54C9 */
  0x0002,   /* U+54CA */
  0x0002,   /* U+54CB */
  0x0002,   /* U+54CC */
  0x0002,   /* U+54CD */
  0x0002,   /* U+54CE */
  0x0002,   /* U+54CF */
  0x0002,   /* U+54D0 */
  0x0002,   /* U+54D1 */
  0x0002,   /* U+54D2 */
  0x0002,   /* U+54D3 */
  0x0002,   /* U+54D4 */
  0x0002,   /* U+54D5 */
  0x0002,   /* U+54D6 */
  0x0002,   /* U+54D7 */
  0x0002,   /* U+54D8 */
  0x0002,   /* U+54D9 */
  0x0002,   /* U+54DA */
  0x0002,   /* U+54DB */
  0x0002,   /* U+54DC */
  0x0002,   /* U+54DD */
  0x0002,   /* U+54DE */
  0x0002,   /* U+54DF */
  0x0002,   /* U+54E0 */
  0x0002,   /* U+54E1 */
  0x0002,   /* U+54E2 */
  0x0002,   /* U+54E3 */
  0x0002,   /* U+54E4 */
  0x0002,   /* U+54E5 */
  0x0002,   /* U+54E6 */
  0x0002,   /* U+54E7 */
  0x0002,   /* U+54E8 */
  0x0002,   /* U+54E9 */
  0x0002,   /* U+54EA */
  0x0002,   /* U+54EB */
  0x0002,   /* U+54EC */
  0x0002,   /* U+54ED */
  0x0002,   /* U+54EE */
  0x0002,   /* U+54EF */
  0x0002,   /* U+54F0 */
  0x0002,   /* U+54F1 */
  0x0002,   /* U+54F2 */
  0x0002,   /* U+54F3 */
  0x0002,   /* U+54F4 */
  0x0002,   /* U+54F5 */
  0x0002,   /* U+54F6 */
  0x0002,   /* U+54F7 */
  0x0002,   /* U+54F8 */
  0x0002,   /* U+54F9 */
  0x0002,   /* U+54FA */
  0x0002,   /* U+54FB */
  0x0002,   /* U+54FC */
  0x0002,   /* U+54FD */
  0x0002,   /* U+54FE */
  0x0002,   /* U+54FF */

  /* Primary weight 2 for each character. */
  0xD400,   /* U+5400 */
  0x0000,   /* U+5401 */
  0xD402,   /* U+5402 */
  0x0000,   /* U+5403 */
  0x0000,   /* U+5404 */
  0xD405,   /* U+5405 */
  0xD406,   /* U+5406 */
  0xD407,   /* U+5407 */
  0x0000,   /* U+5408 */
  0x0000,   /* U+5409 */
  0x0000,   /* U+540A */
  0x0000,   /* U+540B */
  0x0000,   /* U+540C */
  0x0000,   /* U+540D */
  0x0000,   /* U+540E */
  0x0000,   /* U+540F */
  0x0000,   /* U+5410 */
  0x0000,   /* U+5411 */
  0xD412,   /* U+5412 */
  0xD413,   /* U+5413 */
  0xD414,   /* U+5414 */
  0xD415,   /* U+5415 */
  0xD416,   /* U+5416 */
  0xD417,   /* U+5417 */
  0xD418,   /* U+5418 */
  0xD419,   /* U+5419 */
  0xD41A,   /* U+541A */
  0x0000,   /* U+541B */
  0xD41C,   /* U+541C */
  0x0000,   /* U+541D */
  0xD41E,   /* U+541E */
  0x0000,   /* U+541F */
  0x0000,   /* U+5420 */
  0xD421,   /* U+5421 */
  0xD422,   /* U+5422 */
  0xD423,   /* U+5423 */
  0xD424,   /* U+5424 */
  0xD425,   /* U+5425 */
  0x0000,   /* U+5426 */
  0xD427,   /* U+5427 */
  0xD428,   /* U+5428 */
  0x0000,   /* U+5429 */
  0xD42A,   /* U+542A */
  0x0000,   /* U+542B */
  0x0000,   /* U+542C */
  0x0000,   /* U+542D */
  0x0000,   /* U+542E */
  0xD42F,   /* U+542F */
  0xD430,   /* U+5430 */
  0xD431,   /* U+5431 */
  0xD432,   /* U+5432 */
  0xD433,   /* U+5433 */
  0xD434,   /* U+5434 */
  0xD435,   /* U+5435 */
  0x0000,   /* U+5436 */
  0xD437,   /* U+5437 */
  0x0000,   /* U+5438 */
  0x0000,   /* U+5439 */
  0xD43A,   /* U+543A */
  0x0000,   /* U+543B */
  0x0000,   /* U+543C */
  0x0000,   /* U+543D */
  0x0000,   /* U+543E */
  0xD43F,   /* U+543F */
  0x0000,   /* U+5440 */
  0xD441,   /* U+5441 */
  0x0000,   /* U+5442 */
  0xD443,   /* U+5443 */
  0xD444,   /* U+5444 */
  0xD445,   /* U+5445 */
  0x0000,   /* U+5446 */
  0xD447,   /* U+5447 */
  0x0000,   /* U+5448 */
  0x0000,   /* U+5449 */
  0x0000,   /* U+544A */
  0xD44B,   /* U+544B */
  0xD44C,   /* U+544C */
  0xD44D,   /* U+544D */
  0x0000,   /* U+544E */
  0xD44F,   /* U+544F */
  0xD450,   /* U+5450 */
  0x0000,   /* U+5451 */
  0xD452,   /* U+5452 */
  0xD453,   /* U+5453 */
  0xD454,   /* U+5454 */
  0xD455,   /* U+5455 */
  0xD456,   /* U+5456 */
  0xD457,   /* U+5457 */
  0xD458,   /* U+5458 */
  0xD459,   /* U+5459 */
  0xD45A,   /* U+545A */
  0xD45B,   /* U+545B */
  0xD45C,   /* U+545C */
  0xD45D,   /* U+545D */
  0xD45E,   /* U+545E */
  0x0000,   /* U+545F */
  0xD460,   /* U+5460 */
  0xD461,   /* U+5461 */
  0xD462,   /* U+5462 */
  0xD463,   /* U+5463 */
  0xD464,   /* U+5464 */
  0xD465,   /* U+5465 */
  0xD466,   /* U+5466 */
  0xD467,   /* U+5467 */
  0x0000,   /* U+5468 */
  0xD469,   /* U+5469 */
  0x0000,   /* U+546A */
  0xD46B,   /* U+546B */
  0xD46C,   /* U+546C */
  0xD46D,   /* U+546D */
  0xD46E,   /* U+546E */
  0xD46F,   /* U+546F */
  0x0000,   /* U+5470 */
  0x0000,   /* U+5471 */
  0xD472,   /* U+5472 */
  0x0000,   /* U+5473 */
  0xD474,   /* U+5474 */
  0x0000,   /* U+5475 */
  0x0000,   /* U+5476 */
  0x0000,   /* U+5477 */
  0xD478,   /* U+5478 */
  0xD479,   /* U+5479 */
  0xD47A,   /* U+547A */
  0x0000,   /* U+547B */
  0x0000,   /* U+547C */
  0x0000,   /* U+547D */
  0xD47E,   /* U+547E */
  0xD47F,   /* U+547F */
  0x0000,   /* U+5480 */
  0xD481,   /* U+5481 */
  0xD482,   /* U+5482 */
  0xD483,   /* U+5483 */
  0x0000,   /* U+5484 */
  0xD485,   /* U+5485 */
  0x0000,   /* U+5486 */
  0xD487,   /* U+5487 */
  0xD488,   /* U+5488 */
  0xD489,   /* U+5489 */
  0xD48A,   /* U+548A */
  0x0000,   /* U+548B */
  0x0000,   /* U+548C */
  0xD48D,   /* U+548D */
  0x0000,   /* U+548E */
  0x0000,   /* U+548F */
  0x0000,   /* U+5490 */
  0xD491,   /* U+5491 */
  0x0000,   /* U+5492 */
  0xD493,   /* U+5493 */
  0xD494,   /* U+5494 */
  0xD495,   /* U+5495 */
  0xD496,   /* U+5496 */
  0xD497,   /* U+5497 */
  0xD498,   /* U+5498 */
  0xD499,   /* U+5499 */
  0xD49A,   /* U+549A */
  0xD49B,   /* U+549B */
  0xD49C,   /* U+549C */
  0xD49D,   /* U+549D */
  0xD49E,   /* U+549E */
  0xD49F,   /* U+549F */
  0xD4A0,   /* U+54A0 */
  0xD4A1,   /* U+54A1 */
  0x0000,   /* U+54A2 */
  0xD4A3,   /* U+54A3 */
  0x0000,   /* U+54A4 */
  0x0000,   /* U+54A5 */
  0xD4A6,   /* U+54A6 */
  0xD4A7,   /* U+54A7 */
  0x0000,   /* U+54A8 */
  0xD4A9,   /* U+54A9 */
  0xD4AA,   /* U+54AA */
  0x0000,   /* U+54AB */
  0x0000,   /* U+54AC */
  0xD4AD,   /* U+54AD */
  0xD4AE,   /* U+54AE */
  0x0000,   /* U+54AF */
  0xD4B0,   /* U+54B0 */
  0xD4B1,   /* U+54B1 */
  0x0000,   /* U+54B2 */
  0x0000,   /* U+54B3 */
  0xD4B4,   /* U+54B4 */
  0xD4B5,   /* U+54B5 */
  0xD4B6,   /* U+54B6 */
  0xD4B7,   /* U+54B7 */
  0x0000,   /* U+54B8 */
  0xD4B9,   /* U+54B9 */
  0xD4BA,   /* U+54BA */
  0xD4BB,   /* U+54BB */
  0x0000,   /* U+54BC */
  0x0000,   /* U+54BD */
  0x0000,   /* U+54BE */
  0xD4BF,   /* U+54BF */
  0x0000,   /* U+54C0 */
  0x0000,   /* U+54C1 */
  0x0000,   /* U+54C2 */
  0xD4C3,   /* U+54C3 */
  0x0000,   /* U+54C4 */
  0xD4C5,   /* U+54C5 */
  0xD4C6,   /* U+54C6 */
  0x0000,   /* U+54C7 */
  0x0000,   /* U+54C8 */
  0x0000,   /* U+54C9 */
  0xD4CA,   /* U+54CA */
  0xD4CB,   /* U+54CB */
  0xD4CC,   /* U+54CC */
  0xD4CD,   /* U+54CD */
  0xD4CE,   /* U+54CE */
  0xD4CF,   /* U+54CF */
  0xD4D0,   /* U+54D0 */
  0xD4D1,   /* U+54D1 */
  0xD4D2,   /* U+54D2 */
  0xD4D3,   /* U+54D3 */
  0xD4D4,   /* U+54D4 */
  0xD4D5,   /* U+54D5 */
  0xD4D6,   /* U+54D6 */
  0xD4D7,   /* U+54D7 */
  0x0000,   /* U+54D8 */
  0xD4D9,   /* U+54D9 */
  0xD4DA,   /* U+54DA */
  0xD4DB,   /* U+54DB */
  0xD4DC,   /* U+54DC */
  0xD4DD,   /* U+54DD */
  0xD4DE,   /* U+54DE */
  0xD4DF,   /* U+54DF */
  0xD4E0,   /* U+54E0 */
  0x0000,   /* U+54E1 */
  0x0000,   /* U+54E2 */
  0xD4E3,   /* U+54E3 */
  0xD4E4,   /* U+54E4 */
  0x0000,   /* U+54E5 */
  0x0000,   /* U+54E6 */
  0xD4E7,   /* U+54E7 */
  0x0000,   /* U+54E8 */
  0x0000,   /* U+54E9 */
  0xD4EA,   /* U+54EA */
  0xD4EB,   /* U+54EB */
  0xD4EC,   /* U+54EC */
  0x0000,   /* U+54ED */
  0x0000,   /* U+54EE */
  0xD4EF,   /* U+54EF */
  0xD4F0,   /* U+54F0 */
  0xD4F1,   /* U+54F1 */
  0x0000,   /* U+54F2 */
  0xD4F3,   /* U+54F3 */
  0xD4F4,   /* U+54F4 */
  0xD4F5,   /* U+54F5 */
  0xD4F6,   /* U+54F6 */
  0xD4F7,   /* U+54F7 */
  0xD4F8,   /* U+54F8 */
  0xD4F9,   /* U+54F9 */
  0x0000,   /* U+54FA */
  0xD4FB,   /* U+54FB */
  0xD4FC,   /* U+54FC */
  0x0000,   /* U+54FD */
  0xD4FE,   /* U+54FE */
  0xD4FF,   /* U+54FF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+5400 */
  0x0000,   /* U+5401 */
  0x0000,   /* U+5402 */
  0x0000,   /* U+5403 */
  0x0000,   /* U+5404 */
  0x0000,   /* U+5405 */
  0x0000,   /* U+5406 */
  0x0000,   /* U+5407 */
  0x0000,   /* U+5408 */
  0x0000,   /* U+5409 */
  0x0000,   /* U+540A */
  0x0000,   /* U+540B */
  0x0000,   /* U+540C */
  0x0000,   /* U+540D */
  0x0000,   /* U+540E */
  0x0000,   /* U+540F */
  0x0000,   /* U+5410 */
  0x0000,   /* U+5411 */
  0x0000,   /* U+5412 */
  0x0000,   /* U+5413 */
  0x0000,   /* U+5414 */
  0x0000,   /* U+5415 */
  0x0000,   /* U+5416 */
  0x0000,   /* U+5417 */
  0x0000,   /* U+5418 */
  0x0000,   /* U+5419 */
  0x0000,   /* U+541A */
  0x0000,   /* U+541B */
  0x0000,   /* U+541C */
  0x0000,   /* U+541D */
  0x0000,   /* U+541E */
  0x0000,   /* U+541F */
  0x0000,   /* U+5420 */
  0x0000,   /* U+5421 */
  0x0000,   /* U+5422 */
  0x0000,   /* U+5423 */
  0x0000,   /* U+5424 */
  0x0000,   /* U+5425 */
  0x0000,   /* U+5426 */
  0x0000,   /* U+5427 */
  0x0000,   /* U+5428 */
  0x0000,   /* U+5429 */
  0x0000,   /* U+542A */
  0x0000,   /* U+542B */
  0x0000,   /* U+542C */
  0x0000,   /* U+542D */
  0x0000,   /* U+542E */
  0x0000,   /* U+542F */
  0x0000,   /* U+5430 */
  0x0000,   /* U+5431 */
  0x0000,   /* U+5432 */
  0x0000,   /* U+5433 */
  0x0000,   /* U+5434 */
  0x0000,   /* U+5435 */
  0x0000,   /* U+5436 */
  0x0000,   /* U+5437 */
  0x0000,   /* U+5438 */
  0x0000,   /* U+5439 */
  0x0000,   /* U+543A */
  0x0000,   /* U+543B */
  0x0000,   /* U+543C */
  0x0000,   /* U+543D */
  0x0000,   /* U+543E */
  0x0000,   /* U+543F */
  0x0000,   /* U+5440 */
  0x0000,   /* U+5441 */
  0x0000,   /* U+5442 */
  0x0000,   /* U+5443 */
  0x0000,   /* U+5444 */
  0x0000,   /* U+5445 */
  0x0000,   /* U+5446 */
  0x0000,   /* U+5447 */
  0x0000,   /* U+5448 */
  0x0000,   /* U+5449 */
  0x0000,   /* U+544A */
  0x0000,   /* U+544B */
  0x0000,   /* U+544C */
  0x0000,   /* U+544D */
  0x0000,   /* U+544E */
  0x0000,   /* U+544F */
  0x0000,   /* U+5450 */
  0x0000,   /* U+5451 */
  0x0000,   /* U+5452 */
  0x0000,   /* U+5453 */
  0x0000,   /* U+5454 */
  0x0000,   /* U+5455 */
  0x0000,   /* U+5456 */
  0x0000,   /* U+5457 */
  0x0000,   /* U+5458 */
  0x0000,   /* U+5459 */
  0x0000,   /* U+545A */
  0x0000,   /* U+545B */
  0x0000,   /* U+545C */
  0x0000,   /* U+545D */
  0x0000,   /* U+545E */
  0x0000,   /* U+545F */
  0x0000,   /* U+5460 */
  0x0000,   /* U+5461 */
  0x0000,   /* U+5462 */
  0x0000,   /* U+5463 */
  0x0000,   /* U+5464 */
  0x0000,   /* U+5465 */
  0x0000,   /* U+5466 */
  0x0000,   /* U+5467 */
  0x0000,   /* U+5468 */
  0x0000,   /* U+5469 */
  0x0000,   /* U+546A */
  0x0000,   /* U+546B */
  0x0000,   /* U+546C */
  0x0000,   /* U+546D */
  0x0000,   /* U+546E */
  0x0000,   /* U+546F */
  0x0000,   /* U+5470 */
  0x0000,   /* U+5471 */
  0x0000,   /* U+5472 */
  0x0000,   /* U+5473 */
  0x0000,   /* U+5474 */
  0x0000,   /* U+5475 */
  0x0000,   /* U+5476 */
  0x0000,   /* U+5477 */
  0x0000,   /* U+5478 */
  0x0000,   /* U+5479 */
  0x0000,   /* U+547A */
  0x0000,   /* U+547B */
  0x0000,   /* U+547C */
  0x0000,   /* U+547D */
  0x0000,   /* U+547E */
  0x0000,   /* U+547F */
  0x0000,   /* U+5480 */
  0x0000,   /* U+5481 */
  0x0000,   /* U+5482 */
  0x0000,   /* U+5483 */
  0x0000,   /* U+5484 */
  0x0000,   /* U+5485 */
  0x0000,   /* U+5486 */
  0x0000,   /* U+5487 */
  0x0000,   /* U+5488 */
  0x0000,   /* U+5489 */
  0x0000,   /* U+548A */
  0x0000,   /* U+548B */
  0x0000,   /* U+548C */
  0x0000,   /* U+548D */
  0x0000,   /* U+548E */
  0x0000,   /* U+548F */
  0x0000,   /* U+5490 */
  0x0000,   /* U+5491 */
  0x0000,   /* U+5492 */
  0x0000,   /* U+5493 */
  0x0000,   /* U+5494 */
  0x0000,   /* U+5495 */
  0x0000,   /* U+5496 */
  0x0000,   /* U+5497 */
  0x0000,   /* U+5498 */
  0x0000,   /* U+5499 */
  0x0000,   /* U+549A */
  0x0000,   /* U+549B */
  0x0000,   /* U+549C */
  0x0000,   /* U+549D */
  0x0000,   /* U+549E */
  0x0000,   /* U+549F */
  0x0000,   /* U+54A0 */
  0x0000,   /* U+54A1 */
  0x0000,   /* U+54A2 */
  0x0000,   /* U+54A3 */
  0x0000,   /* U+54A4 */
  0x0000,   /* U+54A5 */
  0x0000,   /* U+54A6 */
  0x0000,   /* U+54A7 */
  0x0000,   /* U+54A8 */
  0x0000,   /* U+54A9 */
  0x0000,   /* U+54AA */
  0x0000,   /* U+54AB */
  0x0000,   /* U+54AC */
  0x0000,   /* U+54AD */
  0x0000,   /* U+54AE */
  0x0000,   /* U+54AF */
  0x0000,   /* U+54B0 */
  0x0000,   /* U+54B1 */
  0x0000,   /* U+54B2 */
  0x0000,   /* U+54B3 */
  0x0000,   /* U+54B4 */
  0x0000,   /* U+54B5 */
  0x0000,   /* U+54B6 */
  0x0000,   /* U+54B7 */
  0x0000,   /* U+54B8 */
  0x0000,   /* U+54B9 */
  0x0000,   /* U+54BA */
  0x0000,   /* U+54BB */
  0x0000,   /* U+54BC */
  0x0000,   /* U+54BD */
  0x0000,   /* U+54BE */
  0x0000,   /* U+54BF */
  0x0000,   /* U+54C0 */
  0x0000,   /* U+54C1 */
  0x0000,   /* U+54C2 */
  0x0000,   /* U+54C3 */
  0x0000,   /* U+54C4 */
  0x0000,   /* U+54C5 */
  0x0000,   /* U+54C6 */
  0x0000,   /* U+54C7 */
  0x0000,   /* U+54C8 */
  0x0000,   /* U+54C9 */
  0x0000,   /* U+54CA */
  0x0000,   /* U+54CB */
  0x0000,   /* U+54CC */
  0x0000,   /* U+54CD */
  0x0000,   /* U+54CE */
  0x0000,   /* U+54CF */
  0x0000,   /* U+54D0 */
  0x0000,   /* U+54D1 */
  0x0000,   /* U+54D2 */
  0x0000,   /* U+54D3 */
  0x0000,   /* U+54D4 */
  0x0000,   /* U+54D5 */
  0x0000,   /* U+54D6 */
  0x0000,   /* U+54D7 */
  0x0000,   /* U+54D8 */
  0x0000,   /* U+54D9 */
  0x0000,   /* U+54DA */
  0x0000,   /* U+54DB */
  0x0000,   /* U+54DC */
  0x0000,   /* U+54DD */
  0x0000,   /* U+54DE */
  0x0000,   /* U+54DF */
  0x0000,   /* U+54E0 */
  0x0000,   /* U+54E1 */
  0x0000,   /* U+54E2 */
  0x0000,   /* U+54E3 */
  0x0000,   /* U+54E4 */
  0x0000,   /* U+54E5 */
  0x0000,   /* U+54E6 */
  0x0000,   /* U+54E7 */
  0x0000,   /* U+54E8 */
  0x0000,   /* U+54E9 */
  0x0000,   /* U+54EA */
  0x0000,   /* U+54EB */
  0x0000,   /* U+54EC */
  0x0000,   /* U+54ED */
  0x0000,   /* U+54EE */
  0x0000,   /* U+54EF */
  0x0000,   /* U+54F0 */
  0x0000,   /* U+54F1 */
  0x0000,   /* U+54F2 */
  0x0000,   /* U+54F3 */
  0x0000,   /* U+54F4 */
  0x0000,   /* U+54F5 */
  0x0000,   /* U+54F6 */
  0x0000,   /* U+54F7 */
  0x0000,   /* U+54F8 */
  0x0000,   /* U+54F9 */
  0x0000,   /* U+54FA */
  0x0000,   /* U+54FB */
  0x0000,   /* U+54FC */
  0x0000,   /* U+54FD */
  0x0000,   /* U+54FE */
  0x0000,   /* U+54FF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+5400 */
  0x0000,   /* U+5401 */
  0x0000,   /* U+5402 */
  0x0000,   /* U+5403 */
  0x0000,   /* U+5404 */
  0x0000,   /* U+5405 */
  0x0000,   /* U+5406 */
  0x0000,   /* U+5407 */
  0x0000,   /* U+5408 */
  0x0000,   /* U+5409 */
  0x0000,   /* U+540A */
  0x0000,   /* U+540B */
  0x0000,   /* U+540C */
  0x0000,   /* U+540D */
  0x0000,   /* U+540E */
  0x0000,   /* U+540F */
  0x0000,   /* U+5410 */
  0x0000,   /* U+5411 */
  0x0000,   /* U+5412 */
  0x0000,   /* U+5413 */
  0x0000,   /* U+5414 */
  0x0000,   /* U+5415 */
  0x0000,   /* U+5416 */
  0x0000,   /* U+5417 */
  0x0000,   /* U+5418 */
  0x0000,   /* U+5419 */
  0x0000,   /* U+541A */
  0x0000,   /* U+541B */
  0x0000,   /* U+541C */
  0x0000,   /* U+541D */
  0x0000,   /* U+541E */
  0x0000,   /* U+541F */
  0x0000,   /* U+5420 */
  0x0000,   /* U+5421 */
  0x0000,   /* U+5422 */
  0x0000,   /* U+5423 */
  0x0000,   /* U+5424 */
  0x0000,   /* U+5425 */
  0x0000,   /* U+5426 */
  0x0000,   /* U+5427 */
  0x0000,   /* U+5428 */
  0x0000,   /* U+5429 */
  0x0000,   /* U+542A */
  0x0000,   /* U+542B */
  0x0000,   /* U+542C */
  0x0000,   /* U+542D */
  0x0000,   /* U+542E */
  0x0000,   /* U+542F */
  0x0000,   /* U+5430 */
  0x0000,   /* U+5431 */
  0x0000,   /* U+5432 */
  0x0000,   /* U+5433 */
  0x0000,   /* U+5434 */
  0x0000,   /* U+5435 */
  0x0000,   /* U+5436 */
  0x0000,   /* U+5437 */
  0x0000,   /* U+5438 */
  0x0000,   /* U+5439 */
  0x0000,   /* U+543A */
  0x0000,   /* U+543B */
  0x0000,   /* U+543C */
  0x0000,   /* U+543D */
  0x0000,   /* U+543E */
  0x0000,   /* U+543F */
  0x0000,   /* U+5440 */
  0x0000,   /* U+5441 */
  0x0000,   /* U+5442 */
  0x0000,   /* U+5443 */
  0x0000,   /* U+5444 */
  0x0000,   /* U+5445 */
  0x0000,   /* U+5446 */
  0x0000,   /* U+5447 */
  0x0000,   /* U+5448 */
  0x0000,   /* U+5449 */
  0x0000,   /* U+544A */
  0x0000,   /* U+544B */
  0x0000,   /* U+544C */
  0x0000,   /* U+544D */
  0x0000,   /* U+544E */
  0x0000,   /* U+544F */
  0x0000,   /* U+5450 */
  0x0000,   /* U+5451 */
  0x0000,   /* U+5452 */
  0x0000,   /* U+5453 */
  0x0000,   /* U+5454 */
  0x0000,   /* U+5455 */
  0x0000,   /* U+5456 */
  0x0000,   /* U+5457 */
  0x0000,   /* U+5458 */
  0x0000,   /* U+5459 */
  0x0000,   /* U+545A */
  0x0000,   /* U+545B */
  0x0000,   /* U+545C */
  0x0000,   /* U+545D */
  0x0000,   /* U+545E */
  0x0000,   /* U+545F */
  0x0000,   /* U+5460 */
  0x0000,   /* U+5461 */
  0x0000,   /* U+5462 */
  0x0000,   /* U+5463 */
  0x0000,   /* U+5464 */
  0x0000,   /* U+5465 */
  0x0000,   /* U+5466 */
  0x0000,   /* U+5467 */
  0x0000,   /* U+5468 */
  0x0000,   /* U+5469 */
  0x0000,   /* U+546A */
  0x0000,   /* U+546B */
  0x0000,   /* U+546C */
  0x0000,   /* U+546D */
  0x0000,   /* U+546E */
  0x0000,   /* U+546F */
  0x0000,   /* U+5470 */
  0x0000,   /* U+5471 */
  0x0000,   /* U+5472 */
  0x0000,   /* U+5473 */
  0x0000,   /* U+5474 */
  0x0000,   /* U+5475 */
  0x0000,   /* U+5476 */
  0x0000,   /* U+5477 */
  0x0000,   /* U+5478 */
  0x0000,   /* U+5479 */
  0x0000,   /* U+547A */
  0x0000,   /* U+547B */
  0x0000,   /* U+547C */
  0x0000,   /* U+547D */
  0x0000,   /* U+547E */
  0x0000,   /* U+547F */
  0x0000,   /* U+5480 */
  0x0000,   /* U+5481 */
  0x0000,   /* U+5482 */
  0x0000,   /* U+5483 */
  0x0000,   /* U+5484 */
  0x0000,   /* U+5485 */
  0x0000,   /* U+5486 */
  0x0000,   /* U+5487 */
  0x0000,   /* U+5488 */
  0x0000,   /* U+5489 */
  0x0000,   /* U+548A */
  0x0000,   /* U+548B */
  0x0000,   /* U+548C */
  0x0000,   /* U+548D */
  0x0000,   /* U+548E */
  0x0000,   /* U+548F */
  0x0000,   /* U+5490 */
  0x0000,   /* U+5491 */
  0x0000,   /* U+5492 */
  0x0000,   /* U+5493 */
  0x0000,   /* U+5494 */
  0x0000,   /* U+5495 */
  0x0000,   /* U+5496 */
  0x0000,   /* U+5497 */
  0x0000,   /* U+5498 */
  0x0000,   /* U+5499 */
  0x0000,   /* U+549A */
  0x0000,   /* U+549B */
  0x0000,   /* U+549C */
  0x0000,   /* U+549D */
  0x0000,   /* U+549E */
  0x0000,   /* U+549F */
  0x0000,   /* U+54A0 */
  0x0000,   /* U+54A1 */
  0x0000,   /* U+54A2 */
  0x0000,   /* U+54A3 */
  0x0000,   /* U+54A4 */
  0x0000,   /* U+54A5 */
  0x0000,   /* U+54A6 */
  0x0000,   /* U+54A7 */
  0x0000,   /* U+54A8 */
  0x0000,   /* U+54A9 */
  0x0000,   /* U+54AA */
  0x0000,   /* U+54AB */
  0x0000,   /* U+54AC */
  0x0000,   /* U+54AD */
  0x0000,   /* U+54AE */
  0x0000,   /* U+54AF */
  0x0000,   /* U+54B0 */
  0x0000,   /* U+54B1 */
  0x0000,   /* U+54B2 */
  0x0000,   /* U+54B3 */
  0x0000,   /* U+54B4 */
  0x0000,   /* U+54B5 */
  0x0000,   /* U+54B6 */
  0x0000,   /* U+54B7 */
  0x0000,   /* U+54B8 */
  0x0000,   /* U+54B9 */
  0x0000,   /* U+54BA */
  0x0000,   /* U+54BB */
  0x0000,   /* U+54BC */
  0x0000,   /* U+54BD */
  0x0000,   /* U+54BE */
  0x0000,   /* U+54BF */
  0x0000,   /* U+54C0 */
  0x0000,   /* U+54C1 */
  0x0000,   /* U+54C2 */
  0x0000,   /* U+54C3 */
  0x0000,   /* U+54C4 */
  0x0000,   /* U+54C5 */
  0x0000,   /* U+54C6 */
  0x0000,   /* U+54C7 */
  0x0000,   /* U+54C8 */
  0x0000,   /* U+54C9 */
  0x0000,   /* U+54CA */
  0x0000,   /* U+54CB */
  0x0000,   /* U+54CC */
  0x0000,   /* U+54CD */
  0x0000,   /* U+54CE */
  0x0000,   /* U+54CF */
  0x0000,   /* U+54D0 */
  0x0000,   /* U+54D1 */
  0x0000,   /* U+54D2 */
  0x0000,   /* U+54D3 */
  0x0000,   /* U+54D4 */
  0x0000,   /* U+54D5 */
  0x0000,   /* U+54D6 */
  0x0000,   /* U+54D7 */
  0x0000,   /* U+54D8 */
  0x0000,   /* U+54D9 */
  0x0000,   /* U+54DA */
  0x0000,   /* U+54DB */
  0x0000,   /* U+54DC */
  0x0000,   /* U+54DD */
  0x0000,   /* U+54DE */
  0x0000,   /* U+54DF */
  0x0000,   /* U+54E0 */
  0x0000,   /* U+54E1 */
  0x0000,   /* U+54E2 */
  0x0000,   /* U+54E3 */
  0x0000,   /* U+54E4 */
  0x0000,   /* U+54E5 */
  0x0000,   /* U+54E6 */
  0x0000,   /* U+54E7 */
  0x0000,   /* U+54E8 */
  0x0000,   /* U+54E9 */
  0x0000,   /* U+54EA */
  0x0000,   /* U+54EB */
  0x0000,   /* U+54EC */
  0x0000,   /* U+54ED */
  0x0000,   /* U+54EE */
  0x0000,   /* U+54EF */
  0x0000,   /* U+54F0 */
  0x0000,   /* U+54F1 */
  0x0000,   /* U+54F2 */
  0x0000,   /* U+54F3 */
  0x0000,   /* U+54F4 */
  0x0000,   /* U+54F5 */
  0x0000,   /* U+54F6 */
  0x0000,   /* U+54F7 */
  0x0000,   /* U+54F8 */
  0x0000,   /* U+54F9 */
  0x0000,   /* U+54FA */
  0x0000,   /* U+54FB */
  0x0000,   /* U+54FC */
  0x0000,   /* U+54FD */
  0x0000,   /* U+54FE */
  0x0000,   /* U+54FF */
};

uint16 ja_han_page55[]= {
  /* Number of CEs for each character. */
  2, 2, 2, 2, 1, 2, 1, 1, 2, 2, 2, 2, 2, 2, 2, 1,
  1, 2, 2, 2, 1, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1,
  2, 1, 2, 1, 2, 2, 2, 2, 1, 1, 2, 2, 2, 2, 1, 2,
  1, 2, 2, 2, 1, 1, 1, 2, 2, 2, 2, 2, 1, 2, 2, 1,
  2, 2, 2, 1, 2, 2, 1, 1, 2, 2, 2, 2, 1, 1, 2, 2,
  2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 2, 1, 2,
  1, 2, 2, 1, 1, 2, 2, 1, 2, 1, 1, 1, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 2, 1, 1, 1, 1,
  2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 2, 1, 2,
  1, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 1, 1, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 1, 2, 1, 2, 2, 1,
  2, 2, 2, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 1, 2, 1, 2, 2, 2, 1, 1, 2,

  /* Primary weight 1 for each character. */
  0xFB40,   /* U+5500 */
  0xFB40,   /* U+5501 */
  0xFB40,   /* U+5502 */
  0xFB40,   /* U+5503 */
  0x5515,   /* U+5504 */
  0xFB40,   /* U+5505 */
  0x5865,   /* U+5506 */
  0x5A35,   /* U+5507 */
  0xFB40,   /* U+5508 */
  0xFB40,   /* U+5509 */
  0xFB40,   /* U+550A */
  0xFB40,   /* U+550B */
  0xFB40,   /* U+550C */
  0xFB40,   /* U+550D */
  0xFB40,   /* U+550E */
  0x615B,   /* U+550F */
  0x5C9B,   /* U+5510 */
  0xFB40,   /* U+5511 */
  0xFB40,   /* U+5512 */
  0xFB40,   /* U+5513 */
  0x615C,   /* U+5514 */
  0xFB40,   /* U+5515 */
  0x54A5,   /* U+5516 */
  0xFB40,   /* U+5517 */
  0xFB40,   /* U+5518 */
  0xFB40,   /* U+5519 */
  0xFB40,   /* U+551A */
  0xFB40,   /* U+551B */
  0xFB40,   /* U+551C */
  0xFB40,   /* U+551D */
  0xFB40,   /* U+551E */
  0xFB40,   /* U+551F */
  0xFB40,   /* U+5520 */
  0xFB40,   /* U+5521 */
  0xFB40,   /* U+5522 */
  0xFB40,   /* U+5523 */
  0xFB40,   /* U+5524 */
  0xFB40,   /* U+5525 */
  0xFB40,   /* U+5526 */
  0xFB40,   /* U+5527 */
  0xFB40,   /* U+5528 */
  0xFB40,   /* U+5529 */
  0xFB40,   /* U+552A */
  0xFB40,   /* U+552B */
  0xFB40,   /* U+552C */
  0xFB40,   /* U+552D */
  0x6166,   /* U+552E */
  0x5F4C,   /* U+552F */
  0xFB40,   /* U+5530 */
  0x59CE,   /* U+5531 */
  0xFB40,   /* U+5532 */
  0x616C,   /* U+5533 */
  0xFB40,   /* U+5534 */
  0xFB40,   /* U+5535 */
  0xFB40,   /* U+5536 */
  0xFB40,   /* U+5537 */
  0x616B,   /* U+5538 */
  0x6162,   /* U+5539 */
  0xFB40,   /* U+553A */
  0xFB40,   /* U+553B */
  0xFB40,   /* U+553C */
  0xFB40,   /* U+553D */
  0x5B62,   /* U+553E */
  0xFB40,   /* U+553F */
  0x6163,   /* U+5540 */
  0xFB40,   /* U+5541 */
  0xFB40,   /* U+5542 */
  0xFB40,   /* U+5543 */
  0x5B8E,   /* U+5544 */
  0x6168,   /* U+5545 */
  0x59CD,   /* U+5546 */
  0xFB40,   /* U+5547 */
  0xFB40,   /* U+5548 */
  0xFB40,   /* U+5549 */
  0xFB40,   /* U+554A */
  0xFB40,   /* U+554B */
  0x6165,   /* U+554C */
  0xFB40,   /* U+554D */
  0xFB40,   /* U+554E */
  0x5F2F,   /* U+554F */
  0xFB40,   /* U+5550 */
  0xFB40,   /* U+5551 */
  0xFB40,   /* U+5552 */
  0x5751,   /* U+5553 */
  0xFB40,   /* U+5554 */
  0xFB40,   /* U+5555 */
  0x6169,   /* U+5556 */
  0x616A,   /* U+5557 */
  0xFB40,   /* U+5558 */
  0xFB40,   /* U+5559 */
  0xFB40,   /* U+555A */
  0xFB40,   /* U+555B */
  0x6167,   /* U+555C */
  0x616D,   /* U+555D */
  0xFB40,   /* U+555E */
  0xFB40,   /* U+555F */
  0xFB40,   /* U+5560 */
  0xFB40,   /* U+5561 */
  0xFB40,   /* U+5562 */
  0x6164,   /* U+5563 */
  0xFB40,   /* U+5564 */
  0xFB40,   /* U+5565 */
  0xFB40,   /* U+5566 */
  0xFB40,   /* U+5567 */
  0xFB40,   /* U+5568 */
  0xFB40,   /* U+5569 */
  0xFB40,   /* U+556A */
  0xFB40,   /* U+556B */
  0xFB40,   /* U+556C */
  0xFB40,   /* U+556D */
  0xFB40,   /* U+556E */
  0xFB40,   /* U+556F */
  0xFB40,   /* U+5570 */
  0xFB40,   /* U+5571 */
  0xFB40,   /* U+5572 */
  0xFB40,   /* U+5573 */
  0xFB40,   /* U+5574 */
  0xFB40,   /* U+5575 */
  0xFB40,   /* U+5576 */
  0xFB40,   /* U+5577 */
  0xFB40,   /* U+5578 */
  0xFB40,   /* U+5579 */
  0xFB40,   /* U+557A */
  0x6173,   /* U+557B */
  0x6178,   /* U+557C */
  0xFB40,   /* U+557D */
  0x6174,   /* U+557E */
  0xFB40,   /* U+557F */
  0x616F,   /* U+5580 */
  0xFB40,   /* U+5581 */
  0xFB40,   /* U+5582 */
  0x6179,   /* U+5583 */
  0x5AF2,   /* U+5584 */
  0xFB40,   /* U+5585 */
  0xFB40,   /* U+5586 */
  0x617B,   /* U+5587 */
  0xFB40,   /* U+5588 */
  0x57F3,   /* U+5589 */
  0x6171,   /* U+558A */
  0x5BFA,   /* U+558B */
  0xFB40,   /* U+558C */
  0xFB40,   /* U+558D */
  0xFB40,   /* U+558E */
  0xFB40,   /* U+558F */
  0xFB40,   /* U+5590 */
  0xFB40,   /* U+5591 */
  0xFB40,   /* U+5592 */
  0xFB40,   /* U+5593 */
  0xFB40,   /* U+5594 */
  0xFB40,   /* U+5595 */
  0xFB40,   /* U+5596 */
  0xFB40,   /* U+5597 */
  0x6175,   /* U+5598 */
  0x616E,   /* U+5599 */
  0x5628,   /* U+559A */
  0xFB40,   /* U+559B */
  0x5669,   /* U+559C */
  0x5602,   /* U+559D */
  0x6176,   /* U+559E */
  0x6172,   /* U+559F */
  0xFB40,   /* U+55A0 */
  0xFB40,   /* U+55A1 */
  0xFB40,   /* U+55A2 */
  0xFB40,   /* U+55A3 */
  0xFB40,   /* U+55A4 */
  0xFB40,   /* U+55A5 */
  0xFB40,   /* U+55A6 */
  0x578B,   /* U+55A7 */
  0x617C,   /* U+55A8 */
  0x617A,   /* U+55A9 */
  0x5B14,   /* U+55AA */
  0x56A3,   /* U+55AB */
  0x56E3,   /* U+55AC */
  0xFB40,   /* U+55AD */
  0x6177,   /* U+55AE */
  0xFB40,   /* U+55AF */
  0x572B,   /* U+55B0 */
  0xFB40,   /* U+55B1 */
  0xFB40,   /* U+55B2 */
  0xFB40,   /* U+55B3 */
  0xFB40,   /* U+55B4 */
  0xFB40,   /* U+55B5 */
  0x5525,   /* U+55B6 */
  0xFB40,   /* U+55B7 */
  0xFB40,   /* U+55B8 */
  0xFB40,   /* U+55B9 */
  0xFB40,   /* U+55BA */
  0xFB40,   /* U+55BB */
  0xFB40,   /* U+55BC */
  0xFB40,   /* U+55BD */
  0xFB40,   /* U+55BE */
  0xFB40,   /* U+55BF */
  0xFB40,   /* U+55C0 */
  0xFB40,   /* U+55C1 */
  0xFB40,   /* U+55C2 */
  0xFB40,   /* U+55C3 */
  0x6180,   /* U+55C4 */
  0x617E,   /* U+55C5 */
  0xFB40,   /* U+55C6 */
  0x61B7,   /* U+55C7 */
  0xFB40,   /* U+55C8 */
  0xFB40,   /* U+55C9 */
  0xFB40,   /* U+55CA */
  0xFB40,   /* U+55CB */
  0xFB40,   /* U+55CC */
  0xFB40,   /* U+55CD */
  0xFB40,   /* U+55CE */
  0xFB40,   /* U+55CF */
  0xFB40,   /* U+55D0 */
  0xFB40,   /* U+55D1 */
  0xFB40,   /* U+55D2 */
  0xFB40,   /* U+55D3 */
  0x6183,   /* U+55D4 */
  0xFB40,   /* U+55D5 */
  0xFB40,   /* U+55D6 */
  0xFB40,   /* U+55D7 */
  0xFB40,   /* U+55D8 */
  0xFB40,   /* U+55D9 */
  0x617D,   /* U+55DA */
  0xFB40,   /* U+55DB */
  0x6181,   /* U+55DC */
  0xFB40,   /* U+55DD */
  0xFB40,   /* U+55DE */
  0x617F,   /* U+55DF */
  0xFB40,   /* U+55E0 */
  0xFB40,   /* U+55E1 */
  0xFB40,   /* U+55E2 */
  0x58D9,   /* U+55E3 */
  0x6182,   /* U+55E4 */
  0xFB40,   /* U+55E5 */
  0xFB40,   /* U+55E6 */
  0xFB40,   /* U+55E7 */
  0xFB40,   /* U+55E8 */
  0xFB40,   /* U+55E9 */
  0xFB40,   /* U+55EA */
  0xFB40,   /* U+55EB */
  0xFB40,   /* U+55EC */
  0xFB40,   /* U+55ED */
  0xFB40,   /* U+55EE */
  0xFB40,   /* U+55EF */
  0xFB40,   /* U+55F0 */
  0xFB40,   /* U+55F1 */
  0xFB40,   /* U+55F2 */
  0xFB40,   /* U+55F3 */
  0xFB40,   /* U+55F4 */
  0xFB40,   /* U+55F5 */
  0xFB40,   /* U+55F6 */
  0x6185,   /* U+55F7 */
  0xFB40,   /* U+55F8 */
  0x618A,   /* U+55F9 */
  0xFB40,   /* U+55FA */
  0xFB40,   /* U+55FB */
  0xFB40,   /* U+55FC */
  0x6188,   /* U+55FD */
  0x6187,   /* U+55FE */
  0xFB40,   /* U+55FF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+5500 */
  0x0020,   /* U+5501 */
  0x0020,   /* U+5502 */
  0x0020,   /* U+5503 */
  0x0020,   /* U+5504 */
  0x0020,   /* U+5505 */
  0x0020,   /* U+5506 */
  0x0020,   /* U+5507 */
  0x0020,   /* U+5508 */
  0x0020,   /* U+5509 */
  0x0020,   /* U+550A */
  0x0020,   /* U+550B */
  0x0020,   /* U+550C */
  0x0020,   /* U+550D */
  0x0020,   /* U+550E */
  0x0020,   /* U+550F */
  0x0020,   /* U+5510 */
  0x0020,   /* U+5511 */
  0x0020,   /* U+5512 */
  0x0020,   /* U+5513 */
  0x0020,   /* U+5514 */
  0x0020,   /* U+5515 */
  0x0020,   /* U+5516 */
  0x0020,   /* U+5517 */
  0x0020,   /* U+5518 */
  0x0020,   /* U+5519 */
  0x0020,   /* U+551A */
  0x0020,   /* U+551B */
  0x0020,   /* U+551C */
  0x0020,   /* U+551D */
  0x0020,   /* U+551E */
  0x0020,   /* U+551F */
  0x0020,   /* U+5520 */
  0x0020,   /* U+5521 */
  0x0020,   /* U+5522 */
  0x0020,   /* U+5523 */
  0x0020,   /* U+5524 */
  0x0020,   /* U+5525 */
  0x0020,   /* U+5526 */
  0x0020,   /* U+5527 */
  0x0020,   /* U+5528 */
  0x0020,   /* U+5529 */
  0x0020,   /* U+552A */
  0x0020,   /* U+552B */
  0x0020,   /* U+552C */
  0x0020,   /* U+552D */
  0x0020,   /* U+552E */
  0x0020,   /* U+552F */
  0x0020,   /* U+5530 */
  0x0020,   /* U+5531 */
  0x0020,   /* U+5532 */
  0x0020,   /* U+5533 */
  0x0020,   /* U+5534 */
  0x0020,   /* U+5535 */
  0x0020,   /* U+5536 */
  0x0020,   /* U+5537 */
  0x0020,   /* U+5538 */
  0x0020,   /* U+5539 */
  0x0020,   /* U+553A */
  0x0020,   /* U+553B */
  0x0020,   /* U+553C */
  0x0020,   /* U+553D */
  0x0020,   /* U+553E */
  0x0020,   /* U+553F */
  0x0020,   /* U+5540 */
  0x0020,   /* U+5541 */
  0x0020,   /* U+5542 */
  0x0020,   /* U+5543 */
  0x0020,   /* U+5544 */
  0x0020,   /* U+5545 */
  0x0020,   /* U+5546 */
  0x0020,   /* U+5547 */
  0x0020,   /* U+5548 */
  0x0020,   /* U+5549 */
  0x0020,   /* U+554A */
  0x0020,   /* U+554B */
  0x0020,   /* U+554C */
  0x0020,   /* U+554D */
  0x0020,   /* U+554E */
  0x0020,   /* U+554F */
  0x0020,   /* U+5550 */
  0x0020,   /* U+5551 */
  0x0020,   /* U+5552 */
  0x0020,   /* U+5553 */
  0x0020,   /* U+5554 */
  0x0020,   /* U+5555 */
  0x0020,   /* U+5556 */
  0x0020,   /* U+5557 */
  0x0020,   /* U+5558 */
  0x0020,   /* U+5559 */
  0x0020,   /* U+555A */
  0x0020,   /* U+555B */
  0x0020,   /* U+555C */
  0x0020,   /* U+555D */
  0x0020,   /* U+555E */
  0x0020,   /* U+555F */
  0x0020,   /* U+5560 */
  0x0020,   /* U+5561 */
  0x0020,   /* U+5562 */
  0x0020,   /* U+5563 */
  0x0020,   /* U+5564 */
  0x0020,   /* U+5565 */
  0x0020,   /* U+5566 */
  0x0020,   /* U+5567 */
  0x0020,   /* U+5568 */
  0x0020,   /* U+5569 */
  0x0020,   /* U+556A */
  0x0020,   /* U+556B */
  0x0020,   /* U+556C */
  0x0020,   /* U+556D */
  0x0020,   /* U+556E */
  0x0020,   /* U+556F */
  0x0020,   /* U+5570 */
  0x0020,   /* U+5571 */
  0x0020,   /* U+5572 */
  0x0020,   /* U+5573 */
  0x0020,   /* U+5574 */
  0x0020,   /* U+5575 */
  0x0020,   /* U+5576 */
  0x0020,   /* U+5577 */
  0x0020,   /* U+5578 */
  0x0020,   /* U+5579 */
  0x0020,   /* U+557A */
  0x0020,   /* U+557B */
  0x0020,   /* U+557C */
  0x0020,   /* U+557D */
  0x0020,   /* U+557E */
  0x0020,   /* U+557F */
  0x0020,   /* U+5580 */
  0x0020,   /* U+5581 */
  0x0020,   /* U+5582 */
  0x0020,   /* U+5583 */
  0x0020,   /* U+5584 */
  0x0020,   /* U+5585 */
  0x0020,   /* U+5586 */
  0x0020,   /* U+5587 */
  0x0020,   /* U+5588 */
  0x0020,   /* U+5589 */
  0x0020,   /* U+558A */
  0x0020,   /* U+558B */
  0x0020,   /* U+558C */
  0x0020,   /* U+558D */
  0x0020,   /* U+558E */
  0x0020,   /* U+558F */
  0x0020,   /* U+5590 */
  0x0020,   /* U+5591 */
  0x0020,   /* U+5592 */
  0x0020,   /* U+5593 */
  0x0020,   /* U+5594 */
  0x0020,   /* U+5595 */
  0x0020,   /* U+5596 */
  0x0020,   /* U+5597 */
  0x0020,   /* U+5598 */
  0x0020,   /* U+5599 */
  0x0020,   /* U+559A */
  0x0020,   /* U+559B */
  0x0020,   /* U+559C */
  0x0020,   /* U+559D */
  0x0020,   /* U+559E */
  0x0020,   /* U+559F */
  0x0020,   /* U+55A0 */
  0x0020,   /* U+55A1 */
  0x0020,   /* U+55A2 */
  0x0020,   /* U+55A3 */
  0x0020,   /* U+55A4 */
  0x0020,   /* U+55A5 */
  0x0020,   /* U+55A6 */
  0x0020,   /* U+55A7 */
  0x0020,   /* U+55A8 */
  0x0020,   /* U+55A9 */
  0x0020,   /* U+55AA */
  0x0020,   /* U+55AB */
  0x0020,   /* U+55AC */
  0x0020,   /* U+55AD */
  0x0020,   /* U+55AE */
  0x0020,   /* U+55AF */
  0x0020,   /* U+55B0 */
  0x0020,   /* U+55B1 */
  0x0020,   /* U+55B2 */
  0x0020,   /* U+55B3 */
  0x0020,   /* U+55B4 */
  0x0020,   /* U+55B5 */
  0x0020,   /* U+55B6 */
  0x0020,   /* U+55B7 */
  0x0020,   /* U+55B8 */
  0x0020,   /* U+55B9 */
  0x0020,   /* U+55BA */
  0x0020,   /* U+55BB */
  0x0020,   /* U+55BC */
  0x0020,   /* U+55BD */
  0x0020,   /* U+55BE */
  0x0020,   /* U+55BF */
  0x0020,   /* U+55C0 */
  0x0020,   /* U+55C1 */
  0x0020,   /* U+55C2 */
  0x0020,   /* U+55C3 */
  0x0020,   /* U+55C4 */
  0x0020,   /* U+55C5 */
  0x0020,   /* U+55C6 */
  0x0020,   /* U+55C7 */
  0x0020,   /* U+55C8 */
  0x0020,   /* U+55C9 */
  0x0020,   /* U+55CA */
  0x0020,   /* U+55CB */
  0x0020,   /* U+55CC */
  0x0020,   /* U+55CD */
  0x0020,   /* U+55CE */
  0x0020,   /* U+55CF */
  0x0020,   /* U+55D0 */
  0x0020,   /* U+55D1 */
  0x0020,   /* U+55D2 */
  0x0020,   /* U+55D3 */
  0x0020,   /* U+55D4 */
  0x0020,   /* U+55D5 */
  0x0020,   /* U+55D6 */
  0x0020,   /* U+55D7 */
  0x0020,   /* U+55D8 */
  0x0020,   /* U+55D9 */
  0x0020,   /* U+55DA */
  0x0020,   /* U+55DB */
  0x0020,   /* U+55DC */
  0x0020,   /* U+55DD */
  0x0020,   /* U+55DE */
  0x0020,   /* U+55DF */
  0x0020,   /* U+55E0 */
  0x0020,   /* U+55E1 */
  0x0020,   /* U+55E2 */
  0x0020,   /* U+55E3 */
  0x0020,   /* U+55E4 */
  0x0020,   /* U+55E5 */
  0x0020,   /* U+55E6 */
  0x0020,   /* U+55E7 */
  0x0020,   /* U+55E8 */
  0x0020,   /* U+55E9 */
  0x0020,   /* U+55EA */
  0x0020,   /* U+55EB */
  0x0020,   /* U+55EC */
  0x0020,   /* U+55ED */
  0x0020,   /* U+55EE */
  0x0020,   /* U+55EF */
  0x0020,   /* U+55F0 */
  0x0020,   /* U+55F1 */
  0x0020,   /* U+55F2 */
  0x0020,   /* U+55F3 */
  0x0020,   /* U+55F4 */
  0x0020,   /* U+55F5 */
  0x0020,   /* U+55F6 */
  0x0020,   /* U+55F7 */
  0x0020,   /* U+55F8 */
  0x0020,   /* U+55F9 */
  0x0020,   /* U+55FA */
  0x0020,   /* U+55FB */
  0x0020,   /* U+55FC */
  0x0020,   /* U+55FD */
  0x0020,   /* U+55FE */
  0x0020,   /* U+55FF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+5500 */
  0x0002,   /* U+5501 */
  0x0002,   /* U+5502 */
  0x0002,   /* U+5503 */
  0x0002,   /* U+5504 */
  0x0002,   /* U+5505 */
  0x0002,   /* U+5506 */
  0x0002,   /* U+5507 */
  0x0002,   /* U+5508 */
  0x0002,   /* U+5509 */
  0x0002,   /* U+550A */
  0x0002,   /* U+550B */
  0x0002,   /* U+550C */
  0x0002,   /* U+550D */
  0x0002,   /* U+550E */
  0x0002,   /* U+550F */
  0x0002,   /* U+5510 */
  0x0002,   /* U+5511 */
  0x0002,   /* U+5512 */
  0x0002,   /* U+5513 */
  0x0002,   /* U+5514 */
  0x0002,   /* U+5515 */
  0x0002,   /* U+5516 */
  0x0002,   /* U+5517 */
  0x0002,   /* U+5518 */
  0x0002,   /* U+5519 */
  0x0002,   /* U+551A */
  0x0002,   /* U+551B */
  0x0002,   /* U+551C */
  0x0002,   /* U+551D */
  0x0002,   /* U+551E */
  0x0002,   /* U+551F */
  0x0002,   /* U+5520 */
  0x0002,   /* U+5521 */
  0x0002,   /* U+5522 */
  0x0002,   /* U+5523 */
  0x0002,   /* U+5524 */
  0x0002,   /* U+5525 */
  0x0002,   /* U+5526 */
  0x0002,   /* U+5527 */
  0x0002,   /* U+5528 */
  0x0002,   /* U+5529 */
  0x0002,   /* U+552A */
  0x0002,   /* U+552B */
  0x0002,   /* U+552C */
  0x0002,   /* U+552D */
  0x0002,   /* U+552E */
  0x0002,   /* U+552F */
  0x0002,   /* U+5530 */
  0x0002,   /* U+5531 */
  0x0002,   /* U+5532 */
  0x0002,   /* U+5533 */
  0x0002,   /* U+5534 */
  0x0002,   /* U+5535 */
  0x0002,   /* U+5536 */
  0x0002,   /* U+5537 */
  0x0002,   /* U+5538 */
  0x0002,   /* U+5539 */
  0x0002,   /* U+553A */
  0x0002,   /* U+553B */
  0x0002,   /* U+553C */
  0x0002,   /* U+553D */
  0x0002,   /* U+553E */
  0x0002,   /* U+553F */
  0x0002,   /* U+5540 */
  0x0002,   /* U+5541 */
  0x0002,   /* U+5542 */
  0x0002,   /* U+5543 */
  0x0002,   /* U+5544 */
  0x0002,   /* U+5545 */
  0x0002,   /* U+5546 */
  0x0002,   /* U+5547 */
  0x0002,   /* U+5548 */
  0x0002,   /* U+5549 */
  0x0002,   /* U+554A */
  0x0002,   /* U+554B */
  0x0002,   /* U+554C */
  0x0002,   /* U+554D */
  0x0002,   /* U+554E */
  0x0002,   /* U+554F */
  0x0002,   /* U+5550 */
  0x0002,   /* U+5551 */
  0x0002,   /* U+5552 */
  0x0002,   /* U+5553 */
  0x0002,   /* U+5554 */
  0x0002,   /* U+5555 */
  0x0002,   /* U+5556 */
  0x0002,   /* U+5557 */
  0x0002,   /* U+5558 */
  0x0002,   /* U+5559 */
  0x0002,   /* U+555A */
  0x0002,   /* U+555B */
  0x0002,   /* U+555C */
  0x0002,   /* U+555D */
  0x0002,   /* U+555E */
  0x0002,   /* U+555F */
  0x0002,   /* U+5560 */
  0x0002,   /* U+5561 */
  0x0002,   /* U+5562 */
  0x0002,   /* U+5563 */
  0x0002,   /* U+5564 */
  0x0002,   /* U+5565 */
  0x0002,   /* U+5566 */
  0x0002,   /* U+5567 */
  0x0002,   /* U+5568 */
  0x0002,   /* U+5569 */
  0x0002,   /* U+556A */
  0x0002,   /* U+556B */
  0x0002,   /* U+556C */
  0x0002,   /* U+556D */
  0x0002,   /* U+556E */
  0x0002,   /* U+556F */
  0x0002,   /* U+5570 */
  0x0002,   /* U+5571 */
  0x0002,   /* U+5572 */
  0x0002,   /* U+5573 */
  0x0002,   /* U+5574 */
  0x0002,   /* U+5575 */
  0x0002,   /* U+5576 */
  0x0002,   /* U+5577 */
  0x0002,   /* U+5578 */
  0x0002,   /* U+5579 */
  0x0002,   /* U+557A */
  0x0002,   /* U+557B */
  0x0002,   /* U+557C */
  0x0002,   /* U+557D */
  0x0002,   /* U+557E */
  0x0002,   /* U+557F */
  0x0002,   /* U+5580 */
  0x0002,   /* U+5581 */
  0x0002,   /* U+5582 */
  0x0002,   /* U+5583 */
  0x0002,   /* U+5584 */
  0x0002,   /* U+5585 */
  0x0002,   /* U+5586 */
  0x0002,   /* U+5587 */
  0x0002,   /* U+5588 */
  0x0002,   /* U+5589 */
  0x0002,   /* U+558A */
  0x0002,   /* U+558B */
  0x0002,   /* U+558C */
  0x0002,   /* U+558D */
  0x0002,   /* U+558E */
  0x0002,   /* U+558F */
  0x0002,   /* U+5590 */
  0x0002,   /* U+5591 */
  0x0002,   /* U+5592 */
  0x0002,   /* U+5593 */
  0x0002,   /* U+5594 */
  0x0002,   /* U+5595 */
  0x0002,   /* U+5596 */
  0x0002,   /* U+5597 */
  0x0002,   /* U+5598 */
  0x0002,   /* U+5599 */
  0x0002,   /* U+559A */
  0x0002,   /* U+559B */
  0x0002,   /* U+559C */
  0x0002,   /* U+559D */
  0x0002,   /* U+559E */
  0x0002,   /* U+559F */
  0x0002,   /* U+55A0 */
  0x0002,   /* U+55A1 */
  0x0002,   /* U+55A2 */
  0x0002,   /* U+55A3 */
  0x0002,   /* U+55A4 */
  0x0002,   /* U+55A5 */
  0x0002,   /* U+55A6 */
  0x0002,   /* U+55A7 */
  0x0002,   /* U+55A8 */
  0x0002,   /* U+55A9 */
  0x0002,   /* U+55AA */
  0x0002,   /* U+55AB */
  0x0002,   /* U+55AC */
  0x0002,   /* U+55AD */
  0x0002,   /* U+55AE */
  0x0002,   /* U+55AF */
  0x0002,   /* U+55B0 */
  0x0002,   /* U+55B1 */
  0x0002,   /* U+55B2 */
  0x0002,   /* U+55B3 */
  0x0002,   /* U+55B4 */
  0x0002,   /* U+55B5 */
  0x0002,   /* U+55B6 */
  0x0002,   /* U+55B7 */
  0x0002,   /* U+55B8 */
  0x0002,   /* U+55B9 */
  0x0002,   /* U+55BA */
  0x0002,   /* U+55BB */
  0x0002,   /* U+55BC */
  0x0002,   /* U+55BD */
  0x0002,   /* U+55BE */
  0x0002,   /* U+55BF */
  0x0002,   /* U+55C0 */
  0x0002,   /* U+55C1 */
  0x0002,   /* U+55C2 */
  0x0002,   /* U+55C3 */
  0x0002,   /* U+55C4 */
  0x0002,   /* U+55C5 */
  0x0002,   /* U+55C6 */
  0x0002,   /* U+55C7 */
  0x0002,   /* U+55C8 */
  0x0002,   /* U+55C9 */
  0x0002,   /* U+55CA */
  0x0002,   /* U+55CB */
  0x0002,   /* U+55CC */
  0x0002,   /* U+55CD */
  0x0002,   /* U+55CE */
  0x0002,   /* U+55CF */
  0x0002,   /* U+55D0 */
  0x0002,   /* U+55D1 */
  0x0002,   /* U+55D2 */
  0x0002,   /* U+55D3 */
  0x0002,   /* U+55D4 */
  0x0002,   /* U+55D5 */
  0x0002,   /* U+55D6 */
  0x0002,   /* U+55D7 */
  0x0002,   /* U+55D8 */
  0x0002,   /* U+55D9 */
  0x0002,   /* U+55DA */
  0x0002,   /* U+55DB */
  0x0002,   /* U+55DC */
  0x0002,   /* U+55DD */
  0x0002,   /* U+55DE */
  0x0002,   /* U+55DF */
  0x0002,   /* U+55E0 */
  0x0002,   /* U+55E1 */
  0x0002,   /* U+55E2 */
  0x0002,   /* U+55E3 */
  0x0002,   /* U+55E4 */
  0x0002,   /* U+55E5 */
  0x0002,   /* U+55E6 */
  0x0002,   /* U+55E7 */
  0x0002,   /* U+55E8 */
  0x0002,   /* U+55E9 */
  0x0002,   /* U+55EA */
  0x0002,   /* U+55EB */
  0x0002,   /* U+55EC */
  0x0002,   /* U+55ED */
  0x0002,   /* U+55EE */
  0x0002,   /* U+55EF */
  0x0002,   /* U+55F0 */
  0x0002,   /* U+55F1 */
  0x0002,   /* U+55F2 */
  0x0002,   /* U+55F3 */
  0x0002,   /* U+55F4 */
  0x0002,   /* U+55F5 */
  0x0002,   /* U+55F6 */
  0x0002,   /* U+55F7 */
  0x0002,   /* U+55F8 */
  0x0002,   /* U+55F9 */
  0x0002,   /* U+55FA */
  0x0002,   /* U+55FB */
  0x0002,   /* U+55FC */
  0x0002,   /* U+55FD */
  0x0002,   /* U+55FE */
  0x0002,   /* U+55FF */

  /* Primary weight 2 for each character. */
  0xD500,   /* U+5500 */
  0xD501,   /* U+5501 */
  0xD502,   /* U+5502 */
  0xD503,   /* U+5503 */
  0x0000,   /* U+5504 */
  0xD505,   /* U+5505 */
  0x0000,   /* U+5506 */
  0x0000,   /* U+5507 */
  0xD508,   /* U+5508 */
  0xD509,   /* U+5509 */
  0xD50A,   /* U+550A */
  0xD50B,   /* U+550B */
  0xD50C,   /* U+550C */
  0xD50D,   /* U+550D */
  0xD50E,   /* U+550E */
  0x0000,   /* U+550F */
  0x0000,   /* U+5510 */
  0xD511,   /* U+5511 */
  0xD512,   /* U+5512 */
  0xD513,   /* U+5513 */
  0x0000,   /* U+5514 */
  0xD515,   /* U+5515 */
  0x0000,   /* U+5516 */
  0xD517,   /* U+5517 */
  0xD518,   /* U+5518 */
  0xD519,   /* U+5519 */
  0xD51A,   /* U+551A */
  0xD51B,   /* U+551B */
  0xD51C,   /* U+551C */
  0xD51D,   /* U+551D */
  0xD51E,   /* U+551E */
  0xD51F,   /* U+551F */
  0xD520,   /* U+5520 */
  0xD521,   /* U+5521 */
  0xD522,   /* U+5522 */
  0xD523,   /* U+5523 */
  0xD524,   /* U+5524 */
  0xD525,   /* U+5525 */
  0xD526,   /* U+5526 */
  0xD527,   /* U+5527 */
  0xD528,   /* U+5528 */
  0xD529,   /* U+5529 */
  0xD52A,   /* U+552A */
  0xD52B,   /* U+552B */
  0xD52C,   /* U+552C */
  0xD52D,   /* U+552D */
  0x0000,   /* U+552E */
  0x0000,   /* U+552F */
  0xD530,   /* U+5530 */
  0x0000,   /* U+5531 */
  0xD532,   /* U+5532 */
  0x0000,   /* U+5533 */
  0xD534,   /* U+5534 */
  0xD535,   /* U+5535 */
  0xD536,   /* U+5536 */
  0xD537,   /* U+5537 */
  0x0000,   /* U+5538 */
  0x0000,   /* U+5539 */
  0xD53A,   /* U+553A */
  0xD53B,   /* U+553B */
  0xD53C,   /* U+553C */
  0xD53D,   /* U+553D */
  0x0000,   /* U+553E */
  0xD53F,   /* U+553F */
  0x0000,   /* U+5540 */
  0xD541,   /* U+5541 */
  0xD542,   /* U+5542 */
  0xD543,   /* U+5543 */
  0x0000,   /* U+5544 */
  0x0000,   /* U+5545 */
  0x0000,   /* U+5546 */
  0xD547,   /* U+5547 */
  0xD548,   /* U+5548 */
  0xD549,   /* U+5549 */
  0xD54A,   /* U+554A */
  0xD54B,   /* U+554B */
  0x0000,   /* U+554C */
  0xD54D,   /* U+554D */
  0xD54E,   /* U+554E */
  0x0000,   /* U+554F */
  0xD550,   /* U+5550 */
  0xD551,   /* U+5551 */
  0xD552,   /* U+5552 */
  0x0000,   /* U+5553 */
  0xD554,   /* U+5554 */
  0xD555,   /* U+5555 */
  0x0000,   /* U+5556 */
  0x0000,   /* U+5557 */
  0xD558,   /* U+5558 */
  0xD559,   /* U+5559 */
  0xD55A,   /* U+555A */
  0xD55B,   /* U+555B */
  0x0000,   /* U+555C */
  0x0000,   /* U+555D */
  0xD55E,   /* U+555E */
  0xD55F,   /* U+555F */
  0xD560,   /* U+5560 */
  0xD561,   /* U+5561 */
  0xD562,   /* U+5562 */
  0x0000,   /* U+5563 */
  0xD564,   /* U+5564 */
  0xD565,   /* U+5565 */
  0xD566,   /* U+5566 */
  0xD567,   /* U+5567 */
  0xD568,   /* U+5568 */
  0xD569,   /* U+5569 */
  0xD56A,   /* U+556A */
  0xD56B,   /* U+556B */
  0xD56C,   /* U+556C */
  0xD56D,   /* U+556D */
  0xD56E,   /* U+556E */
  0xD56F,   /* U+556F */
  0xD570,   /* U+5570 */
  0xD571,   /* U+5571 */
  0xD572,   /* U+5572 */
  0xD573,   /* U+5573 */
  0xD574,   /* U+5574 */
  0xD575,   /* U+5575 */
  0xD576,   /* U+5576 */
  0xD577,   /* U+5577 */
  0xD578,   /* U+5578 */
  0xD579,   /* U+5579 */
  0xD57A,   /* U+557A */
  0x0000,   /* U+557B */
  0x0000,   /* U+557C */
  0xD57D,   /* U+557D */
  0x0000,   /* U+557E */
  0xD57F,   /* U+557F */
  0x0000,   /* U+5580 */
  0xD581,   /* U+5581 */
  0xD582,   /* U+5582 */
  0x0000,   /* U+5583 */
  0x0000,   /* U+5584 */
  0xD585,   /* U+5585 */
  0xD586,   /* U+5586 */
  0x0000,   /* U+5587 */
  0xD588,   /* U+5588 */
  0x0000,   /* U+5589 */
  0x0000,   /* U+558A */
  0x0000,   /* U+558B */
  0xD58C,   /* U+558C */
  0xD58D,   /* U+558D */
  0xD58E,   /* U+558E */
  0xD58F,   /* U+558F */
  0xD590,   /* U+5590 */
  0xD591,   /* U+5591 */
  0xD592,   /* U+5592 */
  0xD593,   /* U+5593 */
  0xD594,   /* U+5594 */
  0xD595,   /* U+5595 */
  0xD596,   /* U+5596 */
  0xD597,   /* U+5597 */
  0x0000,   /* U+5598 */
  0x0000,   /* U+5599 */
  0x0000,   /* U+559A */
  0xD59B,   /* U+559B */
  0x0000,   /* U+559C */
  0x0000,   /* U+559D */
  0x0000,   /* U+559E */
  0x0000,   /* U+559F */
  0xD5A0,   /* U+55A0 */
  0xD5A1,   /* U+55A1 */
  0xD5A2,   /* U+55A2 */
  0xD5A3,   /* U+55A3 */
  0xD5A4,   /* U+55A4 */
  0xD5A5,   /* U+55A5 */
  0xD5A6,   /* U+55A6 */
  0x0000,   /* U+55A7 */
  0x0000,   /* U+55A8 */
  0x0000,   /* U+55A9 */
  0x0000,   /* U+55AA */
  0x0000,   /* U+55AB */
  0x0000,   /* U+55AC */
  0xD5AD,   /* U+55AD */
  0x0000,   /* U+55AE */
  0xD5AF,   /* U+55AF */
  0x0000,   /* U+55B0 */
  0xD5B1,   /* U+55B1 */
  0xD5B2,   /* U+55B2 */
  0xD5B3,   /* U+55B3 */
  0xD5B4,   /* U+55B4 */
  0xD5B5,   /* U+55B5 */
  0x0000,   /* U+55B6 */
  0xD5B7,   /* U+55B7 */
  0xD5B8,   /* U+55B8 */
  0xD5B9,   /* U+55B9 */
  0xD5BA,   /* U+55BA */
  0xD5BB,   /* U+55BB */
  0xD5BC,   /* U+55BC */
  0xD5BD,   /* U+55BD */
  0xD5BE,   /* U+55BE */
  0xD5BF,   /* U+55BF */
  0xD5C0,   /* U+55C0 */
  0xD5C1,   /* U+55C1 */
  0xD5C2,   /* U+55C2 */
  0xD5C3,   /* U+55C3 */
  0x0000,   /* U+55C4 */
  0x0000,   /* U+55C5 */
  0xD5C6,   /* U+55C6 */
  0x0000,   /* U+55C7 */
  0xD5C8,   /* U+55C8 */
  0xD5C9,   /* U+55C9 */
  0xD5CA,   /* U+55CA */
  0xD5CB,   /* U+55CB */
  0xD5CC,   /* U+55CC */
  0xD5CD,   /* U+55CD */
  0xD5CE,   /* U+55CE */
  0xD5CF,   /* U+55CF */
  0xD5D0,   /* U+55D0 */
  0xD5D1,   /* U+55D1 */
  0xD5D2,   /* U+55D2 */
  0xD5D3,   /* U+55D3 */
  0x0000,   /* U+55D4 */
  0xD5D5,   /* U+55D5 */
  0xD5D6,   /* U+55D6 */
  0xD5D7,   /* U+55D7 */
  0xD5D8,   /* U+55D8 */
  0xD5D9,   /* U+55D9 */
  0x0000,   /* U+55DA */
  0xD5DB,   /* U+55DB */
  0x0000,   /* U+55DC */
  0xD5DD,   /* U+55DD */
  0xD5DE,   /* U+55DE */
  0x0000,   /* U+55DF */
  0xD5E0,   /* U+55E0 */
  0xD5E1,   /* U+55E1 */
  0xD5E2,   /* U+55E2 */
  0x0000,   /* U+55E3 */
  0x0000,   /* U+55E4 */
  0xD5E5,   /* U+55E5 */
  0xD5E6,   /* U+55E6 */
  0xD5E7,   /* U+55E7 */
  0xD5E8,   /* U+55E8 */
  0xD5E9,   /* U+55E9 */
  0xD5EA,   /* U+55EA */
  0xD5EB,   /* U+55EB */
  0xD5EC,   /* U+55EC */
  0xD5ED,   /* U+55ED */
  0xD5EE,   /* U+55EE */
  0xD5EF,   /* U+55EF */
  0xD5F0,   /* U+55F0 */
  0xD5F1,   /* U+55F1 */
  0xD5F2,   /* U+55F2 */
  0xD5F3,   /* U+55F3 */
  0xD5F4,   /* U+55F4 */
  0xD5F5,   /* U+55F5 */
  0xD5F6,   /* U+55F6 */
  0x0000,   /* U+55F7 */
  0xD5F8,   /* U+55F8 */
  0x0000,   /* U+55F9 */
  0xD5FA,   /* U+55FA */
  0xD5FB,   /* U+55FB */
  0xD5FC,   /* U+55FC */
  0x0000,   /* U+55FD */
  0x0000,   /* U+55FE */
  0xD5FF,   /* U+55FF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+5500 */
  0x0000,   /* U+5501 */
  0x0000,   /* U+5502 */
  0x0000,   /* U+5503 */
  0x0000,   /* U+5504 */
  0x0000,   /* U+5505 */
  0x0000,   /* U+5506 */
  0x0000,   /* U+5507 */
  0x0000,   /* U+5508 */
  0x0000,   /* U+5509 */
  0x0000,   /* U+550A */
  0x0000,   /* U+550B */
  0x0000,   /* U+550C */
  0x0000,   /* U+550D */
  0x0000,   /* U+550E */
  0x0000,   /* U+550F */
  0x0000,   /* U+5510 */
  0x0000,   /* U+5511 */
  0x0000,   /* U+5512 */
  0x0000,   /* U+5513 */
  0x0000,   /* U+5514 */
  0x0000,   /* U+5515 */
  0x0000,   /* U+5516 */
  0x0000,   /* U+5517 */
  0x0000,   /* U+5518 */
  0x0000,   /* U+5519 */
  0x0000,   /* U+551A */
  0x0000,   /* U+551B */
  0x0000,   /* U+551C */
  0x0000,   /* U+551D */
  0x0000,   /* U+551E */
  0x0000,   /* U+551F */
  0x0000,   /* U+5520 */
  0x0000,   /* U+5521 */
  0x0000,   /* U+5522 */
  0x0000,   /* U+5523 */
  0x0000,   /* U+5524 */
  0x0000,   /* U+5525 */
  0x0000,   /* U+5526 */
  0x0000,   /* U+5527 */
  0x0000,   /* U+5528 */
  0x0000,   /* U+5529 */
  0x0000,   /* U+552A */
  0x0000,   /* U+552B */
  0x0000,   /* U+552C */
  0x0000,   /* U+552D */
  0x0000,   /* U+552E */
  0x0000,   /* U+552F */
  0x0000,   /* U+5530 */
  0x0000,   /* U+5531 */
  0x0000,   /* U+5532 */
  0x0000,   /* U+5533 */
  0x0000,   /* U+5534 */
  0x0000,   /* U+5535 */
  0x0000,   /* U+5536 */
  0x0000,   /* U+5537 */
  0x0000,   /* U+5538 */
  0x0000,   /* U+5539 */
  0x0000,   /* U+553A */
  0x0000,   /* U+553B */
  0x0000,   /* U+553C */
  0x0000,   /* U+553D */
  0x0000,   /* U+553E */
  0x0000,   /* U+553F */
  0x0000,   /* U+5540 */
  0x0000,   /* U+5541 */
  0x0000,   /* U+5542 */
  0x0000,   /* U+5543 */
  0x0000,   /* U+5544 */
  0x0000,   /* U+5545 */
  0x0000,   /* U+5546 */
  0x0000,   /* U+5547 */
  0x0000,   /* U+5548 */
  0x0000,   /* U+5549 */
  0x0000,   /* U+554A */
  0x0000,   /* U+554B */
  0x0000,   /* U+554C */
  0x0000,   /* U+554D */
  0x0000,   /* U+554E */
  0x0000,   /* U+554F */
  0x0000,   /* U+5550 */
  0x0000,   /* U+5551 */
  0x0000,   /* U+5552 */
  0x0000,   /* U+5553 */
  0x0000,   /* U+5554 */
  0x0000,   /* U+5555 */
  0x0000,   /* U+5556 */
  0x0000,   /* U+5557 */
  0x0000,   /* U+5558 */
  0x0000,   /* U+5559 */
  0x0000,   /* U+555A */
  0x0000,   /* U+555B */
  0x0000,   /* U+555C */
  0x0000,   /* U+555D */
  0x0000,   /* U+555E */
  0x0000,   /* U+555F */
  0x0000,   /* U+5560 */
  0x0000,   /* U+5561 */
  0x0000,   /* U+5562 */
  0x0000,   /* U+5563 */
  0x0000,   /* U+5564 */
  0x0000,   /* U+5565 */
  0x0000,   /* U+5566 */
  0x0000,   /* U+5567 */
  0x0000,   /* U+5568 */
  0x0000,   /* U+5569 */
  0x0000,   /* U+556A */
  0x0000,   /* U+556B */
  0x0000,   /* U+556C */
  0x0000,   /* U+556D */
  0x0000,   /* U+556E */
  0x0000,   /* U+556F */
  0x0000,   /* U+5570 */
  0x0000,   /* U+5571 */
  0x0000,   /* U+5572 */
  0x0000,   /* U+5573 */
  0x0000,   /* U+5574 */
  0x0000,   /* U+5575 */
  0x0000,   /* U+5576 */
  0x0000,   /* U+5577 */
  0x0000,   /* U+5578 */
  0x0000,   /* U+5579 */
  0x0000,   /* U+557A */
  0x0000,   /* U+557B */
  0x0000,   /* U+557C */
  0x0000,   /* U+557D */
  0x0000,   /* U+557E */
  0x0000,   /* U+557F */
  0x0000,   /* U+5580 */
  0x0000,   /* U+5581 */
  0x0000,   /* U+5582 */
  0x0000,   /* U+5583 */
  0x0000,   /* U+5584 */
  0x0000,   /* U+5585 */
  0x0000,   /* U+5586 */
  0x0000,   /* U+5587 */
  0x0000,   /* U+5588 */
  0x0000,   /* U+5589 */
  0x0000,   /* U+558A */
  0x0000,   /* U+558B */
  0x0000,   /* U+558C */
  0x0000,   /* U+558D */
  0x0000,   /* U+558E */
  0x0000,   /* U+558F */
  0x0000,   /* U+5590 */
  0x0000,   /* U+5591 */
  0x0000,   /* U+5592 */
  0x0000,   /* U+5593 */
  0x0000,   /* U+5594 */
  0x0000,   /* U+5595 */
  0x0000,   /* U+5596 */
  0x0000,   /* U+5597 */
  0x0000,   /* U+5598 */
  0x0000,   /* U+5599 */
  0x0000,   /* U+559A */
  0x0000,   /* U+559B */
  0x0000,   /* U+559C */
  0x0000,   /* U+559D */
  0x0000,   /* U+559E */
  0x0000,   /* U+559F */
  0x0000,   /* U+55A0 */
  0x0000,   /* U+55A1 */
  0x0000,   /* U+55A2 */
  0x0000,   /* U+55A3 */
  0x0000,   /* U+55A4 */
  0x0000,   /* U+55A5 */
  0x0000,   /* U+55A6 */
  0x0000,   /* U+55A7 */
  0x0000,   /* U+55A8 */
  0x0000,   /* U+55A9 */
  0x0000,   /* U+55AA */
  0x0000,   /* U+55AB */
  0x0000,   /* U+55AC */
  0x0000,   /* U+55AD */
  0x0000,   /* U+55AE */
  0x0000,   /* U+55AF */
  0x0000,   /* U+55B0 */
  0x0000,   /* U+55B1 */
  0x0000,   /* U+55B2 */
  0x0000,   /* U+55B3 */
  0x0000,   /* U+55B4 */
  0x0000,   /* U+55B5 */
  0x0000,   /* U+55B6 */
  0x0000,   /* U+55B7 */
  0x0000,   /* U+55B8 */
  0x0000,   /* U+55B9 */
  0x0000,   /* U+55BA */
  0x0000,   /* U+55BB */
  0x0000,   /* U+55BC */
  0x0000,   /* U+55BD */
  0x0000,   /* U+55BE */
  0x0000,   /* U+55BF */
  0x0000,   /* U+55C0 */
  0x0000,   /* U+55C1 */
  0x0000,   /* U+55C2 */
  0x0000,   /* U+55C3 */
  0x0000,   /* U+55C4 */
  0x0000,   /* U+55C5 */
  0x0000,   /* U+55C6 */
  0x0000,   /* U+55C7 */
  0x0000,   /* U+55C8 */
  0x0000,   /* U+55C9 */
  0x0000,   /* U+55CA */
  0x0000,   /* U+55CB */
  0x0000,   /* U+55CC */
  0x0000,   /* U+55CD */
  0x0000,   /* U+55CE */
  0x0000,   /* U+55CF */
  0x0000,   /* U+55D0 */
  0x0000,   /* U+55D1 */
  0x0000,   /* U+55D2 */
  0x0000,   /* U+55D3 */
  0x0000,   /* U+55D4 */
  0x0000,   /* U+55D5 */
  0x0000,   /* U+55D6 */
  0x0000,   /* U+55D7 */
  0x0000,   /* U+55D8 */
  0x0000,   /* U+55D9 */
  0x0000,   /* U+55DA */
  0x0000,   /* U+55DB */
  0x0000,   /* U+55DC */
  0x0000,   /* U+55DD */
  0x0000,   /* U+55DE */
  0x0000,   /* U+55DF */
  0x0000,   /* U+55E0 */
  0x0000,   /* U+55E1 */
  0x0000,   /* U+55E2 */
  0x0000,   /* U+55E3 */
  0x0000,   /* U+55E4 */
  0x0000,   /* U+55E5 */
  0x0000,   /* U+55E6 */
  0x0000,   /* U+55E7 */
  0x0000,   /* U+55E8 */
  0x0000,   /* U+55E9 */
  0x0000,   /* U+55EA */
  0x0000,   /* U+55EB */
  0x0000,   /* U+55EC */
  0x0000,   /* U+55ED */
  0x0000,   /* U+55EE */
  0x0000,   /* U+55EF */
  0x0000,   /* U+55F0 */
  0x0000,   /* U+55F1 */
  0x0000,   /* U+55F2 */
  0x0000,   /* U+55F3 */
  0x0000,   /* U+55F4 */
  0x0000,   /* U+55F5 */
  0x0000,   /* U+55F6 */
  0x0000,   /* U+55F7 */
  0x0000,   /* U+55F8 */
  0x0000,   /* U+55F9 */
  0x0000,   /* U+55FA */
  0x0000,   /* U+55FB */
  0x0000,   /* U+55FC */
  0x0000,   /* U+55FD */
  0x0000,   /* U+55FE */
  0x0000,   /* U+55FF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+5500 */
  0x0000,   /* U+5501 */
  0x0000,   /* U+5502 */
  0x0000,   /* U+5503 */
  0x0000,   /* U+5504 */
  0x0000,   /* U+5505 */
  0x0000,   /* U+5506 */
  0x0000,   /* U+5507 */
  0x0000,   /* U+5508 */
  0x0000,   /* U+5509 */
  0x0000,   /* U+550A */
  0x0000,   /* U+550B */
  0x0000,   /* U+550C */
  0x0000,   /* U+550D */
  0x0000,   /* U+550E */
  0x0000,   /* U+550F */
  0x0000,   /* U+5510 */
  0x0000,   /* U+5511 */
  0x0000,   /* U+5512 */
  0x0000,   /* U+5513 */
  0x0000,   /* U+5514 */
  0x0000,   /* U+5515 */
  0x0000,   /* U+5516 */
  0x0000,   /* U+5517 */
  0x0000,   /* U+5518 */
  0x0000,   /* U+5519 */
  0x0000,   /* U+551A */
  0x0000,   /* U+551B */
  0x0000,   /* U+551C */
  0x0000,   /* U+551D */
  0x0000,   /* U+551E */
  0x0000,   /* U+551F */
  0x0000,   /* U+5520 */
  0x0000,   /* U+5521 */
  0x0000,   /* U+5522 */
  0x0000,   /* U+5523 */
  0x0000,   /* U+5524 */
  0x0000,   /* U+5525 */
  0x0000,   /* U+5526 */
  0x0000,   /* U+5527 */
  0x0000,   /* U+5528 */
  0x0000,   /* U+5529 */
  0x0000,   /* U+552A */
  0x0000,   /* U+552B */
  0x0000,   /* U+552C */
  0x0000,   /* U+552D */
  0x0000,   /* U+552E */
  0x0000,   /* U+552F */
  0x0000,   /* U+5530 */
  0x0000,   /* U+5531 */
  0x0000,   /* U+5532 */
  0x0000,   /* U+5533 */
  0x0000,   /* U+5534 */
  0x0000,   /* U+5535 */
  0x0000,   /* U+5536 */
  0x0000,   /* U+5537 */
  0x0000,   /* U+5538 */
  0x0000,   /* U+5539 */
  0x0000,   /* U+553A */
  0x0000,   /* U+553B */
  0x0000,   /* U+553C */
  0x0000,   /* U+553D */
  0x0000,   /* U+553E */
  0x0000,   /* U+553F */
  0x0000,   /* U+5540 */
  0x0000,   /* U+5541 */
  0x0000,   /* U+5542 */
  0x0000,   /* U+5543 */
  0x0000,   /* U+5544 */
  0x0000,   /* U+5545 */
  0x0000,   /* U+5546 */
  0x0000,   /* U+5547 */
  0x0000,   /* U+5548 */
  0x0000,   /* U+5549 */
  0x0000,   /* U+554A */
  0x0000,   /* U+554B */
  0x0000,   /* U+554C */
  0x0000,   /* U+554D */
  0x0000,   /* U+554E */
  0x0000,   /* U+554F */
  0x0000,   /* U+5550 */
  0x0000,   /* U+5551 */
  0x0000,   /* U+5552 */
  0x0000,   /* U+5553 */
  0x0000,   /* U+5554 */
  0x0000,   /* U+5555 */
  0x0000,   /* U+5556 */
  0x0000,   /* U+5557 */
  0x0000,   /* U+5558 */
  0x0000,   /* U+5559 */
  0x0000,   /* U+555A */
  0x0000,   /* U+555B */
  0x0000,   /* U+555C */
  0x0000,   /* U+555D */
  0x0000,   /* U+555E */
  0x0000,   /* U+555F */
  0x0000,   /* U+5560 */
  0x0000,   /* U+5561 */
  0x0000,   /* U+5562 */
  0x0000,   /* U+5563 */
  0x0000,   /* U+5564 */
  0x0000,   /* U+5565 */
  0x0000,   /* U+5566 */
  0x0000,   /* U+5567 */
  0x0000,   /* U+5568 */
  0x0000,   /* U+5569 */
  0x0000,   /* U+556A */
  0x0000,   /* U+556B */
  0x0000,   /* U+556C */
  0x0000,   /* U+556D */
  0x0000,   /* U+556E */
  0x0000,   /* U+556F */
  0x0000,   /* U+5570 */
  0x0000,   /* U+5571 */
  0x0000,   /* U+5572 */
  0x0000,   /* U+5573 */
  0x0000,   /* U+5574 */
  0x0000,   /* U+5575 */
  0x0000,   /* U+5576 */
  0x0000,   /* U+5577 */
  0x0000,   /* U+5578 */
  0x0000,   /* U+5579 */
  0x0000,   /* U+557A */
  0x0000,   /* U+557B */
  0x0000,   /* U+557C */
  0x0000,   /* U+557D */
  0x0000,   /* U+557E */
  0x0000,   /* U+557F */
  0x0000,   /* U+5580 */
  0x0000,   /* U+5581 */
  0x0000,   /* U+5582 */
  0x0000,   /* U+5583 */
  0x0000,   /* U+5584 */
  0x0000,   /* U+5585 */
  0x0000,   /* U+5586 */
  0x0000,   /* U+5587 */
  0x0000,   /* U+5588 */
  0x0000,   /* U+5589 */
  0x0000,   /* U+558A */
  0x0000,   /* U+558B */
  0x0000,   /* U+558C */
  0x0000,   /* U+558D */
  0x0000,   /* U+558E */
  0x0000,   /* U+558F */
  0x0000,   /* U+5590 */
  0x0000,   /* U+5591 */
  0x0000,   /* U+5592 */
  0x0000,   /* U+5593 */
  0x0000,   /* U+5594 */
  0x0000,   /* U+5595 */
  0x0000,   /* U+5596 */
  0x0000,   /* U+5597 */
  0x0000,   /* U+5598 */
  0x0000,   /* U+5599 */
  0x0000,   /* U+559A */
  0x0000,   /* U+559B */
  0x0000,   /* U+559C */
  0x0000,   /* U+559D */
  0x0000,   /* U+559E */
  0x0000,   /* U+559F */
  0x0000,   /* U+55A0 */
  0x0000,   /* U+55A1 */
  0x0000,   /* U+55A2 */
  0x0000,   /* U+55A3 */
  0x0000,   /* U+55A4 */
  0x0000,   /* U+55A5 */
  0x0000,   /* U+55A6 */
  0x0000,   /* U+55A7 */
  0x0000,   /* U+55A8 */
  0x0000,   /* U+55A9 */
  0x0000,   /* U+55AA */
  0x0000,   /* U+55AB */
  0x0000,   /* U+55AC */
  0x0000,   /* U+55AD */
  0x0000,   /* U+55AE */
  0x0000,   /* U+55AF */
  0x0000,   /* U+55B0 */
  0x0000,   /* U+55B1 */
  0x0000,   /* U+55B2 */
  0x0000,   /* U+55B3 */
  0x0000,   /* U+55B4 */
  0x0000,   /* U+55B5 */
  0x0000,   /* U+55B6 */
  0x0000,   /* U+55B7 */
  0x0000,   /* U+55B8 */
  0x0000,   /* U+55B9 */
  0x0000,   /* U+55BA */
  0x0000,   /* U+55BB */
  0x0000,   /* U+55BC */
  0x0000,   /* U+55BD */
  0x0000,   /* U+55BE */
  0x0000,   /* U+55BF */
  0x0000,   /* U+55C0 */
  0x0000,   /* U+55C1 */
  0x0000,   /* U+55C2 */
  0x0000,   /* U+55C3 */
  0x0000,   /* U+55C4 */
  0x0000,   /* U+55C5 */
  0x0000,   /* U+55C6 */
  0x0000,   /* U+55C7 */
  0x0000,   /* U+55C8 */
  0x0000,   /* U+55C9 */
  0x0000,   /* U+55CA */
  0x0000,   /* U+55CB */
  0x0000,   /* U+55CC */
  0x0000,   /* U+55CD */
  0x0000,   /* U+55CE */
  0x0000,   /* U+55CF */
  0x0000,   /* U+55D0 */
  0x0000,   /* U+55D1 */
  0x0000,   /* U+55D2 */
  0x0000,   /* U+55D3 */
  0x0000,   /* U+55D4 */
  0x0000,   /* U+55D5 */
  0x0000,   /* U+55D6 */
  0x0000,   /* U+55D7 */
  0x0000,   /* U+55D8 */
  0x0000,   /* U+55D9 */
  0x0000,   /* U+55DA */
  0x0000,   /* U+55DB */
  0x0000,   /* U+55DC */
  0x0000,   /* U+55DD */
  0x0000,   /* U+55DE */
  0x0000,   /* U+55DF */
  0x0000,   /* U+55E0 */
  0x0000,   /* U+55E1 */
  0x0000,   /* U+55E2 */
  0x0000,   /* U+55E3 */
  0x0000,   /* U+55E4 */
  0x0000,   /* U+55E5 */
  0x0000,   /* U+55E6 */
  0x0000,   /* U+55E7 */
  0x0000,   /* U+55E8 */
  0x0000,   /* U+55E9 */
  0x0000,   /* U+55EA */
  0x0000,   /* U+55EB */
  0x0000,   /* U+55EC */
  0x0000,   /* U+55ED */
  0x0000,   /* U+55EE */
  0x0000,   /* U+55EF */
  0x0000,   /* U+55F0 */
  0x0000,   /* U+55F1 */
  0x0000,   /* U+55F2 */
  0x0000,   /* U+55F3 */
  0x0000,   /* U+55F4 */
  0x0000,   /* U+55F5 */
  0x0000,   /* U+55F6 */
  0x0000,   /* U+55F7 */
  0x0000,   /* U+55F8 */
  0x0000,   /* U+55F9 */
  0x0000,   /* U+55FA */
  0x0000,   /* U+55FB */
  0x0000,   /* U+55FC */
  0x0000,   /* U+55FD */
  0x0000,   /* U+55FE */
  0x0000,   /* U+55FF */
};

uint16 ja_han_page56[]= {
  /* Number of CEs for each character. */
  2, 2, 2, 2, 2, 2, 1, 2, 2, 1, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 1, 2, 1, 1, 1, 2, 2, 1, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 1,
  2, 1, 1, 2, 1, 2, 1, 2, 1, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 1, 2,
  1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2,
  2, 2, 2, 2, 1, 2, 2, 2, 1, 2, 1, 1, 1, 2, 2, 2,
  2, 2, 2, 2, 1, 2, 2, 2, 1, 2, 1, 2, 2, 2, 2, 2,
  1, 2, 2, 2, 2, 2, 1, 1, 2, 2, 1, 2, 2, 2, 2, 1,
  2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  1, 2, 1, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2,
  2, 2, 2, 2, 1, 2, 1, 2, 2, 2, 2, 2, 1, 2, 2, 2,
  1, 1, 1, 1, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 1, 2,
  2, 1, 2, 1, 2, 2, 2, 1, 1, 2, 1, 1, 2, 2, 1, 2,
  1, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2,
  1, 2, 1, 1, 2, 2, 2, 2, 2, 1, 1, 2, 2, 1, 2, 1,

  /* Primary weight 1 for each character. */
  0xFB40,   /* U+5600 */
  0xFB40,   /* U+5601 */
  0xFB40,   /* U+5602 */
  0xFB40,   /* U+5603 */
  0xFB40,   /* U+5604 */
  0xFB40,   /* U+5605 */
  0x5BAF,   /* U+5606 */
  0xFB40,   /* U+5607 */
  0xFB40,   /* U+5608 */
  0x5584,   /* U+5609 */
  0xFB40,   /* U+560A */
  0xFB40,   /* U+560B */
  0xFB40,   /* U+560C */
  0xFB40,   /* U+560D */
  0xFB40,   /* U+560E */
  0xFB40,   /* U+560F */
  0xFB40,   /* U+5610 */
  0xFB40,   /* U+5611 */
  0xFB40,   /* U+5612 */
  0xFB40,   /* U+5613 */
  0x6184,   /* U+5614 */
  0xFB40,   /* U+5615 */
  0x6186,   /* U+5616 */
  0x59CF,   /* U+5617 */
  0x5514,   /* U+5618 */
  0xFB40,   /* U+5619 */
  0xFB40,   /* U+561A */
  0x6189,   /* U+561B */
  0xFB40,   /* U+561C */
  0xFB40,   /* U+561D */
  0xFB40,   /* U+561E */
  0xFB40,   /* U+561F */
  0xFB40,   /* U+5620 */
  0xFB40,   /* U+5621 */
  0xFB40,   /* U+5622 */
  0xFB40,   /* U+5623 */
  0xFB40,   /* U+5624 */
  0xFB40,   /* U+5625 */
  0xFB40,   /* U+5626 */
  0xFB40,   /* U+5627 */
  0xFB40,   /* U+5628 */
  0x559D,   /* U+5629 */
  0xFB40,   /* U+562A */
  0xFB40,   /* U+562B */
  0xFB40,   /* U+562C */
  0xFB40,   /* U+562D */
  0xFB40,   /* U+562E */
  0x6194,   /* U+562F */
  0xFB40,   /* U+5630 */
  0x5A23,   /* U+5631 */
  0x6190,   /* U+5632 */
  0xFB40,   /* U+5633 */
  0x618E,   /* U+5634 */
  0xFB40,   /* U+5635 */
  0x618F,   /* U+5636 */
  0xFB40,   /* U+5637 */
  0x6191,   /* U+5638 */
  0xFB40,   /* U+5639 */
  0xFB40,   /* U+563A */
  0xFB40,   /* U+563B */
  0xFB40,   /* U+563C */
  0xFB40,   /* U+563D */
  0xFB40,   /* U+563E */
  0xFB40,   /* U+563F */
  0xFB40,   /* U+5640 */
  0xFB40,   /* U+5641 */
  0x551E,   /* U+5642 */
  0xFB40,   /* U+5643 */
  0xFB40,   /* U+5644 */
  0xFB40,   /* U+5645 */
  0xFB40,   /* U+5646 */
  0xFB40,   /* U+5647 */
  0xFB40,   /* U+5648 */
  0xFB40,   /* U+5649 */
  0xFB40,   /* U+564A */
  0xFB40,   /* U+564B */
  0x5AFA,   /* U+564C */
  0xFB40,   /* U+564D */
  0x618B,   /* U+564E */
  0xFB40,   /* U+564F */
  0x618C,   /* U+5650 */
  0xFB40,   /* U+5651 */
  0xFB40,   /* U+5652 */
  0xFB40,   /* U+5653 */
  0xFB40,   /* U+5654 */
  0xFB40,   /* U+5655 */
  0xFB40,   /* U+5656 */
  0xFB40,   /* U+5657 */
  0xFB40,   /* U+5658 */
  0xFB40,   /* U+5659 */
  0xFB40,   /* U+565A */
  0x5617,   /* U+565B */
  0xFB40,   /* U+565C */
  0xFB40,   /* U+565D */
  0xFB40,   /* U+565E */
  0xFB40,   /* U+565F */
  0xFB40,   /* U+5660 */
  0xFB40,   /* U+5661 */
  0xFB40,   /* U+5662 */
  0xFB40,   /* U+5663 */
  0x6193,   /* U+5664 */
  0xFB40,   /* U+5665 */
  0xFB40,   /* U+5666 */
  0xFB40,   /* U+5667 */
  0x566A,   /* U+5668 */
  0xFB40,   /* U+5669 */
  0x6196,   /* U+566A */
  0x6192,   /* U+566B */
  0x6195,   /* U+566C */
  0xFB40,   /* U+566D */
  0xFB40,   /* U+566E */
  0xFB40,   /* U+566F */
  0xFB40,   /* U+5670 */
  0xFB40,   /* U+5671 */
  0xFB40,   /* U+5672 */
  0xFB40,   /* U+5673 */
  0x5E3D,   /* U+5674 */
  0xFB40,   /* U+5675 */
  0xFB40,   /* U+5676 */
  0xFB40,   /* U+5677 */
  0x5CEC,   /* U+5678 */
  0xFB40,   /* U+5679 */
  0x5D8B,   /* U+567A */
  0xFB40,   /* U+567B */
  0xFB40,   /* U+567C */
  0xFB40,   /* U+567D */
  0xFB40,   /* U+567E */
  0xFB40,   /* U+567F */
  0x6198,   /* U+5680 */
  0xFB40,   /* U+5681 */
  0xFB40,   /* U+5682 */
  0xFB40,   /* U+5683 */
  0xFB40,   /* U+5684 */
  0xFB40,   /* U+5685 */
  0x6197,   /* U+5686 */
  0x55E2,   /* U+5687 */
  0xFB40,   /* U+5688 */
  0xFB40,   /* U+5689 */
  0x6199,   /* U+568A */
  0xFB40,   /* U+568B */
  0xFB40,   /* U+568C */
  0xFB40,   /* U+568D */
  0xFB40,   /* U+568E */
  0x619C,   /* U+568F */
  0xFB40,   /* U+5690 */
  0xFB40,   /* U+5691 */
  0xFB40,   /* U+5692 */
  0xFB40,   /* U+5693 */
  0x619B,   /* U+5694 */
  0xFB40,   /* U+5695 */
  0xFB40,   /* U+5696 */
  0xFB40,   /* U+5697 */
  0xFB40,   /* U+5698 */
  0xFB40,   /* U+5699 */
  0xFB40,   /* U+569A */
  0xFB40,   /* U+569B */
  0xFB40,   /* U+569C */
  0xFB40,   /* U+569D */
  0xFB40,   /* U+569E */
  0xFB40,   /* U+569F */
  0x619A,   /* U+56A0 */
  0xFB40,   /* U+56A1 */
  0x5D2E,   /* U+56A2 */
  0xFB40,   /* U+56A3 */
  0xFB40,   /* U+56A4 */
  0x619D,   /* U+56A5 */
  0xFB40,   /* U+56A6 */
  0xFB40,   /* U+56A7 */
  0xFB40,   /* U+56A8 */
  0xFB40,   /* U+56A9 */
  0xFB40,   /* U+56AA */
  0xFB40,   /* U+56AB */
  0xFB40,   /* U+56AC */
  0xFB40,   /* U+56AD */
  0x619E,   /* U+56AE */
  0xFB40,   /* U+56AF */
  0xFB40,   /* U+56B0 */
  0xFB40,   /* U+56B1 */
  0xFB40,   /* U+56B2 */
  0xFB40,   /* U+56B3 */
  0x61A0,   /* U+56B4 */
  0xFB40,   /* U+56B5 */
  0x619F,   /* U+56B6 */
  0xFB40,   /* U+56B7 */
  0xFB40,   /* U+56B8 */
  0xFB40,   /* U+56B9 */
  0xFB40,   /* U+56BA */
  0xFB40,   /* U+56BB */
  0x61A2,   /* U+56BC */
  0xFB40,   /* U+56BD */
  0xFB40,   /* U+56BE */
  0xFB40,   /* U+56BF */
  0x61A5,   /* U+56C0 */
  0x61A3,   /* U+56C1 */
  0x61A1,   /* U+56C2 */
  0x61A4,   /* U+56C3 */
  0xFB40,   /* U+56C4 */
  0xFB40,   /* U+56C5 */
  0xFB40,   /* U+56C6 */
  0xFB40,   /* U+56C7 */
  0x61A6,   /* U+56C8 */
  0xFB40,   /* U+56C9 */
  0xFB40,   /* U+56CA */
  0xFB40,   /* U+56CB */
  0xFB40,   /* U+56CC */
  0xFB40,   /* U+56CD */
  0x61A7,   /* U+56CE */
  0xFB40,   /* U+56CF */
  0xFB40,   /* U+56D0 */
  0x61A8,   /* U+56D1 */
  0xFB40,   /* U+56D2 */
  0x61A9,   /* U+56D3 */
  0xFB40,   /* U+56D4 */
  0xFB40,   /* U+56D5 */
  0xFB40,   /* U+56D6 */
  0x61AA,   /* U+56D7 */
  0x60BB,   /* U+56D8 */
  0xFB40,   /* U+56D9 */
  0x5967,   /* U+56DA */
  0x58DA,   /* U+56DB */
  0xFB40,   /* U+56DC */
  0xFB40,   /* U+56DD */
  0x55B2,   /* U+56DE */
  0xFB40,   /* U+56DF */
  0x54FB,   /* U+56E0 */
  0xFB40,   /* U+56E1 */
  0xFB40,   /* U+56E2 */
  0x5BC1,   /* U+56E3 */
  0xFB40,   /* U+56E4 */
  0xFB40,   /* U+56E5 */
  0xFB40,   /* U+56E6 */
  0xFB40,   /* U+56E7 */
  0xFB40,   /* U+56E8 */
  0xFB40,   /* U+56E9 */
  0xFB40,   /* U+56EA */
  0xFB40,   /* U+56EB */
  0xFB40,   /* U+56EC */
  0xFB40,   /* U+56ED */
  0x61AB,   /* U+56EE */
  0xFB40,   /* U+56EF */
  0x5853,   /* U+56F0 */
  0xFB40,   /* U+56F1 */
  0x54D2,   /* U+56F2 */
  0x5A63,   /* U+56F3 */
  0xFB40,   /* U+56F4 */
  0xFB40,   /* U+56F5 */
  0xFB40,   /* U+56F6 */
  0xFB40,   /* U+56F7 */
  0xFB40,   /* U+56F8 */
  0x61AC,   /* U+56F9 */
  0x57BA,   /* U+56FA */
  0xFB40,   /* U+56FB */
  0xFB40,   /* U+56FC */
  0x5842,   /* U+56FD */
  0xFB40,   /* U+56FE */
  0x61AE,   /* U+56FF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+5600 */
  0x0020,   /* U+5601 */
  0x0020,   /* U+5602 */
  0x0020,   /* U+5603 */
  0x0020,   /* U+5604 */
  0x0020,   /* U+5605 */
  0x0020,   /* U+5606 */
  0x0020,   /* U+5607 */
  0x0020,   /* U+5608 */
  0x0020,   /* U+5609 */
  0x0020,   /* U+560A */
  0x0020,   /* U+560B */
  0x0020,   /* U+560C */
  0x0020,   /* U+560D */
  0x0020,   /* U+560E */
  0x0020,   /* U+560F */
  0x0020,   /* U+5610 */
  0x0020,   /* U+5611 */
  0x0020,   /* U+5612 */
  0x0020,   /* U+5613 */
  0x0020,   /* U+5614 */
  0x0020,   /* U+5615 */
  0x0020,   /* U+5616 */
  0x0020,   /* U+5617 */
  0x0020,   /* U+5618 */
  0x0020,   /* U+5619 */
  0x0020,   /* U+561A */
  0x0020,   /* U+561B */
  0x0020,   /* U+561C */
  0x0020,   /* U+561D */
  0x0020,   /* U+561E */
  0x0020,   /* U+561F */
  0x0020,   /* U+5620 */
  0x0020,   /* U+5621 */
  0x0020,   /* U+5622 */
  0x0020,   /* U+5623 */
  0x0020,   /* U+5624 */
  0x0020,   /* U+5625 */
  0x0020,   /* U+5626 */
  0x0020,   /* U+5627 */
  0x0020,   /* U+5628 */
  0x0020,   /* U+5629 */
  0x0020,   /* U+562A */
  0x0020,   /* U+562B */
  0x0020,   /* U+562C */
  0x0020,   /* U+562D */
  0x0020,   /* U+562E */
  0x0020,   /* U+562F */
  0x0020,   /* U+5630 */
  0x0020,   /* U+5631 */
  0x0020,   /* U+5632 */
  0x0020,   /* U+5633 */
  0x0020,   /* U+5634 */
  0x0020,   /* U+5635 */
  0x0020,   /* U+5636 */
  0x0020,   /* U+5637 */
  0x0020,   /* U+5638 */
  0x0020,   /* U+5639 */
  0x0020,   /* U+563A */
  0x0020,   /* U+563B */
  0x0020,   /* U+563C */
  0x0020,   /* U+563D */
  0x0020,   /* U+563E */
  0x0020,   /* U+563F */
  0x0020,   /* U+5640 */
  0x0020,   /* U+5641 */
  0x0020,   /* U+5642 */
  0x0020,   /* U+5643 */
  0x0020,   /* U+5644 */
  0x0020,   /* U+5645 */
  0x0020,   /* U+5646 */
  0x0020,   /* U+5647 */
  0x0020,   /* U+5648 */
  0x0020,   /* U+5649 */
  0x0020,   /* U+564A */
  0x0020,   /* U+564B */
  0x0020,   /* U+564C */
  0x0020,   /* U+564D */
  0x0020,   /* U+564E */
  0x0020,   /* U+564F */
  0x0020,   /* U+5650 */
  0x0020,   /* U+5651 */
  0x0020,   /* U+5652 */
  0x0020,   /* U+5653 */
  0x0020,   /* U+5654 */
  0x0020,   /* U+5655 */
  0x0020,   /* U+5656 */
  0x0020,   /* U+5657 */
  0x0020,   /* U+5658 */
  0x0020,   /* U+5659 */
  0x0020,   /* U+565A */
  0x0020,   /* U+565B */
  0x0020,   /* U+565C */
  0x0020,   /* U+565D */
  0x0020,   /* U+565E */
  0x0020,   /* U+565F */
  0x0020,   /* U+5660 */
  0x0020,   /* U+5661 */
  0x0020,   /* U+5662 */
  0x0020,   /* U+5663 */
  0x0020,   /* U+5664 */
  0x0020,   /* U+5665 */
  0x0020,   /* U+5666 */
  0x0020,   /* U+5667 */
  0x0020,   /* U+5668 */
  0x0020,   /* U+5669 */
  0x0020,   /* U+566A */
  0x0020,   /* U+566B */
  0x0020,   /* U+566C */
  0x0020,   /* U+566D */
  0x0020,   /* U+566E */
  0x0020,   /* U+566F */
  0x0020,   /* U+5670 */
  0x0020,   /* U+5671 */
  0x0020,   /* U+5672 */
  0x0020,   /* U+5673 */
  0x0020,   /* U+5674 */
  0x0020,   /* U+5675 */
  0x0020,   /* U+5676 */
  0x0020,   /* U+5677 */
  0x0020,   /* U+5678 */
  0x0020,   /* U+5679 */
  0x0020,   /* U+567A */
  0x0020,   /* U+567B */
  0x0020,   /* U+567C */
  0x0020,   /* U+567D */
  0x0020,   /* U+567E */
  0x0020,   /* U+567F */
  0x0020,   /* U+5680 */
  0x0020,   /* U+5681 */
  0x0020,   /* U+5682 */
  0x0020,   /* U+5683 */
  0x0020,   /* U+5684 */
  0x0020,   /* U+5685 */
  0x0020,   /* U+5686 */
  0x0020,   /* U+5687 */
  0x0020,   /* U+5688 */
  0x0020,   /* U+5689 */
  0x0020,   /* U+568A */
  0x0020,   /* U+568B */
  0x0020,   /* U+568C */
  0x0020,   /* U+568D */
  0x0020,   /* U+568E */
  0x0020,   /* U+568F */
  0x0020,   /* U+5690 */
  0x0020,   /* U+5691 */
  0x0020,   /* U+5692 */
  0x0020,   /* U+5693 */
  0x0020,   /* U+5694 */
  0x0020,   /* U+5695 */
  0x0020,   /* U+5696 */
  0x0020,   /* U+5697 */
  0x0020,   /* U+5698 */
  0x0020,   /* U+5699 */
  0x0020,   /* U+569A */
  0x0020,   /* U+569B */
  0x0020,   /* U+569C */
  0x0020,   /* U+569D */
  0x0020,   /* U+569E */
  0x0020,   /* U+569F */
  0x0020,   /* U+56A0 */
  0x0020,   /* U+56A1 */
  0x0020,   /* U+56A2 */
  0x0020,   /* U+56A3 */
  0x0020,   /* U+56A4 */
  0x0020,   /* U+56A5 */
  0x0020,   /* U+56A6 */
  0x0020,   /* U+56A7 */
  0x0020,   /* U+56A8 */
  0x0020,   /* U+56A9 */
  0x0020,   /* U+56AA */
  0x0020,   /* U+56AB */
  0x0020,   /* U+56AC */
  0x0020,   /* U+56AD */
  0x0020,   /* U+56AE */
  0x0020,   /* U+56AF */
  0x0020,   /* U+56B0 */
  0x0020,   /* U+56B1 */
  0x0020,   /* U+56B2 */
  0x0020,   /* U+56B3 */
  0x0020,   /* U+56B4 */
  0x0020,   /* U+56B5 */
  0x0020,   /* U+56B6 */
  0x0020,   /* U+56B7 */
  0x0020,   /* U+56B8 */
  0x0020,   /* U+56B9 */
  0x0020,   /* U+56BA */
  0x0020,   /* U+56BB */
  0x0020,   /* U+56BC */
  0x0020,   /* U+56BD */
  0x0020,   /* U+56BE */
  0x0020,   /* U+56BF */
  0x0020,   /* U+56C0 */
  0x0020,   /* U+56C1 */
  0x0020,   /* U+56C2 */
  0x0020,   /* U+56C3 */
  0x0020,   /* U+56C4 */
  0x0020,   /* U+56C5 */
  0x0020,   /* U+56C6 */
  0x0020,   /* U+56C7 */
  0x0020,   /* U+56C8 */
  0x0020,   /* U+56C9 */
  0x0020,   /* U+56CA */
  0x0020,   /* U+56CB */
  0x0020,   /* U+56CC */
  0x0020,   /* U+56CD */
  0x0020,   /* U+56CE */
  0x0020,   /* U+56CF */
  0x0020,   /* U+56D0 */
  0x0020,   /* U+56D1 */
  0x0020,   /* U+56D2 */
  0x0020,   /* U+56D3 */
  0x0020,   /* U+56D4 */
  0x0020,   /* U+56D5 */
  0x0020,   /* U+56D6 */
  0x0020,   /* U+56D7 */
  0x0020,   /* U+56D8 */
  0x0020,   /* U+56D9 */
  0x0020,   /* U+56DA */
  0x0020,   /* U+56DB */
  0x0020,   /* U+56DC */
  0x0020,   /* U+56DD */
  0x0020,   /* U+56DE */
  0x0020,   /* U+56DF */
  0x0020,   /* U+56E0 */
  0x0020,   /* U+56E1 */
  0x0020,   /* U+56E2 */
  0x0020,   /* U+56E3 */
  0x0020,   /* U+56E4 */
  0x0020,   /* U+56E5 */
  0x0020,   /* U+56E6 */
  0x0020,   /* U+56E7 */
  0x0020,   /* U+56E8 */
  0x0020,   /* U+56E9 */
  0x0020,   /* U+56EA */
  0x0020,   /* U+56EB */
  0x0020,   /* U+56EC */
  0x0020,   /* U+56ED */
  0x0020,   /* U+56EE */
  0x0020,   /* U+56EF */
  0x0020,   /* U+56F0 */
  0x0020,   /* U+56F1 */
  0x0020,   /* U+56F2 */
  0x0020,   /* U+56F3 */
  0x0020,   /* U+56F4 */
  0x0020,   /* U+56F5 */
  0x0020,   /* U+56F6 */
  0x0020,   /* U+56F7 */
  0x0020,   /* U+56F8 */
  0x0020,   /* U+56F9 */
  0x0020,   /* U+56FA */
  0x0020,   /* U+56FB */
  0x0020,   /* U+56FC */
  0x0020,   /* U+56FD */
  0x0020,   /* U+56FE */
  0x0020,   /* U+56FF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+5600 */
  0x0002,   /* U+5601 */
  0x0002,   /* U+5602 */
  0x0002,   /* U+5603 */
  0x0002,   /* U+5604 */
  0x0002,   /* U+5605 */
  0x0002,   /* U+5606 */
  0x0002,   /* U+5607 */
  0x0002,   /* U+5608 */
  0x0002,   /* U+5609 */
  0x0002,   /* U+560A */
  0x0002,   /* U+560B */
  0x0002,   /* U+560C */
  0x0002,   /* U+560D */
  0x0002,   /* U+560E */
  0x0002,   /* U+560F */
  0x0002,   /* U+5610 */
  0x0002,   /* U+5611 */
  0x0002,   /* U+5612 */
  0x0002,   /* U+5613 */
  0x0002,   /* U+5614 */
  0x0002,   /* U+5615 */
  0x0002,   /* U+5616 */
  0x0002,   /* U+5617 */
  0x0002,   /* U+5618 */
  0x0002,   /* U+5619 */
  0x0002,   /* U+561A */
  0x0002,   /* U+561B */
  0x0002,   /* U+561C */
  0x0002,   /* U+561D */
  0x0002,   /* U+561E */
  0x0002,   /* U+561F */
  0x0002,   /* U+5620 */
  0x0002,   /* U+5621 */
  0x0002,   /* U+5622 */
  0x0002,   /* U+5623 */
  0x0002,   /* U+5624 */
  0x0002,   /* U+5625 */
  0x0002,   /* U+5626 */
  0x0002,   /* U+5627 */
  0x0002,   /* U+5628 */
  0x0002,   /* U+5629 */
  0x0002,   /* U+562A */
  0x0002,   /* U+562B */
  0x0002,   /* U+562C */
  0x0002,   /* U+562D */
  0x0002,   /* U+562E */
  0x0002,   /* U+562F */
  0x0002,   /* U+5630 */
  0x0002,   /* U+5631 */
  0x0002,   /* U+5632 */
  0x0002,   /* U+5633 */
  0x0002,   /* U+5634 */
  0x0002,   /* U+5635 */
  0x0002,   /* U+5636 */
  0x0002,   /* U+5637 */
  0x0002,   /* U+5638 */
  0x0002,   /* U+5639 */
  0x0002,   /* U+563A */
  0x0002,   /* U+563B */
  0x0002,   /* U+563C */
  0x0002,   /* U+563D */
  0x0002,   /* U+563E */
  0x0002,   /* U+563F */
  0x0002,   /* U+5640 */
  0x0002,   /* U+5641 */
  0x0002,   /* U+5642 */
  0x0002,   /* U+5643 */
  0x0002,   /* U+5644 */
  0x0002,   /* U+5645 */
  0x0002,   /* U+5646 */
  0x0002,   /* U+5647 */
  0x0002,   /* U+5648 */
  0x0002,   /* U+5649 */
  0x0002,   /* U+564A */
  0x0002,   /* U+564B */
  0x0002,   /* U+564C */
  0x0002,   /* U+564D */
  0x0002,   /* U+564E */
  0x0002,   /* U+564F */
  0x0002,   /* U+5650 */
  0x0002,   /* U+5651 */
  0x0002,   /* U+5652 */
  0x0002,   /* U+5653 */
  0x0002,   /* U+5654 */
  0x0002,   /* U+5655 */
  0x0002,   /* U+5656 */
  0x0002,   /* U+5657 */
  0x0002,   /* U+5658 */
  0x0002,   /* U+5659 */
  0x0002,   /* U+565A */
  0x0002,   /* U+565B */
  0x0002,   /* U+565C */
  0x0002,   /* U+565D */
  0x0002,   /* U+565E */
  0x0002,   /* U+565F */
  0x0002,   /* U+5660 */
  0x0002,   /* U+5661 */
  0x0002,   /* U+5662 */
  0x0002,   /* U+5663 */
  0x0002,   /* U+5664 */
  0x0002,   /* U+5665 */
  0x0002,   /* U+5666 */
  0x0002,   /* U+5667 */
  0x0002,   /* U+5668 */
  0x0002,   /* U+5669 */
  0x0002,   /* U+566A */
  0x0002,   /* U+566B */
  0x0002,   /* U+566C */
  0x0002,   /* U+566D */
  0x0002,   /* U+566E */
  0x0002,   /* U+566F */
  0x0002,   /* U+5670 */
  0x0002,   /* U+5671 */
  0x0002,   /* U+5672 */
  0x0002,   /* U+5673 */
  0x0002,   /* U+5674 */
  0x0002,   /* U+5675 */
  0x0002,   /* U+5676 */
  0x0002,   /* U+5677 */
  0x0002,   /* U+5678 */
  0x0002,   /* U+5679 */
  0x0002,   /* U+567A */
  0x0002,   /* U+567B */
  0x0002,   /* U+567C */
  0x0002,   /* U+567D */
  0x0002,   /* U+567E */
  0x0002,   /* U+567F */
  0x0002,   /* U+5680 */
  0x0002,   /* U+5681 */
  0x0002,   /* U+5682 */
  0x0002,   /* U+5683 */
  0x0002,   /* U+5684 */
  0x0002,   /* U+5685 */
  0x0002,   /* U+5686 */
  0x0002,   /* U+5687 */
  0x0002,   /* U+5688 */
  0x0002,   /* U+5689 */
  0x0002,   /* U+568A */
  0x0002,   /* U+568B */
  0x0002,   /* U+568C */
  0x0002,   /* U+568D */
  0x0002,   /* U+568E */
  0x0002,   /* U+568F */
  0x0002,   /* U+5690 */
  0x0002,   /* U+5691 */
  0x0002,   /* U+5692 */
  0x0002,   /* U+5693 */
  0x0002,   /* U+5694 */
  0x0002,   /* U+5695 */
  0x0002,   /* U+5696 */
  0x0002,   /* U+5697 */
  0x0002,   /* U+5698 */
  0x0002,   /* U+5699 */
  0x0002,   /* U+569A */
  0x0002,   /* U+569B */
  0x0002,   /* U+569C */
  0x0002,   /* U+569D */
  0x0002,   /* U+569E */
  0x0002,   /* U+569F */
  0x0002,   /* U+56A0 */
  0x0002,   /* U+56A1 */
  0x0002,   /* U+56A2 */
  0x0002,   /* U+56A3 */
  0x0002,   /* U+56A4 */
  0x0002,   /* U+56A5 */
  0x0002,   /* U+56A6 */
  0x0002,   /* U+56A7 */
  0x0002,   /* U+56A8 */
  0x0002,   /* U+56A9 */
  0x0002,   /* U+56AA */
  0x0002,   /* U+56AB */
  0x0002,   /* U+56AC */
  0x0002,   /* U+56AD */
  0x0002,   /* U+56AE */
  0x0002,   /* U+56AF */
  0x0002,   /* U+56B0 */
  0x0002,   /* U+56B1 */
  0x0002,   /* U+56B2 */
  0x0002,   /* U+56B3 */
  0x0002,   /* U+56B4 */
  0x0002,   /* U+56B5 */
  0x0002,   /* U+56B6 */
  0x0002,   /* U+56B7 */
  0x0002,   /* U+56B8 */
  0x0002,   /* U+56B9 */
  0x0002,   /* U+56BA */
  0x0002,   /* U+56BB */
  0x0002,   /* U+56BC */
  0x0002,   /* U+56BD */
  0x0002,   /* U+56BE */
  0x0002,   /* U+56BF */
  0x0002,   /* U+56C0 */
  0x0002,   /* U+56C1 */
  0x0002,   /* U+56C2 */
  0x0002,   /* U+56C3 */
  0x0002,   /* U+56C4 */
  0x0002,   /* U+56C5 */
  0x0002,   /* U+56C6 */
  0x0002,   /* U+56C7 */
  0x0002,   /* U+56C8 */
  0x0002,   /* U+56C9 */
  0x0002,   /* U+56CA */
  0x0002,   /* U+56CB */
  0x0002,   /* U+56CC */
  0x0002,   /* U+56CD */
  0x0002,   /* U+56CE */
  0x0002,   /* U+56CF */
  0x0002,   /* U+56D0 */
  0x0002,   /* U+56D1 */
  0x0002,   /* U+56D2 */
  0x0002,   /* U+56D3 */
  0x0002,   /* U+56D4 */
  0x0002,   /* U+56D5 */
  0x0002,   /* U+56D6 */
  0x0002,   /* U+56D7 */
  0x0002,   /* U+56D8 */
  0x0002,   /* U+56D9 */
  0x0002,   /* U+56DA */
  0x0002,   /* U+56DB */
  0x0002,   /* U+56DC */
  0x0002,   /* U+56DD */
  0x0002,   /* U+56DE */
  0x0002,   /* U+56DF */
  0x0002,   /* U+56E0 */
  0x0002,   /* U+56E1 */
  0x0002,   /* U+56E2 */
  0x0002,   /* U+56E3 */
  0x0002,   /* U+56E4 */
  0x0002,   /* U+56E5 */
  0x0002,   /* U+56E6 */
  0x0002,   /* U+56E7 */
  0x0002,   /* U+56E8 */
  0x0002,   /* U+56E9 */
  0x0002,   /* U+56EA */
  0x0002,   /* U+56EB */
  0x0002,   /* U+56EC */
  0x0002,   /* U+56ED */
  0x0002,   /* U+56EE */
  0x0002,   /* U+56EF */
  0x0002,   /* U+56F0 */
  0x0002,   /* U+56F1 */
  0x0002,   /* U+56F2 */
  0x0002,   /* U+56F3 */
  0x0002,   /* U+56F4 */
  0x0002,   /* U+56F5 */
  0x0002,   /* U+56F6 */
  0x0002,   /* U+56F7 */
  0x0002,   /* U+56F8 */
  0x0002,   /* U+56F9 */
  0x0002,   /* U+56FA */
  0x0002,   /* U+56FB */
  0x0002,   /* U+56FC */
  0x0002,   /* U+56FD */
  0x0002,   /* U+56FE */
  0x0002,   /* U+56FF */

  /* Primary weight 2 for each character. */
  0xD600,   /* U+5600 */
  0xD601,   /* U+5601 */
  0xD602,   /* U+5602 */
  0xD603,   /* U+5603 */
  0xD604,   /* U+5604 */
  0xD605,   /* U+5605 */
  0x0000,   /* U+5606 */
  0xD607,   /* U+5607 */
  0xD608,   /* U+5608 */
  0x0000,   /* U+5609 */
  0xD60A,   /* U+560A */
  0xD60B,   /* U+560B */
  0xD60C,   /* U+560C */
  0xD60D,   /* U+560D */
  0xD60E,   /* U+560E */
  0xD60F,   /* U+560F */
  0xD610,   /* U+5610 */
  0xD611,   /* U+5611 */
  0xD612,   /* U+5612 */
  0xD613,   /* U+5613 */
  0x0000,   /* U+5614 */
  0xD615,   /* U+5615 */
  0x0000,   /* U+5616 */
  0x0000,   /* U+5617 */
  0x0000,   /* U+5618 */
  0xD619,   /* U+5619 */
  0xD61A,   /* U+561A */
  0x0000,   /* U+561B */
  0xD61C,   /* U+561C */
  0xD61D,   /* U+561D */
  0xD61E,   /* U+561E */
  0xD61F,   /* U+561F */
  0xD620,   /* U+5620 */
  0xD621,   /* U+5621 */
  0xD622,   /* U+5622 */
  0xD623,   /* U+5623 */
  0xD624,   /* U+5624 */
  0xD625,   /* U+5625 */
  0xD626,   /* U+5626 */
  0xD627,   /* U+5627 */
  0xD628,   /* U+5628 */
  0x0000,   /* U+5629 */
  0xD62A,   /* U+562A */
  0xD62B,   /* U+562B */
  0xD62C,   /* U+562C */
  0xD62D,   /* U+562D */
  0xD62E,   /* U+562E */
  0x0000,   /* U+562F */
  0xD630,   /* U+5630 */
  0x0000,   /* U+5631 */
  0x0000,   /* U+5632 */
  0xD633,   /* U+5633 */
  0x0000,   /* U+5634 */
  0xD635,   /* U+5635 */
  0x0000,   /* U+5636 */
  0xD637,   /* U+5637 */
  0x0000,   /* U+5638 */
  0xD639,   /* U+5639 */
  0xD63A,   /* U+563A */
  0xD63B,   /* U+563B */
  0xD63C,   /* U+563C */
  0xD63D,   /* U+563D */
  0xD63E,   /* U+563E */
  0xD63F,   /* U+563F */
  0xD640,   /* U+5640 */
  0xD641,   /* U+5641 */
  0x0000,   /* U+5642 */
  0xD643,   /* U+5643 */
  0xD644,   /* U+5644 */
  0xD645,   /* U+5645 */
  0xD646,   /* U+5646 */
  0xD647,   /* U+5647 */
  0xD648,   /* U+5648 */
  0xD649,   /* U+5649 */
  0xD64A,   /* U+564A */
  0xD64B,   /* U+564B */
  0x0000,   /* U+564C */
  0xD64D,   /* U+564D */
  0x0000,   /* U+564E */
  0xD64F,   /* U+564F */
  0x0000,   /* U+5650 */
  0xD651,   /* U+5651 */
  0xD652,   /* U+5652 */
  0xD653,   /* U+5653 */
  0xD654,   /* U+5654 */
  0xD655,   /* U+5655 */
  0xD656,   /* U+5656 */
  0xD657,   /* U+5657 */
  0xD658,   /* U+5658 */
  0xD659,   /* U+5659 */
  0xD65A,   /* U+565A */
  0x0000,   /* U+565B */
  0xD65C,   /* U+565C */
  0xD65D,   /* U+565D */
  0xD65E,   /* U+565E */
  0xD65F,   /* U+565F */
  0xD660,   /* U+5660 */
  0xD661,   /* U+5661 */
  0xD662,   /* U+5662 */
  0xD663,   /* U+5663 */
  0x0000,   /* U+5664 */
  0xD665,   /* U+5665 */
  0xD666,   /* U+5666 */
  0xD667,   /* U+5667 */
  0x0000,   /* U+5668 */
  0xD669,   /* U+5669 */
  0x0000,   /* U+566A */
  0x0000,   /* U+566B */
  0x0000,   /* U+566C */
  0xD66D,   /* U+566D */
  0xD66E,   /* U+566E */
  0xD66F,   /* U+566F */
  0xD670,   /* U+5670 */
  0xD671,   /* U+5671 */
  0xD672,   /* U+5672 */
  0xD673,   /* U+5673 */
  0x0000,   /* U+5674 */
  0xD675,   /* U+5675 */
  0xD676,   /* U+5676 */
  0xD677,   /* U+5677 */
  0x0000,   /* U+5678 */
  0xD679,   /* U+5679 */
  0x0000,   /* U+567A */
  0xD67B,   /* U+567B */
  0xD67C,   /* U+567C */
  0xD67D,   /* U+567D */
  0xD67E,   /* U+567E */
  0xD67F,   /* U+567F */
  0x0000,   /* U+5680 */
  0xD681,   /* U+5681 */
  0xD682,   /* U+5682 */
  0xD683,   /* U+5683 */
  0xD684,   /* U+5684 */
  0xD685,   /* U+5685 */
  0x0000,   /* U+5686 */
  0x0000,   /* U+5687 */
  0xD688,   /* U+5688 */
  0xD689,   /* U+5689 */
  0x0000,   /* U+568A */
  0xD68B,   /* U+568B */
  0xD68C,   /* U+568C */
  0xD68D,   /* U+568D */
  0xD68E,   /* U+568E */
  0x0000,   /* U+568F */
  0xD690,   /* U+5690 */
  0xD691,   /* U+5691 */
  0xD692,   /* U+5692 */
  0xD693,   /* U+5693 */
  0x0000,   /* U+5694 */
  0xD695,   /* U+5695 */
  0xD696,   /* U+5696 */
  0xD697,   /* U+5697 */
  0xD698,   /* U+5698 */
  0xD699,   /* U+5699 */
  0xD69A,   /* U+569A */
  0xD69B,   /* U+569B */
  0xD69C,   /* U+569C */
  0xD69D,   /* U+569D */
  0xD69E,   /* U+569E */
  0xD69F,   /* U+569F */
  0x0000,   /* U+56A0 */
  0xD6A1,   /* U+56A1 */
  0x0000,   /* U+56A2 */
  0xD6A3,   /* U+56A3 */
  0xD6A4,   /* U+56A4 */
  0x0000,   /* U+56A5 */
  0xD6A6,   /* U+56A6 */
  0xD6A7,   /* U+56A7 */
  0xD6A8,   /* U+56A8 */
  0xD6A9,   /* U+56A9 */
  0xD6AA,   /* U+56AA */
  0xD6AB,   /* U+56AB */
  0xD6AC,   /* U+56AC */
  0xD6AD,   /* U+56AD */
  0x0000,   /* U+56AE */
  0xD6AF,   /* U+56AF */
  0xD6B0,   /* U+56B0 */
  0xD6B1,   /* U+56B1 */
  0xD6B2,   /* U+56B2 */
  0xD6B3,   /* U+56B3 */
  0x0000,   /* U+56B4 */
  0xD6B5,   /* U+56B5 */
  0x0000,   /* U+56B6 */
  0xD6B7,   /* U+56B7 */
  0xD6B8,   /* U+56B8 */
  0xD6B9,   /* U+56B9 */
  0xD6BA,   /* U+56BA */
  0xD6BB,   /* U+56BB */
  0x0000,   /* U+56BC */
  0xD6BD,   /* U+56BD */
  0xD6BE,   /* U+56BE */
  0xD6BF,   /* U+56BF */
  0x0000,   /* U+56C0 */
  0x0000,   /* U+56C1 */
  0x0000,   /* U+56C2 */
  0x0000,   /* U+56C3 */
  0xD6C4,   /* U+56C4 */
  0xD6C5,   /* U+56C5 */
  0xD6C6,   /* U+56C6 */
  0xD6C7,   /* U+56C7 */
  0x0000,   /* U+56C8 */
  0xD6C9,   /* U+56C9 */
  0xD6CA,   /* U+56CA */
  0xD6CB,   /* U+56CB */
  0xD6CC,   /* U+56CC */
  0xD6CD,   /* U+56CD */
  0x0000,   /* U+56CE */
  0xD6CF,   /* U+56CF */
  0xD6D0,   /* U+56D0 */
  0x0000,   /* U+56D1 */
  0xD6D2,   /* U+56D2 */
  0x0000,   /* U+56D3 */
  0xD6D4,   /* U+56D4 */
  0xD6D5,   /* U+56D5 */
  0xD6D6,   /* U+56D6 */
  0x0000,   /* U+56D7 */
  0x0000,   /* U+56D8 */
  0xD6D9,   /* U+56D9 */
  0x0000,   /* U+56DA */
  0x0000,   /* U+56DB */
  0xD6DC,   /* U+56DC */
  0xD6DD,   /* U+56DD */
  0x0000,   /* U+56DE */
  0xD6DF,   /* U+56DF */
  0x0000,   /* U+56E0 */
  0xD6E1,   /* U+56E1 */
  0xD6E2,   /* U+56E2 */
  0x0000,   /* U+56E3 */
  0xD6E4,   /* U+56E4 */
  0xD6E5,   /* U+56E5 */
  0xD6E6,   /* U+56E6 */
  0xD6E7,   /* U+56E7 */
  0xD6E8,   /* U+56E8 */
  0xD6E9,   /* U+56E9 */
  0xD6EA,   /* U+56EA */
  0xD6EB,   /* U+56EB */
  0xD6EC,   /* U+56EC */
  0xD6ED,   /* U+56ED */
  0x0000,   /* U+56EE */
  0xD6EF,   /* U+56EF */
  0x0000,   /* U+56F0 */
  0xD6F1,   /* U+56F1 */
  0x0000,   /* U+56F2 */
  0x0000,   /* U+56F3 */
  0xD6F4,   /* U+56F4 */
  0xD6F5,   /* U+56F5 */
  0xD6F6,   /* U+56F6 */
  0xD6F7,   /* U+56F7 */
  0xD6F8,   /* U+56F8 */
  0x0000,   /* U+56F9 */
  0x0000,   /* U+56FA */
  0xD6FB,   /* U+56FB */
  0xD6FC,   /* U+56FC */
  0x0000,   /* U+56FD */
  0xD6FE,   /* U+56FE */
  0x0000,   /* U+56FF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+5600 */
  0x0000,   /* U+5601 */
  0x0000,   /* U+5602 */
  0x0000,   /* U+5603 */
  0x0000,   /* U+5604 */
  0x0000,   /* U+5605 */
  0x0000,   /* U+5606 */
  0x0000,   /* U+5607 */
  0x0000,   /* U+5608 */
  0x0000,   /* U+5609 */
  0x0000,   /* U+560A */
  0x0000,   /* U+560B */
  0x0000,   /* U+560C */
  0x0000,   /* U+560D */
  0x0000,   /* U+560E */
  0x0000,   /* U+560F */
  0x0000,   /* U+5610 */
  0x0000,   /* U+5611 */
  0x0000,   /* U+5612 */
  0x0000,   /* U+5613 */
  0x0000,   /* U+5614 */
  0x0000,   /* U+5615 */
  0x0000,   /* U+5616 */
  0x0000,   /* U+5617 */
  0x0000,   /* U+5618 */
  0x0000,   /* U+5619 */
  0x0000,   /* U+561A */
  0x0000,   /* U+561B */
  0x0000,   /* U+561C */
  0x0000,   /* U+561D */
  0x0000,   /* U+561E */
  0x0000,   /* U+561F */
  0x0000,   /* U+5620 */
  0x0000,   /* U+5621 */
  0x0000,   /* U+5622 */
  0x0000,   /* U+5623 */
  0x0000,   /* U+5624 */
  0x0000,   /* U+5625 */
  0x0000,   /* U+5626 */
  0x0000,   /* U+5627 */
  0x0000,   /* U+5628 */
  0x0000,   /* U+5629 */
  0x0000,   /* U+562A */
  0x0000,   /* U+562B */
  0x0000,   /* U+562C */
  0x0000,   /* U+562D */
  0x0000,   /* U+562E */
  0x0000,   /* U+562F */
  0x0000,   /* U+5630 */
  0x0000,   /* U+5631 */
  0x0000,   /* U+5632 */
  0x0000,   /* U+5633 */
  0x0000,   /* U+5634 */
  0x0000,   /* U+5635 */
  0x0000,   /* U+5636 */
  0x0000,   /* U+5637 */
  0x0000,   /* U+5638 */
  0x0000,   /* U+5639 */
  0x0000,   /* U+563A */
  0x0000,   /* U+563B */
  0x0000,   /* U+563C */
  0x0000,   /* U+563D */
  0x0000,   /* U+563E */
  0x0000,   /* U+563F */
  0x0000,   /* U+5640 */
  0x0000,   /* U+5641 */
  0x0000,   /* U+5642 */
  0x0000,   /* U+5643 */
  0x0000,   /* U+5644 */
  0x0000,   /* U+5645 */
  0x0000,   /* U+5646 */
  0x0000,   /* U+5647 */
  0x0000,   /* U+5648 */
  0x0000,   /* U+5649 */
  0x0000,   /* U+564A */
  0x0000,   /* U+564B */
  0x0000,   /* U+564C */
  0x0000,   /* U+564D */
  0x0000,   /* U+564E */
  0x0000,   /* U+564F */
  0x0000,   /* U+5650 */
  0x0000,   /* U+5651 */
  0x0000,   /* U+5652 */
  0x0000,   /* U+5653 */
  0x0000,   /* U+5654 */
  0x0000,   /* U+5655 */
  0x0000,   /* U+5656 */
  0x0000,   /* U+5657 */
  0x0000,   /* U+5658 */
  0x0000,   /* U+5659 */
  0x0000,   /* U+565A */
  0x0000,   /* U+565B */
  0x0000,   /* U+565C */
  0x0000,   /* U+565D */
  0x0000,   /* U+565E */
  0x0000,   /* U+565F */
  0x0000,   /* U+5660 */
  0x0000,   /* U+5661 */
  0x0000,   /* U+5662 */
  0x0000,   /* U+5663 */
  0x0000,   /* U+5664 */
  0x0000,   /* U+5665 */
  0x0000,   /* U+5666 */
  0x0000,   /* U+5667 */
  0x0000,   /* U+5668 */
  0x0000,   /* U+5669 */
  0x0000,   /* U+566A */
  0x0000,   /* U+566B */
  0x0000,   /* U+566C */
  0x0000,   /* U+566D */
  0x0000,   /* U+566E */
  0x0000,   /* U+566F */
  0x0000,   /* U+5670 */
  0x0000,   /* U+5671 */
  0x0000,   /* U+5672 */
  0x0000,   /* U+5673 */
  0x0000,   /* U+5674 */
  0x0000,   /* U+5675 */
  0x0000,   /* U+5676 */
  0x0000,   /* U+5677 */
  0x0000,   /* U+5678 */
  0x0000,   /* U+5679 */
  0x0000,   /* U+567A */
  0x0000,   /* U+567B */
  0x0000,   /* U+567C */
  0x0000,   /* U+567D */
  0x0000,   /* U+567E */
  0x0000,   /* U+567F */
  0x0000,   /* U+5680 */
  0x0000,   /* U+5681 */
  0x0000,   /* U+5682 */
  0x0000,   /* U+5683 */
  0x0000,   /* U+5684 */
  0x0000,   /* U+5685 */
  0x0000,   /* U+5686 */
  0x0000,   /* U+5687 */
  0x0000,   /* U+5688 */
  0x0000,   /* U+5689 */
  0x0000,   /* U+568A */
  0x0000,   /* U+568B */
  0x0000,   /* U+568C */
  0x0000,   /* U+568D */
  0x0000,   /* U+568E */
  0x0000,   /* U+568F */
  0x0000,   /* U+5690 */
  0x0000,   /* U+5691 */
  0x0000,   /* U+5692 */
  0x0000,   /* U+5693 */
  0x0000,   /* U+5694 */
  0x0000,   /* U+5695 */
  0x0000,   /* U+5696 */
  0x0000,   /* U+5697 */
  0x0000,   /* U+5698 */
  0x0000,   /* U+5699 */
  0x0000,   /* U+569A */
  0x0000,   /* U+569B */
  0x0000,   /* U+569C */
  0x0000,   /* U+569D */
  0x0000,   /* U+569E */
  0x0000,   /* U+569F */
  0x0000,   /* U+56A0 */
  0x0000,   /* U+56A1 */
  0x0000,   /* U+56A2 */
  0x0000,   /* U+56A3 */
  0x0000,   /* U+56A4 */
  0x0000,   /* U+56A5 */
  0x0000,   /* U+56A6 */
  0x0000,   /* U+56A7 */
  0x0000,   /* U+56A8 */
  0x0000,   /* U+56A9 */
  0x0000,   /* U+56AA */
  0x0000,   /* U+56AB */
  0x0000,   /* U+56AC */
  0x0000,   /* U+56AD */
  0x0000,   /* U+56AE */
  0x0000,   /* U+56AF */
  0x0000,   /* U+56B0 */
  0x0000,   /* U+56B1 */
  0x0000,   /* U+56B2 */
  0x0000,   /* U+56B3 */
  0x0000,   /* U+56B4 */
  0x0000,   /* U+56B5 */
  0x0000,   /* U+56B6 */
  0x0000,   /* U+56B7 */
  0x0000,   /* U+56B8 */
  0x0000,   /* U+56B9 */
  0x0000,   /* U+56BA */
  0x0000,   /* U+56BB */
  0x0000,   /* U+56BC */
  0x0000,   /* U+56BD */
  0x0000,   /* U+56BE */
  0x0000,   /* U+56BF */
  0x0000,   /* U+56C0 */
  0x0000,   /* U+56C1 */
  0x0000,   /* U+56C2 */
  0x0000,   /* U+56C3 */
  0x0000,   /* U+56C4 */
  0x0000,   /* U+56C5 */
  0x0000,   /* U+56C6 */
  0x0000,   /* U+56C7 */
  0x0000,   /* U+56C8 */
  0x0000,   /* U+56C9 */
  0x0000,   /* U+56CA */
  0x0000,   /* U+56CB */
  0x0000,   /* U+56CC */
  0x0000,   /* U+56CD */
  0x0000,   /* U+56CE */
  0x0000,   /* U+56CF */
  0x0000,   /* U+56D0 */
  0x0000,   /* U+56D1 */
  0x0000,   /* U+56D2 */
  0x0000,   /* U+56D3 */
  0x0000,   /* U+56D4 */
  0x0000,   /* U+56D5 */
  0x0000,   /* U+56D6 */
  0x0000,   /* U+56D7 */
  0x0000,   /* U+56D8 */
  0x0000,   /* U+56D9 */
  0x0000,   /* U+56DA */
  0x0000,   /* U+56DB */
  0x0000,   /* U+56DC */
  0x0000,   /* U+56DD */
  0x0000,   /* U+56DE */
  0x0000,   /* U+56DF */
  0x0000,   /* U+56E0 */
  0x0000,   /* U+56E1 */
  0x0000,   /* U+56E2 */
  0x0000,   /* U+56E3 */
  0x0000,   /* U+56E4 */
  0x0000,   /* U+56E5 */
  0x0000,   /* U+56E6 */
  0x0000,   /* U+56E7 */
  0x0000,   /* U+56E8 */
  0x0000,   /* U+56E9 */
  0x0000,   /* U+56EA */
  0x0000,   /* U+56EB */
  0x0000,   /* U+56EC */
  0x0000,   /* U+56ED */
  0x0000,   /* U+56EE */
  0x0000,   /* U+56EF */
  0x0000,   /* U+56F0 */
  0x0000,   /* U+56F1 */
  0x0000,   /* U+56F2 */
  0x0000,   /* U+56F3 */
  0x0000,   /* U+56F4 */
  0x0000,   /* U+56F5 */
  0x0000,   /* U+56F6 */
  0x0000,   /* U+56F7 */
  0x0000,   /* U+56F8 */
  0x0000,   /* U+56F9 */
  0x0000,   /* U+56FA */
  0x0000,   /* U+56FB */
  0x0000,   /* U+56FC */
  0x0000,   /* U+56FD */
  0x0000,   /* U+56FE */
  0x0000,   /* U+56FF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+5600 */
  0x0000,   /* U+5601 */
  0x0000,   /* U+5602 */
  0x0000,   /* U+5603 */
  0x0000,   /* U+5604 */
  0x0000,   /* U+5605 */
  0x0000,   /* U+5606 */
  0x0000,   /* U+5607 */
  0x0000,   /* U+5608 */
  0x0000,   /* U+5609 */
  0x0000,   /* U+560A */
  0x0000,   /* U+560B */
  0x0000,   /* U+560C */
  0x0000,   /* U+560D */
  0x0000,   /* U+560E */
  0x0000,   /* U+560F */
  0x0000,   /* U+5610 */
  0x0000,   /* U+5611 */
  0x0000,   /* U+5612 */
  0x0000,   /* U+5613 */
  0x0000,   /* U+5614 */
  0x0000,   /* U+5615 */
  0x0000,   /* U+5616 */
  0x0000,   /* U+5617 */
  0x0000,   /* U+5618 */
  0x0000,   /* U+5619 */
  0x0000,   /* U+561A */
  0x0000,   /* U+561B */
  0x0000,   /* U+561C */
  0x0000,   /* U+561D */
  0x0000,   /* U+561E */
  0x0000,   /* U+561F */
  0x0000,   /* U+5620 */
  0x0000,   /* U+5621 */
  0x0000,   /* U+5622 */
  0x0000,   /* U+5623 */
  0x0000,   /* U+5624 */
  0x0000,   /* U+5625 */
  0x0000,   /* U+5626 */
  0x0000,   /* U+5627 */
  0x0000,   /* U+5628 */
  0x0000,   /* U+5629 */
  0x0000,   /* U+562A */
  0x0000,   /* U+562B */
  0x0000,   /* U+562C */
  0x0000,   /* U+562D */
  0x0000,   /* U+562E */
  0x0000,   /* U+562F */
  0x0000,   /* U+5630 */
  0x0000,   /* U+5631 */
  0x0000,   /* U+5632 */
  0x0000,   /* U+5633 */
  0x0000,   /* U+5634 */
  0x0000,   /* U+5635 */
  0x0000,   /* U+5636 */
  0x0000,   /* U+5637 */
  0x0000,   /* U+5638 */
  0x0000,   /* U+5639 */
  0x0000,   /* U+563A */
  0x0000,   /* U+563B */
  0x0000,   /* U+563C */
  0x0000,   /* U+563D */
  0x0000,   /* U+563E */
  0x0000,   /* U+563F */
  0x0000,   /* U+5640 */
  0x0000,   /* U+5641 */
  0x0000,   /* U+5642 */
  0x0000,   /* U+5643 */
  0x0000,   /* U+5644 */
  0x0000,   /* U+5645 */
  0x0000,   /* U+5646 */
  0x0000,   /* U+5647 */
  0x0000,   /* U+5648 */
  0x0000,   /* U+5649 */
  0x0000,   /* U+564A */
  0x0000,   /* U+564B */
  0x0000,   /* U+564C */
  0x0000,   /* U+564D */
  0x0000,   /* U+564E */
  0x0000,   /* U+564F */
  0x0000,   /* U+5650 */
  0x0000,   /* U+5651 */
  0x0000,   /* U+5652 */
  0x0000,   /* U+5653 */
  0x0000,   /* U+5654 */
  0x0000,   /* U+5655 */
  0x0000,   /* U+5656 */
  0x0000,   /* U+5657 */
  0x0000,   /* U+5658 */
  0x0000,   /* U+5659 */
  0x0000,   /* U+565A */
  0x0000,   /* U+565B */
  0x0000,   /* U+565C */
  0x0000,   /* U+565D */
  0x0000,   /* U+565E */
  0x0000,   /* U+565F */
  0x0000,   /* U+5660 */
  0x0000,   /* U+5661 */
  0x0000,   /* U+5662 */
  0x0000,   /* U+5663 */
  0x0000,   /* U+5664 */
  0x0000,   /* U+5665 */
  0x0000,   /* U+5666 */
  0x0000,   /* U+5667 */
  0x0000,   /* U+5668 */
  0x0000,   /* U+5669 */
  0x0000,   /* U+566A */
  0x0000,   /* U+566B */
  0x0000,   /* U+566C */
  0x0000,   /* U+566D */
  0x0000,   /* U+566E */
  0x0000,   /* U+566F */
  0x0000,   /* U+5670 */
  0x0000,   /* U+5671 */
  0x0000,   /* U+5672 */
  0x0000,   /* U+5673 */
  0x0000,   /* U+5674 */
  0x0000,   /* U+5675 */
  0x0000,   /* U+5676 */
  0x0000,   /* U+5677 */
  0x0000,   /* U+5678 */
  0x0000,   /* U+5679 */
  0x0000,   /* U+567A */
  0x0000,   /* U+567B */
  0x0000,   /* U+567C */
  0x0000,   /* U+567D */
  0x0000,   /* U+567E */
  0x0000,   /* U+567F */
  0x0000,   /* U+5680 */
  0x0000,   /* U+5681 */
  0x0000,   /* U+5682 */
  0x0000,   /* U+5683 */
  0x0000,   /* U+5684 */
  0x0000,   /* U+5685 */
  0x0000,   /* U+5686 */
  0x0000,   /* U+5687 */
  0x0000,   /* U+5688 */
  0x0000,   /* U+5689 */
  0x0000,   /* U+568A */
  0x0000,   /* U+568B */
  0x0000,   /* U+568C */
  0x0000,   /* U+568D */
  0x0000,   /* U+568E */
  0x0000,   /* U+568F */
  0x0000,   /* U+5690 */
  0x0000,   /* U+5691 */
  0x0000,   /* U+5692 */
  0x0000,   /* U+5693 */
  0x0000,   /* U+5694 */
  0x0000,   /* U+5695 */
  0x0000,   /* U+5696 */
  0x0000,   /* U+5697 */
  0x0000,   /* U+5698 */
  0x0000,   /* U+5699 */
  0x0000,   /* U+569A */
  0x0000,   /* U+569B */
  0x0000,   /* U+569C */
  0x0000,   /* U+569D */
  0x0000,   /* U+569E */
  0x0000,   /* U+569F */
  0x0000,   /* U+56A0 */
  0x0000,   /* U+56A1 */
  0x0000,   /* U+56A2 */
  0x0000,   /* U+56A3 */
  0x0000,   /* U+56A4 */
  0x0000,   /* U+56A5 */
  0x0000,   /* U+56A6 */
  0x0000,   /* U+56A7 */
  0x0000,   /* U+56A8 */
  0x0000,   /* U+56A9 */
  0x0000,   /* U+56AA */
  0x0000,   /* U+56AB */
  0x0000,   /* U+56AC */
  0x0000,   /* U+56AD */
  0x0000,   /* U+56AE */
  0x0000,   /* U+56AF */
  0x0000,   /* U+56B0 */
  0x0000,   /* U+56B1 */
  0x0000,   /* U+56B2 */
  0x0000,   /* U+56B3 */
  0x0000,   /* U+56B4 */
  0x0000,   /* U+56B5 */
  0x0000,   /* U+56B6 */
  0x0000,   /* U+56B7 */
  0x0000,   /* U+56B8 */
  0x0000,   /* U+56B9 */
  0x0000,   /* U+56BA */
  0x0000,   /* U+56BB */
  0x0000,   /* U+56BC */
  0x0000,   /* U+56BD */
  0x0000,   /* U+56BE */
  0x0000,   /* U+56BF */
  0x0000,   /* U+56C0 */
  0x0000,   /* U+56C1 */
  0x0000,   /* U+56C2 */
  0x0000,   /* U+56C3 */
  0x0000,   /* U+56C4 */
  0x0000,   /* U+56C5 */
  0x0000,   /* U+56C6 */
  0x0000,   /* U+56C7 */
  0x0000,   /* U+56C8 */
  0x0000,   /* U+56C9 */
  0x0000,   /* U+56CA */
  0x0000,   /* U+56CB */
  0x0000,   /* U+56CC */
  0x0000,   /* U+56CD */
  0x0000,   /* U+56CE */
  0x0000,   /* U+56CF */
  0x0000,   /* U+56D0 */
  0x0000,   /* U+56D1 */
  0x0000,   /* U+56D2 */
  0x0000,   /* U+56D3 */
  0x0000,   /* U+56D4 */
  0x0000,   /* U+56D5 */
  0x0000,   /* U+56D6 */
  0x0000,   /* U+56D7 */
  0x0000,   /* U+56D8 */
  0x0000,   /* U+56D9 */
  0x0000,   /* U+56DA */
  0x0000,   /* U+56DB */
  0x0000,   /* U+56DC */
  0x0000,   /* U+56DD */
  0x0000,   /* U+56DE */
  0x0000,   /* U+56DF */
  0x0000,   /* U+56E0 */
  0x0000,   /* U+56E1 */
  0x0000,   /* U+56E2 */
  0x0000,   /* U+56E3 */
  0x0000,   /* U+56E4 */
  0x0000,   /* U+56E5 */
  0x0000,   /* U+56E6 */
  0x0000,   /* U+56E7 */
  0x0000,   /* U+56E8 */
  0x0000,   /* U+56E9 */
  0x0000,   /* U+56EA */
  0x0000,   /* U+56EB */
  0x0000,   /* U+56EC */
  0x0000,   /* U+56ED */
  0x0000,   /* U+56EE */
  0x0000,   /* U+56EF */
  0x0000,   /* U+56F0 */
  0x0000,   /* U+56F1 */
  0x0000,   /* U+56F2 */
  0x0000,   /* U+56F3 */
  0x0000,   /* U+56F4 */
  0x0000,   /* U+56F5 */
  0x0000,   /* U+56F6 */
  0x0000,   /* U+56F7 */
  0x0000,   /* U+56F8 */
  0x0000,   /* U+56F9 */
  0x0000,   /* U+56FA */
  0x0000,   /* U+56FB */
  0x0000,   /* U+56FC */
  0x0000,   /* U+56FD */
  0x0000,   /* U+56FE */
  0x0000,   /* U+56FF */
};

uint16 ja_han_page57[]= {
  /* Number of CEs for each character. */
  1, 2, 2, 1, 1, 2, 2, 2, 1, 1, 2, 1, 2, 1, 2, 1,
  2, 2, 1, 1, 2, 2, 1, 2, 1, 2, 2, 2, 1, 2, 2, 1,
  2, 2, 2, 2, 2, 2, 1, 1, 1, 2, 2, 2, 2, 1, 2, 2,
  1, 2, 2, 2, 2, 2, 2, 1, 1, 2, 2, 1, 2, 2, 2, 2,
  1, 2, 1, 2, 2, 2, 2, 1, 2, 2, 1, 2, 2, 2, 1, 1,
  1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 1, 2, 2, 1, 2, 1, 2, 2, 1, 1, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1,
  2, 2, 1, 2, 2, 2, 2, 2, 1, 1, 2, 1, 2, 2, 2, 2,
  2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  1, 2, 1, 1, 1, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2,
  1, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  1, 2, 2, 1, 2, 2, 1, 2, 2, 2, 2, 1, 2, 2, 1, 2,
  2, 2, 1, 1, 1, 2, 1, 2, 2, 2, 2, 2, 1, 2, 2, 1,
  1, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 1, 2, 2, 1, 2, 1, 1, 2, 1, 2, 2, 2,

  /* Primary weight 1 for each character. */
  0x61AD,   /* U+5700 */
  0xFB40,   /* U+5701 */
  0xFB40,   /* U+5702 */
  0x5E6F,   /* U+5703 */
  0x61AF,   /* U+5704 */
  0xFB40,   /* U+5705 */
  0xFB40,   /* U+5706 */
  0xFB40,   /* U+5707 */
  0x61B1,   /* U+5708 */
  0x61B0,   /* U+5709 */
  0xFB40,   /* U+570A */
  0x61B2,   /* U+570B */
  0xFB40,   /* U+570C */
  0x61B3,   /* U+570D */
  0xFB40,   /* U+570E */
  0x578C,   /* U+570F */
  0xFB40,   /* U+5710 */
  0xFB40,   /* U+5711 */
  0x5541,   /* U+5712 */
  0x61B4,   /* U+5713 */
  0xFB40,   /* U+5714 */
  0xFB40,   /* U+5715 */
  0x61B6,   /* U+5716 */
  0xFB40,   /* U+5717 */
  0x61B5,   /* U+5718 */
  0xFB40,   /* U+5719 */
  0xFB40,   /* U+571A */
  0xFB40,   /* U+571B */
  0x61B8,   /* U+571C */
  0xFB40,   /* U+571D */
  0xFB40,   /* U+571E */
  0x5C93,   /* U+571F */
  0xFB40,   /* U+5720 */
  0xFB40,   /* U+5721 */
  0xFB40,   /* U+5722 */
  0xFB40,   /* U+5723 */
  0xFB40,   /* U+5724 */
  0xFB40,   /* U+5725 */
  0x61B9,   /* U+5726 */
  0x54B8,   /* U+5727 */
  0x588E,   /* U+5728 */
  0xFB40,   /* U+5729 */
  0xFB40,   /* U+572A */
  0xFB40,   /* U+572B */
  0xFB40,   /* U+572C */
  0x5752,   /* U+572D */
  0xFB40,   /* U+572E */
  0xFB40,   /* U+572F */
  0x5BCC,   /* U+5730 */
  0xFB40,   /* U+5731 */
  0xFB40,   /* U+5732 */
  0xFB40,   /* U+5733 */
  0xFB40,   /* U+5734 */
  0xFB40,   /* U+5735 */
  0xFB40,   /* U+5736 */
  0x61BA,   /* U+5737 */
  0x61BB,   /* U+5738 */
  0xFB40,   /* U+5739 */
  0xFB40,   /* U+573A */
  0x61BD,   /* U+573B */
  0xFB40,   /* U+573C */
  0xFB40,   /* U+573D */
  0xFB40,   /* U+573E */
  0xFB40,   /* U+573F */
  0x61BE,   /* U+5740 */
  0xFB40,   /* U+5741 */
  0x5893,   /* U+5742 */
  0xFB40,   /* U+5743 */
  0xFB40,   /* U+5744 */
  0xFB40,   /* U+5745 */
  0xFB40,   /* U+5746 */
  0x5708,   /* U+5747 */
  0xFB40,   /* U+5748 */
  0xFB40,   /* U+5749 */
  0x5EA4,   /* U+574A */
  0xFB40,   /* U+574B */
  0xFB40,   /* U+574C */
  0xFB40,   /* U+574D */
  0x61BC,   /* U+574E */
  0x61BF,   /* U+574F */
  0x5870,   /* U+5750 */
  0x57F4,   /* U+5751 */
  0xFB40,   /* U+5752 */
  0xFB40,   /* U+5753 */
  0xFB40,   /* U+5754 */
  0xFB40,   /* U+5755 */
  0xFB40,   /* U+5756 */
  0xFB40,   /* U+5757 */
  0xFB40,   /* U+5758 */
  0xFB40,   /* U+5759 */
  0xFB40,   /* U+575A */
  0xFB40,   /* U+575B */
  0xFB40,   /* U+575C */
  0xFB40,   /* U+575D */
  0xFB40,   /* U+575E */
  0xFB40,   /* U+575F */
  0xFB40,   /* U+5760 */
  0x61C3,   /* U+5761 */
  0xFB40,   /* U+5762 */
  0xFB40,   /* U+5763 */
  0x5854,   /* U+5764 */
  0xFB40,   /* U+5765 */
  0x5BB0,   /* U+5766 */
  0xFB40,   /* U+5767 */
  0xFB40,   /* U+5768 */
  0x61C0,   /* U+5769 */
  0x5C35,   /* U+576A */
  0xFB40,   /* U+576B */
  0xFB40,   /* U+576C */
  0xFB40,   /* U+576D */
  0xFB40,   /* U+576E */
  0xFB40,   /* U+576F */
  0xFB40,   /* U+5770 */
  0xFB40,   /* U+5771 */
  0xFB40,   /* U+5772 */
  0xFB40,   /* U+5773 */
  0xFB40,   /* U+5774 */
  0xFB40,   /* U+5775 */
  0xFB40,   /* U+5776 */
  0xFB40,   /* U+5777 */
  0xFB40,   /* U+5778 */
  0xFB40,   /* U+5779 */
  0xFB40,   /* U+577A */
  0xFB40,   /* U+577B */
  0xFB40,   /* U+577C */
  0xFB40,   /* U+577D */
  0xFB40,   /* U+577E */
  0x61C4,   /* U+577F */
  0xFB40,   /* U+5780 */
  0xFB40,   /* U+5781 */
  0x5A67,   /* U+5782 */
  0xFB40,   /* U+5783 */
  0xFB40,   /* U+5784 */
  0xFB40,   /* U+5785 */
  0xFB40,   /* U+5786 */
  0xFB40,   /* U+5787 */
  0x61C2,   /* U+5788 */
  0x61C5,   /* U+5789 */
  0xFB40,   /* U+578A */
  0x5754,   /* U+578B */
  0xFB40,   /* U+578C */
  0xFB40,   /* U+578D */
  0xFB40,   /* U+578E */
  0xFB40,   /* U+578F */
  0xFB40,   /* U+5790 */
  0xFB40,   /* U+5791 */
  0xFB40,   /* U+5792 */
  0x61C6,   /* U+5793 */
  0xFB40,   /* U+5794 */
  0xFB40,   /* U+5795 */
  0xFB40,   /* U+5796 */
  0xFB40,   /* U+5797 */
  0xFB40,   /* U+5798 */
  0xFB40,   /* U+5799 */
  0xFB40,   /* U+579A */
  0xFB40,   /* U+579B */
  0xFB40,   /* U+579C */
  0xFB40,   /* U+579D */
  0xFB40,   /* U+579E */
  0xFB40,   /* U+579F */
  0x61C7,   /* U+57A0 */
  0xFB40,   /* U+57A1 */
  0x57F5,   /* U+57A2 */
  0x55DD,   /* U+57A3 */
  0x61C9,   /* U+57A4 */
  0xFB40,   /* U+57A5 */
  0xFB40,   /* U+57A6 */
  0xFB40,   /* U+57A7 */
  0xFB40,   /* U+57A8 */
  0xFB40,   /* U+57A9 */
  0x61CA,   /* U+57AA */
  0xFB40,   /* U+57AB */
  0xFB40,   /* U+57AC */
  0xFB40,   /* U+57AD */
  0xFB40,   /* U+57AE */
  0xFB40,   /* U+57AF */
  0x61CB,   /* U+57B0 */
  0xFB40,   /* U+57B1 */
  0xFB40,   /* U+57B2 */
  0x61C8,   /* U+57B3 */
  0xFB40,   /* U+57B4 */
  0xFB40,   /* U+57B5 */
  0xFB40,   /* U+57B6 */
  0xFB40,   /* U+57B7 */
  0xFB40,   /* U+57B8 */
  0xFB40,   /* U+57B9 */
  0xFB40,   /* U+57BA */
  0xFB40,   /* U+57BB */
  0xFB40,   /* U+57BC */
  0xFB40,   /* U+57BD */
  0xFB40,   /* U+57BE */
  0xFB40,   /* U+57BF */
  0x61C1,   /* U+57C0 */
  0xFB40,   /* U+57C1 */
  0xFB40,   /* U+57C2 */
  0x61CC,   /* U+57C3 */
  0xFB40,   /* U+57C4 */
  0xFB40,   /* U+57C5 */
  0x61CD,   /* U+57C6 */
  0xFB40,   /* U+57C7 */
  0xFB40,   /* U+57C8 */
  0xFB40,   /* U+57C9 */
  0xFB40,   /* U+57CA */
  0x5ED1,   /* U+57CB */
  0xFB40,   /* U+57CC */
  0xFB40,   /* U+57CD */
  0x5A12,   /* U+57CE */
  0xFB40,   /* U+57CF */
  0xFB40,   /* U+57D0 */
  0xFB40,   /* U+57D1 */
  0x61CF,   /* U+57D2 */
  0x61D0,   /* U+57D3 */
  0x61CE,   /* U+57D4 */
  0xFB40,   /* U+57D5 */
  0x61D2,   /* U+57D6 */
  0xFB40,   /* U+57D7 */
  0xFB40,   /* U+57D8 */
  0xFB40,   /* U+57D9 */
  0xFB40,   /* U+57DA */
  0xFB40,   /* U+57DB */
  0x5D2D,   /* U+57DC */
  0xFB40,   /* U+57DD */
  0xFB40,   /* U+57DE */
  0x54EB,   /* U+57DF */
  0x5E07,   /* U+57E0 */
  0xFB40,   /* U+57E1 */
  0xFB40,   /* U+57E2 */
  0x61D3,   /* U+57E3 */
  0xFB40,   /* U+57E4 */
  0xFB40,   /* U+57E5 */
  0xFB40,   /* U+57E6 */
  0xFB40,   /* U+57E7 */
  0xFB40,   /* U+57E8 */
  0xFB40,   /* U+57E9 */
  0xFB40,   /* U+57EA */
  0xFB40,   /* U+57EB */
  0xFB40,   /* U+57EC */
  0xFB40,   /* U+57ED */
  0xFB40,   /* U+57EE */
  0xFB40,   /* U+57EF */
  0xFB40,   /* U+57F0 */
  0xFB40,   /* U+57F1 */
  0xFB40,   /* U+57F2 */
  0xFB40,   /* U+57F3 */
  0x5A24,   /* U+57F4 */
  0xFB40,   /* U+57F5 */
  0xFB40,   /* U+57F6 */
  0x5924,   /* U+57F7 */
  0xFB40,   /* U+57F8 */
  0x5D52,   /* U+57F9 */
  0x566B,   /* U+57FA */
  0xFB40,   /* U+57FB */
  0x589A,   /* U+57FC */
  0xFB40,   /* U+57FD */
  0xFB40,   /* U+57FE */
  0xFB40,   /* U+57FF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+5700 */
  0x0020,   /* U+5701 */
  0x0020,   /* U+5702 */
  0x0020,   /* U+5703 */
  0x0020,   /* U+5704 */
  0x0020,   /* U+5705 */
  0x0020,   /* U+5706 */
  0x0020,   /* U+5707 */
  0x0020,   /* U+5708 */
  0x0020,   /* U+5709 */
  0x0020,   /* U+570A */
  0x0020,   /* U+570B */
  0x0020,   /* U+570C */
  0x0020,   /* U+570D */
  0x0020,   /* U+570E */
  0x0020,   /* U+570F */
  0x0020,   /* U+5710 */
  0x0020,   /* U+5711 */
  0x0020,   /* U+5712 */
  0x0020,   /* U+5713 */
  0x0020,   /* U+5714 */
  0x0020,   /* U+5715 */
  0x0020,   /* U+5716 */
  0x0020,   /* U+5717 */
  0x0020,   /* U+5718 */
  0x0020,   /* U+5719 */
  0x0020,   /* U+571A */
  0x0020,   /* U+571B */
  0x0020,   /* U+571C */
  0x0020,   /* U+571D */
  0x0020,   /* U+571E */
  0x0020,   /* U+571F */
  0x0020,   /* U+5720 */
  0x0020,   /* U+5721 */
  0x0020,   /* U+5722 */
  0x0020,   /* U+5723 */
  0x0020,   /* U+5724 */
  0x0020,   /* U+5725 */
  0x0020,   /* U+5726 */
  0x0020,   /* U+5727 */
  0x0020,   /* U+5728 */
  0x0020,   /* U+5729 */
  0x0020,   /* U+572A */
  0x0020,   /* U+572B */
  0x0020,   /* U+572C */
  0x0020,   /* U+572D */
  0x0020,   /* U+572E */
  0x0020,   /* U+572F */
  0x0020,   /* U+5730 */
  0x0020,   /* U+5731 */
  0x0020,   /* U+5732 */
  0x0020,   /* U+5733 */
  0x0020,   /* U+5734 */
  0x0020,   /* U+5735 */
  0x0020,   /* U+5736 */
  0x0020,   /* U+5737 */
  0x0020,   /* U+5738 */
  0x0020,   /* U+5739 */
  0x0020,   /* U+573A */
  0x0020,   /* U+573B */
  0x0020,   /* U+573C */
  0x0020,   /* U+573D */
  0x0020,   /* U+573E */
  0x0020,   /* U+573F */
  0x0020,   /* U+5740 */
  0x0020,   /* U+5741 */
  0x0020,   /* U+5742 */
  0x0020,   /* U+5743 */
  0x0020,   /* U+5744 */
  0x0020,   /* U+5745 */
  0x0020,   /* U+5746 */
  0x0020,   /* U+5747 */
  0x0020,   /* U+5748 */
  0x0020,   /* U+5749 */
  0x0020,   /* U+574A */
  0x0020,   /* U+574B */
  0x0020,   /* U+574C */
  0x0020,   /* U+574D */
  0x0020,   /* U+574E */
  0x0020,   /* U+574F */
  0x0020,   /* U+5750 */
  0x0020,   /* U+5751 */
  0x0020,   /* U+5752 */
  0x0020,   /* U+5753 */
  0x0020,   /* U+5754 */
  0x0020,   /* U+5755 */
  0x0020,   /* U+5756 */
  0x0020,   /* U+5757 */
  0x0020,   /* U+5758 */
  0x0020,   /* U+5759 */
  0x0020,   /* U+575A */
  0x0020,   /* U+575B */
  0x0020,   /* U+575C */
  0x0020,   /* U+575D */
  0x0020,   /* U+575E */
  0x0020,   /* U+575F */
  0x0020,   /* U+5760 */
  0x0020,   /* U+5761 */
  0x0020,   /* U+5762 */
  0x0020,   /* U+5763 */
  0x0020,   /* U+5764 */
  0x0020,   /* U+5765 */
  0x0020,   /* U+5766 */
  0x0020,   /* U+5767 */
  0x0020,   /* U+5768 */
  0x0020,   /* U+5769 */
  0x0020,   /* U+576A */
  0x0020,   /* U+576B */
  0x0020,   /* U+576C */
  0x0020,   /* U+576D */
  0x0020,   /* U+576E */
  0x0020,   /* U+576F */
  0x0020,   /* U+5770 */
  0x0020,   /* U+5771 */
  0x0020,   /* U+5772 */
  0x0020,   /* U+5773 */
  0x0020,   /* U+5774 */
  0x0020,   /* U+5775 */
  0x0020,   /* U+5776 */
  0x0020,   /* U+5777 */
  0x0020,   /* U+5778 */
  0x0020,   /* U+5779 */
  0x0020,   /* U+577A */
  0x0020,   /* U+577B */
  0x0020,   /* U+577C */
  0x0020,   /* U+577D */
  0x0020,   /* U+577E */
  0x0020,   /* U+577F */
  0x0020,   /* U+5780 */
  0x0020,   /* U+5781 */
  0x0020,   /* U+5782 */
  0x0020,   /* U+5783 */
  0x0020,   /* U+5784 */
  0x0020,   /* U+5785 */
  0x0020,   /* U+5786 */
  0x0020,   /* U+5787 */
  0x0020,   /* U+5788 */
  0x0020,   /* U+5789 */
  0x0020,   /* U+578A */
  0x0020,   /* U+578B */
  0x0020,   /* U+578C */
  0x0020,   /* U+578D */
  0x0020,   /* U+578E */
  0x0020,   /* U+578F */
  0x0020,   /* U+5790 */
  0x0020,   /* U+5791 */
  0x0020,   /* U+5792 */
  0x0020,   /* U+5793 */
  0x0020,   /* U+5794 */
  0x0020,   /* U+5795 */
  0x0020,   /* U+5796 */
  0x0020,   /* U+5797 */
  0x0020,   /* U+5798 */
  0x0020,   /* U+5799 */
  0x0020,   /* U+579A */
  0x0020,   /* U+579B */
  0x0020,   /* U+579C */
  0x0020,   /* U+579D */
  0x0020,   /* U+579E */
  0x0020,   /* U+579F */
  0x0020,   /* U+57A0 */
  0x0020,   /* U+57A1 */
  0x0020,   /* U+57A2 */
  0x0020,   /* U+57A3 */
  0x0020,   /* U+57A4 */
  0x0020,   /* U+57A5 */
  0x0020,   /* U+57A6 */
  0x0020,   /* U+57A7 */
  0x0020,   /* U+57A8 */
  0x0020,   /* U+57A9 */
  0x0020,   /* U+57AA */
  0x0020,   /* U+57AB */
  0x0020,   /* U+57AC */
  0x0020,   /* U+57AD */
  0x0020,   /* U+57AE */
  0x0020,   /* U+57AF */
  0x0020,   /* U+57B0 */
  0x0020,   /* U+57B1 */
  0x0020,   /* U+57B2 */
  0x0020,   /* U+57B3 */
  0x0020,   /* U+57B4 */
  0x0020,   /* U+57B5 */
  0x0020,   /* U+57B6 */
  0x0020,   /* U+57B7 */
  0x0020,   /* U+57B8 */
  0x0020,   /* U+57B9 */
  0x0020,   /* U+57BA */
  0x0020,   /* U+57BB */
  0x0020,   /* U+57BC */
  0x0020,   /* U+57BD */
  0x0020,   /* U+57BE */
  0x0020,   /* U+57BF */
  0x0020,   /* U+57C0 */
  0x0020,   /* U+57C1 */
  0x0020,   /* U+57C2 */
  0x0020,   /* U+57C3 */
  0x0020,   /* U+57C4 */
  0x0020,   /* U+57C5 */
  0x0020,   /* U+57C6 */
  0x0020,   /* U+57C7 */
  0x0020,   /* U+57C8 */
  0x0020,   /* U+57C9 */
  0x0020,   /* U+57CA */
  0x0020,   /* U+57CB */
  0x0020,   /* U+57CC */
  0x0020,   /* U+57CD */
  0x0020,   /* U+57CE */
  0x0020,   /* U+57CF */
  0x0020,   /* U+57D0 */
  0x0020,   /* U+57D1 */
  0x0020,   /* U+57D2 */
  0x0020,   /* U+57D3 */
  0x0020,   /* U+57D4 */
  0x0020,   /* U+57D5 */
  0x0020,   /* U+57D6 */
  0x0020,   /* U+57D7 */
  0x0020,   /* U+57D8 */
  0x0020,   /* U+57D9 */
  0x0020,   /* U+57DA */
  0x0020,   /* U+57DB */
  0x0020,   /* U+57DC */
  0x0020,   /* U+57DD */
  0x0020,   /* U+57DE */
  0x0020,   /* U+57DF */
  0x0020,   /* U+57E0 */
  0x0020,   /* U+57E1 */
  0x0020,   /* U+57E2 */
  0x0020,   /* U+57E3 */
  0x0020,   /* U+57E4 */
  0x0020,   /* U+57E5 */
  0x0020,   /* U+57E6 */
  0x0020,   /* U+57E7 */
  0x0020,   /* U+57E8 */
  0x0020,   /* U+57E9 */
  0x0020,   /* U+57EA */
  0x0020,   /* U+57EB */
  0x0020,   /* U+57EC */
  0x0020,   /* U+57ED */
  0x0020,   /* U+57EE */
  0x0020,   /* U+57EF */
  0x0020,   /* U+57F0 */
  0x0020,   /* U+57F1 */
  0x0020,   /* U+57F2 */
  0x0020,   /* U+57F3 */
  0x0020,   /* U+57F4 */
  0x0020,   /* U+57F5 */
  0x0020,   /* U+57F6 */
  0x0020,   /* U+57F7 */
  0x0020,   /* U+57F8 */
  0x0020,   /* U+57F9 */
  0x0020,   /* U+57FA */
  0x0020,   /* U+57FB */
  0x0020,   /* U+57FC */
  0x0020,   /* U+57FD */
  0x0020,   /* U+57FE */
  0x0020,   /* U+57FF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+5700 */
  0x0002,   /* U+5701 */
  0x0002,   /* U+5702 */
  0x0002,   /* U+5703 */
  0x0002,   /* U+5704 */
  0x0002,   /* U+5705 */
  0x0002,   /* U+5706 */
  0x0002,   /* U+5707 */
  0x0002,   /* U+5708 */
  0x0002,   /* U+5709 */
  0x0002,   /* U+570A */
  0x0002,   /* U+570B */
  0x0002,   /* U+570C */
  0x0002,   /* U+570D */
  0x0002,   /* U+570E */
  0x0002,   /* U+570F */
  0x0002,   /* U+5710 */
  0x0002,   /* U+5711 */
  0x0002,   /* U+5712 */
  0x0002,   /* U+5713 */
  0x0002,   /* U+5714 */
  0x0002,   /* U+5715 */
  0x0002,   /* U+5716 */
  0x0002,   /* U+5717 */
  0x0002,   /* U+5718 */
  0x0002,   /* U+5719 */
  0x0002,   /* U+571A */
  0x0002,   /* U+571B */
  0x0002,   /* U+571C */
  0x0002,   /* U+571D */
  0x0002,   /* U+571E */
  0x0002,   /* U+571F */
  0x0002,   /* U+5720 */
  0x0002,   /* U+5721 */
  0x0002,   /* U+5722 */
  0x0002,   /* U+5723 */
  0x0002,   /* U+5724 */
  0x0002,   /* U+5725 */
  0x0002,   /* U+5726 */
  0x0002,   /* U+5727 */
  0x0002,   /* U+5728 */
  0x0002,   /* U+5729 */
  0x0002,   /* U+572A */
  0x0002,   /* U+572B */
  0x0002,   /* U+572C */
  0x0002,   /* U+572D */
  0x0002,   /* U+572E */
  0x0002,   /* U+572F */
  0x0002,   /* U+5730 */
  0x0002,   /* U+5731 */
  0x0002,   /* U+5732 */
  0x0002,   /* U+5733 */
  0x0002,   /* U+5734 */
  0x0002,   /* U+5735 */
  0x0002,   /* U+5736 */
  0x0002,   /* U+5737 */
  0x0002,   /* U+5738 */
  0x0002,   /* U+5739 */
  0x0002,   /* U+573A */
  0x0002,   /* U+573B */
  0x0002,   /* U+573C */
  0x0002,   /* U+573D */
  0x0002,   /* U+573E */
  0x0002,   /* U+573F */
  0x0002,   /* U+5740 */
  0x0002,   /* U+5741 */
  0x0002,   /* U+5742 */
  0x0002,   /* U+5743 */
  0x0002,   /* U+5744 */
  0x0002,   /* U+5745 */
  0x0002,   /* U+5746 */
  0x0002,   /* U+5747 */
  0x0002,   /* U+5748 */
  0x0002,   /* U+5749 */
  0x0002,   /* U+574A */
  0x0002,   /* U+574B */
  0x0002,   /* U+574C */
  0x0002,   /* U+574D */
  0x0002,   /* U+574E */
  0x0002,   /* U+574F */
  0x0002,   /* U+5750 */
  0x0002,   /* U+5751 */
  0x0002,   /* U+5752 */
  0x0002,   /* U+5753 */
  0x0002,   /* U+5754 */
  0x0002,   /* U+5755 */
  0x0002,   /* U+5756 */
  0x0002,   /* U+5757 */
  0x0002,   /* U+5758 */
  0x0002,   /* U+5759 */
  0x0002,   /* U+575A */
  0x0002,   /* U+575B */
  0x0002,   /* U+575C */
  0x0002,   /* U+575D */
  0x0002,   /* U+575E */
  0x0002,   /* U+575F */
  0x0002,   /* U+5760 */
  0x0002,   /* U+5761 */
  0x0002,   /* U+5762 */
  0x0002,   /* U+5763 */
  0x0002,   /* U+5764 */
  0x0002,   /* U+5765 */
  0x0002,   /* U+5766 */
  0x0002,   /* U+5767 */
  0x0002,   /* U+5768 */
  0x0002,   /* U+5769 */
  0x0002,   /* U+576A */
  0x0002,   /* U+576B */
  0x0002,   /* U+576C */
  0x0002,   /* U+576D */
  0x0002,   /* U+576E */
  0x0002,   /* U+576F */
  0x0002,   /* U+5770 */
  0x0002,   /* U+5771 */
  0x0002,   /* U+5772 */
  0x0002,   /* U+5773 */
  0x0002,   /* U+5774 */
  0x0002,   /* U+5775 */
  0x0002,   /* U+5776 */
  0x0002,   /* U+5777 */
  0x0002,   /* U+5778 */
  0x0002,   /* U+5779 */
  0x0002,   /* U+577A */
  0x0002,   /* U+577B */
  0x0002,   /* U+577C */
  0x0002,   /* U+577D */
  0x0002,   /* U+577E */
  0x0002,   /* U+577F */
  0x0002,   /* U+5780 */
  0x0002,   /* U+5781 */
  0x0002,   /* U+5782 */
  0x0002,   /* U+5783 */
  0x0002,   /* U+5784 */
  0x0002,   /* U+5785 */
  0x0002,   /* U+5786 */
  0x0002,   /* U+5787 */
  0x0002,   /* U+5788 */
  0x0002,   /* U+5789 */
  0x0002,   /* U+578A */
  0x0002,   /* U+578B */
  0x0002,   /* U+578C */
  0x0002,   /* U+578D */
  0x0002,   /* U+578E */
  0x0002,   /* U+578F */
  0x0002,   /* U+5790 */
  0x0002,   /* U+5791 */
  0x0002,   /* U+5792 */
  0x0002,   /* U+5793 */
  0x0002,   /* U+5794 */
  0x0002,   /* U+5795 */
  0x0002,   /* U+5796 */
  0x0002,   /* U+5797 */
  0x0002,   /* U+5798 */
  0x0002,   /* U+5799 */
  0x0002,   /* U+579A */
  0x0002,   /* U+579B */
  0x0002,   /* U+579C */
  0x0002,   /* U+579D */
  0x0002,   /* U+579E */
  0x0002,   /* U+579F */
  0x0002,   /* U+57A0 */
  0x0002,   /* U+57A1 */
  0x0002,   /* U+57A2 */
  0x0002,   /* U+57A3 */
  0x0002,   /* U+57A4 */
  0x0002,   /* U+57A5 */
  0x0002,   /* U+57A6 */
  0x0002,   /* U+57A7 */
  0x0002,   /* U+57A8 */
  0x0002,   /* U+57A9 */
  0x0002,   /* U+57AA */
  0x0002,   /* U+57AB */
  0x0002,   /* U+57AC */
  0x0002,   /* U+57AD */
  0x0002,   /* U+57AE */
  0x0002,   /* U+57AF */
  0x0002,   /* U+57B0 */
  0x0002,   /* U+57B1 */
  0x0002,   /* U+57B2 */
  0x0002,   /* U+57B3 */
  0x0002,   /* U+57B4 */
  0x0002,   /* U+57B5 */
  0x0002,   /* U+57B6 */
  0x0002,   /* U+57B7 */
  0x0002,   /* U+57B8 */
  0x0002,   /* U+57B9 */
  0x0002,   /* U+57BA */
  0x0002,   /* U+57BB */
  0x0002,   /* U+57BC */
  0x0002,   /* U+57BD */
  0x0002,   /* U+57BE */
  0x0002,   /* U+57BF */
  0x0002,   /* U+57C0 */
  0x0002,   /* U+57C1 */
  0x0002,   /* U+57C2 */
  0x0002,   /* U+57C3 */
  0x0002,   /* U+57C4 */
  0x0002,   /* U+57C5 */
  0x0002,   /* U+57C6 */
  0x0002,   /* U+57C7 */
  0x0002,   /* U+57C8 */
  0x0002,   /* U+57C9 */
  0x0002,   /* U+57CA */
  0x0002,   /* U+57CB */
  0x0002,   /* U+57CC */
  0x0002,   /* U+57CD */
  0x0002,   /* U+57CE */
  0x0002,   /* U+57CF */
  0x0002,   /* U+57D0 */
  0x0002,   /* U+57D1 */
  0x0002,   /* U+57D2 */
  0x0002,   /* U+57D3 */
  0x0002,   /* U+57D4 */
  0x0002,   /* U+57D5 */
  0x0002,   /* U+57D6 */
  0x0002,   /* U+57D7 */
  0x0002,   /* U+57D8 */
  0x0002,   /* U+57D9 */
  0x0002,   /* U+57DA */
  0x0002,   /* U+57DB */
  0x0002,   /* U+57DC */
  0x0002,   /* U+57DD */
  0x0002,   /* U+57DE */
  0x0002,   /* U+57DF */
  0x0002,   /* U+57E0 */
  0x0002,   /* U+57E1 */
  0x0002,   /* U+57E2 */
  0x0002,   /* U+57E3 */
  0x0002,   /* U+57E4 */
  0x0002,   /* U+57E5 */
  0x0002,   /* U+57E6 */
  0x0002,   /* U+57E7 */
  0x0002,   /* U+57E8 */
  0x0002,   /* U+57E9 */
  0x0002,   /* U+57EA */
  0x0002,   /* U+57EB */
  0x0002,   /* U+57EC */
  0x0002,   /* U+57ED */
  0x0002,   /* U+57EE */
  0x0002,   /* U+57EF */
  0x0002,   /* U+57F0 */
  0x0002,   /* U+57F1 */
  0x0002,   /* U+57F2 */
  0x0002,   /* U+57F3 */
  0x0002,   /* U+57F4 */
  0x0002,   /* U+57F5 */
  0x0002,   /* U+57F6 */
  0x0002,   /* U+57F7 */
  0x0002,   /* U+57F8 */
  0x0002,   /* U+57F9 */
  0x0002,   /* U+57FA */
  0x0002,   /* U+57FB */
  0x0002,   /* U+57FC */
  0x0002,   /* U+57FD */
  0x0002,   /* U+57FE */
  0x0002,   /* U+57FF */

  /* Primary weight 2 for each character. */
  0x0000,   /* U+5700 */
  0xD701,   /* U+5701 */
  0xD702,   /* U+5702 */
  0x0000,   /* U+5703 */
  0x0000,   /* U+5704 */
  0xD705,   /* U+5705 */
  0xD706,   /* U+5706 */
  0xD707,   /* U+5707 */
  0x0000,   /* U+5708 */
  0x0000,   /* U+5709 */
  0xD70A,   /* U+570A */
  0x0000,   /* U+570B */
  0xD70C,   /* U+570C */
  0x0000,   /* U+570D */
  0xD70E,   /* U+570E */
  0x0000,   /* U+570F */
  0xD710,   /* U+5710 */
  0xD711,   /* U+5711 */
  0x0000,   /* U+5712 */
  0x0000,   /* U+5713 */
  0xD714,   /* U+5714 */
  0xD715,   /* U+5715 */
  0x0000,   /* U+5716 */
  0xD717,   /* U+5717 */
  0x0000,   /* U+5718 */
  0xD719,   /* U+5719 */
  0xD71A,   /* U+571A */
  0xD71B,   /* U+571B */
  0x0000,   /* U+571C */
  0xD71D,   /* U+571D */
  0xD71E,   /* U+571E */
  0x0000,   /* U+571F */
  0xD720,   /* U+5720 */
  0xD721,   /* U+5721 */
  0xD722,   /* U+5722 */
  0xD723,   /* U+5723 */
  0xD724,   /* U+5724 */
  0xD725,   /* U+5725 */
  0x0000,   /* U+5726 */
  0x0000,   /* U+5727 */
  0x0000,   /* U+5728 */
  0xD729,   /* U+5729 */
  0xD72A,   /* U+572A */
  0xD72B,   /* U+572B */
  0xD72C,   /* U+572C */
  0x0000,   /* U+572D */
  0xD72E,   /* U+572E */
  0xD72F,   /* U+572F */
  0x0000,   /* U+5730 */
  0xD731,   /* U+5731 */
  0xD732,   /* U+5732 */
  0xD733,   /* U+5733 */
  0xD734,   /* U+5734 */
  0xD735,   /* U+5735 */
  0xD736,   /* U+5736 */
  0x0000,   /* U+5737 */
  0x0000,   /* U+5738 */
  0xD739,   /* U+5739 */
  0xD73A,   /* U+573A */
  0x0000,   /* U+573B */
  0xD73C,   /* U+573C */
  0xD73D,   /* U+573D */
  0xD73E,   /* U+573E */
  0xD73F,   /* U+573F */
  0x0000,   /* U+5740 */
  0xD741,   /* U+5741 */
  0x0000,   /* U+5742 */
  0xD743,   /* U+5743 */
  0xD744,   /* U+5744 */
  0xD745,   /* U+5745 */
  0xD746,   /* U+5746 */
  0x0000,   /* U+5747 */
  0xD748,   /* U+5748 */
  0xD749,   /* U+5749 */
  0x0000,   /* U+574A */
  0xD74B,   /* U+574B */
  0xD74C,   /* U+574C */
  0xD74D,   /* U+574D */
  0x0000,   /* U+574E */
  0x0000,   /* U+574F */
  0x0000,   /* U+5750 */
  0x0000,   /* U+5751 */
  0xD752,   /* U+5752 */
  0xD753,   /* U+5753 */
  0xD754,   /* U+5754 */
  0xD755,   /* U+5755 */
  0xD756,   /* U+5756 */
  0xD757,   /* U+5757 */
  0xD758,   /* U+5758 */
  0xD759,   /* U+5759 */
  0xD75A,   /* U+575A */
  0xD75B,   /* U+575B */
  0xD75C,   /* U+575C */
  0xD75D,   /* U+575D */
  0xD75E,   /* U+575E */
  0xD75F,   /* U+575F */
  0xD760,   /* U+5760 */
  0x0000,   /* U+5761 */
  0xD762,   /* U+5762 */
  0xD763,   /* U+5763 */
  0x0000,   /* U+5764 */
  0xD765,   /* U+5765 */
  0x0000,   /* U+5766 */
  0xD767,   /* U+5767 */
  0xD768,   /* U+5768 */
  0x0000,   /* U+5769 */
  0x0000,   /* U+576A */
  0xD76B,   /* U+576B */
  0xD76C,   /* U+576C */
  0xD76D,   /* U+576D */
  0xD76E,   /* U+576E */
  0xD76F,   /* U+576F */
  0xD770,   /* U+5770 */
  0xD771,   /* U+5771 */
  0xD772,   /* U+5772 */
  0xD773,   /* U+5773 */
  0xD774,   /* U+5774 */
  0xD775,   /* U+5775 */
  0xD776,   /* U+5776 */
  0xD777,   /* U+5777 */
  0xD778,   /* U+5778 */
  0xD779,   /* U+5779 */
  0xD77A,   /* U+577A */
  0xD77B,   /* U+577B */
  0xD77C,   /* U+577C */
  0xD77D,   /* U+577D */
  0xD77E,   /* U+577E */
  0x0000,   /* U+577F */
  0xD780,   /* U+5780 */
  0xD781,   /* U+5781 */
  0x0000,   /* U+5782 */
  0xD783,   /* U+5783 */
  0xD784,   /* U+5784 */
  0xD785,   /* U+5785 */
  0xD786,   /* U+5786 */
  0xD787,   /* U+5787 */
  0x0000,   /* U+5788 */
  0x0000,   /* U+5789 */
  0xD78A,   /* U+578A */
  0x0000,   /* U+578B */
  0xD78C,   /* U+578C */
  0xD78D,   /* U+578D */
  0xD78E,   /* U+578E */
  0xD78F,   /* U+578F */
  0xD790,   /* U+5790 */
  0xD791,   /* U+5791 */
  0xD792,   /* U+5792 */
  0x0000,   /* U+5793 */
  0xD794,   /* U+5794 */
  0xD795,   /* U+5795 */
  0xD796,   /* U+5796 */
  0xD797,   /* U+5797 */
  0xD798,   /* U+5798 */
  0xD799,   /* U+5799 */
  0xD79A,   /* U+579A */
  0xD79B,   /* U+579B */
  0xD79C,   /* U+579C */
  0xD79D,   /* U+579D */
  0xD79E,   /* U+579E */
  0xD79F,   /* U+579F */
  0x0000,   /* U+57A0 */
  0xD7A1,   /* U+57A1 */
  0x0000,   /* U+57A2 */
  0x0000,   /* U+57A3 */
  0x0000,   /* U+57A4 */
  0xD7A5,   /* U+57A5 */
  0xD7A6,   /* U+57A6 */
  0xD7A7,   /* U+57A7 */
  0xD7A8,   /* U+57A8 */
  0xD7A9,   /* U+57A9 */
  0x0000,   /* U+57AA */
  0xD7AB,   /* U+57AB */
  0xD7AC,   /* U+57AC */
  0xD7AD,   /* U+57AD */
  0xD7AE,   /* U+57AE */
  0xD7AF,   /* U+57AF */
  0x0000,   /* U+57B0 */
  0xD7B1,   /* U+57B1 */
  0xD7B2,   /* U+57B2 */
  0x0000,   /* U+57B3 */
  0xD7B4,   /* U+57B4 */
  0xD7B5,   /* U+57B5 */
  0xD7B6,   /* U+57B6 */
  0xD7B7,   /* U+57B7 */
  0xD7B8,   /* U+57B8 */
  0xD7B9,   /* U+57B9 */
  0xD7BA,   /* U+57BA */
  0xD7BB,   /* U+57BB */
  0xD7BC,   /* U+57BC */
  0xD7BD,   /* U+57BD */
  0xD7BE,   /* U+57BE */
  0xD7BF,   /* U+57BF */
  0x0000,   /* U+57C0 */
  0xD7C1,   /* U+57C1 */
  0xD7C2,   /* U+57C2 */
  0x0000,   /* U+57C3 */
  0xD7C4,   /* U+57C4 */
  0xD7C5,   /* U+57C5 */
  0x0000,   /* U+57C6 */
  0xD7C7,   /* U+57C7 */
  0xD7C8,   /* U+57C8 */
  0xD7C9,   /* U+57C9 */
  0xD7CA,   /* U+57CA */
  0x0000,   /* U+57CB */
  0xD7CC,   /* U+57CC */
  0xD7CD,   /* U+57CD */
  0x0000,   /* U+57CE */
  0xD7CF,   /* U+57CF */
  0xD7D0,   /* U+57D0 */
  0xD7D1,   /* U+57D1 */
  0x0000,   /* U+57D2 */
  0x0000,   /* U+57D3 */
  0x0000,   /* U+57D4 */
  0xD7D5,   /* U+57D5 */
  0x0000,   /* U+57D6 */
  0xD7D7,   /* U+57D7 */
  0xD7D8,   /* U+57D8 */
  0xD7D9,   /* U+57D9 */
  0xD7DA,   /* U+57DA */
  0xD7DB,   /* U+57DB */
  0x0000,   /* U+57DC */
  0xD7DD,   /* U+57DD */
  0xD7DE,   /* U+57DE */
  0x0000,   /* U+57DF */
  0x0000,   /* U+57E0 */
  0xD7E1,   /* U+57E1 */
  0xD7E2,   /* U+57E2 */
  0x0000,   /* U+57E3 */
  0xD7E4,   /* U+57E4 */
  0xD7E5,   /* U+57E5 */
  0xD7E6,   /* U+57E6 */
  0xD7E7,   /* U+57E7 */
  0xD7E8,   /* U+57E8 */
  0xD7E9,   /* U+57E9 */
  0xD7EA,   /* U+57EA */
  0xD7EB,   /* U+57EB */
  0xD7EC,   /* U+57EC */
  0xD7ED,   /* U+57ED */
  0xD7EE,   /* U+57EE */
  0xD7EF,   /* U+57EF */
  0xD7F0,   /* U+57F0 */
  0xD7F1,   /* U+57F1 */
  0xD7F2,   /* U+57F2 */
  0xD7F3,   /* U+57F3 */
  0x0000,   /* U+57F4 */
  0xD7F5,   /* U+57F5 */
  0xD7F6,   /* U+57F6 */
  0x0000,   /* U+57F7 */
  0xD7F8,   /* U+57F8 */
  0x0000,   /* U+57F9 */
  0x0000,   /* U+57FA */
  0xD7FB,   /* U+57FB */
  0x0000,   /* U+57FC */
  0xD7FD,   /* U+57FD */
  0xD7FE,   /* U+57FE */
  0xD7FF,   /* U+57FF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+5700 */
  0x0000,   /* U+5701 */
  0x0000,   /* U+5702 */
  0x0000,   /* U+5703 */
  0x0000,   /* U+5704 */
  0x0000,   /* U+5705 */
  0x0000,   /* U+5706 */
  0x0000,   /* U+5707 */
  0x0000,   /* U+5708 */
  0x0000,   /* U+5709 */
  0x0000,   /* U+570A */
  0x0000,   /* U+570B */
  0x0000,   /* U+570C */
  0x0000,   /* U+570D */
  0x0000,   /* U+570E */
  0x0000,   /* U+570F */
  0x0000,   /* U+5710 */
  0x0000,   /* U+5711 */
  0x0000,   /* U+5712 */
  0x0000,   /* U+5713 */
  0x0000,   /* U+5714 */
  0x0000,   /* U+5715 */
  0x0000,   /* U+5716 */
  0x0000,   /* U+5717 */
  0x0000,   /* U+5718 */
  0x0000,   /* U+5719 */
  0x0000,   /* U+571A */
  0x0000,   /* U+571B */
  0x0000,   /* U+571C */
  0x0000,   /* U+571D */
  0x0000,   /* U+571E */
  0x0000,   /* U+571F */
  0x0000,   /* U+5720 */
  0x0000,   /* U+5721 */
  0x0000,   /* U+5722 */
  0x0000,   /* U+5723 */
  0x0000,   /* U+5724 */
  0x0000,   /* U+5725 */
  0x0000,   /* U+5726 */
  0x0000,   /* U+5727 */
  0x0000,   /* U+5728 */
  0x0000,   /* U+5729 */
  0x0000,   /* U+572A */
  0x0000,   /* U+572B */
  0x0000,   /* U+572C */
  0x0000,   /* U+572D */
  0x0000,   /* U+572E */
  0x0000,   /* U+572F */
  0x0000,   /* U+5730 */
  0x0000,   /* U+5731 */
  0x0000,   /* U+5732 */
  0x0000,   /* U+5733 */
  0x0000,   /* U+5734 */
  0x0000,   /* U+5735 */
  0x0000,   /* U+5736 */
  0x0000,   /* U+5737 */
  0x0000,   /* U+5738 */
  0x0000,   /* U+5739 */
  0x0000,   /* U+573A */
  0x0000,   /* U+573B */
  0x0000,   /* U+573C */
  0x0000,   /* U+573D */
  0x0000,   /* U+573E */
  0x0000,   /* U+573F */
  0x0000,   /* U+5740 */
  0x0000,   /* U+5741 */
  0x0000,   /* U+5742 */
  0x0000,   /* U+5743 */
  0x0000,   /* U+5744 */
  0x0000,   /* U+5745 */
  0x0000,   /* U+5746 */
  0x0000,   /* U+5747 */
  0x0000,   /* U+5748 */
  0x0000,   /* U+5749 */
  0x0000,   /* U+574A */
  0x0000,   /* U+574B */
  0x0000,   /* U+574C */
  0x0000,   /* U+574D */
  0x0000,   /* U+574E */
  0x0000,   /* U+574F */
  0x0000,   /* U+5750 */
  0x0000,   /* U+5751 */
  0x0000,   /* U+5752 */
  0x0000,   /* U+5753 */
  0x0000,   /* U+5754 */
  0x0000,   /* U+5755 */
  0x0000,   /* U+5756 */
  0x0000,   /* U+5757 */
  0x0000,   /* U+5758 */
  0x0000,   /* U+5759 */
  0x0000,   /* U+575A */
  0x0000,   /* U+575B */
  0x0000,   /* U+575C */
  0x0000,   /* U+575D */
  0x0000,   /* U+575E */
  0x0000,   /* U+575F */
  0x0000,   /* U+5760 */
  0x0000,   /* U+5761 */
  0x0000,   /* U+5762 */
  0x0000,   /* U+5763 */
  0x0000,   /* U+5764 */
  0x0000,   /* U+5765 */
  0x0000,   /* U+5766 */
  0x0000,   /* U+5767 */
  0x0000,   /* U+5768 */
  0x0000,   /* U+5769 */
  0x0000,   /* U+576A */
  0x0000,   /* U+576B */
  0x0000,   /* U+576C */
  0x0000,   /* U+576D */
  0x0000,   /* U+576E */
  0x0000,   /* U+576F */
  0x0000,   /* U+5770 */
  0x0000,   /* U+5771 */
  0x0000,   /* U+5772 */
  0x0000,   /* U+5773 */
  0x0000,   /* U+5774 */
  0x0000,   /* U+5775 */
  0x0000,   /* U+5776 */
  0x0000,   /* U+5777 */
  0x0000,   /* U+5778 */
  0x0000,   /* U+5779 */
  0x0000,   /* U+577A */
  0x0000,   /* U+577B */
  0x0000,   /* U+577C */
  0x0000,   /* U+577D */
  0x0000,   /* U+577E */
  0x0000,   /* U+577F */
  0x0000,   /* U+5780 */
  0x0000,   /* U+5781 */
  0x0000,   /* U+5782 */
  0x0000,   /* U+5783 */
  0x0000,   /* U+5784 */
  0x0000,   /* U+5785 */
  0x0000,   /* U+5786 */
  0x0000,   /* U+5787 */
  0x0000,   /* U+5788 */
  0x0000,   /* U+5789 */
  0x0000,   /* U+578A */
  0x0000,   /* U+578B */
  0x0000,   /* U+578C */
  0x0000,   /* U+578D */
  0x0000,   /* U+578E */
  0x0000,   /* U+578F */
  0x0000,   /* U+5790 */
  0x0000,   /* U+5791 */
  0x0000,   /* U+5792 */
  0x0000,   /* U+5793 */
  0x0000,   /* U+5794 */
  0x0000,   /* U+5795 */
  0x0000,   /* U+5796 */
  0x0000,   /* U+5797 */
  0x0000,   /* U+5798 */
  0x0000,   /* U+5799 */
  0x0000,   /* U+579A */
  0x0000,   /* U+579B */
  0x0000,   /* U+579C */
  0x0000,   /* U+579D */
  0x0000,   /* U+579E */
  0x0000,   /* U+579F */
  0x0000,   /* U+57A0 */
  0x0000,   /* U+57A1 */
  0x0000,   /* U+57A2 */
  0x0000,   /* U+57A3 */
  0x0000,   /* U+57A4 */
  0x0000,   /* U+57A5 */
  0x0000,   /* U+57A6 */
  0x0000,   /* U+57A7 */
  0x0000,   /* U+57A8 */
  0x0000,   /* U+57A9 */
  0x0000,   /* U+57AA */
  0x0000,   /* U+57AB */
  0x0000,   /* U+57AC */
  0x0000,   /* U+57AD */
  0x0000,   /* U+57AE */
  0x0000,   /* U+57AF */
  0x0000,   /* U+57B0 */
  0x0000,   /* U+57B1 */
  0x0000,   /* U+57B2 */
  0x0000,   /* U+57B3 */
  0x0000,   /* U+57B4 */
  0x0000,   /* U+57B5 */
  0x0000,   /* U+57B6 */
  0x0000,   /* U+57B7 */
  0x0000,   /* U+57B8 */
  0x0000,   /* U+57B9 */
  0x0000,   /* U+57BA */
  0x0000,   /* U+57BB */
  0x0000,   /* U+57BC */
  0x0000,   /* U+57BD */
  0x0000,   /* U+57BE */
  0x0000,   /* U+57BF */
  0x0000,   /* U+57C0 */
  0x0000,   /* U+57C1 */
  0x0000,   /* U+57C2 */
  0x0000,   /* U+57C3 */
  0x0000,   /* U+57C4 */
  0x0000,   /* U+57C5 */
  0x0000,   /* U+57C6 */
  0x0000,   /* U+57C7 */
  0x0000,   /* U+57C8 */
  0x0000,   /* U+57C9 */
  0x0000,   /* U+57CA */
  0x0000,   /* U+57CB */
  0x0000,   /* U+57CC */
  0x0000,   /* U+57CD */
  0x0000,   /* U+57CE */
  0x0000,   /* U+57CF */
  0x0000,   /* U+57D0 */
  0x0000,   /* U+57D1 */
  0x0000,   /* U+57D2 */
  0x0000,   /* U+57D3 */
  0x0000,   /* U+57D4 */
  0x0000,   /* U+57D5 */
  0x0000,   /* U+57D6 */
  0x0000,   /* U+57D7 */
  0x0000,   /* U+57D8 */
  0x0000,   /* U+57D9 */
  0x0000,   /* U+57DA */
  0x0000,   /* U+57DB */
  0x0000,   /* U+57DC */
  0x0000,   /* U+57DD */
  0x0000,   /* U+57DE */
  0x0000,   /* U+57DF */
  0x0000,   /* U+57E0 */
  0x0000,   /* U+57E1 */
  0x0000,   /* U+57E2 */
  0x0000,   /* U+57E3 */
  0x0000,   /* U+57E4 */
  0x0000,   /* U+57E5 */
  0x0000,   /* U+57E6 */
  0x0000,   /* U+57E7 */
  0x0000,   /* U+57E8 */
  0x0000,   /* U+57E9 */
  0x0000,   /* U+57EA */
  0x0000,   /* U+57EB */
  0x0000,   /* U+57EC */
  0x0000,   /* U+57ED */
  0x0000,   /* U+57EE */
  0x0000,   /* U+57EF */
  0x0000,   /* U+57F0 */
  0x0000,   /* U+57F1 */
  0x0000,   /* U+57F2 */
  0x0000,   /* U+57F3 */
  0x0000,   /* U+57F4 */
  0x0000,   /* U+57F5 */
  0x0000,   /* U+57F6 */
  0x0000,   /* U+57F7 */
  0x0000,   /* U+57F8 */
  0x0000,   /* U+57F9 */
  0x0000,   /* U+57FA */
  0x0000,   /* U+57FB */
  0x0000,   /* U+57FC */
  0x0000,   /* U+57FD */
  0x0000,   /* U+57FE */
  0x0000,   /* U+57FF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+5700 */
  0x0000,   /* U+5701 */
  0x0000,   /* U+5702 */
  0x0000,   /* U+5703 */
  0x0000,   /* U+5704 */
  0x0000,   /* U+5705 */
  0x0000,   /* U+5706 */
  0x0000,   /* U+5707 */
  0x0000,   /* U+5708 */
  0x0000,   /* U+5709 */
  0x0000,   /* U+570A */
  0x0000,   /* U+570B */
  0x0000,   /* U+570C */
  0x0000,   /* U+570D */
  0x0000,   /* U+570E */
  0x0000,   /* U+570F */
  0x0000,   /* U+5710 */
  0x0000,   /* U+5711 */
  0x0000,   /* U+5712 */
  0x0000,   /* U+5713 */
  0x0000,   /* U+5714 */
  0x0000,   /* U+5715 */
  0x0000,   /* U+5716 */
  0x0000,   /* U+5717 */
  0x0000,   /* U+5718 */
  0x0000,   /* U+5719 */
  0x0000,   /* U+571A */
  0x0000,   /* U+571B */
  0x0000,   /* U+571C */
  0x0000,   /* U+571D */
  0x0000,   /* U+571E */
  0x0000,   /* U+571F */
  0x0000,   /* U+5720 */
  0x0000,   /* U+5721 */
  0x0000,   /* U+5722 */
  0x0000,   /* U+5723 */
  0x0000,   /* U+5724 */
  0x0000,   /* U+5725 */
  0x0000,   /* U+5726 */
  0x0000,   /* U+5727 */
  0x0000,   /* U+5728 */
  0x0000,   /* U+5729 */
  0x0000,   /* U+572A */
  0x0000,   /* U+572B */
  0x0000,   /* U+572C */
  0x0000,   /* U+572D */
  0x0000,   /* U+572E */
  0x0000,   /* U+572F */
  0x0000,   /* U+5730 */
  0x0000,   /* U+5731 */
  0x0000,   /* U+5732 */
  0x0000,   /* U+5733 */
  0x0000,   /* U+5734 */
  0x0000,   /* U+5735 */
  0x0000,   /* U+5736 */
  0x0000,   /* U+5737 */
  0x0000,   /* U+5738 */
  0x0000,   /* U+5739 */
  0x0000,   /* U+573A */
  0x0000,   /* U+573B */
  0x0000,   /* U+573C */
  0x0000,   /* U+573D */
  0x0000,   /* U+573E */
  0x0000,   /* U+573F */
  0x0000,   /* U+5740 */
  0x0000,   /* U+5741 */
  0x0000,   /* U+5742 */
  0x0000,   /* U+5743 */
  0x0000,   /* U+5744 */
  0x0000,   /* U+5745 */
  0x0000,   /* U+5746 */
  0x0000,   /* U+5747 */
  0x0000,   /* U+5748 */
  0x0000,   /* U+5749 */
  0x0000,   /* U+574A */
  0x0000,   /* U+574B */
  0x0000,   /* U+574C */
  0x0000,   /* U+574D */
  0x0000,   /* U+574E */
  0x0000,   /* U+574F */
  0x0000,   /* U+5750 */
  0x0000,   /* U+5751 */
  0x0000,   /* U+5752 */
  0x0000,   /* U+5753 */
  0x0000,   /* U+5754 */
  0x0000,   /* U+5755 */
  0x0000,   /* U+5756 */
  0x0000,   /* U+5757 */
  0x0000,   /* U+5758 */
  0x0000,   /* U+5759 */
  0x0000,   /* U+575A */
  0x0000,   /* U+575B */
  0x0000,   /* U+575C */
  0x0000,   /* U+575D */
  0x0000,   /* U+575E */
  0x0000,   /* U+575F */
  0x0000,   /* U+5760 */
  0x0000,   /* U+5761 */
  0x0000,   /* U+5762 */
  0x0000,   /* U+5763 */
  0x0000,   /* U+5764 */
  0x0000,   /* U+5765 */
  0x0000,   /* U+5766 */
  0x0000,   /* U+5767 */
  0x0000,   /* U+5768 */
  0x0000,   /* U+5769 */
  0x0000,   /* U+576A */
  0x0000,   /* U+576B */
  0x0000,   /* U+576C */
  0x0000,   /* U+576D */
  0x0000,   /* U+576E */
  0x0000,   /* U+576F */
  0x0000,   /* U+5770 */
  0x0000,   /* U+5771 */
  0x0000,   /* U+5772 */
  0x0000,   /* U+5773 */
  0x0000,   /* U+5774 */
  0x0000,   /* U+5775 */
  0x0000,   /* U+5776 */
  0x0000,   /* U+5777 */
  0x0000,   /* U+5778 */
  0x0000,   /* U+5779 */
  0x0000,   /* U+577A */
  0x0000,   /* U+577B */
  0x0000,   /* U+577C */
  0x0000,   /* U+577D */
  0x0000,   /* U+577E */
  0x0000,   /* U+577F */
  0x0000,   /* U+5780 */
  0x0000,   /* U+5781 */
  0x0000,   /* U+5782 */
  0x0000,   /* U+5783 */
  0x0000,   /* U+5784 */
  0x0000,   /* U+5785 */
  0x0000,   /* U+5786 */
  0x0000,   /* U+5787 */
  0x0000,   /* U+5788 */
  0x0000,   /* U+5789 */
  0x0000,   /* U+578A */
  0x0000,   /* U+578B */
  0x0000,   /* U+578C */
  0x0000,   /* U+578D */
  0x0000,   /* U+578E */
  0x0000,   /* U+578F */
  0x0000,   /* U+5790 */
  0x0000,   /* U+5791 */
  0x0000,   /* U+5792 */
  0x0000,   /* U+5793 */
  0x0000,   /* U+5794 */
  0x0000,   /* U+5795 */
  0x0000,   /* U+5796 */
  0x0000,   /* U+5797 */
  0x0000,   /* U+5798 */
  0x0000,   /* U+5799 */
  0x0000,   /* U+579A */
  0x0000,   /* U+579B */
  0x0000,   /* U+579C */
  0x0000,   /* U+579D */
  0x0000,   /* U+579E */
  0x0000,   /* U+579F */
  0x0000,   /* U+57A0 */
  0x0000,   /* U+57A1 */
  0x0000,   /* U+57A2 */
  0x0000,   /* U+57A3 */
  0x0000,   /* U+57A4 */
  0x0000,   /* U+57A5 */
  0x0000,   /* U+57A6 */
  0x0000,   /* U+57A7 */
  0x0000,   /* U+57A8 */
  0x0000,   /* U+57A9 */
  0x0000,   /* U+57AA */
  0x0000,   /* U+57AB */
  0x0000,   /* U+57AC */
  0x0000,   /* U+57AD */
  0x0000,   /* U+57AE */
  0x0000,   /* U+57AF */
  0x0000,   /* U+57B0 */
  0x0000,   /* U+57B1 */
  0x0000,   /* U+57B2 */
  0x0000,   /* U+57B3 */
  0x0000,   /* U+57B4 */
  0x0000,   /* U+57B5 */
  0x0000,   /* U+57B6 */
  0x0000,   /* U+57B7 */
  0x0000,   /* U+57B8 */
  0x0000,   /* U+57B9 */
  0x0000,   /* U+57BA */
  0x0000,   /* U+57BB */
  0x0000,   /* U+57BC */
  0x0000,   /* U+57BD */
  0x0000,   /* U+57BE */
  0x0000,   /* U+57BF */
  0x0000,   /* U+57C0 */
  0x0000,   /* U+57C1 */
  0x0000,   /* U+57C2 */
  0x0000,   /* U+57C3 */
  0x0000,   /* U+57C4 */
  0x0000,   /* U+57C5 */
  0x0000,   /* U+57C6 */
  0x0000,   /* U+57C7 */
  0x0000,   /* U+57C8 */
  0x0000,   /* U+57C9 */
  0x0000,   /* U+57CA */
  0x0000,   /* U+57CB */
  0x0000,   /* U+57CC */
  0x0000,   /* U+57CD */
  0x0000,   /* U+57CE */
  0x0000,   /* U+57CF */
  0x0000,   /* U+57D0 */
  0x0000,   /* U+57D1 */
  0x0000,   /* U+57D2 */
  0x0000,   /* U+57D3 */
  0x0000,   /* U+57D4 */
  0x0000,   /* U+57D5 */
  0x0000,   /* U+57D6 */
  0x0000,   /* U+57D7 */
  0x0000,   /* U+57D8 */
  0x0000,   /* U+57D9 */
  0x0000,   /* U+57DA */
  0x0000,   /* U+57DB */
  0x0000,   /* U+57DC */
  0x0000,   /* U+57DD */
  0x0000,   /* U+57DE */
  0x0000,   /* U+57DF */
  0x0000,   /* U+57E0 */
  0x0000,   /* U+57E1 */
  0x0000,   /* U+57E2 */
  0x0000,   /* U+57E3 */
  0x0000,   /* U+57E4 */
  0x0000,   /* U+57E5 */
  0x0000,   /* U+57E6 */
  0x0000,   /* U+57E7 */
  0x0000,   /* U+57E8 */
  0x0000,   /* U+57E9 */
  0x0000,   /* U+57EA */
  0x0000,   /* U+57EB */
  0x0000,   /* U+57EC */
  0x0000,   /* U+57ED */
  0x0000,   /* U+57EE */
  0x0000,   /* U+57EF */
  0x0000,   /* U+57F0 */
  0x0000,   /* U+57F1 */
  0x0000,   /* U+57F2 */
  0x0000,   /* U+57F3 */
  0x0000,   /* U+57F4 */
  0x0000,   /* U+57F5 */
  0x0000,   /* U+57F6 */
  0x0000,   /* U+57F7 */
  0x0000,   /* U+57F8 */
  0x0000,   /* U+57F9 */
  0x0000,   /* U+57FA */
  0x0000,   /* U+57FB */
  0x0000,   /* U+57FC */
  0x0000,   /* U+57FD */
  0x0000,   /* U+57FE */
  0x0000,   /* U+57FF */
};

uint16 ja_han_page58[]= {
  /* Number of CEs for each character. */
  1, 2, 1, 2, 2, 1, 1, 2, 2, 2, 1, 1, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 1, 2, 2, 2, 1, 2, 2, 2, 1, 2, 2,
  2, 1, 2, 2, 1, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 1,
  1, 1, 2, 2, 1, 1, 2, 2, 2, 2, 1, 2, 2, 1, 2, 2,
  1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 2, 2, 2, 2,
  2, 1, 1, 2, 1, 2, 2, 1, 1, 1, 1, 2, 2, 2, 1, 2,
  2, 2, 1, 2, 2, 2, 2, 2, 2, 1, 2, 1, 2, 2, 2, 2,
  1, 2, 1, 2, 2, 1, 2, 2, 2, 1, 2, 2, 2, 2, 1, 2,
  2, 2, 2, 1, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 1, 2, 2, 2, 1, 2, 2, 2, 2, 1, 2, 2, 1,
  2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 1, 2, 2, 1, 2,
  2, 2, 2, 1, 2, 2, 2, 2, 1, 1, 1, 1, 2, 2, 1, 2,
  2, 1, 2, 2, 2, 1, 2, 1, 2, 2, 1, 2, 1, 2, 2, 2,
  2, 1, 2, 1, 2, 1, 2, 1, 1, 1, 2, 2, 1, 2, 1, 1,
  2, 2, 2, 2, 1, 1, 2, 2, 2, 2, 2, 1, 1, 2, 1, 1,
  1, 1, 1, 2, 2, 2, 2, 1, 2, 1, 1, 1, 1, 1, 2, 2,

  /* Primary weight 1 for each character. */
  0x5EC6,   /* U+5800 */
  0xFB40,   /* U+5801 */
  0x5CC9,   /* U+5802 */
  0xFB40,   /* U+5803 */
  0xFB40,   /* U+5804 */
  0x578D,   /* U+5805 */
  0x5B6E,   /* U+5806 */
  0xFB40,   /* U+5807 */
  0xFB40,   /* U+5808 */
  0xFB40,   /* U+5809 */
  0x61D1,   /* U+580A */
  0x61D4,   /* U+580B */
  0xFB40,   /* U+580C */
  0xFB40,   /* U+580D */
  0xFB40,   /* U+580E */
  0xFB40,   /* U+580F */
  0xFB40,   /* U+5810 */
  0xFB40,   /* U+5811 */
  0xFB40,   /* U+5812 */
  0xFB40,   /* U+5813 */
  0xFB40,   /* U+5814 */
  0x5B63,   /* U+5815 */
  0xFB40,   /* U+5816 */
  0xFB40,   /* U+5817 */
  0xFB40,   /* U+5818 */
  0x61D5,   /* U+5819 */
  0xFB40,   /* U+581A */
  0xFB40,   /* U+581B */
  0xFB40,   /* U+581C */
  0x61D6,   /* U+581D */
  0xFB40,   /* U+581E */
  0xFB40,   /* U+581F */
  0xFB40,   /* U+5820 */
  0x61D8,   /* U+5821 */
  0xFB40,   /* U+5822 */
  0xFB40,   /* U+5823 */
  0x5C44,   /* U+5824 */
  0xFB40,   /* U+5825 */
  0xFB40,   /* U+5826 */
  0xFB40,   /* U+5827 */
  0xFB40,   /* U+5828 */
  0xFB40,   /* U+5829 */
  0x5629,   /* U+582A */
  0xFB40,   /* U+582B */
  0xFB40,   /* U+582C */
  0xFB40,   /* U+582D */
  0xFB40,   /* U+582E */
  0x6D71,   /* U+582F */
  0x5542,   /* U+5830 */
  0x5E82,   /* U+5831 */
  0xFB40,   /* U+5832 */
  0xFB40,   /* U+5833 */
  0x5A13,   /* U+5834 */
  0x5C81,   /* U+5835 */
  0xFB40,   /* U+5836 */
  0xFB40,   /* U+5837 */
  0xFB40,   /* U+5838 */
  0xFB40,   /* U+5839 */
  0x5895,   /* U+583A */
  0xFB40,   /* U+583B */
  0xFB40,   /* U+583C */
  0x61DE,   /* U+583D */
  0xFB40,   /* U+583E */
  0xFB40,   /* U+583F */
  0x5E4C,   /* U+5840 */
  0x5FE4,   /* U+5841 */
  0xFB40,   /* U+5842 */
  0xFB40,   /* U+5843 */
  0xFB40,   /* U+5844 */
  0xFB40,   /* U+5845 */
  0xFB40,   /* U+5846 */
  0xFB40,   /* U+5847 */
  0xFB40,   /* U+5848 */
  0xFB40,   /* U+5849 */
  0x55B3,   /* U+584A */
  0x61DA,   /* U+584B */
  0xFB40,   /* U+584C */
  0xFB40,   /* U+584D */
  0xFB40,   /* U+584E */
  0xFB40,   /* U+584F */
  0xFB40,   /* U+5850 */
  0x5AFB,   /* U+5851 */
  0x61DD,   /* U+5852 */
  0xFB40,   /* U+5853 */
  0x5C9C,   /* U+5854 */
  0xFB40,   /* U+5855 */
  0xFB40,   /* U+5856 */
  0x5C82,   /* U+5857 */
  0x5C9D,   /* U+5858 */
  0x5D8C,   /* U+5859 */
  0x5C28,   /* U+585A */
  0xFB40,   /* U+585B */
  0xFB40,   /* U+585C */
  0xFB40,   /* U+585D */
  0x5878,   /* U+585E */
  0xFB40,   /* U+585F */
  0xFB40,   /* U+5860 */
  0xFB40,   /* U+5861 */
  0x61D9,   /* U+5862 */
  0xFB40,   /* U+5863 */
  0xFB40,   /* U+5864 */
  0xFB40,   /* U+5865 */
  0xFB40,   /* U+5866 */
  0xFB40,   /* U+5867 */
  0xFB40,   /* U+5868 */
  0x5557,   /* U+5869 */
  0xFB40,   /* U+586A */
  0x5C6F,   /* U+586B */
  0xFB40,   /* U+586C */
  0xFB40,   /* U+586D */
  0xFB40,   /* U+586E */
  0xFB40,   /* U+586F */
  0x61DB,   /* U+5870 */
  0xFB40,   /* U+5871 */
  0x61D7,   /* U+5872 */
  0xFB40,   /* U+5873 */
  0xFB40,   /* U+5874 */
  0x5A55,   /* U+5875 */
  0xFB40,   /* U+5876 */
  0xFB40,   /* U+5877 */
  0xFB40,   /* U+5878 */
  0x61DF,   /* U+5879 */
  0xFB40,   /* U+587A */
  0xFB40,   /* U+587B */
  0xFB40,   /* U+587C */
  0xFB40,   /* U+587D */
  0x5997,   /* U+587E */
  0xFB40,   /* U+587F */
  0xFB40,   /* U+5880 */
  0xFB40,   /* U+5881 */
  0xFB40,   /* U+5882 */
  0x56E4,   /* U+5883 */
  0xFB40,   /* U+5884 */
  0x61E0,   /* U+5885 */
  0xFB40,   /* U+5886 */
  0xFB40,   /* U+5887 */
  0xFB40,   /* U+5888 */
  0xFB40,   /* U+5889 */
  0xFB40,   /* U+588A */
  0xFB40,   /* U+588B */
  0xFB40,   /* U+588C */
  0xFB40,   /* U+588D */
  0xFB40,   /* U+588E */
  0xFB40,   /* U+588F */
  0xFB40,   /* U+5890 */
  0xFB40,   /* U+5891 */
  0xFB40,   /* U+5892 */
  0x5E77,   /* U+5893 */
  0xFB40,   /* U+5894 */
  0xFB40,   /* U+5895 */
  0xFB40,   /* U+5896 */
  0x5B3E,   /* U+5897 */
  0xFB40,   /* U+5898 */
  0xFB40,   /* U+5899 */
  0xFB40,   /* U+589A */
  0xFB40,   /* U+589B */
  0x5C21,   /* U+589C */
  0xFB40,   /* U+589D */
  0xFB40,   /* U+589E */
  0x61E2,   /* U+589F */
  0xFB40,   /* U+58A0 */
  0xFB40,   /* U+58A1 */
  0xFB40,   /* U+58A2 */
  0xFB40,   /* U+58A3 */
  0xFB40,   /* U+58A4 */
  0xFB40,   /* U+58A5 */
  0xFB40,   /* U+58A6 */
  0xFB40,   /* U+58A7 */
  0x5EBC,   /* U+58A8 */
  0xFB40,   /* U+58A9 */
  0xFB40,   /* U+58AA */
  0x61E3,   /* U+58AB */
  0xFB40,   /* U+58AC */
  0xFB40,   /* U+58AD */
  0x61E8,   /* U+58AE */
  0xFB40,   /* U+58AF */
  0xFB40,   /* U+58B0 */
  0xFB40,   /* U+58B1 */
  0xFB40,   /* U+58B2 */
  0x5E3E,   /* U+58B3 */
  0xFB40,   /* U+58B4 */
  0xFB40,   /* U+58B5 */
  0xFB40,   /* U+58B6 */
  0xFB40,   /* U+58B7 */
  0x61E7,   /* U+58B8 */
  0x61E1,   /* U+58B9 */
  0x61E4,   /* U+58BA */
  0x61E6,   /* U+58BB */
  0xFB40,   /* U+58BC */
  0xFB40,   /* U+58BD */
  0x5855,   /* U+58BE */
  0xFB40,   /* U+58BF */
  0xFB40,   /* U+58C0 */
  0x5E58,   /* U+58C1 */
  0xFB40,   /* U+58C2 */
  0xFB40,   /* U+58C3 */
  0xFB40,   /* U+58C4 */
  0x61E9,   /* U+58C5 */
  0xFB40,   /* U+58C6 */
  0x5BC2,   /* U+58C7 */
  0xFB40,   /* U+58C8 */
  0xFB40,   /* U+58C9 */
  0x55B4,   /* U+58CA */
  0xFB40,   /* U+58CB */
  0x5A14,   /* U+58CC */
  0xFB40,   /* U+58CD */
  0xFB40,   /* U+58CE */
  0xFB40,   /* U+58CF */
  0xFB40,   /* U+58D0 */
  0x61EB,   /* U+58D1 */
  0xFB40,   /* U+58D2 */
  0x61EA,   /* U+58D3 */
  0xFB40,   /* U+58D4 */
  0x5839,   /* U+58D5 */
  0xFB40,   /* U+58D6 */
  0x61EC,   /* U+58D7 */
  0x61EE,   /* U+58D8 */
  0x61ED,   /* U+58D9 */
  0xFB40,   /* U+58DA */
  0xFB40,   /* U+58DB */
  0x61F0,   /* U+58DC */
  0xFB40,   /* U+58DD */
  0x61E5,   /* U+58DE */
  0x61F2,   /* U+58DF */
  0xFB40,   /* U+58E0 */
  0xFB40,   /* U+58E1 */
  0xFB40,   /* U+58E2 */
  0xFB40,   /* U+58E3 */
  0x61F1,   /* U+58E4 */
  0x61EF,   /* U+58E5 */
  0xFB40,   /* U+58E6 */
  0xFB40,   /* U+58E7 */
  0xFB40,   /* U+58E8 */
  0xFB40,   /* U+58E9 */
  0xFB40,   /* U+58EA */
  0x58DB,   /* U+58EB */
  0x5A56,   /* U+58EC */
  0xFB40,   /* U+58ED */
  0x5B15,   /* U+58EE */
  0x61F3,   /* U+58EF */
  0x5A9F,   /* U+58F0 */
  0x54F0,   /* U+58F1 */
  0x5D59,   /* U+58F2 */
  0xFB40,   /* U+58F3 */
  0xFB40,   /* U+58F4 */
  0xFB40,   /* U+58F5 */
  0xFB40,   /* U+58F6 */
  0x5C36,   /* U+58F7 */
  0xFB40,   /* U+58F8 */
  0x61F5,   /* U+58F9 */
  0x61F4,   /* U+58FA */
  0x61F6,   /* U+58FB */
  0x61F7,   /* U+58FC */
  0x61F8,   /* U+58FD */
  0xFB40,   /* U+58FE */
  0xFB40,   /* U+58FF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+5800 */
  0x0020,   /* U+5801 */
  0x0020,   /* U+5802 */
  0x0020,   /* U+5803 */
  0x0020,   /* U+5804 */
  0x0020,   /* U+5805 */
  0x0020,   /* U+5806 */
  0x0020,   /* U+5807 */
  0x0020,   /* U+5808 */
  0x0020,   /* U+5809 */
  0x0020,   /* U+580A */
  0x0020,   /* U+580B */
  0x0020,   /* U+580C */
  0x0020,   /* U+580D */
  0x0020,   /* U+580E */
  0x0020,   /* U+580F */
  0x0020,   /* U+5810 */
  0x0020,   /* U+5811 */
  0x0020,   /* U+5812 */
  0x0020,   /* U+5813 */
  0x0020,   /* U+5814 */
  0x0020,   /* U+5815 */
  0x0020,   /* U+5816 */
  0x0020,   /* U+5817 */
  0x0020,   /* U+5818 */
  0x0020,   /* U+5819 */
  0x0020,   /* U+581A */
  0x0020,   /* U+581B */
  0x0020,   /* U+581C */
  0x0020,   /* U+581D */
  0x0020,   /* U+581E */
  0x0020,   /* U+581F */
  0x0020,   /* U+5820 */
  0x0020,   /* U+5821 */
  0x0020,   /* U+5822 */
  0x0020,   /* U+5823 */
  0x0020,   /* U+5824 */
  0x0020,   /* U+5825 */
  0x0020,   /* U+5826 */
  0x0020,   /* U+5827 */
  0x0020,   /* U+5828 */
  0x0020,   /* U+5829 */
  0x0020,   /* U+582A */
  0x0020,   /* U+582B */
  0x0020,   /* U+582C */
  0x0020,   /* U+582D */
  0x0020,   /* U+582E */
  0x0020,   /* U+582F */
  0x0020,   /* U+5830 */
  0x0020,   /* U+5831 */
  0x0020,   /* U+5832 */
  0x0020,   /* U+5833 */
  0x0020,   /* U+5834 */
  0x0020,   /* U+5835 */
  0x0020,   /* U+5836 */
  0x0020,   /* U+5837 */
  0x0020,   /* U+5838 */
  0x0020,   /* U+5839 */
  0x0020,   /* U+583A */
  0x0020,   /* U+583B */
  0x0020,   /* U+583C */
  0x0020,   /* U+583D */
  0x0020,   /* U+583E */
  0x0020,   /* U+583F */
  0x0020,   /* U+5840 */
  0x0020,   /* U+5841 */
  0x0020,   /* U+5842 */
  0x0020,   /* U+5843 */
  0x0020,   /* U+5844 */
  0x0020,   /* U+5845 */
  0x0020,   /* U+5846 */
  0x0020,   /* U+5847 */
  0x0020,   /* U+5848 */
  0x0020,   /* U+5849 */
  0x0020,   /* U+584A */
  0x0020,   /* U+584B */
  0x0020,   /* U+584C */
  0x0020,   /* U+584D */
  0x0020,   /* U+584E */
  0x0020,   /* U+584F */
  0x0020,   /* U+5850 */
  0x0020,   /* U+5851 */
  0x0020,   /* U+5852 */
  0x0020,   /* U+5853 */
  0x0020,   /* U+5854 */
  0x0020,   /* U+5855 */
  0x0020,   /* U+5856 */
  0x0020,   /* U+5857 */
  0x0020,   /* U+5858 */
  0x0020,   /* U+5859 */
  0x0020,   /* U+585A */
  0x0020,   /* U+585B */
  0x0020,   /* U+585C */
  0x0020,   /* U+585D */
  0x0020,   /* U+585E */
  0x0020,   /* U+585F */
  0x0020,   /* U+5860 */
  0x0020,   /* U+5861 */
  0x0020,   /* U+5862 */
  0x0020,   /* U+5863 */
  0x0020,   /* U+5864 */
  0x0020,   /* U+5865 */
  0x0020,   /* U+5866 */
  0x0020,   /* U+5867 */
  0x0020,   /* U+5868 */
  0x0020,   /* U+5869 */
  0x0020,   /* U+586A */
  0x0020,   /* U+586B */
  0x0020,   /* U+586C */
  0x0020,   /* U+586D */
  0x0020,   /* U+586E */
  0x0020,   /* U+586F */
  0x0020,   /* U+5870 */
  0x0020,   /* U+5871 */
  0x0020,   /* U+5872 */
  0x0020,   /* U+5873 */
  0x0020,   /* U+5874 */
  0x0020,   /* U+5875 */
  0x0020,   /* U+5876 */
  0x0020,   /* U+5877 */
  0x0020,   /* U+5878 */
  0x0020,   /* U+5879 */
  0x0020,   /* U+587A */
  0x0020,   /* U+587B */
  0x0020,   /* U+587C */
  0x0020,   /* U+587D */
  0x0020,   /* U+587E */
  0x0020,   /* U+587F */
  0x0020,   /* U+5880 */
  0x0020,   /* U+5881 */
  0x0020,   /* U+5882 */
  0x0020,   /* U+5883 */
  0x0020,   /* U+5884 */
  0x0020,   /* U+5885 */
  0x0020,   /* U+5886 */
  0x0020,   /* U+5887 */
  0x0020,   /* U+5888 */
  0x0020,   /* U+5889 */
  0x0020,   /* U+588A */
  0x0020,   /* U+588B */
  0x0020,   /* U+588C */
  0x0020,   /* U+588D */
  0x0020,   /* U+588E */
  0x0020,   /* U+588F */
  0x0020,   /* U+5890 */
  0x0020,   /* U+5891 */
  0x0020,   /* U+5892 */
  0x0020,   /* U+5893 */
  0x0020,   /* U+5894 */
  0x0020,   /* U+5895 */
  0x0020,   /* U+5896 */
  0x0020,   /* U+5897 */
  0x0020,   /* U+5898 */
  0x0020,   /* U+5899 */
  0x0020,   /* U+589A */
  0x0020,   /* U+589B */
  0x0020,   /* U+589C */
  0x0020,   /* U+589D */
  0x0020,   /* U+589E */
  0x0020,   /* U+589F */
  0x0020,   /* U+58A0 */
  0x0020,   /* U+58A1 */
  0x0020,   /* U+58A2 */
  0x0020,   /* U+58A3 */
  0x0020,   /* U+58A4 */
  0x0020,   /* U+58A5 */
  0x0020,   /* U+58A6 */
  0x0020,   /* U+58A7 */
  0x0020,   /* U+58A8 */
  0x0020,   /* U+58A9 */
  0x0020,   /* U+58AA */
  0x0020,   /* U+58AB */
  0x0020,   /* U+58AC */
  0x0020,   /* U+58AD */
  0x0020,   /* U+58AE */
  0x0020,   /* U+58AF */
  0x0020,   /* U+58B0 */
  0x0020,   /* U+58B1 */
  0x0020,   /* U+58B2 */
  0x0020,   /* U+58B3 */
  0x0020,   /* U+58B4 */
  0x0020,   /* U+58B5 */
  0x0020,   /* U+58B6 */
  0x0020,   /* U+58B7 */
  0x0020,   /* U+58B8 */
  0x0020,   /* U+58B9 */
  0x0020,   /* U+58BA */
  0x0020,   /* U+58BB */
  0x0020,   /* U+58BC */
  0x0020,   /* U+58BD */
  0x0020,   /* U+58BE */
  0x0020,   /* U+58BF */
  0x0020,   /* U+58C0 */
  0x0020,   /* U+58C1 */
  0x0020,   /* U+58C2 */
  0x0020,   /* U+58C3 */
  0x0020,   /* U+58C4 */
  0x0020,   /* U+58C5 */
  0x0020,   /* U+58C6 */
  0x0020,   /* U+58C7 */
  0x0020,   /* U+58C8 */
  0x0020,   /* U+58C9 */
  0x0020,   /* U+58CA */
  0x0020,   /* U+58CB */
  0x0020,   /* U+58CC */
  0x0020,   /* U+58CD */
  0x0020,   /* U+58CE */
  0x0020,   /* U+58CF */
  0x0020,   /* U+58D0 */
  0x0020,   /* U+58D1 */
  0x0020,   /* U+58D2 */
  0x0020,   /* U+58D3 */
  0x0020,   /* U+58D4 */
  0x0020,   /* U+58D5 */
  0x0020,   /* U+58D6 */
  0x0020,   /* U+58D7 */
  0x0020,   /* U+58D8 */
  0x0020,   /* U+58D9 */
  0x0020,   /* U+58DA */
  0x0020,   /* U+58DB */
  0x0020,   /* U+58DC */
  0x0020,   /* U+58DD */
  0x0020,   /* U+58DE */
  0x0020,   /* U+58DF */
  0x0020,   /* U+58E0 */
  0x0020,   /* U+58E1 */
  0x0020,   /* U+58E2 */
  0x0020,   /* U+58E3 */
  0x0020,   /* U+58E4 */
  0x0020,   /* U+58E5 */
  0x0020,   /* U+58E6 */
  0x0020,   /* U+58E7 */
  0x0020,   /* U+58E8 */
  0x0020,   /* U+58E9 */
  0x0020,   /* U+58EA */
  0x0020,   /* U+58EB */
  0x0020,   /* U+58EC */
  0x0020,   /* U+58ED */
  0x0020,   /* U+58EE */
  0x0020,   /* U+58EF */
  0x0020,   /* U+58F0 */
  0x0020,   /* U+58F1 */
  0x0020,   /* U+58F2 */
  0x0020,   /* U+58F3 */
  0x0020,   /* U+58F4 */
  0x0020,   /* U+58F5 */
  0x0020,   /* U+58F6 */
  0x0020,   /* U+58F7 */
  0x0020,   /* U+58F8 */
  0x0020,   /* U+58F9 */
  0x0020,   /* U+58FA */
  0x0020,   /* U+58FB */
  0x0020,   /* U+58FC */
  0x0020,   /* U+58FD */
  0x0020,   /* U+58FE */
  0x0020,   /* U+58FF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+5800 */
  0x0002,   /* U+5801 */
  0x0002,   /* U+5802 */
  0x0002,   /* U+5803 */
  0x0002,   /* U+5804 */
  0x0002,   /* U+5805 */
  0x0002,   /* U+5806 */
  0x0002,   /* U+5807 */
  0x0002,   /* U+5808 */
  0x0002,   /* U+5809 */
  0x0002,   /* U+580A */
  0x0002,   /* U+580B */
  0x0002,   /* U+580C */
  0x0002,   /* U+580D */
  0x0002,   /* U+580E */
  0x0002,   /* U+580F */
  0x0002,   /* U+5810 */
  0x0002,   /* U+5811 */
  0x0002,   /* U+5812 */
  0x0002,   /* U+5813 */
  0x0002,   /* U+5814 */
  0x0002,   /* U+5815 */
  0x0002,   /* U+5816 */
  0x0002,   /* U+5817 */
  0x0002,   /* U+5818 */
  0x0002,   /* U+5819 */
  0x0002,   /* U+581A */
  0x0002,   /* U+581B */
  0x0002,   /* U+581C */
  0x0002,   /* U+581D */
  0x0002,   /* U+581E */
  0x0002,   /* U+581F */
  0x0002,   /* U+5820 */
  0x0002,   /* U+5821 */
  0x0002,   /* U+5822 */
  0x0002,   /* U+5823 */
  0x0002,   /* U+5824 */
  0x0002,   /* U+5825 */
  0x0002,   /* U+5826 */
  0x0002,   /* U+5827 */
  0x0002,   /* U+5828 */
  0x0002,   /* U+5829 */
  0x0002,   /* U+582A */
  0x0002,   /* U+582B */
  0x0002,   /* U+582C */
  0x0002,   /* U+582D */
  0x0002,   /* U+582E */
  0x0002,   /* U+582F */
  0x0002,   /* U+5830 */
  0x0002,   /* U+5831 */
  0x0002,   /* U+5832 */
  0x0002,   /* U+5833 */
  0x0002,   /* U+5834 */
  0x0002,   /* U+5835 */
  0x0002,   /* U+5836 */
  0x0002,   /* U+5837 */
  0x0002,   /* U+5838 */
  0x0002,   /* U+5839 */
  0x0002,   /* U+583A */
  0x0002,   /* U+583B */
  0x0002,   /* U+583C */
  0x0002,   /* U+583D */
  0x0002,   /* U+583E */
  0x0002,   /* U+583F */
  0x0002,   /* U+5840 */
  0x0002,   /* U+5841 */
  0x0002,   /* U+5842 */
  0x0002,   /* U+5843 */
  0x0002,   /* U+5844 */
  0x0002,   /* U+5845 */
  0x0002,   /* U+5846 */
  0x0002,   /* U+5847 */
  0x0002,   /* U+5848 */
  0x0002,   /* U+5849 */
  0x0002,   /* U+584A */
  0x0002,   /* U+584B */
  0x0002,   /* U+584C */
  0x0002,   /* U+584D */
  0x0002,   /* U+584E */
  0x0002,   /* U+584F */
  0x0002,   /* U+5850 */
  0x0002,   /* U+5851 */
  0x0002,   /* U+5852 */
  0x0002,   /* U+5853 */
  0x0002,   /* U+5854 */
  0x0002,   /* U+5855 */
  0x0002,   /* U+5856 */
  0x0002,   /* U+5857 */
  0x0002,   /* U+5858 */
  0x0002,   /* U+5859 */
  0x0002,   /* U+585A */
  0x0002,   /* U+585B */
  0x0002,   /* U+585C */
  0x0002,   /* U+585D */
  0x0002,   /* U+585E */
  0x0002,   /* U+585F */
  0x0002,   /* U+5860 */
  0x0002,   /* U+5861 */
  0x0002,   /* U+5862 */
  0x0002,   /* U+5863 */
  0x0002,   /* U+5864 */
  0x0002,   /* U+5865 */
  0x0002,   /* U+5866 */
  0x0002,   /* U+5867 */
  0x0002,   /* U+5868 */
  0x0002,   /* U+5869 */
  0x0002,   /* U+586A */
  0x0002,   /* U+586B */
  0x0002,   /* U+586C */
  0x0002,   /* U+586D */
  0x0002,   /* U+586E */
  0x0002,   /* U+586F */
  0x0002,   /* U+5870 */
  0x0002,   /* U+5871 */
  0x0002,   /* U+5872 */
  0x0002,   /* U+5873 */
  0x0002,   /* U+5874 */
  0x0002,   /* U+5875 */
  0x0002,   /* U+5876 */
  0x0002,   /* U+5877 */
  0x0002,   /* U+5878 */
  0x0002,   /* U+5879 */
  0x0002,   /* U+587A */
  0x0002,   /* U+587B */
  0x0002,   /* U+587C */
  0x0002,   /* U+587D */
  0x0002,   /* U+587E */
  0x0002,   /* U+587F */
  0x0002,   /* U+5880 */
  0x0002,   /* U+5881 */
  0x0002,   /* U+5882 */
  0x0002,   /* U+5883 */
  0x0002,   /* U+5884 */
  0x0002,   /* U+5885 */
  0x0002,   /* U+5886 */
  0x0002,   /* U+5887 */
  0x0002,   /* U+5888 */
  0x0002,   /* U+5889 */
  0x0002,   /* U+588A */
  0x0002,   /* U+588B */
  0x0002,   /* U+588C */
  0x0002,   /* U+588D */
  0x0002,   /* U+588E */
  0x0002,   /* U+588F */
  0x0002,   /* U+5890 */
  0x0002,   /* U+5891 */
  0x0002,   /* U+5892 */
  0x0002,   /* U+5893 */
  0x0002,   /* U+5894 */
  0x0002,   /* U+5895 */
  0x0002,   /* U+5896 */
  0x0002,   /* U+5897 */
  0x0002,   /* U+5898 */
  0x0002,   /* U+5899 */
  0x0002,   /* U+589A */
  0x0002,   /* U+589B */
  0x0002,   /* U+589C */
  0x0002,   /* U+589D */
  0x0002,   /* U+589E */
  0x0002,   /* U+589F */
  0x0002,   /* U+58A0 */
  0x0002,   /* U+58A1 */
  0x0002,   /* U+58A2 */
  0x0002,   /* U+58A3 */
  0x0002,   /* U+58A4 */
  0x0002,   /* U+58A5 */
  0x0002,   /* U+58A6 */
  0x0002,   /* U+58A7 */
  0x0002,   /* U+58A8 */
  0x0002,   /* U+58A9 */
  0x0002,   /* U+58AA */
  0x0002,   /* U+58AB */
  0x0002,   /* U+58AC */
  0x0002,   /* U+58AD */
  0x0002,   /* U+58AE */
  0x0002,   /* U+58AF */
  0x0002,   /* U+58B0 */
  0x0002,   /* U+58B1 */
  0x0002,   /* U+58B2 */
  0x0002,   /* U+58B3 */
  0x0002,   /* U+58B4 */
  0x0002,   /* U+58B5 */
  0x0002,   /* U+58B6 */
  0x0002,   /* U+58B7 */
  0x0002,   /* U+58B8 */
  0x0002,   /* U+58B9 */
  0x0002,   /* U+58BA */
  0x0002,   /* U+58BB */
  0x0002,   /* U+58BC */
  0x0002,   /* U+58BD */
  0x0002,   /* U+58BE */
  0x0002,   /* U+58BF */
  0x0002,   /* U+58C0 */
  0x0002,   /* U+58C1 */
  0x0002,   /* U+58C2 */
  0x0002,   /* U+58C3 */
  0x0002,   /* U+58C4 */
  0x0002,   /* U+58C5 */
  0x0002,   /* U+58C6 */
  0x0002,   /* U+58C7 */
  0x0002,   /* U+58C8 */
  0x0002,   /* U+58C9 */
  0x0002,   /* U+58CA */
  0x0002,   /* U+58CB */
  0x0002,   /* U+58CC */
  0x0002,   /* U+58CD */
  0x0002,   /* U+58CE */
  0x0002,   /* U+58CF */
  0x0002,   /* U+58D0 */
  0x0002,   /* U+58D1 */
  0x0002,   /* U+58D2 */
  0x0002,   /* U+58D3 */
  0x0002,   /* U+58D4 */
  0x0002,   /* U+58D5 */
  0x0002,   /* U+58D6 */
  0x0002,   /* U+58D7 */
  0x0002,   /* U+58D8 */
  0x0002,   /* U+58D9 */
  0x0002,   /* U+58DA */
  0x0002,   /* U+58DB */
  0x0002,   /* U+58DC */
  0x0002,   /* U+58DD */
  0x0002,   /* U+58DE */
  0x0002,   /* U+58DF */
  0x0002,   /* U+58E0 */
  0x0002,   /* U+58E1 */
  0x0002,   /* U+58E2 */
  0x0002,   /* U+58E3 */
  0x0002,   /* U+58E4 */
  0x0002,   /* U+58E5 */
  0x0002,   /* U+58E6 */
  0x0002,   /* U+58E7 */
  0x0002,   /* U+58E8 */
  0x0002,   /* U+58E9 */
  0x0002,   /* U+58EA */
  0x0002,   /* U+58EB */
  0x0002,   /* U+58EC */
  0x0002,   /* U+58ED */
  0x0002,   /* U+58EE */
  0x0002,   /* U+58EF */
  0x0002,   /* U+58F0 */
  0x0002,   /* U+58F1 */
  0x0002,   /* U+58F2 */
  0x0002,   /* U+58F3 */
  0x0002,   /* U+58F4 */
  0x0002,   /* U+58F5 */
  0x0002,   /* U+58F6 */
  0x0002,   /* U+58F7 */
  0x0002,   /* U+58F8 */
  0x0002,   /* U+58F9 */
  0x0002,   /* U+58FA */
  0x0002,   /* U+58FB */
  0x0002,   /* U+58FC */
  0x0002,   /* U+58FD */
  0x0002,   /* U+58FE */
  0x0002,   /* U+58FF */

  /* Primary weight 2 for each character. */
  0x0000,   /* U+5800 */
  0xD801,   /* U+5801 */
  0x0000,   /* U+5802 */
  0xD803,   /* U+5803 */
  0xD804,   /* U+5804 */
  0x0000,   /* U+5805 */
  0x0000,   /* U+5806 */
  0xD807,   /* U+5807 */
  0xD808,   /* U+5808 */
  0xD809,   /* U+5809 */
  0x0000,   /* U+580A */
  0x0000,   /* U+580B */
  0xD80C,   /* U+580C */
  0xD80D,   /* U+580D */
  0xD80E,   /* U+580E */
  0xD80F,   /* U+580F */
  0xD810,   /* U+5810 */
  0xD811,   /* U+5811 */
  0xD812,   /* U+5812 */
  0xD813,   /* U+5813 */
  0xD814,   /* U+5814 */
  0x0000,   /* U+5815 */
  0xD816,   /* U+5816 */
  0xD817,   /* U+5817 */
  0xD818,   /* U+5818 */
  0x0000,   /* U+5819 */
  0xD81A,   /* U+581A */
  0xD81B,   /* U+581B */
  0xD81C,   /* U+581C */
  0x0000,   /* U+581D */
  0xD81E,   /* U+581E */
  0xD81F,   /* U+581F */
  0xD820,   /* U+5820 */
  0x0000,   /* U+5821 */
  0xD822,   /* U+5822 */
  0xD823,   /* U+5823 */
  0x0000,   /* U+5824 */
  0xD825,   /* U+5825 */
  0xD826,   /* U+5826 */
  0xD827,   /* U+5827 */
  0xD828,   /* U+5828 */
  0xD829,   /* U+5829 */
  0x0000,   /* U+582A */
  0xD82B,   /* U+582B */
  0xD82C,   /* U+582C */
  0xD82D,   /* U+582D */
  0xD82E,   /* U+582E */
  0x0000,   /* U+582F */
  0x0000,   /* U+5830 */
  0x0000,   /* U+5831 */
  0xD832,   /* U+5832 */
  0xD833,   /* U+5833 */
  0x0000,   /* U+5834 */
  0x0000,   /* U+5835 */
  0xD836,   /* U+5836 */
  0xD837,   /* U+5837 */
  0xD838,   /* U+5838 */
  0xD839,   /* U+5839 */
  0x0000,   /* U+583A */
  0xD83B,   /* U+583B */
  0xD83C,   /* U+583C */
  0x0000,   /* U+583D */
  0xD83E,   /* U+583E */
  0xD83F,   /* U+583F */
  0x0000,   /* U+5840 */
  0x0000,   /* U+5841 */
  0xD842,   /* U+5842 */
  0xD843,   /* U+5843 */
  0xD844,   /* U+5844 */
  0xD845,   /* U+5845 */
  0xD846,   /* U+5846 */
  0xD847,   /* U+5847 */
  0xD848,   /* U+5848 */
  0xD849,   /* U+5849 */
  0x0000,   /* U+584A */
  0x0000,   /* U+584B */
  0xD84C,   /* U+584C */
  0xD84D,   /* U+584D */
  0xD84E,   /* U+584E */
  0xD84F,   /* U+584F */
  0xD850,   /* U+5850 */
  0x0000,   /* U+5851 */
  0x0000,   /* U+5852 */
  0xD853,   /* U+5853 */
  0x0000,   /* U+5854 */
  0xD855,   /* U+5855 */
  0xD856,   /* U+5856 */
  0x0000,   /* U+5857 */
  0x0000,   /* U+5858 */
  0x0000,   /* U+5859 */
  0x0000,   /* U+585A */
  0xD85B,   /* U+585B */
  0xD85C,   /* U+585C */
  0xD85D,   /* U+585D */
  0x0000,   /* U+585E */
  0xD85F,   /* U+585F */
  0xD860,   /* U+5860 */
  0xD861,   /* U+5861 */
  0x0000,   /* U+5862 */
  0xD863,   /* U+5863 */
  0xD864,   /* U+5864 */
  0xD865,   /* U+5865 */
  0xD866,   /* U+5866 */
  0xD867,   /* U+5867 */
  0xD868,   /* U+5868 */
  0x0000,   /* U+5869 */
  0xD86A,   /* U+586A */
  0x0000,   /* U+586B */
  0xD86C,   /* U+586C */
  0xD86D,   /* U+586D */
  0xD86E,   /* U+586E */
  0xD86F,   /* U+586F */
  0x0000,   /* U+5870 */
  0xD871,   /* U+5871 */
  0x0000,   /* U+5872 */
  0xD873,   /* U+5873 */
  0xD874,   /* U+5874 */
  0x0000,   /* U+5875 */
  0xD876,   /* U+5876 */
  0xD877,   /* U+5877 */
  0xD878,   /* U+5878 */
  0x0000,   /* U+5879 */
  0xD87A,   /* U+587A */
  0xD87B,   /* U+587B */
  0xD87C,   /* U+587C */
  0xD87D,   /* U+587D */
  0x0000,   /* U+587E */
  0xD87F,   /* U+587F */
  0xD880,   /* U+5880 */
  0xD881,   /* U+5881 */
  0xD882,   /* U+5882 */
  0x0000,   /* U+5883 */
  0xD884,   /* U+5884 */
  0x0000,   /* U+5885 */
  0xD886,   /* U+5886 */
  0xD887,   /* U+5887 */
  0xD888,   /* U+5888 */
  0xD889,   /* U+5889 */
  0xD88A,   /* U+588A */
  0xD88B,   /* U+588B */
  0xD88C,   /* U+588C */
  0xD88D,   /* U+588D */
  0xD88E,   /* U+588E */
  0xD88F,   /* U+588F */
  0xD890,   /* U+5890 */
  0xD891,   /* U+5891 */
  0xD892,   /* U+5892 */
  0x0000,   /* U+5893 */
  0xD894,   /* U+5894 */
  0xD895,   /* U+5895 */
  0xD896,   /* U+5896 */
  0x0000,   /* U+5897 */
  0xD898,   /* U+5898 */
  0xD899,   /* U+5899 */
  0xD89A,   /* U+589A */
  0xD89B,   /* U+589B */
  0x0000,   /* U+589C */
  0xD89D,   /* U+589D */
  0xD89E,   /* U+589E */
  0x0000,   /* U+589F */
  0xD8A0,   /* U+58A0 */
  0xD8A1,   /* U+58A1 */
  0xD8A2,   /* U+58A2 */
  0xD8A3,   /* U+58A3 */
  0xD8A4,   /* U+58A4 */
  0xD8A5,   /* U+58A5 */
  0xD8A6,   /* U+58A6 */
  0xD8A7,   /* U+58A7 */
  0x0000,   /* U+58A8 */
  0xD8A9,   /* U+58A9 */
  0xD8AA,   /* U+58AA */
  0x0000,   /* U+58AB */
  0xD8AC,   /* U+58AC */
  0xD8AD,   /* U+58AD */
  0x0000,   /* U+58AE */
  0xD8AF,   /* U+58AF */
  0xD8B0,   /* U+58B0 */
  0xD8B1,   /* U+58B1 */
  0xD8B2,   /* U+58B2 */
  0x0000,   /* U+58B3 */
  0xD8B4,   /* U+58B4 */
  0xD8B5,   /* U+58B5 */
  0xD8B6,   /* U+58B6 */
  0xD8B7,   /* U+58B7 */
  0x0000,   /* U+58B8 */
  0x0000,   /* U+58B9 */
  0x0000,   /* U+58BA */
  0x0000,   /* U+58BB */
  0xD8BC,   /* U+58BC */
  0xD8BD,   /* U+58BD */
  0x0000,   /* U+58BE */
  0xD8BF,   /* U+58BF */
  0xD8C0,   /* U+58C0 */
  0x0000,   /* U+58C1 */
  0xD8C2,   /* U+58C2 */
  0xD8C3,   /* U+58C3 */
  0xD8C4,   /* U+58C4 */
  0x0000,   /* U+58C5 */
  0xD8C6,   /* U+58C6 */
  0x0000,   /* U+58C7 */
  0xD8C8,   /* U+58C8 */
  0xD8C9,   /* U+58C9 */
  0x0000,   /* U+58CA */
  0xD8CB,   /* U+58CB */
  0x0000,   /* U+58CC */
  0xD8CD,   /* U+58CD */
  0xD8CE,   /* U+58CE */
  0xD8CF,   /* U+58CF */
  0xD8D0,   /* U+58D0 */
  0x0000,   /* U+58D1 */
  0xD8D2,   /* U+58D2 */
  0x0000,   /* U+58D3 */
  0xD8D4,   /* U+58D4 */
  0x0000,   /* U+58D5 */
  0xD8D6,   /* U+58D6 */
  0x0000,   /* U+58D7 */
  0x0000,   /* U+58D8 */
  0x0000,   /* U+58D9 */
  0xD8DA,   /* U+58DA */
  0xD8DB,   /* U+58DB */
  0x0000,   /* U+58DC */
  0xD8DD,   /* U+58DD */
  0x0000,   /* U+58DE */
  0x0000,   /* U+58DF */
  0xD8E0,   /* U+58E0 */
  0xD8E1,   /* U+58E1 */
  0xD8E2,   /* U+58E2 */
  0xD8E3,   /* U+58E3 */
  0x0000,   /* U+58E4 */
  0x0000,   /* U+58E5 */
  0xD8E6,   /* U+58E6 */
  0xD8E7,   /* U+58E7 */
  0xD8E8,   /* U+58E8 */
  0xD8E9,   /* U+58E9 */
  0xD8EA,   /* U+58EA */
  0x0000,   /* U+58EB */
  0x0000,   /* U+58EC */
  0xD8ED,   /* U+58ED */
  0x0000,   /* U+58EE */
  0x0000,   /* U+58EF */
  0x0000,   /* U+58F0 */
  0x0000,   /* U+58F1 */
  0x0000,   /* U+58F2 */
  0xD8F3,   /* U+58F3 */
  0xD8F4,   /* U+58F4 */
  0xD8F5,   /* U+58F5 */
  0xD8F6,   /* U+58F6 */
  0x0000,   /* U+58F7 */
  0xD8F8,   /* U+58F8 */
  0x0000,   /* U+58F9 */
  0x0000,   /* U+58FA */
  0x0000,   /* U+58FB */
  0x0000,   /* U+58FC */
  0x0000,   /* U+58FD */
  0xD8FE,   /* U+58FE */
  0xD8FF,   /* U+58FF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+5800 */
  0x0000,   /* U+5801 */
  0x0000,   /* U+5802 */
  0x0000,   /* U+5803 */
  0x0000,   /* U+5804 */
  0x0000,   /* U+5805 */
  0x0000,   /* U+5806 */
  0x0000,   /* U+5807 */
  0x0000,   /* U+5808 */
  0x0000,   /* U+5809 */
  0x0000,   /* U+580A */
  0x0000,   /* U+580B */
  0x0000,   /* U+580C */
  0x0000,   /* U+580D */
  0x0000,   /* U+580E */
  0x0000,   /* U+580F */
  0x0000,   /* U+5810 */
  0x0000,   /* U+5811 */
  0x0000,   /* U+5812 */
  0x0000,   /* U+5813 */
  0x0000,   /* U+5814 */
  0x0000,   /* U+5815 */
  0x0000,   /* U+5816 */
  0x0000,   /* U+5817 */
  0x0000,   /* U+5818 */
  0x0000,   /* U+5819 */
  0x0000,   /* U+581A */
  0x0000,   /* U+581B */
  0x0000,   /* U+581C */
  0x0000,   /* U+581D */
  0x0000,   /* U+581E */
  0x0000,   /* U+581F */
  0x0000,   /* U+5820 */
  0x0000,   /* U+5821 */
  0x0000,   /* U+5822 */
  0x0000,   /* U+5823 */
  0x0000,   /* U+5824 */
  0x0000,   /* U+5825 */
  0x0000,   /* U+5826 */
  0x0000,   /* U+5827 */
  0x0000,   /* U+5828 */
  0x0000,   /* U+5829 */
  0x0000,   /* U+582A */
  0x0000,   /* U+582B */
  0x0000,   /* U+582C */
  0x0000,   /* U+582D */
  0x0000,   /* U+582E */
  0x0000,   /* U+582F */
  0x0000,   /* U+5830 */
  0x0000,   /* U+5831 */
  0x0000,   /* U+5832 */
  0x0000,   /* U+5833 */
  0x0000,   /* U+5834 */
  0x0000,   /* U+5835 */
  0x0000,   /* U+5836 */
  0x0000,   /* U+5837 */
  0x0000,   /* U+5838 */
  0x0000,   /* U+5839 */
  0x0000,   /* U+583A */
  0x0000,   /* U+583B */
  0x0000,   /* U+583C */
  0x0000,   /* U+583D */
  0x0000,   /* U+583E */
  0x0000,   /* U+583F */
  0x0000,   /* U+5840 */
  0x0000,   /* U+5841 */
  0x0000,   /* U+5842 */
  0x0000,   /* U+5843 */
  0x0000,   /* U+5844 */
  0x0000,   /* U+5845 */
  0x0000,   /* U+5846 */
  0x0000,   /* U+5847 */
  0x0000,   /* U+5848 */
  0x0000,   /* U+5849 */
  0x0000,   /* U+584A */
  0x0000,   /* U+584B */
  0x0000,   /* U+584C */
  0x0000,   /* U+584D */
  0x0000,   /* U+584E */
  0x0000,   /* U+584F */
  0x0000,   /* U+5850 */
  0x0000,   /* U+5851 */
  0x0000,   /* U+5852 */
  0x0000,   /* U+5853 */
  0x0000,   /* U+5854 */
  0x0000,   /* U+5855 */
  0x0000,   /* U+5856 */
  0x0000,   /* U+5857 */
  0x0000,   /* U+5858 */
  0x0000,   /* U+5859 */
  0x0000,   /* U+585A */
  0x0000,   /* U+585B */
  0x0000,   /* U+585C */
  0x0000,   /* U+585D */
  0x0000,   /* U+585E */
  0x0000,   /* U+585F */
  0x0000,   /* U+5860 */
  0x0000,   /* U+5861 */
  0x0000,   /* U+5862 */
  0x0000,   /* U+5863 */
  0x0000,   /* U+5864 */
  0x0000,   /* U+5865 */
  0x0000,   /* U+5866 */
  0x0000,   /* U+5867 */
  0x0000,   /* U+5868 */
  0x0000,   /* U+5869 */
  0x0000,   /* U+586A */
  0x0000,   /* U+586B */
  0x0000,   /* U+586C */
  0x0000,   /* U+586D */
  0x0000,   /* U+586E */
  0x0000,   /* U+586F */
  0x0000,   /* U+5870 */
  0x0000,   /* U+5871 */
  0x0000,   /* U+5872 */
  0x0000,   /* U+5873 */
  0x0000,   /* U+5874 */
  0x0000,   /* U+5875 */
  0x0000,   /* U+5876 */
  0x0000,   /* U+5877 */
  0x0000,   /* U+5878 */
  0x0000,   /* U+5879 */
  0x0000,   /* U+587A */
  0x0000,   /* U+587B */
  0x0000,   /* U+587C */
  0x0000,   /* U+587D */
  0x0000,   /* U+587E */
  0x0000,   /* U+587F */
  0x0000,   /* U+5880 */
  0x0000,   /* U+5881 */
  0x0000,   /* U+5882 */
  0x0000,   /* U+5883 */
  0x0000,   /* U+5884 */
  0x0000,   /* U+5885 */
  0x0000,   /* U+5886 */
  0x0000,   /* U+5887 */
  0x0000,   /* U+5888 */
  0x0000,   /* U+5889 */
  0x0000,   /* U+588A */
  0x0000,   /* U+588B */
  0x0000,   /* U+588C */
  0x0000,   /* U+588D */
  0x0000,   /* U+588E */
  0x0000,   /* U+588F */
  0x0000,   /* U+5890 */
  0x0000,   /* U+5891 */
  0x0000,   /* U+5892 */
  0x0000,   /* U+5893 */
  0x0000,   /* U+5894 */
  0x0000,   /* U+5895 */
  0x0000,   /* U+5896 */
  0x0000,   /* U+5897 */
  0x0000,   /* U+5898 */
  0x0000,   /* U+5899 */
  0x0000,   /* U+589A */
  0x0000,   /* U+589B */
  0x0000,   /* U+589C */
  0x0000,   /* U+589D */
  0x0000,   /* U+589E */
  0x0000,   /* U+589F */
  0x0000,   /* U+58A0 */
  0x0000,   /* U+58A1 */
  0x0000,   /* U+58A2 */
  0x0000,   /* U+58A3 */
  0x0000,   /* U+58A4 */
  0x0000,   /* U+58A5 */
  0x0000,   /* U+58A6 */
  0x0000,   /* U+58A7 */
  0x0000,   /* U+58A8 */
  0x0000,   /* U+58A9 */
  0x0000,   /* U+58AA */
  0x0000,   /* U+58AB */
  0x0000,   /* U+58AC */
  0x0000,   /* U+58AD */
  0x0000,   /* U+58AE */
  0x0000,   /* U+58AF */
  0x0000,   /* U+58B0 */
  0x0000,   /* U+58B1 */
  0x0000,   /* U+58B2 */
  0x0000,   /* U+58B3 */
  0x0000,   /* U+58B4 */
  0x0000,   /* U+58B5 */
  0x0000,   /* U+58B6 */
  0x0000,   /* U+58B7 */
  0x0000,   /* U+58B8 */
  0x0000,   /* U+58B9 */
  0x0000,   /* U+58BA */
  0x0000,   /* U+58BB */
  0x0000,   /* U+58BC */
  0x0000,   /* U+58BD */
  0x0000,   /* U+58BE */
  0x0000,   /* U+58BF */
  0x0000,   /* U+58C0 */
  0x0000,   /* U+58C1 */
  0x0000,   /* U+58C2 */
  0x0000,   /* U+58C3 */
  0x0000,   /* U+58C4 */
  0x0000,   /* U+58C5 */
  0x0000,   /* U+58C6 */
  0x0000,   /* U+58C7 */
  0x0000,   /* U+58C8 */
  0x0000,   /* U+58C9 */
  0x0000,   /* U+58CA */
  0x0000,   /* U+58CB */
  0x0000,   /* U+58CC */
  0x0000,   /* U+58CD */
  0x0000,   /* U+58CE */
  0x0000,   /* U+58CF */
  0x0000,   /* U+58D0 */
  0x0000,   /* U+58D1 */
  0x0000,   /* U+58D2 */
  0x0000,   /* U+58D3 */
  0x0000,   /* U+58D4 */
  0x0000,   /* U+58D5 */
  0x0000,   /* U+58D6 */
  0x0000,   /* U+58D7 */
  0x0000,   /* U+58D8 */
  0x0000,   /* U+58D9 */
  0x0000,   /* U+58DA */
  0x0000,   /* U+58DB */
  0x0000,   /* U+58DC */
  0x0000,   /* U+58DD */
  0x0000,   /* U+58DE */
  0x0000,   /* U+58DF */
  0x0000,   /* U+58E0 */
  0x0000,   /* U+58E1 */
  0x0000,   /* U+58E2 */
  0x0000,   /* U+58E3 */
  0x0000,   /* U+58E4 */
  0x0000,   /* U+58E5 */
  0x0000,   /* U+58E6 */
  0x0000,   /* U+58E7 */
  0x0000,   /* U+58E8 */
  0x0000,   /* U+58E9 */
  0x0000,   /* U+58EA */
  0x0000,   /* U+58EB */
  0x0000,   /* U+58EC */
  0x0000,   /* U+58ED */
  0x0000,   /* U+58EE */
  0x0000,   /* U+58EF */
  0x0000,   /* U+58F0 */
  0x0000,   /* U+58F1 */
  0x0000,   /* U+58F2 */
  0x0000,   /* U+58F3 */
  0x0000,   /* U+58F4 */
  0x0000,   /* U+58F5 */
  0x0000,   /* U+58F6 */
  0x0000,   /* U+58F7 */
  0x0000,   /* U+58F8 */
  0x0000,   /* U+58F9 */
  0x0000,   /* U+58FA */
  0x0000,   /* U+58FB */
  0x0000,   /* U+58FC */
  0x0000,   /* U+58FD */
  0x0000,   /* U+58FE */
  0x0000,   /* U+58FF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+5800 */
  0x0000,   /* U+5801 */
  0x0000,   /* U+5802 */
  0x0000,   /* U+5803 */
  0x0000,   /* U+5804 */
  0x0000,   /* U+5805 */
  0x0000,   /* U+5806 */
  0x0000,   /* U+5807 */
  0x0000,   /* U+5808 */
  0x0000,   /* U+5809 */
  0x0000,   /* U+580A */
  0x0000,   /* U+580B */
  0x0000,   /* U+580C */
  0x0000,   /* U+580D */
  0x0000,   /* U+580E */
  0x0000,   /* U+580F */
  0x0000,   /* U+5810 */
  0x0000,   /* U+5811 */
  0x0000,   /* U+5812 */
  0x0000,   /* U+5813 */
  0x0000,   /* U+5814 */
  0x0000,   /* U+5815 */
  0x0000,   /* U+5816 */
  0x0000,   /* U+5817 */
  0x0000,   /* U+5818 */
  0x0000,   /* U+5819 */
  0x0000,   /* U+581A */
  0x0000,   /* U+581B */
  0x0000,   /* U+581C */
  0x0000,   /* U+581D */
  0x0000,   /* U+581E */
  0x0000,   /* U+581F */
  0x0000,   /* U+5820 */
  0x0000,   /* U+5821 */
  0x0000,   /* U+5822 */
  0x0000,   /* U+5823 */
  0x0000,   /* U+5824 */
  0x0000,   /* U+5825 */
  0x0000,   /* U+5826 */
  0x0000,   /* U+5827 */
  0x0000,   /* U+5828 */
  0x0000,   /* U+5829 */
  0x0000,   /* U+582A */
  0x0000,   /* U+582B */
  0x0000,   /* U+582C */
  0x0000,   /* U+582D */
  0x0000,   /* U+582E */
  0x0000,   /* U+582F */
  0x0000,   /* U+5830 */
  0x0000,   /* U+5831 */
  0x0000,   /* U+5832 */
  0x0000,   /* U+5833 */
  0x0000,   /* U+5834 */
  0x0000,   /* U+5835 */
  0x0000,   /* U+5836 */
  0x0000,   /* U+5837 */
  0x0000,   /* U+5838 */
  0x0000,   /* U+5839 */
  0x0000,   /* U+583A */
  0x0000,   /* U+583B */
  0x0000,   /* U+583C */
  0x0000,   /* U+583D */
  0x0000,   /* U+583E */
  0x0000,   /* U+583F */
  0x0000,   /* U+5840 */
  0x0000,   /* U+5841 */
  0x0000,   /* U+5842 */
  0x0000,   /* U+5843 */
  0x0000,   /* U+5844 */
  0x0000,   /* U+5845 */
  0x0000,   /* U+5846 */
  0x0000,   /* U+5847 */
  0x0000,   /* U+5848 */
  0x0000,   /* U+5849 */
  0x0000,   /* U+584A */
  0x0000,   /* U+584B */
  0x0000,   /* U+584C */
  0x0000,   /* U+584D */
  0x0000,   /* U+584E */
  0x0000,   /* U+584F */
  0x0000,   /* U+5850 */
  0x0000,   /* U+5851 */
  0x0000,   /* U+5852 */
  0x0000,   /* U+5853 */
  0x0000,   /* U+5854 */
  0x0000,   /* U+5855 */
  0x0000,   /* U+5856 */
  0x0000,   /* U+5857 */
  0x0000,   /* U+5858 */
  0x0000,   /* U+5859 */
  0x0000,   /* U+585A */
  0x0000,   /* U+585B */
  0x0000,   /* U+585C */
  0x0000,   /* U+585D */
  0x0000,   /* U+585E */
  0x0000,   /* U+585F */
  0x0000,   /* U+5860 */
  0x0000,   /* U+5861 */
  0x0000,   /* U+5862 */
  0x0000,   /* U+5863 */
  0x0000,   /* U+5864 */
  0x0000,   /* U+5865 */
  0x0000,   /* U+5866 */
  0x0000,   /* U+5867 */
  0x0000,   /* U+5868 */
  0x0000,   /* U+5869 */
  0x0000,   /* U+586A */
  0x0000,   /* U+586B */
  0x0000,   /* U+586C */
  0x0000,   /* U+586D */
  0x0000,   /* U+586E */
  0x0000,   /* U+586F */
  0x0000,   /* U+5870 */
  0x0000,   /* U+5871 */
  0x0000,   /* U+5872 */
  0x0000,   /* U+5873 */
  0x0000,   /* U+5874 */
  0x0000,   /* U+5875 */
  0x0000,   /* U+5876 */
  0x0000,   /* U+5877 */
  0x0000,   /* U+5878 */
  0x0000,   /* U+5879 */
  0x0000,   /* U+587A */
  0x0000,   /* U+587B */
  0x0000,   /* U+587C */
  0x0000,   /* U+587D */
  0x0000,   /* U+587E */
  0x0000,   /* U+587F */
  0x0000,   /* U+5880 */
  0x0000,   /* U+5881 */
  0x0000,   /* U+5882 */
  0x0000,   /* U+5883 */
  0x0000,   /* U+5884 */
  0x0000,   /* U+5885 */
  0x0000,   /* U+5886 */
  0x0000,   /* U+5887 */
  0x0000,   /* U+5888 */
  0x0000,   /* U+5889 */
  0x0000,   /* U+588A */
  0x0000,   /* U+588B */
  0x0000,   /* U+588C */
  0x0000,   /* U+588D */
  0x0000,   /* U+588E */
  0x0000,   /* U+588F */
  0x0000,   /* U+5890 */
  0x0000,   /* U+5891 */
  0x0000,   /* U+5892 */
  0x0000,   /* U+5893 */
  0x0000,   /* U+5894 */
  0x0000,   /* U+5895 */
  0x0000,   /* U+5896 */
  0x0000,   /* U+5897 */
  0x0000,   /* U+5898 */
  0x0000,   /* U+5899 */
  0x0000,   /* U+589A */
  0x0000,   /* U+589B */
  0x0000,   /* U+589C */
  0x0000,   /* U+589D */
  0x0000,   /* U+589E */
  0x0000,   /* U+589F */
  0x0000,   /* U+58A0 */
  0x0000,   /* U+58A1 */
  0x0000,   /* U+58A2 */
  0x0000,   /* U+58A3 */
  0x0000,   /* U+58A4 */
  0x0000,   /* U+58A5 */
  0x0000,   /* U+58A6 */
  0x0000,   /* U+58A7 */
  0x0000,   /* U+58A8 */
  0x0000,   /* U+58A9 */
  0x0000,   /* U+58AA */
  0x0000,   /* U+58AB */
  0x0000,   /* U+58AC */
  0x0000,   /* U+58AD */
  0x0000,   /* U+58AE */
  0x0000,   /* U+58AF */
  0x0000,   /* U+58B0 */
  0x0000,   /* U+58B1 */
  0x0000,   /* U+58B2 */
  0x0000,   /* U+58B3 */
  0x0000,   /* U+58B4 */
  0x0000,   /* U+58B5 */
  0x0000,   /* U+58B6 */
  0x0000,   /* U+58B7 */
  0x0000,   /* U+58B8 */
  0x0000,   /* U+58B9 */
  0x0000,   /* U+58BA */
  0x0000,   /* U+58BB */
  0x0000,   /* U+58BC */
  0x0000,   /* U+58BD */
  0x0000,   /* U+58BE */
  0x0000,   /* U+58BF */
  0x0000,   /* U+58C0 */
  0x0000,   /* U+58C1 */
  0x0000,   /* U+58C2 */
  0x0000,   /* U+58C3 */
  0x0000,   /* U+58C4 */
  0x0000,   /* U+58C5 */
  0x0000,   /* U+58C6 */
  0x0000,   /* U+58C7 */
  0x0000,   /* U+58C8 */
  0x0000,   /* U+58C9 */
  0x0000,   /* U+58CA */
  0x0000,   /* U+58CB */
  0x0000,   /* U+58CC */
  0x0000,   /* U+58CD */
  0x0000,   /* U+58CE */
  0x0000,   /* U+58CF */
  0x0000,   /* U+58D0 */
  0x0000,   /* U+58D1 */
  0x0000,   /* U+58D2 */
  0x0000,   /* U+58D3 */
  0x0000,   /* U+58D4 */
  0x0000,   /* U+58D5 */
  0x0000,   /* U+58D6 */
  0x0000,   /* U+58D7 */
  0x0000,   /* U+58D8 */
  0x0000,   /* U+58D9 */
  0x0000,   /* U+58DA */
  0x0000,   /* U+58DB */
  0x0000,   /* U+58DC */
  0x0000,   /* U+58DD */
  0x0000,   /* U+58DE */
  0x0000,   /* U+58DF */
  0x0000,   /* U+58E0 */
  0x0000,   /* U+58E1 */
  0x0000,   /* U+58E2 */
  0x0000,   /* U+58E3 */
  0x0000,   /* U+58E4 */
  0x0000,   /* U+58E5 */
  0x0000,   /* U+58E6 */
  0x0000,   /* U+58E7 */
  0x0000,   /* U+58E8 */
  0x0000,   /* U+58E9 */
  0x0000,   /* U+58EA */
  0x0000,   /* U+58EB */
  0x0000,   /* U+58EC */
  0x0000,   /* U+58ED */
  0x0000,   /* U+58EE */
  0x0000,   /* U+58EF */
  0x0000,   /* U+58F0 */
  0x0000,   /* U+58F1 */
  0x0000,   /* U+58F2 */
  0x0000,   /* U+58F3 */
  0x0000,   /* U+58F4 */
  0x0000,   /* U+58F5 */
  0x0000,   /* U+58F6 */
  0x0000,   /* U+58F7 */
  0x0000,   /* U+58F8 */
  0x0000,   /* U+58F9 */
  0x0000,   /* U+58FA */
  0x0000,   /* U+58FB */
  0x0000,   /* U+58FC */
  0x0000,   /* U+58FD */
  0x0000,   /* U+58FE */
  0x0000,   /* U+58FF */
};

uint16 ja_han_page59[]= {
  /* Number of CEs for each character. */
  2, 2, 1, 2, 2, 2, 2, 2, 2, 1, 1, 2, 2, 2, 2, 1,
  1, 2, 2, 2, 2, 1, 1, 2, 1, 1, 1, 1, 1, 2, 2, 2,
  2, 2, 1, 2, 2, 1, 2, 1, 2, 1, 1, 1, 1, 1, 1, 2,
  2, 1, 1, 2, 2, 2, 2, 1, 1, 2, 2, 2, 2, 2, 1, 2,
  2, 2, 2, 2, 1, 2, 2, 1, 1, 1, 2, 2, 2, 2, 1, 1,
  1, 1, 2, 2, 1, 1, 2, 1, 1, 2, 1, 2, 2, 2, 2, 2,
  1, 2, 1, 2, 2, 1, 2, 1, 1, 1, 1, 2, 1, 2, 1, 2,
  2, 2, 2, 1, 1, 2, 2, 2, 1, 2, 2, 2, 2, 1, 2, 2,
  2, 1, 1, 1, 1, 2, 2, 2, 2, 2, 1, 2, 2, 1, 2, 2,
  2, 2, 2, 1, 2, 2, 1, 2, 2, 1, 2, 1, 2, 1, 2, 2,
  2, 2, 2, 1, 2, 1, 2, 2, 1, 2, 2, 2, 1, 2, 2, 2,
  2, 2, 1, 2, 2, 2, 2, 2, 2, 1, 2, 1, 2, 2, 1, 2,
  2, 2, 2, 2, 2, 2, 1, 2, 2, 1, 2, 1, 2, 2, 2, 2,
  1, 1, 2, 1, 1, 2, 2, 2, 2, 1, 1, 2, 1, 2, 2, 2,
  2, 2, 2, 2, 2, 1, 1, 2, 1, 2, 1, 1, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 1, 2, 2, 2, 1,

  /* Primary weight 1 for each character. */
  0xFB40,   /* U+5900 */
  0xFB40,   /* U+5901 */
  0x61F9,   /* U+5902 */
  0xFB40,   /* U+5903 */
  0xFB40,   /* U+5904 */
  0xFB40,   /* U+5905 */
  0xFB40,   /* U+5906 */
  0xFB40,   /* U+5907 */
  0xFB40,   /* U+5908 */
  0x5E60,   /* U+5909 */
  0x61FA,   /* U+590A */
  0xFB40,   /* U+590B */
  0xFB40,   /* U+590C */
  0xFB40,   /* U+590D */
  0xFB40,   /* U+590E */
  0x5585,   /* U+590F */
  0x61FB,   /* U+5910 */
  0xFB40,   /* U+5911 */
  0xFB40,   /* U+5912 */
  0xFB40,   /* U+5913 */
  0xFB40,   /* U+5914 */
  0x5F65,   /* U+5915 */
  0x55CD,   /* U+5916 */
  0xFB40,   /* U+5917 */
  0x611D,   /* U+5918 */
  0x5991,   /* U+5919 */
  0x5B5E,   /* U+591A */
  0x61FC,   /* U+591B */
  0x5F36,   /* U+591C */
  0xFB40,   /* U+591D */
  0xFB40,   /* U+591E */
  0xFB40,   /* U+591F */
  0xFB40,   /* U+5920 */
  0xFB40,   /* U+5921 */
  0x5EFF,   /* U+5922 */
  0xFB40,   /* U+5923 */
  0xFB40,   /* U+5924 */
  0x61FE,   /* U+5925 */
  0xFB40,   /* U+5926 */
  0x5B86,   /* U+5927 */
  0xFB40,   /* U+5928 */
  0x5C70,   /* U+5929 */
  0x5B5F,   /* U+592A */
  0x5E08,   /* U+592B */
  0x61FF,   /* U+592C */
  0x6200,   /* U+592D */
  0x555C,   /* U+592E */
  0xFB40,   /* U+592F */
  0xFB40,   /* U+5930 */
  0x5925,   /* U+5931 */
  0x6201,   /* U+5932 */
  0xFB40,   /* U+5933 */
  0xFB40,   /* U+5934 */
  0xFB40,   /* U+5935 */
  0xFB40,   /* U+5936 */
  0x54D3,   /* U+5937 */
  0x6202,   /* U+5938 */
  0xFB40,   /* U+5939 */
  0xFB40,   /* U+593A */
  0xFB40,   /* U+593B */
  0xFB40,   /* U+593C */
  0xFB40,   /* U+593D */
  0x6203,   /* U+593E */
  0xFB40,   /* U+593F */
  0xFB40,   /* U+5940 */
  0xFB40,   /* U+5941 */
  0xFB40,   /* U+5942 */
  0xFB40,   /* U+5943 */
  0x5543,   /* U+5944 */
  0xFB40,   /* U+5945 */
  0xFB40,   /* U+5946 */
  0x566C,   /* U+5947 */
  0x5CF7,   /* U+5948 */
  0x5E83,   /* U+5949 */
  0xFB40,   /* U+594A */
  0xFB40,   /* U+594B */
  0xFB40,   /* U+594C */
  0xFB40,   /* U+594D */
  0x6207,   /* U+594E */
  0x5B16,   /* U+594F */
  0x6206,   /* U+5950 */
  0x5755,   /* U+5951 */
  0xFB40,   /* U+5952 */
  0xFB40,   /* U+5953 */
  0x5EC8,   /* U+5954 */
  0x6205,   /* U+5955 */
  0xFB40,   /* U+5956 */
  0x5C9E,   /* U+5957 */
  0x6209,   /* U+5958 */
  0xFB40,   /* U+5959 */
  0x6208,   /* U+595A */
  0xFB40,   /* U+595B */
  0xFB40,   /* U+595C */
  0xFB40,   /* U+595D */
  0xFB40,   /* U+595E */
  0xFB40,   /* U+595F */
  0x620B,   /* U+5960 */
  0xFB40,   /* U+5961 */
  0x620A,   /* U+5962 */
  0xFB40,   /* U+5963 */
  0xFB40,   /* U+5964 */
  0x555D,   /* U+5965 */
  0xFB40,   /* U+5966 */
  0x620C,   /* U+5967 */
  0x59D0,   /* U+5968 */
  0x620E,   /* U+5969 */
  0x5BA2,   /* U+596A */
  0xFB40,   /* U+596B */
  0x620D,   /* U+596C */
  0xFB40,   /* U+596D */
  0x5E42,   /* U+596E */
  0xFB40,   /* U+596F */
  0xFB40,   /* U+5970 */
  0xFB40,   /* U+5971 */
  0xFB40,   /* U+5972 */
  0x59C0,   /* U+5973 */
  0x5C94,   /* U+5974 */
  0xFB40,   /* U+5975 */
  0xFB40,   /* U+5976 */
  0xFB40,   /* U+5977 */
  0x620F,   /* U+5978 */
  0xFB40,   /* U+5979 */
  0xFB40,   /* U+597A */
  0xFB40,   /* U+597B */
  0xFB40,   /* U+597C */
  0x57F6,   /* U+597D */
  0xFB40,   /* U+597E */
  0xFB40,   /* U+597F */
  0xFB40,   /* U+5980 */
  0x6210,   /* U+5981 */
  0x5D16,   /* U+5982 */
  0x5DB1,   /* U+5983 */
  0x5F1C,   /* U+5984 */
  0xFB40,   /* U+5985 */
  0xFB40,   /* U+5986 */
  0xFB40,   /* U+5987 */
  0xFB40,   /* U+5988 */
  0xFB40,   /* U+5989 */
  0x5D1A,   /* U+598A */
  0xFB40,   /* U+598B */
  0xFB40,   /* U+598C */
  0x6219,   /* U+598D */
  0xFB40,   /* U+598E */
  0xFB40,   /* U+598F */
  0xFB40,   /* U+5990 */
  0xFB40,   /* U+5991 */
  0xFB40,   /* U+5992 */
  0x5691,   /* U+5993 */
  0xFB40,   /* U+5994 */
  0xFB40,   /* U+5995 */
  0x5F6E,   /* U+5996 */
  0xFB40,   /* U+5997 */
  0xFB40,   /* U+5998 */
  0x5EFA,   /* U+5999 */
  0xFB40,   /* U+599A */
  0x6278,   /* U+599B */
  0xFB40,   /* U+599C */
  0x6211,   /* U+599D */
  0xFB40,   /* U+599E */
  0xFB40,   /* U+599F */
  0xFB40,   /* U+59A0 */
  0xFB40,   /* U+59A1 */
  0xFB40,   /* U+59A2 */
  0x6214,   /* U+59A3 */
  0xFB40,   /* U+59A4 */
  0x5B64,   /* U+59A5 */
  0xFB40,   /* U+59A6 */
  0xFB40,   /* U+59A7 */
  0x5EA5,   /* U+59A8 */
  0xFB40,   /* U+59A9 */
  0xFB40,   /* U+59AA */
  0xFB40,   /* U+59AB */
  0x5C83,   /* U+59AC */
  0xFB40,   /* U+59AD */
  0xFB40,   /* U+59AE */
  0xFB40,   /* U+59AF */
  0xFB40,   /* U+59B0 */
  0xFB40,   /* U+59B1 */
  0x6215,   /* U+59B2 */
  0xFB40,   /* U+59B3 */
  0xFB40,   /* U+59B4 */
  0xFB40,   /* U+59B5 */
  0xFB40,   /* U+59B6 */
  0xFB40,   /* U+59B7 */
  0xFB40,   /* U+59B8 */
  0x5ED2,   /* U+59B9 */
  0xFB40,   /* U+59BA */
  0x5879,   /* U+59BB */
  0xFB40,   /* U+59BC */
  0xFB40,   /* U+59BD */
  0x59D1,   /* U+59BE */
  0xFB40,   /* U+59BF */
  0xFB40,   /* U+59C0 */
  0xFB40,   /* U+59C1 */
  0xFB40,   /* U+59C2 */
  0xFB40,   /* U+59C3 */
  0xFB40,   /* U+59C4 */
  0xFB40,   /* U+59C5 */
  0x6216,   /* U+59C6 */
  0xFB40,   /* U+59C7 */
  0xFB40,   /* U+59C8 */
  0x58DD,   /* U+59C9 */
  0xFB40,   /* U+59CA */
  0x58DC,   /* U+59CB */
  0xFB40,   /* U+59CC */
  0xFB40,   /* U+59CD */
  0xFB40,   /* U+59CE */
  0xFB40,   /* U+59CF */
  0x54BC,   /* U+59D0 */
  0x57BB,   /* U+59D1 */
  0xFB40,   /* U+59D2 */
  0x5A8E,   /* U+59D3 */
  0x54D4,   /* U+59D4 */
  0xFB40,   /* U+59D5 */
  0xFB40,   /* U+59D6 */
  0xFB40,   /* U+59D7 */
  0xFB40,   /* U+59D8 */
  0x621A,   /* U+59D9 */
  0x621B,   /* U+59DA */
  0xFB40,   /* U+59DB */
  0x6218,   /* U+59DC */
  0xFB40,   /* U+59DD */
  0xFB40,   /* U+59DE */
  0xFB40,   /* U+59DF */
  0xFB40,   /* U+59E0 */
  0xFB40,   /* U+59E1 */
  0xFB40,   /* U+59E2 */
  0xFB40,   /* U+59E3 */
  0xFB40,   /* U+59E4 */
  0x5519,   /* U+59E5 */
  0x562A,   /* U+59E6 */
  0xFB40,   /* U+59E7 */
  0x6217,   /* U+59E8 */
  0xFB40,   /* U+59E9 */
  0x5F10,   /* U+59EA */
  0x5DE2,   /* U+59EB */
  0xFB40,   /* U+59EC */
  0xFB40,   /* U+59ED */
  0xFB40,   /* U+59EE */
  0xFB40,   /* U+59EF */
  0xFB40,   /* U+59F0 */
  0xFB40,   /* U+59F1 */
  0xFB40,   /* U+59F2 */
  0xFB40,   /* U+59F3 */
  0xFB40,   /* U+59F4 */
  0xFB40,   /* U+59F5 */
  0x54AB,   /* U+59F6 */
  0xFB40,   /* U+59F7 */
  0xFB40,   /* U+59F8 */
  0xFB40,   /* U+59F9 */
  0xFB40,   /* U+59FA */
  0x54FC,   /* U+59FB */
  0xFB40,   /* U+59FC */
  0xFB40,   /* U+59FD */
  0xFB40,   /* U+59FE */
  0x58DE,   /* U+59FF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+5900 */
  0x0020,   /* U+5901 */
  0x0020,   /* U+5902 */
  0x0020,   /* U+5903 */
  0x0020,   /* U+5904 */
  0x0020,   /* U+5905 */
  0x0020,   /* U+5906 */
  0x0020,   /* U+5907 */
  0x0020,   /* U+5908 */
  0x0020,   /* U+5909 */
  0x0020,   /* U+590A */
  0x0020,   /* U+590B */
  0x0020,   /* U+590C */
  0x0020,   /* U+590D */
  0x0020,   /* U+590E */
  0x0020,   /* U+590F */
  0x0020,   /* U+5910 */
  0x0020,   /* U+5911 */
  0x0020,   /* U+5912 */
  0x0020,   /* U+5913 */
  0x0020,   /* U+5914 */
  0x0020,   /* U+5915 */
  0x0020,   /* U+5916 */
  0x0020,   /* U+5917 */
  0x0020,   /* U+5918 */
  0x0020,   /* U+5919 */
  0x0020,   /* U+591A */
  0x0020,   /* U+591B */
  0x0020,   /* U+591C */
  0x0020,   /* U+591D */
  0x0020,   /* U+591E */
  0x0020,   /* U+591F */
  0x0020,   /* U+5920 */
  0x0020,   /* U+5921 */
  0x0020,   /* U+5922 */
  0x0020,   /* U+5923 */
  0x0020,   /* U+5924 */
  0x0020,   /* U+5925 */
  0x0020,   /* U+5926 */
  0x0020,   /* U+5927 */
  0x0020,   /* U+5928 */
  0x0020,   /* U+5929 */
  0x0020,   /* U+592A */
  0x0020,   /* U+592B */
  0x0020,   /* U+592C */
  0x0020,   /* U+592D */
  0x0020,   /* U+592E */
  0x0020,   /* U+592F */
  0x0020,   /* U+5930 */
  0x0020,   /* U+5931 */
  0x0020,   /* U+5932 */
  0x0020,   /* U+5933 */
  0x0020,   /* U+5934 */
  0x0020,   /* U+5935 */
  0x0020,   /* U+5936 */
  0x0020,   /* U+5937 */
  0x0020,   /* U+5938 */
  0x0020,   /* U+5939 */
  0x0020,   /* U+593A */
  0x0020,   /* U+593B */
  0x0020,   /* U+593C */
  0x0020,   /* U+593D */
  0x0020,   /* U+593E */
  0x0020,   /* U+593F */
  0x0020,   /* U+5940 */
  0x0020,   /* U+5941 */
  0x0020,   /* U+5942 */
  0x0020,   /* U+5943 */
  0x0020,   /* U+5944 */
  0x0020,   /* U+5945 */
  0x0020,   /* U+5946 */
  0x0020,   /* U+5947 */
  0x0020,   /* U+5948 */
  0x0020,   /* U+5949 */
  0x0020,   /* U+594A */
  0x0020,   /* U+594B */
  0x0020,   /* U+594C */
  0x0020,   /* U+594D */
  0x0020,   /* U+594E */
  0x0020,   /* U+594F */
  0x0020,   /* U+5950 */
  0x0020,   /* U+5951 */
  0x0020,   /* U+5952 */
  0x0020,   /* U+5953 */
  0x0020,   /* U+5954 */
  0x0020,   /* U+5955 */
  0x0020,   /* U+5956 */
  0x0020,   /* U+5957 */
  0x0020,   /* U+5958 */
  0x0020,   /* U+5959 */
  0x0020,   /* U+595A */
  0x0020,   /* U+595B */
  0x0020,   /* U+595C */
  0x0020,   /* U+595D */
  0x0020,   /* U+595E */
  0x0020,   /* U+595F */
  0x0020,   /* U+5960 */
  0x0020,   /* U+5961 */
  0x0020,   /* U+5962 */
  0x0020,   /* U+5963 */
  0x0020,   /* U+5964 */
  0x0020,   /* U+5965 */
  0x0020,   /* U+5966 */
  0x0020,   /* U+5967 */
  0x0020,   /* U+5968 */
  0x0020,   /* U+5969 */
  0x0020,   /* U+596A */
  0x0020,   /* U+596B */
  0x0020,   /* U+596C */
  0x0020,   /* U+596D */
  0x0020,   /* U+596E */
  0x0020,   /* U+596F */
  0x0020,   /* U+5970 */
  0x0020,   /* U+5971 */
  0x0020,   /* U+5972 */
  0x0020,   /* U+5973 */
  0x0020,   /* U+5974 */
  0x0020,   /* U+5975 */
  0x0020,   /* U+5976 */
  0x0020,   /* U+5977 */
  0x0020,   /* U+5978 */
  0x0020,   /* U+5979 */
  0x0020,   /* U+597A */
  0x0020,   /* U+597B */
  0x0020,   /* U+597C */
  0x0020,   /* U+597D */
  0x0020,   /* U+597E */
  0x0020,   /* U+597F */
  0x0020,   /* U+5980 */
  0x0020,   /* U+5981 */
  0x0020,   /* U+5982 */
  0x0020,   /* U+5983 */
  0x0020,   /* U+5984 */
  0x0020,   /* U+5985 */
  0x0020,   /* U+5986 */
  0x0020,   /* U+5987 */
  0x0020,   /* U+5988 */
  0x0020,   /* U+5989 */
  0x0020,   /* U+598A */
  0x0020,   /* U+598B */
  0x0020,   /* U+598C */
  0x0020,   /* U+598D */
  0x0020,   /* U+598E */
  0x0020,   /* U+598F */
  0x0020,   /* U+5990 */
  0x0020,   /* U+5991 */
  0x0020,   /* U+5992 */
  0x0020,   /* U+5993 */
  0x0020,   /* U+5994 */
  0x0020,   /* U+5995 */
  0x0020,   /* U+5996 */
  0x0020,   /* U+5997 */
  0x0020,   /* U+5998 */
  0x0020,   /* U+5999 */
  0x0020,   /* U+599A */
  0x0020,   /* U+599B */
  0x0020,   /* U+599C */
  0x0020,   /* U+599D */
  0x0020,   /* U+599E */
  0x0020,   /* U+599F */
  0x0020,   /* U+59A0 */
  0x0020,   /* U+59A1 */
  0x0020,   /* U+59A2 */
  0x0020,   /* U+59A3 */
  0x0020,   /* U+59A4 */
  0x0020,   /* U+59A5 */
  0x0020,   /* U+59A6 */
  0x0020,   /* U+59A7 */
  0x0020,   /* U+59A8 */
  0x0020,   /* U+59A9 */
  0x0020,   /* U+59AA */
  0x0020,   /* U+59AB */
  0x0020,   /* U+59AC */
  0x0020,   /* U+59AD */
  0x0020,   /* U+59AE */
  0x0020,   /* U+59AF */
  0x0020,   /* U+59B0 */
  0x0020,   /* U+59B1 */
  0x0020,   /* U+59B2 */
  0x0020,   /* U+59B3 */
  0x0020,   /* U+59B4 */
  0x0020,   /* U+59B5 */
  0x0020,   /* U+59B6 */
  0x0020,   /* U+59B7 */
  0x0020,   /* U+59B8 */
  0x0020,   /* U+59B9 */
  0x0020,   /* U+59BA */
  0x0020,   /* U+59BB */
  0x0020,   /* U+59BC */
  0x0020,   /* U+59BD */
  0x0020,   /* U+59BE */
  0x0020,   /* U+59BF */
  0x0020,   /* U+59C0 */
  0x0020,   /* U+59C1 */
  0x0020,   /* U+59C2 */
  0x0020,   /* U+59C3 */
  0x0020,   /* U+59C4 */
  0x0020,   /* U+59C5 */
  0x0020,   /* U+59C6 */
  0x0020,   /* U+59C7 */
  0x0020,   /* U+59C8 */
  0x0020,   /* U+59C9 */
  0x0020,   /* U+59CA */
  0x0020,   /* U+59CB */
  0x0020,   /* U+59CC */
  0x0020,   /* U+59CD */
  0x0020,   /* U+59CE */
  0x0020,   /* U+59CF */
  0x0020,   /* U+59D0 */
  0x0020,   /* U+59D1 */
  0x0020,   /* U+59D2 */
  0x0020,   /* U+59D3 */
  0x0020,   /* U+59D4 */
  0x0020,   /* U+59D5 */
  0x0020,   /* U+59D6 */
  0x0020,   /* U+59D7 */
  0x0020,   /* U+59D8 */
  0x0020,   /* U+59D9 */
  0x0020,   /* U+59DA */
  0x0020,   /* U+59DB */
  0x0020,   /* U+59DC */
  0x0020,   /* U+59DD */
  0x0020,   /* U+59DE */
  0x0020,   /* U+59DF */
  0x0020,   /* U+59E0 */
  0x0020,   /* U+59E1 */
  0x0020,   /* U+59E2 */
  0x0020,   /* U+59E3 */
  0x0020,   /* U+59E4 */
  0x0020,   /* U+59E5 */
  0x0020,   /* U+59E6 */
  0x0020,   /* U+59E7 */
  0x0020,   /* U+59E8 */
  0x0020,   /* U+59E9 */
  0x0020,   /* U+59EA */
  0x0020,   /* U+59EB */
  0x0020,   /* U+59EC */
  0x0020,   /* U+59ED */
  0x0020,   /* U+59EE */
  0x0020,   /* U+59EF */
  0x0020,   /* U+59F0 */
  0x0020,   /* U+59F1 */
  0x0020,   /* U+59F2 */
  0x0020,   /* U+59F3 */
  0x0020,   /* U+59F4 */
  0x0020,   /* U+59F5 */
  0x0020,   /* U+59F6 */
  0x0020,   /* U+59F7 */
  0x0020,   /* U+59F8 */
  0x0020,   /* U+59F9 */
  0x0020,   /* U+59FA */
  0x0020,   /* U+59FB */
  0x0020,   /* U+59FC */
  0x0020,   /* U+59FD */
  0x0020,   /* U+59FE */
  0x0020,   /* U+59FF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+5900 */
  0x0002,   /* U+5901 */
  0x0002,   /* U+5902 */
  0x0002,   /* U+5903 */
  0x0002,   /* U+5904 */
  0x0002,   /* U+5905 */
  0x0002,   /* U+5906 */
  0x0002,   /* U+5907 */
  0x0002,   /* U+5908 */
  0x0002,   /* U+5909 */
  0x0002,   /* U+590A */
  0x0002,   /* U+590B */
  0x0002,   /* U+590C */
  0x0002,   /* U+590D */
  0x0002,   /* U+590E */
  0x0002,   /* U+590F */
  0x0002,   /* U+5910 */
  0x0002,   /* U+5911 */
  0x0002,   /* U+5912 */
  0x0002,   /* U+5913 */
  0x0002,   /* U+5914 */
  0x0002,   /* U+5915 */
  0x0002,   /* U+5916 */
  0x0002,   /* U+5917 */
  0x0002,   /* U+5918 */
  0x0002,   /* U+5919 */
  0x0002,   /* U+591A */
  0x0002,   /* U+591B */
  0x0002,   /* U+591C */
  0x0002,   /* U+591D */
  0x0002,   /* U+591E */
  0x0002,   /* U+591F */
  0x0002,   /* U+5920 */
  0x0002,   /* U+5921 */
  0x0002,   /* U+5922 */
  0x0002,   /* U+5923 */
  0x0002,   /* U+5924 */
  0x0002,   /* U+5925 */
  0x0002,   /* U+5926 */
  0x0002,   /* U+5927 */
  0x0002,   /* U+5928 */
  0x0002,   /* U+5929 */
  0x0002,   /* U+592A */
  0x0002,   /* U+592B */
  0x0002,   /* U+592C */
  0x0002,   /* U+592D */
  0x0002,   /* U+592E */
  0x0002,   /* U+592F */
  0x0002,   /* U+5930 */
  0x0002,   /* U+5931 */
  0x0002,   /* U+5932 */
  0x0002,   /* U+5933 */
  0x0002,   /* U+5934 */
  0x0002,   /* U+5935 */
  0x0002,   /* U+5936 */
  0x0002,   /* U+5937 */
  0x0002,   /* U+5938 */
  0x0002,   /* U+5939 */
  0x0002,   /* U+593A */
  0x0002,   /* U+593B */
  0x0002,   /* U+593C */
  0x0002,   /* U+593D */
  0x0002,   /* U+593E */
  0x0002,   /* U+593F */
  0x0002,   /* U+5940 */
  0x0002,   /* U+5941 */
  0x0002,   /* U+5942 */
  0x0002,   /* U+5943 */
  0x0002,   /* U+5944 */
  0x0002,   /* U+5945 */
  0x0002,   /* U+5946 */
  0x0002,   /* U+5947 */
  0x0002,   /* U+5948 */
  0x0002,   /* U+5949 */
  0x0002,   /* U+594A */
  0x0002,   /* U+594B */
  0x0002,   /* U+594C */
  0x0002,   /* U+594D */
  0x0002,   /* U+594E */
  0x0002,   /* U+594F */
  0x0002,   /* U+5950 */
  0x0002,   /* U+5951 */
  0x0002,   /* U+5952 */
  0x0002,   /* U+5953 */
  0x0002,   /* U+5954 */
  0x0002,   /* U+5955 */
  0x0002,   /* U+5956 */
  0x0002,   /* U+5957 */
  0x0002,   /* U+5958 */
  0x0002,   /* U+5959 */
  0x0002,   /* U+595A */
  0x0002,   /* U+595B */
  0x0002,   /* U+595C */
  0x0002,   /* U+595D */
  0x0002,   /* U+595E */
  0x0002,   /* U+595F */
  0x0002,   /* U+5960 */
  0x0002,   /* U+5961 */
  0x0002,   /* U+5962 */
  0x0002,   /* U+5963 */
  0x0002,   /* U+5964 */
  0x0002,   /* U+5965 */
  0x0002,   /* U+5966 */
  0x0002,   /* U+5967 */
  0x0002,   /* U+5968 */
  0x0002,   /* U+5969 */
  0x0002,   /* U+596A */
  0x0002,   /* U+596B */
  0x0002,   /* U+596C */
  0x0002,   /* U+596D */
  0x0002,   /* U+596E */
  0x0002,   /* U+596F */
  0x0002,   /* U+5970 */
  0x0002,   /* U+5971 */
  0x0002,   /* U+5972 */
  0x0002,   /* U+5973 */
  0x0002,   /* U+5974 */
  0x0002,   /* U+5975 */
  0x0002,   /* U+5976 */
  0x0002,   /* U+5977 */
  0x0002,   /* U+5978 */
  0x0002,   /* U+5979 */
  0x0002,   /* U+597A */
  0x0002,   /* U+597B */
  0x0002,   /* U+597C */
  0x0002,   /* U+597D */
  0x0002,   /* U+597E */
  0x0002,   /* U+597F */
  0x0002,   /* U+5980 */
  0x0002,   /* U+5981 */
  0x0002,   /* U+5982 */
  0x0002,   /* U+5983 */
  0x0002,   /* U+5984 */
  0x0002,   /* U+5985 */
  0x0002,   /* U+5986 */
  0x0002,   /* U+5987 */
  0x0002,   /* U+5988 */
  0x0002,   /* U+5989 */
  0x0002,   /* U+598A */
  0x0002,   /* U+598B */
  0x0002,   /* U+598C */
  0x0002,   /* U+598D */
  0x0002,   /* U+598E */
  0x0002,   /* U+598F */
  0x0002,   /* U+5990 */
  0x0002,   /* U+5991 */
  0x0002,   /* U+5992 */
  0x0002,   /* U+5993 */
  0x0002,   /* U+5994 */
  0x0002,   /* U+5995 */
  0x0002,   /* U+5996 */
  0x0002,   /* U+5997 */
  0x0002,   /* U+5998 */
  0x0002,   /* U+5999 */
  0x0002,   /* U+599A */
  0x0002,   /* U+599B */
  0x0002,   /* U+599C */
  0x0002,   /* U+599D */
  0x0002,   /* U+599E */
  0x0002,   /* U+599F */
  0x0002,   /* U+59A0 */
  0x0002,   /* U+59A1 */
  0x0002,   /* U+59A2 */
  0x0002,   /* U+59A3 */
  0x0002,   /* U+59A4 */
  0x0002,   /* U+59A5 */
  0x0002,   /* U+59A6 */
  0x0002,   /* U+59A7 */
  0x0002,   /* U+59A8 */
  0x0002,   /* U+59A9 */
  0x0002,   /* U+59AA */
  0x0002,   /* U+59AB */
  0x0002,   /* U+59AC */
  0x0002,   /* U+59AD */
  0x0002,   /* U+59AE */
  0x0002,   /* U+59AF */
  0x0002,   /* U+59B0 */
  0x0002,   /* U+59B1 */
  0x0002,   /* U+59B2 */
  0x0002,   /* U+59B3 */
  0x0002,   /* U+59B4 */
  0x0002,   /* U+59B5 */
  0x0002,   /* U+59B6 */
  0x0002,   /* U+59B7 */
  0x0002,   /* U+59B8 */
  0x0002,   /* U+59B9 */
  0x0002,   /* U+59BA */
  0x0002,   /* U+59BB */
  0x0002,   /* U+59BC */
  0x0002,   /* U+59BD */
  0x0002,   /* U+59BE */
  0x0002,   /* U+59BF */
  0x0002,   /* U+59C0 */
  0x0002,   /* U+59C1 */
  0x0002,   /* U+59C2 */
  0x0002,   /* U+59C3 */
  0x0002,   /* U+59C4 */
  0x0002,   /* U+59C5 */
  0x0002,   /* U+59C6 */
  0x0002,   /* U+59C7 */
  0x0002,   /* U+59C8 */
  0x0002,   /* U+59C9 */
  0x0002,   /* U+59CA */
  0x0002,   /* U+59CB */
  0x0002,   /* U+59CC */
  0x0002,   /* U+59CD */
  0x0002,   /* U+59CE */
  0x0002,   /* U+59CF */
  0x0002,   /* U+59D0 */
  0x0002,   /* U+59D1 */
  0x0002,   /* U+59D2 */
  0x0002,   /* U+59D3 */
  0x0002,   /* U+59D4 */
  0x0002,   /* U+59D5 */
  0x0002,   /* U+59D6 */
  0x0002,   /* U+59D7 */
  0x0002,   /* U+59D8 */
  0x0002,   /* U+59D9 */
  0x0002,   /* U+59DA */
  0x0002,   /* U+59DB */
  0x0002,   /* U+59DC */
  0x0002,   /* U+59DD */
  0x0002,   /* U+59DE */
  0x0002,   /* U+59DF */
  0x0002,   /* U+59E0 */
  0x0002,   /* U+59E1 */
  0x0002,   /* U+59E2 */
  0x0002,   /* U+59E3 */
  0x0002,   /* U+59E4 */
  0x0002,   /* U+59E5 */
  0x0002,   /* U+59E6 */
  0x0002,   /* U+59E7 */
  0x0002,   /* U+59E8 */
  0x0002,   /* U+59E9 */
  0x0002,   /* U+59EA */
  0x0002,   /* U+59EB */
  0x0002,   /* U+59EC */
  0x0002,   /* U+59ED */
  0x0002,   /* U+59EE */
  0x0002,   /* U+59EF */
  0x0002,   /* U+59F0 */
  0x0002,   /* U+59F1 */
  0x0002,   /* U+59F2 */
  0x0002,   /* U+59F3 */
  0x0002,   /* U+59F4 */
  0x0002,   /* U+59F5 */
  0x0002,   /* U+59F6 */
  0x0002,   /* U+59F7 */
  0x0002,   /* U+59F8 */
  0x0002,   /* U+59F9 */
  0x0002,   /* U+59FA */
  0x0002,   /* U+59FB */
  0x0002,   /* U+59FC */
  0x0002,   /* U+59FD */
  0x0002,   /* U+59FE */
  0x0002,   /* U+59FF */

  /* Primary weight 2 for each character. */
  0xD900,   /* U+5900 */
  0xD901,   /* U+5901 */
  0x0000,   /* U+5902 */
  0xD903,   /* U+5903 */
  0xD904,   /* U+5904 */
  0xD905,   /* U+5905 */
  0xD906,   /* U+5906 */
  0xD907,   /* U+5907 */
  0xD908,   /* U+5908 */
  0x0000,   /* U+5909 */
  0x0000,   /* U+590A */
  0xD90B,   /* U+590B */
  0xD90C,   /* U+590C */
  0xD90D,   /* U+590D */
  0xD90E,   /* U+590E */
  0x0000,   /* U+590F */
  0x0000,   /* U+5910 */
  0xD911,   /* U+5911 */
  0xD912,   /* U+5912 */
  0xD913,   /* U+5913 */
  0xD914,   /* U+5914 */
  0x0000,   /* U+5915 */
  0x0000,   /* U+5916 */
  0xD917,   /* U+5917 */
  0x0000,   /* U+5918 */
  0x0000,   /* U+5919 */
  0x0000,   /* U+591A */
  0x0000,   /* U+591B */
  0x0000,   /* U+591C */
  0xD91D,   /* U+591D */
  0xD91E,   /* U+591E */
  0xD91F,   /* U+591F */
  0xD920,   /* U+5920 */
  0xD921,   /* U+5921 */
  0x0000,   /* U+5922 */
  0xD923,   /* U+5923 */
  0xD924,   /* U+5924 */
  0x0000,   /* U+5925 */
  0xD926,   /* U+5926 */
  0x0000,   /* U+5927 */
  0xD928,   /* U+5928 */
  0x0000,   /* U+5929 */
  0x0000,   /* U+592A */
  0x0000,   /* U+592B */
  0x0000,   /* U+592C */
  0x0000,   /* U+592D */
  0x0000,   /* U+592E */
  0xD92F,   /* U+592F */
  0xD930,   /* U+5930 */
  0x0000,   /* U+5931 */
  0x0000,   /* U+5932 */
  0xD933,   /* U+5933 */
  0xD934,   /* U+5934 */
  0xD935,   /* U+5935 */
  0xD936,   /* U+5936 */
  0x0000,   /* U+5937 */
  0x0000,   /* U+5938 */
  0xD939,   /* U+5939 */
  0xD93A,   /* U+593A */
  0xD93B,   /* U+593B */
  0xD93C,   /* U+593C */
  0xD93D,   /* U+593D */
  0x0000,   /* U+593E */
  0xD93F,   /* U+593F */
  0xD940,   /* U+5940 */
  0xD941,   /* U+5941 */
  0xD942,   /* U+5942 */
  0xD943,   /* U+5943 */
  0x0000,   /* U+5944 */
  0xD945,   /* U+5945 */
  0xD946,   /* U+5946 */
  0x0000,   /* U+5947 */
  0x0000,   /* U+5948 */
  0x0000,   /* U+5949 */
  0xD94A,   /* U+594A */
  0xD94B,   /* U+594B */
  0xD94C,   /* U+594C */
  0xD94D,   /* U+594D */
  0x0000,   /* U+594E */
  0x0000,   /* U+594F */
  0x0000,   /* U+5950 */
  0x0000,   /* U+5951 */
  0xD952,   /* U+5952 */
  0xD953,   /* U+5953 */
  0x0000,   /* U+5954 */
  0x0000,   /* U+5955 */
  0xD956,   /* U+5956 */
  0x0000,   /* U+5957 */
  0x0000,   /* U+5958 */
  0xD959,   /* U+5959 */
  0x0000,   /* U+595A */
  0xD95B,   /* U+595B */
  0xD95C,   /* U+595C */
  0xD95D,   /* U+595D */
  0xD95E,   /* U+595E */
  0xD95F,   /* U+595F */
  0x0000,   /* U+5960 */
  0xD961,   /* U+5961 */
  0x0000,   /* U+5962 */
  0xD963,   /* U+5963 */
  0xD964,   /* U+5964 */
  0x0000,   /* U+5965 */
  0xD966,   /* U+5966 */
  0x0000,   /* U+5967 */
  0x0000,   /* U+5968 */
  0x0000,   /* U+5969 */
  0x0000,   /* U+596A */
  0xD96B,   /* U+596B */
  0x0000,   /* U+596C */
  0xD96D,   /* U+596D */
  0x0000,   /* U+596E */
  0xD96F,   /* U+596F */
  0xD970,   /* U+5970 */
  0xD971,   /* U+5971 */
  0xD972,   /* U+5972 */
  0x0000,   /* U+5973 */
  0x0000,   /* U+5974 */
  0xD975,   /* U+5975 */
  0xD976,   /* U+5976 */
  0xD977,   /* U+5977 */
  0x0000,   /* U+5978 */
  0xD979,   /* U+5979 */
  0xD97A,   /* U+597A */
  0xD97B,   /* U+597B */
  0xD97C,   /* U+597C */
  0x0000,   /* U+597D */
  0xD97E,   /* U+597E */
  0xD97F,   /* U+597F */
  0xD980,   /* U+5980 */
  0x0000,   /* U+5981 */
  0x0000,   /* U+5982 */
  0x0000,   /* U+5983 */
  0x0000,   /* U+5984 */
  0xD985,   /* U+5985 */
  0xD986,   /* U+5986 */
  0xD987,   /* U+5987 */
  0xD988,   /* U+5988 */
  0xD989,   /* U+5989 */
  0x0000,   /* U+598A */
  0xD98B,   /* U+598B */
  0xD98C,   /* U+598C */
  0x0000,   /* U+598D */
  0xD98E,   /* U+598E */
  0xD98F,   /* U+598F */
  0xD990,   /* U+5990 */
  0xD991,   /* U+5991 */
  0xD992,   /* U+5992 */
  0x0000,   /* U+5993 */
  0xD994,   /* U+5994 */
  0xD995,   /* U+5995 */
  0x0000,   /* U+5996 */
  0xD997,   /* U+5997 */
  0xD998,   /* U+5998 */
  0x0000,   /* U+5999 */
  0xD99A,   /* U+599A */
  0x0000,   /* U+599B */
  0xD99C,   /* U+599C */
  0x0000,   /* U+599D */
  0xD99E,   /* U+599E */
  0xD99F,   /* U+599F */
  0xD9A0,   /* U+59A0 */
  0xD9A1,   /* U+59A1 */
  0xD9A2,   /* U+59A2 */
  0x0000,   /* U+59A3 */
  0xD9A4,   /* U+59A4 */
  0x0000,   /* U+59A5 */
  0xD9A6,   /* U+59A6 */
  0xD9A7,   /* U+59A7 */
  0x0000,   /* U+59A8 */
  0xD9A9,   /* U+59A9 */
  0xD9AA,   /* U+59AA */
  0xD9AB,   /* U+59AB */
  0x0000,   /* U+59AC */
  0xD9AD,   /* U+59AD */
  0xD9AE,   /* U+59AE */
  0xD9AF,   /* U+59AF */
  0xD9B0,   /* U+59B0 */
  0xD9B1,   /* U+59B1 */
  0x0000,   /* U+59B2 */
  0xD9B3,   /* U+59B3 */
  0xD9B4,   /* U+59B4 */
  0xD9B5,   /* U+59B5 */
  0xD9B6,   /* U+59B6 */
  0xD9B7,   /* U+59B7 */
  0xD9B8,   /* U+59B8 */
  0x0000,   /* U+59B9 */
  0xD9BA,   /* U+59BA */
  0x0000,   /* U+59BB */
  0xD9BC,   /* U+59BC */
  0xD9BD,   /* U+59BD */
  0x0000,   /* U+59BE */
  0xD9BF,   /* U+59BF */
  0xD9C0,   /* U+59C0 */
  0xD9C1,   /* U+59C1 */
  0xD9C2,   /* U+59C2 */
  0xD9C3,   /* U+59C3 */
  0xD9C4,   /* U+59C4 */
  0xD9C5,   /* U+59C5 */
  0x0000,   /* U+59C6 */
  0xD9C7,   /* U+59C7 */
  0xD9C8,   /* U+59C8 */
  0x0000,   /* U+59C9 */
  0xD9CA,   /* U+59CA */
  0x0000,   /* U+59CB */
  0xD9CC,   /* U+59CC */
  0xD9CD,   /* U+59CD */
  0xD9CE,   /* U+59CE */
  0xD9CF,   /* U+59CF */
  0x0000,   /* U+59D0 */
  0x0000,   /* U+59D1 */
  0xD9D2,   /* U+59D2 */
  0x0000,   /* U+59D3 */
  0x0000,   /* U+59D4 */
  0xD9D5,   /* U+59D5 */
  0xD9D6,   /* U+59D6 */
  0xD9D7,   /* U+59D7 */
  0xD9D8,   /* U+59D8 */
  0x0000,   /* U+59D9 */
  0x0000,   /* U+59DA */
  0xD9DB,   /* U+59DB */
  0x0000,   /* U+59DC */
  0xD9DD,   /* U+59DD */
  0xD9DE,   /* U+59DE */
  0xD9DF,   /* U+59DF */
  0xD9E0,   /* U+59E0 */
  0xD9E1,   /* U+59E1 */
  0xD9E2,   /* U+59E2 */
  0xD9E3,   /* U+59E3 */
  0xD9E4,   /* U+59E4 */
  0x0000,   /* U+59E5 */
  0x0000,   /* U+59E6 */
  0xD9E7,   /* U+59E7 */
  0x0000,   /* U+59E8 */
  0xD9E9,   /* U+59E9 */
  0x0000,   /* U+59EA */
  0x0000,   /* U+59EB */
  0xD9EC,   /* U+59EC */
  0xD9ED,   /* U+59ED */
  0xD9EE,   /* U+59EE */
  0xD9EF,   /* U+59EF */
  0xD9F0,   /* U+59F0 */
  0xD9F1,   /* U+59F1 */
  0xD9F2,   /* U+59F2 */
  0xD9F3,   /* U+59F3 */
  0xD9F4,   /* U+59F4 */
  0xD9F5,   /* U+59F5 */
  0x0000,   /* U+59F6 */
  0xD9F7,   /* U+59F7 */
  0xD9F8,   /* U+59F8 */
  0xD9F9,   /* U+59F9 */
  0xD9FA,   /* U+59FA */
  0x0000,   /* U+59FB */
  0xD9FC,   /* U+59FC */
  0xD9FD,   /* U+59FD */
  0xD9FE,   /* U+59FE */
  0x0000,   /* U+59FF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+5900 */
  0x0000,   /* U+5901 */
  0x0000,   /* U+5902 */
  0x0000,   /* U+5903 */
  0x0000,   /* U+5904 */
  0x0000,   /* U+5905 */
  0x0000,   /* U+5906 */
  0x0000,   /* U+5907 */
  0x0000,   /* U+5908 */
  0x0000,   /* U+5909 */
  0x0000,   /* U+590A */
  0x0000,   /* U+590B */
  0x0000,   /* U+590C */
  0x0000,   /* U+590D */
  0x0000,   /* U+590E */
  0x0000,   /* U+590F */
  0x0000,   /* U+5910 */
  0x0000,   /* U+5911 */
  0x0000,   /* U+5912 */
  0x0000,   /* U+5913 */
  0x0000,   /* U+5914 */
  0x0000,   /* U+5915 */
  0x0000,   /* U+5916 */
  0x0000,   /* U+5917 */
  0x0000,   /* U+5918 */
  0x0000,   /* U+5919 */
  0x0000,   /* U+591A */
  0x0000,   /* U+591B */
  0x0000,   /* U+591C */
  0x0000,   /* U+591D */
  0x0000,   /* U+591E */
  0x0000,   /* U+591F */
  0x0000,   /* U+5920 */
  0x0000,   /* U+5921 */
  0x0000,   /* U+5922 */
  0x0000,   /* U+5923 */
  0x0000,   /* U+5924 */
  0x0000,   /* U+5925 */
  0x0000,   /* U+5926 */
  0x0000,   /* U+5927 */
  0x0000,   /* U+5928 */
  0x0000,   /* U+5929 */
  0x0000,   /* U+592A */
  0x0000,   /* U+592B */
  0x0000,   /* U+592C */
  0x0000,   /* U+592D */
  0x0000,   /* U+592E */
  0x0000,   /* U+592F */
  0x0000,   /* U+5930 */
  0x0000,   /* U+5931 */
  0x0000,   /* U+5932 */
  0x0000,   /* U+5933 */
  0x0000,   /* U+5934 */
  0x0000,   /* U+5935 */
  0x0000,   /* U+5936 */
  0x0000,   /* U+5937 */
  0x0000,   /* U+5938 */
  0x0000,   /* U+5939 */
  0x0000,   /* U+593A */
  0x0000,   /* U+593B */
  0x0000,   /* U+593C */
  0x0000,   /* U+593D */
  0x0000,   /* U+593E */
  0x0000,   /* U+593F */
  0x0000,   /* U+5940 */
  0x0000,   /* U+5941 */
  0x0000,   /* U+5942 */
  0x0000,   /* U+5943 */
  0x0000,   /* U+5944 */
  0x0000,   /* U+5945 */
  0x0000,   /* U+5946 */
  0x0000,   /* U+5947 */
  0x0000,   /* U+5948 */
  0x0000,   /* U+5949 */
  0x0000,   /* U+594A */
  0x0000,   /* U+594B */
  0x0000,   /* U+594C */
  0x0000,   /* U+594D */
  0x0000,   /* U+594E */
  0x0000,   /* U+594F */
  0x0000,   /* U+5950 */
  0x0000,   /* U+5951 */
  0x0000,   /* U+5952 */
  0x0000,   /* U+5953 */
  0x0000,   /* U+5954 */
  0x0000,   /* U+5955 */
  0x0000,   /* U+5956 */
  0x0000,   /* U+5957 */
  0x0000,   /* U+5958 */
  0x0000,   /* U+5959 */
  0x0000,   /* U+595A */
  0x0000,   /* U+595B */
  0x0000,   /* U+595C */
  0x0000,   /* U+595D */
  0x0000,   /* U+595E */
  0x0000,   /* U+595F */
  0x0000,   /* U+5960 */
  0x0000,   /* U+5961 */
  0x0000,   /* U+5962 */
  0x0000,   /* U+5963 */
  0x0000,   /* U+5964 */
  0x0000,   /* U+5965 */
  0x0000,   /* U+5966 */
  0x0000,   /* U+5967 */
  0x0000,   /* U+5968 */
  0x0000,   /* U+5969 */
  0x0000,   /* U+596A */
  0x0000,   /* U+596B */
  0x0000,   /* U+596C */
  0x0000,   /* U+596D */
  0x0000,   /* U+596E */
  0x0000,   /* U+596F */
  0x0000,   /* U+5970 */
  0x0000,   /* U+5971 */
  0x0000,   /* U+5972 */
  0x0000,   /* U+5973 */
  0x0000,   /* U+5974 */
  0x0000,   /* U+5975 */
  0x0000,   /* U+5976 */
  0x0000,   /* U+5977 */
  0x0000,   /* U+5978 */
  0x0000,   /* U+5979 */
  0x0000,   /* U+597A */
  0x0000,   /* U+597B */
  0x0000,   /* U+597C */
  0x0000,   /* U+597D */
  0x0000,   /* U+597E */
  0x0000,   /* U+597F */
  0x0000,   /* U+5980 */
  0x0000,   /* U+5981 */
  0x0000,   /* U+5982 */
  0x0000,   /* U+5983 */
  0x0000,   /* U+5984 */
  0x0000,   /* U+5985 */
  0x0000,   /* U+5986 */
  0x0000,   /* U+5987 */
  0x0000,   /* U+5988 */
  0x0000,   /* U+5989 */
  0x0000,   /* U+598A */
  0x0000,   /* U+598B */
  0x0000,   /* U+598C */
  0x0000,   /* U+598D */
  0x0000,   /* U+598E */
  0x0000,   /* U+598F */
  0x0000,   /* U+5990 */
  0x0000,   /* U+5991 */
  0x0000,   /* U+5992 */
  0x0000,   /* U+5993 */
  0x0000,   /* U+5994 */
  0x0000,   /* U+5995 */
  0x0000,   /* U+5996 */
  0x0000,   /* U+5997 */
  0x0000,   /* U+5998 */
  0x0000,   /* U+5999 */
  0x0000,   /* U+599A */
  0x0000,   /* U+599B */
  0x0000,   /* U+599C */
  0x0000,   /* U+599D */
  0x0000,   /* U+599E */
  0x0000,   /* U+599F */
  0x0000,   /* U+59A0 */
  0x0000,   /* U+59A1 */
  0x0000,   /* U+59A2 */
  0x0000,   /* U+59A3 */
  0x0000,   /* U+59A4 */
  0x0000,   /* U+59A5 */
  0x0000,   /* U+59A6 */
  0x0000,   /* U+59A7 */
  0x0000,   /* U+59A8 */
  0x0000,   /* U+59A9 */
  0x0000,   /* U+59AA */
  0x0000,   /* U+59AB */
  0x0000,   /* U+59AC */
  0x0000,   /* U+59AD */
  0x0000,   /* U+59AE */
  0x0000,   /* U+59AF */
  0x0000,   /* U+59B0 */
  0x0000,   /* U+59B1 */
  0x0000,   /* U+59B2 */
  0x0000,   /* U+59B3 */
  0x0000,   /* U+59B4 */
  0x0000,   /* U+59B5 */
  0x0000,   /* U+59B6 */
  0x0000,   /* U+59B7 */
  0x0000,   /* U+59B8 */
  0x0000,   /* U+59B9 */
  0x0000,   /* U+59BA */
  0x0000,   /* U+59BB */
  0x0000,   /* U+59BC */
  0x0000,   /* U+59BD */
  0x0000,   /* U+59BE */
  0x0000,   /* U+59BF */
  0x0000,   /* U+59C0 */
  0x0000,   /* U+59C1 */
  0x0000,   /* U+59C2 */
  0x0000,   /* U+59C3 */
  0x0000,   /* U+59C4 */
  0x0000,   /* U+59C5 */
  0x0000,   /* U+59C6 */
  0x0000,   /* U+59C7 */
  0x0000,   /* U+59C8 */
  0x0000,   /* U+59C9 */
  0x0000,   /* U+59CA */
  0x0000,   /* U+59CB */
  0x0000,   /* U+59CC */
  0x0000,   /* U+59CD */
  0x0000,   /* U+59CE */
  0x0000,   /* U+59CF */
  0x0000,   /* U+59D0 */
  0x0000,   /* U+59D1 */
  0x0000,   /* U+59D2 */
  0x0000,   /* U+59D3 */
  0x0000,   /* U+59D4 */
  0x0000,   /* U+59D5 */
  0x0000,   /* U+59D6 */
  0x0000,   /* U+59D7 */
  0x0000,   /* U+59D8 */
  0x0000,   /* U+59D9 */
  0x0000,   /* U+59DA */
  0x0000,   /* U+59DB */
  0x0000,   /* U+59DC */
  0x0000,   /* U+59DD */
  0x0000,   /* U+59DE */
  0x0000,   /* U+59DF */
  0x0000,   /* U+59E0 */
  0x0000,   /* U+59E1 */
  0x0000,   /* U+59E2 */
  0x0000,   /* U+59E3 */
  0x0000,   /* U+59E4 */
  0x0000,   /* U+59E5 */
  0x0000,   /* U+59E6 */
  0x0000,   /* U+59E7 */
  0x0000,   /* U+59E8 */
  0x0000,   /* U+59E9 */
  0x0000,   /* U+59EA */
  0x0000,   /* U+59EB */
  0x0000,   /* U+59EC */
  0x0000,   /* U+59ED */
  0x0000,   /* U+59EE */
  0x0000,   /* U+59EF */
  0x0000,   /* U+59F0 */
  0x0000,   /* U+59F1 */
  0x0000,   /* U+59F2 */
  0x0000,   /* U+59F3 */
  0x0000,   /* U+59F4 */
  0x0000,   /* U+59F5 */
  0x0000,   /* U+59F6 */
  0x0000,   /* U+59F7 */
  0x0000,   /* U+59F8 */
  0x0000,   /* U+59F9 */
  0x0000,   /* U+59FA */
  0x0000,   /* U+59FB */
  0x0000,   /* U+59FC */
  0x0000,   /* U+59FD */
  0x0000,   /* U+59FE */
  0x0000,   /* U+59FF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+5900 */
  0x0000,   /* U+5901 */
  0x0000,   /* U+5902 */
  0x0000,   /* U+5903 */
  0x0000,   /* U+5904 */
  0x0000,   /* U+5905 */
  0x0000,   /* U+5906 */
  0x0000,   /* U+5907 */
  0x0000,   /* U+5908 */
  0x0000,   /* U+5909 */
  0x0000,   /* U+590A */
  0x0000,   /* U+590B */
  0x0000,   /* U+590C */
  0x0000,   /* U+590D */
  0x0000,   /* U+590E */
  0x0000,   /* U+590F */
  0x0000,   /* U+5910 */
  0x0000,   /* U+5911 */
  0x0000,   /* U+5912 */
  0x0000,   /* U+5913 */
  0x0000,   /* U+5914 */
  0x0000,   /* U+5915 */
  0x0000,   /* U+5916 */
  0x0000,   /* U+5917 */
  0x0000,   /* U+5918 */
  0x0000,   /* U+5919 */
  0x0000,   /* U+591A */
  0x0000,   /* U+591B */
  0x0000,   /* U+591C */
  0x0000,   /* U+591D */
  0x0000,   /* U+591E */
  0x0000,   /* U+591F */
  0x0000,   /* U+5920 */
  0x0000,   /* U+5921 */
  0x0000,   /* U+5922 */
  0x0000,   /* U+5923 */
  0x0000,   /* U+5924 */
  0x0000,   /* U+5925 */
  0x0000,   /* U+5926 */
  0x0000,   /* U+5927 */
  0x0000,   /* U+5928 */
  0x0000,   /* U+5929 */
  0x0000,   /* U+592A */
  0x0000,   /* U+592B */
  0x0000,   /* U+592C */
  0x0000,   /* U+592D */
  0x0000,   /* U+592E */
  0x0000,   /* U+592F */
  0x0000,   /* U+5930 */
  0x0000,   /* U+5931 */
  0x0000,   /* U+5932 */
  0x0000,   /* U+5933 */
  0x0000,   /* U+5934 */
  0x0000,   /* U+5935 */
  0x0000,   /* U+5936 */
  0x0000,   /* U+5937 */
  0x0000,   /* U+5938 */
  0x0000,   /* U+5939 */
  0x0000,   /* U+593A */
  0x0000,   /* U+593B */
  0x0000,   /* U+593C */
  0x0000,   /* U+593D */
  0x0000,   /* U+593E */
  0x0000,   /* U+593F */
  0x0000,   /* U+5940 */
  0x0000,   /* U+5941 */
  0x0000,   /* U+5942 */
  0x0000,   /* U+5943 */
  0x0000,   /* U+5944 */
  0x0000,   /* U+5945 */
  0x0000,   /* U+5946 */
  0x0000,   /* U+5947 */
  0x0000,   /* U+5948 */
  0x0000,   /* U+5949 */
  0x0000,   /* U+594A */
  0x0000,   /* U+594B */
  0x0000,   /* U+594C */
  0x0000,   /* U+594D */
  0x0000,   /* U+594E */
  0x0000,   /* U+594F */
  0x0000,   /* U+5950 */
  0x0000,   /* U+5951 */
  0x0000,   /* U+5952 */
  0x0000,   /* U+5953 */
  0x0000,   /* U+5954 */
  0x0000,   /* U+5955 */
  0x0000,   /* U+5956 */
  0x0000,   /* U+5957 */
  0x0000,   /* U+5958 */
  0x0000,   /* U+5959 */
  0x0000,   /* U+595A */
  0x0000,   /* U+595B */
  0x0000,   /* U+595C */
  0x0000,   /* U+595D */
  0x0000,   /* U+595E */
  0x0000,   /* U+595F */
  0x0000,   /* U+5960 */
  0x0000,   /* U+5961 */
  0x0000,   /* U+5962 */
  0x0000,   /* U+5963 */
  0x0000,   /* U+5964 */
  0x0000,   /* U+5965 */
  0x0000,   /* U+5966 */
  0x0000,   /* U+5967 */
  0x0000,   /* U+5968 */
  0x0000,   /* U+5969 */
  0x0000,   /* U+596A */
  0x0000,   /* U+596B */
  0x0000,   /* U+596C */
  0x0000,   /* U+596D */
  0x0000,   /* U+596E */
  0x0000,   /* U+596F */
  0x0000,   /* U+5970 */
  0x0000,   /* U+5971 */
  0x0000,   /* U+5972 */
  0x0000,   /* U+5973 */
  0x0000,   /* U+5974 */
  0x0000,   /* U+5975 */
  0x0000,   /* U+5976 */
  0x0000,   /* U+5977 */
  0x0000,   /* U+5978 */
  0x0000,   /* U+5979 */
  0x0000,   /* U+597A */
  0x0000,   /* U+597B */
  0x0000,   /* U+597C */
  0x0000,   /* U+597D */
  0x0000,   /* U+597E */
  0x0000,   /* U+597F */
  0x0000,   /* U+5980 */
  0x0000,   /* U+5981 */
  0x0000,   /* U+5982 */
  0x0000,   /* U+5983 */
  0x0000,   /* U+5984 */
  0x0000,   /* U+5985 */
  0x0000,   /* U+5986 */
  0x0000,   /* U+5987 */
  0x0000,   /* U+5988 */
  0x0000,   /* U+5989 */
  0x0000,   /* U+598A */
  0x0000,   /* U+598B */
  0x0000,   /* U+598C */
  0x0000,   /* U+598D */
  0x0000,   /* U+598E */
  0x0000,   /* U+598F */
  0x0000,   /* U+5990 */
  0x0000,   /* U+5991 */
  0x0000,   /* U+5992 */
  0x0000,   /* U+5993 */
  0x0000,   /* U+5994 */
  0x0000,   /* U+5995 */
  0x0000,   /* U+5996 */
  0x0000,   /* U+5997 */
  0x0000,   /* U+5998 */
  0x0000,   /* U+5999 */
  0x0000,   /* U+599A */
  0x0000,   /* U+599B */
  0x0000,   /* U+599C */
  0x0000,   /* U+599D */
  0x0000,   /* U+599E */
  0x0000,   /* U+599F */
  0x0000,   /* U+59A0 */
  0x0000,   /* U+59A1 */
  0x0000,   /* U+59A2 */
  0x0000,   /* U+59A3 */
  0x0000,   /* U+59A4 */
  0x0000,   /* U+59A5 */
  0x0000,   /* U+59A6 */
  0x0000,   /* U+59A7 */
  0x0000,   /* U+59A8 */
  0x0000,   /* U+59A9 */
  0x0000,   /* U+59AA */
  0x0000,   /* U+59AB */
  0x0000,   /* U+59AC */
  0x0000,   /* U+59AD */
  0x0000,   /* U+59AE */
  0x0000,   /* U+59AF */
  0x0000,   /* U+59B0 */
  0x0000,   /* U+59B1 */
  0x0000,   /* U+59B2 */
  0x0000,   /* U+59B3 */
  0x0000,   /* U+59B4 */
  0x0000,   /* U+59B5 */
  0x0000,   /* U+59B6 */
  0x0000,   /* U+59B7 */
  0x0000,   /* U+59B8 */
  0x0000,   /* U+59B9 */
  0x0000,   /* U+59BA */
  0x0000,   /* U+59BB */
  0x0000,   /* U+59BC */
  0x0000,   /* U+59BD */
  0x0000,   /* U+59BE */
  0x0000,   /* U+59BF */
  0x0000,   /* U+59C0 */
  0x0000,   /* U+59C1 */
  0x0000,   /* U+59C2 */
  0x0000,   /* U+59C3 */
  0x0000,   /* U+59C4 */
  0x0000,   /* U+59C5 */
  0x0000,   /* U+59C6 */
  0x0000,   /* U+59C7 */
  0x0000,   /* U+59C8 */
  0x0000,   /* U+59C9 */
  0x0000,   /* U+59CA */
  0x0000,   /* U+59CB */
  0x0000,   /* U+59CC */
  0x0000,   /* U+59CD */
  0x0000,   /* U+59CE */
  0x0000,   /* U+59CF */
  0x0000,   /* U+59D0 */
  0x0000,   /* U+59D1 */
  0x0000,   /* U+59D2 */
  0x0000,   /* U+59D3 */
  0x0000,   /* U+59D4 */
  0x0000,   /* U+59D5 */
  0x0000,   /* U+59D6 */
  0x0000,   /* U+59D7 */
  0x0000,   /* U+59D8 */
  0x0000,   /* U+59D9 */
  0x0000,   /* U+59DA */
  0x0000,   /* U+59DB */
  0x0000,   /* U+59DC */
  0x0000,   /* U+59DD */
  0x0000,   /* U+59DE */
  0x0000,   /* U+59DF */
  0x0000,   /* U+59E0 */
  0x0000,   /* U+59E1 */
  0x0000,   /* U+59E2 */
  0x0000,   /* U+59E3 */
  0x0000,   /* U+59E4 */
  0x0000,   /* U+59E5 */
  0x0000,   /* U+59E6 */
  0x0000,   /* U+59E7 */
  0x0000,   /* U+59E8 */
  0x0000,   /* U+59E9 */
  0x0000,   /* U+59EA */
  0x0000,   /* U+59EB */
  0x0000,   /* U+59EC */
  0x0000,   /* U+59ED */
  0x0000,   /* U+59EE */
  0x0000,   /* U+59EF */
  0x0000,   /* U+59F0 */
  0x0000,   /* U+59F1 */
  0x0000,   /* U+59F2 */
  0x0000,   /* U+59F3 */
  0x0000,   /* U+59F4 */
  0x0000,   /* U+59F5 */
  0x0000,   /* U+59F6 */
  0x0000,   /* U+59F7 */
  0x0000,   /* U+59F8 */
  0x0000,   /* U+59F9 */
  0x0000,   /* U+59FA */
  0x0000,   /* U+59FB */
  0x0000,   /* U+59FC */
  0x0000,   /* U+59FD */
  0x0000,   /* U+59FE */
  0x0000,   /* U+59FF */
};

uint16 ja_han_page5A[]= {
  /* Number of CEs for each character. */
  2, 1, 2, 1, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2,
  2, 1, 2, 2, 2, 2, 2, 2, 1, 2, 1, 2, 1, 2, 2, 1,
  1, 2, 2, 2, 2, 1, 2, 2, 2, 1, 2, 2, 2, 2, 2, 1,
  2, 2, 2, 2, 2, 1, 1, 2, 2, 2, 2, 2, 1, 2, 2, 2,
  1, 1, 2, 2, 2, 2, 1, 2, 2, 1, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2,
  2, 2, 1, 2, 2, 2, 1, 2, 2, 2, 1, 2, 1, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 1, 1, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 2,
  2, 1, 1, 2, 2, 2, 2, 2, 2, 1, 2, 1, 1, 2, 2, 2,
  1, 2, 2, 2, 2, 2, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 1, 2, 1, 2, 2, 1, 2, 2, 1, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 2, 2, 2, 2,

  /* Primary weight 1 for each character. */
  0xFB40,   /* U+5A00 */
  0x54D5,   /* U+5A01 */
  0xFB40,   /* U+5A02 */
  0x54A6,   /* U+5A03 */
  0xFB40,   /* U+5A04 */
  0xFB40,   /* U+5A05 */
  0xFB40,   /* U+5A06 */
  0xFB40,   /* U+5A07 */
  0xFB40,   /* U+5A08 */
  0x6220,   /* U+5A09 */
  0xFB40,   /* U+5A0A */
  0xFB40,   /* U+5A0B */
  0xFB40,   /* U+5A0C */
  0xFB40,   /* U+5A0D */
  0xFB40,   /* U+5A0E */
  0xFB40,   /* U+5A0F */
  0xFB40,   /* U+5A10 */
  0x621E,   /* U+5A11 */
  0xFB40,   /* U+5A12 */
  0xFB40,   /* U+5A13 */
  0xFB40,   /* U+5A14 */
  0xFB40,   /* U+5A15 */
  0xFB40,   /* U+5A16 */
  0xFB40,   /* U+5A17 */
  0x5F07,   /* U+5A18 */
  0xFB40,   /* U+5A19 */
  0x6221,   /* U+5A1A */
  0xFB40,   /* U+5A1B */
  0x621F,   /* U+5A1C */
  0xFB40,   /* U+5A1D */
  0xFB40,   /* U+5A1E */
  0x621D,   /* U+5A1F */
  0x5A36,   /* U+5A20 */
  0xFB40,   /* U+5A21 */
  0xFB40,   /* U+5A22 */
  0xFB40,   /* U+5A23 */
  0xFB40,   /* U+5A24 */
  0x621C,   /* U+5A25 */
  0xFB40,   /* U+5A26 */
  0xFB40,   /* U+5A27 */
  0xFB40,   /* U+5A28 */
  0x5E69,   /* U+5A29 */
  0xFB40,   /* U+5A2A */
  0xFB40,   /* U+5A2B */
  0xFB40,   /* U+5A2C */
  0xFB40,   /* U+5A2D */
  0xFB40,   /* U+5A2E */
  0x57D7,   /* U+5A2F */
  0xFB40,   /* U+5A30 */
  0xFB40,   /* U+5A31 */
  0xFB40,   /* U+5A32 */
  0xFB40,   /* U+5A33 */
  0xFB40,   /* U+5A34 */
  0x6225,   /* U+5A35 */
  0x6226,   /* U+5A36 */
  0xFB40,   /* U+5A37 */
  0xFB40,   /* U+5A38 */
  0xFB40,   /* U+5A39 */
  0xFB40,   /* U+5A3A */
  0xFB40,   /* U+5A3B */
  0x59D2,   /* U+5A3C */
  0xFB40,   /* U+5A3D */
  0xFB40,   /* U+5A3E */
  0xFB40,   /* U+5A3F */
  0x6222,   /* U+5A40 */
  0x6011,   /* U+5A41 */
  0xFB40,   /* U+5A42 */
  0xFB40,   /* U+5A43 */
  0xFB40,   /* U+5A44 */
  0xFB40,   /* U+5A45 */
  0x5D41,   /* U+5A46 */
  0xFB40,   /* U+5A47 */
  0xFB40,   /* U+5A48 */
  0x6224,   /* U+5A49 */
  0xFB40,   /* U+5A4A */
  0xFB40,   /* U+5A4B */
  0xFB40,   /* U+5A4C */
  0xFB40,   /* U+5A4D */
  0xFB40,   /* U+5A4E */
  0xFB40,   /* U+5A4F */
  0xFB40,   /* U+5A50 */
  0xFB40,   /* U+5A51 */
  0xFB40,   /* U+5A52 */
  0xFB40,   /* U+5A53 */
  0xFB40,   /* U+5A54 */
  0xFB40,   /* U+5A55 */
  0xFB40,   /* U+5A56 */
  0xFB40,   /* U+5A57 */
  0xFB40,   /* U+5A58 */
  0xFB40,   /* U+5A59 */
  0x5856,   /* U+5A5A */
  0xFB40,   /* U+5A5B */
  0xFB40,   /* U+5A5C */
  0xFB40,   /* U+5A5D */
  0xFB40,   /* U+5A5E */
  0xFB40,   /* U+5A5F */
  0xFB40,   /* U+5A60 */
  0xFB40,   /* U+5A61 */
  0x6227,   /* U+5A62 */
  0xFB40,   /* U+5A63 */
  0xFB40,   /* U+5A64 */
  0xFB40,   /* U+5A65 */
  0x5E09,   /* U+5A66 */
  0xFB40,   /* U+5A67 */
  0xFB40,   /* U+5A68 */
  0xFB40,   /* U+5A69 */
  0x6228,   /* U+5A6A */
  0xFB40,   /* U+5A6B */
  0x6223,   /* U+5A6C */
  0xFB40,   /* U+5A6D */
  0xFB40,   /* U+5A6E */
  0xFB40,   /* U+5A6F */
  0xFB40,   /* U+5A70 */
  0xFB40,   /* U+5A71 */
  0xFB40,   /* U+5A72 */
  0xFB40,   /* U+5A73 */
  0xFB40,   /* U+5A74 */
  0xFB40,   /* U+5A75 */
  0xFB40,   /* U+5A76 */
  0xFB40,   /* U+5A77 */
  0xFB40,   /* U+5A78 */
  0xFB40,   /* U+5A79 */
  0xFB40,   /* U+5A7A */
  0xFB40,   /* U+5A7B */
  0xFB40,   /* U+5A7C */
  0xFB40,   /* U+5A7D */
  0xFB40,   /* U+5A7E */
  0x5F06,   /* U+5A7F */
  0xFB40,   /* U+5A80 */
  0xFB40,   /* U+5A81 */
  0xFB40,   /* U+5A82 */
  0xFB40,   /* U+5A83 */
  0xFB40,   /* U+5A84 */
  0xFB40,   /* U+5A85 */
  0xFB40,   /* U+5A86 */
  0xFB40,   /* U+5A87 */
  0xFB40,   /* U+5A88 */
  0xFB40,   /* U+5A89 */
  0xFB40,   /* U+5A8A */
  0xFB40,   /* U+5A8B */
  0xFB40,   /* U+5A8C */
  0xFB40,   /* U+5A8D */
  0xFB40,   /* U+5A8E */
  0xFB40,   /* U+5A8F */
  0xFB40,   /* U+5A90 */
  0xFB40,   /* U+5A91 */
  0x5D53,   /* U+5A92 */
  0xFB40,   /* U+5A93 */
  0xFB40,   /* U+5A94 */
  0xFB40,   /* U+5A95 */
  0xFB40,   /* U+5A96 */
  0xFB40,   /* U+5A97 */
  0xFB40,   /* U+5A98 */
  0xFB40,   /* U+5A99 */
  0x6229,   /* U+5A9A */
  0x5DE3,   /* U+5A9B */
  0xFB40,   /* U+5A9C */
  0xFB40,   /* U+5A9D */
  0xFB40,   /* U+5A9E */
  0xFB40,   /* U+5A9F */
  0xFB40,   /* U+5AA0 */
  0xFB40,   /* U+5AA1 */
  0xFB40,   /* U+5AA2 */
  0xFB40,   /* U+5AA3 */
  0xFB40,   /* U+5AA4 */
  0xFB40,   /* U+5AA5 */
  0xFB40,   /* U+5AA6 */
  0xFB40,   /* U+5AA7 */
  0xFB40,   /* U+5AA8 */
  0xFB40,   /* U+5AA9 */
  0xFB40,   /* U+5AAA */
  0xFB40,   /* U+5AAB */
  0xFB40,   /* U+5AAC */
  0xFB40,   /* U+5AAD */
  0xFB40,   /* U+5AAE */
  0xFB40,   /* U+5AAF */
  0xFB40,   /* U+5AB0 */
  0xFB40,   /* U+5AB1 */
  0xFB40,   /* U+5AB2 */
  0xFB40,   /* U+5AB3 */
  0xFB40,   /* U+5AB4 */
  0xFB40,   /* U+5AB5 */
  0xFB40,   /* U+5AB6 */
  0xFB40,   /* U+5AB7 */
  0xFB40,   /* U+5AB8 */
  0xFB40,   /* U+5AB9 */
  0xFB40,   /* U+5ABA */
  0xFB40,   /* U+5ABB */
  0x622A,   /* U+5ABC */
  0x622E,   /* U+5ABD */
  0x622B,   /* U+5ABE */
  0xFB40,   /* U+5ABF */
  0xFB40,   /* U+5AC0 */
  0x5586,   /* U+5AC1 */
  0x622D,   /* U+5AC2 */
  0xFB40,   /* U+5AC3 */
  0xFB40,   /* U+5AC4 */
  0xFB40,   /* U+5AC5 */
  0xFB40,   /* U+5AC6 */
  0xFB40,   /* U+5AC7 */
  0xFB40,   /* U+5AC8 */
  0x5926,   /* U+5AC9 */
  0xFB40,   /* U+5ACA */
  0x622C,   /* U+5ACB */
  0x578E,   /* U+5ACC */
  0xFB40,   /* U+5ACD */
  0xFB40,   /* U+5ACE */
  0xFB40,   /* U+5ACF */
  0x623A,   /* U+5AD0 */
  0xFB40,   /* U+5AD1 */
  0xFB40,   /* U+5AD2 */
  0xFB40,   /* U+5AD3 */
  0xFB40,   /* U+5AD4 */
  0xFB40,   /* U+5AD5 */
  0x6233,   /* U+5AD6 */
  0x6230,   /* U+5AD7 */
  0xFB40,   /* U+5AD8 */
  0xFB40,   /* U+5AD9 */
  0xFB40,   /* U+5ADA */
  0xFB40,   /* U+5ADB */
  0xFB40,   /* U+5ADC */
  0xFB40,   /* U+5ADD */
  0xFB40,   /* U+5ADE */
  0xFB40,   /* U+5ADF */
  0xFB40,   /* U+5AE0 */
  0x5BE1,   /* U+5AE1 */
  0xFB40,   /* U+5AE2 */
  0x622F,   /* U+5AE3 */
  0xFB40,   /* U+5AE4 */
  0xFB40,   /* U+5AE5 */
  0x6231,   /* U+5AE6 */
  0xFB40,   /* U+5AE7 */
  0xFB40,   /* U+5AE8 */
  0x6232,   /* U+5AE9 */
  0xFB40,   /* U+5AEA */
  0xFB40,   /* U+5AEB */
  0xFB40,   /* U+5AEC */
  0xFB40,   /* U+5AED */
  0xFB40,   /* U+5AEE */
  0xFB40,   /* U+5AEF */
  0xFB40,   /* U+5AF0 */
  0xFB40,   /* U+5AF1 */
  0xFB40,   /* U+5AF2 */
  0xFB40,   /* U+5AF3 */
  0xFB40,   /* U+5AF4 */
  0xFB40,   /* U+5AF5 */
  0xFB40,   /* U+5AF6 */
  0xFB40,   /* U+5AF7 */
  0xFB40,   /* U+5AF8 */
  0xFB40,   /* U+5AF9 */
  0x6234,   /* U+5AFA */
  0x6235,   /* U+5AFB */
  0xFB40,   /* U+5AFC */
  0xFB40,   /* U+5AFD */
  0xFB40,   /* U+5AFE */
  0xFB40,   /* U+5AFF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+5A00 */
  0x0020,   /* U+5A01 */
  0x0020,   /* U+5A02 */
  0x0020,   /* U+5A03 */
  0x0020,   /* U+5A04 */
  0x0020,   /* U+5A05 */
  0x0020,   /* U+5A06 */
  0x0020,   /* U+5A07 */
  0x0020,   /* U+5A08 */
  0x0020,   /* U+5A09 */
  0x0020,   /* U+5A0A */
  0x0020,   /* U+5A0B */
  0x0020,   /* U+5A0C */
  0x0020,   /* U+5A0D */
  0x0020,   /* U+5A0E */
  0x0020,   /* U+5A0F */
  0x0020,   /* U+5A10 */
  0x0020,   /* U+5A11 */
  0x0020,   /* U+5A12 */
  0x0020,   /* U+5A13 */
  0x0020,   /* U+5A14 */
  0x0020,   /* U+5A15 */
  0x0020,   /* U+5A16 */
  0x0020,   /* U+5A17 */
  0x0020,   /* U+5A18 */
  0x0020,   /* U+5A19 */
  0x0020,   /* U+5A1A */
  0x0020,   /* U+5A1B */
  0x0020,   /* U+5A1C */
  0x0020,   /* U+5A1D */
  0x0020,   /* U+5A1E */
  0x0020,   /* U+5A1F */
  0x0020,   /* U+5A20 */
  0x0020,   /* U+5A21 */
  0x0020,   /* U+5A22 */
  0x0020,   /* U+5A23 */
  0x0020,   /* U+5A24 */
  0x0020,   /* U+5A25 */
  0x0020,   /* U+5A26 */
  0x0020,   /* U+5A27 */
  0x0020,   /* U+5A28 */
  0x0020,   /* U+5A29 */
  0x0020,   /* U+5A2A */
  0x0020,   /* U+5A2B */
  0x0020,   /* U+5A2C */
  0x0020,   /* U+5A2D */
  0x0020,   /* U+5A2E */
  0x0020,   /* U+5A2F */
  0x0020,   /* U+5A30 */
  0x0020,   /* U+5A31 */
  0x0020,   /* U+5A32 */
  0x0020,   /* U+5A33 */
  0x0020,   /* U+5A34 */
  0x0020,   /* U+5A35 */
  0x0020,   /* U+5A36 */
  0x0020,   /* U+5A37 */
  0x0020,   /* U+5A38 */
  0x0020,   /* U+5A39 */
  0x0020,   /* U+5A3A */
  0x0020,   /* U+5A3B */
  0x0020,   /* U+5A3C */
  0x0020,   /* U+5A3D */
  0x0020,   /* U+5A3E */
  0x0020,   /* U+5A3F */
  0x0020,   /* U+5A40 */
  0x0020,   /* U+5A41 */
  0x0020,   /* U+5A42 */
  0x0020,   /* U+5A43 */
  0x0020,   /* U+5A44 */
  0x0020,   /* U+5A45 */
  0x0020,   /* U+5A46 */
  0x0020,   /* U+5A47 */
  0x0020,   /* U+5A48 */
  0x0020,   /* U+5A49 */
  0x0020,   /* U+5A4A */
  0x0020,   /* U+5A4B */
  0x0020,   /* U+5A4C */
  0x0020,   /* U+5A4D */
  0x0020,   /* U+5A4E */
  0x0020,   /* U+5A4F */
  0x0020,   /* U+5A50 */
  0x0020,   /* U+5A51 */
  0x0020,   /* U+5A52 */
  0x0020,   /* U+5A53 */
  0x0020,   /* U+5A54 */
  0x0020,   /* U+5A55 */
  0x0020,   /* U+5A56 */
  0x0020,   /* U+5A57 */
  0x0020,   /* U+5A58 */
  0x0020,   /* U+5A59 */
  0x0020,   /* U+5A5A */
  0x0020,   /* U+5A5B */
  0x0020,   /* U+5A5C */
  0x0020,   /* U+5A5D */
  0x0020,   /* U+5A5E */
  0x0020,   /* U+5A5F */
  0x0020,   /* U+5A60 */
  0x0020,   /* U+5A61 */
  0x0020,   /* U+5A62 */
  0x0020,   /* U+5A63 */
  0x0020,   /* U+5A64 */
  0x0020,   /* U+5A65 */
  0x0020,   /* U+5A66 */
  0x0020,   /* U+5A67 */
  0x0020,   /* U+5A68 */
  0x0020,   /* U+5A69 */
  0x0020,   /* U+5A6A */
  0x0020,   /* U+5A6B */
  0x0020,   /* U+5A6C */
  0x0020,   /* U+5A6D */
  0x0020,   /* U+5A6E */
  0x0020,   /* U+5A6F */
  0x0020,   /* U+5A70 */
  0x0020,   /* U+5A71 */
  0x0020,   /* U+5A72 */
  0x0020,   /* U+5A73 */
  0x0020,   /* U+5A74 */
  0x0020,   /* U+5A75 */
  0x0020,   /* U+5A76 */
  0x0020,   /* U+5A77 */
  0x0020,   /* U+5A78 */
  0x0020,   /* U+5A79 */
  0x0020,   /* U+5A7A */
  0x0020,   /* U+5A7B */
  0x0020,   /* U+5A7C */
  0x0020,   /* U+5A7D */
  0x0020,   /* U+5A7E */
  0x0020,   /* U+5A7F */
  0x0020,   /* U+5A80 */
  0x0020,   /* U+5A81 */
  0x0020,   /* U+5A82 */
  0x0020,   /* U+5A83 */
  0x0020,   /* U+5A84 */
  0x0020,   /* U+5A85 */
  0x0020,   /* U+5A86 */
  0x0020,   /* U+5A87 */
  0x0020,   /* U+5A88 */
  0x0020,   /* U+5A89 */
  0x0020,   /* U+5A8A */
  0x0020,   /* U+5A8B */
  0x0020,   /* U+5A8C */
  0x0020,   /* U+5A8D */
  0x0020,   /* U+5A8E */
  0x0020,   /* U+5A8F */
  0x0020,   /* U+5A90 */
  0x0020,   /* U+5A91 */
  0x0020,   /* U+5A92 */
  0x0020,   /* U+5A93 */
  0x0020,   /* U+5A94 */
  0x0020,   /* U+5A95 */
  0x0020,   /* U+5A96 */
  0x0020,   /* U+5A97 */
  0x0020,   /* U+5A98 */
  0x0020,   /* U+5A99 */
  0x0020,   /* U+5A9A */
  0x0020,   /* U+5A9B */
  0x0020,   /* U+5A9C */
  0x0020,   /* U+5A9D */
  0x0020,   /* U+5A9E */
  0x0020,   /* U+5A9F */
  0x0020,   /* U+5AA0 */
  0x0020,   /* U+5AA1 */
  0x0020,   /* U+5AA2 */
  0x0020,   /* U+5AA3 */
  0x0020,   /* U+5AA4 */
  0x0020,   /* U+5AA5 */
  0x0020,   /* U+5AA6 */
  0x0020,   /* U+5AA7 */
  0x0020,   /* U+5AA8 */
  0x0020,   /* U+5AA9 */
  0x0020,   /* U+5AAA */
  0x0020,   /* U+5AAB */
  0x0020,   /* U+5AAC */
  0x0020,   /* U+5AAD */
  0x0020,   /* U+5AAE */
  0x0020,   /* U+5AAF */
  0x0020,   /* U+5AB0 */
  0x0020,   /* U+5AB1 */
  0x0020,   /* U+5AB2 */
  0x0020,   /* U+5AB3 */
  0x0020,   /* U+5AB4 */
  0x0020,   /* U+5AB5 */
  0x0020,   /* U+5AB6 */
  0x0020,   /* U+5AB7 */
  0x0020,   /* U+5AB8 */
  0x0020,   /* U+5AB9 */
  0x0020,   /* U+5ABA */
  0x0020,   /* U+5ABB */
  0x0020,   /* U+5ABC */
  0x0020,   /* U+5ABD */
  0x0020,   /* U+5ABE */
  0x0020,   /* U+5ABF */
  0x0020,   /* U+5AC0 */
  0x0020,   /* U+5AC1 */
  0x0020,   /* U+5AC2 */
  0x0020,   /* U+5AC3 */
  0x0020,   /* U+5AC4 */
  0x0020,   /* U+5AC5 */
  0x0020,   /* U+5AC6 */
  0x0020,   /* U+5AC7 */
  0x0020,   /* U+5AC8 */
  0x0020,   /* U+5AC9 */
  0x0020,   /* U+5ACA */
  0x0020,   /* U+5ACB */
  0x0020,   /* U+5ACC */
  0x0020,   /* U+5ACD */
  0x0020,   /* U+5ACE */
  0x0020,   /* U+5ACF */
  0x0020,   /* U+5AD0 */
  0x0020,   /* U+5AD1 */
  0x0020,   /* U+5AD2 */
  0x0020,   /* U+5AD3 */
  0x0020,   /* U+5AD4 */
  0x0020,   /* U+5AD5 */
  0x0020,   /* U+5AD6 */
  0x0020,   /* U+5AD7 */
  0x0020,   /* U+5AD8 */
  0x0020,   /* U+5AD9 */
  0x0020,   /* U+5ADA */
  0x0020,   /* U+5ADB */
  0x0020,   /* U+5ADC */
  0x0020,   /* U+5ADD */
  0x0020,   /* U+5ADE */
  0x0020,   /* U+5ADF */
  0x0020,   /* U+5AE0 */
  0x0020,   /* U+5AE1 */
  0x0020,   /* U+5AE2 */
  0x0020,   /* U+5AE3 */
  0x0020,   /* U+5AE4 */
  0x0020,   /* U+5AE5 */
  0x0020,   /* U+5AE6 */
  0x0020,   /* U+5AE7 */
  0x0020,   /* U+5AE8 */
  0x0020,   /* U+5AE9 */
  0x0020,   /* U+5AEA */
  0x0020,   /* U+5AEB */
  0x0020,   /* U+5AEC */
  0x0020,   /* U+5AED */
  0x0020,   /* U+5AEE */
  0x0020,   /* U+5AEF */
  0x0020,   /* U+5AF0 */
  0x0020,   /* U+5AF1 */
  0x0020,   /* U+5AF2 */
  0x0020,   /* U+5AF3 */
  0x0020,   /* U+5AF4 */
  0x0020,   /* U+5AF5 */
  0x0020,   /* U+5AF6 */
  0x0020,   /* U+5AF7 */
  0x0020,   /* U+5AF8 */
  0x0020,   /* U+5AF9 */
  0x0020,   /* U+5AFA */
  0x0020,   /* U+5AFB */
  0x0020,   /* U+5AFC */
  0x0020,   /* U+5AFD */
  0x0020,   /* U+5AFE */
  0x0020,   /* U+5AFF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+5A00 */
  0x0002,   /* U+5A01 */
  0x0002,   /* U+5A02 */
  0x0002,   /* U+5A03 */
  0x0002,   /* U+5A04 */
  0x0002,   /* U+5A05 */
  0x0002,   /* U+5A06 */
  0x0002,   /* U+5A07 */
  0x0002,   /* U+5A08 */
  0x0002,   /* U+5A09 */
  0x0002,   /* U+5A0A */
  0x0002,   /* U+5A0B */
  0x0002,   /* U+5A0C */
  0x0002,   /* U+5A0D */
  0x0002,   /* U+5A0E */
  0x0002,   /* U+5A0F */
  0x0002,   /* U+5A10 */
  0x0002,   /* U+5A11 */
  0x0002,   /* U+5A12 */
  0x0002,   /* U+5A13 */
  0x0002,   /* U+5A14 */
  0x0002,   /* U+5A15 */
  0x0002,   /* U+5A16 */
  0x0002,   /* U+5A17 */
  0x0002,   /* U+5A18 */
  0x0002,   /* U+5A19 */
  0x0002,   /* U+5A1A */
  0x0002,   /* U+5A1B */
  0x0002,   /* U+5A1C */
  0x0002,   /* U+5A1D */
  0x0002,   /* U+5A1E */
  0x0002,   /* U+5A1F */
  0x0002,   /* U+5A20 */
  0x0002,   /* U+5A21 */
  0x0002,   /* U+5A22 */
  0x0002,   /* U+5A23 */
  0x0002,   /* U+5A24 */
  0x0002,   /* U+5A25 */
  0x0002,   /* U+5A26 */
  0x0002,   /* U+5A27 */
  0x0002,   /* U+5A28 */
  0x0002,   /* U+5A29 */
  0x0002,   /* U+5A2A */
  0x0002,   /* U+5A2B */
  0x0002,   /* U+5A2C */
  0x0002,   /* U+5A2D */
  0x0002,   /* U+5A2E */
  0x0002,   /* U+5A2F */
  0x0002,   /* U+5A30 */
  0x0002,   /* U+5A31 */
  0x0002,   /* U+5A32 */
  0x0002,   /* U+5A33 */
  0x0002,   /* U+5A34 */
  0x0002,   /* U+5A35 */
  0x0002,   /* U+5A36 */
  0x0002,   /* U+5A37 */
  0x0002,   /* U+5A38 */
  0x0002,   /* U+5A39 */
  0x0002,   /* U+5A3A */
  0x0002,   /* U+5A3B */
  0x0002,   /* U+5A3C */
  0x0002,   /* U+5A3D */
  0x0002,   /* U+5A3E */
  0x0002,   /* U+5A3F */
  0x0002,   /* U+5A40 */
  0x0002,   /* U+5A41 */
  0x0002,   /* U+5A42 */
  0x0002,   /* U+5A43 */
  0x0002,   /* U+5A44 */
  0x0002,   /* U+5A45 */
  0x0002,   /* U+5A46 */
  0x0002,   /* U+5A47 */
  0x0002,   /* U+5A48 */
  0x0002,   /* U+5A49 */
  0x0002,   /* U+5A4A */
  0x0002,   /* U+5A4B */
  0x0002,   /* U+5A4C */
  0x0002,   /* U+5A4D */
  0x0002,   /* U+5A4E */
  0x0002,   /* U+5A4F */
  0x0002,   /* U+5A50 */
  0x0002,   /* U+5A51 */
  0x0002,   /* U+5A52 */
  0x0002,   /* U+5A53 */
  0x0002,   /* U+5A54 */
  0x0002,   /* U+5A55 */
  0x0002,   /* U+5A56 */
  0x0002,   /* U+5A57 */
  0x0002,   /* U+5A58 */
  0x0002,   /* U+5A59 */
  0x0002,   /* U+5A5A */
  0x0002,   /* U+5A5B */
  0x0002,   /* U+5A5C */
  0x0002,   /* U+5A5D */
  0x0002,   /* U+5A5E */
  0x0002,   /* U+5A5F */
  0x0002,   /* U+5A60 */
  0x0002,   /* U+5A61 */
  0x0002,   /* U+5A62 */
  0x0002,   /* U+5A63 */
  0x0002,   /* U+5A64 */
  0x0002,   /* U+5A65 */
  0x0002,   /* U+5A66 */
  0x0002,   /* U+5A67 */
  0x0002,   /* U+5A68 */
  0x0002,   /* U+5A69 */
  0x0002,   /* U+5A6A */
  0x0002,   /* U+5A6B */
  0x0002,   /* U+5A6C */
  0x0002,   /* U+5A6D */
  0x0002,   /* U+5A6E */
  0x0002,   /* U+5A6F */
  0x0002,   /* U+5A70 */
  0x0002,   /* U+5A71 */
  0x0002,   /* U+5A72 */
  0x0002,   /* U+5A73 */
  0x0002,   /* U+5A74 */
  0x0002,   /* U+5A75 */
  0x0002,   /* U+5A76 */
  0x0002,   /* U+5A77 */
  0x0002,   /* U+5A78 */
  0x0002,   /* U+5A79 */
  0x0002,   /* U+5A7A */
  0x0002,   /* U+5A7B */
  0x0002,   /* U+5A7C */
  0x0002,   /* U+5A7D */
  0x0002,   /* U+5A7E */
  0x0002,   /* U+5A7F */
  0x0002,   /* U+5A80 */
  0x0002,   /* U+5A81 */
  0x0002,   /* U+5A82 */
  0x0002,   /* U+5A83 */
  0x0002,   /* U+5A84 */
  0x0002,   /* U+5A85 */
  0x0002,   /* U+5A86 */
  0x0002,   /* U+5A87 */
  0x0002,   /* U+5A88 */
  0x0002,   /* U+5A89 */
  0x0002,   /* U+5A8A */
  0x0002,   /* U+5A8B */
  0x0002,   /* U+5A8C */
  0x0002,   /* U+5A8D */
  0x0002,   /* U+5A8E */
  0x0002,   /* U+5A8F */
  0x0002,   /* U+5A90 */
  0x0002,   /* U+5A91 */
  0x0002,   /* U+5A92 */
  0x0002,   /* U+5A93 */
  0x0002,   /* U+5A94 */
  0x0002,   /* U+5A95 */
  0x0002,   /* U+5A96 */
  0x0002,   /* U+5A97 */
  0x0002,   /* U+5A98 */
  0x0002,   /* U+5A99 */
  0x0002,   /* U+5A9A */
  0x0002,   /* U+5A9B */
  0x0002,   /* U+5A9C */
  0x0002,   /* U+5A9D */
  0x0002,   /* U+5A9E */
  0x0002,   /* U+5A9F */
  0x0002,   /* U+5AA0 */
  0x0002,   /* U+5AA1 */
  0x0002,   /* U+5AA2 */
  0x0002,   /* U+5AA3 */
  0x0002,   /* U+5AA4 */
  0x0002,   /* U+5AA5 */
  0x0002,   /* U+5AA6 */
  0x0002,   /* U+5AA7 */
  0x0002,   /* U+5AA8 */
  0x0002,   /* U+5AA9 */
  0x0002,   /* U+5AAA */
  0x0002,   /* U+5AAB */
  0x0002,   /* U+5AAC */
  0x0002,   /* U+5AAD */
  0x0002,   /* U+5AAE */
  0x0002,   /* U+5AAF */
  0x0002,   /* U+5AB0 */
  0x0002,   /* U+5AB1 */
  0x0002,   /* U+5AB2 */
  0x0002,   /* U+5AB3 */
  0x0002,   /* U+5AB4 */
  0x0002,   /* U+5AB5 */
  0x0002,   /* U+5AB6 */
  0x0002,   /* U+5AB7 */
  0x0002,   /* U+5AB8 */
  0x0002,   /* U+5AB9 */
  0x0002,   /* U+5ABA */
  0x0002,   /* U+5ABB */
  0x0002,   /* U+5ABC */
  0x0002,   /* U+5ABD */
  0x0002,   /* U+5ABE */
  0x0002,   /* U+5ABF */
  0x0002,   /* U+5AC0 */
  0x0002,   /* U+5AC1 */
  0x0002,   /* U+5AC2 */
  0x0002,   /* U+5AC3 */
  0x0002,   /* U+5AC4 */
  0x0002,   /* U+5AC5 */
  0x0002,   /* U+5AC6 */
  0x0002,   /* U+5AC7 */
  0x0002,   /* U+5AC8 */
  0x0002,   /* U+5AC9 */
  0x0002,   /* U+5ACA */
  0x0002,   /* U+5ACB */
  0x0002,   /* U+5ACC */
  0x0002,   /* U+5ACD */
  0x0002,   /* U+5ACE */
  0x0002,   /* U+5ACF */
  0x0002,   /* U+5AD0 */
  0x0002,   /* U+5AD1 */
  0x0002,   /* U+5AD2 */
  0x0002,   /* U+5AD3 */
  0x0002,   /* U+5AD4 */
  0x0002,   /* U+5AD5 */
  0x0002,   /* U+5AD6 */
  0x0002,   /* U+5AD7 */
  0x0002,   /* U+5AD8 */
  0x0002,   /* U+5AD9 */
  0x0002,   /* U+5ADA */
  0x0002,   /* U+5ADB */
  0x0002,   /* U+5ADC */
  0x0002,   /* U+5ADD */
  0x0002,   /* U+5ADE */
  0x0002,   /* U+5ADF */
  0x0002,   /* U+5AE0 */
  0x0002,   /* U+5AE1 */
  0x0002,   /* U+5AE2 */
  0x0002,   /* U+5AE3 */
  0x0002,   /* U+5AE4 */
  0x0002,   /* U+5AE5 */
  0x0002,   /* U+5AE6 */
  0x0002,   /* U+5AE7 */
  0x0002,   /* U+5AE8 */
  0x0002,   /* U+5AE9 */
  0x0002,   /* U+5AEA */
  0x0002,   /* U+5AEB */
  0x0002,   /* U+5AEC */
  0x0002,   /* U+5AED */
  0x0002,   /* U+5AEE */
  0x0002,   /* U+5AEF */
  0x0002,   /* U+5AF0 */
  0x0002,   /* U+5AF1 */
  0x0002,   /* U+5AF2 */
  0x0002,   /* U+5AF3 */
  0x0002,   /* U+5AF4 */
  0x0002,   /* U+5AF5 */
  0x0002,   /* U+5AF6 */
  0x0002,   /* U+5AF7 */
  0x0002,   /* U+5AF8 */
  0x0002,   /* U+5AF9 */
  0x0002,   /* U+5AFA */
  0x0002,   /* U+5AFB */
  0x0002,   /* U+5AFC */
  0x0002,   /* U+5AFD */
  0x0002,   /* U+5AFE */
  0x0002,   /* U+5AFF */

  /* Primary weight 2 for each character. */
  0xDA00,   /* U+5A00 */
  0x0000,   /* U+5A01 */
  0xDA02,   /* U+5A02 */
  0x0000,   /* U+5A03 */
  0xDA04,   /* U+5A04 */
  0xDA05,   /* U+5A05 */
  0xDA06,   /* U+5A06 */
  0xDA07,   /* U+5A07 */
  0xDA08,   /* U+5A08 */
  0x0000,   /* U+5A09 */
  0xDA0A,   /* U+5A0A */
  0xDA0B,   /* U+5A0B */
  0xDA0C,   /* U+5A0C */
  0xDA0D,   /* U+5A0D */
  0xDA0E,   /* U+5A0E */
  0xDA0F,   /* U+5A0F */
  0xDA10,   /* U+5A10 */
  0x0000,   /* U+5A11 */
  0xDA12,   /* U+5A12 */
  0xDA13,   /* U+5A13 */
  0xDA14,   /* U+5A14 */
  0xDA15,   /* U+5A15 */
  0xDA16,   /* U+5A16 */
  0xDA17,   /* U+5A17 */
  0x0000,   /* U+5A18 */
  0xDA19,   /* U+5A19 */
  0x0000,   /* U+5A1A */
  0xDA1B,   /* U+5A1B */
  0x0000,   /* U+5A1C */
  0xDA1D,   /* U+5A1D */
  0xDA1E,   /* U+5A1E */
  0x0000,   /* U+5A1F */
  0x0000,   /* U+5A20 */
  0xDA21,   /* U+5A21 */
  0xDA22,   /* U+5A22 */
  0xDA23,   /* U+5A23 */
  0xDA24,   /* U+5A24 */
  0x0000,   /* U+5A25 */
  0xDA26,   /* U+5A26 */
  0xDA27,   /* U+5A27 */
  0xDA28,   /* U+5A28 */
  0x0000,   /* U+5A29 */
  0xDA2A,   /* U+5A2A */
  0xDA2B,   /* U+5A2B */
  0xDA2C,   /* U+5A2C */
  0xDA2D,   /* U+5A2D */
  0xDA2E,   /* U+5A2E */
  0x0000,   /* U+5A2F */
  0xDA30,   /* U+5A30 */
  0xDA31,   /* U+5A31 */
  0xDA32,   /* U+5A32 */
  0xDA33,   /* U+5A33 */
  0xDA34,   /* U+5A34 */
  0x0000,   /* U+5A35 */
  0x0000,   /* U+5A36 */
  0xDA37,   /* U+5A37 */
  0xDA38,   /* U+5A38 */
  0xDA39,   /* U+5A39 */
  0xDA3A,   /* U+5A3A */
  0xDA3B,   /* U+5A3B */
  0x0000,   /* U+5A3C */
  0xDA3D,   /* U+5A3D */
  0xDA3E,   /* U+5A3E */
  0xDA3F,   /* U+5A3F */
  0x0000,   /* U+5A40 */
  0x0000,   /* U+5A41 */
  0xDA42,   /* U+5A42 */
  0xDA43,   /* U+5A43 */
  0xDA44,   /* U+5A44 */
  0xDA45,   /* U+5A45 */
  0x0000,   /* U+5A46 */
  0xDA47,   /* U+5A47 */
  0xDA48,   /* U+5A48 */
  0x0000,   /* U+5A49 */
  0xDA4A,   /* U+5A4A */
  0xDA4B,   /* U+5A4B */
  0xDA4C,   /* U+5A4C */
  0xDA4D,   /* U+5A4D */
  0xDA4E,   /* U+5A4E */
  0xDA4F,   /* U+5A4F */
  0xDA50,   /* U+5A50 */
  0xDA51,   /* U+5A51 */
  0xDA52,   /* U+5A52 */
  0xDA53,   /* U+5A53 */
  0xDA54,   /* U+5A54 */
  0xDA55,   /* U+5A55 */
  0xDA56,   /* U+5A56 */
  0xDA57,   /* U+5A57 */
  0xDA58,   /* U+5A58 */
  0xDA59,   /* U+5A59 */
  0x0000,   /* U+5A5A */
  0xDA5B,   /* U+5A5B */
  0xDA5C,   /* U+5A5C */
  0xDA5D,   /* U+5A5D */
  0xDA5E,   /* U+5A5E */
  0xDA5F,   /* U+5A5F */
  0xDA60,   /* U+5A60 */
  0xDA61,   /* U+5A61 */
  0x0000,   /* U+5A62 */
  0xDA63,   /* U+5A63 */
  0xDA64,   /* U+5A64 */
  0xDA65,   /* U+5A65 */
  0x0000,   /* U+5A66 */
  0xDA67,   /* U+5A67 */
  0xDA68,   /* U+5A68 */
  0xDA69,   /* U+5A69 */
  0x0000,   /* U+5A6A */
  0xDA6B,   /* U+5A6B */
  0x0000,   /* U+5A6C */
  0xDA6D,   /* U+5A6D */
  0xDA6E,   /* U+5A6E */
  0xDA6F,   /* U+5A6F */
  0xDA70,   /* U+5A70 */
  0xDA71,   /* U+5A71 */
  0xDA72,   /* U+5A72 */
  0xDA73,   /* U+5A73 */
  0xDA74,   /* U+5A74 */
  0xDA75,   /* U+5A75 */
  0xDA76,   /* U+5A76 */
  0xDA77,   /* U+5A77 */
  0xDA78,   /* U+5A78 */
  0xDA79,   /* U+5A79 */
  0xDA7A,   /* U+5A7A */
  0xDA7B,   /* U+5A7B */
  0xDA7C,   /* U+5A7C */
  0xDA7D,   /* U+5A7D */
  0xDA7E,   /* U+5A7E */
  0x0000,   /* U+5A7F */
  0xDA80,   /* U+5A80 */
  0xDA81,   /* U+5A81 */
  0xDA82,   /* U+5A82 */
  0xDA83,   /* U+5A83 */
  0xDA84,   /* U+5A84 */
  0xDA85,   /* U+5A85 */
  0xDA86,   /* U+5A86 */
  0xDA87,   /* U+5A87 */
  0xDA88,   /* U+5A88 */
  0xDA89,   /* U+5A89 */
  0xDA8A,   /* U+5A8A */
  0xDA8B,   /* U+5A8B */
  0xDA8C,   /* U+5A8C */
  0xDA8D,   /* U+5A8D */
  0xDA8E,   /* U+5A8E */
  0xDA8F,   /* U+5A8F */
  0xDA90,   /* U+5A90 */
  0xDA91,   /* U+5A91 */
  0x0000,   /* U+5A92 */
  0xDA93,   /* U+5A93 */
  0xDA94,   /* U+5A94 */
  0xDA95,   /* U+5A95 */
  0xDA96,   /* U+5A96 */
  0xDA97,   /* U+5A97 */
  0xDA98,   /* U+5A98 */
  0xDA99,   /* U+5A99 */
  0x0000,   /* U+5A9A */
  0x0000,   /* U+5A9B */
  0xDA9C,   /* U+5A9C */
  0xDA9D,   /* U+5A9D */
  0xDA9E,   /* U+5A9E */
  0xDA9F,   /* U+5A9F */
  0xDAA0,   /* U+5AA0 */
  0xDAA1,   /* U+5AA1 */
  0xDAA2,   /* U+5AA2 */
  0xDAA3,   /* U+5AA3 */
  0xDAA4,   /* U+5AA4 */
  0xDAA5,   /* U+5AA5 */
  0xDAA6,   /* U+5AA6 */
  0xDAA7,   /* U+5AA7 */
  0xDAA8,   /* U+5AA8 */
  0xDAA9,   /* U+5AA9 */
  0xDAAA,   /* U+5AAA */
  0xDAAB,   /* U+5AAB */
  0xDAAC,   /* U+5AAC */
  0xDAAD,   /* U+5AAD */
  0xDAAE,   /* U+5AAE */
  0xDAAF,   /* U+5AAF */
  0xDAB0,   /* U+5AB0 */
  0xDAB1,   /* U+5AB1 */
  0xDAB2,   /* U+5AB2 */
  0xDAB3,   /* U+5AB3 */
  0xDAB4,   /* U+5AB4 */
  0xDAB5,   /* U+5AB5 */
  0xDAB6,   /* U+5AB6 */
  0xDAB7,   /* U+5AB7 */
  0xDAB8,   /* U+5AB8 */
  0xDAB9,   /* U+5AB9 */
  0xDABA,   /* U+5ABA */
  0xDABB,   /* U+5ABB */
  0x0000,   /* U+5ABC */
  0x0000,   /* U+5ABD */
  0x0000,   /* U+5ABE */
  0xDABF,   /* U+5ABF */
  0xDAC0,   /* U+5AC0 */
  0x0000,   /* U+5AC1 */
  0x0000,   /* U+5AC2 */
  0xDAC3,   /* U+5AC3 */
  0xDAC4,   /* U+5AC4 */
  0xDAC5,   /* U+5AC5 */
  0xDAC6,   /* U+5AC6 */
  0xDAC7,   /* U+5AC7 */
  0xDAC8,   /* U+5AC8 */
  0x0000,   /* U+5AC9 */
  0xDACA,   /* U+5ACA */
  0x0000,   /* U+5ACB */
  0x0000,   /* U+5ACC */
  0xDACD,   /* U+5ACD */
  0xDACE,   /* U+5ACE */
  0xDACF,   /* U+5ACF */
  0x0000,   /* U+5AD0 */
  0xDAD1,   /* U+5AD1 */
  0xDAD2,   /* U+5AD2 */
  0xDAD3,   /* U+5AD3 */
  0xDAD4,   /* U+5AD4 */
  0xDAD5,   /* U+5AD5 */
  0x0000,   /* U+5AD6 */
  0x0000,   /* U+5AD7 */
  0xDAD8,   /* U+5AD8 */
  0xDAD9,   /* U+5AD9 */
  0xDADA,   /* U+5ADA */
  0xDADB,   /* U+5ADB */
  0xDADC,   /* U+5ADC */
  0xDADD,   /* U+5ADD */
  0xDADE,   /* U+5ADE */
  0xDADF,   /* U+5ADF */
  0xDAE0,   /* U+5AE0 */
  0x0000,   /* U+5AE1 */
  0xDAE2,   /* U+5AE2 */
  0x0000,   /* U+5AE3 */
  0xDAE4,   /* U+5AE4 */
  0xDAE5,   /* U+5AE5 */
  0x0000,   /* U+5AE6 */
  0xDAE7,   /* U+5AE7 */
  0xDAE8,   /* U+5AE8 */
  0x0000,   /* U+5AE9 */
  0xDAEA,   /* U+5AEA */
  0xDAEB,   /* U+5AEB */
  0xDAEC,   /* U+5AEC */
  0xDAED,   /* U+5AED */
  0xDAEE,   /* U+5AEE */
  0xDAEF,   /* U+5AEF */
  0xDAF0,   /* U+5AF0 */
  0xDAF1,   /* U+5AF1 */
  0xDAF2,   /* U+5AF2 */
  0xDAF3,   /* U+5AF3 */
  0xDAF4,   /* U+5AF4 */
  0xDAF5,   /* U+5AF5 */
  0xDAF6,   /* U+5AF6 */
  0xDAF7,   /* U+5AF7 */
  0xDAF8,   /* U+5AF8 */
  0xDAF9,   /* U+5AF9 */
  0x0000,   /* U+5AFA */
  0x0000,   /* U+5AFB */
  0xDAFC,   /* U+5AFC */
  0xDAFD,   /* U+5AFD */
  0xDAFE,   /* U+5AFE */
  0xDAFF,   /* U+5AFF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+5A00 */
  0x0000,   /* U+5A01 */
  0x0000,   /* U+5A02 */
  0x0000,   /* U+5A03 */
  0x0000,   /* U+5A04 */
  0x0000,   /* U+5A05 */
  0x0000,   /* U+5A06 */
  0x0000,   /* U+5A07 */
  0x0000,   /* U+5A08 */
  0x0000,   /* U+5A09 */
  0x0000,   /* U+5A0A */
  0x0000,   /* U+5A0B */
  0x0000,   /* U+5A0C */
  0x0000,   /* U+5A0D */
  0x0000,   /* U+5A0E */
  0x0000,   /* U+5A0F */
  0x0000,   /* U+5A10 */
  0x0000,   /* U+5A11 */
  0x0000,   /* U+5A12 */
  0x0000,   /* U+5A13 */
  0x0000,   /* U+5A14 */
  0x0000,   /* U+5A15 */
  0x0000,   /* U+5A16 */
  0x0000,   /* U+5A17 */
  0x0000,   /* U+5A18 */
  0x0000,   /* U+5A19 */
  0x0000,   /* U+5A1A */
  0x0000,   /* U+5A1B */
  0x0000,   /* U+5A1C */
  0x0000,   /* U+5A1D */
  0x0000,   /* U+5A1E */
  0x0000,   /* U+5A1F */
  0x0000,   /* U+5A20 */
  0x0000,   /* U+5A21 */
  0x0000,   /* U+5A22 */
  0x0000,   /* U+5A23 */
  0x0000,   /* U+5A24 */
  0x0000,   /* U+5A25 */
  0x0000,   /* U+5A26 */
  0x0000,   /* U+5A27 */
  0x0000,   /* U+5A28 */
  0x0000,   /* U+5A29 */
  0x0000,   /* U+5A2A */
  0x0000,   /* U+5A2B */
  0x0000,   /* U+5A2C */
  0x0000,   /* U+5A2D */
  0x0000,   /* U+5A2E */
  0x0000,   /* U+5A2F */
  0x0000,   /* U+5A30 */
  0x0000,   /* U+5A31 */
  0x0000,   /* U+5A32 */
  0x0000,   /* U+5A33 */
  0x0000,   /* U+5A34 */
  0x0000,   /* U+5A35 */
  0x0000,   /* U+5A36 */
  0x0000,   /* U+5A37 */
  0x0000,   /* U+5A38 */
  0x0000,   /* U+5A39 */
  0x0000,   /* U+5A3A */
  0x0000,   /* U+5A3B */
  0x0000,   /* U+5A3C */
  0x0000,   /* U+5A3D */
  0x0000,   /* U+5A3E */
  0x0000,   /* U+5A3F */
  0x0000,   /* U+5A40 */
  0x0000,   /* U+5A41 */
  0x0000,   /* U+5A42 */
  0x0000,   /* U+5A43 */
  0x0000,   /* U+5A44 */
  0x0000,   /* U+5A45 */
  0x0000,   /* U+5A46 */
  0x0000,   /* U+5A47 */
  0x0000,   /* U+5A48 */
  0x0000,   /* U+5A49 */
  0x0000,   /* U+5A4A */
  0x0000,   /* U+5A4B */
  0x0000,   /* U+5A4C */
  0x0000,   /* U+5A4D */
  0x0000,   /* U+5A4E */
  0x0000,   /* U+5A4F */
  0x0000,   /* U+5A50 */
  0x0000,   /* U+5A51 */
  0x0000,   /* U+5A52 */
  0x0000,   /* U+5A53 */
  0x0000,   /* U+5A54 */
  0x0000,   /* U+5A55 */
  0x0000,   /* U+5A56 */
  0x0000,   /* U+5A57 */
  0x0000,   /* U+5A58 */
  0x0000,   /* U+5A59 */
  0x0000,   /* U+5A5A */
  0x0000,   /* U+5A5B */
  0x0000,   /* U+5A5C */
  0x0000,   /* U+5A5D */
  0x0000,   /* U+5A5E */
  0x0000,   /* U+5A5F */
  0x0000,   /* U+5A60 */
  0x0000,   /* U+5A61 */
  0x0000,   /* U+5A62 */
  0x0000,   /* U+5A63 */
  0x0000,   /* U+5A64 */
  0x0000,   /* U+5A65 */
  0x0000,   /* U+5A66 */
  0x0000,   /* U+5A67 */
  0x0000,   /* U+5A68 */
  0x0000,   /* U+5A69 */
  0x0000,   /* U+5A6A */
  0x0000,   /* U+5A6B */
  0x0000,   /* U+5A6C */
  0x0000,   /* U+5A6D */
  0x0000,   /* U+5A6E */
  0x0000,   /* U+5A6F */
  0x0000,   /* U+5A70 */
  0x0000,   /* U+5A71 */
  0x0000,   /* U+5A72 */
  0x0000,   /* U+5A73 */
  0x0000,   /* U+5A74 */
  0x0000,   /* U+5A75 */
  0x0000,   /* U+5A76 */
  0x0000,   /* U+5A77 */
  0x0000,   /* U+5A78 */
  0x0000,   /* U+5A79 */
  0x0000,   /* U+5A7A */
  0x0000,   /* U+5A7B */
  0x0000,   /* U+5A7C */
  0x0000,   /* U+5A7D */
  0x0000,   /* U+5A7E */
  0x0000,   /* U+5A7F */
  0x0000,   /* U+5A80 */
  0x0000,   /* U+5A81 */
  0x0000,   /* U+5A82 */
  0x0000,   /* U+5A83 */
  0x0000,   /* U+5A84 */
  0x0000,   /* U+5A85 */
  0x0000,   /* U+5A86 */
  0x0000,   /* U+5A87 */
  0x0000,   /* U+5A88 */
  0x0000,   /* U+5A89 */
  0x0000,   /* U+5A8A */
  0x0000,   /* U+5A8B */
  0x0000,   /* U+5A8C */
  0x0000,   /* U+5A8D */
  0x0000,   /* U+5A8E */
  0x0000,   /* U+5A8F */
  0x0000,   /* U+5A90 */
  0x0000,   /* U+5A91 */
  0x0000,   /* U+5A92 */
  0x0000,   /* U+5A93 */
  0x0000,   /* U+5A94 */
  0x0000,   /* U+5A95 */
  0x0000,   /* U+5A96 */
  0x0000,   /* U+5A97 */
  0x0000,   /* U+5A98 */
  0x0000,   /* U+5A99 */
  0x0000,   /* U+5A9A */
  0x0000,   /* U+5A9B */
  0x0000,   /* U+5A9C */
  0x0000,   /* U+5A9D */
  0x0000,   /* U+5A9E */
  0x0000,   /* U+5A9F */
  0x0000,   /* U+5AA0 */
  0x0000,   /* U+5AA1 */
  0x0000,   /* U+5AA2 */
  0x0000,   /* U+5AA3 */
  0x0000,   /* U+5AA4 */
  0x0000,   /* U+5AA5 */
  0x0000,   /* U+5AA6 */
  0x0000,   /* U+5AA7 */
  0x0000,   /* U+5AA8 */
  0x0000,   /* U+5AA9 */
  0x0000,   /* U+5AAA */
  0x0000,   /* U+5AAB */
  0x0000,   /* U+5AAC */
  0x0000,   /* U+5AAD */
  0x0000,   /* U+5AAE */
  0x0000,   /* U+5AAF */
  0x0000,   /* U+5AB0 */
  0x0000,   /* U+5AB1 */
  0x0000,   /* U+5AB2 */
  0x0000,   /* U+5AB3 */
  0x0000,   /* U+5AB4 */
  0x0000,   /* U+5AB5 */
  0x0000,   /* U+5AB6 */
  0x0000,   /* U+5AB7 */
  0x0000,   /* U+5AB8 */
  0x0000,   /* U+5AB9 */
  0x0000,   /* U+5ABA */
  0x0000,   /* U+5ABB */
  0x0000,   /* U+5ABC */
  0x0000,   /* U+5ABD */
  0x0000,   /* U+5ABE */
  0x0000,   /* U+5ABF */
  0x0000,   /* U+5AC0 */
  0x0000,   /* U+5AC1 */
  0x0000,   /* U+5AC2 */
  0x0000,   /* U+5AC3 */
  0x0000,   /* U+5AC4 */
  0x0000,   /* U+5AC5 */
  0x0000,   /* U+5AC6 */
  0x0000,   /* U+5AC7 */
  0x0000,   /* U+5AC8 */
  0x0000,   /* U+5AC9 */
  0x0000,   /* U+5ACA */
  0x0000,   /* U+5ACB */
  0x0000,   /* U+5ACC */
  0x0000,   /* U+5ACD */
  0x0000,   /* U+5ACE */
  0x0000,   /* U+5ACF */
  0x0000,   /* U+5AD0 */
  0x0000,   /* U+5AD1 */
  0x0000,   /* U+5AD2 */
  0x0000,   /* U+5AD3 */
  0x0000,   /* U+5AD4 */
  0x0000,   /* U+5AD5 */
  0x0000,   /* U+5AD6 */
  0x0000,   /* U+5AD7 */
  0x0000,   /* U+5AD8 */
  0x0000,   /* U+5AD9 */
  0x0000,   /* U+5ADA */
  0x0000,   /* U+5ADB */
  0x0000,   /* U+5ADC */
  0x0000,   /* U+5ADD */
  0x0000,   /* U+5ADE */
  0x0000,   /* U+5ADF */
  0x0000,   /* U+5AE0 */
  0x0000,   /* U+5AE1 */
  0x0000,   /* U+5AE2 */
  0x0000,   /* U+5AE3 */
  0x0000,   /* U+5AE4 */
  0x0000,   /* U+5AE5 */
  0x0000,   /* U+5AE6 */
  0x0000,   /* U+5AE7 */
  0x0000,   /* U+5AE8 */
  0x0000,   /* U+5AE9 */
  0x0000,   /* U+5AEA */
  0x0000,   /* U+5AEB */
  0x0000,   /* U+5AEC */
  0x0000,   /* U+5AED */
  0x0000,   /* U+5AEE */
  0x0000,   /* U+5AEF */
  0x0000,   /* U+5AF0 */
  0x0000,   /* U+5AF1 */
  0x0000,   /* U+5AF2 */
  0x0000,   /* U+5AF3 */
  0x0000,   /* U+5AF4 */
  0x0000,   /* U+5AF5 */
  0x0000,   /* U+5AF6 */
  0x0000,   /* U+5AF7 */
  0x0000,   /* U+5AF8 */
  0x0000,   /* U+5AF9 */
  0x0000,   /* U+5AFA */
  0x0000,   /* U+5AFB */
  0x0000,   /* U+5AFC */
  0x0000,   /* U+5AFD */
  0x0000,   /* U+5AFE */
  0x0000,   /* U+5AFF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+5A00 */
  0x0000,   /* U+5A01 */
  0x0000,   /* U+5A02 */
  0x0000,   /* U+5A03 */
  0x0000,   /* U+5A04 */
  0x0000,   /* U+5A05 */
  0x0000,   /* U+5A06 */
  0x0000,   /* U+5A07 */
  0x0000,   /* U+5A08 */
  0x0000,   /* U+5A09 */
  0x0000,   /* U+5A0A */
  0x0000,   /* U+5A0B */
  0x0000,   /* U+5A0C */
  0x0000,   /* U+5A0D */
  0x0000,   /* U+5A0E */
  0x0000,   /* U+5A0F */
  0x0000,   /* U+5A10 */
  0x0000,   /* U+5A11 */
  0x0000,   /* U+5A12 */
  0x0000,   /* U+5A13 */
  0x0000,   /* U+5A14 */
  0x0000,   /* U+5A15 */
  0x0000,   /* U+5A16 */
  0x0000,   /* U+5A17 */
  0x0000,   /* U+5A18 */
  0x0000,   /* U+5A19 */
  0x0000,   /* U+5A1A */
  0x0000,   /* U+5A1B */
  0x0000,   /* U+5A1C */
  0x0000,   /* U+5A1D */
  0x0000,   /* U+5A1E */
  0x0000,   /* U+5A1F */
  0x0000,   /* U+5A20 */
  0x0000,   /* U+5A21 */
  0x0000,   /* U+5A22 */
  0x0000,   /* U+5A23 */
  0x0000,   /* U+5A24 */
  0x0000,   /* U+5A25 */
  0x0000,   /* U+5A26 */
  0x0000,   /* U+5A27 */
  0x0000,   /* U+5A28 */
  0x0000,   /* U+5A29 */
  0x0000,   /* U+5A2A */
  0x0000,   /* U+5A2B */
  0x0000,   /* U+5A2C */
  0x0000,   /* U+5A2D */
  0x0000,   /* U+5A2E */
  0x0000,   /* U+5A2F */
  0x0000,   /* U+5A30 */
  0x0000,   /* U+5A31 */
  0x0000,   /* U+5A32 */
  0x0000,   /* U+5A33 */
  0x0000,   /* U+5A34 */
  0x0000,   /* U+5A35 */
  0x0000,   /* U+5A36 */
  0x0000,   /* U+5A37 */
  0x0000,   /* U+5A38 */
  0x0000,   /* U+5A39 */
  0x0000,   /* U+5A3A */
  0x0000,   /* U+5A3B */
  0x0000,   /* U+5A3C */
  0x0000,   /* U+5A3D */
  0x0000,   /* U+5A3E */
  0x0000,   /* U+5A3F */
  0x0000,   /* U+5A40 */
  0x0000,   /* U+5A41 */
  0x0000,   /* U+5A42 */
  0x0000,   /* U+5A43 */
  0x0000,   /* U+5A44 */
  0x0000,   /* U+5A45 */
  0x0000,   /* U+5A46 */
  0x0000,   /* U+5A47 */
  0x0000,   /* U+5A48 */
  0x0000,   /* U+5A49 */
  0x0000,   /* U+5A4A */
  0x0000,   /* U+5A4B */
  0x0000,   /* U+5A4C */
  0x0000,   /* U+5A4D */
  0x0000,   /* U+5A4E */
  0x0000,   /* U+5A4F */
  0x0000,   /* U+5A50 */
  0x0000,   /* U+5A51 */
  0x0000,   /* U+5A52 */
  0x0000,   /* U+5A53 */
  0x0000,   /* U+5A54 */
  0x0000,   /* U+5A55 */
  0x0000,   /* U+5A56 */
  0x0000,   /* U+5A57 */
  0x0000,   /* U+5A58 */
  0x0000,   /* U+5A59 */
  0x0000,   /* U+5A5A */
  0x0000,   /* U+5A5B */
  0x0000,   /* U+5A5C */
  0x0000,   /* U+5A5D */
  0x0000,   /* U+5A5E */
  0x0000,   /* U+5A5F */
  0x0000,   /* U+5A60 */
  0x0000,   /* U+5A61 */
  0x0000,   /* U+5A62 */
  0x0000,   /* U+5A63 */
  0x0000,   /* U+5A64 */
  0x0000,   /* U+5A65 */
  0x0000,   /* U+5A66 */
  0x0000,   /* U+5A67 */
  0x0000,   /* U+5A68 */
  0x0000,   /* U+5A69 */
  0x0000,   /* U+5A6A */
  0x0000,   /* U+5A6B */
  0x0000,   /* U+5A6C */
  0x0000,   /* U+5A6D */
  0x0000,   /* U+5A6E */
  0x0000,   /* U+5A6F */
  0x0000,   /* U+5A70 */
  0x0000,   /* U+5A71 */
  0x0000,   /* U+5A72 */
  0x0000,   /* U+5A73 */
  0x0000,   /* U+5A74 */
  0x0000,   /* U+5A75 */
  0x0000,   /* U+5A76 */
  0x0000,   /* U+5A77 */
  0x0000,   /* U+5A78 */
  0x0000,   /* U+5A79 */
  0x0000,   /* U+5A7A */
  0x0000,   /* U+5A7B */
  0x0000,   /* U+5A7C */
  0x0000,   /* U+5A7D */
  0x0000,   /* U+5A7E */
  0x0000,   /* U+5A7F */
  0x0000,   /* U+5A80 */
  0x0000,   /* U+5A81 */
  0x0000,   /* U+5A82 */
  0x0000,   /* U+5A83 */
  0x0000,   /* U+5A84 */
  0x0000,   /* U+5A85 */
  0x0000,   /* U+5A86 */
  0x0000,   /* U+5A87 */
  0x0000,   /* U+5A88 */
  0x0000,   /* U+5A89 */
  0x0000,   /* U+5A8A */
  0x0000,   /* U+5A8B */
  0x0000,   /* U+5A8C */
  0x0000,   /* U+5A8D */
  0x0000,   /* U+5A8E */
  0x0000,   /* U+5A8F */
  0x0000,   /* U+5A90 */
  0x0000,   /* U+5A91 */
  0x0000,   /* U+5A92 */
  0x0000,   /* U+5A93 */
  0x0000,   /* U+5A94 */
  0x0000,   /* U+5A95 */
  0x0000,   /* U+5A96 */
  0x0000,   /* U+5A97 */
  0x0000,   /* U+5A98 */
  0x0000,   /* U+5A99 */
  0x0000,   /* U+5A9A */
  0x0000,   /* U+5A9B */
  0x0000,   /* U+5A9C */
  0x0000,   /* U+5A9D */
  0x0000,   /* U+5A9E */
  0x0000,   /* U+5A9F */
  0x0000,   /* U+5AA0 */
  0x0000,   /* U+5AA1 */
  0x0000,   /* U+5AA2 */
  0x0000,   /* U+5AA3 */
  0x0000,   /* U+5AA4 */
  0x0000,   /* U+5AA5 */
  0x0000,   /* U+5AA6 */
  0x0000,   /* U+5AA7 */
  0x0000,   /* U+5AA8 */
  0x0000,   /* U+5AA9 */
  0x0000,   /* U+5AAA */
  0x0000,   /* U+5AAB */
  0x0000,   /* U+5AAC */
  0x0000,   /* U+5AAD */
  0x0000,   /* U+5AAE */
  0x0000,   /* U+5AAF */
  0x0000,   /* U+5AB0 */
  0x0000,   /* U+5AB1 */
  0x0000,   /* U+5AB2 */
  0x0000,   /* U+5AB3 */
  0x0000,   /* U+5AB4 */
  0x0000,   /* U+5AB5 */
  0x0000,   /* U+5AB6 */
  0x0000,   /* U+5AB7 */
  0x0000,   /* U+5AB8 */
  0x0000,   /* U+5AB9 */
  0x0000,   /* U+5ABA */
  0x0000,   /* U+5ABB */
  0x0000,   /* U+5ABC */
  0x0000,   /* U+5ABD */
  0x0000,   /* U+5ABE */
  0x0000,   /* U+5ABF */
  0x0000,   /* U+5AC0 */
  0x0000,   /* U+5AC1 */
  0x0000,   /* U+5AC2 */
  0x0000,   /* U+5AC3 */
  0x0000,   /* U+5AC4 */
  0x0000,   /* U+5AC5 */
  0x0000,   /* U+5AC6 */
  0x0000,   /* U+5AC7 */
  0x0000,   /* U+5AC8 */
  0x0000,   /* U+5AC9 */
  0x0000,   /* U+5ACA */
  0x0000,   /* U+5ACB */
  0x0000,   /* U+5ACC */
  0x0000,   /* U+5ACD */
  0x0000,   /* U+5ACE */
  0x0000,   /* U+5ACF */
  0x0000,   /* U+5AD0 */
  0x0000,   /* U+5AD1 */
  0x0000,   /* U+5AD2 */
  0x0000,   /* U+5AD3 */
  0x0000,   /* U+5AD4 */
  0x0000,   /* U+5AD5 */
  0x0000,   /* U+5AD6 */
  0x0000,   /* U+5AD7 */
  0x0000,   /* U+5AD8 */
  0x0000,   /* U+5AD9 */
  0x0000,   /* U+5ADA */
  0x0000,   /* U+5ADB */
  0x0000,   /* U+5ADC */
  0x0000,   /* U+5ADD */
  0x0000,   /* U+5ADE */
  0x0000,   /* U+5ADF */
  0x0000,   /* U+5AE0 */
  0x0000,   /* U+5AE1 */
  0x0000,   /* U+5AE2 */
  0x0000,   /* U+5AE3 */
  0x0000,   /* U+5AE4 */
  0x0000,   /* U+5AE5 */
  0x0000,   /* U+5AE6 */
  0x0000,   /* U+5AE7 */
  0x0000,   /* U+5AE8 */
  0x0000,   /* U+5AE9 */
  0x0000,   /* U+5AEA */
  0x0000,   /* U+5AEB */
  0x0000,   /* U+5AEC */
  0x0000,   /* U+5AED */
  0x0000,   /* U+5AEE */
  0x0000,   /* U+5AEF */
  0x0000,   /* U+5AF0 */
  0x0000,   /* U+5AF1 */
  0x0000,   /* U+5AF2 */
  0x0000,   /* U+5AF3 */
  0x0000,   /* U+5AF4 */
  0x0000,   /* U+5AF5 */
  0x0000,   /* U+5AF6 */
  0x0000,   /* U+5AF7 */
  0x0000,   /* U+5AF8 */
  0x0000,   /* U+5AF9 */
  0x0000,   /* U+5AFA */
  0x0000,   /* U+5AFB */
  0x0000,   /* U+5AFC */
  0x0000,   /* U+5AFD */
  0x0000,   /* U+5AFE */
  0x0000,   /* U+5AFF */
};

uint16 ja_han_page5B[]= {
  /* Number of CEs for each character. */
  2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 1, 1, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 1, 2, 1, 2, 2, 2,
  1, 2, 1, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 1, 2,
  1, 2, 2, 1, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  1, 1, 2, 2, 1, 1, 2, 1, 1, 2, 1, 1, 1, 1, 2, 1,
  2, 2, 2, 1, 1, 1, 1, 2, 2, 1, 2, 1, 2, 2, 2, 2,
  1, 1, 2, 1, 2, 1, 2, 2, 1, 2, 1, 2, 2, 2, 2, 2,
  1, 2, 2, 1, 2, 1, 2, 1, 1, 1, 2, 1, 1, 1, 2, 1,
  2, 2, 2, 2, 2, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1,
  2, 2, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 1, 2,
  1, 2, 2, 1, 1, 1, 1, 2, 1, 1, 2, 2, 2, 2, 2, 1,
  2, 2, 1, 1, 1, 1, 1, 1, 2, 1, 2, 2, 1, 2, 2, 2,
  1, 2, 1, 1, 1, 2, 2, 2, 2, 2, 2, 1, 2, 1, 1, 1,
  2, 1, 1, 2, 1, 1, 1, 1, 1, 1, 2, 1, 2, 2, 1, 2,
  1, 2, 2, 1, 2, 1, 1, 2, 1, 2, 1, 2, 2, 2, 1, 1,

  /* Primary weight 1 for each character. */
  0xFB40,   /* U+5B00 */
  0xFB40,   /* U+5B01 */
  0xFB40,   /* U+5B02 */
  0xFB40,   /* U+5B03 */
  0xFB40,   /* U+5B04 */
  0xFB40,   /* U+5B05 */
  0xFB40,   /* U+5B06 */
  0xFB40,   /* U+5B07 */
  0xFB40,   /* U+5B08 */
  0x566D,   /* U+5B09 */
  0xFB40,   /* U+5B0A */
  0x6237,   /* U+5B0B */
  0x6236,   /* U+5B0C */
  0xFB40,   /* U+5B0D */
  0xFB40,   /* U+5B0E */
  0xFB40,   /* U+5B0F */
  0xFB40,   /* U+5B10 */
  0xFB40,   /* U+5B11 */
  0xFB40,   /* U+5B12 */
  0xFB40,   /* U+5B13 */
  0xFB40,   /* U+5B14 */
  0xFB40,   /* U+5B15 */
  0x6238,   /* U+5B16 */
  0xFB40,   /* U+5B17 */
  0xFB40,   /* U+5B18 */
  0xFB40,   /* U+5B19 */
  0xFB40,   /* U+5B1A */
  0xFB40,   /* U+5B1B */
  0xFB40,   /* U+5B1C */
  0xFB40,   /* U+5B1D */
  0xFB40,   /* U+5B1E */
  0xFB40,   /* U+5B1F */
  0xFB40,   /* U+5B20 */
  0xFB40,   /* U+5B21 */
  0x5A15,   /* U+5B22 */
  0xFB40,   /* U+5B23 */
  0xFB40,   /* U+5B24 */
  0xFB40,   /* U+5B25 */
  0xFB40,   /* U+5B26 */
  0xFB40,   /* U+5B27 */
  0xFB40,   /* U+5B28 */
  0xFB40,   /* U+5B29 */
  0x623B,   /* U+5B2A */
  0xFB40,   /* U+5B2B */
  0x5C37,   /* U+5B2C */
  0xFB40,   /* U+5B2D */
  0xFB40,   /* U+5B2E */
  0xFB40,   /* U+5B2F */
  0x5526,   /* U+5B30 */
  0xFB40,   /* U+5B31 */
  0x6239,   /* U+5B32 */
  0xFB40,   /* U+5B33 */
  0xFB40,   /* U+5B34 */
  0xFB40,   /* U+5B35 */
  0x623C,   /* U+5B36 */
  0xFB40,   /* U+5B37 */
  0xFB40,   /* U+5B38 */
  0xFB40,   /* U+5B39 */
  0xFB40,   /* U+5B3A */
  0xFB40,   /* U+5B3B */
  0xFB40,   /* U+5B3C */
  0xFB40,   /* U+5B3D */
  0x623D,   /* U+5B3E */
  0xFB40,   /* U+5B3F */
  0x6240,   /* U+5B40 */
  0xFB40,   /* U+5B41 */
  0xFB40,   /* U+5B42 */
  0x623E,   /* U+5B43 */
  0xFB40,   /* U+5B44 */
  0x623F,   /* U+5B45 */
  0xFB40,   /* U+5B46 */
  0xFB40,   /* U+5B47 */
  0xFB40,   /* U+5B48 */
  0xFB40,   /* U+5B49 */
  0xFB40,   /* U+5B4A */
  0xFB40,   /* U+5B4B */
  0xFB40,   /* U+5B4C */
  0xFB40,   /* U+5B4D */
  0xFB40,   /* U+5B4E */
  0xFB40,   /* U+5B4F */
  0x58DF,   /* U+5B50 */
  0x6241,   /* U+5B51 */
  0xFB40,   /* U+5B52 */
  0xFB40,   /* U+5B53 */
  0x57F7,   /* U+5B54 */
  0x6242,   /* U+5B55 */
  0xFB40,   /* U+5B56 */
  0x5907,   /* U+5B57 */
  0x5B57,   /* U+5B58 */
  0xFB40,   /* U+5B59 */
  0x6243,   /* U+5B5A */
  0x6244,   /* U+5B5B */
  0x58E7,   /* U+5B5C */
  0x57F8,   /* U+5B5D */
  0xFB40,   /* U+5B5E */
  0x5F1D,   /* U+5B5F */
  0xFB40,   /* U+5B60 */
  0xFB40,   /* U+5B61 */
  0xFB40,   /* U+5B62 */
  0x5681,   /* U+5B63 */
  0x57BC,   /* U+5B64 */
  0x6245,   /* U+5B65 */
  0x55F5,   /* U+5B66 */
  0xFB40,   /* U+5B67 */
  0xFB40,   /* U+5B68 */
  0x6246,   /* U+5B69 */
  0xFB40,   /* U+5B6A */
  0x5B58,   /* U+5B6B */
  0xFB40,   /* U+5B6C */
  0xFB40,   /* U+5B6D */
  0xFB40,   /* U+5B6E */
  0xFB40,   /* U+5B6F */
  0x6247,   /* U+5B70 */
  0x626F,   /* U+5B71 */
  0xFB40,   /* U+5B72 */
  0x6248,   /* U+5B73 */
  0xFB40,   /* U+5B74 */
  0x6249,   /* U+5B75 */
  0xFB40,   /* U+5B76 */
  0xFB40,   /* U+5B77 */
  0x624A,   /* U+5B78 */
  0xFB40,   /* U+5B79 */
  0x624C,   /* U+5B7A */
  0xFB40,   /* U+5B7B */
  0xFB40,   /* U+5B7C */
  0xFB40,   /* U+5B7D */
  0xFB40,   /* U+5B7E */
  0xFB40,   /* U+5B7F */
  0x624D,   /* U+5B80 */
  0xFB40,   /* U+5B81 */
  0xFB40,   /* U+5B82 */
  0x624E,   /* U+5B83 */
  0xFB40,   /* U+5B84 */
  0x5B8F,   /* U+5B85 */
  0xFB40,   /* U+5B86 */
  0x5508,   /* U+5B87 */
  0x5954,   /* U+5B88 */
  0x54C5,   /* U+5B89 */
  0xFB40,   /* U+5B8A */
  0x5B18,   /* U+5B8B */
  0x562B,   /* U+5B8C */
  0x5920,   /* U+5B8D */
  0xFB40,   /* U+5B8E */
  0x57F9,   /* U+5B8F */
  0xFB40,   /* U+5B90 */
  0xFB40,   /* U+5B91 */
  0xFB40,   /* U+5B92 */
  0xFB40,   /* U+5B93 */
  0xFB40,   /* U+5B94 */
  0x5C9F,   /* U+5B95 */
  0xFB40,   /* U+5B96 */
  0x596A,   /* U+5B97 */
  0x562C,   /* U+5B98 */
  0x5BE5,   /* U+5B99 */
  0x5C45,   /* U+5B9A */
  0x54BB,   /* U+5B9B */
  0x5692,   /* U+5B9C */
  0x5E84,   /* U+5B9D */
  0xFB40,   /* U+5B9E */
  0x592D,   /* U+5B9F */
  0xFB40,   /* U+5BA0 */
  0xFB40,   /* U+5BA1 */
  0x56AB,   /* U+5BA2 */
  0x5ACE,   /* U+5BA3 */
  0x5927,   /* U+5BA4 */
  0x5F51,   /* U+5BA5 */
  0x624F,   /* U+5BA6 */
  0xFB40,   /* U+5BA7 */
  0xFB40,   /* U+5BA8 */
  0xFB40,   /* U+5BA9 */
  0xFB40,   /* U+5BAA */
  0xFB40,   /* U+5BAB */
  0xFB40,   /* U+5BAC */
  0xFB40,   /* U+5BAD */
  0x56B5,   /* U+5BAE */
  0xFB40,   /* U+5BAF */
  0x587A,   /* U+5BB0 */
  0xFB40,   /* U+5BB1 */
  0xFB40,   /* U+5BB2 */
  0x55CF,   /* U+5BB3 */
  0x5544,   /* U+5BB4 */
  0x59D3,   /* U+5BB5 */
  0x5587,   /* U+5BB6 */
  0xFB40,   /* U+5BB7 */
  0x6250,   /* U+5BB8 */
  0x5F6F,   /* U+5BB9 */
  0xFB40,   /* U+5BBA */
  0xFB40,   /* U+5BBB */
  0xFB40,   /* U+5BBC */
  0xFB40,   /* U+5BBD */
  0xFB40,   /* U+5BBE */
  0x5992,   /* U+5BBF */
  0xFB40,   /* U+5BC0 */
  0xFB40,   /* U+5BC1 */
  0x594F,   /* U+5BC2 */
  0x6251,   /* U+5BC3 */
  0x566E,   /* U+5BC4 */
  0x5CE9,   /* U+5BC5 */
  0x5EF4,   /* U+5BC6 */
  0x6252,   /* U+5BC7 */
  0xFB40,   /* U+5BC8 */
  0x6253,   /* U+5BC9 */
  0xFB40,   /* U+5BCA */
  0xFB40,   /* U+5BCB */
  0x5E0A,   /* U+5BCC */
  0xFB40,   /* U+5BCD */
  0xFB40,   /* U+5BCE */
  0xFB40,   /* U+5BCF */
  0x6255,   /* U+5BD0 */
  0xFB40,   /* U+5BD1 */
  0x5623,   /* U+5BD2 */
  0x572E,   /* U+5BD3 */
  0x6254,   /* U+5BD4 */
  0xFB40,   /* U+5BD5 */
  0xFB40,   /* U+5BD6 */
  0xFB40,   /* U+5BD7 */
  0xFB40,   /* U+5BD8 */
  0xFB40,   /* U+5BD9 */
  0xFB40,   /* U+5BDA */
  0x562D,   /* U+5BDB */
  0xFB40,   /* U+5BDC */
  0x5A37,   /* U+5BDD */
  0x6259,   /* U+5BDE */
  0x58AE,   /* U+5BDF */
  0xFB40,   /* U+5BE0 */
  0x5588,   /* U+5BE1 */
  0x6258,   /* U+5BE2 */
  0xFB40,   /* U+5BE3 */
  0x6256,   /* U+5BE4 */
  0x625A,   /* U+5BE5 */
  0x6257,   /* U+5BE6 */
  0x5D20,   /* U+5BE7 */
  0x64CD,   /* U+5BE8 */
  0x5A38,   /* U+5BE9 */
  0xFB40,   /* U+5BEA */
  0x625B,   /* U+5BEB */
  0xFB40,   /* U+5BEC */
  0xFB40,   /* U+5BED */
  0x5FC7,   /* U+5BEE */
  0xFB40,   /* U+5BEF */
  0x625C,   /* U+5BF0 */
  0xFB40,   /* U+5BF1 */
  0xFB40,   /* U+5BF2 */
  0x625E,   /* U+5BF3 */
  0xFB40,   /* U+5BF4 */
  0x5BFB,   /* U+5BF5 */
  0x625D,   /* U+5BF6 */
  0xFB40,   /* U+5BF7 */
  0x5A86,   /* U+5BF8 */
  0xFB40,   /* U+5BF9 */
  0x5908,   /* U+5BFA */
  0xFB40,   /* U+5BFB */
  0xFB40,   /* U+5BFC */
  0xFB40,   /* U+5BFD */
  0x5B6F,   /* U+5BFE */
  0x5962,   /* U+5BFF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+5B00 */
  0x0020,   /* U+5B01 */
  0x0020,   /* U+5B02 */
  0x0020,   /* U+5B03 */
  0x0020,   /* U+5B04 */
  0x0020,   /* U+5B05 */
  0x0020,   /* U+5B06 */
  0x0020,   /* U+5B07 */
  0x0020,   /* U+5B08 */
  0x0020,   /* U+5B09 */
  0x0020,   /* U+5B0A */
  0x0020,   /* U+5B0B */
  0x0020,   /* U+5B0C */
  0x0020,   /* U+5B0D */
  0x0020,   /* U+5B0E */
  0x0020,   /* U+5B0F */
  0x0020,   /* U+5B10 */
  0x0020,   /* U+5B11 */
  0x0020,   /* U+5B12 */
  0x0020,   /* U+5B13 */
  0x0020,   /* U+5B14 */
  0x0020,   /* U+5B15 */
  0x0020,   /* U+5B16 */
  0x0020,   /* U+5B17 */
  0x0020,   /* U+5B18 */
  0x0020,   /* U+5B19 */
  0x0020,   /* U+5B1A */
  0x0020,   /* U+5B1B */
  0x0020,   /* U+5B1C */
  0x0020,   /* U+5B1D */
  0x0020,   /* U+5B1E */
  0x0020,   /* U+5B1F */
  0x0020,   /* U+5B20 */
  0x0020,   /* U+5B21 */
  0x0020,   /* U+5B22 */
  0x0020,   /* U+5B23 */
  0x0020,   /* U+5B24 */
  0x0020,   /* U+5B25 */
  0x0020,   /* U+5B26 */
  0x0020,   /* U+5B27 */
  0x0020,   /* U+5B28 */
  0x0020,   /* U+5B29 */
  0x0020,   /* U+5B2A */
  0x0020,   /* U+5B2B */
  0x0020,   /* U+5B2C */
  0x0020,   /* U+5B2D */
  0x0020,   /* U+5B2E */
  0x0020,   /* U+5B2F */
  0x0020,   /* U+5B30 */
  0x0020,   /* U+5B31 */
  0x0020,   /* U+5B32 */
  0x0020,   /* U+5B33 */
  0x0020,   /* U+5B34 */
  0x0020,   /* U+5B35 */
  0x0020,   /* U+5B36 */
  0x0020,   /* U+5B37 */
  0x0020,   /* U+5B38 */
  0x0020,   /* U+5B39 */
  0x0020,   /* U+5B3A */
  0x0020,   /* U+5B3B */
  0x0020,   /* U+5B3C */
  0x0020,   /* U+5B3D */
  0x0020,   /* U+5B3E */
  0x0020,   /* U+5B3F */
  0x0020,   /* U+5B40 */
  0x0020,   /* U+5B41 */
  0x0020,   /* U+5B42 */
  0x0020,   /* U+5B43 */
  0x0020,   /* U+5B44 */
  0x0020,   /* U+5B45 */
  0x0020,   /* U+5B46 */
  0x0020,   /* U+5B47 */
  0x0020,   /* U+5B48 */
  0x0020,   /* U+5B49 */
  0x0020,   /* U+5B4A */
  0x0020,   /* U+5B4B */
  0x0020,   /* U+5B4C */
  0x0020,   /* U+5B4D */
  0x0020,   /* U+5B4E */
  0x0020,   /* U+5B4F */
  0x0020,   /* U+5B50 */
  0x0020,   /* U+5B51 */
  0x0020,   /* U+5B52 */
  0x0020,   /* U+5B53 */
  0x0020,   /* U+5B54 */
  0x0020,   /* U+5B55 */
  0x0020,   /* U+5B56 */
  0x0020,   /* U+5B57 */
  0x0020,   /* U+5B58 */
  0x0020,   /* U+5B59 */
  0x0020,   /* U+5B5A */
  0x0020,   /* U+5B5B */
  0x0020,   /* U+5B5C */
  0x0020,   /* U+5B5D */
  0x0020,   /* U+5B5E */
  0x0020,   /* U+5B5F */
  0x0020,   /* U+5B60 */
  0x0020,   /* U+5B61 */
  0x0020,   /* U+5B62 */
  0x0020,   /* U+5B63 */
  0x0020,   /* U+5B64 */
  0x0020,   /* U+5B65 */
  0x0020,   /* U+5B66 */
  0x0020,   /* U+5B67 */
  0x0020,   /* U+5B68 */
  0x0020,   /* U+5B69 */
  0x0020,   /* U+5B6A */
  0x0020,   /* U+5B6B */
  0x0020,   /* U+5B6C */
  0x0020,   /* U+5B6D */
  0x0020,   /* U+5B6E */
  0x0020,   /* U+5B6F */
  0x0020,   /* U+5B70 */
  0x0020,   /* U+5B71 */
  0x0020,   /* U+5B72 */
  0x0020,   /* U+5B73 */
  0x0020,   /* U+5B74 */
  0x0020,   /* U+5B75 */
  0x0020,   /* U+5B76 */
  0x0020,   /* U+5B77 */
  0x0020,   /* U+5B78 */
  0x0020,   /* U+5B79 */
  0x0020,   /* U+5B7A */
  0x0020,   /* U+5B7B */
  0x0020,   /* U+5B7C */
  0x0020,   /* U+5B7D */
  0x0020,   /* U+5B7E */
  0x0020,   /* U+5B7F */
  0x0020,   /* U+5B80 */
  0x0020,   /* U+5B81 */
  0x0020,   /* U+5B82 */
  0x0020,   /* U+5B83 */
  0x0020,   /* U+5B84 */
  0x0020,   /* U+5B85 */
  0x0020,   /* U+5B86 */
  0x0020,   /* U+5B87 */
  0x0020,   /* U+5B88 */
  0x0020,   /* U+5B89 */
  0x0020,   /* U+5B8A */
  0x0020,   /* U+5B8B */
  0x0020,   /* U+5B8C */
  0x0020,   /* U+5B8D */
  0x0020,   /* U+5B8E */
  0x0020,   /* U+5B8F */
  0x0020,   /* U+5B90 */
  0x0020,   /* U+5B91 */
  0x0020,   /* U+5B92 */
  0x0020,   /* U+5B93 */
  0x0020,   /* U+5B94 */
  0x0020,   /* U+5B95 */
  0x0020,   /* U+5B96 */
  0x0020,   /* U+5B97 */
  0x0020,   /* U+5B98 */
  0x0020,   /* U+5B99 */
  0x0020,   /* U+5B9A */
  0x0020,   /* U+5B9B */
  0x0020,   /* U+5B9C */
  0x0020,   /* U+5B9D */
  0x0020,   /* U+5B9E */
  0x0020,   /* U+5B9F */
  0x0020,   /* U+5BA0 */
  0x0020,   /* U+5BA1 */
  0x0020,   /* U+5BA2 */
  0x0020,   /* U+5BA3 */
  0x0020,   /* U+5BA4 */
  0x0020,   /* U+5BA5 */
  0x0020,   /* U+5BA6 */
  0x0020,   /* U+5BA7 */
  0x0020,   /* U+5BA8 */
  0x0020,   /* U+5BA9 */
  0x0020,   /* U+5BAA */
  0x0020,   /* U+5BAB */
  0x0020,   /* U+5BAC */
  0x0020,   /* U+5BAD */
  0x0020,   /* U+5BAE */
  0x0020,   /* U+5BAF */
  0x0020,   /* U+5BB0 */
  0x0020,   /* U+5BB1 */
  0x0020,   /* U+5BB2 */
  0x0020,   /* U+5BB3 */
  0x0020,   /* U+5BB4 */
  0x0020,   /* U+5BB5 */
  0x0020,   /* U+5BB6 */
  0x0020,   /* U+5BB7 */
  0x0020,   /* U+5BB8 */
  0x0020,   /* U+5BB9 */
  0x0020,   /* U+5BBA */
  0x0020,   /* U+5BBB */
  0x0020,   /* U+5BBC */
  0x0020,   /* U+5BBD */
  0x0020,   /* U+5BBE */
  0x0020,   /* U+5BBF */
  0x0020,   /* U+5BC0 */
  0x0020,   /* U+5BC1 */
  0x0020,   /* U+5BC2 */
  0x0020,   /* U+5BC3 */
  0x0020,   /* U+5BC4 */
  0x0020,   /* U+5BC5 */
  0x0020,   /* U+5BC6 */
  0x0020,   /* U+5BC7 */
  0x0020,   /* U+5BC8 */
  0x0020,   /* U+5BC9 */
  0x0020,   /* U+5BCA */
  0x0020,   /* U+5BCB */
  0x0020,   /* U+5BCC */
  0x0020,   /* U+5BCD */
  0x0020,   /* U+5BCE */
  0x0020,   /* U+5BCF */
  0x0020,   /* U+5BD0 */
  0x0020,   /* U+5BD1 */
  0x0020,   /* U+5BD2 */
  0x0020,   /* U+5BD3 */
  0x0020,   /* U+5BD4 */
  0x0020,   /* U+5BD5 */
  0x0020,   /* U+5BD6 */
  0x0020,   /* U+5BD7 */
  0x0020,   /* U+5BD8 */
  0x0020,   /* U+5BD9 */
  0x0020,   /* U+5BDA */
  0x0020,   /* U+5BDB */
  0x0020,   /* U+5BDC */
  0x0020,   /* U+5BDD */
  0x0020,   /* U+5BDE */
  0x0020,   /* U+5BDF */
  0x0020,   /* U+5BE0 */
  0x0020,   /* U+5BE1 */
  0x0020,   /* U+5BE2 */
  0x0020,   /* U+5BE3 */
  0x0020,   /* U+5BE4 */
  0x0020,   /* U+5BE5 */
  0x0020,   /* U+5BE6 */
  0x0020,   /* U+5BE7 */
  0x0020,   /* U+5BE8 */
  0x0020,   /* U+5BE9 */
  0x0020,   /* U+5BEA */
  0x0020,   /* U+5BEB */
  0x0020,   /* U+5BEC */
  0x0020,   /* U+5BED */
  0x0020,   /* U+5BEE */
  0x0020,   /* U+5BEF */
  0x0020,   /* U+5BF0 */
  0x0020,   /* U+5BF1 */
  0x0020,   /* U+5BF2 */
  0x0020,   /* U+5BF3 */
  0x0020,   /* U+5BF4 */
  0x0020,   /* U+5BF5 */
  0x0020,   /* U+5BF6 */
  0x0020,   /* U+5BF7 */
  0x0020,   /* U+5BF8 */
  0x0020,   /* U+5BF9 */
  0x0020,   /* U+5BFA */
  0x0020,   /* U+5BFB */
  0x0020,   /* U+5BFC */
  0x0020,   /* U+5BFD */
  0x0020,   /* U+5BFE */
  0x0020,   /* U+5BFF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+5B00 */
  0x0002,   /* U+5B01 */
  0x0002,   /* U+5B02 */
  0x0002,   /* U+5B03 */
  0x0002,   /* U+5B04 */
  0x0002,   /* U+5B05 */
  0x0002,   /* U+5B06 */
  0x0002,   /* U+5B07 */
  0x0002,   /* U+5B08 */
  0x0002,   /* U+5B09 */
  0x0002,   /* U+5B0A */
  0x0002,   /* U+5B0B */
  0x0002,   /* U+5B0C */
  0x0002,   /* U+5B0D */
  0x0002,   /* U+5B0E */
  0x0002,   /* U+5B0F */
  0x0002,   /* U+5B10 */
  0x0002,   /* U+5B11 */
  0x0002,   /* U+5B12 */
  0x0002,   /* U+5B13 */
  0x0002,   /* U+5B14 */
  0x0002,   /* U+5B15 */
  0x0002,   /* U+5B16 */
  0x0002,   /* U+5B17 */
  0x0002,   /* U+5B18 */
  0x0002,   /* U+5B19 */
  0x0002,   /* U+5B1A */
  0x0002,   /* U+5B1B */
  0x0002,   /* U+5B1C */
  0x0002,   /* U+5B1D */
  0x0002,   /* U+5B1E */
  0x0002,   /* U+5B1F */
  0x0002,   /* U+5B20 */
  0x0002,   /* U+5B21 */
  0x0002,   /* U+5B22 */
  0x0002,   /* U+5B23 */
  0x0002,   /* U+5B24 */
  0x0002,   /* U+5B25 */
  0x0002,   /* U+5B26 */
  0x0002,   /* U+5B27 */
  0x0002,   /* U+5B28 */
  0x0002,   /* U+5B29 */
  0x0002,   /* U+5B2A */
  0x0002,   /* U+5B2B */
  0x0002,   /* U+5B2C */
  0x0002,   /* U+5B2D */
  0x0002,   /* U+5B2E */
  0x0002,   /* U+5B2F */
  0x0002,   /* U+5B30 */
  0x0002,   /* U+5B31 */
  0x0002,   /* U+5B32 */
  0x0002,   /* U+5B33 */
  0x0002,   /* U+5B34 */
  0x0002,   /* U+5B35 */
  0x0002,   /* U+5B36 */
  0x0002,   /* U+5B37 */
  0x0002,   /* U+5B38 */
  0x0002,   /* U+5B39 */
  0x0002,   /* U+5B3A */
  0x0002,   /* U+5B3B */
  0x0002,   /* U+5B3C */
  0x0002,   /* U+5B3D */
  0x0002,   /* U+5B3E */
  0x0002,   /* U+5B3F */
  0x0002,   /* U+5B40 */
  0x0002,   /* U+5B41 */
  0x0002,   /* U+5B42 */
  0x0002,   /* U+5B43 */
  0x0002,   /* U+5B44 */
  0x0002,   /* U+5B45 */
  0x0002,   /* U+5B46 */
  0x0002,   /* U+5B47 */
  0x0002,   /* U+5B48 */
  0x0002,   /* U+5B49 */
  0x0002,   /* U+5B4A */
  0x0002,   /* U+5B4B */
  0x0002,   /* U+5B4C */
  0x0002,   /* U+5B4D */
  0x0002,   /* U+5B4E */
  0x0002,   /* U+5B4F */
  0x0002,   /* U+5B50 */
  0x0002,   /* U+5B51 */
  0x0002,   /* U+5B52 */
  0x0002,   /* U+5B53 */
  0x0002,   /* U+5B54 */
  0x0002,   /* U+5B55 */
  0x0002,   /* U+5B56 */
  0x0002,   /* U+5B57 */
  0x0002,   /* U+5B58 */
  0x0002,   /* U+5B59 */
  0x0002,   /* U+5B5A */
  0x0002,   /* U+5B5B */
  0x0002,   /* U+5B5C */
  0x0002,   /* U+5B5D */
  0x0002,   /* U+5B5E */
  0x0002,   /* U+5B5F */
  0x0002,   /* U+5B60 */
  0x0002,   /* U+5B61 */
  0x0002,   /* U+5B62 */
  0x0002,   /* U+5B63 */
  0x0002,   /* U+5B64 */
  0x0002,   /* U+5B65 */
  0x0002,   /* U+5B66 */
  0x0002,   /* U+5B67 */
  0x0002,   /* U+5B68 */
  0x0002,   /* U+5B69 */
  0x0002,   /* U+5B6A */
  0x0002,   /* U+5B6B */
  0x0002,   /* U+5B6C */
  0x0002,   /* U+5B6D */
  0x0002,   /* U+5B6E */
  0x0002,   /* U+5B6F */
  0x0002,   /* U+5B70 */
  0x0002,   /* U+5B71 */
  0x0002,   /* U+5B72 */
  0x0002,   /* U+5B73 */
  0x0002,   /* U+5B74 */
  0x0002,   /* U+5B75 */
  0x0002,   /* U+5B76 */
  0x0002,   /* U+5B77 */
  0x0002,   /* U+5B78 */
  0x0002,   /* U+5B79 */
  0x0002,   /* U+5B7A */
  0x0002,   /* U+5B7B */
  0x0002,   /* U+5B7C */
  0x0002,   /* U+5B7D */
  0x0002,   /* U+5B7E */
  0x0002,   /* U+5B7F */
  0x0002,   /* U+5B80 */
  0x0002,   /* U+5B81 */
  0x0002,   /* U+5B82 */
  0x0002,   /* U+5B83 */
  0x0002,   /* U+5B84 */
  0x0002,   /* U+5B85 */
  0x0002,   /* U+5B86 */
  0x0002,   /* U+5B87 */
  0x0002,   /* U+5B88 */
  0x0002,   /* U+5B89 */
  0x0002,   /* U+5B8A */
  0x0002,   /* U+5B8B */
  0x0002,   /* U+5B8C */
  0x0002,   /* U+5B8D */
  0x0002,   /* U+5B8E */
  0x0002,   /* U+5B8F */
  0x0002,   /* U+5B90 */
  0x0002,   /* U+5B91 */
  0x0002,   /* U+5B92 */
  0x0002,   /* U+5B93 */
  0x0002,   /* U+5B94 */
  0x0002,   /* U+5B95 */
  0x0002,   /* U+5B96 */
  0x0002,   /* U+5B97 */
  0x0002,   /* U+5B98 */
  0x0002,   /* U+5B99 */
  0x0002,   /* U+5B9A */
  0x0002,   /* U+5B9B */
  0x0002,   /* U+5B9C */
  0x0002,   /* U+5B9D */
  0x0002,   /* U+5B9E */
  0x0002,   /* U+5B9F */
  0x0002,   /* U+5BA0 */
  0x0002,   /* U+5BA1 */
  0x0002,   /* U+5BA2 */
  0x0002,   /* U+5BA3 */
  0x0002,   /* U+5BA4 */
  0x0002,   /* U+5BA5 */
  0x0002,   /* U+5BA6 */
  0x0002,   /* U+5BA7 */
  0x0002,   /* U+5BA8 */
  0x0002,   /* U+5BA9 */
  0x0002,   /* U+5BAA */
  0x0002,   /* U+5BAB */
  0x0002,   /* U+5BAC */
  0x0002,   /* U+5BAD */
  0x0002,   /* U+5BAE */
  0x0002,   /* U+5BAF */
  0x0002,   /* U+5BB0 */
  0x0002,   /* U+5BB1 */
  0x0002,   /* U+5BB2 */
  0x0002,   /* U+5BB3 */
  0x0002,   /* U+5BB4 */
  0x0002,   /* U+5BB5 */
  0x0002,   /* U+5BB6 */
  0x0002,   /* U+5BB7 */
  0x0002,   /* U+5BB8 */
  0x0002,   /* U+5BB9 */
  0x0002,   /* U+5BBA */
  0x0002,   /* U+5BBB */
  0x0002,   /* U+5BBC */
  0x0002,   /* U+5BBD */
  0x0002,   /* U+5BBE */
  0x0002,   /* U+5BBF */
  0x0002,   /* U+5BC0 */
  0x0002,   /* U+5BC1 */
  0x0002,   /* U+5BC2 */
  0x0002,   /* U+5BC3 */
  0x0002,   /* U+5BC4 */
  0x0002,   /* U+5BC5 */
  0x0002,   /* U+5BC6 */
  0x0002,   /* U+5BC7 */
  0x0002,   /* U+5BC8 */
  0x0002,   /* U+5BC9 */
  0x0002,   /* U+5BCA */
  0x0002,   /* U+5BCB */
  0x0002,   /* U+5BCC */
  0x0002,   /* U+5BCD */
  0x0002,   /* U+5BCE */
  0x0002,   /* U+5BCF */
  0x0002,   /* U+5BD0 */
  0x0002,   /* U+5BD1 */
  0x0002,   /* U+5BD2 */
  0x0002,   /* U+5BD3 */
  0x0002,   /* U+5BD4 */
  0x0002,   /* U+5BD5 */
  0x0002,   /* U+5BD6 */
  0x0002,   /* U+5BD7 */
  0x0002,   /* U+5BD8 */
  0x0002,   /* U+5BD9 */
  0x0002,   /* U+5BDA */
  0x0002,   /* U+5BDB */
  0x0002,   /* U+5BDC */
  0x0002,   /* U+5BDD */
  0x0002,   /* U+5BDE */
  0x0002,   /* U+5BDF */
  0x0002,   /* U+5BE0 */
  0x0002,   /* U+5BE1 */
  0x0002,   /* U+5BE2 */
  0x0002,   /* U+5BE3 */
  0x0002,   /* U+5BE4 */
  0x0002,   /* U+5BE5 */
  0x0002,   /* U+5BE6 */
  0x0002,   /* U+5BE7 */
  0x0002,   /* U+5BE8 */
  0x0002,   /* U+5BE9 */
  0x0002,   /* U+5BEA */
  0x0002,   /* U+5BEB */
  0x0002,   /* U+5BEC */
  0x0002,   /* U+5BED */
  0x0002,   /* U+5BEE */
  0x0002,   /* U+5BEF */
  0x0002,   /* U+5BF0 */
  0x0002,   /* U+5BF1 */
  0x0002,   /* U+5BF2 */
  0x0002,   /* U+5BF3 */
  0x0002,   /* U+5BF4 */
  0x0002,   /* U+5BF5 */
  0x0002,   /* U+5BF6 */
  0x0002,   /* U+5BF7 */
  0x0002,   /* U+5BF8 */
  0x0002,   /* U+5BF9 */
  0x0002,   /* U+5BFA */
  0x0002,   /* U+5BFB */
  0x0002,   /* U+5BFC */
  0x0002,   /* U+5BFD */
  0x0002,   /* U+5BFE */
  0x0002,   /* U+5BFF */

  /* Primary weight 2 for each character. */
  0xDB00,   /* U+5B00 */
  0xDB01,   /* U+5B01 */
  0xDB02,   /* U+5B02 */
  0xDB03,   /* U+5B03 */
  0xDB04,   /* U+5B04 */
  0xDB05,   /* U+5B05 */
  0xDB06,   /* U+5B06 */
  0xDB07,   /* U+5B07 */
  0xDB08,   /* U+5B08 */
  0x0000,   /* U+5B09 */
  0xDB0A,   /* U+5B0A */
  0x0000,   /* U+5B0B */
  0x0000,   /* U+5B0C */
  0xDB0D,   /* U+5B0D */
  0xDB0E,   /* U+5B0E */
  0xDB0F,   /* U+5B0F */
  0xDB10,   /* U+5B10 */
  0xDB11,   /* U+5B11 */
  0xDB12,   /* U+5B12 */
  0xDB13,   /* U+5B13 */
  0xDB14,   /* U+5B14 */
  0xDB15,   /* U+5B15 */
  0x0000,   /* U+5B16 */
  0xDB17,   /* U+5B17 */
  0xDB18,   /* U+5B18 */
  0xDB19,   /* U+5B19 */
  0xDB1A,   /* U+5B1A */
  0xDB1B,   /* U+5B1B */
  0xDB1C,   /* U+5B1C */
  0xDB1D,   /* U+5B1D */
  0xDB1E,   /* U+5B1E */
  0xDB1F,   /* U+5B1F */
  0xDB20,   /* U+5B20 */
  0xDB21,   /* U+5B21 */
  0x0000,   /* U+5B22 */
  0xDB23,   /* U+5B23 */
  0xDB24,   /* U+5B24 */
  0xDB25,   /* U+5B25 */
  0xDB26,   /* U+5B26 */
  0xDB27,   /* U+5B27 */
  0xDB28,   /* U+5B28 */
  0xDB29,   /* U+5B29 */
  0x0000,   /* U+5B2A */
  0xDB2B,   /* U+5B2B */
  0x0000,   /* U+5B2C */
  0xDB2D,   /* U+5B2D */
  0xDB2E,   /* U+5B2E */
  0xDB2F,   /* U+5B2F */
  0x0000,   /* U+5B30 */
  0xDB31,   /* U+5B31 */
  0x0000,   /* U+5B32 */
  0xDB33,   /* U+5B33 */
  0xDB34,   /* U+5B34 */
  0xDB35,   /* U+5B35 */
  0x0000,   /* U+5B36 */
  0xDB37,   /* U+5B37 */
  0xDB38,   /* U+5B38 */
  0xDB39,   /* U+5B39 */
  0xDB3A,   /* U+5B3A */
  0xDB3B,   /* U+5B3B */
  0xDB3C,   /* U+5B3C */
  0xDB3D,   /* U+5B3D */
  0x0000,   /* U+5B3E */
  0xDB3F,   /* U+5B3F */
  0x0000,   /* U+5B40 */
  0xDB41,   /* U+5B41 */
  0xDB42,   /* U+5B42 */
  0x0000,   /* U+5B43 */
  0xDB44,   /* U+5B44 */
  0x0000,   /* U+5B45 */
  0xDB46,   /* U+5B46 */
  0xDB47,   /* U+5B47 */
  0xDB48,   /* U+5B48 */
  0xDB49,   /* U+5B49 */
  0xDB4A,   /* U+5B4A */
  0xDB4B,   /* U+5B4B */
  0xDB4C,   /* U+5B4C */
  0xDB4D,   /* U+5B4D */
  0xDB4E,   /* U+5B4E */
  0xDB4F,   /* U+5B4F */
  0x0000,   /* U+5B50 */
  0x0000,   /* U+5B51 */
  0xDB52,   /* U+5B52 */
  0xDB53,   /* U+5B53 */
  0x0000,   /* U+5B54 */
  0x0000,   /* U+5B55 */
  0xDB56,   /* U+5B56 */
  0x0000,   /* U+5B57 */
  0x0000,   /* U+5B58 */
  0xDB59,   /* U+5B59 */
  0x0000,   /* U+5B5A */
  0x0000,   /* U+5B5B */
  0x0000,   /* U+5B5C */
  0x0000,   /* U+5B5D */
  0xDB5E,   /* U+5B5E */
  0x0000,   /* U+5B5F */
  0xDB60,   /* U+5B60 */
  0xDB61,   /* U+5B61 */
  0xDB62,   /* U+5B62 */
  0x0000,   /* U+5B63 */
  0x0000,   /* U+5B64 */
  0x0000,   /* U+5B65 */
  0x0000,   /* U+5B66 */
  0xDB67,   /* U+5B67 */
  0xDB68,   /* U+5B68 */
  0x0000,   /* U+5B69 */
  0xDB6A,   /* U+5B6A */
  0x0000,   /* U+5B6B */
  0xDB6C,   /* U+5B6C */
  0xDB6D,   /* U+5B6D */
  0xDB6E,   /* U+5B6E */
  0xDB6F,   /* U+5B6F */
  0x0000,   /* U+5B70 */
  0x0000,   /* U+5B71 */
  0xDB72,   /* U+5B72 */
  0x0000,   /* U+5B73 */
  0xDB74,   /* U+5B74 */
  0x0000,   /* U+5B75 */
  0xDB76,   /* U+5B76 */
  0xDB77,   /* U+5B77 */
  0x0000,   /* U+5B78 */
  0xDB79,   /* U+5B79 */
  0x0000,   /* U+5B7A */
  0xDB7B,   /* U+5B7B */
  0xDB7C,   /* U+5B7C */
  0xDB7D,   /* U+5B7D */
  0xDB7E,   /* U+5B7E */
  0xDB7F,   /* U+5B7F */
  0x0000,   /* U+5B80 */
  0xDB81,   /* U+5B81 */
  0xDB82,   /* U+5B82 */
  0x0000,   /* U+5B83 */
  0xDB84,   /* U+5B84 */
  0x0000,   /* U+5B85 */
  0xDB86,   /* U+5B86 */
  0x0000,   /* U+5B87 */
  0x0000,   /* U+5B88 */
  0x0000,   /* U+5B89 */
  0xDB8A,   /* U+5B8A */
  0x0000,   /* U+5B8B */
  0x0000,   /* U+5B8C */
  0x0000,   /* U+5B8D */
  0xDB8E,   /* U+5B8E */
  0x0000,   /* U+5B8F */
  0xDB90,   /* U+5B90 */
  0xDB91,   /* U+5B91 */
  0xDB92,   /* U+5B92 */
  0xDB93,   /* U+5B93 */
  0xDB94,   /* U+5B94 */
  0x0000,   /* U+5B95 */
  0xDB96,   /* U+5B96 */
  0x0000,   /* U+5B97 */
  0x0000,   /* U+5B98 */
  0x0000,   /* U+5B99 */
  0x0000,   /* U+5B9A */
  0x0000,   /* U+5B9B */
  0x0000,   /* U+5B9C */
  0x0000,   /* U+5B9D */
  0xDB9E,   /* U+5B9E */
  0x0000,   /* U+5B9F */
  0xDBA0,   /* U+5BA0 */
  0xDBA1,   /* U+5BA1 */
  0x0000,   /* U+5BA2 */
  0x0000,   /* U+5BA3 */
  0x0000,   /* U+5BA4 */
  0x0000,   /* U+5BA5 */
  0x0000,   /* U+5BA6 */
  0xDBA7,   /* U+5BA7 */
  0xDBA8,   /* U+5BA8 */
  0xDBA9,   /* U+5BA9 */
  0xDBAA,   /* U+5BAA */
  0xDBAB,   /* U+5BAB */
  0xDBAC,   /* U+5BAC */
  0xDBAD,   /* U+5BAD */
  0x0000,   /* U+5BAE */
  0xDBAF,   /* U+5BAF */
  0x0000,   /* U+5BB0 */
  0xDBB1,   /* U+5BB1 */
  0xDBB2,   /* U+5BB2 */
  0x0000,   /* U+5BB3 */
  0x0000,   /* U+5BB4 */
  0x0000,   /* U+5BB5 */
  0x0000,   /* U+5BB6 */
  0xDBB7,   /* U+5BB7 */
  0x0000,   /* U+5BB8 */
  0x0000,   /* U+5BB9 */
  0xDBBA,   /* U+5BBA */
  0xDBBB,   /* U+5BBB */
  0xDBBC,   /* U+5BBC */
  0xDBBD,   /* U+5BBD */
  0xDBBE,   /* U+5BBE */
  0x0000,   /* U+5BBF */
  0xDBC0,   /* U+5BC0 */
  0xDBC1,   /* U+5BC1 */
  0x0000,   /* U+5BC2 */
  0x0000,   /* U+5BC3 */
  0x0000,   /* U+5BC4 */
  0x0000,   /* U+5BC5 */
  0x0000,   /* U+5BC6 */
  0x0000,   /* U+5BC7 */
  0xDBC8,   /* U+5BC8 */
  0x0000,   /* U+5BC9 */
  0xDBCA,   /* U+5BCA */
  0xDBCB,   /* U+5BCB */
  0x0000,   /* U+5BCC */
  0xDBCD,   /* U+5BCD */
  0xDBCE,   /* U+5BCE */
  0xDBCF,   /* U+5BCF */
  0x0000,   /* U+5BD0 */
  0xDBD1,   /* U+5BD1 */
  0x0000,   /* U+5BD2 */
  0x0000,   /* U+5BD3 */
  0x0000,   /* U+5BD4 */
  0xDBD5,   /* U+5BD5 */
  0xDBD6,   /* U+5BD6 */
  0xDBD7,   /* U+5BD7 */
  0xDBD8,   /* U+5BD8 */
  0xDBD9,   /* U+5BD9 */
  0xDBDA,   /* U+5BDA */
  0x0000,   /* U+5BDB */
  0xDBDC,   /* U+5BDC */
  0x0000,   /* U+5BDD */
  0x0000,   /* U+5BDE */
  0x0000,   /* U+5BDF */
  0xDBE0,   /* U+5BE0 */
  0x0000,   /* U+5BE1 */
  0x0000,   /* U+5BE2 */
  0xDBE3,   /* U+5BE3 */
  0x0000,   /* U+5BE4 */
  0x0000,   /* U+5BE5 */
  0x0000,   /* U+5BE6 */
  0x0000,   /* U+5BE7 */
  0x0000,   /* U+5BE8 */
  0x0000,   /* U+5BE9 */
  0xDBEA,   /* U+5BEA */
  0x0000,   /* U+5BEB */
  0xDBEC,   /* U+5BEC */
  0xDBED,   /* U+5BED */
  0x0000,   /* U+5BEE */
  0xDBEF,   /* U+5BEF */
  0x0000,   /* U+5BF0 */
  0xDBF1,   /* U+5BF1 */
  0xDBF2,   /* U+5BF2 */
  0x0000,   /* U+5BF3 */
  0xDBF4,   /* U+5BF4 */
  0x0000,   /* U+5BF5 */
  0x0000,   /* U+5BF6 */
  0xDBF7,   /* U+5BF7 */
  0x0000,   /* U+5BF8 */
  0xDBF9,   /* U+5BF9 */
  0x0000,   /* U+5BFA */
  0xDBFB,   /* U+5BFB */
  0xDBFC,   /* U+5BFC */
  0xDBFD,   /* U+5BFD */
  0x0000,   /* U+5BFE */
  0x0000,   /* U+5BFF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+5B00 */
  0x0000,   /* U+5B01 */
  0x0000,   /* U+5B02 */
  0x0000,   /* U+5B03 */
  0x0000,   /* U+5B04 */
  0x0000,   /* U+5B05 */
  0x0000,   /* U+5B06 */
  0x0000,   /* U+5B07 */
  0x0000,   /* U+5B08 */
  0x0000,   /* U+5B09 */
  0x0000,   /* U+5B0A */
  0x0000,   /* U+5B0B */
  0x0000,   /* U+5B0C */
  0x0000,   /* U+5B0D */
  0x0000,   /* U+5B0E */
  0x0000,   /* U+5B0F */
  0x0000,   /* U+5B10 */
  0x0000,   /* U+5B11 */
  0x0000,   /* U+5B12 */
  0x0000,   /* U+5B13 */
  0x0000,   /* U+5B14 */
  0x0000,   /* U+5B15 */
  0x0000,   /* U+5B16 */
  0x0000,   /* U+5B17 */
  0x0000,   /* U+5B18 */
  0x0000,   /* U+5B19 */
  0x0000,   /* U+5B1A */
  0x0000,   /* U+5B1B */
  0x0000,   /* U+5B1C */
  0x0000,   /* U+5B1D */
  0x0000,   /* U+5B1E */
  0x0000,   /* U+5B1F */
  0x0000,   /* U+5B20 */
  0x0000,   /* U+5B21 */
  0x0000,   /* U+5B22 */
  0x0000,   /* U+5B23 */
  0x0000,   /* U+5B24 */
  0x0000,   /* U+5B25 */
  0x0000,   /* U+5B26 */
  0x0000,   /* U+5B27 */
  0x0000,   /* U+5B28 */
  0x0000,   /* U+5B29 */
  0x0000,   /* U+5B2A */
  0x0000,   /* U+5B2B */
  0x0000,   /* U+5B2C */
  0x0000,   /* U+5B2D */
  0x0000,   /* U+5B2E */
  0x0000,   /* U+5B2F */
  0x0000,   /* U+5B30 */
  0x0000,   /* U+5B31 */
  0x0000,   /* U+5B32 */
  0x0000,   /* U+5B33 */
  0x0000,   /* U+5B34 */
  0x0000,   /* U+5B35 */
  0x0000,   /* U+5B36 */
  0x0000,   /* U+5B37 */
  0x0000,   /* U+5B38 */
  0x0000,   /* U+5B39 */
  0x0000,   /* U+5B3A */
  0x0000,   /* U+5B3B */
  0x0000,   /* U+5B3C */
  0x0000,   /* U+5B3D */
  0x0000,   /* U+5B3E */
  0x0000,   /* U+5B3F */
  0x0000,   /* U+5B40 */
  0x0000,   /* U+5B41 */
  0x0000,   /* U+5B42 */
  0x0000,   /* U+5B43 */
  0x0000,   /* U+5B44 */
  0x0000,   /* U+5B45 */
  0x0000,   /* U+5B46 */
  0x0000,   /* U+5B47 */
  0x0000,   /* U+5B48 */
  0x0000,   /* U+5B49 */
  0x0000,   /* U+5B4A */
  0x0000,   /* U+5B4B */
  0x0000,   /* U+5B4C */
  0x0000,   /* U+5B4D */
  0x0000,   /* U+5B4E */
  0x0000,   /* U+5B4F */
  0x0000,   /* U+5B50 */
  0x0000,   /* U+5B51 */
  0x0000,   /* U+5B52 */
  0x0000,   /* U+5B53 */
  0x0000,   /* U+5B54 */
  0x0000,   /* U+5B55 */
  0x0000,   /* U+5B56 */
  0x0000,   /* U+5B57 */
  0x0000,   /* U+5B58 */
  0x0000,   /* U+5B59 */
  0x0000,   /* U+5B5A */
  0x0000,   /* U+5B5B */
  0x0000,   /* U+5B5C */
  0x0000,   /* U+5B5D */
  0x0000,   /* U+5B5E */
  0x0000,   /* U+5B5F */
  0x0000,   /* U+5B60 */
  0x0000,   /* U+5B61 */
  0x0000,   /* U+5B62 */
  0x0000,   /* U+5B63 */
  0x0000,   /* U+5B64 */
  0x0000,   /* U+5B65 */
  0x0000,   /* U+5B66 */
  0x0000,   /* U+5B67 */
  0x0000,   /* U+5B68 */
  0x0000,   /* U+5B69 */
  0x0000,   /* U+5B6A */
  0x0000,   /* U+5B6B */
  0x0000,   /* U+5B6C */
  0x0000,   /* U+5B6D */
  0x0000,   /* U+5B6E */
  0x0000,   /* U+5B6F */
  0x0000,   /* U+5B70 */
  0x0000,   /* U+5B71 */
  0x0000,   /* U+5B72 */
  0x0000,   /* U+5B73 */
  0x0000,   /* U+5B74 */
  0x0000,   /* U+5B75 */
  0x0000,   /* U+5B76 */
  0x0000,   /* U+5B77 */
  0x0000,   /* U+5B78 */
  0x0000,   /* U+5B79 */
  0x0000,   /* U+5B7A */
  0x0000,   /* U+5B7B */
  0x0000,   /* U+5B7C */
  0x0000,   /* U+5B7D */
  0x0000,   /* U+5B7E */
  0x0000,   /* U+5B7F */
  0x0000,   /* U+5B80 */
  0x0000,   /* U+5B81 */
  0x0000,   /* U+5B82 */
  0x0000,   /* U+5B83 */
  0x0000,   /* U+5B84 */
  0x0000,   /* U+5B85 */
  0x0000,   /* U+5B86 */
  0x0000,   /* U+5B87 */
  0x0000,   /* U+5B88 */
  0x0000,   /* U+5B89 */
  0x0000,   /* U+5B8A */
  0x0000,   /* U+5B8B */
  0x0000,   /* U+5B8C */
  0x0000,   /* U+5B8D */
  0x0000,   /* U+5B8E */
  0x0000,   /* U+5B8F */
  0x0000,   /* U+5B90 */
  0x0000,   /* U+5B91 */
  0x0000,   /* U+5B92 */
  0x0000,   /* U+5B93 */
  0x0000,   /* U+5B94 */
  0x0000,   /* U+5B95 */
  0x0000,   /* U+5B96 */
  0x0000,   /* U+5B97 */
  0x0000,   /* U+5B98 */
  0x0000,   /* U+5B99 */
  0x0000,   /* U+5B9A */
  0x0000,   /* U+5B9B */
  0x0000,   /* U+5B9C */
  0x0000,   /* U+5B9D */
  0x0000,   /* U+5B9E */
  0x0000,   /* U+5B9F */
  0x0000,   /* U+5BA0 */
  0x0000,   /* U+5BA1 */
  0x0000,   /* U+5BA2 */
  0x0000,   /* U+5BA3 */
  0x0000,   /* U+5BA4 */
  0x0000,   /* U+5BA5 */
  0x0000,   /* U+5BA6 */
  0x0000,   /* U+5BA7 */
  0x0000,   /* U+5BA8 */
  0x0000,   /* U+5BA9 */
  0x0000,   /* U+5BAA */
  0x0000,   /* U+5BAB */
  0x0000,   /* U+5BAC */
  0x0000,   /* U+5BAD */
  0x0000,   /* U+5BAE */
  0x0000,   /* U+5BAF */
  0x0000,   /* U+5BB0 */
  0x0000,   /* U+5BB1 */
  0x0000,   /* U+5BB2 */
  0x0000,   /* U+5BB3 */
  0x0000,   /* U+5BB4 */
  0x0000,   /* U+5BB5 */
  0x0000,   /* U+5BB6 */
  0x0000,   /* U+5BB7 */
  0x0000,   /* U+5BB8 */
  0x0000,   /* U+5BB9 */
  0x0000,   /* U+5BBA */
  0x0000,   /* U+5BBB */
  0x0000,   /* U+5BBC */
  0x0000,   /* U+5BBD */
  0x0000,   /* U+5BBE */
  0x0000,   /* U+5BBF */
  0x0000,   /* U+5BC0 */
  0x0000,   /* U+5BC1 */
  0x0000,   /* U+5BC2 */
  0x0000,   /* U+5BC3 */
  0x0000,   /* U+5BC4 */
  0x0000,   /* U+5BC5 */
  0x0000,   /* U+5BC6 */
  0x0000,   /* U+5BC7 */
  0x0000,   /* U+5BC8 */
  0x0000,   /* U+5BC9 */
  0x0000,   /* U+5BCA */
  0x0000,   /* U+5BCB */
  0x0000,   /* U+5BCC */
  0x0000,   /* U+5BCD */
  0x0000,   /* U+5BCE */
  0x0000,   /* U+5BCF */
  0x0000,   /* U+5BD0 */
  0x0000,   /* U+5BD1 */
  0x0000,   /* U+5BD2 */
  0x0000,   /* U+5BD3 */
  0x0000,   /* U+5BD4 */
  0x0000,   /* U+5BD5 */
  0x0000,   /* U+5BD6 */
  0x0000,   /* U+5BD7 */
  0x0000,   /* U+5BD8 */
  0x0000,   /* U+5BD9 */
  0x0000,   /* U+5BDA */
  0x0000,   /* U+5BDB */
  0x0000,   /* U+5BDC */
  0x0000,   /* U+5BDD */
  0x0000,   /* U+5BDE */
  0x0000,   /* U+5BDF */
  0x0000,   /* U+5BE0 */
  0x0000,   /* U+5BE1 */
  0x0000,   /* U+5BE2 */
  0x0000,   /* U+5BE3 */
  0x0000,   /* U+5BE4 */
  0x0000,   /* U+5BE5 */
  0x0000,   /* U+5BE6 */
  0x0000,   /* U+5BE7 */
  0x0000,   /* U+5BE8 */
  0x0000,   /* U+5BE9 */
  0x0000,   /* U+5BEA */
  0x0000,   /* U+5BEB */
  0x0000,   /* U+5BEC */
  0x0000,   /* U+5BED */
  0x0000,   /* U+5BEE */
  0x0000,   /* U+5BEF */
  0x0000,   /* U+5BF0 */
  0x0000,   /* U+5BF1 */
  0x0000,   /* U+5BF2 */
  0x0000,   /* U+5BF3 */
  0x0000,   /* U+5BF4 */
  0x0000,   /* U+5BF5 */
  0x0000,   /* U+5BF6 */
  0x0000,   /* U+5BF7 */
  0x0000,   /* U+5BF8 */
  0x0000,   /* U+5BF9 */
  0x0000,   /* U+5BFA */
  0x0000,   /* U+5BFB */
  0x0000,   /* U+5BFC */
  0x0000,   /* U+5BFD */
  0x0000,   /* U+5BFE */
  0x0000,   /* U+5BFF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+5B00 */
  0x0000,   /* U+5B01 */
  0x0000,   /* U+5B02 */
  0x0000,   /* U+5B03 */
  0x0000,   /* U+5B04 */
  0x0000,   /* U+5B05 */
  0x0000,   /* U+5B06 */
  0x0000,   /* U+5B07 */
  0x0000,   /* U+5B08 */
  0x0000,   /* U+5B09 */
  0x0000,   /* U+5B0A */
  0x0000,   /* U+5B0B */
  0x0000,   /* U+5B0C */
  0x0000,   /* U+5B0D */
  0x0000,   /* U+5B0E */
  0x0000,   /* U+5B0F */
  0x0000,   /* U+5B10 */
  0x0000,   /* U+5B11 */
  0x0000,   /* U+5B12 */
  0x0000,   /* U+5B13 */
  0x0000,   /* U+5B14 */
  0x0000,   /* U+5B15 */
  0x0000,   /* U+5B16 */
  0x0000,   /* U+5B17 */
  0x0000,   /* U+5B18 */
  0x0000,   /* U+5B19 */
  0x0000,   /* U+5B1A */
  0x0000,   /* U+5B1B */
  0x0000,   /* U+5B1C */
  0x0000,   /* U+5B1D */
  0x0000,   /* U+5B1E */
  0x0000,   /* U+5B1F */
  0x0000,   /* U+5B20 */
  0x0000,   /* U+5B21 */
  0x0000,   /* U+5B22 */
  0x0000,   /* U+5B23 */
  0x0000,   /* U+5B24 */
  0x0000,   /* U+5B25 */
  0x0000,   /* U+5B26 */
  0x0000,   /* U+5B27 */
  0x0000,   /* U+5B28 */
  0x0000,   /* U+5B29 */
  0x0000,   /* U+5B2A */
  0x0000,   /* U+5B2B */
  0x0000,   /* U+5B2C */
  0x0000,   /* U+5B2D */
  0x0000,   /* U+5B2E */
  0x0000,   /* U+5B2F */
  0x0000,   /* U+5B30 */
  0x0000,   /* U+5B31 */
  0x0000,   /* U+5B32 */
  0x0000,   /* U+5B33 */
  0x0000,   /* U+5B34 */
  0x0000,   /* U+5B35 */
  0x0000,   /* U+5B36 */
  0x0000,   /* U+5B37 */
  0x0000,   /* U+5B38 */
  0x0000,   /* U+5B39 */
  0x0000,   /* U+5B3A */
  0x0000,   /* U+5B3B */
  0x0000,   /* U+5B3C */
  0x0000,   /* U+5B3D */
  0x0000,   /* U+5B3E */
  0x0000,   /* U+5B3F */
  0x0000,   /* U+5B40 */
  0x0000,   /* U+5B41 */
  0x0000,   /* U+5B42 */
  0x0000,   /* U+5B43 */
  0x0000,   /* U+5B44 */
  0x0000,   /* U+5B45 */
  0x0000,   /* U+5B46 */
  0x0000,   /* U+5B47 */
  0x0000,   /* U+5B48 */
  0x0000,   /* U+5B49 */
  0x0000,   /* U+5B4A */
  0x0000,   /* U+5B4B */
  0x0000,   /* U+5B4C */
  0x0000,   /* U+5B4D */
  0x0000,   /* U+5B4E */
  0x0000,   /* U+5B4F */
  0x0000,   /* U+5B50 */
  0x0000,   /* U+5B51 */
  0x0000,   /* U+5B52 */
  0x0000,   /* U+5B53 */
  0x0000,   /* U+5B54 */
  0x0000,   /* U+5B55 */
  0x0000,   /* U+5B56 */
  0x0000,   /* U+5B57 */
  0x0000,   /* U+5B58 */
  0x0000,   /* U+5B59 */
  0x0000,   /* U+5B5A */
  0x0000,   /* U+5B5B */
  0x0000,   /* U+5B5C */
  0x0000,   /* U+5B5D */
  0x0000,   /* U+5B5E */
  0x0000,   /* U+5B5F */
  0x0000,   /* U+5B60 */
  0x0000,   /* U+5B61 */
  0x0000,   /* U+5B62 */
  0x0000,   /* U+5B63 */
  0x0000,   /* U+5B64 */
  0x0000,   /* U+5B65 */
  0x0000,   /* U+5B66 */
  0x0000,   /* U+5B67 */
  0x0000,   /* U+5B68 */
  0x0000,   /* U+5B69 */
  0x0000,   /* U+5B6A */
  0x0000,   /* U+5B6B */
  0x0000,   /* U+5B6C */
  0x0000,   /* U+5B6D */
  0x0000,   /* U+5B6E */
  0x0000,   /* U+5B6F */
  0x0000,   /* U+5B70 */
  0x0000,   /* U+5B71 */
  0x0000,   /* U+5B72 */
  0x0000,   /* U+5B73 */
  0x0000,   /* U+5B74 */
  0x0000,   /* U+5B75 */
  0x0000,   /* U+5B76 */
  0x0000,   /* U+5B77 */
  0x0000,   /* U+5B78 */
  0x0000,   /* U+5B79 */
  0x0000,   /* U+5B7A */
  0x0000,   /* U+5B7B */
  0x0000,   /* U+5B7C */
  0x0000,   /* U+5B7D */
  0x0000,   /* U+5B7E */
  0x0000,   /* U+5B7F */
  0x0000,   /* U+5B80 */
  0x0000,   /* U+5B81 */
  0x0000,   /* U+5B82 */
  0x0000,   /* U+5B83 */
  0x0000,   /* U+5B84 */
  0x0000,   /* U+5B85 */
  0x0000,   /* U+5B86 */
  0x0000,   /* U+5B87 */
  0x0000,   /* U+5B88 */
  0x0000,   /* U+5B89 */
  0x0000,   /* U+5B8A */
  0x0000,   /* U+5B8B */
  0x0000,   /* U+5B8C */
  0x0000,   /* U+5B8D */
  0x0000,   /* U+5B8E */
  0x0000,   /* U+5B8F */
  0x0000,   /* U+5B90 */
  0x0000,   /* U+5B91 */
  0x0000,   /* U+5B92 */
  0x0000,   /* U+5B93 */
  0x0000,   /* U+5B94 */
  0x0000,   /* U+5B95 */
  0x0000,   /* U+5B96 */
  0x0000,   /* U+5B97 */
  0x0000,   /* U+5B98 */
  0x0000,   /* U+5B99 */
  0x0000,   /* U+5B9A */
  0x0000,   /* U+5B9B */
  0x0000,   /* U+5B9C */
  0x0000,   /* U+5B9D */
  0x0000,   /* U+5B9E */
  0x0000,   /* U+5B9F */
  0x0000,   /* U+5BA0 */
  0x0000,   /* U+5BA1 */
  0x0000,   /* U+5BA2 */
  0x0000,   /* U+5BA3 */
  0x0000,   /* U+5BA4 */
  0x0000,   /* U+5BA5 */
  0x0000,   /* U+5BA6 */
  0x0000,   /* U+5BA7 */
  0x0000,   /* U+5BA8 */
  0x0000,   /* U+5BA9 */
  0x0000,   /* U+5BAA */
  0x0000,   /* U+5BAB */
  0x0000,   /* U+5BAC */
  0x0000,   /* U+5BAD */
  0x0000,   /* U+5BAE */
  0x0000,   /* U+5BAF */
  0x0000,   /* U+5BB0 */
  0x0000,   /* U+5BB1 */
  0x0000,   /* U+5BB2 */
  0x0000,   /* U+5BB3 */
  0x0000,   /* U+5BB4 */
  0x0000,   /* U+5BB5 */
  0x0000,   /* U+5BB6 */
  0x0000,   /* U+5BB7 */
  0x0000,   /* U+5BB8 */
  0x0000,   /* U+5BB9 */
  0x0000,   /* U+5BBA */
  0x0000,   /* U+5BBB */
  0x0000,   /* U+5BBC */
  0x0000,   /* U+5BBD */
  0x0000,   /* U+5BBE */
  0x0000,   /* U+5BBF */
  0x0000,   /* U+5BC0 */
  0x0000,   /* U+5BC1 */
  0x0000,   /* U+5BC2 */
  0x0000,   /* U+5BC3 */
  0x0000,   /* U+5BC4 */
  0x0000,   /* U+5BC5 */
  0x0000,   /* U+5BC6 */
  0x0000,   /* U+5BC7 */
  0x0000,   /* U+5BC8 */
  0x0000,   /* U+5BC9 */
  0x0000,   /* U+5BCA */
  0x0000,   /* U+5BCB */
  0x0000,   /* U+5BCC */
  0x0000,   /* U+5BCD */
  0x0000,   /* U+5BCE */
  0x0000,   /* U+5BCF */
  0x0000,   /* U+5BD0 */
  0x0000,   /* U+5BD1 */
  0x0000,   /* U+5BD2 */
  0x0000,   /* U+5BD3 */
  0x0000,   /* U+5BD4 */
  0x0000,   /* U+5BD5 */
  0x0000,   /* U+5BD6 */
  0x0000,   /* U+5BD7 */
  0x0000,   /* U+5BD8 */
  0x0000,   /* U+5BD9 */
  0x0000,   /* U+5BDA */
  0x0000,   /* U+5BDB */
  0x0000,   /* U+5BDC */
  0x0000,   /* U+5BDD */
  0x0000,   /* U+5BDE */
  0x0000,   /* U+5BDF */
  0x0000,   /* U+5BE0 */
  0x0000,   /* U+5BE1 */
  0x0000,   /* U+5BE2 */
  0x0000,   /* U+5BE3 */
  0x0000,   /* U+5BE4 */
  0x0000,   /* U+5BE5 */
  0x0000,   /* U+5BE6 */
  0x0000,   /* U+5BE7 */
  0x0000,   /* U+5BE8 */
  0x0000,   /* U+5BE9 */
  0x0000,   /* U+5BEA */
  0x0000,   /* U+5BEB */
  0x0000,   /* U+5BEC */
  0x0000,   /* U+5BED */
  0x0000,   /* U+5BEE */
  0x0000,   /* U+5BEF */
  0x0000,   /* U+5BF0 */
  0x0000,   /* U+5BF1 */
  0x0000,   /* U+5BF2 */
  0x0000,   /* U+5BF3 */
  0x0000,   /* U+5BF4 */
  0x0000,   /* U+5BF5 */
  0x0000,   /* U+5BF6 */
  0x0000,   /* U+5BF7 */
  0x0000,   /* U+5BF8 */
  0x0000,   /* U+5BF9 */
  0x0000,   /* U+5BFA */
  0x0000,   /* U+5BFB */
  0x0000,   /* U+5BFC */
  0x0000,   /* U+5BFD */
  0x0000,   /* U+5BFE */
  0x0000,   /* U+5BFF */
};

uint16 ja_han_page5C[]= {
  /* Number of CEs for each character. */
  2, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1,
  2, 1, 2, 1, 2, 2, 1, 2, 2, 2, 1, 2, 2, 2, 2, 2,
  1, 2, 1, 2, 1, 2, 2, 2, 1, 2, 2, 2, 2, 1, 2, 2,
  2, 1, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 2, 2, 2, 1, 1, 2, 1, 2, 1, 1, 2, 1, 1, 1,
  1, 1, 2, 1, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2,
  1, 1, 2, 2, 1, 1, 2, 2, 2, 2, 2, 2, 1, 2, 1, 1,
  2, 1, 2, 2, 2, 2, 1, 2, 2, 1, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2,
  1, 1, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 1, 2, 2, 2, 2, 2, 2, 1, 1, 2, 1, 1, 2, 2, 2,
  2, 1, 2, 1, 2, 2, 1, 1, 1, 2, 2, 1, 1, 2, 1, 2,
  2, 2, 2, 2, 2, 1, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2,
  1, 1, 2, 2, 2, 2, 2, 2, 1, 1, 1, 2, 2, 1, 2, 1,
  1, 2, 2, 2, 2, 2, 1, 2, 2, 2, 1, 1, 2, 1, 2, 2,

  /* Primary weight 1 for each character. */
  0xFB40,   /* U+5C00 */
  0x5E26,   /* U+5C01 */
  0x5ACF,   /* U+5C02 */
  0xFB40,   /* U+5C03 */
  0x5938,   /* U+5C04 */
  0x625F,   /* U+5C05 */
  0x59D4,   /* U+5C06 */
  0x6260,   /* U+5C07 */
  0x6261,   /* U+5C08 */
  0x54D6,   /* U+5C09 */
  0x5B59,   /* U+5C0A */
  0x5A57,   /* U+5C0B */
  0xFB40,   /* U+5C0C */
  0x6262,   /* U+5C0D */
  0x5CCA,   /* U+5C0E */
  0x59D5,   /* U+5C0F */
  0xFB40,   /* U+5C10 */
  0x59D6,   /* U+5C11 */
  0xFB40,   /* U+5C12 */
  0x6263,   /* U+5C13 */
  0xFB40,   /* U+5C14 */
  0xFB40,   /* U+5C15 */
  0x5AD0,   /* U+5C16 */
  0xFB40,   /* U+5C17 */
  0xFB40,   /* U+5C18 */
  0xFB40,   /* U+5C19 */
  0x59D7,   /* U+5C1A */
  0xFB40,   /* U+5C1B */
  0xFB40,   /* U+5C1C */
  0xFB40,   /* U+5C1D */
  0xFB40,   /* U+5C1E */
  0xFB40,   /* U+5C1F */
  0x6264,   /* U+5C20 */
  0xFB40,   /* U+5C21 */
  0x6265,   /* U+5C22 */
  0xFB40,   /* U+5C23 */
  0x5F2B,   /* U+5C24 */
  0xFB40,   /* U+5C25 */
  0xFB40,   /* U+5C26 */
  0xFB40,   /* U+5C27 */
  0x6266,   /* U+5C28 */
  0xFB40,   /* U+5C29 */
  0xFB40,   /* U+5C2A */
  0xFB40,   /* U+5C2B */
  0xFB40,   /* U+5C2C */
  0x56FD,   /* U+5C2D */
  0xFB40,   /* U+5C2E */
  0xFB40,   /* U+5C2F */
  0xFB40,   /* U+5C30 */
  0x596B,   /* U+5C31 */
  0xFB40,   /* U+5C32 */
  0xFB40,   /* U+5C33 */
  0xFB40,   /* U+5C34 */
  0xFB40,   /* U+5C35 */
  0xFB40,   /* U+5C36 */
  0xFB40,   /* U+5C37 */
  0x6267,   /* U+5C38 */
  0x6268,   /* U+5C39 */
  0x5947,   /* U+5C3A */
  0x5A31,   /* U+5C3B */
  0x5D0B,   /* U+5C3C */
  0x5A59,   /* U+5C3D */
  0x5DCB,   /* U+5C3E */
  0x5D17,   /* U+5C3F */
  0x5700,   /* U+5C40 */
  0x6269,   /* U+5C41 */
  0xFB40,   /* U+5C42 */
  0xFB40,   /* U+5C43 */
  0xFB40,   /* U+5C44 */
  0x56C8,   /* U+5C45 */
  0x626A,   /* U+5C46 */
  0xFB40,   /* U+5C47 */
  0x5735,   /* U+5C48 */
  0xFB40,   /* U+5C49 */
  0x5CE6,   /* U+5C4A */
  0x556F,   /* U+5C4B */
  0xFB40,   /* U+5C4C */
  0x58E0,   /* U+5C4D */
  0x626B,   /* U+5C4E */
  0x626E,   /* U+5C4F */
  0x626D,   /* U+5C50 */
  0x5734,   /* U+5C51 */
  0xFB40,   /* U+5C52 */
  0x626C,   /* U+5C53 */
  0xFB40,   /* U+5C54 */
  0x5C71,   /* U+5C55 */
  0xFB40,   /* U+5C56 */
  0xFB40,   /* U+5C57 */
  0xFB40,   /* U+5C58 */
  0xFB40,   /* U+5C59 */
  0xFB40,   /* U+5C5A */
  0xFB40,   /* U+5C5B */
  0xFB40,   /* U+5C5C */
  0xFB40,   /* U+5C5D */
  0x5B4F,   /* U+5C5E */
  0xFB40,   /* U+5C5F */
  0x5C84,   /* U+5C60 */
  0x5933,   /* U+5C61 */
  0xFB40,   /* U+5C62 */
  0xFB40,   /* U+5C63 */
  0x5B19,   /* U+5C64 */
  0x5FA3,   /* U+5C65 */
  0xFB40,   /* U+5C66 */
  0xFB40,   /* U+5C67 */
  0xFB40,   /* U+5C68 */
  0xFB40,   /* U+5C69 */
  0xFB40,   /* U+5C6A */
  0xFB40,   /* U+5C6B */
  0x6270,   /* U+5C6C */
  0xFB40,   /* U+5C6D */
  0x6271,   /* U+5C6E */
  0x5CED,   /* U+5C6F */
  0xFB40,   /* U+5C70 */
  0x58C0,   /* U+5C71 */
  0xFB40,   /* U+5C72 */
  0xFB40,   /* U+5C73 */
  0xFB40,   /* U+5C74 */
  0xFB40,   /* U+5C75 */
  0x6273,   /* U+5C76 */
  0xFB40,   /* U+5C77 */
  0xFB40,   /* U+5C78 */
  0x6274,   /* U+5C79 */
  0xFB40,   /* U+5C7A */
  0xFB40,   /* U+5C7B */
  0xFB40,   /* U+5C7C */
  0xFB40,   /* U+5C7D */
  0xFB40,   /* U+5C7E */
  0xFB40,   /* U+5C7F */
  0xFB40,   /* U+5C80 */
  0xFB40,   /* U+5C81 */
  0xFB40,   /* U+5C82 */
  0xFB40,   /* U+5C83 */
  0xFB40,   /* U+5C84 */
  0xFB40,   /* U+5C85 */
  0xFB40,   /* U+5C86 */
  0xFB40,   /* U+5C87 */
  0xFB40,   /* U+5C88 */
  0xFB40,   /* U+5C89 */
  0xFB40,   /* U+5C8A */
  0xFB40,   /* U+5C8B */
  0x6275,   /* U+5C8C */
  0xFB40,   /* U+5C8D */
  0xFB40,   /* U+5C8E */
  0xFB40,   /* U+5C8F */
  0x566F,   /* U+5C90 */
  0x6276,   /* U+5C91 */
  0xFB40,   /* U+5C92 */
  0xFB40,   /* U+5C93 */
  0x6277,   /* U+5C94 */
  0xFB40,   /* U+5C95 */
  0xFB40,   /* U+5C96 */
  0xFB40,   /* U+5C97 */
  0xFB40,   /* U+5C98 */
  0xFB40,   /* U+5C99 */
  0xFB40,   /* U+5C9A */
  0xFB40,   /* U+5C9B */
  0xFB40,   /* U+5C9C */
  0xFB40,   /* U+5C9D */
  0xFB40,   /* U+5C9E */
  0xFB40,   /* U+5C9F */
  0xFB40,   /* U+5CA0 */
  0x556B,   /* U+5CA1 */
  0xFB40,   /* U+5CA2 */
  0xFB40,   /* U+5CA3 */
  0xFB40,   /* U+5CA4 */
  0xFB40,   /* U+5CA5 */
  0xFB40,   /* U+5CA6 */
  0xFB40,   /* U+5CA7 */
  0x5AFC,   /* U+5CA8 */
  0x565F,   /* U+5CA9 */
  0xFB40,   /* U+5CAA */
  0x6279,   /* U+5CAB */
  0x5EF3,   /* U+5CAC */
  0xFB40,   /* U+5CAD */
  0xFB40,   /* U+5CAE */
  0xFB40,   /* U+5CAF */
  0xFB40,   /* U+5CB0 */
  0x5B71,   /* U+5CB1 */
  0xFB40,   /* U+5CB2 */
  0x55F6,   /* U+5CB3 */
  0xFB40,   /* U+5CB4 */
  0xFB40,   /* U+5CB5 */
  0x627B,   /* U+5CB6 */
  0x627D,   /* U+5CB7 */
  0x565A,   /* U+5CB8 */
  0xFB40,   /* U+5CB9 */
  0xFB40,   /* U+5CBA */
  0x627A,   /* U+5CBB */
  0x627C,   /* U+5CBC */
  0xFB40,   /* U+5CBD */
  0x627F,   /* U+5CBE */
  0xFB40,   /* U+5CBF */
  0xFB40,   /* U+5CC0 */
  0xFB40,   /* U+5CC1 */
  0xFB40,   /* U+5CC2 */
  0xFB40,   /* U+5CC3 */
  0xFB40,   /* U+5CC4 */
  0x627E,   /* U+5CC5 */
  0xFB40,   /* U+5CC6 */
  0x6280,   /* U+5CC7 */
  0xFB40,   /* U+5CC8 */
  0xFB40,   /* U+5CC9 */
  0xFB40,   /* U+5CCA */
  0xFB40,   /* U+5CCB */
  0xFB40,   /* U+5CCC */
  0xFB40,   /* U+5CCD */
  0xFB40,   /* U+5CCE */
  0xFB40,   /* U+5CCF */
  0xFB40,   /* U+5CD0 */
  0xFB40,   /* U+5CD1 */
  0xFB40,   /* U+5CD2 */
  0xFB40,   /* U+5CD3 */
  0xFB40,   /* U+5CD4 */
  0xFB40,   /* U+5CD5 */
  0xFB40,   /* U+5CD6 */
  0xFB40,   /* U+5CD7 */
  0xFB40,   /* U+5CD8 */
  0x6281,   /* U+5CD9 */
  0xFB40,   /* U+5CDA */
  0xFB40,   /* U+5CDB */
  0xFB40,   /* U+5CDC */
  0xFB40,   /* U+5CDD */
  0xFB40,   /* U+5CDE */
  0xFB40,   /* U+5CDF */
  0x5CD4,   /* U+5CE0 */
  0x56E5,   /* U+5CE1 */
  0xFB40,   /* U+5CE2 */
  0xFB40,   /* U+5CE3 */
  0xFB40,   /* U+5CE4 */
  0xFB40,   /* U+5CE5 */
  0xFB40,   /* U+5CE6 */
  0xFB40,   /* U+5CE7 */
  0x55A4,   /* U+5CE8 */
  0x6282,   /* U+5CE9 */
  0x6287,   /* U+5CEA */
  0xFB40,   /* U+5CEB */
  0xFB40,   /* U+5CEC */
  0x6285,   /* U+5CED */
  0xFB40,   /* U+5CEE */
  0x5E86,   /* U+5CEF */
  0x5E85,   /* U+5CF0 */
  0xFB40,   /* U+5CF1 */
  0xFB40,   /* U+5CF2 */
  0xFB40,   /* U+5CF3 */
  0xFB40,   /* U+5CF4 */
  0xFB40,   /* U+5CF5 */
  0x5CA0,   /* U+5CF6 */
  0xFB40,   /* U+5CF7 */
  0xFB40,   /* U+5CF8 */
  0xFB40,   /* U+5CF9 */
  0x6284,   /* U+5CFA */
  0x599D,   /* U+5CFB */
  0xFB40,   /* U+5CFC */
  0x6283,   /* U+5CFD */
  0xFB40,   /* U+5CFE */
  0xFB40,   /* U+5CFF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+5C00 */
  0x0020,   /* U+5C01 */
  0x0020,   /* U+5C02 */
  0x0020,   /* U+5C03 */
  0x0020,   /* U+5C04 */
  0x0020,   /* U+5C05 */
  0x0020,   /* U+5C06 */
  0x0020,   /* U+5C07 */
  0x0020,   /* U+5C08 */
  0x0020,   /* U+5C09 */
  0x0020,   /* U+5C0A */
  0x0020,   /* U+5C0B */
  0x0020,   /* U+5C0C */
  0x0020,   /* U+5C0D */
  0x0020,   /* U+5C0E */
  0x0020,   /* U+5C0F */
  0x0020,   /* U+5C10 */
  0x0020,   /* U+5C11 */
  0x0020,   /* U+5C12 */
  0x0020,   /* U+5C13 */
  0x0020,   /* U+5C14 */
  0x0020,   /* U+5C15 */
  0x0020,   /* U+5C16 */
  0x0020,   /* U+5C17 */
  0x0020,   /* U+5C18 */
  0x0020,   /* U+5C19 */
  0x0020,   /* U+5C1A */
  0x0020,   /* U+5C1B */
  0x0020,   /* U+5C1C */
  0x0020,   /* U+5C1D */
  0x0020,   /* U+5C1E */
  0x0020,   /* U+5C1F */
  0x0020,   /* U+5C20 */
  0x0020,   /* U+5C21 */
  0x0020,   /* U+5C22 */
  0x0020,   /* U+5C23 */
  0x0020,   /* U+5C24 */
  0x0020,   /* U+5C25 */
  0x0020,   /* U+5C26 */
  0x0020,   /* U+5C27 */
  0x0020,   /* U+5C28 */
  0x0020,   /* U+5C29 */
  0x0020,   /* U+5C2A */
  0x0020,   /* U+5C2B */
  0x0020,   /* U+5C2C */
  0x0020,   /* U+5C2D */
  0x0020,   /* U+5C2E */
  0x0020,   /* U+5C2F */
  0x0020,   /* U+5C30 */
  0x0020,   /* U+5C31 */
  0x0020,   /* U+5C32 */
  0x0020,   /* U+5C33 */
  0x0020,   /* U+5C34 */
  0x0020,   /* U+5C35 */
  0x0020,   /* U+5C36 */
  0x0020,   /* U+5C37 */
  0x0020,   /* U+5C38 */
  0x0020,   /* U+5C39 */
  0x0020,   /* U+5C3A */
  0x0020,   /* U+5C3B */
  0x0020,   /* U+5C3C */
  0x0020,   /* U+5C3D */
  0x0020,   /* U+5C3E */
  0x0020,   /* U+5C3F */
  0x0020,   /* U+5C40 */
  0x0020,   /* U+5C41 */
  0x0020,   /* U+5C42 */
  0x0020,   /* U+5C43 */
  0x0020,   /* U+5C44 */
  0x0020,   /* U+5C45 */
  0x0020,   /* U+5C46 */
  0x0020,   /* U+5C47 */
  0x0020,   /* U+5C48 */
  0x0020,   /* U+5C49 */
  0x0020,   /* U+5C4A */
  0x0020,   /* U+5C4B */
  0x0020,   /* U+5C4C */
  0x0020,   /* U+5C4D */
  0x0020,   /* U+5C4E */
  0x0020,   /* U+5C4F */
  0x0020,   /* U+5C50 */
  0x0020,   /* U+5C51 */
  0x0020,   /* U+5C52 */
  0x0020,   /* U+5C53 */
  0x0020,   /* U+5C54 */
  0x0020,   /* U+5C55 */
  0x0020,   /* U+5C56 */
  0x0020,   /* U+5C57 */
  0x0020,   /* U+5C58 */
  0x0020,   /* U+5C59 */
  0x0020,   /* U+5C5A */
  0x0020,   /* U+5C5B */
  0x0020,   /* U+5C5C */
  0x0020,   /* U+5C5D */
  0x0020,   /* U+5C5E */
  0x0020,   /* U+5C5F */
  0x0020,   /* U+5C60 */
  0x0020,   /* U+5C61 */
  0x0020,   /* U+5C62 */
  0x0020,   /* U+5C63 */
  0x0020,   /* U+5C64 */
  0x0020,   /* U+5C65 */
  0x0020,   /* U+5C66 */
  0x0020,   /* U+5C67 */
  0x0020,   /* U+5C68 */
  0x0020,   /* U+5C69 */
  0x0020,   /* U+5C6A */
  0x0020,   /* U+5C6B */
  0x0020,   /* U+5C6C */
  0x0020,   /* U+5C6D */
  0x0020,   /* U+5C6E */
  0x0020,   /* U+5C6F */
  0x0020,   /* U+5C70 */
  0x0020,   /* U+5C71 */
  0x0020,   /* U+5C72 */
  0x0020,   /* U+5C73 */
  0x0020,   /* U+5C74 */
  0x0020,   /* U+5C75 */
  0x0020,   /* U+5C76 */
  0x0020,   /* U+5C77 */
  0x0020,   /* U+5C78 */
  0x0020,   /* U+5C79 */
  0x0020,   /* U+5C7A */
  0x0020,   /* U+5C7B */
  0x0020,   /* U+5C7C */
  0x0020,   /* U+5C7D */
  0x0020,   /* U+5C7E */
  0x0020,   /* U+5C7F */
  0x0020,   /* U+5C80 */
  0x0020,   /* U+5C81 */
  0x0020,   /* U+5C82 */
  0x0020,   /* U+5C83 */
  0x0020,   /* U+5C84 */
  0x0020,   /* U+5C85 */
  0x0020,   /* U+5C86 */
  0x0020,   /* U+5C87 */
  0x0020,   /* U+5C88 */
  0x0020,   /* U+5C89 */
  0x0020,   /* U+5C8A */
  0x0020,   /* U+5C8B */
  0x0020,   /* U+5C8C */
  0x0020,   /* U+5C8D */
  0x0020,   /* U+5C8E */
  0x0020,   /* U+5C8F */
  0x0020,   /* U+5C90 */
  0x0020,   /* U+5C91 */
  0x0020,   /* U+5C92 */
  0x0020,   /* U+5C93 */
  0x0020,   /* U+5C94 */
  0x0020,   /* U+5C95 */
  0x0020,   /* U+5C96 */
  0x0020,   /* U+5C97 */
  0x0020,   /* U+5C98 */
  0x0020,   /* U+5C99 */
  0x0020,   /* U+5C9A */
  0x0020,   /* U+5C9B */
  0x0020,   /* U+5C9C */
  0x0020,   /* U+5C9D */
  0x0020,   /* U+5C9E */
  0x0020,   /* U+5C9F */
  0x0020,   /* U+5CA0 */
  0x0020,   /* U+5CA1 */
  0x0020,   /* U+5CA2 */
  0x0020,   /* U+5CA3 */
  0x0020,   /* U+5CA4 */
  0x0020,   /* U+5CA5 */
  0x0020,   /* U+5CA6 */
  0x0020,   /* U+5CA7 */
  0x0020,   /* U+5CA8 */
  0x0020,   /* U+5CA9 */
  0x0020,   /* U+5CAA */
  0x0020,   /* U+5CAB */
  0x0020,   /* U+5CAC */
  0x0020,   /* U+5CAD */
  0x0020,   /* U+5CAE */
  0x0020,   /* U+5CAF */
  0x0020,   /* U+5CB0 */
  0x0020,   /* U+5CB1 */
  0x0020,   /* U+5CB2 */
  0x0020,   /* U+5CB3 */
  0x0020,   /* U+5CB4 */
  0x0020,   /* U+5CB5 */
  0x0020,   /* U+5CB6 */
  0x0020,   /* U+5CB7 */
  0x0020,   /* U+5CB8 */
  0x0020,   /* U+5CB9 */
  0x0020,   /* U+5CBA */
  0x0020,   /* U+5CBB */
  0x0020,   /* U+5CBC */
  0x0020,   /* U+5CBD */
  0x0020,   /* U+5CBE */
  0x0020,   /* U+5CBF */
  0x0020,   /* U+5CC0 */
  0x0020,   /* U+5CC1 */
  0x0020,   /* U+5CC2 */
  0x0020,   /* U+5CC3 */
  0x0020,   /* U+5CC4 */
  0x0020,   /* U+5CC5 */
  0x0020,   /* U+5CC6 */
  0x0020,   /* U+5CC7 */
  0x0020,   /* U+5CC8 */
  0x0020,   /* U+5CC9 */
  0x0020,   /* U+5CCA */
  0x0020,   /* U+5CCB */
  0x0020,   /* U+5CCC */
  0x0020,   /* U+5CCD */
  0x0020,   /* U+5CCE */
  0x0020,   /* U+5CCF */
  0x0020,   /* U+5CD0 */
  0x0020,   /* U+5CD1 */
  0x0020,   /* U+5CD2 */
  0x0020,   /* U+5CD3 */
  0x0020,   /* U+5CD4 */
  0x0020,   /* U+5CD5 */
  0x0020,   /* U+5CD6 */
  0x0020,   /* U+5CD7 */
  0x0020,   /* U+5CD8 */
  0x0020,   /* U+5CD9 */
  0x0020,   /* U+5CDA */
  0x0020,   /* U+5CDB */
  0x0020,   /* U+5CDC */
  0x0020,   /* U+5CDD */
  0x0020,   /* U+5CDE */
  0x0020,   /* U+5CDF */
  0x0020,   /* U+5CE0 */
  0x0020,   /* U+5CE1 */
  0x0020,   /* U+5CE2 */
  0x0020,   /* U+5CE3 */
  0x0020,   /* U+5CE4 */
  0x0020,   /* U+5CE5 */
  0x0020,   /* U+5CE6 */
  0x0020,   /* U+5CE7 */
  0x0020,   /* U+5CE8 */
  0x0020,   /* U+5CE9 */
  0x0020,   /* U+5CEA */
  0x0020,   /* U+5CEB */
  0x0020,   /* U+5CEC */
  0x0020,   /* U+5CED */
  0x0020,   /* U+5CEE */
  0x0020,   /* U+5CEF */
  0x0020,   /* U+5CF0 */
  0x0020,   /* U+5CF1 */
  0x0020,   /* U+5CF2 */
  0x0020,   /* U+5CF3 */
  0x0020,   /* U+5CF4 */
  0x0020,   /* U+5CF5 */
  0x0020,   /* U+5CF6 */
  0x0020,   /* U+5CF7 */
  0x0020,   /* U+5CF8 */
  0x0020,   /* U+5CF9 */
  0x0020,   /* U+5CFA */
  0x0020,   /* U+5CFB */
  0x0020,   /* U+5CFC */
  0x0020,   /* U+5CFD */
  0x0020,   /* U+5CFE */
  0x0020,   /* U+5CFF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+5C00 */
  0x0002,   /* U+5C01 */
  0x0002,   /* U+5C02 */
  0x0002,   /* U+5C03 */
  0x0002,   /* U+5C04 */
  0x0002,   /* U+5C05 */
  0x0002,   /* U+5C06 */
  0x0002,   /* U+5C07 */
  0x0002,   /* U+5C08 */
  0x0002,   /* U+5C09 */
  0x0002,   /* U+5C0A */
  0x0002,   /* U+5C0B */
  0x0002,   /* U+5C0C */
  0x0002,   /* U+5C0D */
  0x0002,   /* U+5C0E */
  0x0002,   /* U+5C0F */
  0x0002,   /* U+5C10 */
  0x0002,   /* U+5C11 */
  0x0002,   /* U+5C12 */
  0x0002,   /* U+5C13 */
  0x0002,   /* U+5C14 */
  0x0002,   /* U+5C15 */
  0x0002,   /* U+5C16 */
  0x0002,   /* U+5C17 */
  0x0002,   /* U+5C18 */
  0x0002,   /* U+5C19 */
  0x0002,   /* U+5C1A */
  0x0002,   /* U+5C1B */
  0x0002,   /* U+5C1C */
  0x0002,   /* U+5C1D */
  0x0002,   /* U+5C1E */
  0x0002,   /* U+5C1F */
  0x0002,   /* U+5C20 */
  0x0002,   /* U+5C21 */
  0x0002,   /* U+5C22 */
  0x0002,   /* U+5C23 */
  0x0002,   /* U+5C24 */
  0x0002,   /* U+5C25 */
  0x0002,   /* U+5C26 */
  0x0002,   /* U+5C27 */
  0x0002,   /* U+5C28 */
  0x0002,   /* U+5C29 */
  0x0002,   /* U+5C2A */
  0x0002,   /* U+5C2B */
  0x0002,   /* U+5C2C */
  0x0002,   /* U+5C2D */
  0x0002,   /* U+5C2E */
  0x0002,   /* U+5C2F */
  0x0002,   /* U+5C30 */
  0x0002,   /* U+5C31 */
  0x0002,   /* U+5C32 */
  0x0002,   /* U+5C33 */
  0x0002,   /* U+5C34 */
  0x0002,   /* U+5C35 */
  0x0002,   /* U+5C36 */
  0x0002,   /* U+5C37 */
  0x0002,   /* U+5C38 */
  0x0002,   /* U+5C39 */
  0x0002,   /* U+5C3A */
  0x0002,   /* U+5C3B */
  0x0002,   /* U+5C3C */
  0x0002,   /* U+5C3D */
  0x0002,   /* U+5C3E */
  0x0002,   /* U+5C3F */
  0x0002,   /* U+5C40 */
  0x0002,   /* U+5C41 */
  0x0002,   /* U+5C42 */
  0x0002,   /* U+5C43 */
  0x0002,   /* U+5C44 */
  0x0002,   /* U+5C45 */
  0x0002,   /* U+5C46 */
  0x0002,   /* U+5C47 */
  0x0002,   /* U+5C48 */
  0x0002,   /* U+5C49 */
  0x0002,   /* U+5C4A */
  0x0002,   /* U+5C4B */
  0x0002,   /* U+5C4C */
  0x0002,   /* U+5C4D */
  0x0002,   /* U+5C4E */
  0x0002,   /* U+5C4F */
  0x0002,   /* U+5C50 */
  0x0002,   /* U+5C51 */
  0x0002,   /* U+5C52 */
  0x0002,   /* U+5C53 */
  0x0002,   /* U+5C54 */
  0x0002,   /* U+5C55 */
  0x0002,   /* U+5C56 */
  0x0002,   /* U+5C57 */
  0x0002,   /* U+5C58 */
  0x0002,   /* U+5C59 */
  0x0002,   /* U+5C5A */
  0x0002,   /* U+5C5B */
  0x0002,   /* U+5C5C */
  0x0002,   /* U+5C5D */
  0x0002,   /* U+5C5E */
  0x0002,   /* U+5C5F */
  0x0002,   /* U+5C60 */
  0x0002,   /* U+5C61 */
  0x0002,   /* U+5C62 */
  0x0002,   /* U+5C63 */
  0x0002,   /* U+5C64 */
  0x0002,   /* U+5C65 */
  0x0002,   /* U+5C66 */
  0x0002,   /* U+5C67 */
  0x0002,   /* U+5C68 */
  0x0002,   /* U+5C69 */
  0x0002,   /* U+5C6A */
  0x0002,   /* U+5C6B */
  0x0002,   /* U+5C6C */
  0x0002,   /* U+5C6D */
  0x0002,   /* U+5C6E */
  0x0002,   /* U+5C6F */
  0x0002,   /* U+5C70 */
  0x0002,   /* U+5C71 */
  0x0002,   /* U+5C72 */
  0x0002,   /* U+5C73 */
  0x0002,   /* U+5C74 */
  0x0002,   /* U+5C75 */
  0x0002,   /* U+5C76 */
  0x0002,   /* U+5C77 */
  0x0002,   /* U+5C78 */
  0x0002,   /* U+5C79 */
  0x0002,   /* U+5C7A */
  0x0002,   /* U+5C7B */
  0x0002,   /* U+5C7C */
  0x0002,   /* U+5C7D */
  0x0002,   /* U+5C7E */
  0x0002,   /* U+5C7F */
  0x0002,   /* U+5C80 */
  0x0002,   /* U+5C81 */
  0x0002,   /* U+5C82 */
  0x0002,   /* U+5C83 */
  0x0002,   /* U+5C84 */
  0x0002,   /* U+5C85 */
  0x0002,   /* U+5C86 */
  0x0002,   /* U+5C87 */
  0x0002,   /* U+5C88 */
  0x0002,   /* U+5C89 */
  0x0002,   /* U+5C8A */
  0x0002,   /* U+5C8B */
  0x0002,   /* U+5C8C */
  0x0002,   /* U+5C8D */
  0x0002,   /* U+5C8E */
  0x0002,   /* U+5C8F */
  0x0002,   /* U+5C90 */
  0x0002,   /* U+5C91 */
  0x0002,   /* U+5C92 */
  0x0002,   /* U+5C93 */
  0x0002,   /* U+5C94 */
  0x0002,   /* U+5C95 */
  0x0002,   /* U+5C96 */
  0x0002,   /* U+5C97 */
  0x0002,   /* U+5C98 */
  0x0002,   /* U+5C99 */
  0x0002,   /* U+5C9A */
  0x0002,   /* U+5C9B */
  0x0002,   /* U+5C9C */
  0x0002,   /* U+5C9D */
  0x0002,   /* U+5C9E */
  0x0002,   /* U+5C9F */
  0x0002,   /* U+5CA0 */
  0x0002,   /* U+5CA1 */
  0x0002,   /* U+5CA2 */
  0x0002,   /* U+5CA3 */
  0x0002,   /* U+5CA4 */
  0x0002,   /* U+5CA5 */
  0x0002,   /* U+5CA6 */
  0x0002,   /* U+5CA7 */
  0x0002,   /* U+5CA8 */
  0x0002,   /* U+5CA9 */
  0x0002,   /* U+5CAA */
  0x0002,   /* U+5CAB */
  0x0002,   /* U+5CAC */
  0x0002,   /* U+5CAD */
  0x0002,   /* U+5CAE */
  0x0002,   /* U+5CAF */
  0x0002,   /* U+5CB0 */
  0x0002,   /* U+5CB1 */
  0x0002,   /* U+5CB2 */
  0x0002,   /* U+5CB3 */
  0x0002,   /* U+5CB4 */
  0x0002,   /* U+5CB5 */
  0x0002,   /* U+5CB6 */
  0x0002,   /* U+5CB7 */
  0x0002,   /* U+5CB8 */
  0x0002,   /* U+5CB9 */
  0x0002,   /* U+5CBA */
  0x0002,   /* U+5CBB */
  0x0002,   /* U+5CBC */
  0x0002,   /* U+5CBD */
  0x0002,   /* U+5CBE */
  0x0002,   /* U+5CBF */
  0x0002,   /* U+5CC0 */
  0x0002,   /* U+5CC1 */
  0x0002,   /* U+5CC2 */
  0x0002,   /* U+5CC3 */
  0x0002,   /* U+5CC4 */
  0x0002,   /* U+5CC5 */
  0x0002,   /* U+5CC6 */
  0x0002,   /* U+5CC7 */
  0x0002,   /* U+5CC8 */
  0x0002,   /* U+5CC9 */
  0x0002,   /* U+5CCA */
  0x0002,   /* U+5CCB */
  0x0002,   /* U+5CCC */
  0x0002,   /* U+5CCD */
  0x0002,   /* U+5CCE */
  0x0002,   /* U+5CCF */
  0x0002,   /* U+5CD0 */
  0x0002,   /* U+5CD1 */
  0x0002,   /* U+5CD2 */
  0x0002,   /* U+5CD3 */
  0x0002,   /* U+5CD4 */
  0x0002,   /* U+5CD5 */
  0x0002,   /* U+5CD6 */
  0x0002,   /* U+5CD7 */
  0x0002,   /* U+5CD8 */
  0x0002,   /* U+5CD9 */
  0x0002,   /* U+5CDA */
  0x0002,   /* U+5CDB */
  0x0002,   /* U+5CDC */
  0x0002,   /* U+5CDD */
  0x0002,   /* U+5CDE */
  0x0002,   /* U+5CDF */
  0x0002,   /* U+5CE0 */
  0x0002,   /* U+5CE1 */
  0x0002,   /* U+5CE2 */
  0x0002,   /* U+5CE3 */
  0x0002,   /* U+5CE4 */
  0x0002,   /* U+5CE5 */
  0x0002,   /* U+5CE6 */
  0x0002,   /* U+5CE7 */
  0x0002,   /* U+5CE8 */
  0x0002,   /* U+5CE9 */
  0x0002,   /* U+5CEA */
  0x0002,   /* U+5CEB */
  0x0002,   /* U+5CEC */
  0x0002,   /* U+5CED */
  0x0002,   /* U+5CEE */
  0x0002,   /* U+5CEF */
  0x0002,   /* U+5CF0 */
  0x0002,   /* U+5CF1 */
  0x0002,   /* U+5CF2 */
  0x0002,   /* U+5CF3 */
  0x0002,   /* U+5CF4 */
  0x0002,   /* U+5CF5 */
  0x0002,   /* U+5CF6 */
  0x0002,   /* U+5CF7 */
  0x0002,   /* U+5CF8 */
  0x0002,   /* U+5CF9 */
  0x0002,   /* U+5CFA */
  0x0002,   /* U+5CFB */
  0x0002,   /* U+5CFC */
  0x0002,   /* U+5CFD */
  0x0002,   /* U+5CFE */
  0x0002,   /* U+5CFF */

  /* Primary weight 2 for each character. */
  0xDC00,   /* U+5C00 */
  0x0000,   /* U+5C01 */
  0x0000,   /* U+5C02 */
  0xDC03,   /* U+5C03 */
  0x0000,   /* U+5C04 */
  0x0000,   /* U+5C05 */
  0x0000,   /* U+5C06 */
  0x0000,   /* U+5C07 */
  0x0000,   /* U+5C08 */
  0x0000,   /* U+5C09 */
  0x0000,   /* U+5C0A */
  0x0000,   /* U+5C0B */
  0xDC0C,   /* U+5C0C */
  0x0000,   /* U+5C0D */
  0x0000,   /* U+5C0E */
  0x0000,   /* U+5C0F */
  0xDC10,   /* U+5C10 */
  0x0000,   /* U+5C11 */
  0xDC12,   /* U+5C12 */
  0x0000,   /* U+5C13 */
  0xDC14,   /* U+5C14 */
  0xDC15,   /* U+5C15 */
  0x0000,   /* U+5C16 */
  0xDC17,   /* U+5C17 */
  0xDC18,   /* U+5C18 */
  0xDC19,   /* U+5C19 */
  0x0000,   /* U+5C1A */
  0xDC1B,   /* U+5C1B */
  0xDC1C,   /* U+5C1C */
  0xDC1D,   /* U+5C1D */
  0xDC1E,   /* U+5C1E */
  0xDC1F,   /* U+5C1F */
  0x0000,   /* U+5C20 */
  0xDC21,   /* U+5C21 */
  0x0000,   /* U+5C22 */
  0xDC23,   /* U+5C23 */
  0x0000,   /* U+5C24 */
  0xDC25,   /* U+5C25 */
  0xDC26,   /* U+5C26 */
  0xDC27,   /* U+5C27 */
  0x0000,   /* U+5C28 */
  0xDC29,   /* U+5C29 */
  0xDC2A,   /* U+5C2A */
  0xDC2B,   /* U+5C2B */
  0xDC2C,   /* U+5C2C */
  0x0000,   /* U+5C2D */
  0xDC2E,   /* U+5C2E */
  0xDC2F,   /* U+5C2F */
  0xDC30,   /* U+5C30 */
  0x0000,   /* U+5C31 */
  0xDC32,   /* U+5C32 */
  0xDC33,   /* U+5C33 */
  0xDC34,   /* U+5C34 */
  0xDC35,   /* U+5C35 */
  0xDC36,   /* U+5C36 */
  0xDC37,   /* U+5C37 */
  0x0000,   /* U+5C38 */
  0x0000,   /* U+5C39 */
  0x0000,   /* U+5C3A */
  0x0000,   /* U+5C3B */
  0x0000,   /* U+5C3C */
  0x0000,   /* U+5C3D */
  0x0000,   /* U+5C3E */
  0x0000,   /* U+5C3F */
  0x0000,   /* U+5C40 */
  0x0000,   /* U+5C41 */
  0xDC42,   /* U+5C42 */
  0xDC43,   /* U+5C43 */
  0xDC44,   /* U+5C44 */
  0x0000,   /* U+5C45 */
  0x0000,   /* U+5C46 */
  0xDC47,   /* U+5C47 */
  0x0000,   /* U+5C48 */
  0xDC49,   /* U+5C49 */
  0x0000,   /* U+5C4A */
  0x0000,   /* U+5C4B */
  0xDC4C,   /* U+5C4C */
  0x0000,   /* U+5C4D */
  0x0000,   /* U+5C4E */
  0x0000,   /* U+5C4F */
  0x0000,   /* U+5C50 */
  0x0000,   /* U+5C51 */
  0xDC52,   /* U+5C52 */
  0x0000,   /* U+5C53 */
  0xDC54,   /* U+5C54 */
  0x0000,   /* U+5C55 */
  0xDC56,   /* U+5C56 */
  0xDC57,   /* U+5C57 */
  0xDC58,   /* U+5C58 */
  0xDC59,   /* U+5C59 */
  0xDC5A,   /* U+5C5A */
  0xDC5B,   /* U+5C5B */
  0xDC5C,   /* U+5C5C */
  0xDC5D,   /* U+5C5D */
  0x0000,   /* U+5C5E */
  0xDC5F,   /* U+5C5F */
  0x0000,   /* U+5C60 */
  0x0000,   /* U+5C61 */
  0xDC62,   /* U+5C62 */
  0xDC63,   /* U+5C63 */
  0x0000,   /* U+5C64 */
  0x0000,   /* U+5C65 */
  0xDC66,   /* U+5C66 */
  0xDC67,   /* U+5C67 */
  0xDC68,   /* U+5C68 */
  0xDC69,   /* U+5C69 */
  0xDC6A,   /* U+5C6A */
  0xDC6B,   /* U+5C6B */
  0x0000,   /* U+5C6C */
  0xDC6D,   /* U+5C6D */
  0x0000,   /* U+5C6E */
  0x0000,   /* U+5C6F */
  0xDC70,   /* U+5C70 */
  0x0000,   /* U+5C71 */
  0xDC72,   /* U+5C72 */
  0xDC73,   /* U+5C73 */
  0xDC74,   /* U+5C74 */
  0xDC75,   /* U+5C75 */
  0x0000,   /* U+5C76 */
  0xDC77,   /* U+5C77 */
  0xDC78,   /* U+5C78 */
  0x0000,   /* U+5C79 */
  0xDC7A,   /* U+5C7A */
  0xDC7B,   /* U+5C7B */
  0xDC7C,   /* U+5C7C */
  0xDC7D,   /* U+5C7D */
  0xDC7E,   /* U+5C7E */
  0xDC7F,   /* U+5C7F */
  0xDC80,   /* U+5C80 */
  0xDC81,   /* U+5C81 */
  0xDC82,   /* U+5C82 */
  0xDC83,   /* U+5C83 */
  0xDC84,   /* U+5C84 */
  0xDC85,   /* U+5C85 */
  0xDC86,   /* U+5C86 */
  0xDC87,   /* U+5C87 */
  0xDC88,   /* U+5C88 */
  0xDC89,   /* U+5C89 */
  0xDC8A,   /* U+5C8A */
  0xDC8B,   /* U+5C8B */
  0x0000,   /* U+5C8C */
  0xDC8D,   /* U+5C8D */
  0xDC8E,   /* U+5C8E */
  0xDC8F,   /* U+5C8F */
  0x0000,   /* U+5C90 */
  0x0000,   /* U+5C91 */
  0xDC92,   /* U+5C92 */
  0xDC93,   /* U+5C93 */
  0x0000,   /* U+5C94 */
  0xDC95,   /* U+5C95 */
  0xDC96,   /* U+5C96 */
  0xDC97,   /* U+5C97 */
  0xDC98,   /* U+5C98 */
  0xDC99,   /* U+5C99 */
  0xDC9A,   /* U+5C9A */
  0xDC9B,   /* U+5C9B */
  0xDC9C,   /* U+5C9C */
  0xDC9D,   /* U+5C9D */
  0xDC9E,   /* U+5C9E */
  0xDC9F,   /* U+5C9F */
  0xDCA0,   /* U+5CA0 */
  0x0000,   /* U+5CA1 */
  0xDCA2,   /* U+5CA2 */
  0xDCA3,   /* U+5CA3 */
  0xDCA4,   /* U+5CA4 */
  0xDCA5,   /* U+5CA5 */
  0xDCA6,   /* U+5CA6 */
  0xDCA7,   /* U+5CA7 */
  0x0000,   /* U+5CA8 */
  0x0000,   /* U+5CA9 */
  0xDCAA,   /* U+5CAA */
  0x0000,   /* U+5CAB */
  0x0000,   /* U+5CAC */
  0xDCAD,   /* U+5CAD */
  0xDCAE,   /* U+5CAE */
  0xDCAF,   /* U+5CAF */
  0xDCB0,   /* U+5CB0 */
  0x0000,   /* U+5CB1 */
  0xDCB2,   /* U+5CB2 */
  0x0000,   /* U+5CB3 */
  0xDCB4,   /* U+5CB4 */
  0xDCB5,   /* U+5CB5 */
  0x0000,   /* U+5CB6 */
  0x0000,   /* U+5CB7 */
  0x0000,   /* U+5CB8 */
  0xDCB9,   /* U+5CB9 */
  0xDCBA,   /* U+5CBA */
  0x0000,   /* U+5CBB */
  0x0000,   /* U+5CBC */
  0xDCBD,   /* U+5CBD */
  0x0000,   /* U+5CBE */
  0xDCBF,   /* U+5CBF */
  0xDCC0,   /* U+5CC0 */
  0xDCC1,   /* U+5CC1 */
  0xDCC2,   /* U+5CC2 */
  0xDCC3,   /* U+5CC3 */
  0xDCC4,   /* U+5CC4 */
  0x0000,   /* U+5CC5 */
  0xDCC6,   /* U+5CC6 */
  0x0000,   /* U+5CC7 */
  0xDCC8,   /* U+5CC8 */
  0xDCC9,   /* U+5CC9 */
  0xDCCA,   /* U+5CCA */
  0xDCCB,   /* U+5CCB */
  0xDCCC,   /* U+5CCC */
  0xDCCD,   /* U+5CCD */
  0xDCCE,   /* U+5CCE */
  0xDCCF,   /* U+5CCF */
  0xDCD0,   /* U+5CD0 */
  0xDCD1,   /* U+5CD1 */
  0xDCD2,   /* U+5CD2 */
  0xDCD3,   /* U+5CD3 */
  0xDCD4,   /* U+5CD4 */
  0xDCD5,   /* U+5CD5 */
  0xDCD6,   /* U+5CD6 */
  0xDCD7,   /* U+5CD7 */
  0xDCD8,   /* U+5CD8 */
  0x0000,   /* U+5CD9 */
  0xDCDA,   /* U+5CDA */
  0xDCDB,   /* U+5CDB */
  0xDCDC,   /* U+5CDC */
  0xDCDD,   /* U+5CDD */
  0xDCDE,   /* U+5CDE */
  0xDCDF,   /* U+5CDF */
  0x0000,   /* U+5CE0 */
  0x0000,   /* U+5CE1 */
  0xDCE2,   /* U+5CE2 */
  0xDCE3,   /* U+5CE3 */
  0xDCE4,   /* U+5CE4 */
  0xDCE5,   /* U+5CE5 */
  0xDCE6,   /* U+5CE6 */
  0xDCE7,   /* U+5CE7 */
  0x0000,   /* U+5CE8 */
  0x0000,   /* U+5CE9 */
  0x0000,   /* U+5CEA */
  0xDCEB,   /* U+5CEB */
  0xDCEC,   /* U+5CEC */
  0x0000,   /* U+5CED */
  0xDCEE,   /* U+5CEE */
  0x0000,   /* U+5CEF */
  0x0000,   /* U+5CF0 */
  0xDCF1,   /* U+5CF1 */
  0xDCF2,   /* U+5CF2 */
  0xDCF3,   /* U+5CF3 */
  0xDCF4,   /* U+5CF4 */
  0xDCF5,   /* U+5CF5 */
  0x0000,   /* U+5CF6 */
  0xDCF7,   /* U+5CF7 */
  0xDCF8,   /* U+5CF8 */
  0xDCF9,   /* U+5CF9 */
  0x0000,   /* U+5CFA */
  0x0000,   /* U+5CFB */
  0xDCFC,   /* U+5CFC */
  0x0000,   /* U+5CFD */
  0xDCFE,   /* U+5CFE */
  0xDCFF,   /* U+5CFF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+5C00 */
  0x0000,   /* U+5C01 */
  0x0000,   /* U+5C02 */
  0x0000,   /* U+5C03 */
  0x0000,   /* U+5C04 */
  0x0000,   /* U+5C05 */
  0x0000,   /* U+5C06 */
  0x0000,   /* U+5C07 */
  0x0000,   /* U+5C08 */
  0x0000,   /* U+5C09 */
  0x0000,   /* U+5C0A */
  0x0000,   /* U+5C0B */
  0x0000,   /* U+5C0C */
  0x0000,   /* U+5C0D */
  0x0000,   /* U+5C0E */
  0x0000,   /* U+5C0F */
  0x0000,   /* U+5C10 */
  0x0000,   /* U+5C11 */
  0x0000,   /* U+5C12 */
  0x0000,   /* U+5C13 */
  0x0000,   /* U+5C14 */
  0x0000,   /* U+5C15 */
  0x0000,   /* U+5C16 */
  0x0000,   /* U+5C17 */
  0x0000,   /* U+5C18 */
  0x0000,   /* U+5C19 */
  0x0000,   /* U+5C1A */
  0x0000,   /* U+5C1B */
  0x0000,   /* U+5C1C */
  0x0000,   /* U+5C1D */
  0x0000,   /* U+5C1E */
  0x0000,   /* U+5C1F */
  0x0000,   /* U+5C20 */
  0x0000,   /* U+5C21 */
  0x0000,   /* U+5C22 */
  0x0000,   /* U+5C23 */
  0x0000,   /* U+5C24 */
  0x0000,   /* U+5C25 */
  0x0000,   /* U+5C26 */
  0x0000,   /* U+5C27 */
  0x0000,   /* U+5C28 */
  0x0000,   /* U+5C29 */
  0x0000,   /* U+5C2A */
  0x0000,   /* U+5C2B */
  0x0000,   /* U+5C2C */
  0x0000,   /* U+5C2D */
  0x0000,   /* U+5C2E */
  0x0000,   /* U+5C2F */
  0x0000,   /* U+5C30 */
  0x0000,   /* U+5C31 */
  0x0000,   /* U+5C32 */
  0x0000,   /* U+5C33 */
  0x0000,   /* U+5C34 */
  0x0000,   /* U+5C35 */
  0x0000,   /* U+5C36 */
  0x0000,   /* U+5C37 */
  0x0000,   /* U+5C38 */
  0x0000,   /* U+5C39 */
  0x0000,   /* U+5C3A */
  0x0000,   /* U+5C3B */
  0x0000,   /* U+5C3C */
  0x0000,   /* U+5C3D */
  0x0000,   /* U+5C3E */
  0x0000,   /* U+5C3F */
  0x0000,   /* U+5C40 */
  0x0000,   /* U+5C41 */
  0x0000,   /* U+5C42 */
  0x0000,   /* U+5C43 */
  0x0000,   /* U+5C44 */
  0x0000,   /* U+5C45 */
  0x0000,   /* U+5C46 */
  0x0000,   /* U+5C47 */
  0x0000,   /* U+5C48 */
  0x0000,   /* U+5C49 */
  0x0000,   /* U+5C4A */
  0x0000,   /* U+5C4B */
  0x0000,   /* U+5C4C */
  0x0000,   /* U+5C4D */
  0x0000,   /* U+5C4E */
  0x0000,   /* U+5C4F */
  0x0000,   /* U+5C50 */
  0x0000,   /* U+5C51 */
  0x0000,   /* U+5C52 */
  0x0000,   /* U+5C53 */
  0x0000,   /* U+5C54 */
  0x0000,   /* U+5C55 */
  0x0000,   /* U+5C56 */
  0x0000,   /* U+5C57 */
  0x0000,   /* U+5C58 */
  0x0000,   /* U+5C59 */
  0x0000,   /* U+5C5A */
  0x0000,   /* U+5C5B */
  0x0000,   /* U+5C5C */
  0x0000,   /* U+5C5D */
  0x0000,   /* U+5C5E */
  0x0000,   /* U+5C5F */
  0x0000,   /* U+5C60 */
  0x0000,   /* U+5C61 */
  0x0000,   /* U+5C62 */
  0x0000,   /* U+5C63 */
  0x0000,   /* U+5C64 */
  0x0000,   /* U+5C65 */
  0x0000,   /* U+5C66 */
  0x0000,   /* U+5C67 */
  0x0000,   /* U+5C68 */
  0x0000,   /* U+5C69 */
  0x0000,   /* U+5C6A */
  0x0000,   /* U+5C6B */
  0x0000,   /* U+5C6C */
  0x0000,   /* U+5C6D */
  0x0000,   /* U+5C6E */
  0x0000,   /* U+5C6F */
  0x0000,   /* U+5C70 */
  0x0000,   /* U+5C71 */
  0x0000,   /* U+5C72 */
  0x0000,   /* U+5C73 */
  0x0000,   /* U+5C74 */
  0x0000,   /* U+5C75 */
  0x0000,   /* U+5C76 */
  0x0000,   /* U+5C77 */
  0x0000,   /* U+5C78 */
  0x0000,   /* U+5C79 */
  0x0000,   /* U+5C7A */
  0x0000,   /* U+5C7B */
  0x0000,   /* U+5C7C */
  0x0000,   /* U+5C7D */
  0x0000,   /* U+5C7E */
  0x0000,   /* U+5C7F */
  0x0000,   /* U+5C80 */
  0x0000,   /* U+5C81 */
  0x0000,   /* U+5C82 */
  0x0000,   /* U+5C83 */
  0x0000,   /* U+5C84 */
  0x0000,   /* U+5C85 */
  0x0000,   /* U+5C86 */
  0x0000,   /* U+5C87 */
  0x0000,   /* U+5C88 */
  0x0000,   /* U+5C89 */
  0x0000,   /* U+5C8A */
  0x0000,   /* U+5C8B */
  0x0000,   /* U+5C8C */
  0x0000,   /* U+5C8D */
  0x0000,   /* U+5C8E */
  0x0000,   /* U+5C8F */
  0x0000,   /* U+5C90 */
  0x0000,   /* U+5C91 */
  0x0000,   /* U+5C92 */
  0x0000,   /* U+5C93 */
  0x0000,   /* U+5C94 */
  0x0000,   /* U+5C95 */
  0x0000,   /* U+5C96 */
  0x0000,   /* U+5C97 */
  0x0000,   /* U+5C98 */
  0x0000,   /* U+5C99 */
  0x0000,   /* U+5C9A */
  0x0000,   /* U+5C9B */
  0x0000,   /* U+5C9C */
  0x0000,   /* U+5C9D */
  0x0000,   /* U+5C9E */
  0x0000,   /* U+5C9F */
  0x0000,   /* U+5CA0 */
  0x0000,   /* U+5CA1 */
  0x0000,   /* U+5CA2 */
  0x0000,   /* U+5CA3 */
  0x0000,   /* U+5CA4 */
  0x0000,   /* U+5CA5 */
  0x0000,   /* U+5CA6 */
  0x0000,   /* U+5CA7 */
  0x0000,   /* U+5CA8 */
  0x0000,   /* U+5CA9 */
  0x0000,   /* U+5CAA */
  0x0000,   /* U+5CAB */
  0x0000,   /* U+5CAC */
  0x0000,   /* U+5CAD */
  0x0000,   /* U+5CAE */
  0x0000,   /* U+5CAF */
  0x0000,   /* U+5CB0 */
  0x0000,   /* U+5CB1 */
  0x0000,   /* U+5CB2 */
  0x0000,   /* U+5CB3 */
  0x0000,   /* U+5CB4 */
  0x0000,   /* U+5CB5 */
  0x0000,   /* U+5CB6 */
  0x0000,   /* U+5CB7 */
  0x0000,   /* U+5CB8 */
  0x0000,   /* U+5CB9 */
  0x0000,   /* U+5CBA */
  0x0000,   /* U+5CBB */
  0x0000,   /* U+5CBC */
  0x0000,   /* U+5CBD */
  0x0000,   /* U+5CBE */
  0x0000,   /* U+5CBF */
  0x0000,   /* U+5CC0 */
  0x0000,   /* U+5CC1 */
  0x0000,   /* U+5CC2 */
  0x0000,   /* U+5CC3 */
  0x0000,   /* U+5CC4 */
  0x0000,   /* U+5CC5 */
  0x0000,   /* U+5CC6 */
  0x0000,   /* U+5CC7 */
  0x0000,   /* U+5CC8 */
  0x0000,   /* U+5CC9 */
  0x0000,   /* U+5CCA */
  0x0000,   /* U+5CCB */
  0x0000,   /* U+5CCC */
  0x0000,   /* U+5CCD */
  0x0000,   /* U+5CCE */
  0x0000,   /* U+5CCF */
  0x0000,   /* U+5CD0 */
  0x0000,   /* U+5CD1 */
  0x0000,   /* U+5CD2 */
  0x0000,   /* U+5CD3 */
  0x0000,   /* U+5CD4 */
  0x0000,   /* U+5CD5 */
  0x0000,   /* U+5CD6 */
  0x0000,   /* U+5CD7 */
  0x0000,   /* U+5CD8 */
  0x0000,   /* U+5CD9 */
  0x0000,   /* U+5CDA */
  0x0000,   /* U+5CDB */
  0x0000,   /* U+5CDC */
  0x0000,   /* U+5CDD */
  0x0000,   /* U+5CDE */
  0x0000,   /* U+5CDF */
  0x0000,   /* U+5CE0 */
  0x0000,   /* U+5CE1 */
  0x0000,   /* U+5CE2 */
  0x0000,   /* U+5CE3 */
  0x0000,   /* U+5CE4 */
  0x0000,   /* U+5CE5 */
  0x0000,   /* U+5CE6 */
  0x0000,   /* U+5CE7 */
  0x0000,   /* U+5CE8 */
  0x0000,   /* U+5CE9 */
  0x0000,   /* U+5CEA */
  0x0000,   /* U+5CEB */
  0x0000,   /* U+5CEC */
  0x0000,   /* U+5CED */
  0x0000,   /* U+5CEE */
  0x0000,   /* U+5CEF */
  0x0000,   /* U+5CF0 */
  0x0000,   /* U+5CF1 */
  0x0000,   /* U+5CF2 */
  0x0000,   /* U+5CF3 */
  0x0000,   /* U+5CF4 */
  0x0000,   /* U+5CF5 */
  0x0000,   /* U+5CF6 */
  0x0000,   /* U+5CF7 */
  0x0000,   /* U+5CF8 */
  0x0000,   /* U+5CF9 */
  0x0000,   /* U+5CFA */
  0x0000,   /* U+5CFB */
  0x0000,   /* U+5CFC */
  0x0000,   /* U+5CFD */
  0x0000,   /* U+5CFE */
  0x0000,   /* U+5CFF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+5C00 */
  0x0000,   /* U+5C01 */
  0x0000,   /* U+5C02 */
  0x0000,   /* U+5C03 */
  0x0000,   /* U+5C04 */
  0x0000,   /* U+5C05 */
  0x0000,   /* U+5C06 */
  0x0000,   /* U+5C07 */
  0x0000,   /* U+5C08 */
  0x0000,   /* U+5C09 */
  0x0000,   /* U+5C0A */
  0x0000,   /* U+5C0B */
  0x0000,   /* U+5C0C */
  0x0000,   /* U+5C0D */
  0x0000,   /* U+5C0E */
  0x0000,   /* U+5C0F */
  0x0000,   /* U+5C10 */
  0x0000,   /* U+5C11 */
  0x0000,   /* U+5C12 */
  0x0000,   /* U+5C13 */
  0x0000,   /* U+5C14 */
  0x0000,   /* U+5C15 */
  0x0000,   /* U+5C16 */
  0x0000,   /* U+5C17 */
  0x0000,   /* U+5C18 */
  0x0000,   /* U+5C19 */
  0x0000,   /* U+5C1A */
  0x0000,   /* U+5C1B */
  0x0000,   /* U+5C1C */
  0x0000,   /* U+5C1D */
  0x0000,   /* U+5C1E */
  0x0000,   /* U+5C1F */
  0x0000,   /* U+5C20 */
  0x0000,   /* U+5C21 */
  0x0000,   /* U+5C22 */
  0x0000,   /* U+5C23 */
  0x0000,   /* U+5C24 */
  0x0000,   /* U+5C25 */
  0x0000,   /* U+5C26 */
  0x0000,   /* U+5C27 */
  0x0000,   /* U+5C28 */
  0x0000,   /* U+5C29 */
  0x0000,   /* U+5C2A */
  0x0000,   /* U+5C2B */
  0x0000,   /* U+5C2C */
  0x0000,   /* U+5C2D */
  0x0000,   /* U+5C2E */
  0x0000,   /* U+5C2F */
  0x0000,   /* U+5C30 */
  0x0000,   /* U+5C31 */
  0x0000,   /* U+5C32 */
  0x0000,   /* U+5C33 */
  0x0000,   /* U+5C34 */
  0x0000,   /* U+5C35 */
  0x0000,   /* U+5C36 */
  0x0000,   /* U+5C37 */
  0x0000,   /* U+5C38 */
  0x0000,   /* U+5C39 */
  0x0000,   /* U+5C3A */
  0x0000,   /* U+5C3B */
  0x0000,   /* U+5C3C */
  0x0000,   /* U+5C3D */
  0x0000,   /* U+5C3E */
  0x0000,   /* U+5C3F */
  0x0000,   /* U+5C40 */
  0x0000,   /* U+5C41 */
  0x0000,   /* U+5C42 */
  0x0000,   /* U+5C43 */
  0x0000,   /* U+5C44 */
  0x0000,   /* U+5C45 */
  0x0000,   /* U+5C46 */
  0x0000,   /* U+5C47 */
  0x0000,   /* U+5C48 */
  0x0000,   /* U+5C49 */
  0x0000,   /* U+5C4A */
  0x0000,   /* U+5C4B */
  0x0000,   /* U+5C4C */
  0x0000,   /* U+5C4D */
  0x0000,   /* U+5C4E */
  0x0000,   /* U+5C4F */
  0x0000,   /* U+5C50 */
  0x0000,   /* U+5C51 */
  0x0000,   /* U+5C52 */
  0x0000,   /* U+5C53 */
  0x0000,   /* U+5C54 */
  0x0000,   /* U+5C55 */
  0x0000,   /* U+5C56 */
  0x0000,   /* U+5C57 */
  0x0000,   /* U+5C58 */
  0x0000,   /* U+5C59 */
  0x0000,   /* U+5C5A */
  0x0000,   /* U+5C5B */
  0x0000,   /* U+5C5C */
  0x0000,   /* U+5C5D */
  0x0000,   /* U+5C5E */
  0x0000,   /* U+5C5F */
  0x0000,   /* U+5C60 */
  0x0000,   /* U+5C61 */
  0x0000,   /* U+5C62 */
  0x0000,   /* U+5C63 */
  0x0000,   /* U+5C64 */
  0x0000,   /* U+5C65 */
  0x0000,   /* U+5C66 */
  0x0000,   /* U+5C67 */
  0x0000,   /* U+5C68 */
  0x0000,   /* U+5C69 */
  0x0000,   /* U+5C6A */
  0x0000,   /* U+5C6B */
  0x0000,   /* U+5C6C */
  0x0000,   /* U+5C6D */
  0x0000,   /* U+5C6E */
  0x0000,   /* U+5C6F */
  0x0000,   /* U+5C70 */
  0x0000,   /* U+5C71 */
  0x0000,   /* U+5C72 */
  0x0000,   /* U+5C73 */
  0x0000,   /* U+5C74 */
  0x0000,   /* U+5C75 */
  0x0000,   /* U+5C76 */
  0x0000,   /* U+5C77 */
  0x0000,   /* U+5C78 */
  0x0000,   /* U+5C79 */
  0x0000,   /* U+5C7A */
  0x0000,   /* U+5C7B */
  0x0000,   /* U+5C7C */
  0x0000,   /* U+5C7D */
  0x0000,   /* U+5C7E */
  0x0000,   /* U+5C7F */
  0x0000,   /* U+5C80 */
  0x0000,   /* U+5C81 */
  0x0000,   /* U+5C82 */
  0x0000,   /* U+5C83 */
  0x0000,   /* U+5C84 */
  0x0000,   /* U+5C85 */
  0x0000,   /* U+5C86 */
  0x0000,   /* U+5C87 */
  0x0000,   /* U+5C88 */
  0x0000,   /* U+5C89 */
  0x0000,   /* U+5C8A */
  0x0000,   /* U+5C8B */
  0x0000,   /* U+5C8C */
  0x0000,   /* U+5C8D */
  0x0000,   /* U+5C8E */
  0x0000,   /* U+5C8F */
  0x0000,   /* U+5C90 */
  0x0000,   /* U+5C91 */
  0x0000,   /* U+5C92 */
  0x0000,   /* U+5C93 */
  0x0000,   /* U+5C94 */
  0x0000,   /* U+5C95 */
  0x0000,   /* U+5C96 */
  0x0000,   /* U+5C97 */
  0x0000,   /* U+5C98 */
  0x0000,   /* U+5C99 */
  0x0000,   /* U+5C9A */
  0x0000,   /* U+5C9B */
  0x0000,   /* U+5C9C */
  0x0000,   /* U+5C9D */
  0x0000,   /* U+5C9E */
  0x0000,   /* U+5C9F */
  0x0000,   /* U+5CA0 */
  0x0000,   /* U+5CA1 */
  0x0000,   /* U+5CA2 */
  0x0000,   /* U+5CA3 */
  0x0000,   /* U+5CA4 */
  0x0000,   /* U+5CA5 */
  0x0000,   /* U+5CA6 */
  0x0000,   /* U+5CA7 */
  0x0000,   /* U+5CA8 */
  0x0000,   /* U+5CA9 */
  0x0000,   /* U+5CAA */
  0x0000,   /* U+5CAB */
  0x0000,   /* U+5CAC */
  0x0000,   /* U+5CAD */
  0x0000,   /* U+5CAE */
  0x0000,   /* U+5CAF */
  0x0000,   /* U+5CB0 */
  0x0000,   /* U+5CB1 */
  0x0000,   /* U+5CB2 */
  0x0000,   /* U+5CB3 */
  0x0000,   /* U+5CB4 */
  0x0000,   /* U+5CB5 */
  0x0000,   /* U+5CB6 */
  0x0000,   /* U+5CB7 */
  0x0000,   /* U+5CB8 */
  0x0000,   /* U+5CB9 */
  0x0000,   /* U+5CBA */
  0x0000,   /* U+5CBB */
  0x0000,   /* U+5CBC */
  0x0000,   /* U+5CBD */
  0x0000,   /* U+5CBE */
  0x0000,   /* U+5CBF */
  0x0000,   /* U+5CC0 */
  0x0000,   /* U+5CC1 */
  0x0000,   /* U+5CC2 */
  0x0000,   /* U+5CC3 */
  0x0000,   /* U+5CC4 */
  0x0000,   /* U+5CC5 */
  0x0000,   /* U+5CC6 */
  0x0000,   /* U+5CC7 */
  0x0000,   /* U+5CC8 */
  0x0000,   /* U+5CC9 */
  0x0000,   /* U+5CCA */
  0x0000,   /* U+5CCB */
  0x0000,   /* U+5CCC */
  0x0000,   /* U+5CCD */
  0x0000,   /* U+5CCE */
  0x0000,   /* U+5CCF */
  0x0000,   /* U+5CD0 */
  0x0000,   /* U+5CD1 */
  0x0000,   /* U+5CD2 */
  0x0000,   /* U+5CD3 */
  0x0000,   /* U+5CD4 */
  0x0000,   /* U+5CD5 */
  0x0000,   /* U+5CD6 */
  0x0000,   /* U+5CD7 */
  0x0000,   /* U+5CD8 */
  0x0000,   /* U+5CD9 */
  0x0000,   /* U+5CDA */
  0x0000,   /* U+5CDB */
  0x0000,   /* U+5CDC */
  0x0000,   /* U+5CDD */
  0x0000,   /* U+5CDE */
  0x0000,   /* U+5CDF */
  0x0000,   /* U+5CE0 */
  0x0000,   /* U+5CE1 */
  0x0000,   /* U+5CE2 */
  0x0000,   /* U+5CE3 */
  0x0000,   /* U+5CE4 */
  0x0000,   /* U+5CE5 */
  0x0000,   /* U+5CE6 */
  0x0000,   /* U+5CE7 */
  0x0000,   /* U+5CE8 */
  0x0000,   /* U+5CE9 */
  0x0000,   /* U+5CEA */
  0x0000,   /* U+5CEB */
  0x0000,   /* U+5CEC */
  0x0000,   /* U+5CED */
  0x0000,   /* U+5CEE */
  0x0000,   /* U+5CEF */
  0x0000,   /* U+5CF0 */
  0x0000,   /* U+5CF1 */
  0x0000,   /* U+5CF2 */
  0x0000,   /* U+5CF3 */
  0x0000,   /* U+5CF4 */
  0x0000,   /* U+5CF5 */
  0x0000,   /* U+5CF6 */
  0x0000,   /* U+5CF7 */
  0x0000,   /* U+5CF8 */
  0x0000,   /* U+5CF9 */
  0x0000,   /* U+5CFA */
  0x0000,   /* U+5CFB */
  0x0000,   /* U+5CFC */
  0x0000,   /* U+5CFD */
  0x0000,   /* U+5CFE */
  0x0000,   /* U+5CFF */
};

uint16 ja_han_page5D[]= {
  /* Number of CEs for each character. */
  2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 1, 2, 2, 1, 2,
  2, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 1,
  2, 2, 1, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 2, 1, 2,
  1, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 1, 2, 2, 1,
  2, 2, 2, 1, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 1, 2, 1, 2, 2, 1, 2, 2, 2, 1, 1, 2, 2, 2,
  1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2,
  2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 1, 2,
  2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 1, 2, 1, 1, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 1, 1, 2, 2,
  2, 2, 1, 1, 2, 2, 1, 2, 2, 2, 2, 1, 2, 1, 1, 2,
  2, 1, 2, 1, 2, 1, 1, 1, 1, 2, 2, 1, 2, 2, 1, 2,
  2, 1, 1, 1, 1, 1, 2, 1, 2, 2, 2, 1, 2, 1, 1, 2,

  /* Primary weight 1 for each character. */
  0xFB40,   /* U+5D00 */
  0xFB40,   /* U+5D01 */
  0xFB40,   /* U+5D02 */
  0xFB40,   /* U+5D03 */
  0xFB40,   /* U+5D04 */
  0xFB40,   /* U+5D05 */
  0xFB40,   /* U+5D06 */
  0x5A77,   /* U+5D07 */
  0xFB40,   /* U+5D08 */
  0xFB40,   /* U+5D09 */
  0xFB40,   /* U+5D0A */
  0x6288,   /* U+5D0B */
  0xFB40,   /* U+5D0C */
  0xFB40,   /* U+5D0D */
  0x5899,   /* U+5D0E */
  0xFB40,   /* U+5D0F */
  0xFB40,   /* U+5D10 */
  0x628E,   /* U+5D11 */
  0xFB40,   /* U+5D12 */
  0xFB40,   /* U+5D13 */
  0x628F,   /* U+5D14 */
  0x6289,   /* U+5D15 */
  0x55D0,   /* U+5D16 */
  0x628A,   /* U+5D17 */
  0x6293,   /* U+5D18 */
  0x6292,   /* U+5D19 */
  0x6291,   /* U+5D1A */
  0x628D,   /* U+5D1B */
  0xFB40,   /* U+5D1C */
  0xFB40,   /* U+5D1D */
  0xFB40,   /* U+5D1E */
  0x628C,   /* U+5D1F */
  0xFB40,   /* U+5D20 */
  0xFB40,   /* U+5D21 */
  0x6290,   /* U+5D22 */
  0xFB40,   /* U+5D23 */
  0xFB40,   /* U+5D24 */
  0xFB40,   /* U+5D25 */
  0xFB40,   /* U+5D26 */
  0xFB40,   /* U+5D27 */
  0xFB40,   /* U+5D28 */
  0x5E87,   /* U+5D29 */
  0xFB40,   /* U+5D2A */
  0xFB40,   /* U+5D2B */
  0xFB40,   /* U+5D2C */
  0xFB40,   /* U+5D2D */
  0xFB40,   /* U+5D2E */
  0xFB40,   /* U+5D2F */
  0xFB40,   /* U+5D30 */
  0xFB40,   /* U+5D31 */
  0xFB40,   /* U+5D32 */
  0xFB40,   /* U+5D33 */
  0xFB40,   /* U+5D34 */
  0xFB40,   /* U+5D35 */
  0xFB40,   /* U+5D36 */
  0xFB40,   /* U+5D37 */
  0xFB40,   /* U+5D38 */
  0xFB40,   /* U+5D39 */
  0xFB40,   /* U+5D3A */
  0xFB40,   /* U+5D3B */
  0xFB40,   /* U+5D3C */
  0xFB40,   /* U+5D3D */
  0xFB40,   /* U+5D3E */
  0xFB40,   /* U+5D3F */
  0xFB40,   /* U+5D40 */
  0xFB40,   /* U+5D41 */
  0xFB40,   /* U+5D42 */
  0xFB40,   /* U+5D43 */
  0xFB40,   /* U+5D44 */
  0xFB40,   /* U+5D45 */
  0xFB40,   /* U+5D46 */
  0xFB40,   /* U+5D47 */
  0xFB40,   /* U+5D48 */
  0xFB40,   /* U+5D49 */
  0xFB40,   /* U+5D4A */
  0x6297,   /* U+5D4B */
  0x6294,   /* U+5D4C */
  0xFB40,   /* U+5D4D */
  0x6296,   /* U+5D4E */
  0xFB40,   /* U+5D4F */
  0x5F9B,   /* U+5D50 */
  0xFB40,   /* U+5D51 */
  0x6295,   /* U+5D52 */
  0xFB40,   /* U+5D53 */
  0xFB40,   /* U+5D54 */
  0xFB40,   /* U+5D55 */
  0xFB40,   /* U+5D56 */
  0xFB40,   /* U+5D57 */
  0xFB40,   /* U+5D58 */
  0xFB40,   /* U+5D59 */
  0xFB40,   /* U+5D5A */
  0xFB40,   /* U+5D5B */
  0x628B,   /* U+5D5C */
  0xFB40,   /* U+5D5D */
  0xFB40,   /* U+5D5E */
  0xFB40,   /* U+5D5F */
  0xFB40,   /* U+5D60 */
  0xFB40,   /* U+5D61 */
  0xFB40,   /* U+5D62 */
  0xFB40,   /* U+5D63 */
  0xFB40,   /* U+5D64 */
  0xFB40,   /* U+5D65 */
  0xFB40,   /* U+5D66 */
  0xFB40,   /* U+5D67 */
  0xFB40,   /* U+5D68 */
  0x5A78,   /* U+5D69 */
  0xFB40,   /* U+5D6A */
  0xFB40,   /* U+5D6B */
  0x6298,   /* U+5D6C */
  0xFB40,   /* U+5D6D */
  0xFB40,   /* U+5D6E */
  0x5866,   /* U+5D6F */
  0xFB40,   /* U+5D70 */
  0xFB40,   /* U+5D71 */
  0xFB40,   /* U+5D72 */
  0x6299,   /* U+5D73 */
  0xFB40,   /* U+5D74 */
  0xFB40,   /* U+5D75 */
  0x629A,   /* U+5D76 */
  0xFB40,   /* U+5D77 */
  0xFB40,   /* U+5D78 */
  0xFB40,   /* U+5D79 */
  0xFB40,   /* U+5D7A */
  0xFB40,   /* U+5D7B */
  0xFB40,   /* U+5D7C */
  0xFB40,   /* U+5D7D */
  0xFB40,   /* U+5D7E */
  0xFB40,   /* U+5D7F */
  0xFB40,   /* U+5D80 */
  0xFB40,   /* U+5D81 */
  0x629D,   /* U+5D82 */
  0xFB40,   /* U+5D83 */
  0x629C,   /* U+5D84 */
  0xFB40,   /* U+5D85 */
  0xFB40,   /* U+5D86 */
  0x629B,   /* U+5D87 */
  0xFB40,   /* U+5D88 */
  0xFB40,   /* U+5D89 */
  0xFB40,   /* U+5D8A */
  0x5CA1,   /* U+5D8B */
  0x6286,   /* U+5D8C */
  0xFB40,   /* U+5D8D */
  0xFB40,   /* U+5D8E */
  0xFB40,   /* U+5D8F */
  0x62A3,   /* U+5D90 */
  0xFB40,   /* U+5D91 */
  0xFB40,   /* U+5D92 */
  0xFB40,   /* U+5D93 */
  0xFB40,   /* U+5D94 */
  0xFB40,   /* U+5D95 */
  0xFB40,   /* U+5D96 */
  0xFB40,   /* U+5D97 */
  0xFB40,   /* U+5D98 */
  0xFB40,   /* U+5D99 */
  0xFB40,   /* U+5D9A */
  0xFB40,   /* U+5D9B */
  0xFB40,   /* U+5D9C */
  0x629F,   /* U+5D9D */
  0xFB40,   /* U+5D9E */
  0xFB40,   /* U+5D9F */
  0xFB40,   /* U+5DA0 */
  0xFB40,   /* U+5DA1 */
  0x629E,   /* U+5DA2 */
  0xFB40,   /* U+5DA3 */
  0xFB40,   /* U+5DA4 */
  0xFB40,   /* U+5DA5 */
  0xFB40,   /* U+5DA6 */
  0xFB40,   /* U+5DA7 */
  0xFB40,   /* U+5DA8 */
  0xFB40,   /* U+5DA9 */
  0xFB40,   /* U+5DAA */
  0xFB40,   /* U+5DAB */
  0x62A0,   /* U+5DAC */
  0xFB40,   /* U+5DAD */
  0x62A1,   /* U+5DAE */
  0xFB40,   /* U+5DAF */
  0xFB40,   /* U+5DB0 */
  0xFB40,   /* U+5DB1 */
  0xFB40,   /* U+5DB2 */
  0xFB40,   /* U+5DB3 */
  0xFB40,   /* U+5DB4 */
  0xFB40,   /* U+5DB5 */
  0xFB40,   /* U+5DB6 */
  0x62A4,   /* U+5DB7 */
  0xFB40,   /* U+5DB8 */
  0xFB40,   /* U+5DB9 */
  0x5FED,   /* U+5DBA */
  0xFB40,   /* U+5DBB */
  0x62A5,   /* U+5DBC */
  0x62A2,   /* U+5DBD */
  0xFB40,   /* U+5DBE */
  0xFB40,   /* U+5DBF */
  0xFB40,   /* U+5DC0 */
  0xFB40,   /* U+5DC1 */
  0xFB40,   /* U+5DC2 */
  0xFB40,   /* U+5DC3 */
  0xFB40,   /* U+5DC4 */
  0xFB40,   /* U+5DC5 */
  0xFB40,   /* U+5DC6 */
  0xFB40,   /* U+5DC7 */
  0xFB40,   /* U+5DC8 */
  0x62A6,   /* U+5DC9 */
  0xFB40,   /* U+5DCA */
  0xFB40,   /* U+5DCB */
  0x565B,   /* U+5DCC */
  0x62A7,   /* U+5DCD */
  0xFB40,   /* U+5DCE */
  0xFB40,   /* U+5DCF */
  0xFB40,   /* U+5DD0 */
  0xFB40,   /* U+5DD1 */
  0x62A9,   /* U+5DD2 */
  0x62A8,   /* U+5DD3 */
  0xFB40,   /* U+5DD4 */
  0xFB40,   /* U+5DD5 */
  0x62AA,   /* U+5DD6 */
  0xFB40,   /* U+5DD7 */
  0xFB40,   /* U+5DD8 */
  0xFB40,   /* U+5DD9 */
  0xFB40,   /* U+5DDA */
  0x62AB,   /* U+5DDB */
  0xFB40,   /* U+5DDC */
  0x5AD1,   /* U+5DDD */
  0x596C,   /* U+5DDE */
  0xFB40,   /* U+5DDF */
  0xFB40,   /* U+5DE0 */
  0x59AD,   /* U+5DE1 */
  0xFB40,   /* U+5DE2 */
  0x5B24,   /* U+5DE3 */
  0xFB40,   /* U+5DE4 */
  0x57FA,   /* U+5DE5 */
  0x5867,   /* U+5DE6 */
  0x57FB,   /* U+5DE7 */
  0x56C9,   /* U+5DE8 */
  0xFB40,   /* U+5DE9 */
  0xFB40,   /* U+5DEA */
  0x62AC,   /* U+5DEB */
  0xFB40,   /* U+5DEC */
  0xFB40,   /* U+5DED */
  0x5868,   /* U+5DEE */
  0xFB40,   /* U+5DEF */
  0xFB40,   /* U+5DF0 */
  0x57BD,   /* U+5DF1 */
  0x62AD,   /* U+5DF2 */
  0x5EF1,   /* U+5DF3 */
  0x5D38,   /* U+5DF4 */
  0x62AE,   /* U+5DF5 */
  0xFB40,   /* U+5DF6 */
  0x57FC,   /* U+5DF7 */
  0xFB40,   /* U+5DF8 */
  0xFB40,   /* U+5DF9 */
  0xFB40,   /* U+5DFA */
  0x5627,   /* U+5DFB */
  0xFB40,   /* U+5DFC */
  0x5BA4,   /* U+5DFD */
  0x5709,   /* U+5DFE */
  0xFB40,   /* U+5DFF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+5D00 */
  0x0020,   /* U+5D01 */
  0x0020,   /* U+5D02 */
  0x0020,   /* U+5D03 */
  0x0020,   /* U+5D04 */
  0x0020,   /* U+5D05 */
  0x0020,   /* U+5D06 */
  0x0020,   /* U+5D07 */
  0x0020,   /* U+5D08 */
  0x0020,   /* U+5D09 */
  0x0020,   /* U+5D0A */
  0x0020,   /* U+5D0B */
  0x0020,   /* U+5D0C */
  0x0020,   /* U+5D0D */
  0x0020,   /* U+5D0E */
  0x0020,   /* U+5D0F */
  0x0020,   /* U+5D10 */
  0x0020,   /* U+5D11 */
  0x0020,   /* U+5D12 */
  0x0020,   /* U+5D13 */
  0x0020,   /* U+5D14 */
  0x0020,   /* U+5D15 */
  0x0020,   /* U+5D16 */
  0x0020,   /* U+5D17 */
  0x0020,   /* U+5D18 */
  0x0020,   /* U+5D19 */
  0x0020,   /* U+5D1A */
  0x0020,   /* U+5D1B */
  0x0020,   /* U+5D1C */
  0x0020,   /* U+5D1D */
  0x0020,   /* U+5D1E */
  0x0020,   /* U+5D1F */
  0x0020,   /* U+5D20 */
  0x0020,   /* U+5D21 */
  0x0020,   /* U+5D22 */
  0x0020,   /* U+5D23 */
  0x0020,   /* U+5D24 */
  0x0020,   /* U+5D25 */
  0x0020,   /* U+5D26 */
  0x0020,   /* U+5D27 */
  0x0020,   /* U+5D28 */
  0x0020,   /* U+5D29 */
  0x0020,   /* U+5D2A */
  0x0020,   /* U+5D2B */
  0x0020,   /* U+5D2C */
  0x0020,   /* U+5D2D */
  0x0020,   /* U+5D2E */
  0x0020,   /* U+5D2F */
  0x0020,   /* U+5D30 */
  0x0020,   /* U+5D31 */
  0x0020,   /* U+5D32 */
  0x0020,   /* U+5D33 */
  0x0020,   /* U+5D34 */
  0x0020,   /* U+5D35 */
  0x0020,   /* U+5D36 */
  0x0020,   /* U+5D37 */
  0x0020,   /* U+5D38 */
  0x0020,   /* U+5D39 */
  0x0020,   /* U+5D3A */
  0x0020,   /* U+5D3B */
  0x0020,   /* U+5D3C */
  0x0020,   /* U+5D3D */
  0x0020,   /* U+5D3E */
  0x0020,   /* U+5D3F */
  0x0020,   /* U+5D40 */
  0x0020,   /* U+5D41 */
  0x0020,   /* U+5D42 */
  0x0020,   /* U+5D43 */
  0x0020,   /* U+5D44 */
  0x0020,   /* U+5D45 */
  0x0020,   /* U+5D46 */
  0x0020,   /* U+5D47 */
  0x0020,   /* U+5D48 */
  0x0020,   /* U+5D49 */
  0x0020,   /* U+5D4A */
  0x0020,   /* U+5D4B */
  0x0020,   /* U+5D4C */
  0x0020,   /* U+5D4D */
  0x0020,   /* U+5D4E */
  0x0020,   /* U+5D4F */
  0x0020,   /* U+5D50 */
  0x0020,   /* U+5D51 */
  0x0020,   /* U+5D52 */
  0x0020,   /* U+5D53 */
  0x0020,   /* U+5D54 */
  0x0020,   /* U+5D55 */
  0x0020,   /* U+5D56 */
  0x0020,   /* U+5D57 */
  0x0020,   /* U+5D58 */
  0x0020,   /* U+5D59 */
  0x0020,   /* U+5D5A */
  0x0020,   /* U+5D5B */
  0x0020,   /* U+5D5C */
  0x0020,   /* U+5D5D */
  0x0020,   /* U+5D5E */
  0x0020,   /* U+5D5F */
  0x0020,   /* U+5D60 */
  0x0020,   /* U+5D61 */
  0x0020,   /* U+5D62 */
  0x0020,   /* U+5D63 */
  0x0020,   /* U+5D64 */
  0x0020,   /* U+5D65 */
  0x0020,   /* U+5D66 */
  0x0020,   /* U+5D67 */
  0x0020,   /* U+5D68 */
  0x0020,   /* U+5D69 */
  0x0020,   /* U+5D6A */
  0x0020,   /* U+5D6B */
  0x0020,   /* U+5D6C */
  0x0020,   /* U+5D6D */
  0x0020,   /* U+5D6E */
  0x0020,   /* U+5D6F */
  0x0020,   /* U+5D70 */
  0x0020,   /* U+5D71 */
  0x0020,   /* U+5D72 */
  0x0020,   /* U+5D73 */
  0x0020,   /* U+5D74 */
  0x0020,   /* U+5D75 */
  0x0020,   /* U+5D76 */
  0x0020,   /* U+5D77 */
  0x0020,   /* U+5D78 */
  0x0020,   /* U+5D79 */
  0x0020,   /* U+5D7A */
  0x0020,   /* U+5D7B */
  0x0020,   /* U+5D7C */
  0x0020,   /* U+5D7D */
  0x0020,   /* U+5D7E */
  0x0020,   /* U+5D7F */
  0x0020,   /* U+5D80 */
  0x0020,   /* U+5D81 */
  0x0020,   /* U+5D82 */
  0x0020,   /* U+5D83 */
  0x0020,   /* U+5D84 */
  0x0020,   /* U+5D85 */
  0x0020,   /* U+5D86 */
  0x0020,   /* U+5D87 */
  0x0020,   /* U+5D88 */
  0x0020,   /* U+5D89 */
  0x0020,   /* U+5D8A */
  0x0020,   /* U+5D8B */
  0x0020,   /* U+5D8C */
  0x0020,   /* U+5D8D */
  0x0020,   /* U+5D8E */
  0x0020,   /* U+5D8F */
  0x0020,   /* U+5D90 */
  0x0020,   /* U+5D91 */
  0x0020,   /* U+5D92 */
  0x0020,   /* U+5D93 */
  0x0020,   /* U+5D94 */
  0x0020,   /* U+5D95 */
  0x0020,   /* U+5D96 */
  0x0020,   /* U+5D97 */
  0x0020,   /* U+5D98 */
  0x0020,   /* U+5D99 */
  0x0020,   /* U+5D9A */
  0x0020,   /* U+5D9B */
  0x0020,   /* U+5D9C */
  0x0020,   /* U+5D9D */
  0x0020,   /* U+5D9E */
  0x0020,   /* U+5D9F */
  0x0020,   /* U+5DA0 */
  0x0020,   /* U+5DA1 */
  0x0020,   /* U+5DA2 */
  0x0020,   /* U+5DA3 */
  0x0020,   /* U+5DA4 */
  0x0020,   /* U+5DA5 */
  0x0020,   /* U+5DA6 */
  0x0020,   /* U+5DA7 */
  0x0020,   /* U+5DA8 */
  0x0020,   /* U+5DA9 */
  0x0020,   /* U+5DAA */
  0x0020,   /* U+5DAB */
  0x0020,   /* U+5DAC */
  0x0020,   /* U+5DAD */
  0x0020,   /* U+5DAE */
  0x0020,   /* U+5DAF */
  0x0020,   /* U+5DB0 */
  0x0020,   /* U+5DB1 */
  0x0020,   /* U+5DB2 */
  0x0020,   /* U+5DB3 */
  0x0020,   /* U+5DB4 */
  0x0020,   /* U+5DB5 */
  0x0020,   /* U+5DB6 */
  0x0020,   /* U+5DB7 */
  0x0020,   /* U+5DB8 */
  0x0020,   /* U+5DB9 */
  0x0020,   /* U+5DBA */
  0x0020,   /* U+5DBB */
  0x0020,   /* U+5DBC */
  0x0020,   /* U+5DBD */
  0x0020,   /* U+5DBE */
  0x0020,   /* U+5DBF */
  0x0020,   /* U+5DC0 */
  0x0020,   /* U+5DC1 */
  0x0020,   /* U+5DC2 */
  0x0020,   /* U+5DC3 */
  0x0020,   /* U+5DC4 */
  0x0020,   /* U+5DC5 */
  0x0020,   /* U+5DC6 */
  0x0020,   /* U+5DC7 */
  0x0020,   /* U+5DC8 */
  0x0020,   /* U+5DC9 */
  0x0020,   /* U+5DCA */
  0x0020,   /* U+5DCB */
  0x0020,   /* U+5DCC */
  0x0020,   /* U+5DCD */
  0x0020,   /* U+5DCE */
  0x0020,   /* U+5DCF */
  0x0020,   /* U+5DD0 */
  0x0020,   /* U+5DD1 */
  0x0020,   /* U+5DD2 */
  0x0020,   /* U+5DD3 */
  0x0020,   /* U+5DD4 */
  0x0020,   /* U+5DD5 */
  0x0020,   /* U+5DD6 */
  0x0020,   /* U+5DD7 */
  0x0020,   /* U+5DD8 */
  0x0020,   /* U+5DD9 */
  0x0020,   /* U+5DDA */
  0x0020,   /* U+5DDB */
  0x0020,   /* U+5DDC */
  0x0020,   /* U+5DDD */
  0x0020,   /* U+5DDE */
  0x0020,   /* U+5DDF */
  0x0020,   /* U+5DE0 */
  0x0020,   /* U+5DE1 */
  0x0020,   /* U+5DE2 */
  0x0020,   /* U+5DE3 */
  0x0020,   /* U+5DE4 */
  0x0020,   /* U+5DE5 */
  0x0020,   /* U+5DE6 */
  0x0020,   /* U+5DE7 */
  0x0020,   /* U+5DE8 */
  0x0020,   /* U+5DE9 */
  0x0020,   /* U+5DEA */
  0x0020,   /* U+5DEB */
  0x0020,   /* U+5DEC */
  0x0020,   /* U+5DED */
  0x0020,   /* U+5DEE */
  0x0020,   /* U+5DEF */
  0x0020,   /* U+5DF0 */
  0x0020,   /* U+5DF1 */
  0x0020,   /* U+5DF2 */
  0x0020,   /* U+5DF3 */
  0x0020,   /* U+5DF4 */
  0x0020,   /* U+5DF5 */
  0x0020,   /* U+5DF6 */
  0x0020,   /* U+5DF7 */
  0x0020,   /* U+5DF8 */
  0x0020,   /* U+5DF9 */
  0x0020,   /* U+5DFA */
  0x0020,   /* U+5DFB */
  0x0020,   /* U+5DFC */
  0x0020,   /* U+5DFD */
  0x0020,   /* U+5DFE */
  0x0020,   /* U+5DFF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+5D00 */
  0x0002,   /* U+5D01 */
  0x0002,   /* U+5D02 */
  0x0002,   /* U+5D03 */
  0x0002,   /* U+5D04 */
  0x0002,   /* U+5D05 */
  0x0002,   /* U+5D06 */
  0x0002,   /* U+5D07 */
  0x0002,   /* U+5D08 */
  0x0002,   /* U+5D09 */
  0x0002,   /* U+5D0A */
  0x0002,   /* U+5D0B */
  0x0002,   /* U+5D0C */
  0x0002,   /* U+5D0D */
  0x0002,   /* U+5D0E */
  0x0002,   /* U+5D0F */
  0x0002,   /* U+5D10 */
  0x0002,   /* U+5D11 */
  0x0002,   /* U+5D12 */
  0x0002,   /* U+5D13 */
  0x0002,   /* U+5D14 */
  0x0002,   /* U+5D15 */
  0x0002,   /* U+5D16 */
  0x0002,   /* U+5D17 */
  0x0002,   /* U+5D18 */
  0x0002,   /* U+5D19 */
  0x0002,   /* U+5D1A */
  0x0002,   /* U+5D1B */
  0x0002,   /* U+5D1C */
  0x0002,   /* U+5D1D */
  0x0002,   /* U+5D1E */
  0x0002,   /* U+5D1F */
  0x0002,   /* U+5D20 */
  0x0002,   /* U+5D21 */
  0x0002,   /* U+5D22 */
  0x0002,   /* U+5D23 */
  0x0002,   /* U+5D24 */
  0x0002,   /* U+5D25 */
  0x0002,   /* U+5D26 */
  0x0002,   /* U+5D27 */
  0x0002,   /* U+5D28 */
  0x0002,   /* U+5D29 */
  0x0002,   /* U+5D2A */
  0x0002,   /* U+5D2B */
  0x0002,   /* U+5D2C */
  0x0002,   /* U+5D2D */
  0x0002,   /* U+5D2E */
  0x0002,   /* U+5D2F */
  0x0002,   /* U+5D30 */
  0x0002,   /* U+5D31 */
  0x0002,   /* U+5D32 */
  0x0002,   /* U+5D33 */
  0x0002,   /* U+5D34 */
  0x0002,   /* U+5D35 */
  0x0002,   /* U+5D36 */
  0x0002,   /* U+5D37 */
  0x0002,   /* U+5D38 */
  0x0002,   /* U+5D39 */
  0x0002,   /* U+5D3A */
  0x0002,   /* U+5D3B */
  0x0002,   /* U+5D3C */
  0x0002,   /* U+5D3D */
  0x0002,   /* U+5D3E */
  0x0002,   /* U+5D3F */
  0x0002,   /* U+5D40 */
  0x0002,   /* U+5D41 */
  0x0002,   /* U+5D42 */
  0x0002,   /* U+5D43 */
  0x0002,   /* U+5D44 */
  0x0002,   /* U+5D45 */
  0x0002,   /* U+5D46 */
  0x0002,   /* U+5D47 */
  0x0002,   /* U+5D48 */
  0x0002,   /* U+5D49 */
  0x0002,   /* U+5D4A */
  0x0002,   /* U+5D4B */
  0x0002,   /* U+5D4C */
  0x0002,   /* U+5D4D */
  0x0002,   /* U+5D4E */
  0x0002,   /* U+5D4F */
  0x0002,   /* U+5D50 */
  0x0002,   /* U+5D51 */
  0x0002,   /* U+5D52 */
  0x0002,   /* U+5D53 */
  0x0002,   /* U+5D54 */
  0x0002,   /* U+5D55 */
  0x0002,   /* U+5D56 */
  0x0002,   /* U+5D57 */
  0x0002,   /* U+5D58 */
  0x0002,   /* U+5D59 */
  0x0002,   /* U+5D5A */
  0x0002,   /* U+5D5B */
  0x0002,   /* U+5D5C */
  0x0002,   /* U+5D5D */
  0x0002,   /* U+5D5E */
  0x0002,   /* U+5D5F */
  0x0002,   /* U+5D60 */
  0x0002,   /* U+5D61 */
  0x0002,   /* U+5D62 */
  0x0002,   /* U+5D63 */
  0x0002,   /* U+5D64 */
  0x0002,   /* U+5D65 */
  0x0002,   /* U+5D66 */
  0x0002,   /* U+5D67 */
  0x0002,   /* U+5D68 */
  0x0002,   /* U+5D69 */
  0x0002,   /* U+5D6A */
  0x0002,   /* U+5D6B */
  0x0002,   /* U+5D6C */
  0x0002,   /* U+5D6D */
  0x0002,   /* U+5D6E */
  0x0002,   /* U+5D6F */
  0x0002,   /* U+5D70 */
  0x0002,   /* U+5D71 */
  0x0002,   /* U+5D72 */
  0x0002,   /* U+5D73 */
  0x0002,   /* U+5D74 */
  0x0002,   /* U+5D75 */
  0x0002,   /* U+5D76 */
  0x0002,   /* U+5D77 */
  0x0002,   /* U+5D78 */
  0x0002,   /* U+5D79 */
  0x0002,   /* U+5D7A */
  0x0002,   /* U+5D7B */
  0x0002,   /* U+5D7C */
  0x0002,   /* U+5D7D */
  0x0002,   /* U+5D7E */
  0x0002,   /* U+5D7F */
  0x0002,   /* U+5D80 */
  0x0002,   /* U+5D81 */
  0x0002,   /* U+5D82 */
  0x0002,   /* U+5D83 */
  0x0002,   /* U+5D84 */
  0x0002,   /* U+5D85 */
  0x0002,   /* U+5D86 */
  0x0002,   /* U+5D87 */
  0x0002,   /* U+5D88 */
  0x0002,   /* U+5D89 */
  0x0002,   /* U+5D8A */
  0x0002,   /* U+5D8B */
  0x0002,   /* U+5D8C */
  0x0002,   /* U+5D8D */
  0x0002,   /* U+5D8E */
  0x0002,   /* U+5D8F */
  0x0002,   /* U+5D90 */
  0x0002,   /* U+5D91 */
  0x0002,   /* U+5D92 */
  0x0002,   /* U+5D93 */
  0x0002,   /* U+5D94 */
  0x0002,   /* U+5D95 */
  0x0002,   /* U+5D96 */
  0x0002,   /* U+5D97 */
  0x0002,   /* U+5D98 */
  0x0002,   /* U+5D99 */
  0x0002,   /* U+5D9A */
  0x0002,   /* U+5D9B */
  0x0002,   /* U+5D9C */
  0x0002,   /* U+5D9D */
  0x0002,   /* U+5D9E */
  0x0002,   /* U+5D9F */
  0x0002,   /* U+5DA0 */
  0x0002,   /* U+5DA1 */
  0x0002,   /* U+5DA2 */
  0x0002,   /* U+5DA3 */
  0x0002,   /* U+5DA4 */
  0x0002,   /* U+5DA5 */
  0x0002,   /* U+5DA6 */
  0x0002,   /* U+5DA7 */
  0x0002,   /* U+5DA8 */
  0x0002,   /* U+5DA9 */
  0x0002,   /* U+5DAA */
  0x0002,   /* U+5DAB */
  0x0002,   /* U+5DAC */
  0x0002,   /* U+5DAD */
  0x0002,   /* U+5DAE */
  0x0002,   /* U+5DAF */
  0x0002,   /* U+5DB0 */
  0x0002,   /* U+5DB1 */
  0x0002,   /* U+5DB2 */
  0x0002,   /* U+5DB3 */
  0x0002,   /* U+5DB4 */
  0x0002,   /* U+5DB5 */
  0x0002,   /* U+5DB6 */
  0x0002,   /* U+5DB7 */
  0x0002,   /* U+5DB8 */
  0x0002,   /* U+5DB9 */
  0x0002,   /* U+5DBA */
  0x0002,   /* U+5DBB */
  0x0002,   /* U+5DBC */
  0x0002,   /* U+5DBD */
  0x0002,   /* U+5DBE */
  0x0002,   /* U+5DBF */
  0x0002,   /* U+5DC0 */
  0x0002,   /* U+5DC1 */
  0x0002,   /* U+5DC2 */
  0x0002,   /* U+5DC3 */
  0x0002,   /* U+5DC4 */
  0x0002,   /* U+5DC5 */
  0x0002,   /* U+5DC6 */
  0x0002,   /* U+5DC7 */
  0x0002,   /* U+5DC8 */
  0x0002,   /* U+5DC9 */
  0x0002,   /* U+5DCA */
  0x0002,   /* U+5DCB */
  0x0002,   /* U+5DCC */
  0x0002,   /* U+5DCD */
  0x0002,   /* U+5DCE */
  0x0002,   /* U+5DCF */
  0x0002,   /* U+5DD0 */
  0x0002,   /* U+5DD1 */
  0x0002,   /* U+5DD2 */
  0x0002,   /* U+5DD3 */
  0x0002,   /* U+5DD4 */
  0x0002,   /* U+5DD5 */
  0x0002,   /* U+5DD6 */
  0x0002,   /* U+5DD7 */
  0x0002,   /* U+5DD8 */
  0x0002,   /* U+5DD9 */
  0x0002,   /* U+5DDA */
  0x0002,   /* U+5DDB */
  0x0002,   /* U+5DDC */
  0x0002,   /* U+5DDD */
  0x0002,   /* U+5DDE */
  0x0002,   /* U+5DDF */
  0x0002,   /* U+5DE0 */
  0x0002,   /* U+5DE1 */
  0x0002,   /* U+5DE2 */
  0x0002,   /* U+5DE3 */
  0x0002,   /* U+5DE4 */
  0x0002,   /* U+5DE5 */
  0x0002,   /* U+5DE6 */
  0x0002,   /* U+5DE7 */
  0x0002,   /* U+5DE8 */
  0x0002,   /* U+5DE9 */
  0x0002,   /* U+5DEA */
  0x0002,   /* U+5DEB */
  0x0002,   /* U+5DEC */
  0x0002,   /* U+5DED */
  0x0002,   /* U+5DEE */
  0x0002,   /* U+5DEF */
  0x0002,   /* U+5DF0 */
  0x0002,   /* U+5DF1 */
  0x0002,   /* U+5DF2 */
  0x0002,   /* U+5DF3 */
  0x0002,   /* U+5DF4 */
  0x0002,   /* U+5DF5 */
  0x0002,   /* U+5DF6 */
  0x0002,   /* U+5DF7 */
  0x0002,   /* U+5DF8 */
  0x0002,   /* U+5DF9 */
  0x0002,   /* U+5DFA */
  0x0002,   /* U+5DFB */
  0x0002,   /* U+5DFC */
  0x0002,   /* U+5DFD */
  0x0002,   /* U+5DFE */
  0x0002,   /* U+5DFF */

  /* Primary weight 2 for each character. */
  0xDD00,   /* U+5D00 */
  0xDD01,   /* U+5D01 */
  0xDD02,   /* U+5D02 */
  0xDD03,   /* U+5D03 */
  0xDD04,   /* U+5D04 */
  0xDD05,   /* U+5D05 */
  0xDD06,   /* U+5D06 */
  0x0000,   /* U+5D07 */
  0xDD08,   /* U+5D08 */
  0xDD09,   /* U+5D09 */
  0xDD0A,   /* U+5D0A */
  0x0000,   /* U+5D0B */
  0xDD0C,   /* U+5D0C */
  0xDD0D,   /* U+5D0D */
  0x0000,   /* U+5D0E */
  0xDD0F,   /* U+5D0F */
  0xDD10,   /* U+5D10 */
  0x0000,   /* U+5D11 */
  0xDD12,   /* U+5D12 */
  0xDD13,   /* U+5D13 */
  0x0000,   /* U+5D14 */
  0x0000,   /* U+5D15 */
  0x0000,   /* U+5D16 */
  0x0000,   /* U+5D17 */
  0x0000,   /* U+5D18 */
  0x0000,   /* U+5D19 */
  0x0000,   /* U+5D1A */
  0x0000,   /* U+5D1B */
  0xDD1C,   /* U+5D1C */
  0xDD1D,   /* U+5D1D */
  0xDD1E,   /* U+5D1E */
  0x0000,   /* U+5D1F */
  0xDD20,   /* U+5D20 */
  0xDD21,   /* U+5D21 */
  0x0000,   /* U+5D22 */
  0xDD23,   /* U+5D23 */
  0xDD24,   /* U+5D24 */
  0xDD25,   /* U+5D25 */
  0xDD26,   /* U+5D26 */
  0xDD27,   /* U+5D27 */
  0xDD28,   /* U+5D28 */
  0x0000,   /* U+5D29 */
  0xDD2A,   /* U+5D2A */
  0xDD2B,   /* U+5D2B */
  0xDD2C,   /* U+5D2C */
  0xDD2D,   /* U+5D2D */
  0xDD2E,   /* U+5D2E */
  0xDD2F,   /* U+5D2F */
  0xDD30,   /* U+5D30 */
  0xDD31,   /* U+5D31 */
  0xDD32,   /* U+5D32 */
  0xDD33,   /* U+5D33 */
  0xDD34,   /* U+5D34 */
  0xDD35,   /* U+5D35 */
  0xDD36,   /* U+5D36 */
  0xDD37,   /* U+5D37 */
  0xDD38,   /* U+5D38 */
  0xDD39,   /* U+5D39 */
  0xDD3A,   /* U+5D3A */
  0xDD3B,   /* U+5D3B */
  0xDD3C,   /* U+5D3C */
  0xDD3D,   /* U+5D3D */
  0xDD3E,   /* U+5D3E */
  0xDD3F,   /* U+5D3F */
  0xDD40,   /* U+5D40 */
  0xDD41,   /* U+5D41 */
  0xDD42,   /* U+5D42 */
  0xDD43,   /* U+5D43 */
  0xDD44,   /* U+5D44 */
  0xDD45,   /* U+5D45 */
  0xDD46,   /* U+5D46 */
  0xDD47,   /* U+5D47 */
  0xDD48,   /* U+5D48 */
  0xDD49,   /* U+5D49 */
  0xDD4A,   /* U+5D4A */
  0x0000,   /* U+5D4B */
  0x0000,   /* U+5D4C */
  0xDD4D,   /* U+5D4D */
  0x0000,   /* U+5D4E */
  0xDD4F,   /* U+5D4F */
  0x0000,   /* U+5D50 */
  0xDD51,   /* U+5D51 */
  0x0000,   /* U+5D52 */
  0xDD53,   /* U+5D53 */
  0xDD54,   /* U+5D54 */
  0xDD55,   /* U+5D55 */
  0xDD56,   /* U+5D56 */
  0xDD57,   /* U+5D57 */
  0xDD58,   /* U+5D58 */
  0xDD59,   /* U+5D59 */
  0xDD5A,   /* U+5D5A */
  0xDD5B,   /* U+5D5B */
  0x0000,   /* U+5D5C */
  0xDD5D,   /* U+5D5D */
  0xDD5E,   /* U+5D5E */
  0xDD5F,   /* U+5D5F */
  0xDD60,   /* U+5D60 */
  0xDD61,   /* U+5D61 */
  0xDD62,   /* U+5D62 */
  0xDD63,   /* U+5D63 */
  0xDD64,   /* U+5D64 */
  0xDD65,   /* U+5D65 */
  0xDD66,   /* U+5D66 */
  0xDD67,   /* U+5D67 */
  0xDD68,   /* U+5D68 */
  0x0000,   /* U+5D69 */
  0xDD6A,   /* U+5D6A */
  0xDD6B,   /* U+5D6B */
  0x0000,   /* U+5D6C */
  0xDD6D,   /* U+5D6D */
  0xDD6E,   /* U+5D6E */
  0x0000,   /* U+5D6F */
  0xDD70,   /* U+5D70 */
  0xDD71,   /* U+5D71 */
  0xDD72,   /* U+5D72 */
  0x0000,   /* U+5D73 */
  0xDD74,   /* U+5D74 */
  0xDD75,   /* U+5D75 */
  0x0000,   /* U+5D76 */
  0xDD77,   /* U+5D77 */
  0xDD78,   /* U+5D78 */
  0xDD79,   /* U+5D79 */
  0xDD7A,   /* U+5D7A */
  0xDD7B,   /* U+5D7B */
  0xDD7C,   /* U+5D7C */
  0xDD7D,   /* U+5D7D */
  0xDD7E,   /* U+5D7E */
  0xDD7F,   /* U+5D7F */
  0xDD80,   /* U+5D80 */
  0xDD81,   /* U+5D81 */
  0x0000,   /* U+5D82 */
  0xDD83,   /* U+5D83 */
  0x0000,   /* U+5D84 */
  0xDD85,   /* U+5D85 */
  0xDD86,   /* U+5D86 */
  0x0000,   /* U+5D87 */
  0xDD88,   /* U+5D88 */
  0xDD89,   /* U+5D89 */
  0xDD8A,   /* U+5D8A */
  0x0000,   /* U+5D8B */
  0x0000,   /* U+5D8C */
  0xDD8D,   /* U+5D8D */
  0xDD8E,   /* U+5D8E */
  0xDD8F,   /* U+5D8F */
  0x0000,   /* U+5D90 */
  0xDD91,   /* U+5D91 */
  0xDD92,   /* U+5D92 */
  0xDD93,   /* U+5D93 */
  0xDD94,   /* U+5D94 */
  0xDD95,   /* U+5D95 */
  0xDD96,   /* U+5D96 */
  0xDD97,   /* U+5D97 */
  0xDD98,   /* U+5D98 */
  0xDD99,   /* U+5D99 */
  0xDD9A,   /* U+5D9A */
  0xDD9B,   /* U+5D9B */
  0xDD9C,   /* U+5D9C */
  0x0000,   /* U+5D9D */
  0xDD9E,   /* U+5D9E */
  0xDD9F,   /* U+5D9F */
  0xDDA0,   /* U+5DA0 */
  0xDDA1,   /* U+5DA1 */
  0x0000,   /* U+5DA2 */
  0xDDA3,   /* U+5DA3 */
  0xDDA4,   /* U+5DA4 */
  0xDDA5,   /* U+5DA5 */
  0xDDA6,   /* U+5DA6 */
  0xDDA7,   /* U+5DA7 */
  0xDDA8,   /* U+5DA8 */
  0xDDA9,   /* U+5DA9 */
  0xDDAA,   /* U+5DAA */
  0xDDAB,   /* U+5DAB */
  0x0000,   /* U+5DAC */
  0xDDAD,   /* U+5DAD */
  0x0000,   /* U+5DAE */
  0xDDAF,   /* U+5DAF */
  0xDDB0,   /* U+5DB0 */
  0xDDB1,   /* U+5DB1 */
  0xDDB2,   /* U+5DB2 */
  0xDDB3,   /* U+5DB3 */
  0xDDB4,   /* U+5DB4 */
  0xDDB5,   /* U+5DB5 */
  0xDDB6,   /* U+5DB6 */
  0x0000,   /* U+5DB7 */
  0xDDB8,   /* U+5DB8 */
  0xDDB9,   /* U+5DB9 */
  0x0000,   /* U+5DBA */
  0xDDBB,   /* U+5DBB */
  0x0000,   /* U+5DBC */
  0x0000,   /* U+5DBD */
  0xDDBE,   /* U+5DBE */
  0xDDBF,   /* U+5DBF */
  0xDDC0,   /* U+5DC0 */
  0xDDC1,   /* U+5DC1 */
  0xDDC2,   /* U+5DC2 */
  0xDDC3,   /* U+5DC3 */
  0xDDC4,   /* U+5DC4 */
  0xDDC5,   /* U+5DC5 */
  0xDDC6,   /* U+5DC6 */
  0xDDC7,   /* U+5DC7 */
  0xDDC8,   /* U+5DC8 */
  0x0000,   /* U+5DC9 */
  0xDDCA,   /* U+5DCA */
  0xDDCB,   /* U+5DCB */
  0x0000,   /* U+5DCC */
  0x0000,   /* U+5DCD */
  0xDDCE,   /* U+5DCE */
  0xDDCF,   /* U+5DCF */
  0xDDD0,   /* U+5DD0 */
  0xDDD1,   /* U+5DD1 */
  0x0000,   /* U+5DD2 */
  0x0000,   /* U+5DD3 */
  0xDDD4,   /* U+5DD4 */
  0xDDD5,   /* U+5DD5 */
  0x0000,   /* U+5DD6 */
  0xDDD7,   /* U+5DD7 */
  0xDDD8,   /* U+5DD8 */
  0xDDD9,   /* U+5DD9 */
  0xDDDA,   /* U+5DDA */
  0x0000,   /* U+5DDB */
  0xDDDC,   /* U+5DDC */
  0x0000,   /* U+5DDD */
  0x0000,   /* U+5DDE */
  0xDDDF,   /* U+5DDF */
  0xDDE0,   /* U+5DE0 */
  0x0000,   /* U+5DE1 */
  0xDDE2,   /* U+5DE2 */
  0x0000,   /* U+5DE3 */
  0xDDE4,   /* U+5DE4 */
  0x0000,   /* U+5DE5 */
  0x0000,   /* U+5DE6 */
  0x0000,   /* U+5DE7 */
  0x0000,   /* U+5DE8 */
  0xDDE9,   /* U+5DE9 */
  0xDDEA,   /* U+5DEA */
  0x0000,   /* U+5DEB */
  0xDDEC,   /* U+5DEC */
  0xDDED,   /* U+5DED */
  0x0000,   /* U+5DEE */
  0xDDEF,   /* U+5DEF */
  0xDDF0,   /* U+5DF0 */
  0x0000,   /* U+5DF1 */
  0x0000,   /* U+5DF2 */
  0x0000,   /* U+5DF3 */
  0x0000,   /* U+5DF4 */
  0x0000,   /* U+5DF5 */
  0xDDF6,   /* U+5DF6 */
  0x0000,   /* U+5DF7 */
  0xDDF8,   /* U+5DF8 */
  0xDDF9,   /* U+5DF9 */
  0xDDFA,   /* U+5DFA */
  0x0000,   /* U+5DFB */
  0xDDFC,   /* U+5DFC */
  0x0000,   /* U+5DFD */
  0x0000,   /* U+5DFE */
  0xDDFF,   /* U+5DFF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+5D00 */
  0x0000,   /* U+5D01 */
  0x0000,   /* U+5D02 */
  0x0000,   /* U+5D03 */
  0x0000,   /* U+5D04 */
  0x0000,   /* U+5D05 */
  0x0000,   /* U+5D06 */
  0x0000,   /* U+5D07 */
  0x0000,   /* U+5D08 */
  0x0000,   /* U+5D09 */
  0x0000,   /* U+5D0A */
  0x0000,   /* U+5D0B */
  0x0000,   /* U+5D0C */
  0x0000,   /* U+5D0D */
  0x0000,   /* U+5D0E */
  0x0000,   /* U+5D0F */
  0x0000,   /* U+5D10 */
  0x0000,   /* U+5D11 */
  0x0000,   /* U+5D12 */
  0x0000,   /* U+5D13 */
  0x0000,   /* U+5D14 */
  0x0000,   /* U+5D15 */
  0x0000,   /* U+5D16 */
  0x0000,   /* U+5D17 */
  0x0000,   /* U+5D18 */
  0x0000,   /* U+5D19 */
  0x0000,   /* U+5D1A */
  0x0000,   /* U+5D1B */
  0x0000,   /* U+5D1C */
  0x0000,   /* U+5D1D */
  0x0000,   /* U+5D1E */
  0x0000,   /* U+5D1F */
  0x0000,   /* U+5D20 */
  0x0000,   /* U+5D21 */
  0x0000,   /* U+5D22 */
  0x0000,   /* U+5D23 */
  0x0000,   /* U+5D24 */
  0x0000,   /* U+5D25 */
  0x0000,   /* U+5D26 */
  0x0000,   /* U+5D27 */
  0x0000,   /* U+5D28 */
  0x0000,   /* U+5D29 */
  0x0000,   /* U+5D2A */
  0x0000,   /* U+5D2B */
  0x0000,   /* U+5D2C */
  0x0000,   /* U+5D2D */
  0x0000,   /* U+5D2E */
  0x0000,   /* U+5D2F */
  0x0000,   /* U+5D30 */
  0x0000,   /* U+5D31 */
  0x0000,   /* U+5D32 */
  0x0000,   /* U+5D33 */
  0x0000,   /* U+5D34 */
  0x0000,   /* U+5D35 */
  0x0000,   /* U+5D36 */
  0x0000,   /* U+5D37 */
  0x0000,   /* U+5D38 */
  0x0000,   /* U+5D39 */
  0x0000,   /* U+5D3A */
  0x0000,   /* U+5D3B */
  0x0000,   /* U+5D3C */
  0x0000,   /* U+5D3D */
  0x0000,   /* U+5D3E */
  0x0000,   /* U+5D3F */
  0x0000,   /* U+5D40 */
  0x0000,   /* U+5D41 */
  0x0000,   /* U+5D42 */
  0x0000,   /* U+5D43 */
  0x0000,   /* U+5D44 */
  0x0000,   /* U+5D45 */
  0x0000,   /* U+5D46 */
  0x0000,   /* U+5D47 */
  0x0000,   /* U+5D48 */
  0x0000,   /* U+5D49 */
  0x0000,   /* U+5D4A */
  0x0000,   /* U+5D4B */
  0x0000,   /* U+5D4C */
  0x0000,   /* U+5D4D */
  0x0000,   /* U+5D4E */
  0x0000,   /* U+5D4F */
  0x0000,   /* U+5D50 */
  0x0000,   /* U+5D51 */
  0x0000,   /* U+5D52 */
  0x0000,   /* U+5D53 */
  0x0000,   /* U+5D54 */
  0x0000,   /* U+5D55 */
  0x0000,   /* U+5D56 */
  0x0000,   /* U+5D57 */
  0x0000,   /* U+5D58 */
  0x0000,   /* U+5D59 */
  0x0000,   /* U+5D5A */
  0x0000,   /* U+5D5B */
  0x0000,   /* U+5D5C */
  0x0000,   /* U+5D5D */
  0x0000,   /* U+5D5E */
  0x0000,   /* U+5D5F */
  0x0000,   /* U+5D60 */
  0x0000,   /* U+5D61 */
  0x0000,   /* U+5D62 */
  0x0000,   /* U+5D63 */
  0x0000,   /* U+5D64 */
  0x0000,   /* U+5D65 */
  0x0000,   /* U+5D66 */
  0x0000,   /* U+5D67 */
  0x0000,   /* U+5D68 */
  0x0000,   /* U+5D69 */
  0x0000,   /* U+5D6A */
  0x0000,   /* U+5D6B */
  0x0000,   /* U+5D6C */
  0x0000,   /* U+5D6D */
  0x0000,   /* U+5D6E */
  0x0000,   /* U+5D6F */
  0x0000,   /* U+5D70 */
  0x0000,   /* U+5D71 */
  0x0000,   /* U+5D72 */
  0x0000,   /* U+5D73 */
  0x0000,   /* U+5D74 */
  0x0000,   /* U+5D75 */
  0x0000,   /* U+5D76 */
  0x0000,   /* U+5D77 */
  0x0000,   /* U+5D78 */
  0x0000,   /* U+5D79 */
  0x0000,   /* U+5D7A */
  0x0000,   /* U+5D7B */
  0x0000,   /* U+5D7C */
  0x0000,   /* U+5D7D */
  0x0000,   /* U+5D7E */
  0x0000,   /* U+5D7F */
  0x0000,   /* U+5D80 */
  0x0000,   /* U+5D81 */
  0x0000,   /* U+5D82 */
  0x0000,   /* U+5D83 */
  0x0000,   /* U+5D84 */
  0x0000,   /* U+5D85 */
  0x0000,   /* U+5D86 */
  0x0000,   /* U+5D87 */
  0x0000,   /* U+5D88 */
  0x0000,   /* U+5D89 */
  0x0000,   /* U+5D8A */
  0x0000,   /* U+5D8B */
  0x0000,   /* U+5D8C */
  0x0000,   /* U+5D8D */
  0x0000,   /* U+5D8E */
  0x0000,   /* U+5D8F */
  0x0000,   /* U+5D90 */
  0x0000,   /* U+5D91 */
  0x0000,   /* U+5D92 */
  0x0000,   /* U+5D93 */
  0x0000,   /* U+5D94 */
  0x0000,   /* U+5D95 */
  0x0000,   /* U+5D96 */
  0x0000,   /* U+5D97 */
  0x0000,   /* U+5D98 */
  0x0000,   /* U+5D99 */
  0x0000,   /* U+5D9A */
  0x0000,   /* U+5D9B */
  0x0000,   /* U+5D9C */
  0x0000,   /* U+5D9D */
  0x0000,   /* U+5D9E */
  0x0000,   /* U+5D9F */
  0x0000,   /* U+5DA0 */
  0x0000,   /* U+5DA1 */
  0x0000,   /* U+5DA2 */
  0x0000,   /* U+5DA3 */
  0x0000,   /* U+5DA4 */
  0x0000,   /* U+5DA5 */
  0x0000,   /* U+5DA6 */
  0x0000,   /* U+5DA7 */
  0x0000,   /* U+5DA8 */
  0x0000,   /* U+5DA9 */
  0x0000,   /* U+5DAA */
  0x0000,   /* U+5DAB */
  0x0000,   /* U+5DAC */
  0x0000,   /* U+5DAD */
  0x0000,   /* U+5DAE */
  0x0000,   /* U+5DAF */
  0x0000,   /* U+5DB0 */
  0x0000,   /* U+5DB1 */
  0x0000,   /* U+5DB2 */
  0x0000,   /* U+5DB3 */
  0x0000,   /* U+5DB4 */
  0x0000,   /* U+5DB5 */
  0x0000,   /* U+5DB6 */
  0x0000,   /* U+5DB7 */
  0x0000,   /* U+5DB8 */
  0x0000,   /* U+5DB9 */
  0x0000,   /* U+5DBA */
  0x0000,   /* U+5DBB */
  0x0000,   /* U+5DBC */
  0x0000,   /* U+5DBD */
  0x0000,   /* U+5DBE */
  0x0000,   /* U+5DBF */
  0x0000,   /* U+5DC0 */
  0x0000,   /* U+5DC1 */
  0x0000,   /* U+5DC2 */
  0x0000,   /* U+5DC3 */
  0x0000,   /* U+5DC4 */
  0x0000,   /* U+5DC5 */
  0x0000,   /* U+5DC6 */
  0x0000,   /* U+5DC7 */
  0x0000,   /* U+5DC8 */
  0x0000,   /* U+5DC9 */
  0x0000,   /* U+5DCA */
  0x0000,   /* U+5DCB */
  0x0000,   /* U+5DCC */
  0x0000,   /* U+5DCD */
  0x0000,   /* U+5DCE */
  0x0000,   /* U+5DCF */
  0x0000,   /* U+5DD0 */
  0x0000,   /* U+5DD1 */
  0x0000,   /* U+5DD2 */
  0x0000,   /* U+5DD3 */
  0x0000,   /* U+5DD4 */
  0x0000,   /* U+5DD5 */
  0x0000,   /* U+5DD6 */
  0x0000,   /* U+5DD7 */
  0x0000,   /* U+5DD8 */
  0x0000,   /* U+5DD9 */
  0x0000,   /* U+5DDA */
  0x0000,   /* U+5DDB */
  0x0000,   /* U+5DDC */
  0x0000,   /* U+5DDD */
  0x0000,   /* U+5DDE */
  0x0000,   /* U+5DDF */
  0x0000,   /* U+5DE0 */
  0x0000,   /* U+5DE1 */
  0x0000,   /* U+5DE2 */
  0x0000,   /* U+5DE3 */
  0x0000,   /* U+5DE4 */
  0x0000,   /* U+5DE5 */
  0x0000,   /* U+5DE6 */
  0x0000,   /* U+5DE7 */
  0x0000,   /* U+5DE8 */
  0x0000,   /* U+5DE9 */
  0x0000,   /* U+5DEA */
  0x0000,   /* U+5DEB */
  0x0000,   /* U+5DEC */
  0x0000,   /* U+5DED */
  0x0000,   /* U+5DEE */
  0x0000,   /* U+5DEF */
  0x0000,   /* U+5DF0 */
  0x0000,   /* U+5DF1 */
  0x0000,   /* U+5DF2 */
  0x0000,   /* U+5DF3 */
  0x0000,   /* U+5DF4 */
  0x0000,   /* U+5DF5 */
  0x0000,   /* U+5DF6 */
  0x0000,   /* U+5DF7 */
  0x0000,   /* U+5DF8 */
  0x0000,   /* U+5DF9 */
  0x0000,   /* U+5DFA */
  0x0000,   /* U+5DFB */
  0x0000,   /* U+5DFC */
  0x0000,   /* U+5DFD */
  0x0000,   /* U+5DFE */
  0x0000,   /* U+5DFF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+5D00 */
  0x0000,   /* U+5D01 */
  0x0000,   /* U+5D02 */
  0x0000,   /* U+5D03 */
  0x0000,   /* U+5D04 */
  0x0000,   /* U+5D05 */
  0x0000,   /* U+5D06 */
  0x0000,   /* U+5D07 */
  0x0000,   /* U+5D08 */
  0x0000,   /* U+5D09 */
  0x0000,   /* U+5D0A */
  0x0000,   /* U+5D0B */
  0x0000,   /* U+5D0C */
  0x0000,   /* U+5D0D */
  0x0000,   /* U+5D0E */
  0x0000,   /* U+5D0F */
  0x0000,   /* U+5D10 */
  0x0000,   /* U+5D11 */
  0x0000,   /* U+5D12 */
  0x0000,   /* U+5D13 */
  0x0000,   /* U+5D14 */
  0x0000,   /* U+5D15 */
  0x0000,   /* U+5D16 */
  0x0000,   /* U+5D17 */
  0x0000,   /* U+5D18 */
  0x0000,   /* U+5D19 */
  0x0000,   /* U+5D1A */
  0x0000,   /* U+5D1B */
  0x0000,   /* U+5D1C */
  0x0000,   /* U+5D1D */
  0x0000,   /* U+5D1E */
  0x0000,   /* U+5D1F */
  0x0000,   /* U+5D20 */
  0x0000,   /* U+5D21 */
  0x0000,   /* U+5D22 */
  0x0000,   /* U+5D23 */
  0x0000,   /* U+5D24 */
  0x0000,   /* U+5D25 */
  0x0000,   /* U+5D26 */
  0x0000,   /* U+5D27 */
  0x0000,   /* U+5D28 */
  0x0000,   /* U+5D29 */
  0x0000,   /* U+5D2A */
  0x0000,   /* U+5D2B */
  0x0000,   /* U+5D2C */
  0x0000,   /* U+5D2D */
  0x0000,   /* U+5D2E */
  0x0000,   /* U+5D2F */
  0x0000,   /* U+5D30 */
  0x0000,   /* U+5D31 */
  0x0000,   /* U+5D32 */
  0x0000,   /* U+5D33 */
  0x0000,   /* U+5D34 */
  0x0000,   /* U+5D35 */
  0x0000,   /* U+5D36 */
  0x0000,   /* U+5D37 */
  0x0000,   /* U+5D38 */
  0x0000,   /* U+5D39 */
  0x0000,   /* U+5D3A */
  0x0000,   /* U+5D3B */
  0x0000,   /* U+5D3C */
  0x0000,   /* U+5D3D */
  0x0000,   /* U+5D3E */
  0x0000,   /* U+5D3F */
  0x0000,   /* U+5D40 */
  0x0000,   /* U+5D41 */
  0x0000,   /* U+5D42 */
  0x0000,   /* U+5D43 */
  0x0000,   /* U+5D44 */
  0x0000,   /* U+5D45 */
  0x0000,   /* U+5D46 */
  0x0000,   /* U+5D47 */
  0x0000,   /* U+5D48 */
  0x0000,   /* U+5D49 */
  0x0000,   /* U+5D4A */
  0x0000,   /* U+5D4B */
  0x0000,   /* U+5D4C */
  0x0000,   /* U+5D4D */
  0x0000,   /* U+5D4E */
  0x0000,   /* U+5D4F */
  0x0000,   /* U+5D50 */
  0x0000,   /* U+5D51 */
  0x0000,   /* U+5D52 */
  0x0000,   /* U+5D53 */
  0x0000,   /* U+5D54 */
  0x0000,   /* U+5D55 */
  0x0000,   /* U+5D56 */
  0x0000,   /* U+5D57 */
  0x0000,   /* U+5D58 */
  0x0000,   /* U+5D59 */
  0x0000,   /* U+5D5A */
  0x0000,   /* U+5D5B */
  0x0000,   /* U+5D5C */
  0x0000,   /* U+5D5D */
  0x0000,   /* U+5D5E */
  0x0000,   /* U+5D5F */
  0x0000,   /* U+5D60 */
  0x0000,   /* U+5D61 */
  0x0000,   /* U+5D62 */
  0x0000,   /* U+5D63 */
  0x0000,   /* U+5D64 */
  0x0000,   /* U+5D65 */
  0x0000,   /* U+5D66 */
  0x0000,   /* U+5D67 */
  0x0000,   /* U+5D68 */
  0x0000,   /* U+5D69 */
  0x0000,   /* U+5D6A */
  0x0000,   /* U+5D6B */
  0x0000,   /* U+5D6C */
  0x0000,   /* U+5D6D */
  0x0000,   /* U+5D6E */
  0x0000,   /* U+5D6F */
  0x0000,   /* U+5D70 */
  0x0000,   /* U+5D71 */
  0x0000,   /* U+5D72 */
  0x0000,   /* U+5D73 */
  0x0000,   /* U+5D74 */
  0x0000,   /* U+5D75 */
  0x0000,   /* U+5D76 */
  0x0000,   /* U+5D77 */
  0x0000,   /* U+5D78 */
  0x0000,   /* U+5D79 */
  0x0000,   /* U+5D7A */
  0x0000,   /* U+5D7B */
  0x0000,   /* U+5D7C */
  0x0000,   /* U+5D7D */
  0x0000,   /* U+5D7E */
  0x0000,   /* U+5D7F */
  0x0000,   /* U+5D80 */
  0x0000,   /* U+5D81 */
  0x0000,   /* U+5D82 */
  0x0000,   /* U+5D83 */
  0x0000,   /* U+5D84 */
  0x0000,   /* U+5D85 */
  0x0000,   /* U+5D86 */
  0x0000,   /* U+5D87 */
  0x0000,   /* U+5D88 */
  0x0000,   /* U+5D89 */
  0x0000,   /* U+5D8A */
  0x0000,   /* U+5D8B */
  0x0000,   /* U+5D8C */
  0x0000,   /* U+5D8D */
  0x0000,   /* U+5D8E */
  0x0000,   /* U+5D8F */
  0x0000,   /* U+5D90 */
  0x0000,   /* U+5D91 */
  0x0000,   /* U+5D92 */
  0x0000,   /* U+5D93 */
  0x0000,   /* U+5D94 */
  0x0000,   /* U+5D95 */
  0x0000,   /* U+5D96 */
  0x0000,   /* U+5D97 */
  0x0000,   /* U+5D98 */
  0x0000,   /* U+5D99 */
  0x0000,   /* U+5D9A */
  0x0000,   /* U+5D9B */
  0x0000,   /* U+5D9C */
  0x0000,   /* U+5D9D */
  0x0000,   /* U+5D9E */
  0x0000,   /* U+5D9F */
  0x0000,   /* U+5DA0 */
  0x0000,   /* U+5DA1 */
  0x0000,   /* U+5DA2 */
  0x0000,   /* U+5DA3 */
  0x0000,   /* U+5DA4 */
  0x0000,   /* U+5DA5 */
  0x0000,   /* U+5DA6 */
  0x0000,   /* U+5DA7 */
  0x0000,   /* U+5DA8 */
  0x0000,   /* U+5DA9 */
  0x0000,   /* U+5DAA */
  0x0000,   /* U+5DAB */
  0x0000,   /* U+5DAC */
  0x0000,   /* U+5DAD */
  0x0000,   /* U+5DAE */
  0x0000,   /* U+5DAF */
  0x0000,   /* U+5DB0 */
  0x0000,   /* U+5DB1 */
  0x0000,   /* U+5DB2 */
  0x0000,   /* U+5DB3 */
  0x0000,   /* U+5DB4 */
  0x0000,   /* U+5DB5 */
  0x0000,   /* U+5DB6 */
  0x0000,   /* U+5DB7 */
  0x0000,   /* U+5DB8 */
  0x0000,   /* U+5DB9 */
  0x0000,   /* U+5DBA */
  0x0000,   /* U+5DBB */
  0x0000,   /* U+5DBC */
  0x0000,   /* U+5DBD */
  0x0000,   /* U+5DBE */
  0x0000,   /* U+5DBF */
  0x0000,   /* U+5DC0 */
  0x0000,   /* U+5DC1 */
  0x0000,   /* U+5DC2 */
  0x0000,   /* U+5DC3 */
  0x0000,   /* U+5DC4 */
  0x0000,   /* U+5DC5 */
  0x0000,   /* U+5DC6 */
  0x0000,   /* U+5DC7 */
  0x0000,   /* U+5DC8 */
  0x0000,   /* U+5DC9 */
  0x0000,   /* U+5DCA */
  0x0000,   /* U+5DCB */
  0x0000,   /* U+5DCC */
  0x0000,   /* U+5DCD */
  0x0000,   /* U+5DCE */
  0x0000,   /* U+5DCF */
  0x0000,   /* U+5DD0 */
  0x0000,   /* U+5DD1 */
  0x0000,   /* U+5DD2 */
  0x0000,   /* U+5DD3 */
  0x0000,   /* U+5DD4 */
  0x0000,   /* U+5DD5 */
  0x0000,   /* U+5DD6 */
  0x0000,   /* U+5DD7 */
  0x0000,   /* U+5DD8 */
  0x0000,   /* U+5DD9 */
  0x0000,   /* U+5DDA */
  0x0000,   /* U+5DDB */
  0x0000,   /* U+5DDC */
  0x0000,   /* U+5DDD */
  0x0000,   /* U+5DDE */
  0x0000,   /* U+5DDF */
  0x0000,   /* U+5DE0 */
  0x0000,   /* U+5DE1 */
  0x0000,   /* U+5DE2 */
  0x0000,   /* U+5DE3 */
  0x0000,   /* U+5DE4 */
  0x0000,   /* U+5DE5 */
  0x0000,   /* U+5DE6 */
  0x0000,   /* U+5DE7 */
  0x0000,   /* U+5DE8 */
  0x0000,   /* U+5DE9 */
  0x0000,   /* U+5DEA */
  0x0000,   /* U+5DEB */
  0x0000,   /* U+5DEC */
  0x0000,   /* U+5DED */
  0x0000,   /* U+5DEE */
  0x0000,   /* U+5DEF */
  0x0000,   /* U+5DF0 */
  0x0000,   /* U+5DF1 */
  0x0000,   /* U+5DF2 */
  0x0000,   /* U+5DF3 */
  0x0000,   /* U+5DF4 */
  0x0000,   /* U+5DF5 */
  0x0000,   /* U+5DF6 */
  0x0000,   /* U+5DF7 */
  0x0000,   /* U+5DF8 */
  0x0000,   /* U+5DF9 */
  0x0000,   /* U+5DFA */
  0x0000,   /* U+5DFB */
  0x0000,   /* U+5DFC */
  0x0000,   /* U+5DFD */
  0x0000,   /* U+5DFE */
  0x0000,   /* U+5DFF */
};

uint16 ja_han_page5E[]= {
  /* Number of CEs for each character. */
  2, 2, 1, 1, 2, 2, 1, 2, 2, 2, 2, 1, 1, 2, 2, 2,
  2, 1, 2, 2, 2, 2, 1, 2, 2, 1, 1, 1, 2, 1, 2, 2,
  2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 1, 2, 1, 2, 1,
  1, 2, 2, 1, 2, 2, 1, 1, 1, 2, 2, 2, 2, 1, 2, 2,
  1, 2, 2, 1, 1, 1, 2, 1, 2, 2, 2, 2, 1, 2, 1, 2,
  2, 2, 2, 2, 1, 1, 2, 1, 2, 2, 2, 2, 2, 2, 2, 1,
  2, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1,
  2, 1, 2, 1, 1, 2, 2, 1, 2, 2, 1, 2, 2, 2, 2, 1,
  2, 2, 2, 2, 2, 1, 1, 1, 2, 2, 1, 2, 1, 2, 2, 2,
  1, 2, 2, 2, 2, 2, 1, 1, 2, 2, 2, 1, 2, 1, 2, 2,
  2, 2, 2, 2, 2, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2,
  2, 1, 1, 1, 2, 2, 2, 2, 1, 1, 1, 2, 2, 2, 2, 1,
  1, 2, 2, 1, 2, 2, 1, 2, 2, 2, 1, 1, 2, 1, 2, 1,
  1, 1, 1, 1, 2, 2, 2, 2, 1, 1, 2, 2, 1, 2, 2, 2,
  1, 1, 2, 1, 1, 2, 1, 1, 1, 2, 1, 1, 1, 2, 1, 1,

  /* Primary weight 1 for each character. */
  0xFB40,   /* U+5E00 */
  0xFB40,   /* U+5E01 */
  0x58E1,   /* U+5E02 */
  0x5E0C,   /* U+5E03 */
  0xFB40,   /* U+5E04 */
  0xFB40,   /* U+5E05 */
  0x5D94,   /* U+5E06 */
  0xFB40,   /* U+5E07 */
  0xFB40,   /* U+5E08 */
  0xFB40,   /* U+5E09 */
  0xFB40,   /* U+5E0A */
  0x62AF,   /* U+5E0B */
  0x5670,   /* U+5E0C */
  0xFB40,   /* U+5E0D */
  0xFB40,   /* U+5E0E */
  0xFB40,   /* U+5E0F */
  0xFB40,   /* U+5E10 */
  0x62B2,   /* U+5E11 */
  0xFB40,   /* U+5E12 */
  0xFB40,   /* U+5E13 */
  0xFB40,   /* U+5E14 */
  0xFB40,   /* U+5E15 */
  0x5BFC,   /* U+5E16 */
  0xFB40,   /* U+5E17 */
  0xFB40,   /* U+5E18 */
  0x62B1,   /* U+5E19 */
  0x62B0,   /* U+5E1A */
  0x62B3,   /* U+5E1B */
  0xFB40,   /* U+5E1C */
  0x5C46,   /* U+5E1D */
  0xFB40,   /* U+5E1E */
  0xFB40,   /* U+5E1F */
  0xFB40,   /* U+5E20 */
  0xFB40,   /* U+5E21 */
  0xFB40,   /* U+5E22 */
  0xFB40,   /* U+5E23 */
  0xFB40,   /* U+5E24 */
  0x5A68,   /* U+5E25 */
  0xFB40,   /* U+5E26 */
  0xFB40,   /* U+5E27 */
  0xFB40,   /* U+5E28 */
  0xFB40,   /* U+5E29 */
  0xFB40,   /* U+5E2A */
  0x58E2,   /* U+5E2B */
  0xFB40,   /* U+5E2C */
  0x5AAD,   /* U+5E2D */
  0xFB40,   /* U+5E2E */
  0x5B72,   /* U+5E2F */
  0x567B,   /* U+5E30 */
  0xFB40,   /* U+5E31 */
  0xFB40,   /* U+5E32 */
  0x5BFD,   /* U+5E33 */
  0xFB40,   /* U+5E34 */
  0xFB40,   /* U+5E35 */
  0x62B4,   /* U+5E36 */
  0x62B5,   /* U+5E37 */
  0x5A16,   /* U+5E38 */
  0xFB40,   /* U+5E39 */
  0xFB40,   /* U+5E3A */
  0xFB40,   /* U+5E3B */
  0xFB40,   /* U+5E3C */
  0x5EA6,   /* U+5E3D */
  0xFB40,   /* U+5E3E */
  0xFB40,   /* U+5E3F */
  0x62B8,   /* U+5E40 */
  0xFB40,   /* U+5E41 */
  0xFB40,   /* U+5E42 */
  0x62B7,   /* U+5E43 */
  0x62B6,   /* U+5E44 */
  0x5E2E,   /* U+5E45 */
  0xFB40,   /* U+5E46 */
  0x62BF,   /* U+5E47 */
  0xFB40,   /* U+5E48 */
  0xFB40,   /* U+5E49 */
  0xFB40,   /* U+5E4A */
  0xFB40,   /* U+5E4B */
  0x5EC7,   /* U+5E4C */
  0xFB40,   /* U+5E4D */
  0x62B9,   /* U+5E4E */
  0xFB40,   /* U+5E4F */
  0xFB40,   /* U+5E50 */
  0xFB40,   /* U+5E51 */
  0xFB40,   /* U+5E52 */
  0xFB40,   /* U+5E53 */
  0x62BB,   /* U+5E54 */
  0x5ED8,   /* U+5E55 */
  0xFB40,   /* U+5E56 */
  0x62BA,   /* U+5E57 */
  0xFB40,   /* U+5E58 */
  0xFB40,   /* U+5E59 */
  0xFB40,   /* U+5E5A */
  0xFB40,   /* U+5E5B */
  0xFB40,   /* U+5E5C */
  0xFB40,   /* U+5E5D */
  0xFB40,   /* U+5E5E */
  0x62BC,   /* U+5E5F */
  0xFB40,   /* U+5E60 */
  0x5D7B,   /* U+5E61 */
  0x62BD,   /* U+5E62 */
  0x5E4D,   /* U+5E63 */
  0x62BE,   /* U+5E64 */
  0xFB40,   /* U+5E65 */
  0xFB40,   /* U+5E66 */
  0xFB40,   /* U+5E67 */
  0xFB40,   /* U+5E68 */
  0xFB40,   /* U+5E69 */
  0xFB40,   /* U+5E6A */
  0xFB40,   /* U+5E6B */
  0xFB40,   /* U+5E6C */
  0xFB40,   /* U+5E6D */
  0xFB40,   /* U+5E6E */
  0xFB40,   /* U+5E6F */
  0xFB40,   /* U+5E70 */
  0xFB40,   /* U+5E71 */
  0x562E,   /* U+5E72 */
  0x5E4E,   /* U+5E73 */
  0x5D24,   /* U+5E74 */
  0x62C0,   /* U+5E75 */
  0x62C1,   /* U+5E76 */
  0xFB40,   /* U+5E77 */
  0x57FD,   /* U+5E78 */
  0x562F,   /* U+5E79 */
  0x62C2,   /* U+5E7A */
  0x57AB,   /* U+5E7B */
  0x5F6D,   /* U+5E7C */
  0x5F52,   /* U+5E7D */
  0x5671,   /* U+5E7E */
  0x62C4,   /* U+5E7F */
  0xFB40,   /* U+5E80 */
  0x5BFE,   /* U+5E81 */
  0xFB40,   /* U+5E82 */
  0x57FE,   /* U+5E83 */
  0x59D8,   /* U+5E84 */
  0xFB40,   /* U+5E85 */
  0xFB40,   /* U+5E86 */
  0x5DB2,   /* U+5E87 */
  0xFB40,   /* U+5E88 */
  0xFB40,   /* U+5E89 */
  0x59D9,   /* U+5E8A */
  0xFB40,   /* U+5E8B */
  0xFB40,   /* U+5E8C */
  0xFB40,   /* U+5E8D */
  0xFB40,   /* U+5E8E */
  0x59C1,   /* U+5E8F */
  0xFB40,   /* U+5E90 */
  0xFB40,   /* U+5E91 */
  0xFB40,   /* U+5E92 */
  0xFB40,   /* U+5E93 */
  0xFB40,   /* U+5E94 */
  0x5C47,   /* U+5E95 */
  0x5E88,   /* U+5E96 */
  0x5C72,   /* U+5E97 */
  0xFB40,   /* U+5E98 */
  0xFB40,   /* U+5E99 */
  0x57FF,   /* U+5E9A */
  0xFB40,   /* U+5E9B */
  0x5E0D,   /* U+5E9C */
  0xFB40,   /* U+5E9D */
  0xFB40,   /* U+5E9E */
  0xFB40,   /* U+5E9F */
  0x62C5,   /* U+5EA0 */
  0xFB40,   /* U+5EA1 */
  0xFB40,   /* U+5EA2 */
  0xFB40,   /* U+5EA3 */
  0xFB40,   /* U+5EA4 */
  0xFB40,   /* U+5EA5 */
  0x5C92,   /* U+5EA6 */
  0x5871,   /* U+5EA7 */
  0xFB40,   /* U+5EA8 */
  0xFB40,   /* U+5EA9 */
  0xFB40,   /* U+5EAA */
  0x57BE,   /* U+5EAB */
  0xFB40,   /* U+5EAC */
  0x5C48,   /* U+5EAD */
  0xFB40,   /* U+5EAE */
  0xFB40,   /* U+5EAF */
  0xFB40,   /* U+5EB0 */
  0xFB40,   /* U+5EB1 */
  0xFB40,   /* U+5EB2 */
  0xFB40,   /* U+5EB3 */
  0xFB40,   /* U+5EB4 */
  0x54C6,   /* U+5EB5 */
  0x59B7,   /* U+5EB6 */
  0x5800,   /* U+5EB7 */
  0x5F70,   /* U+5EB8 */
  0xFB40,   /* U+5EB9 */
  0xFB40,   /* U+5EBA */
  0xFB40,   /* U+5EBB */
  0xFB40,   /* U+5EBC */
  0xFB40,   /* U+5EBD */
  0xFB40,   /* U+5EBE */
  0xFB40,   /* U+5EBF */
  0xFB40,   /* U+5EC0 */
  0x62C6,   /* U+5EC1 */
  0x62C7,   /* U+5EC2 */
  0x5D46,   /* U+5EC3 */
  0xFB40,   /* U+5EC4 */
  0xFB40,   /* U+5EC5 */
  0xFB40,   /* U+5EC6 */
  0xFB40,   /* U+5EC7 */
  0x62C8,   /* U+5EC8 */
  0x5FFE,   /* U+5EC9 */
  0x6012,   /* U+5ECA */
  0xFB40,   /* U+5ECB */
  0xFB40,   /* U+5ECC */
  0xFB40,   /* U+5ECD */
  0xFB40,   /* U+5ECE */
  0x62CA,   /* U+5ECF */
  0x62C9,   /* U+5ED0 */
  0xFB40,   /* U+5ED1 */
  0xFB40,   /* U+5ED2 */
  0x55E4,   /* U+5ED3 */
  0xFB40,   /* U+5ED4 */
  0xFB40,   /* U+5ED5 */
  0x62CB,   /* U+5ED6 */
  0xFB40,   /* U+5ED7 */
  0xFB40,   /* U+5ED8 */
  0xFB40,   /* U+5ED9 */
  0x62CE,   /* U+5EDA */
  0x62CF,   /* U+5EDB */
  0xFB40,   /* U+5EDC */
  0x62CD,   /* U+5EDD */
  0xFB40,   /* U+5EDE */
  0x5DF1,   /* U+5EDF */
  0x59DA,   /* U+5EE0 */
  0x62D1,   /* U+5EE1 */
  0x62D0,   /* U+5EE2 */
  0x62CC,   /* U+5EE3 */
  0xFB40,   /* U+5EE4 */
  0xFB40,   /* U+5EE5 */
  0xFB40,   /* U+5EE6 */
  0xFB40,   /* U+5EE7 */
  0x62D2,   /* U+5EE8 */
  0x62D3,   /* U+5EE9 */
  0xFB40,   /* U+5EEA */
  0xFB40,   /* U+5EEB */
  0x62D4,   /* U+5EEC */
  0xFB40,   /* U+5EED */
  0xFB40,   /* U+5EEE */
  0xFB40,   /* U+5EEF */
  0x62D7,   /* U+5EF0 */
  0x62D5,   /* U+5EF1 */
  0xFB40,   /* U+5EF2 */
  0x62D6,   /* U+5EF3 */
  0x62D8,   /* U+5EF4 */
  0xFB40,   /* U+5EF5 */
  0x5545,   /* U+5EF6 */
  0x5C49,   /* U+5EF7 */
  0x62D9,   /* U+5EF8 */
  0xFB40,   /* U+5EF9 */
  0x578F,   /* U+5EFA */
  0x55B5,   /* U+5EFB */
  0x5D2B,   /* U+5EFC */
  0xFB40,   /* U+5EFD */
  0x62DA,   /* U+5EFE */
  0x5D12,   /* U+5EFF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+5E00 */
  0x0020,   /* U+5E01 */
  0x0020,   /* U+5E02 */
  0x0020,   /* U+5E03 */
  0x0020,   /* U+5E04 */
  0x0020,   /* U+5E05 */
  0x0020,   /* U+5E06 */
  0x0020,   /* U+5E07 */
  0x0020,   /* U+5E08 */
  0x0020,   /* U+5E09 */
  0x0020,   /* U+5E0A */
  0x0020,   /* U+5E0B */
  0x0020,   /* U+5E0C */
  0x0020,   /* U+5E0D */
  0x0020,   /* U+5E0E */
  0x0020,   /* U+5E0F */
  0x0020,   /* U+5E10 */
  0x0020,   /* U+5E11 */
  0x0020,   /* U+5E12 */
  0x0020,   /* U+5E13 */
  0x0020,   /* U+5E14 */
  0x0020,   /* U+5E15 */
  0x0020,   /* U+5E16 */
  0x0020,   /* U+5E17 */
  0x0020,   /* U+5E18 */
  0x0020,   /* U+5E19 */
  0x0020,   /* U+5E1A */
  0x0020,   /* U+5E1B */
  0x0020,   /* U+5E1C */
  0x0020,   /* U+5E1D */
  0x0020,   /* U+5E1E */
  0x0020,   /* U+5E1F */
  0x0020,   /* U+5E20 */
  0x0020,   /* U+5E21 */
  0x0020,   /* U+5E22 */
  0x0020,   /* U+5E23 */
  0x0020,   /* U+5E24 */
  0x0020,   /* U+5E25 */
  0x0020,   /* U+5E26 */
  0x0020,   /* U+5E27 */
  0x0020,   /* U+5E28 */
  0x0020,   /* U+5E29 */
  0x0020,   /* U+5E2A */
  0x0020,   /* U+5E2B */
  0x0020,   /* U+5E2C */
  0x0020,   /* U+5E2D */
  0x0020,   /* U+5E2E */
  0x0020,   /* U+5E2F */
  0x0020,   /* U+5E30 */
  0x0020,   /* U+5E31 */
  0x0020,   /* U+5E32 */
  0x0020,   /* U+5E33 */
  0x0020,   /* U+5E34 */
  0x0020,   /* U+5E35 */
  0x0020,   /* U+5E36 */
  0x0020,   /* U+5E37 */
  0x0020,   /* U+5E38 */
  0x0020,   /* U+5E39 */
  0x0020,   /* U+5E3A */
  0x0020,   /* U+5E3B */
  0x0020,   /* U+5E3C */
  0x0020,   /* U+5E3D */
  0x0020,   /* U+5E3E */
  0x0020,   /* U+5E3F */
  0x0020,   /* U+5E40 */
  0x0020,   /* U+5E41 */
  0x0020,   /* U+5E42 */
  0x0020,   /* U+5E43 */
  0x0020,   /* U+5E44 */
  0x0020,   /* U+5E45 */
  0x0020,   /* U+5E46 */
  0x0020,   /* U+5E47 */
  0x0020,   /* U+5E48 */
  0x0020,   /* U+5E49 */
  0x0020,   /* U+5E4A */
  0x0020,   /* U+5E4B */
  0x0020,   /* U+5E4C */
  0x0020,   /* U+5E4D */
  0x0020,   /* U+5E4E */
  0x0020,   /* U+5E4F */
  0x0020,   /* U+5E50 */
  0x0020,   /* U+5E51 */
  0x0020,   /* U+5E52 */
  0x0020,   /* U+5E53 */
  0x0020,   /* U+5E54 */
  0x0020,   /* U+5E55 */
  0x0020,   /* U+5E56 */
  0x0020,   /* U+5E57 */
  0x0020,   /* U+5E58 */
  0x0020,   /* U+5E59 */
  0x0020,   /* U+5E5A */
  0x0020,   /* U+5E5B */
  0x0020,   /* U+5E5C */
  0x0020,   /* U+5E5D */
  0x0020,   /* U+5E5E */
  0x0020,   /* U+5E5F */
  0x0020,   /* U+5E60 */
  0x0020,   /* U+5E61 */
  0x0020,   /* U+5E62 */
  0x0020,   /* U+5E63 */
  0x0020,   /* U+5E64 */
  0x0020,   /* U+5E65 */
  0x0020,   /* U+5E66 */
  0x0020,   /* U+5E67 */
  0x0020,   /* U+5E68 */
  0x0020,   /* U+5E69 */
  0x0020,   /* U+5E6A */
  0x0020,   /* U+5E6B */
  0x0020,   /* U+5E6C */
  0x0020,   /* U+5E6D */
  0x0020,   /* U+5E6E */
  0x0020,   /* U+5E6F */
  0x0020,   /* U+5E70 */
  0x0020,   /* U+5E71 */
  0x0020,   /* U+5E72 */
  0x0020,   /* U+5E73 */
  0x0020,   /* U+5E74 */
  0x0020,   /* U+5E75 */
  0x0020,   /* U+5E76 */
  0x0020,   /* U+5E77 */
  0x0020,   /* U+5E78 */
  0x0020,   /* U+5E79 */
  0x0020,   /* U+5E7A */
  0x0020,   /* U+5E7B */
  0x0020,   /* U+5E7C */
  0x0020,   /* U+5E7D */
  0x0020,   /* U+5E7E */
  0x0020,   /* U+5E7F */
  0x0020,   /* U+5E80 */
  0x0020,   /* U+5E81 */
  0x0020,   /* U+5E82 */
  0x0020,   /* U+5E83 */
  0x0020,   /* U+5E84 */
  0x0020,   /* U+5E85 */
  0x0020,   /* U+5E86 */
  0x0020,   /* U+5E87 */
  0x0020,   /* U+5E88 */
  0x0020,   /* U+5E89 */
  0x0020,   /* U+5E8A */
  0x0020,   /* U+5E8B */
  0x0020,   /* U+5E8C */
  0x0020,   /* U+5E8D */
  0x0020,   /* U+5E8E */
  0x0020,   /* U+5E8F */
  0x0020,   /* U+5E90 */
  0x0020,   /* U+5E91 */
  0x0020,   /* U+5E92 */
  0x0020,   /* U+5E93 */
  0x0020,   /* U+5E94 */
  0x0020,   /* U+5E95 */
  0x0020,   /* U+5E96 */
  0x0020,   /* U+5E97 */
  0x0020,   /* U+5E98 */
  0x0020,   /* U+5E99 */
  0x0020,   /* U+5E9A */
  0x0020,   /* U+5E9B */
  0x0020,   /* U+5E9C */
  0x0020,   /* U+5E9D */
  0x0020,   /* U+5E9E */
  0x0020,   /* U+5E9F */
  0x0020,   /* U+5EA0 */
  0x0020,   /* U+5EA1 */
  0x0020,   /* U+5EA2 */
  0x0020,   /* U+5EA3 */
  0x0020,   /* U+5EA4 */
  0x0020,   /* U+5EA5 */
  0x0020,   /* U+5EA6 */
  0x0020,   /* U+5EA7 */
  0x0020,   /* U+5EA8 */
  0x0020,   /* U+5EA9 */
  0x0020,   /* U+5EAA */
  0x0020,   /* U+5EAB */
  0x0020,   /* U+5EAC */
  0x0020,   /* U+5EAD */
  0x0020,   /* U+5EAE */
  0x0020,   /* U+5EAF */
  0x0020,   /* U+5EB0 */
  0x0020,   /* U+5EB1 */
  0x0020,   /* U+5EB2 */
  0x0020,   /* U+5EB3 */
  0x0020,   /* U+5EB4 */
  0x0020,   /* U+5EB5 */
  0x0020,   /* U+5EB6 */
  0x0020,   /* U+5EB7 */
  0x0020,   /* U+5EB8 */
  0x0020,   /* U+5EB9 */
  0x0020,   /* U+5EBA */
  0x0020,   /* U+5EBB */
  0x0020,   /* U+5EBC */
  0x0020,   /* U+5EBD */
  0x0020,   /* U+5EBE */
  0x0020,   /* U+5EBF */
  0x0020,   /* U+5EC0 */
  0x0020,   /* U+5EC1 */
  0x0020,   /* U+5EC2 */
  0x0020,   /* U+5EC3 */
  0x0020,   /* U+5EC4 */
  0x0020,   /* U+5EC5 */
  0x0020,   /* U+5EC6 */
  0x0020,   /* U+5EC7 */
  0x0020,   /* U+5EC8 */
  0x0020,   /* U+5EC9 */
  0x0020,   /* U+5ECA */
  0x0020,   /* U+5ECB */
  0x0020,   /* U+5ECC */
  0x0020,   /* U+5ECD */
  0x0020,   /* U+5ECE */
  0x0020,   /* U+5ECF */
  0x0020,   /* U+5ED0 */
  0x0020,   /* U+5ED1 */
  0x0020,   /* U+5ED2 */
  0x0020,   /* U+5ED3 */
  0x0020,   /* U+5ED4 */
  0x0020,   /* U+5ED5 */
  0x0020,   /* U+5ED6 */
  0x0020,   /* U+5ED7 */
  0x0020,   /* U+5ED8 */
  0x0020,   /* U+5ED9 */
  0x0020,   /* U+5EDA */
  0x0020,   /* U+5EDB */
  0x0020,   /* U+5EDC */
  0x0020,   /* U+5EDD */
  0x0020,   /* U+5EDE */
  0x0020,   /* U+5EDF */
  0x0020,   /* U+5EE0 */
  0x0020,   /* U+5EE1 */
  0x0020,   /* U+5EE2 */
  0x0020,   /* U+5EE3 */
  0x0020,   /* U+5EE4 */
  0x0020,   /* U+5EE5 */
  0x0020,   /* U+5EE6 */
  0x0020,   /* U+5EE7 */
  0x0020,   /* U+5EE8 */
  0x0020,   /* U+5EE9 */
  0x0020,   /* U+5EEA */
  0x0020,   /* U+5EEB */
  0x0020,   /* U+5EEC */
  0x0020,   /* U+5EED */
  0x0020,   /* U+5EEE */
  0x0020,   /* U+5EEF */
  0x0020,   /* U+5EF0 */
  0x0020,   /* U+5EF1 */
  0x0020,   /* U+5EF2 */
  0x0020,   /* U+5EF3 */
  0x0020,   /* U+5EF4 */
  0x0020,   /* U+5EF5 */
  0x0020,   /* U+5EF6 */
  0x0020,   /* U+5EF7 */
  0x0020,   /* U+5EF8 */
  0x0020,   /* U+5EF9 */
  0x0020,   /* U+5EFA */
  0x0020,   /* U+5EFB */
  0x0020,   /* U+5EFC */
  0x0020,   /* U+5EFD */
  0x0020,   /* U+5EFE */
  0x0020,   /* U+5EFF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+5E00 */
  0x0002,   /* U+5E01 */
  0x0002,   /* U+5E02 */
  0x0002,   /* U+5E03 */
  0x0002,   /* U+5E04 */
  0x0002,   /* U+5E05 */
  0x0002,   /* U+5E06 */
  0x0002,   /* U+5E07 */
  0x0002,   /* U+5E08 */
  0x0002,   /* U+5E09 */
  0x0002,   /* U+5E0A */
  0x0002,   /* U+5E0B */
  0x0002,   /* U+5E0C */
  0x0002,   /* U+5E0D */
  0x0002,   /* U+5E0E */
  0x0002,   /* U+5E0F */
  0x0002,   /* U+5E10 */
  0x0002,   /* U+5E11 */
  0x0002,   /* U+5E12 */
  0x0002,   /* U+5E13 */
  0x0002,   /* U+5E14 */
  0x0002,   /* U+5E15 */
  0x0002,   /* U+5E16 */
  0x0002,   /* U+5E17 */
  0x0002,   /* U+5E18 */
  0x0002,   /* U+5E19 */
  0x0002,   /* U+5E1A */
  0x0002,   /* U+5E1B */
  0x0002,   /* U+5E1C */
  0x0002,   /* U+5E1D */
  0x0002,   /* U+5E1E */
  0x0002,   /* U+5E1F */
  0x0002,   /* U+5E20 */
  0x0002,   /* U+5E21 */
  0x0002,   /* U+5E22 */
  0x0002,   /* U+5E23 */
  0x0002,   /* U+5E24 */
  0x0002,   /* U+5E25 */
  0x0002,   /* U+5E26 */
  0x0002,   /* U+5E27 */
  0x0002,   /* U+5E28 */
  0x0002,   /* U+5E29 */
  0x0002,   /* U+5E2A */
  0x0002,   /* U+5E2B */
  0x0002,   /* U+5E2C */
  0x0002,   /* U+5E2D */
  0x0002,   /* U+5E2E */
  0x0002,   /* U+5E2F */
  0x0002,   /* U+5E30 */
  0x0002,   /* U+5E31 */
  0x0002,   /* U+5E32 */
  0x0002,   /* U+5E33 */
  0x0002,   /* U+5E34 */
  0x0002,   /* U+5E35 */
  0x0002,   /* U+5E36 */
  0x0002,   /* U+5E37 */
  0x0002,   /* U+5E38 */
  0x0002,   /* U+5E39 */
  0x0002,   /* U+5E3A */
  0x0002,   /* U+5E3B */
  0x0002,   /* U+5E3C */
  0x0002,   /* U+5E3D */
  0x0002,   /* U+5E3E */
  0x0002,   /* U+5E3F */
  0x0002,   /* U+5E40 */
  0x0002,   /* U+5E41 */
  0x0002,   /* U+5E42 */
  0x0002,   /* U+5E43 */
  0x0002,   /* U+5E44 */
  0x0002,   /* U+5E45 */
  0x0002,   /* U+5E46 */
  0x0002,   /* U+5E47 */
  0x0002,   /* U+5E48 */
  0x0002,   /* U+5E49 */
  0x0002,   /* U+5E4A */
  0x0002,   /* U+5E4B */
  0x0002,   /* U+5E4C */
  0x0002,   /* U+5E4D */
  0x0002,   /* U+5E4E */
  0x0002,   /* U+5E4F */
  0x0002,   /* U+5E50 */
  0x0002,   /* U+5E51 */
  0x0002,   /* U+5E52 */
  0x0002,   /* U+5E53 */
  0x0002,   /* U+5E54 */
  0x0002,   /* U+5E55 */
  0x0002,   /* U+5E56 */
  0x0002,   /* U+5E57 */
  0x0002,   /* U+5E58 */
  0x0002,   /* U+5E59 */
  0x0002,   /* U+5E5A */
  0x0002,   /* U+5E5B */
  0x0002,   /* U+5E5C */
  0x0002,   /* U+5E5D */
  0x0002,   /* U+5E5E */
  0x0002,   /* U+5E5F */
  0x0002,   /* U+5E60 */
  0x0002,   /* U+5E61 */
  0x0002,   /* U+5E62 */
  0x0002,   /* U+5E63 */
  0x0002,   /* U+5E64 */
  0x0002,   /* U+5E65 */
  0x0002,   /* U+5E66 */
  0x0002,   /* U+5E67 */
  0x0002,   /* U+5E68 */
  0x0002,   /* U+5E69 */
  0x0002,   /* U+5E6A */
  0x0002,   /* U+5E6B */
  0x0002,   /* U+5E6C */
  0x0002,   /* U+5E6D */
  0x0002,   /* U+5E6E */
  0x0002,   /* U+5E6F */
  0x0002,   /* U+5E70 */
  0x0002,   /* U+5E71 */
  0x0002,   /* U+5E72 */
  0x0002,   /* U+5E73 */
  0x0002,   /* U+5E74 */
  0x0002,   /* U+5E75 */
  0x0002,   /* U+5E76 */
  0x0002,   /* U+5E77 */
  0x0002,   /* U+5E78 */
  0x0002,   /* U+5E79 */
  0x0002,   /* U+5E7A */
  0x0002,   /* U+5E7B */
  0x0002,   /* U+5E7C */
  0x0002,   /* U+5E7D */
  0x0002,   /* U+5E7E */
  0x0002,   /* U+5E7F */
  0x0002,   /* U+5E80 */
  0x0002,   /* U+5E81 */
  0x0002,   /* U+5E82 */
  0x0002,   /* U+5E83 */
  0x0002,   /* U+5E84 */
  0x0002,   /* U+5E85 */
  0x0002,   /* U+5E86 */
  0x0002,   /* U+5E87 */
  0x0002,   /* U+5E88 */
  0x0002,   /* U+5E89 */
  0x0002,   /* U+5E8A */
  0x0002,   /* U+5E8B */
  0x0002,   /* U+5E8C */
  0x0002,   /* U+5E8D */
  0x0002,   /* U+5E8E */
  0x0002,   /* U+5E8F */
  0x0002,   /* U+5E90 */
  0x0002,   /* U+5E91 */
  0x0002,   /* U+5E92 */
  0x0002,   /* U+5E93 */
  0x0002,   /* U+5E94 */
  0x0002,   /* U+5E95 */
  0x0002,   /* U+5E96 */
  0x0002,   /* U+5E97 */
  0x0002,   /* U+5E98 */
  0x0002,   /* U+5E99 */
  0x0002,   /* U+5E9A */
  0x0002,   /* U+5E9B */
  0x0002,   /* U+5E9C */
  0x0002,   /* U+5E9D */
  0x0002,   /* U+5E9E */
  0x0002,   /* U+5E9F */
  0x0002,   /* U+5EA0 */
  0x0002,   /* U+5EA1 */
  0x0002,   /* U+5EA2 */
  0x0002,   /* U+5EA3 */
  0x0002,   /* U+5EA4 */
  0x0002,   /* U+5EA5 */
  0x0002,   /* U+5EA6 */
  0x0002,   /* U+5EA7 */
  0x0002,   /* U+5EA8 */
  0x0002,   /* U+5EA9 */
  0x0002,   /* U+5EAA */
  0x0002,   /* U+5EAB */
  0x0002,   /* U+5EAC */
  0x0002,   /* U+5EAD */
  0x0002,   /* U+5EAE */
  0x0002,   /* U+5EAF */
  0x0002,   /* U+5EB0 */
  0x0002,   /* U+5EB1 */
  0x0002,   /* U+5EB2 */
  0x0002,   /* U+5EB3 */
  0x0002,   /* U+5EB4 */
  0x0002,   /* U+5EB5 */
  0x0002,   /* U+5EB6 */
  0x0002,   /* U+5EB7 */
  0x0002,   /* U+5EB8 */
  0x0002,   /* U+5EB9 */
  0x0002,   /* U+5EBA */
  0x0002,   /* U+5EBB */
  0x0002,   /* U+5EBC */
  0x0002,   /* U+5EBD */
  0x0002,   /* U+5EBE */
  0x0002,   /* U+5EBF */
  0x0002,   /* U+5EC0 */
  0x0002,   /* U+5EC1 */
  0x0002,   /* U+5EC2 */
  0x0002,   /* U+5EC3 */
  0x0002,   /* U+5EC4 */
  0x0002,   /* U+5EC5 */
  0x0002,   /* U+5EC6 */
  0x0002,   /* U+5EC7 */
  0x0002,   /* U+5EC8 */
  0x0002,   /* U+5EC9 */
  0x0002,   /* U+5ECA */
  0x0002,   /* U+5ECB */
  0x0002,   /* U+5ECC */
  0x0002,   /* U+5ECD */
  0x0002,   /* U+5ECE */
  0x0002,   /* U+5ECF */
  0x0002,   /* U+5ED0 */
  0x0002,   /* U+5ED1 */
  0x0002,   /* U+5ED2 */
  0x0002,   /* U+5ED3 */
  0x0002,   /* U+5ED4 */
  0x0002,   /* U+5ED5 */
  0x0002,   /* U+5ED6 */
  0x0002,   /* U+5ED7 */
  0x0002,   /* U+5ED8 */
  0x0002,   /* U+5ED9 */
  0x0002,   /* U+5EDA */
  0x0002,   /* U+5EDB */
  0x0002,   /* U+5EDC */
  0x0002,   /* U+5EDD */
  0x0002,   /* U+5EDE */
  0x0002,   /* U+5EDF */
  0x0002,   /* U+5EE0 */
  0x0002,   /* U+5EE1 */
  0x0002,   /* U+5EE2 */
  0x0002,   /* U+5EE3 */
  0x0002,   /* U+5EE4 */
  0x0002,   /* U+5EE5 */
  0x0002,   /* U+5EE6 */
  0x0002,   /* U+5EE7 */
  0x0002,   /* U+5EE8 */
  0x0002,   /* U+5EE9 */
  0x0002,   /* U+5EEA */
  0x0002,   /* U+5EEB */
  0x0002,   /* U+5EEC */
  0x0002,   /* U+5EED */
  0x0002,   /* U+5EEE */
  0x0002,   /* U+5EEF */
  0x0002,   /* U+5EF0 */
  0x0002,   /* U+5EF1 */
  0x0002,   /* U+5EF2 */
  0x0002,   /* U+5EF3 */
  0x0002,   /* U+5EF4 */
  0x0002,   /* U+5EF5 */
  0x0002,   /* U+5EF6 */
  0x0002,   /* U+5EF7 */
  0x0002,   /* U+5EF8 */
  0x0002,   /* U+5EF9 */
  0x0002,   /* U+5EFA */
  0x0002,   /* U+5EFB */
  0x0002,   /* U+5EFC */
  0x0002,   /* U+5EFD */
  0x0002,   /* U+5EFE */
  0x0002,   /* U+5EFF */

  /* Primary weight 2 for each character. */
  0xDE00,   /* U+5E00 */
  0xDE01,   /* U+5E01 */
  0x0000,   /* U+5E02 */
  0x0000,   /* U+5E03 */
  0xDE04,   /* U+5E04 */
  0xDE05,   /* U+5E05 */
  0x0000,   /* U+5E06 */
  0xDE07,   /* U+5E07 */
  0xDE08,   /* U+5E08 */
  0xDE09,   /* U+5E09 */
  0xDE0A,   /* U+5E0A */
  0x0000,   /* U+5E0B */
  0x0000,   /* U+5E0C */
  0xDE0D,   /* U+5E0D */
  0xDE0E,   /* U+5E0E */
  0xDE0F,   /* U+5E0F */
  0xDE10,   /* U+5E10 */
  0x0000,   /* U+5E11 */
  0xDE12,   /* U+5E12 */
  0xDE13,   /* U+5E13 */
  0xDE14,   /* U+5E14 */
  0xDE15,   /* U+5E15 */
  0x0000,   /* U+5E16 */
  0xDE17,   /* U+5E17 */
  0xDE18,   /* U+5E18 */
  0x0000,   /* U+5E19 */
  0x0000,   /* U+5E1A */
  0x0000,   /* U+5E1B */
  0xDE1C,   /* U+5E1C */
  0x0000,   /* U+5E1D */
  0xDE1E,   /* U+5E1E */
  0xDE1F,   /* U+5E1F */
  0xDE20,   /* U+5E20 */
  0xDE21,   /* U+5E21 */
  0xDE22,   /* U+5E22 */
  0xDE23,   /* U+5E23 */
  0xDE24,   /* U+5E24 */
  0x0000,   /* U+5E25 */
  0xDE26,   /* U+5E26 */
  0xDE27,   /* U+5E27 */
  0xDE28,   /* U+5E28 */
  0xDE29,   /* U+5E29 */
  0xDE2A,   /* U+5E2A */
  0x0000,   /* U+5E2B */
  0xDE2C,   /* U+5E2C */
  0x0000,   /* U+5E2D */
  0xDE2E,   /* U+5E2E */
  0x0000,   /* U+5E2F */
  0x0000,   /* U+5E30 */
  0xDE31,   /* U+5E31 */
  0xDE32,   /* U+5E32 */
  0x0000,   /* U+5E33 */
  0xDE34,   /* U+5E34 */
  0xDE35,   /* U+5E35 */
  0x0000,   /* U+5E36 */
  0x0000,   /* U+5E37 */
  0x0000,   /* U+5E38 */
  0xDE39,   /* U+5E39 */
  0xDE3A,   /* U+5E3A */
  0xDE3B,   /* U+5E3B */
  0xDE3C,   /* U+5E3C */
  0x0000,   /* U+5E3D */
  0xDE3E,   /* U+5E3E */
  0xDE3F,   /* U+5E3F */
  0x0000,   /* U+5E40 */
  0xDE41,   /* U+5E41 */
  0xDE42,   /* U+5E42 */
  0x0000,   /* U+5E43 */
  0x0000,   /* U+5E44 */
  0x0000,   /* U+5E45 */
  0xDE46,   /* U+5E46 */
  0x0000,   /* U+5E47 */
  0xDE48,   /* U+5E48 */
  0xDE49,   /* U+5E49 */
  0xDE4A,   /* U+5E4A */
  0xDE4B,   /* U+5E4B */
  0x0000,   /* U+5E4C */
  0xDE4D,   /* U+5E4D */
  0x0000,   /* U+5E4E */
  0xDE4F,   /* U+5E4F */
  0xDE50,   /* U+5E50 */
  0xDE51,   /* U+5E51 */
  0xDE52,   /* U+5E52 */
  0xDE53,   /* U+5E53 */
  0x0000,   /* U+5E54 */
  0x0000,   /* U+5E55 */
  0xDE56,   /* U+5E56 */
  0x0000,   /* U+5E57 */
  0xDE58,   /* U+5E58 */
  0xDE59,   /* U+5E59 */
  0xDE5A,   /* U+5E5A */
  0xDE5B,   /* U+5E5B */
  0xDE5C,   /* U+5E5C */
  0xDE5D,   /* U+5E5D */
  0xDE5E,   /* U+5E5E */
  0x0000,   /* U+5E5F */
  0xDE60,   /* U+5E60 */
  0x0000,   /* U+5E61 */
  0x0000,   /* U+5E62 */
  0x0000,   /* U+5E63 */
  0x0000,   /* U+5E64 */
  0xDE65,   /* U+5E65 */
  0xDE66,   /* U+5E66 */
  0xDE67,   /* U+5E67 */
  0xDE68,   /* U+5E68 */
  0xDE69,   /* U+5E69 */
  0xDE6A,   /* U+5E6A */
  0xDE6B,   /* U+5E6B */
  0xDE6C,   /* U+5E6C */
  0xDE6D,   /* U+5E6D */
  0xDE6E,   /* U+5E6E */
  0xDE6F,   /* U+5E6F */
  0xDE70,   /* U+5E70 */
  0xDE71,   /* U+5E71 */
  0x0000,   /* U+5E72 */
  0x0000,   /* U+5E73 */
  0x0000,   /* U+5E74 */
  0x0000,   /* U+5E75 */
  0x0000,   /* U+5E76 */
  0xDE77,   /* U+5E77 */
  0x0000,   /* U+5E78 */
  0x0000,   /* U+5E79 */
  0x0000,   /* U+5E7A */
  0x0000,   /* U+5E7B */
  0x0000,   /* U+5E7C */
  0x0000,   /* U+5E7D */
  0x0000,   /* U+5E7E */
  0x0000,   /* U+5E7F */
  0xDE80,   /* U+5E80 */
  0x0000,   /* U+5E81 */
  0xDE82,   /* U+5E82 */
  0x0000,   /* U+5E83 */
  0x0000,   /* U+5E84 */
  0xDE85,   /* U+5E85 */
  0xDE86,   /* U+5E86 */
  0x0000,   /* U+5E87 */
  0xDE88,   /* U+5E88 */
  0xDE89,   /* U+5E89 */
  0x0000,   /* U+5E8A */
  0xDE8B,   /* U+5E8B */
  0xDE8C,   /* U+5E8C */
  0xDE8D,   /* U+5E8D */
  0xDE8E,   /* U+5E8E */
  0x0000,   /* U+5E8F */
  0xDE90,   /* U+5E90 */
  0xDE91,   /* U+5E91 */
  0xDE92,   /* U+5E92 */
  0xDE93,   /* U+5E93 */
  0xDE94,   /* U+5E94 */
  0x0000,   /* U+5E95 */
  0x0000,   /* U+5E96 */
  0x0000,   /* U+5E97 */
  0xDE98,   /* U+5E98 */
  0xDE99,   /* U+5E99 */
  0x0000,   /* U+5E9A */
  0xDE9B,   /* U+5E9B */
  0x0000,   /* U+5E9C */
  0xDE9D,   /* U+5E9D */
  0xDE9E,   /* U+5E9E */
  0xDE9F,   /* U+5E9F */
  0x0000,   /* U+5EA0 */
  0xDEA1,   /* U+5EA1 */
  0xDEA2,   /* U+5EA2 */
  0xDEA3,   /* U+5EA3 */
  0xDEA4,   /* U+5EA4 */
  0xDEA5,   /* U+5EA5 */
  0x0000,   /* U+5EA6 */
  0x0000,   /* U+5EA7 */
  0xDEA8,   /* U+5EA8 */
  0xDEA9,   /* U+5EA9 */
  0xDEAA,   /* U+5EAA */
  0x0000,   /* U+5EAB */
  0xDEAC,   /* U+5EAC */
  0x0000,   /* U+5EAD */
  0xDEAE,   /* U+5EAE */
  0xDEAF,   /* U+5EAF */
  0xDEB0,   /* U+5EB0 */
  0xDEB1,   /* U+5EB1 */
  0xDEB2,   /* U+5EB2 */
  0xDEB3,   /* U+5EB3 */
  0xDEB4,   /* U+5EB4 */
  0x0000,   /* U+5EB5 */
  0x0000,   /* U+5EB6 */
  0x0000,   /* U+5EB7 */
  0x0000,   /* U+5EB8 */
  0xDEB9,   /* U+5EB9 */
  0xDEBA,   /* U+5EBA */
  0xDEBB,   /* U+5EBB */
  0xDEBC,   /* U+5EBC */
  0xDEBD,   /* U+5EBD */
  0xDEBE,   /* U+5EBE */
  0xDEBF,   /* U+5EBF */
  0xDEC0,   /* U+5EC0 */
  0x0000,   /* U+5EC1 */
  0x0000,   /* U+5EC2 */
  0x0000,   /* U+5EC3 */
  0xDEC4,   /* U+5EC4 */
  0xDEC5,   /* U+5EC5 */
  0xDEC6,   /* U+5EC6 */
  0xDEC7,   /* U+5EC7 */
  0x0000,   /* U+5EC8 */
  0x0000,   /* U+5EC9 */
  0x0000,   /* U+5ECA */
  0xDECB,   /* U+5ECB */
  0xDECC,   /* U+5ECC */
  0xDECD,   /* U+5ECD */
  0xDECE,   /* U+5ECE */
  0x0000,   /* U+5ECF */
  0x0000,   /* U+5ED0 */
  0xDED1,   /* U+5ED1 */
  0xDED2,   /* U+5ED2 */
  0x0000,   /* U+5ED3 */
  0xDED4,   /* U+5ED4 */
  0xDED5,   /* U+5ED5 */
  0x0000,   /* U+5ED6 */
  0xDED7,   /* U+5ED7 */
  0xDED8,   /* U+5ED8 */
  0xDED9,   /* U+5ED9 */
  0x0000,   /* U+5EDA */
  0x0000,   /* U+5EDB */
  0xDEDC,   /* U+5EDC */
  0x0000,   /* U+5EDD */
  0xDEDE,   /* U+5EDE */
  0x0000,   /* U+5EDF */
  0x0000,   /* U+5EE0 */
  0x0000,   /* U+5EE1 */
  0x0000,   /* U+5EE2 */
  0x0000,   /* U+5EE3 */
  0xDEE4,   /* U+5EE4 */
  0xDEE5,   /* U+5EE5 */
  0xDEE6,   /* U+5EE6 */
  0xDEE7,   /* U+5EE7 */
  0x0000,   /* U+5EE8 */
  0x0000,   /* U+5EE9 */
  0xDEEA,   /* U+5EEA */
  0xDEEB,   /* U+5EEB */
  0x0000,   /* U+5EEC */
  0xDEED,   /* U+5EED */
  0xDEEE,   /* U+5EEE */
  0xDEEF,   /* U+5EEF */
  0x0000,   /* U+5EF0 */
  0x0000,   /* U+5EF1 */
  0xDEF2,   /* U+5EF2 */
  0x0000,   /* U+5EF3 */
  0x0000,   /* U+5EF4 */
  0xDEF5,   /* U+5EF5 */
  0x0000,   /* U+5EF6 */
  0x0000,   /* U+5EF7 */
  0x0000,   /* U+5EF8 */
  0xDEF9,   /* U+5EF9 */
  0x0000,   /* U+5EFA */
  0x0000,   /* U+5EFB */
  0x0000,   /* U+5EFC */
  0xDEFD,   /* U+5EFD */
  0x0000,   /* U+5EFE */
  0x0000,   /* U+5EFF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+5E00 */
  0x0000,   /* U+5E01 */
  0x0000,   /* U+5E02 */
  0x0000,   /* U+5E03 */
  0x0000,   /* U+5E04 */
  0x0000,   /* U+5E05 */
  0x0000,   /* U+5E06 */
  0x0000,   /* U+5E07 */
  0x0000,   /* U+5E08 */
  0x0000,   /* U+5E09 */
  0x0000,   /* U+5E0A */
  0x0000,   /* U+5E0B */
  0x0000,   /* U+5E0C */
  0x0000,   /* U+5E0D */
  0x0000,   /* U+5E0E */
  0x0000,   /* U+5E0F */
  0x0000,   /* U+5E10 */
  0x0000,   /* U+5E11 */
  0x0000,   /* U+5E12 */
  0x0000,   /* U+5E13 */
  0x0000,   /* U+5E14 */
  0x0000,   /* U+5E15 */
  0x0000,   /* U+5E16 */
  0x0000,   /* U+5E17 */
  0x0000,   /* U+5E18 */
  0x0000,   /* U+5E19 */
  0x0000,   /* U+5E1A */
  0x0000,   /* U+5E1B */
  0x0000,   /* U+5E1C */
  0x0000,   /* U+5E1D */
  0x0000,   /* U+5E1E */
  0x0000,   /* U+5E1F */
  0x0000,   /* U+5E20 */
  0x0000,   /* U+5E21 */
  0x0000,   /* U+5E22 */
  0x0000,   /* U+5E23 */
  0x0000,   /* U+5E24 */
  0x0000,   /* U+5E25 */
  0x0000,   /* U+5E26 */
  0x0000,   /* U+5E27 */
  0x0000,   /* U+5E28 */
  0x0000,   /* U+5E29 */
  0x0000,   /* U+5E2A */
  0x0000,   /* U+5E2B */
  0x0000,   /* U+5E2C */
  0x0000,   /* U+5E2D */
  0x0000,   /* U+5E2E */
  0x0000,   /* U+5E2F */
  0x0000,   /* U+5E30 */
  0x0000,   /* U+5E31 */
  0x0000,   /* U+5E32 */
  0x0000,   /* U+5E33 */
  0x0000,   /* U+5E34 */
  0x0000,   /* U+5E35 */
  0x0000,   /* U+5E36 */
  0x0000,   /* U+5E37 */
  0x0000,   /* U+5E38 */
  0x0000,   /* U+5E39 */
  0x0000,   /* U+5E3A */
  0x0000,   /* U+5E3B */
  0x0000,   /* U+5E3C */
  0x0000,   /* U+5E3D */
  0x0000,   /* U+5E3E */
  0x0000,   /* U+5E3F */
  0x0000,   /* U+5E40 */
  0x0000,   /* U+5E41 */
  0x0000,   /* U+5E42 */
  0x0000,   /* U+5E43 */
  0x0000,   /* U+5E44 */
  0x0000,   /* U+5E45 */
  0x0000,   /* U+5E46 */
  0x0000,   /* U+5E47 */
  0x0000,   /* U+5E48 */
  0x0000,   /* U+5E49 */
  0x0000,   /* U+5E4A */
  0x0000,   /* U+5E4B */
  0x0000,   /* U+5E4C */
  0x0000,   /* U+5E4D */
  0x0000,   /* U+5E4E */
  0x0000,   /* U+5E4F */
  0x0000,   /* U+5E50 */
  0x0000,   /* U+5E51 */
  0x0000,   /* U+5E52 */
  0x0000,   /* U+5E53 */
  0x0000,   /* U+5E54 */
  0x0000,   /* U+5E55 */
  0x0000,   /* U+5E56 */
  0x0000,   /* U+5E57 */
  0x0000,   /* U+5E58 */
  0x0000,   /* U+5E59 */
  0x0000,   /* U+5E5A */
  0x0000,   /* U+5E5B */
  0x0000,   /* U+5E5C */
  0x0000,   /* U+5E5D */
  0x0000,   /* U+5E5E */
  0x0000,   /* U+5E5F */
  0x0000,   /* U+5E60 */
  0x0000,   /* U+5E61 */
  0x0000,   /* U+5E62 */
  0x0000,   /* U+5E63 */
  0x0000,   /* U+5E64 */
  0x0000,   /* U+5E65 */
  0x0000,   /* U+5E66 */
  0x0000,   /* U+5E67 */
  0x0000,   /* U+5E68 */
  0x0000,   /* U+5E69 */
  0x0000,   /* U+5E6A */
  0x0000,   /* U+5E6B */
  0x0000,   /* U+5E6C */
  0x0000,   /* U+5E6D */
  0x0000,   /* U+5E6E */
  0x0000,   /* U+5E6F */
  0x0000,   /* U+5E70 */
  0x0000,   /* U+5E71 */
  0x0000,   /* U+5E72 */
  0x0000,   /* U+5E73 */
  0x0000,   /* U+5E74 */
  0x0000,   /* U+5E75 */
  0x0000,   /* U+5E76 */
  0x0000,   /* U+5E77 */
  0x0000,   /* U+5E78 */
  0x0000,   /* U+5E79 */
  0x0000,   /* U+5E7A */
  0x0000,   /* U+5E7B */
  0x0000,   /* U+5E7C */
  0x0000,   /* U+5E7D */
  0x0000,   /* U+5E7E */
  0x0000,   /* U+5E7F */
  0x0000,   /* U+5E80 */
  0x0000,   /* U+5E81 */
  0x0000,   /* U+5E82 */
  0x0000,   /* U+5E83 */
  0x0000,   /* U+5E84 */
  0x0000,   /* U+5E85 */
  0x0000,   /* U+5E86 */
  0x0000,   /* U+5E87 */
  0x0000,   /* U+5E88 */
  0x0000,   /* U+5E89 */
  0x0000,   /* U+5E8A */
  0x0000,   /* U+5E8B */
  0x0000,   /* U+5E8C */
  0x0000,   /* U+5E8D */
  0x0000,   /* U+5E8E */
  0x0000,   /* U+5E8F */
  0x0000,   /* U+5E90 */
  0x0000,   /* U+5E91 */
  0x0000,   /* U+5E92 */
  0x0000,   /* U+5E93 */
  0x0000,   /* U+5E94 */
  0x0000,   /* U+5E95 */
  0x0000,   /* U+5E96 */
  0x0000,   /* U+5E97 */
  0x0000,   /* U+5E98 */
  0x0000,   /* U+5E99 */
  0x0000,   /* U+5E9A */
  0x0000,   /* U+5E9B */
  0x0000,   /* U+5E9C */
  0x0000,   /* U+5E9D */
  0x0000,   /* U+5E9E */
  0x0000,   /* U+5E9F */
  0x0000,   /* U+5EA0 */
  0x0000,   /* U+5EA1 */
  0x0000,   /* U+5EA2 */
  0x0000,   /* U+5EA3 */
  0x0000,   /* U+5EA4 */
  0x0000,   /* U+5EA5 */
  0x0000,   /* U+5EA6 */
  0x0000,   /* U+5EA7 */
  0x0000,   /* U+5EA8 */
  0x0000,   /* U+5EA9 */
  0x0000,   /* U+5EAA */
  0x0000,   /* U+5EAB */
  0x0000,   /* U+5EAC */
  0x0000,   /* U+5EAD */
  0x0000,   /* U+5EAE */
  0x0000,   /* U+5EAF */
  0x0000,   /* U+5EB0 */
  0x0000,   /* U+5EB1 */
  0x0000,   /* U+5EB2 */
  0x0000,   /* U+5EB3 */
  0x0000,   /* U+5EB4 */
  0x0000,   /* U+5EB5 */
  0x0000,   /* U+5EB6 */
  0x0000,   /* U+5EB7 */
  0x0000,   /* U+5EB8 */
  0x0000,   /* U+5EB9 */
  0x0000,   /* U+5EBA */
  0x0000,   /* U+5EBB */
  0x0000,   /* U+5EBC */
  0x0000,   /* U+5EBD */
  0x0000,   /* U+5EBE */
  0x0000,   /* U+5EBF */
  0x0000,   /* U+5EC0 */
  0x0000,   /* U+5EC1 */
  0x0000,   /* U+5EC2 */
  0x0000,   /* U+5EC3 */
  0x0000,   /* U+5EC4 */
  0x0000,   /* U+5EC5 */
  0x0000,   /* U+5EC6 */
  0x0000,   /* U+5EC7 */
  0x0000,   /* U+5EC8 */
  0x0000,   /* U+5EC9 */
  0x0000,   /* U+5ECA */
  0x0000,   /* U+5ECB */
  0x0000,   /* U+5ECC */
  0x0000,   /* U+5ECD */
  0x0000,   /* U+5ECE */
  0x0000,   /* U+5ECF */
  0x0000,   /* U+5ED0 */
  0x0000,   /* U+5ED1 */
  0x0000,   /* U+5ED2 */
  0x0000,   /* U+5ED3 */
  0x0000,   /* U+5ED4 */
  0x0000,   /* U+5ED5 */
  0x0000,   /* U+5ED6 */
  0x0000,   /* U+5ED7 */
  0x0000,   /* U+5ED8 */
  0x0000,   /* U+5ED9 */
  0x0000,   /* U+5EDA */
  0x0000,   /* U+5EDB */
  0x0000,   /* U+5EDC */
  0x0000,   /* U+5EDD */
  0x0000,   /* U+5EDE */
  0x0000,   /* U+5EDF */
  0x0000,   /* U+5EE0 */
  0x0000,   /* U+5EE1 */
  0x0000,   /* U+5EE2 */
  0x0000,   /* U+5EE3 */
  0x0000,   /* U+5EE4 */
  0x0000,   /* U+5EE5 */
  0x0000,   /* U+5EE6 */
  0x0000,   /* U+5EE7 */
  0x0000,   /* U+5EE8 */
  0x0000,   /* U+5EE9 */
  0x0000,   /* U+5EEA */
  0x0000,   /* U+5EEB */
  0x0000,   /* U+5EEC */
  0x0000,   /* U+5EED */
  0x0000,   /* U+5EEE */
  0x0000,   /* U+5EEF */
  0x0000,   /* U+5EF0 */
  0x0000,   /* U+5EF1 */
  0x0000,   /* U+5EF2 */
  0x0000,   /* U+5EF3 */
  0x0000,   /* U+5EF4 */
  0x0000,   /* U+5EF5 */
  0x0000,   /* U+5EF6 */
  0x0000,   /* U+5EF7 */
  0x0000,   /* U+5EF8 */
  0x0000,   /* U+5EF9 */
  0x0000,   /* U+5EFA */
  0x0000,   /* U+5EFB */
  0x0000,   /* U+5EFC */
  0x0000,   /* U+5EFD */
  0x0000,   /* U+5EFE */
  0x0000,   /* U+5EFF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+5E00 */
  0x0000,   /* U+5E01 */
  0x0000,   /* U+5E02 */
  0x0000,   /* U+5E03 */
  0x0000,   /* U+5E04 */
  0x0000,   /* U+5E05 */
  0x0000,   /* U+5E06 */
  0x0000,   /* U+5E07 */
  0x0000,   /* U+5E08 */
  0x0000,   /* U+5E09 */
  0x0000,   /* U+5E0A */
  0x0000,   /* U+5E0B */
  0x0000,   /* U+5E0C */
  0x0000,   /* U+5E0D */
  0x0000,   /* U+5E0E */
  0x0000,   /* U+5E0F */
  0x0000,   /* U+5E10 */
  0x0000,   /* U+5E11 */
  0x0000,   /* U+5E12 */
  0x0000,   /* U+5E13 */
  0x0000,   /* U+5E14 */
  0x0000,   /* U+5E15 */
  0x0000,   /* U+5E16 */
  0x0000,   /* U+5E17 */
  0x0000,   /* U+5E18 */
  0x0000,   /* U+5E19 */
  0x0000,   /* U+5E1A */
  0x0000,   /* U+5E1B */
  0x0000,   /* U+5E1C */
  0x0000,   /* U+5E1D */
  0x0000,   /* U+5E1E */
  0x0000,   /* U+5E1F */
  0x0000,   /* U+5E20 */
  0x0000,   /* U+5E21 */
  0x0000,   /* U+5E22 */
  0x0000,   /* U+5E23 */
  0x0000,   /* U+5E24 */
  0x0000,   /* U+5E25 */
  0x0000,   /* U+5E26 */
  0x0000,   /* U+5E27 */
  0x0000,   /* U+5E28 */
  0x0000,   /* U+5E29 */
  0x0000,   /* U+5E2A */
  0x0000,   /* U+5E2B */
  0x0000,   /* U+5E2C */
  0x0000,   /* U+5E2D */
  0x0000,   /* U+5E2E */
  0x0000,   /* U+5E2F */
  0x0000,   /* U+5E30 */
  0x0000,   /* U+5E31 */
  0x0000,   /* U+5E32 */
  0x0000,   /* U+5E33 */
  0x0000,   /* U+5E34 */
  0x0000,   /* U+5E35 */
  0x0000,   /* U+5E36 */
  0x0000,   /* U+5E37 */
  0x0000,   /* U+5E38 */
  0x0000,   /* U+5E39 */
  0x0000,   /* U+5E3A */
  0x0000,   /* U+5E3B */
  0x0000,   /* U+5E3C */
  0x0000,   /* U+5E3D */
  0x0000,   /* U+5E3E */
  0x0000,   /* U+5E3F */
  0x0000,   /* U+5E40 */
  0x0000,   /* U+5E41 */
  0x0000,   /* U+5E42 */
  0x0000,   /* U+5E43 */
  0x0000,   /* U+5E44 */
  0x0000,   /* U+5E45 */
  0x0000,   /* U+5E46 */
  0x0000,   /* U+5E47 */
  0x0000,   /* U+5E48 */
  0x0000,   /* U+5E49 */
  0x0000,   /* U+5E4A */
  0x0000,   /* U+5E4B */
  0x0000,   /* U+5E4C */
  0x0000,   /* U+5E4D */
  0x0000,   /* U+5E4E */
  0x0000,   /* U+5E4F */
  0x0000,   /* U+5E50 */
  0x0000,   /* U+5E51 */
  0x0000,   /* U+5E52 */
  0x0000,   /* U+5E53 */
  0x0000,   /* U+5E54 */
  0x0000,   /* U+5E55 */
  0x0000,   /* U+5E56 */
  0x0000,   /* U+5E57 */
  0x0000,   /* U+5E58 */
  0x0000,   /* U+5E59 */
  0x0000,   /* U+5E5A */
  0x0000,   /* U+5E5B */
  0x0000,   /* U+5E5C */
  0x0000,   /* U+5E5D */
  0x0000,   /* U+5E5E */
  0x0000,   /* U+5E5F */
  0x0000,   /* U+5E60 */
  0x0000,   /* U+5E61 */
  0x0000,   /* U+5E62 */
  0x0000,   /* U+5E63 */
  0x0000,   /* U+5E64 */
  0x0000,   /* U+5E65 */
  0x0000,   /* U+5E66 */
  0x0000,   /* U+5E67 */
  0x0000,   /* U+5E68 */
  0x0000,   /* U+5E69 */
  0x0000,   /* U+5E6A */
  0x0000,   /* U+5E6B */
  0x0000,   /* U+5E6C */
  0x0000,   /* U+5E6D */
  0x0000,   /* U+5E6E */
  0x0000,   /* U+5E6F */
  0x0000,   /* U+5E70 */
  0x0000,   /* U+5E71 */
  0x0000,   /* U+5E72 */
  0x0000,   /* U+5E73 */
  0x0000,   /* U+5E74 */
  0x0000,   /* U+5E75 */
  0x0000,   /* U+5E76 */
  0x0000,   /* U+5E77 */
  0x0000,   /* U+5E78 */
  0x0000,   /* U+5E79 */
  0x0000,   /* U+5E7A */
  0x0000,   /* U+5E7B */
  0x0000,   /* U+5E7C */
  0x0000,   /* U+5E7D */
  0x0000,   /* U+5E7E */
  0x0000,   /* U+5E7F */
  0x0000,   /* U+5E80 */
  0x0000,   /* U+5E81 */
  0x0000,   /* U+5E82 */
  0x0000,   /* U+5E83 */
  0x0000,   /* U+5E84 */
  0x0000,   /* U+5E85 */
  0x0000,   /* U+5E86 */
  0x0000,   /* U+5E87 */
  0x0000,   /* U+5E88 */
  0x0000,   /* U+5E89 */
  0x0000,   /* U+5E8A */
  0x0000,   /* U+5E8B */
  0x0000,   /* U+5E8C */
  0x0000,   /* U+5E8D */
  0x0000,   /* U+5E8E */
  0x0000,   /* U+5E8F */
  0x0000,   /* U+5E90 */
  0x0000,   /* U+5E91 */
  0x0000,   /* U+5E92 */
  0x0000,   /* U+5E93 */
  0x0000,   /* U+5E94 */
  0x0000,   /* U+5E95 */
  0x0000,   /* U+5E96 */
  0x0000,   /* U+5E97 */
  0x0000,   /* U+5E98 */
  0x0000,   /* U+5E99 */
  0x0000,   /* U+5E9A */
  0x0000,   /* U+5E9B */
  0x0000,   /* U+5E9C */
  0x0000,   /* U+5E9D */
  0x0000,   /* U+5E9E */
  0x0000,   /* U+5E9F */
  0x0000,   /* U+5EA0 */
  0x0000,   /* U+5EA1 */
  0x0000,   /* U+5EA2 */
  0x0000,   /* U+5EA3 */
  0x0000,   /* U+5EA4 */
  0x0000,   /* U+5EA5 */
  0x0000,   /* U+5EA6 */
  0x0000,   /* U+5EA7 */
  0x0000,   /* U+5EA8 */
  0x0000,   /* U+5EA9 */
  0x0000,   /* U+5EAA */
  0x0000,   /* U+5EAB */
  0x0000,   /* U+5EAC */
  0x0000,   /* U+5EAD */
  0x0000,   /* U+5EAE */
  0x0000,   /* U+5EAF */
  0x0000,   /* U+5EB0 */
  0x0000,   /* U+5EB1 */
  0x0000,   /* U+5EB2 */
  0x0000,   /* U+5EB3 */
  0x0000,   /* U+5EB4 */
  0x0000,   /* U+5EB5 */
  0x0000,   /* U+5EB6 */
  0x0000,   /* U+5EB7 */
  0x0000,   /* U+5EB8 */
  0x0000,   /* U+5EB9 */
  0x0000,   /* U+5EBA */
  0x0000,   /* U+5EBB */
  0x0000,   /* U+5EBC */
  0x0000,   /* U+5EBD */
  0x0000,   /* U+5EBE */
  0x0000,   /* U+5EBF */
  0x0000,   /* U+5EC0 */
  0x0000,   /* U+5EC1 */
  0x0000,   /* U+5EC2 */
  0x0000,   /* U+5EC3 */
  0x0000,   /* U+5EC4 */
  0x0000,   /* U+5EC5 */
  0x0000,   /* U+5EC6 */
  0x0000,   /* U+5EC7 */
  0x0000,   /* U+5EC8 */
  0x0000,   /* U+5EC9 */
  0x0000,   /* U+5ECA */
  0x0000,   /* U+5ECB */
  0x0000,   /* U+5ECC */
  0x0000,   /* U+5ECD */
  0x0000,   /* U+5ECE */
  0x0000,   /* U+5ECF */
  0x0000,   /* U+5ED0 */
  0x0000,   /* U+5ED1 */
  0x0000,   /* U+5ED2 */
  0x0000,   /* U+5ED3 */
  0x0000,   /* U+5ED4 */
  0x0000,   /* U+5ED5 */
  0x0000,   /* U+5ED6 */
  0x0000,   /* U+5ED7 */
  0x0000,   /* U+5ED8 */
  0x0000,   /* U+5ED9 */
  0x0000,   /* U+5EDA */
  0x0000,   /* U+5EDB */
  0x0000,   /* U+5EDC */
  0x0000,   /* U+5EDD */
  0x0000,   /* U+5EDE */
  0x0000,   /* U+5EDF */
  0x0000,   /* U+5EE0 */
  0x0000,   /* U+5EE1 */
  0x0000,   /* U+5EE2 */
  0x0000,   /* U+5EE3 */
  0x0000,   /* U+5EE4 */
  0x0000,   /* U+5EE5 */
  0x0000,   /* U+5EE6 */
  0x0000,   /* U+5EE7 */
  0x0000,   /* U+5EE8 */
  0x0000,   /* U+5EE9 */
  0x0000,   /* U+5EEA */
  0x0000,   /* U+5EEB */
  0x0000,   /* U+5EEC */
  0x0000,   /* U+5EED */
  0x0000,   /* U+5EEE */
  0x0000,   /* U+5EEF */
  0x0000,   /* U+5EF0 */
  0x0000,   /* U+5EF1 */
  0x0000,   /* U+5EF2 */
  0x0000,   /* U+5EF3 */
  0x0000,   /* U+5EF4 */
  0x0000,   /* U+5EF5 */
  0x0000,   /* U+5EF6 */
  0x0000,   /* U+5EF7 */
  0x0000,   /* U+5EF8 */
  0x0000,   /* U+5EF9 */
  0x0000,   /* U+5EFA */
  0x0000,   /* U+5EFB */
  0x0000,   /* U+5EFC */
  0x0000,   /* U+5EFD */
  0x0000,   /* U+5EFE */
  0x0000,   /* U+5EFF */
};

uint16 ja_han_page5F[]= {
  /* Number of CEs for each character. */
  2, 1, 2, 1, 1, 2, 2, 2, 2, 1, 1, 1, 1, 1, 2, 1,
  1, 1, 2, 1, 1, 1, 1, 1, 1, 2, 2, 1, 2, 2, 2, 1,
  2, 2, 2, 2, 2, 1, 1, 1, 2, 1, 2, 2, 2, 1, 2, 1,
  2, 1, 2, 2, 2, 1, 2, 1, 1, 2, 2, 2, 1, 2, 1, 2,
  2, 1, 2, 2, 2, 2, 2, 2, 1, 2, 1, 2, 1, 2, 1, 2,
  2, 1, 2, 1, 2, 2, 1, 1, 2, 1, 2, 2, 1, 1, 2, 2,
  2, 1, 1, 2, 2, 2, 1, 2, 2, 1, 1, 1, 1, 1, 2, 2,
  1, 1, 2, 1, 2, 2, 2, 1, 2, 1, 2, 2, 1, 2, 2, 1,
  1, 1, 1, 1, 1, 1, 2, 1, 1, 2, 1, 1, 1, 2, 2, 2,
  1, 1, 1, 1, 2, 2, 2, 1, 1, 1, 2, 2, 2, 2, 1, 2,
  1, 1, 2, 2, 2, 2, 2, 2, 1, 1, 1, 2, 2, 1, 1, 2,
  2, 2, 2, 1, 1, 2, 2, 2, 2, 1, 2, 2, 1, 1, 2, 2,
  2, 2, 2, 1, 2, 1, 2, 2, 2, 2, 2, 2, 1, 1, 2, 2,
  2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 2, 2, 1, 1, 2, 2,
  1, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2,
  1, 1, 2, 2, 2, 1, 2, 2, 1, 2, 2, 1, 2, 1, 2, 1,

  /* Primary weight 1 for each character. */
  0xFB40,   /* U+5F00 */
  0x5E6A,   /* U+5F01 */
  0xFB40,   /* U+5F02 */
  0x62DB,   /* U+5F03 */
  0x6013,   /* U+5F04 */
  0xFB40,   /* U+5F05 */
  0xFB40,   /* U+5F06 */
  0xFB40,   /* U+5F07 */
  0xFB40,   /* U+5F08 */
  0x62DC,   /* U+5F09 */
  0x5E4F,   /* U+5F0A */
  0x62DF,   /* U+5F0B */
  0x6039,   /* U+5F0C */
  0x6049,   /* U+5F0D */
  0xFB40,   /* U+5F0E */
  0x591B,   /* U+5F0F */
  0x5D0C,   /* U+5F10 */
  0x62E0,   /* U+5F11 */
  0xFB40,   /* U+5F12 */
  0x56B6,   /* U+5F13 */
  0x5BFF,   /* U+5F14 */
  0x54FD,   /* U+5F15 */
  0x62E1,   /* U+5F16 */
  0x5E35,   /* U+5F17 */
  0x5801,   /* U+5F18 */
  0xFB40,   /* U+5F19 */
  0xFB40,   /* U+5F1A */
  0x5BCD,   /* U+5F1B */
  0xFB40,   /* U+5F1C */
  0xFB40,   /* U+5F1D */
  0xFB40,   /* U+5F1E */
  0x5C4A,   /* U+5F1F */
  0xFB40,   /* U+5F20 */
  0xFB40,   /* U+5F21 */
  0xFB40,   /* U+5F22 */
  0xFB40,   /* U+5F23 */
  0xFB40,   /* U+5F24 */
  0x5F3A,   /* U+5F25 */
  0x57AC,   /* U+5F26 */
  0x57BF,   /* U+5F27 */
  0xFB40,   /* U+5F28 */
  0x62E2,   /* U+5F29 */
  0xFB40,   /* U+5F2A */
  0xFB40,   /* U+5F2B */
  0xFB40,   /* U+5F2C */
  0x62E3,   /* U+5F2D */
  0xFB40,   /* U+5F2E */
  0x62E9,   /* U+5F2F */
  0xFB40,   /* U+5F30 */
  0x5950,   /* U+5F31 */
  0xFB40,   /* U+5F32 */
  0xFB40,   /* U+5F33 */
  0xFB40,   /* U+5F34 */
  0x5C00,   /* U+5F35 */
  0xFB40,   /* U+5F36 */
  0x56E6,   /* U+5F37 */
  0x62E4,   /* U+5F38 */
  0xFB40,   /* U+5F39 */
  0xFB40,   /* U+5F3A */
  0xFB40,   /* U+5F3B */
  0x5DDC,   /* U+5F3C */
  0xFB40,   /* U+5F3D */
  0x5BC3,   /* U+5F3E */
  0xFB40,   /* U+5F3F */
  0xFB40,   /* U+5F40 */
  0x62E5,   /* U+5F41 */
  0xFB40,   /* U+5F42 */
  0xFB40,   /* U+5F43 */
  0xFB40,   /* U+5F44 */
  0xFB40,   /* U+5F45 */
  0xFB40,   /* U+5F46 */
  0xFB40,   /* U+5F47 */
  0x62E6,   /* U+5F48 */
  0xFB40,   /* U+5F49 */
  0x56E7,   /* U+5F4A */
  0xFB40,   /* U+5F4B */
  0x62E7,   /* U+5F4C */
  0xFB40,   /* U+5F4D */
  0x62E8,   /* U+5F4E */
  0xFB40,   /* U+5F4F */
  0xFB40,   /* U+5F50 */
  0x62EA,   /* U+5F51 */
  0xFB40,   /* U+5F52 */
  0x5CAF,   /* U+5F53 */
  0xFB40,   /* U+5F54 */
  0xFB40,   /* U+5F55 */
  0x62EB,   /* U+5F56 */
  0x62EC,   /* U+5F57 */
  0xFB40,   /* U+5F58 */
  0x62ED,   /* U+5F59 */
  0xFB40,   /* U+5F5A */
  0xFB40,   /* U+5F5B */
  0x62DE,   /* U+5F5C */
  0x62DD,   /* U+5F5D */
  0xFB40,   /* U+5F5E */
  0xFB40,   /* U+5F5F */
  0xFB40,   /* U+5F60 */
  0x62EE,   /* U+5F61 */
  0x5756,   /* U+5F62 */
  0xFB40,   /* U+5F63 */
  0xFB40,   /* U+5F64 */
  0xFB40,   /* U+5F65 */
  0x5DD8,   /* U+5F66 */
  0xFB40,   /* U+5F67 */
  0xFB40,   /* U+5F68 */
  0x587B,   /* U+5F69 */
  0x5DE8,   /* U+5F6A */
  0x5C01,   /* U+5F6B */
  0x5DFC,   /* U+5F6C */
  0x62EF,   /* U+5F6D */
  0xFB40,   /* U+5F6E */
  0xFB40,   /* U+5F6F */
  0x59DB,   /* U+5F70 */
  0x5527,   /* U+5F71 */
  0xFB40,   /* U+5F72 */
  0x62F0,   /* U+5F73 */
  0xFB40,   /* U+5F74 */
  0xFB40,   /* U+5F75 */
  0xFB40,   /* U+5F76 */
  0x62F1,   /* U+5F77 */
  0xFB40,   /* U+5F78 */
  0x5F3D,   /* U+5F79 */
  0xFB40,   /* U+5F7A */
  0xFB40,   /* U+5F7B */
  0x5DB3,   /* U+5F7C */
  0xFB40,   /* U+5F7D */
  0xFB40,   /* U+5F7E */
  0x62F4,   /* U+5F7F */
  0x555E,   /* U+5F80 */
  0x5A8F,   /* U+5F81 */
  0x62F3,   /* U+5F82 */
  0x62F2,   /* U+5F83 */
  0x5757,   /* U+5F84 */
  0x5B73,   /* U+5F85 */
  0xFB40,   /* U+5F86 */
  0x62F8,   /* U+5F87 */
  0x62F6,   /* U+5F88 */
  0xFB40,   /* U+5F89 */
  0x62F5,   /* U+5F8A */
  0x5FAE,   /* U+5F8B */
  0x57D8,   /* U+5F8C */
  0xFB40,   /* U+5F8D */
  0xFB40,   /* U+5F8E */
  0xFB40,   /* U+5F8F */
  0x59C2,   /* U+5F90 */
  0x62F7,   /* U+5F91 */
  0x5C85,   /* U+5F92 */
  0x5987,   /* U+5F93 */
  0xFB40,   /* U+5F94 */
  0xFB40,   /* U+5F95 */
  0xFB40,   /* U+5F96 */
  0x5CD7,   /* U+5F97 */
  0x62FB,   /* U+5F98 */
  0x62FA,   /* U+5F99 */
  0xFB40,   /* U+5F9A */
  0xFB40,   /* U+5F9B */
  0xFB40,   /* U+5F9C */
  0xFB40,   /* U+5F9D */
  0x62F9,   /* U+5F9E */
  0xFB40,   /* U+5F9F */
  0x62FC,   /* U+5FA0 */
  0x57D9,   /* U+5FA1 */
  0xFB40,   /* U+5FA2 */
  0xFB40,   /* U+5FA3 */
  0xFB40,   /* U+5FA4 */
  0xFB40,   /* U+5FA5 */
  0xFB40,   /* U+5FA6 */
  0xFB40,   /* U+5FA7 */
  0x62FD,   /* U+5FA8 */
  0x5E2D,   /* U+5FA9 */
  0x59A4,   /* U+5FAA */
  0xFB40,   /* U+5FAB */
  0xFB40,   /* U+5FAC */
  0x62FE,   /* U+5FAD */
  0x5DCC,   /* U+5FAE */
  0xFB40,   /* U+5FAF */
  0xFB40,   /* U+5FB0 */
  0xFB40,   /* U+5FB1 */
  0xFB40,   /* U+5FB2 */
  0x5CD8,   /* U+5FB3 */
  0x5C02,   /* U+5FB4 */
  0xFB40,   /* U+5FB5 */
  0xFB40,   /* U+5FB6 */
  0xFB40,   /* U+5FB7 */
  0xFB40,   /* U+5FB8 */
  0x5C69,   /* U+5FB9 */
  0xFB40,   /* U+5FBA */
  0xFB40,   /* U+5FBB */
  0x62FF,   /* U+5FBC */
  0x5684,   /* U+5FBD */
  0xFB40,   /* U+5FBE */
  0xFB40,   /* U+5FBF */
  0xFB40,   /* U+5FC0 */
  0xFB40,   /* U+5FC1 */
  0xFB40,   /* U+5FC2 */
  0x5A39,   /* U+5FC3 */
  0xFB40,   /* U+5FC4 */
  0x5DDD,   /* U+5FC5 */
  0xFB40,   /* U+5FC6 */
  0xFB40,   /* U+5FC7 */
  0xFB40,   /* U+5FC8 */
  0xFB40,   /* U+5FC9 */
  0xFB40,   /* U+5FCA */
  0xFB40,   /* U+5FCB */
  0x5672,   /* U+5FCC */
  0x5D1B,   /* U+5FCD */
  0xFB40,   /* U+5FCE */
  0xFB40,   /* U+5FCF */
  0xFB40,   /* U+5FD0 */
  0xFB40,   /* U+5FD1 */
  0xFB40,   /* U+5FD2 */
  0xFB40,   /* U+5FD3 */
  0xFB40,   /* U+5FD4 */
  0xFB40,   /* U+5FD5 */
  0x6300,   /* U+5FD6 */
  0x58E3,   /* U+5FD7 */
  0x5EA7,   /* U+5FD8 */
  0x5EA8,   /* U+5FD9 */
  0xFB40,   /* U+5FDA */
  0xFB40,   /* U+5FDB */
  0x555F,   /* U+5FDC */
  0x6305,   /* U+5FDD */
  0xFB40,   /* U+5FDE */
  0xFB40,   /* U+5FDF */
  0x5BE6,   /* U+5FE0 */
  0xFB40,   /* U+5FE1 */
  0xFB40,   /* U+5FE2 */
  0xFB40,   /* U+5FE3 */
  0x6302,   /* U+5FE4 */
  0xFB40,   /* U+5FE5 */
  0xFB40,   /* U+5FE6 */
  0xFB40,   /* U+5FE7 */
  0xFB40,   /* U+5FE8 */
  0xFB40,   /* U+5FE9 */
  0xFB40,   /* U+5FEA */
  0x55B6,   /* U+5FEB */
  0xFB40,   /* U+5FEC */
  0xFB40,   /* U+5FED */
  0xFB40,   /* U+5FEE */
  0xFB40,   /* U+5FEF */
  0x6335,   /* U+5FF0 */
  0x6304,   /* U+5FF1 */
  0xFB40,   /* U+5FF2 */
  0xFB40,   /* U+5FF3 */
  0xFB40,   /* U+5FF4 */
  0x5D25,   /* U+5FF5 */
  0xFB40,   /* U+5FF6 */
  0xFB40,   /* U+5FF7 */
  0x6303,   /* U+5FF8 */
  0xFB40,   /* U+5FF9 */
  0xFB40,   /* U+5FFA */
  0x6301,   /* U+5FFB */
  0xFB40,   /* U+5FFC */
  0x584B,   /* U+5FFD */
  0xFB40,   /* U+5FFE */
  0x6307,   /* U+5FFF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+5F00 */
  0x0020,   /* U+5F01 */
  0x0020,   /* U+5F02 */
  0x0020,   /* U+5F03 */
  0x0020,   /* U+5F04 */
  0x0020,   /* U+5F05 */
  0x0020,   /* U+5F06 */
  0x0020,   /* U+5F07 */
  0x0020,   /* U+5F08 */
  0x0020,   /* U+5F09 */
  0x0020,   /* U+5F0A */
  0x0020,   /* U+5F0B */
  0x0020,   /* U+5F0C */
  0x0020,   /* U+5F0D */
  0x0020,   /* U+5F0E */
  0x0020,   /* U+5F0F */
  0x0020,   /* U+5F10 */
  0x0020,   /* U+5F11 */
  0x0020,   /* U+5F12 */
  0x0020,   /* U+5F13 */
  0x0020,   /* U+5F14 */
  0x0020,   /* U+5F15 */
  0x0020,   /* U+5F16 */
  0x0020,   /* U+5F17 */
  0x0020,   /* U+5F18 */
  0x0020,   /* U+5F19 */
  0x0020,   /* U+5F1A */
  0x0020,   /* U+5F1B */
  0x0020,   /* U+5F1C */
  0x0020,   /* U+5F1D */
  0x0020,   /* U+5F1E */
  0x0020,   /* U+5F1F */
  0x0020,   /* U+5F20 */
  0x0020,   /* U+5F21 */
  0x0020,   /* U+5F22 */
  0x0020,   /* U+5F23 */
  0x0020,   /* U+5F24 */
  0x0020,   /* U+5F25 */
  0x0020,   /* U+5F26 */
  0x0020,   /* U+5F27 */
  0x0020,   /* U+5F28 */
  0x0020,   /* U+5F29 */
  0x0020,   /* U+5F2A */
  0x0020,   /* U+5F2B */
  0x0020,   /* U+5F2C */
  0x0020,   /* U+5F2D */
  0x0020,   /* U+5F2E */
  0x0020,   /* U+5F2F */
  0x0020,   /* U+5F30 */
  0x0020,   /* U+5F31 */
  0x0020,   /* U+5F32 */
  0x0020,   /* U+5F33 */
  0x0020,   /* U+5F34 */
  0x0020,   /* U+5F35 */
  0x0020,   /* U+5F36 */
  0x0020,   /* U+5F37 */
  0x0020,   /* U+5F38 */
  0x0020,   /* U+5F39 */
  0x0020,   /* U+5F3A */
  0x0020,   /* U+5F3B */
  0x0020,   /* U+5F3C */
  0x0020,   /* U+5F3D */
  0x0020,   /* U+5F3E */
  0x0020,   /* U+5F3F */
  0x0020,   /* U+5F40 */
  0x0020,   /* U+5F41 */
  0x0020,   /* U+5F42 */
  0x0020,   /* U+5F43 */
  0x0020,   /* U+5F44 */
  0x0020,   /* U+5F45 */
  0x0020,   /* U+5F46 */
  0x0020,   /* U+5F47 */
  0x0020,   /* U+5F48 */
  0x0020,   /* U+5F49 */
  0x0020,   /* U+5F4A */
  0x0020,   /* U+5F4B */
  0x0020,   /* U+5F4C */
  0x0020,   /* U+5F4D */
  0x0020,   /* U+5F4E */
  0x0020,   /* U+5F4F */
  0x0020,   /* U+5F50 */
  0x0020,   /* U+5F51 */
  0x0020,   /* U+5F52 */
  0x0020,   /* U+5F53 */
  0x0020,   /* U+5F54 */
  0x0020,   /* U+5F55 */
  0x0020,   /* U+5F56 */
  0x0020,   /* U+5F57 */
  0x0020,   /* U+5F58 */
  0x0020,   /* U+5F59 */
  0x0020,   /* U+5F5A */
  0x0020,   /* U+5F5B */
  0x0020,   /* U+5F5C */
  0x0020,   /* U+5F5D */
  0x0020,   /* U+5F5E */
  0x0020,   /* U+5F5F */
  0x0020,   /* U+5F60 */
  0x0020,   /* U+5F61 */
  0x0020,   /* U+5F62 */
  0x0020,   /* U+5F63 */
  0x0020,   /* U+5F64 */
  0x0020,   /* U+5F65 */
  0x0020,   /* U+5F66 */
  0x0020,   /* U+5F67 */
  0x0020,   /* U+5F68 */
  0x0020,   /* U+5F69 */
  0x0020,   /* U+5F6A */
  0x0020,   /* U+5F6B */
  0x0020,   /* U+5F6C */
  0x0020,   /* U+5F6D */
  0x0020,   /* U+5F6E */
  0x0020,   /* U+5F6F */
  0x0020,   /* U+5F70 */
  0x0020,   /* U+5F71 */
  0x0020,   /* U+5F72 */
  0x0020,   /* U+5F73 */
  0x0020,   /* U+5F74 */
  0x0020,   /* U+5F75 */
  0x0020,   /* U+5F76 */
  0x0020,   /* U+5F77 */
  0x0020,   /* U+5F78 */
  0x0020,   /* U+5F79 */
  0x0020,   /* U+5F7A */
  0x0020,   /* U+5F7B */
  0x0020,   /* U+5F7C */
  0x0020,   /* U+5F7D */
  0x0020,   /* U+5F7E */
  0x0020,   /* U+5F7F */
  0x0020,   /* U+5F80 */
  0x0020,   /* U+5F81 */
  0x0020,   /* U+5F82 */
  0x0020,   /* U+5F83 */
  0x0020,   /* U+5F84 */
  0x0020,   /* U+5F85 */
  0x0020,   /* U+5F86 */
  0x0020,   /* U+5F87 */
  0x0020,   /* U+5F88 */
  0x0020,   /* U+5F89 */
  0x0020,   /* U+5F8A */
  0x0020,   /* U+5F8B */
  0x0020,   /* U+5F8C */
  0x0020,   /* U+5F8D */
  0x0020,   /* U+5F8E */
  0x0020,   /* U+5F8F */
  0x0020,   /* U+5F90 */
  0x0020,   /* U+5F91 */
  0x0020,   /* U+5F92 */
  0x0020,   /* U+5F93 */
  0x0020,   /* U+5F94 */
  0x0020,   /* U+5F95 */
  0x0020,   /* U+5F96 */
  0x0020,   /* U+5F97 */
  0x0020,   /* U+5F98 */
  0x0020,   /* U+5F99 */
  0x0020,   /* U+5F9A */
  0x0020,   /* U+5F9B */
  0x0020,   /* U+5F9C */
  0x0020,   /* U+5F9D */
  0x0020,   /* U+5F9E */
  0x0020,   /* U+5F9F */
  0x0020,   /* U+5FA0 */
  0x0020,   /* U+5FA1 */
  0x0020,   /* U+5FA2 */
  0x0020,   /* U+5FA3 */
  0x0020,   /* U+5FA4 */
  0x0020,   /* U+5FA5 */
  0x0020,   /* U+5FA6 */
  0x0020,   /* U+5FA7 */
  0x0020,   /* U+5FA8 */
  0x0020,   /* U+5FA9 */
  0x0020,   /* U+5FAA */
  0x0020,   /* U+5FAB */
  0x0020,   /* U+5FAC */
  0x0020,   /* U+5FAD */
  0x0020,   /* U+5FAE */
  0x0020,   /* U+5FAF */
  0x0020,   /* U+5FB0 */
  0x0020,   /* U+5FB1 */
  0x0020,   /* U+5FB2 */
  0x0020,   /* U+5FB3 */
  0x0020,   /* U+5FB4 */
  0x0020,   /* U+5FB5 */
  0x0020,   /* U+5FB6 */
  0x0020,   /* U+5FB7 */
  0x0020,   /* U+5FB8 */
  0x0020,   /* U+5FB9 */
  0x0020,   /* U+5FBA */
  0x0020,   /* U+5FBB */
  0x0020,   /* U+5FBC */
  0x0020,   /* U+5FBD */
  0x0020,   /* U+5FBE */
  0x0020,   /* U+5FBF */
  0x0020,   /* U+5FC0 */
  0x0020,   /* U+5FC1 */
  0x0020,   /* U+5FC2 */
  0x0020,   /* U+5FC3 */
  0x0020,   /* U+5FC4 */
  0x0020,   /* U+5FC5 */
  0x0020,   /* U+5FC6 */
  0x0020,   /* U+5FC7 */
  0x0020,   /* U+5FC8 */
  0x0020,   /* U+5FC9 */
  0x0020,   /* U+5FCA */
  0x0020,   /* U+5FCB */
  0x0020,   /* U+5FCC */
  0x0020,   /* U+5FCD */
  0x0020,   /* U+5FCE */
  0x0020,   /* U+5FCF */
  0x0020,   /* U+5FD0 */
  0x0020,   /* U+5FD1 */
  0x0020,   /* U+5FD2 */
  0x0020,   /* U+5FD3 */
  0x0020,   /* U+5FD4 */
  0x0020,   /* U+5FD5 */
  0x0020,   /* U+5FD6 */
  0x0020,   /* U+5FD7 */
  0x0020,   /* U+5FD8 */
  0x0020,   /* U+5FD9 */
  0x0020,   /* U+5FDA */
  0x0020,   /* U+5FDB */
  0x0020,   /* U+5FDC */
  0x0020,   /* U+5FDD */
  0x0020,   /* U+5FDE */
  0x0020,   /* U+5FDF */
  0x0020,   /* U+5FE0 */
  0x0020,   /* U+5FE1 */
  0x0020,   /* U+5FE2 */
  0x0020,   /* U+5FE3 */
  0x0020,   /* U+5FE4 */
  0x0020,   /* U+5FE5 */
  0x0020,   /* U+5FE6 */
  0x0020,   /* U+5FE7 */
  0x0020,   /* U+5FE8 */
  0x0020,   /* U+5FE9 */
  0x0020,   /* U+5FEA */
  0x0020,   /* U+5FEB */
  0x0020,   /* U+5FEC */
  0x0020,   /* U+5FED */
  0x0020,   /* U+5FEE */
  0x0020,   /* U+5FEF */
  0x0020,   /* U+5FF0 */
  0x0020,   /* U+5FF1 */
  0x0020,   /* U+5FF2 */
  0x0020,   /* U+5FF3 */
  0x0020,   /* U+5FF4 */
  0x0020,   /* U+5FF5 */
  0x0020,   /* U+5FF6 */
  0x0020,   /* U+5FF7 */
  0x0020,   /* U+5FF8 */
  0x0020,   /* U+5FF9 */
  0x0020,   /* U+5FFA */
  0x0020,   /* U+5FFB */
  0x0020,   /* U+5FFC */
  0x0020,   /* U+5FFD */
  0x0020,   /* U+5FFE */
  0x0020,   /* U+5FFF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+5F00 */
  0x0002,   /* U+5F01 */
  0x0002,   /* U+5F02 */
  0x0002,   /* U+5F03 */
  0x0002,   /* U+5F04 */
  0x0002,   /* U+5F05 */
  0x0002,   /* U+5F06 */
  0x0002,   /* U+5F07 */
  0x0002,   /* U+5F08 */
  0x0002,   /* U+5F09 */
  0x0002,   /* U+5F0A */
  0x0002,   /* U+5F0B */
  0x0002,   /* U+5F0C */
  0x0002,   /* U+5F0D */
  0x0002,   /* U+5F0E */
  0x0002,   /* U+5F0F */
  0x0002,   /* U+5F10 */
  0x0002,   /* U+5F11 */
  0x0002,   /* U+5F12 */
  0x0002,   /* U+5F13 */
  0x0002,   /* U+5F14 */
  0x0002,   /* U+5F15 */
  0x0002,   /* U+5F16 */
  0x0002,   /* U+5F17 */
  0x0002,   /* U+5F18 */
  0x0002,   /* U+5F19 */
  0x0002,   /* U+5F1A */
  0x0002,   /* U+5F1B */
  0x0002,   /* U+5F1C */
  0x0002,   /* U+5F1D */
  0x0002,   /* U+5F1E */
  0x0002,   /* U+5F1F */
  0x0002,   /* U+5F20 */
  0x0002,   /* U+5F21 */
  0x0002,   /* U+5F22 */
  0x0002,   /* U+5F23 */
  0x0002,   /* U+5F24 */
  0x0002,   /* U+5F25 */
  0x0002,   /* U+5F26 */
  0x0002,   /* U+5F27 */
  0x0002,   /* U+5F28 */
  0x0002,   /* U+5F29 */
  0x0002,   /* U+5F2A */
  0x0002,   /* U+5F2B */
  0x0002,   /* U+5F2C */
  0x0002,   /* U+5F2D */
  0x0002,   /* U+5F2E */
  0x0002,   /* U+5F2F */
  0x0002,   /* U+5F30 */
  0x0002,   /* U+5F31 */
  0x0002,   /* U+5F32 */
  0x0002,   /* U+5F33 */
  0x0002,   /* U+5F34 */
  0x0002,   /* U+5F35 */
  0x0002,   /* U+5F36 */
  0x0002,   /* U+5F37 */
  0x0002,   /* U+5F38 */
  0x0002,   /* U+5F39 */
  0x0002,   /* U+5F3A */
  0x0002,   /* U+5F3B */
  0x0002,   /* U+5F3C */
  0x0002,   /* U+5F3D */
  0x0002,   /* U+5F3E */
  0x0002,   /* U+5F3F */
  0x0002,   /* U+5F40 */
  0x0002,   /* U+5F41 */
  0x0002,   /* U+5F42 */
  0x0002,   /* U+5F43 */
  0x0002,   /* U+5F44 */
  0x0002,   /* U+5F45 */
  0x0002,   /* U+5F46 */
  0x0002,   /* U+5F47 */
  0x0002,   /* U+5F48 */
  0x0002,   /* U+5F49 */
  0x0002,   /* U+5F4A */
  0x0002,   /* U+5F4B */
  0x0002,   /* U+5F4C */
  0x0002,   /* U+5F4D */
  0x0002,   /* U+5F4E */
  0x0002,   /* U+5F4F */
  0x0002,   /* U+5F50 */
  0x0002,   /* U+5F51 */
  0x0002,   /* U+5F52 */
  0x0002,   /* U+5F53 */
  0x0002,   /* U+5F54 */
  0x0002,   /* U+5F55 */
  0x0002,   /* U+5F56 */
  0x0002,   /* U+5F57 */
  0x0002,   /* U+5F58 */
  0x0002,   /* U+5F59 */
  0x0002,   /* U+5F5A */
  0x0002,   /* U+5F5B */
  0x0002,   /* U+5F5C */
  0x0002,   /* U+5F5D */
  0x0002,   /* U+5F5E */
  0x0002,   /* U+5F5F */
  0x0002,   /* U+5F60 */
  0x0002,   /* U+5F61 */
  0x0002,   /* U+5F62 */
  0x0002,   /* U+5F63 */
  0x0002,   /* U+5F64 */
  0x0002,   /* U+5F65 */
  0x0002,   /* U+5F66 */
  0x0002,   /* U+5F67 */
  0x0002,   /* U+5F68 */
  0x0002,   /* U+5F69 */
  0x0002,   /* U+5F6A */
  0x0002,   /* U+5F6B */
  0x0002,   /* U+5F6C */
  0x0002,   /* U+5F6D */
  0x0002,   /* U+5F6E */
  0x0002,   /* U+5F6F */
  0x0002,   /* U+5F70 */
  0x0002,   /* U+5F71 */
  0x0002,   /* U+5F72 */
  0x0002,   /* U+5F73 */
  0x0002,   /* U+5F74 */
  0x0002,   /* U+5F75 */
  0x0002,   /* U+5F76 */
  0x0002,   /* U+5F77 */
  0x0002,   /* U+5F78 */
  0x0002,   /* U+5F79 */
  0x0002,   /* U+5F7A */
  0x0002,   /* U+5F7B */
  0x0002,   /* U+5F7C */
  0x0002,   /* U+5F7D */
  0x0002,   /* U+5F7E */
  0x0002,   /* U+5F7F */
  0x0002,   /* U+5F80 */
  0x0002,   /* U+5F81 */
  0x0002,   /* U+5F82 */
  0x0002,   /* U+5F83 */
  0x0002,   /* U+5F84 */
  0x0002,   /* U+5F85 */
  0x0002,   /* U+5F86 */
  0x0002,   /* U+5F87 */
  0x0002,   /* U+5F88 */
  0x0002,   /* U+5F89 */
  0x0002,   /* U+5F8A */
  0x0002,   /* U+5F8B */
  0x0002,   /* U+5F8C */
  0x0002,   /* U+5F8D */
  0x0002,   /* U+5F8E */
  0x0002,   /* U+5F8F */
  0x0002,   /* U+5F90 */
  0x0002,   /* U+5F91 */
  0x0002,   /* U+5F92 */
  0x0002,   /* U+5F93 */
  0x0002,   /* U+5F94 */
  0x0002,   /* U+5F95 */
  0x0002,   /* U+5F96 */
  0x0002,   /* U+5F97 */
  0x0002,   /* U+5F98 */
  0x0002,   /* U+5F99 */
  0x0002,   /* U+5F9A */
  0x0002,   /* U+5F9B */
  0x0002,   /* U+5F9C */
  0x0002,   /* U+5F9D */
  0x0002,   /* U+5F9E */
  0x0002,   /* U+5F9F */
  0x0002,   /* U+5FA0 */
  0x0002,   /* U+5FA1 */
  0x0002,   /* U+5FA2 */
  0x0002,   /* U+5FA3 */
  0x0002,   /* U+5FA4 */
  0x0002,   /* U+5FA5 */
  0x0002,   /* U+5FA6 */
  0x0002,   /* U+5FA7 */
  0x0002,   /* U+5FA8 */
  0x0002,   /* U+5FA9 */
  0x0002,   /* U+5FAA */
  0x0002,   /* U+5FAB */
  0x0002,   /* U+5FAC */
  0x0002,   /* U+5FAD */
  0x0002,   /* U+5FAE */
  0x0002,   /* U+5FAF */
  0x0002,   /* U+5FB0 */
  0x0002,   /* U+5FB1 */
  0x0002,   /* U+5FB2 */
  0x0002,   /* U+5FB3 */
  0x0002,   /* U+5FB4 */
  0x0002,   /* U+5FB5 */
  0x0002,   /* U+5FB6 */
  0x0002,   /* U+5FB7 */
  0x0002,   /* U+5FB8 */
  0x0002,   /* U+5FB9 */
  0x0002,   /* U+5FBA */
  0x0002,   /* U+5FBB */
  0x0002,   /* U+5FBC */
  0x0002,   /* U+5FBD */
  0x0002,   /* U+5FBE */
  0x0002,   /* U+5FBF */
  0x0002,   /* U+5FC0 */
  0x0002,   /* U+5FC1 */
  0x0002,   /* U+5FC2 */
  0x0002,   /* U+5FC3 */
  0x0002,   /* U+5FC4 */
  0x0002,   /* U+5FC5 */
  0x0002,   /* U+5FC6 */
  0x0002,   /* U+5FC7 */
  0x0002,   /* U+5FC8 */
  0x0002,   /* U+5FC9 */
  0x0002,   /* U+5FCA */
  0x0002,   /* U+5FCB */
  0x0002,   /* U+5FCC */
  0x0002,   /* U+5FCD */
  0x0002,   /* U+5FCE */
  0x0002,   /* U+5FCF */
  0x0002,   /* U+5FD0 */
  0x0002,   /* U+5FD1 */
  0x0002,   /* U+5FD2 */
  0x0002,   /* U+5FD3 */
  0x0002,   /* U+5FD4 */
  0x0002,   /* U+5FD5 */
  0x0002,   /* U+5FD6 */
  0x0002,   /* U+5FD7 */
  0x0002,   /* U+5FD8 */
  0x0002,   /* U+5FD9 */
  0x0002,   /* U+5FDA */
  0x0002,   /* U+5FDB */
  0x0002,   /* U+5FDC */
  0x0002,   /* U+5FDD */
  0x0002,   /* U+5FDE */
  0x0002,   /* U+5FDF */
  0x0002,   /* U+5FE0 */
  0x0002,   /* U+5FE1 */
  0x0002,   /* U+5FE2 */
  0x0002,   /* U+5FE3 */
  0x0002,   /* U+5FE4 */
  0x0002,   /* U+5FE5 */
  0x0002,   /* U+5FE6 */
  0x0002,   /* U+5FE7 */
  0x0002,   /* U+5FE8 */
  0x0002,   /* U+5FE9 */
  0x0002,   /* U+5FEA */
  0x0002,   /* U+5FEB */
  0x0002,   /* U+5FEC */
  0x0002,   /* U+5FED */
  0x0002,   /* U+5FEE */
  0x0002,   /* U+5FEF */
  0x0002,   /* U+5FF0 */
  0x0002,   /* U+5FF1 */
  0x0002,   /* U+5FF2 */
  0x0002,   /* U+5FF3 */
  0x0002,   /* U+5FF4 */
  0x0002,   /* U+5FF5 */
  0x0002,   /* U+5FF6 */
  0x0002,   /* U+5FF7 */
  0x0002,   /* U+5FF8 */
  0x0002,   /* U+5FF9 */
  0x0002,   /* U+5FFA */
  0x0002,   /* U+5FFB */
  0x0002,   /* U+5FFC */
  0x0002,   /* U+5FFD */
  0x0002,   /* U+5FFE */
  0x0002,   /* U+5FFF */

  /* Primary weight 2 for each character. */
  0xDF00,   /* U+5F00 */
  0x0000,   /* U+5F01 */
  0xDF02,   /* U+5F02 */
  0x0000,   /* U+5F03 */
  0x0000,   /* U+5F04 */
  0xDF05,   /* U+5F05 */
  0xDF06,   /* U+5F06 */
  0xDF07,   /* U+5F07 */
  0xDF08,   /* U+5F08 */
  0x0000,   /* U+5F09 */
  0x0000,   /* U+5F0A */
  0x0000,   /* U+5F0B */
  0x0000,   /* U+5F0C */
  0x0000,   /* U+5F0D */
  0xDF0E,   /* U+5F0E */
  0x0000,   /* U+5F0F */
  0x0000,   /* U+5F10 */
  0x0000,   /* U+5F11 */
  0xDF12,   /* U+5F12 */
  0x0000,   /* U+5F13 */
  0x0000,   /* U+5F14 */
  0x0000,   /* U+5F15 */
  0x0000,   /* U+5F16 */
  0x0000,   /* U+5F17 */
  0x0000,   /* U+5F18 */
  0xDF19,   /* U+5F19 */
  0xDF1A,   /* U+5F1A */
  0x0000,   /* U+5F1B */
  0xDF1C,   /* U+5F1C */
  0xDF1D,   /* U+5F1D */
  0xDF1E,   /* U+5F1E */
  0x0000,   /* U+5F1F */
  0xDF20,   /* U+5F20 */
  0xDF21,   /* U+5F21 */
  0xDF22,   /* U+5F22 */
  0xDF23,   /* U+5F23 */
  0xDF24,   /* U+5F24 */
  0x0000,   /* U+5F25 */
  0x0000,   /* U+5F26 */
  0x0000,   /* U+5F27 */
  0xDF28,   /* U+5F28 */
  0x0000,   /* U+5F29 */
  0xDF2A,   /* U+5F2A */
  0xDF2B,   /* U+5F2B */
  0xDF2C,   /* U+5F2C */
  0x0000,   /* U+5F2D */
  0xDF2E,   /* U+5F2E */
  0x0000,   /* U+5F2F */
  0xDF30,   /* U+5F30 */
  0x0000,   /* U+5F31 */
  0xDF32,   /* U+5F32 */
  0xDF33,   /* U+5F33 */
  0xDF34,   /* U+5F34 */
  0x0000,   /* U+5F35 */
  0xDF36,   /* U+5F36 */
  0x0000,   /* U+5F37 */
  0x0000,   /* U+5F38 */
  0xDF39,   /* U+5F39 */
  0xDF3A,   /* U+5F3A */
  0xDF3B,   /* U+5F3B */
  0x0000,   /* U+5F3C */
  0xDF3D,   /* U+5F3D */
  0x0000,   /* U+5F3E */
  0xDF3F,   /* U+5F3F */
  0xDF40,   /* U+5F40 */
  0x0000,   /* U+5F41 */
  0xDF42,   /* U+5F42 */
  0xDF43,   /* U+5F43 */
  0xDF44,   /* U+5F44 */
  0xDF45,   /* U+5F45 */
  0xDF46,   /* U+5F46 */
  0xDF47,   /* U+5F47 */
  0x0000,   /* U+5F48 */
  0xDF49,   /* U+5F49 */
  0x0000,   /* U+5F4A */
  0xDF4B,   /* U+5F4B */
  0x0000,   /* U+5F4C */
  0xDF4D,   /* U+5F4D */
  0x0000,   /* U+5F4E */
  0xDF4F,   /* U+5F4F */
  0xDF50,   /* U+5F50 */
  0x0000,   /* U+5F51 */
  0xDF52,   /* U+5F52 */
  0x0000,   /* U+5F53 */
  0xDF54,   /* U+5F54 */
  0xDF55,   /* U+5F55 */
  0x0000,   /* U+5F56 */
  0x0000,   /* U+5F57 */
  0xDF58,   /* U+5F58 */
  0x0000,   /* U+5F59 */
  0xDF5A,   /* U+5F5A */
  0xDF5B,   /* U+5F5B */
  0x0000,   /* U+5F5C */
  0x0000,   /* U+5F5D */
  0xDF5E,   /* U+5F5E */
  0xDF5F,   /* U+5F5F */
  0xDF60,   /* U+5F60 */
  0x0000,   /* U+5F61 */
  0x0000,   /* U+5F62 */
  0xDF63,   /* U+5F63 */
  0xDF64,   /* U+5F64 */
  0xDF65,   /* U+5F65 */
  0x0000,   /* U+5F66 */
  0xDF67,   /* U+5F67 */
  0xDF68,   /* U+5F68 */
  0x0000,   /* U+5F69 */
  0x0000,   /* U+5F6A */
  0x0000,   /* U+5F6B */
  0x0000,   /* U+5F6C */
  0x0000,   /* U+5F6D */
  0xDF6E,   /* U+5F6E */
  0xDF6F,   /* U+5F6F */
  0x0000,   /* U+5F70 */
  0x0000,   /* U+5F71 */
  0xDF72,   /* U+5F72 */
  0x0000,   /* U+5F73 */
  0xDF74,   /* U+5F74 */
  0xDF75,   /* U+5F75 */
  0xDF76,   /* U+5F76 */
  0x0000,   /* U+5F77 */
  0xDF78,   /* U+5F78 */
  0x0000,   /* U+5F79 */
  0xDF7A,   /* U+5F7A */
  0xDF7B,   /* U+5F7B */
  0x0000,   /* U+5F7C */
  0xDF7D,   /* U+5F7D */
  0xDF7E,   /* U+5F7E */
  0x0000,   /* U+5F7F */
  0x0000,   /* U+5F80 */
  0x0000,   /* U+5F81 */
  0x0000,   /* U+5F82 */
  0x0000,   /* U+5F83 */
  0x0000,   /* U+5F84 */
  0x0000,   /* U+5F85 */
  0xDF86,   /* U+5F86 */
  0x0000,   /* U+5F87 */
  0x0000,   /* U+5F88 */
  0xDF89,   /* U+5F89 */
  0x0000,   /* U+5F8A */
  0x0000,   /* U+5F8B */
  0x0000,   /* U+5F8C */
  0xDF8D,   /* U+5F8D */
  0xDF8E,   /* U+5F8E */
  0xDF8F,   /* U+5F8F */
  0x0000,   /* U+5F90 */
  0x0000,   /* U+5F91 */
  0x0000,   /* U+5F92 */
  0x0000,   /* U+5F93 */
  0xDF94,   /* U+5F94 */
  0xDF95,   /* U+5F95 */
  0xDF96,   /* U+5F96 */
  0x0000,   /* U+5F97 */
  0x0000,   /* U+5F98 */
  0x0000,   /* U+5F99 */
  0xDF9A,   /* U+5F9A */
  0xDF9B,   /* U+5F9B */
  0xDF9C,   /* U+5F9C */
  0xDF9D,   /* U+5F9D */
  0x0000,   /* U+5F9E */
  0xDF9F,   /* U+5F9F */
  0x0000,   /* U+5FA0 */
  0x0000,   /* U+5FA1 */
  0xDFA2,   /* U+5FA2 */
  0xDFA3,   /* U+5FA3 */
  0xDFA4,   /* U+5FA4 */
  0xDFA5,   /* U+5FA5 */
  0xDFA6,   /* U+5FA6 */
  0xDFA7,   /* U+5FA7 */
  0x0000,   /* U+5FA8 */
  0x0000,   /* U+5FA9 */
  0x0000,   /* U+5FAA */
  0xDFAB,   /* U+5FAB */
  0xDFAC,   /* U+5FAC */
  0x0000,   /* U+5FAD */
  0x0000,   /* U+5FAE */
  0xDFAF,   /* U+5FAF */
  0xDFB0,   /* U+5FB0 */
  0xDFB1,   /* U+5FB1 */
  0xDFB2,   /* U+5FB2 */
  0x0000,   /* U+5FB3 */
  0x0000,   /* U+5FB4 */
  0xDFB5,   /* U+5FB5 */
  0xDFB6,   /* U+5FB6 */
  0xDFB7,   /* U+5FB7 */
  0xDFB8,   /* U+5FB8 */
  0x0000,   /* U+5FB9 */
  0xDFBA,   /* U+5FBA */
  0xDFBB,   /* U+5FBB */
  0x0000,   /* U+5FBC */
  0x0000,   /* U+5FBD */
  0xDFBE,   /* U+5FBE */
  0xDFBF,   /* U+5FBF */
  0xDFC0,   /* U+5FC0 */
  0xDFC1,   /* U+5FC1 */
  0xDFC2,   /* U+5FC2 */
  0x0000,   /* U+5FC3 */
  0xDFC4,   /* U+5FC4 */
  0x0000,   /* U+5FC5 */
  0xDFC6,   /* U+5FC6 */
  0xDFC7,   /* U+5FC7 */
  0xDFC8,   /* U+5FC8 */
  0xDFC9,   /* U+5FC9 */
  0xDFCA,   /* U+5FCA */
  0xDFCB,   /* U+5FCB */
  0x0000,   /* U+5FCC */
  0x0000,   /* U+5FCD */
  0xDFCE,   /* U+5FCE */
  0xDFCF,   /* U+5FCF */
  0xDFD0,   /* U+5FD0 */
  0xDFD1,   /* U+5FD1 */
  0xDFD2,   /* U+5FD2 */
  0xDFD3,   /* U+5FD3 */
  0xDFD4,   /* U+5FD4 */
  0xDFD5,   /* U+5FD5 */
  0x0000,   /* U+5FD6 */
  0x0000,   /* U+5FD7 */
  0x0000,   /* U+5FD8 */
  0x0000,   /* U+5FD9 */
  0xDFDA,   /* U+5FDA */
  0xDFDB,   /* U+5FDB */
  0x0000,   /* U+5FDC */
  0x0000,   /* U+5FDD */
  0xDFDE,   /* U+5FDE */
  0xDFDF,   /* U+5FDF */
  0x0000,   /* U+5FE0 */
  0xDFE1,   /* U+5FE1 */
  0xDFE2,   /* U+5FE2 */
  0xDFE3,   /* U+5FE3 */
  0x0000,   /* U+5FE4 */
  0xDFE5,   /* U+5FE5 */
  0xDFE6,   /* U+5FE6 */
  0xDFE7,   /* U+5FE7 */
  0xDFE8,   /* U+5FE8 */
  0xDFE9,   /* U+5FE9 */
  0xDFEA,   /* U+5FEA */
  0x0000,   /* U+5FEB */
  0xDFEC,   /* U+5FEC */
  0xDFED,   /* U+5FED */
  0xDFEE,   /* U+5FEE */
  0xDFEF,   /* U+5FEF */
  0x0000,   /* U+5FF0 */
  0x0000,   /* U+5FF1 */
  0xDFF2,   /* U+5FF2 */
  0xDFF3,   /* U+5FF3 */
  0xDFF4,   /* U+5FF4 */
  0x0000,   /* U+5FF5 */
  0xDFF6,   /* U+5FF6 */
  0xDFF7,   /* U+5FF7 */
  0x0000,   /* U+5FF8 */
  0xDFF9,   /* U+5FF9 */
  0xDFFA,   /* U+5FFA */
  0x0000,   /* U+5FFB */
  0xDFFC,   /* U+5FFC */
  0x0000,   /* U+5FFD */
  0xDFFE,   /* U+5FFE */
  0x0000,   /* U+5FFF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+5F00 */
  0x0000,   /* U+5F01 */
  0x0000,   /* U+5F02 */
  0x0000,   /* U+5F03 */
  0x0000,   /* U+5F04 */
  0x0000,   /* U+5F05 */
  0x0000,   /* U+5F06 */
  0x0000,   /* U+5F07 */
  0x0000,   /* U+5F08 */
  0x0000,   /* U+5F09 */
  0x0000,   /* U+5F0A */
  0x0000,   /* U+5F0B */
  0x0000,   /* U+5F0C */
  0x0000,   /* U+5F0D */
  0x0000,   /* U+5F0E */
  0x0000,   /* U+5F0F */
  0x0000,   /* U+5F10 */
  0x0000,   /* U+5F11 */
  0x0000,   /* U+5F12 */
  0x0000,   /* U+5F13 */
  0x0000,   /* U+5F14 */
  0x0000,   /* U+5F15 */
  0x0000,   /* U+5F16 */
  0x0000,   /* U+5F17 */
  0x0000,   /* U+5F18 */
  0x0000,   /* U+5F19 */
  0x0000,   /* U+5F1A */
  0x0000,   /* U+5F1B */
  0x0000,   /* U+5F1C */
  0x0000,   /* U+5F1D */
  0x0000,   /* U+5F1E */
  0x0000,   /* U+5F1F */
  0x0000,   /* U+5F20 */
  0x0000,   /* U+5F21 */
  0x0000,   /* U+5F22 */
  0x0000,   /* U+5F23 */
  0x0000,   /* U+5F24 */
  0x0000,   /* U+5F25 */
  0x0000,   /* U+5F26 */
  0x0000,   /* U+5F27 */
  0x0000,   /* U+5F28 */
  0x0000,   /* U+5F29 */
  0x0000,   /* U+5F2A */
  0x0000,   /* U+5F2B */
  0x0000,   /* U+5F2C */
  0x0000,   /* U+5F2D */
  0x0000,   /* U+5F2E */
  0x0000,   /* U+5F2F */
  0x0000,   /* U+5F30 */
  0x0000,   /* U+5F31 */
  0x0000,   /* U+5F32 */
  0x0000,   /* U+5F33 */
  0x0000,   /* U+5F34 */
  0x0000,   /* U+5F35 */
  0x0000,   /* U+5F36 */
  0x0000,   /* U+5F37 */
  0x0000,   /* U+5F38 */
  0x0000,   /* U+5F39 */
  0x0000,   /* U+5F3A */
  0x0000,   /* U+5F3B */
  0x0000,   /* U+5F3C */
  0x0000,   /* U+5F3D */
  0x0000,   /* U+5F3E */
  0x0000,   /* U+5F3F */
  0x0000,   /* U+5F40 */
  0x0000,   /* U+5F41 */
  0x0000,   /* U+5F42 */
  0x0000,   /* U+5F43 */
  0x0000,   /* U+5F44 */
  0x0000,   /* U+5F45 */
  0x0000,   /* U+5F46 */
  0x0000,   /* U+5F47 */
  0x0000,   /* U+5F48 */
  0x0000,   /* U+5F49 */
  0x0000,   /* U+5F4A */
  0x0000,   /* U+5F4B */
  0x0000,   /* U+5F4C */
  0x0000,   /* U+5F4D */
  0x0000,   /* U+5F4E */
  0x0000,   /* U+5F4F */
  0x0000,   /* U+5F50 */
  0x0000,   /* U+5F51 */
  0x0000,   /* U+5F52 */
  0x0000,   /* U+5F53 */
  0x0000,   /* U+5F54 */
  0x0000,   /* U+5F55 */
  0x0000,   /* U+5F56 */
  0x0000,   /* U+5F57 */
  0x0000,   /* U+5F58 */
  0x0000,   /* U+5F59 */
  0x0000,   /* U+5F5A */
  0x0000,   /* U+5F5B */
  0x0000,   /* U+5F5C */
  0x0000,   /* U+5F5D */
  0x0000,   /* U+5F5E */
  0x0000,   /* U+5F5F */
  0x0000,   /* U+5F60 */
  0x0000,   /* U+5F61 */
  0x0000,   /* U+5F62 */
  0x0000,   /* U+5F63 */
  0x0000,   /* U+5F64 */
  0x0000,   /* U+5F65 */
  0x0000,   /* U+5F66 */
  0x0000,   /* U+5F67 */
  0x0000,   /* U+5F68 */
  0x0000,   /* U+5F69 */
  0x0000,   /* U+5F6A */
  0x0000,   /* U+5F6B */
  0x0000,   /* U+5F6C */
  0x0000,   /* U+5F6D */
  0x0000,   /* U+5F6E */
  0x0000,   /* U+5F6F */
  0x0000,   /* U+5F70 */
  0x0000,   /* U+5F71 */
  0x0000,   /* U+5F72 */
  0x0000,   /* U+5F73 */
  0x0000,   /* U+5F74 */
  0x0000,   /* U+5F75 */
  0x0000,   /* U+5F76 */
  0x0000,   /* U+5F77 */
  0x0000,   /* U+5F78 */
  0x0000,   /* U+5F79 */
  0x0000,   /* U+5F7A */
  0x0000,   /* U+5F7B */
  0x0000,   /* U+5F7C */
  0x0000,   /* U+5F7D */
  0x0000,   /* U+5F7E */
  0x0000,   /* U+5F7F */
  0x0000,   /* U+5F80 */
  0x0000,   /* U+5F81 */
  0x0000,   /* U+5F82 */
  0x0000,   /* U+5F83 */
  0x0000,   /* U+5F84 */
  0x0000,   /* U+5F85 */
  0x0000,   /* U+5F86 */
  0x0000,   /* U+5F87 */
  0x0000,   /* U+5F88 */
  0x0000,   /* U+5F89 */
  0x0000,   /* U+5F8A */
  0x0000,   /* U+5F8B */
  0x0000,   /* U+5F8C */
  0x0000,   /* U+5F8D */
  0x0000,   /* U+5F8E */
  0x0000,   /* U+5F8F */
  0x0000,   /* U+5F90 */
  0x0000,   /* U+5F91 */
  0x0000,   /* U+5F92 */
  0x0000,   /* U+5F93 */
  0x0000,   /* U+5F94 */
  0x0000,   /* U+5F95 */
  0x0000,   /* U+5F96 */
  0x0000,   /* U+5F97 */
  0x0000,   /* U+5F98 */
  0x0000,   /* U+5F99 */
  0x0000,   /* U+5F9A */
  0x0000,   /* U+5F9B */
  0x0000,   /* U+5F9C */
  0x0000,   /* U+5F9D */
  0x0000,   /* U+5F9E */
  0x0000,   /* U+5F9F */
  0x0000,   /* U+5FA0 */
  0x0000,   /* U+5FA1 */
  0x0000,   /* U+5FA2 */
  0x0000,   /* U+5FA3 */
  0x0000,   /* U+5FA4 */
  0x0000,   /* U+5FA5 */
  0x0000,   /* U+5FA6 */
  0x0000,   /* U+5FA7 */
  0x0000,   /* U+5FA8 */
  0x0000,   /* U+5FA9 */
  0x0000,   /* U+5FAA */
  0x0000,   /* U+5FAB */
  0x0000,   /* U+5FAC */
  0x0000,   /* U+5FAD */
  0x0000,   /* U+5FAE */
  0x0000,   /* U+5FAF */
  0x0000,   /* U+5FB0 */
  0x0000,   /* U+5FB1 */
  0x0000,   /* U+5FB2 */
  0x0000,   /* U+5FB3 */
  0x0000,   /* U+5FB4 */
  0x0000,   /* U+5FB5 */
  0x0000,   /* U+5FB6 */
  0x0000,   /* U+5FB7 */
  0x0000,   /* U+5FB8 */
  0x0000,   /* U+5FB9 */
  0x0000,   /* U+5FBA */
  0x0000,   /* U+5FBB */
  0x0000,   /* U+5FBC */
  0x0000,   /* U+5FBD */
  0x0000,   /* U+5FBE */
  0x0000,   /* U+5FBF */
  0x0000,   /* U+5FC0 */
  0x0000,   /* U+5FC1 */
  0x0000,   /* U+5FC2 */
  0x0000,   /* U+5FC3 */
  0x0000,   /* U+5FC4 */
  0x0000,   /* U+5FC5 */
  0x0000,   /* U+5FC6 */
  0x0000,   /* U+5FC7 */
  0x0000,   /* U+5FC8 */
  0x0000,   /* U+5FC9 */
  0x0000,   /* U+5FCA */
  0x0000,   /* U+5FCB */
  0x0000,   /* U+5FCC */
  0x0000,   /* U+5FCD */
  0x0000,   /* U+5FCE */
  0x0000,   /* U+5FCF */
  0x0000,   /* U+5FD0 */
  0x0000,   /* U+5FD1 */
  0x0000,   /* U+5FD2 */
  0x0000,   /* U+5FD3 */
  0x0000,   /* U+5FD4 */
  0x0000,   /* U+5FD5 */
  0x0000,   /* U+5FD6 */
  0x0000,   /* U+5FD7 */
  0x0000,   /* U+5FD8 */
  0x0000,   /* U+5FD9 */
  0x0000,   /* U+5FDA */
  0x0000,   /* U+5FDB */
  0x0000,   /* U+5FDC */
  0x0000,   /* U+5FDD */
  0x0000,   /* U+5FDE */
  0x0000,   /* U+5FDF */
  0x0000,   /* U+5FE0 */
  0x0000,   /* U+5FE1 */
  0x0000,   /* U+5FE2 */
  0x0000,   /* U+5FE3 */
  0x0000,   /* U+5FE4 */
  0x0000,   /* U+5FE5 */
  0x0000,   /* U+5FE6 */
  0x0000,   /* U+5FE7 */
  0x0000,   /* U+5FE8 */
  0x0000,   /* U+5FE9 */
  0x0000,   /* U+5FEA */
  0x0000,   /* U+5FEB */
  0x0000,   /* U+5FEC */
  0x0000,   /* U+5FED */
  0x0000,   /* U+5FEE */
  0x0000,   /* U+5FEF */
  0x0000,   /* U+5FF0 */
  0x0000,   /* U+5FF1 */
  0x0000,   /* U+5FF2 */
  0x0000,   /* U+5FF3 */
  0x0000,   /* U+5FF4 */
  0x0000,   /* U+5FF5 */
  0x0000,   /* U+5FF6 */
  0x0000,   /* U+5FF7 */
  0x0000,   /* U+5FF8 */
  0x0000,   /* U+5FF9 */
  0x0000,   /* U+5FFA */
  0x0000,   /* U+5FFB */
  0x0000,   /* U+5FFC */
  0x0000,   /* U+5FFD */
  0x0000,   /* U+5FFE */
  0x0000,   /* U+5FFF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+5F00 */
  0x0000,   /* U+5F01 */
  0x0000,   /* U+5F02 */
  0x0000,   /* U+5F03 */
  0x0000,   /* U+5F04 */
  0x0000,   /* U+5F05 */
  0x0000,   /* U+5F06 */
  0x0000,   /* U+5F07 */
  0x0000,   /* U+5F08 */
  0x0000,   /* U+5F09 */
  0x0000,   /* U+5F0A */
  0x0000,   /* U+5F0B */
  0x0000,   /* U+5F0C */
  0x0000,   /* U+5F0D */
  0x0000,   /* U+5F0E */
  0x0000,   /* U+5F0F */
  0x0000,   /* U+5F10 */
  0x0000,   /* U+5F11 */
  0x0000,   /* U+5F12 */
  0x0000,   /* U+5F13 */
  0x0000,   /* U+5F14 */
  0x0000,   /* U+5F15 */
  0x0000,   /* U+5F16 */
  0x0000,   /* U+5F17 */
  0x0000,   /* U+5F18 */
  0x0000,   /* U+5F19 */
  0x0000,   /* U+5F1A */
  0x0000,   /* U+5F1B */
  0x0000,   /* U+5F1C */
  0x0000,   /* U+5F1D */
  0x0000,   /* U+5F1E */
  0x0000,   /* U+5F1F */
  0x0000,   /* U+5F20 */
  0x0000,   /* U+5F21 */
  0x0000,   /* U+5F22 */
  0x0000,   /* U+5F23 */
  0x0000,   /* U+5F24 */
  0x0000,   /* U+5F25 */
  0x0000,   /* U+5F26 */
  0x0000,   /* U+5F27 */
  0x0000,   /* U+5F28 */
  0x0000,   /* U+5F29 */
  0x0000,   /* U+5F2A */
  0x0000,   /* U+5F2B */
  0x0000,   /* U+5F2C */
  0x0000,   /* U+5F2D */
  0x0000,   /* U+5F2E */
  0x0000,   /* U+5F2F */
  0x0000,   /* U+5F30 */
  0x0000,   /* U+5F31 */
  0x0000,   /* U+5F32 */
  0x0000,   /* U+5F33 */
  0x0000,   /* U+5F34 */
  0x0000,   /* U+5F35 */
  0x0000,   /* U+5F36 */
  0x0000,   /* U+5F37 */
  0x0000,   /* U+5F38 */
  0x0000,   /* U+5F39 */
  0x0000,   /* U+5F3A */
  0x0000,   /* U+5F3B */
  0x0000,   /* U+5F3C */
  0x0000,   /* U+5F3D */
  0x0000,   /* U+5F3E */
  0x0000,   /* U+5F3F */
  0x0000,   /* U+5F40 */
  0x0000,   /* U+5F41 */
  0x0000,   /* U+5F42 */
  0x0000,   /* U+5F43 */
  0x0000,   /* U+5F44 */
  0x0000,   /* U+5F45 */
  0x0000,   /* U+5F46 */
  0x0000,   /* U+5F47 */
  0x0000,   /* U+5F48 */
  0x0000,   /* U+5F49 */
  0x0000,   /* U+5F4A */
  0x0000,   /* U+5F4B */
  0x0000,   /* U+5F4C */
  0x0000,   /* U+5F4D */
  0x0000,   /* U+5F4E */
  0x0000,   /* U+5F4F */
  0x0000,   /* U+5F50 */
  0x0000,   /* U+5F51 */
  0x0000,   /* U+5F52 */
  0x0000,   /* U+5F53 */
  0x0000,   /* U+5F54 */
  0x0000,   /* U+5F55 */
  0x0000,   /* U+5F56 */
  0x0000,   /* U+5F57 */
  0x0000,   /* U+5F58 */
  0x0000,   /* U+5F59 */
  0x0000,   /* U+5F5A */
  0x0000,   /* U+5F5B */
  0x0000,   /* U+5F5C */
  0x0000,   /* U+5F5D */
  0x0000,   /* U+5F5E */
  0x0000,   /* U+5F5F */
  0x0000,   /* U+5F60 */
  0x0000,   /* U+5F61 */
  0x0000,   /* U+5F62 */
  0x0000,   /* U+5F63 */
  0x0000,   /* U+5F64 */
  0x0000,   /* U+5F65 */
  0x0000,   /* U+5F66 */
  0x0000,   /* U+5F67 */
  0x0000,   /* U+5F68 */
  0x0000,   /* U+5F69 */
  0x0000,   /* U+5F6A */
  0x0000,   /* U+5F6B */
  0x0000,   /* U+5F6C */
  0x0000,   /* U+5F6D */
  0x0000,   /* U+5F6E */
  0x0000,   /* U+5F6F */
  0x0000,   /* U+5F70 */
  0x0000,   /* U+5F71 */
  0x0000,   /* U+5F72 */
  0x0000,   /* U+5F73 */
  0x0000,   /* U+5F74 */
  0x0000,   /* U+5F75 */
  0x0000,   /* U+5F76 */
  0x0000,   /* U+5F77 */
  0x0000,   /* U+5F78 */
  0x0000,   /* U+5F79 */
  0x0000,   /* U+5F7A */
  0x0000,   /* U+5F7B */
  0x0000,   /* U+5F7C */
  0x0000,   /* U+5F7D */
  0x0000,   /* U+5F7E */
  0x0000,   /* U+5F7F */
  0x0000,   /* U+5F80 */
  0x0000,   /* U+5F81 */
  0x0000,   /* U+5F82 */
  0x0000,   /* U+5F83 */
  0x0000,   /* U+5F84 */
  0x0000,   /* U+5F85 */
  0x0000,   /* U+5F86 */
  0x0000,   /* U+5F87 */
  0x0000,   /* U+5F88 */
  0x0000,   /* U+5F89 */
  0x0000,   /* U+5F8A */
  0x0000,   /* U+5F8B */
  0x0000,   /* U+5F8C */
  0x0000,   /* U+5F8D */
  0x0000,   /* U+5F8E */
  0x0000,   /* U+5F8F */
  0x0000,   /* U+5F90 */
  0x0000,   /* U+5F91 */
  0x0000,   /* U+5F92 */
  0x0000,   /* U+5F93 */
  0x0000,   /* U+5F94 */
  0x0000,   /* U+5F95 */
  0x0000,   /* U+5F96 */
  0x0000,   /* U+5F97 */
  0x0000,   /* U+5F98 */
  0x0000,   /* U+5F99 */
  0x0000,   /* U+5F9A */
  0x0000,   /* U+5F9B */
  0x0000,   /* U+5F9C */
  0x0000,   /* U+5F9D */
  0x0000,   /* U+5F9E */
  0x0000,   /* U+5F9F */
  0x0000,   /* U+5FA0 */
  0x0000,   /* U+5FA1 */
  0x0000,   /* U+5FA2 */
  0x0000,   /* U+5FA3 */
  0x0000,   /* U+5FA4 */
  0x0000,   /* U+5FA5 */
  0x0000,   /* U+5FA6 */
  0x0000,   /* U+5FA7 */
  0x0000,   /* U+5FA8 */
  0x0000,   /* U+5FA9 */
  0x0000,   /* U+5FAA */
  0x0000,   /* U+5FAB */
  0x0000,   /* U+5FAC */
  0x0000,   /* U+5FAD */
  0x0000,   /* U+5FAE */
  0x0000,   /* U+5FAF */
  0x0000,   /* U+5FB0 */
  0x0000,   /* U+5FB1 */
  0x0000,   /* U+5FB2 */
  0x0000,   /* U+5FB3 */
  0x0000,   /* U+5FB4 */
  0x0000,   /* U+5FB5 */
  0x0000,   /* U+5FB6 */
  0x0000,   /* U+5FB7 */
  0x0000,   /* U+5FB8 */
  0x0000,   /* U+5FB9 */
  0x0000,   /* U+5FBA */
  0x0000,   /* U+5FBB */
  0x0000,   /* U+5FBC */
  0x0000,   /* U+5FBD */
  0x0000,   /* U+5FBE */
  0x0000,   /* U+5FBF */
  0x0000,   /* U+5FC0 */
  0x0000,   /* U+5FC1 */
  0x0000,   /* U+5FC2 */
  0x0000,   /* U+5FC3 */
  0x0000,   /* U+5FC4 */
  0x0000,   /* U+5FC5 */
  0x0000,   /* U+5FC6 */
  0x0000,   /* U+5FC7 */
  0x0000,   /* U+5FC8 */
  0x0000,   /* U+5FC9 */
  0x0000,   /* U+5FCA */
  0x0000,   /* U+5FCB */
  0x0000,   /* U+5FCC */
  0x0000,   /* U+5FCD */
  0x0000,   /* U+5FCE */
  0x0000,   /* U+5FCF */
  0x0000,   /* U+5FD0 */
  0x0000,   /* U+5FD1 */
  0x0000,   /* U+5FD2 */
  0x0000,   /* U+5FD3 */
  0x0000,   /* U+5FD4 */
  0x0000,   /* U+5FD5 */
  0x0000,   /* U+5FD6 */
  0x0000,   /* U+5FD7 */
  0x0000,   /* U+5FD8 */
  0x0000,   /* U+5FD9 */
  0x0000,   /* U+5FDA */
  0x0000,   /* U+5FDB */
  0x0000,   /* U+5FDC */
  0x0000,   /* U+5FDD */
  0x0000,   /* U+5FDE */
  0x0000,   /* U+5FDF */
  0x0000,   /* U+5FE0 */
  0x0000,   /* U+5FE1 */
  0x0000,   /* U+5FE2 */
  0x0000,   /* U+5FE3 */
  0x0000,   /* U+5FE4 */
  0x0000,   /* U+5FE5 */
  0x0000,   /* U+5FE6 */
  0x0000,   /* U+5FE7 */
  0x0000,   /* U+5FE8 */
  0x0000,   /* U+5FE9 */
  0x0000,   /* U+5FEA */
  0x0000,   /* U+5FEB */
  0x0000,   /* U+5FEC */
  0x0000,   /* U+5FED */
  0x0000,   /* U+5FEE */
  0x0000,   /* U+5FEF */
  0x0000,   /* U+5FF0 */
  0x0000,   /* U+5FF1 */
  0x0000,   /* U+5FF2 */
  0x0000,   /* U+5FF3 */
  0x0000,   /* U+5FF4 */
  0x0000,   /* U+5FF5 */
  0x0000,   /* U+5FF6 */
  0x0000,   /* U+5FF7 */
  0x0000,   /* U+5FF8 */
  0x0000,   /* U+5FF9 */
  0x0000,   /* U+5FFA */
  0x0000,   /* U+5FFB */
  0x0000,   /* U+5FFC */
  0x0000,   /* U+5FFD */
  0x0000,   /* U+5FFE */
  0x0000,   /* U+5FFF */
};

uint16 ja_han_page60[]= {
  /* Number of CEs for each character. */
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1,
  1, 2, 1, 2, 2, 1, 1, 2, 2, 1, 2, 1, 1, 1, 2, 2,
  1, 1, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 1,
  2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2,
  2, 1, 1, 1, 2, 2, 1, 2, 2, 2, 1, 1, 2, 1, 2, 2,
  1, 2, 1, 2, 2, 1, 2, 2, 2, 1, 1, 2, 2, 2, 2, 1,
  1, 2, 1, 1, 1, 1, 2, 2, 1, 1, 1, 1, 1, 1, 2, 1,
  1, 2, 2, 2, 2, 1, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 1, 2, 1, 1, 2, 2, 2, 2, 1, 2, 1, 1, 1, 2, 2,
  2, 2, 1, 2, 1, 2, 1, 1, 2, 2, 1, 1, 2, 2, 2, 1,
  1, 2, 2, 1, 2, 2, 1, 1, 2, 1, 1, 2, 2, 2, 2, 2,
  2, 2, 1, 1, 1, 1, 1, 2, 1, 2, 2, 2, 1, 1, 2, 2,
  2, 2, 2, 2, 2, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 1, 2, 1, 2, 2, 2, 2, 1, 2, 1, 2, 1, 2, 2, 1,
  1, 1, 2, 1, 2, 2, 2, 1, 1, 2, 2, 2, 2, 2, 2, 2,
  1, 1, 2, 1, 1, 2, 1, 1, 2, 1, 1, 1, 2, 2, 2, 2,

  /* Primary weight 1 for each character. */
  0xFB40,   /* U+6000 */
  0xFB40,   /* U+6001 */
  0xFB40,   /* U+6002 */
  0xFB40,   /* U+6003 */
  0xFB40,   /* U+6004 */
  0xFB40,   /* U+6005 */
  0xFB40,   /* U+6006 */
  0xFB40,   /* U+6007 */
  0xFB40,   /* U+6008 */
  0xFB40,   /* U+6009 */
  0xFB40,   /* U+600A */
  0xFB40,   /* U+600B */
  0xFB40,   /* U+600C */
  0xFB40,   /* U+600D */
  0x630D,   /* U+600E */
  0x6313,   /* U+600F */
  0x630B,   /* U+6010 */
  0xFB40,   /* U+6011 */
  0x5C95,   /* U+6012 */
  0xFB40,   /* U+6013 */
  0xFB40,   /* U+6014 */
  0x6310,   /* U+6015 */
  0x5E0E,   /* U+6016 */
  0xFB40,   /* U+6017 */
  0xFB40,   /* U+6018 */
  0x630A,   /* U+6019 */
  0xFB40,   /* U+601A */
  0x630F,   /* U+601B */
  0x5FEE,   /* U+601C */
  0x58E4,   /* U+601D */
  0xFB40,   /* U+601E */
  0xFB40,   /* U+601F */
  0x5B74,   /* U+6020 */
  0x6308,   /* U+6021 */
  0xFB40,   /* U+6022 */
  0xFB40,   /* U+6023 */
  0xFB40,   /* U+6024 */
  0x56B7,   /* U+6025 */
  0x6312,   /* U+6026 */
  0x5A90,   /* U+6027 */
  0x5546,   /* U+6028 */
  0x630C,   /* U+6029 */
  0x55B7,   /* U+602A */
  0x6311,   /* U+602B */
  0xFB40,   /* U+602C */
  0xFB40,   /* U+602D */
  0xFB40,   /* U+602E */
  0x56E8,   /* U+602F */
  0xFB40,   /* U+6030 */
  0x630E,   /* U+6031 */
  0xFB40,   /* U+6032 */
  0xFB40,   /* U+6033 */
  0xFB40,   /* U+6034 */
  0xFB40,   /* U+6035 */
  0xFB40,   /* U+6036 */
  0xFB40,   /* U+6037 */
  0xFB40,   /* U+6038 */
  0xFB40,   /* U+6039 */
  0x6314,   /* U+603A */
  0xFB40,   /* U+603B */
  0xFB40,   /* U+603C */
  0xFB40,   /* U+603D */
  0xFB40,   /* U+603E */
  0xFB40,   /* U+603F */
  0xFB40,   /* U+6040 */
  0x6316,   /* U+6041 */
  0x6320,   /* U+6042 */
  0x631E,   /* U+6043 */
  0xFB40,   /* U+6044 */
  0xFB40,   /* U+6045 */
  0x631B,   /* U+6046 */
  0xFB40,   /* U+6047 */
  0xFB40,   /* U+6048 */
  0xFB40,   /* U+6049 */
  0x631A,   /* U+604A */
  0x5FFF,   /* U+604B */
  0xFB40,   /* U+604C */
  0x631C,   /* U+604D */
  0xFB40,   /* U+604E */
  0xFB40,   /* U+604F */
  0x56E9,   /* U+6050 */
  0xFB40,   /* U+6051 */
  0x5802,   /* U+6052 */
  0xFB40,   /* U+6053 */
  0xFB40,   /* U+6054 */
  0x59C3,   /* U+6055 */
  0xFB40,   /* U+6056 */
  0xFB40,   /* U+6057 */
  0xFB40,   /* U+6058 */
  0x6323,   /* U+6059 */
  0x6315,   /* U+605A */
  0xFB40,   /* U+605B */
  0xFB40,   /* U+605C */
  0xFB40,   /* U+605D */
  0xFB40,   /* U+605E */
  0x6319,   /* U+605F */
  0x6309,   /* U+6060 */
  0xFB40,   /* U+6061 */
  0x55B9,   /* U+6062 */
  0x631D,   /* U+6063 */
  0x631F,   /* U+6064 */
  0x5BCE,   /* U+6065 */
  0xFB40,   /* U+6066 */
  0xFB40,   /* U+6067 */
  0x5857,   /* U+6068 */
  0x5577,   /* U+6069 */
  0x6317,   /* U+606A */
  0x6322,   /* U+606B */
  0x6321,   /* U+606C */
  0x56EA,   /* U+606D */
  0xFB40,   /* U+606E */
  0x5B48,   /* U+606F */
  0x5603,   /* U+6070 */
  0xFB40,   /* U+6071 */
  0xFB40,   /* U+6072 */
  0xFB40,   /* U+6073 */
  0xFB40,   /* U+6074 */
  0x5758,   /* U+6075 */
  0xFB40,   /* U+6076 */
  0x6318,   /* U+6077 */
  0xFB40,   /* U+6078 */
  0xFB40,   /* U+6079 */
  0xFB40,   /* U+607A */
  0xFB40,   /* U+607B */
  0xFB40,   /* U+607C */
  0xFB40,   /* U+607D */
  0xFB40,   /* U+607E */
  0xFB40,   /* U+607F */
  0xFB40,   /* U+6080 */
  0x6324,   /* U+6081 */
  0xFB40,   /* U+6082 */
  0x6327,   /* U+6083 */
  0x6329,   /* U+6084 */
  0xFB40,   /* U+6085 */
  0xFB40,   /* U+6086 */
  0xFB40,   /* U+6087 */
  0xFB40,   /* U+6088 */
  0x5928,   /* U+6089 */
  0xFB40,   /* U+608A */
  0x632F,   /* U+608B */
  0x5C4B,   /* U+608C */
  0x6325,   /* U+608D */
  0xFB40,   /* U+608E */
  0xFB40,   /* U+608F */
  0xFB40,   /* U+6090 */
  0xFB40,   /* U+6091 */
  0x632D,   /* U+6092 */
  0xFB40,   /* U+6093 */
  0x55B8,   /* U+6094 */
  0xFB40,   /* U+6095 */
  0x632B,   /* U+6096 */
  0x632C,   /* U+6097 */
  0xFB40,   /* U+6098 */
  0xFB40,   /* U+6099 */
  0x6328,   /* U+609A */
  0x632A,   /* U+609B */
  0xFB40,   /* U+609C */
  0xFB40,   /* U+609D */
  0xFB40,   /* U+609E */
  0x57DA,   /* U+609F */
  0x5F53,   /* U+60A0 */
  0xFB40,   /* U+60A1 */
  0xFB40,   /* U+60A2 */
  0x5630,   /* U+60A3 */
  0xFB40,   /* U+60A4 */
  0xFB40,   /* U+60A5 */
  0x553A,   /* U+60A6 */
  0x632E,   /* U+60A7 */
  0xFB40,   /* U+60A8 */
  0x5D2F,   /* U+60A9 */
  0x54B0,   /* U+60AA */
  0xFB40,   /* U+60AB */
  0xFB40,   /* U+60AC */
  0xFB40,   /* U+60AD */
  0xFB40,   /* U+60AE */
  0xFB40,   /* U+60AF */
  0xFB40,   /* U+60B0 */
  0xFB40,   /* U+60B1 */
  0x5DB4,   /* U+60B2 */
  0x6306,   /* U+60B3 */
  0x6334,   /* U+60B4 */
  0x6338,   /* U+60B5 */
  0x5F30,   /* U+60B6 */
  0xFB40,   /* U+60B7 */
  0x6331,   /* U+60B8 */
  0xFB40,   /* U+60B9 */
  0xFB40,   /* U+60BA */
  0xFB40,   /* U+60BB */
  0x5CA2,   /* U+60BC */
  0x6336,   /* U+60BD */
  0xFB40,   /* U+60BE */
  0xFB40,   /* U+60BF */
  0xFB40,   /* U+60C0 */
  0xFB40,   /* U+60C1 */
  0xFB40,   /* U+60C2 */
  0xFB40,   /* U+60C3 */
  0xFB40,   /* U+60C4 */
  0x5A17,   /* U+60C5 */
  0x6337,   /* U+60C6 */
  0x5CEE,   /* U+60C7 */
  0xFB40,   /* U+60C8 */
  0xFB40,   /* U+60C9 */
  0xFB40,   /* U+60CA */
  0xFB40,   /* U+60CB */
  0xFB40,   /* U+60CC */
  0xFB40,   /* U+60CD */
  0xFB40,   /* U+60CE */
  0xFB40,   /* U+60CF */
  0xFB40,   /* U+60D0 */
  0x602C,   /* U+60D1 */
  0xFB40,   /* U+60D2 */
  0x6333,   /* U+60D3 */
  0xFB40,   /* U+60D4 */
  0xFB40,   /* U+60D5 */
  0xFB40,   /* U+60D6 */
  0xFB40,   /* U+60D7 */
  0x6339,   /* U+60D8 */
  0xFB40,   /* U+60D9 */
  0x584C,   /* U+60DA */
  0xFB40,   /* U+60DB */
  0x5AAE,   /* U+60DC */
  0xFB40,   /* U+60DD */
  0xFB40,   /* U+60DE */
  0x54D7,   /* U+60DF */
  0x6332,   /* U+60E0 */
  0x6330,   /* U+60E1 */
  0xFB40,   /* U+60E2 */
  0x5B1B,   /* U+60E3 */
  0xFB40,   /* U+60E4 */
  0xFB40,   /* U+60E5 */
  0xFB40,   /* U+60E6 */
  0x6326,   /* U+60E7 */
  0x58C1,   /* U+60E8 */
  0xFB40,   /* U+60E9 */
  0xFB40,   /* U+60EA */
  0xFB40,   /* U+60EB */
  0xFB40,   /* U+60EC */
  0xFB40,   /* U+60ED */
  0xFB40,   /* U+60EE */
  0xFB40,   /* U+60EF */
  0x5B65,   /* U+60F0 */
  0x6345,   /* U+60F1 */
  0xFB40,   /* U+60F2 */
  0x5B1C,   /* U+60F3 */
  0x6340,   /* U+60F4 */
  0xFB40,   /* U+60F5 */
  0x633D,   /* U+60F6 */
  0x633E,   /* U+60F7 */
  0xFB40,   /* U+60F8 */
  0x5951,   /* U+60F9 */
  0x6341,   /* U+60FA */
  0x6344,   /* U+60FB */
  0xFB40,   /* U+60FC */
  0xFB40,   /* U+60FD */
  0xFB40,   /* U+60FE */
  0xFB40,   /* U+60FF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+6000 */
  0x0020,   /* U+6001 */
  0x0020,   /* U+6002 */
  0x0020,   /* U+6003 */
  0x0020,   /* U+6004 */
  0x0020,   /* U+6005 */
  0x0020,   /* U+6006 */
  0x0020,   /* U+6007 */
  0x0020,   /* U+6008 */
  0x0020,   /* U+6009 */
  0x0020,   /* U+600A */
  0x0020,   /* U+600B */
  0x0020,   /* U+600C */
  0x0020,   /* U+600D */
  0x0020,   /* U+600E */
  0x0020,   /* U+600F */
  0x0020,   /* U+6010 */
  0x0020,   /* U+6011 */
  0x0020,   /* U+6012 */
  0x0020,   /* U+6013 */
  0x0020,   /* U+6014 */
  0x0020,   /* U+6015 */
  0x0020,   /* U+6016 */
  0x0020,   /* U+6017 */
  0x0020,   /* U+6018 */
  0x0020,   /* U+6019 */
  0x0020,   /* U+601A */
  0x0020,   /* U+601B */
  0x0020,   /* U+601C */
  0x0020,   /* U+601D */
  0x0020,   /* U+601E */
  0x0020,   /* U+601F */
  0x0020,   /* U+6020 */
  0x0020,   /* U+6021 */
  0x0020,   /* U+6022 */
  0x0020,   /* U+6023 */
  0x0020,   /* U+6024 */
  0x0020,   /* U+6025 */
  0x0020,   /* U+6026 */
  0x0020,   /* U+6027 */
  0x0020,   /* U+6028 */
  0x0020,   /* U+6029 */
  0x0020,   /* U+602A */
  0x0020,   /* U+602B */
  0x0020,   /* U+602C */
  0x0020,   /* U+602D */
  0x0020,   /* U+602E */
  0x0020,   /* U+602F */
  0x0020,   /* U+6030 */
  0x0020,   /* U+6031 */
  0x0020,   /* U+6032 */
  0x0020,   /* U+6033 */
  0x0020,   /* U+6034 */
  0x0020,   /* U+6035 */
  0x0020,   /* U+6036 */
  0x0020,   /* U+6037 */
  0x0020,   /* U+6038 */
  0x0020,   /* U+6039 */
  0x0020,   /* U+603A */
  0x0020,   /* U+603B */
  0x0020,   /* U+603C */
  0x0020,   /* U+603D */
  0x0020,   /* U+603E */
  0x0020,   /* U+603F */
  0x0020,   /* U+6040 */
  0x0020,   /* U+6041 */
  0x0020,   /* U+6042 */
  0x0020,   /* U+6043 */
  0x0020,   /* U+6044 */
  0x0020,   /* U+6045 */
  0x0020,   /* U+6046 */
  0x0020,   /* U+6047 */
  0x0020,   /* U+6048 */
  0x0020,   /* U+6049 */
  0x0020,   /* U+604A */
  0x0020,   /* U+604B */
  0x0020,   /* U+604C */
  0x0020,   /* U+604D */
  0x0020,   /* U+604E */
  0x0020,   /* U+604F */
  0x0020,   /* U+6050 */
  0x0020,   /* U+6051 */
  0x0020,   /* U+6052 */
  0x0020,   /* U+6053 */
  0x0020,   /* U+6054 */
  0x0020,   /* U+6055 */
  0x0020,   /* U+6056 */
  0x0020,   /* U+6057 */
  0x0020,   /* U+6058 */
  0x0020,   /* U+6059 */
  0x0020,   /* U+605A */
  0x0020,   /* U+605B */
  0x0020,   /* U+605C */
  0x0020,   /* U+605D */
  0x0020,   /* U+605E */
  0x0020,   /* U+605F */
  0x0020,   /* U+6060 */
  0x0020,   /* U+6061 */
  0x0020,   /* U+6062 */
  0x0020,   /* U+6063 */
  0x0020,   /* U+6064 */
  0x0020,   /* U+6065 */
  0x0020,   /* U+6066 */
  0x0020,   /* U+6067 */
  0x0020,   /* U+6068 */
  0x0020,   /* U+6069 */
  0x0020,   /* U+606A */
  0x0020,   /* U+606B */
  0x0020,   /* U+606C */
  0x0020,   /* U+606D */
  0x0020,   /* U+606E */
  0x0020,   /* U+606F */
  0x0020,   /* U+6070 */
  0x0020,   /* U+6071 */
  0x0020,   /* U+6072 */
  0x0020,   /* U+6073 */
  0x0020,   /* U+6074 */
  0x0020,   /* U+6075 */
  0x0020,   /* U+6076 */
  0x0020,   /* U+6077 */
  0x0020,   /* U+6078 */
  0x0020,   /* U+6079 */
  0x0020,   /* U+607A */
  0x0020,   /* U+607B */
  0x0020,   /* U+607C */
  0x0020,   /* U+607D */
  0x0020,   /* U+607E */
  0x0020,   /* U+607F */
  0x0020,   /* U+6080 */
  0x0020,   /* U+6081 */
  0x0020,   /* U+6082 */
  0x0020,   /* U+6083 */
  0x0020,   /* U+6084 */
  0x0020,   /* U+6085 */
  0x0020,   /* U+6086 */
  0x0020,   /* U+6087 */
  0x0020,   /* U+6088 */
  0x0020,   /* U+6089 */
  0x0020,   /* U+608A */
  0x0020,   /* U+608B */
  0x0020,   /* U+608C */
  0x0020,   /* U+608D */
  0x0020,   /* U+608E */
  0x0020,   /* U+608F */
  0x0020,   /* U+6090 */
  0x0020,   /* U+6091 */
  0x0020,   /* U+6092 */
  0x0020,   /* U+6093 */
  0x0020,   /* U+6094 */
  0x0020,   /* U+6095 */
  0x0020,   /* U+6096 */
  0x0020,   /* U+6097 */
  0x0020,   /* U+6098 */
  0x0020,   /* U+6099 */
  0x0020,   /* U+609A */
  0x0020,   /* U+609B */
  0x0020,   /* U+609C */
  0x0020,   /* U+609D */
  0x0020,   /* U+609E */
  0x0020,   /* U+609F */
  0x0020,   /* U+60A0 */
  0x0020,   /* U+60A1 */
  0x0020,   /* U+60A2 */
  0x0020,   /* U+60A3 */
  0x0020,   /* U+60A4 */
  0x0020,   /* U+60A5 */
  0x0020,   /* U+60A6 */
  0x0020,   /* U+60A7 */
  0x0020,   /* U+60A8 */
  0x0020,   /* U+60A9 */
  0x0020,   /* U+60AA */
  0x0020,   /* U+60AB */
  0x0020,   /* U+60AC */
  0x0020,   /* U+60AD */
  0x0020,   /* U+60AE */
  0x0020,   /* U+60AF */
  0x0020,   /* U+60B0 */
  0x0020,   /* U+60B1 */
  0x0020,   /* U+60B2 */
  0x0020,   /* U+60B3 */
  0x0020,   /* U+60B4 */
  0x0020,   /* U+60B5 */
  0x0020,   /* U+60B6 */
  0x0020,   /* U+60B7 */
  0x0020,   /* U+60B8 */
  0x0020,   /* U+60B9 */
  0x0020,   /* U+60BA */
  0x0020,   /* U+60BB */
  0x0020,   /* U+60BC */
  0x0020,   /* U+60BD */
  0x0020,   /* U+60BE */
  0x0020,   /* U+60BF */
  0x0020,   /* U+60C0 */
  0x0020,   /* U+60C1 */
  0x0020,   /* U+60C2 */
  0x0020,   /* U+60C3 */
  0x0020,   /* U+60C4 */
  0x0020,   /* U+60C5 */
  0x0020,   /* U+60C6 */
  0x0020,   /* U+60C7 */
  0x0020,   /* U+60C8 */
  0x0020,   /* U+60C9 */
  0x0020,   /* U+60CA */
  0x0020,   /* U+60CB */
  0x0020,   /* U+60CC */
  0x0020,   /* U+60CD */
  0x0020,   /* U+60CE */
  0x0020,   /* U+60CF */
  0x0020,   /* U+60D0 */
  0x0020,   /* U+60D1 */
  0x0020,   /* U+60D2 */
  0x0020,   /* U+60D3 */
  0x0020,   /* U+60D4 */
  0x0020,   /* U+60D5 */
  0x0020,   /* U+60D6 */
  0x0020,   /* U+60D7 */
  0x0020,   /* U+60D8 */
  0x0020,   /* U+60D9 */
  0x0020,   /* U+60DA */
  0x0020,   /* U+60DB */
  0x0020,   /* U+60DC */
  0x0020,   /* U+60DD */
  0x0020,   /* U+60DE */
  0x0020,   /* U+60DF */
  0x0020,   /* U+60E0 */
  0x0020,   /* U+60E1 */
  0x0020,   /* U+60E2 */
  0x0020,   /* U+60E3 */
  0x0020,   /* U+60E4 */
  0x0020,   /* U+60E5 */
  0x0020,   /* U+60E6 */
  0x0020,   /* U+60E7 */
  0x0020,   /* U+60E8 */
  0x0020,   /* U+60E9 */
  0x0020,   /* U+60EA */
  0x0020,   /* U+60EB */
  0x0020,   /* U+60EC */
  0x0020,   /* U+60ED */
  0x0020,   /* U+60EE */
  0x0020,   /* U+60EF */
  0x0020,   /* U+60F0 */
  0x0020,   /* U+60F1 */
  0x0020,   /* U+60F2 */
  0x0020,   /* U+60F3 */
  0x0020,   /* U+60F4 */
  0x0020,   /* U+60F5 */
  0x0020,   /* U+60F6 */
  0x0020,   /* U+60F7 */
  0x0020,   /* U+60F8 */
  0x0020,   /* U+60F9 */
  0x0020,   /* U+60FA */
  0x0020,   /* U+60FB */
  0x0020,   /* U+60FC */
  0x0020,   /* U+60FD */
  0x0020,   /* U+60FE */
  0x0020,   /* U+60FF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+6000 */
  0x0002,   /* U+6001 */
  0x0002,   /* U+6002 */
  0x0002,   /* U+6003 */
  0x0002,   /* U+6004 */
  0x0002,   /* U+6005 */
  0x0002,   /* U+6006 */
  0x0002,   /* U+6007 */
  0x0002,   /* U+6008 */
  0x0002,   /* U+6009 */
  0x0002,   /* U+600A */
  0x0002,   /* U+600B */
  0x0002,   /* U+600C */
  0x0002,   /* U+600D */
  0x0002,   /* U+600E */
  0x0002,   /* U+600F */
  0x0002,   /* U+6010 */
  0x0002,   /* U+6011 */
  0x0002,   /* U+6012 */
  0x0002,   /* U+6013 */
  0x0002,   /* U+6014 */
  0x0002,   /* U+6015 */
  0x0002,   /* U+6016 */
  0x0002,   /* U+6017 */
  0x0002,   /* U+6018 */
  0x0002,   /* U+6019 */
  0x0002,   /* U+601A */
  0x0002,   /* U+601B */
  0x0002,   /* U+601C */
  0x0002,   /* U+601D */
  0x0002,   /* U+601E */
  0x0002,   /* U+601F */
  0x0002,   /* U+6020 */
  0x0002,   /* U+6021 */
  0x0002,   /* U+6022 */
  0x0002,   /* U+6023 */
  0x0002,   /* U+6024 */
  0x0002,   /* U+6025 */
  0x0002,   /* U+6026 */
  0x0002,   /* U+6027 */
  0x0002,   /* U+6028 */
  0x0002,   /* U+6029 */
  0x0002,   /* U+602A */
  0x0002,   /* U+602B */
  0x0002,   /* U+602C */
  0x0002,   /* U+602D */
  0x0002,   /* U+602E */
  0x0002,   /* U+602F */
  0x0002,   /* U+6030 */
  0x0002,   /* U+6031 */
  0x0002,   /* U+6032 */
  0x0002,   /* U+6033 */
  0x0002,   /* U+6034 */
  0x0002,   /* U+6035 */
  0x0002,   /* U+6036 */
  0x0002,   /* U+6037 */
  0x0002,   /* U+6038 */
  0x0002,   /* U+6039 */
  0x0002,   /* U+603A */
  0x0002,   /* U+603B */
  0x0002,   /* U+603C */
  0x0002,   /* U+603D */
  0x0002,   /* U+603E */
  0x0002,   /* U+603F */
  0x0002,   /* U+6040 */
  0x0002,   /* U+6041 */
  0x0002,   /* U+6042 */
  0x0002,   /* U+6043 */
  0x0002,   /* U+6044 */
  0x0002,   /* U+6045 */
  0x0002,   /* U+6046 */
  0x0002,   /* U+6047 */
  0x0002,   /* U+6048 */
  0x0002,   /* U+6049 */
  0x0002,   /* U+604A */
  0x0002,   /* U+604B */
  0x0002,   /* U+604C */
  0x0002,   /* U+604D */
  0x0002,   /* U+604E */
  0x0002,   /* U+604F */
  0x0002,   /* U+6050 */
  0x0002,   /* U+6051 */
  0x0002,   /* U+6052 */
  0x0002,   /* U+6053 */
  0x0002,   /* U+6054 */
  0x0002,   /* U+6055 */
  0x0002,   /* U+6056 */
  0x0002,   /* U+6057 */
  0x0002,   /* U+6058 */
  0x0002,   /* U+6059 */
  0x0002,   /* U+605A */
  0x0002,   /* U+605B */
  0x0002,   /* U+605C */
  0x0002,   /* U+605D */
  0x0002,   /* U+605E */
  0x0002,   /* U+605F */
  0x0002,   /* U+6060 */
  0x0002,   /* U+6061 */
  0x0002,   /* U+6062 */
  0x0002,   /* U+6063 */
  0x0002,   /* U+6064 */
  0x0002,   /* U+6065 */
  0x0002,   /* U+6066 */
  0x0002,   /* U+6067 */
  0x0002,   /* U+6068 */
  0x0002,   /* U+6069 */
  0x0002,   /* U+606A */
  0x0002,   /* U+606B */
  0x0002,   /* U+606C */
  0x0002,   /* U+606D */
  0x0002,   /* U+606E */
  0x0002,   /* U+606F */
  0x0002,   /* U+6070 */
  0x0002,   /* U+6071 */
  0x0002,   /* U+6072 */
  0x0002,   /* U+6073 */
  0x0002,   /* U+6074 */
  0x0002,   /* U+6075 */
  0x0002,   /* U+6076 */
  0x0002,   /* U+6077 */
  0x0002,   /* U+6078 */
  0x0002,   /* U+6079 */
  0x0002,   /* U+607A */
  0x0002,   /* U+607B */
  0x0002,   /* U+607C */
  0x0002,   /* U+607D */
  0x0002,   /* U+607E */
  0x0002,   /* U+607F */
  0x0002,   /* U+6080 */
  0x0002,   /* U+6081 */
  0x0002,   /* U+6082 */
  0x0002,   /* U+6083 */
  0x0002,   /* U+6084 */
  0x0002,   /* U+6085 */
  0x0002,   /* U+6086 */
  0x0002,   /* U+6087 */
  0x0002,   /* U+6088 */
  0x0002,   /* U+6089 */
  0x0002,   /* U+608A */
  0x0002,   /* U+608B */
  0x0002,   /* U+608C */
  0x0002,   /* U+608D */
  0x0002,   /* U+608E */
  0x0002,   /* U+608F */
  0x0002,   /* U+6090 */
  0x0002,   /* U+6091 */
  0x0002,   /* U+6092 */
  0x0002,   /* U+6093 */
  0x0002,   /* U+6094 */
  0x0002,   /* U+6095 */
  0x0002,   /* U+6096 */
  0x0002,   /* U+6097 */
  0x0002,   /* U+6098 */
  0x0002,   /* U+6099 */
  0x0002,   /* U+609A */
  0x0002,   /* U+609B */
  0x0002,   /* U+609C */
  0x0002,   /* U+609D */
  0x0002,   /* U+609E */
  0x0002,   /* U+609F */
  0x0002,   /* U+60A0 */
  0x0002,   /* U+60A1 */
  0x0002,   /* U+60A2 */
  0x0002,   /* U+60A3 */
  0x0002,   /* U+60A4 */
  0x0002,   /* U+60A5 */
  0x0002,   /* U+60A6 */
  0x0002,   /* U+60A7 */
  0x0002,   /* U+60A8 */
  0x0002,   /* U+60A9 */
  0x0002,   /* U+60AA */
  0x0002,   /* U+60AB */
  0x0002,   /* U+60AC */
  0x0002,   /* U+60AD */
  0x0002,   /* U+60AE */
  0x0002,   /* U+60AF */
  0x0002,   /* U+60B0 */
  0x0002,   /* U+60B1 */
  0x0002,   /* U+60B2 */
  0x0002,   /* U+60B3 */
  0x0002,   /* U+60B4 */
  0x0002,   /* U+60B5 */
  0x0002,   /* U+60B6 */
  0x0002,   /* U+60B7 */
  0x0002,   /* U+60B8 */
  0x0002,   /* U+60B9 */
  0x0002,   /* U+60BA */
  0x0002,   /* U+60BB */
  0x0002,   /* U+60BC */
  0x0002,   /* U+60BD */
  0x0002,   /* U+60BE */
  0x0002,   /* U+60BF */
  0x0002,   /* U+60C0 */
  0x0002,   /* U+60C1 */
  0x0002,   /* U+60C2 */
  0x0002,   /* U+60C3 */
  0x0002,   /* U+60C4 */
  0x0002,   /* U+60C5 */
  0x0002,   /* U+60C6 */
  0x0002,   /* U+60C7 */
  0x0002,   /* U+60C8 */
  0x0002,   /* U+60C9 */
  0x0002,   /* U+60CA */
  0x0002,   /* U+60CB */
  0x0002,   /* U+60CC */
  0x0002,   /* U+60CD */
  0x0002,   /* U+60CE */
  0x0002,   /* U+60CF */
  0x0002,   /* U+60D0 */
  0x0002,   /* U+60D1 */
  0x0002,   /* U+60D2 */
  0x0002,   /* U+60D3 */
  0x0002,   /* U+60D4 */
  0x0002,   /* U+60D5 */
  0x0002,   /* U+60D6 */
  0x0002,   /* U+60D7 */
  0x0002,   /* U+60D8 */
  0x0002,   /* U+60D9 */
  0x0002,   /* U+60DA */
  0x0002,   /* U+60DB */
  0x0002,   /* U+60DC */
  0x0002,   /* U+60DD */
  0x0002,   /* U+60DE */
  0x0002,   /* U+60DF */
  0x0002,   /* U+60E0 */
  0x0002,   /* U+60E1 */
  0x0002,   /* U+60E2 */
  0x0002,   /* U+60E3 */
  0x0002,   /* U+60E4 */
  0x0002,   /* U+60E5 */
  0x0002,   /* U+60E6 */
  0x0002,   /* U+60E7 */
  0x0002,   /* U+60E8 */
  0x0002,   /* U+60E9 */
  0x0002,   /* U+60EA */
  0x0002,   /* U+60EB */
  0x0002,   /* U+60EC */
  0x0002,   /* U+60ED */
  0x0002,   /* U+60EE */
  0x0002,   /* U+60EF */
  0x0002,   /* U+60F0 */
  0x0002,   /* U+60F1 */
  0x0002,   /* U+60F2 */
  0x0002,   /* U+60F3 */
  0x0002,   /* U+60F4 */
  0x0002,   /* U+60F5 */
  0x0002,   /* U+60F6 */
  0x0002,   /* U+60F7 */
  0x0002,   /* U+60F8 */
  0x0002,   /* U+60F9 */
  0x0002,   /* U+60FA */
  0x0002,   /* U+60FB */
  0x0002,   /* U+60FC */
  0x0002,   /* U+60FD */
  0x0002,   /* U+60FE */
  0x0002,   /* U+60FF */

  /* Primary weight 2 for each character. */
  0xE000,   /* U+6000 */
  0xE001,   /* U+6001 */
  0xE002,   /* U+6002 */
  0xE003,   /* U+6003 */
  0xE004,   /* U+6004 */
  0xE005,   /* U+6005 */
  0xE006,   /* U+6006 */
  0xE007,   /* U+6007 */
  0xE008,   /* U+6008 */
  0xE009,   /* U+6009 */
  0xE00A,   /* U+600A */
  0xE00B,   /* U+600B */
  0xE00C,   /* U+600C */
  0xE00D,   /* U+600D */
  0x0000,   /* U+600E */
  0x0000,   /* U+600F */
  0x0000,   /* U+6010 */
  0xE011,   /* U+6011 */
  0x0000,   /* U+6012 */
  0xE013,   /* U+6013 */
  0xE014,   /* U+6014 */
  0x0000,   /* U+6015 */
  0x0000,   /* U+6016 */
  0xE017,   /* U+6017 */
  0xE018,   /* U+6018 */
  0x0000,   /* U+6019 */
  0xE01A,   /* U+601A */
  0x0000,   /* U+601B */
  0x0000,   /* U+601C */
  0x0000,   /* U+601D */
  0xE01E,   /* U+601E */
  0xE01F,   /* U+601F */
  0x0000,   /* U+6020 */
  0x0000,   /* U+6021 */
  0xE022,   /* U+6022 */
  0xE023,   /* U+6023 */
  0xE024,   /* U+6024 */
  0x0000,   /* U+6025 */
  0x0000,   /* U+6026 */
  0x0000,   /* U+6027 */
  0x0000,   /* U+6028 */
  0x0000,   /* U+6029 */
  0x0000,   /* U+602A */
  0x0000,   /* U+602B */
  0xE02C,   /* U+602C */
  0xE02D,   /* U+602D */
  0xE02E,   /* U+602E */
  0x0000,   /* U+602F */
  0xE030,   /* U+6030 */
  0x0000,   /* U+6031 */
  0xE032,   /* U+6032 */
  0xE033,   /* U+6033 */
  0xE034,   /* U+6034 */
  0xE035,   /* U+6035 */
  0xE036,   /* U+6036 */
  0xE037,   /* U+6037 */
  0xE038,   /* U+6038 */
  0xE039,   /* U+6039 */
  0x0000,   /* U+603A */
  0xE03B,   /* U+603B */
  0xE03C,   /* U+603C */
  0xE03D,   /* U+603D */
  0xE03E,   /* U+603E */
  0xE03F,   /* U+603F */
  0xE040,   /* U+6040 */
  0x0000,   /* U+6041 */
  0x0000,   /* U+6042 */
  0x0000,   /* U+6043 */
  0xE044,   /* U+6044 */
  0xE045,   /* U+6045 */
  0x0000,   /* U+6046 */
  0xE047,   /* U+6047 */
  0xE048,   /* U+6048 */
  0xE049,   /* U+6049 */
  0x0000,   /* U+604A */
  0x0000,   /* U+604B */
  0xE04C,   /* U+604C */
  0x0000,   /* U+604D */
  0xE04E,   /* U+604E */
  0xE04F,   /* U+604F */
  0x0000,   /* U+6050 */
  0xE051,   /* U+6051 */
  0x0000,   /* U+6052 */
  0xE053,   /* U+6053 */
  0xE054,   /* U+6054 */
  0x0000,   /* U+6055 */
  0xE056,   /* U+6056 */
  0xE057,   /* U+6057 */
  0xE058,   /* U+6058 */
  0x0000,   /* U+6059 */
  0x0000,   /* U+605A */
  0xE05B,   /* U+605B */
  0xE05C,   /* U+605C */
  0xE05D,   /* U+605D */
  0xE05E,   /* U+605E */
  0x0000,   /* U+605F */
  0x0000,   /* U+6060 */
  0xE061,   /* U+6061 */
  0x0000,   /* U+6062 */
  0x0000,   /* U+6063 */
  0x0000,   /* U+6064 */
  0x0000,   /* U+6065 */
  0xE066,   /* U+6066 */
  0xE067,   /* U+6067 */
  0x0000,   /* U+6068 */
  0x0000,   /* U+6069 */
  0x0000,   /* U+606A */
  0x0000,   /* U+606B */
  0x0000,   /* U+606C */
  0x0000,   /* U+606D */
  0xE06E,   /* U+606E */
  0x0000,   /* U+606F */
  0x0000,   /* U+6070 */
  0xE071,   /* U+6071 */
  0xE072,   /* U+6072 */
  0xE073,   /* U+6073 */
  0xE074,   /* U+6074 */
  0x0000,   /* U+6075 */
  0xE076,   /* U+6076 */
  0x0000,   /* U+6077 */
  0xE078,   /* U+6078 */
  0xE079,   /* U+6079 */
  0xE07A,   /* U+607A */
  0xE07B,   /* U+607B */
  0xE07C,   /* U+607C */
  0xE07D,   /* U+607D */
  0xE07E,   /* U+607E */
  0xE07F,   /* U+607F */
  0xE080,   /* U+6080 */
  0x0000,   /* U+6081 */
  0xE082,   /* U+6082 */
  0x0000,   /* U+6083 */
  0x0000,   /* U+6084 */
  0xE085,   /* U+6085 */
  0xE086,   /* U+6086 */
  0xE087,   /* U+6087 */
  0xE088,   /* U+6088 */
  0x0000,   /* U+6089 */
  0xE08A,   /* U+608A */
  0x0000,   /* U+608B */
  0x0000,   /* U+608C */
  0x0000,   /* U+608D */
  0xE08E,   /* U+608E */
  0xE08F,   /* U+608F */
  0xE090,   /* U+6090 */
  0xE091,   /* U+6091 */
  0x0000,   /* U+6092 */
  0xE093,   /* U+6093 */
  0x0000,   /* U+6094 */
  0xE095,   /* U+6095 */
  0x0000,   /* U+6096 */
  0x0000,   /* U+6097 */
  0xE098,   /* U+6098 */
  0xE099,   /* U+6099 */
  0x0000,   /* U+609A */
  0x0000,   /* U+609B */
  0xE09C,   /* U+609C */
  0xE09D,   /* U+609D */
  0xE09E,   /* U+609E */
  0x0000,   /* U+609F */
  0x0000,   /* U+60A0 */
  0xE0A1,   /* U+60A1 */
  0xE0A2,   /* U+60A2 */
  0x0000,   /* U+60A3 */
  0xE0A4,   /* U+60A4 */
  0xE0A5,   /* U+60A5 */
  0x0000,   /* U+60A6 */
  0x0000,   /* U+60A7 */
  0xE0A8,   /* U+60A8 */
  0x0000,   /* U+60A9 */
  0x0000,   /* U+60AA */
  0xE0AB,   /* U+60AB */
  0xE0AC,   /* U+60AC */
  0xE0AD,   /* U+60AD */
  0xE0AE,   /* U+60AE */
  0xE0AF,   /* U+60AF */
  0xE0B0,   /* U+60B0 */
  0xE0B1,   /* U+60B1 */
  0x0000,   /* U+60B2 */
  0x0000,   /* U+60B3 */
  0x0000,   /* U+60B4 */
  0x0000,   /* U+60B5 */
  0x0000,   /* U+60B6 */
  0xE0B7,   /* U+60B7 */
  0x0000,   /* U+60B8 */
  0xE0B9,   /* U+60B9 */
  0xE0BA,   /* U+60BA */
  0xE0BB,   /* U+60BB */
  0x0000,   /* U+60BC */
  0x0000,   /* U+60BD */
  0xE0BE,   /* U+60BE */
  0xE0BF,   /* U+60BF */
  0xE0C0,   /* U+60C0 */
  0xE0C1,   /* U+60C1 */
  0xE0C2,   /* U+60C2 */
  0xE0C3,   /* U+60C3 */
  0xE0C4,   /* U+60C4 */
  0x0000,   /* U+60C5 */
  0x0000,   /* U+60C6 */
  0x0000,   /* U+60C7 */
  0xE0C8,   /* U+60C8 */
  0xE0C9,   /* U+60C9 */
  0xE0CA,   /* U+60CA */
  0xE0CB,   /* U+60CB */
  0xE0CC,   /* U+60CC */
  0xE0CD,   /* U+60CD */
  0xE0CE,   /* U+60CE */
  0xE0CF,   /* U+60CF */
  0xE0D0,   /* U+60D0 */
  0x0000,   /* U+60D1 */
  0xE0D2,   /* U+60D2 */
  0x0000,   /* U+60D3 */
  0xE0D4,   /* U+60D4 */
  0xE0D5,   /* U+60D5 */
  0xE0D6,   /* U+60D6 */
  0xE0D7,   /* U+60D7 */
  0x0000,   /* U+60D8 */
  0xE0D9,   /* U+60D9 */
  0x0000,   /* U+60DA */
  0xE0DB,   /* U+60DB */
  0x0000,   /* U+60DC */
  0xE0DD,   /* U+60DD */
  0xE0DE,   /* U+60DE */
  0x0000,   /* U+60DF */
  0x0000,   /* U+60E0 */
  0x0000,   /* U+60E1 */
  0xE0E2,   /* U+60E2 */
  0x0000,   /* U+60E3 */
  0xE0E4,   /* U+60E4 */
  0xE0E5,   /* U+60E5 */
  0xE0E6,   /* U+60E6 */
  0x0000,   /* U+60E7 */
  0x0000,   /* U+60E8 */
  0xE0E9,   /* U+60E9 */
  0xE0EA,   /* U+60EA */
  0xE0EB,   /* U+60EB */
  0xE0EC,   /* U+60EC */
  0xE0ED,   /* U+60ED */
  0xE0EE,   /* U+60EE */
  0xE0EF,   /* U+60EF */
  0x0000,   /* U+60F0 */
  0x0000,   /* U+60F1 */
  0xE0F2,   /* U+60F2 */
  0x0000,   /* U+60F3 */
  0x0000,   /* U+60F4 */
  0xE0F5,   /* U+60F5 */
  0x0000,   /* U+60F6 */
  0x0000,   /* U+60F7 */
  0xE0F8,   /* U+60F8 */
  0x0000,   /* U+60F9 */
  0x0000,   /* U+60FA */
  0x0000,   /* U+60FB */
  0xE0FC,   /* U+60FC */
  0xE0FD,   /* U+60FD */
  0xE0FE,   /* U+60FE */
  0xE0FF,   /* U+60FF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+6000 */
  0x0000,   /* U+6001 */
  0x0000,   /* U+6002 */
  0x0000,   /* U+6003 */
  0x0000,   /* U+6004 */
  0x0000,   /* U+6005 */
  0x0000,   /* U+6006 */
  0x0000,   /* U+6007 */
  0x0000,   /* U+6008 */
  0x0000,   /* U+6009 */
  0x0000,   /* U+600A */
  0x0000,   /* U+600B */
  0x0000,   /* U+600C */
  0x0000,   /* U+600D */
  0x0000,   /* U+600E */
  0x0000,   /* U+600F */
  0x0000,   /* U+6010 */
  0x0000,   /* U+6011 */
  0x0000,   /* U+6012 */
  0x0000,   /* U+6013 */
  0x0000,   /* U+6014 */
  0x0000,   /* U+6015 */
  0x0000,   /* U+6016 */
  0x0000,   /* U+6017 */
  0x0000,   /* U+6018 */
  0x0000,   /* U+6019 */
  0x0000,   /* U+601A */
  0x0000,   /* U+601B */
  0x0000,   /* U+601C */
  0x0000,   /* U+601D */
  0x0000,   /* U+601E */
  0x0000,   /* U+601F */
  0x0000,   /* U+6020 */
  0x0000,   /* U+6021 */
  0x0000,   /* U+6022 */
  0x0000,   /* U+6023 */
  0x0000,   /* U+6024 */
  0x0000,   /* U+6025 */
  0x0000,   /* U+6026 */
  0x0000,   /* U+6027 */
  0x0000,   /* U+6028 */
  0x0000,   /* U+6029 */
  0x0000,   /* U+602A */
  0x0000,   /* U+602B */
  0x0000,   /* U+602C */
  0x0000,   /* U+602D */
  0x0000,   /* U+602E */
  0x0000,   /* U+602F */
  0x0000,   /* U+6030 */
  0x0000,   /* U+6031 */
  0x0000,   /* U+6032 */
  0x0000,   /* U+6033 */
  0x0000,   /* U+6034 */
  0x0000,   /* U+6035 */
  0x0000,   /* U+6036 */
  0x0000,   /* U+6037 */
  0x0000,   /* U+6038 */
  0x0000,   /* U+6039 */
  0x0000,   /* U+603A */
  0x0000,   /* U+603B */
  0x0000,   /* U+603C */
  0x0000,   /* U+603D */
  0x0000,   /* U+603E */
  0x0000,   /* U+603F */
  0x0000,   /* U+6040 */
  0x0000,   /* U+6041 */
  0x0000,   /* U+6042 */
  0x0000,   /* U+6043 */
  0x0000,   /* U+6044 */
  0x0000,   /* U+6045 */
  0x0000,   /* U+6046 */
  0x0000,   /* U+6047 */
  0x0000,   /* U+6048 */
  0x0000,   /* U+6049 */
  0x0000,   /* U+604A */
  0x0000,   /* U+604B */
  0x0000,   /* U+604C */
  0x0000,   /* U+604D */
  0x0000,   /* U+604E */
  0x0000,   /* U+604F */
  0x0000,   /* U+6050 */
  0x0000,   /* U+6051 */
  0x0000,   /* U+6052 */
  0x0000,   /* U+6053 */
  0x0000,   /* U+6054 */
  0x0000,   /* U+6055 */
  0x0000,   /* U+6056 */
  0x0000,   /* U+6057 */
  0x0000,   /* U+6058 */
  0x0000,   /* U+6059 */
  0x0000,   /* U+605A */
  0x0000,   /* U+605B */
  0x0000,   /* U+605C */
  0x0000,   /* U+605D */
  0x0000,   /* U+605E */
  0x0000,   /* U+605F */
  0x0000,   /* U+6060 */
  0x0000,   /* U+6061 */
  0x0000,   /* U+6062 */
  0x0000,   /* U+6063 */
  0x0000,   /* U+6064 */
  0x0000,   /* U+6065 */
  0x0000,   /* U+6066 */
  0x0000,   /* U+6067 */
  0x0000,   /* U+6068 */
  0x0000,   /* U+6069 */
  0x0000,   /* U+606A */
  0x0000,   /* U+606B */
  0x0000,   /* U+606C */
  0x0000,   /* U+606D */
  0x0000,   /* U+606E */
  0x0000,   /* U+606F */
  0x0000,   /* U+6070 */
  0x0000,   /* U+6071 */
  0x0000,   /* U+6072 */
  0x0000,   /* U+6073 */
  0x0000,   /* U+6074 */
  0x0000,   /* U+6075 */
  0x0000,   /* U+6076 */
  0x0000,   /* U+6077 */
  0x0000,   /* U+6078 */
  0x0000,   /* U+6079 */
  0x0000,   /* U+607A */
  0x0000,   /* U+607B */
  0x0000,   /* U+607C */
  0x0000,   /* U+607D */
  0x0000,   /* U+607E */
  0x0000,   /* U+607F */
  0x0000,   /* U+6080 */
  0x0000,   /* U+6081 */
  0x0000,   /* U+6082 */
  0x0000,   /* U+6083 */
  0x0000,   /* U+6084 */
  0x0000,   /* U+6085 */
  0x0000,   /* U+6086 */
  0x0000,   /* U+6087 */
  0x0000,   /* U+6088 */
  0x0000,   /* U+6089 */
  0x0000,   /* U+608A */
  0x0000,   /* U+608B */
  0x0000,   /* U+608C */
  0x0000,   /* U+608D */
  0x0000,   /* U+608E */
  0x0000,   /* U+608F */
  0x0000,   /* U+6090 */
  0x0000,   /* U+6091 */
  0x0000,   /* U+6092 */
  0x0000,   /* U+6093 */
  0x0000,   /* U+6094 */
  0x0000,   /* U+6095 */
  0x0000,   /* U+6096 */
  0x0000,   /* U+6097 */
  0x0000,   /* U+6098 */
  0x0000,   /* U+6099 */
  0x0000,   /* U+609A */
  0x0000,   /* U+609B */
  0x0000,   /* U+609C */
  0x0000,   /* U+609D */
  0x0000,   /* U+609E */
  0x0000,   /* U+609F */
  0x0000,   /* U+60A0 */
  0x0000,   /* U+60A1 */
  0x0000,   /* U+60A2 */
  0x0000,   /* U+60A3 */
  0x0000,   /* U+60A4 */
  0x0000,   /* U+60A5 */
  0x0000,   /* U+60A6 */
  0x0000,   /* U+60A7 */
  0x0000,   /* U+60A8 */
  0x0000,   /* U+60A9 */
  0x0000,   /* U+60AA */
  0x0000,   /* U+60AB */
  0x0000,   /* U+60AC */
  0x0000,   /* U+60AD */
  0x0000,   /* U+60AE */
  0x0000,   /* U+60AF */
  0x0000,   /* U+60B0 */
  0x0000,   /* U+60B1 */
  0x0000,   /* U+60B2 */
  0x0000,   /* U+60B3 */
  0x0000,   /* U+60B4 */
  0x0000,   /* U+60B5 */
  0x0000,   /* U+60B6 */
  0x0000,   /* U+60B7 */
  0x0000,   /* U+60B8 */
  0x0000,   /* U+60B9 */
  0x0000,   /* U+60BA */
  0x0000,   /* U+60BB */
  0x0000,   /* U+60BC */
  0x0000,   /* U+60BD */
  0x0000,   /* U+60BE */
  0x0000,   /* U+60BF */
  0x0000,   /* U+60C0 */
  0x0000,   /* U+60C1 */
  0x0000,   /* U+60C2 */
  0x0000,   /* U+60C3 */
  0x0000,   /* U+60C4 */
  0x0000,   /* U+60C5 */
  0x0000,   /* U+60C6 */
  0x0000,   /* U+60C7 */
  0x0000,   /* U+60C8 */
  0x0000,   /* U+60C9 */
  0x0000,   /* U+60CA */
  0x0000,   /* U+60CB */
  0x0000,   /* U+60CC */
  0x0000,   /* U+60CD */
  0x0000,   /* U+60CE */
  0x0000,   /* U+60CF */
  0x0000,   /* U+60D0 */
  0x0000,   /* U+60D1 */
  0x0000,   /* U+60D2 */
  0x0000,   /* U+60D3 */
  0x0000,   /* U+60D4 */
  0x0000,   /* U+60D5 */
  0x0000,   /* U+60D6 */
  0x0000,   /* U+60D7 */
  0x0000,   /* U+60D8 */
  0x0000,   /* U+60D9 */
  0x0000,   /* U+60DA */
  0x0000,   /* U+60DB */
  0x0000,   /* U+60DC */
  0x0000,   /* U+60DD */
  0x0000,   /* U+60DE */
  0x0000,   /* U+60DF */
  0x0000,   /* U+60E0 */
  0x0000,   /* U+60E1 */
  0x0000,   /* U+60E2 */
  0x0000,   /* U+60E3 */
  0x0000,   /* U+60E4 */
  0x0000,   /* U+60E5 */
  0x0000,   /* U+60E6 */
  0x0000,   /* U+60E7 */
  0x0000,   /* U+60E8 */
  0x0000,   /* U+60E9 */
  0x0000,   /* U+60EA */
  0x0000,   /* U+60EB */
  0x0000,   /* U+60EC */
  0x0000,   /* U+60ED */
  0x0000,   /* U+60EE */
  0x0000,   /* U+60EF */
  0x0000,   /* U+60F0 */
  0x0000,   /* U+60F1 */
  0x0000,   /* U+60F2 */
  0x0000,   /* U+60F3 */
  0x0000,   /* U+60F4 */
  0x0000,   /* U+60F5 */
  0x0000,   /* U+60F6 */
  0x0000,   /* U+60F7 */
  0x0000,   /* U+60F8 */
  0x0000,   /* U+60F9 */
  0x0000,   /* U+60FA */
  0x0000,   /* U+60FB */
  0x0000,   /* U+60FC */
  0x0000,   /* U+60FD */
  0x0000,   /* U+60FE */
  0x0000,   /* U+60FF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+6000 */
  0x0000,   /* U+6001 */
  0x0000,   /* U+6002 */
  0x0000,   /* U+6003 */
  0x0000,   /* U+6004 */
  0x0000,   /* U+6005 */
  0x0000,   /* U+6006 */
  0x0000,   /* U+6007 */
  0x0000,   /* U+6008 */
  0x0000,   /* U+6009 */
  0x0000,   /* U+600A */
  0x0000,   /* U+600B */
  0x0000,   /* U+600C */
  0x0000,   /* U+600D */
  0x0000,   /* U+600E */
  0x0000,   /* U+600F */
  0x0000,   /* U+6010 */
  0x0000,   /* U+6011 */
  0x0000,   /* U+6012 */
  0x0000,   /* U+6013 */
  0x0000,   /* U+6014 */
  0x0000,   /* U+6015 */
  0x0000,   /* U+6016 */
  0x0000,   /* U+6017 */
  0x0000,   /* U+6018 */
  0x0000,   /* U+6019 */
  0x0000,   /* U+601A */
  0x0000,   /* U+601B */
  0x0000,   /* U+601C */
  0x0000,   /* U+601D */
  0x0000,   /* U+601E */
  0x0000,   /* U+601F */
  0x0000,   /* U+6020 */
  0x0000,   /* U+6021 */
  0x0000,   /* U+6022 */
  0x0000,   /* U+6023 */
  0x0000,   /* U+6024 */
  0x0000,   /* U+6025 */
  0x0000,   /* U+6026 */
  0x0000,   /* U+6027 */
  0x0000,   /* U+6028 */
  0x0000,   /* U+6029 */
  0x0000,   /* U+602A */
  0x0000,   /* U+602B */
  0x0000,   /* U+602C */
  0x0000,   /* U+602D */
  0x0000,   /* U+602E */
  0x0000,   /* U+602F */
  0x0000,   /* U+6030 */
  0x0000,   /* U+6031 */
  0x0000,   /* U+6032 */
  0x0000,   /* U+6033 */
  0x0000,   /* U+6034 */
  0x0000,   /* U+6035 */
  0x0000,   /* U+6036 */
  0x0000,   /* U+6037 */
  0x0000,   /* U+6038 */
  0x0000,   /* U+6039 */
  0x0000,   /* U+603A */
  0x0000,   /* U+603B */
  0x0000,   /* U+603C */
  0x0000,   /* U+603D */
  0x0000,   /* U+603E */
  0x0000,   /* U+603F */
  0x0000,   /* U+6040 */
  0x0000,   /* U+6041 */
  0x0000,   /* U+6042 */
  0x0000,   /* U+6043 */
  0x0000,   /* U+6044 */
  0x0000,   /* U+6045 */
  0x0000,   /* U+6046 */
  0x0000,   /* U+6047 */
  0x0000,   /* U+6048 */
  0x0000,   /* U+6049 */
  0x0000,   /* U+604A */
  0x0000,   /* U+604B */
  0x0000,   /* U+604C */
  0x0000,   /* U+604D */
  0x0000,   /* U+604E */
  0x0000,   /* U+604F */
  0x0000,   /* U+6050 */
  0x0000,   /* U+6051 */
  0x0000,   /* U+6052 */
  0x0000,   /* U+6053 */
  0x0000,   /* U+6054 */
  0x0000,   /* U+6055 */
  0x0000,   /* U+6056 */
  0x0000,   /* U+6057 */
  0x0000,   /* U+6058 */
  0x0000,   /* U+6059 */
  0x0000,   /* U+605A */
  0x0000,   /* U+605B */
  0x0000,   /* U+605C */
  0x0000,   /* U+605D */
  0x0000,   /* U+605E */
  0x0000,   /* U+605F */
  0x0000,   /* U+6060 */
  0x0000,   /* U+6061 */
  0x0000,   /* U+6062 */
  0x0000,   /* U+6063 */
  0x0000,   /* U+6064 */
  0x0000,   /* U+6065 */
  0x0000,   /* U+6066 */
  0x0000,   /* U+6067 */
  0x0000,   /* U+6068 */
  0x0000,   /* U+6069 */
  0x0000,   /* U+606A */
  0x0000,   /* U+606B */
  0x0000,   /* U+606C */
  0x0000,   /* U+606D */
  0x0000,   /* U+606E */
  0x0000,   /* U+606F */
  0x0000,   /* U+6070 */
  0x0000,   /* U+6071 */
  0x0000,   /* U+6072 */
  0x0000,   /* U+6073 */
  0x0000,   /* U+6074 */
  0x0000,   /* U+6075 */
  0x0000,   /* U+6076 */
  0x0000,   /* U+6077 */
  0x0000,   /* U+6078 */
  0x0000,   /* U+6079 */
  0x0000,   /* U+607A */
  0x0000,   /* U+607B */
  0x0000,   /* U+607C */
  0x0000,   /* U+607D */
  0x0000,   /* U+607E */
  0x0000,   /* U+607F */
  0x0000,   /* U+6080 */
  0x0000,   /* U+6081 */
  0x0000,   /* U+6082 */
  0x0000,   /* U+6083 */
  0x0000,   /* U+6084 */
  0x0000,   /* U+6085 */
  0x0000,   /* U+6086 */
  0x0000,   /* U+6087 */
  0x0000,   /* U+6088 */
  0x0000,   /* U+6089 */
  0x0000,   /* U+608A */
  0x0000,   /* U+608B */
  0x0000,   /* U+608C */
  0x0000,   /* U+608D */
  0x0000,   /* U+608E */
  0x0000,   /* U+608F */
  0x0000,   /* U+6090 */
  0x0000,   /* U+6091 */
  0x0000,   /* U+6092 */
  0x0000,   /* U+6093 */
  0x0000,   /* U+6094 */
  0x0000,   /* U+6095 */
  0x0000,   /* U+6096 */
  0x0000,   /* U+6097 */
  0x0000,   /* U+6098 */
  0x0000,   /* U+6099 */
  0x0000,   /* U+609A */
  0x0000,   /* U+609B */
  0x0000,   /* U+609C */
  0x0000,   /* U+609D */
  0x0000,   /* U+609E */
  0x0000,   /* U+609F */
  0x0000,   /* U+60A0 */
  0x0000,   /* U+60A1 */
  0x0000,   /* U+60A2 */
  0x0000,   /* U+60A3 */
  0x0000,   /* U+60A4 */
  0x0000,   /* U+60A5 */
  0x0000,   /* U+60A6 */
  0x0000,   /* U+60A7 */
  0x0000,   /* U+60A8 */
  0x0000,   /* U+60A9 */
  0x0000,   /* U+60AA */
  0x0000,   /* U+60AB */
  0x0000,   /* U+60AC */
  0x0000,   /* U+60AD */
  0x0000,   /* U+60AE */
  0x0000,   /* U+60AF */
  0x0000,   /* U+60B0 */
  0x0000,   /* U+60B1 */
  0x0000,   /* U+60B2 */
  0x0000,   /* U+60B3 */
  0x0000,   /* U+60B4 */
  0x0000,   /* U+60B5 */
  0x0000,   /* U+60B6 */
  0x0000,   /* U+60B7 */
  0x0000,   /* U+60B8 */
  0x0000,   /* U+60B9 */
  0x0000,   /* U+60BA */
  0x0000,   /* U+60BB */
  0x0000,   /* U+60BC */
  0x0000,   /* U+60BD */
  0x0000,   /* U+60BE */
  0x0000,   /* U+60BF */
  0x0000,   /* U+60C0 */
  0x0000,   /* U+60C1 */
  0x0000,   /* U+60C2 */
  0x0000,   /* U+60C3 */
  0x0000,   /* U+60C4 */
  0x0000,   /* U+60C5 */
  0x0000,   /* U+60C6 */
  0x0000,   /* U+60C7 */
  0x0000,   /* U+60C8 */
  0x0000,   /* U+60C9 */
  0x0000,   /* U+60CA */
  0x0000,   /* U+60CB */
  0x0000,   /* U+60CC */
  0x0000,   /* U+60CD */
  0x0000,   /* U+60CE */
  0x0000,   /* U+60CF */
  0x0000,   /* U+60D0 */
  0x0000,   /* U+60D1 */
  0x0000,   /* U+60D2 */
  0x0000,   /* U+60D3 */
  0x0000,   /* U+60D4 */
  0x0000,   /* U+60D5 */
  0x0000,   /* U+60D6 */
  0x0000,   /* U+60D7 */
  0x0000,   /* U+60D8 */
  0x0000,   /* U+60D9 */
  0x0000,   /* U+60DA */
  0x0000,   /* U+60DB */
  0x0000,   /* U+60DC */
  0x0000,   /* U+60DD */
  0x0000,   /* U+60DE */
  0x0000,   /* U+60DF */
  0x0000,   /* U+60E0 */
  0x0000,   /* U+60E1 */
  0x0000,   /* U+60E2 */
  0x0000,   /* U+60E3 */
  0x0000,   /* U+60E4 */
  0x0000,   /* U+60E5 */
  0x0000,   /* U+60E6 */
  0x0000,   /* U+60E7 */
  0x0000,   /* U+60E8 */
  0x0000,   /* U+60E9 */
  0x0000,   /* U+60EA */
  0x0000,   /* U+60EB */
  0x0000,   /* U+60EC */
  0x0000,   /* U+60ED */
  0x0000,   /* U+60EE */
  0x0000,   /* U+60EF */
  0x0000,   /* U+60F0 */
  0x0000,   /* U+60F1 */
  0x0000,   /* U+60F2 */
  0x0000,   /* U+60F3 */
  0x0000,   /* U+60F4 */
  0x0000,   /* U+60F5 */
  0x0000,   /* U+60F6 */
  0x0000,   /* U+60F7 */
  0x0000,   /* U+60F8 */
  0x0000,   /* U+60F9 */
  0x0000,   /* U+60FA */
  0x0000,   /* U+60FB */
  0x0000,   /* U+60FC */
  0x0000,   /* U+60FD */
  0x0000,   /* U+60FE */
  0x0000,   /* U+60FF */
};

uint16 ja_han_page61[]= {
  /* Number of CEs for each character. */
  1, 1, 2, 1, 2, 2, 1, 2, 1, 1, 2, 2, 2, 1, 1, 1,
  2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 1, 1, 2, 2, 2, 1,
  2, 1, 2, 2, 2, 2, 2, 1, 1, 2, 2, 2, 1, 2, 2, 2,
  2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1,
  2, 2, 1, 2, 1, 2, 2, 1, 1, 2, 1, 1, 1, 1, 1, 2,
  2, 2, 2, 1, 2, 1, 2, 2, 1, 1, 1, 2, 2, 1, 2, 1,
  2, 2, 1, 1, 2, 1, 2, 1, 1, 2, 2, 1, 2, 2, 1, 1,
  1, 1, 2, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 1, 2,
  2, 2, 1, 2, 2, 2, 2, 1, 2, 2, 1, 2, 2, 2, 1, 2,
  1, 1, 2, 2, 1, 2, 1, 2, 2, 1, 1, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 1, 2, 2, 1, 2, 1, 2, 1, 1, 2, 1, 2,
  2, 2, 1, 2, 2, 2, 1, 2, 2, 2, 1, 2, 2, 2, 1, 2,
  2, 2, 2, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2,
  1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 1, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 1, 2, 1, 2, 1, 1, 1, 2, 1, 2, 1, 1, 1, 1,

  /* Primary weight 1 for each character. */
  0x633F,   /* U+6100 */
  0x596E,   /* U+6101 */
  0xFB40,   /* U+6102 */
  0x6342,   /* U+6103 */
  0xFB40,   /* U+6104 */
  0xFB40,   /* U+6105 */
  0x633C,   /* U+6106 */
  0xFB40,   /* U+6107 */
  0x5F47,   /* U+6108 */
  0x5F46,   /* U+6109 */
  0xFB40,   /* U+610A */
  0xFB40,   /* U+610B */
  0xFB40,   /* U+610C */
  0x6346,   /* U+610D */
  0x6347,   /* U+610E */
  0x54D8,   /* U+610F */
  0xFB40,   /* U+6110 */
  0xFB40,   /* U+6111 */
  0xFB40,   /* U+6112 */
  0xFB40,   /* U+6113 */
  0xFB40,   /* U+6114 */
  0x633B,   /* U+6115 */
  0xFB40,   /* U+6116 */
  0xFB40,   /* U+6117 */
  0xFB40,   /* U+6118 */
  0xFB40,   /* U+6119 */
  0x5729,   /* U+611A */
  0x54A9,   /* U+611B */
  0xFB40,   /* U+611C */
  0xFB40,   /* U+611D */
  0xFB40,   /* U+611E */
  0x5631,   /* U+611F */
  0xFB40,   /* U+6120 */
  0x6343,   /* U+6121 */
  0xFB40,   /* U+6122 */
  0xFB40,   /* U+6123 */
  0xFB40,   /* U+6124 */
  0xFB40,   /* U+6125 */
  0xFB40,   /* U+6126 */
  0x634B,   /* U+6127 */
  0x634A,   /* U+6128 */
  0xFB40,   /* U+6129 */
  0xFB40,   /* U+612A */
  0xFB40,   /* U+612B */
  0x634F,   /* U+612C */
  0xFB40,   /* U+612D */
  0xFB40,   /* U+612E */
  0xFB40,   /* U+612F */
  0xFB40,   /* U+6130 */
  0xFB40,   /* U+6131 */
  0xFB40,   /* U+6132 */
  0xFB40,   /* U+6133 */
  0x6350,   /* U+6134 */
  0xFB40,   /* U+6135 */
  0xFB40,   /* U+6136 */
  0xFB40,   /* U+6137 */
  0xFB40,   /* U+6138 */
  0xFB40,   /* U+6139 */
  0xFB40,   /* U+613A */
  0xFB40,   /* U+613B */
  0x634E,   /* U+613C */
  0x6351,   /* U+613D */
  0x6349,   /* U+613E */
  0x634D,   /* U+613F */
  0xFB40,   /* U+6140 */
  0xFB40,   /* U+6141 */
  0x6352,   /* U+6142 */
  0xFB40,   /* U+6143 */
  0x6353,   /* U+6144 */
  0xFB40,   /* U+6145 */
  0xFB40,   /* U+6146 */
  0x6348,   /* U+6147 */
  0x5909,   /* U+6148 */
  0xFB40,   /* U+6149 */
  0x634C,   /* U+614A */
  0x5B75,   /* U+614B */
  0x5803,   /* U+614C */
  0x633A,   /* U+614D */
  0x5A3A,   /* U+614E */
  0xFB40,   /* U+614F */
  0xFB40,   /* U+6150 */
  0xFB40,   /* U+6151 */
  0xFB40,   /* U+6152 */
  0x6360,   /* U+6153 */
  0xFB40,   /* U+6154 */
  0x5E78,   /* U+6155 */
  0xFB40,   /* U+6156 */
  0xFB40,   /* U+6157 */
  0x6356,   /* U+6158 */
  0x6357,   /* U+6159 */
  0x6358,   /* U+615A */
  0xFB40,   /* U+615B */
  0xFB40,   /* U+615C */
  0x635F,   /* U+615D */
  0xFB40,   /* U+615E */
  0x635E,   /* U+615F */
  0xFB40,   /* U+6160 */
  0xFB40,   /* U+6161 */
  0x5EEA,   /* U+6162 */
  0x5632,   /* U+6163 */
  0xFB40,   /* U+6164 */
  0x635C,   /* U+6165 */
  0xFB40,   /* U+6166 */
  0x575A,   /* U+6167 */
  0x55D1,   /* U+6168 */
  0xFB40,   /* U+6169 */
  0xFB40,   /* U+616A */
  0x6359,   /* U+616B */
  0xFB40,   /* U+616C */
  0xFB40,   /* U+616D */
  0x5FBF,   /* U+616E */
  0x635B,   /* U+616F */
  0x54D9,   /* U+6170 */
  0x635D,   /* U+6171 */
  0xFB40,   /* U+6172 */
  0x6354,   /* U+6173 */
  0x635A,   /* U+6174 */
  0x6361,   /* U+6175 */
  0x5759,   /* U+6176 */
  0x6355,   /* U+6177 */
  0xFB40,   /* U+6178 */
  0xFB40,   /* U+6179 */
  0xFB40,   /* U+617A */
  0xFB40,   /* U+617B */
  0xFB40,   /* U+617C */
  0xFB40,   /* U+617D */
  0x5F86,   /* U+617E */
  0xFB40,   /* U+617F */
  0xFB40,   /* U+6180 */
  0xFB40,   /* U+6181 */
  0x5F54,   /* U+6182 */
  0xFB40,   /* U+6183 */
  0xFB40,   /* U+6184 */
  0xFB40,   /* U+6185 */
  0xFB40,   /* U+6186 */
  0x6364,   /* U+6187 */
  0xFB40,   /* U+6188 */
  0xFB40,   /* U+6189 */
  0x6368,   /* U+618A */
  0xFB40,   /* U+618B */
  0xFB40,   /* U+618C */
  0xFB40,   /* U+618D */
  0x5B3F,   /* U+618E */
  0xFB40,   /* U+618F */
  0x6000,   /* U+6190 */
  0x6369,   /* U+6191 */
  0xFB40,   /* U+6192 */
  0xFB40,   /* U+6193 */
  0x6366,   /* U+6194 */
  0xFB40,   /* U+6195 */
  0x6363,   /* U+6196 */
  0xFB40,   /* U+6197 */
  0xFB40,   /* U+6198 */
  0x6362,   /* U+6199 */
  0x6367,   /* U+619A */
  0xFB40,   /* U+619B */
  0xFB40,   /* U+619C */
  0xFB40,   /* U+619D */
  0xFB40,   /* U+619E */
  0xFB40,   /* U+619F */
  0xFB40,   /* U+61A0 */
  0xFB40,   /* U+61A1 */
  0xFB40,   /* U+61A2 */
  0xFB40,   /* U+61A3 */
  0x5E3F,   /* U+61A4 */
  0xFB40,   /* U+61A5 */
  0xFB40,   /* U+61A6 */
  0x5CCB,   /* U+61A7 */
  0xFB40,   /* U+61A8 */
  0x575B,   /* U+61A9 */
  0xFB40,   /* U+61AA */
  0x636A,   /* U+61AB */
  0x6365,   /* U+61AC */
  0xFB40,   /* U+61AD */
  0x636B,   /* U+61AE */
  0xFB40,   /* U+61AF */
  0xFB40,   /* U+61B0 */
  0xFB40,   /* U+61B1 */
  0x5790,   /* U+61B2 */
  0xFB40,   /* U+61B3 */
  0xFB40,   /* U+61B4 */
  0xFB40,   /* U+61B5 */
  0x5570,   /* U+61B6 */
  0xFB40,   /* U+61B7 */
  0xFB40,   /* U+61B8 */
  0xFB40,   /* U+61B9 */
  0x6373,   /* U+61BA */
  0xFB40,   /* U+61BB */
  0xFB40,   /* U+61BC */
  0xFB40,   /* U+61BD */
  0x5633,   /* U+61BE */
  0xFB40,   /* U+61BF */
  0xFB40,   /* U+61C0 */
  0xFB40,   /* U+61C1 */
  0xFB40,   /* U+61C2 */
  0x6371,   /* U+61C3 */
  0xFB40,   /* U+61C4 */
  0xFB40,   /* U+61C5 */
  0x6372,   /* U+61C6 */
  0x5858,   /* U+61C7 */
  0x6370,   /* U+61C8 */
  0x636E,   /* U+61C9 */
  0x636D,   /* U+61CA */
  0x6374,   /* U+61CB */
  0x636C,   /* U+61CC */
  0x6376,   /* U+61CD */
  0xFB40,   /* U+61CE */
  0xFB40,   /* U+61CF */
  0x55BA,   /* U+61D0 */
  0xFB40,   /* U+61D1 */
  0xFB40,   /* U+61D2 */
  0xFB40,   /* U+61D3 */
  0xFB40,   /* U+61D4 */
  0xFB40,   /* U+61D5 */
  0xFB40,   /* U+61D6 */
  0xFB40,   /* U+61D7 */
  0xFB40,   /* U+61D8 */
  0xFB40,   /* U+61D9 */
  0xFB40,   /* U+61DA */
  0xFB40,   /* U+61DB */
  0xFB40,   /* U+61DC */
  0xFB40,   /* U+61DD */
  0xFB40,   /* U+61DE */
  0xFB40,   /* U+61DF */
  0xFB40,   /* U+61E0 */
  0xFB40,   /* U+61E1 */
  0xFB40,   /* U+61E2 */
  0x6378,   /* U+61E3 */
  0xFB40,   /* U+61E4 */
  0xFB40,   /* U+61E5 */
  0x6377,   /* U+61E6 */
  0xFB40,   /* U+61E7 */
  0xFB40,   /* U+61E8 */
  0xFB40,   /* U+61E9 */
  0xFB40,   /* U+61EA */
  0xFB40,   /* U+61EB */
  0xFB40,   /* U+61EC */
  0xFB40,   /* U+61ED */
  0xFB40,   /* U+61EE */
  0xFB40,   /* U+61EF */
  0xFB40,   /* U+61F0 */
  0xFB40,   /* U+61F1 */
  0x5C03,   /* U+61F2 */
  0xFB40,   /* U+61F3 */
  0x637B,   /* U+61F4 */
  0xFB40,   /* U+61F5 */
  0x6379,   /* U+61F6 */
  0x636F,   /* U+61F7 */
  0x5791,   /* U+61F8 */
  0xFB40,   /* U+61F9 */
  0x637A,   /* U+61FA */
  0xFB40,   /* U+61FB */
  0x637E,   /* U+61FC */
  0x637D,   /* U+61FD */
  0x637F,   /* U+61FE */
  0x637C,   /* U+61FF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+6100 */
  0x0020,   /* U+6101 */
  0x0020,   /* U+6102 */
  0x0020,   /* U+6103 */
  0x0020,   /* U+6104 */
  0x0020,   /* U+6105 */
  0x0020,   /* U+6106 */
  0x0020,   /* U+6107 */
  0x0020,   /* U+6108 */
  0x0020,   /* U+6109 */
  0x0020,   /* U+610A */
  0x0020,   /* U+610B */
  0x0020,   /* U+610C */
  0x0020,   /* U+610D */
  0x0020,   /* U+610E */
  0x0020,   /* U+610F */
  0x0020,   /* U+6110 */
  0x0020,   /* U+6111 */
  0x0020,   /* U+6112 */
  0x0020,   /* U+6113 */
  0x0020,   /* U+6114 */
  0x0020,   /* U+6115 */
  0x0020,   /* U+6116 */
  0x0020,   /* U+6117 */
  0x0020,   /* U+6118 */
  0x0020,   /* U+6119 */
  0x0020,   /* U+611A */
  0x0020,   /* U+611B */
  0x0020,   /* U+611C */
  0x0020,   /* U+611D */
  0x0020,   /* U+611E */
  0x0020,   /* U+611F */
  0x0020,   /* U+6120 */
  0x0020,   /* U+6121 */
  0x0020,   /* U+6122 */
  0x0020,   /* U+6123 */
  0x0020,   /* U+6124 */
  0x0020,   /* U+6125 */
  0x0020,   /* U+6126 */
  0x0020,   /* U+6127 */
  0x0020,   /* U+6128 */
  0x0020,   /* U+6129 */
  0x0020,   /* U+612A */
  0x0020,   /* U+612B */
  0x0020,   /* U+612C */
  0x0020,   /* U+612D */
  0x0020,   /* U+612E */
  0x0020,   /* U+612F */
  0x0020,   /* U+6130 */
  0x0020,   /* U+6131 */
  0x0020,   /* U+6132 */
  0x0020,   /* U+6133 */
  0x0020,   /* U+6134 */
  0x0020,   /* U+6135 */
  0x0020,   /* U+6136 */
  0x0020,   /* U+6137 */
  0x0020,   /* U+6138 */
  0x0020,   /* U+6139 */
  0x0020,   /* U+613A */
  0x0020,   /* U+613B */
  0x0020,   /* U+613C */
  0x0020,   /* U+613D */
  0x0020,   /* U+613E */
  0x0020,   /* U+613F */
  0x0020,   /* U+6140 */
  0x0020,   /* U+6141 */
  0x0020,   /* U+6142 */
  0x0020,   /* U+6143 */
  0x0020,   /* U+6144 */
  0x0020,   /* U+6145 */
  0x0020,   /* U+6146 */
  0x0020,   /* U+6147 */
  0x0020,   /* U+6148 */
  0x0020,   /* U+6149 */
  0x0020,   /* U+614A */
  0x0020,   /* U+614B */
  0x0020,   /* U+614C */
  0x0020,   /* U+614D */
  0x0020,   /* U+614E */
  0x0020,   /* U+614F */
  0x0020,   /* U+6150 */
  0x0020,   /* U+6151 */
  0x0020,   /* U+6152 */
  0x0020,   /* U+6153 */
  0x0020,   /* U+6154 */
  0x0020,   /* U+6155 */
  0x0020,   /* U+6156 */
  0x0020,   /* U+6157 */
  0x0020,   /* U+6158 */
  0x0020,   /* U+6159 */
  0x0020,   /* U+615A */
  0x0020,   /* U+615B */
  0x0020,   /* U+615C */
  0x0020,   /* U+615D */
  0x0020,   /* U+615E */
  0x0020,   /* U+615F */
  0x0020,   /* U+6160 */
  0x0020,   /* U+6161 */
  0x0020,   /* U+6162 */
  0x0020,   /* U+6163 */
  0x0020,   /* U+6164 */
  0x0020,   /* U+6165 */
  0x0020,   /* U+6166 */
  0x0020,   /* U+6167 */
  0x0020,   /* U+6168 */
  0x0020,   /* U+6169 */
  0x0020,   /* U+616A */
  0x0020,   /* U+616B */
  0x0020,   /* U+616C */
  0x0020,   /* U+616D */
  0x0020,   /* U+616E */
  0x0020,   /* U+616F */
  0x0020,   /* U+6170 */
  0x0020,   /* U+6171 */
  0x0020,   /* U+6172 */
  0x0020,   /* U+6173 */
  0x0020,   /* U+6174 */
  0x0020,   /* U+6175 */
  0x0020,   /* U+6176 */
  0x0020,   /* U+6177 */
  0x0020,   /* U+6178 */
  0x0020,   /* U+6179 */
  0x0020,   /* U+617A */
  0x0020,   /* U+617B */
  0x0020,   /* U+617C */
  0x0020,   /* U+617D */
  0x0020,   /* U+617E */
  0x0020,   /* U+617F */
  0x0020,   /* U+6180 */
  0x0020,   /* U+6181 */
  0x0020,   /* U+6182 */
  0x0020,   /* U+6183 */
  0x0020,   /* U+6184 */
  0x0020,   /* U+6185 */
  0x0020,   /* U+6186 */
  0x0020,   /* U+6187 */
  0x0020,   /* U+6188 */
  0x0020,   /* U+6189 */
  0x0020,   /* U+618A */
  0x0020,   /* U+618B */
  0x0020,   /* U+618C */
  0x0020,   /* U+618D */
  0x0020,   /* U+618E */
  0x0020,   /* U+618F */
  0x0020,   /* U+6190 */
  0x0020,   /* U+6191 */
  0x0020,   /* U+6192 */
  0x0020,   /* U+6193 */
  0x0020,   /* U+6194 */
  0x0020,   /* U+6195 */
  0x0020,   /* U+6196 */
  0x0020,   /* U+6197 */
  0x0020,   /* U+6198 */
  0x0020,   /* U+6199 */
  0x0020,   /* U+619A */
  0x0020,   /* U+619B */
  0x0020,   /* U+619C */
  0x0020,   /* U+619D */
  0x0020,   /* U+619E */
  0x0020,   /* U+619F */
  0x0020,   /* U+61A0 */
  0x0020,   /* U+61A1 */
  0x0020,   /* U+61A2 */
  0x0020,   /* U+61A3 */
  0x0020,   /* U+61A4 */
  0x0020,   /* U+61A5 */
  0x0020,   /* U+61A6 */
  0x0020,   /* U+61A7 */
  0x0020,   /* U+61A8 */
  0x0020,   /* U+61A9 */
  0x0020,   /* U+61AA */
  0x0020,   /* U+61AB */
  0x0020,   /* U+61AC */
  0x0020,   /* U+61AD */
  0x0020,   /* U+61AE */
  0x0020,   /* U+61AF */
  0x0020,   /* U+61B0 */
  0x0020,   /* U+61B1 */
  0x0020,   /* U+61B2 */
  0x0020,   /* U+61B3 */
  0x0020,   /* U+61B4 */
  0x0020,   /* U+61B5 */
  0x0020,   /* U+61B6 */
  0x0020,   /* U+61B7 */
  0x0020,   /* U+61B8 */
  0x0020,   /* U+61B9 */
  0x0020,   /* U+61BA */
  0x0020,   /* U+61BB */
  0x0020,   /* U+61BC */
  0x0020,   /* U+61BD */
  0x0020,   /* U+61BE */
  0x0020,   /* U+61BF */
  0x0020,   /* U+61C0 */
  0x0020,   /* U+61C1 */
  0x0020,   /* U+61C2 */
  0x0020,   /* U+61C3 */
  0x0020,   /* U+61C4 */
  0x0020,   /* U+61C5 */
  0x0020,   /* U+61C6 */
  0x0020,   /* U+61C7 */
  0x0020,   /* U+61C8 */
  0x0020,   /* U+61C9 */
  0x0020,   /* U+61CA */
  0x0020,   /* U+61CB */
  0x0020,   /* U+61CC */
  0x0020,   /* U+61CD */
  0x0020,   /* U+61CE */
  0x0020,   /* U+61CF */
  0x0020,   /* U+61D0 */
  0x0020,   /* U+61D1 */
  0x0020,   /* U+61D2 */
  0x0020,   /* U+61D3 */
  0x0020,   /* U+61D4 */
  0x0020,   /* U+61D5 */
  0x0020,   /* U+61D6 */
  0x0020,   /* U+61D7 */
  0x0020,   /* U+61D8 */
  0x0020,   /* U+61D9 */
  0x0020,   /* U+61DA */
  0x0020,   /* U+61DB */
  0x0020,   /* U+61DC */
  0x0020,   /* U+61DD */
  0x0020,   /* U+61DE */
  0x0020,   /* U+61DF */
  0x0020,   /* U+61E0 */
  0x0020,   /* U+61E1 */
  0x0020,   /* U+61E2 */
  0x0020,   /* U+61E3 */
  0x0020,   /* U+61E4 */
  0x0020,   /* U+61E5 */
  0x0020,   /* U+61E6 */
  0x0020,   /* U+61E7 */
  0x0020,   /* U+61E8 */
  0x0020,   /* U+61E9 */
  0x0020,   /* U+61EA */
  0x0020,   /* U+61EB */
  0x0020,   /* U+61EC */
  0x0020,   /* U+61ED */
  0x0020,   /* U+61EE */
  0x0020,   /* U+61EF */
  0x0020,   /* U+61F0 */
  0x0020,   /* U+61F1 */
  0x0020,   /* U+61F2 */
  0x0020,   /* U+61F3 */
  0x0020,   /* U+61F4 */
  0x0020,   /* U+61F5 */
  0x0020,   /* U+61F6 */
  0x0020,   /* U+61F7 */
  0x0020,   /* U+61F8 */
  0x0020,   /* U+61F9 */
  0x0020,   /* U+61FA */
  0x0020,   /* U+61FB */
  0x0020,   /* U+61FC */
  0x0020,   /* U+61FD */
  0x0020,   /* U+61FE */
  0x0020,   /* U+61FF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+6100 */
  0x0002,   /* U+6101 */
  0x0002,   /* U+6102 */
  0x0002,   /* U+6103 */
  0x0002,   /* U+6104 */
  0x0002,   /* U+6105 */
  0x0002,   /* U+6106 */
  0x0002,   /* U+6107 */
  0x0002,   /* U+6108 */
  0x0002,   /* U+6109 */
  0x0002,   /* U+610A */
  0x0002,   /* U+610B */
  0x0002,   /* U+610C */
  0x0002,   /* U+610D */
  0x0002,   /* U+610E */
  0x0002,   /* U+610F */
  0x0002,   /* U+6110 */
  0x0002,   /* U+6111 */
  0x0002,   /* U+6112 */
  0x0002,   /* U+6113 */
  0x0002,   /* U+6114 */
  0x0002,   /* U+6115 */
  0x0002,   /* U+6116 */
  0x0002,   /* U+6117 */
  0x0002,   /* U+6118 */
  0x0002,   /* U+6119 */
  0x0002,   /* U+611A */
  0x0002,   /* U+611B */
  0x0002,   /* U+611C */
  0x0002,   /* U+611D */
  0x0002,   /* U+611E */
  0x0002,   /* U+611F */
  0x0002,   /* U+6120 */
  0x0002,   /* U+6121 */
  0x0002,   /* U+6122 */
  0x0002,   /* U+6123 */
  0x0002,   /* U+6124 */
  0x0002,   /* U+6125 */
  0x0002,   /* U+6126 */
  0x0002,   /* U+6127 */
  0x0002,   /* U+6128 */
  0x0002,   /* U+6129 */
  0x0002,   /* U+612A */
  0x0002,   /* U+612B */
  0x0002,   /* U+612C */
  0x0002,   /* U+612D */
  0x0002,   /* U+612E */
  0x0002,   /* U+612F */
  0x0002,   /* U+6130 */
  0x0002,   /* U+6131 */
  0x0002,   /* U+6132 */
  0x0002,   /* U+6133 */
  0x0002,   /* U+6134 */
  0x0002,   /* U+6135 */
  0x0002,   /* U+6136 */
  0x0002,   /* U+6137 */
  0x0002,   /* U+6138 */
  0x0002,   /* U+6139 */
  0x0002,   /* U+613A */
  0x0002,   /* U+613B */
  0x0002,   /* U+613C */
  0x0002,   /* U+613D */
  0x0002,   /* U+613E */
  0x0002,   /* U+613F */
  0x0002,   /* U+6140 */
  0x0002,   /* U+6141 */
  0x0002,   /* U+6142 */
  0x0002,   /* U+6143 */
  0x0002,   /* U+6144 */
  0x0002,   /* U+6145 */
  0x0002,   /* U+6146 */
  0x0002,   /* U+6147 */
  0x0002,   /* U+6148 */
  0x0002,   /* U+6149 */
  0x0002,   /* U+614A */
  0x0002,   /* U+614B */
  0x0002,   /* U+614C */
  0x0002,   /* U+614D */
  0x0002,   /* U+614E */
  0x0002,   /* U+614F */
  0x0002,   /* U+6150 */
  0x0002,   /* U+6151 */
  0x0002,   /* U+6152 */
  0x0002,   /* U+6153 */
  0x0002,   /* U+6154 */
  0x0002,   /* U+6155 */
  0x0002,   /* U+6156 */
  0x0002,   /* U+6157 */
  0x0002,   /* U+6158 */
  0x0002,   /* U+6159 */
  0x0002,   /* U+615A */
  0x0002,   /* U+615B */
  0x0002,   /* U+615C */
  0x0002,   /* U+615D */
  0x0002,   /* U+615E */
  0x0002,   /* U+615F */
  0x0002,   /* U+6160 */
  0x0002,   /* U+6161 */
  0x0002,   /* U+6162 */
  0x0002,   /* U+6163 */
  0x0002,   /* U+6164 */
  0x0002,   /* U+6165 */
  0x0002,   /* U+6166 */
  0x0002,   /* U+6167 */
  0x0002,   /* U+6168 */
  0x0002,   /* U+6169 */
  0x0002,   /* U+616A */
  0x0002,   /* U+616B */
  0x0002,   /* U+616C */
  0x0002,   /* U+616D */
  0x0002,   /* U+616E */
  0x0002,   /* U+616F */
  0x0002,   /* U+6170 */
  0x0002,   /* U+6171 */
  0x0002,   /* U+6172 */
  0x0002,   /* U+6173 */
  0x0002,   /* U+6174 */
  0x0002,   /* U+6175 */
  0x0002,   /* U+6176 */
  0x0002,   /* U+6177 */
  0x0002,   /* U+6178 */
  0x0002,   /* U+6179 */
  0x0002,   /* U+617A */
  0x0002,   /* U+617B */
  0x0002,   /* U+617C */
  0x0002,   /* U+617D */
  0x0002,   /* U+617E */
  0x0002,   /* U+617F */
  0x0002,   /* U+6180 */
  0x0002,   /* U+6181 */
  0x0002,   /* U+6182 */
  0x0002,   /* U+6183 */
  0x0002,   /* U+6184 */
  0x0002,   /* U+6185 */
  0x0002,   /* U+6186 */
  0x0002,   /* U+6187 */
  0x0002,   /* U+6188 */
  0x0002,   /* U+6189 */
  0x0002,   /* U+618A */
  0x0002,   /* U+618B */
  0x0002,   /* U+618C */
  0x0002,   /* U+618D */
  0x0002,   /* U+618E */
  0x0002,   /* U+618F */
  0x0002,   /* U+6190 */
  0x0002,   /* U+6191 */
  0x0002,   /* U+6192 */
  0x0002,   /* U+6193 */
  0x0002,   /* U+6194 */
  0x0002,   /* U+6195 */
  0x0002,   /* U+6196 */
  0x0002,   /* U+6197 */
  0x0002,   /* U+6198 */
  0x0002,   /* U+6199 */
  0x0002,   /* U+619A */
  0x0002,   /* U+619B */
  0x0002,   /* U+619C */
  0x0002,   /* U+619D */
  0x0002,   /* U+619E */
  0x0002,   /* U+619F */
  0x0002,   /* U+61A0 */
  0x0002,   /* U+61A1 */
  0x0002,   /* U+61A2 */
  0x0002,   /* U+61A3 */
  0x0002,   /* U+61A4 */
  0x0002,   /* U+61A5 */
  0x0002,   /* U+61A6 */
  0x0002,   /* U+61A7 */
  0x0002,   /* U+61A8 */
  0x0002,   /* U+61A9 */
  0x0002,   /* U+61AA */
  0x0002,   /* U+61AB */
  0x0002,   /* U+61AC */
  0x0002,   /* U+61AD */
  0x0002,   /* U+61AE */
  0x0002,   /* U+61AF */
  0x0002,   /* U+61B0 */
  0x0002,   /* U+61B1 */
  0x0002,   /* U+61B2 */
  0x0002,   /* U+61B3 */
  0x0002,   /* U+61B4 */
  0x0002,   /* U+61B5 */
  0x0002,   /* U+61B6 */
  0x0002,   /* U+61B7 */
  0x0002,   /* U+61B8 */
  0x0002,   /* U+61B9 */
  0x0002,   /* U+61BA */
  0x0002,   /* U+61BB */
  0x0002,   /* U+61BC */
  0x0002,   /* U+61BD */
  0x0002,   /* U+61BE */
  0x0002,   /* U+61BF */
  0x0002,   /* U+61C0 */
  0x0002,   /* U+61C1 */
  0x0002,   /* U+61C2 */
  0x0002,   /* U+61C3 */
  0x0002,   /* U+61C4 */
  0x0002,   /* U+61C5 */
  0x0002,   /* U+61C6 */
  0x0002,   /* U+61C7 */
  0x0002,   /* U+61C8 */
  0x0002,   /* U+61C9 */
  0x0002,   /* U+61CA */
  0x0002,   /* U+61CB */
  0x0002,   /* U+61CC */
  0x0002,   /* U+61CD */
  0x0002,   /* U+61CE */
  0x0002,   /* U+61CF */
  0x0002,   /* U+61D0 */
  0x0002,   /* U+61D1 */
  0x0002,   /* U+61D2 */
  0x0002,   /* U+61D3 */
  0x0002,   /* U+61D4 */
  0x0002,   /* U+61D5 */
  0x0002,   /* U+61D6 */
  0x0002,   /* U+61D7 */
  0x0002,   /* U+61D8 */
  0x0002,   /* U+61D9 */
  0x0002,   /* U+61DA */
  0x0002,   /* U+61DB */
  0x0002,   /* U+61DC */
  0x0002,   /* U+61DD */
  0x0002,   /* U+61DE */
  0x0002,   /* U+61DF */
  0x0002,   /* U+61E0 */
  0x0002,   /* U+61E1 */
  0x0002,   /* U+61E2 */
  0x0002,   /* U+61E3 */
  0x0002,   /* U+61E4 */
  0x0002,   /* U+61E5 */
  0x0002,   /* U+61E6 */
  0x0002,   /* U+61E7 */
  0x0002,   /* U+61E8 */
  0x0002,   /* U+61E9 */
  0x0002,   /* U+61EA */
  0x0002,   /* U+61EB */
  0x0002,   /* U+61EC */
  0x0002,   /* U+61ED */
  0x0002,   /* U+61EE */
  0x0002,   /* U+61EF */
  0x0002,   /* U+61F0 */
  0x0002,   /* U+61F1 */
  0x0002,   /* U+61F2 */
  0x0002,   /* U+61F3 */
  0x0002,   /* U+61F4 */
  0x0002,   /* U+61F5 */
  0x0002,   /* U+61F6 */
  0x0002,   /* U+61F7 */
  0x0002,   /* U+61F8 */
  0x0002,   /* U+61F9 */
  0x0002,   /* U+61FA */
  0x0002,   /* U+61FB */
  0x0002,   /* U+61FC */
  0x0002,   /* U+61FD */
  0x0002,   /* U+61FE */
  0x0002,   /* U+61FF */

  /* Primary weight 2 for each character. */
  0x0000,   /* U+6100 */
  0x0000,   /* U+6101 */
  0xE102,   /* U+6102 */
  0x0000,   /* U+6103 */
  0xE104,   /* U+6104 */
  0xE105,   /* U+6105 */
  0x0000,   /* U+6106 */
  0xE107,   /* U+6107 */
  0x0000,   /* U+6108 */
  0x0000,   /* U+6109 */
  0xE10A,   /* U+610A */
  0xE10B,   /* U+610B */
  0xE10C,   /* U+610C */
  0x0000,   /* U+610D */
  0x0000,   /* U+610E */
  0x0000,   /* U+610F */
  0xE110,   /* U+6110 */
  0xE111,   /* U+6111 */
  0xE112,   /* U+6112 */
  0xE113,   /* U+6113 */
  0xE114,   /* U+6114 */
  0x0000,   /* U+6115 */
  0xE116,   /* U+6116 */
  0xE117,   /* U+6117 */
  0xE118,   /* U+6118 */
  0xE119,   /* U+6119 */
  0x0000,   /* U+611A */
  0x0000,   /* U+611B */
  0xE11C,   /* U+611C */
  0xE11D,   /* U+611D */
  0xE11E,   /* U+611E */
  0x0000,   /* U+611F */
  0xE120,   /* U+6120 */
  0x0000,   /* U+6121 */
  0xE122,   /* U+6122 */
  0xE123,   /* U+6123 */
  0xE124,   /* U+6124 */
  0xE125,   /* U+6125 */
  0xE126,   /* U+6126 */
  0x0000,   /* U+6127 */
  0x0000,   /* U+6128 */
  0xE129,   /* U+6129 */
  0xE12A,   /* U+612A */
  0xE12B,   /* U+612B */
  0x0000,   /* U+612C */
  0xE12D,   /* U+612D */
  0xE12E,   /* U+612E */
  0xE12F,   /* U+612F */
  0xE130,   /* U+6130 */
  0xE131,   /* U+6131 */
  0xE132,   /* U+6132 */
  0xE133,   /* U+6133 */
  0x0000,   /* U+6134 */
  0xE135,   /* U+6135 */
  0xE136,   /* U+6136 */
  0xE137,   /* U+6137 */
  0xE138,   /* U+6138 */
  0xE139,   /* U+6139 */
  0xE13A,   /* U+613A */
  0xE13B,   /* U+613B */
  0x0000,   /* U+613C */
  0x0000,   /* U+613D */
  0x0000,   /* U+613E */
  0x0000,   /* U+613F */
  0xE140,   /* U+6140 */
  0xE141,   /* U+6141 */
  0x0000,   /* U+6142 */
  0xE143,   /* U+6143 */
  0x0000,   /* U+6144 */
  0xE145,   /* U+6145 */
  0xE146,   /* U+6146 */
  0x0000,   /* U+6147 */
  0x0000,   /* U+6148 */
  0xE149,   /* U+6149 */
  0x0000,   /* U+614A */
  0x0000,   /* U+614B */
  0x0000,   /* U+614C */
  0x0000,   /* U+614D */
  0x0000,   /* U+614E */
  0xE14F,   /* U+614F */
  0xE150,   /* U+6150 */
  0xE151,   /* U+6151 */
  0xE152,   /* U+6152 */
  0x0000,   /* U+6153 */
  0xE154,   /* U+6154 */
  0x0000,   /* U+6155 */
  0xE156,   /* U+6156 */
  0xE157,   /* U+6157 */
  0x0000,   /* U+6158 */
  0x0000,   /* U+6159 */
  0x0000,   /* U+615A */
  0xE15B,   /* U+615B */
  0xE15C,   /* U+615C */
  0x0000,   /* U+615D */
  0xE15E,   /* U+615E */
  0x0000,   /* U+615F */
  0xE160,   /* U+6160 */
  0xE161,   /* U+6161 */
  0x0000,   /* U+6162 */
  0x0000,   /* U+6163 */
  0xE164,   /* U+6164 */
  0x0000,   /* U+6165 */
  0xE166,   /* U+6166 */
  0x0000,   /* U+6167 */
  0x0000,   /* U+6168 */
  0xE169,   /* U+6169 */
  0xE16A,   /* U+616A */
  0x0000,   /* U+616B */
  0xE16C,   /* U+616C */
  0xE16D,   /* U+616D */
  0x0000,   /* U+616E */
  0x0000,   /* U+616F */
  0x0000,   /* U+6170 */
  0x0000,   /* U+6171 */
  0xE172,   /* U+6172 */
  0x0000,   /* U+6173 */
  0x0000,   /* U+6174 */
  0x0000,   /* U+6175 */
  0x0000,   /* U+6176 */
  0x0000,   /* U+6177 */
  0xE178,   /* U+6178 */
  0xE179,   /* U+6179 */
  0xE17A,   /* U+617A */
  0xE17B,   /* U+617B */
  0xE17C,   /* U+617C */
  0xE17D,   /* U+617D */
  0x0000,   /* U+617E */
  0xE17F,   /* U+617F */
  0xE180,   /* U+6180 */
  0xE181,   /* U+6181 */
  0x0000,   /* U+6182 */
  0xE183,   /* U+6183 */
  0xE184,   /* U+6184 */
  0xE185,   /* U+6185 */
  0xE186,   /* U+6186 */
  0x0000,   /* U+6187 */
  0xE188,   /* U+6188 */
  0xE189,   /* U+6189 */
  0x0000,   /* U+618A */
  0xE18B,   /* U+618B */
  0xE18C,   /* U+618C */
  0xE18D,   /* U+618D */
  0x0000,   /* U+618E */
  0xE18F,   /* U+618F */
  0x0000,   /* U+6190 */
  0x0000,   /* U+6191 */
  0xE192,   /* U+6192 */
  0xE193,   /* U+6193 */
  0x0000,   /* U+6194 */
  0xE195,   /* U+6195 */
  0x0000,   /* U+6196 */
  0xE197,   /* U+6197 */
  0xE198,   /* U+6198 */
  0x0000,   /* U+6199 */
  0x0000,   /* U+619A */
  0xE19B,   /* U+619B */
  0xE19C,   /* U+619C */
  0xE19D,   /* U+619D */
  0xE19E,   /* U+619E */
  0xE19F,   /* U+619F */
  0xE1A0,   /* U+61A0 */
  0xE1A1,   /* U+61A1 */
  0xE1A2,   /* U+61A2 */
  0xE1A3,   /* U+61A3 */
  0x0000,   /* U+61A4 */
  0xE1A5,   /* U+61A5 */
  0xE1A6,   /* U+61A6 */
  0x0000,   /* U+61A7 */
  0xE1A8,   /* U+61A8 */
  0x0000,   /* U+61A9 */
  0xE1AA,   /* U+61AA */
  0x0000,   /* U+61AB */
  0x0000,   /* U+61AC */
  0xE1AD,   /* U+61AD */
  0x0000,   /* U+61AE */
  0xE1AF,   /* U+61AF */
  0xE1B0,   /* U+61B0 */
  0xE1B1,   /* U+61B1 */
  0x0000,   /* U+61B2 */
  0xE1B3,   /* U+61B3 */
  0xE1B4,   /* U+61B4 */
  0xE1B5,   /* U+61B5 */
  0x0000,   /* U+61B6 */
  0xE1B7,   /* U+61B7 */
  0xE1B8,   /* U+61B8 */
  0xE1B9,   /* U+61B9 */
  0x0000,   /* U+61BA */
  0xE1BB,   /* U+61BB */
  0xE1BC,   /* U+61BC */
  0xE1BD,   /* U+61BD */
  0x0000,   /* U+61BE */
  0xE1BF,   /* U+61BF */
  0xE1C0,   /* U+61C0 */
  0xE1C1,   /* U+61C1 */
  0xE1C2,   /* U+61C2 */
  0x0000,   /* U+61C3 */
  0xE1C4,   /* U+61C4 */
  0xE1C5,   /* U+61C5 */
  0x0000,   /* U+61C6 */
  0x0000,   /* U+61C7 */
  0x0000,   /* U+61C8 */
  0x0000,   /* U+61C9 */
  0x0000,   /* U+61CA */
  0x0000,   /* U+61CB */
  0x0000,   /* U+61CC */
  0x0000,   /* U+61CD */
  0xE1CE,   /* U+61CE */
  0xE1CF,   /* U+61CF */
  0x0000,   /* U+61D0 */
  0xE1D1,   /* U+61D1 */
  0xE1D2,   /* U+61D2 */
  0xE1D3,   /* U+61D3 */
  0xE1D4,   /* U+61D4 */
  0xE1D5,   /* U+61D5 */
  0xE1D6,   /* U+61D6 */
  0xE1D7,   /* U+61D7 */
  0xE1D8,   /* U+61D8 */
  0xE1D9,   /* U+61D9 */
  0xE1DA,   /* U+61DA */
  0xE1DB,   /* U+61DB */
  0xE1DC,   /* U+61DC */
  0xE1DD,   /* U+61DD */
  0xE1DE,   /* U+61DE */
  0xE1DF,   /* U+61DF */
  0xE1E0,   /* U+61E0 */
  0xE1E1,   /* U+61E1 */
  0xE1E2,   /* U+61E2 */
  0x0000,   /* U+61E3 */
  0xE1E4,   /* U+61E4 */
  0xE1E5,   /* U+61E5 */
  0x0000,   /* U+61E6 */
  0xE1E7,   /* U+61E7 */
  0xE1E8,   /* U+61E8 */
  0xE1E9,   /* U+61E9 */
  0xE1EA,   /* U+61EA */
  0xE1EB,   /* U+61EB */
  0xE1EC,   /* U+61EC */
  0xE1ED,   /* U+61ED */
  0xE1EE,   /* U+61EE */
  0xE1EF,   /* U+61EF */
  0xE1F0,   /* U+61F0 */
  0xE1F1,   /* U+61F1 */
  0x0000,   /* U+61F2 */
  0xE1F3,   /* U+61F3 */
  0x0000,   /* U+61F4 */
  0xE1F5,   /* U+61F5 */
  0x0000,   /* U+61F6 */
  0x0000,   /* U+61F7 */
  0x0000,   /* U+61F8 */
  0xE1F9,   /* U+61F9 */
  0x0000,   /* U+61FA */
  0xE1FB,   /* U+61FB */
  0x0000,   /* U+61FC */
  0x0000,   /* U+61FD */
  0x0000,   /* U+61FE */
  0x0000,   /* U+61FF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+6100 */
  0x0000,   /* U+6101 */
  0x0000,   /* U+6102 */
  0x0000,   /* U+6103 */
  0x0000,   /* U+6104 */
  0x0000,   /* U+6105 */
  0x0000,   /* U+6106 */
  0x0000,   /* U+6107 */
  0x0000,   /* U+6108 */
  0x0000,   /* U+6109 */
  0x0000,   /* U+610A */
  0x0000,   /* U+610B */
  0x0000,   /* U+610C */
  0x0000,   /* U+610D */
  0x0000,   /* U+610E */
  0x0000,   /* U+610F */
  0x0000,   /* U+6110 */
  0x0000,   /* U+6111 */
  0x0000,   /* U+6112 */
  0x0000,   /* U+6113 */
  0x0000,   /* U+6114 */
  0x0000,   /* U+6115 */
  0x0000,   /* U+6116 */
  0x0000,   /* U+6117 */
  0x0000,   /* U+6118 */
  0x0000,   /* U+6119 */
  0x0000,   /* U+611A */
  0x0000,   /* U+611B */
  0x0000,   /* U+611C */
  0x0000,   /* U+611D */
  0x0000,   /* U+611E */
  0x0000,   /* U+611F */
  0x0000,   /* U+6120 */
  0x0000,   /* U+6121 */
  0x0000,   /* U+6122 */
  0x0000,   /* U+6123 */
  0x0000,   /* U+6124 */
  0x0000,   /* U+6125 */
  0x0000,   /* U+6126 */
  0x0000,   /* U+6127 */
  0x0000,   /* U+6128 */
  0x0000,   /* U+6129 */
  0x0000,   /* U+612A */
  0x0000,   /* U+612B */
  0x0000,   /* U+612C */
  0x0000,   /* U+612D */
  0x0000,   /* U+612E */
  0x0000,   /* U+612F */
  0x0000,   /* U+6130 */
  0x0000,   /* U+6131 */
  0x0000,   /* U+6132 */
  0x0000,   /* U+6133 */
  0x0000,   /* U+6134 */
  0x0000,   /* U+6135 */
  0x0000,   /* U+6136 */
  0x0000,   /* U+6137 */
  0x0000,   /* U+6138 */
  0x0000,   /* U+6139 */
  0x0000,   /* U+613A */
  0x0000,   /* U+613B */
  0x0000,   /* U+613C */
  0x0000,   /* U+613D */
  0x0000,   /* U+613E */
  0x0000,   /* U+613F */
  0x0000,   /* U+6140 */
  0x0000,   /* U+6141 */
  0x0000,   /* U+6142 */
  0x0000,   /* U+6143 */
  0x0000,   /* U+6144 */
  0x0000,   /* U+6145 */
  0x0000,   /* U+6146 */
  0x0000,   /* U+6147 */
  0x0000,   /* U+6148 */
  0x0000,   /* U+6149 */
  0x0000,   /* U+614A */
  0x0000,   /* U+614B */
  0x0000,   /* U+614C */
  0x0000,   /* U+614D */
  0x0000,   /* U+614E */
  0x0000,   /* U+614F */
  0x0000,   /* U+6150 */
  0x0000,   /* U+6151 */
  0x0000,   /* U+6152 */
  0x0000,   /* U+6153 */
  0x0000,   /* U+6154 */
  0x0000,   /* U+6155 */
  0x0000,   /* U+6156 */
  0x0000,   /* U+6157 */
  0x0000,   /* U+6158 */
  0x0000,   /* U+6159 */
  0x0000,   /* U+615A */
  0x0000,   /* U+615B */
  0x0000,   /* U+615C */
  0x0000,   /* U+615D */
  0x0000,   /* U+615E */
  0x0000,   /* U+615F */
  0x0000,   /* U+6160 */
  0x0000,   /* U+6161 */
  0x0000,   /* U+6162 */
  0x0000,   /* U+6163 */
  0x0000,   /* U+6164 */
  0x0000,   /* U+6165 */
  0x0000,   /* U+6166 */
  0x0000,   /* U+6167 */
  0x0000,   /* U+6168 */
  0x0000,   /* U+6169 */
  0x0000,   /* U+616A */
  0x0000,   /* U+616B */
  0x0000,   /* U+616C */
  0x0000,   /* U+616D */
  0x0000,   /* U+616E */
  0x0000,   /* U+616F */
  0x0000,   /* U+6170 */
  0x0000,   /* U+6171 */
  0x0000,   /* U+6172 */
  0x0000,   /* U+6173 */
  0x0000,   /* U+6174 */
  0x0000,   /* U+6175 */
  0x0000,   /* U+6176 */
  0x0000,   /* U+6177 */
  0x0000,   /* U+6178 */
  0x0000,   /* U+6179 */
  0x0000,   /* U+617A */
  0x0000,   /* U+617B */
  0x0000,   /* U+617C */
  0x0000,   /* U+617D */
  0x0000,   /* U+617E */
  0x0000,   /* U+617F */
  0x0000,   /* U+6180 */
  0x0000,   /* U+6181 */
  0x0000,   /* U+6182 */
  0x0000,   /* U+6183 */
  0x0000,   /* U+6184 */
  0x0000,   /* U+6185 */
  0x0000,   /* U+6186 */
  0x0000,   /* U+6187 */
  0x0000,   /* U+6188 */
  0x0000,   /* U+6189 */
  0x0000,   /* U+618A */
  0x0000,   /* U+618B */
  0x0000,   /* U+618C */
  0x0000,   /* U+618D */
  0x0000,   /* U+618E */
  0x0000,   /* U+618F */
  0x0000,   /* U+6190 */
  0x0000,   /* U+6191 */
  0x0000,   /* U+6192 */
  0x0000,   /* U+6193 */
  0x0000,   /* U+6194 */
  0x0000,   /* U+6195 */
  0x0000,   /* U+6196 */
  0x0000,   /* U+6197 */
  0x0000,   /* U+6198 */
  0x0000,   /* U+6199 */
  0x0000,   /* U+619A */
  0x0000,   /* U+619B */
  0x0000,   /* U+619C */
  0x0000,   /* U+619D */
  0x0000,   /* U+619E */
  0x0000,   /* U+619F */
  0x0000,   /* U+61A0 */
  0x0000,   /* U+61A1 */
  0x0000,   /* U+61A2 */
  0x0000,   /* U+61A3 */
  0x0000,   /* U+61A4 */
  0x0000,   /* U+61A5 */
  0x0000,   /* U+61A6 */
  0x0000,   /* U+61A7 */
  0x0000,   /* U+61A8 */
  0x0000,   /* U+61A9 */
  0x0000,   /* U+61AA */
  0x0000,   /* U+61AB */
  0x0000,   /* U+61AC */
  0x0000,   /* U+61AD */
  0x0000,   /* U+61AE */
  0x0000,   /* U+61AF */
  0x0000,   /* U+61B0 */
  0x0000,   /* U+61B1 */
  0x0000,   /* U+61B2 */
  0x0000,   /* U+61B3 */
  0x0000,   /* U+61B4 */
  0x0000,   /* U+61B5 */
  0x0000,   /* U+61B6 */
  0x0000,   /* U+61B7 */
  0x0000,   /* U+61B8 */
  0x0000,   /* U+61B9 */
  0x0000,   /* U+61BA */
  0x0000,   /* U+61BB */
  0x0000,   /* U+61BC */
  0x0000,   /* U+61BD */
  0x0000,   /* U+61BE */
  0x0000,   /* U+61BF */
  0x0000,   /* U+61C0 */
  0x0000,   /* U+61C1 */
  0x0000,   /* U+61C2 */
  0x0000,   /* U+61C3 */
  0x0000,   /* U+61C4 */
  0x0000,   /* U+61C5 */
  0x0000,   /* U+61C6 */
  0x0000,   /* U+61C7 */
  0x0000,   /* U+61C8 */
  0x0000,   /* U+61C9 */
  0x0000,   /* U+61CA */
  0x0000,   /* U+61CB */
  0x0000,   /* U+61CC */
  0x0000,   /* U+61CD */
  0x0000,   /* U+61CE */
  0x0000,   /* U+61CF */
  0x0000,   /* U+61D0 */
  0x0000,   /* U+61D1 */
  0x0000,   /* U+61D2 */
  0x0000,   /* U+61D3 */
  0x0000,   /* U+61D4 */
  0x0000,   /* U+61D5 */
  0x0000,   /* U+61D6 */
  0x0000,   /* U+61D7 */
  0x0000,   /* U+61D8 */
  0x0000,   /* U+61D9 */
  0x0000,   /* U+61DA */
  0x0000,   /* U+61DB */
  0x0000,   /* U+61DC */
  0x0000,   /* U+61DD */
  0x0000,   /* U+61DE */
  0x0000,   /* U+61DF */
  0x0000,   /* U+61E0 */
  0x0000,   /* U+61E1 */
  0x0000,   /* U+61E2 */
  0x0000,   /* U+61E3 */
  0x0000,   /* U+61E4 */
  0x0000,   /* U+61E5 */
  0x0000,   /* U+61E6 */
  0x0000,   /* U+61E7 */
  0x0000,   /* U+61E8 */
  0x0000,   /* U+61E9 */
  0x0000,   /* U+61EA */
  0x0000,   /* U+61EB */
  0x0000,   /* U+61EC */
  0x0000,   /* U+61ED */
  0x0000,   /* U+61EE */
  0x0000,   /* U+61EF */
  0x0000,   /* U+61F0 */
  0x0000,   /* U+61F1 */
  0x0000,   /* U+61F2 */
  0x0000,   /* U+61F3 */
  0x0000,   /* U+61F4 */
  0x0000,   /* U+61F5 */
  0x0000,   /* U+61F6 */
  0x0000,   /* U+61F7 */
  0x0000,   /* U+61F8 */
  0x0000,   /* U+61F9 */
  0x0000,   /* U+61FA */
  0x0000,   /* U+61FB */
  0x0000,   /* U+61FC */
  0x0000,   /* U+61FD */
  0x0000,   /* U+61FE */
  0x0000,   /* U+61FF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+6100 */
  0x0000,   /* U+6101 */
  0x0000,   /* U+6102 */
  0x0000,   /* U+6103 */
  0x0000,   /* U+6104 */
  0x0000,   /* U+6105 */
  0x0000,   /* U+6106 */
  0x0000,   /* U+6107 */
  0x0000,   /* U+6108 */
  0x0000,   /* U+6109 */
  0x0000,   /* U+610A */
  0x0000,   /* U+610B */
  0x0000,   /* U+610C */
  0x0000,   /* U+610D */
  0x0000,   /* U+610E */
  0x0000,   /* U+610F */
  0x0000,   /* U+6110 */
  0x0000,   /* U+6111 */
  0x0000,   /* U+6112 */
  0x0000,   /* U+6113 */
  0x0000,   /* U+6114 */
  0x0000,   /* U+6115 */
  0x0000,   /* U+6116 */
  0x0000,   /* U+6117 */
  0x0000,   /* U+6118 */
  0x0000,   /* U+6119 */
  0x0000,   /* U+611A */
  0x0000,   /* U+611B */
  0x0000,   /* U+611C */
  0x0000,   /* U+611D */
  0x0000,   /* U+611E */
  0x0000,   /* U+611F */
  0x0000,   /* U+6120 */
  0x0000,   /* U+6121 */
  0x0000,   /* U+6122 */
  0x0000,   /* U+6123 */
  0x0000,   /* U+6124 */
  0x0000,   /* U+6125 */
  0x0000,   /* U+6126 */
  0x0000,   /* U+6127 */
  0x0000,   /* U+6128 */
  0x0000,   /* U+6129 */
  0x0000,   /* U+612A */
  0x0000,   /* U+612B */
  0x0000,   /* U+612C */
  0x0000,   /* U+612D */
  0x0000,   /* U+612E */
  0x0000,   /* U+612F */
  0x0000,   /* U+6130 */
  0x0000,   /* U+6131 */
  0x0000,   /* U+6132 */
  0x0000,   /* U+6133 */
  0x0000,   /* U+6134 */
  0x0000,   /* U+6135 */
  0x0000,   /* U+6136 */
  0x0000,   /* U+6137 */
  0x0000,   /* U+6138 */
  0x0000,   /* U+6139 */
  0x0000,   /* U+613A */
  0x0000,   /* U+613B */
  0x0000,   /* U+613C */
  0x0000,   /* U+613D */
  0x0000,   /* U+613E */
  0x0000,   /* U+613F */
  0x0000,   /* U+6140 */
  0x0000,   /* U+6141 */
  0x0000,   /* U+6142 */
  0x0000,   /* U+6143 */
  0x0000,   /* U+6144 */
  0x0000,   /* U+6145 */
  0x0000,   /* U+6146 */
  0x0000,   /* U+6147 */
  0x0000,   /* U+6148 */
  0x0000,   /* U+6149 */
  0x0000,   /* U+614A */
  0x0000,   /* U+614B */
  0x0000,   /* U+614C */
  0x0000,   /* U+614D */
  0x0000,   /* U+614E */
  0x0000,   /* U+614F */
  0x0000,   /* U+6150 */
  0x0000,   /* U+6151 */
  0x0000,   /* U+6152 */
  0x0000,   /* U+6153 */
  0x0000,   /* U+6154 */
  0x0000,   /* U+6155 */
  0x0000,   /* U+6156 */
  0x0000,   /* U+6157 */
  0x0000,   /* U+6158 */
  0x0000,   /* U+6159 */
  0x0000,   /* U+615A */
  0x0000,   /* U+615B */
  0x0000,   /* U+615C */
  0x0000,   /* U+615D */
  0x0000,   /* U+615E */
  0x0000,   /* U+615F */
  0x0000,   /* U+6160 */
  0x0000,   /* U+6161 */
  0x0000,   /* U+6162 */
  0x0000,   /* U+6163 */
  0x0000,   /* U+6164 */
  0x0000,   /* U+6165 */
  0x0000,   /* U+6166 */
  0x0000,   /* U+6167 */
  0x0000,   /* U+6168 */
  0x0000,   /* U+6169 */
  0x0000,   /* U+616A */
  0x0000,   /* U+616B */
  0x0000,   /* U+616C */
  0x0000,   /* U+616D */
  0x0000,   /* U+616E */
  0x0000,   /* U+616F */
  0x0000,   /* U+6170 */
  0x0000,   /* U+6171 */
  0x0000,   /* U+6172 */
  0x0000,   /* U+6173 */
  0x0000,   /* U+6174 */
  0x0000,   /* U+6175 */
  0x0000,   /* U+6176 */
  0x0000,   /* U+6177 */
  0x0000,   /* U+6178 */
  0x0000,   /* U+6179 */
  0x0000,   /* U+617A */
  0x0000,   /* U+617B */
  0x0000,   /* U+617C */
  0x0000,   /* U+617D */
  0x0000,   /* U+617E */
  0x0000,   /* U+617F */
  0x0000,   /* U+6180 */
  0x0000,   /* U+6181 */
  0x0000,   /* U+6182 */
  0x0000,   /* U+6183 */
  0x0000,   /* U+6184 */
  0x0000,   /* U+6185 */
  0x0000,   /* U+6186 */
  0x0000,   /* U+6187 */
  0x0000,   /* U+6188 */
  0x0000,   /* U+6189 */
  0x0000,   /* U+618A */
  0x0000,   /* U+618B */
  0x0000,   /* U+618C */
  0x0000,   /* U+618D */
  0x0000,   /* U+618E */
  0x0000,   /* U+618F */
  0x0000,   /* U+6190 */
  0x0000,   /* U+6191 */
  0x0000,   /* U+6192 */
  0x0000,   /* U+6193 */
  0x0000,   /* U+6194 */
  0x0000,   /* U+6195 */
  0x0000,   /* U+6196 */
  0x0000,   /* U+6197 */
  0x0000,   /* U+6198 */
  0x0000,   /* U+6199 */
  0x0000,   /* U+619A */
  0x0000,   /* U+619B */
  0x0000,   /* U+619C */
  0x0000,   /* U+619D */
  0x0000,   /* U+619E */
  0x0000,   /* U+619F */
  0x0000,   /* U+61A0 */
  0x0000,   /* U+61A1 */
  0x0000,   /* U+61A2 */
  0x0000,   /* U+61A3 */
  0x0000,   /* U+61A4 */
  0x0000,   /* U+61A5 */
  0x0000,   /* U+61A6 */
  0x0000,   /* U+61A7 */
  0x0000,   /* U+61A8 */
  0x0000,   /* U+61A9 */
  0x0000,   /* U+61AA */
  0x0000,   /* U+61AB */
  0x0000,   /* U+61AC */
  0x0000,   /* U+61AD */
  0x0000,   /* U+61AE */
  0x0000,   /* U+61AF */
  0x0000,   /* U+61B0 */
  0x0000,   /* U+61B1 */
  0x0000,   /* U+61B2 */
  0x0000,   /* U+61B3 */
  0x0000,   /* U+61B4 */
  0x0000,   /* U+61B5 */
  0x0000,   /* U+61B6 */
  0x0000,   /* U+61B7 */
  0x0000,   /* U+61B8 */
  0x0000,   /* U+61B9 */
  0x0000,   /* U+61BA */
  0x0000,   /* U+61BB */
  0x0000,   /* U+61BC */
  0x0000,   /* U+61BD */
  0x0000,   /* U+61BE */
  0x0000,   /* U+61BF */
  0x0000,   /* U+61C0 */
  0x0000,   /* U+61C1 */
  0x0000,   /* U+61C2 */
  0x0000,   /* U+61C3 */
  0x0000,   /* U+61C4 */
  0x0000,   /* U+61C5 */
  0x0000,   /* U+61C6 */
  0x0000,   /* U+61C7 */
  0x0000,   /* U+61C8 */
  0x0000,   /* U+61C9 */
  0x0000,   /* U+61CA */
  0x0000,   /* U+61CB */
  0x0000,   /* U+61CC */
  0x0000,   /* U+61CD */
  0x0000,   /* U+61CE */
  0x0000,   /* U+61CF */
  0x0000,   /* U+61D0 */
  0x0000,   /* U+61D1 */
  0x0000,   /* U+61D2 */
  0x0000,   /* U+61D3 */
  0x0000,   /* U+61D4 */
  0x0000,   /* U+61D5 */
  0x0000,   /* U+61D6 */
  0x0000,   /* U+61D7 */
  0x0000,   /* U+61D8 */
  0x0000,   /* U+61D9 */
  0x0000,   /* U+61DA */
  0x0000,   /* U+61DB */
  0x0000,   /* U+61DC */
  0x0000,   /* U+61DD */
  0x0000,   /* U+61DE */
  0x0000,   /* U+61DF */
  0x0000,   /* U+61E0 */
  0x0000,   /* U+61E1 */
  0x0000,   /* U+61E2 */
  0x0000,   /* U+61E3 */
  0x0000,   /* U+61E4 */
  0x0000,   /* U+61E5 */
  0x0000,   /* U+61E6 */
  0x0000,   /* U+61E7 */
  0x0000,   /* U+61E8 */
  0x0000,   /* U+61E9 */
  0x0000,   /* U+61EA */
  0x0000,   /* U+61EB */
  0x0000,   /* U+61EC */
  0x0000,   /* U+61ED */
  0x0000,   /* U+61EE */
  0x0000,   /* U+61EF */
  0x0000,   /* U+61F0 */
  0x0000,   /* U+61F1 */
  0x0000,   /* U+61F2 */
  0x0000,   /* U+61F3 */
  0x0000,   /* U+61F4 */
  0x0000,   /* U+61F5 */
  0x0000,   /* U+61F6 */
  0x0000,   /* U+61F7 */
  0x0000,   /* U+61F8 */
  0x0000,   /* U+61F9 */
  0x0000,   /* U+61FA */
  0x0000,   /* U+61FB */
  0x0000,   /* U+61FC */
  0x0000,   /* U+61FD */
  0x0000,   /* U+61FE */
  0x0000,   /* U+61FF */
};

uint16 ja_han_page62[]= {
  /* Number of CEs for each character. */
  1, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 2, 1, 1, 1, 2,
  1, 1, 1, 2, 1, 2, 1, 2, 2, 2, 1, 1, 2, 1, 1, 1,
  2, 1, 2, 2, 2, 2, 1, 2, 2, 2, 1, 2, 2, 2, 1, 1,
  1, 2, 1, 1, 1, 2, 2, 2, 1, 2, 2, 1, 2, 2, 2, 1,
  1, 1, 2, 2, 2, 2, 2, 1, 1, 1, 2, 1, 2, 1, 1, 2,
  2, 2, 2, 1, 2, 1, 2, 2, 1, 2, 2, 1, 2, 2, 1, 2,
  1, 2, 2, 1, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 1, 2,
  2, 1, 2, 2, 2, 2, 1, 2, 2, 1, 2, 2, 1, 2, 1, 1,
  1, 2, 1, 1, 1, 2, 2, 2, 2, 1, 1, 2, 2, 2, 2, 2,
  2, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 2, 1, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 2, 2, 2,
  2, 1, 2, 2, 2, 1, 2, 2, 2, 1, 2, 1, 1, 1, 2, 2,
  2, 2, 1, 2, 2, 1, 1, 1, 1, 1, 1, 2, 1, 1, 2, 1,
  1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 2, 1, 1, 1, 2, 2,
  1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1,
  2, 1, 2, 1, 2, 1, 1, 1, 2, 2, 2, 2, 2, 2, 1, 1,

  /* Primary weight 1 for each character. */
  0x6380,   /* U+6200 */
  0xFB40,   /* U+6201 */
  0xFB40,   /* U+6202 */
  0xFB40,   /* U+6203 */
  0xFB40,   /* U+6204 */
  0xFB40,   /* U+6205 */
  0xFB40,   /* U+6206 */
  0xFB40,   /* U+6207 */
  0x6381,   /* U+6208 */
  0x6382,   /* U+6209 */
  0x5E79,   /* U+620A */
  0xFB40,   /* U+620B */
  0x6384,   /* U+620C */
  0x6383,   /* U+620D */
  0x5988,   /* U+620E */
  0xFB40,   /* U+620F */
  0x5A91,   /* U+6210 */
  0x55A5,   /* U+6211 */
  0x55BB,   /* U+6212 */
  0xFB40,   /* U+6213 */
  0x6385,   /* U+6214 */
  0xFB40,   /* U+6215 */
  0x54C2,   /* U+6216 */
  0xFB40,   /* U+6217 */
  0xFB40,   /* U+6218 */
  0xFB40,   /* U+6219 */
  0x5AAF,   /* U+621A */
  0x6386,   /* U+621B */
  0xFB40,   /* U+621C */
  0x6AA3,   /* U+621D */
  0x6387,   /* U+621E */
  0x5776,   /* U+621F */
  0xFB40,   /* U+6220 */
  0x6388,   /* U+6221 */
  0xFB40,   /* U+6222 */
  0xFB40,   /* U+6223 */
  0xFB40,   /* U+6224 */
  0xFB40,   /* U+6225 */
  0x5AD2,   /* U+6226 */
  0xFB40,   /* U+6227 */
  0xFB40,   /* U+6228 */
  0xFB40,   /* U+6229 */
  0x6389,   /* U+622A */
  0xFB40,   /* U+622B */
  0xFB40,   /* U+622C */
  0xFB40,   /* U+622D */
  0x638A,   /* U+622E */
  0x5693,   /* U+622F */
  0x638B,   /* U+6230 */
  0xFB40,   /* U+6231 */
  0x638C,   /* U+6232 */
  0x638D,   /* U+6233 */
  0x5B76,   /* U+6234 */
  0xFB40,   /* U+6235 */
  0xFB40,   /* U+6236 */
  0xFB40,   /* U+6237 */
  0x57C0,   /* U+6238 */
  0xFB40,   /* U+6239 */
  0xFB40,   /* U+623A */
  0x5F2C,   /* U+623B */
  0xFB40,   /* U+623C */
  0xFB40,   /* U+623D */
  0xFB40,   /* U+623E */
  0x5EA9,   /* U+623F */
  0x59B3,   /* U+6240 */
  0x638E,   /* U+6241 */
  0xFB40,   /* U+6242 */
  0xFB40,   /* U+6243 */
  0xFB40,   /* U+6244 */
  0xFB40,   /* U+6245 */
  0xFB40,   /* U+6246 */
  0x5AD3,   /* U+6247 */
  0x6B59,   /* U+6248 */
  0x5DB5,   /* U+6249 */
  0xFB40,   /* U+624A */
  0x5955,   /* U+624B */
  0xFB40,   /* U+624C */
  0x587C,   /* U+624D */
  0x638F,   /* U+624E */
  0xFB40,   /* U+624F */
  0xFB40,   /* U+6250 */
  0xFB40,   /* U+6251 */
  0xFB40,   /* U+6252 */
  0x5B66,   /* U+6253 */
  0xFB40,   /* U+6254 */
  0x5E36,   /* U+6255 */
  0xFB40,   /* U+6256 */
  0xFB40,   /* U+6257 */
  0x5B90,   /* U+6258 */
  0xFB40,   /* U+6259 */
  0xFB40,   /* U+625A */
  0x6392,   /* U+625B */
  0xFB40,   /* U+625C */
  0xFB40,   /* U+625D */
  0x6390,   /* U+625E */
  0xFB40,   /* U+625F */
  0x6393,   /* U+6260 */
  0xFB40,   /* U+6261 */
  0xFB40,   /* U+6262 */
  0x6391,   /* U+6263 */
  0xFB40,   /* U+6264 */
  0xFB40,   /* U+6265 */
  0xFB40,   /* U+6266 */
  0xFB40,   /* U+6267 */
  0x6394,   /* U+6268 */
  0xFB40,   /* U+6269 */
  0xFB40,   /* U+626A */
  0xFB40,   /* U+626B */
  0xFB40,   /* U+626C */
  0xFB40,   /* U+626D */
  0x5E40,   /* U+626E */
  0xFB40,   /* U+626F */
  0xFB40,   /* U+6270 */
  0x54BA,   /* U+6271 */
  0xFB40,   /* U+6272 */
  0xFB40,   /* U+6273 */
  0xFB40,   /* U+6274 */
  0xFB40,   /* U+6275 */
  0x5E0F,   /* U+6276 */
  0xFB40,   /* U+6277 */
  0xFB40,   /* U+6278 */
  0x5DB6,   /* U+6279 */
  0xFB40,   /* U+627A */
  0xFB40,   /* U+627B */
  0x6395,   /* U+627C */
  0xFB40,   /* U+627D */
  0x6398,   /* U+627E */
  0x59DC,   /* U+627F */
  0x5694,   /* U+6280 */
  0xFB40,   /* U+6281 */
  0x6396,   /* U+6282 */
  0x639D,   /* U+6283 */
  0x59DD,   /* U+6284 */
  0xFB40,   /* U+6285 */
  0xFB40,   /* U+6286 */
  0xFB40,   /* U+6287 */
  0xFB40,   /* U+6288 */
  0x6397,   /* U+6289 */
  0x5D39,   /* U+628A */
  0xFB40,   /* U+628B */
  0xFB40,   /* U+628C */
  0xFB40,   /* U+628D */
  0xFB40,   /* U+628E */
  0xFB40,   /* U+628F */
  0xFB40,   /* U+6290 */
  0x5F87,   /* U+6291 */
  0x6399,   /* U+6292 */
  0x639A,   /* U+6293 */
  0x639E,   /* U+6294 */
  0x5CA3,   /* U+6295 */
  0x639B,   /* U+6296 */
  0x5804,   /* U+6297 */
  0x5AC1,   /* U+6298 */
  0xFB40,   /* U+6299 */
  0xFB40,   /* U+629A */
  0x63AC,   /* U+629B */
  0x5D87,   /* U+629C */
  0xFB40,   /* U+629D */
  0x5B91,   /* U+629E */
  0xFB40,   /* U+629F */
  0xFB40,   /* U+62A0 */
  0xFB40,   /* U+62A1 */
  0xFB40,   /* U+62A2 */
  0xFB40,   /* U+62A3 */
  0xFB40,   /* U+62A4 */
  0xFB40,   /* U+62A5 */
  0xFB40,   /* U+62A6 */
  0xFB40,   /* U+62A7 */
  0xFB40,   /* U+62A8 */
  0xFB40,   /* U+62A9 */
  0xFB40,   /* U+62AA */
  0x5DB7,   /* U+62AB */
  0x63F1,   /* U+62AC */
  0xFB40,   /* U+62AD */
  0xFB40,   /* U+62AE */
  0xFB40,   /* U+62AF */
  0xFB40,   /* U+62B0 */
  0x5E89,   /* U+62B1 */
  0xFB40,   /* U+62B2 */
  0xFB40,   /* U+62B3 */
  0xFB40,   /* U+62B4 */
  0x5C4C,   /* U+62B5 */
  0xFB40,   /* U+62B6 */
  0xFB40,   /* U+62B7 */
  0xFB40,   /* U+62B8 */
  0x5EE2,   /* U+62B9 */
  0xFB40,   /* U+62BA */
  0x63A1,   /* U+62BB */
  0x5560,   /* U+62BC */
  0x5BE7,   /* U+62BD */
  0xFB40,   /* U+62BE */
  0xFB40,   /* U+62BF */
  0xFB40,   /* U+62C0 */
  0xFB40,   /* U+62C1 */
  0x63AA,   /* U+62C2 */
  0xFB40,   /* U+62C3 */
  0xFB40,   /* U+62C4 */
  0x5BB1,   /* U+62C5 */
  0x63A4,   /* U+62C6 */
  0x63AB,   /* U+62C7 */
  0x63A6,   /* U+62C8 */
  0x63AD,   /* U+62C9 */
  0x63A9,   /* U+62CA */
  0xFB40,   /* U+62CB */
  0x63A8,   /* U+62CC */
  0x5D64,   /* U+62CD */
  0xFB40,   /* U+62CE */
  0x63A2,   /* U+62CF */
  0x55BC,   /* U+62D0 */
  0x63A0,   /* U+62D1 */
  0x56CA,   /* U+62D2 */
  0x5B92,   /* U+62D3 */
  0x639C,   /* U+62D4 */
  0xFB40,   /* U+62D5 */
  0xFB40,   /* U+62D6 */
  0x639F,   /* U+62D7 */
  0x5805,   /* U+62D8 */
  0x5ABE,   /* U+62D9 */
  0xFB40,   /* U+62DA */
  0x59DE,   /* U+62DB */
  0x63A7,   /* U+62DC */
  0x5D47,   /* U+62DD */
  0xFB40,   /* U+62DE */
  0xFB40,   /* U+62DF */
  0x56CB,   /* U+62E0 */
  0x55E5,   /* U+62E1 */
  0xFB40,   /* U+62E2 */
  0xFB40,   /* U+62E3 */
  0xFB40,   /* U+62E4 */
  0xFB40,   /* U+62E5 */
  0xFB40,   /* U+62E6 */
  0xFB40,   /* U+62E7 */
  0xFB40,   /* U+62E8 */
  0xFB40,   /* U+62E9 */
  0xFB40,   /* U+62EA */
  0xFB40,   /* U+62EB */
  0x5604,   /* U+62EC */
  0x5A26,   /* U+62ED */
  0x63AF,   /* U+62EE */
  0x63B4,   /* U+62EF */
  0xFB40,   /* U+62F0 */
  0x63B0,   /* U+62F1 */
  0xFB40,   /* U+62F2 */
  0x5792,   /* U+62F3 */
  0xFB40,   /* U+62F4 */
  0x63B5,   /* U+62F5 */
  0x58AF,   /* U+62F6 */
  0x583A,   /* U+62F7 */
  0xFB40,   /* U+62F8 */
  0xFB40,   /* U+62F9 */
  0xFB40,   /* U+62FA */
  0xFB40,   /* U+62FB */
  0xFB40,   /* U+62FC */
  0xFB40,   /* U+62FD */
  0x596F,   /* U+62FE */
  0x63A3,   /* U+62FF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+6200 */
  0x0020,   /* U+6201 */
  0x0020,   /* U+6202 */
  0x0020,   /* U+6203 */
  0x0020,   /* U+6204 */
  0x0020,   /* U+6205 */
  0x0020,   /* U+6206 */
  0x0020,   /* U+6207 */
  0x0020,   /* U+6208 */
  0x0020,   /* U+6209 */
  0x0020,   /* U+620A */
  0x0020,   /* U+620B */
  0x0020,   /* U+620C */
  0x0020,   /* U+620D */
  0x0020,   /* U+620E */
  0x0020,   /* U+620F */
  0x0020,   /* U+6210 */
  0x0020,   /* U+6211 */
  0x0020,   /* U+6212 */
  0x0020,   /* U+6213 */
  0x0020,   /* U+6214 */
  0x0020,   /* U+6215 */
  0x0020,   /* U+6216 */
  0x0020,   /* U+6217 */
  0x0020,   /* U+6218 */
  0x0020,   /* U+6219 */
  0x0020,   /* U+621A */
  0x0020,   /* U+621B */
  0x0020,   /* U+621C */
  0x0020,   /* U+621D */
  0x0020,   /* U+621E */
  0x0020,   /* U+621F */
  0x0020,   /* U+6220 */
  0x0020,   /* U+6221 */
  0x0020,   /* U+6222 */
  0x0020,   /* U+6223 */
  0x0020,   /* U+6224 */
  0x0020,   /* U+6225 */
  0x0020,   /* U+6226 */
  0x0020,   /* U+6227 */
  0x0020,   /* U+6228 */
  0x0020,   /* U+6229 */
  0x0020,   /* U+622A */
  0x0020,   /* U+622B */
  0x0020,   /* U+622C */
  0x0020,   /* U+622D */
  0x0020,   /* U+622E */
  0x0020,   /* U+622F */
  0x0020,   /* U+6230 */
  0x0020,   /* U+6231 */
  0x0020,   /* U+6232 */
  0x0020,   /* U+6233 */
  0x0020,   /* U+6234 */
  0x0020,   /* U+6235 */
  0x0020,   /* U+6236 */
  0x0020,   /* U+6237 */
  0x0020,   /* U+6238 */
  0x0020,   /* U+6239 */
  0x0020,   /* U+623A */
  0x0020,   /* U+623B */
  0x0020,   /* U+623C */
  0x0020,   /* U+623D */
  0x0020,   /* U+623E */
  0x0020,   /* U+623F */
  0x0020,   /* U+6240 */
  0x0020,   /* U+6241 */
  0x0020,   /* U+6242 */
  0x0020,   /* U+6243 */
  0x0020,   /* U+6244 */
  0x0020,   /* U+6245 */
  0x0020,   /* U+6246 */
  0x0020,   /* U+6247 */
  0x0020,   /* U+6248 */
  0x0020,   /* U+6249 */
  0x0020,   /* U+624A */
  0x0020,   /* U+624B */
  0x0020,   /* U+624C */
  0x0020,   /* U+624D */
  0x0020,   /* U+624E */
  0x0020,   /* U+624F */
  0x0020,   /* U+6250 */
  0x0020,   /* U+6251 */
  0x0020,   /* U+6252 */
  0x0020,   /* U+6253 */
  0x0020,   /* U+6254 */
  0x0020,   /* U+6255 */
  0x0020,   /* U+6256 */
  0x0020,   /* U+6257 */
  0x0020,   /* U+6258 */
  0x0020,   /* U+6259 */
  0x0020,   /* U+625A */
  0x0020,   /* U+625B */
  0x0020,   /* U+625C */
  0x0020,   /* U+625D */
  0x0020,   /* U+625E */
  0x0020,   /* U+625F */
  0x0020,   /* U+6260 */
  0x0020,   /* U+6261 */
  0x0020,   /* U+6262 */
  0x0020,   /* U+6263 */
  0x0020,   /* U+6264 */
  0x0020,   /* U+6265 */
  0x0020,   /* U+6266 */
  0x0020,   /* U+6267 */
  0x0020,   /* U+6268 */
  0x0020,   /* U+6269 */
  0x0020,   /* U+626A */
  0x0020,   /* U+626B */
  0x0020,   /* U+626C */
  0x0020,   /* U+626D */
  0x0020,   /* U+626E */
  0x0020,   /* U+626F */
  0x0020,   /* U+6270 */
  0x0020,   /* U+6271 */
  0x0020,   /* U+6272 */
  0x0020,   /* U+6273 */
  0x0020,   /* U+6274 */
  0x0020,   /* U+6275 */
  0x0020,   /* U+6276 */
  0x0020,   /* U+6277 */
  0x0020,   /* U+6278 */
  0x0020,   /* U+6279 */
  0x0020,   /* U+627A */
  0x0020,   /* U+627B */
  0x0020,   /* U+627C */
  0x0020,   /* U+627D */
  0x0020,   /* U+627E */
  0x0020,   /* U+627F */
  0x0020,   /* U+6280 */
  0x0020,   /* U+6281 */
  0x0020,   /* U+6282 */
  0x0020,   /* U+6283 */
  0x0020,   /* U+6284 */
  0x0020,   /* U+6285 */
  0x0020,   /* U+6286 */
  0x0020,   /* U+6287 */
  0x0020,   /* U+6288 */
  0x0020,   /* U+6289 */
  0x0020,   /* U+628A */
  0x0020,   /* U+628B */
  0x0020,   /* U+628C */
  0x0020,   /* U+628D */
  0x0020,   /* U+628E */
  0x0020,   /* U+628F */
  0x0020,   /* U+6290 */
  0x0020,   /* U+6291 */
  0x0020,   /* U+6292 */
  0x0020,   /* U+6293 */
  0x0020,   /* U+6294 */
  0x0020,   /* U+6295 */
  0x0020,   /* U+6296 */
  0x0020,   /* U+6297 */
  0x0020,   /* U+6298 */
  0x0020,   /* U+6299 */
  0x0020,   /* U+629A */
  0x0020,   /* U+629B */
  0x0020,   /* U+629C */
  0x0020,   /* U+629D */
  0x0020,   /* U+629E */
  0x0020,   /* U+629F */
  0x0020,   /* U+62A0 */
  0x0020,   /* U+62A1 */
  0x0020,   /* U+62A2 */
  0x0020,   /* U+62A3 */
  0x0020,   /* U+62A4 */
  0x0020,   /* U+62A5 */
  0x0020,   /* U+62A6 */
  0x0020,   /* U+62A7 */
  0x0020,   /* U+62A8 */
  0x0020,   /* U+62A9 */
  0x0020,   /* U+62AA */
  0x0020,   /* U+62AB */
  0x0020,   /* U+62AC */
  0x0020,   /* U+62AD */
  0x0020,   /* U+62AE */
  0x0020,   /* U+62AF */
  0x0020,   /* U+62B0 */
  0x0020,   /* U+62B1 */
  0x0020,   /* U+62B2 */
  0x0020,   /* U+62B3 */
  0x0020,   /* U+62B4 */
  0x0020,   /* U+62B5 */
  0x0020,   /* U+62B6 */
  0x0020,   /* U+62B7 */
  0x0020,   /* U+62B8 */
  0x0020,   /* U+62B9 */
  0x0020,   /* U+62BA */
  0x0020,   /* U+62BB */
  0x0020,   /* U+62BC */
  0x0020,   /* U+62BD */
  0x0020,   /* U+62BE */
  0x0020,   /* U+62BF */
  0x0020,   /* U+62C0 */
  0x0020,   /* U+62C1 */
  0x0020,   /* U+62C2 */
  0x0020,   /* U+62C3 */
  0x0020,   /* U+62C4 */
  0x0020,   /* U+62C5 */
  0x0020,   /* U+62C6 */
  0x0020,   /* U+62C7 */
  0x0020,   /* U+62C8 */
  0x0020,   /* U+62C9 */
  0x0020,   /* U+62CA */
  0x0020,   /* U+62CB */
  0x0020,   /* U+62CC */
  0x0020,   /* U+62CD */
  0x0020,   /* U+62CE */
  0x0020,   /* U+62CF */
  0x0020,   /* U+62D0 */
  0x0020,   /* U+62D1 */
  0x0020,   /* U+62D2 */
  0x0020,   /* U+62D3 */
  0x0020,   /* U+62D4 */
  0x0020,   /* U+62D5 */
  0x0020,   /* U+62D6 */
  0x0020,   /* U+62D7 */
  0x0020,   /* U+62D8 */
  0x0020,   /* U+62D9 */
  0x0020,   /* U+62DA */
  0x0020,   /* U+62DB */
  0x0020,   /* U+62DC */
  0x0020,   /* U+62DD */
  0x0020,   /* U+62DE */
  0x0020,   /* U+62DF */
  0x0020,   /* U+62E0 */
  0x0020,   /* U+62E1 */
  0x0020,   /* U+62E2 */
  0x0020,   /* U+62E3 */
  0x0020,   /* U+62E4 */
  0x0020,   /* U+62E5 */
  0x0020,   /* U+62E6 */
  0x0020,   /* U+62E7 */
  0x0020,   /* U+62E8 */
  0x0020,   /* U+62E9 */
  0x0020,   /* U+62EA */
  0x0020,   /* U+62EB */
  0x0020,   /* U+62EC */
  0x0020,   /* U+62ED */
  0x0020,   /* U+62EE */
  0x0020,   /* U+62EF */
  0x0020,   /* U+62F0 */
  0x0020,   /* U+62F1 */
  0x0020,   /* U+62F2 */
  0x0020,   /* U+62F3 */
  0x0020,   /* U+62F4 */
  0x0020,   /* U+62F5 */
  0x0020,   /* U+62F6 */
  0x0020,   /* U+62F7 */
  0x0020,   /* U+62F8 */
  0x0020,   /* U+62F9 */
  0x0020,   /* U+62FA */
  0x0020,   /* U+62FB */
  0x0020,   /* U+62FC */
  0x0020,   /* U+62FD */
  0x0020,   /* U+62FE */
  0x0020,   /* U+62FF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+6200 */
  0x0002,   /* U+6201 */
  0x0002,   /* U+6202 */
  0x0002,   /* U+6203 */
  0x0002,   /* U+6204 */
  0x0002,   /* U+6205 */
  0x0002,   /* U+6206 */
  0x0002,   /* U+6207 */
  0x0002,   /* U+6208 */
  0x0002,   /* U+6209 */
  0x0002,   /* U+620A */
  0x0002,   /* U+620B */
  0x0002,   /* U+620C */
  0x0002,   /* U+620D */
  0x0002,   /* U+620E */
  0x0002,   /* U+620F */
  0x0002,   /* U+6210 */
  0x0002,   /* U+6211 */
  0x0002,   /* U+6212 */
  0x0002,   /* U+6213 */
  0x0002,   /* U+6214 */
  0x0002,   /* U+6215 */
  0x0002,   /* U+6216 */
  0x0002,   /* U+6217 */
  0x0002,   /* U+6218 */
  0x0002,   /* U+6219 */
  0x0002,   /* U+621A */
  0x0002,   /* U+621B */
  0x0002,   /* U+621C */
  0x0002,   /* U+621D */
  0x0002,   /* U+621E */
  0x0002,   /* U+621F */
  0x0002,   /* U+6220 */
  0x0002,   /* U+6221 */
  0x0002,   /* U+6222 */
  0x0002,   /* U+6223 */
  0x0002,   /* U+6224 */
  0x0002,   /* U+6225 */
  0x0002,   /* U+6226 */
  0x0002,   /* U+6227 */
  0x0002,   /* U+6228 */
  0x0002,   /* U+6229 */
  0x0002,   /* U+622A */
  0x0002,   /* U+622B */
  0x0002,   /* U+622C */
  0x0002,   /* U+622D */
  0x0002,   /* U+622E */
  0x0002,   /* U+622F */
  0x0002,   /* U+6230 */
  0x0002,   /* U+6231 */
  0x0002,   /* U+6232 */
  0x0002,   /* U+6233 */
  0x0002,   /* U+6234 */
  0x0002,   /* U+6235 */
  0x0002,   /* U+6236 */
  0x0002,   /* U+6237 */
  0x0002,   /* U+6238 */
  0x0002,   /* U+6239 */
  0x0002,   /* U+623A */
  0x0002,   /* U+623B */
  0x0002,   /* U+623C */
  0x0002,   /* U+623D */
  0x0002,   /* U+623E */
  0x0002,   /* U+623F */
  0x0002,   /* U+6240 */
  0x0002,   /* U+6241 */
  0x0002,   /* U+6242 */
  0x0002,   /* U+6243 */
  0x0002,   /* U+6244 */
  0x0002,   /* U+6245 */
  0x0002,   /* U+6246 */
  0x0002,   /* U+6247 */
  0x0002,   /* U+6248 */
  0x0002,   /* U+6249 */
  0x0002,   /* U+624A */
  0x0002,   /* U+624B */
  0x0002,   /* U+624C */
  0x0002,   /* U+624D */
  0x0002,   /* U+624E */
  0x0002,   /* U+624F */
  0x0002,   /* U+6250 */
  0x0002,   /* U+6251 */
  0x0002,   /* U+6252 */
  0x0002,   /* U+6253 */
  0x0002,   /* U+6254 */
  0x0002,   /* U+6255 */
  0x0002,   /* U+6256 */
  0x0002,   /* U+6257 */
  0x0002,   /* U+6258 */
  0x0002,   /* U+6259 */
  0x0002,   /* U+625A */
  0x0002,   /* U+625B */
  0x0002,   /* U+625C */
  0x0002,   /* U+625D */
  0x0002,   /* U+625E */
  0x0002,   /* U+625F */
  0x0002,   /* U+6260 */
  0x0002,   /* U+6261 */
  0x0002,   /* U+6262 */
  0x0002,   /* U+6263 */
  0x0002,   /* U+6264 */
  0x0002,   /* U+6265 */
  0x0002,   /* U+6266 */
  0x0002,   /* U+6267 */
  0x0002,   /* U+6268 */
  0x0002,   /* U+6269 */
  0x0002,   /* U+626A */
  0x0002,   /* U+626B */
  0x0002,   /* U+626C */
  0x0002,   /* U+626D */
  0x0002,   /* U+626E */
  0x0002,   /* U+626F */
  0x0002,   /* U+6270 */
  0x0002,   /* U+6271 */
  0x0002,   /* U+6272 */
  0x0002,   /* U+6273 */
  0x0002,   /* U+6274 */
  0x0002,   /* U+6275 */
  0x0002,   /* U+6276 */
  0x0002,   /* U+6277 */
  0x0002,   /* U+6278 */
  0x0002,   /* U+6279 */
  0x0002,   /* U+627A */
  0x0002,   /* U+627B */
  0x0002,   /* U+627C */
  0x0002,   /* U+627D */
  0x0002,   /* U+627E */
  0x0002,   /* U+627F */
  0x0002,   /* U+6280 */
  0x0002,   /* U+6281 */
  0x0002,   /* U+6282 */
  0x0002,   /* U+6283 */
  0x0002,   /* U+6284 */
  0x0002,   /* U+6285 */
  0x0002,   /* U+6286 */
  0x0002,   /* U+6287 */
  0x0002,   /* U+6288 */
  0x0002,   /* U+6289 */
  0x0002,   /* U+628A */
  0x0002,   /* U+628B */
  0x0002,   /* U+628C */
  0x0002,   /* U+628D */
  0x0002,   /* U+628E */
  0x0002,   /* U+628F */
  0x0002,   /* U+6290 */
  0x0002,   /* U+6291 */
  0x0002,   /* U+6292 */
  0x0002,   /* U+6293 */
  0x0002,   /* U+6294 */
  0x0002,   /* U+6295 */
  0x0002,   /* U+6296 */
  0x0002,   /* U+6297 */
  0x0002,   /* U+6298 */
  0x0002,   /* U+6299 */
  0x0002,   /* U+629A */
  0x0002,   /* U+629B */
  0x0002,   /* U+629C */
  0x0002,   /* U+629D */
  0x0002,   /* U+629E */
  0x0002,   /* U+629F */
  0x0002,   /* U+62A0 */
  0x0002,   /* U+62A1 */
  0x0002,   /* U+62A2 */
  0x0002,   /* U+62A3 */
  0x0002,   /* U+62A4 */
  0x0002,   /* U+62A5 */
  0x0002,   /* U+62A6 */
  0x0002,   /* U+62A7 */
  0x0002,   /* U+62A8 */
  0x0002,   /* U+62A9 */
  0x0002,   /* U+62AA */
  0x0002,   /* U+62AB */
  0x0002,   /* U+62AC */
  0x0002,   /* U+62AD */
  0x0002,   /* U+62AE */
  0x0002,   /* U+62AF */
  0x0002,   /* U+62B0 */
  0x0002,   /* U+62B1 */
  0x0002,   /* U+62B2 */
  0x0002,   /* U+62B3 */
  0x0002,   /* U+62B4 */
  0x0002,   /* U+62B5 */
  0x0002,   /* U+62B6 */
  0x0002,   /* U+62B7 */
  0x0002,   /* U+62B8 */
  0x0002,   /* U+62B9 */
  0x0002,   /* U+62BA */
  0x0002,   /* U+62BB */
  0x0002,   /* U+62BC */
  0x0002,   /* U+62BD */
  0x0002,   /* U+62BE */
  0x0002,   /* U+62BF */
  0x0002,   /* U+62C0 */
  0x0002,   /* U+62C1 */
  0x0002,   /* U+62C2 */
  0x0002,   /* U+62C3 */
  0x0002,   /* U+62C4 */
  0x0002,   /* U+62C5 */
  0x0002,   /* U+62C6 */
  0x0002,   /* U+62C7 */
  0x0002,   /* U+62C8 */
  0x0002,   /* U+62C9 */
  0x0002,   /* U+62CA */
  0x0002,   /* U+62CB */
  0x0002,   /* U+62CC */
  0x0002,   /* U+62CD */
  0x0002,   /* U+62CE */
  0x0002,   /* U+62CF */
  0x0002,   /* U+62D0 */
  0x0002,   /* U+62D1 */
  0x0002,   /* U+62D2 */
  0x0002,   /* U+62D3 */
  0x0002,   /* U+62D4 */
  0x0002,   /* U+62D5 */
  0x0002,   /* U+62D6 */
  0x0002,   /* U+62D7 */
  0x0002,   /* U+62D8 */
  0x0002,   /* U+62D9 */
  0x0002,   /* U+62DA */
  0x0002,   /* U+62DB */
  0x0002,   /* U+62DC */
  0x0002,   /* U+62DD */
  0x0002,   /* U+62DE */
  0x0002,   /* U+62DF */
  0x0002,   /* U+62E0 */
  0x0002,   /* U+62E1 */
  0x0002,   /* U+62E2 */
  0x0002,   /* U+62E3 */
  0x0002,   /* U+62E4 */
  0x0002,   /* U+62E5 */
  0x0002,   /* U+62E6 */
  0x0002,   /* U+62E7 */
  0x0002,   /* U+62E8 */
  0x0002,   /* U+62E9 */
  0x0002,   /* U+62EA */
  0x0002,   /* U+62EB */
  0x0002,   /* U+62EC */
  0x0002,   /* U+62ED */
  0x0002,   /* U+62EE */
  0x0002,   /* U+62EF */
  0x0002,   /* U+62F0 */
  0x0002,   /* U+62F1 */
  0x0002,   /* U+62F2 */
  0x0002,   /* U+62F3 */
  0x0002,   /* U+62F4 */
  0x0002,   /* U+62F5 */
  0x0002,   /* U+62F6 */
  0x0002,   /* U+62F7 */
  0x0002,   /* U+62F8 */
  0x0002,   /* U+62F9 */
  0x0002,   /* U+62FA */
  0x0002,   /* U+62FB */
  0x0002,   /* U+62FC */
  0x0002,   /* U+62FD */
  0x0002,   /* U+62FE */
  0x0002,   /* U+62FF */

  /* Primary weight 2 for each character. */
  0x0000,   /* U+6200 */
  0xE201,   /* U+6201 */
  0xE202,   /* U+6202 */
  0xE203,   /* U+6203 */
  0xE204,   /* U+6204 */
  0xE205,   /* U+6205 */
  0xE206,   /* U+6206 */
  0xE207,   /* U+6207 */
  0x0000,   /* U+6208 */
  0x0000,   /* U+6209 */
  0x0000,   /* U+620A */
  0xE20B,   /* U+620B */
  0x0000,   /* U+620C */
  0x0000,   /* U+620D */
  0x0000,   /* U+620E */
  0xE20F,   /* U+620F */
  0x0000,   /* U+6210 */
  0x0000,   /* U+6211 */
  0x0000,   /* U+6212 */
  0xE213,   /* U+6213 */
  0x0000,   /* U+6214 */
  0xE215,   /* U+6215 */
  0x0000,   /* U+6216 */
  0xE217,   /* U+6217 */
  0xE218,   /* U+6218 */
  0xE219,   /* U+6219 */
  0x0000,   /* U+621A */
  0x0000,   /* U+621B */
  0xE21C,   /* U+621C */
  0x0000,   /* U+621D */
  0x0000,   /* U+621E */
  0x0000,   /* U+621F */
  0xE220,   /* U+6220 */
  0x0000,   /* U+6221 */
  0xE222,   /* U+6222 */
  0xE223,   /* U+6223 */
  0xE224,   /* U+6224 */
  0xE225,   /* U+6225 */
  0x0000,   /* U+6226 */
  0xE227,   /* U+6227 */
  0xE228,   /* U+6228 */
  0xE229,   /* U+6229 */
  0x0000,   /* U+622A */
  0xE22B,   /* U+622B */
  0xE22C,   /* U+622C */
  0xE22D,   /* U+622D */
  0x0000,   /* U+622E */
  0x0000,   /* U+622F */
  0x0000,   /* U+6230 */
  0xE231,   /* U+6231 */
  0x0000,   /* U+6232 */
  0x0000,   /* U+6233 */
  0x0000,   /* U+6234 */
  0xE235,   /* U+6235 */
  0xE236,   /* U+6236 */
  0xE237,   /* U+6237 */
  0x0000,   /* U+6238 */
  0xE239,   /* U+6239 */
  0xE23A,   /* U+623A */
  0x0000,   /* U+623B */
  0xE23C,   /* U+623C */
  0xE23D,   /* U+623D */
  0xE23E,   /* U+623E */
  0x0000,   /* U+623F */
  0x0000,   /* U+6240 */
  0x0000,   /* U+6241 */
  0xE242,   /* U+6242 */
  0xE243,   /* U+6243 */
  0xE244,   /* U+6244 */
  0xE245,   /* U+6245 */
  0xE246,   /* U+6246 */
  0x0000,   /* U+6247 */
  0x0000,   /* U+6248 */
  0x0000,   /* U+6249 */
  0xE24A,   /* U+624A */
  0x0000,   /* U+624B */
  0xE24C,   /* U+624C */
  0x0000,   /* U+624D */
  0x0000,   /* U+624E */
  0xE24F,   /* U+624F */
  0xE250,   /* U+6250 */
  0xE251,   /* U+6251 */
  0xE252,   /* U+6252 */
  0x0000,   /* U+6253 */
  0xE254,   /* U+6254 */
  0x0000,   /* U+6255 */
  0xE256,   /* U+6256 */
  0xE257,   /* U+6257 */
  0x0000,   /* U+6258 */
  0xE259,   /* U+6259 */
  0xE25A,   /* U+625A */
  0x0000,   /* U+625B */
  0xE25C,   /* U+625C */
  0xE25D,   /* U+625D */
  0x0000,   /* U+625E */
  0xE25F,   /* U+625F */
  0x0000,   /* U+6260 */
  0xE261,   /* U+6261 */
  0xE262,   /* U+6262 */
  0x0000,   /* U+6263 */
  0xE264,   /* U+6264 */
  0xE265,   /* U+6265 */
  0xE266,   /* U+6266 */
  0xE267,   /* U+6267 */
  0x0000,   /* U+6268 */
  0xE269,   /* U+6269 */
  0xE26A,   /* U+626A */
  0xE26B,   /* U+626B */
  0xE26C,   /* U+626C */
  0xE26D,   /* U+626D */
  0x0000,   /* U+626E */
  0xE26F,   /* U+626F */
  0xE270,   /* U+6270 */
  0x0000,   /* U+6271 */
  0xE272,   /* U+6272 */
  0xE273,   /* U+6273 */
  0xE274,   /* U+6274 */
  0xE275,   /* U+6275 */
  0x0000,   /* U+6276 */
  0xE277,   /* U+6277 */
  0xE278,   /* U+6278 */
  0x0000,   /* U+6279 */
  0xE27A,   /* U+627A */
  0xE27B,   /* U+627B */
  0x0000,   /* U+627C */
  0xE27D,   /* U+627D */
  0x0000,   /* U+627E */
  0x0000,   /* U+627F */
  0x0000,   /* U+6280 */
  0xE281,   /* U+6281 */
  0x0000,   /* U+6282 */
  0x0000,   /* U+6283 */
  0x0000,   /* U+6284 */
  0xE285,   /* U+6285 */
  0xE286,   /* U+6286 */
  0xE287,   /* U+6287 */
  0xE288,   /* U+6288 */
  0x0000,   /* U+6289 */
  0x0000,   /* U+628A */
  0xE28B,   /* U+628B */
  0xE28C,   /* U+628C */
  0xE28D,   /* U+628D */
  0xE28E,   /* U+628E */
  0xE28F,   /* U+628F */
  0xE290,   /* U+6290 */
  0x0000,   /* U+6291 */
  0x0000,   /* U+6292 */
  0x0000,   /* U+6293 */
  0x0000,   /* U+6294 */
  0x0000,   /* U+6295 */
  0x0000,   /* U+6296 */
  0x0000,   /* U+6297 */
  0x0000,   /* U+6298 */
  0xE299,   /* U+6299 */
  0xE29A,   /* U+629A */
  0x0000,   /* U+629B */
  0x0000,   /* U+629C */
  0xE29D,   /* U+629D */
  0x0000,   /* U+629E */
  0xE29F,   /* U+629F */
  0xE2A0,   /* U+62A0 */
  0xE2A1,   /* U+62A1 */
  0xE2A2,   /* U+62A2 */
  0xE2A3,   /* U+62A3 */
  0xE2A4,   /* U+62A4 */
  0xE2A5,   /* U+62A5 */
  0xE2A6,   /* U+62A6 */
  0xE2A7,   /* U+62A7 */
  0xE2A8,   /* U+62A8 */
  0xE2A9,   /* U+62A9 */
  0xE2AA,   /* U+62AA */
  0x0000,   /* U+62AB */
  0x0000,   /* U+62AC */
  0xE2AD,   /* U+62AD */
  0xE2AE,   /* U+62AE */
  0xE2AF,   /* U+62AF */
  0xE2B0,   /* U+62B0 */
  0x0000,   /* U+62B1 */
  0xE2B2,   /* U+62B2 */
  0xE2B3,   /* U+62B3 */
  0xE2B4,   /* U+62B4 */
  0x0000,   /* U+62B5 */
  0xE2B6,   /* U+62B6 */
  0xE2B7,   /* U+62B7 */
  0xE2B8,   /* U+62B8 */
  0x0000,   /* U+62B9 */
  0xE2BA,   /* U+62BA */
  0x0000,   /* U+62BB */
  0x0000,   /* U+62BC */
  0x0000,   /* U+62BD */
  0xE2BE,   /* U+62BE */
  0xE2BF,   /* U+62BF */
  0xE2C0,   /* U+62C0 */
  0xE2C1,   /* U+62C1 */
  0x0000,   /* U+62C2 */
  0xE2C3,   /* U+62C3 */
  0xE2C4,   /* U+62C4 */
  0x0000,   /* U+62C5 */
  0x0000,   /* U+62C6 */
  0x0000,   /* U+62C7 */
  0x0000,   /* U+62C8 */
  0x0000,   /* U+62C9 */
  0x0000,   /* U+62CA */
  0xE2CB,   /* U+62CB */
  0x0000,   /* U+62CC */
  0x0000,   /* U+62CD */
  0xE2CE,   /* U+62CE */
  0x0000,   /* U+62CF */
  0x0000,   /* U+62D0 */
  0x0000,   /* U+62D1 */
  0x0000,   /* U+62D2 */
  0x0000,   /* U+62D3 */
  0x0000,   /* U+62D4 */
  0xE2D5,   /* U+62D5 */
  0xE2D6,   /* U+62D6 */
  0x0000,   /* U+62D7 */
  0x0000,   /* U+62D8 */
  0x0000,   /* U+62D9 */
  0xE2DA,   /* U+62DA */
  0x0000,   /* U+62DB */
  0x0000,   /* U+62DC */
  0x0000,   /* U+62DD */
  0xE2DE,   /* U+62DE */
  0xE2DF,   /* U+62DF */
  0x0000,   /* U+62E0 */
  0x0000,   /* U+62E1 */
  0xE2E2,   /* U+62E2 */
  0xE2E3,   /* U+62E3 */
  0xE2E4,   /* U+62E4 */
  0xE2E5,   /* U+62E5 */
  0xE2E6,   /* U+62E6 */
  0xE2E7,   /* U+62E7 */
  0xE2E8,   /* U+62E8 */
  0xE2E9,   /* U+62E9 */
  0xE2EA,   /* U+62EA */
  0xE2EB,   /* U+62EB */
  0x0000,   /* U+62EC */
  0x0000,   /* U+62ED */
  0x0000,   /* U+62EE */
  0x0000,   /* U+62EF */
  0xE2F0,   /* U+62F0 */
  0x0000,   /* U+62F1 */
  0xE2F2,   /* U+62F2 */
  0x0000,   /* U+62F3 */
  0xE2F4,   /* U+62F4 */
  0x0000,   /* U+62F5 */
  0x0000,   /* U+62F6 */
  0x0000,   /* U+62F7 */
  0xE2F8,   /* U+62F8 */
  0xE2F9,   /* U+62F9 */
  0xE2FA,   /* U+62FA */
  0xE2FB,   /* U+62FB */
  0xE2FC,   /* U+62FC */
  0xE2FD,   /* U+62FD */
  0x0000,   /* U+62FE */
  0x0000,   /* U+62FF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+6200 */
  0x0000,   /* U+6201 */
  0x0000,   /* U+6202 */
  0x0000,   /* U+6203 */
  0x0000,   /* U+6204 */
  0x0000,   /* U+6205 */
  0x0000,   /* U+6206 */
  0x0000,   /* U+6207 */
  0x0000,   /* U+6208 */
  0x0000,   /* U+6209 */
  0x0000,   /* U+620A */
  0x0000,   /* U+620B */
  0x0000,   /* U+620C */
  0x0000,   /* U+620D */
  0x0000,   /* U+620E */
  0x0000,   /* U+620F */
  0x0000,   /* U+6210 */
  0x0000,   /* U+6211 */
  0x0000,   /* U+6212 */
  0x0000,   /* U+6213 */
  0x0000,   /* U+6214 */
  0x0000,   /* U+6215 */
  0x0000,   /* U+6216 */
  0x0000,   /* U+6217 */
  0x0000,   /* U+6218 */
  0x0000,   /* U+6219 */
  0x0000,   /* U+621A */
  0x0000,   /* U+621B */
  0x0000,   /* U+621C */
  0x0000,   /* U+621D */
  0x0000,   /* U+621E */
  0x0000,   /* U+621F */
  0x0000,   /* U+6220 */
  0x0000,   /* U+6221 */
  0x0000,   /* U+6222 */
  0x0000,   /* U+6223 */
  0x0000,   /* U+6224 */
  0x0000,   /* U+6225 */
  0x0000,   /* U+6226 */
  0x0000,   /* U+6227 */
  0x0000,   /* U+6228 */
  0x0000,   /* U+6229 */
  0x0000,   /* U+622A */
  0x0000,   /* U+622B */
  0x0000,   /* U+622C */
  0x0000,   /* U+622D */
  0x0000,   /* U+622E */
  0x0000,   /* U+622F */
  0x0000,   /* U+6230 */
  0x0000,   /* U+6231 */
  0x0000,   /* U+6232 */
  0x0000,   /* U+6233 */
  0x0000,   /* U+6234 */
  0x0000,   /* U+6235 */
  0x0000,   /* U+6236 */
  0x0000,   /* U+6237 */
  0x0000,   /* U+6238 */
  0x0000,   /* U+6239 */
  0x0000,   /* U+623A */
  0x0000,   /* U+623B */
  0x0000,   /* U+623C */
  0x0000,   /* U+623D */
  0x0000,   /* U+623E */
  0x0000,   /* U+623F */
  0x0000,   /* U+6240 */
  0x0000,   /* U+6241 */
  0x0000,   /* U+6242 */
  0x0000,   /* U+6243 */
  0x0000,   /* U+6244 */
  0x0000,   /* U+6245 */
  0x0000,   /* U+6246 */
  0x0000,   /* U+6247 */
  0x0000,   /* U+6248 */
  0x0000,   /* U+6249 */
  0x0000,   /* U+624A */
  0x0000,   /* U+624B */
  0x0000,   /* U+624C */
  0x0000,   /* U+624D */
  0x0000,   /* U+624E */
  0x0000,   /* U+624F */
  0x0000,   /* U+6250 */
  0x0000,   /* U+6251 */
  0x0000,   /* U+6252 */
  0x0000,   /* U+6253 */
  0x0000,   /* U+6254 */
  0x0000,   /* U+6255 */
  0x0000,   /* U+6256 */
  0x0000,   /* U+6257 */
  0x0000,   /* U+6258 */
  0x0000,   /* U+6259 */
  0x0000,   /* U+625A */
  0x0000,   /* U+625B */
  0x0000,   /* U+625C */
  0x0000,   /* U+625D */
  0x0000,   /* U+625E */
  0x0000,   /* U+625F */
  0x0000,   /* U+6260 */
  0x0000,   /* U+6261 */
  0x0000,   /* U+6262 */
  0x0000,   /* U+6263 */
  0x0000,   /* U+6264 */
  0x0000,   /* U+6265 */
  0x0000,   /* U+6266 */
  0x0000,   /* U+6267 */
  0x0000,   /* U+6268 */
  0x0000,   /* U+6269 */
  0x0000,   /* U+626A */
  0x0000,   /* U+626B */
  0x0000,   /* U+626C */
  0x0000,   /* U+626D */
  0x0000,   /* U+626E */
  0x0000,   /* U+626F */
  0x0000,   /* U+6270 */
  0x0000,   /* U+6271 */
  0x0000,   /* U+6272 */
  0x0000,   /* U+6273 */
  0x0000,   /* U+6274 */
  0x0000,   /* U+6275 */
  0x0000,   /* U+6276 */
  0x0000,   /* U+6277 */
  0x0000,   /* U+6278 */
  0x0000,   /* U+6279 */
  0x0000,   /* U+627A */
  0x0000,   /* U+627B */
  0x0000,   /* U+627C */
  0x0000,   /* U+627D */
  0x0000,   /* U+627E */
  0x0000,   /* U+627F */
  0x0000,   /* U+6280 */
  0x0000,   /* U+6281 */
  0x0000,   /* U+6282 */
  0x0000,   /* U+6283 */
  0x0000,   /* U+6284 */
  0x0000,   /* U+6285 */
  0x0000,   /* U+6286 */
  0x0000,   /* U+6287 */
  0x0000,   /* U+6288 */
  0x0000,   /* U+6289 */
  0x0000,   /* U+628A */
  0x0000,   /* U+628B */
  0x0000,   /* U+628C */
  0x0000,   /* U+628D */
  0x0000,   /* U+628E */
  0x0000,   /* U+628F */
  0x0000,   /* U+6290 */
  0x0000,   /* U+6291 */
  0x0000,   /* U+6292 */
  0x0000,   /* U+6293 */
  0x0000,   /* U+6294 */
  0x0000,   /* U+6295 */
  0x0000,   /* U+6296 */
  0x0000,   /* U+6297 */
  0x0000,   /* U+6298 */
  0x0000,   /* U+6299 */
  0x0000,   /* U+629A */
  0x0000,   /* U+629B */
  0x0000,   /* U+629C */
  0x0000,   /* U+629D */
  0x0000,   /* U+629E */
  0x0000,   /* U+629F */
  0x0000,   /* U+62A0 */
  0x0000,   /* U+62A1 */
  0x0000,   /* U+62A2 */
  0x0000,   /* U+62A3 */
  0x0000,   /* U+62A4 */
  0x0000,   /* U+62A5 */
  0x0000,   /* U+62A6 */
  0x0000,   /* U+62A7 */
  0x0000,   /* U+62A8 */
  0x0000,   /* U+62A9 */
  0x0000,   /* U+62AA */
  0x0000,   /* U+62AB */
  0x0000,   /* U+62AC */
  0x0000,   /* U+62AD */
  0x0000,   /* U+62AE */
  0x0000,   /* U+62AF */
  0x0000,   /* U+62B0 */
  0x0000,   /* U+62B1 */
  0x0000,   /* U+62B2 */
  0x0000,   /* U+62B3 */
  0x0000,   /* U+62B4 */
  0x0000,   /* U+62B5 */
  0x0000,   /* U+62B6 */
  0x0000,   /* U+62B7 */
  0x0000,   /* U+62B8 */
  0x0000,   /* U+62B9 */
  0x0000,   /* U+62BA */
  0x0000,   /* U+62BB */
  0x0000,   /* U+62BC */
  0x0000,   /* U+62BD */
  0x0000,   /* U+62BE */
  0x0000,   /* U+62BF */
  0x0000,   /* U+62C0 */
  0x0000,   /* U+62C1 */
  0x0000,   /* U+62C2 */
  0x0000,   /* U+62C3 */
  0x0000,   /* U+62C4 */
  0x0000,   /* U+62C5 */
  0x0000,   /* U+62C6 */
  0x0000,   /* U+62C7 */
  0x0000,   /* U+62C8 */
  0x0000,   /* U+62C9 */
  0x0000,   /* U+62CA */
  0x0000,   /* U+62CB */
  0x0000,   /* U+62CC */
  0x0000,   /* U+62CD */
  0x0000,   /* U+62CE */
  0x0000,   /* U+62CF */
  0x0000,   /* U+62D0 */
  0x0000,   /* U+62D1 */
  0x0000,   /* U+62D2 */
  0x0000,   /* U+62D3 */
  0x0000,   /* U+62D4 */
  0x0000,   /* U+62D5 */
  0x0000,   /* U+62D6 */
  0x0000,   /* U+62D7 */
  0x0000,   /* U+62D8 */
  0x0000,   /* U+62D9 */
  0x0000,   /* U+62DA */
  0x0000,   /* U+62DB */
  0x0000,   /* U+62DC */
  0x0000,   /* U+62DD */
  0x0000,   /* U+62DE */
  0x0000,   /* U+62DF */
  0x0000,   /* U+62E0 */
  0x0000,   /* U+62E1 */
  0x0000,   /* U+62E2 */
  0x0000,   /* U+62E3 */
  0x0000,   /* U+62E4 */
  0x0000,   /* U+62E5 */
  0x0000,   /* U+62E6 */
  0x0000,   /* U+62E7 */
  0x0000,   /* U+62E8 */
  0x0000,   /* U+62E9 */
  0x0000,   /* U+62EA */
  0x0000,   /* U+62EB */
  0x0000,   /* U+62EC */
  0x0000,   /* U+62ED */
  0x0000,   /* U+62EE */
  0x0000,   /* U+62EF */
  0x0000,   /* U+62F0 */
  0x0000,   /* U+62F1 */
  0x0000,   /* U+62F2 */
  0x0000,   /* U+62F3 */
  0x0000,   /* U+62F4 */
  0x0000,   /* U+62F5 */
  0x0000,   /* U+62F6 */
  0x0000,   /* U+62F7 */
  0x0000,   /* U+62F8 */
  0x0000,   /* U+62F9 */
  0x0000,   /* U+62FA */
  0x0000,   /* U+62FB */
  0x0000,   /* U+62FC */
  0x0000,   /* U+62FD */
  0x0000,   /* U+62FE */
  0x0000,   /* U+62FF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+6200 */
  0x0000,   /* U+6201 */
  0x0000,   /* U+6202 */
  0x0000,   /* U+6203 */
  0x0000,   /* U+6204 */
  0x0000,   /* U+6205 */
  0x0000,   /* U+6206 */
  0x0000,   /* U+6207 */
  0x0000,   /* U+6208 */
  0x0000,   /* U+6209 */
  0x0000,   /* U+620A */
  0x0000,   /* U+620B */
  0x0000,   /* U+620C */
  0x0000,   /* U+620D */
  0x0000,   /* U+620E */
  0x0000,   /* U+620F */
  0x0000,   /* U+6210 */
  0x0000,   /* U+6211 */
  0x0000,   /* U+6212 */
  0x0000,   /* U+6213 */
  0x0000,   /* U+6214 */
  0x0000,   /* U+6215 */
  0x0000,   /* U+6216 */
  0x0000,   /* U+6217 */
  0x0000,   /* U+6218 */
  0x0000,   /* U+6219 */
  0x0000,   /* U+621A */
  0x0000,   /* U+621B */
  0x0000,   /* U+621C */
  0x0000,   /* U+621D */
  0x0000,   /* U+621E */
  0x0000,   /* U+621F */
  0x0000,   /* U+6220 */
  0x0000,   /* U+6221 */
  0x0000,   /* U+6222 */
  0x0000,   /* U+6223 */
  0x0000,   /* U+6224 */
  0x0000,   /* U+6225 */
  0x0000,   /* U+6226 */
  0x0000,   /* U+6227 */
  0x0000,   /* U+6228 */
  0x0000,   /* U+6229 */
  0x0000,   /* U+622A */
  0x0000,   /* U+622B */
  0x0000,   /* U+622C */
  0x0000,   /* U+622D */
  0x0000,   /* U+622E */
  0x0000,   /* U+622F */
  0x0000,   /* U+6230 */
  0x0000,   /* U+6231 */
  0x0000,   /* U+6232 */
  0x0000,   /* U+6233 */
  0x0000,   /* U+6234 */
  0x0000,   /* U+6235 */
  0x0000,   /* U+6236 */
  0x0000,   /* U+6237 */
  0x0000,   /* U+6238 */
  0x0000,   /* U+6239 */
  0x0000,   /* U+623A */
  0x0000,   /* U+623B */
  0x0000,   /* U+623C */
  0x0000,   /* U+623D */
  0x0000,   /* U+623E */
  0x0000,   /* U+623F */
  0x0000,   /* U+6240 */
  0x0000,   /* U+6241 */
  0x0000,   /* U+6242 */
  0x0000,   /* U+6243 */
  0x0000,   /* U+6244 */
  0x0000,   /* U+6245 */
  0x0000,   /* U+6246 */
  0x0000,   /* U+6247 */
  0x0000,   /* U+6248 */
  0x0000,   /* U+6249 */
  0x0000,   /* U+624A */
  0x0000,   /* U+624B */
  0x0000,   /* U+624C */
  0x0000,   /* U+624D */
  0x0000,   /* U+624E */
  0x0000,   /* U+624F */
  0x0000,   /* U+6250 */
  0x0000,   /* U+6251 */
  0x0000,   /* U+6252 */
  0x0000,   /* U+6253 */
  0x0000,   /* U+6254 */
  0x0000,   /* U+6255 */
  0x0000,   /* U+6256 */
  0x0000,   /* U+6257 */
  0x0000,   /* U+6258 */
  0x0000,   /* U+6259 */
  0x0000,   /* U+625A */
  0x0000,   /* U+625B */
  0x0000,   /* U+625C */
  0x0000,   /* U+625D */
  0x0000,   /* U+625E */
  0x0000,   /* U+625F */
  0x0000,   /* U+6260 */
  0x0000,   /* U+6261 */
  0x0000,   /* U+6262 */
  0x0000,   /* U+6263 */
  0x0000,   /* U+6264 */
  0x0000,   /* U+6265 */
  0x0000,   /* U+6266 */
  0x0000,   /* U+6267 */
  0x0000,   /* U+6268 */
  0x0000,   /* U+6269 */
  0x0000,   /* U+626A */
  0x0000,   /* U+626B */
  0x0000,   /* U+626C */
  0x0000,   /* U+626D */
  0x0000,   /* U+626E */
  0x0000,   /* U+626F */
  0x0000,   /* U+6270 */
  0x0000,   /* U+6271 */
  0x0000,   /* U+6272 */
  0x0000,   /* U+6273 */
  0x0000,   /* U+6274 */
  0x0000,   /* U+6275 */
  0x0000,   /* U+6276 */
  0x0000,   /* U+6277 */
  0x0000,   /* U+6278 */
  0x0000,   /* U+6279 */
  0x0000,   /* U+627A */
  0x0000,   /* U+627B */
  0x0000,   /* U+627C */
  0x0000,   /* U+627D */
  0x0000,   /* U+627E */
  0x0000,   /* U+627F */
  0x0000,   /* U+6280 */
  0x0000,   /* U+6281 */
  0x0000,   /* U+6282 */
  0x0000,   /* U+6283 */
  0x0000,   /* U+6284 */
  0x0000,   /* U+6285 */
  0x0000,   /* U+6286 */
  0x0000,   /* U+6287 */
  0x0000,   /* U+6288 */
  0x0000,   /* U+6289 */
  0x0000,   /* U+628A */
  0x0000,   /* U+628B */
  0x0000,   /* U+628C */
  0x0000,   /* U+628D */
  0x0000,   /* U+628E */
  0x0000,   /* U+628F */
  0x0000,   /* U+6290 */
  0x0000,   /* U+6291 */
  0x0000,   /* U+6292 */
  0x0000,   /* U+6293 */
  0x0000,   /* U+6294 */
  0x0000,   /* U+6295 */
  0x0000,   /* U+6296 */
  0x0000,   /* U+6297 */
  0x0000,   /* U+6298 */
  0x0000,   /* U+6299 */
  0x0000,   /* U+629A */
  0x0000,   /* U+629B */
  0x0000,   /* U+629C */
  0x0000,   /* U+629D */
  0x0000,   /* U+629E */
  0x0000,   /* U+629F */
  0x0000,   /* U+62A0 */
  0x0000,   /* U+62A1 */
  0x0000,   /* U+62A2 */
  0x0000,   /* U+62A3 */
  0x0000,   /* U+62A4 */
  0x0000,   /* U+62A5 */
  0x0000,   /* U+62A6 */
  0x0000,   /* U+62A7 */
  0x0000,   /* U+62A8 */
  0x0000,   /* U+62A9 */
  0x0000,   /* U+62AA */
  0x0000,   /* U+62AB */
  0x0000,   /* U+62AC */
  0x0000,   /* U+62AD */
  0x0000,   /* U+62AE */
  0x0000,   /* U+62AF */
  0x0000,   /* U+62B0 */
  0x0000,   /* U+62B1 */
  0x0000,   /* U+62B2 */
  0x0000,   /* U+62B3 */
  0x0000,   /* U+62B4 */
  0x0000,   /* U+62B5 */
  0x0000,   /* U+62B6 */
  0x0000,   /* U+62B7 */
  0x0000,   /* U+62B8 */
  0x0000,   /* U+62B9 */
  0x0000,   /* U+62BA */
  0x0000,   /* U+62BB */
  0x0000,   /* U+62BC */
  0x0000,   /* U+62BD */
  0x0000,   /* U+62BE */
  0x0000,   /* U+62BF */
  0x0000,   /* U+62C0 */
  0x0000,   /* U+62C1 */
  0x0000,   /* U+62C2 */
  0x0000,   /* U+62C3 */
  0x0000,   /* U+62C4 */
  0x0000,   /* U+62C5 */
  0x0000,   /* U+62C6 */
  0x0000,   /* U+62C7 */
  0x0000,   /* U+62C8 */
  0x0000,   /* U+62C9 */
  0x0000,   /* U+62CA */
  0x0000,   /* U+62CB */
  0x0000,   /* U+62CC */
  0x0000,   /* U+62CD */
  0x0000,   /* U+62CE */
  0x0000,   /* U+62CF */
  0x0000,   /* U+62D0 */
  0x0000,   /* U+62D1 */
  0x0000,   /* U+62D2 */
  0x0000,   /* U+62D3 */
  0x0000,   /* U+62D4 */
  0x0000,   /* U+62D5 */
  0x0000,   /* U+62D6 */
  0x0000,   /* U+62D7 */
  0x0000,   /* U+62D8 */
  0x0000,   /* U+62D9 */
  0x0000,   /* U+62DA */
  0x0000,   /* U+62DB */
  0x0000,   /* U+62DC */
  0x0000,   /* U+62DD */
  0x0000,   /* U+62DE */
  0x0000,   /* U+62DF */
  0x0000,   /* U+62E0 */
  0x0000,   /* U+62E1 */
  0x0000,   /* U+62E2 */
  0x0000,   /* U+62E3 */
  0x0000,   /* U+62E4 */
  0x0000,   /* U+62E5 */
  0x0000,   /* U+62E6 */
  0x0000,   /* U+62E7 */
  0x0000,   /* U+62E8 */
  0x0000,   /* U+62E9 */
  0x0000,   /* U+62EA */
  0x0000,   /* U+62EB */
  0x0000,   /* U+62EC */
  0x0000,   /* U+62ED */
  0x0000,   /* U+62EE */
  0x0000,   /* U+62EF */
  0x0000,   /* U+62F0 */
  0x0000,   /* U+62F1 */
  0x0000,   /* U+62F2 */
  0x0000,   /* U+62F3 */
  0x0000,   /* U+62F4 */
  0x0000,   /* U+62F5 */
  0x0000,   /* U+62F6 */
  0x0000,   /* U+62F7 */
  0x0000,   /* U+62F8 */
  0x0000,   /* U+62F9 */
  0x0000,   /* U+62FA */
  0x0000,   /* U+62FB */
  0x0000,   /* U+62FC */
  0x0000,   /* U+62FD */
  0x0000,   /* U+62FE */
  0x0000,   /* U+62FF */
};

uint16 ja_han_page63[]= {
  /* Number of CEs for each character. */
  2, 1, 1, 2, 2, 2, 2, 1, 1, 1, 2, 2, 1, 2, 2, 2,
  2, 1, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 1,
  2, 2, 2, 2, 2, 2, 2, 1, 1, 2, 2, 1, 2, 2, 2, 1,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 1, 1, 1,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 1, 1, 2, 1,
  1, 2, 2, 2, 2, 1, 2, 1, 2, 2, 2, 2, 1, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 2, 1, 2, 2, 1, 2,
  2, 2, 1, 2, 2, 2, 1, 1, 2, 2, 1, 1, 2, 2, 2, 2,
  1, 2, 2, 1, 2, 2, 2, 2, 1, 1, 2, 2, 1, 2, 1, 1,
  2, 2, 1, 2, 2, 2, 1, 2, 1, 2, 2, 1, 2, 2, 2, 1,
  1, 1, 1, 1, 2, 1, 2, 1, 1, 1, 1, 1, 1, 2, 2, 2,
  2, 2, 1, 2, 1, 1, 2, 2, 2, 2, 2, 1, 2, 2, 1, 2,
  1, 2, 2, 1, 1, 2, 1, 2, 2, 1, 2, 2, 2, 2, 2, 1,
  1, 2, 1, 2, 2, 2, 1, 2, 2, 2, 1, 1, 2, 2, 2, 2,
  2, 1, 2, 1, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 1, 2,
  2, 2, 2, 2, 1, 2, 1, 2, 2, 2, 1, 2, 2, 2, 2, 2,

  /* Primary weight 1 for each character. */
  0xFB40,   /* U+6300 */
  0x590A,   /* U+6301 */
  0x63B2,   /* U+6302 */
  0xFB40,   /* U+6303 */
  0xFB40,   /* U+6304 */
  0xFB40,   /* U+6305 */
  0xFB40,   /* U+6306 */
  0x58E5,   /* U+6307 */
  0x63B3,   /* U+6308 */
  0x54C7,   /* U+6309 */
  0xFB40,   /* U+630A */
  0xFB40,   /* U+630B */
  0x63AE,   /* U+630C */
  0xFB40,   /* U+630D */
  0xFB40,   /* U+630E */
  0xFB40,   /* U+630F */
  0xFB40,   /* U+6310 */
  0x5C04,   /* U+6311 */
  0xFB40,   /* U+6312 */
  0xFB40,   /* U+6313 */
  0xFB40,   /* U+6314 */
  0xFB40,   /* U+6315 */
  0xFB40,   /* U+6316 */
  0xFB40,   /* U+6317 */
  0xFB40,   /* U+6318 */
  0x56CC,   /* U+6319 */
  0xFB40,   /* U+631A */
  0xFB40,   /* U+631B */
  0xFB40,   /* U+631C */
  0xFB40,   /* U+631D */
  0xFB40,   /* U+631E */
  0x56EB,   /* U+631F */
  0xFB40,   /* U+6320 */
  0xFB40,   /* U+6321 */
  0xFB40,   /* U+6322 */
  0xFB40,   /* U+6323 */
  0xFB40,   /* U+6324 */
  0xFB40,   /* U+6325 */
  0xFB40,   /* U+6326 */
  0x63B1,   /* U+6327 */
  0x54AA,   /* U+6328 */
  0xFB40,   /* U+6329 */
  0xFB40,   /* U+632A */
  0x5872,   /* U+632B */
  0xFB40,   /* U+632C */
  0xFB40,   /* U+632D */
  0xFB40,   /* U+632E */
  0x5A3B,   /* U+632F */
  0xFB40,   /* U+6330 */
  0xFB40,   /* U+6331 */
  0xFB40,   /* U+6332 */
  0xFB40,   /* U+6333 */
  0xFB40,   /* U+6334 */
  0xFB40,   /* U+6335 */
  0xFB40,   /* U+6336 */
  0xFB40,   /* U+6337 */
  0xFB40,   /* U+6338 */
  0xFB40,   /* U+6339 */
  0x5C4D,   /* U+633A */
  0xFB40,   /* U+633B */
  0xFB40,   /* U+633C */
  0x5DA7,   /* U+633D */
  0x63B7,   /* U+633E */
  0x5B1F,   /* U+633F */
  0xFB40,   /* U+6340 */
  0xFB40,   /* U+6341 */
  0xFB40,   /* U+6342 */
  0xFB40,   /* U+6343 */
  0xFB40,   /* U+6344 */
  0xFB40,   /* U+6345 */
  0xFB40,   /* U+6346 */
  0xFB40,   /* U+6347 */
  0xFB40,   /* U+6348 */
  0x5B49,   /* U+6349 */
  0xFB40,   /* U+634A */
  0xFB40,   /* U+634B */
  0x58B8,   /* U+634C */
  0x63B8,   /* U+634D */
  0xFB40,   /* U+634E */
  0x63BA,   /* U+634F */
  0x63B6,   /* U+6350 */
  0xFB40,   /* U+6351 */
  0xFB40,   /* U+6352 */
  0xFB40,   /* U+6353 */
  0xFB40,   /* U+6354 */
  0x5E70,   /* U+6355 */
  0xFB40,   /* U+6356 */
  0x5C18,   /* U+6357 */
  0xFB40,   /* U+6358 */
  0xFB40,   /* U+6359 */
  0xFB40,   /* U+635A */
  0xFB40,   /* U+635B */
  0x5B1D,   /* U+635C */
  0xFB40,   /* U+635D */
  0xFB40,   /* U+635E */
  0xFB40,   /* U+635F */
  0xFB40,   /* U+6360 */
  0xFB40,   /* U+6361 */
  0xFB40,   /* U+6362 */
  0xFB40,   /* U+6363 */
  0xFB40,   /* U+6364 */
  0xFB40,   /* U+6365 */
  0xFB40,   /* U+6366 */
  0x5E8A,   /* U+6367 */
  0x5939,   /* U+6368 */
  0x63C6,   /* U+6369 */
  0xFB40,   /* U+636A */
  0x63C5,   /* U+636B */
  0xFB40,   /* U+636C */
  0xFB40,   /* U+636D */
  0x5A7D,   /* U+636E */
  0xFB40,   /* U+636F */
  0xFB40,   /* U+6370 */
  0xFB40,   /* U+6371 */
  0x5793,   /* U+6372 */
  0xFB40,   /* U+6373 */
  0xFB40,   /* U+6374 */
  0xFB40,   /* U+6375 */
  0x63BF,   /* U+6376 */
  0x59E0,   /* U+6377 */
  0xFB40,   /* U+6378 */
  0xFB40,   /* U+6379 */
  0x5CFF,   /* U+637A */
  0x5D26,   /* U+637B */
  0xFB40,   /* U+637C */
  0xFB40,   /* U+637D */
  0xFB40,   /* U+637E */
  0xFB40,   /* U+637F */
  0x63BD,   /* U+6380 */
  0xFB40,   /* U+6381 */
  0xFB40,   /* U+6382 */
  0x5B1E,   /* U+6383 */
  0xFB40,   /* U+6384 */
  0xFB40,   /* U+6385 */
  0xFB40,   /* U+6386 */
  0xFB40,   /* U+6387 */
  0x5963,   /* U+6388 */
  0x63C2,   /* U+6389 */
  0xFB40,   /* U+638A */
  0xFB40,   /* U+638B */
  0x59DF,   /* U+638C */
  0xFB40,   /* U+638D */
  0x63BC,   /* U+638E */
  0x63C1,   /* U+638F */
  0xFB40,   /* U+6390 */
  0xFB40,   /* U+6391 */
  0x5D48,   /* U+6392 */
  0xFB40,   /* U+6393 */
  0xFB40,   /* U+6394 */
  0xFB40,   /* U+6395 */
  0x63BB,   /* U+6396 */
  0xFB40,   /* U+6397 */
  0x5736,   /* U+6398 */
  0xFB40,   /* U+6399 */
  0xFB40,   /* U+639A */
  0x55FA,   /* U+639B */
  0xFB40,   /* U+639C */
  0xFB40,   /* U+639D */
  0xFB40,   /* U+639E */
  0x63C3,   /* U+639F */
  0x5FB2,   /* U+63A0 */
  0x587D,   /* U+63A1 */
  0x5BB2,   /* U+63A2 */
  0x63C0,   /* U+63A3 */
  0xFB40,   /* U+63A4 */
  0x5ABF,   /* U+63A5 */
  0xFB40,   /* U+63A6 */
  0x5806,   /* U+63A7 */
  0x5A69,   /* U+63A8 */
  0x5547,   /* U+63A9 */
  0x5AFD,   /* U+63AA */
  0x63BE,   /* U+63AB */
  0x569E,   /* U+63AC */
  0xFB40,   /* U+63AD */
  0xFB40,   /* U+63AE */
  0xFB40,   /* U+63AF */
  0xFB40,   /* U+63B0 */
  0xFB40,   /* U+63B1 */
  0x575C,   /* U+63B2 */
  0xFB40,   /* U+63B3 */
  0x5C2A,   /* U+63B4 */
  0x63C4,   /* U+63B5 */
  0xFB40,   /* U+63B6 */
  0xFB40,   /* U+63B7 */
  0xFB40,   /* U+63B8 */
  0xFB40,   /* U+63B9 */
  0xFB40,   /* U+63BA */
  0x5B20,   /* U+63BB */
  0xFB40,   /* U+63BC */
  0xFB40,   /* U+63BD */
  0x63C7,   /* U+63BE */
  0xFB40,   /* U+63BF */
  0x63C9,   /* U+63C0 */
  0xFB40,   /* U+63C1 */
  0xFB40,   /* U+63C2 */
  0x5B56,   /* U+63C3 */
  0x63CF,   /* U+63C4 */
  0xFB40,   /* U+63C5 */
  0x63CA,   /* U+63C6 */
  0xFB40,   /* U+63C7 */
  0xFB40,   /* U+63C8 */
  0x63CC,   /* U+63C9 */
  0xFB40,   /* U+63CA */
  0xFB40,   /* U+63CB */
  0xFB40,   /* U+63CC */
  0xFB40,   /* U+63CD */
  0xFB40,   /* U+63CE */
  0x5DF2,   /* U+63CF */
  0x5C4E,   /* U+63D0 */
  0xFB40,   /* U+63D1 */
  0x63CD,   /* U+63D2 */
  0xFB40,   /* U+63D3 */
  0xFB40,   /* U+63D4 */
  0xFB40,   /* U+63D5 */
  0x5F55,   /* U+63D6 */
  0xFB40,   /* U+63D7 */
  0xFB40,   /* U+63D8 */
  0xFB40,   /* U+63D9 */
  0x5F71,   /* U+63DA */
  0x5634,   /* U+63DB */
  0xFB40,   /* U+63DC */
  0xFB40,   /* U+63DD */
  0xFB40,   /* U+63DE */
  0xFB40,   /* U+63DF */
  0xFB40,   /* U+63E0 */
  0x54B1,   /* U+63E1 */
  0xFB40,   /* U+63E2 */
  0x63CB,   /* U+63E3 */
  0xFB40,   /* U+63E4 */
  0xFB40,   /* U+63E5 */
  0xFB40,   /* U+63E6 */
  0xFB40,   /* U+63E7 */
  0xFB40,   /* U+63E8 */
  0x63C8,   /* U+63E9 */
  0xFB40,   /* U+63EA */
  0xFB40,   /* U+63EB */
  0xFB40,   /* U+63EC */
  0xFB40,   /* U+63ED */
  0x5673,   /* U+63EE */
  0xFB40,   /* U+63EF */
  0xFB40,   /* U+63F0 */
  0xFB40,   /* U+63F1 */
  0xFB40,   /* U+63F2 */
  0xFB40,   /* U+63F3 */
  0x5548,   /* U+63F4 */
  0xFB40,   /* U+63F5 */
  0x63CE,   /* U+63F6 */
  0xFB40,   /* U+63F7 */
  0xFB40,   /* U+63F8 */
  0xFB40,   /* U+63F9 */
  0x5F72,   /* U+63FA */
  0xFB40,   /* U+63FB */
  0xFB40,   /* U+63FC */
  0xFB40,   /* U+63FD */
  0xFB40,   /* U+63FE */
  0xFB40,   /* U+63FF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+6300 */
  0x0020,   /* U+6301 */
  0x0020,   /* U+6302 */
  0x0020,   /* U+6303 */
  0x0020,   /* U+6304 */
  0x0020,   /* U+6305 */
  0x0020,   /* U+6306 */
  0x0020,   /* U+6307 */
  0x0020,   /* U+6308 */
  0x0020,   /* U+6309 */
  0x0020,   /* U+630A */
  0x0020,   /* U+630B */
  0x0020,   /* U+630C */
  0x0020,   /* U+630D */
  0x0020,   /* U+630E */
  0x0020,   /* U+630F */
  0x0020,   /* U+6310 */
  0x0020,   /* U+6311 */
  0x0020,   /* U+6312 */
  0x0020,   /* U+6313 */
  0x0020,   /* U+6314 */
  0x0020,   /* U+6315 */
  0x0020,   /* U+6316 */
  0x0020,   /* U+6317 */
  0x0020,   /* U+6318 */
  0x0020,   /* U+6319 */
  0x0020,   /* U+631A */
  0x0020,   /* U+631B */
  0x0020,   /* U+631C */
  0x0020,   /* U+631D */
  0x0020,   /* U+631E */
  0x0020,   /* U+631F */
  0x0020,   /* U+6320 */
  0x0020,   /* U+6321 */
  0x0020,   /* U+6322 */
  0x0020,   /* U+6323 */
  0x0020,   /* U+6324 */
  0x0020,   /* U+6325 */
  0x0020,   /* U+6326 */
  0x0020,   /* U+6327 */
  0x0020,   /* U+6328 */
  0x0020,   /* U+6329 */
  0x0020,   /* U+632A */
  0x0020,   /* U+632B */
  0x0020,   /* U+632C */
  0x0020,   /* U+632D */
  0x0020,   /* U+632E */
  0x0020,   /* U+632F */
  0x0020,   /* U+6330 */
  0x0020,   /* U+6331 */
  0x0020,   /* U+6332 */
  0x0020,   /* U+6333 */
  0x0020,   /* U+6334 */
  0x0020,   /* U+6335 */
  0x0020,   /* U+6336 */
  0x0020,   /* U+6337 */
  0x0020,   /* U+6338 */
  0x0020,   /* U+6339 */
  0x0020,   /* U+633A */
  0x0020,   /* U+633B */
  0x0020,   /* U+633C */
  0x0020,   /* U+633D */
  0x0020,   /* U+633E */
  0x0020,   /* U+633F */
  0x0020,   /* U+6340 */
  0x0020,   /* U+6341 */
  0x0020,   /* U+6342 */
  0x0020,   /* U+6343 */
  0x0020,   /* U+6344 */
  0x0020,   /* U+6345 */
  0x0020,   /* U+6346 */
  0x0020,   /* U+6347 */
  0x0020,   /* U+6348 */
  0x0020,   /* U+6349 */
  0x0020,   /* U+634A */
  0x0020,   /* U+634B */
  0x0020,   /* U+634C */
  0x0020,   /* U+634D */
  0x0020,   /* U+634E */
  0x0020,   /* U+634F */
  0x0020,   /* U+6350 */
  0x0020,   /* U+6351 */
  0x0020,   /* U+6352 */
  0x0020,   /* U+6353 */
  0x0020,   /* U+6354 */
  0x0020,   /* U+6355 */
  0x0020,   /* U+6356 */
  0x0020,   /* U+6357 */
  0x0020,   /* U+6358 */
  0x0020,   /* U+6359 */
  0x0020,   /* U+635A */
  0x0020,   /* U+635B */
  0x0020,   /* U+635C */
  0x0020,   /* U+635D */
  0x0020,   /* U+635E */
  0x0020,   /* U+635F */
  0x0020,   /* U+6360 */
  0x0020,   /* U+6361 */
  0x0020,   /* U+6362 */
  0x0020,   /* U+6363 */
  0x0020,   /* U+6364 */
  0x0020,   /* U+6365 */
  0x0020,   /* U+6366 */
  0x0020,   /* U+6367 */
  0x0020,   /* U+6368 */
  0x0020,   /* U+6369 */
  0x0020,   /* U+636A */
  0x0020,   /* U+636B */
  0x0020,   /* U+636C */
  0x0020,   /* U+636D */
  0x0020,   /* U+636E */
  0x0020,   /* U+636F */
  0x0020,   /* U+6370 */
  0x0020,   /* U+6371 */
  0x0020,   /* U+6372 */
  0x0020,   /* U+6373 */
  0x0020,   /* U+6374 */
  0x0020,   /* U+6375 */
  0x0020,   /* U+6376 */
  0x0020,   /* U+6377 */
  0x0020,   /* U+6378 */
  0x0020,   /* U+6379 */
  0x0020,   /* U+637A */
  0x0020,   /* U+637B */
  0x0020,   /* U+637C */
  0x0020,   /* U+637D */
  0x0020,   /* U+637E */
  0x0020,   /* U+637F */
  0x0020,   /* U+6380 */
  0x0020,   /* U+6381 */
  0x0020,   /* U+6382 */
  0x0020,   /* U+6383 */
  0x0020,   /* U+6384 */
  0x0020,   /* U+6385 */
  0x0020,   /* U+6386 */
  0x0020,   /* U+6387 */
  0x0020,   /* U+6388 */
  0x0020,   /* U+6389 */
  0x0020,   /* U+638A */
  0x0020,   /* U+638B */
  0x0020,   /* U+638C */
  0x0020,   /* U+638D */
  0x0020,   /* U+638E */
  0x0020,   /* U+638F */
  0x0020,   /* U+6390 */
  0x0020,   /* U+6391 */
  0x0020,   /* U+6392 */
  0x0020,   /* U+6393 */
  0x0020,   /* U+6394 */
  0x0020,   /* U+6395 */
  0x0020,   /* U+6396 */
  0x0020,   /* U+6397 */
  0x0020,   /* U+6398 */
  0x0020,   /* U+6399 */
  0x0020,   /* U+639A */
  0x0020,   /* U+639B */
  0x0020,   /* U+639C */
  0x0020,   /* U+639D */
  0x0020,   /* U+639E */
  0x0020,   /* U+639F */
  0x0020,   /* U+63A0 */
  0x0020,   /* U+63A1 */
  0x0020,   /* U+63A2 */
  0x0020,   /* U+63A3 */
  0x0020,   /* U+63A4 */
  0x0020,   /* U+63A5 */
  0x0020,   /* U+63A6 */
  0x0020,   /* U+63A7 */
  0x0020,   /* U+63A8 */
  0x0020,   /* U+63A9 */
  0x0020,   /* U+63AA */
  0x0020,   /* U+63AB */
  0x0020,   /* U+63AC */
  0x0020,   /* U+63AD */
  0x0020,   /* U+63AE */
  0x0020,   /* U+63AF */
  0x0020,   /* U+63B0 */
  0x0020,   /* U+63B1 */
  0x0020,   /* U+63B2 */
  0x0020,   /* U+63B3 */
  0x0020,   /* U+63B4 */
  0x0020,   /* U+63B5 */
  0x0020,   /* U+63B6 */
  0x0020,   /* U+63B7 */
  0x0020,   /* U+63B8 */
  0x0020,   /* U+63B9 */
  0x0020,   /* U+63BA */
  0x0020,   /* U+63BB */
  0x0020,   /* U+63BC */
  0x0020,   /* U+63BD */
  0x0020,   /* U+63BE */
  0x0020,   /* U+63BF */
  0x0020,   /* U+63C0 */
  0x0020,   /* U+63C1 */
  0x0020,   /* U+63C2 */
  0x0020,   /* U+63C3 */
  0x0020,   /* U+63C4 */
  0x0020,   /* U+63C5 */
  0x0020,   /* U+63C6 */
  0x0020,   /* U+63C7 */
  0x0020,   /* U+63C8 */
  0x0020,   /* U+63C9 */
  0x0020,   /* U+63CA */
  0x0020,   /* U+63CB */
  0x0020,   /* U+63CC */
  0x0020,   /* U+63CD */
  0x0020,   /* U+63CE */
  0x0020,   /* U+63CF */
  0x0020,   /* U+63D0 */
  0x0020,   /* U+63D1 */
  0x0020,   /* U+63D2 */
  0x0020,   /* U+63D3 */
  0x0020,   /* U+63D4 */
  0x0020,   /* U+63D5 */
  0x0020,   /* U+63D6 */
  0x0020,   /* U+63D7 */
  0x0020,   /* U+63D8 */
  0x0020,   /* U+63D9 */
  0x0020,   /* U+63DA */
  0x0020,   /* U+63DB */
  0x0020,   /* U+63DC */
  0x0020,   /* U+63DD */
  0x0020,   /* U+63DE */
  0x0020,   /* U+63DF */
  0x0020,   /* U+63E0 */
  0x0020,   /* U+63E1 */
  0x0020,   /* U+63E2 */
  0x0020,   /* U+63E3 */
  0x0020,   /* U+63E4 */
  0x0020,   /* U+63E5 */
  0x0020,   /* U+63E6 */
  0x0020,   /* U+63E7 */
  0x0020,   /* U+63E8 */
  0x0020,   /* U+63E9 */
  0x0020,   /* U+63EA */
  0x0020,   /* U+63EB */
  0x0020,   /* U+63EC */
  0x0020,   /* U+63ED */
  0x0020,   /* U+63EE */
  0x0020,   /* U+63EF */
  0x0020,   /* U+63F0 */
  0x0020,   /* U+63F1 */
  0x0020,   /* U+63F2 */
  0x0020,   /* U+63F3 */
  0x0020,   /* U+63F4 */
  0x0020,   /* U+63F5 */
  0x0020,   /* U+63F6 */
  0x0020,   /* U+63F7 */
  0x0020,   /* U+63F8 */
  0x0020,   /* U+63F9 */
  0x0020,   /* U+63FA */
  0x0020,   /* U+63FB */
  0x0020,   /* U+63FC */
  0x0020,   /* U+63FD */
  0x0020,   /* U+63FE */
  0x0020,   /* U+63FF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+6300 */
  0x0002,   /* U+6301 */
  0x0002,   /* U+6302 */
  0x0002,   /* U+6303 */
  0x0002,   /* U+6304 */
  0x0002,   /* U+6305 */
  0x0002,   /* U+6306 */
  0x0002,   /* U+6307 */
  0x0002,   /* U+6308 */
  0x0002,   /* U+6309 */
  0x0002,   /* U+630A */
  0x0002,   /* U+630B */
  0x0002,   /* U+630C */
  0x0002,   /* U+630D */
  0x0002,   /* U+630E */
  0x0002,   /* U+630F */
  0x0002,   /* U+6310 */
  0x0002,   /* U+6311 */
  0x0002,   /* U+6312 */
  0x0002,   /* U+6313 */
  0x0002,   /* U+6314 */
  0x0002,   /* U+6315 */
  0x0002,   /* U+6316 */
  0x0002,   /* U+6317 */
  0x0002,   /* U+6318 */
  0x0002,   /* U+6319 */
  0x0002,   /* U+631A */
  0x0002,   /* U+631B */
  0x0002,   /* U+631C */
  0x0002,   /* U+631D */
  0x0002,   /* U+631E */
  0x0002,   /* U+631F */
  0x0002,   /* U+6320 */
  0x0002,   /* U+6321 */
  0x0002,   /* U+6322 */
  0x0002,   /* U+6323 */
  0x0002,   /* U+6324 */
  0x0002,   /* U+6325 */
  0x0002,   /* U+6326 */
  0x0002,   /* U+6327 */
  0x0002,   /* U+6328 */
  0x0002,   /* U+6329 */
  0x0002,   /* U+632A */
  0x0002,   /* U+632B */
  0x0002,   /* U+632C */
  0x0002,   /* U+632D */
  0x0002,   /* U+632E */
  0x0002,   /* U+632F */
  0x0002,   /* U+6330 */
  0x0002,   /* U+6331 */
  0x0002,   /* U+6332 */
  0x0002,   /* U+6333 */
  0x0002,   /* U+6334 */
  0x0002,   /* U+6335 */
  0x0002,   /* U+6336 */
  0x0002,   /* U+6337 */
  0x0002,   /* U+6338 */
  0x0002,   /* U+6339 */
  0x0002,   /* U+633A */
  0x0002,   /* U+633B */
  0x0002,   /* U+633C */
  0x0002,   /* U+633D */
  0x0002,   /* U+633E */
  0x0002,   /* U+633F */
  0x0002,   /* U+6340 */
  0x0002,   /* U+6341 */
  0x0002,   /* U+6342 */
  0x0002,   /* U+6343 */
  0x0002,   /* U+6344 */
  0x0002,   /* U+6345 */
  0x0002,   /* U+6346 */
  0x0002,   /* U+6347 */
  0x0002,   /* U+6348 */
  0x0002,   /* U+6349 */
  0x0002,   /* U+634A */
  0x0002,   /* U+634B */
  0x0002,   /* U+634C */
  0x0002,   /* U+634D */
  0x0002,   /* U+634E */
  0x0002,   /* U+634F */
  0x0002,   /* U+6350 */
  0x0002,   /* U+6351 */
  0x0002,   /* U+6352 */
  0x0002,   /* U+6353 */
  0x0002,   /* U+6354 */
  0x0002,   /* U+6355 */
  0x0002,   /* U+6356 */
  0x0002,   /* U+6357 */
  0x0002,   /* U+6358 */
  0x0002,   /* U+6359 */
  0x0002,   /* U+635A */
  0x0002,   /* U+635B */
  0x0002,   /* U+635C */
  0x0002,   /* U+635D */
  0x0002,   /* U+635E */
  0x0002,   /* U+635F */
  0x0002,   /* U+6360 */
  0x0002,   /* U+6361 */
  0x0002,   /* U+6362 */
  0x0002,   /* U+6363 */
  0x0002,   /* U+6364 */
  0x0002,   /* U+6365 */
  0x0002,   /* U+6366 */
  0x0002,   /* U+6367 */
  0x0002,   /* U+6368 */
  0x0002,   /* U+6369 */
  0x0002,   /* U+636A */
  0x0002,   /* U+636B */
  0x0002,   /* U+636C */
  0x0002,   /* U+636D */
  0x0002,   /* U+636E */
  0x0002,   /* U+636F */
  0x0002,   /* U+6370 */
  0x0002,   /* U+6371 */
  0x0002,   /* U+6372 */
  0x0002,   /* U+6373 */
  0x0002,   /* U+6374 */
  0x0002,   /* U+6375 */
  0x0002,   /* U+6376 */
  0x0002,   /* U+6377 */
  0x0002,   /* U+6378 */
  0x0002,   /* U+6379 */
  0x0002,   /* U+637A */
  0x0002,   /* U+637B */
  0x0002,   /* U+637C */
  0x0002,   /* U+637D */
  0x0002,   /* U+637E */
  0x0002,   /* U+637F */
  0x0002,   /* U+6380 */
  0x0002,   /* U+6381 */
  0x0002,   /* U+6382 */
  0x0002,   /* U+6383 */
  0x0002,   /* U+6384 */
  0x0002,   /* U+6385 */
  0x0002,   /* U+6386 */
  0x0002,   /* U+6387 */
  0x0002,   /* U+6388 */
  0x0002,   /* U+6389 */
  0x0002,   /* U+638A */
  0x0002,   /* U+638B */
  0x0002,   /* U+638C */
  0x0002,   /* U+638D */
  0x0002,   /* U+638E */
  0x0002,   /* U+638F */
  0x0002,   /* U+6390 */
  0x0002,   /* U+6391 */
  0x0002,   /* U+6392 */
  0x0002,   /* U+6393 */
  0x0002,   /* U+6394 */
  0x0002,   /* U+6395 */
  0x0002,   /* U+6396 */
  0x0002,   /* U+6397 */
  0x0002,   /* U+6398 */
  0x0002,   /* U+6399 */
  0x0002,   /* U+639A */
  0x0002,   /* U+639B */
  0x0002,   /* U+639C */
  0x0002,   /* U+639D */
  0x0002,   /* U+639E */
  0x0002,   /* U+639F */
  0x0002,   /* U+63A0 */
  0x0002,   /* U+63A1 */
  0x0002,   /* U+63A2 */
  0x0002,   /* U+63A3 */
  0x0002,   /* U+63A4 */
  0x0002,   /* U+63A5 */
  0x0002,   /* U+63A6 */
  0x0002,   /* U+63A7 */
  0x0002,   /* U+63A8 */
  0x0002,   /* U+63A9 */
  0x0002,   /* U+63AA */
  0x0002,   /* U+63AB */
  0x0002,   /* U+63AC */
  0x0002,   /* U+63AD */
  0x0002,   /* U+63AE */
  0x0002,   /* U+63AF */
  0x0002,   /* U+63B0 */
  0x0002,   /* U+63B1 */
  0x0002,   /* U+63B2 */
  0x0002,   /* U+63B3 */
  0x0002,   /* U+63B4 */
  0x0002,   /* U+63B5 */
  0x0002,   /* U+63B6 */
  0x0002,   /* U+63B7 */
  0x0002,   /* U+63B8 */
  0x0002,   /* U+63B9 */
  0x0002,   /* U+63BA */
  0x0002,   /* U+63BB */
  0x0002,   /* U+63BC */
  0x0002,   /* U+63BD */
  0x0002,   /* U+63BE */
  0x0002,   /* U+63BF */
  0x0002,   /* U+63C0 */
  0x0002,   /* U+63C1 */
  0x0002,   /* U+63C2 */
  0x0002,   /* U+63C3 */
  0x0002,   /* U+63C4 */
  0x0002,   /* U+63C5 */
  0x0002,   /* U+63C6 */
  0x0002,   /* U+63C7 */
  0x0002,   /* U+63C8 */
  0x0002,   /* U+63C9 */
  0x0002,   /* U+63CA */
  0x0002,   /* U+63CB */
  0x0002,   /* U+63CC */
  0x0002,   /* U+63CD */
  0x0002,   /* U+63CE */
  0x0002,   /* U+63CF */
  0x0002,   /* U+63D0 */
  0x0002,   /* U+63D1 */
  0x0002,   /* U+63D2 */
  0x0002,   /* U+63D3 */
  0x0002,   /* U+63D4 */
  0x0002,   /* U+63D5 */
  0x0002,   /* U+63D6 */
  0x0002,   /* U+63D7 */
  0x0002,   /* U+63D8 */
  0x0002,   /* U+63D9 */
  0x0002,   /* U+63DA */
  0x0002,   /* U+63DB */
  0x0002,   /* U+63DC */
  0x0002,   /* U+63DD */
  0x0002,   /* U+63DE */
  0x0002,   /* U+63DF */
  0x0002,   /* U+63E0 */
  0x0002,   /* U+63E1 */
  0x0002,   /* U+63E2 */
  0x0002,   /* U+63E3 */
  0x0002,   /* U+63E4 */
  0x0002,   /* U+63E5 */
  0x0002,   /* U+63E6 */
  0x0002,   /* U+63E7 */
  0x0002,   /* U+63E8 */
  0x0002,   /* U+63E9 */
  0x0002,   /* U+63EA */
  0x0002,   /* U+63EB */
  0x0002,   /* U+63EC */
  0x0002,   /* U+63ED */
  0x0002,   /* U+63EE */
  0x0002,   /* U+63EF */
  0x0002,   /* U+63F0 */
  0x0002,   /* U+63F1 */
  0x0002,   /* U+63F2 */
  0x0002,   /* U+63F3 */
  0x0002,   /* U+63F4 */
  0x0002,   /* U+63F5 */
  0x0002,   /* U+63F6 */
  0x0002,   /* U+63F7 */
  0x0002,   /* U+63F8 */
  0x0002,   /* U+63F9 */
  0x0002,   /* U+63FA */
  0x0002,   /* U+63FB */
  0x0002,   /* U+63FC */
  0x0002,   /* U+63FD */
  0x0002,   /* U+63FE */
  0x0002,   /* U+63FF */

  /* Primary weight 2 for each character. */
  0xE300,   /* U+6300 */
  0x0000,   /* U+6301 */
  0x0000,   /* U+6302 */
  0xE303,   /* U+6303 */
  0xE304,   /* U+6304 */
  0xE305,   /* U+6305 */
  0xE306,   /* U+6306 */
  0x0000,   /* U+6307 */
  0x0000,   /* U+6308 */
  0x0000,   /* U+6309 */
  0xE30A,   /* U+630A */
  0xE30B,   /* U+630B */
  0x0000,   /* U+630C */
  0xE30D,   /* U+630D */
  0xE30E,   /* U+630E */
  0xE30F,   /* U+630F */
  0xE310,   /* U+6310 */
  0x0000,   /* U+6311 */
  0xE312,   /* U+6312 */
  0xE313,   /* U+6313 */
  0xE314,   /* U+6314 */
  0xE315,   /* U+6315 */
  0xE316,   /* U+6316 */
  0xE317,   /* U+6317 */
  0xE318,   /* U+6318 */
  0x0000,   /* U+6319 */
  0xE31A,   /* U+631A */
  0xE31B,   /* U+631B */
  0xE31C,   /* U+631C */
  0xE31D,   /* U+631D */
  0xE31E,   /* U+631E */
  0x0000,   /* U+631F */
  0xE320,   /* U+6320 */
  0xE321,   /* U+6321 */
  0xE322,   /* U+6322 */
  0xE323,   /* U+6323 */
  0xE324,   /* U+6324 */
  0xE325,   /* U+6325 */
  0xE326,   /* U+6326 */
  0x0000,   /* U+6327 */
  0x0000,   /* U+6328 */
  0xE329,   /* U+6329 */
  0xE32A,   /* U+632A */
  0x0000,   /* U+632B */
  0xE32C,   /* U+632C */
  0xE32D,   /* U+632D */
  0xE32E,   /* U+632E */
  0x0000,   /* U+632F */
  0xE330,   /* U+6330 */
  0xE331,   /* U+6331 */
  0xE332,   /* U+6332 */
  0xE333,   /* U+6333 */
  0xE334,   /* U+6334 */
  0xE335,   /* U+6335 */
  0xE336,   /* U+6336 */
  0xE337,   /* U+6337 */
  0xE338,   /* U+6338 */
  0xE339,   /* U+6339 */
  0x0000,   /* U+633A */
  0xE33B,   /* U+633B */
  0xE33C,   /* U+633C */
  0x0000,   /* U+633D */
  0x0000,   /* U+633E */
  0x0000,   /* U+633F */
  0xE340,   /* U+6340 */
  0xE341,   /* U+6341 */
  0xE342,   /* U+6342 */
  0xE343,   /* U+6343 */
  0xE344,   /* U+6344 */
  0xE345,   /* U+6345 */
  0xE346,   /* U+6346 */
  0xE347,   /* U+6347 */
  0xE348,   /* U+6348 */
  0x0000,   /* U+6349 */
  0xE34A,   /* U+634A */
  0xE34B,   /* U+634B */
  0x0000,   /* U+634C */
  0x0000,   /* U+634D */
  0xE34E,   /* U+634E */
  0x0000,   /* U+634F */
  0x0000,   /* U+6350 */
  0xE351,   /* U+6351 */
  0xE352,   /* U+6352 */
  0xE353,   /* U+6353 */
  0xE354,   /* U+6354 */
  0x0000,   /* U+6355 */
  0xE356,   /* U+6356 */
  0x0000,   /* U+6357 */
  0xE358,   /* U+6358 */
  0xE359,   /* U+6359 */
  0xE35A,   /* U+635A */
  0xE35B,   /* U+635B */
  0x0000,   /* U+635C */
  0xE35D,   /* U+635D */
  0xE35E,   /* U+635E */
  0xE35F,   /* U+635F */
  0xE360,   /* U+6360 */
  0xE361,   /* U+6361 */
  0xE362,   /* U+6362 */
  0xE363,   /* U+6363 */
  0xE364,   /* U+6364 */
  0xE365,   /* U+6365 */
  0xE366,   /* U+6366 */
  0x0000,   /* U+6367 */
  0x0000,   /* U+6368 */
  0x0000,   /* U+6369 */
  0xE36A,   /* U+636A */
  0x0000,   /* U+636B */
  0xE36C,   /* U+636C */
  0xE36D,   /* U+636D */
  0x0000,   /* U+636E */
  0xE36F,   /* U+636F */
  0xE370,   /* U+6370 */
  0xE371,   /* U+6371 */
  0x0000,   /* U+6372 */
  0xE373,   /* U+6373 */
  0xE374,   /* U+6374 */
  0xE375,   /* U+6375 */
  0x0000,   /* U+6376 */
  0x0000,   /* U+6377 */
  0xE378,   /* U+6378 */
  0xE379,   /* U+6379 */
  0x0000,   /* U+637A */
  0x0000,   /* U+637B */
  0xE37C,   /* U+637C */
  0xE37D,   /* U+637D */
  0xE37E,   /* U+637E */
  0xE37F,   /* U+637F */
  0x0000,   /* U+6380 */
  0xE381,   /* U+6381 */
  0xE382,   /* U+6382 */
  0x0000,   /* U+6383 */
  0xE384,   /* U+6384 */
  0xE385,   /* U+6385 */
  0xE386,   /* U+6386 */
  0xE387,   /* U+6387 */
  0x0000,   /* U+6388 */
  0x0000,   /* U+6389 */
  0xE38A,   /* U+638A */
  0xE38B,   /* U+638B */
  0x0000,   /* U+638C */
  0xE38D,   /* U+638D */
  0x0000,   /* U+638E */
  0x0000,   /* U+638F */
  0xE390,   /* U+6390 */
  0xE391,   /* U+6391 */
  0x0000,   /* U+6392 */
  0xE393,   /* U+6393 */
  0xE394,   /* U+6394 */
  0xE395,   /* U+6395 */
  0x0000,   /* U+6396 */
  0xE397,   /* U+6397 */
  0x0000,   /* U+6398 */
  0xE399,   /* U+6399 */
  0xE39A,   /* U+639A */
  0x0000,   /* U+639B */
  0xE39C,   /* U+639C */
  0xE39D,   /* U+639D */
  0xE39E,   /* U+639E */
  0x0000,   /* U+639F */
  0x0000,   /* U+63A0 */
  0x0000,   /* U+63A1 */
  0x0000,   /* U+63A2 */
  0x0000,   /* U+63A3 */
  0xE3A4,   /* U+63A4 */
  0x0000,   /* U+63A5 */
  0xE3A6,   /* U+63A6 */
  0x0000,   /* U+63A7 */
  0x0000,   /* U+63A8 */
  0x0000,   /* U+63A9 */
  0x0000,   /* U+63AA */
  0x0000,   /* U+63AB */
  0x0000,   /* U+63AC */
  0xE3AD,   /* U+63AD */
  0xE3AE,   /* U+63AE */
  0xE3AF,   /* U+63AF */
  0xE3B0,   /* U+63B0 */
  0xE3B1,   /* U+63B1 */
  0x0000,   /* U+63B2 */
  0xE3B3,   /* U+63B3 */
  0x0000,   /* U+63B4 */
  0x0000,   /* U+63B5 */
  0xE3B6,   /* U+63B6 */
  0xE3B7,   /* U+63B7 */
  0xE3B8,   /* U+63B8 */
  0xE3B9,   /* U+63B9 */
  0xE3BA,   /* U+63BA */
  0x0000,   /* U+63BB */
  0xE3BC,   /* U+63BC */
  0xE3BD,   /* U+63BD */
  0x0000,   /* U+63BE */
  0xE3BF,   /* U+63BF */
  0x0000,   /* U+63C0 */
  0xE3C1,   /* U+63C1 */
  0xE3C2,   /* U+63C2 */
  0x0000,   /* U+63C3 */
  0x0000,   /* U+63C4 */
  0xE3C5,   /* U+63C5 */
  0x0000,   /* U+63C6 */
  0xE3C7,   /* U+63C7 */
  0xE3C8,   /* U+63C8 */
  0x0000,   /* U+63C9 */
  0xE3CA,   /* U+63CA */
  0xE3CB,   /* U+63CB */
  0xE3CC,   /* U+63CC */
  0xE3CD,   /* U+63CD */
  0xE3CE,   /* U+63CE */
  0x0000,   /* U+63CF */
  0x0000,   /* U+63D0 */
  0xE3D1,   /* U+63D1 */
  0x0000,   /* U+63D2 */
  0xE3D3,   /* U+63D3 */
  0xE3D4,   /* U+63D4 */
  0xE3D5,   /* U+63D5 */
  0x0000,   /* U+63D6 */
  0xE3D7,   /* U+63D7 */
  0xE3D8,   /* U+63D8 */
  0xE3D9,   /* U+63D9 */
  0x0000,   /* U+63DA */
  0x0000,   /* U+63DB */
  0xE3DC,   /* U+63DC */
  0xE3DD,   /* U+63DD */
  0xE3DE,   /* U+63DE */
  0xE3DF,   /* U+63DF */
  0xE3E0,   /* U+63E0 */
  0x0000,   /* U+63E1 */
  0xE3E2,   /* U+63E2 */
  0x0000,   /* U+63E3 */
  0xE3E4,   /* U+63E4 */
  0xE3E5,   /* U+63E5 */
  0xE3E6,   /* U+63E6 */
  0xE3E7,   /* U+63E7 */
  0xE3E8,   /* U+63E8 */
  0x0000,   /* U+63E9 */
  0xE3EA,   /* U+63EA */
  0xE3EB,   /* U+63EB */
  0xE3EC,   /* U+63EC */
  0xE3ED,   /* U+63ED */
  0x0000,   /* U+63EE */
  0xE3EF,   /* U+63EF */
  0xE3F0,   /* U+63F0 */
  0xE3F1,   /* U+63F1 */
  0xE3F2,   /* U+63F2 */
  0xE3F3,   /* U+63F3 */
  0x0000,   /* U+63F4 */
  0xE3F5,   /* U+63F5 */
  0x0000,   /* U+63F6 */
  0xE3F7,   /* U+63F7 */
  0xE3F8,   /* U+63F8 */
  0xE3F9,   /* U+63F9 */
  0x0000,   /* U+63FA */
  0xE3FB,   /* U+63FB */
  0xE3FC,   /* U+63FC */
  0xE3FD,   /* U+63FD */
  0xE3FE,   /* U+63FE */
  0xE3FF,   /* U+63FF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+6300 */
  0x0000,   /* U+6301 */
  0x0000,   /* U+6302 */
  0x0000,   /* U+6303 */
  0x0000,   /* U+6304 */
  0x0000,   /* U+6305 */
  0x0000,   /* U+6306 */
  0x0000,   /* U+6307 */
  0x0000,   /* U+6308 */
  0x0000,   /* U+6309 */
  0x0000,   /* U+630A */
  0x0000,   /* U+630B */
  0x0000,   /* U+630C */
  0x0000,   /* U+630D */
  0x0000,   /* U+630E */
  0x0000,   /* U+630F */
  0x0000,   /* U+6310 */
  0x0000,   /* U+6311 */
  0x0000,   /* U+6312 */
  0x0000,   /* U+6313 */
  0x0000,   /* U+6314 */
  0x0000,   /* U+6315 */
  0x0000,   /* U+6316 */
  0x0000,   /* U+6317 */
  0x0000,   /* U+6318 */
  0x0000,   /* U+6319 */
  0x0000,   /* U+631A */
  0x0000,   /* U+631B */
  0x0000,   /* U+631C */
  0x0000,   /* U+631D */
  0x0000,   /* U+631E */
  0x0000,   /* U+631F */
  0x0000,   /* U+6320 */
  0x0000,   /* U+6321 */
  0x0000,   /* U+6322 */
  0x0000,   /* U+6323 */
  0x0000,   /* U+6324 */
  0x0000,   /* U+6325 */
  0x0000,   /* U+6326 */
  0x0000,   /* U+6327 */
  0x0000,   /* U+6328 */
  0x0000,   /* U+6329 */
  0x0000,   /* U+632A */
  0x0000,   /* U+632B */
  0x0000,   /* U+632C */
  0x0000,   /* U+632D */
  0x0000,   /* U+632E */
  0x0000,   /* U+632F */
  0x0000,   /* U+6330 */
  0x0000,   /* U+6331 */
  0x0000,   /* U+6332 */
  0x0000,   /* U+6333 */
  0x0000,   /* U+6334 */
  0x0000,   /* U+6335 */
  0x0000,   /* U+6336 */
  0x0000,   /* U+6337 */
  0x0000,   /* U+6338 */
  0x0000,   /* U+6339 */
  0x0000,   /* U+633A */
  0x0000,   /* U+633B */
  0x0000,   /* U+633C */
  0x0000,   /* U+633D */
  0x0000,   /* U+633E */
  0x0000,   /* U+633F */
  0x0000,   /* U+6340 */
  0x0000,   /* U+6341 */
  0x0000,   /* U+6342 */
  0x0000,   /* U+6343 */
  0x0000,   /* U+6344 */
  0x0000,   /* U+6345 */
  0x0000,   /* U+6346 */
  0x0000,   /* U+6347 */
  0x0000,   /* U+6348 */
  0x0000,   /* U+6349 */
  0x0000,   /* U+634A */
  0x0000,   /* U+634B */
  0x0000,   /* U+634C */
  0x0000,   /* U+634D */
  0x0000,   /* U+634E */
  0x0000,   /* U+634F */
  0x0000,   /* U+6350 */
  0x0000,   /* U+6351 */
  0x0000,   /* U+6352 */
  0x0000,   /* U+6353 */
  0x0000,   /* U+6354 */
  0x0000,   /* U+6355 */
  0x0000,   /* U+6356 */
  0x0000,   /* U+6357 */
  0x0000,   /* U+6358 */
  0x0000,   /* U+6359 */
  0x0000,   /* U+635A */
  0x0000,   /* U+635B */
  0x0000,   /* U+635C */
  0x0000,   /* U+635D */
  0x0000,   /* U+635E */
  0x0000,   /* U+635F */
  0x0000,   /* U+6360 */
  0x0000,   /* U+6361 */
  0x0000,   /* U+6362 */
  0x0000,   /* U+6363 */
  0x0000,   /* U+6364 */
  0x0000,   /* U+6365 */
  0x0000,   /* U+6366 */
  0x0000,   /* U+6367 */
  0x0000,   /* U+6368 */
  0x0000,   /* U+6369 */
  0x0000,   /* U+636A */
  0x0000,   /* U+636B */
  0x0000,   /* U+636C */
  0x0000,   /* U+636D */
  0x0000,   /* U+636E */
  0x0000,   /* U+636F */
  0x0000,   /* U+6370 */
  0x0000,   /* U+6371 */
  0x0000,   /* U+6372 */
  0x0000,   /* U+6373 */
  0x0000,   /* U+6374 */
  0x0000,   /* U+6375 */
  0x0000,   /* U+6376 */
  0x0000,   /* U+6377 */
  0x0000,   /* U+6378 */
  0x0000,   /* U+6379 */
  0x0000,   /* U+637A */
  0x0000,   /* U+637B */
  0x0000,   /* U+637C */
  0x0000,   /* U+637D */
  0x0000,   /* U+637E */
  0x0000,   /* U+637F */
  0x0000,   /* U+6380 */
  0x0000,   /* U+6381 */
  0x0000,   /* U+6382 */
  0x0000,   /* U+6383 */
  0x0000,   /* U+6384 */
  0x0000,   /* U+6385 */
  0x0000,   /* U+6386 */
  0x0000,   /* U+6387 */
  0x0000,   /* U+6388 */
  0x0000,   /* U+6389 */
  0x0000,   /* U+638A */
  0x0000,   /* U+638B */
  0x0000,   /* U+638C */
  0x0000,   /* U+638D */
  0x0000,   /* U+638E */
  0x0000,   /* U+638F */
  0x0000,   /* U+6390 */
  0x0000,   /* U+6391 */
  0x0000,   /* U+6392 */
  0x0000,   /* U+6393 */
  0x0000,   /* U+6394 */
  0x0000,   /* U+6395 */
  0x0000,   /* U+6396 */
  0x0000,   /* U+6397 */
  0x0000,   /* U+6398 */
  0x0000,   /* U+6399 */
  0x0000,   /* U+639A */
  0x0000,   /* U+639B */
  0x0000,   /* U+639C */
  0x0000,   /* U+639D */
  0x0000,   /* U+639E */
  0x0000,   /* U+639F */
  0x0000,   /* U+63A0 */
  0x0000,   /* U+63A1 */
  0x0000,   /* U+63A2 */
  0x0000,   /* U+63A3 */
  0x0000,   /* U+63A4 */
  0x0000,   /* U+63A5 */
  0x0000,   /* U+63A6 */
  0x0000,   /* U+63A7 */
  0x0000,   /* U+63A8 */
  0x0000,   /* U+63A9 */
  0x0000,   /* U+63AA */
  0x0000,   /* U+63AB */
  0x0000,   /* U+63AC */
  0x0000,   /* U+63AD */
  0x0000,   /* U+63AE */
  0x0000,   /* U+63AF */
  0x0000,   /* U+63B0 */
  0x0000,   /* U+63B1 */
  0x0000,   /* U+63B2 */
  0x0000,   /* U+63B3 */
  0x0000,   /* U+63B4 */
  0x0000,   /* U+63B5 */
  0x0000,   /* U+63B6 */
  0x0000,   /* U+63B7 */
  0x0000,   /* U+63B8 */
  0x0000,   /* U+63B9 */
  0x0000,   /* U+63BA */
  0x0000,   /* U+63BB */
  0x0000,   /* U+63BC */
  0x0000,   /* U+63BD */
  0x0000,   /* U+63BE */
  0x0000,   /* U+63BF */
  0x0000,   /* U+63C0 */
  0x0000,   /* U+63C1 */
  0x0000,   /* U+63C2 */
  0x0000,   /* U+63C3 */
  0x0000,   /* U+63C4 */
  0x0000,   /* U+63C5 */
  0x0000,   /* U+63C6 */
  0x0000,   /* U+63C7 */
  0x0000,   /* U+63C8 */
  0x0000,   /* U+63C9 */
  0x0000,   /* U+63CA */
  0x0000,   /* U+63CB */
  0x0000,   /* U+63CC */
  0x0000,   /* U+63CD */
  0x0000,   /* U+63CE */
  0x0000,   /* U+63CF */
  0x0000,   /* U+63D0 */
  0x0000,   /* U+63D1 */
  0x0000,   /* U+63D2 */
  0x0000,   /* U+63D3 */
  0x0000,   /* U+63D4 */
  0x0000,   /* U+63D5 */
  0x0000,   /* U+63D6 */
  0x0000,   /* U+63D7 */
  0x0000,   /* U+63D8 */
  0x0000,   /* U+63D9 */
  0x0000,   /* U+63DA */
  0x0000,   /* U+63DB */
  0x0000,   /* U+63DC */
  0x0000,   /* U+63DD */
  0x0000,   /* U+63DE */
  0x0000,   /* U+63DF */
  0x0000,   /* U+63E0 */
  0x0000,   /* U+63E1 */
  0x0000,   /* U+63E2 */
  0x0000,   /* U+63E3 */
  0x0000,   /* U+63E4 */
  0x0000,   /* U+63E5 */
  0x0000,   /* U+63E6 */
  0x0000,   /* U+63E7 */
  0x0000,   /* U+63E8 */
  0x0000,   /* U+63E9 */
  0x0000,   /* U+63EA */
  0x0000,   /* U+63EB */
  0x0000,   /* U+63EC */
  0x0000,   /* U+63ED */
  0x0000,   /* U+63EE */
  0x0000,   /* U+63EF */
  0x0000,   /* U+63F0 */
  0x0000,   /* U+63F1 */
  0x0000,   /* U+63F2 */
  0x0000,   /* U+63F3 */
  0x0000,   /* U+63F4 */
  0x0000,   /* U+63F5 */
  0x0000,   /* U+63F6 */
  0x0000,   /* U+63F7 */
  0x0000,   /* U+63F8 */
  0x0000,   /* U+63F9 */
  0x0000,   /* U+63FA */
  0x0000,   /* U+63FB */
  0x0000,   /* U+63FC */
  0x0000,   /* U+63FD */
  0x0000,   /* U+63FE */
  0x0000,   /* U+63FF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+6300 */
  0x0000,   /* U+6301 */
  0x0000,   /* U+6302 */
  0x0000,   /* U+6303 */
  0x0000,   /* U+6304 */
  0x0000,   /* U+6305 */
  0x0000,   /* U+6306 */
  0x0000,   /* U+6307 */
  0x0000,   /* U+6308 */
  0x0000,   /* U+6309 */
  0x0000,   /* U+630A */
  0x0000,   /* U+630B */
  0x0000,   /* U+630C */
  0x0000,   /* U+630D */
  0x0000,   /* U+630E */
  0x0000,   /* U+630F */
  0x0000,   /* U+6310 */
  0x0000,   /* U+6311 */
  0x0000,   /* U+6312 */
  0x0000,   /* U+6313 */
  0x0000,   /* U+6314 */
  0x0000,   /* U+6315 */
  0x0000,   /* U+6316 */
  0x0000,   /* U+6317 */
  0x0000,   /* U+6318 */
  0x0000,   /* U+6319 */
  0x0000,   /* U+631A */
  0x0000,   /* U+631B */
  0x0000,   /* U+631C */
  0x0000,   /* U+631D */
  0x0000,   /* U+631E */
  0x0000,   /* U+631F */
  0x0000,   /* U+6320 */
  0x0000,   /* U+6321 */
  0x0000,   /* U+6322 */
  0x0000,   /* U+6323 */
  0x0000,   /* U+6324 */
  0x0000,   /* U+6325 */
  0x0000,   /* U+6326 */
  0x0000,   /* U+6327 */
  0x0000,   /* U+6328 */
  0x0000,   /* U+6329 */
  0x0000,   /* U+632A */
  0x0000,   /* U+632B */
  0x0000,   /* U+632C */
  0x0000,   /* U+632D */
  0x0000,   /* U+632E */
  0x0000,   /* U+632F */
  0x0000,   /* U+6330 */
  0x0000,   /* U+6331 */
  0x0000,   /* U+6332 */
  0x0000,   /* U+6333 */
  0x0000,   /* U+6334 */
  0x0000,   /* U+6335 */
  0x0000,   /* U+6336 */
  0x0000,   /* U+6337 */
  0x0000,   /* U+6338 */
  0x0000,   /* U+6339 */
  0x0000,   /* U+633A */
  0x0000,   /* U+633B */
  0x0000,   /* U+633C */
  0x0000,   /* U+633D */
  0x0000,   /* U+633E */
  0x0000,   /* U+633F */
  0x0000,   /* U+6340 */
  0x0000,   /* U+6341 */
  0x0000,   /* U+6342 */
  0x0000,   /* U+6343 */
  0x0000,   /* U+6344 */
  0x0000,   /* U+6345 */
  0x0000,   /* U+6346 */
  0x0000,   /* U+6347 */
  0x0000,   /* U+6348 */
  0x0000,   /* U+6349 */
  0x0000,   /* U+634A */
  0x0000,   /* U+634B */
  0x0000,   /* U+634C */
  0x0000,   /* U+634D */
  0x0000,   /* U+634E */
  0x0000,   /* U+634F */
  0x0000,   /* U+6350 */
  0x0000,   /* U+6351 */
  0x0000,   /* U+6352 */
  0x0000,   /* U+6353 */
  0x0000,   /* U+6354 */
  0x0000,   /* U+6355 */
  0x0000,   /* U+6356 */
  0x0000,   /* U+6357 */
  0x0000,   /* U+6358 */
  0x0000,   /* U+6359 */
  0x0000,   /* U+635A */
  0x0000,   /* U+635B */
  0x0000,   /* U+635C */
  0x0000,   /* U+635D */
  0x0000,   /* U+635E */
  0x0000,   /* U+635F */
  0x0000,   /* U+6360 */
  0x0000,   /* U+6361 */
  0x0000,   /* U+6362 */
  0x0000,   /* U+6363 */
  0x0000,   /* U+6364 */
  0x0000,   /* U+6365 */
  0x0000,   /* U+6366 */
  0x0000,   /* U+6367 */
  0x0000,   /* U+6368 */
  0x0000,   /* U+6369 */
  0x0000,   /* U+636A */
  0x0000,   /* U+636B */
  0x0000,   /* U+636C */
  0x0000,   /* U+636D */
  0x0000,   /* U+636E */
  0x0000,   /* U+636F */
  0x0000,   /* U+6370 */
  0x0000,   /* U+6371 */
  0x0000,   /* U+6372 */
  0x0000,   /* U+6373 */
  0x0000,   /* U+6374 */
  0x0000,   /* U+6375 */
  0x0000,   /* U+6376 */
  0x0000,   /* U+6377 */
  0x0000,   /* U+6378 */
  0x0000,   /* U+6379 */
  0x0000,   /* U+637A */
  0x0000,   /* U+637B */
  0x0000,   /* U+637C */
  0x0000,   /* U+637D */
  0x0000,   /* U+637E */
  0x0000,   /* U+637F */
  0x0000,   /* U+6380 */
  0x0000,   /* U+6381 */
  0x0000,   /* U+6382 */
  0x0000,   /* U+6383 */
  0x0000,   /* U+6384 */
  0x0000,   /* U+6385 */
  0x0000,   /* U+6386 */
  0x0000,   /* U+6387 */
  0x0000,   /* U+6388 */
  0x0000,   /* U+6389 */
  0x0000,   /* U+638A */
  0x0000,   /* U+638B */
  0x0000,   /* U+638C */
  0x0000,   /* U+638D */
  0x0000,   /* U+638E */
  0x0000,   /* U+638F */
  0x0000,   /* U+6390 */
  0x0000,   /* U+6391 */
  0x0000,   /* U+6392 */
  0x0000,   /* U+6393 */
  0x0000,   /* U+6394 */
  0x0000,   /* U+6395 */
  0x0000,   /* U+6396 */
  0x0000,   /* U+6397 */
  0x0000,   /* U+6398 */
  0x0000,   /* U+6399 */
  0x0000,   /* U+639A */
  0x0000,   /* U+639B */
  0x0000,   /* U+639C */
  0x0000,   /* U+639D */
  0x0000,   /* U+639E */
  0x0000,   /* U+639F */
  0x0000,   /* U+63A0 */
  0x0000,   /* U+63A1 */
  0x0000,   /* U+63A2 */
  0x0000,   /* U+63A3 */
  0x0000,   /* U+63A4 */
  0x0000,   /* U+63A5 */
  0x0000,   /* U+63A6 */
  0x0000,   /* U+63A7 */
  0x0000,   /* U+63A8 */
  0x0000,   /* U+63A9 */
  0x0000,   /* U+63AA */
  0x0000,   /* U+63AB */
  0x0000,   /* U+63AC */
  0x0000,   /* U+63AD */
  0x0000,   /* U+63AE */
  0x0000,   /* U+63AF */
  0x0000,   /* U+63B0 */
  0x0000,   /* U+63B1 */
  0x0000,   /* U+63B2 */
  0x0000,   /* U+63B3 */
  0x0000,   /* U+63B4 */
  0x0000,   /* U+63B5 */
  0x0000,   /* U+63B6 */
  0x0000,   /* U+63B7 */
  0x0000,   /* U+63B8 */
  0x0000,   /* U+63B9 */
  0x0000,   /* U+63BA */
  0x0000,   /* U+63BB */
  0x0000,   /* U+63BC */
  0x0000,   /* U+63BD */
  0x0000,   /* U+63BE */
  0x0000,   /* U+63BF */
  0x0000,   /* U+63C0 */
  0x0000,   /* U+63C1 */
  0x0000,   /* U+63C2 */
  0x0000,   /* U+63C3 */
  0x0000,   /* U+63C4 */
  0x0000,   /* U+63C5 */
  0x0000,   /* U+63C6 */
  0x0000,   /* U+63C7 */
  0x0000,   /* U+63C8 */
  0x0000,   /* U+63C9 */
  0x0000,   /* U+63CA */
  0x0000,   /* U+63CB */
  0x0000,   /* U+63CC */
  0x0000,   /* U+63CD */
  0x0000,   /* U+63CE */
  0x0000,   /* U+63CF */
  0x0000,   /* U+63D0 */
  0x0000,   /* U+63D1 */
  0x0000,   /* U+63D2 */
  0x0000,   /* U+63D3 */
  0x0000,   /* U+63D4 */
  0x0000,   /* U+63D5 */
  0x0000,   /* U+63D6 */
  0x0000,   /* U+63D7 */
  0x0000,   /* U+63D8 */
  0x0000,   /* U+63D9 */
  0x0000,   /* U+63DA */
  0x0000,   /* U+63DB */
  0x0000,   /* U+63DC */
  0x0000,   /* U+63DD */
  0x0000,   /* U+63DE */
  0x0000,   /* U+63DF */
  0x0000,   /* U+63E0 */
  0x0000,   /* U+63E1 */
  0x0000,   /* U+63E2 */
  0x0000,   /* U+63E3 */
  0x0000,   /* U+63E4 */
  0x0000,   /* U+63E5 */
  0x0000,   /* U+63E6 */
  0x0000,   /* U+63E7 */
  0x0000,   /* U+63E8 */
  0x0000,   /* U+63E9 */
  0x0000,   /* U+63EA */
  0x0000,   /* U+63EB */
  0x0000,   /* U+63EC */
  0x0000,   /* U+63ED */
  0x0000,   /* U+63EE */
  0x0000,   /* U+63EF */
  0x0000,   /* U+63F0 */
  0x0000,   /* U+63F1 */
  0x0000,   /* U+63F2 */
  0x0000,   /* U+63F3 */
  0x0000,   /* U+63F4 */
  0x0000,   /* U+63F5 */
  0x0000,   /* U+63F6 */
  0x0000,   /* U+63F7 */
  0x0000,   /* U+63F8 */
  0x0000,   /* U+63F9 */
  0x0000,   /* U+63FA */
  0x0000,   /* U+63FB */
  0x0000,   /* U+63FC */
  0x0000,   /* U+63FD */
  0x0000,   /* U+63FE */
  0x0000,   /* U+63FF */
};

uint16 ja_han_page64[]= {
  /* Number of CEs for each character. */
  2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 1, 2, 1,
  2, 2, 2, 1, 2, 2, 1, 1, 2, 2, 2, 2, 1, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 1, 2, 1, 2, 2, 2, 1, 1, 2, 2,
  2, 2, 2, 2, 1, 2, 1, 2, 2, 2, 1, 2, 2, 2, 1, 2,
  2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 1, 2, 1, 2, 2, 2, 2, 2, 1,
  2, 2, 2, 2, 2, 2, 1, 2, 1, 2, 1, 2, 2, 2, 2, 2,
  2, 2, 2, 1, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 1, 1, 2, 1, 2, 2, 2, 2, 1, 2, 2, 2, 1, 2,
  2, 2, 2, 2, 1, 1, 2, 2, 2, 1, 2, 1, 2, 1, 1, 2,
  1, 2, 1, 2, 2, 2, 2, 2, 2, 1, 2, 1, 1, 2, 2, 2,
  2, 1, 1, 2, 2, 1, 2, 1, 2, 2, 2, 2, 2, 1, 2, 2,
  2, 2, 1, 2, 1, 2, 2, 2, 1, 2, 1, 2, 2, 2, 2, 2,
  1, 1, 1, 1, 2, 2, 1, 1, 2, 2, 2, 2, 1, 2, 2, 1,
  2, 1, 1, 2, 1, 2, 1, 2, 2, 2, 1, 2, 2, 1, 1, 2,

  /* Primary weight 1 for each character. */
  0xFB40,   /* U+6400 */
  0xFB40,   /* U+6401 */
  0xFB40,   /* U+6402 */
  0xFB40,   /* U+6403 */
  0xFB40,   /* U+6404 */
  0xFB40,   /* U+6405 */
  0x63D2,   /* U+6406 */
  0xFB40,   /* U+6407 */
  0xFB40,   /* U+6408 */
  0xFB40,   /* U+6409 */
  0xFB40,   /* U+640A */
  0xFB40,   /* U+640B */
  0xFB40,   /* U+640C */
  0x5B5A,   /* U+640D */
  0xFB40,   /* U+640E */
  0x63D9,   /* U+640F */
  0xFB40,   /* U+6410 */
  0xFB40,   /* U+6411 */
  0xFB40,   /* U+6412 */
  0x63D3,   /* U+6413 */
  0xFB40,   /* U+6414 */
  0xFB40,   /* U+6415 */
  0x63D0,   /* U+6416 */
  0x63D7,   /* U+6417 */
  0xFB40,   /* U+6418 */
  0xFB40,   /* U+6419 */
  0xFB40,   /* U+641A */
  0xFB40,   /* U+641B */
  0x63B9,   /* U+641C */
  0xFB40,   /* U+641D */
  0xFB40,   /* U+641E */
  0xFB40,   /* U+641F */
  0xFB40,   /* U+6420 */
  0xFB40,   /* U+6421 */
  0xFB40,   /* U+6422 */
  0xFB40,   /* U+6423 */
  0xFB40,   /* U+6424 */
  0xFB40,   /* U+6425 */
  0x63D4,   /* U+6426 */
  0xFB40,   /* U+6427 */
  0x63D8,   /* U+6428 */
  0xFB40,   /* U+6429 */
  0xFB40,   /* U+642A */
  0xFB40,   /* U+642B */
  0x5D95,   /* U+642C */
  0x5CA4,   /* U+642D */
  0xFB40,   /* U+642E */
  0xFB40,   /* U+642F */
  0xFB40,   /* U+6430 */
  0xFB40,   /* U+6431 */
  0xFB40,   /* U+6432 */
  0xFB40,   /* U+6433 */
  0x63D1,   /* U+6434 */
  0xFB40,   /* U+6435 */
  0x63D5,   /* U+6436 */
  0xFB40,   /* U+6437 */
  0xFB40,   /* U+6438 */
  0xFB40,   /* U+6439 */
  0x575D,   /* U+643A */
  0xFB40,   /* U+643B */
  0xFB40,   /* U+643C */
  0xFB40,   /* U+643D */
  0x58A0,   /* U+643E */
  0xFB40,   /* U+643F */
  0xFB40,   /* U+6440 */
  0xFB40,   /* U+6441 */
  0x5AC0,   /* U+6442 */
  0xFB40,   /* U+6443 */
  0xFB40,   /* U+6444 */
  0xFB40,   /* U+6445 */
  0xFB40,   /* U+6446 */
  0xFB40,   /* U+6447 */
  0xFB40,   /* U+6448 */
  0xFB40,   /* U+6449 */
  0xFB40,   /* U+644A */
  0xFB40,   /* U+644B */
  0xFB40,   /* U+644C */
  0xFB40,   /* U+644D */
  0x63DD,   /* U+644E */
  0xFB40,   /* U+644F */
  0xFB40,   /* U+6450 */
  0xFB40,   /* U+6451 */
  0xFB40,   /* U+6452 */
  0xFB40,   /* U+6453 */
  0xFB40,   /* U+6454 */
  0xFB40,   /* U+6455 */
  0xFB40,   /* U+6456 */
  0xFB40,   /* U+6457 */
  0x5C5F,   /* U+6458 */
  0xFB40,   /* U+6459 */
  0xFB40,   /* U+645A */
  0xFB40,   /* U+645B */
  0xFB40,   /* U+645C */
  0xFB40,   /* U+645D */
  0xFB40,   /* U+645E */
  0xFB40,   /* U+645F */
  0xFB40,   /* U+6460 */
  0xFB40,   /* U+6461 */
  0xFB40,   /* U+6462 */
  0xFB40,   /* U+6463 */
  0xFB40,   /* U+6464 */
  0xFB40,   /* U+6465 */
  0xFB40,   /* U+6466 */
  0x63DA,   /* U+6467 */
  0xFB40,   /* U+6468 */
  0x5ECD,   /* U+6469 */
  0xFB40,   /* U+646A */
  0xFB40,   /* U+646B */
  0xFB40,   /* U+646C */
  0xFB40,   /* U+646D */
  0xFB40,   /* U+646E */
  0x63DB,   /* U+646F */
  0xFB40,   /* U+6470 */
  0xFB40,   /* U+6471 */
  0xFB40,   /* U+6472 */
  0xFB40,   /* U+6473 */
  0xFB40,   /* U+6474 */
  0xFB40,   /* U+6475 */
  0x63DC,   /* U+6476 */
  0xFB40,   /* U+6477 */
  0x5F19,   /* U+6478 */
  0xFB40,   /* U+6479 */
  0x5A85,   /* U+647A */
  0xFB40,   /* U+647B */
  0xFB40,   /* U+647C */
  0xFB40,   /* U+647D */
  0xFB40,   /* U+647E */
  0xFB40,   /* U+647F */
  0xFB40,   /* U+6480 */
  0xFB40,   /* U+6481 */
  0xFB40,   /* U+6482 */
  0x5777,   /* U+6483 */
  0xFB40,   /* U+6484 */
  0xFB40,   /* U+6485 */
  0xFB40,   /* U+6486 */
  0xFB40,   /* U+6487 */
  0x63E3,   /* U+6488 */
  0xFB40,   /* U+6489 */
  0xFB40,   /* U+648A */
  0xFB40,   /* U+648B */
  0xFB40,   /* U+648C */
  0xFB40,   /* U+648D */
  0xFB40,   /* U+648E */
  0xFB40,   /* U+648F */
  0xFB40,   /* U+6490 */
  0xFB40,   /* U+6491 */
  0x58C2,   /* U+6492 */
  0x63E0,   /* U+6493 */
  0xFB40,   /* U+6494 */
  0x63DF,   /* U+6495 */
  0xFB40,   /* U+6496 */
  0xFB40,   /* U+6497 */
  0xFB40,   /* U+6498 */
  0xFB40,   /* U+6499 */
  0x5D27,   /* U+649A */
  0xFB40,   /* U+649B */
  0xFB40,   /* U+649C */
  0xFB40,   /* U+649D */
  0x5CCC,   /* U+649E */
  0xFB40,   /* U+649F */
  0xFB40,   /* U+64A0 */
  0xFB40,   /* U+64A1 */
  0xFB40,   /* U+64A2 */
  0xFB40,   /* U+64A3 */
  0x5C6A,   /* U+64A4 */
  0x63E1,   /* U+64A5 */
  0xFB40,   /* U+64A6 */
  0xFB40,   /* U+64A7 */
  0xFB40,   /* U+64A8 */
  0x63E2,   /* U+64A9 */
  0xFB40,   /* U+64AA */
  0x5E20,   /* U+64AB */
  0xFB40,   /* U+64AC */
  0x5D3A,   /* U+64AD */
  0x58B0,   /* U+64AE */
  0xFB40,   /* U+64AF */
  0x5AD4,   /* U+64B0 */
  0xFB40,   /* U+64B1 */
  0x5EBD,   /* U+64B2 */
  0xFB40,   /* U+64B3 */
  0xFB40,   /* U+64B4 */
  0xFB40,   /* U+64B5 */
  0xFB40,   /* U+64B6 */
  0xFB40,   /* U+64B7 */
  0xFB40,   /* U+64B8 */
  0x55E6,   /* U+64B9 */
  0xFB40,   /* U+64BA */
  0x63E9,   /* U+64BB */
  0x63E4,   /* U+64BC */
  0xFB40,   /* U+64BD */
  0xFB40,   /* U+64BE */
  0xFB40,   /* U+64BF */
  0xFB40,   /* U+64C0 */
  0x5F73,   /* U+64C1 */
  0x63EB,   /* U+64C2 */
  0xFB40,   /* U+64C3 */
  0xFB40,   /* U+64C4 */
  0x63E7,   /* U+64C5 */
  0xFB40,   /* U+64C6 */
  0x63E8,   /* U+64C7 */
  0xFB40,   /* U+64C8 */
  0xFB40,   /* U+64C9 */
  0xFB40,   /* U+64CA */
  0xFB40,   /* U+64CB */
  0xFB40,   /* U+64CC */
  0x5B21,   /* U+64CD */
  0xFB40,   /* U+64CE */
  0xFB40,   /* U+64CF */
  0xFB40,   /* U+64D0 */
  0xFB40,   /* U+64D1 */
  0x63E6,   /* U+64D2 */
  0xFB40,   /* U+64D3 */
  0x63A5,   /* U+64D4 */
  0xFB40,   /* U+64D5 */
  0xFB40,   /* U+64D6 */
  0xFB40,   /* U+64D7 */
  0x63EA,   /* U+64D8 */
  0xFB40,   /* U+64D9 */
  0x63E5,   /* U+64DA */
  0xFB40,   /* U+64DB */
  0xFB40,   /* U+64DC */
  0xFB40,   /* U+64DD */
  0xFB40,   /* U+64DE */
  0xFB40,   /* U+64DF */
  0x63EF,   /* U+64E0 */
  0x63F0,   /* U+64E1 */
  0x5C60,   /* U+64E2 */
  0x63F2,   /* U+64E3 */
  0xFB40,   /* U+64E4 */
  0xFB40,   /* U+64E5 */
  0x58B1,   /* U+64E6 */
  0x63ED,   /* U+64E7 */
  0xFB40,   /* U+64E8 */
  0xFB40,   /* U+64E9 */
  0xFB40,   /* U+64EA */
  0xFB40,   /* U+64EB */
  0x5695,   /* U+64EC */
  0xFB40,   /* U+64ED */
  0xFB40,   /* U+64EE */
  0x63F3,   /* U+64EF */
  0xFB40,   /* U+64F0 */
  0x63EC,   /* U+64F1 */
  0x63F7,   /* U+64F2 */
  0xFB40,   /* U+64F3 */
  0x63F6,   /* U+64F4 */
  0xFB40,   /* U+64F5 */
  0x63F5,   /* U+64F6 */
  0xFB40,   /* U+64F7 */
  0xFB40,   /* U+64F8 */
  0xFB40,   /* U+64F9 */
  0x63F8,   /* U+64FA */
  0xFB40,   /* U+64FB */
  0xFB40,   /* U+64FC */
  0x63FA,   /* U+64FD */
  0x5A18,   /* U+64FE */
  0xFB40,   /* U+64FF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+6400 */
  0x0020,   /* U+6401 */
  0x0020,   /* U+6402 */
  0x0020,   /* U+6403 */
  0x0020,   /* U+6404 */
  0x0020,   /* U+6405 */
  0x0020,   /* U+6406 */
  0x0020,   /* U+6407 */
  0x0020,   /* U+6408 */
  0x0020,   /* U+6409 */
  0x0020,   /* U+640A */
  0x0020,   /* U+640B */
  0x0020,   /* U+640C */
  0x0020,   /* U+640D */
  0x0020,   /* U+640E */
  0x0020,   /* U+640F */
  0x0020,   /* U+6410 */
  0x0020,   /* U+6411 */
  0x0020,   /* U+6412 */
  0x0020,   /* U+6413 */
  0x0020,   /* U+6414 */
  0x0020,   /* U+6415 */
  0x0020,   /* U+6416 */
  0x0020,   /* U+6417 */
  0x0020,   /* U+6418 */
  0x0020,   /* U+6419 */
  0x0020,   /* U+641A */
  0x0020,   /* U+641B */
  0x0020,   /* U+641C */
  0x0020,   /* U+641D */
  0x0020,   /* U+641E */
  0x0020,   /* U+641F */
  0x0020,   /* U+6420 */
  0x0020,   /* U+6421 */
  0x0020,   /* U+6422 */
  0x0020,   /* U+6423 */
  0x0020,   /* U+6424 */
  0x0020,   /* U+6425 */
  0x0020,   /* U+6426 */
  0x0020,   /* U+6427 */
  0x0020,   /* U+6428 */
  0x0020,   /* U+6429 */
  0x0020,   /* U+642A */
  0x0020,   /* U+642B */
  0x0020,   /* U+642C */
  0x0020,   /* U+642D */
  0x0020,   /* U+642E */
  0x0020,   /* U+642F */
  0x0020,   /* U+6430 */
  0x0020,   /* U+6431 */
  0x0020,   /* U+6432 */
  0x0020,   /* U+6433 */
  0x0020,   /* U+6434 */
  0x0020,   /* U+6435 */
  0x0020,   /* U+6436 */
  0x0020,   /* U+6437 */
  0x0020,   /* U+6438 */
  0x0020,   /* U+6439 */
  0x0020,   /* U+643A */
  0x0020,   /* U+643B */
  0x0020,   /* U+643C */
  0x0020,   /* U+643D */
  0x0020,   /* U+643E */
  0x0020,   /* U+643F */
  0x0020,   /* U+6440 */
  0x0020,   /* U+6441 */
  0x0020,   /* U+6442 */
  0x0020,   /* U+6443 */
  0x0020,   /* U+6444 */
  0x0020,   /* U+6445 */
  0x0020,   /* U+6446 */
  0x0020,   /* U+6447 */
  0x0020,   /* U+6448 */
  0x0020,   /* U+6449 */
  0x0020,   /* U+644A */
  0x0020,   /* U+644B */
  0x0020,   /* U+644C */
  0x0020,   /* U+644D */
  0x0020,   /* U+644E */
  0x0020,   /* U+644F */
  0x0020,   /* U+6450 */
  0x0020,   /* U+6451 */
  0x0020,   /* U+6452 */
  0x0020,   /* U+6453 */
  0x0020,   /* U+6454 */
  0x0020,   /* U+6455 */
  0x0020,   /* U+6456 */
  0x0020,   /* U+6457 */
  0x0020,   /* U+6458 */
  0x0020,   /* U+6459 */
  0x0020,   /* U+645A */
  0x0020,   /* U+645B */
  0x0020,   /* U+645C */
  0x0020,   /* U+645D */
  0x0020,   /* U+645E */
  0x0020,   /* U+645F */
  0x0020,   /* U+6460 */
  0x0020,   /* U+6461 */
  0x0020,   /* U+6462 */
  0x0020,   /* U+6463 */
  0x0020,   /* U+6464 */
  0x0020,   /* U+6465 */
  0x0020,   /* U+6466 */
  0x0020,   /* U+6467 */
  0x0020,   /* U+6468 */
  0x0020,   /* U+6469 */
  0x0020,   /* U+646A */
  0x0020,   /* U+646B */
  0x0020,   /* U+646C */
  0x0020,   /* U+646D */
  0x0020,   /* U+646E */
  0x0020,   /* U+646F */
  0x0020,   /* U+6470 */
  0x0020,   /* U+6471 */
  0x0020,   /* U+6472 */
  0x0020,   /* U+6473 */
  0x0020,   /* U+6474 */
  0x0020,   /* U+6475 */
  0x0020,   /* U+6476 */
  0x0020,   /* U+6477 */
  0x0020,   /* U+6478 */
  0x0020,   /* U+6479 */
  0x0020,   /* U+647A */
  0x0020,   /* U+647B */
  0x0020,   /* U+647C */
  0x0020,   /* U+647D */
  0x0020,   /* U+647E */
  0x0020,   /* U+647F */
  0x0020,   /* U+6480 */
  0x0020,   /* U+6481 */
  0x0020,   /* U+6482 */
  0x0020,   /* U+6483 */
  0x0020,   /* U+6484 */
  0x0020,   /* U+6485 */
  0x0020,   /* U+6486 */
  0x0020,   /* U+6487 */
  0x0020,   /* U+6488 */
  0x0020,   /* U+6489 */
  0x0020,   /* U+648A */
  0x0020,   /* U+648B */
  0x0020,   /* U+648C */
  0x0020,   /* U+648D */
  0x0020,   /* U+648E */
  0x0020,   /* U+648F */
  0x0020,   /* U+6490 */
  0x0020,   /* U+6491 */
  0x0020,   /* U+6492 */
  0x0020,   /* U+6493 */
  0x0020,   /* U+6494 */
  0x0020,   /* U+6495 */
  0x0020,   /* U+6496 */
  0x0020,   /* U+6497 */
  0x0020,   /* U+6498 */
  0x0020,   /* U+6499 */
  0x0020,   /* U+649A */
  0x0020,   /* U+649B */
  0x0020,   /* U+649C */
  0x0020,   /* U+649D */
  0x0020,   /* U+649E */
  0x0020,   /* U+649F */
  0x0020,   /* U+64A0 */
  0x0020,   /* U+64A1 */
  0x0020,   /* U+64A2 */
  0x0020,   /* U+64A3 */
  0x0020,   /* U+64A4 */
  0x0020,   /* U+64A5 */
  0x0020,   /* U+64A6 */
  0x0020,   /* U+64A7 */
  0x0020,   /* U+64A8 */
  0x0020,   /* U+64A9 */
  0x0020,   /* U+64AA */
  0x0020,   /* U+64AB */
  0x0020,   /* U+64AC */
  0x0020,   /* U+64AD */
  0x0020,   /* U+64AE */
  0x0020,   /* U+64AF */
  0x0020,   /* U+64B0 */
  0x0020,   /* U+64B1 */
  0x0020,   /* U+64B2 */
  0x0020,   /* U+64B3 */
  0x0020,   /* U+64B4 */
  0x0020,   /* U+64B5 */
  0x0020,   /* U+64B6 */
  0x0020,   /* U+64B7 */
  0x0020,   /* U+64B8 */
  0x0020,   /* U+64B9 */
  0x0020,   /* U+64BA */
  0x0020,   /* U+64BB */
  0x0020,   /* U+64BC */
  0x0020,   /* U+64BD */
  0x0020,   /* U+64BE */
  0x0020,   /* U+64BF */
  0x0020,   /* U+64C0 */
  0x0020,   /* U+64C1 */
  0x0020,   /* U+64C2 */
  0x0020,   /* U+64C3 */
  0x0020,   /* U+64C4 */
  0x0020,   /* U+64C5 */
  0x0020,   /* U+64C6 */
  0x0020,   /* U+64C7 */
  0x0020,   /* U+64C8 */
  0x0020,   /* U+64C9 */
  0x0020,   /* U+64CA */
  0x0020,   /* U+64CB */
  0x0020,   /* U+64CC */
  0x0020,   /* U+64CD */
  0x0020,   /* U+64CE */
  0x0020,   /* U+64CF */
  0x0020,   /* U+64D0 */
  0x0020,   /* U+64D1 */
  0x0020,   /* U+64D2 */
  0x0020,   /* U+64D3 */
  0x0020,   /* U+64D4 */
  0x0020,   /* U+64D5 */
  0x0020,   /* U+64D6 */
  0x0020,   /* U+64D7 */
  0x0020,   /* U+64D8 */
  0x0020,   /* U+64D9 */
  0x0020,   /* U+64DA */
  0x0020,   /* U+64DB */
  0x0020,   /* U+64DC */
  0x0020,   /* U+64DD */
  0x0020,   /* U+64DE */
  0x0020,   /* U+64DF */
  0x0020,   /* U+64E0 */
  0x0020,   /* U+64E1 */
  0x0020,   /* U+64E2 */
  0x0020,   /* U+64E3 */
  0x0020,   /* U+64E4 */
  0x0020,   /* U+64E5 */
  0x0020,   /* U+64E6 */
  0x0020,   /* U+64E7 */
  0x0020,   /* U+64E8 */
  0x0020,   /* U+64E9 */
  0x0020,   /* U+64EA */
  0x0020,   /* U+64EB */
  0x0020,   /* U+64EC */
  0x0020,   /* U+64ED */
  0x0020,   /* U+64EE */
  0x0020,   /* U+64EF */
  0x0020,   /* U+64F0 */
  0x0020,   /* U+64F1 */
  0x0020,   /* U+64F2 */
  0x0020,   /* U+64F3 */
  0x0020,   /* U+64F4 */
  0x0020,   /* U+64F5 */
  0x0020,   /* U+64F6 */
  0x0020,   /* U+64F7 */
  0x0020,   /* U+64F8 */
  0x0020,   /* U+64F9 */
  0x0020,   /* U+64FA */
  0x0020,   /* U+64FB */
  0x0020,   /* U+64FC */
  0x0020,   /* U+64FD */
  0x0020,   /* U+64FE */
  0x0020,   /* U+64FF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+6400 */
  0x0002,   /* U+6401 */
  0x0002,   /* U+6402 */
  0x0002,   /* U+6403 */
  0x0002,   /* U+6404 */
  0x0002,   /* U+6405 */
  0x0002,   /* U+6406 */
  0x0002,   /* U+6407 */
  0x0002,   /* U+6408 */
  0x0002,   /* U+6409 */
  0x0002,   /* U+640A */
  0x0002,   /* U+640B */
  0x0002,   /* U+640C */
  0x0002,   /* U+640D */
  0x0002,   /* U+640E */
  0x0002,   /* U+640F */
  0x0002,   /* U+6410 */
  0x0002,   /* U+6411 */
  0x0002,   /* U+6412 */
  0x0002,   /* U+6413 */
  0x0002,   /* U+6414 */
  0x0002,   /* U+6415 */
  0x0002,   /* U+6416 */
  0x0002,   /* U+6417 */
  0x0002,   /* U+6418 */
  0x0002,   /* U+6419 */
  0x0002,   /* U+641A */
  0x0002,   /* U+641B */
  0x0002,   /* U+641C */
  0x0002,   /* U+641D */
  0x0002,   /* U+641E */
  0x0002,   /* U+641F */
  0x0002,   /* U+6420 */
  0x0002,   /* U+6421 */
  0x0002,   /* U+6422 */
  0x0002,   /* U+6423 */
  0x0002,   /* U+6424 */
  0x0002,   /* U+6425 */
  0x0002,   /* U+6426 */
  0x0002,   /* U+6427 */
  0x0002,   /* U+6428 */
  0x0002,   /* U+6429 */
  0x0002,   /* U+642A */
  0x0002,   /* U+642B */
  0x0002,   /* U+642C */
  0x0002,   /* U+642D */
  0x0002,   /* U+642E */
  0x0002,   /* U+642F */
  0x0002,   /* U+6430 */
  0x0002,   /* U+6431 */
  0x0002,   /* U+6432 */
  0x0002,   /* U+6433 */
  0x0002,   /* U+6434 */
  0x0002,   /* U+6435 */
  0x0002,   /* U+6436 */
  0x0002,   /* U+6437 */
  0x0002,   /* U+6438 */
  0x0002,   /* U+6439 */
  0x0002,   /* U+643A */
  0x0002,   /* U+643B */
  0x0002,   /* U+643C */
  0x0002,   /* U+643D */
  0x0002,   /* U+643E */
  0x0002,   /* U+643F */
  0x0002,   /* U+6440 */
  0x0002,   /* U+6441 */
  0x0002,   /* U+6442 */
  0x0002,   /* U+6443 */
  0x0002,   /* U+6444 */
  0x0002,   /* U+6445 */
  0x0002,   /* U+6446 */
  0x0002,   /* U+6447 */
  0x0002,   /* U+6448 */
  0x0002,   /* U+6449 */
  0x0002,   /* U+644A */
  0x0002,   /* U+644B */
  0x0002,   /* U+644C */
  0x0002,   /* U+644D */
  0x0002,   /* U+644E */
  0x0002,   /* U+644F */
  0x0002,   /* U+6450 */
  0x0002,   /* U+6451 */
  0x0002,   /* U+6452 */
  0x0002,   /* U+6453 */
  0x0002,   /* U+6454 */
  0x0002,   /* U+6455 */
  0x0002,   /* U+6456 */
  0x0002,   /* U+6457 */
  0x0002,   /* U+6458 */
  0x0002,   /* U+6459 */
  0x0002,   /* U+645A */
  0x0002,   /* U+645B */
  0x0002,   /* U+645C */
  0x0002,   /* U+645D */
  0x0002,   /* U+645E */
  0x0002,   /* U+645F */
  0x0002,   /* U+6460 */
  0x0002,   /* U+6461 */
  0x0002,   /* U+6462 */
  0x0002,   /* U+6463 */
  0x0002,   /* U+6464 */
  0x0002,   /* U+6465 */
  0x0002,   /* U+6466 */
  0x0002,   /* U+6467 */
  0x0002,   /* U+6468 */
  0x0002,   /* U+6469 */
  0x0002,   /* U+646A */
  0x0002,   /* U+646B */
  0x0002,   /* U+646C */
  0x0002,   /* U+646D */
  0x0002,   /* U+646E */
  0x0002,   /* U+646F */
  0x0002,   /* U+6470 */
  0x0002,   /* U+6471 */
  0x0002,   /* U+6472 */
  0x0002,   /* U+6473 */
  0x0002,   /* U+6474 */
  0x0002,   /* U+6475 */
  0x0002,   /* U+6476 */
  0x0002,   /* U+6477 */
  0x0002,   /* U+6478 */
  0x0002,   /* U+6479 */
  0x0002,   /* U+647A */
  0x0002,   /* U+647B */
  0x0002,   /* U+647C */
  0x0002,   /* U+647D */
  0x0002,   /* U+647E */
  0x0002,   /* U+647F */
  0x0002,   /* U+6480 */
  0x0002,   /* U+6481 */
  0x0002,   /* U+6482 */
  0x0002,   /* U+6483 */
  0x0002,   /* U+6484 */
  0x0002,   /* U+6485 */
  0x0002,   /* U+6486 */
  0x0002,   /* U+6487 */
  0x0002,   /* U+6488 */
  0x0002,   /* U+6489 */
  0x0002,   /* U+648A */
  0x0002,   /* U+648B */
  0x0002,   /* U+648C */
  0x0002,   /* U+648D */
  0x0002,   /* U+648E */
  0x0002,   /* U+648F */
  0x0002,   /* U+6490 */
  0x0002,   /* U+6491 */
  0x0002,   /* U+6492 */
  0x0002,   /* U+6493 */
  0x0002,   /* U+6494 */
  0x0002,   /* U+6495 */
  0x0002,   /* U+6496 */
  0x0002,   /* U+6497 */
  0x0002,   /* U+6498 */
  0x0002,   /* U+6499 */
  0x0002,   /* U+649A */
  0x0002,   /* U+649B */
  0x0002,   /* U+649C */
  0x0002,   /* U+649D */
  0x0002,   /* U+649E */
  0x0002,   /* U+649F */
  0x0002,   /* U+64A0 */
  0x0002,   /* U+64A1 */
  0x0002,   /* U+64A2 */
  0x0002,   /* U+64A3 */
  0x0002,   /* U+64A4 */
  0x0002,   /* U+64A5 */
  0x0002,   /* U+64A6 */
  0x0002,   /* U+64A7 */
  0x0002,   /* U+64A8 */
  0x0002,   /* U+64A9 */
  0x0002,   /* U+64AA */
  0x0002,   /* U+64AB */
  0x0002,   /* U+64AC */
  0x0002,   /* U+64AD */
  0x0002,   /* U+64AE */
  0x0002,   /* U+64AF */
  0x0002,   /* U+64B0 */
  0x0002,   /* U+64B1 */
  0x0002,   /* U+64B2 */
  0x0002,   /* U+64B3 */
  0x0002,   /* U+64B4 */
  0x0002,   /* U+64B5 */
  0x0002,   /* U+64B6 */
  0x0002,   /* U+64B7 */
  0x0002,   /* U+64B8 */
  0x0002,   /* U+64B9 */
  0x0002,   /* U+64BA */
  0x0002,   /* U+64BB */
  0x0002,   /* U+64BC */
  0x0002,   /* U+64BD */
  0x0002,   /* U+64BE */
  0x0002,   /* U+64BF */
  0x0002,   /* U+64C0 */
  0x0002,   /* U+64C1 */
  0x0002,   /* U+64C2 */
  0x0002,   /* U+64C3 */
  0x0002,   /* U+64C4 */
  0x0002,   /* U+64C5 */
  0x0002,   /* U+64C6 */
  0x0002,   /* U+64C7 */
  0x0002,   /* U+64C8 */
  0x0002,   /* U+64C9 */
  0x0002,   /* U+64CA */
  0x0002,   /* U+64CB */
  0x0002,   /* U+64CC */
  0x0002,   /* U+64CD */
  0x0002,   /* U+64CE */
  0x0002,   /* U+64CF */
  0x0002,   /* U+64D0 */
  0x0002,   /* U+64D1 */
  0x0002,   /* U+64D2 */
  0x0002,   /* U+64D3 */
  0x0002,   /* U+64D4 */
  0x0002,   /* U+64D5 */
  0x0002,   /* U+64D6 */
  0x0002,   /* U+64D7 */
  0x0002,   /* U+64D8 */
  0x0002,   /* U+64D9 */
  0x0002,   /* U+64DA */
  0x0002,   /* U+64DB */
  0x0002,   /* U+64DC */
  0x0002,   /* U+64DD */
  0x0002,   /* U+64DE */
  0x0002,   /* U+64DF */
  0x0002,   /* U+64E0 */
  0x0002,   /* U+64E1 */
  0x0002,   /* U+64E2 */
  0x0002,   /* U+64E3 */
  0x0002,   /* U+64E4 */
  0x0002,   /* U+64E5 */
  0x0002,   /* U+64E6 */
  0x0002,   /* U+64E7 */
  0x0002,   /* U+64E8 */
  0x0002,   /* U+64E9 */
  0x0002,   /* U+64EA */
  0x0002,   /* U+64EB */
  0x0002,   /* U+64EC */
  0x0002,   /* U+64ED */
  0x0002,   /* U+64EE */
  0x0002,   /* U+64EF */
  0x0002,   /* U+64F0 */
  0x0002,   /* U+64F1 */
  0x0002,   /* U+64F2 */
  0x0002,   /* U+64F3 */
  0x0002,   /* U+64F4 */
  0x0002,   /* U+64F5 */
  0x0002,   /* U+64F6 */
  0x0002,   /* U+64F7 */
  0x0002,   /* U+64F8 */
  0x0002,   /* U+64F9 */
  0x0002,   /* U+64FA */
  0x0002,   /* U+64FB */
  0x0002,   /* U+64FC */
  0x0002,   /* U+64FD */
  0x0002,   /* U+64FE */
  0x0002,   /* U+64FF */

  /* Primary weight 2 for each character. */
  0xE400,   /* U+6400 */
  0xE401,   /* U+6401 */
  0xE402,   /* U+6402 */
  0xE403,   /* U+6403 */
  0xE404,   /* U+6404 */
  0xE405,   /* U+6405 */
  0x0000,   /* U+6406 */
  0xE407,   /* U+6407 */
  0xE408,   /* U+6408 */
  0xE409,   /* U+6409 */
  0xE40A,   /* U+640A */
  0xE40B,   /* U+640B */
  0xE40C,   /* U+640C */
  0x0000,   /* U+640D */
  0xE40E,   /* U+640E */
  0x0000,   /* U+640F */
  0xE410,   /* U+6410 */
  0xE411,   /* U+6411 */
  0xE412,   /* U+6412 */
  0x0000,   /* U+6413 */
  0xE414,   /* U+6414 */
  0xE415,   /* U+6415 */
  0x0000,   /* U+6416 */
  0x0000,   /* U+6417 */
  0xE418,   /* U+6418 */
  0xE419,   /* U+6419 */
  0xE41A,   /* U+641A */
  0xE41B,   /* U+641B */
  0x0000,   /* U+641C */
  0xE41D,   /* U+641D */
  0xE41E,   /* U+641E */
  0xE41F,   /* U+641F */
  0xE420,   /* U+6420 */
  0xE421,   /* U+6421 */
  0xE422,   /* U+6422 */
  0xE423,   /* U+6423 */
  0xE424,   /* U+6424 */
  0xE425,   /* U+6425 */
  0x0000,   /* U+6426 */
  0xE427,   /* U+6427 */
  0x0000,   /* U+6428 */
  0xE429,   /* U+6429 */
  0xE42A,   /* U+642A */
  0xE42B,   /* U+642B */
  0x0000,   /* U+642C */
  0x0000,   /* U+642D */
  0xE42E,   /* U+642E */
  0xE42F,   /* U+642F */
  0xE430,   /* U+6430 */
  0xE431,   /* U+6431 */
  0xE432,   /* U+6432 */
  0xE433,   /* U+6433 */
  0x0000,   /* U+6434 */
  0xE435,   /* U+6435 */
  0x0000,   /* U+6436 */
  0xE437,   /* U+6437 */
  0xE438,   /* U+6438 */
  0xE439,   /* U+6439 */
  0x0000,   /* U+643A */
  0xE43B,   /* U+643B */
  0xE43C,   /* U+643C */
  0xE43D,   /* U+643D */
  0x0000,   /* U+643E */
  0xE43F,   /* U+643F */
  0xE440,   /* U+6440 */
  0xE441,   /* U+6441 */
  0x0000,   /* U+6442 */
  0xE443,   /* U+6443 */
  0xE444,   /* U+6444 */
  0xE445,   /* U+6445 */
  0xE446,   /* U+6446 */
  0xE447,   /* U+6447 */
  0xE448,   /* U+6448 */
  0xE449,   /* U+6449 */
  0xE44A,   /* U+644A */
  0xE44B,   /* U+644B */
  0xE44C,   /* U+644C */
  0xE44D,   /* U+644D */
  0x0000,   /* U+644E */
  0xE44F,   /* U+644F */
  0xE450,   /* U+6450 */
  0xE451,   /* U+6451 */
  0xE452,   /* U+6452 */
  0xE453,   /* U+6453 */
  0xE454,   /* U+6454 */
  0xE455,   /* U+6455 */
  0xE456,   /* U+6456 */
  0xE457,   /* U+6457 */
  0x0000,   /* U+6458 */
  0xE459,   /* U+6459 */
  0xE45A,   /* U+645A */
  0xE45B,   /* U+645B */
  0xE45C,   /* U+645C */
  0xE45D,   /* U+645D */
  0xE45E,   /* U+645E */
  0xE45F,   /* U+645F */
  0xE460,   /* U+6460 */
  0xE461,   /* U+6461 */
  0xE462,   /* U+6462 */
  0xE463,   /* U+6463 */
  0xE464,   /* U+6464 */
  0xE465,   /* U+6465 */
  0xE466,   /* U+6466 */
  0x0000,   /* U+6467 */
  0xE468,   /* U+6468 */
  0x0000,   /* U+6469 */
  0xE46A,   /* U+646A */
  0xE46B,   /* U+646B */
  0xE46C,   /* U+646C */
  0xE46D,   /* U+646D */
  0xE46E,   /* U+646E */
  0x0000,   /* U+646F */
  0xE470,   /* U+6470 */
  0xE471,   /* U+6471 */
  0xE472,   /* U+6472 */
  0xE473,   /* U+6473 */
  0xE474,   /* U+6474 */
  0xE475,   /* U+6475 */
  0x0000,   /* U+6476 */
  0xE477,   /* U+6477 */
  0x0000,   /* U+6478 */
  0xE479,   /* U+6479 */
  0x0000,   /* U+647A */
  0xE47B,   /* U+647B */
  0xE47C,   /* U+647C */
  0xE47D,   /* U+647D */
  0xE47E,   /* U+647E */
  0xE47F,   /* U+647F */
  0xE480,   /* U+6480 */
  0xE481,   /* U+6481 */
  0xE482,   /* U+6482 */
  0x0000,   /* U+6483 */
  0xE484,   /* U+6484 */
  0xE485,   /* U+6485 */
  0xE486,   /* U+6486 */
  0xE487,   /* U+6487 */
  0x0000,   /* U+6488 */
  0xE489,   /* U+6489 */
  0xE48A,   /* U+648A */
  0xE48B,   /* U+648B */
  0xE48C,   /* U+648C */
  0xE48D,   /* U+648D */
  0xE48E,   /* U+648E */
  0xE48F,   /* U+648F */
  0xE490,   /* U+6490 */
  0xE491,   /* U+6491 */
  0x0000,   /* U+6492 */
  0x0000,   /* U+6493 */
  0xE494,   /* U+6494 */
  0x0000,   /* U+6495 */
  0xE496,   /* U+6496 */
  0xE497,   /* U+6497 */
  0xE498,   /* U+6498 */
  0xE499,   /* U+6499 */
  0x0000,   /* U+649A */
  0xE49B,   /* U+649B */
  0xE49C,   /* U+649C */
  0xE49D,   /* U+649D */
  0x0000,   /* U+649E */
  0xE49F,   /* U+649F */
  0xE4A0,   /* U+64A0 */
  0xE4A1,   /* U+64A1 */
  0xE4A2,   /* U+64A2 */
  0xE4A3,   /* U+64A3 */
  0x0000,   /* U+64A4 */
  0x0000,   /* U+64A5 */
  0xE4A6,   /* U+64A6 */
  0xE4A7,   /* U+64A7 */
  0xE4A8,   /* U+64A8 */
  0x0000,   /* U+64A9 */
  0xE4AA,   /* U+64AA */
  0x0000,   /* U+64AB */
  0xE4AC,   /* U+64AC */
  0x0000,   /* U+64AD */
  0x0000,   /* U+64AE */
  0xE4AF,   /* U+64AF */
  0x0000,   /* U+64B0 */
  0xE4B1,   /* U+64B1 */
  0x0000,   /* U+64B2 */
  0xE4B3,   /* U+64B3 */
  0xE4B4,   /* U+64B4 */
  0xE4B5,   /* U+64B5 */
  0xE4B6,   /* U+64B6 */
  0xE4B7,   /* U+64B7 */
  0xE4B8,   /* U+64B8 */
  0x0000,   /* U+64B9 */
  0xE4BA,   /* U+64BA */
  0x0000,   /* U+64BB */
  0x0000,   /* U+64BC */
  0xE4BD,   /* U+64BD */
  0xE4BE,   /* U+64BE */
  0xE4BF,   /* U+64BF */
  0xE4C0,   /* U+64C0 */
  0x0000,   /* U+64C1 */
  0x0000,   /* U+64C2 */
  0xE4C3,   /* U+64C3 */
  0xE4C4,   /* U+64C4 */
  0x0000,   /* U+64C5 */
  0xE4C6,   /* U+64C6 */
  0x0000,   /* U+64C7 */
  0xE4C8,   /* U+64C8 */
  0xE4C9,   /* U+64C9 */
  0xE4CA,   /* U+64CA */
  0xE4CB,   /* U+64CB */
  0xE4CC,   /* U+64CC */
  0x0000,   /* U+64CD */
  0xE4CE,   /* U+64CE */
  0xE4CF,   /* U+64CF */
  0xE4D0,   /* U+64D0 */
  0xE4D1,   /* U+64D1 */
  0x0000,   /* U+64D2 */
  0xE4D3,   /* U+64D3 */
  0x0000,   /* U+64D4 */
  0xE4D5,   /* U+64D5 */
  0xE4D6,   /* U+64D6 */
  0xE4D7,   /* U+64D7 */
  0x0000,   /* U+64D8 */
  0xE4D9,   /* U+64D9 */
  0x0000,   /* U+64DA */
  0xE4DB,   /* U+64DB */
  0xE4DC,   /* U+64DC */
  0xE4DD,   /* U+64DD */
  0xE4DE,   /* U+64DE */
  0xE4DF,   /* U+64DF */
  0x0000,   /* U+64E0 */
  0x0000,   /* U+64E1 */
  0x0000,   /* U+64E2 */
  0x0000,   /* U+64E3 */
  0xE4E4,   /* U+64E4 */
  0xE4E5,   /* U+64E5 */
  0x0000,   /* U+64E6 */
  0x0000,   /* U+64E7 */
  0xE4E8,   /* U+64E8 */
  0xE4E9,   /* U+64E9 */
  0xE4EA,   /* U+64EA */
  0xE4EB,   /* U+64EB */
  0x0000,   /* U+64EC */
  0xE4ED,   /* U+64ED */
  0xE4EE,   /* U+64EE */
  0x0000,   /* U+64EF */
  0xE4F0,   /* U+64F0 */
  0x0000,   /* U+64F1 */
  0x0000,   /* U+64F2 */
  0xE4F3,   /* U+64F3 */
  0x0000,   /* U+64F4 */
  0xE4F5,   /* U+64F5 */
  0x0000,   /* U+64F6 */
  0xE4F7,   /* U+64F7 */
  0xE4F8,   /* U+64F8 */
  0xE4F9,   /* U+64F9 */
  0x0000,   /* U+64FA */
  0xE4FB,   /* U+64FB */
  0xE4FC,   /* U+64FC */
  0x0000,   /* U+64FD */
  0x0000,   /* U+64FE */
  0xE4FF,   /* U+64FF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+6400 */
  0x0000,   /* U+6401 */
  0x0000,   /* U+6402 */
  0x0000,   /* U+6403 */
  0x0000,   /* U+6404 */
  0x0000,   /* U+6405 */
  0x0000,   /* U+6406 */
  0x0000,   /* U+6407 */
  0x0000,   /* U+6408 */
  0x0000,   /* U+6409 */
  0x0000,   /* U+640A */
  0x0000,   /* U+640B */
  0x0000,   /* U+640C */
  0x0000,   /* U+640D */
  0x0000,   /* U+640E */
  0x0000,   /* U+640F */
  0x0000,   /* U+6410 */
  0x0000,   /* U+6411 */
  0x0000,   /* U+6412 */
  0x0000,   /* U+6413 */
  0x0000,   /* U+6414 */
  0x0000,   /* U+6415 */
  0x0000,   /* U+6416 */
  0x0000,   /* U+6417 */
  0x0000,   /* U+6418 */
  0x0000,   /* U+6419 */
  0x0000,   /* U+641A */
  0x0000,   /* U+641B */
  0x0000,   /* U+641C */
  0x0000,   /* U+641D */
  0x0000,   /* U+641E */
  0x0000,   /* U+641F */
  0x0000,   /* U+6420 */
  0x0000,   /* U+6421 */
  0x0000,   /* U+6422 */
  0x0000,   /* U+6423 */
  0x0000,   /* U+6424 */
  0x0000,   /* U+6425 */
  0x0000,   /* U+6426 */
  0x0000,   /* U+6427 */
  0x0000,   /* U+6428 */
  0x0000,   /* U+6429 */
  0x0000,   /* U+642A */
  0x0000,   /* U+642B */
  0x0000,   /* U+642C */
  0x0000,   /* U+642D */
  0x0000,   /* U+642E */
  0x0000,   /* U+642F */
  0x0000,   /* U+6430 */
  0x0000,   /* U+6431 */
  0x0000,   /* U+6432 */
  0x0000,   /* U+6433 */
  0x0000,   /* U+6434 */
  0x0000,   /* U+6435 */
  0x0000,   /* U+6436 */
  0x0000,   /* U+6437 */
  0x0000,   /* U+6438 */
  0x0000,   /* U+6439 */
  0x0000,   /* U+643A */
  0x0000,   /* U+643B */
  0x0000,   /* U+643C */
  0x0000,   /* U+643D */
  0x0000,   /* U+643E */
  0x0000,   /* U+643F */
  0x0000,   /* U+6440 */
  0x0000,   /* U+6441 */
  0x0000,   /* U+6442 */
  0x0000,   /* U+6443 */
  0x0000,   /* U+6444 */
  0x0000,   /* U+6445 */
  0x0000,   /* U+6446 */
  0x0000,   /* U+6447 */
  0x0000,   /* U+6448 */
  0x0000,   /* U+6449 */
  0x0000,   /* U+644A */
  0x0000,   /* U+644B */
  0x0000,   /* U+644C */
  0x0000,   /* U+644D */
  0x0000,   /* U+644E */
  0x0000,   /* U+644F */
  0x0000,   /* U+6450 */
  0x0000,   /* U+6451 */
  0x0000,   /* U+6452 */
  0x0000,   /* U+6453 */
  0x0000,   /* U+6454 */
  0x0000,   /* U+6455 */
  0x0000,   /* U+6456 */
  0x0000,   /* U+6457 */
  0x0000,   /* U+6458 */
  0x0000,   /* U+6459 */
  0x0000,   /* U+645A */
  0x0000,   /* U+645B */
  0x0000,   /* U+645C */
  0x0000,   /* U+645D */
  0x0000,   /* U+645E */
  0x0000,   /* U+645F */
  0x0000,   /* U+6460 */
  0x0000,   /* U+6461 */
  0x0000,   /* U+6462 */
  0x0000,   /* U+6463 */
  0x0000,   /* U+6464 */
  0x0000,   /* U+6465 */
  0x0000,   /* U+6466 */
  0x0000,   /* U+6467 */
  0x0000,   /* U+6468 */
  0x0000,   /* U+6469 */
  0x0000,   /* U+646A */
  0x0000,   /* U+646B */
  0x0000,   /* U+646C */
  0x0000,   /* U+646D */
  0x0000,   /* U+646E */
  0x0000,   /* U+646F */
  0x0000,   /* U+6470 */
  0x0000,   /* U+6471 */
  0x0000,   /* U+6472 */
  0x0000,   /* U+6473 */
  0x0000,   /* U+6474 */
  0x0000,   /* U+6475 */
  0x0000,   /* U+6476 */
  0x0000,   /* U+6477 */
  0x0000,   /* U+6478 */
  0x0000,   /* U+6479 */
  0x0000,   /* U+647A */
  0x0000,   /* U+647B */
  0x0000,   /* U+647C */
  0x0000,   /* U+647D */
  0x0000,   /* U+647E */
  0x0000,   /* U+647F */
  0x0000,   /* U+6480 */
  0x0000,   /* U+6481 */
  0x0000,   /* U+6482 */
  0x0000,   /* U+6483 */
  0x0000,   /* U+6484 */
  0x0000,   /* U+6485 */
  0x0000,   /* U+6486 */
  0x0000,   /* U+6487 */
  0x0000,   /* U+6488 */
  0x0000,   /* U+6489 */
  0x0000,   /* U+648A */
  0x0000,   /* U+648B */
  0x0000,   /* U+648C */
  0x0000,   /* U+648D */
  0x0000,   /* U+648E */
  0x0000,   /* U+648F */
  0x0000,   /* U+6490 */
  0x0000,   /* U+6491 */
  0x0000,   /* U+6492 */
  0x0000,   /* U+6493 */
  0x0000,   /* U+6494 */
  0x0000,   /* U+6495 */
  0x0000,   /* U+6496 */
  0x0000,   /* U+6497 */
  0x0000,   /* U+6498 */
  0x0000,   /* U+6499 */
  0x0000,   /* U+649A */
  0x0000,   /* U+649B */
  0x0000,   /* U+649C */
  0x0000,   /* U+649D */
  0x0000,   /* U+649E */
  0x0000,   /* U+649F */
  0x0000,   /* U+64A0 */
  0x0000,   /* U+64A1 */
  0x0000,   /* U+64A2 */
  0x0000,   /* U+64A3 */
  0x0000,   /* U+64A4 */
  0x0000,   /* U+64A5 */
  0x0000,   /* U+64A6 */
  0x0000,   /* U+64A7 */
  0x0000,   /* U+64A8 */
  0x0000,   /* U+64A9 */
  0x0000,   /* U+64AA */
  0x0000,   /* U+64AB */
  0x0000,   /* U+64AC */
  0x0000,   /* U+64AD */
  0x0000,   /* U+64AE */
  0x0000,   /* U+64AF */
  0x0000,   /* U+64B0 */
  0x0000,   /* U+64B1 */
  0x0000,   /* U+64B2 */
  0x0000,   /* U+64B3 */
  0x0000,   /* U+64B4 */
  0x0000,   /* U+64B5 */
  0x0000,   /* U+64B6 */
  0x0000,   /* U+64B7 */
  0x0000,   /* U+64B8 */
  0x0000,   /* U+64B9 */
  0x0000,   /* U+64BA */
  0x0000,   /* U+64BB */
  0x0000,   /* U+64BC */
  0x0000,   /* U+64BD */
  0x0000,   /* U+64BE */
  0x0000,   /* U+64BF */
  0x0000,   /* U+64C0 */
  0x0000,   /* U+64C1 */
  0x0000,   /* U+64C2 */
  0x0000,   /* U+64C3 */
  0x0000,   /* U+64C4 */
  0x0000,   /* U+64C5 */
  0x0000,   /* U+64C6 */
  0x0000,   /* U+64C7 */
  0x0000,   /* U+64C8 */
  0x0000,   /* U+64C9 */
  0x0000,   /* U+64CA */
  0x0000,   /* U+64CB */
  0x0000,   /* U+64CC */
  0x0000,   /* U+64CD */
  0x0000,   /* U+64CE */
  0x0000,   /* U+64CF */
  0x0000,   /* U+64D0 */
  0x0000,   /* U+64D1 */
  0x0000,   /* U+64D2 */
  0x0000,   /* U+64D3 */
  0x0000,   /* U+64D4 */
  0x0000,   /* U+64D5 */
  0x0000,   /* U+64D6 */
  0x0000,   /* U+64D7 */
  0x0000,   /* U+64D8 */
  0x0000,   /* U+64D9 */
  0x0000,   /* U+64DA */
  0x0000,   /* U+64DB */
  0x0000,   /* U+64DC */
  0x0000,   /* U+64DD */
  0x0000,   /* U+64DE */
  0x0000,   /* U+64DF */
  0x0000,   /* U+64E0 */
  0x0000,   /* U+64E1 */
  0x0000,   /* U+64E2 */
  0x0000,   /* U+64E3 */
  0x0000,   /* U+64E4 */
  0x0000,   /* U+64E5 */
  0x0000,   /* U+64E6 */
  0x0000,   /* U+64E7 */
  0x0000,   /* U+64E8 */
  0x0000,   /* U+64E9 */
  0x0000,   /* U+64EA */
  0x0000,   /* U+64EB */
  0x0000,   /* U+64EC */
  0x0000,   /* U+64ED */
  0x0000,   /* U+64EE */
  0x0000,   /* U+64EF */
  0x0000,   /* U+64F0 */
  0x0000,   /* U+64F1 */
  0x0000,   /* U+64F2 */
  0x0000,   /* U+64F3 */
  0x0000,   /* U+64F4 */
  0x0000,   /* U+64F5 */
  0x0000,   /* U+64F6 */
  0x0000,   /* U+64F7 */
  0x0000,   /* U+64F8 */
  0x0000,   /* U+64F9 */
  0x0000,   /* U+64FA */
  0x0000,   /* U+64FB */
  0x0000,   /* U+64FC */
  0x0000,   /* U+64FD */
  0x0000,   /* U+64FE */
  0x0000,   /* U+64FF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+6400 */
  0x0000,   /* U+6401 */
  0x0000,   /* U+6402 */
  0x0000,   /* U+6403 */
  0x0000,   /* U+6404 */
  0x0000,   /* U+6405 */
  0x0000,   /* U+6406 */
  0x0000,   /* U+6407 */
  0x0000,   /* U+6408 */
  0x0000,   /* U+6409 */
  0x0000,   /* U+640A */
  0x0000,   /* U+640B */
  0x0000,   /* U+640C */
  0x0000,   /* U+640D */
  0x0000,   /* U+640E */
  0x0000,   /* U+640F */
  0x0000,   /* U+6410 */
  0x0000,   /* U+6411 */
  0x0000,   /* U+6412 */
  0x0000,   /* U+6413 */
  0x0000,   /* U+6414 */
  0x0000,   /* U+6415 */
  0x0000,   /* U+6416 */
  0x0000,   /* U+6417 */
  0x0000,   /* U+6418 */
  0x0000,   /* U+6419 */
  0x0000,   /* U+641A */
  0x0000,   /* U+641B */
  0x0000,   /* U+641C */
  0x0000,   /* U+641D */
  0x0000,   /* U+641E */
  0x0000,   /* U+641F */
  0x0000,   /* U+6420 */
  0x0000,   /* U+6421 */
  0x0000,   /* U+6422 */
  0x0000,   /* U+6423 */
  0x0000,   /* U+6424 */
  0x0000,   /* U+6425 */
  0x0000,   /* U+6426 */
  0x0000,   /* U+6427 */
  0x0000,   /* U+6428 */
  0x0000,   /* U+6429 */
  0x0000,   /* U+642A */
  0x0000,   /* U+642B */
  0x0000,   /* U+642C */
  0x0000,   /* U+642D */
  0x0000,   /* U+642E */
  0x0000,   /* U+642F */
  0x0000,   /* U+6430 */
  0x0000,   /* U+6431 */
  0x0000,   /* U+6432 */
  0x0000,   /* U+6433 */
  0x0000,   /* U+6434 */
  0x0000,   /* U+6435 */
  0x0000,   /* U+6436 */
  0x0000,   /* U+6437 */
  0x0000,   /* U+6438 */
  0x0000,   /* U+6439 */
  0x0000,   /* U+643A */
  0x0000,   /* U+643B */
  0x0000,   /* U+643C */
  0x0000,   /* U+643D */
  0x0000,   /* U+643E */
  0x0000,   /* U+643F */
  0x0000,   /* U+6440 */
  0x0000,   /* U+6441 */
  0x0000,   /* U+6442 */
  0x0000,   /* U+6443 */
  0x0000,   /* U+6444 */
  0x0000,   /* U+6445 */
  0x0000,   /* U+6446 */
  0x0000,   /* U+6447 */
  0x0000,   /* U+6448 */
  0x0000,   /* U+6449 */
  0x0000,   /* U+644A */
  0x0000,   /* U+644B */
  0x0000,   /* U+644C */
  0x0000,   /* U+644D */
  0x0000,   /* U+644E */
  0x0000,   /* U+644F */
  0x0000,   /* U+6450 */
  0x0000,   /* U+6451 */
  0x0000,   /* U+6452 */
  0x0000,   /* U+6453 */
  0x0000,   /* U+6454 */
  0x0000,   /* U+6455 */
  0x0000,   /* U+6456 */
  0x0000,   /* U+6457 */
  0x0000,   /* U+6458 */
  0x0000,   /* U+6459 */
  0x0000,   /* U+645A */
  0x0000,   /* U+645B */
  0x0000,   /* U+645C */
  0x0000,   /* U+645D */
  0x0000,   /* U+645E */
  0x0000,   /* U+645F */
  0x0000,   /* U+6460 */
  0x0000,   /* U+6461 */
  0x0000,   /* U+6462 */
  0x0000,   /* U+6463 */
  0x0000,   /* U+6464 */
  0x0000,   /* U+6465 */
  0x0000,   /* U+6466 */
  0x0000,   /* U+6467 */
  0x0000,   /* U+6468 */
  0x0000,   /* U+6469 */
  0x0000,   /* U+646A */
  0x0000,   /* U+646B */
  0x0000,   /* U+646C */
  0x0000,   /* U+646D */
  0x0000,   /* U+646E */
  0x0000,   /* U+646F */
  0x0000,   /* U+6470 */
  0x0000,   /* U+6471 */
  0x0000,   /* U+6472 */
  0x0000,   /* U+6473 */
  0x0000,   /* U+6474 */
  0x0000,   /* U+6475 */
  0x0000,   /* U+6476 */
  0x0000,   /* U+6477 */
  0x0000,   /* U+6478 */
  0x0000,   /* U+6479 */
  0x0000,   /* U+647A */
  0x0000,   /* U+647B */
  0x0000,   /* U+647C */
  0x0000,   /* U+647D */
  0x0000,   /* U+647E */
  0x0000,   /* U+647F */
  0x0000,   /* U+6480 */
  0x0000,   /* U+6481 */
  0x0000,   /* U+6482 */
  0x0000,   /* U+6483 */
  0x0000,   /* U+6484 */
  0x0000,   /* U+6485 */
  0x0000,   /* U+6486 */
  0x0000,   /* U+6487 */
  0x0000,   /* U+6488 */
  0x0000,   /* U+6489 */
  0x0000,   /* U+648A */
  0x0000,   /* U+648B */
  0x0000,   /* U+648C */
  0x0000,   /* U+648D */
  0x0000,   /* U+648E */
  0x0000,   /* U+648F */
  0x0000,   /* U+6490 */
  0x0000,   /* U+6491 */
  0x0000,   /* U+6492 */
  0x0000,   /* U+6493 */
  0x0000,   /* U+6494 */
  0x0000,   /* U+6495 */
  0x0000,   /* U+6496 */
  0x0000,   /* U+6497 */
  0x0000,   /* U+6498 */
  0x0000,   /* U+6499 */
  0x0000,   /* U+649A */
  0x0000,   /* U+649B */
  0x0000,   /* U+649C */
  0x0000,   /* U+649D */
  0x0000,   /* U+649E */
  0x0000,   /* U+649F */
  0x0000,   /* U+64A0 */
  0x0000,   /* U+64A1 */
  0x0000,   /* U+64A2 */
  0x0000,   /* U+64A3 */
  0x0000,   /* U+64A4 */
  0x0000,   /* U+64A5 */
  0x0000,   /* U+64A6 */
  0x0000,   /* U+64A7 */
  0x0000,   /* U+64A8 */
  0x0000,   /* U+64A9 */
  0x0000,   /* U+64AA */
  0x0000,   /* U+64AB */
  0x0000,   /* U+64AC */
  0x0000,   /* U+64AD */
  0x0000,   /* U+64AE */
  0x0000,   /* U+64AF */
  0x0000,   /* U+64B0 */
  0x0000,   /* U+64B1 */
  0x0000,   /* U+64B2 */
  0x0000,   /* U+64B3 */
  0x0000,   /* U+64B4 */
  0x0000,   /* U+64B5 */
  0x0000,   /* U+64B6 */
  0x0000,   /* U+64B7 */
  0x0000,   /* U+64B8 */
  0x0000,   /* U+64B9 */
  0x0000,   /* U+64BA */
  0x0000,   /* U+64BB */
  0x0000,   /* U+64BC */
  0x0000,   /* U+64BD */
  0x0000,   /* U+64BE */
  0x0000,   /* U+64BF */
  0x0000,   /* U+64C0 */
  0x0000,   /* U+64C1 */
  0x0000,   /* U+64C2 */
  0x0000,   /* U+64C3 */
  0x0000,   /* U+64C4 */
  0x0000,   /* U+64C5 */
  0x0000,   /* U+64C6 */
  0x0000,   /* U+64C7 */
  0x0000,   /* U+64C8 */
  0x0000,   /* U+64C9 */
  0x0000,   /* U+64CA */
  0x0000,   /* U+64CB */
  0x0000,   /* U+64CC */
  0x0000,   /* U+64CD */
  0x0000,   /* U+64CE */
  0x0000,   /* U+64CF */
  0x0000,   /* U+64D0 */
  0x0000,   /* U+64D1 */
  0x0000,   /* U+64D2 */
  0x0000,   /* U+64D3 */
  0x0000,   /* U+64D4 */
  0x0000,   /* U+64D5 */
  0x0000,   /* U+64D6 */
  0x0000,   /* U+64D7 */
  0x0000,   /* U+64D8 */
  0x0000,   /* U+64D9 */
  0x0000,   /* U+64DA */
  0x0000,   /* U+64DB */
  0x0000,   /* U+64DC */
  0x0000,   /* U+64DD */
  0x0000,   /* U+64DE */
  0x0000,   /* U+64DF */
  0x0000,   /* U+64E0 */
  0x0000,   /* U+64E1 */
  0x0000,   /* U+64E2 */
  0x0000,   /* U+64E3 */
  0x0000,   /* U+64E4 */
  0x0000,   /* U+64E5 */
  0x0000,   /* U+64E6 */
  0x0000,   /* U+64E7 */
  0x0000,   /* U+64E8 */
  0x0000,   /* U+64E9 */
  0x0000,   /* U+64EA */
  0x0000,   /* U+64EB */
  0x0000,   /* U+64EC */
  0x0000,   /* U+64ED */
  0x0000,   /* U+64EE */
  0x0000,   /* U+64EF */
  0x0000,   /* U+64F0 */
  0x0000,   /* U+64F1 */
  0x0000,   /* U+64F2 */
  0x0000,   /* U+64F3 */
  0x0000,   /* U+64F4 */
  0x0000,   /* U+64F5 */
  0x0000,   /* U+64F6 */
  0x0000,   /* U+64F7 */
  0x0000,   /* U+64F8 */
  0x0000,   /* U+64F9 */
  0x0000,   /* U+64FA */
  0x0000,   /* U+64FB */
  0x0000,   /* U+64FC */
  0x0000,   /* U+64FD */
  0x0000,   /* U+64FE */
  0x0000,   /* U+64FF */
};

uint16 ja_han_page65[]= {
  /* Number of CEs for each character. */
  1, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 1, 1, 2, 2,
  2, 2, 2, 1, 1, 2, 2, 2, 2, 2, 1, 1, 1, 2, 2, 1,
  2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 2, 1, 2, 2, 1, 1,
  2, 2, 2, 2, 2, 1, 2, 2, 1, 2, 2, 2, 2, 1, 2, 1,
  2, 1, 2, 2, 2, 1, 1, 1, 1, 1, 2, 2, 2, 1, 1, 2,
  2, 2, 1, 1, 2, 2, 1, 2, 2, 2, 2, 2, 1, 2, 2, 2,
  1, 2, 1, 2, 1, 1, 2, 1, 1, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 1, 1, 2, 2, 2, 1, 1, 1, 2, 2, 1, 2, 1, 2,
  1, 1, 2, 2, 2, 2, 2, 1, 2, 1, 2, 1, 1, 2, 2, 1,
  2, 1, 2, 2, 1, 1, 2, 1, 2, 2, 2, 1, 1, 1, 2, 1,
  1, 2, 2, 2, 2, 2, 2, 1, 2, 1, 2, 2, 1, 1, 2, 2,
  2, 1, 2, 1, 1, 1, 1, 2, 2, 2, 2, 1, 1, 2, 2, 1,
  2, 2, 1, 2, 2, 2, 2, 1, 2, 1, 2, 1, 2, 2, 2, 2,
  1, 1, 1, 2, 2, 1, 1, 1, 1, 1, 2, 2, 1, 1, 2, 2,
  2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 2, 2, 2, 2,

  /* Primary weight 1 for each character. */
  0x63F9,   /* U+6500 */
  0xFB40,   /* U+6501 */
  0xFB40,   /* U+6502 */
  0xFB40,   /* U+6503 */
  0xFB40,   /* U+6504 */
  0x63FD,   /* U+6505 */
  0xFB40,   /* U+6506 */
  0xFB40,   /* U+6507 */
  0xFB40,   /* U+6508 */
  0xFB40,   /* U+6509 */
  0xFB40,   /* U+650A */
  0xFB40,   /* U+650B */
  0xFB40,   /* U+650C */
  0xFB40,   /* U+650D */
  0xFB40,   /* U+650E */
  0xFB40,   /* U+650F */
  0xFB40,   /* U+6510 */
  0xFB40,   /* U+6511 */
  0xFB40,   /* U+6512 */
  0xFB40,   /* U+6513 */
  0xFB40,   /* U+6514 */
  0xFB40,   /* U+6515 */
  0xFB40,   /* U+6516 */
  0xFB40,   /* U+6517 */
  0x63FB,   /* U+6518 */
  0xFB40,   /* U+6519 */
  0xFB40,   /* U+651A */
  0xFB40,   /* U+651B */
  0x63FC,   /* U+651C */
  0x63D6,   /* U+651D */
  0xFB40,   /* U+651E */
  0xFB40,   /* U+651F */
  0xFB40,   /* U+6520 */
  0xFB40,   /* U+6521 */
  0xFB40,   /* U+6522 */
  0x63FF,   /* U+6523 */
  0x63FE,   /* U+6524 */
  0xFB40,   /* U+6525 */
  0xFB40,   /* U+6526 */
  0xFB40,   /* U+6527 */
  0xFB40,   /* U+6528 */
  0xFB40,   /* U+6529 */
  0x63DE,   /* U+652A */
  0x6400,   /* U+652B */
  0x63F4,   /* U+652C */
  0xFB40,   /* U+652D */
  0xFB40,   /* U+652E */
  0x58E6,   /* U+652F */
  0xFB40,   /* U+6530 */
  0xFB40,   /* U+6531 */
  0xFB40,   /* U+6532 */
  0xFB40,   /* U+6533 */
  0x6401,   /* U+6534 */
  0x6402,   /* U+6535 */
  0x6404,   /* U+6536 */
  0x6403,   /* U+6537 */
  0x6405,   /* U+6538 */
  0x55BD,   /* U+6539 */
  0xFB40,   /* U+653A */
  0x5807,   /* U+653B */
  0xFB40,   /* U+653C */
  0xFB40,   /* U+653D */
  0x5E8B,   /* U+653E */
  0x5A92,   /* U+653F */
  0xFB40,   /* U+6540 */
  0xFB40,   /* U+6541 */
  0xFB40,   /* U+6542 */
  0xFB40,   /* U+6543 */
  0xFB40,   /* U+6544 */
  0x57C1,   /* U+6545 */
  0xFB40,   /* U+6546 */
  0xFB40,   /* U+6547 */
  0x6407,   /* U+6548 */
  0xFB40,   /* U+6549 */
  0xFB40,   /* U+654A */
  0xFB40,   /* U+654B */
  0xFB40,   /* U+654C */
  0x640A,   /* U+654D */
  0xFB40,   /* U+654E */
  0x5E03,   /* U+654F */
  0xFB40,   /* U+6550 */
  0x56B8,   /* U+6551 */
  0xFB40,   /* U+6552 */
  0xFB40,   /* U+6553 */
  0xFB40,   /* U+6554 */
  0x6409,   /* U+6555 */
  0x6408,   /* U+6556 */
  0x5D49,   /* U+6557 */
  0x640B,   /* U+6558 */
  0x56EC,   /* U+6559 */
  0xFB40,   /* U+655A */
  0xFB40,   /* U+655B */
  0xFB40,   /* U+655C */
  0x640D,   /* U+655D */
  0x640C,   /* U+655E */
  0xFB40,   /* U+655F */
  0xFB40,   /* U+6560 */
  0xFB40,   /* U+6561 */
  0x5635,   /* U+6562 */
  0x58C3,   /* U+6563 */
  0xFB40,   /* U+6564 */
  0xFB40,   /* U+6565 */
  0x5CEF,   /* U+6566 */
  0xFB40,   /* U+6567 */
  0xFB40,   /* U+6568 */
  0xFB40,   /* U+6569 */
  0xFB40,   /* U+656A */
  0xFB40,   /* U+656B */
  0x575E,   /* U+656C */
  0xFB40,   /* U+656D */
  0xFB40,   /* U+656E */
  0xFB40,   /* U+656F */
  0x5A79,   /* U+6570 */
  0xFB40,   /* U+6571 */
  0x640E,   /* U+6572 */
  0xFB40,   /* U+6573 */
  0x5A93,   /* U+6574 */
  0x5C61,   /* U+6575 */
  0xFB40,   /* U+6576 */
  0x5E10,   /* U+6577 */
  0x640F,   /* U+6578 */
  0xFB40,   /* U+6579 */
  0xFB40,   /* U+657A */
  0xFB40,   /* U+657B */
  0xFB40,   /* U+657C */
  0xFB40,   /* U+657D */
  0xFB40,   /* U+657E */
  0xFB40,   /* U+657F */
  0xFB40,   /* U+6580 */
  0xFB40,   /* U+6581 */
  0x6410,   /* U+6582 */
  0x6411,   /* U+6583 */
  0xFB40,   /* U+6584 */
  0xFB40,   /* U+6585 */
  0xFB40,   /* U+6586 */
  0x5E47,   /* U+6587 */
  0x624B,   /* U+6588 */
  0x5AA9,   /* U+6589 */
  0xFB40,   /* U+658A */
  0xFB40,   /* U+658B */
  0x5DFD,   /* U+658C */
  0xFB40,   /* U+658D */
  0x5887,   /* U+658E */
  0xFB40,   /* U+658F */
  0x5DB8,   /* U+6590 */
  0x5D96,   /* U+6591 */
  0xFB40,   /* U+6592 */
  0xFB40,   /* U+6593 */
  0xFB40,   /* U+6594 */
  0xFB40,   /* U+6595 */
  0xFB40,   /* U+6596 */
  0x5C86,   /* U+6597 */
  0xFB40,   /* U+6598 */
  0x5FC8,   /* U+6599 */
  0xFB40,   /* U+659A */
  0x6413,   /* U+659B */
  0x593B,   /* U+659C */
  0xFB40,   /* U+659D */
  0xFB40,   /* U+659E */
  0x6414,   /* U+659F */
  0xFB40,   /* U+65A0 */
  0x54B9,   /* U+65A1 */
  0xFB40,   /* U+65A2 */
  0xFB40,   /* U+65A3 */
  0x570B,   /* U+65A4 */
  0x5AB0,   /* U+65A5 */
  0xFB40,   /* U+65A6 */
  0x5E11,   /* U+65A7 */
  0xFB40,   /* U+65A8 */
  0xFB40,   /* U+65A9 */
  0xFB40,   /* U+65AA */
  0x6415,   /* U+65AB */
  0x58CF,   /* U+65AC */
  0x5BC4,   /* U+65AD */
  0xFB40,   /* U+65AE */
  0x58E8,   /* U+65AF */
  0x5A3C,   /* U+65B0 */
  0xFB40,   /* U+65B1 */
  0xFB40,   /* U+65B2 */
  0xFB40,   /* U+65B3 */
  0xFB40,   /* U+65B4 */
  0xFB40,   /* U+65B5 */
  0xFB40,   /* U+65B6 */
  0x6416,   /* U+65B7 */
  0xFB40,   /* U+65B8 */
  0x5E8C,   /* U+65B9 */
  0xFB40,   /* U+65BA */
  0xFB40,   /* U+65BB */
  0x5558,   /* U+65BC */
  0x58E9,   /* U+65BD */
  0xFB40,   /* U+65BE */
  0xFB40,   /* U+65BF */
  0xFB40,   /* U+65C0 */
  0x6419,   /* U+65C1 */
  0xFB40,   /* U+65C2 */
  0x6417,   /* U+65C3 */
  0x641A,   /* U+65C4 */
  0x5FC0,   /* U+65C5 */
  0x6418,   /* U+65C6 */
  0xFB40,   /* U+65C7 */
  0xFB40,   /* U+65C8 */
  0xFB40,   /* U+65C9 */
  0xFB40,   /* U+65CA */
  0x5ADE,   /* U+65CB */
  0x641B,   /* U+65CC */
  0xFB40,   /* U+65CD */
  0xFB40,   /* U+65CE */
  0x5B51,   /* U+65CF */
  0xFB40,   /* U+65D0 */
  0xFB40,   /* U+65D1 */
  0x641C,   /* U+65D2 */
  0xFB40,   /* U+65D3 */
  0xFB40,   /* U+65D4 */
  0xFB40,   /* U+65D5 */
  0xFB40,   /* U+65D6 */
  0x5675,   /* U+65D7 */
  0xFB40,   /* U+65D8 */
  0x641E,   /* U+65D9 */
  0xFB40,   /* U+65DA */
  0x641D,   /* U+65DB */
  0xFB40,   /* U+65DC */
  0xFB40,   /* U+65DD */
  0xFB40,   /* U+65DE */
  0xFB40,   /* U+65DF */
  0x641F,   /* U+65E0 */
  0x6420,   /* U+65E1 */
  0x5676,   /* U+65E2 */
  0xFB40,   /* U+65E3 */
  0xFB40,   /* U+65E4 */
  0x5D13,   /* U+65E5 */
  0x5BB3,   /* U+65E6 */
  0x56C5,   /* U+65E7 */
  0x58EA,   /* U+65E8 */
  0x5B22,   /* U+65E9 */
  0xFB40,   /* U+65EA */
  0xFB40,   /* U+65EB */
  0x59A5,   /* U+65EC */
  0x54B3,   /* U+65ED */
  0xFB40,   /* U+65EE */
  0xFB40,   /* U+65EF */
  0xFB40,   /* U+65F0 */
  0x6421,   /* U+65F1 */
  0xFB40,   /* U+65F2 */
  0xFB40,   /* U+65F3 */
  0xFB40,   /* U+65F4 */
  0xFB40,   /* U+65F5 */
  0xFB40,   /* U+65F6 */
  0xFB40,   /* U+65F7 */
  0xFB40,   /* U+65F8 */
  0xFB40,   /* U+65F9 */
  0x5561,   /* U+65FA */
  0x6425,   /* U+65FB */
  0xFB40,   /* U+65FC */
  0xFB40,   /* U+65FD */
  0xFB40,   /* U+65FE */
  0xFB40,   /* U+65FF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+6500 */
  0x0020,   /* U+6501 */
  0x0020,   /* U+6502 */
  0x0020,   /* U+6503 */
  0x0020,   /* U+6504 */
  0x0020,   /* U+6505 */
  0x0020,   /* U+6506 */
  0x0020,   /* U+6507 */
  0x0020,   /* U+6508 */
  0x0020,   /* U+6509 */
  0x0020,   /* U+650A */
  0x0020,   /* U+650B */
  0x0020,   /* U+650C */
  0x0020,   /* U+650D */
  0x0020,   /* U+650E */
  0x0020,   /* U+650F */
  0x0020,   /* U+6510 */
  0x0020,   /* U+6511 */
  0x0020,   /* U+6512 */
  0x0020,   /* U+6513 */
  0x0020,   /* U+6514 */
  0x0020,   /* U+6515 */
  0x0020,   /* U+6516 */
  0x0020,   /* U+6517 */
  0x0020,   /* U+6518 */
  0x0020,   /* U+6519 */
  0x0020,   /* U+651A */
  0x0020,   /* U+651B */
  0x0020,   /* U+651C */
  0x0020,   /* U+651D */
  0x0020,   /* U+651E */
  0x0020,   /* U+651F */
  0x0020,   /* U+6520 */
  0x0020,   /* U+6521 */
  0x0020,   /* U+6522 */
  0x0020,   /* U+6523 */
  0x0020,   /* U+6524 */
  0x0020,   /* U+6525 */
  0x0020,   /* U+6526 */
  0x0020,   /* U+6527 */
  0x0020,   /* U+6528 */
  0x0020,   /* U+6529 */
  0x0020,   /* U+652A */
  0x0020,   /* U+652B */
  0x0020,   /* U+652C */
  0x0020,   /* U+652D */
  0x0020,   /* U+652E */
  0x0020,   /* U+652F */
  0x0020,   /* U+6530 */
  0x0020,   /* U+6531 */
  0x0020,   /* U+6532 */
  0x0020,   /* U+6533 */
  0x0020,   /* U+6534 */
  0x0020,   /* U+6535 */
  0x0020,   /* U+6536 */
  0x0020,   /* U+6537 */
  0x0020,   /* U+6538 */
  0x0020,   /* U+6539 */
  0x0020,   /* U+653A */
  0x0020,   /* U+653B */
  0x0020,   /* U+653C */
  0x0020,   /* U+653D */
  0x0020,   /* U+653E */
  0x0020,   /* U+653F */
  0x0020,   /* U+6540 */
  0x0020,   /* U+6541 */
  0x0020,   /* U+6542 */
  0x0020,   /* U+6543 */
  0x0020,   /* U+6544 */
  0x0020,   /* U+6545 */
  0x0020,   /* U+6546 */
  0x0020,   /* U+6547 */
  0x0020,   /* U+6548 */
  0x0020,   /* U+6549 */
  0x0020,   /* U+654A */
  0x0020,   /* U+654B */
  0x0020,   /* U+654C */
  0x0020,   /* U+654D */
  0x0020,   /* U+654E */
  0x0020,   /* U+654F */
  0x0020,   /* U+6550 */
  0x0020,   /* U+6551 */
  0x0020,   /* U+6552 */
  0x0020,   /* U+6553 */
  0x0020,   /* U+6554 */
  0x0020,   /* U+6555 */
  0x0020,   /* U+6556 */
  0x0020,   /* U+6557 */
  0x0020,   /* U+6558 */
  0x0020,   /* U+6559 */
  0x0020,   /* U+655A */
  0x0020,   /* U+655B */
  0x0020,   /* U+655C */
  0x0020,   /* U+655D */
  0x0020,   /* U+655E */
  0x0020,   /* U+655F */
  0x0020,   /* U+6560 */
  0x0020,   /* U+6561 */
  0x0020,   /* U+6562 */
  0x0020,   /* U+6563 */
  0x0020,   /* U+6564 */
  0x0020,   /* U+6565 */
  0x0020,   /* U+6566 */
  0x0020,   /* U+6567 */
  0x0020,   /* U+6568 */
  0x0020,   /* U+6569 */
  0x0020,   /* U+656A */
  0x0020,   /* U+656B */
  0x0020,   /* U+656C */
  0x0020,   /* U+656D */
  0x0020,   /* U+656E */
  0x0020,   /* U+656F */
  0x0020,   /* U+6570 */
  0x0020,   /* U+6571 */
  0x0020,   /* U+6572 */
  0x0020,   /* U+6573 */
  0x0020,   /* U+6574 */
  0x0020,   /* U+6575 */
  0x0020,   /* U+6576 */
  0x0020,   /* U+6577 */
  0x0020,   /* U+6578 */
  0x0020,   /* U+6579 */
  0x0020,   /* U+657A */
  0x0020,   /* U+657B */
  0x0020,   /* U+657C */
  0x0020,   /* U+657D */
  0x0020,   /* U+657E */
  0x0020,   /* U+657F */
  0x0020,   /* U+6580 */
  0x0020,   /* U+6581 */
  0x0020,   /* U+6582 */
  0x0020,   /* U+6583 */
  0x0020,   /* U+6584 */
  0x0020,   /* U+6585 */
  0x0020,   /* U+6586 */
  0x0020,   /* U+6587 */
  0x0020,   /* U+6588 */
  0x0020,   /* U+6589 */
  0x0020,   /* U+658A */
  0x0020,   /* U+658B */
  0x0020,   /* U+658C */
  0x0020,   /* U+658D */
  0x0020,   /* U+658E */
  0x0020,   /* U+658F */
  0x0020,   /* U+6590 */
  0x0020,   /* U+6591 */
  0x0020,   /* U+6592 */
  0x0020,   /* U+6593 */
  0x0020,   /* U+6594 */
  0x0020,   /* U+6595 */
  0x0020,   /* U+6596 */
  0x0020,   /* U+6597 */
  0x0020,   /* U+6598 */
  0x0020,   /* U+6599 */
  0x0020,   /* U+659A */
  0x0020,   /* U+659B */
  0x0020,   /* U+659C */
  0x0020,   /* U+659D */
  0x0020,   /* U+659E */
  0x0020,   /* U+659F */
  0x0020,   /* U+65A0 */
  0x0020,   /* U+65A1 */
  0x0020,   /* U+65A2 */
  0x0020,   /* U+65A3 */
  0x0020,   /* U+65A4 */
  0x0020,   /* U+65A5 */
  0x0020,   /* U+65A6 */
  0x0020,   /* U+65A7 */
  0x0020,   /* U+65A8 */
  0x0020,   /* U+65A9 */
  0x0020,   /* U+65AA */
  0x0020,   /* U+65AB */
  0x0020,   /* U+65AC */
  0x0020,   /* U+65AD */
  0x0020,   /* U+65AE */
  0x0020,   /* U+65AF */
  0x0020,   /* U+65B0 */
  0x0020,   /* U+65B1 */
  0x0020,   /* U+65B2 */
  0x0020,   /* U+65B3 */
  0x0020,   /* U+65B4 */
  0x0020,   /* U+65B5 */
  0x0020,   /* U+65B6 */
  0x0020,   /* U+65B7 */
  0x0020,   /* U+65B8 */
  0x0020,   /* U+65B9 */
  0x0020,   /* U+65BA */
  0x0020,   /* U+65BB */
  0x0020,   /* U+65BC */
  0x0020,   /* U+65BD */
  0x0020,   /* U+65BE */
  0x0020,   /* U+65BF */
  0x0020,   /* U+65C0 */
  0x0020,   /* U+65C1 */
  0x0020,   /* U+65C2 */
  0x0020,   /* U+65C3 */
  0x0020,   /* U+65C4 */
  0x0020,   /* U+65C5 */
  0x0020,   /* U+65C6 */
  0x0020,   /* U+65C7 */
  0x0020,   /* U+65C8 */
  0x0020,   /* U+65C9 */
  0x0020,   /* U+65CA */
  0x0020,   /* U+65CB */
  0x0020,   /* U+65CC */
  0x0020,   /* U+65CD */
  0x0020,   /* U+65CE */
  0x0020,   /* U+65CF */
  0x0020,   /* U+65D0 */
  0x0020,   /* U+65D1 */
  0x0020,   /* U+65D2 */
  0x0020,   /* U+65D3 */
  0x0020,   /* U+65D4 */
  0x0020,   /* U+65D5 */
  0x0020,   /* U+65D6 */
  0x0020,   /* U+65D7 */
  0x0020,   /* U+65D8 */
  0x0020,   /* U+65D9 */
  0x0020,   /* U+65DA */
  0x0020,   /* U+65DB */
  0x0020,   /* U+65DC */
  0x0020,   /* U+65DD */
  0x0020,   /* U+65DE */
  0x0020,   /* U+65DF */
  0x0020,   /* U+65E0 */
  0x0020,   /* U+65E1 */
  0x0020,   /* U+65E2 */
  0x0020,   /* U+65E3 */
  0x0020,   /* U+65E4 */
  0x0020,   /* U+65E5 */
  0x0020,   /* U+65E6 */
  0x0020,   /* U+65E7 */
  0x0020,   /* U+65E8 */
  0x0020,   /* U+65E9 */
  0x0020,   /* U+65EA */
  0x0020,   /* U+65EB */
  0x0020,   /* U+65EC */
  0x0020,   /* U+65ED */
  0x0020,   /* U+65EE */
  0x0020,   /* U+65EF */
  0x0020,   /* U+65F0 */
  0x0020,   /* U+65F1 */
  0x0020,   /* U+65F2 */
  0x0020,   /* U+65F3 */
  0x0020,   /* U+65F4 */
  0x0020,   /* U+65F5 */
  0x0020,   /* U+65F6 */
  0x0020,   /* U+65F7 */
  0x0020,   /* U+65F8 */
  0x0020,   /* U+65F9 */
  0x0020,   /* U+65FA */
  0x0020,   /* U+65FB */
  0x0020,   /* U+65FC */
  0x0020,   /* U+65FD */
  0x0020,   /* U+65FE */
  0x0020,   /* U+65FF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+6500 */
  0x0002,   /* U+6501 */
  0x0002,   /* U+6502 */
  0x0002,   /* U+6503 */
  0x0002,   /* U+6504 */
  0x0002,   /* U+6505 */
  0x0002,   /* U+6506 */
  0x0002,   /* U+6507 */
  0x0002,   /* U+6508 */
  0x0002,   /* U+6509 */
  0x0002,   /* U+650A */
  0x0002,   /* U+650B */
  0x0002,   /* U+650C */
  0x0002,   /* U+650D */
  0x0002,   /* U+650E */
  0x0002,   /* U+650F */
  0x0002,   /* U+6510 */
  0x0002,   /* U+6511 */
  0x0002,   /* U+6512 */
  0x0002,   /* U+6513 */
  0x0002,   /* U+6514 */
  0x0002,   /* U+6515 */
  0x0002,   /* U+6516 */
  0x0002,   /* U+6517 */
  0x0002,   /* U+6518 */
  0x0002,   /* U+6519 */
  0x0002,   /* U+651A */
  0x0002,   /* U+651B */
  0x0002,   /* U+651C */
  0x0002,   /* U+651D */
  0x0002,   /* U+651E */
  0x0002,   /* U+651F */
  0x0002,   /* U+6520 */
  0x0002,   /* U+6521 */
  0x0002,   /* U+6522 */
  0x0002,   /* U+6523 */
  0x0002,   /* U+6524 */
  0x0002,   /* U+6525 */
  0x0002,   /* U+6526 */
  0x0002,   /* U+6527 */
  0x0002,   /* U+6528 */
  0x0002,   /* U+6529 */
  0x0002,   /* U+652A */
  0x0002,   /* U+652B */
  0x0002,   /* U+652C */
  0x0002,   /* U+652D */
  0x0002,   /* U+652E */
  0x0002,   /* U+652F */
  0x0002,   /* U+6530 */
  0x0002,   /* U+6531 */
  0x0002,   /* U+6532 */
  0x0002,   /* U+6533 */
  0x0002,   /* U+6534 */
  0x0002,   /* U+6535 */
  0x0002,   /* U+6536 */
  0x0002,   /* U+6537 */
  0x0002,   /* U+6538 */
  0x0002,   /* U+6539 */
  0x0002,   /* U+653A */
  0x0002,   /* U+653B */
  0x0002,   /* U+653C */
  0x0002,   /* U+653D */
  0x0002,   /* U+653E */
  0x0002,   /* U+653F */
  0x0002,   /* U+6540 */
  0x0002,   /* U+6541 */
  0x0002,   /* U+6542 */
  0x0002,   /* U+6543 */
  0x0002,   /* U+6544 */
  0x0002,   /* U+6545 */
  0x0002,   /* U+6546 */
  0x0002,   /* U+6547 */
  0x0002,   /* U+6548 */
  0x0002,   /* U+6549 */
  0x0002,   /* U+654A */
  0x0002,   /* U+654B */
  0x0002,   /* U+654C */
  0x0002,   /* U+654D */
  0x0002,   /* U+654E */
  0x0002,   /* U+654F */
  0x0002,   /* U+6550 */
  0x0002,   /* U+6551 */
  0x0002,   /* U+6552 */
  0x0002,   /* U+6553 */
  0x0002,   /* U+6554 */
  0x0002,   /* U+6555 */
  0x0002,   /* U+6556 */
  0x0002,   /* U+6557 */
  0x0002,   /* U+6558 */
  0x0002,   /* U+6559 */
  0x0002,   /* U+655A */
  0x0002,   /* U+655B */
  0x0002,   /* U+655C */
  0x0002,   /* U+655D */
  0x0002,   /* U+655E */
  0x0002,   /* U+655F */
  0x0002,   /* U+6560 */
  0x0002,   /* U+6561 */
  0x0002,   /* U+6562 */
  0x0002,   /* U+6563 */
  0x0002,   /* U+6564 */
  0x0002,   /* U+6565 */
  0x0002,   /* U+6566 */
  0x0002,   /* U+6567 */
  0x0002,   /* U+6568 */
  0x0002,   /* U+6569 */
  0x0002,   /* U+656A */
  0x0002,   /* U+656B */
  0x0002,   /* U+656C */
  0x0002,   /* U+656D */
  0x0002,   /* U+656E */
  0x0002,   /* U+656F */
  0x0002,   /* U+6570 */
  0x0002,   /* U+6571 */
  0x0002,   /* U+6572 */
  0x0002,   /* U+6573 */
  0x0002,   /* U+6574 */
  0x0002,   /* U+6575 */
  0x0002,   /* U+6576 */
  0x0002,   /* U+6577 */
  0x0002,   /* U+6578 */
  0x0002,   /* U+6579 */
  0x0002,   /* U+657A */
  0x0002,   /* U+657B */
  0x0002,   /* U+657C */
  0x0002,   /* U+657D */
  0x0002,   /* U+657E */
  0x0002,   /* U+657F */
  0x0002,   /* U+6580 */
  0x0002,   /* U+6581 */
  0x0002,   /* U+6582 */
  0x0002,   /* U+6583 */
  0x0002,   /* U+6584 */
  0x0002,   /* U+6585 */
  0x0002,   /* U+6586 */
  0x0002,   /* U+6587 */
  0x0002,   /* U+6588 */
  0x0002,   /* U+6589 */
  0x0002,   /* U+658A */
  0x0002,   /* U+658B */
  0x0002,   /* U+658C */
  0x0002,   /* U+658D */
  0x0002,   /* U+658E */
  0x0002,   /* U+658F */
  0x0002,   /* U+6590 */
  0x0002,   /* U+6591 */
  0x0002,   /* U+6592 */
  0x0002,   /* U+6593 */
  0x0002,   /* U+6594 */
  0x0002,   /* U+6595 */
  0x0002,   /* U+6596 */
  0x0002,   /* U+6597 */
  0x0002,   /* U+6598 */
  0x0002,   /* U+6599 */
  0x0002,   /* U+659A */
  0x0002,   /* U+659B */
  0x0002,   /* U+659C */
  0x0002,   /* U+659D */
  0x0002,   /* U+659E */
  0x0002,   /* U+659F */
  0x0002,   /* U+65A0 */
  0x0002,   /* U+65A1 */
  0x0002,   /* U+65A2 */
  0x0002,   /* U+65A3 */
  0x0002,   /* U+65A4 */
  0x0002,   /* U+65A5 */
  0x0002,   /* U+65A6 */
  0x0002,   /* U+65A7 */
  0x0002,   /* U+65A8 */
  0x0002,   /* U+65A9 */
  0x0002,   /* U+65AA */
  0x0002,   /* U+65AB */
  0x0002,   /* U+65AC */
  0x0002,   /* U+65AD */
  0x0002,   /* U+65AE */
  0x0002,   /* U+65AF */
  0x0002,   /* U+65B0 */
  0x0002,   /* U+65B1 */
  0x0002,   /* U+65B2 */
  0x0002,   /* U+65B3 */
  0x0002,   /* U+65B4 */
  0x0002,   /* U+65B5 */
  0x0002,   /* U+65B6 */
  0x0002,   /* U+65B7 */
  0x0002,   /* U+65B8 */
  0x0002,   /* U+65B9 */
  0x0002,   /* U+65BA */
  0x0002,   /* U+65BB */
  0x0002,   /* U+65BC */
  0x0002,   /* U+65BD */
  0x0002,   /* U+65BE */
  0x0002,   /* U+65BF */
  0x0002,   /* U+65C0 */
  0x0002,   /* U+65C1 */
  0x0002,   /* U+65C2 */
  0x0002,   /* U+65C3 */
  0x0002,   /* U+65C4 */
  0x0002,   /* U+65C5 */
  0x0002,   /* U+65C6 */
  0x0002,   /* U+65C7 */
  0x0002,   /* U+65C8 */
  0x0002,   /* U+65C9 */
  0x0002,   /* U+65CA */
  0x0002,   /* U+65CB */
  0x0002,   /* U+65CC */
  0x0002,   /* U+65CD */
  0x0002,   /* U+65CE */
  0x0002,   /* U+65CF */
  0x0002,   /* U+65D0 */
  0x0002,   /* U+65D1 */
  0x0002,   /* U+65D2 */
  0x0002,   /* U+65D3 */
  0x0002,   /* U+65D4 */
  0x0002,   /* U+65D5 */
  0x0002,   /* U+65D6 */
  0x0002,   /* U+65D7 */
  0x0002,   /* U+65D8 */
  0x0002,   /* U+65D9 */
  0x0002,   /* U+65DA */
  0x0002,   /* U+65DB */
  0x0002,   /* U+65DC */
  0x0002,   /* U+65DD */
  0x0002,   /* U+65DE */
  0x0002,   /* U+65DF */
  0x0002,   /* U+65E0 */
  0x0002,   /* U+65E1 */
  0x0002,   /* U+65E2 */
  0x0002,   /* U+65E3 */
  0x0002,   /* U+65E4 */
  0x0002,   /* U+65E5 */
  0x0002,   /* U+65E6 */
  0x0002,   /* U+65E7 */
  0x0002,   /* U+65E8 */
  0x0002,   /* U+65E9 */
  0x0002,   /* U+65EA */
  0x0002,   /* U+65EB */
  0x0002,   /* U+65EC */
  0x0002,   /* U+65ED */
  0x0002,   /* U+65EE */
  0x0002,   /* U+65EF */
  0x0002,   /* U+65F0 */
  0x0002,   /* U+65F1 */
  0x0002,   /* U+65F2 */
  0x0002,   /* U+65F3 */
  0x0002,   /* U+65F4 */
  0x0002,   /* U+65F5 */
  0x0002,   /* U+65F6 */
  0x0002,   /* U+65F7 */
  0x0002,   /* U+65F8 */
  0x0002,   /* U+65F9 */
  0x0002,   /* U+65FA */
  0x0002,   /* U+65FB */
  0x0002,   /* U+65FC */
  0x0002,   /* U+65FD */
  0x0002,   /* U+65FE */
  0x0002,   /* U+65FF */

  /* Primary weight 2 for each character. */
  0x0000,   /* U+6500 */
  0xE501,   /* U+6501 */
  0xE502,   /* U+6502 */
  0xE503,   /* U+6503 */
  0xE504,   /* U+6504 */
  0x0000,   /* U+6505 */
  0xE506,   /* U+6506 */
  0xE507,   /* U+6507 */
  0xE508,   /* U+6508 */
  0xE509,   /* U+6509 */
  0xE50A,   /* U+650A */
  0xE50B,   /* U+650B */
  0xE50C,   /* U+650C */
  0xE50D,   /* U+650D */
  0xE50E,   /* U+650E */
  0xE50F,   /* U+650F */
  0xE510,   /* U+6510 */
  0xE511,   /* U+6511 */
  0xE512,   /* U+6512 */
  0xE513,   /* U+6513 */
  0xE514,   /* U+6514 */
  0xE515,   /* U+6515 */
  0xE516,   /* U+6516 */
  0xE517,   /* U+6517 */
  0x0000,   /* U+6518 */
  0xE519,   /* U+6519 */
  0xE51A,   /* U+651A */
  0xE51B,   /* U+651B */
  0x0000,   /* U+651C */
  0x0000,   /* U+651D */
  0xE51E,   /* U+651E */
  0xE51F,   /* U+651F */
  0xE520,   /* U+6520 */
  0xE521,   /* U+6521 */
  0xE522,   /* U+6522 */
  0x0000,   /* U+6523 */
  0x0000,   /* U+6524 */
  0xE525,   /* U+6525 */
  0xE526,   /* U+6526 */
  0xE527,   /* U+6527 */
  0xE528,   /* U+6528 */
  0xE529,   /* U+6529 */
  0x0000,   /* U+652A */
  0x0000,   /* U+652B */
  0x0000,   /* U+652C */
  0xE52D,   /* U+652D */
  0xE52E,   /* U+652E */
  0x0000,   /* U+652F */
  0xE530,   /* U+6530 */
  0xE531,   /* U+6531 */
  0xE532,   /* U+6532 */
  0xE533,   /* U+6533 */
  0x0000,   /* U+6534 */
  0x0000,   /* U+6535 */
  0x0000,   /* U+6536 */
  0x0000,   /* U+6537 */
  0x0000,   /* U+6538 */
  0x0000,   /* U+6539 */
  0xE53A,   /* U+653A */
  0x0000,   /* U+653B */
  0xE53C,   /* U+653C */
  0xE53D,   /* U+653D */
  0x0000,   /* U+653E */
  0x0000,   /* U+653F */
  0xE540,   /* U+6540 */
  0xE541,   /* U+6541 */
  0xE542,   /* U+6542 */
  0xE543,   /* U+6543 */
  0xE544,   /* U+6544 */
  0x0000,   /* U+6545 */
  0xE546,   /* U+6546 */
  0xE547,   /* U+6547 */
  0x0000,   /* U+6548 */
  0xE549,   /* U+6549 */
  0xE54A,   /* U+654A */
  0xE54B,   /* U+654B */
  0xE54C,   /* U+654C */
  0x0000,   /* U+654D */
  0xE54E,   /* U+654E */
  0x0000,   /* U+654F */
  0xE550,   /* U+6550 */
  0x0000,   /* U+6551 */
  0xE552,   /* U+6552 */
  0xE553,   /* U+6553 */
  0xE554,   /* U+6554 */
  0x0000,   /* U+6555 */
  0x0000,   /* U+6556 */
  0x0000,   /* U+6557 */
  0x0000,   /* U+6558 */
  0x0000,   /* U+6559 */
  0xE55A,   /* U+655A */
  0xE55B,   /* U+655B */
  0xE55C,   /* U+655C */
  0x0000,   /* U+655D */
  0x0000,   /* U+655E */
  0xE55F,   /* U+655F */
  0xE560,   /* U+6560 */
  0xE561,   /* U+6561 */
  0x0000,   /* U+6562 */
  0x0000,   /* U+6563 */
  0xE564,   /* U+6564 */
  0xE565,   /* U+6565 */
  0x0000,   /* U+6566 */
  0xE567,   /* U+6567 */
  0xE568,   /* U+6568 */
  0xE569,   /* U+6569 */
  0xE56A,   /* U+656A */
  0xE56B,   /* U+656B */
  0x0000,   /* U+656C */
  0xE56D,   /* U+656D */
  0xE56E,   /* U+656E */
  0xE56F,   /* U+656F */
  0x0000,   /* U+6570 */
  0xE571,   /* U+6571 */
  0x0000,   /* U+6572 */
  0xE573,   /* U+6573 */
  0x0000,   /* U+6574 */
  0x0000,   /* U+6575 */
  0xE576,   /* U+6576 */
  0x0000,   /* U+6577 */
  0x0000,   /* U+6578 */
  0xE579,   /* U+6579 */
  0xE57A,   /* U+657A */
  0xE57B,   /* U+657B */
  0xE57C,   /* U+657C */
  0xE57D,   /* U+657D */
  0xE57E,   /* U+657E */
  0xE57F,   /* U+657F */
  0xE580,   /* U+6580 */
  0xE581,   /* U+6581 */
  0x0000,   /* U+6582 */
  0x0000,   /* U+6583 */
  0xE584,   /* U+6584 */
  0xE585,   /* U+6585 */
  0xE586,   /* U+6586 */
  0x0000,   /* U+6587 */
  0x0000,   /* U+6588 */
  0x0000,   /* U+6589 */
  0xE58A,   /* U+658A */
  0xE58B,   /* U+658B */
  0x0000,   /* U+658C */
  0xE58D,   /* U+658D */
  0x0000,   /* U+658E */
  0xE58F,   /* U+658F */
  0x0000,   /* U+6590 */
  0x0000,   /* U+6591 */
  0xE592,   /* U+6592 */
  0xE593,   /* U+6593 */
  0xE594,   /* U+6594 */
  0xE595,   /* U+6595 */
  0xE596,   /* U+6596 */
  0x0000,   /* U+6597 */
  0xE598,   /* U+6598 */
  0x0000,   /* U+6599 */
  0xE59A,   /* U+659A */
  0x0000,   /* U+659B */
  0x0000,   /* U+659C */
  0xE59D,   /* U+659D */
  0xE59E,   /* U+659E */
  0x0000,   /* U+659F */
  0xE5A0,   /* U+65A0 */
  0x0000,   /* U+65A1 */
  0xE5A2,   /* U+65A2 */
  0xE5A3,   /* U+65A3 */
  0x0000,   /* U+65A4 */
  0x0000,   /* U+65A5 */
  0xE5A6,   /* U+65A6 */
  0x0000,   /* U+65A7 */
  0xE5A8,   /* U+65A8 */
  0xE5A9,   /* U+65A9 */
  0xE5AA,   /* U+65AA */
  0x0000,   /* U+65AB */
  0x0000,   /* U+65AC */
  0x0000,   /* U+65AD */
  0xE5AE,   /* U+65AE */
  0x0000,   /* U+65AF */
  0x0000,   /* U+65B0 */
  0xE5B1,   /* U+65B1 */
  0xE5B2,   /* U+65B2 */
  0xE5B3,   /* U+65B3 */
  0xE5B4,   /* U+65B4 */
  0xE5B5,   /* U+65B5 */
  0xE5B6,   /* U+65B6 */
  0x0000,   /* U+65B7 */
  0xE5B8,   /* U+65B8 */
  0x0000,   /* U+65B9 */
  0xE5BA,   /* U+65BA */
  0xE5BB,   /* U+65BB */
  0x0000,   /* U+65BC */
  0x0000,   /* U+65BD */
  0xE5BE,   /* U+65BE */
  0xE5BF,   /* U+65BF */
  0xE5C0,   /* U+65C0 */
  0x0000,   /* U+65C1 */
  0xE5C2,   /* U+65C2 */
  0x0000,   /* U+65C3 */
  0x0000,   /* U+65C4 */
  0x0000,   /* U+65C5 */
  0x0000,   /* U+65C6 */
  0xE5C7,   /* U+65C7 */
  0xE5C8,   /* U+65C8 */
  0xE5C9,   /* U+65C9 */
  0xE5CA,   /* U+65CA */
  0x0000,   /* U+65CB */
  0x0000,   /* U+65CC */
  0xE5CD,   /* U+65CD */
  0xE5CE,   /* U+65CE */
  0x0000,   /* U+65CF */
  0xE5D0,   /* U+65D0 */
  0xE5D1,   /* U+65D1 */
  0x0000,   /* U+65D2 */
  0xE5D3,   /* U+65D3 */
  0xE5D4,   /* U+65D4 */
  0xE5D5,   /* U+65D5 */
  0xE5D6,   /* U+65D6 */
  0x0000,   /* U+65D7 */
  0xE5D8,   /* U+65D8 */
  0x0000,   /* U+65D9 */
  0xE5DA,   /* U+65DA */
  0x0000,   /* U+65DB */
  0xE5DC,   /* U+65DC */
  0xE5DD,   /* U+65DD */
  0xE5DE,   /* U+65DE */
  0xE5DF,   /* U+65DF */
  0x0000,   /* U+65E0 */
  0x0000,   /* U+65E1 */
  0x0000,   /* U+65E2 */
  0xE5E3,   /* U+65E3 */
  0xE5E4,   /* U+65E4 */
  0x0000,   /* U+65E5 */
  0x0000,   /* U+65E6 */
  0x0000,   /* U+65E7 */
  0x0000,   /* U+65E8 */
  0x0000,   /* U+65E9 */
  0xE5EA,   /* U+65EA */
  0xE5EB,   /* U+65EB */
  0x0000,   /* U+65EC */
  0x0000,   /* U+65ED */
  0xE5EE,   /* U+65EE */
  0xE5EF,   /* U+65EF */
  0xE5F0,   /* U+65F0 */
  0x0000,   /* U+65F1 */
  0xE5F2,   /* U+65F2 */
  0xE5F3,   /* U+65F3 */
  0xE5F4,   /* U+65F4 */
  0xE5F5,   /* U+65F5 */
  0xE5F6,   /* U+65F6 */
  0xE5F7,   /* U+65F7 */
  0xE5F8,   /* U+65F8 */
  0xE5F9,   /* U+65F9 */
  0x0000,   /* U+65FA */
  0x0000,   /* U+65FB */
  0xE5FC,   /* U+65FC */
  0xE5FD,   /* U+65FD */
  0xE5FE,   /* U+65FE */
  0xE5FF,   /* U+65FF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+6500 */
  0x0000,   /* U+6501 */
  0x0000,   /* U+6502 */
  0x0000,   /* U+6503 */
  0x0000,   /* U+6504 */
  0x0000,   /* U+6505 */
  0x0000,   /* U+6506 */
  0x0000,   /* U+6507 */
  0x0000,   /* U+6508 */
  0x0000,   /* U+6509 */
  0x0000,   /* U+650A */
  0x0000,   /* U+650B */
  0x0000,   /* U+650C */
  0x0000,   /* U+650D */
  0x0000,   /* U+650E */
  0x0000,   /* U+650F */
  0x0000,   /* U+6510 */
  0x0000,   /* U+6511 */
  0x0000,   /* U+6512 */
  0x0000,   /* U+6513 */
  0x0000,   /* U+6514 */
  0x0000,   /* U+6515 */
  0x0000,   /* U+6516 */
  0x0000,   /* U+6517 */
  0x0000,   /* U+6518 */
  0x0000,   /* U+6519 */
  0x0000,   /* U+651A */
  0x0000,   /* U+651B */
  0x0000,   /* U+651C */
  0x0000,   /* U+651D */
  0x0000,   /* U+651E */
  0x0000,   /* U+651F */
  0x0000,   /* U+6520 */
  0x0000,   /* U+6521 */
  0x0000,   /* U+6522 */
  0x0000,   /* U+6523 */
  0x0000,   /* U+6524 */
  0x0000,   /* U+6525 */
  0x0000,   /* U+6526 */
  0x0000,   /* U+6527 */
  0x0000,   /* U+6528 */
  0x0000,   /* U+6529 */
  0x0000,   /* U+652A */
  0x0000,   /* U+652B */
  0x0000,   /* U+652C */
  0x0000,   /* U+652D */
  0x0000,   /* U+652E */
  0x0000,   /* U+652F */
  0x0000,   /* U+6530 */
  0x0000,   /* U+6531 */
  0x0000,   /* U+6532 */
  0x0000,   /* U+6533 */
  0x0000,   /* U+6534 */
  0x0000,   /* U+6535 */
  0x0000,   /* U+6536 */
  0x0000,   /* U+6537 */
  0x0000,   /* U+6538 */
  0x0000,   /* U+6539 */
  0x0000,   /* U+653A */
  0x0000,   /* U+653B */
  0x0000,   /* U+653C */
  0x0000,   /* U+653D */
  0x0000,   /* U+653E */
  0x0000,   /* U+653F */
  0x0000,   /* U+6540 */
  0x0000,   /* U+6541 */
  0x0000,   /* U+6542 */
  0x0000,   /* U+6543 */
  0x0000,   /* U+6544 */
  0x0000,   /* U+6545 */
  0x0000,   /* U+6546 */
  0x0000,   /* U+6547 */
  0x0000,   /* U+6548 */
  0x0000,   /* U+6549 */
  0x0000,   /* U+654A */
  0x0000,   /* U+654B */
  0x0000,   /* U+654C */
  0x0000,   /* U+654D */
  0x0000,   /* U+654E */
  0x0000,   /* U+654F */
  0x0000,   /* U+6550 */
  0x0000,   /* U+6551 */
  0x0000,   /* U+6552 */
  0x0000,   /* U+6553 */
  0x0000,   /* U+6554 */
  0x0000,   /* U+6555 */
  0x0000,   /* U+6556 */
  0x0000,   /* U+6557 */
  0x0000,   /* U+6558 */
  0x0000,   /* U+6559 */
  0x0000,   /* U+655A */
  0x0000,   /* U+655B */
  0x0000,   /* U+655C */
  0x0000,   /* U+655D */
  0x0000,   /* U+655E */
  0x0000,   /* U+655F */
  0x0000,   /* U+6560 */
  0x0000,   /* U+6561 */
  0x0000,   /* U+6562 */
  0x0000,   /* U+6563 */
  0x0000,   /* U+6564 */
  0x0000,   /* U+6565 */
  0x0000,   /* U+6566 */
  0x0000,   /* U+6567 */
  0x0000,   /* U+6568 */
  0x0000,   /* U+6569 */
  0x0000,   /* U+656A */
  0x0000,   /* U+656B */
  0x0000,   /* U+656C */
  0x0000,   /* U+656D */
  0x0000,   /* U+656E */
  0x0000,   /* U+656F */
  0x0000,   /* U+6570 */
  0x0000,   /* U+6571 */
  0x0000,   /* U+6572 */
  0x0000,   /* U+6573 */
  0x0000,   /* U+6574 */
  0x0000,   /* U+6575 */
  0x0000,   /* U+6576 */
  0x0000,   /* U+6577 */
  0x0000,   /* U+6578 */
  0x0000,   /* U+6579 */
  0x0000,   /* U+657A */
  0x0000,   /* U+657B */
  0x0000,   /* U+657C */
  0x0000,   /* U+657D */
  0x0000,   /* U+657E */
  0x0000,   /* U+657F */
  0x0000,   /* U+6580 */
  0x0000,   /* U+6581 */
  0x0000,   /* U+6582 */
  0x0000,   /* U+6583 */
  0x0000,   /* U+6584 */
  0x0000,   /* U+6585 */
  0x0000,   /* U+6586 */
  0x0000,   /* U+6587 */
  0x0000,   /* U+6588 */
  0x0000,   /* U+6589 */
  0x0000,   /* U+658A */
  0x0000,   /* U+658B */
  0x0000,   /* U+658C */
  0x0000,   /* U+658D */
  0x0000,   /* U+658E */
  0x0000,   /* U+658F */
  0x0000,   /* U+6590 */
  0x0000,   /* U+6591 */
  0x0000,   /* U+6592 */
  0x0000,   /* U+6593 */
  0x0000,   /* U+6594 */
  0x0000,   /* U+6595 */
  0x0000,   /* U+6596 */
  0x0000,   /* U+6597 */
  0x0000,   /* U+6598 */
  0x0000,   /* U+6599 */
  0x0000,   /* U+659A */
  0x0000,   /* U+659B */
  0x0000,   /* U+659C */
  0x0000,   /* U+659D */
  0x0000,   /* U+659E */
  0x0000,   /* U+659F */
  0x0000,   /* U+65A0 */
  0x0000,   /* U+65A1 */
  0x0000,   /* U+65A2 */
  0x0000,   /* U+65A3 */
  0x0000,   /* U+65A4 */
  0x0000,   /* U+65A5 */
  0x0000,   /* U+65A6 */
  0x0000,   /* U+65A7 */
  0x0000,   /* U+65A8 */
  0x0000,   /* U+65A9 */
  0x0000,   /* U+65AA */
  0x0000,   /* U+65AB */
  0x0000,   /* U+65AC */
  0x0000,   /* U+65AD */
  0x0000,   /* U+65AE */
  0x0000,   /* U+65AF */
  0x0000,   /* U+65B0 */
  0x0000,   /* U+65B1 */
  0x0000,   /* U+65B2 */
  0x0000,   /* U+65B3 */
  0x0000,   /* U+65B4 */
  0x0000,   /* U+65B5 */
  0x0000,   /* U+65B6 */
  0x0000,   /* U+65B7 */
  0x0000,   /* U+65B8 */
  0x0000,   /* U+65B9 */
  0x0000,   /* U+65BA */
  0x0000,   /* U+65BB */
  0x0000,   /* U+65BC */
  0x0000,   /* U+65BD */
  0x0000,   /* U+65BE */
  0x0000,   /* U+65BF */
  0x0000,   /* U+65C0 */
  0x0000,   /* U+65C1 */
  0x0000,   /* U+65C2 */
  0x0000,   /* U+65C3 */
  0x0000,   /* U+65C4 */
  0x0000,   /* U+65C5 */
  0x0000,   /* U+65C6 */
  0x0000,   /* U+65C7 */
  0x0000,   /* U+65C8 */
  0x0000,   /* U+65C9 */
  0x0000,   /* U+65CA */
  0x0000,   /* U+65CB */
  0x0000,   /* U+65CC */
  0x0000,   /* U+65CD */
  0x0000,   /* U+65CE */
  0x0000,   /* U+65CF */
  0x0000,   /* U+65D0 */
  0x0000,   /* U+65D1 */
  0x0000,   /* U+65D2 */
  0x0000,   /* U+65D3 */
  0x0000,   /* U+65D4 */
  0x0000,   /* U+65D5 */
  0x0000,   /* U+65D6 */
  0x0000,   /* U+65D7 */
  0x0000,   /* U+65D8 */
  0x0000,   /* U+65D9 */
  0x0000,   /* U+65DA */
  0x0000,   /* U+65DB */
  0x0000,   /* U+65DC */
  0x0000,   /* U+65DD */
  0x0000,   /* U+65DE */
  0x0000,   /* U+65DF */
  0x0000,   /* U+65E0 */
  0x0000,   /* U+65E1 */
  0x0000,   /* U+65E2 */
  0x0000,   /* U+65E3 */
  0x0000,   /* U+65E4 */
  0x0000,   /* U+65E5 */
  0x0000,   /* U+65E6 */
  0x0000,   /* U+65E7 */
  0x0000,   /* U+65E8 */
  0x0000,   /* U+65E9 */
  0x0000,   /* U+65EA */
  0x0000,   /* U+65EB */
  0x0000,   /* U+65EC */
  0x0000,   /* U+65ED */
  0x0000,   /* U+65EE */
  0x0000,   /* U+65EF */
  0x0000,   /* U+65F0 */
  0x0000,   /* U+65F1 */
  0x0000,   /* U+65F2 */
  0x0000,   /* U+65F3 */
  0x0000,   /* U+65F4 */
  0x0000,   /* U+65F5 */
  0x0000,   /* U+65F6 */
  0x0000,   /* U+65F7 */
  0x0000,   /* U+65F8 */
  0x0000,   /* U+65F9 */
  0x0000,   /* U+65FA */
  0x0000,   /* U+65FB */
  0x0000,   /* U+65FC */
  0x0000,   /* U+65FD */
  0x0000,   /* U+65FE */
  0x0000,   /* U+65FF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+6500 */
  0x0000,   /* U+6501 */
  0x0000,   /* U+6502 */
  0x0000,   /* U+6503 */
  0x0000,   /* U+6504 */
  0x0000,   /* U+6505 */
  0x0000,   /* U+6506 */
  0x0000,   /* U+6507 */
  0x0000,   /* U+6508 */
  0x0000,   /* U+6509 */
  0x0000,   /* U+650A */
  0x0000,   /* U+650B */
  0x0000,   /* U+650C */
  0x0000,   /* U+650D */
  0x0000,   /* U+650E */
  0x0000,   /* U+650F */
  0x0000,   /* U+6510 */
  0x0000,   /* U+6511 */
  0x0000,   /* U+6512 */
  0x0000,   /* U+6513 */
  0x0000,   /* U+6514 */
  0x0000,   /* U+6515 */
  0x0000,   /* U+6516 */
  0x0000,   /* U+6517 */
  0x0000,   /* U+6518 */
  0x0000,   /* U+6519 */
  0x0000,   /* U+651A */
  0x0000,   /* U+651B */
  0x0000,   /* U+651C */
  0x0000,   /* U+651D */
  0x0000,   /* U+651E */
  0x0000,   /* U+651F */
  0x0000,   /* U+6520 */
  0x0000,   /* U+6521 */
  0x0000,   /* U+6522 */
  0x0000,   /* U+6523 */
  0x0000,   /* U+6524 */
  0x0000,   /* U+6525 */
  0x0000,   /* U+6526 */
  0x0000,   /* U+6527 */
  0x0000,   /* U+6528 */
  0x0000,   /* U+6529 */
  0x0000,   /* U+652A */
  0x0000,   /* U+652B */
  0x0000,   /* U+652C */
  0x0000,   /* U+652D */
  0x0000,   /* U+652E */
  0x0000,   /* U+652F */
  0x0000,   /* U+6530 */
  0x0000,   /* U+6531 */
  0x0000,   /* U+6532 */
  0x0000,   /* U+6533 */
  0x0000,   /* U+6534 */
  0x0000,   /* U+6535 */
  0x0000,   /* U+6536 */
  0x0000,   /* U+6537 */
  0x0000,   /* U+6538 */
  0x0000,   /* U+6539 */
  0x0000,   /* U+653A */
  0x0000,   /* U+653B */
  0x0000,   /* U+653C */
  0x0000,   /* U+653D */
  0x0000,   /* U+653E */
  0x0000,   /* U+653F */
  0x0000,   /* U+6540 */
  0x0000,   /* U+6541 */
  0x0000,   /* U+6542 */
  0x0000,   /* U+6543 */
  0x0000,   /* U+6544 */
  0x0000,   /* U+6545 */
  0x0000,   /* U+6546 */
  0x0000,   /* U+6547 */
  0x0000,   /* U+6548 */
  0x0000,   /* U+6549 */
  0x0000,   /* U+654A */
  0x0000,   /* U+654B */
  0x0000,   /* U+654C */
  0x0000,   /* U+654D */
  0x0000,   /* U+654E */
  0x0000,   /* U+654F */
  0x0000,   /* U+6550 */
  0x0000,   /* U+6551 */
  0x0000,   /* U+6552 */
  0x0000,   /* U+6553 */
  0x0000,   /* U+6554 */
  0x0000,   /* U+6555 */
  0x0000,   /* U+6556 */
  0x0000,   /* U+6557 */
  0x0000,   /* U+6558 */
  0x0000,   /* U+6559 */
  0x0000,   /* U+655A */
  0x0000,   /* U+655B */
  0x0000,   /* U+655C */
  0x0000,   /* U+655D */
  0x0000,   /* U+655E */
  0x0000,   /* U+655F */
  0x0000,   /* U+6560 */
  0x0000,   /* U+6561 */
  0x0000,   /* U+6562 */
  0x0000,   /* U+6563 */
  0x0000,   /* U+6564 */
  0x0000,   /* U+6565 */
  0x0000,   /* U+6566 */
  0x0000,   /* U+6567 */
  0x0000,   /* U+6568 */
  0x0000,   /* U+6569 */
  0x0000,   /* U+656A */
  0x0000,   /* U+656B */
  0x0000,   /* U+656C */
  0x0000,   /* U+656D */
  0x0000,   /* U+656E */
  0x0000,   /* U+656F */
  0x0000,   /* U+6570 */
  0x0000,   /* U+6571 */
  0x0000,   /* U+6572 */
  0x0000,   /* U+6573 */
  0x0000,   /* U+6574 */
  0x0000,   /* U+6575 */
  0x0000,   /* U+6576 */
  0x0000,   /* U+6577 */
  0x0000,   /* U+6578 */
  0x0000,   /* U+6579 */
  0x0000,   /* U+657A */
  0x0000,   /* U+657B */
  0x0000,   /* U+657C */
  0x0000,   /* U+657D */
  0x0000,   /* U+657E */
  0x0000,   /* U+657F */
  0x0000,   /* U+6580 */
  0x0000,   /* U+6581 */
  0x0000,   /* U+6582 */
  0x0000,   /* U+6583 */
  0x0000,   /* U+6584 */
  0x0000,   /* U+6585 */
  0x0000,   /* U+6586 */
  0x0000,   /* U+6587 */
  0x0000,   /* U+6588 */
  0x0000,   /* U+6589 */
  0x0000,   /* U+658A */
  0x0000,   /* U+658B */
  0x0000,   /* U+658C */
  0x0000,   /* U+658D */
  0x0000,   /* U+658E */
  0x0000,   /* U+658F */
  0x0000,   /* U+6590 */
  0x0000,   /* U+6591 */
  0x0000,   /* U+6592 */
  0x0000,   /* U+6593 */
  0x0000,   /* U+6594 */
  0x0000,   /* U+6595 */
  0x0000,   /* U+6596 */
  0x0000,   /* U+6597 */
  0x0000,   /* U+6598 */
  0x0000,   /* U+6599 */
  0x0000,   /* U+659A */
  0x0000,   /* U+659B */
  0x0000,   /* U+659C */
  0x0000,   /* U+659D */
  0x0000,   /* U+659E */
  0x0000,   /* U+659F */
  0x0000,   /* U+65A0 */
  0x0000,   /* U+65A1 */
  0x0000,   /* U+65A2 */
  0x0000,   /* U+65A3 */
  0x0000,   /* U+65A4 */
  0x0000,   /* U+65A5 */
  0x0000,   /* U+65A6 */
  0x0000,   /* U+65A7 */
  0x0000,   /* U+65A8 */
  0x0000,   /* U+65A9 */
  0x0000,   /* U+65AA */
  0x0000,   /* U+65AB */
  0x0000,   /* U+65AC */
  0x0000,   /* U+65AD */
  0x0000,   /* U+65AE */
  0x0000,   /* U+65AF */
  0x0000,   /* U+65B0 */
  0x0000,   /* U+65B1 */
  0x0000,   /* U+65B2 */
  0x0000,   /* U+65B3 */
  0x0000,   /* U+65B4 */
  0x0000,   /* U+65B5 */
  0x0000,   /* U+65B6 */
  0x0000,   /* U+65B7 */
  0x0000,   /* U+65B8 */
  0x0000,   /* U+65B9 */
  0x0000,   /* U+65BA */
  0x0000,   /* U+65BB */
  0x0000,   /* U+65BC */
  0x0000,   /* U+65BD */
  0x0000,   /* U+65BE */
  0x0000,   /* U+65BF */
  0x0000,   /* U+65C0 */
  0x0000,   /* U+65C1 */
  0x0000,   /* U+65C2 */
  0x0000,   /* U+65C3 */
  0x0000,   /* U+65C4 */
  0x0000,   /* U+65C5 */
  0x0000,   /* U+65C6 */
  0x0000,   /* U+65C7 */
  0x0000,   /* U+65C8 */
  0x0000,   /* U+65C9 */
  0x0000,   /* U+65CA */
  0x0000,   /* U+65CB */
  0x0000,   /* U+65CC */
  0x0000,   /* U+65CD */
  0x0000,   /* U+65CE */
  0x0000,   /* U+65CF */
  0x0000,   /* U+65D0 */
  0x0000,   /* U+65D1 */
  0x0000,   /* U+65D2 */
  0x0000,   /* U+65D3 */
  0x0000,   /* U+65D4 */
  0x0000,   /* U+65D5 */
  0x0000,   /* U+65D6 */
  0x0000,   /* U+65D7 */
  0x0000,   /* U+65D8 */
  0x0000,   /* U+65D9 */
  0x0000,   /* U+65DA */
  0x0000,   /* U+65DB */
  0x0000,   /* U+65DC */
  0x0000,   /* U+65DD */
  0x0000,   /* U+65DE */
  0x0000,   /* U+65DF */
  0x0000,   /* U+65E0 */
  0x0000,   /* U+65E1 */
  0x0000,   /* U+65E2 */
  0x0000,   /* U+65E3 */
  0x0000,   /* U+65E4 */
  0x0000,   /* U+65E5 */
  0x0000,   /* U+65E6 */
  0x0000,   /* U+65E7 */
  0x0000,   /* U+65E8 */
  0x0000,   /* U+65E9 */
  0x0000,   /* U+65EA */
  0x0000,   /* U+65EB */
  0x0000,   /* U+65EC */
  0x0000,   /* U+65ED */
  0x0000,   /* U+65EE */
  0x0000,   /* U+65EF */
  0x0000,   /* U+65F0 */
  0x0000,   /* U+65F1 */
  0x0000,   /* U+65F2 */
  0x0000,   /* U+65F3 */
  0x0000,   /* U+65F4 */
  0x0000,   /* U+65F5 */
  0x0000,   /* U+65F6 */
  0x0000,   /* U+65F7 */
  0x0000,   /* U+65F8 */
  0x0000,   /* U+65F9 */
  0x0000,   /* U+65FA */
  0x0000,   /* U+65FB */
  0x0000,   /* U+65FC */
  0x0000,   /* U+65FD */
  0x0000,   /* U+65FE */
  0x0000,   /* U+65FF */
};

uint16 ja_han_page66[]= {
  /* Number of CEs for each character. */
  2, 2, 1, 1, 2, 2, 1, 1, 2, 2, 1, 2, 1, 2, 1, 1,
  2, 2, 2, 1, 1, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 1,
  1, 2, 2, 2, 2, 1, 2, 1, 1, 2, 2, 2, 2, 1, 2, 1,
  2, 2, 2, 2, 1, 1, 1, 2, 2, 2, 2, 2, 1, 2, 2, 1,
  2, 1, 1, 1, 1, 2, 2, 2, 2, 1, 2, 1, 2, 2, 2, 1,
  2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1,
  2, 2, 1, 2, 1, 2, 1, 1, 1, 1, 2, 2, 2, 2, 1, 1,
  1, 2, 2, 2, 1, 2, 1, 2, 2, 2, 1, 2, 2, 2, 2, 2,
  2, 1, 2, 1, 1, 2, 2, 1, 1, 1, 2, 2, 2, 2, 1, 2,
  2, 1, 2, 2, 2, 2, 1, 1, 1, 2, 2, 2, 2, 1, 2, 2,
  2, 2, 1, 2, 2, 2, 1, 2, 2, 2, 2, 1, 2, 2, 1, 2,
  2, 2, 2, 2, 1, 2, 2, 2, 1, 1, 2, 2, 1, 2, 1, 2,
  2, 1, 2, 2, 1, 2, 2, 1, 2, 1, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 1, 2, 2, 1, 1, 2, 1, 1, 2, 2,
  1, 2, 2, 2, 2, 2, 1, 2, 2, 1, 2, 2, 2, 2, 2, 2,
  1, 2, 1, 1, 1, 1, 2, 1, 1, 1, 2, 2, 1, 1, 1, 1,

  /* Primary weight 1 for each character. */
  0xFB40,   /* U+6600 */
  0xFB40,   /* U+6601 */
  0x5808,   /* U+6602 */
  0x6424,   /* U+6603 */
  0xFB40,   /* U+6604 */
  0xFB40,   /* U+6605 */
  0x585A,   /* U+6606 */
  0x59E1,   /* U+6607 */
  0xFB40,   /* U+6608 */
  0xFB40,   /* U+6609 */
  0x6423,   /* U+660A */
  0xFB40,   /* U+660B */
  0x59E2,   /* U+660C */
  0xFB40,   /* U+660D */
  0x5F0B,   /* U+660E */
  0x5859,   /* U+660F */
  0xFB40,   /* U+6610 */
  0xFB40,   /* U+6611 */
  0xFB40,   /* U+6612 */
  0x54DA,   /* U+6613 */
  0x5AB1,   /* U+6614 */
  0xFB40,   /* U+6615 */
  0xFB40,   /* U+6616 */
  0xFB40,   /* U+6617 */
  0xFB40,   /* U+6618 */
  0xFB40,   /* U+6619 */
  0xFB40,   /* U+661A */
  0xFB40,   /* U+661B */
  0x642A,   /* U+661C */
  0xFB40,   /* U+661D */
  0xFB40,   /* U+661E */
  0x5A94,   /* U+661F */
  0x5528,   /* U+6620 */
  0xFB40,   /* U+6621 */
  0xFB40,   /* U+6622 */
  0xFB40,   /* U+6623 */
  0xFB40,   /* U+6624 */
  0x599E,   /* U+6625 */
  0xFB40,   /* U+6626 */
  0x5ED3,   /* U+6627 */
  0x58A1,   /* U+6628 */
  0xFB40,   /* U+6629 */
  0xFB40,   /* U+662A */
  0xFB40,   /* U+662B */
  0xFB40,   /* U+662C */
  0x59E3,   /* U+662D */
  0xFB40,   /* U+662E */
  0x5A8A,   /* U+662F */
  0xFB40,   /* U+6630 */
  0xFB40,   /* U+6631 */
  0xFB40,   /* U+6632 */
  0xFB40,   /* U+6633 */
  0x6429,   /* U+6634 */
  0x6427,   /* U+6635 */
  0x6428,   /* U+6636 */
  0xFB40,   /* U+6637 */
  0xFB40,   /* U+6638 */
  0xFB40,   /* U+6639 */
  0xFB40,   /* U+663A */
  0xFB40,   /* U+663B */
  0x5BE8,   /* U+663C */
  0xFB40,   /* U+663D */
  0xFB40,   /* U+663E */
  0x6448,   /* U+663F */
  0xFB40,   /* U+6640 */
  0x642E,   /* U+6641 */
  0x590B,   /* U+6642 */
  0x5809,   /* U+6643 */
  0x642C,   /* U+6644 */
  0xFB40,   /* U+6645 */
  0xFB40,   /* U+6646 */
  0xFB40,   /* U+6647 */
  0xFB40,   /* U+6648 */
  0x642D,   /* U+6649 */
  0xFB40,   /* U+664A */
  0x5A3D,   /* U+664B */
  0xFB40,   /* U+664C */
  0xFB40,   /* U+664D */
  0xFB40,   /* U+664E */
  0x642B,   /* U+664F */
  0xFB40,   /* U+6650 */
  0xFB40,   /* U+6651 */
  0x58BC,   /* U+6652 */
  0xFB40,   /* U+6653 */
  0xFB40,   /* U+6654 */
  0xFB40,   /* U+6655 */
  0xFB40,   /* U+6656 */
  0xFB40,   /* U+6657 */
  0xFB40,   /* U+6658 */
  0xFB40,   /* U+6659 */
  0xFB40,   /* U+665A */
  0xFB40,   /* U+665B */
  0xFB40,   /* U+665C */
  0x6430,   /* U+665D */
  0x642F,   /* U+665E */
  0x6434,   /* U+665F */
  0xFB40,   /* U+6660 */
  0xFB40,   /* U+6661 */
  0x6435,   /* U+6662 */
  0xFB40,   /* U+6663 */
  0x6431,   /* U+6664 */
  0xFB40,   /* U+6665 */
  0x55BF,   /* U+6666 */
  0x6432,   /* U+6667 */
  0x6433,   /* U+6668 */
  0x5DA8,   /* U+6669 */
  0xFB40,   /* U+666A */
  0xFB40,   /* U+666B */
  0xFB40,   /* U+666C */
  0xFB40,   /* U+666D */
  0x5E12,   /* U+666E */
  0x575F,   /* U+666F */
  0x6436,   /* U+6670 */
  0xFB40,   /* U+6671 */
  0xFB40,   /* U+6672 */
  0xFB40,   /* U+6673 */
  0x5A95,   /* U+6674 */
  0xFB40,   /* U+6675 */
  0x59E4,   /* U+6676 */
  0xFB40,   /* U+6677 */
  0xFB40,   /* U+6678 */
  0xFB40,   /* U+6679 */
  0x5BCF,   /* U+667A */
  0xFB40,   /* U+667B */
  0xFB40,   /* U+667C */
  0xFB40,   /* U+667D */
  0xFB40,   /* U+667E */
  0xFB40,   /* U+667F */
  0xFB40,   /* U+6680 */
  0x56FE,   /* U+6681 */
  0xFB40,   /* U+6682 */
  0x6437,   /* U+6683 */
  0x643B,   /* U+6684 */
  0xFB40,   /* U+6685 */
  0xFB40,   /* U+6686 */
  0x558A,   /* U+6687 */
  0x6438,   /* U+6688 */
  0x643A,   /* U+6689 */
  0xFB40,   /* U+668A */
  0xFB40,   /* U+668B */
  0xFB40,   /* U+668C */
  0xFB40,   /* U+668D */
  0x6439,   /* U+668E */
  0xFB40,   /* U+668F */
  0xFB40,   /* U+6690 */
  0x59B4,   /* U+6691 */
  0xFB40,   /* U+6692 */
  0xFB40,   /* U+6693 */
  0xFB40,   /* U+6694 */
  0xFB40,   /* U+6695 */
  0x5BC5,   /* U+6696 */
  0x54C8,   /* U+6697 */
  0x643C,   /* U+6698 */
  0xFB40,   /* U+6699 */
  0xFB40,   /* U+669A */
  0xFB40,   /* U+669B */
  0xFB40,   /* U+669C */
  0x643D,   /* U+669D */
  0xFB40,   /* U+669E */
  0xFB40,   /* U+669F */
  0xFB40,   /* U+66A0 */
  0xFB40,   /* U+66A1 */
  0x5C05,   /* U+66A2 */
  0xFB40,   /* U+66A3 */
  0xFB40,   /* U+66A4 */
  0xFB40,   /* U+66A5 */
  0x5FF8,   /* U+66A6 */
  0xFB40,   /* U+66A7 */
  0xFB40,   /* U+66A8 */
  0xFB40,   /* U+66A9 */
  0xFB40,   /* U+66AA */
  0x58D0,   /* U+66AB */
  0xFB40,   /* U+66AC */
  0xFB40,   /* U+66AD */
  0x5E7A,   /* U+66AE */
  0xFB40,   /* U+66AF */
  0xFB40,   /* U+66B0 */
  0xFB40,   /* U+66B1 */
  0xFB40,   /* U+66B2 */
  0xFB40,   /* U+66B3 */
  0x5EAA,   /* U+66B4 */
  0xFB40,   /* U+66B5 */
  0xFB40,   /* U+66B6 */
  0xFB40,   /* U+66B7 */
  0x6444,   /* U+66B8 */
  0x643F,   /* U+66B9 */
  0xFB40,   /* U+66BA */
  0xFB40,   /* U+66BB */
  0x6442,   /* U+66BC */
  0xFB40,   /* U+66BD */
  0x6441,   /* U+66BE */
  0xFB40,   /* U+66BF */
  0xFB40,   /* U+66C0 */
  0x643E,   /* U+66C1 */
  0xFB40,   /* U+66C2 */
  0xFB40,   /* U+66C3 */
  0x6443,   /* U+66C4 */
  0xFB40,   /* U+66C5 */
  0xFB40,   /* U+66C6 */
  0x5CF5,   /* U+66C7 */
  0xFB40,   /* U+66C8 */
  0x6440,   /* U+66C9 */
  0xFB40,   /* U+66CA */
  0xFB40,   /* U+66CB */
  0xFB40,   /* U+66CC */
  0xFB40,   /* U+66CD */
  0xFB40,   /* U+66CE */
  0xFB40,   /* U+66CF */
  0xFB40,   /* U+66D0 */
  0xFB40,   /* U+66D1 */
  0xFB40,   /* U+66D2 */
  0xFB40,   /* U+66D3 */
  0xFB40,   /* U+66D4 */
  0xFB40,   /* U+66D5 */
  0x6445,   /* U+66D6 */
  0xFB40,   /* U+66D7 */
  0xFB40,   /* U+66D8 */
  0x59B5,   /* U+66D9 */
  0x6446,   /* U+66DA */
  0xFB40,   /* U+66DB */
  0x5F74,   /* U+66DC */
  0x5D6D,   /* U+66DD */
  0xFB40,   /* U+66DE */
  0xFB40,   /* U+66DF */
  0x6447,   /* U+66E0 */
  0xFB40,   /* U+66E1 */
  0xFB40,   /* U+66E2 */
  0xFB40,   /* U+66E3 */
  0xFB40,   /* U+66E4 */
  0xFB40,   /* U+66E5 */
  0x6449,   /* U+66E6 */
  0xFB40,   /* U+66E7 */
  0xFB40,   /* U+66E8 */
  0x644A,   /* U+66E9 */
  0xFB40,   /* U+66EA */
  0xFB40,   /* U+66EB */
  0xFB40,   /* U+66EC */
  0xFB40,   /* U+66ED */
  0xFB40,   /* U+66EE */
  0xFB40,   /* U+66EF */
  0x644B,   /* U+66F0 */
  0xFB40,   /* U+66F1 */
  0x5701,   /* U+66F2 */
  0x5529,   /* U+66F3 */
  0x580A,   /* U+66F4 */
  0x644C,   /* U+66F5 */
  0xFB40,   /* U+66F6 */
  0x644D,   /* U+66F7 */
  0x59BA,   /* U+66F8 */
  0x5B23,   /* U+66F9 */
  0xFB40,   /* U+66FA */
  0xFB40,   /* U+66FB */
  0x612C,   /* U+66FC */
  0x5AFF,   /* U+66FD */
  0x5AFE,   /* U+66FE */
  0x5B77,   /* U+66FF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+6600 */
  0x0020,   /* U+6601 */
  0x0020,   /* U+6602 */
  0x0020,   /* U+6603 */
  0x0020,   /* U+6604 */
  0x0020,   /* U+6605 */
  0x0020,   /* U+6606 */
  0x0020,   /* U+6607 */
  0x0020,   /* U+6608 */
  0x0020,   /* U+6609 */
  0x0020,   /* U+660A */
  0x0020,   /* U+660B */
  0x0020,   /* U+660C */
  0x0020,   /* U+660D */
  0x0020,   /* U+660E */
  0x0020,   /* U+660F */
  0x0020,   /* U+6610 */
  0x0020,   /* U+6611 */
  0x0020,   /* U+6612 */
  0x0020,   /* U+6613 */
  0x0020,   /* U+6614 */
  0x0020,   /* U+6615 */
  0x0020,   /* U+6616 */
  0x0020,   /* U+6617 */
  0x0020,   /* U+6618 */
  0x0020,   /* U+6619 */
  0x0020,   /* U+661A */
  0x0020,   /* U+661B */
  0x0020,   /* U+661C */
  0x0020,   /* U+661D */
  0x0020,   /* U+661E */
  0x0020,   /* U+661F */
  0x0020,   /* U+6620 */
  0x0020,   /* U+6621 */
  0x0020,   /* U+6622 */
  0x0020,   /* U+6623 */
  0x0020,   /* U+6624 */
  0x0020,   /* U+6625 */
  0x0020,   /* U+6626 */
  0x0020,   /* U+6627 */
  0x0020,   /* U+6628 */
  0x0020,   /* U+6629 */
  0x0020,   /* U+662A */
  0x0020,   /* U+662B */
  0x0020,   /* U+662C */
  0x0020,   /* U+662D */
  0x0020,   /* U+662E */
  0x0020,   /* U+662F */
  0x0020,   /* U+6630 */
  0x0020,   /* U+6631 */
  0x0020,   /* U+6632 */
  0x0020,   /* U+6633 */
  0x0020,   /* U+6634 */
  0x0020,   /* U+6635 */
  0x0020,   /* U+6636 */
  0x0020,   /* U+6637 */
  0x0020,   /* U+6638 */
  0x0020,   /* U+6639 */
  0x0020,   /* U+663A */
  0x0020,   /* U+663B */
  0x0020,   /* U+663C */
  0x0020,   /* U+663D */
  0x0020,   /* U+663E */
  0x0020,   /* U+663F */
  0x0020,   /* U+6640 */
  0x0020,   /* U+6641 */
  0x0020,   /* U+6642 */
  0x0020,   /* U+6643 */
  0x0020,   /* U+6644 */
  0x0020,   /* U+6645 */
  0x0020,   /* U+6646 */
  0x0020,   /* U+6647 */
  0x0020,   /* U+6648 */
  0x0020,   /* U+6649 */
  0x0020,   /* U+664A */
  0x0020,   /* U+664B */
  0x0020,   /* U+664C */
  0x0020,   /* U+664D */
  0x0020,   /* U+664E */
  0x0020,   /* U+664F */
  0x0020,   /* U+6650 */
  0x0020,   /* U+6651 */
  0x0020,   /* U+6652 */
  0x0020,   /* U+6653 */
  0x0020,   /* U+6654 */
  0x0020,   /* U+6655 */
  0x0020,   /* U+6656 */
  0x0020,   /* U+6657 */
  0x0020,   /* U+6658 */
  0x0020,   /* U+6659 */
  0x0020,   /* U+665A */
  0x0020,   /* U+665B */
  0x0020,   /* U+665C */
  0x0020,   /* U+665D */
  0x0020,   /* U+665E */
  0x0020,   /* U+665F */
  0x0020,   /* U+6660 */
  0x0020,   /* U+6661 */
  0x0020,   /* U+6662 */
  0x0020,   /* U+6663 */
  0x0020,   /* U+6664 */
  0x0020,   /* U+6665 */
  0x0020,   /* U+6666 */
  0x0020,   /* U+6667 */
  0x0020,   /* U+6668 */
  0x0020,   /* U+6669 */
  0x0020,   /* U+666A */
  0x0020,   /* U+666B */
  0x0020,   /* U+666C */
  0x0020,   /* U+666D */
  0x0020,   /* U+666E */
  0x0020,   /* U+666F */
  0x0020,   /* U+6670 */
  0x0020,   /* U+6671 */
  0x0020,   /* U+6672 */
  0x0020,   /* U+6673 */
  0x0020,   /* U+6674 */
  0x0020,   /* U+6675 */
  0x0020,   /* U+6676 */
  0x0020,   /* U+6677 */
  0x0020,   /* U+6678 */
  0x0020,   /* U+6679 */
  0x0020,   /* U+667A */
  0x0020,   /* U+667B */
  0x0020,   /* U+667C */
  0x0020,   /* U+667D */
  0x0020,   /* U+667E */
  0x0020,   /* U+667F */
  0x0020,   /* U+6680 */
  0x0020,   /* U+6681 */
  0x0020,   /* U+6682 */
  0x0020,   /* U+6683 */
  0x0020,   /* U+6684 */
  0x0020,   /* U+6685 */
  0x0020,   /* U+6686 */
  0x0020,   /* U+6687 */
  0x0020,   /* U+6688 */
  0x0020,   /* U+6689 */
  0x0020,   /* U+668A */
  0x0020,   /* U+668B */
  0x0020,   /* U+668C */
  0x0020,   /* U+668D */
  0x0020,   /* U+668E */
  0x0020,   /* U+668F */
  0x0020,   /* U+6690 */
  0x0020,   /* U+6691 */
  0x0020,   /* U+6692 */
  0x0020,   /* U+6693 */
  0x0020,   /* U+6694 */
  0x0020,   /* U+6695 */
  0x0020,   /* U+6696 */
  0x0020,   /* U+6697 */
  0x0020,   /* U+6698 */
  0x0020,   /* U+6699 */
  0x0020,   /* U+669A */
  0x0020,   /* U+669B */
  0x0020,   /* U+669C */
  0x0020,   /* U+669D */
  0x0020,   /* U+669E */
  0x0020,   /* U+669F */
  0x0020,   /* U+66A0 */
  0x0020,   /* U+66A1 */
  0x0020,   /* U+66A2 */
  0x0020,   /* U+66A3 */
  0x0020,   /* U+66A4 */
  0x0020,   /* U+66A5 */
  0x0020,   /* U+66A6 */
  0x0020,   /* U+66A7 */
  0x0020,   /* U+66A8 */
  0x0020,   /* U+66A9 */
  0x0020,   /* U+66AA */
  0x0020,   /* U+66AB */
  0x0020,   /* U+66AC */
  0x0020,   /* U+66AD */
  0x0020,   /* U+66AE */
  0x0020,   /* U+66AF */
  0x0020,   /* U+66B0 */
  0x0020,   /* U+66B1 */
  0x0020,   /* U+66B2 */
  0x0020,   /* U+66B3 */
  0x0020,   /* U+66B4 */
  0x0020,   /* U+66B5 */
  0x0020,   /* U+66B6 */
  0x0020,   /* U+66B7 */
  0x0020,   /* U+66B8 */
  0x0020,   /* U+66B9 */
  0x0020,   /* U+66BA */
  0x0020,   /* U+66BB */
  0x0020,   /* U+66BC */
  0x0020,   /* U+66BD */
  0x0020,   /* U+66BE */
  0x0020,   /* U+66BF */
  0x0020,   /* U+66C0 */
  0x0020,   /* U+66C1 */
  0x0020,   /* U+66C2 */
  0x0020,   /* U+66C3 */
  0x0020,   /* U+66C4 */
  0x0020,   /* U+66C5 */
  0x0020,   /* U+66C6 */
  0x0020,   /* U+66C7 */
  0x0020,   /* U+66C8 */
  0x0020,   /* U+66C9 */
  0x0020,   /* U+66CA */
  0x0020,   /* U+66CB */
  0x0020,   /* U+66CC */
  0x0020,   /* U+66CD */
  0x0020,   /* U+66CE */
  0x0020,   /* U+66CF */
  0x0020,   /* U+66D0 */
  0x0020,   /* U+66D1 */
  0x0020,   /* U+66D2 */
  0x0020,   /* U+66D3 */
  0x0020,   /* U+66D4 */
  0x0020,   /* U+66D5 */
  0x0020,   /* U+66D6 */
  0x0020,   /* U+66D7 */
  0x0020,   /* U+66D8 */
  0x0020,   /* U+66D9 */
  0x0020,   /* U+66DA */
  0x0020,   /* U+66DB */
  0x0020,   /* U+66DC */
  0x0020,   /* U+66DD */
  0x0020,   /* U+66DE */
  0x0020,   /* U+66DF */
  0x0020,   /* U+66E0 */
  0x0020,   /* U+66E1 */
  0x0020,   /* U+66E2 */
  0x0020,   /* U+66E3 */
  0x0020,   /* U+66E4 */
  0x0020,   /* U+66E5 */
  0x0020,   /* U+66E6 */
  0x0020,   /* U+66E7 */
  0x0020,   /* U+66E8 */
  0x0020,   /* U+66E9 */
  0x0020,   /* U+66EA */
  0x0020,   /* U+66EB */
  0x0020,   /* U+66EC */
  0x0020,   /* U+66ED */
  0x0020,   /* U+66EE */
  0x0020,   /* U+66EF */
  0x0020,   /* U+66F0 */
  0x0020,   /* U+66F1 */
  0x0020,   /* U+66F2 */
  0x0020,   /* U+66F3 */
  0x0020,   /* U+66F4 */
  0x0020,   /* U+66F5 */
  0x0020,   /* U+66F6 */
  0x0020,   /* U+66F7 */
  0x0020,   /* U+66F8 */
  0x0020,   /* U+66F9 */
  0x0020,   /* U+66FA */
  0x0020,   /* U+66FB */
  0x0020,   /* U+66FC */
  0x0020,   /* U+66FD */
  0x0020,   /* U+66FE */
  0x0020,   /* U+66FF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+6600 */
  0x0002,   /* U+6601 */
  0x0002,   /* U+6602 */
  0x0002,   /* U+6603 */
  0x0002,   /* U+6604 */
  0x0002,   /* U+6605 */
  0x0002,   /* U+6606 */
  0x0002,   /* U+6607 */
  0x0002,   /* U+6608 */
  0x0002,   /* U+6609 */
  0x0002,   /* U+660A */
  0x0002,   /* U+660B */
  0x0002,   /* U+660C */
  0x0002,   /* U+660D */
  0x0002,   /* U+660E */
  0x0002,   /* U+660F */
  0x0002,   /* U+6610 */
  0x0002,   /* U+6611 */
  0x0002,   /* U+6612 */
  0x0002,   /* U+6613 */
  0x0002,   /* U+6614 */
  0x0002,   /* U+6615 */
  0x0002,   /* U+6616 */
  0x0002,   /* U+6617 */
  0x0002,   /* U+6618 */
  0x0002,   /* U+6619 */
  0x0002,   /* U+661A */
  0x0002,   /* U+661B */
  0x0002,   /* U+661C */
  0x0002,   /* U+661D */
  0x0002,   /* U+661E */
  0x0002,   /* U+661F */
  0x0002,   /* U+6620 */
  0x0002,   /* U+6621 */
  0x0002,   /* U+6622 */
  0x0002,   /* U+6623 */
  0x0002,   /* U+6624 */
  0x0002,   /* U+6625 */
  0x0002,   /* U+6626 */
  0x0002,   /* U+6627 */
  0x0002,   /* U+6628 */
  0x0002,   /* U+6629 */
  0x0002,   /* U+662A */
  0x0002,   /* U+662B */
  0x0002,   /* U+662C */
  0x0002,   /* U+662D */
  0x0002,   /* U+662E */
  0x0002,   /* U+662F */
  0x0002,   /* U+6630 */
  0x0002,   /* U+6631 */
  0x0002,   /* U+6632 */
  0x0002,   /* U+6633 */
  0x0002,   /* U+6634 */
  0x0002,   /* U+6635 */
  0x0002,   /* U+6636 */
  0x0002,   /* U+6637 */
  0x0002,   /* U+6638 */
  0x0002,   /* U+6639 */
  0x0002,   /* U+663A */
  0x0002,   /* U+663B */
  0x0002,   /* U+663C */
  0x0002,   /* U+663D */
  0x0002,   /* U+663E */
  0x0002,   /* U+663F */
  0x0002,   /* U+6640 */
  0x0002,   /* U+6641 */
  0x0002,   /* U+6642 */
  0x0002,   /* U+6643 */
  0x0002,   /* U+6644 */
  0x0002,   /* U+6645 */
  0x0002,   /* U+6646 */
  0x0002,   /* U+6647 */
  0x0002,   /* U+6648 */
  0x0002,   /* U+6649 */
  0x0002,   /* U+664A */
  0x0002,   /* U+664B */
  0x0002,   /* U+664C */
  0x0002,   /* U+664D */
  0x0002,   /* U+664E */
  0x0002,   /* U+664F */
  0x0002,   /* U+6650 */
  0x0002,   /* U+6651 */
  0x0002,   /* U+6652 */
  0x0002,   /* U+6653 */
  0x0002,   /* U+6654 */
  0x0002,   /* U+6655 */
  0x0002,   /* U+6656 */
  0x0002,   /* U+6657 */
  0x0002,   /* U+6658 */
  0x0002,   /* U+6659 */
  0x0002,   /* U+665A */
  0x0002,   /* U+665B */
  0x0002,   /* U+665C */
  0x0002,   /* U+665D */
  0x0002,   /* U+665E */
  0x0002,   /* U+665F */
  0x0002,   /* U+6660 */
  0x0002,   /* U+6661 */
  0x0002,   /* U+6662 */
  0x0002,   /* U+6663 */
  0x0002,   /* U+6664 */
  0x0002,   /* U+6665 */
  0x0002,   /* U+6666 */
  0x0002,   /* U+6667 */
  0x0002,   /* U+6668 */
  0x0002,   /* U+6669 */
  0x0002,   /* U+666A */
  0x0002,   /* U+666B */
  0x0002,   /* U+666C */
  0x0002,   /* U+666D */
  0x0002,   /* U+666E */
  0x0002,   /* U+666F */
  0x0002,   /* U+6670 */
  0x0002,   /* U+6671 */
  0x0002,   /* U+6672 */
  0x0002,   /* U+6673 */
  0x0002,   /* U+6674 */
  0x0002,   /* U+6675 */
  0x0002,   /* U+6676 */
  0x0002,   /* U+6677 */
  0x0002,   /* U+6678 */
  0x0002,   /* U+6679 */
  0x0002,   /* U+667A */
  0x0002,   /* U+667B */
  0x0002,   /* U+667C */
  0x0002,   /* U+667D */
  0x0002,   /* U+667E */
  0x0002,   /* U+667F */
  0x0002,   /* U+6680 */
  0x0002,   /* U+6681 */
  0x0002,   /* U+6682 */
  0x0002,   /* U+6683 */
  0x0002,   /* U+6684 */
  0x0002,   /* U+6685 */
  0x0002,   /* U+6686 */
  0x0002,   /* U+6687 */
  0x0002,   /* U+6688 */
  0x0002,   /* U+6689 */
  0x0002,   /* U+668A */
  0x0002,   /* U+668B */
  0x0002,   /* U+668C */
  0x0002,   /* U+668D */
  0x0002,   /* U+668E */
  0x0002,   /* U+668F */
  0x0002,   /* U+6690 */
  0x0002,   /* U+6691 */
  0x0002,   /* U+6692 */
  0x0002,   /* U+6693 */
  0x0002,   /* U+6694 */
  0x0002,   /* U+6695 */
  0x0002,   /* U+6696 */
  0x0002,   /* U+6697 */
  0x0002,   /* U+6698 */
  0x0002,   /* U+6699 */
  0x0002,   /* U+669A */
  0x0002,   /* U+669B */
  0x0002,   /* U+669C */
  0x0002,   /* U+669D */
  0x0002,   /* U+669E */
  0x0002,   /* U+669F */
  0x0002,   /* U+66A0 */
  0x0002,   /* U+66A1 */
  0x0002,   /* U+66A2 */
  0x0002,   /* U+66A3 */
  0x0002,   /* U+66A4 */
  0x0002,   /* U+66A5 */
  0x0002,   /* U+66A6 */
  0x0002,   /* U+66A7 */
  0x0002,   /* U+66A8 */
  0x0002,   /* U+66A9 */
  0x0002,   /* U+66AA */
  0x0002,   /* U+66AB */
  0x0002,   /* U+66AC */
  0x0002,   /* U+66AD */
  0x0002,   /* U+66AE */
  0x0002,   /* U+66AF */
  0x0002,   /* U+66B0 */
  0x0002,   /* U+66B1 */
  0x0002,   /* U+66B2 */
  0x0002,   /* U+66B3 */
  0x0002,   /* U+66B4 */
  0x0002,   /* U+66B5 */
  0x0002,   /* U+66B6 */
  0x0002,   /* U+66B7 */
  0x0002,   /* U+66B8 */
  0x0002,   /* U+66B9 */
  0x0002,   /* U+66BA */
  0x0002,   /* U+66BB */
  0x0002,   /* U+66BC */
  0x0002,   /* U+66BD */
  0x0002,   /* U+66BE */
  0x0002,   /* U+66BF */
  0x0002,   /* U+66C0 */
  0x0002,   /* U+66C1 */
  0x0002,   /* U+66C2 */
  0x0002,   /* U+66C3 */
  0x0002,   /* U+66C4 */
  0x0002,   /* U+66C5 */
  0x0002,   /* U+66C6 */
  0x0002,   /* U+66C7 */
  0x0002,   /* U+66C8 */
  0x0002,   /* U+66C9 */
  0x0002,   /* U+66CA */
  0x0002,   /* U+66CB */
  0x0002,   /* U+66CC */
  0x0002,   /* U+66CD */
  0x0002,   /* U+66CE */
  0x0002,   /* U+66CF */
  0x0002,   /* U+66D0 */
  0x0002,   /* U+66D1 */
  0x0002,   /* U+66D2 */
  0x0002,   /* U+66D3 */
  0x0002,   /* U+66D4 */
  0x0002,   /* U+66D5 */
  0x0002,   /* U+66D6 */
  0x0002,   /* U+66D7 */
  0x0002,   /* U+66D8 */
  0x0002,   /* U+66D9 */
  0x0002,   /* U+66DA */
  0x0002,   /* U+66DB */
  0x0002,   /* U+66DC */
  0x0002,   /* U+66DD */
  0x0002,   /* U+66DE */
  0x0002,   /* U+66DF */
  0x0002,   /* U+66E0 */
  0x0002,   /* U+66E1 */
  0x0002,   /* U+66E2 */
  0x0002,   /* U+66E3 */
  0x0002,   /* U+66E4 */
  0x0002,   /* U+66E5 */
  0x0002,   /* U+66E6 */
  0x0002,   /* U+66E7 */
  0x0002,   /* U+66E8 */
  0x0002,   /* U+66E9 */
  0x0002,   /* U+66EA */
  0x0002,   /* U+66EB */
  0x0002,   /* U+66EC */
  0x0002,   /* U+66ED */
  0x0002,   /* U+66EE */
  0x0002,   /* U+66EF */
  0x0002,   /* U+66F0 */
  0x0002,   /* U+66F1 */
  0x0002,   /* U+66F2 */
  0x0002,   /* U+66F3 */
  0x0002,   /* U+66F4 */
  0x0002,   /* U+66F5 */
  0x0002,   /* U+66F6 */
  0x0002,   /* U+66F7 */
  0x0002,   /* U+66F8 */
  0x0002,   /* U+66F9 */
  0x0002,   /* U+66FA */
  0x0002,   /* U+66FB */
  0x0002,   /* U+66FC */
  0x0002,   /* U+66FD */
  0x0002,   /* U+66FE */
  0x0002,   /* U+66FF */

  /* Primary weight 2 for each character. */
  0xE600,   /* U+6600 */
  0xE601,   /* U+6601 */
  0x0000,   /* U+6602 */
  0x0000,   /* U+6603 */
  0xE604,   /* U+6604 */
  0xE605,   /* U+6605 */
  0x0000,   /* U+6606 */
  0x0000,   /* U+6607 */
  0xE608,   /* U+6608 */
  0xE609,   /* U+6609 */
  0x0000,   /* U+660A */
  0xE60B,   /* U+660B */
  0x0000,   /* U+660C */
  0xE60D,   /* U+660D */
  0x0000,   /* U+660E */
  0x0000,   /* U+660F */
  0xE610,   /* U+6610 */
  0xE611,   /* U+6611 */
  0xE612,   /* U+6612 */
  0x0000,   /* U+6613 */
  0x0000,   /* U+6614 */
  0xE615,   /* U+6615 */
  0xE616,   /* U+6616 */
  0xE617,   /* U+6617 */
  0xE618,   /* U+6618 */
  0xE619,   /* U+6619 */
  0xE61A,   /* U+661A */
  0xE61B,   /* U+661B */
  0x0000,   /* U+661C */
  0xE61D,   /* U+661D */
  0xE61E,   /* U+661E */
  0x0000,   /* U+661F */
  0x0000,   /* U+6620 */
  0xE621,   /* U+6621 */
  0xE622,   /* U+6622 */
  0xE623,   /* U+6623 */
  0xE624,   /* U+6624 */
  0x0000,   /* U+6625 */
  0xE626,   /* U+6626 */
  0x0000,   /* U+6627 */
  0x0000,   /* U+6628 */
  0xE629,   /* U+6629 */
  0xE62A,   /* U+662A */
  0xE62B,   /* U+662B */
  0xE62C,   /* U+662C */
  0x0000,   /* U+662D */
  0xE62E,   /* U+662E */
  0x0000,   /* U+662F */
  0xE630,   /* U+6630 */
  0xE631,   /* U+6631 */
  0xE632,   /* U+6632 */
  0xE633,   /* U+6633 */
  0x0000,   /* U+6634 */
  0x0000,   /* U+6635 */
  0x0000,   /* U+6636 */
  0xE637,   /* U+6637 */
  0xE638,   /* U+6638 */
  0xE639,   /* U+6639 */
  0xE63A,   /* U+663A */
  0xE63B,   /* U+663B */
  0x0000,   /* U+663C */
  0xE63D,   /* U+663D */
  0xE63E,   /* U+663E */
  0x0000,   /* U+663F */
  0xE640,   /* U+6640 */
  0x0000,   /* U+6641 */
  0x0000,   /* U+6642 */
  0x0000,   /* U+6643 */
  0x0000,   /* U+6644 */
  0xE645,   /* U+6645 */
  0xE646,   /* U+6646 */
  0xE647,   /* U+6647 */
  0xE648,   /* U+6648 */
  0x0000,   /* U+6649 */
  0xE64A,   /* U+664A */
  0x0000,   /* U+664B */
  0xE64C,   /* U+664C */
  0xE64D,   /* U+664D */
  0xE64E,   /* U+664E */
  0x0000,   /* U+664F */
  0xE650,   /* U+6650 */
  0xE651,   /* U+6651 */
  0x0000,   /* U+6652 */
  0xE653,   /* U+6653 */
  0xE654,   /* U+6654 */
  0xE655,   /* U+6655 */
  0xE656,   /* U+6656 */
  0xE657,   /* U+6657 */
  0xE658,   /* U+6658 */
  0xE659,   /* U+6659 */
  0xE65A,   /* U+665A */
  0xE65B,   /* U+665B */
  0xE65C,   /* U+665C */
  0x0000,   /* U+665D */
  0x0000,   /* U+665E */
  0x0000,   /* U+665F */
  0xE660,   /* U+6660 */
  0xE661,   /* U+6661 */
  0x0000,   /* U+6662 */
  0xE663,   /* U+6663 */
  0x0000,   /* U+6664 */
  0xE665,   /* U+6665 */
  0x0000,   /* U+6666 */
  0x0000,   /* U+6667 */
  0x0000,   /* U+6668 */
  0x0000,   /* U+6669 */
  0xE66A,   /* U+666A */
  0xE66B,   /* U+666B */
  0xE66C,   /* U+666C */
  0xE66D,   /* U+666D */
  0x0000,   /* U+666E */
  0x0000,   /* U+666F */
  0x0000,   /* U+6670 */
  0xE671,   /* U+6671 */
  0xE672,   /* U+6672 */
  0xE673,   /* U+6673 */
  0x0000,   /* U+6674 */
  0xE675,   /* U+6675 */
  0x0000,   /* U+6676 */
  0xE677,   /* U+6677 */
  0xE678,   /* U+6678 */
  0xE679,   /* U+6679 */
  0x0000,   /* U+667A */
  0xE67B,   /* U+667B */
  0xE67C,   /* U+667C */
  0xE67D,   /* U+667D */
  0xE67E,   /* U+667E */
  0xE67F,   /* U+667F */
  0xE680,   /* U+6680 */
  0x0000,   /* U+6681 */
  0xE682,   /* U+6682 */
  0x0000,   /* U+6683 */
  0x0000,   /* U+6684 */
  0xE685,   /* U+6685 */
  0xE686,   /* U+6686 */
  0x0000,   /* U+6687 */
  0x0000,   /* U+6688 */
  0x0000,   /* U+6689 */
  0xE68A,   /* U+668A */
  0xE68B,   /* U+668B */
  0xE68C,   /* U+668C */
  0xE68D,   /* U+668D */
  0x0000,   /* U+668E */
  0xE68F,   /* U+668F */
  0xE690,   /* U+6690 */
  0x0000,   /* U+6691 */
  0xE692,   /* U+6692 */
  0xE693,   /* U+6693 */
  0xE694,   /* U+6694 */
  0xE695,   /* U+6695 */
  0x0000,   /* U+6696 */
  0x0000,   /* U+6697 */
  0x0000,   /* U+6698 */
  0xE699,   /* U+6699 */
  0xE69A,   /* U+669A */
  0xE69B,   /* U+669B */
  0xE69C,   /* U+669C */
  0x0000,   /* U+669D */
  0xE69E,   /* U+669E */
  0xE69F,   /* U+669F */
  0xE6A0,   /* U+66A0 */
  0xE6A1,   /* U+66A1 */
  0x0000,   /* U+66A2 */
  0xE6A3,   /* U+66A3 */
  0xE6A4,   /* U+66A4 */
  0xE6A5,   /* U+66A5 */
  0x0000,   /* U+66A6 */
  0xE6A7,   /* U+66A7 */
  0xE6A8,   /* U+66A8 */
  0xE6A9,   /* U+66A9 */
  0xE6AA,   /* U+66AA */
  0x0000,   /* U+66AB */
  0xE6AC,   /* U+66AC */
  0xE6AD,   /* U+66AD */
  0x0000,   /* U+66AE */
  0xE6AF,   /* U+66AF */
  0xE6B0,   /* U+66B0 */
  0xE6B1,   /* U+66B1 */
  0xE6B2,   /* U+66B2 */
  0xE6B3,   /* U+66B3 */
  0x0000,   /* U+66B4 */
  0xE6B5,   /* U+66B5 */
  0xE6B6,   /* U+66B6 */
  0xE6B7,   /* U+66B7 */
  0x0000,   /* U+66B8 */
  0x0000,   /* U+66B9 */
  0xE6BA,   /* U+66BA */
  0xE6BB,   /* U+66BB */
  0x0000,   /* U+66BC */
  0xE6BD,   /* U+66BD */
  0x0000,   /* U+66BE */
  0xE6BF,   /* U+66BF */
  0xE6C0,   /* U+66C0 */
  0x0000,   /* U+66C1 */
  0xE6C2,   /* U+66C2 */
  0xE6C3,   /* U+66C3 */
  0x0000,   /* U+66C4 */
  0xE6C5,   /* U+66C5 */
  0xE6C6,   /* U+66C6 */
  0x0000,   /* U+66C7 */
  0xE6C8,   /* U+66C8 */
  0x0000,   /* U+66C9 */
  0xE6CA,   /* U+66CA */
  0xE6CB,   /* U+66CB */
  0xE6CC,   /* U+66CC */
  0xE6CD,   /* U+66CD */
  0xE6CE,   /* U+66CE */
  0xE6CF,   /* U+66CF */
  0xE6D0,   /* U+66D0 */
  0xE6D1,   /* U+66D1 */
  0xE6D2,   /* U+66D2 */
  0xE6D3,   /* U+66D3 */
  0xE6D4,   /* U+66D4 */
  0xE6D5,   /* U+66D5 */
  0x0000,   /* U+66D6 */
  0xE6D7,   /* U+66D7 */
  0xE6D8,   /* U+66D8 */
  0x0000,   /* U+66D9 */
  0x0000,   /* U+66DA */
  0xE6DB,   /* U+66DB */
  0x0000,   /* U+66DC */
  0x0000,   /* U+66DD */
  0xE6DE,   /* U+66DE */
  0xE6DF,   /* U+66DF */
  0x0000,   /* U+66E0 */
  0xE6E1,   /* U+66E1 */
  0xE6E2,   /* U+66E2 */
  0xE6E3,   /* U+66E3 */
  0xE6E4,   /* U+66E4 */
  0xE6E5,   /* U+66E5 */
  0x0000,   /* U+66E6 */
  0xE6E7,   /* U+66E7 */
  0xE6E8,   /* U+66E8 */
  0x0000,   /* U+66E9 */
  0xE6EA,   /* U+66EA */
  0xE6EB,   /* U+66EB */
  0xE6EC,   /* U+66EC */
  0xE6ED,   /* U+66ED */
  0xE6EE,   /* U+66EE */
  0xE6EF,   /* U+66EF */
  0x0000,   /* U+66F0 */
  0xE6F1,   /* U+66F1 */
  0x0000,   /* U+66F2 */
  0x0000,   /* U+66F3 */
  0x0000,   /* U+66F4 */
  0x0000,   /* U+66F5 */
  0xE6F6,   /* U+66F6 */
  0x0000,   /* U+66F7 */
  0x0000,   /* U+66F8 */
  0x0000,   /* U+66F9 */
  0xE6FA,   /* U+66FA */
  0xE6FB,   /* U+66FB */
  0x0000,   /* U+66FC */
  0x0000,   /* U+66FD */
  0x0000,   /* U+66FE */
  0x0000,   /* U+66FF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+6600 */
  0x0000,   /* U+6601 */
  0x0000,   /* U+6602 */
  0x0000,   /* U+6603 */
  0x0000,   /* U+6604 */
  0x0000,   /* U+6605 */
  0x0000,   /* U+6606 */
  0x0000,   /* U+6607 */
  0x0000,   /* U+6608 */
  0x0000,   /* U+6609 */
  0x0000,   /* U+660A */
  0x0000,   /* U+660B */
  0x0000,   /* U+660C */
  0x0000,   /* U+660D */
  0x0000,   /* U+660E */
  0x0000,   /* U+660F */
  0x0000,   /* U+6610 */
  0x0000,   /* U+6611 */
  0x0000,   /* U+6612 */
  0x0000,   /* U+6613 */
  0x0000,   /* U+6614 */
  0x0000,   /* U+6615 */
  0x0000,   /* U+6616 */
  0x0000,   /* U+6617 */
  0x0000,   /* U+6618 */
  0x0000,   /* U+6619 */
  0x0000,   /* U+661A */
  0x0000,   /* U+661B */
  0x0000,   /* U+661C */
  0x0000,   /* U+661D */
  0x0000,   /* U+661E */
  0x0000,   /* U+661F */
  0x0000,   /* U+6620 */
  0x0000,   /* U+6621 */
  0x0000,   /* U+6622 */
  0x0000,   /* U+6623 */
  0x0000,   /* U+6624 */
  0x0000,   /* U+6625 */
  0x0000,   /* U+6626 */
  0x0000,   /* U+6627 */
  0x0000,   /* U+6628 */
  0x0000,   /* U+6629 */
  0x0000,   /* U+662A */
  0x0000,   /* U+662B */
  0x0000,   /* U+662C */
  0x0000,   /* U+662D */
  0x0000,   /* U+662E */
  0x0000,   /* U+662F */
  0x0000,   /* U+6630 */
  0x0000,   /* U+6631 */
  0x0000,   /* U+6632 */
  0x0000,   /* U+6633 */
  0x0000,   /* U+6634 */
  0x0000,   /* U+6635 */
  0x0000,   /* U+6636 */
  0x0000,   /* U+6637 */
  0x0000,   /* U+6638 */
  0x0000,   /* U+6639 */
  0x0000,   /* U+663A */
  0x0000,   /* U+663B */
  0x0000,   /* U+663C */
  0x0000,   /* U+663D */
  0x0000,   /* U+663E */
  0x0000,   /* U+663F */
  0x0000,   /* U+6640 */
  0x0000,   /* U+6641 */
  0x0000,   /* U+6642 */
  0x0000,   /* U+6643 */
  0x0000,   /* U+6644 */
  0x0000,   /* U+6645 */
  0x0000,   /* U+6646 */
  0x0000,   /* U+6647 */
  0x0000,   /* U+6648 */
  0x0000,   /* U+6649 */
  0x0000,   /* U+664A */
  0x0000,   /* U+664B */
  0x0000,   /* U+664C */
  0x0000,   /* U+664D */
  0x0000,   /* U+664E */
  0x0000,   /* U+664F */
  0x0000,   /* U+6650 */
  0x0000,   /* U+6651 */
  0x0000,   /* U+6652 */
  0x0000,   /* U+6653 */
  0x0000,   /* U+6654 */
  0x0000,   /* U+6655 */
  0x0000,   /* U+6656 */
  0x0000,   /* U+6657 */
  0x0000,   /* U+6658 */
  0x0000,   /* U+6659 */
  0x0000,   /* U+665A */
  0x0000,   /* U+665B */
  0x0000,   /* U+665C */
  0x0000,   /* U+665D */
  0x0000,   /* U+665E */
  0x0000,   /* U+665F */
  0x0000,   /* U+6660 */
  0x0000,   /* U+6661 */
  0x0000,   /* U+6662 */
  0x0000,   /* U+6663 */
  0x0000,   /* U+6664 */
  0x0000,   /* U+6665 */
  0x0000,   /* U+6666 */
  0x0000,   /* U+6667 */
  0x0000,   /* U+6668 */
  0x0000,   /* U+6669 */
  0x0000,   /* U+666A */
  0x0000,   /* U+666B */
  0x0000,   /* U+666C */
  0x0000,   /* U+666D */
  0x0000,   /* U+666E */
  0x0000,   /* U+666F */
  0x0000,   /* U+6670 */
  0x0000,   /* U+6671 */
  0x0000,   /* U+6672 */
  0x0000,   /* U+6673 */
  0x0000,   /* U+6674 */
  0x0000,   /* U+6675 */
  0x0000,   /* U+6676 */
  0x0000,   /* U+6677 */
  0x0000,   /* U+6678 */
  0x0000,   /* U+6679 */
  0x0000,   /* U+667A */
  0x0000,   /* U+667B */
  0x0000,   /* U+667C */
  0x0000,   /* U+667D */
  0x0000,   /* U+667E */
  0x0000,   /* U+667F */
  0x0000,   /* U+6680 */
  0x0000,   /* U+6681 */
  0x0000,   /* U+6682 */
  0x0000,   /* U+6683 */
  0x0000,   /* U+6684 */
  0x0000,   /* U+6685 */
  0x0000,   /* U+6686 */
  0x0000,   /* U+6687 */
  0x0000,   /* U+6688 */
  0x0000,   /* U+6689 */
  0x0000,   /* U+668A */
  0x0000,   /* U+668B */
  0x0000,   /* U+668C */
  0x0000,   /* U+668D */
  0x0000,   /* U+668E */
  0x0000,   /* U+668F */
  0x0000,   /* U+6690 */
  0x0000,   /* U+6691 */
  0x0000,   /* U+6692 */
  0x0000,   /* U+6693 */
  0x0000,   /* U+6694 */
  0x0000,   /* U+6695 */
  0x0000,   /* U+6696 */
  0x0000,   /* U+6697 */
  0x0000,   /* U+6698 */
  0x0000,   /* U+6699 */
  0x0000,   /* U+669A */
  0x0000,   /* U+669B */
  0x0000,   /* U+669C */
  0x0000,   /* U+669D */
  0x0000,   /* U+669E */
  0x0000,   /* U+669F */
  0x0000,   /* U+66A0 */
  0x0000,   /* U+66A1 */
  0x0000,   /* U+66A2 */
  0x0000,   /* U+66A3 */
  0x0000,   /* U+66A4 */
  0x0000,   /* U+66A5 */
  0x0000,   /* U+66A6 */
  0x0000,   /* U+66A7 */
  0x0000,   /* U+66A8 */
  0x0000,   /* U+66A9 */
  0x0000,   /* U+66AA */
  0x0000,   /* U+66AB */
  0x0000,   /* U+66AC */
  0x0000,   /* U+66AD */
  0x0000,   /* U+66AE */
  0x0000,   /* U+66AF */
  0x0000,   /* U+66B0 */
  0x0000,   /* U+66B1 */
  0x0000,   /* U+66B2 */
  0x0000,   /* U+66B3 */
  0x0000,   /* U+66B4 */
  0x0000,   /* U+66B5 */
  0x0000,   /* U+66B6 */
  0x0000,   /* U+66B7 */
  0x0000,   /* U+66B8 */
  0x0000,   /* U+66B9 */
  0x0000,   /* U+66BA */
  0x0000,   /* U+66BB */
  0x0000,   /* U+66BC */
  0x0000,   /* U+66BD */
  0x0000,   /* U+66BE */
  0x0000,   /* U+66BF */
  0x0000,   /* U+66C0 */
  0x0000,   /* U+66C1 */
  0x0000,   /* U+66C2 */
  0x0000,   /* U+66C3 */
  0x0000,   /* U+66C4 */
  0x0000,   /* U+66C5 */
  0x0000,   /* U+66C6 */
  0x0000,   /* U+66C7 */
  0x0000,   /* U+66C8 */
  0x0000,   /* U+66C9 */
  0x0000,   /* U+66CA */
  0x0000,   /* U+66CB */
  0x0000,   /* U+66CC */
  0x0000,   /* U+66CD */
  0x0000,   /* U+66CE */
  0x0000,   /* U+66CF */
  0x0000,   /* U+66D0 */
  0x0000,   /* U+66D1 */
  0x0000,   /* U+66D2 */
  0x0000,   /* U+66D3 */
  0x0000,   /* U+66D4 */
  0x0000,   /* U+66D5 */
  0x0000,   /* U+66D6 */
  0x0000,   /* U+66D7 */
  0x0000,   /* U+66D8 */
  0x0000,   /* U+66D9 */
  0x0000,   /* U+66DA */
  0x0000,   /* U+66DB */
  0x0000,   /* U+66DC */
  0x0000,   /* U+66DD */
  0x0000,   /* U+66DE */
  0x0000,   /* U+66DF */
  0x0000,   /* U+66E0 */
  0x0000,   /* U+66E1 */
  0x0000,   /* U+66E2 */
  0x0000,   /* U+66E3 */
  0x0000,   /* U+66E4 */
  0x0000,   /* U+66E5 */
  0x0000,   /* U+66E6 */
  0x0000,   /* U+66E7 */
  0x0000,   /* U+66E8 */
  0x0000,   /* U+66E9 */
  0x0000,   /* U+66EA */
  0x0000,   /* U+66EB */
  0x0000,   /* U+66EC */
  0x0000,   /* U+66ED */
  0x0000,   /* U+66EE */
  0x0000,   /* U+66EF */
  0x0000,   /* U+66F0 */
  0x0000,   /* U+66F1 */
  0x0000,   /* U+66F2 */
  0x0000,   /* U+66F3 */
  0x0000,   /* U+66F4 */
  0x0000,   /* U+66F5 */
  0x0000,   /* U+66F6 */
  0x0000,   /* U+66F7 */
  0x0000,   /* U+66F8 */
  0x0000,   /* U+66F9 */
  0x0000,   /* U+66FA */
  0x0000,   /* U+66FB */
  0x0000,   /* U+66FC */
  0x0000,   /* U+66FD */
  0x0000,   /* U+66FE */
  0x0000,   /* U+66FF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+6600 */
  0x0000,   /* U+6601 */
  0x0000,   /* U+6602 */
  0x0000,   /* U+6603 */
  0x0000,   /* U+6604 */
  0x0000,   /* U+6605 */
  0x0000,   /* U+6606 */
  0x0000,   /* U+6607 */
  0x0000,   /* U+6608 */
  0x0000,   /* U+6609 */
  0x0000,   /* U+660A */
  0x0000,   /* U+660B */
  0x0000,   /* U+660C */
  0x0000,   /* U+660D */
  0x0000,   /* U+660E */
  0x0000,   /* U+660F */
  0x0000,   /* U+6610 */
  0x0000,   /* U+6611 */
  0x0000,   /* U+6612 */
  0x0000,   /* U+6613 */
  0x0000,   /* U+6614 */
  0x0000,   /* U+6615 */
  0x0000,   /* U+6616 */
  0x0000,   /* U+6617 */
  0x0000,   /* U+6618 */
  0x0000,   /* U+6619 */
  0x0000,   /* U+661A */
  0x0000,   /* U+661B */
  0x0000,   /* U+661C */
  0x0000,   /* U+661D */
  0x0000,   /* U+661E */
  0x0000,   /* U+661F */
  0x0000,   /* U+6620 */
  0x0000,   /* U+6621 */
  0x0000,   /* U+6622 */
  0x0000,   /* U+6623 */
  0x0000,   /* U+6624 */
  0x0000,   /* U+6625 */
  0x0000,   /* U+6626 */
  0x0000,   /* U+6627 */
  0x0000,   /* U+6628 */
  0x0000,   /* U+6629 */
  0x0000,   /* U+662A */
  0x0000,   /* U+662B */
  0x0000,   /* U+662C */
  0x0000,   /* U+662D */
  0x0000,   /* U+662E */
  0x0000,   /* U+662F */
  0x0000,   /* U+6630 */
  0x0000,   /* U+6631 */
  0x0000,   /* U+6632 */
  0x0000,   /* U+6633 */
  0x0000,   /* U+6634 */
  0x0000,   /* U+6635 */
  0x0000,   /* U+6636 */
  0x0000,   /* U+6637 */
  0x0000,   /* U+6638 */
  0x0000,   /* U+6639 */
  0x0000,   /* U+663A */
  0x0000,   /* U+663B */
  0x0000,   /* U+663C */
  0x0000,   /* U+663D */
  0x0000,   /* U+663E */
  0x0000,   /* U+663F */
  0x0000,   /* U+6640 */
  0x0000,   /* U+6641 */
  0x0000,   /* U+6642 */
  0x0000,   /* U+6643 */
  0x0000,   /* U+6644 */
  0x0000,   /* U+6645 */
  0x0000,   /* U+6646 */
  0x0000,   /* U+6647 */
  0x0000,   /* U+6648 */
  0x0000,   /* U+6649 */
  0x0000,   /* U+664A */
  0x0000,   /* U+664B */
  0x0000,   /* U+664C */
  0x0000,   /* U+664D */
  0x0000,   /* U+664E */
  0x0000,   /* U+664F */
  0x0000,   /* U+6650 */
  0x0000,   /* U+6651 */
  0x0000,   /* U+6652 */
  0x0000,   /* U+6653 */
  0x0000,   /* U+6654 */
  0x0000,   /* U+6655 */
  0x0000,   /* U+6656 */
  0x0000,   /* U+6657 */
  0x0000,   /* U+6658 */
  0x0000,   /* U+6659 */
  0x0000,   /* U+665A */
  0x0000,   /* U+665B */
  0x0000,   /* U+665C */
  0x0000,   /* U+665D */
  0x0000,   /* U+665E */
  0x0000,   /* U+665F */
  0x0000,   /* U+6660 */
  0x0000,   /* U+6661 */
  0x0000,   /* U+6662 */
  0x0000,   /* U+6663 */
  0x0000,   /* U+6664 */
  0x0000,   /* U+6665 */
  0x0000,   /* U+6666 */
  0x0000,   /* U+6667 */
  0x0000,   /* U+6668 */
  0x0000,   /* U+6669 */
  0x0000,   /* U+666A */
  0x0000,   /* U+666B */
  0x0000,   /* U+666C */
  0x0000,   /* U+666D */
  0x0000,   /* U+666E */
  0x0000,   /* U+666F */
  0x0000,   /* U+6670 */
  0x0000,   /* U+6671 */
  0x0000,   /* U+6672 */
  0x0000,   /* U+6673 */
  0x0000,   /* U+6674 */
  0x0000,   /* U+6675 */
  0x0000,   /* U+6676 */
  0x0000,   /* U+6677 */
  0x0000,   /* U+6678 */
  0x0000,   /* U+6679 */
  0x0000,   /* U+667A */
  0x0000,   /* U+667B */
  0x0000,   /* U+667C */
  0x0000,   /* U+667D */
  0x0000,   /* U+667E */
  0x0000,   /* U+667F */
  0x0000,   /* U+6680 */
  0x0000,   /* U+6681 */
  0x0000,   /* U+6682 */
  0x0000,   /* U+6683 */
  0x0000,   /* U+6684 */
  0x0000,   /* U+6685 */
  0x0000,   /* U+6686 */
  0x0000,   /* U+6687 */
  0x0000,   /* U+6688 */
  0x0000,   /* U+6689 */
  0x0000,   /* U+668A */
  0x0000,   /* U+668B */
  0x0000,   /* U+668C */
  0x0000,   /* U+668D */
  0x0000,   /* U+668E */
  0x0000,   /* U+668F */
  0x0000,   /* U+6690 */
  0x0000,   /* U+6691 */
  0x0000,   /* U+6692 */
  0x0000,   /* U+6693 */
  0x0000,   /* U+6694 */
  0x0000,   /* U+6695 */
  0x0000,   /* U+6696 */
  0x0000,   /* U+6697 */
  0x0000,   /* U+6698 */
  0x0000,   /* U+6699 */
  0x0000,   /* U+669A */
  0x0000,   /* U+669B */
  0x0000,   /* U+669C */
  0x0000,   /* U+669D */
  0x0000,   /* U+669E */
  0x0000,   /* U+669F */
  0x0000,   /* U+66A0 */
  0x0000,   /* U+66A1 */
  0x0000,   /* U+66A2 */
  0x0000,   /* U+66A3 */
  0x0000,   /* U+66A4 */
  0x0000,   /* U+66A5 */
  0x0000,   /* U+66A6 */
  0x0000,   /* U+66A7 */
  0x0000,   /* U+66A8 */
  0x0000,   /* U+66A9 */
  0x0000,   /* U+66AA */
  0x0000,   /* U+66AB */
  0x0000,   /* U+66AC */
  0x0000,   /* U+66AD */
  0x0000,   /* U+66AE */
  0x0000,   /* U+66AF */
  0x0000,   /* U+66B0 */
  0x0000,   /* U+66B1 */
  0x0000,   /* U+66B2 */
  0x0000,   /* U+66B3 */
  0x0000,   /* U+66B4 */
  0x0000,   /* U+66B5 */
  0x0000,   /* U+66B6 */
  0x0000,   /* U+66B7 */
  0x0000,   /* U+66B8 */
  0x0000,   /* U+66B9 */
  0x0000,   /* U+66BA */
  0x0000,   /* U+66BB */
  0x0000,   /* U+66BC */
  0x0000,   /* U+66BD */
  0x0000,   /* U+66BE */
  0x0000,   /* U+66BF */
  0x0000,   /* U+66C0 */
  0x0000,   /* U+66C1 */
  0x0000,   /* U+66C2 */
  0x0000,   /* U+66C3 */
  0x0000,   /* U+66C4 */
  0x0000,   /* U+66C5 */
  0x0000,   /* U+66C6 */
  0x0000,   /* U+66C7 */
  0x0000,   /* U+66C8 */
  0x0000,   /* U+66C9 */
  0x0000,   /* U+66CA */
  0x0000,   /* U+66CB */
  0x0000,   /* U+66CC */
  0x0000,   /* U+66CD */
  0x0000,   /* U+66CE */
  0x0000,   /* U+66CF */
  0x0000,   /* U+66D0 */
  0x0000,   /* U+66D1 */
  0x0000,   /* U+66D2 */
  0x0000,   /* U+66D3 */
  0x0000,   /* U+66D4 */
  0x0000,   /* U+66D5 */
  0x0000,   /* U+66D6 */
  0x0000,   /* U+66D7 */
  0x0000,   /* U+66D8 */
  0x0000,   /* U+66D9 */
  0x0000,   /* U+66DA */
  0x0000,   /* U+66DB */
  0x0000,   /* U+66DC */
  0x0000,   /* U+66DD */
  0x0000,   /* U+66DE */
  0x0000,   /* U+66DF */
  0x0000,   /* U+66E0 */
  0x0000,   /* U+66E1 */
  0x0000,   /* U+66E2 */
  0x0000,   /* U+66E3 */
  0x0000,   /* U+66E4 */
  0x0000,   /* U+66E5 */
  0x0000,   /* U+66E6 */
  0x0000,   /* U+66E7 */
  0x0000,   /* U+66E8 */
  0x0000,   /* U+66E9 */
  0x0000,   /* U+66EA */
  0x0000,   /* U+66EB */
  0x0000,   /* U+66EC */
  0x0000,   /* U+66ED */
  0x0000,   /* U+66EE */
  0x0000,   /* U+66EF */
  0x0000,   /* U+66F0 */
  0x0000,   /* U+66F1 */
  0x0000,   /* U+66F2 */
  0x0000,   /* U+66F3 */
  0x0000,   /* U+66F4 */
  0x0000,   /* U+66F5 */
  0x0000,   /* U+66F6 */
  0x0000,   /* U+66F7 */
  0x0000,   /* U+66F8 */
  0x0000,   /* U+66F9 */
  0x0000,   /* U+66FA */
  0x0000,   /* U+66FB */
  0x0000,   /* U+66FC */
  0x0000,   /* U+66FD */
  0x0000,   /* U+66FE */
  0x0000,   /* U+66FF */
};

uint16 ja_han_page67[]= {
  /* Number of CEs for each character. */
  1, 2, 2, 1, 2, 2, 2, 2, 1, 1, 2, 1, 2, 1, 2, 1,
  2, 2, 2, 2, 1, 1, 1, 1, 2, 2, 2, 1, 2, 1, 1, 1,
  2, 2, 2, 2, 2, 2, 1, 1, 1, 2, 1, 1, 1, 1, 1, 2,
  2, 1, 2, 2, 1, 2, 1, 1, 1, 2, 1, 2, 2, 1, 2, 1,
  2, 1, 2, 2, 2, 2, 1, 2, 2, 1, 2, 2, 2, 2, 1, 1,
  1, 1, 2, 1, 2, 2, 1, 2, 2, 1, 2, 2, 1, 2, 1, 1,
  1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 1, 2, 2, 1, 2, 1,
  1, 1, 1, 1, 2, 1, 2, 1, 2, 2, 2, 2, 1, 2, 1, 1,
  2, 2, 2, 2, 2, 1, 2, 1, 2, 1, 2, 1, 1, 2, 2, 2,
  1, 2, 2, 2, 2, 1, 2, 1, 2, 2, 1, 2, 1, 1, 2, 2,
  1, 1, 1, 2, 2, 2, 1, 2, 2, 1, 2, 2, 2, 2, 2, 1,
  2, 2, 2, 1, 1, 2, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2,
  2, 1, 2, 2, 1, 2, 1, 2, 2, 2, 1, 2, 2, 2, 1, 1,
  1, 1, 2, 1, 1, 2, 2, 2, 1, 2, 1, 2, 2, 1, 1, 2,
  2, 2, 1, 2, 1, 2, 2, 1, 2, 1, 2, 2, 1, 2, 1, 1,
  2, 1, 2, 1, 1, 1, 2, 2, 2, 2, 2, 1, 2, 2, 1, 1,

  /* Primary weight 1 for each character. */
  0x5876,   /* U+6700 */
  0xFB40,   /* U+6701 */
  0xFB40,   /* U+6702 */
  0x608A,   /* U+6703 */
  0xFB40,   /* U+6704 */
  0xFB40,   /* U+6705 */
  0xFB40,   /* U+6706 */
  0xFB40,   /* U+6707 */
  0x5783,   /* U+6708 */
  0x5F56,   /* U+6709 */
  0xFB40,   /* U+670A */
  0x5E8D,   /* U+670B */
  0xFB40,   /* U+670C */
  0x5E2F,   /* U+670D */
  0xFB40,   /* U+670E */
  0x644E,   /* U+670F */
  0xFB40,   /* U+6710 */
  0xFB40,   /* U+6711 */
  0xFB40,   /* U+6712 */
  0xFB40,   /* U+6713 */
  0x58A2,   /* U+6714 */
  0x5C1A,   /* U+6715 */
  0x644F,   /* U+6716 */
  0x6014,   /* U+6717 */
  0xFB40,   /* U+6718 */
  0xFB40,   /* U+6719 */
  0xFB40,   /* U+671A */
  0x5EAB,   /* U+671B */
  0xFB40,   /* U+671C */
  0x5C06,   /* U+671D */
  0x6450,   /* U+671E */
  0x5677,   /* U+671F */
  0xFB40,   /* U+6720 */
  0xFB40,   /* U+6721 */
  0xFB40,   /* U+6722 */
  0xFB40,   /* U+6723 */
  0xFB40,   /* U+6724 */
  0xFB40,   /* U+6725 */
  0x6451,   /* U+6726 */
  0x6452,   /* U+6727 */
  0x5F25,   /* U+6728 */
  0xFB40,   /* U+6729 */
  0x5EEF,   /* U+672A */
  0x5EE3,   /* U+672B */
  0x5EC9,   /* U+672C */
  0x58B2,   /* U+672D */
  0x6454,   /* U+672E */
  0xFB40,   /* U+672F */
  0xFB40,   /* U+6730 */
  0x5956,   /* U+6731 */
  0xFB40,   /* U+6732 */
  0xFB40,   /* U+6733 */
  0x5EBE,   /* U+6734 */
  0xFB40,   /* U+6735 */
  0x6456,   /* U+6736 */
  0x6459,   /* U+6737 */
  0x6458,   /* U+6738 */
  0xFB40,   /* U+6739 */
  0x5674,   /* U+673A */
  0xFB40,   /* U+673B */
  0xFB40,   /* U+673C */
  0x56B9,   /* U+673D */
  0xFB40,   /* U+673E */
  0x6455,   /* U+673F */
  0xFB40,   /* U+6740 */
  0x6457,   /* U+6741 */
  0xFB40,   /* U+6742 */
  0xFB40,   /* U+6743 */
  0xFB40,   /* U+6744 */
  0xFB40,   /* U+6745 */
  0x645A,   /* U+6746 */
  0xFB40,   /* U+6747 */
  0xFB40,   /* U+6748 */
  0x5A7E,   /* U+6749 */
  0xFB40,   /* U+674A */
  0xFB40,   /* U+674B */
  0xFB40,   /* U+674C */
  0xFB40,   /* U+674D */
  0x5FA4,   /* U+674E */
  0x54CC,   /* U+674F */
  0x588F,   /* U+6750 */
  0x5B5B,   /* U+6751 */
  0xFB40,   /* U+6752 */
  0x5948,   /* U+6753 */
  0xFB40,   /* U+6754 */
  0xFB40,   /* U+6755 */
  0x5A1A,   /* U+6756 */
  0xFB40,   /* U+6757 */
  0xFB40,   /* U+6758 */
  0x645D,   /* U+6759 */
  0xFB40,   /* U+675A */
  0xFB40,   /* U+675B */
  0x5C87,   /* U+675C */
  0xFB40,   /* U+675D */
  0x645B,   /* U+675E */
  0x5B4A,   /* U+675F */
  0x645C,   /* U+6760 */
  0x5A19,   /* U+6761 */
  0x5F28,   /* U+6762 */
  0x645E,   /* U+6763 */
  0x645F,   /* U+6764 */
  0x5F91,   /* U+6765 */
  0xFB40,   /* U+6766 */
  0xFB40,   /* U+6767 */
  0xFB40,   /* U+6768 */
  0xFB40,   /* U+6769 */
  0x6464,   /* U+676A */
  0xFB40,   /* U+676B */
  0xFB40,   /* U+676C */
  0x580B,   /* U+676D */
  0xFB40,   /* U+676E */
  0x5D4A,   /* U+676F */
  0x6461,   /* U+6770 */
  0x5CA5,   /* U+6771 */
  0x6422,   /* U+6772 */
  0x6426,   /* U+6773 */
  0xFB40,   /* U+6774 */
  0x56A8,   /* U+6775 */
  0xFB40,   /* U+6776 */
  0x5D3C,   /* U+6777 */
  0xFB40,   /* U+6778 */
  0xFB40,   /* U+6779 */
  0xFB40,   /* U+677A */
  0xFB40,   /* U+677B */
  0x6463,   /* U+677C */
  0xFB40,   /* U+677D */
  0x59E5,   /* U+677E */
  0x5D97,   /* U+677F */
  0xFB40,   /* U+6780 */
  0xFB40,   /* U+6781 */
  0xFB40,   /* U+6782 */
  0xFB40,   /* U+6783 */
  0xFB40,   /* U+6784 */
  0x6469,   /* U+6785 */
  0xFB40,   /* U+6786 */
  0x5DCD,   /* U+6787 */
  0xFB40,   /* U+6788 */
  0x6460,   /* U+6789 */
  0xFB40,   /* U+678A */
  0x6466,   /* U+678B */
  0x6465,   /* U+678C */
  0xFB40,   /* U+678D */
  0xFB40,   /* U+678E */
  0xFB40,   /* U+678F */
  0x5AB2,   /* U+6790 */
  0xFB40,   /* U+6791 */
  0xFB40,   /* U+6792 */
  0xFB40,   /* U+6793 */
  0xFB40,   /* U+6794 */
  0x5EDA,   /* U+6795 */
  0xFB40,   /* U+6796 */
  0x5FDA,   /* U+6797 */
  0xFB40,   /* U+6798 */
  0xFB40,   /* U+6799 */
  0x5ED4,   /* U+679A */
  0xFB40,   /* U+679B */
  0x558B,   /* U+679C */
  0x58EB,   /* U+679D */
  0xFB40,   /* U+679E */
  0xFB40,   /* U+679F */
  0x602D,   /* U+67A0 */
  0x6468,   /* U+67A1 */
  0x5A7A,   /* U+67A2 */
  0xFB40,   /* U+67A3 */
  0xFB40,   /* U+67A4 */
  0xFB40,   /* U+67A5 */
  0x6467,   /* U+67A6 */
  0xFB40,   /* U+67A7 */
  0xFB40,   /* U+67A8 */
  0x6462,   /* U+67A9 */
  0xFB40,   /* U+67AA */
  0xFB40,   /* U+67AB */
  0xFB40,   /* U+67AC */
  0xFB40,   /* U+67AD */
  0xFB40,   /* U+67AE */
  0x57C2,   /* U+67AF */
  0xFB40,   /* U+67B0 */
  0xFB40,   /* U+67B1 */
  0xFB40,   /* U+67B2 */
  0x646E,   /* U+67B3 */
  0x646C,   /* U+67B4 */
  0xFB40,   /* U+67B5 */
  0x558C,   /* U+67B6 */
  0x646A,   /* U+67B7 */
  0x6470,   /* U+67B8 */
  0x6476,   /* U+67B9 */
  0xFB40,   /* U+67BA */
  0xFB40,   /* U+67BB */
  0xFB40,   /* U+67BC */
  0xFB40,   /* U+67BD */
  0xFB40,   /* U+67BE */
  0xFB40,   /* U+67BF */
  0xFB40,   /* U+67C0 */
  0x5B67,   /* U+67C1 */
  0xFB40,   /* U+67C2 */
  0xFB40,   /* U+67C3 */
  0x5E50,   /* U+67C4 */
  0xFB40,   /* U+67C5 */
  0x6478,   /* U+67C6 */
  0xFB40,   /* U+67C7 */
  0xFB40,   /* U+67C8 */
  0xFB40,   /* U+67C9 */
  0x5DD3,   /* U+67CA */
  0xFB40,   /* U+67CB */
  0xFB40,   /* U+67CC */
  0xFB40,   /* U+67CD */
  0x6477,   /* U+67CE */
  0x5D65,   /* U+67CF */
  0x5EAC,   /* U+67D0 */
  0x5636,   /* U+67D1 */
  0xFB40,   /* U+67D2 */
  0x5ADA,   /* U+67D3 */
  0x5989,   /* U+67D4 */
  0xFB40,   /* U+67D5 */
  0xFB40,   /* U+67D6 */
  0xFB40,   /* U+67D7 */
  0x5C2E,   /* U+67D8 */
  0xFB40,   /* U+67D9 */
  0x5F57,   /* U+67DA */
  0xFB40,   /* U+67DB */
  0xFB40,   /* U+67DC */
  0x6473,   /* U+67DD */
  0x6472,   /* U+67DE */
  0xFB40,   /* U+67DF */
  0xFB40,   /* U+67E0 */
  0xFB40,   /* U+67E1 */
  0x6474,   /* U+67E2 */
  0xFB40,   /* U+67E3 */
  0x6471,   /* U+67E4 */
  0xFB40,   /* U+67E5 */
  0xFB40,   /* U+67E6 */
  0x6479,   /* U+67E7 */
  0xFB40,   /* U+67E8 */
  0x646F,   /* U+67E9 */
  0xFB40,   /* U+67EA */
  0xFB40,   /* U+67EB */
  0x646D,   /* U+67EC */
  0xFB40,   /* U+67ED */
  0x6475,   /* U+67EE */
  0x646B,   /* U+67EF */
  0xFB40,   /* U+67F0 */
  0x5BE9,   /* U+67F1 */
  0xFB40,   /* U+67F2 */
  0x5F43,   /* U+67F3 */
  0x5931,   /* U+67F4 */
  0x58A3,   /* U+67F5 */
  0xFB40,   /* U+67F6 */
  0xFB40,   /* U+67F7 */
  0xFB40,   /* U+67F8 */
  0xFB40,   /* U+67F9 */
  0xFB40,   /* U+67FA */
  0x5869,   /* U+67FB */
  0xFB40,   /* U+67FC */
  0xFB40,   /* U+67FD */
  0x5EDC,   /* U+67FE */
  0x55DE,   /* U+67FF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+6700 */
  0x0020,   /* U+6701 */
  0x0020,   /* U+6702 */
  0x0020,   /* U+6703 */
  0x0020,   /* U+6704 */
  0x0020,   /* U+6705 */
  0x0020,   /* U+6706 */
  0x0020,   /* U+6707 */
  0x0020,   /* U+6708 */
  0x0020,   /* U+6709 */
  0x0020,   /* U+670A */
  0x0020,   /* U+670B */
  0x0020,   /* U+670C */
  0x0020,   /* U+670D */
  0x0020,   /* U+670E */
  0x0020,   /* U+670F */
  0x0020,   /* U+6710 */
  0x0020,   /* U+6711 */
  0x0020,   /* U+6712 */
  0x0020,   /* U+6713 */
  0x0020,   /* U+6714 */
  0x0020,   /* U+6715 */
  0x0020,   /* U+6716 */
  0x0020,   /* U+6717 */
  0x0020,   /* U+6718 */
  0x0020,   /* U+6719 */
  0x0020,   /* U+671A */
  0x0020,   /* U+671B */
  0x0020,   /* U+671C */
  0x0020,   /* U+671D */
  0x0020,   /* U+671E */
  0x0020,   /* U+671F */
  0x0020,   /* U+6720 */
  0x0020,   /* U+6721 */
  0x0020,   /* U+6722 */
  0x0020,   /* U+6723 */
  0x0020,   /* U+6724 */
  0x0020,   /* U+6725 */
  0x0020,   /* U+6726 */
  0x0020,   /* U+6727 */
  0x0020,   /* U+6728 */
  0x0020,   /* U+6729 */
  0x0020,   /* U+672A */
  0x0020,   /* U+672B */
  0x0020,   /* U+672C */
  0x0020,   /* U+672D */
  0x0020,   /* U+672E */
  0x0020,   /* U+672F */
  0x0020,   /* U+6730 */
  0x0020,   /* U+6731 */
  0x0020,   /* U+6732 */
  0x0020,   /* U+6733 */
  0x0020,   /* U+6734 */
  0x0020,   /* U+6735 */
  0x0020,   /* U+6736 */
  0x0020,   /* U+6737 */
  0x0020,   /* U+6738 */
  0x0020,   /* U+6739 */
  0x0020,   /* U+673A */
  0x0020,   /* U+673B */
  0x0020,   /* U+673C */
  0x0020,   /* U+673D */
  0x0020,   /* U+673E */
  0x0020,   /* U+673F */
  0x0020,   /* U+6740 */
  0x0020,   /* U+6741 */
  0x0020,   /* U+6742 */
  0x0020,   /* U+6743 */
  0x0020,   /* U+6744 */
  0x0020,   /* U+6745 */
  0x0020,   /* U+6746 */
  0x0020,   /* U+6747 */
  0x0020,   /* U+6748 */
  0x0020,   /* U+6749 */
  0x0020,   /* U+674A */
  0x0020,   /* U+674B */
  0x0020,   /* U+674C */
  0x0020,   /* U+674D */
  0x0020,   /* U+674E */
  0x0020,   /* U+674F */
  0x0020,   /* U+6750 */
  0x0020,   /* U+6751 */
  0x0020,   /* U+6752 */
  0x0020,   /* U+6753 */
  0x0020,   /* U+6754 */
  0x0020,   /* U+6755 */
  0x0020,   /* U+6756 */
  0x0020,   /* U+6757 */
  0x0020,   /* U+6758 */
  0x0020,   /* U+6759 */
  0x0020,   /* U+675A */
  0x0020,   /* U+675B */
  0x0020,   /* U+675C */
  0x0020,   /* U+675D */
  0x0020,   /* U+675E */
  0x0020,   /* U+675F */
  0x0020,   /* U+6760 */
  0x0020,   /* U+6761 */
  0x0020,   /* U+6762 */
  0x0020,   /* U+6763 */
  0x0020,   /* U+6764 */
  0x0020,   /* U+6765 */
  0x0020,   /* U+6766 */
  0x0020,   /* U+6767 */
  0x0020,   /* U+6768 */
  0x0020,   /* U+6769 */
  0x0020,   /* U+676A */
  0x0020,   /* U+676B */
  0x0020,   /* U+676C */
  0x0020,   /* U+676D */
  0x0020,   /* U+676E */
  0x0020,   /* U+676F */
  0x0020,   /* U+6770 */
  0x0020,   /* U+6771 */
  0x0020,   /* U+6772 */
  0x0020,   /* U+6773 */
  0x0020,   /* U+6774 */
  0x0020,   /* U+6775 */
  0x0020,   /* U+6776 */
  0x0020,   /* U+6777 */
  0x0020,   /* U+6778 */
  0x0020,   /* U+6779 */
  0x0020,   /* U+677A */
  0x0020,   /* U+677B */
  0x0020,   /* U+677C */
  0x00