/**
 * Copyright (c) 2021 OceanBase
 * OceanBase CE is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *          http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */

#ifndef OCEANBASE_SQL_OB_ITEM_TYPE_H_
#define OCEANBASE_SQL_OB_ITEM_TYPE_H_

// @note !!!Contact with Zhuweng before you modify this file!!!

#ifdef __cplusplus
extern "C" {
#endif
typedef enum ObItemType
{
  T_INVALID = -1, //Attention: add a new type after T_INVALID

  /* Literal data type tags, the same as ObObjType */
  // Although some of the following types are not used in the parser,
  // we define them here to make it the same as ObObjType!!!
  T_NULL = 0,

  T_TINYINT = 1,
  T_SMALLINT = 2,
  T_MEDIUMINT = 3,
  T_INT32 = 4,
  T_INT = 5,

  T_UTINYINT = 6,
  T_USMALLINT = 7,
  T_UMEDIUMINT = 8,
  T_UINT32 = 9,
  T_UINT64 = 10,

  T_FLOAT = 11,
  T_DOUBLE = 12,
  T_UFLOAT = 13,
  T_UDOUBLE = 14,

  T_NUMBER = 15,
  T_UNUMBER = 16,

  T_DATETIME = 17,
  T_TIMESTAMP = 18,
  T_DATE = 19,
  T_TIME = 20,
  T_YEAR = 21,

  T_VARCHAR = 22, /*ObVarcharType*/
  T_CHAR = 23,
  T_HEX_STRING = 24,

  T_EXTEND = 25,
  T_QUESTIONMARK = 26, /*ObUnknownType*/
  T_TINYTEXT = 27,
  T_TEXT = 28,
  T_MEDIUMTEXT = 29,
  T_LONGTEXT = 30,
  T_BIT = 31,
  T_ENUM = 32,
  T_SET = 33,

  T_TIMESTAMP_TZ = 36,
  T_TIMESTAMP_LTZ = 37,
  T_TIMESTAMP_NANO = 38,
  T_RAW = 39,
  T_INTERVAL_YM = 40,
  T_INTERVAL_DS = 41,
  T_NUMBER_FLOAT = 42,
  T_NVARCHAR2   = 43,
  T_NCHAR       = 44,
  T_UROWID      = 45,
  T_LOB         = 46,
  T_JSON        = 47,
  T_GEOMETRY    = 48,
  T_UDT_SQL     = 49,
  T_COLLECTION  = 51,
  T_ROARINGBITMAP = 54,

  T_IEEE754_NAN = 61,
  T_IEEE754_INFINITE = 62,
  T_BOOL = 63, /*@todo remove later*/
  T_MAX_CONST = 64,
  T_VAR_INT = 65,

  T_EXEC_VAR = 66,

  T_REF_ALIAS_COLUMN = 88,
  T_REF_COLUMN = 89,
  // @note !!! the values of the following tags between T_FUN_MAX and T_FUN_AVG SHOULD NOT be changed
  /* Aggregate function tags */
  T_FUN_MAX = 90,
  T_FUN_MIN = 91,
  T_FUN_SUM = 92,
  T_FUN_COUNT_SUM = 93,
  T_FUN_COUNT = 94,
  T_FUN_GROUP_CONCAT = 95,
  T_FUN_AVG = 96,
  T_FUN_APPROX_COUNT_DISTINCT = 97,
  T_FUN_APPROX_COUNT_DISTINCT_SYNOPSIS = 98,
  T_FUN_APPROX_COUNT_DISTINCT_SYNOPSIS_MERGE = 99,

  // @note !!! the values of the following tags between T_MIN_OP and T_FUN_SYS SHOULD NOT be changed, new operator should be appended only
  /* Operator tags */
  T_MIN_OP = 100, /* 1. arithmetic operators */
  T_OP_NEG = 101,   // negative
  T_OP_POS = 102,   // positive
  T_OP_ABS = 103,   // for abs
  T_OP_ADD = 104,
  T_OP_MINUS = 105,
  T_OP_MUL = 106,
  T_OP_DIV = 107,
  T_OP_REM = 108,   // remainder
  T_OP_MOD = 109,
  /* common comparison operators */
  T_OP_EQ = 110,      /* 2. Bool operators */
  T_OP_NSEQ = 111,
  T_OP_LE = 112,
  T_OP_LT = 113,
  T_OP_GE = 114,
  T_OP_GT = 115,
  T_OP_NE = 116,
  /* subquery comparison operators */
  T_OP_SQ_EQ = 117,
  T_OP_SQ_NSEQ = 118,
  T_OP_SQ_LE = 119,
  T_OP_SQ_LT = 120,
  T_OP_SQ_GE = 121,
  T_OP_SQ_GT = 122,
  T_OP_SQ_NE = 123,
  T_OP_POW = 124,

  T_OP_IS = 125,
  T_OP_IS_NOT = 126,
  T_OP_BTW = 127,
  T_OP_NOT_BTW = 128,
  T_OP_LIKE = 129,
  T_OP_NOT_LIKE = 130,
  T_OP_REGEXP = 131,
  T_OP_NOT_REGEXP = 132,
  T_OP_NOT = 133,
  T_OP_AND = 134,
  T_OP_OR = 135,
  T_OP_IN = 136,
  T_OP_NOT_IN = 137,
  T_OP_ARG_CASE = 138,
  T_OP_CASE = 139,
  T_OP_ROW = 140,
  T_OP_EXISTS = 141,
  T_OP_NOT_EXISTS = 142,
  T_OP_QUOTE = 143,
  T_OP_CONV = 144,
  T_OP_CNN = 145,  /* 3. String operators */
  T_OP_INT_DIV = 146,
  T_OP_SIGN = 147,
  T_OP_ASSIGN = 148,
  T_OP_GET_USER_VAR = 149,
  T_OP_GET_SYS_VAR = 150,
  T_OP_COLUMN_REF = 151, /* normalize column to function */
  T_OP_CONST_VAL = 152,  /* normalize const to funciton */

  //set expr operators
  T_OP_SET = 153,
  T_OP_UNION = 154,
  T_OP_INTERSECT = 155,
  T_OP_EXCEPT = 156,

  /*bit operators*/
  T_OP_BIT_AND = 157,
  T_OP_BIT_OR = 158,
  T_OP_BIT_XOR = 159,
  T_OP_BIT_INVERT = 160,
  T_OP_BIT_NEG = 161,
  T_OP_BIT_LEFT_SHIFT = 162,
  T_OP_BIT_RIGHT_SHIFT = 163,
  /*bit operators end*/

  /* special op*/
  T_OP_AGG_PARAM_LIST = 164,
  /* reference tags */
  T_REF_QUERY = 165,
  T_OP_PRIOR = 166,
  T_OBJ_ACCESS_REF = 167,
  T_OP_CONNECT_BY_ROOT = 168,

  /*regexp_substr这个函数注册已经由T_FUN_SYS_REGEXP_SUBSTR代替,因为将其注册在这会造成oracle无法识别这个函数，
  因此同时不确定删除会不会影响其它,因此选择了保留*/
  T_OP_REGEXP_SUBSTR = 169,
  T_OP_GET_PACKAGE_VAR = 170,
  T_OP_SHADOW_UK_PROJECT = 171,

  T_OP_XOR = 172,
  /* oracle outer join symbol as a dummy op*/
  T_OP_ORACLE_OUTER_JOIN_SYMBOL = 173,
  T_OP_RANGE_PARAM = 174,
  T_OP_GET_SUBPROGRAM_VAR = 175,
  T_OP_MULTISET = 176,
  T_OP_COLL_PRED = 177, // collection predicate, such as: xx is member of collection
  T_OP_BOOL = 178,
  T_OP_STACK_OVERFLOW_CHECK = 179,  // stack over flow check expr.
  T_OP_RUNTIME_FILTER = 180,
  T_OP_TO_OUTFILE_ROW = 181,
  // The aggregation version arithmetic operator is used to ignore the double overflow error,
  // because mysql do not check overflow for double in aggregation.
  T_OP_AGG_ADD = 182,
  T_OP_AGG_MINUS = 183,
  T_OP_AGG_MUL = 184,
  T_OP_AGG_DIV = 185,
  T_OP_OUTPUT_PACK = 186,
  T_FUN_GET_TEMP_TABLE_SESSID = 187,
  T_OP_PUSHDOWN_TOPN_FILTER = 188,
  ///< @note add new operator before this line

  // system functions
  // @note !!! the values of the following tags between T_FUN_SYS and T_MAX_OP SHOULD NOT be changed, new function should be appended only
  T_FUN_SYS = 500,
  T_FUN_SYS_CAST = 501,
  T_FUN_SYS_CHAR = 502,
  T_FUN_SYS_CONVERT = 503,
  T_FUN_SYS_GREATEST = 504,
  T_FUN_SYS_LEAST = 505,
  T_FUN_SYS_COALESCE = 506,
  T_FUN_SYS_TRIM = 507,
  T_FUN_SYS_SUBSTR = 508,
  T_FUN_SYS_SUBSTRING_INDEX = 509,
  T_FUN_SYS_MD5 = 510,
  T_FUN_SYS_IP2INT = 511,
  T_FUN_SYS_INT2IP = 512,
  T_FUN_SYS_INSERT = 513,
  T_FUN_SYS_LENGTH = 514,
  T_FUN_SYS_HEX = 515,
  T_FUN_SYS_UNHEX = 516,
  T_FUN_SYS_UPPER = 517,
  T_FUN_SYS_LOWER = 518,
  T_FUN_SYS_BIN = 519,
  T_FUN_SYS_DATE = 520,
  T_FUN_SYS_DATE_ADD = 521,
  T_FUN_SYS_DATE_SUB = 522,
  T_FUN_SYS_DATE_DIFF = 523,
  T_FUN_SYS_TIME_STAMP_DIFF = 524,
  T_FUN_SYS_TIME_DIFF = 525,
  T_FUN_SYS_PERIOD_DIFF = 526,
  T_FUN_SYS_FROM_UNIX_TIME = 527,
  T_FUN_SYS_EXTRACT = 528,
  T_FUN_SYS_MONTH = 529,
  T_FUN_SYS_DATE_FORMAT = 530,
  T_FUN_SYS_STR_TO_DATE = 531,
  T_FUN_SYS_UTC_TIMESTAMP = 532,
  T_FUN_SYS_UPS_TIME = 533,
  T_FUN_SYS_CUR_TIMESTAMP = 534,
  T_FUN_SYS_CUR_TIME = 535,
  T_FUN_SYS_CUR_DATE = 536,
  T_FUN_SYS_TO_DAYS = 537,
  T_FUN_SYS_FROM_DAYS = 538,
  T_FUN_SYS_NVL = 539,
  T_FUN_SYS_TIME_TO_USEC = 540,
  T_FUN_SYS_USEC_TO_TIME = 541,
  T_FUN_SYS_UNIX_TIMESTAMP = 542,
  T_FUN_SYS_ROUND = 543,
  T_FUN_SYS_DUMP = 544,
  T_FUN_SYS_FLOOR = 545,
  T_FUN_SYS_CEIL = 546,
  T_FUN_SYS_REPEAT = 547,
  T_FUN_SYS_REPLACE = 548,
  T_FUN_SYS_MERGING_FROZEN_TIME = 549,
  T_FUN_SYS_PART_HASH = 550,
  //following T_FUN_SYS_PART_KEY_V1 has been removed, it's useless now.
  T_FUN_SYS_PART_KEY_V1 = 551,
  T_FUN_SYS_ADDR_TO_PART_ID = 552,
  T_FUN_SYS_DATABASE = 553,
  T_FUN_SYS_AUTOINC_NEXTVAL = 554,
  T_FUN_SYS_LAST_INSERT_ID = 555,
  T_FUN_SYS_INSTR = 556,
  T_FUN_SYS_LNNVL = 557,
  T_FUN_SYS_LOCATE = 558,
  T_FUN_SYS_EFFECTIVE_TENANT = 559,
  T_FUN_SYS_CURRENT_USER = 560,
  T_FUN_SYS_USER = 561,
  T_FUN_SYS_VERSION = 562,
  T_FUN_SYS_CHARSET = 563,
  T_FUN_SYS_COLLATION = 564,
  T_FUN_SYS_SYS_VIEW_BIGINT_PARAM = 565,
  T_FUN_SYS_COERCIBILITY = 566,
  T_FUN_SYS_REVERSE = 567,
  T_FUN_SYS_RIGHT = 568,
  T_FUN_SYS_EFFECTIVE_TENANT_ID = 569,
  T_FUN_SYS_VALUES = 570,
  T_FUN_SYS_OCT = 571,
  T_FUN_SYS_RPAD = 572,
  T_FUN_SYS_SET_COLLATION = 573,
  T_FUN_SYS_CHAR_LENGTH = 574,
  T_FUN_SYS_CONNECTION_ID = 575,
  T_FUN_SYS_HOST_IP = 576,
  T_FUN_SYS_RPC_PORT = 577,
  T_FUN_SYS_MYSQL_PORT = 578,
  T_FUN_SYS_IFNULL = 579,
  T_FUN_SYS_FOUND_ROWS = 580,
  T_FUN_SYS_ROW_COUNT = 581,
  T_FUN_CNN_WS = 582,
  T_FUN_SYS_SYS_PRIVILEGE_CHECK = 583,
  T_FUN_SYS_CMP_META = 585,
  T_FUN_SYS_DEFAULT = 586,
  T_FUN_SYS_FIELD = 587,
  T_FUN_SYS_NULLIF = 588,
  T_FUN_PAD = 589,
  T_FUN_COLUMN_CONV = 590,
  T_FUN_SYS_IF = 591,
  T_FUN_SYS_ISNULL = 592,
  T_FUN_SYS_TIMESTAMP_NVL = 593,
  T_FUN_IS_SERVING_TENANT = 594,
  T_FUN_SYS_POSITION = 595,
  T_FUN_SYS_ORA_DECODE = 596,
  T_FUN_SYS_ELT = 597,
  T_FUN_SYS_STRCMP = 598,
  T_FUN_SYS_PART_KEY = 599,
  T_FUN_INNER_TRIM = 600,
  T_FUN_SYS_PART_ID = 601,
  T_FUN_SYS_ORA_TRUNC = 602,
  T_FUN_SYS_TO_TYPE = 603,
  T_FUN_SYS_SLEEP = 604,
  T_FUN_GET_LAST_EXEC_ID = 605,
  T_FUN_GET_LAST_TRACE_ID = 606,
  T_FUN_SYS_CEILING = 607,
  T_FUN_DES_HEX_STR = 608,
  T_FUN_SYS_YEAR = 609,
  T_FUN_SYS_UUID = 610,
  T_FUN_SYS_TIME = 611,
  T_FUN_SYS_ASCII = 612,
  T_FUN_SYS_ORD = 613,
  T_FUN_SYS_WORD_SEGMENT = 614,
  T_FUN_SYS_LTRIM = 615,
  T_FUN_SYS_SPACE = 616,
  T_FUN_SYS_RTRIM = 617,
  T_FUN_SYS_LPAD = 618,
  T_FUN_SYS_TIME_STAMP_ADD = 619,
  T_FUN_SYS_BIT_COUNT = 620,
  T_FUN_SYS_FIND_IN_SET = 621,
  T_FUN_SYS_LEFT = 622,
  T_FUN_SYS_MAKE_SET = 623,
  T_FUN_SYS_RAND = 624,
  T_FUN_SYS_ROWNUM = 625,
  T_FUN_SYS_ESTIMATE_NDV = 626,
  T_FUN_ENUM_TO_STR = 627,
  T_FUN_ENUM_TO_INNER_TYPE = 628,
  T_FUN_SET_TO_STR = 629,
  T_FUN_SET_TO_INNER_TYPE = 630,
  T_FUN_GROUPING = 631,
  T_FUN_SYS_OP_OPNSIZE = 632,
  T_FUN_SYS_PDB_ON = 633,
  T_FUN_SYS_PDB_OFF = 634,
  T_FUN_SYS_PDB_INITIALIZE = 635,
  T_FUN_SYS_PDB_ATTACHSESSION = 636,
  T_FUN_SYS_PDB_DETACHSESSION = 637,
  T_FUN_SYS_PDB_SETBREAKPOINT = 638,
  T_FUN_SYS_PDB_PRINTBACKTRACE = 639,
  T_FUN_SYS_PDB_CONTINUE = 640,
  T_FUN_SYS_PDB_SHOWBREAKPOINTS = 641,
  T_FUN_SYS_PDB_GETVALUE = 642,
  T_FUN_SYS_PDB_DELBREAKPOINT = 643,
  T_FUN_SYS_PDB_ENABLE_BP = 644,
  T_FUN_SYS_PDB_DISABLE_BP = 645,
  T_FUN_SYS_PDB_SET_TIMEOUT = 646,
  T_FUN_SYS_PDB_SET_TIMEOUT_BEHAVIOUR = 647,
  T_FUN_SYS_PDB_GET_TIMEOUT_BEHAVIOUR = 648,
  // 649, 650 has beed removed
  T_FUN_SYS_DAY_OF_MONTH = 651,
  T_FUN_SYS_DAY_OF_WEEK = 652,
  T_FUN_SYS_DAY_OF_YEAR = 653,
  T_FUN_SYS_SECOND = 654,
  T_FUN_SYS_MINUTE = 655,
  T_FUN_SYS_MICROSECOND = 656,
  T_FUN_SYS_TO_SECONDS = 657,
  T_FUN_SYS_TIME_TO_SEC = 658,
  T_FUN_SYS_SEC_TO_TIME = 659,
  T_FUN_SYS_INTERVAL = 660,
  T_FUN_UDF = 661,
  T_FUN_SYS_SUBTIME = 662,
  T_FUN_SYS_SQRT = 663,
  T_FUN_SYS_LOG_TWO = 664,
  T_FUN_SYS_LOG_TEN = 665,
  T_FUN_SYS_SYSDATE = 666,
  T_FUN_SYS_TRUNCATE = 667,
  T_FUN_SYS_WEEK_OF_YEAR = 668,
  T_FUN_SYS_WEEKDAY_OF_DATE = 669,
  T_FUN_SYS_YEARWEEK_OF_DATE = 670,
  T_FUN_SYS_WEEK = 671,
  T_FUN_NORMAL_UDF = 672,
  T_FUN_AGG_UDF = 673,
  T_FUN_SYS_SEQ_NEXTVAL = 674,
  T_FUN_SYS_ROWKEY_TO_ROWID = 675,
  T_FUN_SYS_UID = 676,
  T_FUN_SYS_LOCALTIMESTAMP = 677,
  // 678 has been removed
  T_FUN_SYS_EXP = 679,
  T_FUN_STDDEV_SAMP = 680,
  T_FUN_STDDEV_POP = 681,
  T_FUN_STDDEV = 682,
  T_FUN_VARIANCE = 683,
  T_FUN_SYS_HOUR = 684,
  T_FUN_SYS_STMT_ID = 685,
  T_FUN_SYS_REGEXP_INSTR = 686,
  T_FUN_SYS_REGEXP_REPLACE = 687,
  T_FUN_SYS_REGEXP_LIKE = 688,
  T_FUN_SYS_REGEXP_SUBSTR = 689,
  T_FUN_COLUMN_CONV_SKIP_NULL_CHECK = 690,
  // use for pdml, pseudo column
  T_PDML_PARTITION_ID = 691,
  T_FUN_SYS_MID = 692,
  T_FUN_SYS_CALC_UROWID = 693,
  // udf for pl debugger get_runtime_info
  T_FUN_SYS_PDB_GET_RUNTIME_INFO = 694,
  T_FUN_SYS_REMOVE_CONST = 695,
  //following T_FUN_SYS_PART_KEY_V3 has been removed, it's useless now.
  T_FUN_SYS_PART_KEY_V3 = 696,
  //following T_FUN_SYS_PART_HASH_V2 has been removed, it's useless now.
  T_FUN_SYS_PART_HASH_V2 = 697,
  T_FUN_SYS_SQL_MODE_CONVERT = 698,
  T_FUN_SYS_PREFIX_PATTERN = 699,

  ///< @note add new mysql/oracle function type before this line
  T_COMMON_FUN_SYS_END = 700,

  // system function for mysql only
  T_MYSQL_ONLY_SYS_MIN_OP = 701,
  T_FUN_AES_ENCRYPT = 702,
  T_FUN_AES_DECRYPT = 703,
  T_FUN_SYS_OB_VERSION = 704,
  T_FUN_SYS_CALC_PARTITION_ID = 705,
  T_FUN_SYS_RADIANS = 706,
  T_FUN_SYS_MAKETIME = 707,
  T_FUN_SYS_MONTH_NAME = 708,
  T_FUN_SYS_FORMAT = 709,
  T_FUN_SYS_COT = 710,
  T_FUN_SYS_QUARTER = 711,
  T_FUN_SYS_BIT_LENGTH = 712,
  T_FUN_SYS_PI = 713,
  T_FUN_SYS_ANY_VALUE = 714,
  T_FUN_SYS_DEGREES = 715,
  T_FUN_SYS_VALIDATE_PASSWORD_STRENGTH = 716,
  T_FUN_SYS_DAY = 717,
  T_FUN_SYS_SOUNDEX= 718,
  T_FUN_SYS_UUID_SHORT = 719,
  T_FUN_SYS_BENCHMARK = 720,
  T_FUN_SYS_EXPORT_SET = 721,
  T_FUN_SYS_INET6NTOA = 722,
  T_FUN_SYS_INET6ATON = 723,
  T_FUN_SYS_IS_IPV4 = 724,
  T_FUN_SYS_IS_IPV6 = 725,
  T_FUN_SYS_IS_IPV4_MAPPED = 726,
  T_FUN_SYS_IS_IPV4_COMPAT = 727,
  T_FUN_SYS_INETATON = 728,
  T_FUN_SYS_WEIGHT_STRING = 729,
  T_FUN_SYS_CONVERT_TZ = 730,
  T_FUN_SYS_CRC32 = 731,
  // @note !!! the values of the following tags between T_FUN_SYS_BIT_AND and T_FUN_SYS_BIT_XOR
  // SHOULD NOT be changed
  T_FUN_SYS_BIT_AND = 732,
  T_FUN_SYS_BIT_OR = 733,
  T_FUN_SYS_BIT_XOR = 734,
  T_FUN_SYS_TO_BASE64 = 735,
  T_FUN_SYS_FROM_BASE64 = 736,
  T_FUN_SYS_RANDOM_BYTES = 737,
  T_FUN_SUBQUERY = 738,
  T_FUN_SYS_ENCODE_SORTKEY = 739,
  T_FUN_SYS_SHA = 740,
  T_FUN_SYS_SHA1 = 741,
  T_FUN_SYS_SHA2 = 742,
  T_FUN_SYS_COMPRESS = 743,
  T_FUN_SYS_UNCOMPRESS = 744,
  T_FUN_SYS_UNCOMPRESSED_LENGTH = 745,
  T_FUN_SYS_STATEMENT_DIGEST = 746,
  T_FUN_SYS_STATEMENT_DIGEST_TEXT = 747,
  T_FUN_SYS_HASH = 748,
  T_FUN_SYS_CALC_TABLET_ID = 749,
  T_FUN_SYS_CALC_PARTITION_TABLET_ID = 750,
  T_FUN_SYS_ERRNO = 751,
  T_FUN_SYS_ADDTIME = 752,
  T_FUN_SYS_DAY_NAME = 753,
  T_FUN_SYS_UUID2BIN = 754,
  T_FUN_SYS_IS_UUID = 755,
  T_FUN_SYS_BIN2UUID = 756,
  T_FUN_SYS_NAME_CONST = 757,
  T_FUN_SYS_FORMAT_BYTES = 758,
  T_FUN_SYS_FORMAT_PICO_TIME = 759,
  T_FUN_SYS_DECODE = 760,
  T_FUN_SYS_ENCODE = 761,
  T_FUN_SYS_DES_DECRYPT = 762,
  T_FUN_SYS_DES_ENCRYPT = 763,
  T_FUN_SYS_ENCRYPT = 764,
  T_FUN_SYS_ICU_VERSION = 765,
  T_FUN_SYS_CURRENT_USER_PRIV = 766,
  T_FUN_SYS_CURRENT_ROLE = 767,
  T_FUN_SYS_EXTRACT_CERT_EXPIRED_TIME = 768,
  T_FUN_SYS_AUDIT_LOG_SET_FILTER = 769,
  T_FUN_SYS_AUDIT_LOG_REMOVE_FILTER = 770,
  T_FUN_SYS_AUDIT_LOG_SET_USER = 771,
  T_FUN_SYS_AUDIT_LOG_REMOVE_USER = 772,
  T_FUN_SYS_PASSWORD = 773,
  T_FUN_SYS_IS_ENABLED_ROLE = 774,
  T_FUN_SYS_CAN_ACCESS_TRIGGER = 775,
  T_FUN_SYS_SM3 = 776,
  T_FUN_SYS_SM4_ENCRYPT = 777,
  T_FUN_SYS_SM4_DECRYPT = 778,
  T_FUN_SYS_ENHANCED_AES_ENCRYPT = 779,
  T_FUN_SYS_ENHANCED_AES_DECRYPT = 780,
  T_FUNC_SYS_MYSQL_PROC_INFO = 781,
  T_FUN_SYS_GET_MYSQL_ROUTINE_PARAMETER_TYPE_STR = 782,
  T_FUN_SYS_MYSQL_TO_CHAR = 783,
  T_FUN_INNER_TYPE_TO_ENUMSET = 784,
  ///< @note add new mysql only function type before this line
  T_MYSQL_ONLY_SYS_MAX_OP = 800,

  // system function for oracle only
  T_FUN_SYS_CONNECT_BY_PATH = 1401,
  T_FUN_SYS_SYSTIMESTAMP = 1402,
  T_FUN_SYS_TO_DATE = 1403,
  T_FUN_SYS_TO_CHAR = 1404,
  T_FUN_SYS_TO_NUMBER = 1405,
  T_FUN_SYS_USERENV = 1406,
  T_FUN_SYS_SYS_CONTEXT = 1407,
  T_FUN_SYS_LENGTHB = 1408,
  T_FUN_SYS_HEXTORAW = 1409,
  T_FUN_SYS_RAWTOHEX = 1410,
  T_FUN_SYS_UTL_RAW_CAST_TO_RAW = 1411,
  T_FUN_SYS_UTL_RAW_CAST_TO_VARCHAR2 = 1412,
  T_FUN_SYS_TO_TIMESTAMP = 1413,
  T_FUN_SYS_TO_TIMESTAMP_TZ = 1414,
  T_FUN_SYS_UTL_RAW_LENGTH = 1415,
  T_FUN_SYS_UTL_RAW_BIT_AND = 1416,
  T_FUN_SYS_UTL_RAW_BIT_OR = 1417,
  T_FUN_SYS_UTL_RAW_BIT_XOR = 1418,
  T_FUN_SYS_UTL_RAW_BIT_COMPLEMENT = 1419,
  T_FUN_SYS_UTL_RAW_REVERSE = 1420,
  T_FUN_SYS_UTL_RAW_COPIES = 1421,
  T_FUN_SYS_UTL_RAW_COMPARE = 1422,
  T_FUN_SYS_UTL_RAW_SUBSTR = 1423,
  T_FUN_SYS_UTL_RAW_CONCAT = 1424,
  T_FUN_SYS_TO_CLOB = 1425,
  T_FUN_SYS_CHR = 1426,
  T_FUN_PL_INTEGER_CHECKER = 1427,
  T_FUN_PL_GET_CURSOR_ATTR = 1428,
  T_FUN_PL_ASSOCIATIVE_INDEX = 1429,
  T_FUN_SYS_SESSIONTIMEZONE = 1430,
  T_FUN_SYS_DBTIMEZONE = 1431,
  T_FUN_SYS_SYS_EXTRACT_UTC = 1432,
  T_FUN_SYS_TZ_OFFSET = 1433,
  T_FUN_SYS_FROM_TZ = 1434,
  T_FUN_SYS_DBMS_LOB_GETLENGTH = 1435,
  T_FUN_SYS_DBMS_LOB_APPEND = 1436,
  T_FUN_SYS_DBMS_LOB_READ = 1437,
  T_FUN_SYS_DBMS_LOB_CONVERTTOBLOB = 1438,
  T_FUN_SYS_DBMS_LOB_CAST_CLOB_TO_BLOB = 1439,
  T_FUN_SYS_DBMS_LOB_CONVERT_CLOB_CHARSET = 1440,
  //Lable Security, only used in oracle PL
  T_FUN_LABEL_SE_POLICY_CREATE = 1441,
  T_FUN_LABEL_SE_POLICY_ALTER = 1442,
  T_FUN_LABEL_SE_POLICY_DISABLE = 1443,
  T_FUN_LABEL_SE_POLICY_ENABLE = 1444,
  T_FUN_LABEL_SE_POLICY_DROP = 1445,
  T_FUN_LABEL_SE_LEVEL_CREATE = 1446,
  T_FUN_LABEL_SE_LEVEL_ALTER = 1447,
  T_FUN_LABEL_SE_LEVEL_DROP = 1448,
  T_FUN_LABEL_SE_COMPARTMENT_CREATE = 1449,
  T_FUN_LABEL_SE_COMPARTMENT_ALTER = 1450,
  T_FUN_LABEL_SE_COMPARTMENT_DROP = 1451,
  T_FUN_LABEL_SE_GROUP_CREATE = 1452,
  T_FUN_LABEL_SE_GROUP_ALTER = 1453,
  T_FUN_LABEL_SE_GROUP_ALTER_PARENT = 1454,
  T_FUN_LABEL_SE_GROUP_DROP = 1455,
  T_FUN_LABEL_SE_LABEL_CREATE = 1456,
  T_FUN_LABEL_SE_LABEL_ALTER = 1457,
  T_FUN_LABEL_SE_LABEL_DROP = 1458,
  T_FUN_LABEL_SE_TABLE_POLICY_APPLY = 1459,
  T_FUN_LABEL_SE_TABLE_POLICY_REMOVE = 1460,
  T_FUN_LABEL_SE_TABLE_POLICY_DISABLE = 1461,
  T_FUN_LABEL_SE_TABLE_POLICY_ENABLE = 1462,
  T_FUN_LABEL_SE_SCHEMA_POLICY_APPLY = 1463,
  T_FUN_LABEL_SE_SCHEMA_POLICY_REMOVE = 1464,
  T_FUN_LABEL_SE_SCHEMA_POLICY_DISABLE = 1465,
  T_FUN_LABEL_SE_SCHEMA_POLICY_ENABLE = 1466,
  T_FUN_LABEL_SE_USER_SET_LEVELS = 1467,
  T_FUN_LABEL_SE_USER_SET_COMPARTMENTS = 1468,
  T_FUN_LABEL_SE_USER_SET_GROUPS = 1469,
  T_FUN_LABEL_SE_USER_ADD_COMPARTMENTS = 1470,
  T_FUN_LABEL_SE_USER_ALTER_COMPARTMENTS = 1471,
  T_FUN_LABEL_SE_USER_DROP_COMPARTMENTS = 1472,
  T_FUN_LABEL_SE_USER_DROP_ALL_COMPARTMENTS = 1473,
  T_FUN_LABEL_SE_USER_ADD_GROUPS = 1474,
  T_FUN_LABEL_SE_USER_ALTER_GROUPS = 1475,
  T_FUN_LABEL_SE_USER_DROP_GROUPS = 1476,
  T_FUN_LABEL_SE_USER_DROP_ALL_GROUPS = 1477,
  T_FUN_LABEL_SE_LABEL_VALUE_CMP_LE = 1478,
  T_FUN_LABEL_SE_LABEL_VALUE_CHECK = 1479,
  T_FUN_LABEL_SE_LABEL_VALUE_TO_CHAR = 1480,
  T_FUN_LABEL_SE_CHAR_TO_LABEL_VALUE = 1481,
  T_FUN_LABEL_SE_SESSION_SET_LABEL = 1482,
  T_FUN_LABEL_SE_SESSION_SET_ROW_LABEL = 1483,
  T_FUN_LABEL_SE_SESSION_RESTORE_DEFAULT_LABEL = 1484,
  T_FUN_LABEL_SE_SESSION_SAVE_DEFAULT_LABEL = 1485,
  T_FUN_LABEL_SE_SESSION_LABEL = 1486,
  T_FUN_LABEL_SE_SESSION_ROW_LABEL = 1487,
  T_FUN_PL_SQLCODE_SQLERRM = 1488,
  T_FUN_PL_COLLECTION_CONSTRUCT = 1489,
  T_FUN_SYS_REMAINDER = 1490,

  T_FUN_PL_OBJECT_CONSTRUCT = 1491,
  T_FUN_SYS_ADD_MONTHS = 1492,
  T_FUN_SYS_LAST_DAY = 1493,
  T_FUN_SYS_MONTHS_BETWEEN = 1494,
  T_FUN_SYS_NEXT_DAY = 1495,
  T_FUN_SYS_TO_DSINTERVAL = 1496,
  T_FUN_SYS_TO_YMINTERVAL = 1497,
  T_FUN_SYS_NUMTODSINTERVAL = 1498,
  T_FUN_SYS_NUMTOYMINTERVAL = 1499,
  T_FUN_SYS_INITCAP = 1500,
  T_FUN_SYS_INSTRB = 1501,
  T_FUN_SYS_SUBSTRB = 1502,
  T_FUN_SYS_LENGTHC = 1503,
  T_FUN_SYS_SUBSTRC = 1504,
  T_FUN_SYS_INSTRC = 1505,
  T_FUN_SYS_POWER = 1506,
  T_FUN_SYS_LN = 1507,
  T_FUN_SYS_LOG = 1508,
  T_FUN_SYS_WIDTH_BUCKET = 1509,
  T_FUN_SYS_TRANSLATE = 1510,
  T_FUN_SYS_ASIN = 1511,
  T_FUN_SYS_ACOS = 1512,
  T_FUN_SYS_ATAN = 1513,
  T_FUN_SYS_ATAN2 = 1514,
  T_FUN_SYS_REGEXP_COUNT = 1515,
  T_FUN_NVL2 = 1516,
  T_FUN_SYS_TO_BINARY_FLOAT = 1517,
  T_FUN_SYS_TO_BINARY_DOUBLE = 1518,
  T_FUN_SYS_NANVL = 1519,
  T_FUN_SYS_COS = 1520,
  T_FUN_SYS_TAN = 1521,
  T_FUN_SYS_SIN = 1522,
  T_FUN_SYS_SINH = 1523,
  T_FUN_SYS_COSH = 1524,
  T_FUN_SYS_TANH = 1525,
  T_FUN_SYS_VSIZE = 1526,
  T_FUN_SYS_ORAHASH = 1527,
  T_FUN_SYS_PL_SEQ_NEXT_VALUE = 1528,
  T_FUN_SYS_GUID = 1529,
  T_FUN_SYS_TO_SINGLE_BYTE = 1530,
  T_FUN_SYS_TO_MULTI_BYTE = 1531,
  T_FUN_SYS_UTL_I18N_STRING_TO_RAW = 1532,
  T_FUN_SYS_UTL_I18N_RAW_TO_CHAR = 1533,
  T_FUC_SYS_DBMS_CRYPTO_ENCRYPT = 1534,
  T_FUC_SYS_DBMS_CRYPTO_DECRYPT = 1535,
  T_FUN_SYS_TO_NCHAR = 1536,
  T_FUN_SYS_SET = 1537,
  T_FUN_SYS_CARDINALITY = 1538,
  T_FUN_CORR = 1539,
  T_FUN_COVAR_POP = 1540,
  T_FUN_COVAR_SAMP = 1541,
  T_FUN_VAR_POP = 1542,
  T_FUN_VAR_SAMP = 1543,
  T_FUN_REGR_SLOPE = 1544,
  T_FUN_REGR_INTERCEPT = 1545,
  T_FUN_REGR_COUNT = 1546,
  T_FUN_REGR_R2 = 1547,
  T_FUN_REGR_AVGX = 1548,
  T_FUN_REGR_AVGY = 1549,
  T_FUN_REGR_SXX = 1550,
  T_FUN_REGR_SYY = 1551,
  T_FUN_REGR_SXY = 1552,
  T_FUN_SYS_UTL_INADDR_GET_HOST_ADDR = 1553,
  T_FUN_SYS_UTL_INADDR_GET_HOST_NAME = 1554,
  T_FUN_GROUP_RANK = 1555,
  T_FUN_GROUP_PERCENT_RANK = 1556,
  T_FUN_GROUP_DENSE_RANK = 1557,
  T_FUN_GROUP_CUME_DIST = 1558,
  T_FUN_KEEP_MAX = 1559,
  T_FUN_KEEP_MIN = 1560,
  T_FUN_KEEP_SUM = 1561,
  T_FUN_KEEP_COUNT = 1562,
  T_FUN_KEEP_AVG = 1563,
  T_FUN_KEEP_VARIANCE = 1564,
  T_FUN_KEEP_STDDEV = 1565,
  T_FUN_MEDIAN = 1566,
  T_FUN_GROUP_PERCENTILE_CONT = 1567,
  T_FUN_GROUP_PERCENTILE_DISC = 1568,
  T_FUN_SYS_USER_CAN_ACCESS_OBJ = 1569,
  T_FUN_EMPTY_CLOB = 1570,
  T_FUN_EMPTY_BLOB = 1571,
  T_FUN_SYS_ROWID_TO_CHAR = 1572,
  T_FUN_SYS_ROWID_TO_NCHAR = 1573,
  T_FUN_SYS_CHAR_TO_ROWID = 1574,
  T_FUN_SYS_TO_BLOB = 1575,
  T_FUN_SYS_NLS_LOWER = 1576,
  T_FUN_SYS_NLS_UPPER = 1577,
  T_FUN_KEEP_WM_CONCAT = 1578,
  T_FUN_WM_CONCAT = 1579,
  T_FUN_TOP_FRE_HIST = 1580,
  T_FUN_UNISTR = 1581,
  T_FUN_PLSQL_VARIABLE = 1582,
  T_FUN_ASCIISTR = 1583,
  T_FUN_PL_AGG_UDF = 1584,
  T_FUN_SYS_AT_TIME_ZONE = 1585,
  T_FUN_SYS_AT_LOCAL = 1586,
  T_FUN_HYBRID_HIST = 1587,
  T_FUN_RETURNING_LOB = 1588,
  T_FUN_SYS_TIMESTAMP = 1589,
  T_FUN_SYS_GET_FORMAT = 1590,
  T_FUN_SYS_MAKEDATE = 1591,
  T_FUN_SYS_PERIOD_ADD = 1592,
  T_FUN_SYS_UTC_TIME = 1593,
  T_FUN_SYS_UTC_DATE = 1594,
  T_FUN_SYS_TIME_FORMAT = 1595,
  T_FUN_SYS_WRAPPER_INNER = 1596,
  T_FUN_SYS_RAWTONHEX = 1597,
  T_FUN_SYS_DML_EVENT = 1598,
  T_FUN_GROUPING_ID = 1599,
  T_FUN_GROUP_ID = 1600,
  T_FUN_SYS_NLSSORT = 1601,
  T_FUN_SYS_JSON_OBJECT = 1602,
  T_FUN_SYS_JSON_EXTRACT = 1603,
  T_FUN_SYS_JSON_CONTAINS = 1604,
  T_FUN_SYS_JSON_CONTAINS_PATH = 1605,
  T_FUN_SYS_JSON_DEPTH = 1606,
  T_FUN_SYS_JSON_KEYS = 1607,
  T_FUN_SYS_JSON_ARRAY = 1608,
  T_FUN_SYS_JSON_QUOTE = 1609,
  T_FUN_SYS_JSON_UNQUOTE = 1610,
  T_FUN_SYS_JSON_OVERLAPS = 1611,
  T_FUN_SYS_JSON_REMOVE = 1612,
  T_FUN_SYS_JSON_SEARCH = 1613,
  T_FUN_SYS_JSON_VALID = 1614,
  T_FUN_SYS_JSON_ARRAY_APPEND = 1615,
  T_FUN_SYS_JSON_ARRAY_INSERT = 1616,
  T_FUN_SYS_JSON_REPLACE = 1617,
  T_FUN_SYS_JSON_TYPE = 1618,
  T_FUN_SYS_JSON_LENGTH = 1619,
  T_FUN_SYS_JSON_INSERT = 1620,
  T_FUN_SYS_JSON_STORAGE_SIZE = 1621,
  T_FUN_SYS_JSON_STORAGE_FREE = 1622,
  T_FUN_SYS_JSON_MERGE_PRESERVE = 1623,
  T_FUN_SYS_JSON_MERGE = 1624,
  T_FUN_SYS_JSON_MERGE_PATCH = 1625,
  T_FUN_SYS_JSON_PRETTY = 1626,
  T_FUN_SYS_JSON_SET = 1627,
  T_FUN_SYS_JSON_MEMBER_OF = 1628,
  T_FUN_SYS_JSON_VALUE = 1629,
  T_FUN_JSON_ARRAYAGG = 1630,
  T_FUN_JSON_OBJECTAGG = 1631,
// please modify need_calc_json_as_text if other json functions are added
  T_FUN_SYS_INNER_AGGR_CODE = 1632,
  //T_FUN_SYS_TIMESTAMP_TO_SCN and T_FUN_SYS_SCN_TO_TIMESTAMP are supported both in mysql and oracle
  T_FUN_SYS_TIMESTAMP_TO_SCN = 1633,
  T_FUN_SYS_SCN_TO_TIMESTAMP = 1634,

  T_FUN_SYS_ST_LONGITUDE = 1635,
  T_FUN_SYS_ST_TRANSFORM = 1636,
  T_FUN_SYS_POINT = 1637,
  T_FUN_SYS_LINESTRING = 1638,
  T_FUN_SYS_MULTIPOINT = 1639,
  T_FUN_SYS_MULTILINESTRING = 1640,
  T_FUN_SYS_POLYGON = 1641,
  T_FUN_SYS_MULTIPOLYGON = 1642,
  T_FUN_SYS_GEOMCOLLECTION = 1643,
  T_FUN_SYS_ST_COVERS = 1644,
  T_FUN_SYS_PRIV_ST_BESTSRID = 1645,
  T_FUN_SYS_ST_ASTEXT = 1646,
  T_FUN_SYS_ST_BUFFER_STRATEGY = 1647,
  T_FUN_SYS_ST_BUFFER = 1648,
  T_FUN_SYS_SPATIAL_CELLID = 1649,
  T_FUN_SYS_SPATIAL_MBR = 1650,
  T_FUN_SYS_ST_GEOMFROMEWKB = 1651,
  T_FUN_SYS_ST_GEOMFROMWKB = 1652,
  T_FUN_SYS_ST_GEOMETRYFROMWKB = 1653,
  T_FUN_SYS_ST_GEOMFROMEWKT = 1654,
  T_FUN_SYS_PRIV_ST_ASEWKT = 1655,
  T_FUN_SYS_ST_SRID = 1656,
  T_FUN_SYS_ST_ASWKT = 1657,
  T_FUN_SYS_ST_DISTANCE = 1658,
  T_FUN_SYS_ST_GEOMETRYFROMTEXT = 1659,
  T_FUN_SYS_PRIV_ST_SETSRID = 1660,
  T_FUN_SYS_PRIV_ST_POINT = 1661,
  T_FUN_SYS_PRIV_ST_GEOGFROMTEXT = 1662,
  T_FUN_SYS_PRIV_ST_GEOGRAPHYFROMTEXT = 1663,
  T_FUN_SYS_ST_ISVALID = 1664,
  T_FUN_SYS_PRIV_ST_BUFFER = 1665,
  T_FUN_SYS_ST_ASWKB = 1666,
  T_FUN_SYS_PRIV_ST_ASEWKB = 1667,
  T_FUN_SYS_ST_ASBINARY = 1668,
  T_FUN_SYS_ST_DISTANCE_SPHERE = 1669,
  T_FUN_SYS_ST_DWITHIN = 1670,
  T_FUN_SYS_ST_WITHIN = 1671,
  T_FUN_SYS_ST_CONTAINS = 1672,
  T_FUN_SYS_PRIV_ST_TRANSFORM = 1673,
  T_FUN_SYS_ST_GEOMFROMTEXT = 1674,
  T_FUN_SYS_ST_INTERSECTION = 1675,
  T_FUN_SYS_ST_AREA = 1676,
  T_FUN_SYS_ST_INTERSECTS = 1677,
  T_FUN_SYS_ST_X = 1678,
  T_FUN_SYS_ST_Y = 1679,
  T_FUN_SYS_ST_LATITUDE = 1680,
  // gis expr should add above
  // please maintain is_geo_expr / is_mysql_geo_expr / is_priv_geo_expr if other gis expr added

  T_FUN_SYS_IS_JSON = 1681,
  T_FUN_SYS_JSON_EQUAL = 1682,
  T_FUN_SYS_JSON_QUERY = 1683,
  T_FUN_ORA_JSON_ARRAYAGG = 1684,
  T_FUN_ORA_JSON_OBJECTAGG = 1685,
  T_FUN_SYS_JSON_EXISTS = 1686,
  T_FUN_SYS_TREAT = 1687,
  T_NULLX_CLAUSE = 1688,   // null clause on json expr
  T_FUN_SYS_NLS_INITCAP = 1689,
  T_WEIGHT_STRING_LEVEL_PARAM = 1690, // `level 1-2` and `level 1,2,3` clause on json expr
  T_FUN_SYS_CURRENT_SCN = 1691,
  T_FUN_SYS_MAKEXML = 1692,
  T_FUN_SYS_XML_ELEMENT = 1693,
  T_FUN_SYS_XMLPARSE = 1694,
  T_FUN_ORA_XMLAGG = 1695,
  T_FUN_SYS_XML_ATTRIBUTES = 1696,
  T_FUN_SYS_XML_EXTRACTVALUE = 1697,
  T_FUN_SYS_XML_EXTRACT = 1698,
  T_FUN_SYS_XML_SERIALIZE = 1699,
  T_FUN_SYS_XMLCAST = 1700,
  T_FUN_SYS_XML_ATTRIBUTES_VALUES = 1701,
  T_FUN_SYS_UPDATE_XML = 1702,
  T_FUN_SYS_PRIV_MAKE_XML_BINARY = 1703,  // add only for xml dml rewrite
  T_FUN_SYS_JSON_OBJECT_WILD_STAR = 1704, // wild star in json object
  T_FUN_SYS_JSON_SCHEMA_VALID = 1705,         // mysql json schema func
  T_FUN_SYS_JSON_SCHEMA_VALIDATION_REPORT = 1706,
  T_FUN_SYS_JSON_APPEND = 1707,
  T_FUN_SYS_INSERTCHILDXML = 1708,
  T_FUN_SYS_DELETEXML = 1709,
  T_FUN_SYS_XMLSEQUENCE = 1710,
  T_FUN_SYS_PRIV_SQL_UDT_CONSTRUCT = 1711,  // add only for udt default constructor in sql
  T_FUN_SYS_PRIV_SQL_UDT_ATTR_ACCESS = 1712,  // add only for sql udt access attribute in sql
  T_FUN_SYS_PRIV_ST_NUMINTERIORRINGS = 1713,
  T_FUN_SYS_PRIV_ST_ISCOLLECTION = 1714,
  T_FUN_SYS_PRIV_ST_EQUALS = 1715,
  T_FUN_SYS_PRIV_ST_TOUCHES = 1716,
  T_FUN_SYS_PRIV_ST_MAKEENVELOPE = 1717,
  T_FUN_SYS_PRIV_ST_CLIPBYBOX2D = 1718,
  T_FUN_SYS_PRIV_ST_POINTONSURFACE = 1719,
  T_FUN_SYS_PRIV_ST_GEOMETRYTYPE = 1720,
  T_FUN_SYS_ST_CROSSES = 1721,
  T_FUN_SYS_ST_OVERLAPS = 1722,
  T_FUN_SYS_ST_UNION = 1723,
  T_FUN_SYS_ST_LENGTH = 1724,
  T_FUN_SYS_ST_DIFFERENCE = 1725,
  T_FUN_SYS_ST_ASMVT = 1726,
  T_FUN_SYS_ST_ASGEOJSON = 1727,
  T_FUN_SYS_ST_CENTROID = 1728,
  T_FUN_SYS_ST_SYMDIFFERENCE = 1729,
  T_FUN_SYS_PRIV_ST_ASMVTGEOM = 1730,
  T_FUN_SYS_PRIV_ST_MAKE_VALID = 1731,
  T_FUN_SYS_XML_CONCAT = 1732,
  T_FUN_SYS_XML_FOREST = 1733,
  T_FUN_SYS_XML_EXISTSNODE = 1734,
  T_FUN_SYS_PRIV_ST_GEOHASH = 1735,
  T_FUN_SYS_PRIV_ST_MAKEPOINT = 1736,
  T_FUN_SYS_ARRAY = 1737,
  T_FUN_SYS_L1_DISTANCE = 1738,
  T_FUN_SYS_L2_DISTANCE = 1739,
  T_FUN_SYS_INNER_PRODUCT = 1740,
  T_FUN_SYS_COSINE_DISTANCE = 1741,
  T_FUN_SYS_VECTOR_DIMS = 1742,
  T_FUN_SYS_VECTOR_NORM = 1743,
  T_FUN_SYS_VECTOR_DISTANCE = 1744,
  T_FUNC_SYS_ARRAY_CONTAINS = 1745,
  T_FUN_SYS_NEGATIVE_INNER_PRODUCT = 1746,
  T_FUNC_SYS_ARRAY_OVERLAPS = 1747,
  T_FUNC_SYS_ARRAY_CONTAINS_ALL = 1748,
  T_FUNC_SYS_ARRAY_AGG = 1749,
  T_FUNC_SYS_ARRAY_DISTINCT = 1750,
  T_FUNC_SYS_ARRAY_REMOVE = 1751,
  T_FUNC_SYS_ARRAY_MAP = 1752,
  T_FUNC_SYS_LAMBDA = 1753,
  T_FUN_SYS_ORA_LOGIN_USER = 1754,
  T_FUNC_SYS_ARRAY_TO_STRING = 1755,
  T_FUNC_SYS_STRING_TO_ARRAY = 1756,
  T_FUNC_SYS_ARRAY_APPEND = 1757,
  T_FUNC_SYS_ELEMENT_AT = 1758,
  T_FUNC_SYS_ARRAY_CARDINALITY = 1759,
  T_FUNC_SYS_RB_BUILD = 1760,
  T_FUNC_SYS_ARRAY_PREPEND = 1761,
  T_FUNC_SYS_ARRAY_CONCAT = 1762,
  T_FUNC_SYS_ARRAY_DIFFERENCE = 1763,
  T_FUNC_SYS_ARRAY_FIRST = 1764,
  T_FUNC_SYS_ARRAY_MAX = 1765,
  T_FUNC_SYS_ARRAY_MIN = 1766,
  T_FUNC_SYS_ARRAY_AVG = 1767,
  T_FUNC_SYS_ARRAY_SUM = 1768,
  T_FUNC_SYS_ARRAY_COMPACT = 1769,
  T_FUNC_SYS_ARRAY_SORT = 1770,
  T_FUN_SYS_TO_PINYIN = 1771,
  T_FUNC_SYS_ARRAY_SLICE = 1772,
  T_FUNC_SYS_ARRAY_SORTBY = 1773,
  T_FUNC_SYS_ARRAY_FILTER = 1774,
  T_FUNC_SYS_ARRAY_LENGTH = 1775,
  T_FUNC_SYS_ARRAY_RANGE = 1776, // FARM COMPAT WHITELIST
  T_FUNC_SYS_ARRAY_POSITION = 1777,
  T_FUNC_SYS_ARRAY_EXCEPT = 1778,
  T_FUNC_SYS_ARRAY_INTERSECT = 1779,
  T_FUNC_SYS_ARRAY_UNION = 1780,
  T_FUNC_SYS_ARRAY_REPLACE = 1781,
  T_FUNC_SYS_ARRAY_POPFRONT = 1782,
  ///< @note add new oracle only function type before this line

  T_FUN_SYS_TABLET_AUTOINC_NEXTVAL = 1801, // add only for heap table
  T_FUN_SYS_GENERATOR = 1802,
  T_FUN_SYS_ZIPF = 1803,
  T_FUN_SYS_NORMAL = 1804,
  T_FUN_SYS_UNIFORM = 1805,
  T_FUN_SYS_RANDOM = 1806,
  T_FUN_SYS_RANDSTR = 1807,
  T_FUNC_SYS_INNER_IS_TRUE = 1808,
  T_FUN_SYS_INNER_DECODE_LIKE = 1809,
  T_FUN_SYS_DOC_ID = 1810,
  T_FUN_SYS_WORD_COUNT = 1811,
  T_FUN_SYS_BM25 = 1812,
  T_FUN_SYS_TRANSACTION_ID = 1813,
  T_FUN_SYS_INNER_TABLE_OPTION_PRINTER = 1814,
  T_FUN_SYS_INNER_TABLE_SEQUENCE_GETTER = 1815,
  T_FUN_SYS_DECODE_TRACE_ID = 1816,
  T_FUN_SYS_DOC_LENGTH = 1817,
  T_FUN_SYS_GET_PATH = 1818,
  T_FUN_SYS_INNER_DOUBLE_TO_INT = 1819,
  T_FUN_SYS_INNER_DECIMAL_TO_YEAR = 1820,
  T_FUN_SYS_SPLIT_PART = 1821,
  T_FUN_SYS_KEYVALUE = 1822,
  T_FUN_SYS_VEC_VID = 1900,   // vector index
  T_FUN_SYS_VEC_TYPE = 1901,
  T_FUN_SYS_VEC_VECTOR = 1902,
  T_FUN_SYS_VEC_SCN = 1903,
  T_FUN_SYS_VEC_KEY = 1904,
  T_FUN_SYS_VEC_DATA = 1905,
  T_FUN_SYS_VEC_IVF_CENTER_ID = 1906,   // ivf vector index
  T_FUN_SYS_VEC_IVF_CENTER_VECTOR = 1907,
  T_FUN_SYS_VEC_IVF_FLAT_DATA_VECTOR = 1908,
  T_FUN_SYS_VEC_IVF_SQ8_DATA_VECTOR = 1909,
  T_FUN_SYS_VEC_IVF_META_ID = 1910,
  T_FUN_SYS_VEC_IVF_META_VECTOR = 1911,
  T_FUN_SYS_VEC_IVF_PQ_CENTER_ID = 1912,
  T_FUN_SYS_VEC_IVF_PQ_CENTER_IDS = 1913,
  T_FUN_SYS_VEC_IVF_PQ_CENTER_VECTOR = 1914,
  T_FUN_SYS_CURRENT_CATALOG = 1915,
  T_FUN_SYS_END = 2000,
  T_FUN_SYS_ALIGN_DATE4CMP = 2010,
  T_FUN_SYS_INNER_ROW_CMP_VALUE = 2011,
  T_FUN_SYS_GTID_SUBSET = 2012,
  T_FUN_SYS_GTID_SUBTRACT = 2013,
  T_FUN_SYS_WAIT_FOR_EXECUTED_GTID_SET = 2014,
  T_FUN_SYS_WAIT_UNTIL_SQL_THREAD_AFTER_GTIDS = 2015,
  T_FUN_SYS_LAST_REFRESH_SCN = 2016,
  T_FUN_SUM_OPNSIZE = 2017,
  T_FUN_SYS_GET_LOCK = 2018,
  T_FUN_SYS_IS_FREE_LOCK = 2019,
  T_FUN_SYS_IS_USED_LOCK = 2020,
  T_FUN_SYS_RELEASE_LOCK = 2021,
  T_FUN_SYS_RELEASE_ALL_LOCKS = 2022,
  T_FUN_SYS_RB_BUILD_EMPTY = 2023,
  T_FUN_SYS_RB_IS_EMPTY = 2024,
  T_FUN_SYS_RB_BUILD_VARBINARY = 2025,
  T_FUN_SYS_RB_TO_VARBINARY = 2026,
  T_FUN_SYS_RB_BUILD_AGG = 2027,
  T_FUN_SYS_RB_OR_AGG = 2028,
  T_FUN_SYS_SDO_RELATE = 2029,
  T_FUN_SYS_RB_AND_AGG = 2030,
  T_FUN_SYS_RB_CARDINALITY = 2031,
  T_FUN_SYS_RB_AND_CARDINALITY = 2032,
  T_FUN_SYS_RB_OR_CARDINALITY = 2033,
  T_FUN_SYS_RB_XOR_CARDINALITY = 2034,
  T_FUN_SYS_RB_ANDNOT_CARDINALITY = 2035,
  T_FUN_SYS_RB_AND_NULL2EMPTY_CARDINALITY = 2036,
  T_FUN_SYS_RB_OR_NULL2EMPTY_CARDINALITY = 2037,
  T_FUN_SYS_RB_ANDNOT_NULL2EMPTY_CARDINALITY = 2038,
  T_FUN_SYS_RB_AND = 2039,
  T_FUN_SYS_RB_OR = 2040,
  T_FUN_SYS_RB_XOR = 2041,
  T_FUN_SYS_RB_ANDNOT = 2042,
  T_FUN_SYS_RB_AND_NULL2EMPTY = 2043,
  T_FUN_SYS_RB_OR_NULL2EMPTY = 2044,
  T_FUN_SYS_RB_ANDNOT_NULL2EMPTY = 2045,
  T_FUN_SYS_RB_TO_STRING = 2046,
  T_FUN_SYS_RB_FROM_STRING = 2047,
  T_FUN_SYS_RB_ITERATE = 2048,
  T_FUN_SYS_RB_SELECT = 2049,
  T_FUN_TOKENIZE = 2050,
  T_FUN_SYS_CALC_SUB_PARTITION_ID = 2051,
  T_FUN_SYS_CALC_PARTITION_NAME = 2052,
  T_FUN_SYS_CALC_SUB_PARTITION_NAME = 2053,
  T_FUN_SYS_CALC_PARTITION_IDX = 2054,
  T_FUN_SYS_CALC_SUB_PARTITION_IDX = 2055,
  T_FUN_SYS_CALC_ODPS_SIZE = 2056,
  T_FUN_URL_ENCODE = 2057,
  T_FUN_URL_DECODE = 2058,
  T_FUN_SYS_DEMOTE_CAST = 2059,
  T_FUN_SYS_RANGE_PLACEMENT = 2060,
  T_FUN_SYS_INNER_INFO_COLS_COLUMN_DEF_PRINTER = 2061,
  T_FUN_SYS_INNER_INFO_COLS_CHAR_LEN_PRINTER = 2062,
  T_FUN_SYS_INNER_INFO_COLS_CHAR_NAME_PRINTER = 2063,
  T_FUN_SYS_INNER_INFO_COLS_COLL_NAME_PRINTER = 2064,
  T_FUN_SYS_INNER_INFO_COLS_PRIV_PRINTER = 2065,
  T_FUN_SYS_INNER_INFO_COLS_EXTRA_PRINTER = 2066,
  T_FUN_SYS_INNER_INFO_COLS_DATA_TYPE_PRINTER = 2067,
  T_FUN_SYS_INNER_INFO_COLS_COLUMN_TYPE_PRINTER = 2068,
  T_FUN_SYS_RB_OR_CARDINALITY_AGG = 2069,
  T_FUN_SYS_RB_AND_CARDINALITY_AGG = 2070,
  T_FUN_SYS_RB_TO_ARRAY = 2071,
  T_FUN_SYS_RB_CONTAINS = 2072,
  T_MAX_OP = 3000,

  //pseudo column, to mark the group iterator id
  T_PSEUDO_GROUP_ID = 3003,

  T_INNER_AGGR_CODE = 3004,
  T_PSEUDO_SORT_KEY = 3005,
  T_PSEUDO_CALC_PART_SORT_KEY = 3006,
  T_PSEUDO_ROLLUP_ID = 3007,
  T_PSEUDO_DUP_EXPR = 3008,
  T_PSEUDO_STMT_ID = 3009,
  T_PSEUDO_RANDOM = 3010,
  T_INNER_WF_AGGR_STAUTS = 3011,
  T_PSEUDO_ROW_TRANS_INFO_COLUMN = 3012, // trans_info, only for defensive check
  T_PSEUDO_IDENTIFY_SEQ = 3013,
  T_PSEUDO_ROLLUP_GROUPING_ID = 3014,
  T_PSEUDO_GROUP_PARAM = 3040,
  T_PSEUDO_EXTERNAL_FILE_COL = 3041,
  T_PSEUDO_RELEVANCE_SCORE = 3042, // relecance score for sparse retireval
  T_PSEUDO_EXTERNAL_FILE_URL = 3043,
  T_PSEUDO_DDL_SLICE_ID = 3044,
  T_WINDOW_FUNCTION = 3151,
  T_WIN_GENERALIZED_WINDOW = 3152,
  T_WIN_NEW_GENERALIZED_WINDOW = 3153,
  T_WIN_WINDOW = 3154,
  T_WIN_NAMED_WINDOWS = 3155,
  T_WIN_NAMED_WINDOW = 3156,
  T_WIN_BOUND = 3157,
  T_WIN_INTERVAL = 3158,
  T_WIN_FUN_ROW_NUMBER = 3159,
  T_WIN_FUN_RANK = 3160,
  T_WIN_FUN_DENSE_RANK = 3161,
  T_WIN_FUN_PERCENT_RANK = 3162,
  T_WIN_FUN_SUM = 3163,
  T_WIN_FUN_MAX = 3164,
  T_WIN_FUN_NTILE = 3165,
  T_WIN_FUN_NTH_VALUE = 3166,
  T_WIN_FUN_FIRST_VALUE = 3167,
  T_WIN_FUN_LAST_VALUE = 3168,
  T_WIN_FUN_CUME_DIST = 3169,
  T_WIN_FUN_LEAD = 3170,
  T_WIN_FUN_LAG = 3171,
  T_WIN_FUN_AVG = 3172,
  T_WIN_FUN_RATIO_TO_REPORT = 3173,
  T_TABLET_AUTOINC_NEXTVAL = 3266, // hidden_pk for heap table

  ///< @note values of the following symbols are insiginificant
  T_DEFAULT = 3267,
  T_CAST_ARGUMENT = 3268,
  T_CHAR_CHARSET = 3269,
  T_HINT = 3270,     // Hint message from rowkey
  T_IDENT = 3271,
  T_SIMPLE_IDENT = 3272,
  T_STAR = 3273,
  T_SYSTEM_VARIABLE = 3274,
  T_USER_VARIABLE_IDENTIFIER = 3275,
  T_LEFT_VALUE = 3276,//assignment

  /* Data type tags */
  T_TYPE_INTEGER = 3277,
  T_TYPE_FLOAT = 3278,
  T_TYPE_DOUBLE = 3279,
  T_TYPE_DECIMAL = 3280,
  T_TYPE_BOOLEAN = 3281,
  T_TYPE_YEAR = 3282,
  T_TYPE_DATE = 3283,
  T_TYPE_TIME = 3284,
  T_TYPE_DATETIME = 3285,
  T_TYPE_TIMESTAMP = 3286,
  T_TYPE_CHARACTER = 3287,
  T_TYPE_VARCHAR = 3288,
  T_TYPE_NUMBER = 3289,

  /* name field specificator */
  T_COLUMN_REF = 3290,
  T_RELATION_FACTOR = 3291,
  T_RELATION_FACTOR_IN_HINT = 3292,
  T_RELATION_FACTOR_IN_HINT_LIST = 3293,

  /* parse tree node tags */
  /* insert parse tree node type*/
  T_INSERT = 3294,
  T_INSERT_INTO_CLAUSE = 3295,
  T_VALUE_LIST = 3296,
  T_SINGLE_TABLE_INSERT = 3297,

  T_DELETE = 3298,
  T_SELECT = 3299,
  T_UPDATE = 3300,
  T_MERGE = 3301,
  T_REPLACE = 3302,
  T_EXPLAIN = 3303,
  T_LINK_NODE = 3304,
  T_ASSIGN_LIST = 3305,
  T_ASSIGN_ITEM = 3306,
  T_STMT_LIST = 3307,
  T_EXPR_LIST = 3308,
  T_WHEN_LIST = 3309,
  T_PROJECT_LIST = 3310,
  T_PROJECT_ITEM = 3311,
  T_FROM_LIST = 3312,
  T_TABLE_REFERENCES = 3313,
  T_DELETE_TABLE_NODE = 3314,
  T_SET_UNION = 3315,
  T_SET_INTERSECT = 3316,
  T_SET_EXCEPT = 3317,
  T_CONNECT_BY_CLAUSE = 3318,
  T_NOCYCLE = 3319,
  T_SIBLINGS = 3320,
  T_WHERE_CLAUSE = 3321,
  T_GROUPBY_CLAUSE = 3322,
  T_GROUPBY_LIST = 3323,
  T_GROUPBY_KEY = 3324,
  T_ROLLUP = 3325,
  T_LIMIT_CLAUSE = 3326,
  T_COMMA_LIMIT_CLAUSE = 3327,
  T_LIKE_CLAUSE = 3328,
  T_SEPARATOR_CLAUSE = 3329,
  T_INTO_CLAUSE = 3330,
  T_INTO_OUTFILE = 3331,
  T_INTO_DUMPFILE = 3332,
  T_INTO_VARIABLES = 3333,
  T_SORT_LIST = 3334,
  T_SORT_KEY = 3335,
  T_SORT_ASC = 3336,
  T_SORT_DESC = 3337,
  T_ROLLUP_KEY = 3338,
  T_ROLLUP_DELIMIT = 3339,
  T_ALL = 3340,
  T_ANY = 3341,
  T_DISTINCT = 3342,
  T_ORG = 3343,
  T_ALIAS = 3344,
  T_PROJECT_STRING = 3345,
  T_COLUMN_LIST = 3346,
  T_VALUE_VECTOR = 3347,
  T_JOINED_TABLE = 3348,
  T_JOIN_INNER = 3349,
  T_JOIN_FULL = 3350,
  T_JOIN_LEFT = 3351,
  T_JOIN_RIGHT = 3352,
  T_JOIN_CROSS = 3353,
  T_NATURAL_JOIN = 3354,
  T_STRAIGHT_JOIN = 3355,
  T_CASE = 3356,
  T_WHEN = 3357,
  T_CREATE_TABLE = 3358,
  T_CREATE_TABLE_LIKE = 3359,
  T_CREATE_VIEW = 3360,
  T_ALTER_VIEW = 3361,
  T_TABLE_ELEMENT_LIST = 3362,
  T_TABLE_OPTION_LIST = 3363,
  T_PRIMARY_KEY = 3364,
  T_SPLIT_KEY = 3365,
  T_COLUMN_DEFINITION = 3366,
  T_COLUMN_ATTRIBUTES = 3367,
  T_CONSTR_NOT_NULL = 3368,
  T_CONSTR_NULL = 3369,
  T_CONSTR_DEFAULT = 3370,
  T_CONSTR_ORIG_DEFAULT = 3371,
  T_CONSTR_AUTO_INCREMENT = 3372,
  T_CONSTR_PRIMARY_KEY = 3373,
  T_CONSTR_UNIQUE_KEY = 3374,
  T_CONSTR_SRID = 3375,
  T_CHECK_CONSTRAINT = 3376,
  T_RESPECT = 3377,
  T_FIRST = 3378,
  T_LAST = 3379,
  T_VIRTUAL_COLUMN = 3380,
  T_STORED_COLUMN = 3381,
  T_IF_NOT_EXISTS = 3382,
  T_IF_EXISTS = 3383,
  T_JOIN_INFO = 3384,
  T_EXPIRE_INFO = 3385,
  T_TABLET_MAX_SIZE = 3386,
  T_BLOCK_SIZE = 3387,
  T_TABLE_ID = 3388,
  T_DATA_TABLE_ID = 3389,
  T_INDEX_TABLE_ID = 3390,
  T_TABLET_ID = 3391,
  T_TENANT_TABLET = 3392,
  T_TENANT_LS_TABLET = 3393,
  T_VIRTUAL_COLUMN_ID = 3394,
  T_DATABASE_ID = 3395,
  T_REPLICA_NUM = 3396,
  T_TABLET_SIZE = 3397,
  T_LOCALITY = 3398,
  T_DUPLICATE_SCOPE = 3399,
  T_LOGONLY_REPLICA_NUM = 3400,
  T_TABLEGROUP = 3401,
  T_COMPRESSION = 3402,
  T_PROGRESSIVE_MERGE_NUM = 3403,
  T_COMMENT = 3404,
  T_COLUMN_ID = 3405,
  T_ON_UPDATE = 3406,
  T_USE_BLOOM_FILTER = 3407,
  T_CHARSET = 3408,
  T_COLLATION = 3409,
  T_INDEX_SCOPE = 3410,
  T_DROP_TABLE = 3411,
  T_TABLE_LIST = 3412,
  T_DROP_VIEW = 3413,
  T_VIEW_LIST = 3414,
  T_PARTITION_OPTION = 3415,
  T_HASH_PARTITION = 3416,
  T_KEY_PARTITION = 3417,
  T_RANGE_PARTITION = 3418,
  T_RANGE_COLUMNS_PARTITION = 3419,
  T_LIST_PARTITION = 3420,
  T_LIST_COLUMNS_PARTITION = 3421,
  T_VERTICAL_COLUMNS_PARTITION = 3422,
  T_AUX_COLUMN_LIST = 3423,
  T_ADDR_PARTITION = 3424,
  T_PARTITION_LIST = 3425,
  T_PARTITION_ELEMENT = 3426,
  T_PART_ID = 3427,
  T_CREATE_SEQUENCE = 3428,
  T_DROP_SEQUENCE = 3429,
  T_ALTER_SEQUENCE = 3430,
  T_SEQUENCE_OPTION_LIST = 3431,
  T_REMOTE_SEQUENCE = 3432,
  T_INCREMENT_BY = 3433,
  T_START_WITH = 3434,
  T_MAXVALUE = 3435,
  T_NOMAXVALUE = 3436,
  T_MINVALUE = 3437,
  T_NOMINVALUE = 3438,
  T_CYCLE = 3439,
  /*T_NOCYCLE, defined */
  T_ORDER = 3440,
  T_NOORDER = 3441,
  T_CACHE = 3442,
  T_NOCACHE = 3443,
  T_RESTART = 3444,
  T_SIGNED = 3445,
  T_UNSIGNED = 3446,
  T_ZEROFILL = 3447,
  T_USE_PARTITION = 3448,
  T_AUTO_INCREMENT = 3449,
  T_AUTO_INCREMENT_MODE = 3450,
  T_ENABLE_EXTENDED_ROWID = 3451,
  T_USING_HASH = 3452,
  T_USING_BTREE = 3453,
  T_WITH_CLAUSE_AS = 3454,
  T_WITH_CLAUSE_LIST = 3455,
  T_CYCLE_NODE = 3456,
  T_SEARCH_BREADTH_NODE = 3457,
  T_SEARCH_DEPTH_NODE = 3458,
  T_EXPR_WITH_ALIAS = 3459,
  T_TABLE_COLLECTION_EXPRESSION = 3460,
  T_DIAGNOSTICS = 3461,
  T_JSON_TABLE_EXPRESSION = 3462,
  T_JSON_TABLE_COLUMN = 3463,
  //pseudo_column
  T_PSEUDO_COLUMN = 3464,
  T_LEVEL = 3465,
  T_CONNECT_BY_ISCYCLE = 3466,
  T_CONNECT_BY_ISLEAF = 3467,
  T_CTE_SEARCH_COLUMN = 3468,
  T_CTE_CYCLE_COLUMN = 3469,

  T_RENAME_TABLE = 3470,
  T_RENAME_TABLE_ACTION = 3471,
  T_TRUNCATE_TABLE = 3472,
  T_ALTER_TABLE = 3473,
  T_ALTER_TABLE_OPTION = 3474,
  T_ALTER_INDEX_OPTION = 3475,
  T_ALTER_CHECK_CONSTRAINT_OPTION = 3476,
  T_ALTER_PARTITION_OPTION = 3477,
  T_ALTER_PARTITION_DROP = 3478,
  T_ALTER_PARTITION_ADD = 3479,
  T_ALTER_COLUMN_OPTION = 3480,
  T_ALTER_TABLEGROUP_OPTION = 3481,
  T_ALTER_TABLE_ACTION_LIST = 3482,

  T_COLUMN_ADD = 3483,
  T_COLUMN_ADD_BEFORE = 3484,
  T_COLUMN_ADD_AFTER = 3485,
  T_COLUMN_ADD_FIRST = 3486,
  T_TABLE_RENAME = 3487,
  T_COLUMN_DROP = 3488,
  T_COLUMN_ALTER = 3489,
  T_COLUMN_RENAME = 3490,
  T_COLUMN_MODIFY = 3491,
  T_COLUMN_CHANGE = 3492,
  T_INDEX_ADD = 3493,
  T_INDEX_DROP = 3494,
  T_INDEX_ALTER = 3495,
  T_INDEX_RENAME = 3496,
  T_VISIBLE = 3497,
  T_INVISIBLE = 3498,
  T_TABLEGROUP_DROP = 3499,
  T_ORDER_BY = 3500,
  T_SET_TABLE_COMMENT = 3501,
  T_SET_COLUMN_COMMENT = 3502,
  T_MULTI_LOCK_ROWNUM = 3503, // add only for multi_part_for_update

  T_CREATE_TABLEGROUP = 3504,
  T_DROP_TABLEGROUP = 3505,
  T_ALTER_TABLEGROUP = 3506,
  T_DEFAULT_TABLEGROUP = 3507,
  T_TEMPORARY = 3508,

  T_ALTER_SYSTEM = 3509,
  T_CHANGE_OBI = 3510,
  T_FORCE = 3511,
  T_USE = 3512,
  T_IGNORE = 3513,
  T_INDEX_HINT_LIST = 3514,
  T_INDEX_HINT_DEF = 3515,
  T_SET_MASTER = 3516,
  T_SET_SLAVE = 3517,
  T_SET_MASTER_SLAVE = 3518,
  T_SYTEM_ACTION_LIST = 3519,
  T_SYSTEM_ACTION = 3520,
  T_CLUSTER = 3521,
  T_SERVER_INFO = 3522,
  T_SERVER_INFO_LIST = 3523,
  T_SERVER_LIST = 3524,
  T_CLUSTER_V2 = 3525,
  T_SERVER_ADDRESS = 3526,
  T_SWITCH_MASTER_LIST = 3527,
  T_SWITCH_MASTER = 3528,
  T_SIWTCH_ACTION = 3529,
  T_SERVER_ACTION = 3530,
  T_ZONE_ACTION = 3531,
  T_IP_PORT = 3532,

  T_SHOW_TABLES = 3533,
  T_SHOW_DATABASES = 3534,
  T_SHOW_VARIABLES = 3535,
  T_SHOW_COLUMNS = 3536,
  T_SHOW_SCHEMA = 3537,
  T_SHOW_CREATE_DATABASE = 3538,
  T_SHOW_CREATE_TABLE = 3539,
  T_SHOW_CREATE_VIEW = 3540,
  T_SHOW_TABLE_STATUS = 3541,
  T_SHOW_PARAMETERS = 3542,
  T_SHOW_INDEXES = 3543,
  T_SHOW_PROCESSLIST = 3544,
  T_SHOW_SERVER_STATUS = 3545,
  T_SHOW_WARNINGS = 3546,
  T_SHOW_ERRORS = 3547,
  T_SHOW_CHARSET = 3548,
  T_SHOW_COLLATION = 3549,
  T_SHOW_TABLEGROUPS = 3550,
  T_SHOW_STATUS = 3551,
  T_SHOW_TENANT = 3552,
  T_SHOW_CREATE_TENANT = 3553,
  T_SHOW_TRACE = 3554,
  T_SHOW_ENGINES = 3555,
  T_SHOW_PRIVILEGES = 3556,
  T_SHOW_RECYCLEBIN = 3557,
  T_SHOW_CREATE_PROCEDURE = 3558,
  T_SHOW_CREATE_FUNCTION = 3559,
  T_SHOW_PROCEDURE_STATUS = 3560,
  T_SHOW_FUNCTION_STATUS = 3561,
  T_SHOW_CREATE_TABLEGROUP = 3562,
  T_SHOW_RESTORE_PREVIEW = 3563,
  T_SHOW_CREATE_TRIGGER = 3564,
  T_SHOW_QUERY_RESPONSE_TIME = 3565,
  T_SHOW_SEQUENCES = 3566,
  T_SHOW_GRANTS = 3567,

  T_SHOW_LIMIT = 3568,
  T_CREATE_USER = 3569,
  T_CREATE_USER_SPEC = 3570,
  T_DROP_USER = 3571,
  T_SET_PASSWORD = 3572,
  T_RENAME_USER = 3573,
  T_RENAME_INFO = 3574,
  T_LOCK_USER = 3575,
  T_GRANT = 3576,
  T_PRIVILEGES = 3577,
  T_PRIV_LEVEL = 3578,
  T_PRIV_TYPE = 3579,
  T_USERS = 3580,
  T_REVOKE = 3581,
  T_REVOKE_ALL = 3582,
  T_BEGIN = 3583,
  T_COMMIT = 3584,
  T_PREPARE = 3585,
  T_DEALLOCATE = 3586,
  T_EXECUTE = 3587,
  T_ARGUMENT_LIST = 3588,
  T_VARIABLE_SET = 3589,
  T_VAR_VAL = 3590,
  T_ROLLBACK = 3591,
  T_ANY_HOST_NAME = 3592,
  T_USER_WITH_HOST_NAME = 3593,

  T_INDEX_COLUMN_LIST = 3594,
  T_INDEX_USING_ALGORITHM = 3595,
  T_CREATE_INDEX = 3596,
  T_SORT_COLUMN_KEY = 3597,
  T_STORING = 3598,
  T_STORING_COLUMN_LIST = 3599,
  T_WITH_ROWID = 3600,
  T_PARSER_NAME = 3601,
  T_DROP_INDEX = 3602,

  //recycle related
  T_FLASHBACK_TENANT = 3603,
  T_FLASHBACK_DATABASE = 3604,
  T_FLASHBACK_TABLE_FROM_RECYCLEBIN = 3605,
  T_FLASHBACK_INDEX = 3606,
  T_PURGE_RECYCLEBIN = 3607,
  T_PURGE_TENANT = 3608,
  T_PURGE_DATABASE = 3609,
  T_PURGE_TABLE = 3610,
  T_PURGE_INDEX = 3611,

  T_HINT_OPTION_LIST = 3612,
  T_READ_CONSISTENCY = 3613,
  T_INDEX = 3614,
  T_FROZEN_VERSION = 3615,
  T_TOPK = 3616,
  T_CLIENT_VERSION = 3617,
  T_MYSQL_DRIVER = 3618,
  T_QUERY_TIMEOUT = 3619,
  T_DBLINK_INFO = 3620,
  T_LOG_LEVEL = 3621,
  T_LEADING = 3622,
  T_ORDERED = 3623,
  T_INDEX_HINT = 3624,
  T_NO_INDEX_HINT = 3625,
  T_FULL_HINT = 3626,
  T_USE_DAS_HINT = 3627,
  T_NO_USE_DAS_HINT = 3628,
  T_INDEX_SS_HINT = 3629,
  T_INDEX_SS_ASC_HINT = 3630,
  T_INDEX_SS_DESC_HINT = 3631,
  T_USE_MERGE = 3632,
  T_USE_HASH = 3633,
  T_NO_USE_HASH = 3634,
  T_USE_NL = 3635,
  T_USE_PLAN_CACHE = 3636,
  T_USE_HASH_AGGREGATE = 3637,
  T_NO_USE_HASH_AGGREGATE = 3638,
  T_GBY_PUSHDOWN = 3639,
  T_NO_GBY_PUSHDOWN = 3640,
  T_USE_HASH_DISTINCT = 3641,
  T_NO_USE_HASH_DISTINCT = 3642,
  T_DISTINCT_PUSHDOWN = 3643,
  T_NO_DISTINCT_PUSHDOWN = 3644,
  T_USE_HASH_SET = 3645,
  T_NO_USE_HASH_SET = 3646,
  T_NEG_SIGN = 3647, /* 用于支持hint里的负数 */
  T_USE_LATE_MATERIALIZATION = 3648,
  T_NO_USE_LATE_MATERIALIZATION = 3649,
  T_NO_REWRITE = 3650,
  T_TRACE_LOG = 3651,
  T_QB_NAME = 3652,
  T_QB_NAME_LIST = 3653,
  T_MAX_CONCURRENT = 3654,
  T_PARALLEL = 3655,
  T_TABLE_PARALLEL = 3656,
  T_NO_PARALLEL = 3657,
  T_MONITOR = 3658,
  T_PQ_DISTRIBUTE = 3659,
  T_PQ_DISTRIBUTE_WINDOW = 3660,
  T_WIN_FUNC_IDX_LIST = 3661,
  T_PQ_SET = 3662,
  T_DISTRIBUTE_BROADCAST = 3663,
  T_DISTRIBUTE_HASH = 3664,
  T_DISTRIBUTE_NONE = 3665,
  T_DISTRIBUTE_ALL = 3666,
  T_DISTRIBUTE_PARTITION = 3667,
  T_DISTRIBUTE_LOCAL = 3668,
  T_DISTRIBUTE_BC2HOST = 3669,
  T_DISTRIBUTE_RANDOM = 3670,
  T_DISTRIBUTE_RANGE = 3671,
  T_DISTRIBUTE_LIST = 3672,
  T_DISTRIBUTE_METHOD_LIST = 3673,
  T_PX_JOIN_FILTER = 3674,
  T_TRACING = 3675,
  T_DOP = 3676,
  T_STAT = 3677,
  T_GATHER_OPTIMIZER_STATISTICS = 3678,
  T_NO_GATHER_OPTIMIZER_STATISTICS = 3679,
  T_APPEND = 3680,
  T_DBMS_STATS = 3681,

  T_KILL = 3682,
  T_HELP = 3683,
  T_CANCEL = 3684,
  T_CANCEL_TASK = 3685,
  T_BOOTSTRAP = 3686,
  T_FLUSH_CACHE = 3687,
  T_FLUSH_KVCACHE = 3688,
  T_FLUSH_ILOGCACHE = 3689,
  T_ADMIN_SERVER = 3690,
  T_ADMIN_ZONE = 3691,
  T_FLASHBACK_READ_TX_UNCOMMITTED = 3692,
  T_CS_DISKMAINTAIN = 3693,
  T_DISK_OP_PARAM = 3694,
  T_CS_ADMIN_PARAMS = 3695,
  T_CREATE_TABLET = 3696,
  T_CHECK_TABLET = 3697,
  T_REPORT_REPLICA = 3698,
  T_IP_PORT_CLUSTER = 3699,
  T_RANGE = 3700,
  T_VERSION = 3701,
  T_IP_SOURCE = 3702,
  T_IP_DESTINATION = 3703,
  T_SWITCH_ROOTSERVER = 3704,
  T_SWITCH_UPDATESERVER = 3705,
  T_CLUSTER_MANAGER = 3706,
  T_CLUSTER_ID = 3707,
  T_FREEZE = 3708,
  T_DROP_MEMTABLE = 3709,
  T_CLEAR_MEMTABLE = 3710,
  T_DELAY = 3711,
  T_PRINT_ROOT_TABLE = 3712,
  T_ADD_UPDATESERVER = 3713,
  T_DELETE_UPDATESERVER = 3714,
  T_CHECK_ROOT_TABLE = 3715,
  T_CLEAR_ROOT_TABLE = 3716,
  T_REFRESH_SCHEMA = 3717,
  T_REFRESH_MEMORY_STAT = 3718,
  T_WASH_MEMORY_FRAGMENTATION = 3719,
  T_NAME_LIST = 3720,
  T_CREATE_DATABASE = 3721,
  T_DROP_DATABASE = 3722,
  T_ALTER_DATABASE = 3723,
  T_USE_DATABASE = 3724,
  T_DATABASE_OPTION_LIST = 3725,
  T_DATABASE_LIST = 3726,
  T_CREATE_TENANT = 3727,
  T_CREATE_STANDBY_TENANT = 3728,
  T_DROP_TENANT = 3729,
  T_MODIFY_TENANT = 3730,
  T_LOCK_TENANT = 3731,
  T_LOG_RESTORE_SOURCE = 3732,
  T_ZONE_LIST = 3733,
  T_RESOURCE_POOL_LIST = 3734,
  T_ZONE = 3735,
  T_TENANT_RESOURCE_POOL_LIST = 3736,
  T_TENANT_OPTION_LIST = 3737,
  T_PRIMARY_ZONE = 3738,
  T_READ_ONLY = 3739,
  T_STORAGE_FORMAT_VERSION = 3740,
  T_ENGINE = 3741,
  T_ON = 3742,
  T_OFF = 3743,

  T_CREATE_RESOURCE_UNIT = 3744,
  T_ALTER_RESOURCE_UNIT = 3745,
  T_DROP_RESOURCE_UNIT = 3746,
  T_RESOURCE_POOL_OPTION_LIST = 3747,
  T_UNIT = 3748,
  T_UNIT_NUM = 3749,
  T_UNIT_ID_LIST = 3750,

  T_CREATE_RESOURCE_POOL = 3751,
  T_DROP_RESOURCE_POOL = 3752,
  T_ALTER_RESOURCE_POOL = 3753,
  T_SPLIT_RESOURCE_POOL = 3754,
  T_RESOURCE_UNIT_OPTION_LIST = 3755,
  T_MAX_CPU = 3756,
  T_MEMORY_SIZE = 3757,
  T_MAX_IOPS = 3758,
  T_IOPS_WEIGHT = 3759,
  T_LOG_DISK_SIZE = 3760,
  T_MAX_SESSION_NUM = 3761,
  T_MIN_CPU = 3762,
  T_MIN_IOPS = 3763,
  T_BASIC = 3764,
  T_OUTLINE = 3765,
  T_EXTENDED = 3766,
  T_PARTITIONS = 3767,
  T_TRADITIONAL = 3768,
  T_FORMAT_JSON = 3769,
  T_EXTENDED_NOADDR = 3770,
  T_PLANREGRESS = 3771,

  T_SFU_INT = 3772,
  T_SFU_DECIMAL = 3773,
  T_SFU_DOUBLE = 3774,
  T_FOR_UPDATE = 3775,
  T_SKIP_LOCKED = 3776,
  T_ERR_LOG_CALUSE = 3777,
  T_INTO_ERR_LOG_TABLE = 3778,
  T_ERR_LOG_SIMPLE_EXPR = 3779,
  T_ERR_LOG_LIMIT = 3780,
  T_DEFAULT_INT = 3781,
  T_DEFAULT_NULL = 3782,
  T_LS = 3783,
  T_PARTITION_ID_SERVER = 3784,
  T_SERVER_TENANT = 3785,
  T_LS_SERVER_TENANT = 3786,
  T_ZONE_TENANT = 3787,
  T_SWITCH_REPLICA_ROLE = 3788,
  T_SWITCH_RS_ROLE = 3789,
  T_CREATE_TIMESTAMP = 3790,
  T_RECYCLE_REPLICA = 3791,
  T_MERGE_CONTROL = 3792,
  T_TENANT_NAME = 3793,
  T_CACHE_NAME = 3794,
  T_FILE_ID = 3795,
  T_TENANT_LIST = 3796,
  T_CHANGE_TENANT = 3797,
  T_SET_NAMES = 3798,
  T_SET_CHARSET = 3799,
  T_CLEAR_LOCATION_CACHE = 3800,
  T_RELOAD_UNIT = 3801,
  T_EMPTY = 3802,
  T_CONCAT_STRING = 3803,
  T_FOUND_ROWS = 3804,
  T_BINARY = 3805,
  T_TRANSACTION = 3806,
  T_TRANSACTION_CHARACTERISTICS = 3807,
  T_RELOAD_SERVER = 3808,
  T_RELOAD_ZONE = 3809,
  T_MIGRATE_UNIT = 3810,
  T_ADD_ARBITRATION_SERVICE = 3811,
  T_REMOVE_ARBITRATION_SERVICE = 3812,
  T_REPLACE_ARBITRATION_SERVICE = 3813,
  T_ENABLE_ARBITRATION_SERVICE = 3814,
  T_CLEAR_MERGE_ERROR = 3815,
  T_QEURY_EXPRESSION_LIST = 3816,
  T_UPGRADE_VIRTUAL_SCHEMA = 3817,
  T_RUN_JOB = 3818,
  T_EMPTY_QUERY = 3819,
  T_LOCK_TABLE = 3820,
  T_CREATE_OUTLINE = 3821,
  T_ALTER_OUTLINE = 3822,
  T_DROP_OUTLINE = 3823,
  T_ADMIN_UPGRADE_CMD = 3824,
  T_GATHER_PLAN_STATISTICS = 3825,
  T_TP_NAME = 3826,
  T_TP_NO = 3827,
  T_TP_COND = 3828,
  T_ACTION = 3829,
  T_ERROR = 3830,
  T_ERROR_CODE = 3831,
  T_SYTEM_SETTP_LIST = 3832,
  T_ALTER_SYSTEM_SETTP = 3833,
  T_ALTER_SYSTEM_DROP_TEMP_TABLE = 3834,
  T_ALTER_SYSTEM_REFRESH_TEMP_TABLE = 3835,
  T_ALTER_DISKGROUP_ADD_DISK = 3836,
  T_ALTER_DISKGROUP_DROP_DISK = 3837,
  T_OCCUR = 3838,
  T_TRIGGER_MODE = 3839,
  T_REFRESH_TIME_ZONE_INFO = 3840,
  T_REGION = 3841,
  T_SET_REGION_NETWORK_BANDWIDTH = 3842,
  T_SET_MERGE_LIST = 3843,
  T_INTO_VARS_LIST = 3844,
  T_INTO_FIELD_LIST = 3845,
  T_INTO_LINE_LIST = 3846,
  T_FIELD_TERMINATED_STR = 3847,
  T_OPTIONALLY_CLOSED_STR = 3848,
  T_CLOSED_STR = 3849,
  T_LINE_TERMINATED_STR = 3850,
  T_LINE_START_STR = 3851,
  T_CHANGE_LIST = 3852,
  T_REPLICA_TYPE = 3853,
  T_PCTFREE = 3854,
  T_SET_DISK_VALID = 3855,

  T_SQL_STATE = 3856,
  T_SQL_EXCEPTION = 3857,
  T_SQL_WARNING = 3858,
  T_SQL_NOT_FOUND = 3859,
  T_SP_EXCEPTION_OTHERS = 3860,

  //pl parse item type
  T_SP_PARAM = 3861,
  T_SP_PARAM_LIST = 3862,
  T_SP_NAME = 3863,
  T_SP_ACCESS_NAME = 3864,
  T_SP_CREATE = 3865,
  T_SP_ALTER = 3866,
  T_SP_COMPILE_CLAUSE = 3867,
  T_SP_EDITIONABLE_CLAUSE = 3868,
  T_SP_DROP = 3869,
  T_SP_SOURCE = 3870,
  T_SP_PROC_STMT_LIST = 3871,
  T_SQL_STMT = 3872,
  T_EXPR = 3873,
  T_SP_USING_LIST = 3874,
  T_SP_USING_PARAM = 3875,
  T_SP_EXECUTE_IMMEDIATE = 3876,
  T_SP_BLOCK_CONTENT = 3877,
  T_SP_LABELED_BLOCK = 3878,
  T_SP_DECL_LIST = 3879,
  T_SP_DECL = 3880,
  T_SP_DECL_COND = 3881,
  T_SP_INIT_PRAGMA = 3882,
  T_SP_INIT_PRAGMA_PARAM_LIST = 3883,
  T_SP_DECL_HANDLER = 3884,
  T_SP_DECL_IDENT_LIST = 3885,
  T_SP_DECL_DEFAULT = 3886,
  T_SP_DECL_CURSOR = 3887,
  T_SP_EXTEND = 3888,
  T_SP_DELETE = 3889,
  T_SP_DO = 3890,
  T_SP_IF = 3891,
  T_SP_ELSE = 3892,
  T_SP_CASE = 3893,
  T_SP_WHEN = 3894,
  T_SP_RETURN = 3895,
  T_SP_GOTO = 3896,
  T_SP_CPARAM = 3897,
  T_SP_CPARAM_LIST = 3898,
  T_SP_CALL_STMT = 3899,
  T_SP_INNER_CALL_STMT = 3900,
  T_SP_ANONYMOUS_BLOCK = 3901,
  T_SP_NULL = 3902,
  T_SP_PIPELINED = 3903,
  T_SP_PIPE_ROW = 3904,
  T_SP_LOOP = 3905,
  T_SP_WHILE = 3906,
  T_SP_REPEAT = 3907,
  T_SP_LABELED_CONTROL = 3908,
  T_SP_ITERATE = 3909,
  T_SP_LEAVE = 3910,
  T_SP_CONDITION = 3911,
  T_SP_HCOND_LIST = 3912,
  T_SF_CREATE = 3913,
  T_SF_ALTER = 3914,
  T_SF_DROP = 3915,
  T_SF_SOURCE = 3916,
  T_SF_AGGREGATE_BODY = 3917,
  T_SF_AGGREGATE_SOURCE = 3918,
  T_SP_SIGNAL = 3919,
  T_SP_RESIGNAL = 3920,
  T_SP_SIGNAL_INFO_LIST = 3921,
  T_SP_SIGNAL_INFO_ITEM = 3922,
  T_SP_REF_CURSOR_TYPE = 3923,
  T_RECORD_MEMBER = 3924,
  T_RECORD_MEMBER_LIST = 3925,
  T_SP_RECORD_TYPE = 3926,
  T_SP_COLLECTION_TYPE = 3927,
  T_SP_DECL_USER_TYPE = 3928,
  T_SP_NESTED_TABLE_TYPE = 3929,
  T_SP_ASSOC_ARRAY_TYPE = 3930,
  T_SP_VARRAY_TYPE = 3931,
  T_SP_PROC_OPEN = 3932,
  T_SP_PROC_FETCH = 3933,
  T_SP_PROC_CLOSE = 3934,
  T_SP_INTO_LIST = 3935,
  T_SP_OBJ_ACCESS_REF = 3936,
  T_SP_INVOKE = 3937,
  T_SP_ACCESSOR = 3938,
  T_SP_ACCESSOR_KIND = 3939,
  T_SP_ACCESSOR_LIST = 3940,
  T_SP_ACCESSIBLE_BY = 3941,
  T_SP_DETERMINISTIC = 3942,
  T_SP_PARALLEL_ENABLE = 3943,
  T_SP_SOURCE_LIST = 3944,
  T_SP_RELIES_ON = 3945,
  T_SP_RESULT_CACHE = 3946,
  T_SP_CLAUSE_LIST = 3947,
  T_SP_INTEGER_TYPE = 3948,
  T_SP_FOR_LOOP = 3949,
  T_SP_CURSOR_FOR_LOOP = 3950,
  T_SP_BOUND_CLAUSE = 3951,
  T_SP_INDICES_OF_CALUSE = 3952,
  T_SP_VALUES_OF_CALUSE = 3953,
  T_SP_FORALL = 3954,
  T_SP_TYPE = 3955,
  T_SP_ROWTYPE = 3956,
  T_SP_DBLINK_TYPE = 3957,
  T_SP_DECL_USER_SUBTYPE = 3958,
  T_SP_USER_SUBTYPE_RANGE = 3959,
  T_SP_USER_SUBTYPE_BASETYPE = 3960,
  T_SP_PRAGMA_INLINE = 3961,
  T_SP_PRAGMA_UDF = 3962,
  T_SP_PRAGMA_SERIALLY_REUSABLE = 3963,
  T_SP_PRAGMA_RESTRICT_REFERENCE = 3964,
  T_SP_PRAGMA_AUTONOMOUS_TRANSACTION = 3965,
  T_SP_PRAGMA_INTERFACE = 3966,

  T_SP_CURSOR_ISOPEN = 3967,
  T_SP_CURSOR_FOUND = 3968,
  T_SP_CURSOR_NOTFOUND = 3969,
  T_SP_CURSOR_ROWCOUNT = 3970,
  T_SP_CURSOR_ROWID = 3971,
  T_SP_CURSOR_BULK_ROWCOUNT = 3972,
  T_SP_CURSOR_BULK_EXCEPTIONS = 3973,
  T_SP_CURSOR_BULK_EXCEPTIONS_COUNT = 3974,
  T_SP_IMPLICIT_CURSOR_ATTR = 3975,
  T_SP_EXPLICIT_CURSOR_ATTR = 3976,

  // user define type parse item type
  T_SP_CREATE_TYPE = 3977,
  T_SP_DROP_TYPE = 3978,
  T_SP_OBJECT_DEF = 3979,
  T_SP_IS_OBJECT = 3980,
  T_SP_IS_UNDER_OBJECT = 3981,
  T_SP_SQLJ_OBJ_TYPE = 3982,
  T_SP_OBJ_FINAL = 3983,
  T_SP_OBJ_INISTANTIABLE = 3984,
  T_SP_OBJ_FINAL_INST_LIST = 3985,
  T_SP_OBJ_ATTR_LIST = 3986,
  T_SP_OBJ_ATTR_AND_ELEMENT_SPEC = 3987,
  T_SP_OBJ_ATTR_SPEC = 3988,
  T_SP_OBJ_SQLJ_TYPE_ATTR = 3989,
  T_SP_OBJ_ELEMENT_SPEC = 3990,
  T_SP_OBJ_INHERITANCE = 3991,
  T_SP_OBJ_RESTRICT = 3992,
  T_SP_ASSERT_ITEM = 3993,
  T_SP_ASSERT_ITEM_LIST = 3994,
  T_SP_OBJ_ELEM_SUBPROG_SPEC = 3995,
  T_SP_OBJ_SQLJ_FUNC_DECL = 3996,
  T_SP_OBJ_SQLJ_SIG = 3997,
  T_SP_OBJ_SELF_RESULT = 3998,
  T_SP_OBJ_VARIABLE_NAME = 3999,
  T_SP_OBJ_NAME = 4000,
  T_SP_OBJ_ELEM_CONSTRUCTOR = 4001,
  T_SP_OBJ_CONSTRUCT_PARAM = 4002,
  T_SP_OBJ_SELF_INOUT = 4003,
  T_SP_OBJ_CONSTR_PARAM = 4004,
  T_SP_OBJ_MAP_ORDER = 4005,
  T_SP_OBJ_CONSTR_IMPL = 4006,

  //pl package parse item type
  T_PACKAGE_CREATE = 4007,
  T_PACKAGE_CREATE_BODY = 4008,
  T_PACKAGE_BLOCK = 4009,
  T_PACKAGE_BODY_BLOCK = 4010,
  T_PACKAGE_STMTS = 4011,
  T_PACKAGE_BODY_STMTS = 4012,
  T_PACKAGE_ALTER = 4013,
  T_PACKAGE_DROP = 4014,
  T_SUB_FUNC_DECL = 4015,
  T_SUB_FUNC_DEF = 4016,
  T_SUB_PROC_DECL = 4017,
  T_SUB_PROC_DEF = 4018,
  T_PACKAGE_ALTER_OPTIONS = 4019,

  //event job parse item type
  T_EVENT_JOB_EVERY = 4020,
  T_EVENT_JOB_WITH_ON = 4021,
  T_EVENT_JOB_CREATE = 4022,
  T_EVENT_JOB_ALTER = 4023,
  T_EVENT_JOB_DROP = 4024,

  T_CLEAR_BALANCE_TASK = 4025,
  T_BALANCE_TASK_TYPE = 4026,
  T_CREATE_SYNONYM = 4027,
  T_DROP_SYNONYM = 4028,
  T_CREATE_FUNC = 4029,
  T_DROP_FUNC = 4030,
  T_PUBLIC = 4031,
  T_DLINK = 4032,
  T_IDC = 4033,
  T_STRING_LIST = 4034,
  T_ZONE_TYPE = 4035,
  T_SQL_ID = 4036,
  T_NAMESPACE = 4037,
  T_ALTER_TABLEGROUP_ACTION_LIST = 4038,
  T_TABLEGROUP_OPTION_LIST = 4039,
  T_RETURNING = 4040,
  T_SAMPLE_SCAN = 4041,
  T_EXPR_NUM = 4042,
  T_BASE = 4043,
  T_INCR = 4044,
  T_ALTER_PARTITION_PARTITIONED = 4045,
  T_ENCRYPTION = 4046,
  T_RANDOM = 4047,
  T_TABLEGROUP_ID = 4048,
  T_TABLEGROUP_BINDING = 4049,
  T_TABLEGROUP_SHARDING = 4050,
  T_MAX_USED_PART_ID = 4051,
  T_TENANT_ID = 4052,

  //load data
  T_LOAD_DATA = 4053,
  T_LOCAL = 4054,
  T_ESCAPED_STR = 4055,
  T_IGNORE_ROWS = 4056,
  T_LOAD_DATA_ERR_FILE = 4057,
  T_LOAD_DATA_REJECT_LIMIT = 4058,
  T_LOAD_DATA_BAD_FILE = 4059,

  // foreign key
  T_REFERENCE_OPTION_LIST = 4060,
  T_REFERENCE_OPTION = 4061,
  T_FOREIGN_KEY = 4062,
  T_RESTRICT = 4063,
  T_CASCADE = 4064,
  T_SET_NULL = 4065,
  T_NO_ACTION = 4066,
  T_SET_DEFAULT = 4067,
  T_ALTER_FOREIGN_KEY_OPTION = 4068,
  T_FOREIGN_KEY_DROP = 4069,
  T_FOREIGN_KEY_MATCH = 4070,
  T_FULL = 4071,
  T_SIMPLE = 4072,
  T_PARTIAL = 4073,
  T_CLUSTER_ROLE = 4074,
  T_USER_INFO = 4075,
  T_CLUSTER_NAME_ID = 4076,
  T_SWTICH_CLUSTER_ROLE = 4077,

  // partition manager
  T_ALTER_PARTITION_SPLIT = 4078,
  T_SPLIT_ACTION = 4079,
  T_ALTER_PARTITION_REORGANIZE = 4080,
  T_ALTER_PARTITION_TRUNCATE = 4081,
  T_ALTER_SUBPARTITION_ADD = 4082,
  T_ALTER_SUBPARTITION_DROP = 4083,
  T_ALTER_SUBPARTITION_TRUNCATE = 4084,
  T_ALTER_SUBPARTITION_RENAME = 4085,
  T_ALTER_PARTITION_RENAME = 4086,

  T_ANALYZE = 4087,
  T_ANALYZE_STATISTICS = 4088,
  T_ANALYZE_FOR_CLAUSE_LIST = 4089,
  T_ANALYZE_TABLE = 4090,
  T_ANALYZE_ALL_COLUMNS = 4091,
  T_ANALYZE_COLUMN_LIST = 4092,
  T_ANALYZE_SOME_COLUMNS = 4093,
  T_ANALYZE_COLUMN_INFO = 4094,
  T_ANALYZE_SAMPLE_INFO = 4095,
  T_MYSQL_UPDATE_HISTOGRAM = 4096,
  T_MYSQL_DROP_HISTOGRAM = 4097,
  T_ANALYZE_MYSQL_COLUMN_LIST = 4098,
  T_SWITCHOVER = 4099,
  T_SWITCHOVER_TO_PRIMARY = 4100,
  T_SWITCHOVER_TO_STANDBY = 4101,
  T_RECOVER = 4102,
  T_RECOVER_UNLIMITED = 4103,
  T_RECOVER_CANCEL = 4104,
  T_ALTER_SYSTEM_SET = 4105,
  T_ALTER_SYSTEM_SET_PARAMETER = 4106,
  T_ALTER_SESSION_SET = 4107,
  T_ALTER_SESSION_SET_PARAMETER_LIST = 4108,
  T_USING_INDEX = 4109,
  T_REFERENCES_CLAUSE = 4110,
  T_DROP_USER_LIST = 4111,
  T_CASCADE_CONSTRAINTS = 4112,
  T_PURGE = 4113,
  T_STORE_FORMAT = 4114,

  //split partition
  T_SPLIT_RANGE = 4115,
  T_SPLIT_LIST = 4116,
  T_OPTIMIZE_TABLE = 4117,
  T_OPTIMIZE_TENANT = 4118,
  T_OPTIMIZE_ALL = 4119,
  // xa transaction
  T_XA_START = 4120,
  T_XA_END = 4121,
  T_XA_PREPARE = 4122,
  T_XA_COMMIT = 4123,
  T_XA_ROLLBACK = 4124,
  //cluster mgr
  T_REMOVE_CLUSTER = 4125,
  T_ADD_CLUSTER = 4126,
  T_TABLE_FLASHBACK_QUERY_TIMESTAMP = 4127,
  T_TABLE_FLASHBACK_QUERY_SCN = 4128,
  T_TABLE_FLASHBACK_QUERY = 4129,
  T_FAILOVER_TO_PRIMARY = 4130,
  T_ENABLE_ROW_MOVEMENT = 4131,
  T_ORA_ROWSCN = 4132,

  T_TABLE_MODE = 4133,
  T_TABLE_CHECKSUM = 4134,
  T_DELAY_KEY_WRITE = 4135,
  T_AVG_ROW_LENGTH = 4136,
  T_RELOAD_GTS = 4137,
  T_ALTER_CONSTRAINT_OPTION = 4138,
  T_DROP_CONSTRAINT = 4139,
  T_CREATE_SAVEPOINT = 4140,
  T_ROLLBACK_SAVEPOINT = 4141,
  T_RELEASE_SAVEPOINT = 4142,
  T_CONSTRAINT_STATE = 4143,
  T_RELY_CONSTRAINT = 4144,
  T_NORELY_CONSTRAINT = 4145,
  T_ENABLE_CONSTRAINT = 4146,
  T_DISABLE_CONSTRAINT = 4147,
  T_VALIDATE_CONSTRAINT = 4148,
  T_NOVALIDATE_CONSTRAINT = 4149,
  T_RELATION_FACTOR_IN_USE_JOIN_HINT_LIST = 4150,
  T_NO_USE_MERGE = 4151,
  T_NO_USE_NL = 4152,
  T_BEGIN_OUTLINE_DATA = 4153,
  T_END_OUTLINE_DATA = 4154,
  T_OUTLINE_HINT = 4155,
  T_OPTIMIZER_FEATURES_ENABLE = 4156,
  T_OPT_PARAM_HINT = 4157,

  T_CREATE_ROLE = 4158,
  T_DROP_ROLE = 4159,
  T_ALTER_ROLE = 4160,
  T_SET_ROLE = 4161,
  T_SET_ROLE_PASSWORD = 4162,
  T_WITH_ADMIN_OPTION = 4163,
  T_SYSTEM_GRANT = 4164,
  T_GRANT_ROLE = 4165,
  T_SYSTEM_REVOKE = 4166,
  T_REVOKE_ROLE = 4167,

  //keystore
  T_CREATE_KEYSTORE = 4168,
  T_ALTER_KEYSTORE_PASSWORD = 4169,
  T_ALTER_KEYSTORE_SET_KEY = 4170,
  T_ALTER_KEYSTORE_CLOSE = 4171,
  T_ALTER_KEYSTORE_OPEN = 4172,

  T_SHOW_TRIGGERS = 4173,

  //tablespace
  T_CREATE_TABLESPACE = 4174,
  T_ENCRYPT_ALGORITHM = 4175,
  T_PERMANENT_TABLESPACE = 4176,
  T_DROP_TABLESPACE = 4177,
  T_TABLESPACE = 4178,
  //profile
  T_ALTER_USER_PROFILE = 4179,
  T_CREATE_PROFILE = 4180,
  T_ALTER_PROFILE = 4181,
  T_DROP_PROFILE = 4182,
  T_USER_PROFILE = 4183,
  T_PROFILE_PARAM_LIST = 4184,
  T_PROFILE_PAIR = 4185,
  T_PROFILE_UNLIMITED = 4186,
  T_PROFILE_DEFAULT = 4187,
  T_PCTUSED = 4188,
  T_INITRANS = 4189,
  T_MAXTRANS = 4190,
  T_STORAGE_OPTIONS = 4191,
  T_STORAGE_INITIAL = 4192,
  T_STORAGE_NEXT = 4193,
  T_STORAGE_MINEXTENTS = 4194,
  T_STORAGE_MAXEXTENTS = 4195,
  T_SIZE_OPTION = 4196,
  T_SIZE_INT = 4197,
  T_SIZE_UNLIMITED = 4198,
  T_MERGE_HINT = 4199,
  T_NO_MERGE_HINT = 4200,
  T_NO_EXPAND = 4201,
  T_USE_CONCAT = 4202,
  T_UNNEST = 4203,
  T_NO_UNNEST = 4204,
  T_INLINE = 4205,
  T_MATERIALIZE = 4206,
  T_PLACE_GROUP_BY = 4207,
  T_NO_PLACE_GROUP_BY = 4208,
  T_SEMI_TO_INNER = 4209,
  T_NO_SEMI_TO_INNER = 4210,
  T_REPLACE_CONST = 4211,
  T_NO_REPLACE_CONST = 4212,
  T_SIMPLIFY_ORDER_BY = 4213,
  T_NO_SIMPLIFY_ORDER_BY = 4214,
  T_SIMPLIFY_GROUP_BY = 4215,
  T_NO_SIMPLIFY_GROUP_BY = 4216,
  T_SIMPLIFY_DISTINCT = 4217,
  T_NO_SIMPLIFY_DISTINCT = 4218,
  T_SIMPLIFY_WINFUNC = 4219,
  T_NO_SIMPLIFY_WINFUNC = 4220,
  T_SIMPLIFY_EXPR = 4221,
  T_NO_SIMPLIFY_EXPR = 4222,
  T_SIMPLIFY_LIMIT = 4223,
  T_NO_SIMPLIFY_LIMIT = 4224,
  T_SIMPLIFY_SUBQUERY = 4225,
  T_NO_SIMPLIFY_SUBQUERY = 4226,
  T_FAST_MINMAX = 4227,
  T_NO_FAST_MINMAX = 4228,
  T_PROJECT_PRUNE = 4229,
  T_NO_PROJECT_PRUNE = 4230,
  T_SIMPLIFY_SET = 4231,
  T_NO_SIMPLIFY_SET = 4232,
  T_OUTER_TO_INNER = 4233,
  T_NO_OUTER_TO_INNER = 4234,
  T_COALESCE_SQ = 4235,
  T_NO_COALESCE_SQ = 4236,
  T_COUNT_TO_EXISTS = 4237,
  T_NO_COUNT_TO_EXISTS = 4238,
  T_LEFT_TO_ANTI = 4239,
  T_NO_LEFT_TO_ANTI = 4240,
  T_PUSH_LIMIT = 4241,
  T_NO_PUSH_LIMIT = 4242,
  T_ELIMINATE_JOIN = 4243,
  T_NO_ELIMINATE_JOIN = 4244,
  T_WIN_MAGIC = 4245,
  T_NO_WIN_MAGIC = 4246,
  T_PULLUP_EXPR = 4247,
  T_NO_PULLUP_EXPR = 4248,
  T_AGGR_FIRST_UNNEST = 4249,
  T_NO_AGGR_FIRST_UNNEST = 4250,
  T_JOIN_FIRST_UNNEST = 4251,
  T_NO_JOIN_FIRST_UNNEST = 4252,
  T_INTERVAL_LITERAL = 4253,
  //T_INTERVAL_YM_LITERAL,
  //T_INTERVAL_DS_LITERAL,

  // trigger parse item type
  T_TG_ALTER = 4254,
  T_TG_CREATE = 4255,
  T_TG_DROP = 4256,
  T_TG_SOURCE = 4257,
  T_TG_SIMPLE_DML = 4258,
  T_TG_COMPOUND_DML = 4259,
  T_TG_INSTEAD_DML = 4260,
  T_TG_SYSTEM = 4261,
  T_BEFORE = 4262,
  T_AFTER = 4263,
  T_INSTEAD = 4264,
  T_ENABLE = 4265,
  T_DISABLE = 4266,
  T_TP_STATEMENT = 4267,
  T_TP_EACH_ROW = 4268,
  T_TG_DML_EVENT_OPTION = 4269,
  T_TG_DML_EVENT_LIST = 4270,
  T_TG_DML_EVENT = 4271,
  T_TG_WHEN_CONDITION = 4272,
//  T_TG_SIMPLE_BODY,
//  T_TG_SIMPLE_DECLARE,
//  T_TG_EXECUTE_BLOCK,
  T_TG_COMPOUND_BODY = 4273,
  T_TG_TIMPING_POINT_SECTION_LIST = 4274,
  T_TG_TIMPING_POINT_SECTION = 4275,
  T_TG_COLUMN_LIST = 4276,
  T_TG_REF_OLD = 4277,
  T_TG_REF_NEW = 4278,
  T_TG_REF_PARENT = 4279,
  T_TG_REF_LIST = 4280,
  T_USE_NL_MATERIALIZATION = 4281,
  T_NO_USE_NL_MATERIALIZATION = 4282,
  T_FLASHBACK_TABLE_TO_TIMESTAMP = 4283,
  T_FLASHBACK_TABLE_TO_SCN = 4284,
  T_RELATION_FACTORS = 4285,

  //ssl
  T_TLS_OPTIONS = 4286,
  T_TLS_NONE = 4287,
  T_TLS_SSL = 4288,
  T_TLS_XFZN = 4289,//x509
  T_TLS_SPECIFIED = 4290,
  T_TLS_CIPHER = 4291,
  T_TLS_ISSUER = 4292,
  T_TLS_SUBJECT = 4293,
  T_ROLLUP_LIST = 4294,
  T_WITH_ROLLUP_CLAUSE = 4295,

  T_MODIFY_CONSTRAINT_OPTION = 4296,

  //security audit
  T_AUDIT = 4297,
  T_AUDIT_STMT = 4298,
  T_AUDIT_OBJECT = 4299,
  T_AUDIT_ALL = 4300,
  T_AUDIT_ALL_STMT = 4301,

  T_AUDIT_ALTER_SYSTEM = 4302,
  T_AUDIT_CLUSTER = 4303,
  T_AUDIT_CONTEXT = 4304,
  T_AUDIT_DBLINK = 4305,
  T_AUDIT_INDEX = 4306,
  T_AUDIT_MATERIALIZED_VIEW = 4307,
  T_AUDIT_NOT_EXIST = 4308,
  T_AUDIT_OUTLINE = 4309,
  T_AUDIT_PROCEDURE = 4310,
  T_AUDIT_PROFILE = 4311,
  T_AUDIT_PUBLIC_DBLINK = 4312,
  T_AUDIT_PUBLIC_SYNONYM = 4313,
  T_AUDIT_ROLE = 4314,
  T_AUDIT_SEQUENCE = 4315,
  T_AUDIT_SESSION = 4316,
  T_AUDIT_SYNONYM = 4317,
  T_AUDIT_SYSTEM_AUDIT = 4318,
  T_AUDIT_SYSTEM_GRANT = 4319,
  T_AUDIT_TABLE = 4320,
  T_AUDIT_TABLESPACE = 4321,
  T_AUDIT_TRIGGER = 4322,
  T_AUDIT_TYPE = 4323,
  T_AUDIT_USER = 4324,
  T_AUDIT_VIEW = 4325,

  T_AUDIT_ALTER_SEQUENCE = 4326,
  T_AUDIT_ALTER_TABLE = 4327,
  T_AUDIT_COMMENT_TABLE  = 4328,
  T_AUDIT_DELETE_TABLE = 4329,
  T_AUDIT_EXECUTE_PROCEDURE = 4330,
  T_AUDIT_GRANT_PROCEDURE = 4331,
  T_AUDIT_GRANT_SEQUENCE = 4332,
  T_AUDIT_GRANT_TABLE = 4333,
  T_AUDIT_GRANT_TYPE = 4334,
  T_AUDIT_INSERT_TABLE = 4335,
  T_AUDIT_SELECT_SEQUENCE = 4336,
  T_AUDIT_SELECT_TABLE = 4337,
  T_AUDIT_UPDATE_TABLE = 4338,

  T_AUDIT_ALTER = 4339,
  T_AUDIT_AUDIT = 4340,
  T_AUDIT_COMMENT = 4341,
  T_AUDIT_DELETE = 4342,
  T_AUDIT_EXECUTE = 4343,
  T_AUDIT_FLASHBACK = 4344,
  T_AUDIT_GRANT = 4345,
  T_AUDIT_INSERT = 4346,
  T_AUDIT_LOCK = 4347,
  T_AUDIT_RENAME = 4348,
  T_AUDIT_SELECT = 4349,
  T_AUDIT_UPDATE = 4350,
  T_AUDIT_DIRECTORY = 4351,

  T_ALTER_CLUSTER = 4352,
  T_CLUSTER_INFO = 4353,
  T_CONVERT_TO_STANDBY = 4354,
  T_MEMSTORE_PERCENT = 4355,
  T_GRANT_SYS_PRIV_ORACLE = 4356,
  T_ORACLE_SYS_PRIV_TYPE = 4357,
  T_DISCONNECT_CLUSTER = 4358,
  T_VERIFY = 4359,
  T_OBCONFIG_URL = 4360,
  T_ARCHIVE_LOG = 4361,
  T_BACKUP_DATABASE = 4362,
  T_RECOVER_TABLE = 4363,
  T_REMAP_TABLE = 4364,
  T_REMAP_TABLEGROUP = 4365,
  T_REMAP_TABLESPACE = 4366,
  T_BACKUP_MANAGE = 4367,
  T_BACKUP_CLEAN = 4368,
  T_DELETE_POLICY = 4369,
  T_BACKUP_KEY = 4370,
  T_RESTORE_TENANT_2 = 4371,
  T_CANCEL_RESTORE = 4372,
  T_CANCEL_RECOVER_TABLE = 4373,
  T_GEN_ROWS = 4374,
  T_LOAD_BATCH_SIZE = 4375,
  T_DIRECT = 4376, // direct load data
  T_REMOTE_OSS = 4377,
  T_PHYSICAL_RESTORE_TENANT = 4378,
  T_RECOVER_TABLE_REMAP = 4379,
  T_PHYSICAL_RESTORE_UNTIL = 4380,
  T_REVOKE_SYSAUTH = 4381,

  // hint, for slave mapping
  T_PQ_MAP = 4382,
  T_ORA_PRIV_TYPE = 4383,
  T_ORA_ROLE_TYPE = 4384,

  T_ENABLE_PARALLEL_DML = 4385,
  T_DISABLE_PARALLEL_DML = 4386,
  T_USE_DISTRIBUTED_DML = 4387,
  T_NO_USE_DISTRIBUTED_DML = 4388,
  T_NO_QUERY_TRANSFORMATION = 4389,
  T_NO_COST_BASED_QUERY_TRANSFORMATION = 4390,

  T_CURSOR_SHARING_EXACT = 4391,

  T_NO_PX_JOIN_FILTER = 4392,
  T_PX_PART_JOIN_FILTER = 4393,
  T_NO_PX_PART_JOIN_FILTER = 4394,

  T_PRED_DEDUCE = 4395,
  T_NO_PRED_DEDUCE = 4396,
  T_PUSH_PRED_CTE = 4397,
  T_NO_PUSH_PRED_CTE = 4398,

  T_TRANS_PARAM = 4399,
  T_MERGE_RESOURCE_POOL = 4400,

  T_ALTER_TABLESPACE = 4401,
  T_TABLESPACE_OPTION_LIST = 4402,

  T_IS_TENANT_SYS_POOL = 4403,
  T_DUMP_MEMORY = 4404,
  T_FORCE_REFRESH_LOCATION_CACHE = 4405,
  T_PROFILE_VERIFY_FUNCTION_NAME = 4406,
  T_ADMIN_ROLLING_UPGRADE_CMD = 4407,
  T_ALTER_INDEX_OPTION_ORACLE = 4408,

  T_PIVOT = 4409,//check
  T_UNPIVOT = 4410,
  T_PIVOT_AGGR_LIST = 4411,
  T_PIVOT_AGGR = 4412,
  T_PIVOT_IN_LIST = 4413,
  T_PIVOT_IN = 4414,
  T_UNPIVOT_IN_LIST = 4415,
  T_UNPIVOT_IN = 4416,
  T_USE_SUBPARTITION = 4417,
  T_ROOTSERVICE_LIST = 4418,
  T_CLUSTER_OPTIONS = 4419,

  T_SP_CREATE_TYPE_BODY = 4420,
  T_SP_CREATE_TYPE_BODY_SRC = 4421,
  T_SP_CONTRUCTOR_DEF_IN_TYPE = 4422,
  T_SP_OBJECT_BODY_DEF = 4423,
  T_SP_CREATE_TYPE_SRC = 4424,
  T_SP_OBJ_ELEMENT_SPEC_LIST = 4425,
  T_FETCH_CLAUSE = 4426, //use to support fetch next rows only
  T_FETCH_TIES_CLAUSE = 4427, //use to support fetch next rows with tie
  T_DBLINK_NAME = 4428,
  T_CREATE_DBLINK = 4429,
  T_REVERSE_DBLINK = 4430,
  T_DROP_DBLINK = 4431,
  T_ALTER_DBLINK = 4432,
  T_LABEL_LIST = 4433,
  T_PRIMARY_ROOTSERVICE_LIST = 4434,
  T_ALTER_USER = 4435,
  T_ALTER_USER_DEFAULT_ROLE = 4436,
  T_DEFAULT_ROLE = 4437,
  T_REVERSE = 4438,
  T_AUTO = 4439,
  T_AUTO_PARTITION = 4440,

  // sql throttling
  T_ENABLE_SQL_THROTTLE = 4441,
  T_DISABLE_SQL_THROTTLE = 4442,
  T_RT = 4443,
  T_CPU = 4444,
  T_IO = 4445,
  T_NETWORK = 4446,
  T_LOGICAL_READS = 4447,
  T_QUEUE_TIME = 4448,
  T_SQL_THROTTLE_METRICS = 4449,
  T_BACKUP_SET_ENCRYPTION = 4450,
  T_BACKUP_SET_DECRYPTION = 4451,
  T_GROUPING_SETS_LIST = 4452,
  T_CUBE_LIST = 4453,
  T_MODIFY_READ_TRANSPORT = 4454,
  T_SET_PROTECT_MODE = 4455,
  T_INTACT_FAILOVER = 4456,
  T_RECOVERY_CONTROL = 4457,
  T_INDEX_ALTER_PARALLEL = 4458,

  T_CREATE_RESTORE_POINT = 4459,
  T_DROP_RESTORE_POINT = 4460,

  T_ADMIN_RUN_UPGRADE_JOB = 4461,
  T_ADMIN_STOP_UPGRADE_JOB = 4462,

  T_ALTER_USER_PRIMARY_ZONE = 4463,

  T_HASH_SUBPARTITION_LIST = 4464,
  T_RANGE_SUBPARTITION_LIST = 4465,
  T_LIST_SUBPARTITION_LIST = 4466,
  T_HASH_PARTITION_LIST = 4467,
  T_RANGE_PARTITION_LIST = 4468,
  T_LIST_PARTITION_LIST = 4469,

  T_FLUSH_DAG_WARNINGS = 4470,

  T_MULTI_INSERT = 4471,//used to support multi table insert
  T_INSERT_TABLE_LIST = 4472,//used to support multi table insert
  T_MULTI_TABLE_INSERT = 4473,//used to support multi table insert
  T_MULTI_CONDITION_INSERT = 4474,//used to support multi table insert
  T_CONDITIION_INSERT_LIST = 4475,//used to support multi table insert
  T_CONDITION_INSERT = 4476,//used to support multi table insert
  T_SINGLE_INSERT = 4477,//used to support multi table insert

  T_GENERATED_COLUMN = 4478,
  T_CONSTR_ALWAYS = 4479,
  T_IDENTITY_COLUMN = 4480,

  T_METHOD_OPT = 4481,
  T_METHOD_OPT_LIST = 4482,
  T_FOR_ALL = 4483,
  T_FOR_COLUMNS = 4484,
  T_FOR_COLUMN_ITEM = 4485,
  T_EXTENSION = 4486,
  T_FOR_COLUMN_LIST = 4487,
  T_SORTKEY = 4488,

  T_SP_OPAQUE_DEF = 4489,

  T_SP_PRE_STMTS = 4490,
  T_SP_PRE_IF = 4491,
  T_SP_PRE_ELSE = 4492,

  T_PLSQL_VARIABLE_IDENTIFIER = 4493,

  T_SP_ERROR = 4494,

  T_PRIMARY_KEY_DROP = 4495,
  T_PRIMARY_KEY_ALTER = 4496,
  T_BACKUP_BACKUPSET = 4497,
  T_BACKUP_ARCHIVELOG = 4498,
  T_COPY_ID = 4499,
  T_CREATE_DIRECTORY = 4500,
  T_DROP_DIRECTORY = 4501,
  T_BACKUP_BACKUPPIECE = 4502,
  T_ADD_RESTORE_SOURCE = 4503,
  T_CLEAR_RESTORE_SOURCE = 4504,

  T_PREVIEW = 4505,

  T_TG_NEST_OF_TABLE_COLUMN = 4506,
  T_CONVERT_TO_CHARACTER = 4507,
  T_USER_RESOURCE_OPTIONS = 4508,
  T_MAX_CONNECTIONS_PER_HOUR = 4509,
  T_MAX_USER_CONNECTIONS = 4510,
  T_MAX_QUERIES_PER_HOUR = 4511,
  T_MAX_UPDATES_PER_HOUR = 4512,
  T_HAVING = 4513,
  T_MODIFY_ALL_TRIGGERS = 4514,
  T_DML_EVENT_INSERTING = 4515,
  T_DML_EVENT_DELETING = 4516,
  T_DML_EVENT_UPDATING = 4517,
  T_ENFORCED_CONSTRAINT = 4518,
  T_NOENFORCED_CONSTRAINT = 4519,
  T_INTERVAL = 4520,
  T_SET_INTERVAL = 4521,
  T_ALTER_RESOURCE_TENANT = 4522,
  T_UNIT_GROUP_ID_LIST = 4523,
  T_CREATE_CONTEXT = 4524,
  T_DROP_CONTEXT = 4525,
  T_CHECKPOINT_SLOG = 4526,
  T_PRETTY = 4527,
  T_PRETTY_COLOR = 4528,
  T_CALIBRATION_INFO_LIST = 4529,
  T_REFRESH_IO_CALIBRATION = 4530,
  T_OB_DDL_SCHEMA_VERSION = 4531,
  T_TG_ORDER = 4532,
  T_ODBC_ESCAPE_SEQUENCES = 4533,
  T_SP_DATA_ACCESS = 4534,

  // column group
  T_COLUMN_GROUP = 4535,
  T_ALL_COLUMN_GROUP = 4536,
  T_SINGLE_COLUMN_GROUP = 4537,
  T_NORMAL_COLUMN_GROUP = 4538,
  T_TRACE_FORMAT = 4539,
  T_TG_ALTER_OPTIONS = 4540,

  //for external table
  T_EXTERNAL_FILE_LOCATION = 4541,
  T_EXTERNAL_FILE_FORMAT = 4542,
  T_EXTERNAL_FILE_FORMAT_TYPE = 4543,
  T_EXTERNAL = 4544,
  T_ALTER_REFRESH_EXTERNAL_TABLE = 4545,
  T_SKIP_HEADER = 4546,
  T_SKIP_BLANK_LINE = 4547,
  T_TRIM_SPACE = 4548,
  T_NULL_IF_EXETERNAL = 4549,
  T_EMPTY_FIELD_AS_NULL = 4550,
  T_EXTERNAL_FILE_PATTERN = 4551,

  T_ADMIN_STORAGE = 4552,// used to support oss storage for clog/sstable
  T_DYNAMIC_SAMPLING = 4553,
  T_TABLE_DYNAMIC_SAMPLING = 4554,
  T_PARTITION_HASH_ELEMENT = 4555,
  T_PARTITION_LIST_ELEMENT = 4556,
  T_PARTITION_RANGE_ELEMENT = 4557,

  T_CONSTR_LOB_CHUNK_SIZE = 4558,
  T_LOB_CHUNK_SIZE = 4559,

  T_ALTER_SYSTEM_KILL = 4560, // used to support kill session in oracle

  T_LOB_STORAGE_CLAUSE = 4561,
  T_TABLE_TTL = 4562,
  T_TTL_DEFINITION = 4563,
  T_TTL_EXPR = 4564,
  T_REMOVE_TTL = 4565,
  T_KV_ATTRIBUTES = 4566,
  T_VALUES_TABLE_EXPRESSION = 4567,//used to values statement
  T_VALUES_ROW_LIST = 4568,//used to values statement
  T_LOB_INROW_THRESHOLD = 4569,
  T_TRANSFER_PARTITION = 4570, // transfer tablet manually
  T_TRANSFER_PARTITION_TO_LS = 4571,
  T_PARTITION_INFO = 4572,
  T_XML_TABLE_EXPRESSION = 4573,
  T_CREATE_FMT_OUTLINE = 4574,
  T_ALTER_FMT_OUTLINE = 4575,
  T_DROP_FMT_OUTLINE = 4576,
  T_PRIV_OBJECT = 4577,
  T_MYSQL_ANALYZE = 4578,
  T_DECORRELATE = 4579,
  T_NO_DECORRELATE = 4580,
  T_DBLINK_UDF = 4581,
  T_COLUMN_ADD_WITH_LOB_PARAMS = 4582,

  //for materialized view
  T_MV_REFRESH_INFO = 4583,
  T_MV_REFRESH_ON_CLAUSE = 4584,
  T_MV_REFRESH_METHOD = 4585,
  T_MV_REFRESH_INTERVAL = 4586,
  T_MV_REFRESH_START_EXPR = 4587,

  // for materialized view log
  T_CREATE_MLOG = 4588,
  T_MLOG_WITH = 4589,
  T_MLOG_WITH_VALUES = 4590,
  T_MLOG_WITH_SPECIAL_COLUMN_LIST = 4591,
  T_MLOG_WITH_SPECIAL_COLUMN = 4592,
  T_MLOG_WITH_REFERENCE_COLUMN = 4593,
  T_MLOG_WITH_PRIMARY_KEY = 4594,
  T_MLOG_WITH_ROWID = 4595,
  T_MLOG_WITH_SEQUENCE = 4596,
  T_MLOG_NEW_VALUES = 4597,
  T_MLOG_INCLUDING_NEW_VALUES = 4598,
  T_MLOG_EXCLUDING_NEW_VALUES = 4599,
  T_MLOG_PURGE = 4600,
  T_MLOG_PURGE_IMMEDIATE = 4601,
  T_MLOG_PURGE_IMMEDIATE_SYNC = 4602,
  T_MLOG_PURGE_IMMEDIATE_ASYNC = 4603,
  T_MLOG_PURGE_START_NEXT = 4604,
  T_MLOG_PURGE_START_TIME_EXPR = 4605,
  T_DROP_MLOG = 4606,

  T_COL_SKIP_INDEX = 4607,
  T_COL_SKIP_INDEX_LIST = 4608,
  T_COL_SKIP_INDEX_MIN_MAX = 4609,
  T_COL_SKIP_INDEX_SUM = 4610,
  T_ALTER_SYSTEM_RESET = 4611,
  T_ALTER_SYSTEM_RESET_PARAMETER = 4612,

  //tenant clone
  T_CREATE_TENANT_SNAPSHOT = 4613,
  T_DROP_TENANT_SNAPSHOT = 4614,
  T_CLONE_TENANT = 4615,
  T_CANCEL_CLONE = 4616,

  // fulltext index
  T_FUN_MATCH_AGAINST = 4617,
  T_ROW_ITER_EXPR = 4618,
  T_FULLTEXT_COLUMN_LIST = 4619,
  T_MATCH_COLUMN_LIST = 4620,

  T_USE_COLUMN_STORE_HINT = 4621,
  T_NO_USE_COLUMN_STORE_HINT = 4622,
  T_REBUILD_COLUMN_STORE = 4623,
  T_COLUMN_GROUP_ADD = 4624,
  T_COLUMN_GROUP_DROP = 4625,
  T_ALTER_COLUMN_GROUP_OPTION = 4626,
  T_BLOCKING = 4627,
  T_PQ_SUBQUERY = 4628,
  T_FLUSH_PRIVILEGES = 4629,
  T_SCHEMA_ID = 4630,
  T_CANCEL_TRANSFER_PARTITION = 4631,
  T_CANCEL_BALANCE_JOB = 4632, //FARM COMPAT WHITELIST
  T_AUTO_SPLIT_TABLET_SIZE = 4633,

  T_DATA_DISK_SIZE = 4634,
  T_ADD_LS_REPLICA = 4635,
  T_REMOVE_LS_REPLICA = 4636,
  T_MIGRATE_LS_REPLICA = 4637,
  T_MODIFY_LS_REPLICA_TYPE = 4638,
  T_MODIFY_LS_PAXOS_REPLICA_NUM = 4639,
  T_CANCEL_LS_REPLICA_TASK = 4640,
  T_COALESCE_AGGR = 4641,
  T_NO_COALESCE_AGGR = 4642,
  T_AUTO_INCREMENT_CACHE_SIZE = 4643,

  T_IGNORE_UNKNOWN_USER = 4644,
  T_SHOW_PROFILE = 4645,
  T_ALTER_TABLE_FORCE = 4646,
  T_SHOW_PROCEDURE_CODE = 4647,
  T_SHOW_FUNCTION_CODE = 4648,

  T_CHANGE_EXTERNAL_STORAGE_DEST = 4649,
  T_ALTER_USER_PROXY = 4650,
  T_PARALLEL_DAS_DML = 4651,
  T_DISABLE_PARALLEL_DAS_DML = 4652,
  T_ENABLE_LOB_PREFETCH = 4653,
  T_MV_OPTIONS = 4654,
  T_MV_REWRITE = 4655,
  T_MV_NO_REWRITE = 4656,
  // select into outfile
  T_INTO_FILE_LIST = 4657,
  T_SINGLE_OPT = 4658,
  T_MAX_FILE_SIZE = 4659,
  T_SHOW_CREATE_USER = 4660,
  T_INSTALL_PLUGIN = 4661,
  T_UNINSTALL_PLUGIN = 4662,
  T_FLUSH_MOCK = 4663,
  T_FLUSH_MOCK_LIST = 4664,
  T_HANDLER_MOCK = 4665,
  T_SHOW_PLUGINS = 4666,
  T_PSEUDO_PARTITION_LIST_COL = 4667,
  T_EXTERNAL_USER_SPECIFIED_PARTITION = 4668,
  T_ALTER_EXTERNAL_PARTITION_OPTION = 4669,
  T_ALTER_EXTERNAL_PARTITION_ADD = 4670,
  T_ALTER_EXTERNAL_PARTITION_DROP = 4671,
  T_ALTER_PARTITION_EXCHANGE = 4672,
  T_SHOW_ENGINE = 4673,
  T_SHOW_OPEN_TABLES = 4674,
  T_REPAIR_TABLE = 4675,
  T_CHECKSUM_TABLE = 4676,
  T_SERVICE_NAME = 4677,
  T_MAX_NET_BANDWIDTH = 4678,
  T_NET_BANDWIDTH_WEIGHT = 4679,
  T_CREATE_SERVER = 4680,
  T_ALTER_SERVER = 4681,
  T_DROP_SERVER = 4682,
  T_CREATE_LOGFILE_GROUP = 4683,
  T_ALTER_LOGFILE_GROUP = 4684,
  T_DROP_LOGFILE_GROUP = 4685,
  T_SET_UNION_ALL = 4686,
  T_SHOW_CHECK_TABLE = 4687,
  T_SHARED_STORAGE_INFO = 4688,
  T_XA_RECOVER = 4689,
  T_VEC_INDEX_PARAMS = 4690,
  T_VEC_INDEX_COLUMN = 4691,
  T_VEC_INDEX_COLUMN_EXPR = 4692,
  T_BACKUP_CLUSTER_PARAMETERS = 4693,
  // create mv build deferred
  T_MV_REFRESH_OPT = 4694,
  T_MV_BUILD_OPT = 4695,
  T_PSEUDO_EXTERNAL_FILE_ROW = 4696,
  T_EXTERNAL_TABLE_AUTO_REFRESH = 4697,

  // for tablelock
  T_MYSQL_LOCK_LIST = 4698,
  T_MYSQL_LOCK_NODE = 4699,
  // for vector index
  T_APPROX = 4700,

  // select into outfile
  T_BUFFER_SIZE = 4701,
  T_PARTITION_EXPR = 4702,
  T_CACHE_INDEX = 4703,
  T_LOAD_INDEX_INTO_CACHE = 4704,

  T_RESOURCE_GROUP = 4705,
  //olap async job
  T_OLAP_ASYNC_JOB_SUBMIT = 4706,
  T_OLAP_ASYNC_JOB_CANCEL = 4707,
  T_SHOW_OLAP_ASYNC_JOB_STATUS = 4708,
  T_USE_ADAPTIVE = 4709,
  T_NO_USE_ADAPTIVE = 4710,
  T_SHOW_CHECK_PARTITION = 4711,
  T_ALTER_COLUMN_GROUP_DELAYED = 4712,
  T_DUPLICATE_READ_CONSISTENCY = 4713,
  T_NO_DIRECT = 4714,

  //odps external table
  T_EXTERNAL_PROPERTIES = 4715,
  T_ACCESSTYPE = 4716,
  T_ACCESSID = 4717,
  T_ACCESSKEY = 4718,
  T_STSTOKEN = 4719,
  T_COMPRESSION_CODE = 4720,//Deprecated, use T_COMPRESSION
  T_ENDPOINT = 4721,
  T_PROJECT = 4722,
  T_SCHEMA = 4723,
  T_QUOTA = 4724,
  T_TABLE = 4725,
  T_EXTERNAL_TABLE_PARTITION = 4726,

  //Rebuild Tablet
  T_REBUILD_TABLET = 4727,

  T_MICRO_INDEX_CLUSTERED = 4728,

  // Parquet related
  T_ROW_GROUP_SIZE = 4729,    // FARM COMPAT WHITELIST, renamed
  T_COMPRESSION_ALGORITHM = 4730,//Deprecated, use T_COMPRESSION

  // Erase micro cache
  T_FLUSH_SS_MICRO_CACHE = 4731,

  //restore sts
  T_RESTORE_WITH_CONFIG_LIST = 4732,
  T_STS_CREDENTIAL = 4733,
  // optimizer hint
  T_PQ_GBY_HINT = 4734,
  T_PQ_DISTINCT_HINT = 4735,
  T_DISTRIBUTE_BASIC = 4736,

  T_RB_ITERATE_EXPRESSION = 4737,
  T_MODULE_DATA = 4738,
  T_MODULE_NAME = 4739,

  T_UNION_MERGE_HINT = 4740,
  T_UNION_MERGE_LIST = 4741,
  T_PSEUDO_OLD_NEW_COL = 4742,

  T_TRANSFORM_DISTINCT_AGG = 4743,
  T_NO_TRANSFORM_DISTINCT_AGG = 4744,

  T_UNNEST_EXPRESSION = 4745,
  // orc related
  T_STRIPE_SIZE = 4746,
  T_COMPRESSION_BLOCK_SIZE = 4747,
  T_COLUMN_BLOOM_FILTER = 4748,
  T_ROW_INDEX_STRIDE = 4749,

  T_GRANT_PROXY = 4750,
  T_REVOKE_PROXY = 4751,
  T_TG_DB_SCHEMA = 4752,
  T_TG_SYS_EVENT_OPTION = 4753,
  T_TG_SYS_EVENT = 4754,
  T_TG_DB_EVENT_LIST = 4755,
  T_FILE_EXTENSION = 4756,
  T_LS_ATTR_LIST = 4757,
  T_ALTER_LS = 4758,
  T_UNIT_GROUP = 4759,
  T_TRANSPOSE_TABLE = 4760,
  T_FUN_UNPIVOT = 4761,

  //odps external table
  T_TUNNEL_ENDPOINT = 4762,
  T_COLLECT_STATISTICS_ON_CREATE = 4763,
  T_LOAD_TIME_ZONE_INFO = 4764,

  // create wrapped ddl
  T_CREATE_WRAPPED_PACKAGE = 4765,
  T_CREATE_WRAPPED_PACKAGE_BODY = 4766,
  T_CREATE_WRAPPED_TYPE = 4767,
  T_CREATE_WRAPPED_TYPE_BODY = 4768,
  T_CREATE_WRAPPED_FUNCTION = 4769,
  T_CREATE_WRAPPED_PROCEDURE = 4770,
  T_BASE64_CIPHER = 4771,

  // optimizer hint
  T_INDEX_ASC_HINT = 4772,
  T_INDEX_DESC_HINT = 4773,
  T_PX_NODE_POLICY = 4774,
  T_PX_NODE_ADDRS = 4775,
  T_PX_NODE_COUNT = 4776,
  T_LOAD_DATA_URL = 4777,

  T_PARSER_PROPERTIES = 4778,
  T_PARSER_MIN_TOKEN_SIZE = 4779,
  T_PARSER_MAX_TOKEN_SIZE = 4780,
  T_PARSER_NGRAM_TOKEN_SIZE = 4781,
  T_PARSER_STOPWORD_TABLE = 4782,
  T_PARSER_DICT_TABLE = 4783,
  T_PARSER_QUANTIFIER_TABLE = 4784,

  T_ALTER_MLOG_OPTIONS = 4785,
  // macro block bloom filter
  T_ENABLE_MACRO_BLOCK_BLOOM_FILTER = 4786,
  T_DISTRIBUTE_HASH_LOCAL = 4787,
  // external catalog
  T_CREATE_CATALOG = 4788,
  T_ALTER_CATALOG = 4789,
  T_DROP_CATALOG = 4790,
  T_SET_CATALOG = 4791,
  T_SHOW_CATALOGS = 4792,

  // organization option
  T_ORGANIZATION = 4793,
  T_ORGANIZATION_INDEX = 4794,
  T_ORGANIZATION_HEAP = 4795,
  T_PARSE_HEADER = 4796,
  T_SP_OBJ_PERSISTABLE = 4797,
  T_FLASHBACK_STANDBY_LOG = 4798,
  T_BINARY_FORMAT = 4799,

  // parser config: ik_mode
  T_IK_MODE = 4800,
  T_DML_PARALLEL = 4801,
  //pl dbms scheduler calendar
  T_SCHED_CALENDAR = 4802,
  T_SCHED_CALENDAR_LIST = 4803,
  T_SCHED_CALENDAR_FREQ = 4804,
  T_SCHED_CALENDAR_INTERVAL = 4805,
  T_SCHED_CALENDAR_BY = 4806,
  T_SCHED_CALENDAR_BY_LIST = 4807,

  T_LOAD_LICENSE = 4808,

  // parser config: range ngram
  T_PARSER_MIN_NGRAM_SIZE = 4809,
  T_PARSER_MAX_NGRAM_SIZE = 4810,
  T_MAX //Attention: add a new type before T_MAX
} ObItemType;

typedef enum ObCacheType
{
  CACHE_TYPE_INVALID = -1, //Attention: add a new type after CACHE_TYPE_INVALID
  CACHE_TYPE_ALL,
  CACHE_TYPE_COLUMN_STAT,
  CACHE_TYPE_BLOCK_INDEX,
  CACHE_TYPE_BLOCK,
  CACHE_TYPE_ROW,
  CACHE_TYPE_BLOOM_FILTER,
  CACHE_TYPE_PLAN,
  CACHE_TYPE_LOCATION,
  CACHE_TYPE_CLOG,
  CACHE_TYPE_ILOG,
  CACHE_TYPE_SCHEMA,
  CACHE_TYPE_BALANCE,
  CACHE_TYPE_SQL_AUDIT,
  CACHE_TYPE_PL_OBJ,
  CACHE_TYPE_PS_OBJ,
  CACHE_TYPE_LIB_CACHE,
  CACHE_TYPE_MAX //Attention: add a new type before CACHE_TYPE_MAX
} ObCacheType;

typedef enum ObContextType {
    ACCESSED_LOCALLY = 0,
    INITIALIZED_EXTERNALLY = 1,
    ACCESSED_GLOBALLY = 2,
    INITIALIZED_GLOBALLY = 3,
  }ObContextType;

typedef enum ObOutlineType
{
  OUTLINE_TYPE_INVALID = -1, //Attention: add a new type after CACHE_TYPE_INVALID
  OUTLINE_TYPE_NORMAL,
  OUTLINE_TYPE_FORMAT,
  OUTLINE_TYPE_MAX //Attention: add a new type before CACHE_TYPE_MAX
} ObOutlineType;

#define IS_BOOL_OP(op) \
  (((op) >= T_OP_EQ && (op) <= T_OP_NOT_IN && (op) != T_OP_POW) \
    || ((op) == T_OP_EXISTS) \
    || ((op) == T_OP_NOT_EXISTS) \
    || ((op) == T_FUN_SYS_STRCMP) \
    || ((op) == T_FUN_SYS_JSON_VALID) \
    || ((op) == T_FUN_SYS_JSON_CONTAINS) \
    || ((op) == T_FUN_SYS_JSON_MEMBER_OF) \
    || ((op) == T_FUN_SYS_JSON_OVERLAPS) \
    || ((op) == T_FUN_SYS_JSON_CONTAINS) \
    || ((op) == T_FUN_SYS_JSON_CONTAINS_PATH) \
    || ((op) == T_FUN_SYS_JSON_SCHEMA_VALID) \
    || ((op) == T_FUN_SYS_JSON_EQUAL) \
    || ((op) == T_FUN_SYS_IS_JSON) \
    || ((op) == T_FUN_SYS_JSON_EXISTS) \
    || ((op) == T_BOOL) \
    || ((op) == T_OP_XOR) \
    || ((op) == T_FUN_SYS_IS_UUID) \
    || ((op) == T_FUN_SYS_ST_CONTAINS) \
    || ((op) == T_FUN_SYS_ST_WITHIN) \
    || ((op) == T_FUN_SYS_ST_DWITHIN) \
    || ((op) == T_FUN_SYS_ST_INTERSECTS) \
    || ((op) == T_FUN_SYS_ST_COVERS) \
    || ((op) == T_FUN_SYS_PRIV_ST_EQUALS) \
    || ((op) == T_FUN_SYS_PRIV_ST_TOUCHES) \
    || ((op) == T_FUN_SYS_ST_CROSSES) \
    || ((op) == T_FUN_SYS_ST_OVERLAPS)) \

//in oracle mode, only lists exprs can accept bool(tinyint) param
#define ALLOW_BOOL_INPUT(op) \
  ((IS_BOOL_OP((op))) \
    || ((op) == T_FUN_COLUMN_CONV) \
    || ((op) == T_FUN_PL_COLLECTION_CONSTRUCT) \
    || ((op) == T_FUN_PL_INTEGER_CHECKER) \
    || ((op) == T_FUN_SYS_CAST) \
    || ((op) == T_FUN_SYS_LNNVL) \
    || ((op) == T_FUN_SYS_NVL) \
    || ((op) == T_FUN_UDF) \
    || ((op) == T_OP_ARG_CASE) \
    || ((op) == T_OP_CASE) \
    || ((op) == T_OP_OUTPUT_PACK) \
    || ((op) == T_FUN_SYS_JSON_OBJECT) \
    || ((op) == T_FUN_SYS_JSON_ARRAY) \
    || ((op) == T_OP_TO_OUTFILE_ROW) \
    || ((op) == T_FUNC_SYS_INNER_IS_TRUE)) \



#define IS_RANGE_CMP_OP(op) ((op) >= T_OP_LE && (op) <= T_OP_GT)
// we will extract query range from following OP expressions
// between and, in, is null will be converted to them
#define IS_BASIC_CMP_OP(op) (((op) >= T_OP_EQ && (op) <= T_OP_GT) || ((op) == T_OP_LIKE))
#define IS_STRICT_OP(op) ((IS_BASIC_CMP_OP(op) && (op) != T_OP_NSEQ) || ((op) == T_OP_NE))
#define IS_EXPR_OP(op) ((op) > T_MIN_OP && (op) < T_MAX_OP)
#define IS_CONST_LITERAL(op) (((op) > T_INVALID && (op) < T_MAX_CONST && (op) != T_QUESTIONMARK) || T_USER_VARIABLE_IDENTIFIER == op)
#define IS_DATATYPE_OP(op) (T_INVALID < (op) && (op) < T_MAX_CONST && T_EXTEND != (op) && T_QUESTIONMARK != (op))
#define IS_DATATYPE_OR_QUESTIONMARK_OP(op) (T_INVALID < (op) && (op) < T_MAX_CONST && T_EXTEND != (op))
#define IS_NUMBER_TC_OP(op) (T_NUMBER == (op) || T_UNUMBER == (op))
#define IS_STRING_TC_OP(op) (T_VARCHAR == (op) || T_CHAR == (op) || T_VARBINARY == (op) || T_BINARY == (op))
#define IS_SINGLE_VALUE_OP(op) (T_OP_EQ == (op) || T_OP_NSEQ == (op) || T_OP_IN == (op))
#define IS_CONST_TYPE(op) ((op) > T_INVALID && (op) < T_MAX_CONST)
#define IS_FUN_SYS_TYPE(op) (((op) >= T_FUN_SYS && (op) < T_FUN_SYS_END) \
                            || ((op) > T_MIN_OP && (op) <= T_OP_CONST_VAL) \
                            || T_OP_CONNECT_BY_ROOT == (op) \
                            || (lib::is_oracle_mode() && (op) == T_OP_BIT_AND))

#define IS_FUN_STYLE(op) (((op) >= T_FUN_SYS && (op) < T_FUN_SYS_END) \
    || ((op) >= T_FUN_MAX && (op) <= T_FUN_APPROX_COUNT_DISTINCT_SYNOPSIS_MERGE) \
    || T_OP_ABS == (op) \
    || T_OP_MOD == (op) \
    || T_OP_POW == (op) \
    || T_OP_CONV == (op) \
    || T_OP_CNN == (op) \
    || T_OP_SIGN == (op) \
    || T_OP_CONNECT_BY_ROOT == (op))

#define ITEM_TO_OBJ_TYPE(op) (static_cast<ObObjType>(op))

#define IS_COMPARISON_OP(op)                            \
  (((op) >= T_OP_EQ && (op) <= T_OP_NE)                 \
   || ((op) >= T_OP_SQ_EQ && (op) <= T_OP_SQ_NE)        \
   || ((op) == T_OP_IN) || ((op) == T_OP_NOT_IN))
#define IS_COMMON_COMPARISON_OP(op) ((op) >= T_OP_EQ && (op) <= T_OP_NE)
#define IS_SUBQUERY_COMPARISON_OP(op) ((op) >= T_OP_SQ_EQ && (op) <= T_OP_SQ_NE)
#define IS_ENUM_SET_OP(op) ((op) >= T_FUN_ENUM_TO_STR && (op) <= T_FUN_SET_TO_INNER_TYPE)

// special statements
#define IS_TRANSACTION_STMT(op) ((op) == T_BEGIN || (op) == T_COMMIT || (op) == T_ROLLBACK)
#define IS_PREPARABLE_STMT(op)  \
  ((op) == T_SELECT || (op) == T_DELETE || (op) == T_INSERT || (op) == T_MERGE || (op) == T_UPDATE \
   || (op) == T_BEGIN || (op) == T_COMMIT || (op) == T_ROLLBACK)

#define IS_DML_STMT(op)  \
  ((op) == T_SELECT || (op) == T_DELETE || (op) == T_INSERT || (op) == T_MERGE || (op) == T_UPDATE || (op) == T_MULTI_INSERT)
#define IS_SHOW_STMT(op) (((op) >= T_SHOW_TABLES && (op) <= T_SHOW_GRANTS) || (op) == T_SHOW_TRIGGERS || (op) == T_SHOW_CREATE_USER)

#define EXPR_OP_NUM (T_MAX_OP-T_MIN_OP-1)
extern const char *get_type_name(int type);

#define IS_AGGR_FUN(op) (((op) >= T_FUN_MAX && (op) <= T_FUN_APPROX_COUNT_DISTINCT_SYNOPSIS_MERGE) ||\
                         ((op) >= T_FUN_CORR && (op) <= T_FUN_REGR_SXY) ||  \
                         ((op) >= T_FUN_GROUP_RANK && (op) <= T_FUN_GROUP_PERCENTILE_DISC) ||\
                         (op) == T_FUN_GROUPING || (op) == T_FUN_KEEP_WM_CONCAT ||\
                         (op) == T_FUN_WM_CONCAT || (op) == T_FUN_PL_AGG_UDF || \
                         (op) == T_FUN_TOP_FRE_HIST || (op) == T_FUN_HYBRID_HIST || \
                         (op) == T_FUN_AGG_UDF || (op) == T_FUN_GROUPING_ID || \
                         (op) == T_FUN_JSON_ARRAYAGG || (op) == T_FUN_JSON_OBJECTAGG ||\
                         (op) == T_FUN_ORA_JSON_ARRAYAGG || (op) == T_FUN_ORA_JSON_OBJECTAGG ||\
                         (op) == T_FUN_GROUP_ID || \
                         (op) == T_FUN_ORA_XMLAGG || \
                         (op) == T_FUN_SYS_ST_ASMVT || \
                         (op) == T_FUN_SUM_OPNSIZE ||\
                         (op) == T_FUN_SYS_RB_BUILD_AGG ||\
                         (op) == T_FUN_SYS_RB_OR_AGG ||\
                         (op) == T_FUN_SYS_RB_AND_AGG ||\
                         (op) == T_FUNC_SYS_ARRAY_AGG ||\
                         ((op) >= T_FUN_SYS_BIT_AND && (op) <= T_FUN_SYS_BIT_XOR))
#define MAYBE_ROW_OP(op) ((op) >= T_OP_EQ && (op) <= T_OP_NE)
#define IS_PSEUDO_COLUMN_TYPE(op) \
  ((op) == T_LEVEL || (op) == T_CONNECT_BY_ISLEAF || (op) == T_CONNECT_BY_ISCYCLE || (op) == T_ORA_ROWSCN)

#define IS_LABEL_SE_POLICY_FUNC(op) \
  (T_FUN_LABEL_SE_POLICY_CREATE <= (op) && (op) <= T_FUN_LABEL_SE_LABEL_DROP)

#define IS_KEEP_AGGR_FUN(op) ((op) >= T_FUN_KEEP_MAX && (op) <= T_FUN_KEEP_STDDEV)

#define IS_JSON_COMPATIBLE_OP(op) (IS_COMMON_COMPARISON_OP(op) || (op) == T_OP_ROW || (op) == T_OP_LIKE)
#define IS_TYPE_DEMOTION_FUN(op) ((T_FUN_SYS_DEMOTE_CAST == (op) || \
                                   T_FUN_SYS_RANGE_PLACEMENT == (op)))

#define IS_ARRAY_MAP_OP(op) ((op) == T_FUNC_SYS_ARRAY_MAP || \
                             (op) == T_FUNC_SYS_ARRAY_FIRST || \
                             (op) == T_FUNC_SYS_ARRAY_FILTER || \
                             (op) == T_FUNC_SYS_ARRAY_SORTBY)
/**
 * @notice: 目前只支持IS_BASIC_CMP_OP这个宏里定义的op type，如果有在这之外的需求，请扩展这个接口的实现
 * */
inline ObItemType get_opposite_compare_type(ObItemType src_type)
{
  ObItemType ret_type = src_type;
  switch (src_type) {
    case T_OP_LT:
      ret_type = T_OP_GT;
      break;
    case T_OP_GT:
      ret_type = T_OP_LT;
      break;
    case T_OP_LE:
      ret_type = T_OP_GE;
      break;
    case T_OP_GE:
      ret_type = T_OP_LE;
      break;
    case T_OP_EXISTS:
      ret_type = T_OP_NOT_EXISTS;
      break;
    case T_OP_NOT_EXISTS:
      ret_type = T_OP_EXISTS;
      break;
    default:
      ret_type = src_type;
      break;
  }
  return ret_type;
}

#ifdef __cplusplus
}
#ifndef SQL_PARSER_COMPILATION
#include "lib/utility/ob_print_utils.h"
namespace oceanbase
{
namespace common
{
template<>
inline int databuff_print_obj(char *buf, const int64_t buf_len, int64_t &pos,
                              const ObItemType &obj)
{
  //ignore ret value on purpose;if failed, the string will be truncated
  return databuff_printf(buf, buf_len, pos, "\"%s\"", get_type_name(obj));
}

template<>
inline int databuff_print_key_obj(char *buf, const int64_t buf_len, int64_t &pos, const char *key,
                                  const bool with_comma, const ObItemType &obj)
{
  return databuff_printf(buf, buf_len, pos, WITH_COMMA("%s:\"%s\""), key, get_type_name(obj));
}
}  // namespace common
} // end namespace oceanbase
#endif // SQL_PARSER_COMPILATION
#endif //__cplusplus
#endif //OCEANBASE_SQL_OB_ITEM_TYPE_H_
