/**
 * Copyright (c) 2021 OceanBase
 * OceanBase CE is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *          http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
#ifndef __SQL_ENG_P2P_DH_SHARE_INFO_H__
#define __SQL_ENG_P2P_DH_SHARE_INFO_H__

#include "lib/ob_define.h"
#include "lib/hash/ob_hashmap.h"
namespace oceanbase
{
namespace sql
{

class ObP2PDatahubManagerHashWrapper
{
  OB_UNIS_VERSION(1);
public:
  ObP2PDatahubManagerHashWrapper() :
      p2p_datahub_id_(OB_INVALID_ID), px_sequence_id_(OB_INVALID_ID), task_id_(0),
      start_time_(0), timeout_ts_(0) {}
  ObP2PDatahubManagerHashWrapper(int64_t p2p_datahub_id, int64_t px_sequence_id, int64_t task_id) :
      p2p_datahub_id_(p2p_datahub_id),
      px_sequence_id_(px_sequence_id),
      task_id_(task_id),
      start_time_(0), timeout_ts_(0) {}
  ObP2PDatahubManagerHashWrapper(int64_t p2p_datahub_id, int64_t px_sequence_id,
      int64_t task_id, int64_t start_time, int64_t timeout_ts) :
      p2p_datahub_id_(p2p_datahub_id),
      px_sequence_id_(px_sequence_id),
      task_id_(task_id),
      start_time_(start_time), timeout_ts_(timeout_ts) {}
  ~ObP2PDatahubManagerHashWrapper() {}
  inline bool operator==(const ObP2PDatahubManagerHashWrapper &other) const
  {
    return p2p_datahub_id_ == other.p2p_datahub_id_ &&
           px_sequence_id_ == other.px_sequence_id_ &&
           task_id_ == other.task_id_;
  }
  inline uint64_t hash() const;
  int hash(uint64_t &hash_val) const { hash_val = hash(); return OB_SUCCESS; }

  // generated by the optimizer,
  // a unique identifier represents data that needs to be accessed via P2P Datahub.
  int64_t p2p_datahub_id_;
  // The use of PX ID as a unique dynamic identifier during execution,
  // in combination with P2P Datahub ID, ensures uniqueness.
  int64_t px_sequence_id_;
  // task id is used for partition wise
  int64_t task_id_;
  int64_t start_time_;
  int64_t timeout_ts_;
  TO_STRING_KV(K_(p2p_datahub_id), K_(px_sequence_id), K_(task_id), K_(start_time), K_(timeout_ts));
};

typedef ObP2PDatahubManagerHashWrapper ObP2PDhKey;
inline uint64_t ObP2PDatahubManagerHashWrapper::hash() const
{
  uint64_t hash_ret = 0;
  hash_ret = common::murmurhash(&p2p_datahub_id_, sizeof(uint64_t), 0);
  hash_ret = common::murmurhash(&px_sequence_id_, sizeof(uint64_t), hash_ret);
  hash_ret = common::murmurhash(&task_id_, sizeof(uint64_t), hash_ret);
  return hash_ret;
}

}
}

#endif
