/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"bytes"
	"context"
	"io"
	"net/http"
	"net/url"
	"strings"
	"reflect"
)


// ContentReleaseComponentsAPIService ContentReleaseComponentsAPI service
type ContentReleaseComponentsAPIService service

type ContentReleaseComponentsAPIContentDebReleaseComponentsCreateRequest struct {
	ctx context.Context
	ApiService *ContentReleaseComponentsAPIService
	debReleaseComponent *DebReleaseComponent
}

func (r ContentReleaseComponentsAPIContentDebReleaseComponentsCreateRequest) DebReleaseComponent(debReleaseComponent DebReleaseComponent) ContentReleaseComponentsAPIContentDebReleaseComponentsCreateRequest {
	r.debReleaseComponent = &debReleaseComponent
	return r
}

func (r ContentReleaseComponentsAPIContentDebReleaseComponentsCreateRequest) Execute() (*DebReleaseComponentResponse, *http.Response, error) {
	return r.ApiService.ContentDebReleaseComponentsCreateExecute(r)
}

/*
ContentDebReleaseComponentsCreate Create a release component

A ReleaseComponent represents a single APT repository component.

Associated artifacts: None; contains only metadata.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return ContentReleaseComponentsAPIContentDebReleaseComponentsCreateRequest
*/
func (a *ContentReleaseComponentsAPIService) ContentDebReleaseComponentsCreate(ctx context.Context) ContentReleaseComponentsAPIContentDebReleaseComponentsCreateRequest {
	return ContentReleaseComponentsAPIContentDebReleaseComponentsCreateRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return DebReleaseComponentResponse
func (a *ContentReleaseComponentsAPIService) ContentDebReleaseComponentsCreateExecute(r ContentReleaseComponentsAPIContentDebReleaseComponentsCreateRequest) (*DebReleaseComponentResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *DebReleaseComponentResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ContentReleaseComponentsAPIService.ContentDebReleaseComponentsCreate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/content/deb/release_components/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.debReleaseComponent == nil {
		return localVarReturnValue, nil, reportError("debReleaseComponent is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.debReleaseComponent
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ContentReleaseComponentsAPIContentDebReleaseComponentsListRequest struct {
	ctx context.Context
	ApiService *ContentReleaseComponentsAPIService
	codename *string
	component *string
	distribution *string
	limit *int32
	offset *int32
	ordering *[]string
	pulpHrefIn *[]string
	pulpIdIn *[]string
	repositoryVersion *string
	repositoryVersionAdded *string
	repositoryVersionRemoved *string
	suite *string
	fields *[]string
	excludeFields *[]string
}

// Filter results where codename matches value
func (r ContentReleaseComponentsAPIContentDebReleaseComponentsListRequest) Codename(codename string) ContentReleaseComponentsAPIContentDebReleaseComponentsListRequest {
	r.codename = &codename
	return r
}

// Filter results where component matches value
func (r ContentReleaseComponentsAPIContentDebReleaseComponentsListRequest) Component(component string) ContentReleaseComponentsAPIContentDebReleaseComponentsListRequest {
	r.component = &component
	return r
}

// Filter results where distribution matches value
func (r ContentReleaseComponentsAPIContentDebReleaseComponentsListRequest) Distribution(distribution string) ContentReleaseComponentsAPIContentDebReleaseComponentsListRequest {
	r.distribution = &distribution
	return r
}

// Number of results to return per page.
func (r ContentReleaseComponentsAPIContentDebReleaseComponentsListRequest) Limit(limit int32) ContentReleaseComponentsAPIContentDebReleaseComponentsListRequest {
	r.limit = &limit
	return r
}

// The initial index from which to return the results.
func (r ContentReleaseComponentsAPIContentDebReleaseComponentsListRequest) Offset(offset int32) ContentReleaseComponentsAPIContentDebReleaseComponentsListRequest {
	r.offset = &offset
	return r
}

// Ordering  * &#x60;pulp_id&#x60; - Pulp id * &#x60;-pulp_id&#x60; - Pulp id (descending) * &#x60;pulp_created&#x60; - Pulp created * &#x60;-pulp_created&#x60; - Pulp created (descending) * &#x60;pulp_last_updated&#x60; - Pulp last updated * &#x60;-pulp_last_updated&#x60; - Pulp last updated (descending) * &#x60;pulp_type&#x60; - Pulp type * &#x60;-pulp_type&#x60; - Pulp type (descending) * &#x60;upstream_id&#x60; - Upstream id * &#x60;-upstream_id&#x60; - Upstream id (descending) * &#x60;timestamp_of_interest&#x60; - Timestamp of interest * &#x60;-timestamp_of_interest&#x60; - Timestamp of interest (descending) * &#x60;distribution&#x60; - Distribution * &#x60;-distribution&#x60; - Distribution (descending) * &#x60;component&#x60; - Component * &#x60;-component&#x60; - Component (descending) * &#x60;codename&#x60; - Codename * &#x60;-codename&#x60; - Codename (descending) * &#x60;suite&#x60; - Suite * &#x60;-suite&#x60; - Suite (descending) * &#x60;pk&#x60; - Pk * &#x60;-pk&#x60; - Pk (descending)
func (r ContentReleaseComponentsAPIContentDebReleaseComponentsListRequest) Ordering(ordering []string) ContentReleaseComponentsAPIContentDebReleaseComponentsListRequest {
	r.ordering = &ordering
	return r
}

// Multiple values may be separated by commas.
func (r ContentReleaseComponentsAPIContentDebReleaseComponentsListRequest) PulpHrefIn(pulpHrefIn []string) ContentReleaseComponentsAPIContentDebReleaseComponentsListRequest {
	r.pulpHrefIn = &pulpHrefIn
	return r
}

// Multiple values may be separated by commas.
func (r ContentReleaseComponentsAPIContentDebReleaseComponentsListRequest) PulpIdIn(pulpIdIn []string) ContentReleaseComponentsAPIContentDebReleaseComponentsListRequest {
	r.pulpIdIn = &pulpIdIn
	return r
}

// Repository Version referenced by HREF
func (r ContentReleaseComponentsAPIContentDebReleaseComponentsListRequest) RepositoryVersion(repositoryVersion string) ContentReleaseComponentsAPIContentDebReleaseComponentsListRequest {
	r.repositoryVersion = &repositoryVersion
	return r
}

// Repository Version referenced by HREF
func (r ContentReleaseComponentsAPIContentDebReleaseComponentsListRequest) RepositoryVersionAdded(repositoryVersionAdded string) ContentReleaseComponentsAPIContentDebReleaseComponentsListRequest {
	r.repositoryVersionAdded = &repositoryVersionAdded
	return r
}

// Repository Version referenced by HREF
func (r ContentReleaseComponentsAPIContentDebReleaseComponentsListRequest) RepositoryVersionRemoved(repositoryVersionRemoved string) ContentReleaseComponentsAPIContentDebReleaseComponentsListRequest {
	r.repositoryVersionRemoved = &repositoryVersionRemoved
	return r
}

// Filter results where suite matches value
func (r ContentReleaseComponentsAPIContentDebReleaseComponentsListRequest) Suite(suite string) ContentReleaseComponentsAPIContentDebReleaseComponentsListRequest {
	r.suite = &suite
	return r
}

// A list of fields to include in the response.
func (r ContentReleaseComponentsAPIContentDebReleaseComponentsListRequest) Fields(fields []string) ContentReleaseComponentsAPIContentDebReleaseComponentsListRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r ContentReleaseComponentsAPIContentDebReleaseComponentsListRequest) ExcludeFields(excludeFields []string) ContentReleaseComponentsAPIContentDebReleaseComponentsListRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r ContentReleaseComponentsAPIContentDebReleaseComponentsListRequest) Execute() (*PaginateddebReleaseComponentResponseList, *http.Response, error) {
	return r.ApiService.ContentDebReleaseComponentsListExecute(r)
}

/*
ContentDebReleaseComponentsList List release components

A ReleaseComponent represents a single APT repository component.

Associated artifacts: None; contains only metadata.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return ContentReleaseComponentsAPIContentDebReleaseComponentsListRequest
*/
func (a *ContentReleaseComponentsAPIService) ContentDebReleaseComponentsList(ctx context.Context) ContentReleaseComponentsAPIContentDebReleaseComponentsListRequest {
	return ContentReleaseComponentsAPIContentDebReleaseComponentsListRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return PaginateddebReleaseComponentResponseList
func (a *ContentReleaseComponentsAPIService) ContentDebReleaseComponentsListExecute(r ContentReleaseComponentsAPIContentDebReleaseComponentsListRequest) (*PaginateddebReleaseComponentResponseList, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *PaginateddebReleaseComponentResponseList
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ContentReleaseComponentsAPIService.ContentDebReleaseComponentsList")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/content/deb/release_components/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.codename != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "codename", r.codename, "")
	}
	if r.component != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "component", r.component, "")
	}
	if r.distribution != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "distribution", r.distribution, "")
	}
	if r.limit != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "limit", r.limit, "")
	}
	if r.offset != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "offset", r.offset, "")
	}
	if r.ordering != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "ordering", r.ordering, "csv")
	}
	if r.pulpHrefIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_href__in", r.pulpHrefIn, "csv")
	}
	if r.pulpIdIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_id__in", r.pulpIdIn, "csv")
	}
	if r.repositoryVersion != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "repository_version", r.repositoryVersion, "")
	}
	if r.repositoryVersionAdded != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "repository_version_added", r.repositoryVersionAdded, "")
	}
	if r.repositoryVersionRemoved != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "repository_version_removed", r.repositoryVersionRemoved, "")
	}
	if r.suite != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "suite", r.suite, "")
	}
	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ContentReleaseComponentsAPIContentDebReleaseComponentsReadRequest struct {
	ctx context.Context
	ApiService *ContentReleaseComponentsAPIService
	debReleaseComponentHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r ContentReleaseComponentsAPIContentDebReleaseComponentsReadRequest) Fields(fields []string) ContentReleaseComponentsAPIContentDebReleaseComponentsReadRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r ContentReleaseComponentsAPIContentDebReleaseComponentsReadRequest) ExcludeFields(excludeFields []string) ContentReleaseComponentsAPIContentDebReleaseComponentsReadRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r ContentReleaseComponentsAPIContentDebReleaseComponentsReadRequest) Execute() (*DebReleaseComponentResponse, *http.Response, error) {
	return r.ApiService.ContentDebReleaseComponentsReadExecute(r)
}

/*
ContentDebReleaseComponentsRead Inspect a release component

A ReleaseComponent represents a single APT repository component.

Associated artifacts: None; contains only metadata.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param debReleaseComponentHref
 @return ContentReleaseComponentsAPIContentDebReleaseComponentsReadRequest
*/
func (a *ContentReleaseComponentsAPIService) ContentDebReleaseComponentsRead(ctx context.Context, debReleaseComponentHref string) ContentReleaseComponentsAPIContentDebReleaseComponentsReadRequest {
	return ContentReleaseComponentsAPIContentDebReleaseComponentsReadRequest{
		ApiService: a,
		ctx: ctx,
		debReleaseComponentHref: debReleaseComponentHref,
	}
}

// Execute executes the request
//  @return DebReleaseComponentResponse
func (a *ContentReleaseComponentsAPIService) ContentDebReleaseComponentsReadExecute(r ContentReleaseComponentsAPIContentDebReleaseComponentsReadRequest) (*DebReleaseComponentResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *DebReleaseComponentResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ContentReleaseComponentsAPIService.ContentDebReleaseComponentsRead")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{deb_release_component_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"deb_release_component_href"+"}", parameterValueToString(r.debReleaseComponentHref, "debReleaseComponentHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}
