/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"encoding/json"
	"time"
)

// checks if the PulpExporterResponse type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &PulpExporterResponse{}

// PulpExporterResponse Serializer for pulp exporters.
type PulpExporterResponse struct {
	PulpHref *string `json:"pulp_href,omitempty"`
	// Timestamp of creation.
	PulpCreated *time.Time `json:"pulp_created,omitempty"`
	// Unique name of the file system exporter.
	Name string `json:"name"`
	// File system directory to store exported tar.gzs.
	Path string `json:"path"`
	Repositories []string `json:"repositories"`
	// Last attempted export for this PulpExporter
	LastExport NullableString `json:"last_export,omitempty"`
	AdditionalProperties map[string]interface{}
}

type _PulpExporterResponse PulpExporterResponse

// NewPulpExporterResponse instantiates a new PulpExporterResponse object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewPulpExporterResponse(name string, path string, repositories []string) *PulpExporterResponse {
	this := PulpExporterResponse{}
	this.Name = name
	this.Path = path
	this.Repositories = repositories
	return &this
}

// NewPulpExporterResponseWithDefaults instantiates a new PulpExporterResponse object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewPulpExporterResponseWithDefaults() *PulpExporterResponse {
	this := PulpExporterResponse{}
	return &this
}

// GetPulpHref returns the PulpHref field value if set, zero value otherwise.
func (o *PulpExporterResponse) GetPulpHref() string {
	if o == nil || IsNil(o.PulpHref) {
		var ret string
		return ret
	}
	return *o.PulpHref
}

// GetPulpHrefOk returns a tuple with the PulpHref field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PulpExporterResponse) GetPulpHrefOk() (*string, bool) {
	if o == nil || IsNil(o.PulpHref) {
		return nil, false
	}
	return o.PulpHref, true
}

// HasPulpHref returns a boolean if a field has been set.
func (o *PulpExporterResponse) HasPulpHref() bool {
	if o != nil && !IsNil(o.PulpHref) {
		return true
	}

	return false
}

// SetPulpHref gets a reference to the given string and assigns it to the PulpHref field.
func (o *PulpExporterResponse) SetPulpHref(v string) {
	o.PulpHref = &v
}

// GetPulpCreated returns the PulpCreated field value if set, zero value otherwise.
func (o *PulpExporterResponse) GetPulpCreated() time.Time {
	if o == nil || IsNil(o.PulpCreated) {
		var ret time.Time
		return ret
	}
	return *o.PulpCreated
}

// GetPulpCreatedOk returns a tuple with the PulpCreated field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PulpExporterResponse) GetPulpCreatedOk() (*time.Time, bool) {
	if o == nil || IsNil(o.PulpCreated) {
		return nil, false
	}
	return o.PulpCreated, true
}

// HasPulpCreated returns a boolean if a field has been set.
func (o *PulpExporterResponse) HasPulpCreated() bool {
	if o != nil && !IsNil(o.PulpCreated) {
		return true
	}

	return false
}

// SetPulpCreated gets a reference to the given time.Time and assigns it to the PulpCreated field.
func (o *PulpExporterResponse) SetPulpCreated(v time.Time) {
	o.PulpCreated = &v
}

// GetName returns the Name field value
func (o *PulpExporterResponse) GetName() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *PulpExporterResponse) GetNameOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *PulpExporterResponse) SetName(v string) {
	o.Name = v
}

// GetPath returns the Path field value
func (o *PulpExporterResponse) GetPath() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Path
}

// GetPathOk returns a tuple with the Path field value
// and a boolean to check if the value has been set.
func (o *PulpExporterResponse) GetPathOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Path, true
}

// SetPath sets field value
func (o *PulpExporterResponse) SetPath(v string) {
	o.Path = v
}

// GetRepositories returns the Repositories field value
func (o *PulpExporterResponse) GetRepositories() []string {
	if o == nil {
		var ret []string
		return ret
	}

	return o.Repositories
}

// GetRepositoriesOk returns a tuple with the Repositories field value
// and a boolean to check if the value has been set.
func (o *PulpExporterResponse) GetRepositoriesOk() ([]string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Repositories, true
}

// SetRepositories sets field value
func (o *PulpExporterResponse) SetRepositories(v []string) {
	o.Repositories = v
}

// GetLastExport returns the LastExport field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *PulpExporterResponse) GetLastExport() string {
	if o == nil || IsNil(o.LastExport.Get()) {
		var ret string
		return ret
	}
	return *o.LastExport.Get()
}

// GetLastExportOk returns a tuple with the LastExport field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *PulpExporterResponse) GetLastExportOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.LastExport.Get(), o.LastExport.IsSet()
}

// HasLastExport returns a boolean if a field has been set.
func (o *PulpExporterResponse) HasLastExport() bool {
	if o != nil && o.LastExport.IsSet() {
		return true
	}

	return false
}

// SetLastExport gets a reference to the given NullableString and assigns it to the LastExport field.
func (o *PulpExporterResponse) SetLastExport(v string) {
	o.LastExport.Set(&v)
}
// SetLastExportNil sets the value for LastExport to be an explicit nil
func (o *PulpExporterResponse) SetLastExportNil() {
	o.LastExport.Set(nil)
}

// UnsetLastExport ensures that no value is present for LastExport, not even an explicit nil
func (o *PulpExporterResponse) UnsetLastExport() {
	o.LastExport.Unset()
}

func (o PulpExporterResponse) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o PulpExporterResponse) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !IsNil(o.PulpHref) {
		toSerialize["pulp_href"] = o.PulpHref
	}
	if !IsNil(o.PulpCreated) {
		toSerialize["pulp_created"] = o.PulpCreated
	}
	toSerialize["name"] = o.Name
	toSerialize["path"] = o.Path
	toSerialize["repositories"] = o.Repositories
	if o.LastExport.IsSet() {
		toSerialize["last_export"] = o.LastExport.Get()
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *PulpExporterResponse) UnmarshalJSON(bytes []byte) (err error) {
	varPulpExporterResponse := _PulpExporterResponse{}

	if err = json.Unmarshal(bytes, &varPulpExporterResponse); err == nil {
		*o = PulpExporterResponse(varPulpExporterResponse)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "pulp_href")
		delete(additionalProperties, "pulp_created")
		delete(additionalProperties, "name")
		delete(additionalProperties, "path")
		delete(additionalProperties, "repositories")
		delete(additionalProperties, "last_export")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullablePulpExporterResponse struct {
	value *PulpExporterResponse
	isSet bool
}

func (v NullablePulpExporterResponse) Get() *PulpExporterResponse {
	return v.value
}

func (v *NullablePulpExporterResponse) Set(val *PulpExporterResponse) {
	v.value = val
	v.isSet = true
}

func (v NullablePulpExporterResponse) IsSet() bool {
	return v.isSet
}

func (v *NullablePulpExporterResponse) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullablePulpExporterResponse(val *PulpExporterResponse) *NullablePulpExporterResponse {
	return &NullablePulpExporterResponse{value: val, isSet: true}
}

func (v NullablePulpExporterResponse) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullablePulpExporterResponse) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


