/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"encoding/json"
	"os"
)

// checks if the CompsXml type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &CompsXml{}

// CompsXml A serializer for comps.xml Upload API.
type CompsXml struct {
	// Full path of a comps.xml file that may be parsed into comps.xml Content units.
	File *os.File `json:"file"`
	// URI of an RPM repository the comps.xml content units should be associated to.
	Repository *string `json:"repository,omitempty"`
	// If true, incoming comps.xml replaces existing comps-related ContentUnits in the specified repository.
	Replace *bool `json:"replace,omitempty"`
	AdditionalProperties map[string]interface{}
}

type _CompsXml CompsXml

// NewCompsXml instantiates a new CompsXml object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewCompsXml(file *os.File) *CompsXml {
	this := CompsXml{}
	this.File = file
	return &this
}

// NewCompsXmlWithDefaults instantiates a new CompsXml object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewCompsXmlWithDefaults() *CompsXml {
	this := CompsXml{}
	return &this
}

// GetFile returns the File field value
func (o *CompsXml) GetFile() *os.File {
	if o == nil {
		var ret *os.File
		return ret
	}

	return o.File
}

// GetFileOk returns a tuple with the File field value
// and a boolean to check if the value has been set.
func (o *CompsXml) GetFileOk() (**os.File, bool) {
	if o == nil {
		return nil, false
	}
	return &o.File, true
}

// SetFile sets field value
func (o *CompsXml) SetFile(v *os.File) {
	o.File = v
}

// GetRepository returns the Repository field value if set, zero value otherwise.
func (o *CompsXml) GetRepository() string {
	if o == nil || IsNil(o.Repository) {
		var ret string
		return ret
	}
	return *o.Repository
}

// GetRepositoryOk returns a tuple with the Repository field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CompsXml) GetRepositoryOk() (*string, bool) {
	if o == nil || IsNil(o.Repository) {
		return nil, false
	}
	return o.Repository, true
}

// HasRepository returns a boolean if a field has been set.
func (o *CompsXml) HasRepository() bool {
	if o != nil && !IsNil(o.Repository) {
		return true
	}

	return false
}

// SetRepository gets a reference to the given string and assigns it to the Repository field.
func (o *CompsXml) SetRepository(v string) {
	o.Repository = &v
}

// GetReplace returns the Replace field value if set, zero value otherwise.
func (o *CompsXml) GetReplace() bool {
	if o == nil || IsNil(o.Replace) {
		var ret bool
		return ret
	}
	return *o.Replace
}

// GetReplaceOk returns a tuple with the Replace field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CompsXml) GetReplaceOk() (*bool, bool) {
	if o == nil || IsNil(o.Replace) {
		return nil, false
	}
	return o.Replace, true
}

// HasReplace returns a boolean if a field has been set.
func (o *CompsXml) HasReplace() bool {
	if o != nil && !IsNil(o.Replace) {
		return true
	}

	return false
}

// SetReplace gets a reference to the given bool and assigns it to the Replace field.
func (o *CompsXml) SetReplace(v bool) {
	o.Replace = &v
}

func (o CompsXml) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o CompsXml) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["file"] = o.File
	if !IsNil(o.Repository) {
		toSerialize["repository"] = o.Repository
	}
	if !IsNil(o.Replace) {
		toSerialize["replace"] = o.Replace
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *CompsXml) UnmarshalJSON(bytes []byte) (err error) {
	varCompsXml := _CompsXml{}

	if err = json.Unmarshal(bytes, &varCompsXml); err == nil {
		*o = CompsXml(varCompsXml)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "file")
		delete(additionalProperties, "repository")
		delete(additionalProperties, "replace")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableCompsXml struct {
	value *CompsXml
	isSet bool
}

func (v NullableCompsXml) Get() *CompsXml {
	return v.value
}

func (v *NullableCompsXml) Set(val *CompsXml) {
	v.value = val
	v.isSet = true
}

func (v NullableCompsXml) IsSet() bool {
	return v.isSet
}

func (v *NullableCompsXml) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableCompsXml(val *CompsXml) *NullableCompsXml {
	return &NullableCompsXml{value: val, isSet: true}
}

func (v NullableCompsXml) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableCompsXml) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


