/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.cert;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.cert.CertReviewResponse;
import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.profile.PolicyConstraint;
import com.netscape.certsrv.profile.ProfilePolicy;
import com.netscape.certsrv.profile.ProfilePolicySet;
import com.netscape.certsrv.property.EPropertyException;
import com.netscape.cms.profile.common.Profile;
import com.netscape.cms.profile.common.ProfileInput;
import com.netscape.cms.profile.def.PolicyDefault;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cms.servlet.profile.PolicyConstraintFactory;
import com.netscape.cms.servlet.profile.PolicyDefaultFactory;
import com.netscape.cms.servlet.profile.ProfileInputFactory;
import com.netscape.cmscore.base.ArgBlock;
import com.netscape.cmscore.request.Request;
import java.util.Enumeration;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertReviewResponseFactory {
    public static Logger logger = LoggerFactory.getLogger(CertReviewResponseFactory.class);

    public static CertReviewResponse create(Request request, Profile profile, UriInfo uriInfo, Locale locale) throws EBaseException {
        CertReviewResponse ret = new CertReviewResponse();
        if (request.getRequestType().equals("renewal")) {
            ret.setRenewal(true);
        } else {
            ret.setRenewal(false);
        }
        ret.setRequestId(request.getRequestId());
        ret.setRequestType(request.getRequestType());
        ret.setRequestStatus(request.getRequestStatus().toString());
        if (request.getRequestOwner() == null) {
            ret.setRequestOwner("");
        } else {
            ret.setRequestOwner(request.getRequestOwner());
        }
        ret.setRequestCreationTime(request.getCreationTime().toString());
        ret.setRequestModificationTime(request.getModificationTime().toString());
        ret.setProfileId(profile.getId());
        ret.setProfileApprovedBy(request.getExtDataInString("profileApprovedBy"));
        ret.setProfileSetId(request.getExtDataInString("profileSetId"));
        if (profile.isVisible()) {
            ret.setProfileIsVisible("true");
        } else {
            ret.setProfileIsVisible("false");
        }
        ret.setProfileName(profile.getName(locale));
        ret.setProfileDescription(profile.getDescription(locale));
        ret.setProfileRemoteHost(request.getExtDataInString("profileRemoteHost"));
        ret.setProfileRemoteAddr(request.getExtDataInString("profileRemoteAddr"));
        if (request.getExtDataInString("requestNotes") == null) {
            ret.setRequestNotes("");
        } else {
            ret.setRequestNotes(request.getExtDataInString("requestNotes"));
        }
        Enumeration<String> inputIds = profile.getProfileInputIds();
        while (inputIds.hasMoreElements()) {
            ProfileInput input = profile.getProfileInput(inputIds.nextElement());
            com.netscape.certsrv.profile.ProfileInput addInput = ProfileInputFactory.create(input, request, locale);
            ret.addInput(addInput);
        }
        String profileSetId = request.getExtDataInString("profileSetId");
        logger.debug("createAgentCertRequestInfo: profileSetId=" + profileSetId);
        Enumeration<String> policyIds = profileSetId != null && profileSetId.length() > 0 ? profile.getProfilePolicyIds(profileSetId) : null;
        ProfilePolicySet dataPolicySet = new ProfilePolicySet();
        if (policyIds != null) {
            while (policyIds.hasMoreElements()) {
                String id = policyIds.nextElement();
                logger.debug("policyId:" + id);
                com.netscape.cms.profile.common.ProfilePolicy policy = profile.getProfilePolicy(profileSetId, id);
                ProfilePolicy dataPolicy = new ProfilePolicy();
                dataPolicy.setId(id);
                PolicyDefault def = policy.getDefault();
                com.netscape.certsrv.profile.PolicyDefault dataDef = PolicyDefaultFactory.create(request, locale, def);
                dataPolicy.setDef(dataDef);
                PolicyConstraint dataCons = PolicyConstraintFactory.create(locale, policy.getConstraint(), policy.getConstraint().getClass().getSimpleName());
                dataPolicy.setConstraint(dataCons);
                dataPolicySet.addPolicy(dataPolicy);
            }
        }
        ret.addProfilePolicySet(dataPolicySet);
        return ret;
    }

    public static CertReviewResponse create(CMSRequest cmsReq, Profile profile, boolean noncesEnabled, Locale locale) throws EPropertyException, EProfileException {
        String profileSetId;
        HttpServletRequest req = cmsReq.getHttpReq();
        Request ireq = cmsReq.getRequest();
        ArgBlock params = cmsReq.getHttpParams();
        CertReviewResponse ret = new CertReviewResponse();
        ret.setProfileId(profile.getId());
        ret.setRequestNotes(req.getParameter("requestNotes"));
        ret.setRequestId(ireq.getRequestId());
        if (noncesEnabled) {
            ret.setNonce(req.getParameter("nonce"));
        }
        Enumeration<String> policyIds = (profileSetId = ireq.getExtDataInString("profileSetId")) != null && profileSetId.length() > 0 ? profile.getProfilePolicyIds(profileSetId) : null;
        ProfilePolicySet dataPolicySet = new ProfilePolicySet();
        if (policyIds != null) {
            while (policyIds.hasMoreElements()) {
                String id = policyIds.nextElement();
                logger.debug("policyId:" + id);
                com.netscape.cms.profile.common.ProfilePolicy policy = profile.getProfilePolicy(profileSetId, id);
                ProfilePolicy dataPolicy = new ProfilePolicy();
                PolicyDefault def = policy.getDefault();
                com.netscape.certsrv.profile.PolicyDefault dataDef = PolicyDefaultFactory.create(params, locale, def);
                dataPolicy.setDef(dataDef);
                dataPolicySet.addPolicy(dataPolicy);
                logger.debug(dataPolicy.toString());
            }
        }
        ret.addProfilePolicySet(dataPolicySet);
        return ret;
    }
}

