/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.tps.config;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.cmscore.dbs.CSCfgDatabase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.dogtagpki.server.tps.config.ConfigDatabase;
import org.dogtagpki.server.tps.config.ConfigRecord;
import org.dogtagpki.server.tps.config.ProfileRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileDatabase
extends CSCfgDatabase<ProfileRecord> {
    public static Logger logger = LoggerFactory.getLogger(ProfileDatabase.class);

    public ProfileDatabase() {
        super("Profile", "Profiles");
    }

    public ProfileRecord createProfileRecord(ConfigDatabase configDatabase, ConfigRecord configRecord, String profileID) throws EBaseException {
        ProfileRecord profileRecord = new ProfileRecord();
        profileRecord.setID(profileID);
        String status = this.getRecordStatus(profileID);
        profileRecord.setStatus(status);
        Map<String, String> properties = configDatabase.getProperties(configRecord, profileID);
        profileRecord.setProperties(properties);
        return profileRecord;
    }

    public Collection<ProfileRecord> findRecords(String filter) throws Exception {
        ArrayList<ProfileRecord> result = new ArrayList<ProfileRecord>();
        ConfigDatabase configDatabase = new ConfigDatabase();
        ConfigRecord configRecord = configDatabase.getRecord(this.substoreName);
        for (String profileID : configRecord.getKeys()) {
            if (filter != null && !profileID.contains(filter)) continue;
            ProfileRecord profileRecord = this.createProfileRecord(configDatabase, configRecord, profileID);
            result.add(profileRecord);
        }
        return result;
    }

    public ProfileRecord getRecord(String profileID) throws Exception {
        ConfigDatabase configDatabase = new ConfigDatabase();
        ConfigRecord configRecord = configDatabase.getRecord(this.substoreName);
        return this.createProfileRecord(configDatabase, configRecord, profileID);
    }

    public void addRecord(String profileID, ProfileRecord profileRecord) throws Exception {
        logger.debug("ProfileDatabase.addRecord(\"" + profileID + "\")");
        ConfigDatabase configDatabase = new ConfigDatabase();
        ConfigRecord configRecord = configDatabase.getRecord(this.substoreName);
        Map properties = profileRecord.getProperties();
        configDatabase.validateProperties(configRecord, profileID, properties);
        configRecord.addKey(profileID);
        configDatabase.updateRecord(this.substoreName, configRecord);
        configDatabase.addProperties(configRecord, profileID, properties);
        this.setRecordStatus(profileID, profileRecord.getStatus());
        configDatabase.commit();
    }

    public void updateRecord(String profileID, ProfileRecord profileRecord) throws Exception {
        logger.debug("ProfileDatabase.updateRecord(\"" + profileID + "\")");
        ConfigDatabase configDatabase = new ConfigDatabase();
        ConfigRecord configRecord = configDatabase.getRecord(this.substoreName);
        Map properties = profileRecord.getProperties();
        configDatabase.validateProperties(configRecord, profileID, properties);
        configDatabase.removeProperties(configRecord, profileID);
        configDatabase.addProperties(configRecord, profileID, properties);
        this.setRecordStatus(profileID, profileRecord.getStatus());
        configDatabase.commit();
    }

    public void removeRecord(String profileID) throws Exception {
        logger.debug("ProfileDatabase.removeRecord(\"" + profileID + "\")");
        ConfigDatabase configDatabase = new ConfigDatabase();
        ConfigRecord configRecord = configDatabase.getRecord(this.substoreName);
        configDatabase.removeProperties(configRecord, profileID);
        configRecord.removeKey(profileID);
        configDatabase.updateRecord(this.substoreName, configRecord);
        this.removeRecordStatus(profileID);
        configDatabase.commit();
    }
}

