/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.acme.database;

import com.netscape.cmscore.apps.EngineConfig;
import com.netscape.cmscore.base.ConfigStorage;
import com.netscape.cmscore.base.FileConfigStorage;
import com.netscape.cmscore.ldapconn.LDAPConfig;
import com.netscape.cmscore.ldapconn.LdapBoundConnFactory;
import com.netscape.cmscore.ldapconn.PKISocketConfig;
import com.netscape.cmsutil.password.PasswordStore;
import com.netscape.cmsutil.password.PasswordStoreConfig;
import com.netscape.cmsutil.password.PlainPasswordFile;
import java.net.URI;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.stream.Collectors;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPSearchResults;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.dogtagpki.acme.ACMEAccount;
import org.dogtagpki.acme.ACMEAuthorization;
import org.dogtagpki.acme.ACMECertificate;
import org.dogtagpki.acme.ACMEChallenge;
import org.dogtagpki.acme.ACMEIdentifier;
import org.dogtagpki.acme.ACMENonce;
import org.dogtagpki.acme.ACMEOrder;
import org.dogtagpki.acme.JWK;
import org.dogtagpki.acme.database.ACMEDatabase;
import org.dogtagpki.acme.database.LDAPConfigMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LDAPDatabase
extends ACMEDatabase {
    public static Logger logger = LoggerFactory.getLogger(LDAPDatabase.class);
    static final String RDN_CONFIG = "ou=config";
    static final String RDN_NONCE = "ou=nonces";
    static final String RDN_ACCOUNT = "ou=accounts";
    static final String RDN_ORDER = "ou=orders";
    static final String RDN_AUTHORIZATION = "ou=authorizations";
    static final String RDN_CHALLENGE = "ou=challenges";
    static final String RDN_CERTIFICATE = "ou=certificates";
    static final String ATTR_OBJECTCLASS = "objectClass";
    static final String ATTR_ACCOUNT_CONTACT = "acmeAccountContact";
    static final String ATTR_ACCOUNT_ID = "acmeAccountId";
    static final String ATTR_ACCOUNT_KEY = "acmeAccountKey";
    static final String ATTR_AUTHORIZATION_ID = "acmeAuthorizationId";
    static final String ATTR_AUTHORIZATION_WILDCARD = "acmeAuthorizationWildcard";
    static final String ATTR_CERTIFICATE_ID = "acmeCertificateId";
    static final String ATTR_CHALLENGE_ID = "acmeChallengeId";
    static final String ATTR_CREATED = "acmeCreated";
    static final String ATTR_ERROR = "acmeError";
    static final String ATTR_EXPIRES = "acmeExpires";
    static final String ATTR_IDENTIFIER = "acmeIdentifier";
    static final String ATTR_NONCE_ID = "acmeNonceId";
    static final String ATTR_ORDER_ID = "acmeOrderId";
    static final String ATTR_STATUS = "acmeStatus";
    static final String ATTR_TOKEN = "acmeToken";
    static final String ATTR_USER_CERTIFICATE = "userCertificate;binary";
    static final String ATTR_VALIDATED_AT = "acmeValidatedAt";
    static final String ATTR_ENABLED = "acmeEnabled";
    static final String OBJ_ACCOUNT = "acmeAccount";
    static final String OBJ_AUTHORIZATION = "acmeAuthorization";
    static final String OBJ_CERTIFICATE = "acmeCertificate";
    static final String OBJ_CHALLENGE = "acmeChallenge";
    static final String OBJ_CHALLENGE_DNS01 = "acmeChallengeDns01";
    static final String OBJ_CHALLENGE_HTTP01 = "acmeChallengeHttp01";
    static final String OBJ_NONCE = "acmeNonce";
    static final String OBJ_ORDER = "acmeOrder";
    static final String IDENTIFIER_TYPE_DNS = "dns";
    static final FastDateFormat dateFormat = FastDateFormat.getInstance((String)"yyyyMMddHHmmssZ", (TimeZone)TimeZone.getTimeZone("UTC"));
    String baseDN;
    LdapBoundConnFactory connFactory = null;
    Boolean enabled;
    LDAPConfigMonitor monitor;

    @Override
    public void init() throws Exception {
        LDAPConfig ldapConfig;
        PlainPasswordFile ps;
        EngineConfig cs;
        String configFile = this.config.getParameter("configFile");
        if (configFile == null) {
            logger.info("Loading LDAP database configuration from database.conf");
            cs = new EngineConfig();
            ps = new PlainPasswordFile();
            ldapConfig = new LDAPConfig(null);
            for (String name : this.config.getParameterNames()) {
                String value = this.config.getParameter(name);
                if (name.equals("baseDN") || name.equals("basedn")) continue;
                if (name.equals("url")) {
                    String secureConn;
                    logger.info("- URL: " + value);
                    URI url = new URI(value);
                    String host = url.getHost();
                    String port = "" + url.getPort();
                    String protocol = url.getScheme();
                    if ("ldap".equals(protocol)) {
                        secureConn = "false";
                    } else if ("ldaps".equals(protocol)) {
                        secureConn = "true";
                    } else {
                        throw new Exception("Unsupported LDAP protocol: " + protocol);
                    }
                    ldapConfig.put("ldapconn.host", host);
                    ldapConfig.put("ldapconn.port", port);
                    ldapConfig.put("ldapconn.secureConn", secureConn);
                    continue;
                }
                if (name.equals("authType")) {
                    logger.info("- authentication type: " + value);
                    ldapConfig.put("ldapauth.authtype", value);
                    continue;
                }
                if (name.equals("bindDN")) {
                    logger.info("- bind DN: " + value);
                    ldapConfig.put("ldapauth.bindDN", value);
                    continue;
                }
                if (name.equals("bindPassword")) {
                    ldapConfig.put("ldapauth.bindPassword", value);
                    continue;
                }
                if (name.equals("nickname")) {
                    logger.info("- nickname: " + value);
                    ldapConfig.put("ldapauth.clientCertNickname", value);
                    continue;
                }
                if (name.equals("minConns")) {
                    logger.info("- " + name + ": " + value);
                    ldapConfig.put(name, value);
                    continue;
                }
                if (name.equals("maxConns")) {
                    logger.info("- " + name + ": " + value);
                    ldapConfig.put(name, value);
                    continue;
                }
                if (name.equals("maxResults")) {
                    logger.info("- " + name + ": " + value);
                    ldapConfig.put(name, value);
                    continue;
                }
                if (name.equals("errorIfDown")) {
                    logger.info("- " + name + ": " + value);
                    ldapConfig.put(name, value);
                    continue;
                }
                if (name.startsWith("ldapauth.")) {
                    ldapConfig.put(name, value);
                    logger.info("- " + name + ": " + value);
                    continue;
                }
                if (name.startsWith("ldapconn.")) {
                    logger.info("- " + name + ": " + value);
                    ldapConfig.put(name, value);
                    continue;
                }
                cs.put(name, value);
            }
        } else {
            logger.info("Loading LDAP database configuration from " + configFile);
            cs = new EngineConfig((ConfigStorage)new FileConfigStorage(configFile));
            cs.load();
            ps = PasswordStore.create((PasswordStoreConfig)cs.getPasswordStoreConfig());
            ldapConfig = cs.getInternalDBConfig();
        }
        this.baseDN = this.config.getParameter("basedn");
        if (this.baseDN == null) {
            this.baseDN = this.config.getParameter("baseDN");
        } else {
            logger.warn("The basedn parameter has been deprecated. Use baseDN instead.");
        }
        logger.info("- base DN: " + this.baseDN);
        PKISocketConfig socketConfig = cs.getSocketConfig();
        this.connFactory = new LdapBoundConnFactory("acme");
        this.connFactory.init(socketConfig, ldapConfig, (PasswordStore)ps);
        String monitorEnabled = this.config.getParameter("monitor.enabled");
        logger.info("- monitor enabled: " + monitorEnabled);
        if ("true".equals(monitorEnabled)) {
            this.monitor = new LDAPConfigMonitor();
            this.monitor.setDatabase(this);
            new Thread((Runnable)this.monitor, "LDAPConfigMonitor").start();
        }
    }

    @Override
    public Boolean getEnabled() throws Exception {
        if (this.monitor == null) {
            String dn = "ou=config," + this.baseDN;
            LDAPEntry entry = this.ldapGet(dn);
            if (entry == null) {
                this.enabled = null;
                return null;
            }
            LDAPAttribute acmeEnabled = entry.getAttribute(ATTR_ENABLED);
            if (acmeEnabled == null) {
                this.enabled = null;
                return this.enabled;
            }
            String value = acmeEnabled.getStringValueArray()[0];
            this.enabled = Boolean.parseBoolean(value);
        }
        return this.enabled;
    }

    @Override
    public void setEnabled(Boolean enabled) throws Exception {
        String dn = "ou=config," + this.baseDN;
        LDAPModificationSet mods = new LDAPModificationSet();
        if (enabled == null) {
            LDAPAttribute acmeEnabled = new LDAPAttribute(ATTR_ENABLED);
            mods.add(1, acmeEnabled);
        } else {
            LDAPAttribute acmeEnabled = new LDAPAttribute(ATTR_ENABLED, enabled != false ? "TRUE" : "FALSE");
            mods.add(2, acmeEnabled);
        }
        this.ldapModify(dn, mods);
        this.enabled = enabled;
    }

    public ACMENonce getNonce(String nonceID) throws Exception {
        String dn = "acmeNonceId=" + nonceID + ",ou=nonces," + this.baseDN;
        LDAPEntry entry = this.ldapGet(dn);
        if (entry == null) {
            return null;
        }
        ACMENonce nonce = new ACMENonce();
        nonce.setID(nonceID);
        LDAPAttribute attrCreated = entry.getAttribute(ATTR_CREATED);
        nonce.setCreationTime(dateFormat.parse((String)attrCreated.getStringValues().nextElement()));
        LDAPAttribute attrExpires = entry.getAttribute(ATTR_EXPIRES);
        nonce.setExpirationTime(dateFormat.parse((String)attrExpires.getStringValues().nextElement()));
        return nonce;
    }

    @Override
    public void addNonce(ACMENonce nonce) throws Exception {
        LDAPAttribute[] attrs = new LDAPAttribute[]{new LDAPAttribute(ATTR_OBJECTCLASS, OBJ_NONCE), new LDAPAttribute(ATTR_NONCE_ID, nonce.getID()), new LDAPAttribute(ATTR_CREATED, dateFormat.format(nonce.getCreationTime())), new LDAPAttribute(ATTR_EXPIRES, dateFormat.format(nonce.getExpirationTime()))};
        LDAPAttributeSet attrSet = new LDAPAttributeSet(attrs);
        String dn = "acmeNonceId=" + nonce.getID() + ",ou=nonces," + this.baseDN;
        LDAPEntry entry = new LDAPEntry(dn, attrSet);
        this.ldapAdd(entry);
    }

    @Override
    public ACMENonce removeNonce(String nonceID) throws Exception {
        ACMENonce nonce = this.getNonce(nonceID);
        if (nonce == null) {
            return null;
        }
        String dn = "acmeNonceId=" + nonceID + ",ou=nonces," + this.baseDN;
        this.ldapDelete(dn, OnNoSuchObject.Ignore);
        return nonce;
    }

    @Override
    public void removeExpiredNonces(Date currentTime) throws Exception {
        String[] attrs = new String[]{"1.1"};
        List<LDAPEntry> entries = this.ldapSearch("ou=nonces," + this.baseDN, "(acmeExpires<=" + dateFormat.format(currentTime) + ")", attrs);
        for (LDAPEntry entry : entries) {
            this.ldapDelete(entry.getDN(), OnNoSuchObject.Ignore);
        }
    }

    @Override
    public ACMEAccount getAccount(String accountID) throws Exception {
        String dn = "acmeAccountId=" + accountID + ",ou=accounts," + this.baseDN;
        LDAPEntry entry = this.ldapGet(dn);
        if (entry == null) {
            return null;
        }
        ACMEAccount account = new ACMEAccount();
        account.setID(accountID);
        LDAPAttribute attr = entry.getAttribute(ATTR_CREATED);
        account.setCreationTime(dateFormat.parse((String)attr.getStringValues().nextElement()));
        attr = entry.getAttribute(ATTR_STATUS);
        account.setStatus((String)attr.getStringValues().nextElement());
        attr = entry.getAttribute(ATTR_ACCOUNT_KEY);
        account.setJWK(JWK.fromJSON((String)((String)attr.getStringValues().nextElement())));
        attr = entry.getAttribute(ATTR_ACCOUNT_CONTACT);
        if (attr != null) {
            account.setContact(attr.getStringValueArray());
        }
        account.setTermsOfServiceAgreed(Boolean.valueOf(true));
        return account;
    }

    @Override
    public void addAccount(ACMEAccount account) throws Exception {
        LDAPAttribute[] attrs = new LDAPAttribute[]{new LDAPAttribute(ATTR_OBJECTCLASS, OBJ_ACCOUNT), new LDAPAttribute(ATTR_ACCOUNT_ID, account.getID()), new LDAPAttribute(ATTR_CREATED, dateFormat.format(account.getCreationTime())), new LDAPAttribute(ATTR_ACCOUNT_KEY, account.getJWK().toJSON()), new LDAPAttribute(ATTR_STATUS, account.getStatus())};
        LDAPAttributeSet attrSet = new LDAPAttributeSet(attrs);
        String[] contacts = account.getContact();
        if (contacts != null && contacts.length > 0) {
            attrSet.add(new LDAPAttribute(ATTR_ACCOUNT_CONTACT, contacts));
        }
        String dn = "acmeAccountId=" + account.getID() + ",ou=accounts," + this.baseDN;
        LDAPEntry entry = new LDAPEntry(dn, attrSet);
        this.ldapAdd(entry);
    }

    @Override
    public void updateAccount(ACMEAccount account) throws Exception {
        String dn = "acmeAccountId=" + account.getID() + ",ou=accounts," + this.baseDN;
        LDAPModificationSet mods = new LDAPModificationSet();
        mods.add(2, new LDAPAttribute(ATTR_STATUS, account.getStatus()));
        String[] contact = account.getContact();
        if (contact == null) {
            contact = new String[]{};
        }
        mods.add(2, new LDAPAttribute(ATTR_ACCOUNT_CONTACT, contact));
        this.ldapModify(dn, mods);
    }

    @Override
    public ACMEOrder getOrder(String orderID) throws Exception {
        String dn = "acmeOrderId=" + orderID + ",ou=orders," + this.baseDN;
        LDAPEntry entry = this.ldapGet(dn);
        if (entry == null) {
            return null;
        }
        return LDAPDatabase.loadOrder(entry);
    }

    @Override
    public Collection<ACMEOrder> getOrdersByAccount(String accountID) throws Exception {
        ArrayList<ACMEOrder> orders = new ArrayList<ACMEOrder>();
        List<LDAPEntry> entries = this.ldapSearch("ou=orders," + this.baseDN, "(&(objectClass=acmeOrder)(acmeAccountId=" + accountID + "))");
        for (LDAPEntry entry : entries) {
            orders.add(LDAPDatabase.loadOrder(entry));
        }
        return orders;
    }

    @Override
    public Collection<ACMEOrder> getOrdersByAuthorizationAndStatus(String authzID, String status) throws Exception {
        ArrayList<ACMEOrder> orders = new ArrayList<ACMEOrder>();
        List<LDAPEntry> entries = this.ldapSearch("ou=orders," + this.baseDN, "(&(objectClass=acmeOrder)(acmeAuthorizationId=" + authzID + ")(acmeStatus=" + status + "))");
        for (LDAPEntry entry : entries) {
            orders.add(LDAPDatabase.loadOrder(entry));
        }
        return orders;
    }

    @Override
    public ACMEOrder getOrderByCertificate(String certID) throws Exception {
        List<LDAPEntry> entries = this.ldapSearch("ou=orders," + this.baseDN, "(&(objectClass=acmeOrder)(acmeCertificateId=" + certID + "))");
        try {
            return LDAPDatabase.loadOrder(entries.get(0));
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    private static ACMEOrder loadOrder(LDAPEntry entry) throws Exception {
        ACMEOrder order = new ACMEOrder();
        LDAPAttribute attr = entry.getAttribute(ATTR_ORDER_ID);
        order.setID((String)attr.getStringValues().nextElement());
        attr = entry.getAttribute(ATTR_ACCOUNT_ID);
        order.setAccountID((String)attr.getStringValues().nextElement());
        attr = entry.getAttribute(ATTR_CREATED);
        order.setCreationTime(dateFormat.parse((String)attr.getStringValues().nextElement()));
        attr = entry.getAttribute(ATTR_STATUS);
        order.setStatus((String)attr.getStringValues().nextElement());
        attr = entry.getAttribute(ATTR_ERROR);
        if (attr != null) {
            order.setError((String)attr.getStringValues().nextElement());
        }
        if ((attr = entry.getAttribute(ATTR_EXPIRES)) != null) {
            order.setExpirationTime(dateFormat.parse((String)attr.getStringValues().nextElement()));
        }
        if ((attr = entry.getAttribute(ATTR_CERTIFICATE_ID)) != null) {
            order.setCertID((String)attr.getStringValues().nextElement());
        }
        ArrayList<ACMEIdentifier> identifiers = new ArrayList<ACMEIdentifier>();
        attr = entry.getAttribute(ATTR_IDENTIFIER);
        for (String identifier : attr.getStringValueArray()) {
            String[] parts = StringUtils.split((String)identifier, (String)":", (int)2);
            if (parts.length != 2) {
                throw new Exception("Invalid order identifier: " + identifier);
            }
            String type = parts[0];
            String value = parts[1];
            identifiers.add(new ACMEIdentifier(type, value));
        }
        order.setIdentifiers(identifiers.toArray(new ACMEIdentifier[0]));
        attr = entry.getAttribute(ATTR_AUTHORIZATION_ID);
        order.setAuthzIDs(attr.getStringValueArray());
        return order;
    }

    @Override
    public void addOrder(ACMEOrder order) throws Exception {
        ACMEIdentifier[] identifiers;
        LDAPAttribute[] attrs = new LDAPAttribute[]{new LDAPAttribute(ATTR_OBJECTCLASS, OBJ_ORDER), new LDAPAttribute(ATTR_ORDER_ID, order.getID()), new LDAPAttribute(ATTR_ACCOUNT_ID, order.getAccountID()), new LDAPAttribute(ATTR_CREATED, dateFormat.format(order.getCreationTime())), new LDAPAttribute(ATTR_STATUS, order.getStatus()), new LDAPAttribute(ATTR_AUTHORIZATION_ID, order.getAuthzIDs())};
        LDAPAttributeSet attrSet = new LDAPAttributeSet(attrs);
        Date expirationTime = order.getExpirationTime();
        if (expirationTime != null) {
            attrSet.add(new LDAPAttribute(ATTR_EXPIRES, dateFormat.format(expirationTime)));
        }
        for (ACMEIdentifier identifier : identifiers = order.getIdentifiers()) {
            attrSet.add(new LDAPAttribute(ATTR_IDENTIFIER, identifier.getType() + ":" + identifier.getValue()));
        }
        String error = order.getError();
        if (error != null) {
            attrSet.add(new LDAPAttribute(ATTR_ERROR, error));
        }
        String dn = "acmeOrderId=" + order.getID() + ",ou=orders," + this.baseDN;
        LDAPEntry entry = new LDAPEntry(dn, attrSet);
        this.ldapAdd(entry);
    }

    @Override
    public void updateOrder(ACMEOrder order) throws Exception {
        String dn = "acmeOrderId=" + order.getID() + ",ou=orders," + this.baseDN;
        LDAPModificationSet mods = new LDAPModificationSet();
        mods.add(2, new LDAPAttribute(ATTR_STATUS, order.getStatus()));
        mods.add(2, new LDAPAttribute(ATTR_CERTIFICATE_ID, order.getCertID()));
        String error = order.getError();
        LDAPAttribute attrError = error == null ? new LDAPAttribute(ATTR_ERROR) : new LDAPAttribute(ATTR_ERROR, error);
        mods.add(2, attrError);
        Date expirationTime = order.getExpirationTime();
        LDAPAttribute attrExpires = expirationTime == null ? new LDAPAttribute(ATTR_EXPIRES) : new LDAPAttribute(ATTR_EXPIRES, dateFormat.format(expirationTime));
        mods.add(2, attrExpires);
        this.ldapModify(dn, mods);
    }

    @Override
    public void removeExpiredOrders(Date currentTime) throws Exception {
        String[] attrs = new String[]{"1.1"};
        List<LDAPEntry> entries = this.ldapSearch("ou=orders," + this.baseDN, "(acmeExpires<=" + dateFormat.format(currentTime) + ")", attrs);
        for (LDAPEntry entry : entries) {
            this.ldapDelete(entry.getDN(), OnNoSuchObject.Ignore);
        }
    }

    @Override
    public ACMEAuthorization getAuthorization(String authzID) throws Exception {
        return this.getAuthorization(authzID, LoadChallenges.DoLoad);
    }

    private ACMEAuthorization getAuthorization(String authzID, LoadChallenges clc) throws Exception {
        String dn = "acmeAuthorizationId=" + authzID + ",ou=authorizations," + this.baseDN;
        LDAPEntry entry = this.ldapGet(dn);
        if (entry == null) {
            return null;
        }
        ACMEAuthorization authz = new ACMEAuthorization();
        authz.setID(authzID);
        LDAPAttribute attr = entry.getAttribute(ATTR_ACCOUNT_ID);
        authz.setAccountID((String)attr.getStringValues().nextElement());
        attr = entry.getAttribute(ATTR_CREATED);
        authz.setCreationTime(dateFormat.parse((String)attr.getStringValues().nextElement()));
        attr = entry.getAttribute(ATTR_EXPIRES);
        if (attr != null) {
            authz.setExpirationTime(dateFormat.parse((String)attr.getStringValues().nextElement()));
        }
        attr = entry.getAttribute(ATTR_STATUS);
        authz.setStatus((String)attr.getStringValues().nextElement());
        attr = entry.getAttribute(ATTR_IDENTIFIER);
        String identifier = (String)attr.getStringValues().nextElement();
        String[] parts = StringUtils.split((String)identifier, (String)":", (int)2);
        if (parts.length != 2) {
            throw new Exception("Invalid authorization identifier: " + identifier);
        }
        String type = parts[0];
        String value = parts[1];
        authz.setIdentifier(new ACMEIdentifier(type, value));
        attr = entry.getAttribute(ATTR_AUTHORIZATION_WILDCARD);
        if (attr != null && "TRUE".equalsIgnoreCase((String)attr.getStringValues().nextElement())) {
            authz.setWildcard(Boolean.valueOf(true));
        }
        if (clc == LoadChallenges.DoLoad) {
            ArrayList<ACMEChallenge> challenges = new ArrayList<ACMEChallenge>();
            List<LDAPEntry> entries = this.ldapSearch("ou=challenges," + this.baseDN, "(&(objectClass=acmeChallenge)(acmeAuthorizationId=" + authzID + "))");
            for (LDAPEntry challengeEntry : entries) {
                challenges.add(this.loadChallenge(challengeEntry));
            }
            authz.setChallenges(challenges);
        }
        return authz;
    }

    private ACMEChallenge getChallenge(String challengeID) throws Exception {
        String dn = "acmeChallengeId=" + challengeID + ",ou=challenges," + this.baseDN;
        LDAPEntry entry = this.ldapGet(dn);
        if (entry == null) {
            return null;
        }
        return this.loadChallenge(entry);
    }

    private ACMEChallenge loadChallenge(LDAPEntry entry) throws ParseException {
        ACMEChallenge challenge = new ACMEChallenge();
        LDAPAttribute attr = entry.getAttribute(ATTR_CHALLENGE_ID);
        challenge.setID((String)attr.getStringValues().nextElement());
        attr = entry.getAttribute(ATTR_OBJECTCLASS);
        ArrayList classes = Collections.list(attr.getStringValues());
        if (classes.contains(OBJ_CHALLENGE_DNS01)) {
            challenge.setType("dns-01");
        } else if (classes.contains(OBJ_CHALLENGE_HTTP01)) {
            challenge.setType("http-01");
        } else {
            throw new RuntimeException("unable to determine challenge type from objectclass " + classes.stream().collect(Collectors.joining(", ", "{", "}")));
        }
        attr = entry.getAttribute(ATTR_AUTHORIZATION_ID);
        challenge.setAuthzID((String)attr.getStringValues().nextElement());
        attr = entry.getAttribute(ATTR_TOKEN);
        challenge.setToken((String)attr.getStringValues().nextElement());
        attr = entry.getAttribute(ATTR_STATUS);
        challenge.setStatus((String)attr.getStringValues().nextElement());
        attr = entry.getAttribute(ATTR_ERROR);
        if (attr != null) {
            challenge.setError((String)attr.getStringValues().nextElement());
        }
        if ((attr = entry.getAttribute(ATTR_VALIDATED_AT)) != null) {
            challenge.setValidationTime(dateFormat.parse((String)attr.getStringValues().nextElement()));
        }
        return challenge;
    }

    @Override
    public ACMEAuthorization getAuthorizationByChallenge(String challengeID) throws Exception {
        ACMEChallenge challenge = this.getChallenge(challengeID);
        if (challenge == null) {
            return null;
        }
        return this.getAuthorization(challenge.getAuthzID());
    }

    @Override
    public void addAuthorization(ACMEAuthorization authorization) throws Exception {
        Boolean wildcard;
        ACMEIdentifier identifier = authorization.getIdentifier();
        LDAPAttribute[] attrs = new LDAPAttribute[]{new LDAPAttribute(ATTR_OBJECTCLASS, OBJ_AUTHORIZATION), new LDAPAttribute(ATTR_AUTHORIZATION_ID, authorization.getID()), new LDAPAttribute(ATTR_ACCOUNT_ID, authorization.getAccountID()), new LDAPAttribute(ATTR_CREATED, dateFormat.format(authorization.getCreationTime())), new LDAPAttribute(ATTR_STATUS, authorization.getStatus()), new LDAPAttribute(ATTR_IDENTIFIER, identifier.getType() + ":" + identifier.getValue())};
        LDAPAttributeSet attrSet = new LDAPAttributeSet(attrs);
        Date expirationTime = authorization.getExpirationTime();
        if (expirationTime != null) {
            attrSet.add(new LDAPAttribute(ATTR_EXPIRES, dateFormat.format(expirationTime)));
        }
        String wildcardValue = (wildcard = authorization.getWildcard()) != null && wildcard == true ? "TRUE" : "FALSE";
        attrSet.add(new LDAPAttribute(ATTR_AUTHORIZATION_WILDCARD, wildcardValue));
        String dn = "acmeAuthorizationId=" + authorization.getID() + ",ou=authorizations," + this.baseDN;
        LDAPEntry entry = new LDAPEntry(dn, attrSet);
        this.ldapAdd(entry);
    }

    public void addChallenge(String accountID, ACMEChallenge challenge) throws Exception {
        String type = challenge.getType();
        String objclass = null;
        if (type.equals("dns-01")) {
            objclass = OBJ_CHALLENGE_DNS01;
        } else if (type.equals("http-01")) {
            objclass = OBJ_CHALLENGE_HTTP01;
        } else {
            throw new RuntimeException("unrecognised challenge type: " + type);
        }
        String[] classes = new String[]{OBJ_CHALLENGE, objclass};
        LDAPAttribute[] attrs = new LDAPAttribute[]{new LDAPAttribute(ATTR_OBJECTCLASS, classes), new LDAPAttribute(ATTR_CHALLENGE_ID, challenge.getID()), new LDAPAttribute(ATTR_AUTHORIZATION_ID, challenge.getAuthzID()), new LDAPAttribute(ATTR_ACCOUNT_ID, accountID), new LDAPAttribute(ATTR_STATUS, challenge.getStatus()), new LDAPAttribute(ATTR_TOKEN, challenge.getToken())};
        LDAPAttributeSet attrSet = new LDAPAttributeSet(attrs);
        String dn = "acmeChallengeId=" + challenge.getID() + ",ou=challenges," + this.baseDN;
        LDAPEntry entry = new LDAPEntry(dn, attrSet);
        this.ldapAdd(entry);
    }

    @Override
    public void updateAuthorization(ACMEAuthorization authorization) throws Exception {
        String dn = "acmeAuthorizationId=" + authorization.getID() + ",ou=authorizations," + this.baseDN;
        LDAPModificationSet mods = new LDAPModificationSet();
        mods.add(2, new LDAPAttribute(ATTR_STATUS, authorization.getStatus()));
        Date expirationTime = authorization.getExpirationTime();
        LDAPAttribute attrExpires = expirationTime == null ? new LDAPAttribute(ATTR_EXPIRES) : new LDAPAttribute(ATTR_EXPIRES, dateFormat.format(expirationTime));
        mods.add(2, attrExpires);
        this.ldapModify(dn, mods);
        ACMEAuthorization authzORIG = this.getAuthorization(authorization.getID(), LoadChallenges.DoLoad);
        for (ACMEChallenge challenge : authzORIG.getChallenges()) {
            dn = "acmeChallengeId=" + challenge.getID() + ",ou=challenges," + this.baseDN;
            this.ldapDelete(dn, OnNoSuchObject.Ignore);
        }
        for (ACMEChallenge challenge : authorization.getChallenges()) {
            dn = "acmeChallengeId=" + challenge.getID() + ",ou=challenges," + this.baseDN;
            this.addChallenge(authorization.getAccountID(), challenge);
        }
    }

    @Override
    public boolean hasRevocationAuthorization(String accountID, Date time, ACMEIdentifier identifier) throws Exception {
        boolean wildcard = false;
        String ident = identifier.getValue();
        if (IDENTIFIER_TYPE_DNS.equals(identifier.getType()) && ident.startsWith("*.")) {
            wildcard = true;
            ident = ident.substring(2);
        }
        List<LDAPEntry> entries = this.ldapSearch("ou=authorizations," + this.baseDN, "(&(objectClass=acmeAuthorization)(acmeAccountId=" + accountID + ")(!(acmeExpires<=" + dateFormat.format(time) + "))(acmeStatus=valid)(acmeIdentifier=" + identifier.getType() + ":" + ident + ")(acmeAuthorizationWildcard=" + (wildcard ? "TRUE" : "FALSE") + "))");
        return !entries.isEmpty();
    }

    @Override
    public void removeExpiredAuthorizations(Date currentTime) throws Exception {
        String[] attrs = new String[]{"1.1"};
        List<LDAPEntry> entries = this.ldapSearch("ou=authorizations," + this.baseDN, "(acmeExpires<=" + dateFormat.format(currentTime) + ")", attrs);
        for (LDAPEntry entry : entries) {
            this.ldapDelete(entry.getDN(), OnNoSuchObject.Ignore);
        }
    }

    @Override
    public ACMECertificate getCertificate(String certID) throws Exception {
        String dn = "acmeCertificateId=" + certID + ",ou=certificates," + this.baseDN;
        LDAPEntry entry = this.ldapGet(dn);
        if (entry == null) {
            return null;
        }
        ACMECertificate certificate = new ACMECertificate();
        certificate.setID(certID);
        LDAPAttribute attr = entry.getAttribute(ATTR_CREATED);
        certificate.setCreationTime(dateFormat.parse((String)attr.getStringValues().nextElement()));
        attr = entry.getAttribute(ATTR_USER_CERTIFICATE);
        certificate.setData(attr.getByteValueArray()[0]);
        attr = entry.getAttribute(ATTR_EXPIRES);
        if (attr != null) {
            certificate.setExpirationTime(dateFormat.parse((String)attr.getStringValues().nextElement()));
        }
        return certificate;
    }

    @Override
    public void addCertificate(String certID, ACMECertificate certificate) throws Exception {
        String dn = "acmeCertificateId=" + certID + ",ou=certificates," + this.baseDN;
        LDAPAttribute[] attrs = new LDAPAttribute[]{new LDAPAttribute(ATTR_OBJECTCLASS, OBJ_CERTIFICATE), new LDAPAttribute(ATTR_CERTIFICATE_ID, certID), new LDAPAttribute(ATTR_CREATED, dateFormat.format(certificate.getCreationTime())), new LDAPAttribute(ATTR_USER_CERTIFICATE, certificate.getData())};
        LDAPAttributeSet attrSet = new LDAPAttributeSet(attrs);
        Date expirationTime = certificate.getExpirationTime();
        if (expirationTime != null) {
            attrSet.add(new LDAPAttribute(ATTR_EXPIRES, dateFormat.format(expirationTime)));
        }
        LDAPEntry entry = new LDAPEntry(dn, attrSet);
        this.ldapAdd(entry);
    }

    @Override
    public void removeExpiredCertificates(Date currentTime) throws Exception {
        String[] attrs = new String[]{"1.1"};
        List<LDAPEntry> entries = this.ldapSearch("ou=certificates," + this.baseDN, "(acmeExpires<=" + dateFormat.format(currentTime) + ")", attrs);
        for (LDAPEntry entry : entries) {
            this.ldapDelete(entry.getDN(), OnNoSuchObject.Ignore);
        }
    }

    void ldapAdd(LDAPEntry entry) throws Exception {
        logger.info("LDAP: add " + entry.getDN());
        LDAPConnection conn = this.connFactory.getConn();
        try {
            conn.add(entry);
        }
        catch (LDAPException e) {
            throw new Exception("LDAP add failed: " + e, e);
        }
        finally {
            this.connFactory.returnConn(conn);
        }
    }

    void ldapModify(String dn, LDAPModificationSet mods) throws Exception {
        logger.info("LDAP: modify " + dn);
        LDAPConnection conn = this.connFactory.getConn();
        try {
            conn.modify(dn, mods);
        }
        catch (LDAPException e) {
            throw new Exception("LDAP modify failed: " + e, e);
        }
        finally {
            this.connFactory.returnConn(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ldapDelete(String dn, OnNoSuchObject action) throws Exception {
        logger.info("LDAP: delete " + dn);
        LDAPConnection conn = this.connFactory.getConn();
        try {
            conn.delete(dn);
        }
        catch (LDAPException e) {
            if (e.getLDAPResultCode() != 32 || action == OnNoSuchObject.Throw) {
                throw e;
            }
        }
        finally {
            this.connFactory.returnConn(conn);
        }
    }

    LDAPEntry ldapGet(String dn) throws Exception {
        logger.info("LDAP: search " + dn);
        LDAPConnection conn = this.connFactory.getConn();
        try {
            LDAPEntry lDAPEntry = conn.search(dn, 0, null, null, false).next();
            return lDAPEntry;
        }
        catch (LDAPException e) {
            if (e.getLDAPResultCode() == 32) {
                LDAPEntry lDAPEntry = null;
                return lDAPEntry;
            }
            throw new Exception("LDAP search failed: " + e, e);
        }
        finally {
            this.connFactory.returnConn(conn);
        }
    }

    List<LDAPEntry> ldapSearch(String searchBase, String filter) throws Exception {
        return this.ldapSearch(searchBase, filter, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<LDAPEntry> ldapSearch(String searchBase, String filter, String[] attrs) throws Exception {
        logger.info("LDAP: search " + searchBase);
        ArrayList<LDAPEntry> l = new ArrayList<LDAPEntry>();
        LDAPConnection conn = this.connFactory.getConn();
        try {
            LDAPSearchResults results = conn.search(searchBase, 2, filter, attrs, false);
            if (results != null) {
                while (results.hasMoreElements()) {
                    l.add(results.next());
                }
            }
        }
        finally {
            this.connFactory.returnConn(conn);
        }
        return l;
    }

    @Override
    public void close() throws Exception {
        if (this.monitor != null) {
            this.monitor.stop();
        }
    }

    static enum OnNoSuchObject {
        Ignore,
        Throw;

    }

    static enum LoadChallenges {
        DoLoad,
        DontLoad;

    }
}

