/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.apps;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.SecurityDomainSessionTable;
import com.netscape.certsrv.base.Subsystem;
import com.netscape.certsrv.request.RequestListener;
import com.netscape.certsrv.request.RequestStatus;
import com.netscape.cms.notification.MailNotification;
import com.netscape.cms.password.PasswordChecker;
import com.netscape.cms.servlet.common.CMSGateway;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.CommandQueue;
import com.netscape.cmscore.apps.DatabaseConfig;
import com.netscape.cmscore.apps.EngineConfig;
import com.netscape.cmscore.apps.ServerConfig;
import com.netscape.cmscore.apps.SubsystemConfig;
import com.netscape.cmscore.apps.SubsystemInfo;
import com.netscape.cmscore.apps.SubsystemListener;
import com.netscape.cmscore.apps.SubsystemsConfig;
import com.netscape.cmscore.authentication.AuthSubsystem;
import com.netscape.cmscore.authentication.VerifiedCerts;
import com.netscape.cmscore.authorization.AuthzSubsystem;
import com.netscape.cmscore.base.ConfigStorage;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.base.FileConfigStorage;
import com.netscape.cmscore.cert.OidLoaderSubsystem;
import com.netscape.cmscore.cert.X500NameSubsystem;
import com.netscape.cmscore.dbs.DBSubsystem;
import com.netscape.cmscore.jobs.JobsScheduler;
import com.netscape.cmscore.jobs.JobsSchedulerConfig;
import com.netscape.cmscore.ldapconn.LDAPAuthenticationConfig;
import com.netscape.cmscore.ldapconn.LDAPConfig;
import com.netscape.cmscore.ldapconn.LDAPConnectionConfig;
import com.netscape.cmscore.ldapconn.LdapConnInfo;
import com.netscape.cmscore.ldapconn.PKISocketConfig;
import com.netscape.cmscore.ldapconn.PKISocketFactory;
import com.netscape.cmscore.logging.Auditor;
import com.netscape.cmscore.logging.LogSubsystem;
import com.netscape.cmscore.logging.LoggerConfig;
import com.netscape.cmscore.logging.LoggersConfig;
import com.netscape.cmscore.logging.LoggingConfig;
import com.netscape.cmscore.registry.PluginRegistry;
import com.netscape.cmscore.request.RecoverThread;
import com.netscape.cmscore.request.Request;
import com.netscape.cmscore.request.RequestNotifier;
import com.netscape.cmscore.request.RequestQueue;
import com.netscape.cmscore.request.RequestRepository;
import com.netscape.cmscore.request.RequestSubsystem;
import com.netscape.cmscore.security.JssSubsystem;
import com.netscape.cmscore.security.JssSubsystemConfig;
import com.netscape.cmscore.security.PWsdrCache;
import com.netscape.cmscore.selftests.SelfTestSubsystem;
import com.netscape.cmscore.session.LDAPSecurityDomainSessionTable;
import com.netscape.cmscore.session.MemorySecurityDomainSessionTable;
import com.netscape.cmscore.session.SessionTimer;
import com.netscape.cmscore.usrgrp.Group;
import com.netscape.cmscore.usrgrp.UGSubsystem;
import com.netscape.cmscore.usrgrp.UGSubsystemConfig;
import com.netscape.cmscore.util.Debug;
import com.netscape.cmsutil.crypto.CryptoUtil;
import com.netscape.cmsutil.password.PasswordStore;
import com.netscape.cmsutil.password.PasswordStoreConfig;
import com.netscape.cmsutil.util.NuxwdogUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.security.Provider;
import java.security.Security;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import javax.servlet.http.HttpServlet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSocketFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.tomcat.util.net.jss.TomcatJSS;
import org.dogtag.util.cert.CertUtil;
import org.dogtagpki.server.PKIClientSocketListener;
import org.dogtagpki.server.PKIServerSocketListener;
import org.dogtagpki.server.authentication.AuthenticationConfig;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.PrivateKey;
import org.mozilla.jss.crypto.Signature;
import org.mozilla.jss.crypto.SignatureAlgorithm;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.netscape.security.util.Cert;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.pkcs11.PK11PrivKey;
import org.mozilla.jss.ssl.SSLSocketListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMSEngine {
    public static Logger logger = LoggerFactory.getLogger(CMSEngine.class);
    private static final String SERVER_XML = "server.xml";
    public String id;
    public String name;
    public String instanceDir;
    private String instanceId;
    private int pid;
    protected EngineConfig config;
    protected EngineConfig mConfig;
    protected ServerConfig serverConfig;
    private String mAutoSD_CrumbFile = null;
    private boolean mAutoSD_Restart = false;
    private int mAutoSD_RestartMax = 3;
    private int mAutoSD_RestartCount = 0;
    private PrivateKey mSigningKey = null;
    private byte[] mSigningData = null;
    private long mStartupTime = 0L;
    private boolean isStarted = false;
    private PasswordStore mPasswordStore = null;
    private SecurityDomainSessionTable mSecurityDomainSessionTable = null;
    private Timer mSDTimer = null;
    private String mServerCertNickname = null;
    private boolean ready;
    private Debug debug = new Debug();
    private PluginRegistry pluginRegistry = new PluginRegistry();
    protected Auditor auditor;
    protected LogSubsystem logSubsystem;
    protected PKIClientSocketListener clientSocketListener;
    protected PKIServerSocketListener serverSocketListener;
    protected JssSubsystem jssSubsystem;
    protected DBSubsystem dbSubsystem;
    protected RequestRepository requestRepository;
    protected RequestQueue requestQueue;
    protected UGSubsystem ugSubsystem;
    protected OidLoaderSubsystem oidLoaderSubsystem;
    protected X500NameSubsystem x500NameSubsystem;
    protected RequestSubsystem requestSubsystem = new RequestSubsystem();
    protected AuthSubsystem authSubsystem;
    protected AuthzSubsystem authzSubsystem;
    protected CMSGateway gateway;
    protected JobsScheduler jobsScheduler;
    public final Map<String, SubsystemInfo> subsystemInfos = new LinkedHashMap<String, SubsystemInfo>();
    public final Map<String, Subsystem> subsystems = new LinkedHashMap<String, Subsystem>();
    public String unsecurePort;
    public String securePort;
    protected RequestNotifier requestNotifier;
    protected RequestNotifier pendingNotifier;
    private Map<String, SubsystemListener> subsystemListeners = new LinkedHashMap<String, SubsystemListener>();
    private static final int PW_OK = 0;
    private static final int PW_INVALID_CREDENTIALS = 2;
    private static final int PW_CANNOT_CONNECT = 3;
    private static final int PW_MAX_ATTEMPTS = 3;
    public VerifiedCerts mVCList = null;
    private int mVCListSize = 0;

    public CMSEngine(String name) {
        this.id = name.toLowerCase();
        this.name = name;
        logger.info("Creating " + name + " engine");
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public PluginRegistry getPluginRegistry() {
        return this.pluginRegistry;
    }

    public LogSubsystem getLogSubsystem() {
        return this.logSubsystem;
    }

    public Auditor getAuditor() {
        return this.auditor;
    }

    public PKIClientSocketListener getClientSocketListener() {
        return this.clientSocketListener;
    }

    public PKIServerSocketListener getServerSocketListener() {
        return this.serverSocketListener;
    }

    public JssSubsystem getJSSSubsystem() {
        return this.jssSubsystem;
    }

    public DBSubsystem getDBSubsystem() {
        return this.dbSubsystem;
    }

    public RequestRepository getRequestRepository() {
        return this.requestRepository;
    }

    public void setRequestRepository(RequestRepository requestRepository) {
        this.requestRepository = requestRepository;
    }

    public RequestQueue getRequestQueue() {
        return this.requestQueue;
    }

    public void setRequestQueue(RequestQueue requestQueue) {
        this.requestQueue = requestQueue;
    }

    public UGSubsystem getUGSubsystem() {
        return this.ugSubsystem;
    }

    public OidLoaderSubsystem getOIDLoaderSubsystem() {
        return this.oidLoaderSubsystem;
    }

    public X500NameSubsystem getX500NameSubsystem() {
        return this.x500NameSubsystem;
    }

    public RequestSubsystem getRequestSubsystem() {
        return this.requestSubsystem;
    }

    public AuthSubsystem getAuthSubsystem() {
        return this.authSubsystem;
    }

    public AuthzSubsystem getAuthzSubsystem() {
        return this.authzSubsystem;
    }

    public CMSGateway getCMSGateway() {
        return this.gateway;
    }

    public JobsScheduler getJobsScheduler() {
        return this.jobsScheduler;
    }

    public RequestNotifier getRequestNotifier() {
        return this.requestNotifier;
    }

    public void setRequestNotifier(RequestNotifier requestNotifier) {
        this.requestNotifier = requestNotifier;
    }

    public Enumeration<String> getRequestListenerNames() {
        return this.requestNotifier.getListenerNames();
    }

    public RequestListener getRequestListener(String name) {
        return this.requestNotifier.getListener(name);
    }

    public void registerRequestListener(RequestListener listener) {
        this.requestNotifier.registerListener(listener);
    }

    public void registerRequestListener(String name, RequestListener listener) {
        this.requestNotifier.registerListener(name, listener);
    }

    public void removeRequestListener(RequestListener listener) {
        this.requestNotifier.removeListener(listener);
    }

    public void removeRequestListener(String name) {
        this.requestNotifier.removeListener(name);
    }

    public RequestNotifier getPendingNotifier() {
        return this.pendingNotifier;
    }

    public void setPendingNotifier(RequestNotifier pendingNotifier) {
        this.pendingNotifier = pendingNotifier;
    }

    public RequestListener getPendingListener(String name) {
        return this.pendingNotifier.getListener(name);
    }

    public void registerPendingListener(RequestListener listener) {
        this.pendingNotifier.registerListener(listener);
    }

    public void registerPendingListener(String name, RequestListener listener) {
        this.pendingNotifier.registerListener(name, listener);
    }

    public void loadConfig(String path) throws Exception {
        FileConfigStorage storage = new FileConfigStorage(path);
        this.config = this.createConfig(storage);
        this.config.load();
        this.instanceId = this.config.getInstanceID();
        this.mConfig = this.config;
    }

    public EngineConfig createConfig(ConfigStorage storage) throws Exception {
        return new EngineConfig(storage);
    }

    public synchronized PasswordStore getPasswordStore() throws EBaseException {
        if (this.mPasswordStore == null) {
            try {
                PasswordStoreConfig psc = this.mConfig.getPasswordStoreConfig();
                this.mPasswordStore = PasswordStore.create((PasswordStoreConfig)psc);
            }
            catch (Exception e) {
                throw new EBaseException("Failed to initialise password store: " + e.getMessage(), (Throwable)e);
            }
        }
        return this.mPasswordStore;
    }

    public void initDebug() throws Exception {
        ConfigStore debugConfig = this.config.getSubStore("debug", ConfigStore.class);
        this.debug.init(debugConfig);
    }

    public void initSubsystemListeners() throws Exception {
        String ids;
        logger.info("CMSEngine: Initializing subsystem listeners");
        ConfigStore listenersConfig = this.config.getSubStore("listeners", ConfigStore.class);
        if (listenersConfig.size() == 0 && (listenersConfig = this.config.getSubStore("startupNotifiers", ConfigStore.class)).size() > 0) {
            String subsystem = this.config.getType().toLowerCase();
            String configPath = this.instanceDir + "/conf/" + subsystem + "/CS.cfg";
            logger.warn("The 'startupNotifiers' property in " + configPath + " has been deprecated. Use 'listeners' instead.");
        }
        if ((ids = listenersConfig.getString("list", null)) == null) {
            return;
        }
        for (String id : ids.split(",")) {
            if ((id = id.trim()).isEmpty()) continue;
            ConfigStore instanceConfig = listenersConfig.getSubStore(id, ConfigStore.class);
            String className = instanceConfig.getString("class");
            logger.info("CMSEngine: Initializing subsystem listener " + id + ": " + className);
            Class<SubsystemListener> clazz = Class.forName(className).asSubclass(SubsystemListener.class);
            SubsystemListener listener = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            listener.init(instanceConfig);
            this.subsystemListeners.put(id, listener);
        }
    }

    public void initPasswordStore() throws Exception {
        int state = this.config.getState();
        if (state == 0) {
            return;
        }
        logger.info("CMSEngine: initializing password store");
        this.getPasswordStore();
    }

    public void testLDAPConnections() throws Exception {
        int state = this.config.getState();
        if (state == 0) {
            return;
        }
        boolean skipLdapConnectionTest = this.config.getBoolean("cms.password.skipLdapConnTest", false);
        logger.debug("CMSEngine: skip LDAP connection test: " + skipLdapConnectionTest);
        if (skipLdapConnectionTest) {
            logger.debug("CMSEngine: Skipping LDAP connection test");
            return;
        }
        logger.info("CMSEngine: Checking LDAP connections");
        boolean skipPublishingCheck = this.config.getBoolean("cms.password.ignore.publishing.failure", true);
        String pwList = this.config.getString("cms.passwordlist", "internaldb,replicationdb");
        String[] tags = StringUtils.split((String)pwList, (String)",");
        LDAPConfig ldapConfig = this.config.getInternalDBConfig();
        LDAPConnectionConfig connConfig = ldapConfig.getConnectionConfig();
        LDAPAuthenticationConfig authConfig = ldapConfig.getAuthenticationConfig();
        for (String tag : tags) {
            String passwd;
            Object binddn;
            logger.info("CMSEngine: Checking LDAP connections for " + tag);
            LdapConnInfo connInfo = null;
            if (tag.equals("internaldb")) {
                authType = authConfig.getString("authtype", "BasicAuth");
                logger.debug("CMSEngine: auth type: " + authType);
                if (!authType.equals("BasicAuth")) continue;
                connInfo = new LdapConnInfo(connConfig.getString("host"), connConfig.getInteger("port"), connConfig.getBoolean("secureConn"));
                binddn = authConfig.getString("bindDN");
            } else if (tag.equals("replicationdb")) {
                authType = authConfig.getString("authtype", "BasicAuth");
                logger.debug("CMSEngine: auth type: " + authType);
                if (!authType.equals("BasicAuth")) continue;
                connInfo = new LdapConnInfo(connConfig.getString("host"), connConfig.getInteger("port"), connConfig.getBoolean("secureConn"));
                binddn = "cn=Replication Manager masterAgreement1-" + this.config.getHostname() + "-" + this.config.getInstanceID() + ",cn=config";
            } else if (tags.equals("CA LDAP Publishing")) {
                LDAPConfig publishConfig = this.config.getSubStore("ca.publish.ldappublish.ldap", LDAPConfig.class);
                LDAPAuthenticationConfig publishAuthConfig = publishConfig.getAuthenticationConfig();
                authType = publishAuthConfig.getString("authtype", "BasicAuth");
                logger.debug("CMSEngine: auth type: " + authType);
                if (!authType.equals("BasicAuth")) continue;
                LDAPConnectionConfig publishConnConfig = publishConfig.getConnectionConfig();
                connInfo = new LdapConnInfo(publishConnConfig.getString("host"), publishConnConfig.getInteger("port"), publishConnConfig.getBoolean("secureConn"));
                binddn = publishAuthConfig.getString("bindDN");
            } else {
                String authPrefix = this.config.getString(tag + ".authPrefix", null);
                logger.debug("CMSEngine: auth prefix: " + authPrefix);
                if (authPrefix == null) continue;
                LDAPConfig prefixConfig = this.config.getSubStore(authPrefix + ".ldap", LDAPConfig.class);
                LDAPAuthenticationConfig prefixAuthConfig = prefixConfig.getAuthenticationConfig();
                authType = prefixAuthConfig.getString("authtype", "BasicAuth");
                logger.debug("CMSEngine: auth type: " + authType);
                if (!authType.equals("BasicAuth")) continue;
                LDAPConnectionConfig prefixConnConfig = prefixConfig.getConnectionConfig();
                connInfo = new LdapConnInfo(prefixConnConfig.getString("host"), prefixConnConfig.getInteger("port"), prefixConnConfig.getBoolean("secureConn"));
                binddn = prefixAuthConfig.getString("bindDN", null);
                if (binddn == null) {
                    logger.debug("CMSEngine.initializePasswordStore(): binddn not found...skipping");
                    continue;
                }
            }
            int iteration = 0;
            int result = 2;
            while ((result = this.testLDAPConnection(tag, connInfo, (String)binddn, passwd = this.mPasswordStore.getPassword(tag, iteration))) == 2 && ++iteration < 3) {
            }
            if (result == 0) continue;
            if (result == 2 && tag.equals("replicationdb")) {
                logger.warn("CMSEngine: LDAP connection test failed for replicationdb with NO_SUCH_USER. This may not be a latest instance. Ignoring ..");
                continue;
            }
            if (skipPublishingCheck && result == 3 && tag.equals("CA LDAP Publishing")) {
                logger.warn("CMSEngine: Unable to connect to the publishing database to check password, but continuing to start up. Please check if publishing is operational.");
                continue;
            }
            logger.error("CMSEngine: LDAP connection test failed: " + result);
            throw new EBaseException("LDAP connection test failed. Is the database up?");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int testLDAPConnection(String name, LdapConnInfo info, String binddn, String pwd) {
        int ret = 0;
        if (StringUtils.isEmpty((CharSequence)pwd)) {
            return 2;
        }
        String host = info.getHost();
        int port = info.getPort();
        PKISocketConfig socketConfig = this.mConfig.getSocketConfig();
        PKISocketFactory socketFactory = new PKISocketFactory();
        socketFactory.setAuditor(this.auditor);
        socketFactory.addSocketListener(this.clientSocketListener);
        socketFactory.setSecure(info.getSecure());
        socketFactory.init(socketConfig);
        LDAPConnection conn = new LDAPConnection((LDAPSocketFactory)socketFactory);
        try {
            logger.info("CMSEngine: verifying connection to " + host + ":" + port + " as " + binddn);
            conn.connect(host, port, binddn, pwd);
            return ret;
        }
        catch (LDAPException e) {
            switch (e.getLDAPResultCode()) {
                case 32: 
                case 49: {
                    logger.debug("CMSEngine: invalid credentials");
                    ret = 2;
                    return ret;
                }
                default: {
                    logger.debug("CMSEngine: unable to connect to " + name + ": " + e.getMessage());
                    ret = 3;
                    return ret;
                }
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.disconnect();
                }
            }
            catch (Exception e) {
                logger.warn("CMSEngine: unable to disconnect from " + host + ":" + port);
            }
        }
    }

    public void initSecurityProvider() {
        logger.info("CMSEngine: Java version: " + System.getProperty("java.version"));
        Security.addProvider((Provider)new org.mozilla.jss.netscape.security.provider.CMS());
        logger.info("CMSEngine: security providers:");
        for (Provider provider : Security.getProviders()) {
            logger.debug("CMSEngine: - " + provider);
        }
    }

    public void initDatabase() throws Exception {
    }

    public void initPluginRegistry() throws Exception {
        ConfigStore pluginRegistryConfig = this.config.getSubStore("registry", ConfigStore.class);
        String subsystem = this.config.getType().toLowerCase();
        String defaultRegistryFile = this.instanceDir + "/conf/" + subsystem + "/registry.cfg";
        this.pluginRegistry.init(pluginRegistryConfig, defaultRegistryFile);
        this.pluginRegistry.startup();
    }

    public void initAuditor() throws Exception {
        this.auditor = new Auditor();
        this.auditor.init();
    }

    public void initLogSubsystem() throws Exception {
        LoggingConfig logConfig = this.config.getLoggingConfig();
        this.logSubsystem = new LogSubsystem();
        this.logSubsystem.setCMSEngine(this);
        this.logSubsystem.init(logConfig);
        this.logSubsystem.startup();
    }

    public void initClientSocketListener() {
        this.clientSocketListener = new PKIClientSocketListener();
        this.clientSocketListener.setCMSEngine(this);
    }

    public void initServerSocketListener() {
        this.serverSocketListener = new PKIServerSocketListener();
        this.serverSocketListener.setCMSEngine(this);
    }

    public void initJssSubsystem() throws Exception {
        JssSubsystemConfig jssConfig = this.config.getJssSubsystemConfig();
        this.jssSubsystem = new JssSubsystem();
        this.jssSubsystem.setCMSEngine(this);
        this.jssSubsystem.init(jssConfig);
        this.jssSubsystem.startup();
    }

    public void initDBSubsystem() throws Exception {
        DatabaseConfig dbConfig = this.config.getDatabaseConfig();
        LDAPConfig ldapConfig = dbConfig.getLDAPConfig();
        PKISocketConfig socketConfig = this.config.getSocketConfig();
        PasswordStore passwordStore = this.getPasswordStore();
        this.dbSubsystem = new DBSubsystem();
        this.dbSubsystem.setCMSEngine(this);
        this.dbSubsystem.setEngineConfig(this.config);
        this.dbSubsystem.init(dbConfig, ldapConfig, socketConfig, passwordStore);
    }

    public void initUGSubsystem() throws Exception {
        this.ugSubsystem = new UGSubsystem();
        this.ugSubsystem.setCMSEngine(this);
        UGSubsystemConfig ugConfig = this.config.getUGSubsystemConfig();
        LDAPConfig ldapConfig = ugConfig.getLDAPConfig();
        PKISocketConfig socketConfig = this.config.getSocketConfig();
        PasswordStore passwordStore = this.getPasswordStore();
        this.ugSubsystem.init(ldapConfig, socketConfig, passwordStore);
    }

    public void initOIDLoaderSubsystem() throws Exception {
        ConfigStore oidLoaderConfig = this.config.getSubStore("oidmap", ConfigStore.class);
        this.oidLoaderSubsystem = new OidLoaderSubsystem();
        this.oidLoaderSubsystem.setCMSEngine(this);
        this.oidLoaderSubsystem.init(oidLoaderConfig);
        this.oidLoaderSubsystem.startup();
    }

    public void initX500NameSubsystem() throws Exception {
        ConfigStore x500NameConfig = this.config.getSubStore("X500Name", ConfigStore.class);
        this.x500NameSubsystem = new X500NameSubsystem();
        this.x500NameSubsystem.setCMSEngine(this);
        this.x500NameSubsystem.init(x500NameConfig);
        this.x500NameSubsystem.startup();
    }

    public void initRequestSubsystem() throws Exception {
        ConfigStore requestConfig = this.config.getSubStore("request", ConfigStore.class);
        this.requestSubsystem.init(requestConfig, this.dbSubsystem);
        this.requestSubsystem.startup();
    }

    public void initAuthSubsystem() throws Exception {
        AuthenticationConfig authConfig = this.config.getAuthenticationConfig();
        this.authSubsystem = new AuthSubsystem();
        this.authSubsystem.setCMSEngine(this);
        this.authSubsystem.init(authConfig);
        this.authSubsystem.startup();
    }

    public void initAuthzSubsystem() throws Exception {
        ConfigStore authzConfig = this.config.getSubStore("authz", ConfigStore.class);
        this.authzSubsystem = new AuthzSubsystem();
        this.authzSubsystem.setCMSEngine(this);
        this.authzSubsystem.init(authzConfig);
        this.authzSubsystem.startup();
    }

    public void initCMSGateway() throws Exception {
        this.gateway = new CMSGateway();
        this.gateway.setCMSEngine(this);
        this.gateway.init();
    }

    public void initJobsScheduler() throws Exception {
        JobsSchedulerConfig jobsSchedulerConfig = this.config.getJobsSchedulerConfig();
        this.jobsScheduler = new JobsScheduler();
        this.jobsScheduler.setCMSEngine(this);
        this.jobsScheduler.init(jobsSchedulerConfig);
        this.jobsScheduler.startup();
    }

    public void configurePorts() throws Exception {
        String path = this.instanceDir + File.separator + "conf" + File.separator + SERVER_XML;
        this.serverConfig = ServerConfig.load(path);
        this.unsecurePort = this.serverConfig.getUnsecurePort();
        this.securePort = this.serverConfig.getSecurePort();
        String port = this.config.getString("proxy.securePort", "");
        if (!port.equals("")) {
            this.securePort = port;
        }
        if (!(port = this.config.getString("proxy.unsecurePort", "")).equals("")) {
            this.unsecurePort = port;
        }
    }

    public void initSecurityDomain() throws Exception {
        int state = this.config.getState();
        if (state == 0) {
            return;
        }
        String sd = this.config.getString("securitydomain.select", "");
        if (sd.equals("existing")) {
            return;
        }
        String source = this.config.getString("securitydomain.source", "memory");
        String flushInterval = this.config.getString("securitydomain.flushinterval", "86400000");
        String checkInterval = this.config.getString("securitydomain.checkinterval", "5000");
        if (source.equals("ldap")) {
            LDAPSecurityDomainSessionTable sessionTable = new LDAPSecurityDomainSessionTable(Long.parseLong(flushInterval));
            sessionTable.setCMSEngine(this);
            sessionTable.init();
            this.mSecurityDomainSessionTable = sessionTable;
        } else {
            this.mSecurityDomainSessionTable = new MemorySecurityDomainSessionTable(Long.parseLong(flushInterval));
        }
        SessionTimer task = new SessionTimer(this.mSecurityDomainSessionTable);
        task.setCMSEngine(this);
        this.mSDTimer = new Timer();
        this.mSDTimer.schedule((TimerTask)task, 5L, Long.parseLong(checkInterval));
    }

    public void init() throws Exception {
        logger.info("Initializing " + this.name + " subsystem");
        this.loadSubsystems();
        this.initSubsystems();
        this.configurePorts();
    }

    public ConfigStore loadConfigStore(String path) throws EBaseException {
        try {
            File f = new File(path);
            f.createNewFile();
            FileConfigStorage storage = new FileConfigStorage(path);
            ConfigStore cs = new ConfigStore(storage);
            cs.load();
            return cs;
        }
        catch (Exception e) {
            logger.error("Cannot create file: " + path + ": " + e.getMessage(), (Throwable)e);
            throw new EBaseException("Cannot create file: " + path + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public boolean isPreOpMode() {
        return this.getCSState() == 0;
    }

    public boolean isRunningMode() {
        return this.getCSState() == 1;
    }

    public void setCSState(int mode) {
        this.mConfig.setState(mode);
    }

    public int getCSState() {
        int mode = 0;
        try {
            mode = this.mConfig.getState();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return mode;
    }

    public SecurityDomainSessionTable getSecurityDomainSessionTable() {
        return this.mSecurityDomainSessionTable;
    }

    public String getEENonSSLPort() {
        return this.unsecurePort;
    }

    public String getEESSLPort() {
        return this.securePort;
    }

    public String getEEClientAuthSSLPort() {
        return this.securePort;
    }

    public String getAgentPort() {
        return this.securePort;
    }

    public String getAdminPort() {
        return this.securePort;
    }

    public Collection<Subsystem> getSubsystems() {
        return this.subsystems.values();
    }

    public Subsystem getSubsystem(String name) {
        return this.subsystems.get(name);
    }

    public void setSubsystemEnabled(String id, boolean enabled) {
        SubsystemInfo si = this.subsystemInfos.get(id);
        si.enabled = enabled;
    }

    protected void loadSubsystems() throws Exception {
        this.subsystemInfos.clear();
        this.subsystems.clear();
        SubsystemsConfig subsystemsConfig = this.mConfig.getSubsystemsConfig();
        for (String subsystemNumber : subsystemsConfig.getSubsystemNames()) {
            SubsystemConfig subsystemConfig = subsystemsConfig.getSubsystemConfig(subsystemNumber);
            String id = subsystemConfig.getID();
            logger.info("CMSEngine: Loading " + id + " subsystem");
            String className = subsystemConfig.getClassName();
            boolean enabled = subsystemConfig.isEnabled();
            Subsystem subsystem = (Subsystem)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            subsystem.setCMSEngine(this);
            SubsystemInfo subsystemInfo = new SubsystemInfo(id);
            subsystemInfo.setEnabled(enabled);
            subsystemInfo.setUpdateIdOnInit(true);
            this.subsystems.put(id, subsystem);
            this.subsystemInfos.put(id, subsystemInfo);
        }
    }

    public void initSubsystem(Subsystem subsystem, ConfigStore subsystemConfig) throws Exception {
        if (subsystem instanceof SelfTestSubsystem && this.isPreOpMode()) {
            return;
        }
        subsystem.init(subsystemConfig);
    }

    public void initSubsystems() throws Exception {
        for (String id : this.subsystems.keySet()) {
            logger.info("CMSEngine: Initializing " + id + " subsystem");
            Subsystem subsystem = this.subsystems.get(id);
            SubsystemInfo subsystemInfo = this.subsystemInfos.get(id);
            if (subsystemInfo.updateIdOnInit) {
                subsystem.setId(id);
            }
            if (!subsystemInfo.enabled) {
                logger.info("CMSEngine: " + id + " subsystem is disabled");
                continue;
            }
            ConfigStore subsystemConfig = this.mConfig.getSubStore(id, ConfigStore.class);
            this.initSubsystem(subsystem, subsystemConfig);
        }
    }

    public void configureAutoShutdown() throws Exception {
        if (this.isPreOpMode()) {
            return;
        }
        logger.info("CMSEngine: Configuring auto shutdown");
        this.mAutoSD_Restart = this.config.getBoolean("autoShutdown.restart.enable", false);
        logger.debug("CMSEngine: restart at autoShutdown: " + this.mAutoSD_Restart);
        if (this.mAutoSD_Restart) {
            this.mAutoSD_RestartMax = this.config.getInteger("autoShutdown.restart.max", 3);
            logger.debug("CMSEngine: restart max: " + this.mAutoSD_RestartMax);
            this.mAutoSD_RestartCount = this.config.getInteger("autoShutdown.restart.count", 0);
            logger.debug("CMSEngine: current restart count: " + this.mAutoSD_RestartCount);
        } else {
            this.mAutoSD_CrumbFile = this.config.getString("autoShutdown.crumbFile", this.instanceDir + "/logs/autoShutdown.crumb");
            logger.info("CMSEngine: auto-shutdown crumb file: " + this.mAutoSD_CrumbFile);
            File crumb = new File(this.mAutoSD_CrumbFile);
            if (crumb.exists()) {
                logger.info("CMSEngine: deleting auto-shutdown crumb file: " + this.mAutoSD_CrumbFile);
                crumb.delete();
            }
        }
        LoggersConfig loggersConfig = this.config.getLoggingConfig().getLoggersConfig();
        LoggerConfig loggerConfig = loggersConfig.getLoggerConfig("SignedAudit");
        String mSAuditCertNickName = loggerConfig.getString("signedAuditCertNickname");
        logger.debug("CMSEngine: audit signing cert: " + mSAuditCertNickName);
        CryptoManager mManager = CryptoManager.getInstance();
        X509Certificate cert = mManager.findCertByNickname(mSAuditCertNickName);
        this.mSigningKey = mManager.findPrivKeyByCert(cert);
        this.mSigningData = cert.getPublicKey().getEncoded();
    }

    public void configureServerCertNickname() throws EBaseException {
        String id = this.mConfig.getType().toLowerCase();
        if (id.equals("ca") || id.equals("ocsp") || id.equals("kra") || id.equals("tks")) {
            logger.info("CMSEngine: Configuring servlet certificate nickname");
            ConfigStore serverCertStore = this.mConfig.getSubStore(id + ".sslserver", ConfigStore.class);
            if (serverCertStore != null && serverCertStore.size() > 0) {
                String nickName = serverCertStore.getString("nickname");
                String tokenName = serverCertStore.getString("tokenname");
                if (tokenName != null && tokenName.length() > 0 && nickName != null && nickName.length() > 0) {
                    this.setServerCertNickname(tokenName, nickName);
                    logger.debug("CMSEngine: server certificate nickname: " + tokenName + ":" + nickName);
                } else if (nickName != null && nickName.length() > 0) {
                    this.setServerCertNickname(nickName);
                    logger.debug("CMSEngine: server certificate nickName: " + nickName);
                } else {
                    logger.warn("Unable to configure server certificate nickname");
                }
            }
        }
    }

    public void checkForAndAutoShutdown() {
        String method = "CMSEngine: checkForAndAutoShutdown: ";
        logger.debug(method + "begins");
        try {
            boolean allowShutdown = this.mConfig.getBoolean("autoShutdown.allowed", false);
            if (!allowShutdown || this.mSigningKey == null || this.mSigningData == null) {
                logger.debug(method + "autoShutdown not allowed");
                return;
            }
            logger.debug(method + "autoShutdown allowed");
            CryptoToken token = ((PK11PrivKey)this.mSigningKey).getOwningToken();
            SignatureAlgorithm signAlg = Cert.mapAlgorithmToJss((String)"SHA256withRSA");
            Signature signer = token.getSignatureContext(signAlg);
            signer.initSign(this.mSigningKey);
            signer.update(this.mSigningData);
            byte[] result = signer.sign();
            logger.debug(method + " signining successful: " + new String(result));
        }
        catch (SignatureException e) {
            System.err.println(CMS.getUserMessage("CMS_CA_SIGNING_OPERATION_FAILED", e.toString()));
            logger.warn(method + "autoShutdown for " + e.getMessage(), (Throwable)e);
            this.autoShutdown();
        }
        catch (Exception e) {
            logger.warn(method + "continue for " + e.getMessage(), (Throwable)e);
        }
        logger.debug(method + "passed; continue");
    }

    public void recoverRequestQueue() {
        if (!this.isRunningMode()) {
            return;
        }
        RecoverThread t = new RecoverThread(this.requestQueue);
        t.start();
    }

    protected void startupSubsystems() throws Exception {
        for (Subsystem subsystem : this.subsystems.values()) {
            if (subsystem instanceof SelfTestSubsystem && this.isPreOpMode()) {
                return;
            }
            logger.info("CMSEngine: Starting " + subsystem.getId() + " subsystem");
            subsystem.startup();
        }
    }

    public void notifySubsystemStarted() {
        for (String name : this.subsystemListeners.keySet()) {
            SubsystemListener notifier = this.subsystemListeners.get(name);
            try {
                notifier.subsystemStarted();
            }
            catch (Exception e) {
                logger.warn("Unable to notify '" + name + "': " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public void start() throws Exception {
        logger.info("Starting " + this.name + " engine");
        this.ready = false;
        this.instanceDir = CMS.getInstanceDir();
        String serverConfDir = this.instanceDir + File.separator + "conf";
        String subsystemConfDir = serverConfDir + File.separator + this.id;
        String path = subsystemConfDir + File.separator + "CS.cfg";
        this.loadConfig(path);
        this.initDebug();
        this.initPasswordStore();
        this.initSubsystemListeners();
        this.initSecurityProvider();
        this.initPluginRegistry();
        this.initAuditor();
        this.initLogSubsystem();
        this.initClientSocketListener();
        this.initServerSocketListener();
        this.testLDAPConnections();
        this.initDatabase();
        this.initJssSubsystem();
        this.initDBSubsystem();
        this.initUGSubsystem();
        this.initOIDLoaderSubsystem();
        this.initX500NameSubsystem();
        this.initRequestSubsystem();
        this.init();
        this.startupSubsystems();
        this.initAuthSubsystem();
        this.initAuthzSubsystem();
        this.initCMSGateway();
        this.initJobsScheduler();
        this.configureAutoShutdown();
        this.configureServerCertNickname();
        this.initSecurityDomain();
        this.ready = true;
        this.isStarted = true;
        this.mStartupTime = System.currentTimeMillis();
        logger.info(this.name + " engine started");
        TomcatJSS tomcatJss = TomcatJSS.getInstance();
        tomcatJss.addSocketListener((SSLSocketListener)this.serverSocketListener);
        this.notifySubsystemStarted();
    }

    public boolean isInRunningState() {
        return this.isStarted;
    }

    public String getServerCertNickname() {
        return this.mServerCertNickname;
    }

    public void setServerCertNickname(String tokenName, String nickName) {
        Object newName = null;
        if (CryptoUtil.isInternalToken((String)tokenName)) {
            newName = nickName;
        } else {
            if (tokenName.equals("") && nickName.equals("")) {
                return;
            }
            newName = tokenName + ":" + nickName;
        }
        this.setServerCertNickname((String)newName);
    }

    public void setServerCertNickname(String newName) {
        this.mServerCertNickname = newName;
    }

    public MailNotification getMailNotification() {
        try {
            String className = this.mConfig.getString("notificationClassName", MailNotification.class.getName());
            MailNotification notification = (MailNotification)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            ConfigStore cs = this.config.getSubStore("smtp", ConfigStore.class);
            String host = cs.getString("host");
            logger.debug("CMSEngine: SMTP host: " + host);
            notification.setHost(host);
            return notification;
        }
        catch (Exception e) {
            logger.warn("CMSEngine: Unable to create mail notification: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public PasswordChecker getPasswordChecker() {
        try {
            String className = this.mConfig.getString("passwordCheckerClass", "com.netscape.cms.password.PasswordChecker");
            PasswordChecker check = (PasswordChecker)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return check;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void disableRequests() {
        CommandQueue.mShuttingDown = true;
    }

    public boolean areRequestsDisabled() {
        return CommandQueue.mShuttingDown;
    }

    public void terminateRequests() {
        Enumeration<CMSRequest> e = CommandQueue.mCommandQueue.keys();
        while (e.hasMoreElements()) {
            CMSRequest thisRequest = e.nextElement();
            HttpServlet thisServlet = (HttpServlet)CommandQueue.mCommandQueue.get(thisRequest);
            if (thisServlet == null) continue;
            CommandQueue.mCommandQueue.remove(thisRequest);
            thisServlet.destroy();
        }
    }

    public static boolean isNT() {
        return File.separator.equals("\\");
    }

    private void shutdownHttpServer(boolean restart) {
        try {
            String[] cmds = null;
            String cmd = "stop";
            if (restart) {
                cmd = "restart";
            }
            cmds = new String[]{"/usr/bin/systemctl", cmd, NuxwdogUtil.startedByNuxwdog() ? "pki-tomcatd-nuxwdog@" + this.instanceId + ".service" : "pki-tomcatd@" + this.instanceId + ".service"};
            Process process = Runtime.getRuntime().exec(cmds);
            process.waitFor();
        }
        catch (IOException e) {
            logger.warn("Unable to shutdown HTTP server: " + e.getMessage(), (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void shutdownJobsScheduler() {
        if (this.jobsScheduler == null) {
            return;
        }
        this.jobsScheduler.shutdown();
    }

    public void shutdownAuthzSubsystem() {
        if (this.authzSubsystem == null) {
            return;
        }
        this.authzSubsystem.shutdown();
    }

    public void shutdownAuthSubsystem() {
        if (this.authSubsystem == null) {
            return;
        }
        this.authSubsystem.shutdown();
    }

    public void shutdownRequestSubsystem() {
        if (this.requestSubsystem == null) {
            return;
        }
        this.requestSubsystem.shutdown();
    }

    public void shutdownX500NameSubsystem() {
        if (this.x500NameSubsystem == null) {
            return;
        }
        this.x500NameSubsystem.shutdown();
    }

    public void shutdownOIDLoaderSubsystem() {
        if (this.oidLoaderSubsystem == null) {
            return;
        }
        this.oidLoaderSubsystem.shutdown();
    }

    public void shutdownUGSubsystem() {
        if (this.ugSubsystem == null) {
            return;
        }
        this.ugSubsystem.shutdown();
    }

    public void shutdownDBSubsystem() {
        if (this.dbSubsystem == null) {
            return;
        }
        this.dbSubsystem.shutdown();
    }

    public void shutdownJSSSubsystem() {
        if (this.jssSubsystem == null) {
            return;
        }
        this.jssSubsystem.shutdown();
    }

    public void shutdownLogSubsystem() {
        if (this.logSubsystem == null) {
            return;
        }
        this.logSubsystem.shutdown();
    }

    public void shutdownDatabase() {
    }

    public void shutdownPluginRegistry() {
        if (this.pluginRegistry == null) {
            return;
        }
        this.pluginRegistry.shutdown();
    }

    public void shutdown() {
        this.isStarted = false;
        if (this.serverSocketListener != null) {
            TomcatJSS tomcatJss = TomcatJSS.getInstance();
            tomcatJss.removeSocketListener((SSLSocketListener)this.serverSocketListener);
        }
        logger.info("Shutting down " + this.name + " subsystem");
        this.shutdownJobsScheduler();
        this.shutdownAuthzSubsystem();
        this.shutdownAuthSubsystem();
        this.shutdownSubsystems();
        if (this.mSDTimer != null) {
            this.mSDTimer.cancel();
        }
        if (this.mSecurityDomainSessionTable != null) {
            this.mSecurityDomainSessionTable.shutdown();
        }
        this.shutdownRequestSubsystem();
        this.shutdownX500NameSubsystem();
        this.shutdownOIDLoaderSubsystem();
        this.shutdownUGSubsystem();
        this.shutdownDBSubsystem();
        this.shutdownJSSSubsystem();
        this.shutdownLogSubsystem();
        this.shutdownDatabase();
        this.shutdownPluginRegistry();
    }

    public void forceShutdown() {
        logger.debug("CMSEngine.forceShutdown()");
        this.autoShutdown(false);
    }

    public void autoShutdown() {
        this.autoShutdown(this.mAutoSD_Restart);
    }

    public void autoShutdown(boolean restart) {
        logger.info("CMSEngine: Shutting down " + this.name + " subsystem");
        logger.debug("CMSEngine: restart: " + restart);
        if (restart) {
            logger.debug("CMSEngine: checking autoShutdown.restart trackers");
            if (this.mAutoSD_RestartCount >= this.mAutoSD_RestartMax) {
                this.mAutoSD_Restart = false;
                this.mConfig.putBoolean("autoShutdown.restart.enable", this.mAutoSD_Restart);
                logger.debug("CMSEngine: autoShutdown.restart.max reached, disabled autoShutdown.restart.enable");
            } else {
                ++this.mAutoSD_RestartCount;
                this.mConfig.putInteger("autoShutdown.restart.count", this.mAutoSD_RestartCount);
                logger.debug("CMSEngine: autoShutdown.restart.max not reached, increment autoShutdown.restart.count");
            }
            try {
                this.mConfig.commit(false);
            }
            catch (EBaseException e) {
                logger.warn("Unable to store configuration: " + e.getMessage(), (Throwable)e);
            }
        } else {
            File crumb = new File(this.mAutoSD_CrumbFile);
            try {
                crumb.createNewFile();
            }
            catch (IOException e) {
                logger.warn("Create autoShutdown crumb file failed on " + this.mAutoSD_CrumbFile + ": " + e.getMessage(), (Throwable)e);
                logger.warn("Nothing to do, keep shutting down");
            }
        }
        if (!this.areRequestsDisabled()) {
            this.disableRequests();
        }
        this.terminateRequests();
        this.shutdown();
        this.shutdownHttpServer(restart);
    }

    public void disableSubsystem() {
        logger.info("CMSEngine: Disabling " + this.name + " subsystem");
        try {
            ProcessBuilder pb = new ProcessBuilder("pki-server", "subsystem-disable", "-i", this.instanceId, this.id);
            logger.debug("Command: " + String.join((CharSequence)" ", pb.command()));
            Process process = pb.inheritIO().start();
            int rc = process.waitFor();
            if (rc != 0) {
                logger.error("CMSEngine: Unable to disable " + this.name + " subsystem. RC: " + rc);
            }
        }
        catch (Exception e) {
            logger.error("CMSEngine: Unable to disable " + this.name + " subsystem: " + e.getMessage(), (Throwable)e);
        }
    }

    protected void shutdownSubsystems() {
        ArrayList<Subsystem> list = new ArrayList<Subsystem>();
        list.addAll(this.subsystems.values());
        Collections.reverse(list);
        for (Subsystem subsystem : list) {
            logger.debug("CMSEngine: Stopping " + subsystem.getId() + " subsystem");
            subsystem.shutdown();
        }
    }

    public ConfigStore getConfigStore() {
        return this.mConfig;
    }

    public EngineConfig getConfig() {
        return this.mConfig;
    }

    public ServerConfig getServerConfig() {
        return this.serverConfig;
    }

    public long getStartupTime() {
        return this.mStartupTime;
    }

    public void putPasswordCache(String tag, String pw) {
        try {
            PWsdrCache pwc = new PWsdrCache();
            pwc.setEngineConfig(this.config);
            pwc.addEntry(tag, pw);
        }
        catch (EBaseException e) {
            logger.warn(CMS.getLogMessage("CMSCORE_SDR_ADD_ERROR", e.toString()), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPID() {
        if (this.pid != 0) {
            return this.pid;
        }
        BufferedReader bf = null;
        try {
            String dir = this.mConfig.getString("pidDir", "/var/run");
            String name = dir + File.separator + this.instanceId + ".pid";
            if (dir == null) {
                int n = this.pid;
                return n;
            }
            File file = new File(name);
            if (!file.exists()) {
                int e = this.pid;
                return e;
            }
            bf = new BufferedReader(new FileReader(file));
            String value = bf.readLine();
            this.pid = Integer.parseInt(value);
        }
        catch (Exception e) {
            logger.warn("Unable to get PID: " + e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (bf != null) {
                    bf.close();
                }
            }
            catch (Exception e) {
                logger.warn("Unable to close BufferedReader: " + e.getMessage(), (Throwable)e);
            }
        }
        return this.pid;
    }

    public void setListOfVerifiedCerts(int size, long interval, long unknownStateInterval) {
        if (size > 0 && this.mVCListSize == 0) {
            this.mVCListSize = size;
            this.mVCList = new VerifiedCerts(size, interval, unknownStateInterval);
        }
    }

    public boolean isRevoked(java.security.cert.X509Certificate[] certificates) {
        if (certificates == null) {
            return false;
        }
        X509CertImpl cert = (X509CertImpl)certificates[0];
        int result = 0;
        if (this.mVCList != null) {
            result = this.mVCList.check(cert);
        }
        if (result == 1) {
            return true;
        }
        if (result == 2 || result == 4) {
            return false;
        }
        boolean revoked = false;
        if (this.requestQueue != null) {
            Request checkRevReq = null;
            try {
                checkRevReq = this.requestRepository.createRequest("getRevocationInfo");
                checkRevReq.setExtData("requestType", "getRevocationInfo");
                checkRevReq.setExtData("requestorType", "RA");
                X509CertImpl[] agentCerts = new X509CertImpl[certificates.length];
                for (int i = 0; i < certificates.length; ++i) {
                    agentCerts[i] = (X509CertImpl)certificates[i];
                }
                checkRevReq.setExtData("issuedCerts", agentCerts);
                this.requestQueue.processRequest(checkRevReq);
                RequestStatus status = checkRevReq.getRequestStatus();
                if (status == RequestStatus.COMPLETE) {
                    Enumeration<String> keys = checkRevReq.getExtDataKeys();
                    while (keys.hasMoreElements()) {
                        String name = keys.nextElement();
                        if (!name.equals("revokedCerts")) continue;
                        revoked = true;
                        if (this.mVCList == null) continue;
                        this.mVCList.update(cert, 1);
                    }
                    if (!revoked && this.mVCList != null) {
                        this.mVCList.update(cert, 2);
                    }
                } else if (this.mVCList != null) {
                    this.mVCList.update(cert, 4);
                }
            }
            catch (EBaseException e) {
                logger.warn(CMS.getLogMessage("CMSCORE_AUTH_AGENT_PROCESS_CHECKING", new Object[0]), (Throwable)e);
            }
        }
        return revoked;
    }

    public boolean isReady() {
        return this.ready;
    }

    public void sleepOneMinute() {
        boolean debugSleep = false;
        try {
            debugSleep = this.mConfig.getBoolean("debug.sleepOneMinute", false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (debugSleep) {
            logger.debug("debugSleep: about to sleep for one minute; do check now: e.g. ldap, hsm, etc.");
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException e) {
                logger.warn("debugSleep: sleep out:" + e.toString());
            }
        }
    }

    public void verifySystemCerts(boolean checkValidityOnly) throws Exception {
        String auditMessage = null;
        try {
            String subsysType = this.config.getType();
            if (subsysType == null || subsysType.equals("")) {
                logger.error("CMSEngine: Missing cs.type in CS.cfg");
                auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_CIMC_CERT_VERIFICATION_3", "$System$", "Failure", "");
                this.auditor.log(auditMessage);
                throw new Exception("Missing cs.type in CS.cfg");
            }
            String certlist = this.config.getString((subsysType = subsysType.toLowerCase()) + ".cert.list", "");
            if (certlist.equals("")) {
                logger.error("CMSEngine: Missing " + subsysType + ".cert.list in CS.cfg");
                auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_CIMC_CERT_VERIFICATION_3", "$System$", "Failure", "");
                this.auditor.log(auditMessage);
                throw new Exception("Missing " + subsysType + ".cert.list in CS.cfg");
            }
            StringTokenizer tokenizer = new StringTokenizer(certlist, ",");
            while (tokenizer.hasMoreTokens()) {
                String tag = tokenizer.nextToken();
                tag = tag.trim();
                logger.debug("CMSEngine: verifySystemCerts() cert tag=" + tag);
                if (!checkValidityOnly) {
                    this.verifySystemCertByTag(tag);
                    continue;
                }
                this.verifySystemCertByTag(tag, true);
            }
        }
        catch (Exception e) {
            auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_CIMC_CERT_VERIFICATION_3", "$System$", "Failure", "");
            this.auditor.log(auditMessage);
            throw e;
        }
    }

    public void verifySystemCertByTag(String tag) throws Exception {
        this.verifySystemCertByTag(tag, false);
    }

    public void verifySystemCertByTag(String tag, boolean checkValidityOnly) throws Exception {
        logger.debug("CMSEngine: verifySystemCertByTag(" + tag + ")");
        String auditMessage = null;
        try {
            String subsysType = this.config.getType();
            if (subsysType == null || subsysType.equals("")) {
                logger.error("CMSEngine: Missing cs.type in CS.cfg");
                throw new Exception("Missing cs.type in CS.cfg");
            }
            String nickname = this.config.getString((subsysType = subsysType.toLowerCase()) + ".cert." + tag + ".nickname", "");
            if (nickname.equals("")) {
                logger.error("CMSEngine: verifySystemCertByTag() nickname for cert tag " + tag + " undefined in CS.cfg");
                throw new Exception("Missing nickname for " + tag + " certificate");
            }
            String certusage = this.config.getString(subsysType + ".cert." + tag + ".certusage", "");
            if (certusage.equals("")) {
                logger.warn("CMSEngine: verifySystemCertByTag() certusage for cert tag " + tag + " undefined in CS.cfg, getting current certificate usage");
            }
            if (!checkValidityOnly) {
                CertUtil.verifyCertificateUsage((String)nickname, (String)certusage);
            } else {
                CertUtil.verifyCertValidity((String)nickname);
            }
            auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_CIMC_CERT_VERIFICATION_3", "$System$", "Success", nickname);
            this.auditor.log(auditMessage);
        }
        catch (Exception e) {
            logger.error("CMSEngine: verifySystemCertsByTag() failed: " + e.getMessage(), (Throwable)e);
            auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_CIMC_CERT_VERIFICATION_3", "$System$", "Failure", "");
            this.auditor.log(auditMessage);
            throw e;
        }
    }

    public String getAuditGroups(String subjectID) {
        Enumeration<Group> groups;
        if (subjectID == null || subjectID.equals("$Unidentified$")) {
            return null;
        }
        try {
            groups = this.ugSubsystem.findGroups("*");
        }
        catch (Exception e) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        while (groups.hasMoreElements()) {
            Group group = groups.nextElement();
            if (!group.isMember(subjectID)) continue;
            if (sb.length() != 0) {
                sb.append(", ");
            }
            sb.append(group.getGroupID());
        }
        if (sb.length() == 0) {
            return null;
        }
        return sb.toString();
    }
}

