/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.cli;

import com.netscape.cmscore.apps.EngineConfig;
import com.netscape.cmscore.ldapconn.LDAPConfig;
import com.netscape.cmscore.ldapconn.PKISocketConfig;
import com.netscape.cmscore.usrgrp.Group;
import com.netscape.cmscore.usrgrp.UGSubsystem;
import com.netscape.cmscore.usrgrp.UGSubsystemConfig;
import com.netscape.cmscore.usrgrp.User;
import com.netscape.cmsutil.password.PasswordStore;
import com.netscape.cmsutil.password.PasswordStoreConfig;
import java.util.Enumeration;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.lang3.StringUtils;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.server.cli.SubsystemCLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubsystemGroupFindCLI
extends SubsystemCLI {
    public static Logger logger = LoggerFactory.getLogger(SubsystemGroupFindCLI.class);

    public SubsystemGroupFindCLI(CLI parent) {
        super("find", "Find " + parent.getParent().getName().toUpperCase() + " groups", parent);
    }

    public void createOptions() {
        Option option = new Option(null, "member", true, "Member ID");
        option.setArgName("ID");
        this.options.addOption(option);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(CommandLine cmd) throws Exception {
        String memberID = cmd.getOptionValue("member");
        this.initializeTomcatJSS();
        String subsystem = this.parent.getParent().getName();
        EngineConfig cs = this.getEngineConfig(subsystem);
        cs.load();
        UGSubsystemConfig ugConfig = cs.getUGSubsystemConfig();
        LDAPConfig ldapConfig = ugConfig.getLDAPConfig();
        ldapConfig.putInteger("minConns", 1);
        PKISocketConfig socketConfig = cs.getSocketConfig();
        PasswordStoreConfig psc = cs.getPasswordStoreConfig();
        PasswordStore passwordStore = PasswordStore.create((PasswordStoreConfig)psc);
        UGSubsystem ugSubsystem = new UGSubsystem();
        try {
            Enumeration<Group> groups;
            ugSubsystem.init(ldapConfig, socketConfig, passwordStore);
            if (memberID != null) {
                User member = ugSubsystem.getUser(memberID);
                groups = ugSubsystem.findGroupsByUser(member.getUserDN(), null);
            } else {
                groups = ugSubsystem.listGroups(null);
            }
            boolean first = true;
            while (groups.hasMoreElements()) {
                Group group = groups.nextElement();
                if (first) {
                    first = false;
                } else {
                    System.out.println();
                }
                System.out.println("  Group ID: " + group.getGroupID());
                String description = group.getDescription();
                if (StringUtils.isEmpty((CharSequence)description)) continue;
                System.out.println("  Description: " + description);
            }
        }
        finally {
            ugSubsystem.shutdown();
        }
    }
}

