/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.ca;

import com.netscape.certsrv.ca.AuthorityID;
import com.netscape.certsrv.ca.CACertClient;
import com.netscape.certsrv.cert.CertEnrollmentRequest;
import com.netscape.certsrv.cert.CertRequestInfos;
import com.netscape.certsrv.dbs.certdb.CertId;
import com.netscape.certsrv.profile.ProfileAttribute;
import com.netscape.certsrv.profile.ProfileInput;
import com.netscape.cmstools.ca.CACertRequestCLI;
import com.netscape.cmstools.cli.MainCLI;
import java.io.Closeable;
import java.io.Console;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Scanner;
import java.util.Vector;
import netscape.ldap.util.DN;
import netscape.ldap.util.RDN;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtag.util.cert.CertUtil;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.mozilla.jss.netscape.security.pkcs.PKCS10;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CACertRequestSubmitCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(CACertRequestSubmitCLI.class);
    CACertRequestCLI certRequestCLI;

    public CACertRequestSubmitCLI(CACertRequestCLI CACertRequestCLI2) {
        super("submit", "Submit certificate request", (CLI)CACertRequestCLI2);
        this.certRequestCLI = CACertRequestCLI2;
    }

    public void createOptions() {
        Option option = new Option(null, "issuer-id", true, "Authority ID (host authority if omitted)");
        option.setArgName("ID");
        this.options.addOption(option);
        option = new Option(null, "issuer-dn", true, "Authority DN (host authority if omitted)");
        option.setArgName("DN");
        this.options.addOption(option);
        option = new Option(null, "username", true, "Username for request authentication");
        option.setArgName("username");
        this.options.addOption(option);
        option = new Option(null, "password", false, "Prompt password for request authentication");
        this.options.addOption(option);
        option = new Option(null, "profile", true, "Certificate profile");
        option.setArgName("profile");
        this.options.addOption(option);
        option = new Option(null, "request-type", true, "Request type (default: pkcs10)");
        option.setArgName("type");
        this.options.addOption(option);
        option = new Option(null, "renewal", false, "Submit renewal request");
        this.options.addOption(option);
        option = new Option(null, "csr-file", true, "File containing the CSR");
        option.setArgName("path");
        this.options.addOption(option);
        option = new Option(null, "serial", true, "Serial number of certificate for renewal");
        option.setArgName("number");
        this.options.addOption(option);
        option = new Option(null, "subject", true, "Subject DN");
        option.setArgName("DN");
        this.options.addOption(option);
        option = new Option(null, "dns-names", true, "Comma-separated list of DNS names");
        option.setArgName("names");
        this.options.addOption(option);
        option = new Option(null, "requestor", true, "Requestor");
        option.setArgName("requestor");
        this.options.addOption(option);
        option = new Option(null, "session", true, "Session ID");
        option.setArgName("ID");
        this.options.addOption(option);
        option = new Option(null, "install-token", true, "Install token");
        option.setArgName("path");
        this.options.addOption(option);
        option = new Option(null, "output-format", true, "Output format: PEM (default), DER");
        option.setArgName("format");
        this.options.addOption(option);
        option = new Option(null, "output-file", true, "Output file");
        option.setArgName("file");
        this.options.addOption(option);
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " <filename> [OPTIONS...]", this.options);
    }

    public void execute(CommandLine cmd) throws Exception {
        Closeable out;
        String certRequestUsername;
        String subjectDN;
        String serial;
        CertEnrollmentRequest request;
        String[] cmdArgs = cmd.getArgs();
        String requestFilename = cmdArgs.length > 0 ? cmdArgs[0] : null;
        String profileID = cmd.getOptionValue("profile");
        if (requestFilename == null && profileID == null) {
            throw new Exception("Missing request file or profile ID.");
        }
        if (requestFilename != null && profileID != null) {
            throw new Exception("Request file and profile ID are mutually exclusive.");
        }
        AuthorityID aid = null;
        if (cmd.hasOption("issuer-id")) {
            String aidString = cmd.getOptionValue("issuer-id");
            try {
                aid = new AuthorityID(aidString);
            }
            catch (IllegalArgumentException e) {
                throw new Exception("Bad AuthorityID: " + aidString, e);
            }
        }
        X500Name adn = null;
        if (cmd.hasOption("issuer-dn")) {
            String adnString = cmd.getOptionValue("issuer-dn");
            try {
                adn = new X500Name(adnString);
            }
            catch (IOException e) {
                throw new Exception("Bad DN: " + adnString, e);
            }
        }
        if (aid != null && adn != null) {
            throw new Exception("--issuer-id and --issuer-dn options are mutually exclusive");
        }
        String requestType = cmd.getOptionValue("request-type");
        if (requestFilename == null) {
            logger.info("Retrieving " + profileID + " profile");
            CACertClient certClient = this.certRequestCLI.getCertClient();
            request = certClient.getEnrollmentTemplate(profileID);
            if (requestType == null) {
                requestType = "pkcs10";
            }
        } else {
            logger.info("Loading request from " + requestFilename);
            String xml = this.loadFile(requestFilename);
            request = CertEnrollmentRequest.fromXML((String)xml);
        }
        if (requestType != null) {
            logger.info("Request type: " + requestType);
            for (ProfileInput input : request.getInputs()) {
                ProfileAttribute typeAttr = input.getAttribute("cert_request_type");
                if (typeAttr == null) continue;
                typeAttr.setValue(requestType);
            }
        }
        request.setRenewal(cmd.hasOption("renewal"));
        String csrFilename = cmd.getOptionValue("csr-file");
        String csr = null;
        PKCS10 pkcs10 = null;
        if (csrFilename != null) {
            csr = this.loadFile(csrFilename);
            logger.debug("CSR:\n" + csr);
            byte[] bytes = CertUtil.parseCSR((String)csr);
            if ("pkcs10".equals(requestType)) {
                pkcs10 = new PKCS10(bytes);
            }
            for (ProfileInput input : request.getInputs()) {
                ProfileAttribute csrAttr = input.getAttribute("cert_request");
                if (csrAttr == null) continue;
                csrAttr.setValue(csr);
            }
        }
        if ((serial = cmd.getOptionValue("serial")) != null) {
            logger.info("Serial: " + serial);
            request.setSerialNum(new CertId(serial));
            for (ProfileInput input : request.getInputs()) {
                ProfileAttribute serialAttr = input.getAttribute("serial_num");
                if (serialAttr == null) continue;
                serialAttr.setValue(serial);
            }
        }
        if ((subjectDN = cmd.getOptionValue("subject")) == null && pkcs10 != null) {
            subjectDN = pkcs10.getSubjectName().toLdapDNString();
        }
        if (subjectDN != null) {
            DN dn = new DN(subjectDN);
            Vector rdns = dn.getRDNs();
            HashMap<String, String> subjectAttributes = new HashMap<String, String>();
            for (int i = 0; i < rdns.size(); ++i) {
                RDN rdn = (RDN)rdns.elementAt(i);
                String type = rdn.getTypes()[0].toLowerCase();
                String value = rdn.getValues()[0];
                subjectAttributes.put(type, value);
            }
            ProfileInput sn = request.getInput("Subject Name");
            if (sn != null) {
                logger.info("Subject Name:");
                for (ProfileAttribute attribute : sn.getAttributes()) {
                    String name = attribute.getName();
                    String value = null;
                    if (name.equals("subject")) {
                        value = subjectDN;
                    } else if (name.startsWith("sn_")) {
                        value = (String)subjectAttributes.get(name.substring(3));
                    } else {
                        logger.info("- " + name);
                        continue;
                    }
                    if (value == null) continue;
                    logger.info("- " + name + ": " + value);
                    attribute.setValue(value);
                }
            }
        }
        if ((certRequestUsername = cmd.getOptionValue("username")) != null) {
            request.setAttribute("uid", certRequestUsername);
        }
        if (cmd.hasOption("password")) {
            Console console = System.console();
            String certRequestPassword = new String(console.readPassword("Password: ", new Object[0]));
            request.setAttribute("pwd", certRequestPassword);
        }
        logger.info("Request:\n" + request);
        String list = cmd.getOptionValue("dns-names");
        logger.info("DNS names: " + list);
        String[] dnsNames = null;
        if (list != null) {
            dnsNames = list.split(",");
        }
        String requestor = cmd.getOptionValue("requestor");
        logger.info("Requestor: " + requestor);
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        CACertClient certClient = this.certRequestCLI.getCertClient();
        String installToken = cmd.getOptionValue("install-token");
        String sessionID = installToken != null ? new String(Files.readAllBytes(Paths.get(installToken, new String[0]))) : cmd.getOptionValue("session");
        if (sessionID == null) {
            CertRequestInfos cri = certClient.enrollRequest(request, aid, adn);
            MainCLI.printMessage("Submitted certificate request");
            CACertRequestCLI.printCertRequestInfos(cri);
            return;
        }
        X509CertImpl cert = certClient.submitRequest(requestType, csr, profileID, subjectDN, dnsNames, requestor, sessionID);
        byte[] bytes = cert.getEncoded();
        String outputFormat = cmd.getOptionValue("output-format");
        if (outputFormat == null || "PEM".equalsIgnoreCase(outputFormat)) {
            StringWriter sw = new StringWriter();
            out = new PrintWriter((Writer)sw, true);
            try {
                ((PrintWriter)out).println("-----BEGIN CERTIFICATE-----");
                ((PrintWriter)out).print(Utils.base64encodeMultiLine((byte[])cert.getEncoded()));
                ((PrintWriter)out).println("-----END CERTIFICATE-----");
            }
            finally {
                ((PrintWriter)out).close();
            }
            bytes = sw.toString().getBytes();
        } else if ("DER".equalsIgnoreCase(outputFormat)) {
            bytes = cert.getEncoded();
        } else {
            throw new Exception("Unsupported format: " + outputFormat);
        }
        String outputFile = cmd.getOptionValue("output-file");
        if (outputFile != null) {
            out = new FileOutputStream(outputFile);
            try {
                ((FileOutputStream)out).write(bytes);
            }
            finally {
                ((FileOutputStream)out).close();
            }
        } else {
            System.out.write(bytes);
        }
    }

    private String loadFile(String fileName) throws FileNotFoundException {
        try (Scanner scanner = new Scanner(new File(fileName));){
            String string = scanner.useDelimiter("\\A").next();
            return string;
        }
    }
}

