/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.kra;

import com.netscape.certsrv.base.RESTMessage;
import com.netscape.certsrv.util.JSONSerializer;
import com.netscape.cmstools.kra.KRAKeyCLI;
import java.io.FileWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KRAKeyTemplateShowCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(KRAKeyTemplateShowCLI.class);
    public KRAKeyCLI keyCLI;

    public KRAKeyTemplateShowCLI(KRAKeyCLI keyCLI) {
        super("template-show", "Get request template", (CLI)keyCLI);
        this.keyCLI = keyCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " <Template ID> [OPTIONS...]", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "output", true, "Location to store the template.");
        option.setArgName("output file");
        this.options.addOption(option);
    }

    public void execute(CommandLine cmd) throws Exception {
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length < 1) {
            throw new Exception("No Template ID specified.");
        }
        String templateId = cmdArgs[0];
        String writeToFile = cmd.getOptionValue("output");
        String templateDir = "/usr/share/pki/key/templates/";
        String templatePath = templateDir + templateId + ".json";
        String json = Files.readString(Path.of(templatePath, new String[0]));
        RESTMessage data = (RESTMessage)JSONSerializer.fromJSON((String)json, RESTMessage.class);
        if (writeToFile != null) {
            try (FileWriter out = new FileWriter(writeToFile);){
                out.write(data.toJSON());
            }
        } else {
            System.out.println(data.toJSON());
        }
    }
}

