/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.logging;

import com.netscape.certsrv.logging.AuditClient;
import com.netscape.certsrv.logging.AuditFile;
import com.netscape.certsrv.logging.AuditFileCollection;
import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.logging.AuditCLI;
import java.util.Collection;
import org.apache.commons.cli.CommandLine;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditFileFindCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(AuditFileFindCLI.class);
    public AuditCLI auditCLI;

    public AuditFileFindCLI(AuditCLI auditCLI) {
        super("file-find", "Find audit files", (CLI)auditCLI);
        this.auditCLI = auditCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " [OPTIONS...]", this.options);
    }

    public void execute(CommandLine cmd) throws Exception {
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length > 0) {
            throw new Exception("Too many arguments specified.");
        }
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        AuditClient auditClient = this.auditCLI.getAuditClient();
        AuditFileCollection response = auditClient.findAuditFiles();
        MainCLI.printMessage(response.getTotal() + " entries matched");
        if (response.getTotal() == 0) {
            return;
        }
        Collection entries = response.getEntries();
        boolean first = true;
        for (AuditFile auditFile : entries) {
            if (first) {
                first = false;
            } else {
                System.out.println();
            }
            AuditCLI.printAuditFile(auditFile);
        }
        MainCLI.printMessage("Number of entries returned " + entries.size());
    }
}

