/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.certsrv.property;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.certsrv.util.JSONSerializer;
import java.util.Locale;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Descriptor
implements IDescriptor,
JSONSerializer {
    @JsonProperty(value="Syntax")
    public String mSyntax = null;
    @JsonProperty(value="Constraint")
    public String mConstraint = null;
    @JsonProperty(value="Description")
    public String mDescription = null;
    @JsonProperty(value="DefaultValue")
    public String mDef = null;

    public Descriptor() {
    }

    public Descriptor(String syntax, String constraint, String defValue, String description) {
        this.mSyntax = syntax;
        this.mConstraint = constraint;
        this.mDef = defValue;
        this.mDescription = description;
    }

    @Override
    @JsonIgnore
    public String getSyntax() {
        return this.mSyntax;
    }

    @Override
    @JsonIgnore
    public String getDefaultValue() {
        return this.mDef;
    }

    @Override
    @JsonIgnore
    public String getConstraint() {
        return this.mConstraint;
    }

    @Override
    @JsonIgnore
    public String getDescription(Locale locale) {
        return this.mDescription;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mConstraint == null ? 0 : this.mConstraint.hashCode());
        result = 31 * result + (this.mDef == null ? 0 : this.mDef.hashCode());
        result = 31 * result + (this.mDescription == null ? 0 : this.mDescription.hashCode());
        result = 31 * result + (this.mSyntax == null ? 0 : this.mSyntax.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Descriptor other = (Descriptor)obj;
        if (this.mConstraint == null ? other.mConstraint != null : !this.mConstraint.equals(other.mConstraint)) {
            return false;
        }
        if (this.mDef == null ? other.mDef != null : !this.mDef.equals(other.mDef)) {
            return false;
        }
        if (this.mDescription == null ? other.mDescription != null : !this.mDescription.equals(other.mDescription)) {
            return false;
        }
        return !(this.mSyntax == null ? other.mSyntax != null : !this.mSyntax.equals(other.mSyntax));
    }

    public void toDOM(Document document, Element element) {
        if (this.mSyntax != null) {
            Element syntaxElement = document.createElement("Syntax");
            syntaxElement.appendChild(document.createTextNode(this.mSyntax));
            element.appendChild(syntaxElement);
        }
        if (this.mConstraint != null) {
            Element constraintElement = document.createElement("Constraint");
            constraintElement.appendChild(document.createTextNode(this.mConstraint));
            element.appendChild(constraintElement);
        }
        if (this.mDescription != null) {
            Element descriptionElement = document.createElement("Description");
            descriptionElement.appendChild(document.createTextNode(this.mDescription));
            element.appendChild(descriptionElement);
        }
        if (this.mDef != null) {
            Element defaultValueElement = document.createElement("DefaultValue");
            defaultValueElement.appendChild(document.createTextNode(this.mDef));
            element.appendChild(defaultValueElement);
        }
    }

    public Element toDOM(Document document) {
        Element element = document.createElement("Descriptor");
        this.toDOM(document, element);
        return element;
    }

    public static Descriptor fromDOM(Element element) {
        NodeList defaultValueList;
        NodeList descriptionList;
        NodeList constraintList;
        Descriptor descriptor = new Descriptor();
        NodeList syntaxList = element.getElementsByTagName("Syntax");
        if (syntaxList.getLength() > 0) {
            descriptor.mSyntax = syntaxList.item(0).getTextContent();
        }
        if ((constraintList = element.getElementsByTagName("Constraint")).getLength() > 0) {
            descriptor.mConstraint = constraintList.item(0).getTextContent();
        }
        if ((descriptionList = element.getElementsByTagName("Description")).getLength() > 0) {
            descriptor.mDescription = descriptionList.item(0).getTextContent();
        }
        if ((defaultValueList = element.getElementsByTagName("DefaultValue")).getLength() > 0) {
            descriptor.mDef = defaultValueList.item(0).getTextContent();
        }
        return descriptor;
    }
}

