# This file is auto-generated by /codegen/x86_64.py
# Instruction data is based on package opcodes 0.3.14

import inspect

import peachpy.stream
import peachpy.x86_64.options
import peachpy.x86_64.isa
from peachpy.util import is_sint8, is_sint32
from peachpy.x86_64.encoding import rex, optional_rex, vex2, vex3, evex, modrm_sib_disp
from peachpy.x86_64.instructions import Instruction, BranchInstruction
from peachpy.x86_64.operand import is_al, is_ax, is_eax, is_rax, is_cl, is_xmm0, is_r8, is_r8rex, is_r16, is_r32, is_r64, \
    is_mm, is_xmm, is_ymm, is_m, is_m8, is_m16, is_m32, is_m64, is_m80, is_m128, is_m256, is_m512, \
    is_evex_xmm, is_xmmk, is_xmmkz, is_evex_ymm, is_ymmk, is_ymmkz, is_zmm, is_zmmk, is_zmmkz, is_k, is_kk, \
    is_m32k, is_m64k, is_m16kz, is_m32kz, is_m64kz, is_m128kz, is_m256kz, is_m512kz, \
    is_m64_m32bcst, is_m128_m32bcst, is_m256_m32bcst, is_m512_m32bcst, \
    is_m128_m64bcst, is_m256_m64bcst, is_m512_m64bcst, \
    is_vmx, is_vmy, is_evex_vmx, is_evex_vmy, is_vmz, is_vmxk, is_vmyk, is_vmzk, \
    is_imm, is_imm4, is_imm8, is_imm16, is_imm32, is_imm64, \
    is_rel8, is_rel32, is_label, is_er, is_sae, check_operand, format_operand_type


class VMOVSS(Instruction):
    """Move Scalar Single-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VMOVSS(xmm, m32)               [AVX]
            * VMOVSS(m32, xmm)               [AVX]
            * VMOVSS(xmm, xmm, xmm)          [AVX]
            * VMOVSS(m32{k}, xmm)            [AVX512F]
            * VMOVSS(xmm{k}{z}, m32)         [AVX512F]
            * VMOVSS(xmm{k}{z}, xmm, xmm)    [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VMOVSS, self).__init__("VMOVSS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 2:
            self.out_operands = (True, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_m32(self.operands[1]):
                self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(2, op[0].hcode, op[1].address, 0, vex3) + bytearray([0x10]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
                self.in_regs = (False, True)
                self.out_regs = (True, False)
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_m32(self.operands[0]) and is_xmm(self.operands[1]):
                self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(2, op[1].hcode, op[0].address, 0, vex3) + bytearray([0x11]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp)))
                self.in_regs = (True, True)
                self.out_regs = (False, False)
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_m32k(self.operands[0]) and is_evex_xmm(self.operands[1]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x06, 0b00, op[1].ehcode, op[0].address, aaa=op[0].kcode) + bytearray([0x11]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=4)))
                self.in_regs = (True, True)
                self.out_regs = (False, False)
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_m32(self.operands[1]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x06, 0b00, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x10]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=4)))
                self.in_regs = (False, True)
                self.out_regs = (True, False)
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VMOVSS " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 3:
            self.in_regs = (False, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x40, lambda op, vex3=False: vex2(2, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0x10, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.encodings.append((0x40, lambda op, vex3=False: vex2(2, op[2].hcode, op[0], op[1].hlcode, vex3) + bytearray([0x11, 0xC0 | op[2].lcode << 3 | op[0].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7E ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0x10, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[2].hcode << 7) | (op[0].ehcode << 5) | (op[2].ecode << 4)) ^ 241, 0x7E ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0x11, 0xC0 | op[2].lcode << 3 | op[0].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VMOVSS " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VMOVSS\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VEXTRACTPS(Instruction):
    """Extract Packed Single Precision Floating-Point Value"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VEXTRACTPS(r32/m32, xmm, imm8)    [AVX]
            * VEXTRACTPS(r32/m32, xmm, imm8)    [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VEXTRACTPS, self).__init__("VEXTRACTPS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"VEXTRACTPS\" requires 3 operands")
        self.out_operands = (True, False, False)
        self.avx_mode = True
        if is_r32(self.operands[0]) and is_xmm(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[1].hcode << 7) ^ (op[0].hcode << 5), 0x79, 0x17, 0xC0 | op[1].lcode << 3 | op[0].lcode, op[2] & 0xFF])))
            self.in_regs = (False, True, False)
            self.out_regs = (True, False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_m32(self.operands[0]) and is_xmm(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x01, op[1].hcode, op[0].address) + bytearray([0x17]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp) + bytearray([op[2] & 0xFF])))
            self.in_regs = (True, True, False)
            self.out_regs = (False, False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_r32(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[1].hcode << 7) | (op[0].ehcode << 5) | (op[1].ecode << 4)) ^ 243, 0x7D, 0x08, 0x17, 0xC0 | op[1].lcode << 3 | op[0].lcode, op[2] & 0xFF])))
            self.in_regs = (False, True, False)
            self.out_regs = (True, False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_m32(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b11, 0x05, 0b00, op[1].ehcode, op[0].address) + bytearray([0x17]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=4) + bytearray([op[2] & 0xFF])))
            self.in_regs = (True, True, False)
            self.out_regs = (False, False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: VEXTRACTPS " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VINSERTPS(Instruction):
    """Insert Packed Single Precision Floating-Point Value"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VINSERTPS(xmm, xmm, xmm/m32, imm8)    [AVX]
            * VINSERTPS(xmm, xmm, xmm/m32, imm8)    [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VINSERTPS, self).__init__("VINSERTPS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 4:
            raise SyntaxError("Instruction \"VINSERTPS\" requires 4 operands")
        self.in_regs = (False, True, True, False)
        self.out_regs = (True, False, False, False)
        self.out_operands = (True, False, False, False)
        self.avx_mode = True
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_imm(self.operands[3]):
            if not is_imm8(self.operands[3]):
                raise ValueError("Argument #3 can not be encoded as imm8")
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x79 ^ (op[1].hlcode << 3), 0x21, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3] & 0xFF])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m32(self.operands[2]) and is_imm(self.operands[3]):
            if not is_imm8(self.operands[3]):
                raise ValueError("Argument #3 can not be encoded as imm8")
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x01, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x21]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3] & 0xFF])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_evex_xmm(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]) and is_imm(self.operands[3]):
            if not is_imm8(self.operands[3]):
                raise ValueError("Argument #3 can not be encoded as imm8")
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 243, 0x7D ^ (op[1].hlcode << 3), (op[1].ecode << 3 ^ 0x8) | 0x00, 0x21, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3] & 0xFF])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_evex_xmm(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m32(self.operands[2]) and is_imm(self.operands[3]):
            if not is_imm8(self.operands[3]):
                raise ValueError("Argument #3 can not be encoded as imm8")
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b11, 0x05, 0b00, op[0].ehcode, op[2].address, op[1].code) + bytearray([0x21]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=4) + bytearray([op[3] & 0xFF])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: VINSERTPS " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VADDSS(Instruction):
    """Add Scalar Single-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VADDSS(xmm, xmm, xmm/m32)            [AVX]
            * VADDSS(xmm{k}{z}, xmm, xmm/m32)      [AVX512F]
            * VADDSS(xmm{k}{z}, xmm, xmm, {er})    [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VADDSS, self).__init__("VADDSS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (False, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x40, lambda op, vex3=False: vex2(2, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0x58, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m32(self.operands[2]):
                self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(2, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0x58]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m32(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x06, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x58]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=4)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7E ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x58, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VADDSS " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7E ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0x58, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (False, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VADDSS " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VADDSS\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VSUBSS(Instruction):
    """Subtract Scalar Single-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VSUBSS(xmm, xmm, xmm/m32)            [AVX]
            * VSUBSS(xmm{k}{z}, xmm, xmm/m32)      [AVX512F]
            * VSUBSS(xmm{k}{z}, xmm, xmm, {er})    [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VSUBSS, self).__init__("VSUBSS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (False, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x40, lambda op, vex3=False: vex2(2, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0x5C, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m32(self.operands[2]):
                self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(2, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0x5C]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m32(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x06, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x5C]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=4)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7E ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x5C, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VSUBSS " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7E ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0x5C, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (False, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VSUBSS " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VSUBSS\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VMULSS(Instruction):
    """Multiply Scalar Single-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VMULSS(xmm, xmm, xmm/m32)            [AVX]
            * VMULSS(xmm{k}{z}, xmm, xmm/m32)      [AVX512F]
            * VMULSS(xmm{k}{z}, xmm, xmm, {er})    [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VMULSS, self).__init__("VMULSS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (False, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x40, lambda op, vex3=False: vex2(2, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0x59, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m32(self.operands[2]):
                self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(2, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0x59]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m32(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x06, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x59]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=4)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7E ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x59, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VMULSS " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7E ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0x59, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (False, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VMULSS " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VMULSS\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VDIVSS(Instruction):
    """Divide Scalar Single-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VDIVSS(xmm, xmm, xmm/m32)            [AVX]
            * VDIVSS(xmm{k}{z}, xmm, xmm/m32)      [AVX512F]
            * VDIVSS(xmm{k}{z}, xmm, xmm, {er})    [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VDIVSS, self).__init__("VDIVSS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (False, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x40, lambda op, vex3=False: vex2(2, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0x5E, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m32(self.operands[2]):
                self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(2, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0x5E]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m32(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x06, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x5E]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=4)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7E ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x5E, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VDIVSS " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7E ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0x5E, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (False, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VDIVSS " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VDIVSS\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VSQRTSS(Instruction):
    """Compute Square Root of Scalar Single-Precision Floating-Point Value"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VSQRTSS(xmm, xmm, xmm/m32)            [AVX]
            * VSQRTSS(xmm{k}{z}, xmm, xmm/m32)      [AVX512F]
            * VSQRTSS(xmm{k}{z}, xmm, xmm, {er})    [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VSQRTSS, self).__init__("VSQRTSS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (False, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x40, lambda op, vex3=False: vex2(2, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0x51, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m32(self.operands[2]):
                self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(2, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0x51]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m32(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x06, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x51]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=4)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7E ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x51, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VSQRTSS " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7E ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0x51, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (False, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VSQRTSS " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VSQRTSS\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VROUNDSS(Instruction):
    """Round Scalar Single Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VROUNDSS(xmm, xmm, xmm/m32, imm8)    [AVX]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VROUNDSS, self).__init__("VROUNDSS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 4:
            raise SyntaxError("Instruction \"VROUNDSS\" requires 4 operands")
        self.in_regs = (False, True, True, False)
        self.out_regs = (True, False, False, False)
        self.out_operands = (True, False, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_imm(self.operands[3]):
            if not is_imm8(self.operands[3]):
                raise ValueError("Argument #3 can not be encoded as imm8")
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x79 ^ (op[1].hlcode << 3), 0x0A, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3] & 0xFF])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m32(self.operands[2]) and is_imm(self.operands[3]):
            if not is_imm8(self.operands[3]):
                raise ValueError("Argument #3 can not be encoded as imm8")
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x01, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x0A]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3] & 0xFF])))
        else:
            raise SyntaxError("Invalid operand types: VROUNDSS " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VRNDSCALESS(Instruction):
    """Round Scalar Single-Precision Floating-Point Value To Include A Given Number Of Fraction Bits"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VRNDSCALESS(xmm{k}{z}, xmm, xmm/m32, imm8)       [AVX512F]
            * VRNDSCALESS(xmm{k}{z}, xmm, xmm, {sae}, imm8)    [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VRNDSCALESS, self).__init__("VRNDSCALESS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 4:
            self.in_regs = (False, True, True, False)
            self.out_regs = (True, False, False, False)
            self.out_operands = (True, False, False, False)
            self.avx_mode = True
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            if is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m32(self.operands[2]) and is_imm(self.operands[3]):
                if not is_imm8(self.operands[3]):
                    raise ValueError("Argument #3 can not be encoded as imm8")
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b11, 0x05, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x0A]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=4) + bytearray([op[3] & 0xFF])))
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]) and is_imm(self.operands[3]):
                if not is_imm8(self.operands[3]):
                    raise ValueError("Argument #3 can not be encoded as imm8")
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 243, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x0A, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3] & 0xFF])))
            else:
                raise SyntaxError("Invalid operand types: VRNDSCALESS " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 5:
            if is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]) and is_sae(self.operands[3]) and is_imm(self.operands[4]):
                if not is_imm8(self.operands[4]):
                    raise ValueError("Argument #4 can not be encoded as imm8")
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 243, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0x0A, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[4] & 0xFF])))
                self.in_regs = (False, True, True, False, False)
                self.out_regs = (True, False, False, False, False)
                self.out_operands = (True, False, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VRNDSCALESS " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VRNDSCALESS\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VRANGESS(Instruction):
    """Range Restriction Calculation For a pair of Scalar Single-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VRANGESS(xmm{k}{z}, xmm, xmm/m32, imm8)       [AVX512DQ]
            * VRANGESS(xmm{k}{z}, xmm, xmm, {sae}, imm8)    [AVX512DQ]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VRANGESS, self).__init__("VRANGESS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 4:
            self.in_regs = (False, True, True, False)
            self.out_regs = (True, False, False, False)
            self.out_operands = (True, False, False, False)
            self.avx_mode = True
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512dq])
            if is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m32(self.operands[2]) and is_imm(self.operands[3]):
                if not is_imm8(self.operands[3]):
                    raise ValueError("Argument #3 can not be encoded as imm8")
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b11, 0x05, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x51]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=4) + bytearray([op[3] & 0xFF])))
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]) and is_imm(self.operands[3]):
                if not is_imm8(self.operands[3]):
                    raise ValueError("Argument #3 can not be encoded as imm8")
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 243, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x51, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3] & 0xFF])))
            else:
                raise SyntaxError("Invalid operand types: VRANGESS " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 5:
            if is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]) and is_sae(self.operands[3]) and is_imm(self.operands[4]):
                if not is_imm8(self.operands[4]):
                    raise ValueError("Argument #4 can not be encoded as imm8")
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 243, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0x51, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[4] & 0xFF])))
                self.in_regs = (False, True, True, False, False)
                self.out_regs = (True, False, False, False, False)
                self.out_operands = (True, False, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512dq])
            else:
                raise SyntaxError("Invalid operand types: VRANGESS " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VRANGESS\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VMINSS(Instruction):
    """Return Minimum Scalar Single-Precision Floating-Point Value"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VMINSS(xmm, xmm, xmm/m32)             [AVX]
            * VMINSS(xmm{k}{z}, xmm, xmm/m32)       [AVX512F]
            * VMINSS(xmm{k}{z}, xmm, xmm, {sae})    [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VMINSS, self).__init__("VMINSS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (False, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x40, lambda op, vex3=False: vex2(2, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0x5D, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m32(self.operands[2]):
                self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(2, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0x5D]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m32(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x06, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x5D]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=4)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7E ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x5D, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VMINSS " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]) and is_sae(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7E ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0x5D, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (False, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VMINSS " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VMINSS\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VMAXSS(Instruction):
    """Return Maximum Scalar Single-Precision Floating-Point Value"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VMAXSS(xmm, xmm, xmm/m32)             [AVX]
            * VMAXSS(xmm{k}{z}, xmm, xmm/m32)       [AVX512F]
            * VMAXSS(xmm{k}{z}, xmm, xmm, {sae})    [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VMAXSS, self).__init__("VMAXSS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (False, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x40, lambda op, vex3=False: vex2(2, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0x5F, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m32(self.operands[2]):
                self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(2, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0x5F]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m32(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x06, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x5F]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=4)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7E ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x5F, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VMAXSS " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]) and is_sae(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7E ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0x5F, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (False, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VMAXSS " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VMAXSS\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VREDUCESS(Instruction):
    """Perform Reduction Transformation on a Scalar Single-Precision Floating-Point Value"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VREDUCESS(xmm{k}{z}, xmm, xmm/m32, imm8)    [AVX512DQ]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VREDUCESS, self).__init__("VREDUCESS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 4:
            raise SyntaxError("Instruction \"VREDUCESS\" requires 4 operands")
        self.in_regs = (False, True, True, False)
        self.out_regs = (True, False, False, False)
        self.out_operands = (True, False, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512dq])
        if is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]) and is_imm(self.operands[3]):
            if not is_imm8(self.operands[3]):
                raise ValueError("Argument #3 can not be encoded as imm8")
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 243, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0x57, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3] & 0xFF])))
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m32(self.operands[2]) and is_imm(self.operands[3]):
            if not is_imm8(self.operands[3]):
                raise ValueError("Argument #3 can not be encoded as imm8")
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b11, 0x05, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x57]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=4) + bytearray([op[3] & 0xFF])))
        else:
            raise SyntaxError("Invalid operand types: VREDUCESS " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VGETMANTSS(Instruction):
    """Extract Normalized Mantissa from Scalar Single-Precision Floating-Point Value"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VGETMANTSS(xmm{k}{z}, xmm, xmm/m32, imm8)       [AVX512F]
            * VGETMANTSS(xmm{k}{z}, xmm, xmm, {sae}, imm8)    [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VGETMANTSS, self).__init__("VGETMANTSS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 4:
            self.in_regs = (False, True, True, False)
            self.out_regs = (True, False, False, False)
            self.out_operands = (True, False, False, False)
            self.avx_mode = True
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            if is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m32(self.operands[2]) and is_imm(self.operands[3]):
                if not is_imm8(self.operands[3]):
                    raise ValueError("Argument #3 can not be encoded as imm8")
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b11, 0x05, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x27]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=4) + bytearray([op[3] & 0xFF])))
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]) and is_imm(self.operands[3]):
                if not is_imm8(self.operands[3]):
                    raise ValueError("Argument #3 can not be encoded as imm8")
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 243, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x27, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3] & 0xFF])))
            else:
                raise SyntaxError("Invalid operand types: VGETMANTSS " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 5:
            if is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]) and is_sae(self.operands[3]) and is_imm(self.operands[4]):
                if not is_imm8(self.operands[4]):
                    raise ValueError("Argument #4 can not be encoded as imm8")
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 243, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0x27, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[4] & 0xFF])))
                self.in_regs = (False, True, True, False, False)
                self.out_regs = (True, False, False, False, False)
                self.out_operands = (True, False, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VGETMANTSS " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VGETMANTSS\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VGETEXPSS(Instruction):
    """Extract Exponent of Scalar Single-Precision Floating-Point Value as Single-Precision Floating-Point Value"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VGETEXPSS(xmm{k}{z}, xmm, xmm/m32)       [AVX512F]
            * VGETEXPSS(xmm{k}{z}, xmm, xmm, {sae})    [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VGETEXPSS, self).__init__("VGETEXPSS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (False, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            if is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m32(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x43]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=4)))
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x43, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            else:
                raise SyntaxError("Invalid operand types: VGETEXPSS " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]) and is_sae(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0x43, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (False, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VGETEXPSS " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VGETEXPSS\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VSCALEFSS(Instruction):
    """Scale Scalar Single-Precision Floating-Point Value With a Single-Precision Floating-Point Value"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VSCALEFSS(xmm{k}{z}, xmm, xmm/m32)      [AVX512F]
            * VSCALEFSS(xmm{k}{z}, xmm, xmm, {er})    [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VSCALEFSS, self).__init__("VSCALEFSS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (False, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            if is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m32(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x2D]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=4)))
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x2D, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            else:
                raise SyntaxError("Invalid operand types: VSCALEFSS " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0x2D, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (False, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VSCALEFSS " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VSCALEFSS\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFIXUPIMMSS(Instruction):
    """Fix Up Special Scalar Single-Precision Floating-Point Value"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFIXUPIMMSS(xmm{k}{z}, xmm, xmm/m32, imm8)       [AVX512F]
            * VFIXUPIMMSS(xmm{k}{z}, xmm, xmm, {sae}, imm8)    [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFIXUPIMMSS, self).__init__("VFIXUPIMMSS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 4:
            self.in_regs = (True, True, True, False)
            self.out_regs = (True, False, False, False)
            self.out_operands = (True, False, False, False)
            self.avx_mode = True
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            if is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m32(self.operands[2]) and is_imm(self.operands[3]):
                if not is_imm8(self.operands[3]):
                    raise ValueError("Argument #3 can not be encoded as imm8")
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b11, 0x05, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x55]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=4) + bytearray([op[3] & 0xFF])))
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]) and is_imm(self.operands[3]):
                if not is_imm8(self.operands[3]):
                    raise ValueError("Argument #3 can not be encoded as imm8")
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 243, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x55, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3] & 0xFF])))
            else:
                raise SyntaxError("Invalid operand types: VFIXUPIMMSS " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 5:
            if is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]) and is_sae(self.operands[3]) and is_imm(self.operands[4]):
                if not is_imm8(self.operands[4]):
                    raise ValueError("Argument #4 can not be encoded as imm8")
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 243, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0x55, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[4] & 0xFF])))
                self.in_regs = (True, True, True, False, False)
                self.out_regs = (True, False, False, False, False)
                self.out_operands = (True, False, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFIXUPIMMSS " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VFIXUPIMMSS\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFPCLASSSS(Instruction):
    """Test Class of Scalar Single-Precision Floating-Point Value"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFPCLASSSS(k{k}, xmm/m32, imm8)    [AVX512DQ]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFPCLASSSS, self).__init__("VFPCLASSSS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"VFPCLASSSS\" requires 3 operands")
        self.in_regs = (False, True, False)
        self.out_regs = (True, False, False)
        self.out_operands = (True, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512dq])
        if is_kk(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 243, 0x7D, op[0].kcode | 0x08, 0x67, 0xC0 | op[0].lcode << 3 | op[1].lcode, op[2] & 0xFF])))
        elif is_kk(self.operands[0]) and is_m32(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b11, 0x05, 0b00, op[0].ehcode, op[1].address, aaa=op[0].kcode) + bytearray([0x67]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=4) + bytearray([op[2] & 0xFF])))
        else:
            raise SyntaxError("Invalid operand types: VFPCLASSSS " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VRCPSS(Instruction):
    """Compute Approximate Reciprocal of Scalar Single-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VRCPSS(xmm, xmm, xmm/m32)    [AVX]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VRCPSS, self).__init__("VRCPSS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"VRCPSS\" requires 3 operands")
        self.in_regs = (False, True, True)
        self.out_regs = (True, False, False)
        self.out_operands = (True, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(2, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0x53, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m32(self.operands[2]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(2, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0x53]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
        else:
            raise SyntaxError("Invalid operand types: VRCPSS " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VRSQRTSS(Instruction):
    """Compute Reciprocal of Square Root of Scalar Single-Precision Floating-Point Value"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VRSQRTSS(xmm, xmm, xmm/m32)    [AVX]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VRSQRTSS, self).__init__("VRSQRTSS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"VRSQRTSS\" requires 3 operands")
        self.in_regs = (False, True, True)
        self.out_regs = (True, False, False)
        self.out_operands = (True, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(2, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0x52, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m32(self.operands[2]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(2, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0x52]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
        else:
            raise SyntaxError("Invalid operand types: VRSQRTSS " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VRCP14SS(Instruction):
    """Compute Approximate Reciprocal of a Scalar Single-Precision Floating-Point Value"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VRCP14SS(xmm{k}{z}, xmm, xmm/m32)    [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VRCP14SS, self).__init__("VRCP14SS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"VRCP14SS\" requires 3 operands")
        self.in_regs = (False, True, True)
        self.out_regs = (True, False, False)
        self.out_operands = (True, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        if is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0x4D, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m32(self.operands[2]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x4D]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=4)))
        else:
            raise SyntaxError("Invalid operand types: VRCP14SS " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VRSQRT14SS(Instruction):
    """Compute Approximate Reciprocal of a Square Root of a Scalar Single-Precision Floating-Point Value"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VRSQRT14SS(xmm{k}{z}, xmm, xmm/m32)    [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VRSQRT14SS, self).__init__("VRSQRT14SS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"VRSQRT14SS\" requires 3 operands")
        self.in_regs = (False, True, True)
        self.out_regs = (True, False, False)
        self.out_operands = (True, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        if is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0x4F, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m32(self.operands[2]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x4F]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=4)))
        else:
            raise SyntaxError("Invalid operand types: VRSQRT14SS " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VRCP28SS(Instruction):
    """Approximation to the Reciprocal of a Scalar Single-Precision Floating-Point Value with Less Than 2^-28 Relative Error"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VRCP28SS(xmm{k}{z}, xmm, xmm/m32)       [AVX512ER]
            * VRCP28SS(xmm{k}{z}, xmm, xmm, {sae})    [AVX512ER]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VRCP28SS, self).__init__("VRCP28SS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (False, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512er])
            if is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m32(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0xCB]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=4)))
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0xCB, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            else:
                raise SyntaxError("Invalid operand types: VRCP28SS " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]) and is_sae(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0xCB, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (False, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512er])
            else:
                raise SyntaxError("Invalid operand types: VRCP28SS " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VRCP28SS\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VRSQRT28SS(Instruction):
    """Approximation to the Reciprocal Square Root of a Scalar Single-Precision Floating-Point Value with Less Than 2^-28 Relative Error"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VRSQRT28SS(xmm{k}{z}, xmm, xmm/m32)       [AVX512ER]
            * VRSQRT28SS(xmm{k}{z}, xmm, xmm, {sae})    [AVX512ER]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VRSQRT28SS, self).__init__("VRSQRT28SS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (False, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512er])
            if is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m32(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0xCD]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=4)))
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0xCD, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            else:
                raise SyntaxError("Invalid operand types: VRSQRT28SS " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]) and is_sae(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0xCD, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (False, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512er])
            else:
                raise SyntaxError("Invalid operand types: VRSQRT28SS " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VRSQRT28SS\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VCMPSS(Instruction):
    """Compare Scalar Single-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VCMPSS(xmm, xmm, xmm/m32, imm8)        [AVX]
            * VCMPSS(k{k}, xmm, xmm/m32, imm8)       [AVX512F]
            * VCMPSS(k{k}, xmm, xmm, {sae}, imm8)    [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VCMPSS, self).__init__("VCMPSS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 4:
            self.in_regs = (False, True, True, False)
            self.out_regs = (True, False, False, False)
            self.out_operands = (True, False, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_imm(self.operands[3]):
                if not is_imm8(self.operands[3]):
                    raise ValueError("Argument #3 can not be encoded as imm8")
                self.encodings.append((0x40, lambda op, vex3=False: vex2(2, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0xC2, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3] & 0xFF])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m32(self.operands[2]) and is_imm(self.operands[3]):
                if not is_imm8(self.operands[3]):
                    raise ValueError("Argument #3 can not be encoded as imm8")
                self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(2, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0xC2]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3] & 0xFF])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_kk(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m32(self.operands[2]) and is_imm(self.operands[3]):
                if not is_imm8(self.operands[3]):
                    raise ValueError("Argument #3 can not be encoded as imm8")
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x06, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode) + bytearray([0xC2]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=4) + bytearray([op[3] & 0xFF])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_kk(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]) and is_imm(self.operands[3]):
                if not is_imm8(self.operands[3]):
                    raise ValueError("Argument #3 can not be encoded as imm8")
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7E ^ (op[1].hlcode << 3), (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0xC2, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3] & 0xFF])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VCMPSS " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 5:
            if is_kk(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]) and is_sae(self.operands[3]) and is_imm(self.operands[4]):
                if not is_imm8(self.operands[4]):
                    raise ValueError("Argument #4 can not be encoded as imm8")
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7E ^ (op[1].hlcode << 3), (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0xC2, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[4] & 0xFF])))
                self.in_regs = (False, True, True, False, False)
                self.out_regs = (True, False, False, False, False)
                self.out_operands = (True, False, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VCMPSS " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VCMPSS\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VCOMISS(Instruction):
    """Compare Scalar Ordered Single-Precision Floating-Point Values and Set EFLAGS"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VCOMISS(xmm, xmm/m32)       [AVX]
            * VCOMISS(xmm, xmm/m32)       [AVX512F]
            * VCOMISS(xmm, xmm, {sae})    [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VCOMISS, self).__init__("VCOMISS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 2:
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.out_operands = (False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]):
                self.encodings.append((0x40, lambda op, vex3=False: vex2(0, op[0].hcode, op[1], 0, vex3) + bytearray([0x2F, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_xmm(self.operands[0]) and is_m32(self.operands[1]):
                self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(0, op[0].hcode, op[1].address, 0, vex3) + bytearray([0x2F]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_evex_xmm(self.operands[0]) and is_m32(self.operands[1]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x04, 0b00, op[0].ehcode, op[1].address) + bytearray([0x2F]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=4)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_evex_xmm(self.operands[0]) and is_evex_xmm(self.operands[1]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7C, 0x48, 0x2F, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VCOMISS " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 3:
            if is_evex_xmm(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_sae(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7C, 0x18, 0x2F, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
                self.in_regs = (True, True, False)
                self.out_regs = (False, False, False)
                self.out_operands = (False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VCOMISS " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VCOMISS\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VUCOMISS(Instruction):
    """Unordered Compare Scalar Single-Precision Floating-Point Values and Set EFLAGS"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VUCOMISS(xmm, xmm/m32)       [AVX]
            * VUCOMISS(xmm, xmm/m32)       [AVX512F]
            * VUCOMISS(xmm, xmm, {sae})    [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VUCOMISS, self).__init__("VUCOMISS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 2:
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.out_operands = (False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]):
                self.encodings.append((0x40, lambda op, vex3=False: vex2(0, op[0].hcode, op[1], 0, vex3) + bytearray([0x2E, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_xmm(self.operands[0]) and is_m32(self.operands[1]):
                self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(0, op[0].hcode, op[1].address, 0, vex3) + bytearray([0x2E]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_evex_xmm(self.operands[0]) and is_m32(self.operands[1]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x04, 0b00, op[0].ehcode, op[1].address) + bytearray([0x2E]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=4)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_evex_xmm(self.operands[0]) and is_evex_xmm(self.operands[1]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7C, 0x48, 0x2E, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VUCOMISS " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 3:
            if is_evex_xmm(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_sae(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7C, 0x18, 0x2E, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
                self.in_regs = (True, True, False)
                self.out_regs = (False, False, False)
                self.out_operands = (False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VUCOMISS " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VUCOMISS\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VMOVSD(Instruction):
    """Move Scalar Double-Precision Floating-Point Value"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VMOVSD(xmm, m64)               [AVX]
            * VMOVSD(m64, xmm)               [AVX]
            * VMOVSD(xmm, xmm, xmm)          [AVX]
            * VMOVSD(m64{k}, xmm)            [AVX512F]
            * VMOVSD(xmm{k}{z}, m64)         [AVX512F]
            * VMOVSD(xmm{k}{z}, xmm, xmm)    [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VMOVSD, self).__init__("VMOVSD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 2:
            self.out_operands = (True, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_m64(self.operands[1]):
                self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(3, op[0].hcode, op[1].address, 0, vex3) + bytearray([0x10]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
                self.in_regs = (False, True)
                self.out_regs = (True, False)
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_m64(self.operands[0]) and is_xmm(self.operands[1]):
                self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(3, op[1].hcode, op[0].address, 0, vex3) + bytearray([0x11]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp)))
                self.in_regs = (True, True)
                self.out_regs = (False, False)
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_m64k(self.operands[0]) and is_evex_xmm(self.operands[1]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x87, 0b00, op[1].ehcode, op[0].address, aaa=op[0].kcode) + bytearray([0x11]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=8)))
                self.in_regs = (True, True)
                self.out_regs = (False, False)
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_m64(self.operands[1]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x87, 0b00, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x10]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=8)))
                self.in_regs = (False, True)
                self.out_regs = (True, False)
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VMOVSD " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 3:
            self.in_regs = (False, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x40, lambda op, vex3=False: vex2(3, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0x10, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.encodings.append((0x40, lambda op, vex3=False: vex2(3, op[2].hcode, op[0], op[1].hlcode, vex3) + bytearray([0x11, 0xC0 | op[2].lcode << 3 | op[0].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFF ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0x10, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[2].hcode << 7) | (op[0].ehcode << 5) | (op[2].ecode << 4)) ^ 241, 0xFF ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0x11, 0xC0 | op[2].lcode << 3 | op[0].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VMOVSD " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VMOVSD\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VADDSD(Instruction):
    """Add Scalar Double-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VADDSD(xmm, xmm, xmm/m64)            [AVX]
            * VADDSD(xmm{k}{z}, xmm, xmm/m64)      [AVX512F]
            * VADDSD(xmm{k}{z}, xmm, xmm, {er})    [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VADDSD, self).__init__("VADDSD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (False, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x40, lambda op, vex3=False: vex2(3, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0x58, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m64(self.operands[2]):
                self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(3, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0x58]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m64(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x87, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x58]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=8)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFF ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x58, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VADDSD " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFF ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0x58, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (False, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VADDSD " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VADDSD\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VSUBSD(Instruction):
    """Subtract Scalar Double-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VSUBSD(xmm, xmm, xmm/m64)            [AVX]
            * VSUBSD(xmm{k}{z}, xmm, xmm/m64)      [AVX512F]
            * VSUBSD(xmm{k}{z}, xmm, xmm, {er})    [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VSUBSD, self).__init__("VSUBSD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (False, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x40, lambda op, vex3=False: vex2(3, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0x5C, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m64(self.operands[2]):
                self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(3, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0x5C]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m64(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x87, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x5C]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=8)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFF ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x5C, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VSUBSD " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFF ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0x5C, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (False, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VSUBSD " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VSUBSD\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VMULSD(Instruction):
    """Multiply Scalar Double-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VMULSD(xmm, xmm, xmm/m64)            [AVX]
            * VMULSD(xmm{k}{z}, xmm, xmm/m64)      [AVX512F]
            * VMULSD(xmm{k}{z}, xmm, xmm, {er})    [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VMULSD, self).__init__("VMULSD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (False, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x40, lambda op, vex3=False: vex2(3, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0x59, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m64(self.operands[2]):
                self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(3, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0x59]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m64(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x87, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x59]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=8)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFF ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x59, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VMULSD " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFF ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0x59, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (False, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VMULSD " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VMULSD\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VDIVSD(Instruction):
    """Divide Scalar Double-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VDIVSD(xmm, xmm, xmm/m64)            [AVX]
            * VDIVSD(xmm{k}{z}, xmm, xmm/m64)      [AVX512F]
            * VDIVSD(xmm{k}{z}, xmm, xmm, {er})    [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VDIVSD, self).__init__("VDIVSD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (False, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x40, lambda op, vex3=False: vex2(3, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0x5E, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m64(self.operands[2]):
                self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(3, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0x5E]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m64(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x87, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x5E]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=8)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFF ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x5E, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VDIVSD " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFF ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0x5E, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (False, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VDIVSD " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VDIVSD\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VSQRTSD(Instruction):
    """Compute Square Root of Scalar Double-Precision Floating-Point Value"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VSQRTSD(xmm, xmm, xmm/m64)            [AVX]
            * VSQRTSD(xmm{k}{z}, xmm, xmm/m64)      [AVX512F]
            * VSQRTSD(xmm{k}{z}, xmm, xmm, {er})    [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VSQRTSD, self).__init__("VSQRTSD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (False, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x40, lambda op, vex3=False: vex2(3, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0x51, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m64(self.operands[2]):
                self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(3, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0x51]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m64(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x87, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x51]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=8)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFF ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x51, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VSQRTSD " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFF ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0x51, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (False, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VSQRTSD " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VSQRTSD\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VROUNDSD(Instruction):
    """Round Scalar Double Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VROUNDSD(xmm, xmm, xmm/m64, imm8)    [AVX]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VROUNDSD, self).__init__("VROUNDSD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 4:
            raise SyntaxError("Instruction \"VROUNDSD\" requires 4 operands")
        self.in_regs = (False, True, True, False)
        self.out_regs = (True, False, False, False)
        self.out_operands = (True, False, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_imm(self.operands[3]):
            if not is_imm8(self.operands[3]):
                raise ValueError("Argument #3 can not be encoded as imm8")
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x79 ^ (op[1].hlcode << 3), 0x0B, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3] & 0xFF])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m64(self.operands[2]) and is_imm(self.operands[3]):
            if not is_imm8(self.operands[3]):
                raise ValueError("Argument #3 can not be encoded as imm8")
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x01, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x0B]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3] & 0xFF])))
        else:
            raise SyntaxError("Invalid operand types: VROUNDSD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VRNDSCALESD(Instruction):
    """Round Scalar Double-Precision Floating-Point Value To Include A Given Number Of Fraction Bits"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VRNDSCALESD(xmm{k}{z}, xmm, xmm/m64, imm8)       [AVX512F]
            * VRNDSCALESD(xmm{k}{z}, xmm, xmm, {sae}, imm8)    [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VRNDSCALESD, self).__init__("VRNDSCALESD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 4:
            self.in_regs = (False, True, True, False)
            self.out_regs = (True, False, False, False)
            self.out_operands = (True, False, False, False)
            self.avx_mode = True
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            if is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m64(self.operands[2]) and is_imm(self.operands[3]):
                if not is_imm8(self.operands[3]):
                    raise ValueError("Argument #3 can not be encoded as imm8")
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b11, 0x85, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x0B]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=8) + bytearray([op[3] & 0xFF])))
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]) and is_imm(self.operands[3]):
                if not is_imm8(self.operands[3]):
                    raise ValueError("Argument #3 can not be encoded as imm8")
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 243, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x0B, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3] & 0xFF])))
            else:
                raise SyntaxError("Invalid operand types: VRNDSCALESD " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 5:
            if is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]) and is_sae(self.operands[3]) and is_imm(self.operands[4]):
                if not is_imm8(self.operands[4]):
                    raise ValueError("Argument #4 can not be encoded as imm8")
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 243, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0x0B, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[4] & 0xFF])))
                self.in_regs = (False, True, True, False, False)
                self.out_regs = (True, False, False, False, False)
                self.out_operands = (True, False, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VRNDSCALESD " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VRNDSCALESD\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VRANGESD(Instruction):
    """Range Restriction Calculation For a pair of Scalar Double-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VRANGESD(xmm{k}{z}, xmm, xmm/m64, imm8)       [AVX512DQ]
            * VRANGESD(xmm{k}{z}, xmm, xmm, {sae}, imm8)    [AVX512DQ]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VRANGESD, self).__init__("VRANGESD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 4:
            self.in_regs = (False, True, True, False)
            self.out_regs = (True, False, False, False)
            self.out_operands = (True, False, False, False)
            self.avx_mode = True
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512dq])
            if is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m64(self.operands[2]) and is_imm(self.operands[3]):
                if not is_imm8(self.operands[3]):
                    raise ValueError("Argument #3 can not be encoded as imm8")
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b11, 0x85, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x51]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=8) + bytearray([op[3] & 0xFF])))
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]) and is_imm(self.operands[3]):
                if not is_imm8(self.operands[3]):
                    raise ValueError("Argument #3 can not be encoded as imm8")
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 243, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x51, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3] & 0xFF])))
            else:
                raise SyntaxError("Invalid operand types: VRANGESD " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 5:
            if is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]) and is_sae(self.operands[3]) and is_imm(self.operands[4]):
                if not is_imm8(self.operands[4]):
                    raise ValueError("Argument #4 can not be encoded as imm8")
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 243, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0x51, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[4] & 0xFF])))
                self.in_regs = (False, True, True, False, False)
                self.out_regs = (True, False, False, False, False)
                self.out_operands = (True, False, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512dq])
            else:
                raise SyntaxError("Invalid operand types: VRANGESD " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VRANGESD\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VMINSD(Instruction):
    """Return Minimum Scalar Double-Precision Floating-Point Value"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VMINSD(xmm, xmm, xmm/m64)             [AVX]
            * VMINSD(xmm{k}{z}, xmm, xmm/m64)       [AVX512F]
            * VMINSD(xmm{k}{z}, xmm, xmm, {sae})    [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VMINSD, self).__init__("VMINSD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (False, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x40, lambda op, vex3=False: vex2(3, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0x5D, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m64(self.operands[2]):
                self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(3, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0x5D]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m64(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x87, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x5D]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=8)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFF ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x5D, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VMINSD " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]) and is_sae(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFF ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0x5D, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (False, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VMINSD " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VMINSD\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VMAXSD(Instruction):
    """Return Maximum Scalar Double-Precision Floating-Point Value"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VMAXSD(xmm, xmm, xmm/m64)             [AVX]
            * VMAXSD(xmm{k}{z}, xmm, xmm/m64)       [AVX512F]
            * VMAXSD(xmm{k}{z}, xmm, xmm, {sae})    [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VMAXSD, self).__init__("VMAXSD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (False, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x40, lambda op, vex3=False: vex2(3, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0x5F, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m64(self.operands[2]):
                self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(3, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0x5F]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m64(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x87, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x5F]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=8)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFF ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x5F, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VMAXSD " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]) and is_sae(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFF ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0x5F, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (False, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VMAXSD " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VMAXSD\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VREDUCESD(Instruction):
    """Perform Reduction Transformation on a Scalar Double-Precision Floating-Point Value"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VREDUCESD(xmm{k}{z}, xmm, xmm/m64, imm8)    [AVX512DQ]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VREDUCESD, self).__init__("VREDUCESD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 4:
            raise SyntaxError("Instruction \"VREDUCESD\" requires 4 operands")
        self.in_regs = (False, True, True, False)
        self.out_regs = (True, False, False, False)
        self.out_operands = (True, False, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512dq])
        if is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]) and is_imm(self.operands[3]):
            if not is_imm8(self.operands[3]):
                raise ValueError("Argument #3 can not be encoded as imm8")
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 243, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0x57, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3] & 0xFF])))
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m64(self.operands[2]) and is_imm(self.operands[3]):
            if not is_imm8(self.operands[3]):
                raise ValueError("Argument #3 can not be encoded as imm8")
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b11, 0x85, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x57]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=8) + bytearray([op[3] & 0xFF])))
        else:
            raise SyntaxError("Invalid operand types: VREDUCESD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VGETMANTSD(Instruction):
    """Extract Normalized Mantissa from Scalar Double-Precision Floating-Point Value"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VGETMANTSD(xmm{k}{z}, xmm, xmm/m64, imm8)       [AVX512F]
            * VGETMANTSD(xmm{k}{z}, xmm, xmm, {sae}, imm8)    [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VGETMANTSD, self).__init__("VGETMANTSD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 4:
            self.in_regs = (False, True, True, False)
            self.out_regs = (True, False, False, False)
            self.out_operands = (True, False, False, False)
            self.avx_mode = True
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            if is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m64(self.operands[2]) and is_imm(self.operands[3]):
                if not is_imm8(self.operands[3]):
                    raise ValueError("Argument #3 can not be encoded as imm8")
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b11, 0x85, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x27]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=8) + bytearray([op[3] & 0xFF])))
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]) and is_imm(self.operands[3]):
                if not is_imm8(self.operands[3]):
                    raise ValueError("Argument #3 can not be encoded as imm8")
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 243, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x27, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3] & 0xFF])))
            else:
                raise SyntaxError("Invalid operand types: VGETMANTSD " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 5:
            if is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]) and is_sae(self.operands[3]) and is_imm(self.operands[4]):
                if not is_imm8(self.operands[4]):
                    raise ValueError("Argument #4 can not be encoded as imm8")
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 243, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0x27, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[4] & 0xFF])))
                self.in_regs = (False, True, True, False, False)
                self.out_regs = (True, False, False, False, False)
                self.out_operands = (True, False, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VGETMANTSD " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VGETMANTSD\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VGETEXPSD(Instruction):
    """Extract Exponent of Scalar Double-Precision Floating-Point Value as Double-Precision Floating-Point Value"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VGETEXPSD(xmm{k}{z}, xmm, xmm/m64)       [AVX512F]
            * VGETEXPSD(xmm{k}{z}, xmm, xmm, {sae})    [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VGETEXPSD, self).__init__("VGETEXPSD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (False, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            if is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m64(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x43]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=8)))
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x43, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            else:
                raise SyntaxError("Invalid operand types: VGETEXPSD " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]) and is_sae(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0x43, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (False, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VGETEXPSD " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VGETEXPSD\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VSCALEFSD(Instruction):
    """Scale Scalar Double-Precision Floating-Point Value With a Double-Precision Floating-Point Value"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VSCALEFSD(xmm{k}{z}, xmm, xmm/m64)      [AVX512F]
            * VSCALEFSD(xmm{k}{z}, xmm, xmm, {er})    [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VSCALEFSD, self).__init__("VSCALEFSD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (False, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            if is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m64(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x2D]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=8)))
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x2D, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            else:
                raise SyntaxError("Invalid operand types: VSCALEFSD " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0x2D, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (False, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VSCALEFSD " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VSCALEFSD\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFIXUPIMMSD(Instruction):
    """Fix Up Special Scalar Double-Precision Floating-Point Value"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFIXUPIMMSD(xmm{k}{z}, xmm, xmm/m64, imm8)       [AVX512F]
            * VFIXUPIMMSD(xmm{k}{z}, xmm, xmm, {sae}, imm8)    [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFIXUPIMMSD, self).__init__("VFIXUPIMMSD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 4:
            self.in_regs = (True, True, True, False)
            self.out_regs = (True, False, False, False)
            self.out_operands = (True, False, False, False)
            self.avx_mode = True
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            if is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m64(self.operands[2]) and is_imm(self.operands[3]):
                if not is_imm8(self.operands[3]):
                    raise ValueError("Argument #3 can not be encoded as imm8")
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b11, 0x85, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x55]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=8) + bytearray([op[3] & 0xFF])))
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]) and is_imm(self.operands[3]):
                if not is_imm8(self.operands[3]):
                    raise ValueError("Argument #3 can not be encoded as imm8")
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 243, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x55, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3] & 0xFF])))
            else:
                raise SyntaxError("Invalid operand types: VFIXUPIMMSD " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 5:
            if is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]) and is_sae(self.operands[3]) and is_imm(self.operands[4]):
                if not is_imm8(self.operands[4]):
                    raise ValueError("Argument #4 can not be encoded as imm8")
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 243, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0x55, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[4] & 0xFF])))
                self.in_regs = (True, True, True, False, False)
                self.out_regs = (True, False, False, False, False)
                self.out_operands = (True, False, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFIXUPIMMSD " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VFIXUPIMMSD\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFPCLASSSD(Instruction):
    """Test Class of Scalar Double-Precision Floating-Point Value"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFPCLASSSD(k{k}, xmm/m64, imm8)    [AVX512DQ]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFPCLASSSD, self).__init__("VFPCLASSSD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"VFPCLASSSD\" requires 3 operands")
        self.in_regs = (False, True, False)
        self.out_regs = (True, False, False)
        self.out_operands = (True, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512dq])
        if is_kk(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 243, 0xFD, op[0].kcode | 0x08, 0x67, 0xC0 | op[0].lcode << 3 | op[1].lcode, op[2] & 0xFF])))
        elif is_kk(self.operands[0]) and is_m64(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b11, 0x85, 0b00, op[0].ehcode, op[1].address, aaa=op[0].kcode) + bytearray([0x67]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=8) + bytearray([op[2] & 0xFF])))
        else:
            raise SyntaxError("Invalid operand types: VFPCLASSSD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VRCP14SD(Instruction):
    """Compute Approximate Reciprocal of a Scalar Double-Precision Floating-Point Value"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VRCP14SD(xmm{k}{z}, xmm, xmm/m64)    [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VRCP14SD, self).__init__("VRCP14SD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"VRCP14SD\" requires 3 operands")
        self.in_regs = (False, True, True)
        self.out_regs = (True, False, False)
        self.out_operands = (True, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        if is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0x4D, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m64(self.operands[2]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x4D]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=8)))
        else:
            raise SyntaxError("Invalid operand types: VRCP14SD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VRSQRT14SD(Instruction):
    """Compute Approximate Reciprocal of a Square Root of a Scalar Double-Precision Floating-Point Value"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VRSQRT14SD(xmm{k}{z}, xmm, xmm/m64)    [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VRSQRT14SD, self).__init__("VRSQRT14SD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"VRSQRT14SD\" requires 3 operands")
        self.in_regs = (False, True, True)
        self.out_regs = (True, False, False)
        self.out_operands = (True, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        if is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0x4F, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m64(self.operands[2]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x4F]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=8)))
        else:
            raise SyntaxError("Invalid operand types: VRSQRT14SD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VRCP28SD(Instruction):
    """Approximation to the Reciprocal of a Scalar Double-Precision Floating-Point Value with Less Than 2^-28 Relative Error"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VRCP28SD(xmm{k}{z}, xmm, xmm/m64)       [AVX512ER]
            * VRCP28SD(xmm{k}{z}, xmm, xmm, {sae})    [AVX512ER]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VRCP28SD, self).__init__("VRCP28SD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (False, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512er])
            if is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m64(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0xCB]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=8)))
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0xCB, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            else:
                raise SyntaxError("Invalid operand types: VRCP28SD " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]) and is_sae(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0xCB, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (False, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512er])
            else:
                raise SyntaxError("Invalid operand types: VRCP28SD " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VRCP28SD\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VRSQRT28SD(Instruction):
    """Approximation to the Reciprocal Square Root of a Scalar Double-Precision Floating-Point Value with Less Than 2^-28 Relative Error"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VRSQRT28SD(xmm{k}{z}, xmm, xmm/m64)       [AVX512ER]
            * VRSQRT28SD(xmm{k}{z}, xmm, xmm, {sae})    [AVX512ER]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VRSQRT28SD, self).__init__("VRSQRT28SD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (False, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512er])
            if is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m64(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0xCD]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=8)))
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0xCD, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            else:
                raise SyntaxError("Invalid operand types: VRSQRT28SD " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]) and is_sae(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0xCD, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (False, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512er])
            else:
                raise SyntaxError("Invalid operand types: VRSQRT28SD " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VRSQRT28SD\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VCMPSD(Instruction):
    """Compare Scalar Double-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VCMPSD(xmm, xmm, xmm/m64, imm8)        [AVX]
            * VCMPSD(k{k}, xmm, xmm/m64, imm8)       [AVX512F]
            * VCMPSD(k{k}, xmm, xmm, {sae}, imm8)    [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VCMPSD, self).__init__("VCMPSD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 4:
            self.in_regs = (False, True, True, False)
            self.out_regs = (True, False, False, False)
            self.out_operands = (True, False, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_imm(self.operands[3]):
                if not is_imm8(self.operands[3]):
                    raise ValueError("Argument #3 can not be encoded as imm8")
                self.encodings.append((0x40, lambda op, vex3=False: vex2(3, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0xC2, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3] & 0xFF])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m64(self.operands[2]) and is_imm(self.operands[3]):
                if not is_imm8(self.operands[3]):
                    raise ValueError("Argument #3 can not be encoded as imm8")
                self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(3, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0xC2]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3] & 0xFF])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_kk(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m64(self.operands[2]) and is_imm(self.operands[3]):
                if not is_imm8(self.operands[3]):
                    raise ValueError("Argument #3 can not be encoded as imm8")
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x87, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode) + bytearray([0xC2]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=8) + bytearray([op[3] & 0xFF])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_kk(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]) and is_imm(self.operands[3]):
                if not is_imm8(self.operands[3]):
                    raise ValueError("Argument #3 can not be encoded as imm8")
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFF ^ (op[1].hlcode << 3), (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0xC2, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3] & 0xFF])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VCMPSD " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 5:
            if is_kk(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]) and is_sae(self.operands[3]) and is_imm(self.operands[4]):
                if not is_imm8(self.operands[4]):
                    raise ValueError("Argument #4 can not be encoded as imm8")
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFF ^ (op[1].hlcode << 3), (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0xC2, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[4] & 0xFF])))
                self.in_regs = (False, True, True, False, False)
                self.out_regs = (True, False, False, False, False)
                self.out_operands = (True, False, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VCMPSD " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VCMPSD\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VCOMISD(Instruction):
    """Compare Scalar Ordered Double-Precision Floating-Point Values and Set EFLAGS"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VCOMISD(xmm, xmm/m64)       [AVX]
            * VCOMISD(xmm, xmm/m64)       [AVX512F]
            * VCOMISD(xmm, xmm, {sae})    [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VCOMISD, self).__init__("VCOMISD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 2:
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.out_operands = (False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]):
                self.encodings.append((0x40, lambda op, vex3=False: vex2(1, op[0].hcode, op[1], 0, vex3) + bytearray([0x2F, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_xmm(self.operands[0]) and is_m64(self.operands[1]):
                self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(1, op[0].hcode, op[1].address, 0, vex3) + bytearray([0x2F]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_evex_xmm(self.operands[0]) and is_m64(self.operands[1]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x85, 0b00, op[0].ehcode, op[1].address) + bytearray([0x2F]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=8)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_evex_xmm(self.operands[0]) and is_evex_xmm(self.operands[1]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFD, 0x48, 0x2F, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VCOMISD " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 3:
            if is_evex_xmm(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_sae(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFD, 0x18, 0x2F, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
                self.in_regs = (True, True, False)
                self.out_regs = (False, False, False)
                self.out_operands = (False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VCOMISD " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VCOMISD\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VUCOMISD(Instruction):
    """Unordered Compare Scalar Double-Precision Floating-Point Values and Set EFLAGS"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VUCOMISD(xmm, xmm/m64)       [AVX]
            * VUCOMISD(xmm, xmm/m64)       [AVX512F]
            * VUCOMISD(xmm, xmm, {sae})    [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VUCOMISD, self).__init__("VUCOMISD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 2:
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.out_operands = (False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]):
                self.encodings.append((0x40, lambda op, vex3=False: vex2(1, op[0].hcode, op[1], 0, vex3) + bytearray([0x2E, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_xmm(self.operands[0]) and is_m64(self.operands[1]):
                self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(1, op[0].hcode, op[1].address, 0, vex3) + bytearray([0x2E]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_evex_xmm(self.operands[0]) and is_m64(self.operands[1]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x85, 0b00, op[0].ehcode, op[1].address) + bytearray([0x2E]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=8)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_evex_xmm(self.operands[0]) and is_evex_xmm(self.operands[1]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFD, 0x48, 0x2E, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VUCOMISD " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 3:
            if is_evex_xmm(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_sae(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFD, 0x18, 0x2E, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
                self.in_regs = (True, True, False)
                self.out_regs = (False, False, False)
                self.out_operands = (False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VUCOMISD " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VUCOMISD\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VMOVAPS(Instruction):
    """Move Aligned Packed Single-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VMOVAPS(xmm, xmm/m128)          [AVX]
            * VMOVAPS(ymm, ymm/m256)          [AVX]
            * VMOVAPS(xmm/m128, xmm)          [AVX]
            * VMOVAPS(ymm/m256, ymm)          [AVX]
            * VMOVAPS(m512{k}{z}, zmm)        [AVX512F]
            * VMOVAPS(zmm{k}{z}, zmm/m512)    [AVX512F]
            * VMOVAPS(m128{k}{z}, xmm)        [AVX512F and AVX512VL]
            * VMOVAPS(m256{k}{z}, ymm)        [AVX512F and AVX512VL]
            * VMOVAPS(xmm{k}{z}, xmm/m128)    [AVX512F and AVX512VL]
            * VMOVAPS(ymm{k}{z}, ymm/m256)    [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VMOVAPS, self).__init__("VMOVAPS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VMOVAPS\" requires 2 operands")
        self.out_operands = (True, False)
        self.avx_mode = True
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(0, op[0].hcode, op[1], 0, vex3) + bytearray([0x28, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.encodings.append((0x40, lambda op, vex3=False: vex2(0, op[1].hcode, op[0], 0, vex3) + bytearray([0x29, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_xmm(self.operands[0]) and is_m128(self.operands[1]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(0, op[0].hcode, op[1].address, 0, vex3) + bytearray([0x28]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(4, op[0].hcode, op[1], 0, vex3) + bytearray([0x28, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.encodings.append((0x40, lambda op, vex3=False: vex2(4, op[1].hcode, op[0], 0, vex3) + bytearray([0x29, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_ymm(self.operands[0]) and is_m256(self.operands[1]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(4, op[0].hcode, op[1].address, 0, vex3) + bytearray([0x28]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_m128(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(0, op[1].hcode, op[0].address, 0, vex3) + bytearray([0x29]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_m256(self.operands[0]) and is_ymm(self.operands[1]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(4, op[1].hcode, op[0].address, 0, vex3) + bytearray([0x29]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_m512kz(self.operands[0]) and is_zmm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x04, 0b10, op[1].ehcode, op[0].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x29]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=64)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7C, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x28, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[1].hcode << 7) | (op[0].ehcode << 5) | (op[1].ecode << 4)) ^ 241, 0x7C, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x29, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_zmmkz(self.operands[0]) and is_m512(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x04, 0b10, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x28]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=64)))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_m128kz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x04, 0b00, op[1].ehcode, op[0].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x29]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=16)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7C, (op[0].zcode << 7) | op[0].kcode | 0x08, 0x28, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[1].hcode << 7) | (op[0].ehcode << 5) | (op[1].ecode << 4)) ^ 241, 0x7C, (op[0].zcode << 7) | op[0].kcode | 0x08, 0x29, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_m256kz(self.operands[0]) and is_evex_ymm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x04, 0b01, op[1].ehcode, op[0].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x29]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=32)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7C, (op[0].zcode << 7) | op[0].kcode | 0x28, 0x28, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[1].hcode << 7) | (op[0].ehcode << 5) | (op[1].ecode << 4)) ^ 241, 0x7C, (op[0].zcode << 7) | op[0].kcode | 0x28, 0x29, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_m128(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x04, 0b00, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x28]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=16)))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_m256(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x04, 0b01, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x28]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=32)))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: VMOVAPS " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VMOVUPS(Instruction):
    """Move Unaligned Packed Single-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VMOVUPS(xmm, xmm/m128)          [AVX]
            * VMOVUPS(ymm, ymm/m256)          [AVX]
            * VMOVUPS(xmm/m128, xmm)          [AVX]
            * VMOVUPS(ymm/m256, ymm)          [AVX]
            * VMOVUPS(m512{k}{z}, zmm)        [AVX512F]
            * VMOVUPS(zmm{k}{z}, zmm/m512)    [AVX512F]
            * VMOVUPS(m128{k}{z}, xmm)        [AVX512F and AVX512VL]
            * VMOVUPS(m256{k}{z}, ymm)        [AVX512F and AVX512VL]
            * VMOVUPS(xmm{k}{z}, xmm/m128)    [AVX512F and AVX512VL]
            * VMOVUPS(ymm{k}{z}, ymm/m256)    [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VMOVUPS, self).__init__("VMOVUPS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VMOVUPS\" requires 2 operands")
        self.out_operands = (True, False)
        self.avx_mode = True
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(0, op[0].hcode, op[1], 0, vex3) + bytearray([0x10, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.encodings.append((0x40, lambda op, vex3=False: vex2(0, op[1].hcode, op[0], 0, vex3) + bytearray([0x11, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_xmm(self.operands[0]) and is_m128(self.operands[1]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(0, op[0].hcode, op[1].address, 0, vex3) + bytearray([0x10]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(4, op[0].hcode, op[1], 0, vex3) + bytearray([0x10, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.encodings.append((0x40, lambda op, vex3=False: vex2(4, op[1].hcode, op[0], 0, vex3) + bytearray([0x11, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_ymm(self.operands[0]) and is_m256(self.operands[1]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(4, op[0].hcode, op[1].address, 0, vex3) + bytearray([0x10]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_m128(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(0, op[1].hcode, op[0].address, 0, vex3) + bytearray([0x11]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_m256(self.operands[0]) and is_ymm(self.operands[1]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(4, op[1].hcode, op[0].address, 0, vex3) + bytearray([0x11]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_m512kz(self.operands[0]) and is_zmm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x04, 0b10, op[1].ehcode, op[0].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x11]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=64)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7C, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x10, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[1].hcode << 7) | (op[0].ehcode << 5) | (op[1].ecode << 4)) ^ 241, 0x7C, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x11, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_zmmkz(self.operands[0]) and is_m512(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x04, 0b10, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x10]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=64)))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_m128kz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x04, 0b00, op[1].ehcode, op[0].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x11]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=16)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7C, (op[0].zcode << 7) | op[0].kcode | 0x08, 0x10, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[1].hcode << 7) | (op[0].ehcode << 5) | (op[1].ecode << 4)) ^ 241, 0x7C, (op[0].zcode << 7) | op[0].kcode | 0x08, 0x11, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_m256kz(self.operands[0]) and is_evex_ymm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x04, 0b01, op[1].ehcode, op[0].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x11]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=32)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7C, (op[0].zcode << 7) | op[0].kcode | 0x28, 0x10, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[1].hcode << 7) | (op[0].ehcode << 5) | (op[1].ecode << 4)) ^ 241, 0x7C, (op[0].zcode << 7) | op[0].kcode | 0x28, 0x11, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_m128(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x04, 0b00, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x10]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=16)))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_m256(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x04, 0b01, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x10]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=32)))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: VMOVUPS " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VMOVLPS(Instruction):
    """Move Low Packed Single-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VMOVLPS(m64, xmm)         [AVX]
            * VMOVLPS(xmm, xmm, m64)    [AVX]
            * VMOVLPS(m64, xmm)         [AVX512F]
            * VMOVLPS(xmm, xmm, m64)    [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VMOVLPS, self).__init__("VMOVLPS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 2:
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.out_operands = (True, False)
            self.avx_mode = True
            if is_m64(self.operands[0]) and is_xmm(self.operands[1]):
                self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(0, op[1].hcode, op[0].address, 0, vex3) + bytearray([0x13]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_m64(self.operands[0]) and is_evex_xmm(self.operands[1]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x04, 0b00, op[1].ehcode, op[0].address) + bytearray([0x13]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=8)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VMOVLPS " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 3:
            self.in_regs = (False, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m64(self.operands[2]):
                self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(0, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0x12]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_evex_xmm(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m64(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x04, 0b00, op[0].ehcode, op[2].address, op[1].code) + bytearray([0x12]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=8)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VMOVLPS " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VMOVLPS\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VMOVHPS(Instruction):
    """Move High Packed Single-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VMOVHPS(m64, xmm)         [AVX]
            * VMOVHPS(xmm, xmm, m64)    [AVX]
            * VMOVHPS(m64, xmm)         [AVX512F]
            * VMOVHPS(xmm, xmm, m64)    [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VMOVHPS, self).__init__("VMOVHPS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 2:
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.out_operands = (True, False)
            self.avx_mode = True
            if is_m64(self.operands[0]) and is_xmm(self.operands[1]):
                self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(0, op[1].hcode, op[0].address, 0, vex3) + bytearray([0x17]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_m64(self.operands[0]) and is_evex_xmm(self.operands[1]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x04, 0b00, op[1].ehcode, op[0].address) + bytearray([0x17]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=8)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VMOVHPS " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 3:
            self.in_regs = (False, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m64(self.operands[2]):
                self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(0, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0x16]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_evex_xmm(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m64(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x04, 0b00, op[0].ehcode, op[2].address, op[1].code) + bytearray([0x16]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=8)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VMOVHPS " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VMOVHPS\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VMASKMOVPS(Instruction):
    """Conditional Move Packed Single-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VMASKMOVPS(xmm, xmm, m128)    [AVX]
            * VMASKMOVPS(ymm, ymm, m256)    [AVX]
            * VMASKMOVPS(m128, xmm, xmm)    [AVX]
            * VMASKMOVPS(m256, ymm, ymm)    [AVX]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VMASKMOVPS, self).__init__("VMASKMOVPS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"VMASKMOVPS\" requires 3 operands")
        self.out_operands = (True, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x01, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x2C]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
            self.in_regs = (False, True, True)
            self.out_regs = (True, False, False)
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x05, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x2C]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
            self.in_regs = (False, True, True)
            self.out_regs = (True, False, False)
        elif is_m128(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x01, op[2].hcode, op[0].address, op[1].hlcode) + bytearray([0x2E]) + modrm_sib_disp(op[2].lcode, op[0].address, sib, min_disp)))
            self.in_regs = (True, True, True)
            self.out_regs = (False, False, False)
        elif is_m256(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x05, op[2].hcode, op[0].address, op[1].hlcode) + bytearray([0x2E]) + modrm_sib_disp(op[2].lcode, op[0].address, sib, min_disp)))
            self.in_regs = (True, True, True)
            self.out_regs = (False, False, False)
        else:
            raise SyntaxError("Invalid operand types: VMASKMOVPS " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VMOVMSKPS(Instruction):
    """Extract Packed Single-Precision Floating-Point Sign Mask"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VMOVMSKPS(r32, xmm)    [AVX]
            * VMOVMSKPS(r32, ymm)    [AVX]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VMOVMSKPS, self).__init__("VMOVMSKPS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VMOVMSKPS\" requires 2 operands")
        self.in_regs = (False, True)
        self.out_regs = (True, False)
        self.out_operands = (True, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        if is_r32(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(0, op[0].hcode, op[1], 0, vex3) + bytearray([0x50, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
        elif is_r32(self.operands[0]) and is_ymm(self.operands[1]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(4, op[0].hcode, op[1], 0, vex3) + bytearray([0x50, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
        else:
            raise SyntaxError("Invalid operand types: VMOVMSKPS " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VMOVNTPS(Instruction):
    """Store Packed Single-Precision Floating-Point Values Using Non-Temporal Hint"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VMOVNTPS(m128, xmm)    [AVX]
            * VMOVNTPS(m256, ymm)    [AVX]
            * VMOVNTPS(m512, zmm)    [AVX512F]
            * VMOVNTPS(m128, xmm)    [AVX512F and AVX512VL]
            * VMOVNTPS(m256, ymm)    [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VMOVNTPS, self).__init__("VMOVNTPS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VMOVNTPS\" requires 2 operands")
        self.in_regs = (True, True)
        self.out_regs = (False, False)
        self.out_operands = (True, False)
        self.avx_mode = True
        if is_m128(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(0, op[1].hcode, op[0].address, 0, vex3) + bytearray([0x2B]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_m256(self.operands[0]) and is_ymm(self.operands[1]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(4, op[1].hcode, op[0].address, 0, vex3) + bytearray([0x2B]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_m512(self.operands[0]) and is_zmm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x04, 0b10, op[1].ehcode, op[0].address) + bytearray([0x2B]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=64)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_m128(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x05, 0b00, op[1].ehcode, op[0].address) + bytearray([0x2B]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=16)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_m256(self.operands[0]) and is_evex_ymm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x05, 0b01, op[1].ehcode, op[0].address) + bytearray([0x2B]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=32)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: VMOVNTPS " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VBROADCASTSS(Instruction):
    """Broadcast Single-Precision Floating-Point Element"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VBROADCASTSS(xmm, m32)              [AVX]
            * VBROADCASTSS(ymm, m32)              [AVX]
            * VBROADCASTSS(xmm, xmm)              [AVX2]
            * VBROADCASTSS(ymm, xmm)              [AVX2]
            * VBROADCASTSS(zmm{k}{z}, xmm/m32)    [AVX512F]
            * VBROADCASTSS(ymm{k}{z}, xmm/m32)    [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VBROADCASTSS, self).__init__("VBROADCASTSS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VBROADCASTSS\" requires 2 operands")
        self.in_regs = (False, True)
        self.out_regs = (True, False)
        self.out_operands = (True, False)
        self.avx_mode = True
        if is_xmm(self.operands[0]) and is_m32(self.operands[1]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x01, op[0].hcode, op[1].address) + bytearray([0x18]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_ymm(self.operands[0]) and is_m32(self.operands[1]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x05, op[0].hcode, op[1].address) + bytearray([0x18]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x79, 0x18, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx2])
        elif is_ymm(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x7D, 0x18, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx2])
        elif is_zmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x18, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_zmmkz(self.operands[0]) and is_m32(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b10, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x18]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=4)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x28, 0x18, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_m32(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b01, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x18]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=4)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: VBROADCASTSS " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VMOVSLDUP(Instruction):
    """Move Packed Single-FP Low and Duplicate"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VMOVSLDUP(xmm, xmm/m128)          [AVX]
            * VMOVSLDUP(ymm, ymm/m256)          [AVX]
            * VMOVSLDUP(zmm{k}{z}, zmm/m512)    [AVX512F]
            * VMOVSLDUP(xmm{k}{z}, xmm/m128)    [AVX512F and AVX512VL]
            * VMOVSLDUP(ymm{k}{z}, ymm/m256)    [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VMOVSLDUP, self).__init__("VMOVSLDUP", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VMOVSLDUP\" requires 2 operands")
        self.in_regs = (False, True)
        self.out_regs = (True, False)
        self.out_operands = (True, False)
        self.avx_mode = True
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(2, op[0].hcode, op[1], 0, vex3) + bytearray([0x12, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_xmm(self.operands[0]) and is_m128(self.operands[1]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(2, op[0].hcode, op[1].address, 0, vex3) + bytearray([0x12]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(6, op[0].hcode, op[1], 0, vex3) + bytearray([0x12, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_ymm(self.operands[0]) and is_m256(self.operands[1]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(6, op[0].hcode, op[1].address, 0, vex3) + bytearray([0x12]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7E, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x12, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_zmmkz(self.operands[0]) and is_m512(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x06, 0b10, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x12]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=64)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7E, (op[0].zcode << 7) | op[0].kcode | 0x08, 0x12, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7E, (op[0].zcode << 7) | op[0].kcode | 0x28, 0x12, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_m128(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x06, 0b00, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x12]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=16)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_m256(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x06, 0b01, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x12]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=32)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: VMOVSLDUP " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VMOVSHDUP(Instruction):
    """Move Packed Single-FP High and Duplicate"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VMOVSHDUP(xmm, xmm/m128)          [AVX]
            * VMOVSHDUP(ymm, ymm/m256)          [AVX]
            * VMOVSHDUP(zmm{k}{z}, zmm/m512)    [AVX512F]
            * VMOVSHDUP(xmm{k}{z}, xmm/m128)    [AVX512F and AVX512VL]
            * VMOVSHDUP(ymm{k}{z}, ymm/m256)    [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VMOVSHDUP, self).__init__("VMOVSHDUP", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VMOVSHDUP\" requires 2 operands")
        self.in_regs = (False, True)
        self.out_regs = (True, False)
        self.out_operands = (True, False)
        self.avx_mode = True
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(2, op[0].hcode, op[1], 0, vex3) + bytearray([0x16, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_xmm(self.operands[0]) and is_m128(self.operands[1]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(2, op[0].hcode, op[1].address, 0, vex3) + bytearray([0x16]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(6, op[0].hcode, op[1], 0, vex3) + bytearray([0x16, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_ymm(self.operands[0]) and is_m256(self.operands[1]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(6, op[0].hcode, op[1].address, 0, vex3) + bytearray([0x16]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7E, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x16, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_zmmkz(self.operands[0]) and is_m512(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x06, 0b10, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x16]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=64)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7E, (op[0].zcode << 7) | op[0].kcode | 0x08, 0x16, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7E, (op[0].zcode << 7) | op[0].kcode | 0x28, 0x16, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_m128(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x06, 0b00, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x16]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=16)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_m256(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x06, 0b01, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x16]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=32)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: VMOVSHDUP " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VEXPANDPS(Instruction):
    """Load Sparse Packed Single-Precision Floating-Point Values from Dense Memory"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VEXPANDPS(zmm{k}{z}, zmm/m512)    [AVX512F]
            * VEXPANDPS(xmm{k}{z}, xmm/m128)    [AVX512F and AVX512VL]
            * VEXPANDPS(ymm{k}{z}, ymm/m256)    [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VEXPANDPS, self).__init__("VEXPANDPS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VEXPANDPS\" requires 2 operands")
        self.in_regs = (False, True)
        self.out_regs = (True, False)
        self.out_operands = (True, False)
        self.avx_mode = True
        if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x88, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_zmmkz(self.operands[0]) and is_m512(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b10, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x88]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=4)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x08, 0x88, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x28, 0x88, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_m128(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b00, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x88]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=4)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_m256(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b01, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x88]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=4)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: VEXPANDPS " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VCOMPRESSPS(Instruction):
    """Store Sparse Packed Single-Precision Floating-Point Values into Dense Memory/Register"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VCOMPRESSPS(zmm{k}{z}, zmm)     [AVX512F]
            * VCOMPRESSPS(m512{k}{z}, zmm)    [AVX512F]
            * VCOMPRESSPS(xmm{k}{z}, xmm)     [AVX512F and AVX512VL]
            * VCOMPRESSPS(m128{k}{z}, xmm)    [AVX512F and AVX512VL]
            * VCOMPRESSPS(ymm{k}{z}, ymm)     [AVX512F and AVX512VL]
            * VCOMPRESSPS(m256{k}{z}, ymm)    [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VCOMPRESSPS, self).__init__("VCOMPRESSPS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VCOMPRESSPS\" requires 2 operands")
        self.out_operands = (True, False)
        self.avx_mode = True
        if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[1].hcode << 7) | (op[0].ehcode << 5) | (op[1].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x8A, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_m512kz(self.operands[0]) and is_zmm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b10, op[1].ehcode, op[0].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x8A]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=4)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[1].hcode << 7) | (op[0].ehcode << 5) | (op[1].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x08, 0x8A, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_m128kz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b00, op[1].ehcode, op[0].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x8A]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=4)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[1].hcode << 7) | (op[0].ehcode << 5) | (op[1].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x28, 0x8A, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_m256kz(self.operands[0]) and is_evex_ymm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b01, op[1].ehcode, op[0].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x8A]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=4)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: VCOMPRESSPS " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VGATHERDPS(Instruction):
    """Gather Packed Single-Precision Floating-Point Values Using Signed Doubleword Indices"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VGATHERDPS(xmm, vm32x, xmm)    [AVX2]
            * VGATHERDPS(ymm, vm32y, ymm)    [AVX2]
            * VGATHERDPS(zmm{k}, vm32z)      [AVX512F]
            * VGATHERDPS(xmm{k}, vm32x)      [AVX512F and AVX512VL]
            * VGATHERDPS(ymm{k}, vm32y)      [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VGATHERDPS, self).__init__("VGATHERDPS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 2:
            self.in_regs = (True, True)
            self.out_regs = (True, False)
            self.out_operands = (True, False)
            self.avx_mode = True
            if is_zmmk(self.operands[0]) and is_vmz(self.operands[1]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b10, op[0].ehcode, op[1].address, aaa=op[0].kcode) + bytearray([0x92]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=4)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmk(self.operands[0]) and is_evex_vmx(self.operands[1]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b00, op[0].ehcode, op[1].address, aaa=op[0].kcode) + bytearray([0x92]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=4)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmk(self.operands[0]) and is_evex_vmy(self.operands[1]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b01, op[0].ehcode, op[1].address, aaa=op[0].kcode) + bytearray([0x92]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=4)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VGATHERDPS " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 3:
            self.in_regs = (True, True, True)
            self.out_regs = (True, False, True)
            self.out_operands = (True, False, True)
            self.avx_mode = True
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx2])
            if is_xmm(self.operands[0]) and is_vmx(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x01, op[0].hcode, op[1].address, op[2].hlcode) + bytearray([0x92]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
            elif is_ymm(self.operands[0]) and is_vmy(self.operands[1]) and is_ymm(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x05, op[0].hcode, op[1].address, op[2].hlcode) + bytearray([0x92]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
            else:
                raise SyntaxError("Invalid operand types: VGATHERDPS " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VGATHERDPS\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VGATHERQPS(Instruction):
    """Gather Packed Single-Precision Floating-Point Values Using Signed Quadword Indices"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VGATHERQPS(xmm, vm64x, xmm)    [AVX2]
            * VGATHERQPS(xmm, vm64y, xmm)    [AVX2]
            * VGATHERQPS(ymm{k}, vm64z)      [AVX512F]
            * VGATHERQPS(xmm{k}, vm64x)      [AVX512F and AVX512VL]
            * VGATHERQPS(xmm{k}, vm64y)      [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VGATHERQPS, self).__init__("VGATHERQPS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 2:
            self.in_regs = (True, True)
            self.out_regs = (True, False)
            self.out_operands = (True, False)
            self.avx_mode = True
            if is_ymmk(self.operands[0]) and is_vmz(self.operands[1]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b10, op[0].ehcode, op[1].address, aaa=op[0].kcode) + bytearray([0x93]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=4)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmk(self.operands[0]) and is_evex_vmx(self.operands[1]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b00, op[0].ehcode, op[1].address, aaa=op[0].kcode) + bytearray([0x93]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=4)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_xmmk(self.operands[0]) and is_evex_vmy(self.operands[1]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b01, op[0].ehcode, op[1].address, aaa=op[0].kcode) + bytearray([0x93]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=4)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VGATHERQPS " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 3:
            self.in_regs = (True, True, True)
            self.out_regs = (True, False, True)
            self.out_operands = (True, False, True)
            self.avx_mode = True
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx2])
            if is_xmm(self.operands[0]) and is_vmx(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x01, op[0].hcode, op[1].address, op[2].hlcode) + bytearray([0x93]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
            elif is_xmm(self.operands[0]) and is_vmy(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x05, op[0].hcode, op[1].address, op[2].hlcode) + bytearray([0x93]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
            else:
                raise SyntaxError("Invalid operand types: VGATHERQPS " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VGATHERQPS\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VGATHERPF0DPS(Instruction):
    """Sparse Prefetch Packed Single-Precision Floating-Point Data Values with Signed Doubleword Indices Using T0 Hint"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VGATHERPF0DPS(vm32z{k})    [AVX512PF]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VGATHERPF0DPS, self).__init__("VGATHERPF0DPS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 1:
            raise SyntaxError("Instruction \"VGATHERPF0DPS\" requires 1 operands")
        if is_vmzk(self.operands[0]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b10, 0, op[0].address, aaa=op[0].kcode) + bytearray([0xC6]) + modrm_sib_disp(1, op[0].address, sib, min_disp, disp8xN=4)))
            self.in_regs = (True,)
            self.out_regs = (False,)
            self.out_operands = (False,)
            self.avx_mode = True
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512pf])
        else:
            raise SyntaxError("Invalid operand types: VGATHERPF0DPS " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VGATHERPF0QPS(Instruction):
    """Sparse Prefetch Packed Single-Precision Floating-Point Data Values with Signed Quadword Indices Using T0 Hint"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VGATHERPF0QPS(vm64z{k})    [AVX512PF]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VGATHERPF0QPS, self).__init__("VGATHERPF0QPS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 1:
            raise SyntaxError("Instruction \"VGATHERPF0QPS\" requires 1 operands")
        if is_vmzk(self.operands[0]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b10, 0, op[0].address, aaa=op[0].kcode) + bytearray([0xC7]) + modrm_sib_disp(1, op[0].address, sib, min_disp, disp8xN=4)))
            self.in_regs = (True,)
            self.out_regs = (False,)
            self.out_operands = (False,)
            self.avx_mode = True
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512pf])
        else:
            raise SyntaxError("Invalid operand types: VGATHERPF0QPS " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VGATHERPF1DPS(Instruction):
    """Sparse Prefetch Packed Single-Precision Floating-Point Data Values with Signed Doubleword Indices Using T1 Hint"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VGATHERPF1DPS(vm32z{k})    [AVX512PF]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VGATHERPF1DPS, self).__init__("VGATHERPF1DPS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 1:
            raise SyntaxError("Instruction \"VGATHERPF1DPS\" requires 1 operands")
        if is_vmzk(self.operands[0]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b10, 0, op[0].address, aaa=op[0].kcode) + bytearray([0xC6]) + modrm_sib_disp(2, op[0].address, sib, min_disp, disp8xN=4)))
            self.in_regs = (True,)
            self.out_regs = (False,)
            self.out_operands = (False,)
            self.avx_mode = True
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512pf])
        else:
            raise SyntaxError("Invalid operand types: VGATHERPF1DPS " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VGATHERPF1QPS(Instruction):
    """Sparse Prefetch Packed Single-Precision Floating-Point Data Values with Signed Quadword Indices Using T1 Hint"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VGATHERPF1QPS(vm64z{k})    [AVX512PF]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VGATHERPF1QPS, self).__init__("VGATHERPF1QPS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 1:
            raise SyntaxError("Instruction \"VGATHERPF1QPS\" requires 1 operands")
        if is_vmzk(self.operands[0]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b10, 0, op[0].address, aaa=op[0].kcode) + bytearray([0xC7]) + modrm_sib_disp(2, op[0].address, sib, min_disp, disp8xN=4)))
            self.in_regs = (True,)
            self.out_regs = (False,)
            self.out_operands = (False,)
            self.avx_mode = True
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512pf])
        else:
            raise SyntaxError("Invalid operand types: VGATHERPF1QPS " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VSCATTERDPS(Instruction):
    """Scatter Packed Single-Precision Floating-Point Values with Signed Doubleword Indices"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VSCATTERDPS(vm32z{k}, zmm)    [AVX512F]
            * VSCATTERDPS(vm32x{k}, xmm)    [AVX512F and AVX512VL]
            * VSCATTERDPS(vm32y{k}, ymm)    [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VSCATTERDPS, self).__init__("VSCATTERDPS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VSCATTERDPS\" requires 2 operands")
        self.in_regs = (True, True)
        self.out_regs = (False, False)
        self.out_operands = (True, False)
        self.avx_mode = True
        if is_vmzk(self.operands[0]) and is_zmm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b10, op[1].ehcode, op[0].address, aaa=op[0].kcode) + bytearray([0xA2]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=4)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_vmxk(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b00, op[1].ehcode, op[0].address, aaa=op[0].kcode) + bytearray([0xA2]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=4)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_vmyk(self.operands[0]) and is_evex_ymm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b01, op[1].ehcode, op[0].address, aaa=op[0].kcode) + bytearray([0xA2]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=4)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: VSCATTERDPS " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VSCATTERQPS(Instruction):
    """Scatter Packed Single-Precision Floating-Point Values with Signed Quadword Indices"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VSCATTERQPS(vm64z{k}, ymm)    [AVX512F]
            * VSCATTERQPS(vm64x{k}, xmm)    [AVX512F and AVX512VL]
            * VSCATTERQPS(vm64y{k}, xmm)    [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VSCATTERQPS, self).__init__("VSCATTERQPS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VSCATTERQPS\" requires 2 operands")
        self.in_regs = (True, True)
        self.out_regs = (False, False)
        self.out_operands = (True, False)
        self.avx_mode = True
        if is_vmzk(self.operands[0]) and is_evex_ymm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b10, op[1].ehcode, op[0].address, aaa=op[0].kcode) + bytearray([0xA3]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=4)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_vmxk(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b00, op[1].ehcode, op[0].address, aaa=op[0].kcode) + bytearray([0xA3]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=4)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_vmyk(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b01, op[1].ehcode, op[0].address, aaa=op[0].kcode) + bytearray([0xA3]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=4)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: VSCATTERQPS " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VSCATTERPF0DPS(Instruction):
    """Sparse Prefetch Packed Single-Precision Floating-Point Data Values with Signed Doubleword Indices Using T0 Hint with Intent to Write"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VSCATTERPF0DPS(vm32z{k})    [AVX512PF]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VSCATTERPF0DPS, self).__init__("VSCATTERPF0DPS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 1:
            raise SyntaxError("Instruction \"VSCATTERPF0DPS\" requires 1 operands")
        if is_vmzk(self.operands[0]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b10, 0, op[0].address, aaa=op[0].kcode) + bytearray([0xC6]) + modrm_sib_disp(5, op[0].address, sib, min_disp, disp8xN=4)))
            self.in_regs = (True,)
            self.out_regs = (False,)
            self.out_operands = (False,)
            self.avx_mode = True
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512pf])
        else:
            raise SyntaxError("Invalid operand types: VSCATTERPF0DPS " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VSCATTERPF0QPS(Instruction):
    """Sparse Prefetch Packed Single-Precision Floating-Point Data Values with Signed Quadword Indices Using T0 Hint with Intent to Write"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VSCATTERPF0QPS(vm64z{k})    [AVX512PF]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VSCATTERPF0QPS, self).__init__("VSCATTERPF0QPS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 1:
            raise SyntaxError("Instruction \"VSCATTERPF0QPS\" requires 1 operands")
        if is_vmzk(self.operands[0]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b10, 0, op[0].address, aaa=op[0].kcode) + bytearray([0xC7]) + modrm_sib_disp(5, op[0].address, sib, min_disp, disp8xN=4)))
            self.in_regs = (True,)
            self.out_regs = (False,)
            self.out_operands = (False,)
            self.avx_mode = True
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512pf])
        else:
            raise SyntaxError("Invalid operand types: VSCATTERPF0QPS " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VSCATTERPF1DPS(Instruction):
    """Sparse Prefetch Packed Single-Precision Floating-Point Data Values with Signed Doubleword Indices Using T1 Hint with Intent to Write"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VSCATTERPF1DPS(vm32z{k})    [AVX512PF]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VSCATTERPF1DPS, self).__init__("VSCATTERPF1DPS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 1:
            raise SyntaxError("Instruction \"VSCATTERPF1DPS\" requires 1 operands")
        if is_vmzk(self.operands[0]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b10, 0, op[0].address, aaa=op[0].kcode) + bytearray([0xC6]) + modrm_sib_disp(6, op[0].address, sib, min_disp, disp8xN=4)))
            self.in_regs = (True,)
            self.out_regs = (False,)
            self.out_operands = (False,)
            self.avx_mode = True
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512pf])
        else:
            raise SyntaxError("Invalid operand types: VSCATTERPF1DPS " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VSCATTERPF1QPS(Instruction):
    """Sparse Prefetch Packed Single-Precision Floating-Point Data Values with Signed Quadword Indices Using T1 Hint with Intent to Write"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VSCATTERPF1QPS(vm64z{k})    [AVX512PF]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VSCATTERPF1QPS, self).__init__("VSCATTERPF1QPS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 1:
            raise SyntaxError("Instruction \"VSCATTERPF1QPS\" requires 1 operands")
        if is_vmzk(self.operands[0]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b10, 0, op[0].address, aaa=op[0].kcode) + bytearray([0xC7]) + modrm_sib_disp(6, op[0].address, sib, min_disp, disp8xN=4)))
            self.in_regs = (True,)
            self.out_regs = (False,)
            self.out_operands = (False,)
            self.avx_mode = True
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512pf])
        else:
            raise SyntaxError("Invalid operand types: VSCATTERPF1QPS " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VMOVAPD(Instruction):
    """Move Aligned Packed Double-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VMOVAPD(xmm, xmm/m128)          [AVX]
            * VMOVAPD(ymm, ymm/m256)          [AVX]
            * VMOVAPD(xmm/m128, xmm)          [AVX]
            * VMOVAPD(ymm/m256, ymm)          [AVX]
            * VMOVAPD(m512{k}{z}, zmm)        [AVX512F]
            * VMOVAPD(zmm{k}{z}, zmm/m512)    [AVX512F]
            * VMOVAPD(m128{k}{z}, xmm)        [AVX512F and AVX512VL]
            * VMOVAPD(m256{k}{z}, ymm)        [AVX512F and AVX512VL]
            * VMOVAPD(xmm{k}{z}, xmm/m128)    [AVX512F and AVX512VL]
            * VMOVAPD(ymm{k}{z}, ymm/m256)    [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VMOVAPD, self).__init__("VMOVAPD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VMOVAPD\" requires 2 operands")
        self.out_operands = (True, False)
        self.avx_mode = True
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(1, op[0].hcode, op[1], 0, vex3) + bytearray([0x28, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.encodings.append((0x40, lambda op, vex3=False: vex2(1, op[1].hcode, op[0], 0, vex3) + bytearray([0x29, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_xmm(self.operands[0]) and is_m128(self.operands[1]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(1, op[0].hcode, op[1].address, 0, vex3) + bytearray([0x28]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(5, op[0].hcode, op[1], 0, vex3) + bytearray([0x28, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.encodings.append((0x40, lambda op, vex3=False: vex2(5, op[1].hcode, op[0], 0, vex3) + bytearray([0x29, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_ymm(self.operands[0]) and is_m256(self.operands[1]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(5, op[0].hcode, op[1].address, 0, vex3) + bytearray([0x28]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_m128(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(1, op[1].hcode, op[0].address, 0, vex3) + bytearray([0x29]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_m256(self.operands[0]) and is_ymm(self.operands[1]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(5, op[1].hcode, op[0].address, 0, vex3) + bytearray([0x29]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_m512kz(self.operands[0]) and is_zmm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x85, 0b10, op[1].ehcode, op[0].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x29]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=64)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFD, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x28, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[1].hcode << 7) | (op[0].ehcode << 5) | (op[1].ecode << 4)) ^ 241, 0xFD, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x29, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_zmmkz(self.operands[0]) and is_m512(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x85, 0b10, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x28]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=64)))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_m128kz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x85, 0b00, op[1].ehcode, op[0].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x29]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=16)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFD, (op[0].zcode << 7) | op[0].kcode | 0x08, 0x28, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[1].hcode << 7) | (op[0].ehcode << 5) | (op[1].ecode << 4)) ^ 241, 0xFD, (op[0].zcode << 7) | op[0].kcode | 0x08, 0x29, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_m256kz(self.operands[0]) and is_evex_ymm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x85, 0b01, op[1].ehcode, op[0].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x29]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=32)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFD, (op[0].zcode << 7) | op[0].kcode | 0x28, 0x28, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[1].hcode << 7) | (op[0].ehcode << 5) | (op[1].ecode << 4)) ^ 241, 0xFD, (op[0].zcode << 7) | op[0].kcode | 0x28, 0x29, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_m128(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x85, 0b00, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x28]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=16)))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_m256(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x85, 0b01, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x28]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=32)))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: VMOVAPD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VMOVUPD(Instruction):
    """Move Unaligned Packed Double-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VMOVUPD(xmm, xmm/m128)          [AVX]
            * VMOVUPD(ymm, ymm/m256)          [AVX]
            * VMOVUPD(xmm/m128, xmm)          [AVX]
            * VMOVUPD(ymm/m256, ymm)          [AVX]
            * VMOVUPD(m512{k}{z}, zmm)        [AVX512F]
            * VMOVUPD(zmm{k}{z}, zmm/m512)    [AVX512F]
            * VMOVUPD(m128{k}{z}, xmm)        [AVX512F and AVX512VL]
            * VMOVUPD(m256{k}{z}, ymm)        [AVX512F and AVX512VL]
            * VMOVUPD(xmm{k}{z}, xmm/m128)    [AVX512F and AVX512VL]
            * VMOVUPD(ymm{k}{z}, ymm/m256)    [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VMOVUPD, self).__init__("VMOVUPD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VMOVUPD\" requires 2 operands")
        self.out_operands = (True, False)
        self.avx_mode = True
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(1, op[0].hcode, op[1], 0, vex3) + bytearray([0x10, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.encodings.append((0x40, lambda op, vex3=False: vex2(1, op[1].hcode, op[0], 0, vex3) + bytearray([0x11, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_xmm(self.operands[0]) and is_m128(self.operands[1]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(1, op[0].hcode, op[1].address, 0, vex3) + bytearray([0x10]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(5, op[0].hcode, op[1], 0, vex3) + bytearray([0x10, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.encodings.append((0x40, lambda op, vex3=False: vex2(5, op[1].hcode, op[0], 0, vex3) + bytearray([0x11, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_ymm(self.operands[0]) and is_m256(self.operands[1]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(5, op[0].hcode, op[1].address, 0, vex3) + bytearray([0x10]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_m128(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(1, op[1].hcode, op[0].address, 0, vex3) + bytearray([0x11]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_m256(self.operands[0]) and is_ymm(self.operands[1]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(5, op[1].hcode, op[0].address, 0, vex3) + bytearray([0x11]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_m512kz(self.operands[0]) and is_zmm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x85, 0b10, op[1].ehcode, op[0].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x11]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=64)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFD, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x10, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[1].hcode << 7) | (op[0].ehcode << 5) | (op[1].ecode << 4)) ^ 241, 0xFD, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x11, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_zmmkz(self.operands[0]) and is_m512(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x85, 0b10, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x10]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=64)))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_m128kz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x85, 0b00, op[1].ehcode, op[0].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x11]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=16)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFD, (op[0].zcode << 7) | op[0].kcode | 0x08, 0x10, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[1].hcode << 7) | (op[0].ehcode << 5) | (op[1].ecode << 4)) ^ 241, 0xFD, (op[0].zcode << 7) | op[0].kcode | 0x08, 0x11, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_m256kz(self.operands[0]) and is_evex_ymm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x85, 0b01, op[1].ehcode, op[0].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x11]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=32)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFD, (op[0].zcode << 7) | op[0].kcode | 0x28, 0x10, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[1].hcode << 7) | (op[0].ehcode << 5) | (op[1].ecode << 4)) ^ 241, 0xFD, (op[0].zcode << 7) | op[0].kcode | 0x28, 0x11, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_m128(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x85, 0b00, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x10]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=16)))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_m256(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x85, 0b01, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x10]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=32)))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: VMOVUPD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VMOVLPD(Instruction):
    """Move Low Packed Double-Precision Floating-Point Value"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VMOVLPD(m64, xmm)         [AVX]
            * VMOVLPD(xmm, xmm, m64)    [AVX]
            * VMOVLPD(m64, xmm)         [AVX512F]
            * VMOVLPD(xmm, xmm, m64)    [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VMOVLPD, self).__init__("VMOVLPD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 2:
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.out_operands = (True, False)
            self.avx_mode = True
            if is_m64(self.operands[0]) and is_xmm(self.operands[1]):
                self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(1, op[1].hcode, op[0].address, 0, vex3) + bytearray([0x13]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_m64(self.operands[0]) and is_evex_xmm(self.operands[1]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x85, 0b00, op[1].ehcode, op[0].address) + bytearray([0x13]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=8)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VMOVLPD " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 3:
            self.in_regs = (False, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m64(self.operands[2]):
                self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(1, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0x12]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_evex_xmm(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m64(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x85, 0b00, op[0].ehcode, op[2].address, op[1].code) + bytearray([0x12]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=8)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VMOVLPD " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VMOVLPD\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VMOVHPD(Instruction):
    """Move High Packed Double-Precision Floating-Point Value"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VMOVHPD(m64, xmm)         [AVX]
            * VMOVHPD(xmm, xmm, m64)    [AVX]
            * VMOVHPD(m64, xmm)         [AVX512F]
            * VMOVHPD(xmm, xmm, m64)    [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VMOVHPD, self).__init__("VMOVHPD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 2:
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.out_operands = (True, False)
            self.avx_mode = True
            if is_m64(self.operands[0]) and is_xmm(self.operands[1]):
                self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(1, op[1].hcode, op[0].address, 0, vex3) + bytearray([0x17]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_m64(self.operands[0]) and is_evex_xmm(self.operands[1]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x85, 0b00, op[1].ehcode, op[0].address) + bytearray([0x17]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=8)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VMOVHPD " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 3:
            self.in_regs = (False, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m64(self.operands[2]):
                self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(1, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0x16]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_evex_xmm(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m64(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x85, 0b00, op[0].ehcode, op[2].address, op[1].code) + bytearray([0x16]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=8)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VMOVHPD " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VMOVHPD\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VMASKMOVPD(Instruction):
    """Conditional Move Packed Double-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VMASKMOVPD(xmm, xmm, m128)    [AVX]
            * VMASKMOVPD(ymm, ymm, m256)    [AVX]
            * VMASKMOVPD(m128, xmm, xmm)    [AVX]
            * VMASKMOVPD(m256, ymm, ymm)    [AVX]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VMASKMOVPD, self).__init__("VMASKMOVPD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"VMASKMOVPD\" requires 3 operands")
        self.out_operands = (True, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x01, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x2D]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
            self.in_regs = (False, True, True)
            self.out_regs = (True, False, False)
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x05, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x2D]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
            self.in_regs = (False, True, True)
            self.out_regs = (True, False, False)
        elif is_m128(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x01, op[2].hcode, op[0].address, op[1].hlcode) + bytearray([0x2F]) + modrm_sib_disp(op[2].lcode, op[0].address, sib, min_disp)))
            self.in_regs = (True, True, True)
            self.out_regs = (False, False, False)
        elif is_m256(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x05, op[2].hcode, op[0].address, op[1].hlcode) + bytearray([0x2F]) + modrm_sib_disp(op[2].lcode, op[0].address, sib, min_disp)))
            self.in_regs = (True, True, True)
            self.out_regs = (False, False, False)
        else:
            raise SyntaxError("Invalid operand types: VMASKMOVPD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VMOVMSKPD(Instruction):
    """Extract Packed Double-Precision Floating-Point Sign Mask"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VMOVMSKPD(r32, xmm)    [AVX]
            * VMOVMSKPD(r32, ymm)    [AVX]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VMOVMSKPD, self).__init__("VMOVMSKPD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VMOVMSKPD\" requires 2 operands")
        self.in_regs = (False, True)
        self.out_regs = (True, False)
        self.out_operands = (True, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        if is_r32(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(1, op[0].hcode, op[1], 0, vex3) + bytearray([0x50, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
        elif is_r32(self.operands[0]) and is_ymm(self.operands[1]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(5, op[0].hcode, op[1], 0, vex3) + bytearray([0x50, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
        else:
            raise SyntaxError("Invalid operand types: VMOVMSKPD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VMOVNTPD(Instruction):
    """Store Packed Double-Precision Floating-Point Values Using Non-Temporal Hint"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VMOVNTPD(m128, xmm)    [AVX]
            * VMOVNTPD(m256, ymm)    [AVX]
            * VMOVNTPD(m512, zmm)    [AVX512F]
            * VMOVNTPD(m128, xmm)    [AVX512F and AVX512VL]
            * VMOVNTPD(m256, ymm)    [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VMOVNTPD, self).__init__("VMOVNTPD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VMOVNTPD\" requires 2 operands")
        self.in_regs = (True, True)
        self.out_regs = (False, False)
        self.out_operands = (True, False)
        self.avx_mode = True
        if is_m128(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(1, op[1].hcode, op[0].address, 0, vex3) + bytearray([0x2B]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_m256(self.operands[0]) and is_ymm(self.operands[1]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(5, op[1].hcode, op[0].address, 0, vex3) + bytearray([0x2B]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_m512(self.operands[0]) and is_zmm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x85, 0b10, op[1].ehcode, op[0].address) + bytearray([0x2B]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=64)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_m128(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x85, 0b00, op[1].ehcode, op[0].address) + bytearray([0x2B]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=16)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_m256(self.operands[0]) and is_evex_ymm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x85, 0b01, op[1].ehcode, op[0].address) + bytearray([0x2B]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=32)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: VMOVNTPD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VBROADCASTSD(Instruction):
    """Broadcast Double-Precision Floating-Point Element"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VBROADCASTSD(ymm, m64)              [AVX]
            * VBROADCASTSD(ymm, xmm)              [AVX2]
            * VBROADCASTSD(zmm{k}{z}, xmm/m64)    [AVX512F]
            * VBROADCASTSD(ymm{k}{z}, xmm/m64)    [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VBROADCASTSD, self).__init__("VBROADCASTSD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VBROADCASTSD\" requires 2 operands")
        self.in_regs = (False, True)
        self.out_regs = (True, False)
        self.out_operands = (True, False)
        self.avx_mode = True
        if is_ymm(self.operands[0]) and is_m64(self.operands[1]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x05, op[0].hcode, op[1].address) + bytearray([0x19]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_ymm(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x7D, 0x19, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx2])
        elif is_zmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x19, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_zmmkz(self.operands[0]) and is_m64(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b10, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x19]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=8)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD, (op[0].zcode << 7) | op[0].kcode | 0x28, 0x19, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_m64(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b01, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x19]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=8)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: VBROADCASTSD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VMOVDDUP(Instruction):
    """Move One Double-FP and Duplicate"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VMOVDDUP(xmm, xmm/m64)           [AVX]
            * VMOVDDUP(ymm, ymm/m256)          [AVX]
            * VMOVDDUP(zmm{k}{z}, zmm/m512)    [AVX512F]
            * VMOVDDUP(xmm{k}{z}, xmm/m64)     [AVX512F and AVX512VL]
            * VMOVDDUP(ymm{k}{z}, ymm/m256)    [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VMOVDDUP, self).__init__("VMOVDDUP", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VMOVDDUP\" requires 2 operands")
        self.in_regs = (False, True)
        self.out_regs = (True, False)
        self.out_operands = (True, False)
        self.avx_mode = True
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(3, op[0].hcode, op[1], 0, vex3) + bytearray([0x12, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_xmm(self.operands[0]) and is_m64(self.operands[1]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(3, op[0].hcode, op[1].address, 0, vex3) + bytearray([0x12]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(7, op[0].hcode, op[1], 0, vex3) + bytearray([0x12, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_ymm(self.operands[0]) and is_m256(self.operands[1]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(7, op[0].hcode, op[1].address, 0, vex3) + bytearray([0x12]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFF, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x12, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_zmmkz(self.operands[0]) and is_m512(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x87, 0b10, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x12]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=64)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFF, (op[0].zcode << 7) | op[0].kcode | 0x08, 0x12, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFF, (op[0].zcode << 7) | op[0].kcode | 0x28, 0x12, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_m64(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x87, 0b00, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x12]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=8)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_m256(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x87, 0b01, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x12]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=32)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: VMOVDDUP " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VEXPANDPD(Instruction):
    """Load Sparse Packed Double-Precision Floating-Point Values from Dense Memory"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VEXPANDPD(zmm{k}{z}, zmm/m512)    [AVX512F]
            * VEXPANDPD(ymm{k}{z}, ymm/m256)    [AVX512F and AVX512VL]
            * VEXPANDPD(xmm{k}{z}, xmm/m128)    [AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VEXPANDPD, self).__init__("VEXPANDPD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VEXPANDPD\" requires 2 operands")
        self.in_regs = (False, True)
        self.out_regs = (True, False)
        self.out_operands = (True, False)
        self.avx_mode = True
        if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x88, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_zmmkz(self.operands[0]) and is_m512(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b10, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x88]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=8)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD, (op[0].zcode << 7) | op[0].kcode | 0x08, 0x88, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl])
        elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD, (op[0].zcode << 7) | op[0].kcode | 0x28, 0x88, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_m128(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b00, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x88]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=8)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl])
        elif is_ymmkz(self.operands[0]) and is_m256(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b01, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x88]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=8)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: VEXPANDPD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VCOMPRESSPD(Instruction):
    """Store Sparse Packed Double-Precision Floating-Point Values into Dense Memory/Register"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VCOMPRESSPD(zmm{k}{z}, zmm)     [AVX512F]
            * VCOMPRESSPD(m512{k}{z}, zmm)    [AVX512F]
            * VCOMPRESSPD(xmm{k}{z}, xmm)     [AVX512F and AVX512VL]
            * VCOMPRESSPD(m128{k}{z}, xmm)    [AVX512F and AVX512VL]
            * VCOMPRESSPD(ymm{k}{z}, ymm)     [AVX512F and AVX512VL]
            * VCOMPRESSPD(m256{k}{z}, ymm)    [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VCOMPRESSPD, self).__init__("VCOMPRESSPD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VCOMPRESSPD\" requires 2 operands")
        self.out_operands = (True, False)
        self.avx_mode = True
        if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[1].hcode << 7) | (op[0].ehcode << 5) | (op[1].ecode << 4)) ^ 242, 0xFD, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x8A, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_m512kz(self.operands[0]) and is_zmm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b10, op[1].ehcode, op[0].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x8A]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=8)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[1].hcode << 7) | (op[0].ehcode << 5) | (op[1].ecode << 4)) ^ 242, 0xFD, (op[0].zcode << 7) | op[0].kcode | 0x08, 0x8A, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_m128kz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b00, op[1].ehcode, op[0].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x8A]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=8)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[1].hcode << 7) | (op[0].ehcode << 5) | (op[1].ecode << 4)) ^ 242, 0xFD, (op[0].zcode << 7) | op[0].kcode | 0x28, 0x8A, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_m256kz(self.operands[0]) and is_evex_ymm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b01, op[1].ehcode, op[0].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x8A]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=8)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: VCOMPRESSPD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VGATHERDPD(Instruction):
    """Gather Packed Double-Precision Floating-Point Values Using Signed Doubleword Indices"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VGATHERDPD(xmm, vm32x, xmm)    [AVX2]
            * VGATHERDPD(ymm, vm32x, ymm)    [AVX2]
            * VGATHERDPD(zmm{k}, vm32y)      [AVX512F]
            * VGATHERDPD(xmm{k}, vm32x)      [AVX512F and AVX512VL]
            * VGATHERDPD(ymm{k}, vm32x)      [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VGATHERDPD, self).__init__("VGATHERDPD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 2:
            self.in_regs = (True, True)
            self.out_regs = (True, False)
            self.out_operands = (True, False)
            self.avx_mode = True
            if is_zmmk(self.operands[0]) and is_evex_vmy(self.operands[1]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b10, op[0].ehcode, op[1].address, aaa=op[0].kcode) + bytearray([0x92]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=8)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmk(self.operands[0]) and is_evex_vmx(self.operands[1]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b00, op[0].ehcode, op[1].address, aaa=op[0].kcode) + bytearray([0x92]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=8)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmk(self.operands[0]) and is_evex_vmx(self.operands[1]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b01, op[0].ehcode, op[1].address, aaa=op[0].kcode) + bytearray([0x92]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=8)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VGATHERDPD " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 3:
            self.in_regs = (True, True, True)
            self.out_regs = (True, False, True)
            self.out_operands = (True, False, True)
            self.avx_mode = True
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx2])
            if is_xmm(self.operands[0]) and is_vmx(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x81, op[0].hcode, op[1].address, op[2].hlcode) + bytearray([0x92]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
            elif is_ymm(self.operands[0]) and is_vmx(self.operands[1]) and is_ymm(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x85, op[0].hcode, op[1].address, op[2].hlcode) + bytearray([0x92]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
            else:
                raise SyntaxError("Invalid operand types: VGATHERDPD " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VGATHERDPD\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VGATHERQPD(Instruction):
    """Gather Packed Double-Precision Floating-Point Values Using Signed Quadword Indices"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VGATHERQPD(xmm, vm64x, xmm)    [AVX2]
            * VGATHERQPD(ymm, vm64y, ymm)    [AVX2]
            * VGATHERQPD(zmm{k}, vm64z)      [AVX512F]
            * VGATHERQPD(xmm{k}, vm64x)      [AVX512F and AVX512VL]
            * VGATHERQPD(ymm{k}, vm64y)      [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VGATHERQPD, self).__init__("VGATHERQPD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 2:
            self.in_regs = (True, True)
            self.out_regs = (True, False)
            self.out_operands = (True, False)
            self.avx_mode = True
            if is_zmmk(self.operands[0]) and is_vmz(self.operands[1]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b10, op[0].ehcode, op[1].address, aaa=op[0].kcode) + bytearray([0x93]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=8)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmk(self.operands[0]) and is_evex_vmx(self.operands[1]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b00, op[0].ehcode, op[1].address, aaa=op[0].kcode) + bytearray([0x93]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=8)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmk(self.operands[0]) and is_evex_vmy(self.operands[1]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b01, op[0].ehcode, op[1].address, aaa=op[0].kcode) + bytearray([0x93]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=8)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VGATHERQPD " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 3:
            self.in_regs = (True, True, True)
            self.out_regs = (True, False, True)
            self.out_operands = (True, False, True)
            self.avx_mode = True
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx2])
            if is_xmm(self.operands[0]) and is_vmx(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x81, op[0].hcode, op[1].address, op[2].hlcode) + bytearray([0x93]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
            elif is_ymm(self.operands[0]) and is_vmy(self.operands[1]) and is_ymm(self.operands[2]):
                self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x85, op[0].hcode, op[1].address, op[2].hlcode) + bytearray([0x93]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
            else:
                raise SyntaxError("Invalid operand types: VGATHERQPD " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VGATHERQPD\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VGATHERPF0DPD(Instruction):
    """Sparse Prefetch Packed Double-Precision Floating-Point Data Values with Signed Doubleword Indices Using T0 Hint"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VGATHERPF0DPD(vm32y{k})    [AVX512PF]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VGATHERPF0DPD, self).__init__("VGATHERPF0DPD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 1:
            raise SyntaxError("Instruction \"VGATHERPF0DPD\" requires 1 operands")
        if is_vmyk(self.operands[0]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b10, 0, op[0].address, aaa=op[0].kcode) + bytearray([0xC6]) + modrm_sib_disp(1, op[0].address, sib, min_disp, disp8xN=8)))
            self.in_regs = (True,)
            self.out_regs = (False,)
            self.out_operands = (False,)
            self.avx_mode = True
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512pf])
        else:
            raise SyntaxError("Invalid operand types: VGATHERPF0DPD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VGATHERPF0QPD(Instruction):
    """Sparse Prefetch Packed Double-Precision Floating-Point Data Values with Signed Quadword Indices Using T0 Hint"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VGATHERPF0QPD(vm64z{k})    [AVX512PF]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VGATHERPF0QPD, self).__init__("VGATHERPF0QPD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 1:
            raise SyntaxError("Instruction \"VGATHERPF0QPD\" requires 1 operands")
        if is_vmzk(self.operands[0]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b10, 0, op[0].address, aaa=op[0].kcode) + bytearray([0xC7]) + modrm_sib_disp(1, op[0].address, sib, min_disp, disp8xN=8)))
            self.in_regs = (True,)
            self.out_regs = (False,)
            self.out_operands = (False,)
            self.avx_mode = True
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512pf])
        else:
            raise SyntaxError("Invalid operand types: VGATHERPF0QPD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VGATHERPF1DPD(Instruction):
    """Sparse Prefetch Packed Double-Precision Floating-Point Data Values with Signed Doubleword Indices Using T1 Hint"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VGATHERPF1DPD(vm32y{k})    [AVX512PF]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VGATHERPF1DPD, self).__init__("VGATHERPF1DPD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 1:
            raise SyntaxError("Instruction \"VGATHERPF1DPD\" requires 1 operands")
        if is_vmyk(self.operands[0]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b10, 0, op[0].address, aaa=op[0].kcode) + bytearray([0xC6]) + modrm_sib_disp(2, op[0].address, sib, min_disp, disp8xN=8)))
            self.in_regs = (True,)
            self.out_regs = (False,)
            self.out_operands = (False,)
            self.avx_mode = True
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512pf])
        else:
            raise SyntaxError("Invalid operand types: VGATHERPF1DPD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VGATHERPF1QPD(Instruction):
    """Sparse Prefetch Packed Double-Precision Floating-Point Data Values with Signed Quadword Indices Using T1 Hint"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VGATHERPF1QPD(vm64z{k})    [AVX512PF]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VGATHERPF1QPD, self).__init__("VGATHERPF1QPD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 1:
            raise SyntaxError("Instruction \"VGATHERPF1QPD\" requires 1 operands")
        if is_vmzk(self.operands[0]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b10, 0, op[0].address, aaa=op[0].kcode) + bytearray([0xC7]) + modrm_sib_disp(2, op[0].address, sib, min_disp, disp8xN=8)))
            self.in_regs = (True,)
            self.out_regs = (False,)
            self.out_operands = (False,)
            self.avx_mode = True
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512pf])
        else:
            raise SyntaxError("Invalid operand types: VGATHERPF1QPD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VSCATTERDPD(Instruction):
    """Scatter Packed Double-Precision Floating-Point Values with Signed Doubleword Indices"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VSCATTERDPD(vm32y{k}, zmm)    [AVX512F]
            * VSCATTERDPD(vm32x{k}, xmm)    [AVX512F and AVX512VL]
            * VSCATTERDPD(vm32x{k}, ymm)    [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VSCATTERDPD, self).__init__("VSCATTERDPD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VSCATTERDPD\" requires 2 operands")
        self.in_regs = (True, True)
        self.out_regs = (False, False)
        self.out_operands = (True, False)
        self.avx_mode = True
        if is_vmyk(self.operands[0]) and is_zmm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b10, op[1].ehcode, op[0].address, aaa=op[0].kcode) + bytearray([0xA2]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=8)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_vmxk(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b00, op[1].ehcode, op[0].address, aaa=op[0].kcode) + bytearray([0xA2]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=8)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_vmxk(self.operands[0]) and is_evex_ymm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b01, op[1].ehcode, op[0].address, aaa=op[0].kcode) + bytearray([0xA2]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=8)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: VSCATTERDPD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VSCATTERQPD(Instruction):
    """Scatter Packed Double-Precision Floating-Point Values with Signed Quadword Indices"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VSCATTERQPD(vm64z{k}, zmm)    [AVX512F]
            * VSCATTERQPD(vm64x{k}, xmm)    [AVX512F and AVX512VL]
            * VSCATTERQPD(vm64y{k}, ymm)    [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VSCATTERQPD, self).__init__("VSCATTERQPD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VSCATTERQPD\" requires 2 operands")
        self.in_regs = (True, True)
        self.out_regs = (False, False)
        self.out_operands = (True, False)
        self.avx_mode = True
        if is_vmzk(self.operands[0]) and is_zmm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b10, op[1].ehcode, op[0].address, aaa=op[0].kcode) + bytearray([0xA3]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=8)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_vmxk(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b00, op[1].ehcode, op[0].address, aaa=op[0].kcode) + bytearray([0xA3]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=8)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_vmyk(self.operands[0]) and is_evex_ymm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b01, op[1].ehcode, op[0].address, aaa=op[0].kcode) + bytearray([0xA3]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=8)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: VSCATTERQPD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VSCATTERPF0DPD(Instruction):
    """Sparse Prefetch Packed Double-Precision Floating-Point Data Values with Signed Doubleword Indices Using T0 Hint with Intent to Write"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VSCATTERPF0DPD(vm32y{k})    [AVX512PF]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VSCATTERPF0DPD, self).__init__("VSCATTERPF0DPD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 1:
            raise SyntaxError("Instruction \"VSCATTERPF0DPD\" requires 1 operands")
        if is_vmyk(self.operands[0]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b10, 0, op[0].address, aaa=op[0].kcode) + bytearray([0xC6]) + modrm_sib_disp(5, op[0].address, sib, min_disp, disp8xN=8)))
            self.in_regs = (True,)
            self.out_regs = (False,)
            self.out_operands = (False,)
            self.avx_mode = True
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512pf])
        else:
            raise SyntaxError("Invalid operand types: VSCATTERPF0DPD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VSCATTERPF0QPD(Instruction):
    """Sparse Prefetch Packed Double-Precision Floating-Point Data Values with Signed Quadword Indices Using T0 Hint with Intent to Write"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VSCATTERPF0QPD(vm64z{k})    [AVX512PF]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VSCATTERPF0QPD, self).__init__("VSCATTERPF0QPD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 1:
            raise SyntaxError("Instruction \"VSCATTERPF0QPD\" requires 1 operands")
        if is_vmzk(self.operands[0]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b10, 0, op[0].address, aaa=op[0].kcode) + bytearray([0xC7]) + modrm_sib_disp(5, op[0].address, sib, min_disp, disp8xN=8)))
            self.in_regs = (True,)
            self.out_regs = (False,)
            self.out_operands = (False,)
            self.avx_mode = True
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512pf])
        else:
            raise SyntaxError("Invalid operand types: VSCATTERPF0QPD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VSCATTERPF1DPD(Instruction):
    """Sparse Prefetch Packed Double-Precision Floating-Point Data Values with Signed Doubleword Indices Using T1 Hint with Intent to Write"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VSCATTERPF1DPD(vm32y{k})    [AVX512PF]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VSCATTERPF1DPD, self).__init__("VSCATTERPF1DPD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 1:
            raise SyntaxError("Instruction \"VSCATTERPF1DPD\" requires 1 operands")
        if is_vmyk(self.operands[0]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b10, 0, op[0].address, aaa=op[0].kcode) + bytearray([0xC6]) + modrm_sib_disp(6, op[0].address, sib, min_disp, disp8xN=8)))
            self.in_regs = (True,)
            self.out_regs = (False,)
            self.out_operands = (False,)
            self.avx_mode = True
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512pf])
        else:
            raise SyntaxError("Invalid operand types: VSCATTERPF1DPD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VSCATTERPF1QPD(Instruction):
    """Sparse Prefetch Packed Double-Precision Floating-Point Data Values with Signed Quadword Indices Using T1 Hint with Intent to Write"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VSCATTERPF1QPD(vm64z{k})    [AVX512PF]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VSCATTERPF1QPD, self).__init__("VSCATTERPF1QPD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 1:
            raise SyntaxError("Instruction \"VSCATTERPF1QPD\" requires 1 operands")
        if is_vmzk(self.operands[0]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b10, 0, op[0].address, aaa=op[0].kcode) + bytearray([0xC7]) + modrm_sib_disp(6, op[0].address, sib, min_disp, disp8xN=8)))
            self.in_regs = (True,)
            self.out_regs = (False,)
            self.out_operands = (False,)
            self.avx_mode = True
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512pf])
        else:
            raise SyntaxError("Invalid operand types: VSCATTERPF1QPD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VADDPS(Instruction):
    """Add Packed Single-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VADDPS(xmm, xmm, xmm/m128)              [AVX]
            * VADDPS(ymm, ymm, ymm/m256)              [AVX]
            * VADDPS(zmm{k}{z}, zmm, m512/m32bcst)    [AVX512F]
            * VADDPS(zmm{k}{z}, zmm, zmm, {er})       [AVX512F]
            * VADDPS(zmm{k}{z}, zmm, zmm)             [AVX512F]
            * VADDPS(xmm{k}{z}, xmm, m128/m32bcst)    [AVX512F and AVX512VL]
            * VADDPS(xmm{k}{z}, xmm, xmm)             [AVX512F and AVX512VL]
            * VADDPS(ymm{k}{z}, ymm, m256/m32bcst)    [AVX512F and AVX512VL]
            * VADDPS(ymm{k}{z}, ymm, ymm)             [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VADDPS, self).__init__("VADDPS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (False, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x40, lambda op, vex3=False: vex2(0, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0x58, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
                self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(0, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0x58]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]):
                self.encodings.append((0x40, lambda op, vex3=False: vex2(4, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0x58, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]):
                self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(4, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0x58]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_m512_m32bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x04, 0b10, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x58]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=64)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7C ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x58, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m128_m32bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x04, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x58]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=16)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7C ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0x58, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_m256_m32bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x04, 0b01, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x58]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=32)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_evex_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7C ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x20, 0x58, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VADDPS " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7C ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0x58, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (False, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VADDPS " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VADDPS\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VHADDPS(Instruction):
    """Packed Single-FP Horizontal Add"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VHADDPS(xmm, xmm, xmm/m128)    [AVX]
            * VHADDPS(ymm, ymm, ymm/m256)    [AVX]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VHADDPS, self).__init__("VHADDPS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"VHADDPS\" requires 3 operands")
        self.in_regs = (False, True, True)
        self.out_regs = (True, False, False)
        self.out_operands = (True, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(3, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0x7C, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(3, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0x7C]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(7, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0x7C, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(7, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0x7C]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
        else:
            raise SyntaxError("Invalid operand types: VHADDPS " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VSUBPS(Instruction):
    """Subtract Packed Single-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VSUBPS(xmm, xmm, xmm/m128)              [AVX]
            * VSUBPS(ymm, ymm, ymm/m256)              [AVX]
            * VSUBPS(zmm{k}{z}, zmm, m512/m32bcst)    [AVX512F]
            * VSUBPS(zmm{k}{z}, zmm, zmm, {er})       [AVX512F]
            * VSUBPS(zmm{k}{z}, zmm, zmm)             [AVX512F]
            * VSUBPS(xmm{k}{z}, xmm, m128/m32bcst)    [AVX512F and AVX512VL]
            * VSUBPS(xmm{k}{z}, xmm, xmm)             [AVX512F and AVX512VL]
            * VSUBPS(ymm{k}{z}, ymm, m256/m32bcst)    [AVX512F and AVX512VL]
            * VSUBPS(ymm{k}{z}, ymm, ymm)             [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VSUBPS, self).__init__("VSUBPS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (False, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x40, lambda op, vex3=False: vex2(0, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0x5C, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
                self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(0, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0x5C]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]):
                self.encodings.append((0x40, lambda op, vex3=False: vex2(4, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0x5C, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]):
                self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(4, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0x5C]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_m512_m32bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x04, 0b10, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x5C]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=64)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7C ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x5C, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m128_m32bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x04, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x5C]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=16)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7C ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0x5C, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_m256_m32bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x04, 0b01, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x5C]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=32)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_evex_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7C ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x20, 0x5C, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VSUBPS " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7C ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0x5C, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (False, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VSUBPS " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VSUBPS\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VHSUBPS(Instruction):
    """Packed Single-FP Horizontal Subtract"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VHSUBPS(xmm, xmm, xmm/m128)    [AVX]
            * VHSUBPS(ymm, ymm, ymm/m256)    [AVX]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VHSUBPS, self).__init__("VHSUBPS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"VHSUBPS\" requires 3 operands")
        self.in_regs = (False, True, True)
        self.out_regs = (True, False, False)
        self.out_operands = (True, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(3, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0x7D, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(3, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0x7D]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(7, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0x7D, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(7, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0x7D]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
        else:
            raise SyntaxError("Invalid operand types: VHSUBPS " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VADDSUBPS(Instruction):
    """Packed Single-FP Add/Subtract"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VADDSUBPS(xmm, xmm, xmm/m128)    [AVX]
            * VADDSUBPS(ymm, ymm, ymm/m256)    [AVX]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VADDSUBPS, self).__init__("VADDSUBPS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"VADDSUBPS\" requires 3 operands")
        self.in_regs = (False, True, True)
        self.out_regs = (True, False, False)
        self.out_operands = (True, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(3, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0xD0, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(3, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0xD0]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(7, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0xD0, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(7, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0xD0]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
        else:
            raise SyntaxError("Invalid operand types: VADDSUBPS " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VMULPS(Instruction):
    """Multiply Packed Single-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VMULPS(xmm, xmm, xmm/m128)              [AVX]
            * VMULPS(ymm, ymm, ymm/m256)              [AVX]
            * VMULPS(zmm{k}{z}, zmm, m512/m32bcst)    [AVX512F]
            * VMULPS(zmm{k}{z}, zmm, zmm, {er})       [AVX512F]
            * VMULPS(zmm{k}{z}, zmm, zmm)             [AVX512F]
            * VMULPS(xmm{k}{z}, xmm, m128/m32bcst)    [AVX512F and AVX512VL]
            * VMULPS(xmm{k}{z}, xmm, xmm)             [AVX512F and AVX512VL]
            * VMULPS(ymm{k}{z}, ymm, m256/m32bcst)    [AVX512F and AVX512VL]
            * VMULPS(ymm{k}{z}, ymm, ymm)             [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VMULPS, self).__init__("VMULPS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (False, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x40, lambda op, vex3=False: vex2(0, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0x59, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
                self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(0, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0x59]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]):
                self.encodings.append((0x40, lambda op, vex3=False: vex2(4, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0x59, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]):
                self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(4, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0x59]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_m512_m32bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x04, 0b10, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x59]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=64)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7C ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x59, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m128_m32bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x04, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x59]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=16)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7C ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0x59, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_m256_m32bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x04, 0b01, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x59]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=32)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_evex_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7C ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x20, 0x59, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VMULPS " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7C ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0x59, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (False, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VMULPS " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VMULPS\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VDIVPS(Instruction):
    """Divide Packed Single-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VDIVPS(xmm, xmm, xmm/m128)              [AVX]
            * VDIVPS(ymm, ymm, ymm/m256)              [AVX]
            * VDIVPS(zmm{k}{z}, zmm, m512/m32bcst)    [AVX512F]
            * VDIVPS(zmm{k}{z}, zmm, zmm, {er})       [AVX512F]
            * VDIVPS(zmm{k}{z}, zmm, zmm)             [AVX512F]
            * VDIVPS(xmm{k}{z}, xmm, m128/m32bcst)    [AVX512F and AVX512VL]
            * VDIVPS(xmm{k}{z}, xmm, xmm)             [AVX512F and AVX512VL]
            * VDIVPS(ymm{k}{z}, ymm, m256/m32bcst)    [AVX512F and AVX512VL]
            * VDIVPS(ymm{k}{z}, ymm, ymm)             [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VDIVPS, self).__init__("VDIVPS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (False, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x40, lambda op, vex3=False: vex2(0, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0x5E, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
                self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(0, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0x5E]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]):
                self.encodings.append((0x40, lambda op, vex3=False: vex2(4, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0x5E, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]):
                self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(4, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0x5E]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_m512_m32bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x04, 0b10, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x5E]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=64)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7C ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x5E, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m128_m32bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x04, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x5E]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=16)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7C ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0x5E, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_m256_m32bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x04, 0b01, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x5E]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=32)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_evex_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7C ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x20, 0x5E, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VDIVPS " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7C ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0x5E, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (False, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VDIVPS " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VDIVPS\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VSQRTPS(Instruction):
    """Compute Square Roots of Packed Single-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VSQRTPS(xmm, xmm/m128)              [AVX]
            * VSQRTPS(ymm, ymm/m256)              [AVX]
            * VSQRTPS(zmm{k}{z}, m512/m32bcst)    [AVX512F]
            * VSQRTPS(zmm{k}{z}, zmm, {er})       [AVX512F]
            * VSQRTPS(zmm{k}{z}, zmm)             [AVX512F]
            * VSQRTPS(xmm{k}{z}, m128/m32bcst)    [AVX512F and AVX512VL]
            * VSQRTPS(ymm{k}{z}, m256/m32bcst)    [AVX512F and AVX512VL]
            * VSQRTPS(xmm{k}{z}, xmm)             [AVX512F and AVX512VL]
            * VSQRTPS(ymm{k}{z}, ymm)             [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VSQRTPS, self).__init__("VSQRTPS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 2:
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.out_operands = (True, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]):
                self.encodings.append((0x40, lambda op, vex3=False: vex2(0, op[0].hcode, op[1], 0, vex3) + bytearray([0x51, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_xmm(self.operands[0]) and is_m128(self.operands[1]):
                self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(0, op[0].hcode, op[1].address, 0, vex3) + bytearray([0x51]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]):
                self.encodings.append((0x40, lambda op, vex3=False: vex2(4, op[0].hcode, op[1], 0, vex3) + bytearray([0x51, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_ymm(self.operands[0]) and is_m256(self.operands[1]):
                self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(4, op[0].hcode, op[1].address, 0, vex3) + bytearray([0x51]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_zmmkz(self.operands[0]) and is_m512_m32bcst(self.operands[1]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x04, 0b10, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode, b=op[1].bcode) + bytearray([0x51]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=64)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7C, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x51, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_m128_m32bcst(self.operands[1]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x04, 0b00, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode, b=op[1].bcode) + bytearray([0x51]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=16)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_m256_m32bcst(self.operands[1]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x04, 0b01, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode, b=op[1].bcode) + bytearray([0x51]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=32)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7C, (op[0].zcode << 7) | op[0].kcode | 0x08, 0x51, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7C, (op[0].zcode << 7) | op[0].kcode | 0x28, 0x51, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VSQRTPS " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 3:
            if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_er(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7C, (op[0].zcode << 7) | (op[2].code << 5) | op[0].kcode | 0x18, 0x51, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
                self.in_regs = (False, True, False)
                self.out_regs = (True, False, False)
                self.out_operands = (True, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VSQRTPS " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VSQRTPS\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VADDPD(Instruction):
    """Add Packed Double-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VADDPD(xmm, xmm, xmm/m128)              [AVX]
            * VADDPD(ymm, ymm, ymm/m256)              [AVX]
            * VADDPD(zmm{k}{z}, zmm, m512/m64bcst)    [AVX512F]
            * VADDPD(zmm{k}{z}, zmm, zmm, {er})       [AVX512F]
            * VADDPD(zmm{k}{z}, zmm, zmm)             [AVX512F]
            * VADDPD(xmm{k}{z}, xmm, m128/m64bcst)    [AVX512F and AVX512VL]
            * VADDPD(xmm{k}{z}, xmm, xmm)             [AVX512F and AVX512VL]
            * VADDPD(ymm{k}{z}, ymm, m256/m64bcst)    [AVX512F and AVX512VL]
            * VADDPD(ymm{k}{z}, ymm, ymm)             [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VADDPD, self).__init__("VADDPD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (False, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x40, lambda op, vex3=False: vex2(1, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0x58, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
                self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(1, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0x58]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]):
                self.encodings.append((0x40, lambda op, vex3=False: vex2(5, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0x58, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]):
                self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(5, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0x58]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_m512_m64bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x85, 0b10, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x58]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=64)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x58, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m128_m64bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x85, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x58]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=16)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0x58, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_m256_m64bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x85, 0b01, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x58]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=32)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_evex_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x20, 0x58, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VADDPD " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0x58, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (False, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VADDPD " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VADDPD\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VHADDPD(Instruction):
    """Packed Double-FP Horizontal Add"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VHADDPD(xmm, xmm, xmm/m128)    [AVX]
            * VHADDPD(ymm, ymm, ymm/m256)    [AVX]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VHADDPD, self).__init__("VHADDPD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"VHADDPD\" requires 3 operands")
        self.in_regs = (False, True, True)
        self.out_regs = (True, False, False)
        self.out_operands = (True, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(1, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0x7C, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(1, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0x7C]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(5, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0x7C, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(5, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0x7C]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
        else:
            raise SyntaxError("Invalid operand types: VHADDPD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VSUBPD(Instruction):
    """Subtract Packed Double-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VSUBPD(xmm, xmm, xmm/m128)              [AVX]
            * VSUBPD(ymm, ymm, ymm/m256)              [AVX]
            * VSUBPD(zmm{k}{z}, zmm, m512/m64bcst)    [AVX512F]
            * VSUBPD(zmm{k}{z}, zmm, zmm, {er})       [AVX512F]
            * VSUBPD(zmm{k}{z}, zmm, zmm)             [AVX512F]
            * VSUBPD(xmm{k}{z}, xmm, m128/m64bcst)    [AVX512F and AVX512VL]
            * VSUBPD(xmm{k}{z}, xmm, xmm)             [AVX512F and AVX512VL]
            * VSUBPD(ymm{k}{z}, ymm, m256/m64bcst)    [AVX512F and AVX512VL]
            * VSUBPD(ymm{k}{z}, ymm, ymm)             [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VSUBPD, self).__init__("VSUBPD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (False, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x40, lambda op, vex3=False: vex2(1, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0x5C, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
                self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(1, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0x5C]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]):
                self.encodings.append((0x40, lambda op, vex3=False: vex2(5, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0x5C, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]):
                self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(5, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0x5C]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_m512_m64bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x85, 0b10, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x5C]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=64)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x5C, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m128_m64bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x85, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x5C]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=16)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0x5C, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_m256_m64bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x85, 0b01, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x5C]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=32)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_evex_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x20, 0x5C, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VSUBPD " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0x5C, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (False, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VSUBPD " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VSUBPD\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VHSUBPD(Instruction):
    """Packed Double-FP Horizontal Subtract"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VHSUBPD(xmm, xmm, xmm/m128)    [AVX]
            * VHSUBPD(ymm, ymm, ymm/m256)    [AVX]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VHSUBPD, self).__init__("VHSUBPD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"VHSUBPD\" requires 3 operands")
        self.in_regs = (False, True, True)
        self.out_regs = (True, False, False)
        self.out_operands = (True, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(1, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0x7D, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(1, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0x7D]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(5, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0x7D, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(5, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0x7D]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
        else:
            raise SyntaxError("Invalid operand types: VHSUBPD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VADDSUBPD(Instruction):
    """Packed Double-FP Add/Subtract"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VADDSUBPD(xmm, xmm, xmm/m128)    [AVX]
            * VADDSUBPD(ymm, ymm, ymm/m256)    [AVX]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VADDSUBPD, self).__init__("VADDSUBPD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"VADDSUBPD\" requires 3 operands")
        self.in_regs = (False, True, True)
        self.out_regs = (True, False, False)
        self.out_operands = (True, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(1, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0xD0, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(1, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0xD0]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(5, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0xD0, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(5, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0xD0]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
        else:
            raise SyntaxError("Invalid operand types: VADDSUBPD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VMULPD(Instruction):
    """Multiply Packed Double-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VMULPD(xmm, xmm, xmm/m128)              [AVX]
            * VMULPD(ymm, ymm, ymm/m256)              [AVX]
            * VMULPD(zmm{k}{z}, zmm, m512/m64bcst)    [AVX512F]
            * VMULPD(zmm{k}{z}, zmm, zmm, {er})       [AVX512F]
            * VMULPD(zmm{k}{z}, zmm, zmm)             [AVX512F]
            * VMULPD(xmm{k}{z}, xmm, m128/m64bcst)    [AVX512F and AVX512VL]
            * VMULPD(xmm{k}{z}, xmm, xmm)             [AVX512F and AVX512VL]
            * VMULPD(ymm{k}{z}, ymm, m256/m64bcst)    [AVX512F and AVX512VL]
            * VMULPD(ymm{k}{z}, ymm, ymm)             [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VMULPD, self).__init__("VMULPD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (False, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x40, lambda op, vex3=False: vex2(1, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0x59, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
                self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(1, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0x59]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]):
                self.encodings.append((0x40, lambda op, vex3=False: vex2(5, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0x59, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]):
                self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(5, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0x59]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_m512_m64bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x85, 0b10, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x59]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=64)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x59, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m128_m64bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x85, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x59]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=16)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0x59, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_m256_m64bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x85, 0b01, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x59]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=32)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_evex_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x20, 0x59, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VMULPD " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0x59, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (False, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VMULPD " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VMULPD\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VDIVPD(Instruction):
    """Divide Packed Double-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VDIVPD(xmm, xmm, xmm/m128)              [AVX]
            * VDIVPD(ymm, ymm, ymm/m256)              [AVX]
            * VDIVPD(zmm{k}{z}, zmm, m512/m64bcst)    [AVX512F]
            * VDIVPD(zmm{k}{z}, zmm, zmm, {er})       [AVX512F]
            * VDIVPD(zmm{k}{z}, zmm, zmm)             [AVX512F]
            * VDIVPD(xmm{k}{z}, xmm, m128/m64bcst)    [AVX512F and AVX512VL]
            * VDIVPD(xmm{k}{z}, xmm, xmm)             [AVX512F and AVX512VL]
            * VDIVPD(ymm{k}{z}, ymm, m256/m64bcst)    [AVX512F and AVX512VL]
            * VDIVPD(ymm{k}{z}, ymm, ymm)             [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VDIVPD, self).__init__("VDIVPD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (False, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x40, lambda op, vex3=False: vex2(1, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0x5E, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
                self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(1, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0x5E]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]):
                self.encodings.append((0x40, lambda op, vex3=False: vex2(5, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0x5E, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]):
                self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(5, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0x5E]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_m512_m64bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x85, 0b10, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x5E]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=64)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x5E, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m128_m64bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x85, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x5E]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=16)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0x5E, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_m256_m64bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x85, 0b01, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x5E]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=32)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_evex_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x20, 0x5E, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VDIVPD " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0x5E, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (False, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VDIVPD " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VDIVPD\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VSQRTPD(Instruction):
    """Compute Square Roots of Packed Double-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VSQRTPD(xmm, xmm/m128)              [AVX]
            * VSQRTPD(ymm, ymm/m256)              [AVX]
            * VSQRTPD(zmm{k}{z}, m512/m64bcst)    [AVX512F]
            * VSQRTPD(zmm{k}{z}, zmm, {er})       [AVX512F]
            * VSQRTPD(zmm{k}{z}, zmm)             [AVX512F]
            * VSQRTPD(xmm{k}{z}, m128/m32bcst)    [AVX512F and AVX512VL]
            * VSQRTPD(ymm{k}{z}, m256/m32bcst)    [AVX512F and AVX512VL]
            * VSQRTPD(xmm{k}{z}, xmm)             [AVX512F and AVX512VL]
            * VSQRTPD(ymm{k}{z}, ymm)             [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VSQRTPD, self).__init__("VSQRTPD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 2:
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.out_operands = (True, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]):
                self.encodings.append((0x40, lambda op, vex3=False: vex2(1, op[0].hcode, op[1], 0, vex3) + bytearray([0x51, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_xmm(self.operands[0]) and is_m128(self.operands[1]):
                self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(1, op[0].hcode, op[1].address, 0, vex3) + bytearray([0x51]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]):
                self.encodings.append((0x40, lambda op, vex3=False: vex2(5, op[0].hcode, op[1], 0, vex3) + bytearray([0x51, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_ymm(self.operands[0]) and is_m256(self.operands[1]):
                self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(5, op[0].hcode, op[1].address, 0, vex3) + bytearray([0x51]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_zmmkz(self.operands[0]) and is_m512_m64bcst(self.operands[1]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x85, 0b10, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode, b=op[1].bcode) + bytearray([0x51]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=64)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFD, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x51, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_m128_m32bcst(self.operands[1]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x85, 0b00, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode, b=op[1].bcode) + bytearray([0x51]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=16)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_m256_m32bcst(self.operands[1]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x85, 0b01, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode, b=op[1].bcode) + bytearray([0x51]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=32)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFD, (op[0].zcode << 7) | op[0].kcode | 0x08, 0x51, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFD, (op[0].zcode << 7) | op[0].kcode | 0x28, 0x51, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VSQRTPD " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 3:
            if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_er(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFD, (op[0].zcode << 7) | (op[2].code << 5) | op[0].kcode | 0x18, 0x51, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
                self.in_regs = (False, True, False)
                self.out_regs = (True, False, False)
                self.out_operands = (True, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VSQRTPD " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VSQRTPD\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VROUNDPS(Instruction):
    """Round Packed Single Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VROUNDPS(xmm, xmm/m128, imm8)    [AVX]
            * VROUNDPS(ymm, ymm/m256, imm8)    [AVX]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VROUNDPS, self).__init__("VROUNDPS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"VROUNDPS\" requires 3 operands")
        self.in_regs = (False, True, False)
        self.out_regs = (True, False, False)
        self.out_operands = (True, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x79, 0x08, 0xC0 | op[0].lcode << 3 | op[1].lcode, op[2] & 0xFF])))
        elif is_xmm(self.operands[0]) and is_m128(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x01, op[0].hcode, op[1].address) + bytearray([0x08]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp) + bytearray([op[2] & 0xFF])))
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x7D, 0x08, 0xC0 | op[0].lcode << 3 | op[1].lcode, op[2] & 0xFF])))
        elif is_ymm(self.operands[0]) and is_m256(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x05, op[0].hcode, op[1].address) + bytearray([0x08]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp) + bytearray([op[2] & 0xFF])))
        else:
            raise SyntaxError("Invalid operand types: VROUNDPS " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VRNDSCALEPS(Instruction):
    """Round Packed Single-Precision Floating-Point Values To Include A Given Number Of Fraction Bits"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VRNDSCALEPS(zmm{k}{z}, m512/m32bcst, imm8)    [AVX512F]
            * VRNDSCALEPS(zmm{k}{z}, zmm, {sae}, imm8)      [AVX512F]
            * VRNDSCALEPS(zmm{k}{z}, zmm, imm8)             [AVX512F]
            * VRNDSCALEPS(xmm{k}{z}, m128/m32bcst, imm8)    [AVX512F and AVX512VL]
            * VRNDSCALEPS(ymm{k}{z}, m256/m32bcst, imm8)    [AVX512F and AVX512VL]
            * VRNDSCALEPS(xmm{k}{z}, xmm, imm8)             [AVX512F and AVX512VL]
            * VRNDSCALEPS(ymm{k}{z}, ymm, imm8)             [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VRNDSCALEPS, self).__init__("VRNDSCALEPS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (False, True, False)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_zmmkz(self.operands[0]) and is_m512_m32bcst(self.operands[1]) and is_imm(self.operands[2]):
                if not is_imm8(self.operands[2]):
                    raise ValueError("Argument #2 can not be encoded as imm8")
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b11, 0x05, 0b10, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode, b=op[1].bcode) + bytearray([0x08]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=64) + bytearray([op[2] & 0xFF])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_imm(self.operands[2]):
                if not is_imm8(self.operands[2]):
                    raise ValueError("Argument #2 can not be encoded as imm8")
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 243, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x08, 0xC0 | op[0].lcode << 3 | op[1].lcode, op[2] & 0xFF])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_m128_m32bcst(self.operands[1]) and is_imm(self.operands[2]):
                if not is_imm8(self.operands[2]):
                    raise ValueError("Argument #2 can not be encoded as imm8")
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b11, 0x05, 0b00, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode, b=op[1].bcode) + bytearray([0x08]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=16) + bytearray([op[2] & 0xFF])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_m256_m32bcst(self.operands[1]) and is_imm(self.operands[2]):
                if not is_imm8(self.operands[2]):
                    raise ValueError("Argument #2 can not be encoded as imm8")
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b11, 0x05, 0b01, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode, b=op[1].bcode) + bytearray([0x08]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=32) + bytearray([op[2] & 0xFF])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_imm(self.operands[2]):
                if not is_imm8(self.operands[2]):
                    raise ValueError("Argument #2 can not be encoded as imm8")
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 243, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x08, 0x08, 0xC0 | op[0].lcode << 3 | op[1].lcode, op[2] & 0xFF])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_imm(self.operands[2]):
                if not is_imm8(self.operands[2]):
                    raise ValueError("Argument #2 can not be encoded as imm8")
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 243, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x28, 0x08, 0xC0 | op[0].lcode << 3 | op[1].lcode, op[2] & 0xFF])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VRNDSCALEPS " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_sae(self.operands[2]) and is_imm(self.operands[3]):
                if not is_imm8(self.operands[3]):
                    raise ValueError("Argument #3 can not be encoded as imm8")
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 243, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x18, 0x08, 0xC0 | op[0].lcode << 3 | op[1].lcode, op[3] & 0xFF])))
                self.in_regs = (False, True, False, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VRNDSCALEPS " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VRNDSCALEPS\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VRANGEPS(Instruction):
    """Range Restriction Calculation For Packed Pairs of Single-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VRANGEPS(zmm{k}{z}, zmm, m512/m32bcst, imm8)    [AVX512DQ]
            * VRANGEPS(zmm{k}{z}, zmm, zmm, {sae}, imm8)      [AVX512DQ]
            * VRANGEPS(zmm{k}{z}, zmm, zmm, imm8)             [AVX512DQ]
            * VRANGEPS(xmm{k}{z}, xmm, m128/m32bcst, imm8)    [AVX512DQ and AVX512VL]
            * VRANGEPS(xmm{k}{z}, xmm, xmm, imm8)             [AVX512DQ and AVX512VL]
            * VRANGEPS(ymm{k}{z}, ymm, m256/m32bcst, imm8)    [AVX512DQ and AVX512VL]
            * VRANGEPS(ymm{k}{z}, ymm, ymm, imm8)             [AVX512DQ and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VRANGEPS, self).__init__("VRANGEPS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 4:
            self.in_regs = (False, True, True, False)
            self.out_regs = (True, False, False, False)
            self.out_operands = (True, False, False, False)
            self.avx_mode = True
            if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_m512_m32bcst(self.operands[2]) and is_imm(self.operands[3]):
                if not is_imm8(self.operands[3]):
                    raise ValueError("Argument #3 can not be encoded as imm8")
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b11, 0x05, 0b10, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x50]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=64) + bytearray([op[3] & 0xFF])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512dq])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]) and is_imm(self.operands[3]):
                if not is_imm8(self.operands[3]):
                    raise ValueError("Argument #3 can not be encoded as imm8")
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 243, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x50, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3] & 0xFF])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512dq])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m128_m32bcst(self.operands[2]) and is_imm(self.operands[3]):
                if not is_imm8(self.operands[3]):
                    raise ValueError("Argument #3 can not be encoded as imm8")
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b11, 0x05, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x50]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=16) + bytearray([op[3] & 0xFF])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512dq])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]) and is_imm(self.operands[3]):
                if not is_imm8(self.operands[3]):
                    raise ValueError("Argument #3 can not be encoded as imm8")
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 243, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0x50, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3] & 0xFF])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512dq])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_m256_m32bcst(self.operands[2]) and is_imm(self.operands[3]):
                if not is_imm8(self.operands[3]):
                    raise ValueError("Argument #3 can not be encoded as imm8")
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b11, 0x05, 0b01, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x50]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=32) + bytearray([op[3] & 0xFF])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512dq])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_evex_ymm(self.operands[2]) and is_imm(self.operands[3]):
                if not is_imm8(self.operands[3]):
                    raise ValueError("Argument #3 can not be encoded as imm8")
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 243, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x20, 0x50, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3] & 0xFF])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512dq])
            else:
                raise SyntaxError("Invalid operand types: VRANGEPS " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 5:
            if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]) and is_sae(self.operands[3]) and is_imm(self.operands[4]):
                if not is_imm8(self.operands[4]):
                    raise ValueError("Argument #4 can not be encoded as imm8")
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 243, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0x50, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[4] & 0xFF])))
                self.in_regs = (False, True, True, False, False)
                self.out_regs = (True, False, False, False, False)
                self.out_operands = (True, False, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512dq])
            else:
                raise SyntaxError("Invalid operand types: VRANGEPS " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VRANGEPS\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VMINPS(Instruction):
    """Return Minimum Packed Single-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VMINPS(xmm, xmm, xmm/m128)              [AVX]
            * VMINPS(ymm, ymm, ymm/m256)              [AVX]
            * VMINPS(zmm{k}{z}, zmm, m512/m32bcst)    [AVX512F]
            * VMINPS(zmm{k}{z}, zmm, zmm, {sae})      [AVX512F]
            * VMINPS(zmm{k}{z}, zmm, zmm)             [AVX512F]
            * VMINPS(xmm{k}{z}, xmm, m128/m32bcst)    [AVX512F and AVX512VL]
            * VMINPS(xmm{k}{z}, xmm, xmm)             [AVX512F and AVX512VL]
            * VMINPS(ymm{k}{z}, ymm, m256/m32bcst)    [AVX512F and AVX512VL]
            * VMINPS(ymm{k}{z}, ymm, ymm)             [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VMINPS, self).__init__("VMINPS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (False, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x40, lambda op, vex3=False: vex2(0, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0x5D, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
                self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(0, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0x5D]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]):
                self.encodings.append((0x40, lambda op, vex3=False: vex2(4, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0x5D, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]):
                self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(4, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0x5D]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_m512_m32bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x04, 0b10, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x5D]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=64)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7C ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x5D, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m128_m32bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x04, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x5D]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=16)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7C ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0x5D, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_m256_m32bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x04, 0b01, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x5D]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=32)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_evex_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7C ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x20, 0x5D, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VMINPS " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]) and is_sae(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7C ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0x5D, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (False, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VMINPS " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VMINPS\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VMAXPS(Instruction):
    """Return Maximum Packed Single-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VMAXPS(xmm, xmm, xmm/m128)              [AVX]
            * VMAXPS(ymm, ymm, ymm/m256)              [AVX]
            * VMAXPS(zmm{k}{z}, zmm, m512/m32bcst)    [AVX512F]
            * VMAXPS(zmm{k}{z}, zmm, zmm, {sae})      [AVX512F]
            * VMAXPS(zmm{k}{z}, zmm, zmm)             [AVX512F]
            * VMAXPS(xmm{k}{z}, xmm, m128/m32bcst)    [AVX512F and AVX512VL]
            * VMAXPS(xmm{k}{z}, xmm, xmm)             [AVX512F and AVX512VL]
            * VMAXPS(ymm{k}{z}, ymm, m256/m32bcst)    [AVX512F and AVX512VL]
            * VMAXPS(ymm{k}{z}, ymm, ymm)             [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VMAXPS, self).__init__("VMAXPS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (False, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x40, lambda op, vex3=False: vex2(0, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0x5F, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
                self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(0, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0x5F]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]):
                self.encodings.append((0x40, lambda op, vex3=False: vex2(4, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0x5F, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]):
                self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(4, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0x5F]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_m512_m32bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x04, 0b10, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x5F]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=64)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7C ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x5F, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m128_m32bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x04, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x5F]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=16)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7C ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0x5F, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_m256_m32bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x04, 0b01, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x5F]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=32)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_evex_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7C ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x20, 0x5F, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VMAXPS " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]) and is_sae(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7C ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0x5F, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (False, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VMAXPS " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VMAXPS\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VREDUCEPS(Instruction):
    """Perform Reduction Transformation on Packed Single-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VREDUCEPS(zmm{k}{z}, m512/m32bcst, imm8)    [AVX512DQ]
            * VREDUCEPS(zmm{k}{z}, zmm, imm8)             [AVX512DQ]
            * VREDUCEPS(xmm{k}{z}, m128/m32bcst, imm8)    [AVX512DQ and AVX512VL]
            * VREDUCEPS(ymm{k}{z}, m256/m32bcst, imm8)    [AVX512DQ and AVX512VL]
            * VREDUCEPS(xmm{k}{z}, xmm, imm8)             [AVX512DQ and AVX512VL]
            * VREDUCEPS(ymm{k}{z}, ymm, imm8)             [AVX512DQ and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VREDUCEPS, self).__init__("VREDUCEPS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"VREDUCEPS\" requires 3 operands")
        self.in_regs = (False, True, False)
        self.out_regs = (True, False, False)
        self.out_operands = (True, False, False)
        self.avx_mode = True
        if is_zmmkz(self.operands[0]) and is_m512_m32bcst(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b11, 0x05, 0b10, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode, b=op[1].bcode) + bytearray([0x56]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=64) + bytearray([op[2] & 0xFF])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512dq])
        elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 243, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x56, 0xC0 | op[0].lcode << 3 | op[1].lcode, op[2] & 0xFF])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512dq])
        elif is_xmmkz(self.operands[0]) and is_m128_m32bcst(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b11, 0x05, 0b00, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode, b=op[1].bcode) + bytearray([0x56]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=16) + bytearray([op[2] & 0xFF])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512dq])
        elif is_ymmkz(self.operands[0]) and is_m256_m32bcst(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b11, 0x05, 0b01, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode, b=op[1].bcode) + bytearray([0x56]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=32) + bytearray([op[2] & 0xFF])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512dq])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 243, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x08, 0x56, 0xC0 | op[0].lcode << 3 | op[1].lcode, op[2] & 0xFF])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512dq])
        elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 243, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x28, 0x56, 0xC0 | op[0].lcode << 3 | op[1].lcode, op[2] & 0xFF])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512dq])
        else:
            raise SyntaxError("Invalid operand types: VREDUCEPS " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VDPPS(Instruction):
    """Dot Product of Packed Single Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VDPPS(xmm, xmm, xmm/m128, imm8)    [AVX]
            * VDPPS(ymm, ymm, ymm/m256, imm8)    [AVX]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VDPPS, self).__init__("VDPPS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 4:
            raise SyntaxError("Instruction \"VDPPS\" requires 4 operands")
        self.in_regs = (False, True, True, False)
        self.out_regs = (True, False, False, False)
        self.out_operands = (True, False, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_imm(self.operands[3]):
            if not is_imm8(self.operands[3]):
                raise ValueError("Argument #3 can not be encoded as imm8")
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x79 ^ (op[1].hlcode << 3), 0x40, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3] & 0xFF])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]) and is_imm(self.operands[3]):
            if not is_imm8(self.operands[3]):
                raise ValueError("Argument #3 can not be encoded as imm8")
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x01, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x40]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3] & 0xFF])))
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]) and is_imm(self.operands[3]):
            if not is_imm8(self.operands[3]):
                raise ValueError("Argument #3 can not be encoded as imm8")
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x7D ^ (op[1].hlcode << 3), 0x40, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3] & 0xFF])))
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]) and is_imm(self.operands[3]):
            if not is_imm8(self.operands[3]):
                raise ValueError("Argument #3 can not be encoded as imm8")
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x05, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x40]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3] & 0xFF])))
        else:
            raise SyntaxError("Invalid operand types: VDPPS " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VGETMANTPS(Instruction):
    """Extract Normalized Mantissas from Packed Single-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VGETMANTPS(zmm{k}{z}, m512/m32bcst, imm8)    [AVX512F]
            * VGETMANTPS(zmm{k}{z}, zmm, {sae}, imm8)      [AVX512F]
            * VGETMANTPS(zmm{k}{z}, zmm, imm8)             [AVX512F]
            * VGETMANTPS(xmm{k}{z}, m128/m32bcst, imm8)    [AVX512F and AVX512VL]
            * VGETMANTPS(ymm{k}{z}, m256/m32bcst, imm8)    [AVX512F and AVX512VL]
            * VGETMANTPS(xmm{k}{z}, xmm, imm8)             [AVX512F and AVX512VL]
            * VGETMANTPS(ymm{k}{z}, ymm, imm8)             [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VGETMANTPS, self).__init__("VGETMANTPS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (False, True, False)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_zmmkz(self.operands[0]) and is_m512_m32bcst(self.operands[1]) and is_imm(self.operands[2]):
                if not is_imm8(self.operands[2]):
                    raise ValueError("Argument #2 can not be encoded as imm8")
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b11, 0x05, 0b10, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode, b=op[1].bcode) + bytearray([0x26]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=64) + bytearray([op[2] & 0xFF])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_imm(self.operands[2]):
                if not is_imm8(self.operands[2]):
                    raise ValueError("Argument #2 can not be encoded as imm8")
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 243, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x26, 0xC0 | op[0].lcode << 3 | op[1].lcode, op[2] & 0xFF])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_m128_m32bcst(self.operands[1]) and is_imm(self.operands[2]):
                if not is_imm8(self.operands[2]):
                    raise ValueError("Argument #2 can not be encoded as imm8")
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b11, 0x05, 0b00, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode, b=op[1].bcode) + bytearray([0x26]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=16) + bytearray([op[2] & 0xFF])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_m256_m32bcst(self.operands[1]) and is_imm(self.operands[2]):
                if not is_imm8(self.operands[2]):
                    raise ValueError("Argument #2 can not be encoded as imm8")
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b11, 0x05, 0b01, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode, b=op[1].bcode) + bytearray([0x26]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=32) + bytearray([op[2] & 0xFF])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_imm(self.operands[2]):
                if not is_imm8(self.operands[2]):
                    raise ValueError("Argument #2 can not be encoded as imm8")
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 243, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x08, 0x26, 0xC0 | op[0].lcode << 3 | op[1].lcode, op[2] & 0xFF])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_imm(self.operands[2]):
                if not is_imm8(self.operands[2]):
                    raise ValueError("Argument #2 can not be encoded as imm8")
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 243, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x28, 0x26, 0xC0 | op[0].lcode << 3 | op[1].lcode, op[2] & 0xFF])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VGETMANTPS " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_sae(self.operands[2]) and is_imm(self.operands[3]):
                if not is_imm8(self.operands[3]):
                    raise ValueError("Argument #3 can not be encoded as imm8")
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 243, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x18, 0x26, 0xC0 | op[0].lcode << 3 | op[1].lcode, op[3] & 0xFF])))
                self.in_regs = (False, True, False, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VGETMANTPS " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VGETMANTPS\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VGETEXPPS(Instruction):
    """Extract Exponents of Packed Single-Precision Floating-Point Values as Single-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VGETEXPPS(zmm{k}{z}, m512/m32bcst)    [AVX512F]
            * VGETEXPPS(zmm{k}{z}, zmm, {sae})      [AVX512F]
            * VGETEXPPS(zmm{k}{z}, zmm)             [AVX512F]
            * VGETEXPPS(xmm{k}{z}, m128/m32bcst)    [AVX512F and AVX512VL]
            * VGETEXPPS(ymm{k}{z}, m256/m32bcst)    [AVX512F and AVX512VL]
            * VGETEXPPS(xmm{k}{z}, xmm)             [AVX512F and AVX512VL]
            * VGETEXPPS(ymm{k}{z}, ymm)             [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VGETEXPPS, self).__init__("VGETEXPPS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 2:
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.out_operands = (True, False)
            self.avx_mode = True
            if is_zmmkz(self.operands[0]) and is_m512_m32bcst(self.operands[1]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b10, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode, b=op[1].bcode) + bytearray([0x42]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=64)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x42, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_m128_m32bcst(self.operands[1]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b00, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode, b=op[1].bcode) + bytearray([0x42]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=16)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_m256_m32bcst(self.operands[1]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b01, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode, b=op[1].bcode) + bytearray([0x42]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=32)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x08, 0x42, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x28, 0x42, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VGETEXPPS " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 3:
            if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_sae(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x18, 0x42, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
                self.in_regs = (False, True, False)
                self.out_regs = (True, False, False)
                self.out_operands = (True, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VGETEXPPS " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VGETEXPPS\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VSCALEFPS(Instruction):
    """Scale Packed Single-Precision Floating-Point Values With Single-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VSCALEFPS(zmm{k}{z}, zmm, m512/m32bcst)    [AVX512F]
            * VSCALEFPS(zmm{k}{z}, zmm, zmm, {er})       [AVX512F]
            * VSCALEFPS(zmm{k}{z}, zmm, zmm)             [AVX512F]
            * VSCALEFPS(xmm{k}{z}, xmm, m128/m32bcst)    [AVX512F and AVX512VL]
            * VSCALEFPS(xmm{k}{z}, xmm, xmm)             [AVX512F and AVX512VL]
            * VSCALEFPS(ymm{k}{z}, ymm, m256/m32bcst)    [AVX512F and AVX512VL]
            * VSCALEFPS(ymm{k}{z}, ymm, ymm)             [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VSCALEFPS, self).__init__("VSCALEFPS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (False, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_m512_m32bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b10, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x2C]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=64)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x2C, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m128_m32bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x2C]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=16)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0x2C, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_m256_m32bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b01, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x2C]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=32)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_evex_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x20, 0x2C, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VSCALEFPS " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0x2C, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (False, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VSCALEFPS " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VSCALEFPS\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFIXUPIMMPS(Instruction):
    """Fix Up Special Packed Single-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFIXUPIMMPS(zmm{k}{z}, zmm, m512/m32bcst, imm8)    [AVX512F]
            * VFIXUPIMMPS(zmm{k}{z}, zmm, zmm, {sae}, imm8)      [AVX512F]
            * VFIXUPIMMPS(zmm{k}{z}, zmm, zmm, imm8)             [AVX512F]
            * VFIXUPIMMPS(ymm{k}{z}, ymm, m256/m32bcst, imm8)    [AVX512F and AVX512VL]
            * VFIXUPIMMPS(ymm{k}{z}, ymm, ymm, imm8)             [AVX512F and AVX512VL]
            * VFIXUPIMMPS(xmm{k}{z}, xmm, m128/m32bcst, imm8)    [AVX512VL]
            * VFIXUPIMMPS(xmm{k}{z}, xmm, xmm, imm8)             [AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFIXUPIMMPS, self).__init__("VFIXUPIMMPS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 4:
            self.in_regs = (True, True, True, False)
            self.out_regs = (True, False, False, False)
            self.out_operands = (True, False, False, False)
            self.avx_mode = True
            if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_m512_m32bcst(self.operands[2]) and is_imm(self.operands[3]):
                if not is_imm8(self.operands[3]):
                    raise ValueError("Argument #3 can not be encoded as imm8")
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b11, 0x05, 0b10, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x54]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=64) + bytearray([op[3] & 0xFF])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]) and is_imm(self.operands[3]):
                if not is_imm8(self.operands[3]):
                    raise ValueError("Argument #3 can not be encoded as imm8")
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 243, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x54, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3] & 0xFF])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m128_m32bcst(self.operands[2]) and is_imm(self.operands[3]):
                if not is_imm8(self.operands[3]):
                    raise ValueError("Argument #3 can not be encoded as imm8")
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b11, 0x05, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x54]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=16) + bytearray([op[3] & 0xFF])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]) and is_imm(self.operands[3]):
                if not is_imm8(self.operands[3]):
                    raise ValueError("Argument #3 can not be encoded as imm8")
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 243, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0x54, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3] & 0xFF])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_m256_m32bcst(self.operands[2]) and is_imm(self.operands[3]):
                if not is_imm8(self.operands[3]):
                    raise ValueError("Argument #3 can not be encoded as imm8")
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b11, 0x05, 0b01, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x54]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=32) + bytearray([op[3] & 0xFF])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_evex_ymm(self.operands[2]) and is_imm(self.operands[3]):
                if not is_imm8(self.operands[3]):
                    raise ValueError("Argument #3 can not be encoded as imm8")
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 243, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x20, 0x54, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3] & 0xFF])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFIXUPIMMPS " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 5:
            if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]) and is_sae(self.operands[3]) and is_imm(self.operands[4]):
                if not is_imm8(self.operands[4]):
                    raise ValueError("Argument #4 can not be encoded as imm8")
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 243, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0x54, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[4] & 0xFF])))
                self.in_regs = (True, True, True, False, False)
                self.out_regs = (True, False, False, False, False)
                self.out_operands = (True, False, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFIXUPIMMPS " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VFIXUPIMMPS\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFPCLASSPS(Instruction):
    """Test Class of Packed Single-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFPCLASSPS(k{k}, m512/m32bcst, imm8)    [AVX512DQ]
            * VFPCLASSPS(k{k}, zmm, imm8)             [AVX512DQ]
            * VFPCLASSPS(k{k}, m128/m32bcst, imm8)    [AVX512DQ and AVX512VL]
            * VFPCLASSPS(k{k}, m256/m32bcst, imm8)    [AVX512DQ and AVX512VL]
            * VFPCLASSPS(k{k}, xmm, imm8)             [AVX512DQ and AVX512VL]
            * VFPCLASSPS(k{k}, ymm, imm8)             [AVX512DQ and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFPCLASSPS, self).__init__("VFPCLASSPS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"VFPCLASSPS\" requires 3 operands")
        self.in_regs = (False, True, False)
        self.out_regs = (True, False, False)
        self.out_operands = (True, False, False)
        self.avx_mode = True
        if is_kk(self.operands[0]) and is_m512_m32bcst(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b11, 0x05, 0b10, op[0].ehcode, op[1].address, aaa=op[0].kcode, b=op[1].bcode) + bytearray([0x66]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=64) + bytearray([op[2] & 0xFF])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512dq])
        elif is_kk(self.operands[0]) and is_zmm(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 243, 0x7D, op[0].kcode | 0x48, 0x66, 0xC0 | op[0].lcode << 3 | op[1].lcode, op[2] & 0xFF])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512dq])
        elif is_kk(self.operands[0]) and is_m128_m32bcst(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b11, 0x05, 0b00, op[0].ehcode, op[1].address, aaa=op[0].kcode, b=op[1].bcode) + bytearray([0x66]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=16) + bytearray([op[2] & 0xFF])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512dq])
        elif is_kk(self.operands[0]) and is_m256_m32bcst(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b11, 0x05, 0b01, op[0].ehcode, op[1].address, aaa=op[0].kcode, b=op[1].bcode) + bytearray([0x66]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=32) + bytearray([op[2] & 0xFF])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512dq])
        elif is_kk(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 243, 0x7D, op[0].kcode | 0x08, 0x66, 0xC0 | op[0].lcode << 3 | op[1].lcode, op[2] & 0xFF])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512dq])
        elif is_kk(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 243, 0x7D, op[0].kcode | 0x28, 0x66, 0xC0 | op[0].lcode << 3 | op[1].lcode, op[2] & 0xFF])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512dq])
        else:
            raise SyntaxError("Invalid operand types: VFPCLASSPS " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VRCPPS(Instruction):
    """Compute Approximate Reciprocals of Packed Single-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VRCPPS(xmm, xmm/m128)    [AVX]
            * VRCPPS(ymm, ymm/m256)    [AVX]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VRCPPS, self).__init__("VRCPPS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VRCPPS\" requires 2 operands")
        self.in_regs = (False, True)
        self.out_regs = (True, False)
        self.out_operands = (True, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(0, op[0].hcode, op[1], 0, vex3) + bytearray([0x53, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
        elif is_xmm(self.operands[0]) and is_m128(self.operands[1]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(0, op[0].hcode, op[1].address, 0, vex3) + bytearray([0x53]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(4, op[0].hcode, op[1], 0, vex3) + bytearray([0x53, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
        elif is_ymm(self.operands[0]) and is_m256(self.operands[1]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(4, op[0].hcode, op[1].address, 0, vex3) + bytearray([0x53]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
        else:
            raise SyntaxError("Invalid operand types: VRCPPS " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VRSQRTPS(Instruction):
    """Compute Reciprocals of Square Roots of Packed Single-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VRSQRTPS(xmm, xmm/m128)    [AVX]
            * VRSQRTPS(ymm, ymm/m256)    [AVX]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VRSQRTPS, self).__init__("VRSQRTPS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VRSQRTPS\" requires 2 operands")
        self.in_regs = (False, True)
        self.out_regs = (True, False)
        self.out_operands = (True, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(0, op[0].hcode, op[1], 0, vex3) + bytearray([0x52, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
        elif is_xmm(self.operands[0]) and is_m128(self.operands[1]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(0, op[0].hcode, op[1].address, 0, vex3) + bytearray([0x52]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(4, op[0].hcode, op[1], 0, vex3) + bytearray([0x52, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
        elif is_ymm(self.operands[0]) and is_m256(self.operands[1]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(4, op[0].hcode, op[1].address, 0, vex3) + bytearray([0x52]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
        else:
            raise SyntaxError("Invalid operand types: VRSQRTPS " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VRCP14PS(Instruction):
    """Compute Approximate Reciprocals of Packed Single-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VRCP14PS(zmm{k}{z}, m512/m32bcst)    [AVX512F]
            * VRCP14PS(zmm{k}{z}, zmm)             [AVX512F]
            * VRCP14PS(xmm{k}{z}, m128/m32bcst)    [AVX512F and AVX512VL]
            * VRCP14PS(ymm{k}{z}, m256/m32bcst)    [AVX512F and AVX512VL]
            * VRCP14PS(xmm{k}{z}, xmm)             [AVX512F and AVX512VL]
            * VRCP14PS(ymm{k}{z}, ymm)             [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VRCP14PS, self).__init__("VRCP14PS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VRCP14PS\" requires 2 operands")
        self.in_regs = (False, True)
        self.out_regs = (True, False)
        self.out_operands = (True, False)
        self.avx_mode = True
        if is_zmmkz(self.operands[0]) and is_m512_m32bcst(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b10, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode, b=op[1].bcode) + bytearray([0x4C]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=64)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x4C, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_m128_m32bcst(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b00, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode, b=op[1].bcode) + bytearray([0x4C]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=16)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_m256_m32bcst(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b01, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode, b=op[1].bcode) + bytearray([0x4C]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=32)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x08, 0x4C, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x28, 0x4C, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: VRCP14PS " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VRSQRT14PS(Instruction):
    """Compute Approximate Reciprocals of Square Roots of Packed Single-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VRSQRT14PS(zmm{k}{z}, m512/m32bcst)    [AVX512F]
            * VRSQRT14PS(zmm{k}{z}, zmm)             [AVX512F]
            * VRSQRT14PS(xmm{k}{z}, m128/m32bcst)    [AVX512F and AVX512VL]
            * VRSQRT14PS(ymm{k}{z}, m256/m32bcst)    [AVX512F and AVX512VL]
            * VRSQRT14PS(xmm{k}{z}, xmm)             [AVX512F and AVX512VL]
            * VRSQRT14PS(ymm{k}{z}, ymm)             [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VRSQRT14PS, self).__init__("VRSQRT14PS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VRSQRT14PS\" requires 2 operands")
        self.in_regs = (False, True)
        self.out_regs = (True, False)
        self.out_operands = (True, False)
        self.avx_mode = True
        if is_zmmkz(self.operands[0]) and is_m512_m32bcst(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b10, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode, b=op[1].bcode) + bytearray([0x4E]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=64)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x4E, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_m128_m32bcst(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b00, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode, b=op[1].bcode) + bytearray([0x4E]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=16)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_m256_m32bcst(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b01, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode, b=op[1].bcode) + bytearray([0x4E]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=32)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x08, 0x4E, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x28, 0x4E, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: VRSQRT14PS " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VRCP28PS(Instruction):
    """Approximation to the Reciprocal of Packed Single-Precision Floating-Point Values with Less Than 2^-28 Relative Error"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VRCP28PS(zmm{k}{z}, m512/m32bcst)    [AVX512ER]
            * VRCP28PS(zmm{k}{z}, zmm, {sae})      [AVX512ER]
            * VRCP28PS(zmm{k}{z}, zmm)             [AVX512ER]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VRCP28PS, self).__init__("VRCP28PS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 2:
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.out_operands = (True, False)
            self.avx_mode = True
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512er])
            if is_zmmkz(self.operands[0]) and is_m512_m32bcst(self.operands[1]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b10, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode, b=op[1].bcode) + bytearray([0xCA]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=64)))
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x48, 0xCA, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            else:
                raise SyntaxError("Invalid operand types: VRCP28PS " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 3:
            if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_sae(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x18, 0xCA, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
                self.in_regs = (False, True, False)
                self.out_regs = (True, False, False)
                self.out_operands = (True, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512er])
            else:
                raise SyntaxError("Invalid operand types: VRCP28PS " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VRCP28PS\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VRSQRT28PS(Instruction):
    """Approximation to the Reciprocal Square Root of Packed Single-Precision Floating-Point Values with Less Than 2^-28 Relative Error"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VRSQRT28PS(zmm{k}{z}, m512/m32bcst)    [AVX512ER]
            * VRSQRT28PS(zmm{k}{z}, zmm, {sae})      [AVX512ER]
            * VRSQRT28PS(zmm{k}{z}, zmm)             [AVX512ER]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VRSQRT28PS, self).__init__("VRSQRT28PS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 2:
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.out_operands = (True, False)
            self.avx_mode = True
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512er])
            if is_zmmkz(self.operands[0]) and is_m512_m32bcst(self.operands[1]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b10, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode, b=op[1].bcode) + bytearray([0xCC]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=64)))
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x48, 0xCC, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            else:
                raise SyntaxError("Invalid operand types: VRSQRT28PS " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 3:
            if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_sae(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x18, 0xCC, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
                self.in_regs = (False, True, False)
                self.out_regs = (True, False, False)
                self.out_operands = (True, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512er])
            else:
                raise SyntaxError("Invalid operand types: VRSQRT28PS " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VRSQRT28PS\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VEXP2PS(Instruction):
    """Approximation to the Exponential 2^x of Packed Single-Precision Floating-Point Values with Less Than 2^-23 Relative Error"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VEXP2PS(zmm{k}{z}, m512/m32bcst)    [AVX512ER]
            * VEXP2PS(zmm{k}{z}, zmm, {sae})      [AVX512ER]
            * VEXP2PS(zmm{k}{z}, zmm)             [AVX512ER]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VEXP2PS, self).__init__("VEXP2PS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 2:
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.out_operands = (True, False)
            self.avx_mode = True
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512er])
            if is_zmmkz(self.operands[0]) and is_m512_m32bcst(self.operands[1]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b10, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode, b=op[1].bcode) + bytearray([0xC8]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=64)))
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x48, 0xC8, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            else:
                raise SyntaxError("Invalid operand types: VEXP2PS " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 3:
            if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_sae(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x18, 0xC8, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
                self.in_regs = (False, True, False)
                self.out_regs = (True, False, False)
                self.out_operands = (True, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512er])
            else:
                raise SyntaxError("Invalid operand types: VEXP2PS " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VEXP2PS\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VCMPPS(Instruction):
    """Compare Packed Single-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VCMPPS(xmm, xmm, xmm/m128, imm8)         [AVX]
            * VCMPPS(ymm, ymm, ymm/m256, imm8)         [AVX]
            * VCMPPS(k{k}, zmm, m512/m32bcst, imm8)    [AVX512F]
            * VCMPPS(k{k}, zmm, zmm, {sae}, imm8)      [AVX512F]
            * VCMPPS(k{k}, zmm, zmm, imm8)             [AVX512F]
            * VCMPPS(k{k}, xmm, m128/m32bcst, imm8)    [AVX512F and AVX512VL]
            * VCMPPS(k{k}, xmm, xmm, imm8)             [AVX512F and AVX512VL]
            * VCMPPS(k{k}, ymm, m256/m32bcst, imm8)    [AVX512F and AVX512VL]
            * VCMPPS(k{k}, ymm, ymm, imm8)             [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VCMPPS, self).__init__("VCMPPS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 4:
            self.in_regs = (False, True, True, False)
            self.out_regs = (True, False, False, False)
            self.out_operands = (True, False, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_imm(self.operands[3]):
                if not is_imm8(self.operands[3]):
                    raise ValueError("Argument #3 can not be encoded as imm8")
                self.encodings.append((0x40, lambda op, vex3=False: vex2(0, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0xC2, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3] & 0xFF])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]) and is_imm(self.operands[3]):
                if not is_imm8(self.operands[3]):
                    raise ValueError("Argument #3 can not be encoded as imm8")
                self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(0, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0xC2]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3] & 0xFF])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]) and is_imm(self.operands[3]):
                if not is_imm8(self.operands[3]):
                    raise ValueError("Argument #3 can not be encoded as imm8")
                self.encodings.append((0x40, lambda op, vex3=False: vex2(4, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0xC2, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3] & 0xFF])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]) and is_imm(self.operands[3]):
                if not is_imm8(self.operands[3]):
                    raise ValueError("Argument #3 can not be encoded as imm8")
                self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(4, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0xC2]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3] & 0xFF])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_kk(self.operands[0]) and is_zmm(self.operands[1]) and is_m512_m32bcst(self.operands[2]) and is_imm(self.operands[3]):
                if not is_imm8(self.operands[3]):
                    raise ValueError("Argument #3 can not be encoded as imm8")
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x04, 0b10, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, b=op[2].bcode) + bytearray([0xC2]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=64) + bytearray([op[3] & 0xFF])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_kk(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]) and is_imm(self.operands[3]):
                if not is_imm8(self.operands[3]):
                    raise ValueError("Argument #3 can not be encoded as imm8")
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7C ^ (op[1].hlcode << 3), (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0xC2, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3] & 0xFF])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_kk(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m128_m32bcst(self.operands[2]) and is_imm(self.operands[3]):
                if not is_imm8(self.operands[3]):
                    raise ValueError("Argument #3 can not be encoded as imm8")
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x04, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, b=op[2].bcode) + bytearray([0xC2]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=16) + bytearray([op[3] & 0xFF])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_kk(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]) and is_imm(self.operands[3]):
                if not is_imm8(self.operands[3]):
                    raise ValueError("Argument #3 can not be encoded as imm8")
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7C ^ (op[1].hlcode << 3), (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0xC2, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3] & 0xFF])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_kk(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_m256_m32bcst(self.operands[2]) and is_imm(self.operands[3]):
                if not is_imm8(self.operands[3]):
                    raise ValueError("Argument #3 can not be encoded as imm8")
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x04, 0b01, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, b=op[2].bcode) + bytearray([0xC2]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=32) + bytearray([op[3] & 0xFF])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_kk(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_evex_ymm(self.operands[2]) and is_imm(self.operands[3]):
                if not is_imm8(self.operands[3]):
                    raise ValueError("Argument #3 can not be encoded as imm8")
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7C ^ (op[1].hlcode << 3), (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x20, 0xC2, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3] & 0xFF])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VCMPPS " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 5:
            if is_kk(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]) and is_sae(self.operands[3]) and is_imm(self.operands[4]):
                if not is_imm8(self.operands[4]):
                    raise ValueError("Argument #4 can not be encoded as imm8")
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7C ^ (op[1].hlcode << 3), (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0xC2, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[4] & 0xFF])))
                self.in_regs = (False, True, True, False, False)
                self.out_regs = (True, False, False, False, False)
                self.out_operands = (True, False, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VCMPPS " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VCMPPS\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VTESTPS(Instruction):
    """Packed Single-Precision Floating-Point Bit Test"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VTESTPS(xmm, xmm/m128)    [AVX]
            * VTESTPS(ymm, ymm/m256)    [AVX]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VTESTPS, self).__init__("VTESTPS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VTESTPS\" requires 2 operands")
        self.in_regs = (True, True)
        self.out_regs = (False, False)
        self.out_operands = (False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x79, 0x0E, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
        elif is_xmm(self.operands[0]) and is_m128(self.operands[1]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x01, op[0].hcode, op[1].address) + bytearray([0x0E]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x7D, 0x0E, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
        elif is_ymm(self.operands[0]) and is_m256(self.operands[1]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x05, op[0].hcode, op[1].address) + bytearray([0x0E]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
        else:
            raise SyntaxError("Invalid operand types: VTESTPS " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VROUNDPD(Instruction):
    """Round Packed Double Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VROUNDPD(xmm, xmm/m128, imm8)    [AVX]
            * VROUNDPD(ymm, ymm/m256, imm8)    [AVX]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VROUNDPD, self).__init__("VROUNDPD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"VROUNDPD\" requires 3 operands")
        self.in_regs = (False, True, False)
        self.out_regs = (True, False, False)
        self.out_operands = (True, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x79, 0x09, 0xC0 | op[0].lcode << 3 | op[1].lcode, op[2] & 0xFF])))
        elif is_xmm(self.operands[0]) and is_m128(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x01, op[0].hcode, op[1].address) + bytearray([0x09]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp) + bytearray([op[2] & 0xFF])))
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x7D, 0x09, 0xC0 | op[0].lcode << 3 | op[1].lcode, op[2] & 0xFF])))
        elif is_ymm(self.operands[0]) and is_m256(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x05, op[0].hcode, op[1].address) + bytearray([0x09]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp) + bytearray([op[2] & 0xFF])))
        else:
            raise SyntaxError("Invalid operand types: VROUNDPD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VRNDSCALEPD(Instruction):
    """Round Packed Double-Precision Floating-Point Values To Include A Given Number Of Fraction Bits"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VRNDSCALEPD(zmm{k}{z}, m512/m64bcst, imm8)    [AVX512F]
            * VRNDSCALEPD(zmm{k}{z}, zmm, {sae}, imm8)      [AVX512F]
            * VRNDSCALEPD(zmm{k}{z}, zmm, imm8)             [AVX512F]
            * VRNDSCALEPD(xmm{k}{z}, m128/m64bcst, imm8)    [AVX512F and AVX512VL]
            * VRNDSCALEPD(ymm{k}{z}, m256/m64bcst, imm8)    [AVX512F and AVX512VL]
            * VRNDSCALEPD(xmm{k}{z}, xmm, imm8)             [AVX512F and AVX512VL]
            * VRNDSCALEPD(ymm{k}{z}, ymm, imm8)             [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VRNDSCALEPD, self).__init__("VRNDSCALEPD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (False, True, False)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_zmmkz(self.operands[0]) and is_m512_m64bcst(self.operands[1]) and is_imm(self.operands[2]):
                if not is_imm8(self.operands[2]):
                    raise ValueError("Argument #2 can not be encoded as imm8")
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b11, 0x85, 0b10, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode, b=op[1].bcode) + bytearray([0x09]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=64) + bytearray([op[2] & 0xFF])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_imm(self.operands[2]):
                if not is_imm8(self.operands[2]):
                    raise ValueError("Argument #2 can not be encoded as imm8")
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 243, 0xFD, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x09, 0xC0 | op[0].lcode << 3 | op[1].lcode, op[2] & 0xFF])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_m128_m64bcst(self.operands[1]) and is_imm(self.operands[2]):
                if not is_imm8(self.operands[2]):
                    raise ValueError("Argument #2 can not be encoded as imm8")
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b11, 0x85, 0b00, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode, b=op[1].bcode) + bytearray([0x09]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=16) + bytearray([op[2] & 0xFF])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_m256_m64bcst(self.operands[1]) and is_imm(self.operands[2]):
                if not is_imm8(self.operands[2]):
                    raise ValueError("Argument #2 can not be encoded as imm8")
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b11, 0x85, 0b01, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode, b=op[1].bcode) + bytearray([0x09]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=32) + bytearray([op[2] & 0xFF])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_imm(self.operands[2]):
                if not is_imm8(self.operands[2]):
                    raise ValueError("Argument #2 can not be encoded as imm8")
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 243, 0xFD, (op[0].zcode << 7) | op[0].kcode | 0x08, 0x09, 0xC0 | op[0].lcode << 3 | op[1].lcode, op[2] & 0xFF])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_imm(self.operands[2]):
                if not is_imm8(self.operands[2]):
                    raise ValueError("Argument #2 can not be encoded as imm8")
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 243, 0xFD, (op[0].zcode << 7) | op[0].kcode | 0x28, 0x09, 0xC0 | op[0].lcode << 3 | op[1].lcode, op[2] & 0xFF])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VRNDSCALEPD " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_sae(self.operands[2]) and is_imm(self.operands[3]):
                if not is_imm8(self.operands[3]):
                    raise ValueError("Argument #3 can not be encoded as imm8")
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 243, 0xFD, (op[0].zcode << 7) | op[0].kcode | 0x18, 0x09, 0xC0 | op[0].lcode << 3 | op[1].lcode, op[3] & 0xFF])))
                self.in_regs = (False, True, False, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VRNDSCALEPD " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VRNDSCALEPD\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VRANGEPD(Instruction):
    """Range Restriction Calculation For Packed Pairs of Double-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VRANGEPD(zmm{k}{z}, zmm, m512/m64bcst, imm8)    [AVX512DQ]
            * VRANGEPD(zmm{k}{z}, zmm, zmm, {sae}, imm8)      [AVX512DQ]
            * VRANGEPD(zmm{k}{z}, zmm, zmm, imm8)             [AVX512DQ]
            * VRANGEPD(xmm{k}{z}, xmm, m128/m64bcst, imm8)    [AVX512DQ and AVX512VL]
            * VRANGEPD(xmm{k}{z}, xmm, xmm, imm8)             [AVX512DQ and AVX512VL]
            * VRANGEPD(ymm{k}{z}, ymm, m256/m64bcst, imm8)    [AVX512DQ and AVX512VL]
            * VRANGEPD(ymm{k}{z}, ymm, ymm, imm8)             [AVX512DQ and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VRANGEPD, self).__init__("VRANGEPD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 4:
            self.in_regs = (False, True, True, False)
            self.out_regs = (True, False, False, False)
            self.out_operands = (True, False, False, False)
            self.avx_mode = True
            if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_m512_m64bcst(self.operands[2]) and is_imm(self.operands[3]):
                if not is_imm8(self.operands[3]):
                    raise ValueError("Argument #3 can not be encoded as imm8")
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b11, 0x85, 0b10, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x50]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=64) + bytearray([op[3] & 0xFF])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512dq])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]) and is_imm(self.operands[3]):
                if not is_imm8(self.operands[3]):
                    raise ValueError("Argument #3 can not be encoded as imm8")
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 243, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x50, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3] & 0xFF])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512dq])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m128_m64bcst(self.operands[2]) and is_imm(self.operands[3]):
                if not is_imm8(self.operands[3]):
                    raise ValueError("Argument #3 can not be encoded as imm8")
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b11, 0x85, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x50]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=16) + bytearray([op[3] & 0xFF])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512dq])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]) and is_imm(self.operands[3]):
                if not is_imm8(self.operands[3]):
                    raise ValueError("Argument #3 can not be encoded as imm8")
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 243, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0x50, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3] & 0xFF])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512dq])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_m256_m64bcst(self.operands[2]) and is_imm(self.operands[3]):
                if not is_imm8(self.operands[3]):
                    raise ValueError("Argument #3 can not be encoded as imm8")
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b11, 0x85, 0b01, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x50]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=32) + bytearray([op[3] & 0xFF])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512dq])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_evex_ymm(self.operands[2]) and is_imm(self.operands[3]):
                if not is_imm8(self.operands[3]):
                    raise ValueError("Argument #3 can not be encoded as imm8")
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 243, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x20, 0x50, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3] & 0xFF])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512dq])
            else:
                raise SyntaxError("Invalid operand types: VRANGEPD " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 5:
            if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]) and is_sae(self.operands[3]) and is_imm(self.operands[4]):
                if not is_imm8(self.operands[4]):
                    raise ValueError("Argument #4 can not be encoded as imm8")
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 243, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0x50, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[4] & 0xFF])))
                self.in_regs = (False, True, True, False, False)
                self.out_regs = (True, False, False, False, False)
                self.out_operands = (True, False, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512dq])
            else:
                raise SyntaxError("Invalid operand types: VRANGEPD " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VRANGEPD\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VMINPD(Instruction):
    """Return Minimum Packed Double-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VMINPD(xmm, xmm, xmm/m128)              [AVX]
            * VMINPD(ymm, ymm, ymm/m256)              [AVX]
            * VMINPD(zmm{k}{z}, zmm, m512/m64bcst)    [AVX512F]
            * VMINPD(zmm{k}{z}, zmm, zmm, {sae})      [AVX512F]
            * VMINPD(zmm{k}{z}, zmm, zmm)             [AVX512F]
            * VMINPD(xmm{k}{z}, xmm, m128/m64bcst)    [AVX512F and AVX512VL]
            * VMINPD(xmm{k}{z}, xmm, xmm)             [AVX512F and AVX512VL]
            * VMINPD(ymm{k}{z}, ymm, m256/m64bcst)    [AVX512F and AVX512VL]
            * VMINPD(ymm{k}{z}, ymm, ymm)             [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VMINPD, self).__init__("VMINPD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (False, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x40, lambda op, vex3=False: vex2(1, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0x5D, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
                self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(1, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0x5D]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]):
                self.encodings.append((0x40, lambda op, vex3=False: vex2(5, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0x5D, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]):
                self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(5, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0x5D]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_m512_m64bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x85, 0b10, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x5D]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=64)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x5D, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m128_m64bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x85, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x5D]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=16)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0x5D, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_m256_m64bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x85, 0b01, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x5D]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=32)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_evex_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x20, 0x5D, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VMINPD " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]) and is_sae(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0x5D, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (False, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VMINPD " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VMINPD\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VMAXPD(Instruction):
    """Return Maximum Packed Double-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VMAXPD(xmm, xmm, xmm/m128)              [AVX]
            * VMAXPD(ymm, ymm, ymm/m256)              [AVX]
            * VMAXPD(zmm{k}{z}, zmm, m512/m64bcst)    [AVX512F]
            * VMAXPD(zmm{k}{z}, zmm, zmm, {sae})      [AVX512F]
            * VMAXPD(zmm{k}{z}, zmm, zmm)             [AVX512F]
            * VMAXPD(xmm{k}{z}, xmm, m128/m64bcst)    [AVX512F and AVX512VL]
            * VMAXPD(xmm{k}{z}, xmm, xmm)             [AVX512F and AVX512VL]
            * VMAXPD(ymm{k}{z}, ymm, m256/m64bcst)    [AVX512F and AVX512VL]
            * VMAXPD(ymm{k}{z}, ymm, ymm)             [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VMAXPD, self).__init__("VMAXPD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (False, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
                self.encodings.append((0x40, lambda op, vex3=False: vex2(1, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0x5F, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
                self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(1, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0x5F]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]):
                self.encodings.append((0x40, lambda op, vex3=False: vex2(5, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0x5F, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]):
                self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(5, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0x5F]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_m512_m64bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x85, 0b10, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x5F]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=64)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x5F, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m128_m64bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x85, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x5F]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=16)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0x5F, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_m256_m64bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x85, 0b01, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x5F]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=32)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_evex_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x20, 0x5F, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VMAXPD " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]) and is_sae(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0x5F, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (False, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VMAXPD " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VMAXPD\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VREDUCEPD(Instruction):
    """Perform Reduction Transformation on Packed Double-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VREDUCEPD(zmm{k}{z}, m512/m64bcst, imm8)    [AVX512DQ]
            * VREDUCEPD(zmm{k}{z}, zmm, imm8)             [AVX512DQ]
            * VREDUCEPD(xmm{k}{z}, m128/m64bcst, imm8)    [AVX512DQ and AVX512VL]
            * VREDUCEPD(ymm{k}{z}, m256/m64bcst, imm8)    [AVX512DQ and AVX512VL]
            * VREDUCEPD(xmm{k}{z}, xmm, imm8)             [AVX512DQ and AVX512VL]
            * VREDUCEPD(ymm{k}{z}, ymm, imm8)             [AVX512DQ and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VREDUCEPD, self).__init__("VREDUCEPD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"VREDUCEPD\" requires 3 operands")
        self.in_regs = (False, True, False)
        self.out_regs = (True, False, False)
        self.out_operands = (True, False, False)
        self.avx_mode = True
        if is_zmmkz(self.operands[0]) and is_m512_m64bcst(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b11, 0x85, 0b10, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode, b=op[1].bcode) + bytearray([0x56]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=64) + bytearray([op[2] & 0xFF])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512dq])
        elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 243, 0xFD, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x56, 0xC0 | op[0].lcode << 3 | op[1].lcode, op[2] & 0xFF])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512dq])
        elif is_xmmkz(self.operands[0]) and is_m128_m64bcst(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b11, 0x85, 0b00, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode, b=op[1].bcode) + bytearray([0x56]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=16) + bytearray([op[2] & 0xFF])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512dq])
        elif is_ymmkz(self.operands[0]) and is_m256_m64bcst(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b11, 0x85, 0b01, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode, b=op[1].bcode) + bytearray([0x56]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=32) + bytearray([op[2] & 0xFF])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512dq])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 243, 0xFD, (op[0].zcode << 7) | op[0].kcode | 0x08, 0x56, 0xC0 | op[0].lcode << 3 | op[1].lcode, op[2] & 0xFF])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512dq])
        elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 243, 0xFD, (op[0].zcode << 7) | op[0].kcode | 0x28, 0x56, 0xC0 | op[0].lcode << 3 | op[1].lcode, op[2] & 0xFF])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512dq])
        else:
            raise SyntaxError("Invalid operand types: VREDUCEPD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VDPPD(Instruction):
    """Dot Product of Packed Double Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VDPPD(xmm, xmm, xmm/m128, imm8)    [AVX]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VDPPD, self).__init__("VDPPD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 4:
            raise SyntaxError("Instruction \"VDPPD\" requires 4 operands")
        self.in_regs = (False, True, True, False)
        self.out_regs = (True, False, False, False)
        self.out_operands = (True, False, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_imm(self.operands[3]):
            if not is_imm8(self.operands[3]):
                raise ValueError("Argument #3 can not be encoded as imm8")
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x79 ^ (op[1].hlcode << 3), 0x41, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3] & 0xFF])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]) and is_imm(self.operands[3]):
            if not is_imm8(self.operands[3]):
                raise ValueError("Argument #3 can not be encoded as imm8")
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x01, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x41]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3] & 0xFF])))
        else:
            raise SyntaxError("Invalid operand types: VDPPD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VGETMANTPD(Instruction):
    """Extract Normalized Mantissas from Packed Double-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VGETMANTPD(zmm{k}{z}, m512/m64bcst, imm8)    [AVX512F]
            * VGETMANTPD(zmm{k}{z}, zmm, {sae}, imm8)      [AVX512F]
            * VGETMANTPD(zmm{k}{z}, zmm, imm8)             [AVX512F]
            * VGETMANTPD(xmm{k}{z}, m128/m64bcst, imm8)    [AVX512F and AVX512VL]
            * VGETMANTPD(ymm{k}{z}, m256/m64bcst, imm8)    [AVX512F and AVX512VL]
            * VGETMANTPD(xmm{k}{z}, xmm, imm8)             [AVX512F and AVX512VL]
            * VGETMANTPD(ymm{k}{z}, ymm, imm8)             [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VGETMANTPD, self).__init__("VGETMANTPD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (False, True, False)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_zmmkz(self.operands[0]) and is_m512_m64bcst(self.operands[1]) and is_imm(self.operands[2]):
                if not is_imm8(self.operands[2]):
                    raise ValueError("Argument #2 can not be encoded as imm8")
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b11, 0x85, 0b10, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode, b=op[1].bcode) + bytearray([0x26]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=64) + bytearray([op[2] & 0xFF])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_imm(self.operands[2]):
                if not is_imm8(self.operands[2]):
                    raise ValueError("Argument #2 can not be encoded as imm8")
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 243, 0xFD, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x26, 0xC0 | op[0].lcode << 3 | op[1].lcode, op[2] & 0xFF])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_m128_m64bcst(self.operands[1]) and is_imm(self.operands[2]):
                if not is_imm8(self.operands[2]):
                    raise ValueError("Argument #2 can not be encoded as imm8")
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b11, 0x85, 0b00, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode, b=op[1].bcode) + bytearray([0x26]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=16) + bytearray([op[2] & 0xFF])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_m256_m64bcst(self.operands[1]) and is_imm(self.operands[2]):
                if not is_imm8(self.operands[2]):
                    raise ValueError("Argument #2 can not be encoded as imm8")
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b11, 0x85, 0b01, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode, b=op[1].bcode) + bytearray([0x26]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=32) + bytearray([op[2] & 0xFF])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_imm(self.operands[2]):
                if not is_imm8(self.operands[2]):
                    raise ValueError("Argument #2 can not be encoded as imm8")
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 243, 0xFD, (op[0].zcode << 7) | op[0].kcode | 0x08, 0x26, 0xC0 | op[0].lcode << 3 | op[1].lcode, op[2] & 0xFF])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_imm(self.operands[2]):
                if not is_imm8(self.operands[2]):
                    raise ValueError("Argument #2 can not be encoded as imm8")
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 243, 0xFD, (op[0].zcode << 7) | op[0].kcode | 0x28, 0x26, 0xC0 | op[0].lcode << 3 | op[1].lcode, op[2] & 0xFF])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VGETMANTPD " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_sae(self.operands[2]) and is_imm(self.operands[3]):
                if not is_imm8(self.operands[3]):
                    raise ValueError("Argument #3 can not be encoded as imm8")
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 243, 0xFD, (op[0].zcode << 7) | op[0].kcode | 0x18, 0x26, 0xC0 | op[0].lcode << 3 | op[1].lcode, op[3] & 0xFF])))
                self.in_regs = (False, True, False, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VGETMANTPD " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VGETMANTPD\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VGETEXPPD(Instruction):
    """Extract Exponents of Packed Double-Precision Floating-Point Values as Double-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VGETEXPPD(zmm{k}{z}, m512/m64bcst)    [AVX512F]
            * VGETEXPPD(zmm{k}{z}, zmm, {sae})      [AVX512F]
            * VGETEXPPD(zmm{k}{z}, zmm)             [AVX512F]
            * VGETEXPPD(xmm{k}{z}, m128/m64bcst)    [AVX512F and AVX512VL]
            * VGETEXPPD(ymm{k}{z}, m256/m64bcst)    [AVX512F and AVX512VL]
            * VGETEXPPD(xmm{k}{z}, xmm)             [AVX512F and AVX512VL]
            * VGETEXPPD(ymm{k}{z}, ymm)             [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VGETEXPPD, self).__init__("VGETEXPPD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 2:
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.out_operands = (True, False)
            self.avx_mode = True
            if is_zmmkz(self.operands[0]) and is_m512_m64bcst(self.operands[1]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b10, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode, b=op[1].bcode) + bytearray([0x42]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=64)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x42, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_m128_m64bcst(self.operands[1]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b00, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode, b=op[1].bcode) + bytearray([0x42]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=16)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_m256_m64bcst(self.operands[1]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b01, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode, b=op[1].bcode) + bytearray([0x42]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=32)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD, (op[0].zcode << 7) | op[0].kcode | 0x08, 0x42, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD, (op[0].zcode << 7) | op[0].kcode | 0x28, 0x42, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VGETEXPPD " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 3:
            if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_sae(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD, (op[0].zcode << 7) | op[0].kcode | 0x18, 0x42, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
                self.in_regs = (False, True, False)
                self.out_regs = (True, False, False)
                self.out_operands = (True, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VGETEXPPD " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VGETEXPPD\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VSCALEFPD(Instruction):
    """Scale Packed Double-Precision Floating-Point Values With Double-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VSCALEFPD(zmm{k}{z}, zmm, m512/m64bcst)    [AVX512F]
            * VSCALEFPD(zmm{k}{z}, zmm, zmm, {er})       [AVX512F]
            * VSCALEFPD(zmm{k}{z}, zmm, zmm)             [AVX512F]
            * VSCALEFPD(xmm{k}{z}, xmm, m128/m64bcst)    [AVX512F and AVX512VL]
            * VSCALEFPD(xmm{k}{z}, xmm, xmm)             [AVX512F and AVX512VL]
            * VSCALEFPD(ymm{k}{z}, ymm, m256/m64bcst)    [AVX512F and AVX512VL]
            * VSCALEFPD(ymm{k}{z}, ymm, ymm)             [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VSCALEFPD, self).__init__("VSCALEFPD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 3:
            self.in_regs = (False, True, True)
            self.out_regs = (True, False, False)
            self.out_operands = (True, False, False)
            self.avx_mode = True
            if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_m512_m64bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b10, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x2C]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=64)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x2C, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m128_m64bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x2C]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=16)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0x2C, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_m256_m64bcst(self.operands[2]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b01, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x2C]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=32)))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_evex_ymm(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x20, 0x2C, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VSCALEFPD " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]) and is_er(self.operands[3]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[3].code << 5) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0x2C, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
                self.in_regs = (False, True, True, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VSCALEFPD " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VSCALEFPD\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFIXUPIMMPD(Instruction):
    """Fix Up Special Packed Double-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFIXUPIMMPD(zmm{k}{z}, zmm, m512/m64bcst, imm8)    [AVX512F]
            * VFIXUPIMMPD(zmm{k}{z}, zmm, zmm, {sae}, imm8)      [AVX512F]
            * VFIXUPIMMPD(zmm{k}{z}, zmm, zmm, imm8)             [AVX512F]
            * VFIXUPIMMPD(xmm{k}{z}, xmm, m128/m64bcst, imm8)    [AVX512F and AVX512VL]
            * VFIXUPIMMPD(xmm{k}{z}, xmm, xmm, imm8)             [AVX512F and AVX512VL]
            * VFIXUPIMMPD(ymm{k}{z}, ymm, m256/m64bcst, imm8)    [AVX512F and AVX512VL]
            * VFIXUPIMMPD(ymm{k}{z}, ymm, ymm, imm8)             [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFIXUPIMMPD, self).__init__("VFIXUPIMMPD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 4:
            self.in_regs = (True, True, True, False)
            self.out_regs = (True, False, False, False)
            self.out_operands = (True, False, False, False)
            self.avx_mode = True
            if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_m512_m64bcst(self.operands[2]) and is_imm(self.operands[3]):
                if not is_imm8(self.operands[3]):
                    raise ValueError("Argument #3 can not be encoded as imm8")
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b11, 0x85, 0b10, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x54]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=64) + bytearray([op[3] & 0xFF])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]) and is_imm(self.operands[3]):
                if not is_imm8(self.operands[3]):
                    raise ValueError("Argument #3 can not be encoded as imm8")
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 243, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x54, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3] & 0xFF])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m128_m64bcst(self.operands[2]) and is_imm(self.operands[3]):
                if not is_imm8(self.operands[3]):
                    raise ValueError("Argument #3 can not be encoded as imm8")
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b11, 0x85, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x54]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=16) + bytearray([op[3] & 0xFF])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]) and is_imm(self.operands[3]):
                if not is_imm8(self.operands[3]):
                    raise ValueError("Argument #3 can not be encoded as imm8")
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 243, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0x54, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3] & 0xFF])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_m256_m64bcst(self.operands[2]) and is_imm(self.operands[3]):
                if not is_imm8(self.operands[3]):
                    raise ValueError("Argument #3 can not be encoded as imm8")
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b11, 0x85, 0b01, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x54]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=32) + bytearray([op[3] & 0xFF])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_evex_ymm(self.operands[2]) and is_imm(self.operands[3]):
                if not is_imm8(self.operands[3]):
                    raise ValueError("Argument #3 can not be encoded as imm8")
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 243, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x20, 0x54, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3] & 0xFF])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFIXUPIMMPD " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 5:
            if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]) and is_sae(self.operands[3]) and is_imm(self.operands[4]):
                if not is_imm8(self.operands[4]):
                    raise ValueError("Argument #4 can not be encoded as imm8")
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 243, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0x54, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[4] & 0xFF])))
                self.in_regs = (True, True, True, False, False)
                self.out_regs = (True, False, False, False, False)
                self.out_operands = (True, False, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VFIXUPIMMPD " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VFIXUPIMMPD\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFPCLASSPD(Instruction):
    """Test Class of Packed Double-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFPCLASSPD(k{k}, m512/m64bcst, imm8)    [AVX512DQ]
            * VFPCLASSPD(k{k}, zmm, imm8)             [AVX512DQ]
            * VFPCLASSPD(k{k}, m128/m64bcst, imm8)    [AVX512DQ and AVX512VL]
            * VFPCLASSPD(k{k}, m256/m64bcst, imm8)    [AVX512DQ and AVX512VL]
            * VFPCLASSPD(k{k}, xmm, imm8)             [AVX512DQ and AVX512VL]
            * VFPCLASSPD(k{k}, ymm, imm8)             [AVX512DQ and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFPCLASSPD, self).__init__("VFPCLASSPD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"VFPCLASSPD\" requires 3 operands")
        self.in_regs = (False, True, False)
        self.out_regs = (True, False, False)
        self.out_operands = (True, False, False)
        self.avx_mode = True
        if is_kk(self.operands[0]) and is_m512_m64bcst(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b11, 0x85, 0b10, op[0].ehcode, op[1].address, aaa=op[0].kcode, b=op[1].bcode) + bytearray([0x66]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=64) + bytearray([op[2] & 0xFF])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512dq])
        elif is_kk(self.operands[0]) and is_zmm(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 243, 0xFD, op[0].kcode | 0x48, 0x66, 0xC0 | op[0].lcode << 3 | op[1].lcode, op[2] & 0xFF])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512dq])
        elif is_kk(self.operands[0]) and is_m128_m64bcst(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b11, 0x85, 0b00, op[0].ehcode, op[1].address, aaa=op[0].kcode, b=op[1].bcode) + bytearray([0x66]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=16) + bytearray([op[2] & 0xFF])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512dq])
        elif is_kk(self.operands[0]) and is_m256_m64bcst(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b11, 0x85, 0b01, op[0].ehcode, op[1].address, aaa=op[0].kcode, b=op[1].bcode) + bytearray([0x66]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=32) + bytearray([op[2] & 0xFF])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512dq])
        elif is_kk(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 243, 0xFD, op[0].kcode | 0x08, 0x66, 0xC0 | op[0].lcode << 3 | op[1].lcode, op[2] & 0xFF])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512dq])
        elif is_kk(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 243, 0xFD, op[0].kcode | 0x28, 0x66, 0xC0 | op[0].lcode << 3 | op[1].lcode, op[2] & 0xFF])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512dq])
        else:
            raise SyntaxError("Invalid operand types: VFPCLASSPD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VRCP14PD(Instruction):
    """Compute Approximate Reciprocals of Packed Double-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VRCP14PD(zmm{k}{z}, m512/m64bcst)    [AVX512F]
            * VRCP14PD(zmm{k}{z}, zmm)             [AVX512F]
            * VRCP14PD(xmm{k}{z}, m128/m64bcst)    [AVX512F and AVX512VL]
            * VRCP14PD(ymm{k}{z}, m256/m64bcst)    [AVX512F and AVX512VL]
            * VRCP14PD(xmm{k}{z}, xmm)             [AVX512F and AVX512VL]
            * VRCP14PD(ymm{k}{z}, ymm)             [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VRCP14PD, self).__init__("VRCP14PD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VRCP14PD\" requires 2 operands")
        self.in_regs = (False, True)
        self.out_regs = (True, False)
        self.out_operands = (True, False)
        self.avx_mode = True
        if is_zmmkz(self.operands[0]) and is_m512_m64bcst(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b10, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode, b=op[1].bcode) + bytearray([0x4C]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=64)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x4C, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_m128_m64bcst(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b00, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode, b=op[1].bcode) + bytearray([0x4C]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=16)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_m256_m64bcst(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b01, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode, b=op[1].bcode) + bytearray([0x4C]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=32)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD, (op[0].zcode << 7) | op[0].kcode | 0x08, 0x4C, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD, (op[0].zcode << 7) | op[0].kcode | 0x28, 0x4C, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: VRCP14PD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VRSQRT14PD(Instruction):
    """Compute Approximate Reciprocals of Square Roots of Packed Double-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VRSQRT14PD(zmm{k}{z}, m512/m64bcst)    [AVX512F]
            * VRSQRT14PD(zmm{k}{z}, zmm)             [AVX512F]
            * VRSQRT14PD(xmm{k}{z}, m128/m64bcst)    [AVX512F and AVX512VL]
            * VRSQRT14PD(ymm{k}{z}, m256/m64bcst)    [AVX512F and AVX512VL]
            * VRSQRT14PD(xmm{k}{z}, xmm)             [AVX512F and AVX512VL]
            * VRSQRT14PD(ymm{k}{z}, ymm)             [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VRSQRT14PD, self).__init__("VRSQRT14PD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VRSQRT14PD\" requires 2 operands")
        self.in_regs = (False, True)
        self.out_regs = (True, False)
        self.out_operands = (True, False)
        self.avx_mode = True
        if is_zmmkz(self.operands[0]) and is_m512_m64bcst(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b10, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode, b=op[1].bcode) + bytearray([0x4E]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=64)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x4E, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_m128_m64bcst(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b00, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode, b=op[1].bcode) + bytearray([0x4E]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=16)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_m256_m64bcst(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b01, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode, b=op[1].bcode) + bytearray([0x4E]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=32)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD, (op[0].zcode << 7) | op[0].kcode | 0x08, 0x4E, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD, (op[0].zcode << 7) | op[0].kcode | 0x28, 0x4E, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: VRSQRT14PD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VRCP28PD(Instruction):
    """Approximation to the Reciprocal of Packed Double-Precision Floating-Point Values with Less Than 2^-28 Relative Error"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VRCP28PD(zmm{k}{z}, m512/m64bcst)    [AVX512ER]
            * VRCP28PD(zmm{k}{z}, zmm, {sae})      [AVX512ER]
            * VRCP28PD(zmm{k}{z}, zmm)             [AVX512ER]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VRCP28PD, self).__init__("VRCP28PD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 2:
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.out_operands = (True, False)
            self.avx_mode = True
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512er])
            if is_zmmkz(self.operands[0]) and is_m512_m64bcst(self.operands[1]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b10, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode, b=op[1].bcode) + bytearray([0xCA]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=64)))
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD, (op[0].zcode << 7) | op[0].kcode | 0x48, 0xCA, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            else:
                raise SyntaxError("Invalid operand types: VRCP28PD " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 3:
            if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_sae(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD, (op[0].zcode << 7) | op[0].kcode | 0x18, 0xCA, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
                self.in_regs = (False, True, False)
                self.out_regs = (True, False, False)
                self.out_operands = (True, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512er])
            else:
                raise SyntaxError("Invalid operand types: VRCP28PD " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VRCP28PD\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VRSQRT28PD(Instruction):
    """Approximation to the Reciprocal Square Root of Packed Double-Precision Floating-Point Values with Less Than 2^-28 Relative Error"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VRSQRT28PD(zmm{k}{z}, m512/m64bcst)    [AVX512ER]
            * VRSQRT28PD(zmm{k}{z}, zmm, {sae})      [AVX512ER]
            * VRSQRT28PD(zmm{k}{z}, zmm)             [AVX512ER]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VRSQRT28PD, self).__init__("VRSQRT28PD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 2:
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.out_operands = (True, False)
            self.avx_mode = True
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512er])
            if is_zmmkz(self.operands[0]) and is_m512_m64bcst(self.operands[1]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b10, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode, b=op[1].bcode) + bytearray([0xCC]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=64)))
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD, (op[0].zcode << 7) | op[0].kcode | 0x48, 0xCC, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            else:
                raise SyntaxError("Invalid operand types: VRSQRT28PD " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 3:
            if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_sae(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD, (op[0].zcode << 7) | op[0].kcode | 0x18, 0xCC, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
                self.in_regs = (False, True, False)
                self.out_regs = (True, False, False)
                self.out_operands = (True, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512er])
            else:
                raise SyntaxError("Invalid operand types: VRSQRT28PD " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VRSQRT28PD\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VEXP2PD(Instruction):
    """Approximation to the Exponential 2^x of Packed Double-Precision Floating-Point Values with Less Than 2^-23 Relative Error"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VEXP2PD(zmm{k}{z}, m512/m64bcst)    [AVX512ER]
            * VEXP2PD(zmm{k}{z}, zmm, {sae})      [AVX512ER]
            * VEXP2PD(zmm{k}{z}, zmm)             [AVX512ER]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VEXP2PD, self).__init__("VEXP2PD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 2:
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.out_operands = (True, False)
            self.avx_mode = True
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512er])
            if is_zmmkz(self.operands[0]) and is_m512_m64bcst(self.operands[1]):
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b10, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode, b=op[1].bcode) + bytearray([0xC8]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=64)))
            elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD, (op[0].zcode << 7) | op[0].kcode | 0x48, 0xC8, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            else:
                raise SyntaxError("Invalid operand types: VEXP2PD " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 3:
            if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_sae(self.operands[2]):
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD, (op[0].zcode << 7) | op[0].kcode | 0x18, 0xC8, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
                self.in_regs = (False, True, False)
                self.out_regs = (True, False, False)
                self.out_operands = (True, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512er])
            else:
                raise SyntaxError("Invalid operand types: VEXP2PD " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VEXP2PD\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VCMPPD(Instruction):
    """Compare Packed Double-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VCMPPD(xmm, xmm, xmm/m128, imm8)         [AVX]
            * VCMPPD(ymm, ymm, ymm/m256, imm8)         [AVX]
            * VCMPPD(k{k}, zmm, m512/m64bcst, imm8)    [AVX512F]
            * VCMPPD(k{k}, zmm, zmm, {sae}, imm8)      [AVX512F]
            * VCMPPD(k{k}, zmm, zmm, imm8)             [AVX512F]
            * VCMPPD(k{k}, xmm, m128/m64bcst, imm8)    [AVX512F and AVX512VL]
            * VCMPPD(k{k}, xmm, xmm, imm8)             [AVX512F and AVX512VL]
            * VCMPPD(k{k}, ymm, m256/m64bcst, imm8)    [AVX512F and AVX512VL]
            * VCMPPD(k{k}, ymm, ymm, imm8)             [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VCMPPD, self).__init__("VCMPPD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 4:
            self.in_regs = (False, True, True, False)
            self.out_regs = (True, False, False, False)
            self.out_operands = (True, False, False, False)
            self.avx_mode = True
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_imm(self.operands[3]):
                if not is_imm8(self.operands[3]):
                    raise ValueError("Argument #3 can not be encoded as imm8")
                self.encodings.append((0x40, lambda op, vex3=False: vex2(1, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0xC2, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3] & 0xFF])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]) and is_imm(self.operands[3]):
                if not is_imm8(self.operands[3]):
                    raise ValueError("Argument #3 can not be encoded as imm8")
                self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(1, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0xC2]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3] & 0xFF])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]) and is_imm(self.operands[3]):
                if not is_imm8(self.operands[3]):
                    raise ValueError("Argument #3 can not be encoded as imm8")
                self.encodings.append((0x40, lambda op, vex3=False: vex2(5, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0xC2, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3] & 0xFF])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]) and is_imm(self.operands[3]):
                if not is_imm8(self.operands[3]):
                    raise ValueError("Argument #3 can not be encoded as imm8")
                self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(5, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0xC2]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3] & 0xFF])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            elif is_kk(self.operands[0]) and is_zmm(self.operands[1]) and is_m512_m64bcst(self.operands[2]) and is_imm(self.operands[3]):
                if not is_imm8(self.operands[3]):
                    raise ValueError("Argument #3 can not be encoded as imm8")
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x85, 0b10, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, b=op[2].bcode) + bytearray([0xC2]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=64) + bytearray([op[3] & 0xFF])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_kk(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]) and is_imm(self.operands[3]):
                if not is_imm8(self.operands[3]):
                    raise ValueError("Argument #3 can not be encoded as imm8")
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFD ^ (op[1].hlcode << 3), (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0xC2, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3] & 0xFF])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            elif is_kk(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m128_m64bcst(self.operands[2]) and is_imm(self.operands[3]):
                if not is_imm8(self.operands[3]):
                    raise ValueError("Argument #3 can not be encoded as imm8")
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x85, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, b=op[2].bcode) + bytearray([0xC2]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=16) + bytearray([op[3] & 0xFF])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_kk(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]) and is_imm(self.operands[3]):
                if not is_imm8(self.operands[3]):
                    raise ValueError("Argument #3 can not be encoded as imm8")
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFD ^ (op[1].hlcode << 3), (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0xC2, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3] & 0xFF])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_kk(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_m256_m64bcst(self.operands[2]) and is_imm(self.operands[3]):
                if not is_imm8(self.operands[3]):
                    raise ValueError("Argument #3 can not be encoded as imm8")
                self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x85, 0b01, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, b=op[2].bcode) + bytearray([0xC2]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=32) + bytearray([op[3] & 0xFF])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            elif is_kk(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_evex_ymm(self.operands[2]) and is_imm(self.operands[3]):
                if not is_imm8(self.operands[3]):
                    raise ValueError("Argument #3 can not be encoded as imm8")
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFD ^ (op[1].hlcode << 3), (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x20, 0xC2, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3] & 0xFF])))
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VCMPPD " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 5:
            if is_kk(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]) and is_sae(self.operands[3]) and is_imm(self.operands[4]):
                if not is_imm8(self.operands[4]):
                    raise ValueError("Argument #4 can not be encoded as imm8")
                self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFD ^ (op[1].hlcode << 3), (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x10, 0xC2, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[4] & 0xFF])))
                self.in_regs = (False, True, True, False, False)
                self.out_regs = (True, False, False, False, False)
                self.out_operands = (True, False, False, False, False)
                self.avx_mode = True
                self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
            else:
                raise SyntaxError("Invalid operand types: VCMPPD " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"VCMPPD\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VTESTPD(Instruction):
    """Packed Double-Precision Floating-Point Bit Test"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VTESTPD(xmm, xmm/m128)    [AVX]
            * VTESTPD(ymm, ymm/m256)    [AVX]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VTESTPD, self).__init__("VTESTPD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VTESTPD\" requires 2 operands")
        self.in_regs = (True, True)
        self.out_regs = (False, False)
        self.out_operands = (False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x79, 0x0F, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
        elif is_xmm(self.operands[0]) and is_m128(self.operands[1]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x01, op[0].hcode, op[1].address) + bytearray([0x0F]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x7D, 0x0F, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
        elif is_ymm(self.operands[0]) and is_m256(self.operands[1]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x05, op[0].hcode, op[1].address) + bytearray([0x0F]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
        else:
            raise SyntaxError("Invalid operand types: VTESTPD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VANDPS(Instruction):
    """Bitwise Logical AND of Packed Single-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VANDPS(xmm, xmm, xmm/m128)              [AVX]
            * VANDPS(ymm, ymm, ymm/m256)              [AVX]
            * VANDPS(zmm{k}{z}, zmm, m512/m32bcst)    [AVX512DQ]
            * VANDPS(zmm{k}{z}, zmm, zmm)             [AVX512DQ]
            * VANDPS(xmm{k}{z}, xmm, m128/m32bcst)    [AVX512DQ and AVX512VL]
            * VANDPS(xmm{k}{z}, xmm, xmm)             [AVX512DQ and AVX512VL]
            * VANDPS(ymm{k}{z}, ymm, m256/m32bcst)    [AVX512DQ and AVX512VL]
            * VANDPS(ymm{k}{z}, ymm, ymm)             [AVX512DQ and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VANDPS, self).__init__("VANDPS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"VANDPS\" requires 3 operands")
        self.in_regs = (False, True, True)
        self.out_regs = (True, False, False)
        self.out_operands = (True, False, False)
        self.avx_mode = True
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(0, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0x54, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(0, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0x54]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(4, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0x54, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(4, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0x54]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_m512_m32bcst(self.operands[2]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x04, 0b10, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x54]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=64)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512dq])
        elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7C ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x54, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512dq])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m128_m32bcst(self.operands[2]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x04, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x54]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=16)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512dq])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7C ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0x54, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512dq])
        elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_m256_m32bcst(self.operands[2]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x04, 0b01, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x54]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=32)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512dq])
        elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_evex_ymm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7C ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x20, 0x54, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512dq])
        else:
            raise SyntaxError("Invalid operand types: VANDPS " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VANDNPS(Instruction):
    """Bitwise Logical AND NOT of Packed Single-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VANDNPS(xmm, xmm, xmm/m128)              [AVX]
            * VANDNPS(ymm, ymm, ymm/m256)              [AVX]
            * VANDNPS(zmm{k}{z}, zmm, m512/m32bcst)    [AVX512DQ]
            * VANDNPS(zmm{k}{z}, zmm, zmm)             [AVX512DQ]
            * VANDNPS(xmm{k}{z}, xmm, m128/m32bcst)    [AVX512DQ and AVX512VL]
            * VANDNPS(xmm{k}{z}, xmm, xmm)             [AVX512DQ and AVX512VL]
            * VANDNPS(ymm{k}{z}, ymm, m256/m32bcst)    [AVX512DQ and AVX512VL]
            * VANDNPS(ymm{k}{z}, ymm, ymm)             [AVX512DQ and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VANDNPS, self).__init__("VANDNPS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"VANDNPS\" requires 3 operands")
        self.in_regs = (False, True, True)
        self.out_regs = (True, False, False)
        self.out_operands = (True, False, False)
        self.avx_mode = True
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(0, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0x55, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            self._cancelling_inputs = True
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(0, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0x55]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(4, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0x55, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            self._cancelling_inputs = True
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(4, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0x55]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_m512_m32bcst(self.operands[2]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x04, 0b10, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x55]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=64)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512dq])
        elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7C ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x55, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512dq])
            self._cancelling_inputs = True
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m128_m32bcst(self.operands[2]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x04, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x55]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=16)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512dq])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7C ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0x55, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512dq])
            self._cancelling_inputs = True
        elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_m256_m32bcst(self.operands[2]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x04, 0b01, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x55]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=32)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512dq])
        elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_evex_ymm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7C ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x20, 0x55, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512dq])
            self._cancelling_inputs = True
        else:
            raise SyntaxError("Invalid operand types: VANDNPS " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VORPS(Instruction):
    """Bitwise Logical OR of Single-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VORPS(xmm, xmm, xmm/m128)              [AVX]
            * VORPS(ymm, ymm, ymm/m256)              [AVX]
            * VORPS(zmm{k}{z}, zmm, m512/m32bcst)    [AVX512DQ]
            * VORPS(zmm{k}{z}, zmm, zmm)             [AVX512DQ]
            * VORPS(xmm{k}{z}, xmm, m128/m32bcst)    [AVX512DQ and AVX512VL]
            * VORPS(xmm{k}{z}, xmm, xmm)             [AVX512DQ and AVX512VL]
            * VORPS(ymm{k}{z}, ymm, m256/m32bcst)    [AVX512DQ and AVX512VL]
            * VORPS(ymm{k}{z}, ymm, ymm)             [AVX512DQ and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VORPS, self).__init__("VORPS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"VORPS\" requires 3 operands")
        self.in_regs = (False, True, True)
        self.out_regs = (True, False, False)
        self.out_operands = (True, False, False)
        self.avx_mode = True
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(0, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0x56, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(0, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0x56]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(4, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0x56, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(4, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0x56]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_m512_m32bcst(self.operands[2]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x04, 0b10, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x56]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=64)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512dq])
        elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7C ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x56, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512dq])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m128_m32bcst(self.operands[2]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x04, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x56]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=16)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512dq])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7C ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0x56, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512dq])
        elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_m256_m32bcst(self.operands[2]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x04, 0b01, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x56]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=32)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512dq])
        elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_evex_ymm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7C ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x20, 0x56, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512dq])
        else:
            raise SyntaxError("Invalid operand types: VORPS " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VXORPS(Instruction):
    """Bitwise Logical XOR for Single-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VXORPS(xmm, xmm, xmm/m128)              [AVX]
            * VXORPS(ymm, ymm, ymm/m256)              [AVX]
            * VXORPS(zmm{k}{z}, zmm, m512/m32bcst)    [AVX512DQ]
            * VXORPS(zmm{k}{z}, zmm, zmm)             [AVX512DQ]
            * VXORPS(xmm{k}{z}, xmm, m128/m32bcst)    [AVX512DQ and AVX512VL]
            * VXORPS(xmm{k}{z}, xmm, xmm)             [AVX512DQ and AVX512VL]
            * VXORPS(ymm{k}{z}, ymm, m256/m32bcst)    [AVX512DQ and AVX512VL]
            * VXORPS(ymm{k}{z}, ymm, ymm)             [AVX512DQ and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VXORPS, self).__init__("VXORPS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"VXORPS\" requires 3 operands")
        self.in_regs = (False, True, True)
        self.out_regs = (True, False, False)
        self.out_operands = (True, False, False)
        self.avx_mode = True
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(0, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0x57, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            self._cancelling_inputs = True
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(0, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0x57]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(4, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0x57, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            self._cancelling_inputs = True
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(4, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0x57]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_m512_m32bcst(self.operands[2]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x04, 0b10, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x57]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=64)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512dq])
        elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7C ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x57, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512dq])
            self._cancelling_inputs = True
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m128_m32bcst(self.operands[2]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x04, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x57]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=16)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512dq])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7C ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0x57, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512dq])
            self._cancelling_inputs = True
        elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_m256_m32bcst(self.operands[2]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x04, 0b01, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x57]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=32)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512dq])
        elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_evex_ymm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7C ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x20, 0x57, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512dq])
            self._cancelling_inputs = True
        else:
            raise SyntaxError("Invalid operand types: VXORPS " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VBLENDPS(Instruction):
    """ Blend Packed Single Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VBLENDPS(xmm, xmm, xmm/m128, imm8)    [AVX]
            * VBLENDPS(ymm, ymm, ymm/m256, imm8)    [AVX]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VBLENDPS, self).__init__("VBLENDPS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 4:
            raise SyntaxError("Instruction \"VBLENDPS\" requires 4 operands")
        self.in_regs = (False, True, True, False)
        self.out_regs = (True, False, False, False)
        self.out_operands = (True, False, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_imm(self.operands[3]):
            if not is_imm8(self.operands[3]):
                raise ValueError("Argument #3 can not be encoded as imm8")
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x79 ^ (op[1].hlcode << 3), 0x0C, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3] & 0xFF])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]) and is_imm(self.operands[3]):
            if not is_imm8(self.operands[3]):
                raise ValueError("Argument #3 can not be encoded as imm8")
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x01, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x0C]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3] & 0xFF])))
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]) and is_imm(self.operands[3]):
            if not is_imm8(self.operands[3]):
                raise ValueError("Argument #3 can not be encoded as imm8")
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x7D ^ (op[1].hlcode << 3), 0x0C, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3] & 0xFF])))
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]) and is_imm(self.operands[3]):
            if not is_imm8(self.operands[3]):
                raise ValueError("Argument #3 can not be encoded as imm8")
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x05, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x0C]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3] & 0xFF])))
        else:
            raise SyntaxError("Invalid operand types: VBLENDPS " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VBLENDVPS(Instruction):
    """ Variable Blend Packed Single Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VBLENDVPS(xmm, xmm, xmm/m128, xmm)    [AVX]
            * VBLENDVPS(ymm, ymm, ymm/m256, ymm)    [AVX]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VBLENDVPS, self).__init__("VBLENDVPS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 4:
            raise SyntaxError("Instruction \"VBLENDVPS\" requires 4 operands")
        self.in_regs = (False, True, True, True)
        self.out_regs = (True, False, False, False)
        self.out_operands = (True, False, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_xmm(self.operands[3]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x79 ^ (op[1].hlcode << 3), 0x4A, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3].hlcode << 4])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]) and is_xmm(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x01, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x4A]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3].hlcode << 4])))
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]) and is_ymm(self.operands[3]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x7D ^ (op[1].hlcode << 3), 0x4A, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3].hlcode << 4])))
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]) and is_ymm(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x05, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x4A]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3].hlcode << 4])))
        else:
            raise SyntaxError("Invalid operand types: VBLENDVPS " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VBLENDMPS(Instruction):
    """Blend Packed Single-Precision Floating-Point Vectors Using an OpMask Control"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VBLENDMPS(zmm{k}{z}, zmm, m512/m32bcst)    [AVX512F]
            * VBLENDMPS(zmm{k}{z}, zmm, zmm)             [AVX512F]
            * VBLENDMPS(xmm{k}{z}, xmm, m128/m32bcst)    [AVX512F and AVX512VL]
            * VBLENDMPS(xmm{k}{z}, xmm, xmm)             [AVX512F and AVX512VL]
            * VBLENDMPS(ymm{k}{z}, ymm, m256/m32bcst)    [AVX512F and AVX512VL]
            * VBLENDMPS(ymm{k}{z}, ymm, ymm)             [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VBLENDMPS, self).__init__("VBLENDMPS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"VBLENDMPS\" requires 3 operands")
        self.in_regs = (False, True, True)
        self.out_regs = (True, False, False)
        self.out_operands = (True, False, False)
        self.avx_mode = True
        if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_m512_m32bcst(self.operands[2]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b10, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x65]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=64)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x65, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m128_m32bcst(self.operands[2]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x65]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=16)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0x65, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_m256_m32bcst(self.operands[2]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b01, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x65]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=32)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_evex_ymm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x20, 0x65, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: VBLENDMPS " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VANDPD(Instruction):
    """Bitwise Logical AND of Packed Double-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VANDPD(xmm, xmm, xmm/m128)              [AVX]
            * VANDPD(ymm, ymm, ymm/m256)              [AVX]
            * VANDPD(zmm{k}{z}, zmm, m512/m64bcst)    [AVX512DQ]
            * VANDPD(zmm{k}{z}, zmm, zmm)             [AVX512DQ]
            * VANDPD(xmm{k}{z}, xmm, m128/m64bcst)    [AVX512DQ and AVX512VL]
            * VANDPD(xmm{k}{z}, xmm, xmm)             [AVX512DQ and AVX512VL]
            * VANDPD(ymm{k}{z}, ymm, m256/m64bcst)    [AVX512DQ and AVX512VL]
            * VANDPD(ymm{k}{z}, ymm, ymm)             [AVX512DQ and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VANDPD, self).__init__("VANDPD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"VANDPD\" requires 3 operands")
        self.in_regs = (False, True, True)
        self.out_regs = (True, False, False)
        self.out_operands = (True, False, False)
        self.avx_mode = True
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(1, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0x54, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(1, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0x54]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(5, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0x54, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(5, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0x54]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_m512_m64bcst(self.operands[2]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x85, 0b10, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x54]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=64)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512dq])
        elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x54, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512dq])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m128_m64bcst(self.operands[2]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x85, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x54]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=16)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512dq])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0x54, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512dq])
        elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_m256_m64bcst(self.operands[2]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x85, 0b01, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x54]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=32)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512dq])
        elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_evex_ymm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x20, 0x54, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512dq])
        else:
            raise SyntaxError("Invalid operand types: VANDPD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VANDNPD(Instruction):
    """Bitwise Logical AND NOT of Packed Double-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VANDNPD(xmm, xmm, xmm/m128)              [AVX]
            * VANDNPD(ymm, ymm, ymm/m256)              [AVX]
            * VANDNPD(zmm{k}{z}, zmm, m512/m64bcst)    [AVX512DQ]
            * VANDNPD(zmm{k}{z}, zmm, zmm)             [AVX512DQ]
            * VANDNPD(xmm{k}{z}, xmm, m128/m64bcst)    [AVX512DQ and AVX512VL]
            * VANDNPD(xmm{k}{z}, xmm, xmm)             [AVX512DQ and AVX512VL]
            * VANDNPD(ymm{k}{z}, ymm, m256/m64bcst)    [AVX512DQ and AVX512VL]
            * VANDNPD(ymm{k}{z}, ymm, ymm)             [AVX512DQ and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VANDNPD, self).__init__("VANDNPD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"VANDNPD\" requires 3 operands")
        self.in_regs = (False, True, True)
        self.out_regs = (True, False, False)
        self.out_operands = (True, False, False)
        self.avx_mode = True
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(1, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0x55, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            self._cancelling_inputs = True
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(1, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0x55]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(5, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0x55, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            self._cancelling_inputs = True
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(5, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0x55]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_m512_m64bcst(self.operands[2]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x85, 0b10, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x55]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=64)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512dq])
        elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x55, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512dq])
            self._cancelling_inputs = True
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m128_m64bcst(self.operands[2]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x85, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x55]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=16)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512dq])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0x55, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512dq])
            self._cancelling_inputs = True
        elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_m256_m64bcst(self.operands[2]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x85, 0b01, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x55]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=32)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512dq])
        elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_evex_ymm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x20, 0x55, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512dq])
            self._cancelling_inputs = True
        else:
            raise SyntaxError("Invalid operand types: VANDNPD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VORPD(Instruction):
    """Bitwise Logical OR of Double-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VORPD(xmm, xmm, xmm/m128)              [AVX]
            * VORPD(ymm, ymm, ymm/m256)              [AVX]
            * VORPD(zmm{k}{z}, zmm, m512/m64bcst)    [AVX512DQ]
            * VORPD(zmm{k}{z}, zmm, zmm)             [AVX512DQ]
            * VORPD(xmm{k}{z}, xmm, m128/m64bcst)    [AVX512DQ and AVX512VL]
            * VORPD(xmm{k}{z}, xmm, xmm)             [AVX512DQ and AVX512VL]
            * VORPD(ymm{k}{z}, ymm, m256/m64bcst)    [AVX512DQ and AVX512VL]
            * VORPD(ymm{k}{z}, ymm, ymm)             [AVX512DQ and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VORPD, self).__init__("VORPD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"VORPD\" requires 3 operands")
        self.in_regs = (False, True, True)
        self.out_regs = (True, False, False)
        self.out_operands = (True, False, False)
        self.avx_mode = True
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(1, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0x56, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(1, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0x56]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(5, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0x56, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(5, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0x56]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_m512_m64bcst(self.operands[2]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x85, 0b10, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x56]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=64)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512dq])
        elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x56, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512dq])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m128_m64bcst(self.operands[2]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x85, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x56]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=16)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512dq])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0x56, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512dq])
        elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_m256_m64bcst(self.operands[2]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x85, 0b01, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x56]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=32)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512dq])
        elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_evex_ymm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x20, 0x56, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512dq])
        else:
            raise SyntaxError("Invalid operand types: VORPD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VXORPD(Instruction):
    """Bitwise Logical XOR for Double-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VXORPD(xmm, xmm, xmm/m128)              [AVX]
            * VXORPD(ymm, ymm, ymm/m256)              [AVX]
            * VXORPD(zmm{k}{z}, zmm, m512/m64bcst)    [AVX512DQ]
            * VXORPD(zmm{k}{z}, zmm, zmm)             [AVX512DQ]
            * VXORPD(xmm{k}{z}, xmm, m128/m64bcst)    [AVX512DQ and AVX512VL]
            * VXORPD(xmm{k}{z}, xmm, xmm)             [AVX512DQ and AVX512VL]
            * VXORPD(ymm{k}{z}, ymm, m256/m64bcst)    [AVX512DQ and AVX512VL]
            * VXORPD(ymm{k}{z}, ymm, ymm)             [AVX512DQ and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VXORPD, self).__init__("VXORPD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"VXORPD\" requires 3 operands")
        self.in_regs = (False, True, True)
        self.out_regs = (True, False, False)
        self.out_operands = (True, False, False)
        self.avx_mode = True
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(1, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0x57, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            self._cancelling_inputs = True
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(1, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0x57]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(5, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0x57, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
            self._cancelling_inputs = True
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(5, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0x57]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_m512_m64bcst(self.operands[2]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x85, 0b10, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x57]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=64)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512dq])
        elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x57, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512dq])
            self._cancelling_inputs = True
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m128_m64bcst(self.operands[2]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x85, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x57]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=16)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512dq])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0x57, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512dq])
            self._cancelling_inputs = True
        elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_m256_m64bcst(self.operands[2]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x85, 0b01, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x57]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=32)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512dq])
        elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_evex_ymm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x20, 0x57, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512dq])
            self._cancelling_inputs = True
        else:
            raise SyntaxError("Invalid operand types: VXORPD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VBLENDPD(Instruction):
    """Blend Packed Double Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VBLENDPD(xmm, xmm, xmm/m128, imm8)    [AVX]
            * VBLENDPD(ymm, ymm, ymm/m256, imm8)    [AVX]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VBLENDPD, self).__init__("VBLENDPD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 4:
            raise SyntaxError("Instruction \"VBLENDPD\" requires 4 operands")
        self.in_regs = (False, True, True, False)
        self.out_regs = (True, False, False, False)
        self.out_operands = (True, False, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_imm(self.operands[3]):
            if not is_imm8(self.operands[3]):
                raise ValueError("Argument #3 can not be encoded as imm8")
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x79 ^ (op[1].hlcode << 3), 0x0D, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3] & 0xFF])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]) and is_imm(self.operands[3]):
            if not is_imm8(self.operands[3]):
                raise ValueError("Argument #3 can not be encoded as imm8")
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x01, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x0D]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3] & 0xFF])))
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]) and is_imm(self.operands[3]):
            if not is_imm8(self.operands[3]):
                raise ValueError("Argument #3 can not be encoded as imm8")
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x7D ^ (op[1].hlcode << 3), 0x0D, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3] & 0xFF])))
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]) and is_imm(self.operands[3]):
            if not is_imm8(self.operands[3]):
                raise ValueError("Argument #3 can not be encoded as imm8")
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x05, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x0D]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3] & 0xFF])))
        else:
            raise SyntaxError("Invalid operand types: VBLENDPD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VBLENDVPD(Instruction):
    """ Variable Blend Packed Double Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VBLENDVPD(xmm, xmm, xmm/m128, xmm)    [AVX]
            * VBLENDVPD(ymm, ymm, ymm/m256, ymm)    [AVX]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VBLENDVPD, self).__init__("VBLENDVPD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 4:
            raise SyntaxError("Instruction \"VBLENDVPD\" requires 4 operands")
        self.in_regs = (False, True, True, True)
        self.out_regs = (True, False, False, False)
        self.out_operands = (True, False, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_xmm(self.operands[3]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x79 ^ (op[1].hlcode << 3), 0x4B, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3].hlcode << 4])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]) and is_xmm(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x01, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x4B]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3].hlcode << 4])))
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]) and is_ymm(self.operands[3]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x7D ^ (op[1].hlcode << 3), 0x4B, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3].hlcode << 4])))
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]) and is_ymm(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x05, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x4B]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3].hlcode << 4])))
        else:
            raise SyntaxError("Invalid operand types: VBLENDVPD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VBLENDMPD(Instruction):
    """Blend Packed Double-Precision Floating-Point Vectors Using an OpMask Control"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VBLENDMPD(zmm{k}{z}, zmm, m512/m64bcst)    [AVX512F]
            * VBLENDMPD(zmm{k}{z}, zmm, zmm)             [AVX512F]
            * VBLENDMPD(xmm{k}{z}, xmm, m128/m64bcst)    [AVX512F and AVX512VL]
            * VBLENDMPD(xmm{k}{z}, xmm, xmm)             [AVX512F and AVX512VL]
            * VBLENDMPD(ymm{k}{z}, ymm, m256/m64bcst)    [AVX512F and AVX512VL]
            * VBLENDMPD(ymm{k}{z}, ymm, ymm)             [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VBLENDMPD, self).__init__("VBLENDMPD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"VBLENDMPD\" requires 3 operands")
        self.in_regs = (False, True, True)
        self.out_regs = (True, False, False)
        self.out_operands = (True, False, False)
        self.avx_mode = True
        if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_m512_m64bcst(self.operands[2]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b10, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x65]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=64)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x65, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m128_m64bcst(self.operands[2]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x65]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=16)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0x65, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_m256_m64bcst(self.operands[2]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b01, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x65]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=32)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_evex_ymm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x20, 0x65, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: VBLENDMPD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VUNPCKLPS(Instruction):
    """Unpack and Interleave Low Packed Single-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VUNPCKLPS(xmm, xmm, xmm/m128)              [AVX]
            * VUNPCKLPS(ymm, ymm, ymm/m256)              [AVX]
            * VUNPCKLPS(zmm{k}{z}, zmm, m512/m32bcst)    [AVX512F]
            * VUNPCKLPS(zmm{k}{z}, zmm, zmm)             [AVX512F]
            * VUNPCKLPS(xmm{k}{z}, xmm, m128/m32bcst)    [AVX512F and AVX512VL]
            * VUNPCKLPS(xmm{k}{z}, xmm, xmm)             [AVX512F and AVX512VL]
            * VUNPCKLPS(ymm{k}{z}, ymm, m256/m32bcst)    [AVX512F and AVX512VL]
            * VUNPCKLPS(ymm{k}{z}, ymm, ymm)             [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VUNPCKLPS, self).__init__("VUNPCKLPS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"VUNPCKLPS\" requires 3 operands")
        self.in_regs = (False, True, True)
        self.out_regs = (True, False, False)
        self.out_operands = (True, False, False)
        self.avx_mode = True
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(0, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0x14, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(0, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0x14]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(4, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0x14, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(4, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0x14]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_m512_m32bcst(self.operands[2]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x04, 0b10, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x14]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=64)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7C ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x14, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m128_m32bcst(self.operands[2]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x04, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x14]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=16)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7C ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0x14, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_m256_m32bcst(self.operands[2]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x04, 0b01, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x14]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=32)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_evex_ymm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7C ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x20, 0x14, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: VUNPCKLPS " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VUNPCKHPS(Instruction):
    """Unpack and Interleave High Packed Single-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VUNPCKHPS(xmm, xmm, xmm/m128)              [AVX]
            * VUNPCKHPS(ymm, ymm, ymm/m256)              [AVX]
            * VUNPCKHPS(zmm{k}{z}, zmm, m512/m32bcst)    [AVX512F]
            * VUNPCKHPS(zmm{k}{z}, zmm, zmm)             [AVX512F]
            * VUNPCKHPS(xmm{k}{z}, xmm, m128/m32bcst)    [AVX512F and AVX512VL]
            * VUNPCKHPS(xmm{k}{z}, xmm, xmm)             [AVX512F and AVX512VL]
            * VUNPCKHPS(ymm{k}{z}, ymm, m256/m32bcst)    [AVX512F and AVX512VL]
            * VUNPCKHPS(ymm{k}{z}, ymm, ymm)             [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VUNPCKHPS, self).__init__("VUNPCKHPS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"VUNPCKHPS\" requires 3 operands")
        self.in_regs = (False, True, True)
        self.out_regs = (True, False, False)
        self.out_operands = (True, False, False)
        self.avx_mode = True
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(0, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0x15, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(0, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0x15]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(4, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0x15, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(4, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0x15]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_m512_m32bcst(self.operands[2]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x04, 0b10, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x15]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=64)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7C ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x15, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m128_m32bcst(self.operands[2]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x04, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x15]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=16)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7C ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0x15, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_m256_m32bcst(self.operands[2]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x04, 0b01, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x15]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=32)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_evex_ymm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7C ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x20, 0x15, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: VUNPCKHPS " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VMOVLHPS(Instruction):
    """Move Packed Single-Precision Floating-Point Values Low to High"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VMOVLHPS(xmm, xmm, xmm)    [AVX]
            * VMOVLHPS(xmm, xmm, xmm)    [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VMOVLHPS, self).__init__("VMOVLHPS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"VMOVLHPS\" requires 3 operands")
        self.in_regs = (False, True, True)
        self.out_regs = (True, False, False)
        self.out_operands = (True, False, False)
        self.avx_mode = True
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(0, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0x16, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_evex_xmm(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7C ^ (op[1].hlcode << 3), (op[1].ecode << 3 ^ 0x8) | 0x00, 0x16, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: VMOVLHPS " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VMOVHLPS(Instruction):
    """Move Packed Single-Precision Floating-Point Values High to Low"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VMOVHLPS(xmm, xmm, xmm)    [AVX]
            * VMOVHLPS(xmm, xmm, xmm)    [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VMOVHLPS, self).__init__("VMOVHLPS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"VMOVHLPS\" requires 3 operands")
        self.in_regs = (False, True, True)
        self.out_regs = (True, False, False)
        self.out_operands = (True, False, False)
        self.avx_mode = True
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(0, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0x12, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_evex_xmm(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7C ^ (op[1].hlcode << 3), (op[1].ecode << 3 ^ 0x8) | 0x00, 0x12, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: VMOVHLPS " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VSHUFPS(Instruction):
    """Shuffle Packed Single-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VSHUFPS(xmm, xmm, xmm/m128, imm8)              [AVX]
            * VSHUFPS(ymm, ymm, ymm/m256, imm8)              [AVX]
            * VSHUFPS(zmm{k}{z}, zmm, m512/m32bcst, imm8)    [AVX512F]
            * VSHUFPS(zmm{k}{z}, zmm, zmm, imm8)             [AVX512F]
            * VSHUFPS(xmm{k}{z}, xmm, m128/m32bcst, imm8)    [AVX512F and AVX512VL]
            * VSHUFPS(xmm{k}{z}, xmm, xmm, imm8)             [AVX512F and AVX512VL]
            * VSHUFPS(ymm{k}{z}, ymm, m256/m32bcst, imm8)    [AVX512F and AVX512VL]
            * VSHUFPS(ymm{k}{z}, ymm, ymm, imm8)             [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VSHUFPS, self).__init__("VSHUFPS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 4:
            raise SyntaxError("Instruction \"VSHUFPS\" requires 4 operands")
        self.in_regs = (False, True, True, False)
        self.out_regs = (True, False, False, False)
        self.out_operands = (True, False, False, False)
        self.avx_mode = True
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_imm(self.operands[3]):
            if not is_imm8(self.operands[3]):
                raise ValueError("Argument #3 can not be encoded as imm8")
            self.encodings.append((0x40, lambda op, vex3=False: vex2(0, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0xC6, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3] & 0xFF])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]) and is_imm(self.operands[3]):
            if not is_imm8(self.operands[3]):
                raise ValueError("Argument #3 can not be encoded as imm8")
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(0, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0xC6]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3] & 0xFF])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]) and is_imm(self.operands[3]):
            if not is_imm8(self.operands[3]):
                raise ValueError("Argument #3 can not be encoded as imm8")
            self.encodings.append((0x40, lambda op, vex3=False: vex2(4, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0xC6, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3] & 0xFF])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]) and is_imm(self.operands[3]):
            if not is_imm8(self.operands[3]):
                raise ValueError("Argument #3 can not be encoded as imm8")
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(4, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0xC6]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3] & 0xFF])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_m512_m32bcst(self.operands[2]) and is_imm(self.operands[3]):
            if not is_imm8(self.operands[3]):
                raise ValueError("Argument #3 can not be encoded as imm8")
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x04, 0b10, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0xC6]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=64) + bytearray([op[3] & 0xFF])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]) and is_imm(self.operands[3]):
            if not is_imm8(self.operands[3]):
                raise ValueError("Argument #3 can not be encoded as imm8")
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7C ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0xC6, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3] & 0xFF])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m128_m32bcst(self.operands[2]) and is_imm(self.operands[3]):
            if not is_imm8(self.operands[3]):
                raise ValueError("Argument #3 can not be encoded as imm8")
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x04, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0xC6]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=16) + bytearray([op[3] & 0xFF])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]) and is_imm(self.operands[3]):
            if not is_imm8(self.operands[3]):
                raise ValueError("Argument #3 can not be encoded as imm8")
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7C ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0xC6, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3] & 0xFF])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_m256_m32bcst(self.operands[2]) and is_imm(self.operands[3]):
            if not is_imm8(self.operands[3]):
                raise ValueError("Argument #3 can not be encoded as imm8")
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x04, 0b01, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0xC6]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=32) + bytearray([op[3] & 0xFF])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_evex_ymm(self.operands[2]) and is_imm(self.operands[3]):
            if not is_imm8(self.operands[3]):
                raise ValueError("Argument #3 can not be encoded as imm8")
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7C ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x20, 0xC6, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3] & 0xFF])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: VSHUFPS " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VUNPCKLPD(Instruction):
    """Unpack and Interleave Low Packed Double-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VUNPCKLPD(xmm, xmm, xmm/m128)              [AVX]
            * VUNPCKLPD(ymm, ymm, ymm/m256)              [AVX]
            * VUNPCKLPD(zmm{k}{z}, zmm, m512/m64bcst)    [AVX512F]
            * VUNPCKLPD(zmm{k}{z}, zmm, zmm)             [AVX512F]
            * VUNPCKLPD(xmm{k}{z}, xmm, m128/m64bcst)    [AVX512F and AVX512VL]
            * VUNPCKLPD(xmm{k}{z}, xmm, xmm)             [AVX512F and AVX512VL]
            * VUNPCKLPD(ymm{k}{z}, ymm, m256/m64bcst)    [AVX512F and AVX512VL]
            * VUNPCKLPD(ymm{k}{z}, ymm, ymm)             [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VUNPCKLPD, self).__init__("VUNPCKLPD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"VUNPCKLPD\" requires 3 operands")
        self.in_regs = (False, True, True)
        self.out_regs = (True, False, False)
        self.out_operands = (True, False, False)
        self.avx_mode = True
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(1, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0x14, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(1, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0x14]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(5, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0x14, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(5, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0x14]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_m512_m64bcst(self.operands[2]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x85, 0b10, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x14]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=64)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x14, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m128_m64bcst(self.operands[2]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x85, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x14]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=16)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0x14, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_m256_m64bcst(self.operands[2]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x85, 0b01, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x14]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=32)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_evex_ymm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x20, 0x14, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: VUNPCKLPD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VUNPCKHPD(Instruction):
    """Unpack and Interleave High Packed Double-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VUNPCKHPD(xmm, xmm, xmm/m128)              [AVX]
            * VUNPCKHPD(ymm, ymm, ymm/m256)              [AVX]
            * VUNPCKHPD(zmm{k}{z}, zmm, m512/m64bcst)    [AVX512F]
            * VUNPCKHPD(zmm{k}{z}, zmm, zmm)             [AVX512F]
            * VUNPCKHPD(xmm{k}{z}, xmm, m128/m64bcst)    [AVX512F and AVX512VL]
            * VUNPCKHPD(xmm{k}{z}, xmm, xmm)             [AVX512F and AVX512VL]
            * VUNPCKHPD(ymm{k}{z}, ymm, m256/m64bcst)    [AVX512F and AVX512VL]
            * VUNPCKHPD(ymm{k}{z}, ymm, ymm)             [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VUNPCKHPD, self).__init__("VUNPCKHPD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"VUNPCKHPD\" requires 3 operands")
        self.in_regs = (False, True, True)
        self.out_regs = (True, False, False)
        self.out_operands = (True, False, False)
        self.avx_mode = True
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(1, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0x15, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(1, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0x15]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(5, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0x15, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(5, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0x15]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_m512_m64bcst(self.operands[2]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x85, 0b10, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x15]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=64)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x15, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m128_m64bcst(self.operands[2]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x85, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x15]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=16)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0x15, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_m256_m64bcst(self.operands[2]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x85, 0b01, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x15]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=32)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_evex_ymm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x20, 0x15, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: VUNPCKHPD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VSHUFPD(Instruction):
    """Shuffle Packed Double-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VSHUFPD(xmm, xmm, xmm/m128, imm8)              [AVX]
            * VSHUFPD(ymm, ymm, ymm/m256, imm8)              [AVX]
            * VSHUFPD(zmm{k}{z}, zmm, m512/m64bcst, imm8)    [AVX512F]
            * VSHUFPD(zmm{k}{z}, zmm, zmm, imm8)             [AVX512F]
            * VSHUFPD(xmm{k}{z}, xmm, m128/m64bcst, imm8)    [AVX512F and AVX512VL]
            * VSHUFPD(xmm{k}{z}, xmm, xmm, imm8)             [AVX512F and AVX512VL]
            * VSHUFPD(ymm{k}{z}, ymm, m256/m64bcst, imm8)    [AVX512F and AVX512VL]
            * VSHUFPD(ymm{k}{z}, ymm, ymm, imm8)             [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VSHUFPD, self).__init__("VSHUFPD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 4:
            raise SyntaxError("Instruction \"VSHUFPD\" requires 4 operands")
        self.in_regs = (False, True, True, False)
        self.out_regs = (True, False, False, False)
        self.out_operands = (True, False, False, False)
        self.avx_mode = True
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_imm(self.operands[3]):
            if not is_imm8(self.operands[3]):
                raise ValueError("Argument #3 can not be encoded as imm8")
            self.encodings.append((0x40, lambda op, vex3=False: vex2(1, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0xC6, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3] & 0xFF])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]) and is_imm(self.operands[3]):
            if not is_imm8(self.operands[3]):
                raise ValueError("Argument #3 can not be encoded as imm8")
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(1, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0xC6]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3] & 0xFF])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]) and is_imm(self.operands[3]):
            if not is_imm8(self.operands[3]):
                raise ValueError("Argument #3 can not be encoded as imm8")
            self.encodings.append((0x40, lambda op, vex3=False: vex2(5, op[0].hcode, op[2], op[1].hlcode, vex3) + bytearray([0xC6, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3] & 0xFF])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]) and is_imm(self.operands[3]):
            if not is_imm8(self.operands[3]):
                raise ValueError("Argument #3 can not be encoded as imm8")
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(5, op[0].hcode, op[2].address, op[1].hlcode, vex3) + bytearray([0xC6]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3] & 0xFF])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_m512_m64bcst(self.operands[2]) and is_imm(self.operands[3]):
            if not is_imm8(self.operands[3]):
                raise ValueError("Argument #3 can not be encoded as imm8")
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x85, 0b10, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0xC6]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=64) + bytearray([op[3] & 0xFF])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]) and is_imm(self.operands[3]):
            if not is_imm8(self.operands[3]):
                raise ValueError("Argument #3 can not be encoded as imm8")
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0xC6, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3] & 0xFF])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m128_m64bcst(self.operands[2]) and is_imm(self.operands[3]):
            if not is_imm8(self.operands[3]):
                raise ValueError("Argument #3 can not be encoded as imm8")
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x85, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0xC6]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=16) + bytearray([op[3] & 0xFF])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]) and is_imm(self.operands[3]):
            if not is_imm8(self.operands[3]):
                raise ValueError("Argument #3 can not be encoded as imm8")
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0xC6, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3] & 0xFF])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_m256_m64bcst(self.operands[2]) and is_imm(self.operands[3]):
            if not is_imm8(self.operands[3]):
                raise ValueError("Argument #3 can not be encoded as imm8")
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x85, 0b01, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0xC6]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=32) + bytearray([op[3] & 0xFF])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_evex_ymm(self.operands[2]) and is_imm(self.operands[3]):
            if not is_imm8(self.operands[3]):
                raise ValueError("Argument #3 can not be encoded as imm8")
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x20, 0xC6, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3] & 0xFF])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: VSHUFPD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPERMPS(Instruction):
    """Permute Single-Precision Floating-Point Elements"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPERMPS(ymm, ymm, ymm/m256)              [AVX2]
            * VPERMPS(zmm{k}{z}, zmm, m512/m32bcst)    [AVX512F]
            * VPERMPS(zmm{k}{z}, zmm, zmm)             [AVX512F]
            * VPERMPS(ymm{k}{z}, ymm, m256/m32bcst)    [AVX512F and AVX512VL]
            * VPERMPS(ymm{k}{z}, ymm, ymm)             [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPERMPS, self).__init__("VPERMPS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"VPERMPS\" requires 3 operands")
        self.in_regs = (False, True, True)
        self.out_regs = (True, False, False)
        self.out_operands = (True, False, False)
        self.avx_mode = True
        if is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x7D ^ (op[1].hlcode << 3), 0x16, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx2])
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x05, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x16]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx2])
        elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_m512_m32bcst(self.operands[2]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b10, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x16]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=64)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x16, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_m256_m32bcst(self.operands[2]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b01, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x16]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=32)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_evex_ymm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x20, 0x16, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: VPERMPS " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPERMILPS(Instruction):
    """Permute Single-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPERMILPS(xmm, xmm, xmm/m128)               [AVX]
            * VPERMILPS(xmm, xmm/m128, imm8)              [AVX]
            * VPERMILPS(ymm, ymm, ymm/m256)               [AVX]
            * VPERMILPS(ymm, ymm/m256, imm8)              [AVX]
            * VPERMILPS(zmm{k}{z}, m512/m32bcst, imm8)    [AVX512F]
            * VPERMILPS(zmm{k}{z}, zmm, m512/m32bcst)     [AVX512F]
            * VPERMILPS(zmm{k}{z}, zmm, imm8)             [AVX512F]
            * VPERMILPS(zmm{k}{z}, zmm, zmm)              [AVX512F]
            * VPERMILPS(xmm{k}{z}, m128/m32bcst, imm8)    [AVX512F and AVX512VL]
            * VPERMILPS(ymm{k}{z}, m256/m32bcst, imm8)    [AVX512F and AVX512VL]
            * VPERMILPS(xmm{k}{z}, xmm, m128/m32bcst)     [AVX512F and AVX512VL]
            * VPERMILPS(xmm{k}{z}, xmm, imm8)             [AVX512F and AVX512VL]
            * VPERMILPS(xmm{k}{z}, xmm, xmm)              [AVX512F and AVX512VL]
            * VPERMILPS(ymm{k}{z}, ymm, m256/m32bcst)     [AVX512F and AVX512VL]
            * VPERMILPS(ymm{k}{z}, ymm, imm8)             [AVX512F and AVX512VL]
            * VPERMILPS(ymm{k}{z}, ymm, ymm)              [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPERMILPS, self).__init__("VPERMILPS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"VPERMILPS\" requires 3 operands")
        self.out_regs = (True, False, False)
        self.out_operands = (True, False, False)
        self.avx_mode = True
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x79, 0x04, 0xC0 | op[0].lcode << 3 | op[1].lcode, op[2] & 0xFF])))
            self.in_regs = (False, True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x79 ^ (op[1].hlcode << 3), 0x0C, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.in_regs = (False, True, True)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x01, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x0C]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
            self.in_regs = (False, True, True)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_xmm(self.operands[0]) and is_m128(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x01, op[0].hcode, op[1].address) + bytearray([0x04]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp) + bytearray([op[2] & 0xFF])))
            self.in_regs = (False, True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x7D, 0x04, 0xC0 | op[0].lcode << 3 | op[1].lcode, op[2] & 0xFF])))
            self.in_regs = (False, True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x7D ^ (op[1].hlcode << 3), 0x0C, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.in_regs = (False, True, True)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x05, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x0C]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
            self.in_regs = (False, True, True)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_ymm(self.operands[0]) and is_m256(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x05, op[0].hcode, op[1].address) + bytearray([0x04]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp) + bytearray([op[2] & 0xFF])))
            self.in_regs = (False, True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_zmmkz(self.operands[0]) and is_m512_m32bcst(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b11, 0x05, 0b10, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode, b=op[1].bcode) + bytearray([0x04]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=64) + bytearray([op[2] & 0xFF])))
            self.in_regs = (False, True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_m512_m32bcst(self.operands[2]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b10, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x0C]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=64)))
            self.in_regs = (False, True, True)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 243, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x04, 0xC0 | op[0].lcode << 3 | op[1].lcode, op[2] & 0xFF])))
            self.in_regs = (False, True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x0C, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.in_regs = (False, True, True)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_m128_m32bcst(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b11, 0x05, 0b00, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode, b=op[1].bcode) + bytearray([0x04]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=16) + bytearray([op[2] & 0xFF])))
            self.in_regs = (False, True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_m256_m32bcst(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b11, 0x05, 0b01, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode, b=op[1].bcode) + bytearray([0x04]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=32) + bytearray([op[2] & 0xFF])))
            self.in_regs = (False, True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m128_m32bcst(self.operands[2]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x0C]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=16)))
            self.in_regs = (False, True, True)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 243, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x08, 0x04, 0xC0 | op[0].lcode << 3 | op[1].lcode, op[2] & 0xFF])))
            self.in_regs = (False, True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0x0C, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.in_regs = (False, True, True)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_m256_m32bcst(self.operands[2]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b01, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x0C]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=32)))
            self.in_regs = (False, True, True)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 243, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x28, 0x04, 0xC0 | op[0].lcode << 3 | op[1].lcode, op[2] & 0xFF])))
            self.in_regs = (False, True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_evex_ymm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x20, 0x0C, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.in_regs = (False, True, True)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: VPERMILPS " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPERMT2PS(Instruction):
    """Full Permute of Single-Precision Floating-Point Values From Two Tables Overwriting a Table"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPERMT2PS(zmm{k}{z}, zmm, m512/m32bcst)    [AVX512F]
            * VPERMT2PS(zmm{k}{z}, zmm, zmm)             [AVX512F]
            * VPERMT2PS(xmm{k}{z}, xmm, m128/m32bcst)    [AVX512F and AVX512VL]
            * VPERMT2PS(xmm{k}{z}, xmm, xmm)             [AVX512F and AVX512VL]
            * VPERMT2PS(ymm{k}{z}, ymm, m256/m32bcst)    [AVX512F and AVX512VL]
            * VPERMT2PS(ymm{k}{z}, ymm, ymm)             [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPERMT2PS, self).__init__("VPERMT2PS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"VPERMT2PS\" requires 3 operands")
        self.in_regs = (True, True, True)
        self.out_regs = (True, False, False)
        self.out_operands = (True, False, False)
        self.avx_mode = True
        if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_m512_m32bcst(self.operands[2]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b10, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x7F]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=64)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x7F, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m128_m32bcst(self.operands[2]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x7F]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=16)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0x7F, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_m256_m32bcst(self.operands[2]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b01, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x7F]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=32)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_evex_ymm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x20, 0x7F, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: VPERMT2PS " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPERMI2PS(Instruction):
    """Full Permute of Single-Precision Floating-Point Values From Two Tables Overwriting the Index"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPERMI2PS(zmm{k}{z}, zmm, m512/m32bcst)    [AVX512F]
            * VPERMI2PS(zmm{k}{z}, zmm, zmm)             [AVX512F]
            * VPERMI2PS(xmm{k}{z}, xmm, m128/m32bcst)    [AVX512F and AVX512VL]
            * VPERMI2PS(xmm{k}{z}, xmm, xmm)             [AVX512F and AVX512VL]
            * VPERMI2PS(ymm{k}{z}, ymm, m256/m32bcst)    [AVX512F and AVX512VL]
            * VPERMI2PS(ymm{k}{z}, ymm, ymm)             [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPERMI2PS, self).__init__("VPERMI2PS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"VPERMI2PS\" requires 3 operands")
        self.in_regs = (True, True, True)
        self.out_regs = (True, False, False)
        self.out_operands = (True, False, False)
        self.avx_mode = True
        if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_m512_m32bcst(self.operands[2]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b10, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x77]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=64)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x77, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m128_m32bcst(self.operands[2]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x77]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=16)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0x77, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_m256_m32bcst(self.operands[2]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b01, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x77]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=32)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_evex_ymm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x20, 0x77, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: VPERMI2PS " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPERMPD(Instruction):
    """Permute Double-Precision Floating-Point Elements"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPERMPD(ymm, ymm/m256, imm8)              [AVX2]
            * VPERMPD(zmm{k}{z}, m512/m64bcst, imm8)    [AVX512F]
            * VPERMPD(zmm{k}{z}, zmm, m512/m64bcst)     [AVX512F]
            * VPERMPD(zmm{k}{z}, zmm, imm8)             [AVX512F]
            * VPERMPD(zmm{k}{z}, zmm, zmm)              [AVX512F]
            * VPERMPD(ymm{k}{z}, m256/m64bcst, imm8)    [AVX512F and AVX512VL]
            * VPERMPD(ymm{k}{z}, ymm, m256/m64bcst)     [AVX512F and AVX512VL]
            * VPERMPD(ymm{k}{z}, ymm, imm8)             [AVX512F and AVX512VL]
            * VPERMPD(ymm{k}{z}, ymm, ymm)              [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPERMPD, self).__init__("VPERMPD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"VPERMPD\" requires 3 operands")
        self.out_regs = (True, False, False)
        self.out_operands = (True, False, False)
        self.avx_mode = True
        if is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0xFD, 0x01, 0xC0 | op[0].lcode << 3 | op[1].lcode, op[2] & 0xFF])))
            self.in_regs = (False, True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx2])
        elif is_ymm(self.operands[0]) and is_m256(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x85, op[0].hcode, op[1].address) + bytearray([0x01]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp) + bytearray([op[2] & 0xFF])))
            self.in_regs = (False, True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx2])
        elif is_zmmkz(self.operands[0]) and is_m512_m64bcst(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b11, 0x85, 0b10, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode, b=op[1].bcode) + bytearray([0x01]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=64) + bytearray([op[2] & 0xFF])))
            self.in_regs = (False, True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_m512_m64bcst(self.operands[2]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b10, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x16]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=64)))
            self.in_regs = (False, True, True)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 243, 0xFD, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x01, 0xC0 | op[0].lcode << 3 | op[1].lcode, op[2] & 0xFF])))
            self.in_regs = (False, True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x16, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.in_regs = (False, True, True)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_m256_m64bcst(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b11, 0x85, 0b01, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode, b=op[1].bcode) + bytearray([0x01]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=32) + bytearray([op[2] & 0xFF])))
            self.in_regs = (False, True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_m256_m64bcst(self.operands[2]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b01, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x16]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=32)))
            self.in_regs = (False, True, True)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 243, 0xFD, (op[0].zcode << 7) | op[0].kcode | 0x28, 0x01, 0xC0 | op[0].lcode << 3 | op[1].lcode, op[2] & 0xFF])))
            self.in_regs = (False, True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_evex_ymm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x20, 0x16, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.in_regs = (False, True, True)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: VPERMPD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPERMILPD(Instruction):
    """Permute Double-Precision Floating-Point Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPERMILPD(xmm, xmm, xmm/m128)               [AVX]
            * VPERMILPD(xmm, xmm/m128, imm8)              [AVX]
            * VPERMILPD(ymm, ymm, ymm/m256)               [AVX]
            * VPERMILPD(ymm, ymm/m256, imm8)              [AVX]
            * VPERMILPD(zmm{k}{z}, m512/m64bcst, imm8)    [AVX512F]
            * VPERMILPD(zmm{k}{z}, zmm, m512/m64bcst)     [AVX512F]
            * VPERMILPD(zmm{k}{z}, zmm, imm8)             [AVX512F]
            * VPERMILPD(zmm{k}{z}, zmm, zmm)              [AVX512F]
            * VPERMILPD(xmm{k}{z}, m128/m64bcst, imm8)    [AVX512F and AVX512VL]
            * VPERMILPD(ymm{k}{z}, m256/m64bcst, imm8)    [AVX512F and AVX512VL]
            * VPERMILPD(xmm{k}{z}, xmm, m128/m64bcst)     [AVX512F and AVX512VL]
            * VPERMILPD(xmm{k}{z}, xmm, imm8)             [AVX512F and AVX512VL]
            * VPERMILPD(xmm{k}{z}, xmm, xmm)              [AVX512F and AVX512VL]
            * VPERMILPD(ymm{k}{z}, ymm, m256/m64bcst)     [AVX512F and AVX512VL]
            * VPERMILPD(ymm{k}{z}, ymm, imm8)             [AVX512F and AVX512VL]
            * VPERMILPD(ymm{k}{z}, ymm, ymm)              [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPERMILPD, self).__init__("VPERMILPD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"VPERMILPD\" requires 3 operands")
        self.out_regs = (True, False, False)
        self.out_operands = (True, False, False)
        self.avx_mode = True
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x79, 0x05, 0xC0 | op[0].lcode << 3 | op[1].lcode, op[2] & 0xFF])))
            self.in_regs = (False, True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x79 ^ (op[1].hlcode << 3), 0x0D, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.in_regs = (False, True, True)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x01, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x0D]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
            self.in_regs = (False, True, True)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_xmm(self.operands[0]) and is_m128(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x01, op[0].hcode, op[1].address) + bytearray([0x05]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp) + bytearray([op[2] & 0xFF])))
            self.in_regs = (False, True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x7D, 0x05, 0xC0 | op[0].lcode << 3 | op[1].lcode, op[2] & 0xFF])))
            self.in_regs = (False, True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x7D ^ (op[1].hlcode << 3), 0x0D, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.in_regs = (False, True, True)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x05, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x0D]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
            self.in_regs = (False, True, True)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_ymm(self.operands[0]) and is_m256(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x05, op[0].hcode, op[1].address) + bytearray([0x05]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp) + bytearray([op[2] & 0xFF])))
            self.in_regs = (False, True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_zmmkz(self.operands[0]) and is_m512_m64bcst(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b11, 0x85, 0b10, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode, b=op[1].bcode) + bytearray([0x05]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=64) + bytearray([op[2] & 0xFF])))
            self.in_regs = (False, True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_m512_m64bcst(self.operands[2]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b10, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x0D]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=64)))
            self.in_regs = (False, True, True)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 243, 0xFD, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x05, 0xC0 | op[0].lcode << 3 | op[1].lcode, op[2] & 0xFF])))
            self.in_regs = (False, True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x0D, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.in_regs = (False, True, True)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_m128_m64bcst(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b11, 0x85, 0b00, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode, b=op[1].bcode) + bytearray([0x05]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=16) + bytearray([op[2] & 0xFF])))
            self.in_regs = (False, True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_m256_m64bcst(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b11, 0x85, 0b01, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode, b=op[1].bcode) + bytearray([0x05]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=32) + bytearray([op[2] & 0xFF])))
            self.in_regs = (False, True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m128_m64bcst(self.operands[2]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x0D]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=16)))
            self.in_regs = (False, True, True)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 243, 0xFD, (op[0].zcode << 7) | op[0].kcode | 0x08, 0x05, 0xC0 | op[0].lcode << 3 | op[1].lcode, op[2] & 0xFF])))
            self.in_regs = (False, True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0x0D, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.in_regs = (False, True, True)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_m256_m64bcst(self.operands[2]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b01, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x0D]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=32)))
            self.in_regs = (False, True, True)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 243, 0xFD, (op[0].zcode << 7) | op[0].kcode | 0x28, 0x05, 0xC0 | op[0].lcode << 3 | op[1].lcode, op[2] & 0xFF])))
            self.in_regs = (False, True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_evex_ymm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x20, 0x0D, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.in_regs = (False, True, True)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: VPERMILPD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPERMT2PD(Instruction):
    """Full Permute of Double-Precision Floating-Point Values From Two Tables Overwriting a Table"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPERMT2PD(zmm{k}{z}, zmm, m512/m64bcst)    [AVX512F]
            * VPERMT2PD(zmm{k}{z}, zmm, zmm)             [AVX512F]
            * VPERMT2PD(xmm{k}{z}, xmm, m128/m64bcst)    [AVX512F and AVX512VL]
            * VPERMT2PD(xmm{k}{z}, xmm, xmm)             [AVX512F and AVX512VL]
            * VPERMT2PD(ymm{k}{z}, ymm, m256/m64bcst)    [AVX512F and AVX512VL]
            * VPERMT2PD(ymm{k}{z}, ymm, ymm)             [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPERMT2PD, self).__init__("VPERMT2PD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"VPERMT2PD\" requires 3 operands")
        self.in_regs = (True, True, True)
        self.out_regs = (True, False, False)
        self.out_operands = (True, False, False)
        self.avx_mode = True
        if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_m512_m64bcst(self.operands[2]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b10, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x7F]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=64)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x7F, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m128_m64bcst(self.operands[2]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x7F]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=16)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0x7F, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_m256_m64bcst(self.operands[2]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b01, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x7F]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=32)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_evex_ymm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x20, 0x7F, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: VPERMT2PD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPERMI2PD(Instruction):
    """Full Permute of Double-Precision Floating-Point Values From Two Tables Overwriting the Index"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPERMI2PD(zmm{k}{z}, zmm, m512/m64bcst)    [AVX512F]
            * VPERMI2PD(zmm{k}{z}, zmm, zmm)             [AVX512F]
            * VPERMI2PD(xmm{k}{z}, xmm, m128/m64bcst)    [AVX512F and AVX512VL]
            * VPERMI2PD(xmm{k}{z}, xmm, xmm)             [AVX512F and AVX512VL]
            * VPERMI2PD(ymm{k}{z}, ymm, m256/m64bcst)    [AVX512F and AVX512VL]
            * VPERMI2PD(ymm{k}{z}, ymm, ymm)             [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPERMI2PD, self).__init__("VPERMI2PD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"VPERMI2PD\" requires 3 operands")
        self.in_regs = (True, True, True)
        self.out_regs = (True, False, False)
        self.out_operands = (True, False, False)
        self.avx_mode = True
        if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_m512_m64bcst(self.operands[2]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b10, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x77]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=64)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]) and is_zmm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x40, 0x77, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_m128_m64bcst(self.operands[2]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b00, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x77]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=16)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]) and is_evex_xmm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x00, 0x77, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_m256_m64bcst(self.operands[2]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b01, op[0].ehcode, op[2].address, op[1].code, aaa=op[0].kcode, z=op[0].zcode, b=op[2].bcode) + bytearray([0x77]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp, disp8xN=32)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]) and is_evex_ymm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[2].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD ^ (op[1].hlcode << 3), (op[0].zcode << 7) | (op[1].ecode << 3 ^ 0x8) | op[0].kcode | 0x20, 0x77, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: VPERMI2PD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VMOVD(Instruction):
    """Move Doubleword"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VMOVD(xmm, r32/m32)    [AVX]
            * VMOVD(r32/m32, xmm)    [AVX]
            * VMOVD(xmm, r32/m32)    [AVX512F]
            * VMOVD(r32/m32, xmm)    [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VMOVD, self).__init__("VMOVD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VMOVD\" requires 2 operands")
        self.out_operands = (True, False)
        self.avx_mode = True
        if is_r32(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(1, op[1].hcode, op[0], 0, vex3) + bytearray([0x7E, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_xmm(self.operands[0]) and is_r32(self.operands[1]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(1, op[0].hcode, op[1], 0, vex3) + bytearray([0x6E, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_xmm(self.operands[0]) and is_m32(self.operands[1]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(1, op[0].hcode, op[1].address, 0, vex3) + bytearray([0x6E]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_m32(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(1, op[1].hcode, op[0].address, 0, vex3) + bytearray([0x7E]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_r32(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[1].hcode << 7) | (op[0].ehcode << 5) | (op[1].ecode << 4)) ^ 241, 0x7D, 0x08, 0x7E, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_evex_xmm(self.operands[0]) and is_r32(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7D, 0x08, 0x6E, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_evex_xmm(self.operands[0]) and is_m32(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x05, 0b00, op[0].ehcode, op[1].address) + bytearray([0x6E]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=4)))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_m32(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x05, 0b00, op[1].ehcode, op[0].address) + bytearray([0x7E]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=4)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: VMOVD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VMOVQ(Instruction):
    """Move Quadword"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VMOVQ(xmm, xmm)        [AVX]
            * VMOVQ(xmm, r64/m64)    [AVX]
            * VMOVQ(r64/m64, xmm)    [AVX]
            * VMOVQ(xmm, xmm)        [AVX512F]
            * VMOVQ(xmm, r64/m64)    [AVX512F]
            * VMOVQ(r64/m64, xmm)    [AVX512F]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VMOVQ, self).__init__("VMOVQ", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VMOVQ\" requires 2 operands")
        self.out_operands = (True, False)
        self.avx_mode = True
        if is_r64(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE1 ^ (op[1].hcode << 7) ^ (op[0].hcode << 5), 0xF9, 0x7E, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_xmm(self.operands[0]) and is_r64(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE1 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0xF9, 0x6E, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(2, op[0].hcode, op[1], 0, vex3) + bytearray([0x7E, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.encodings.append((0x40, lambda op, vex3=False: vex2(1, op[1].hcode, op[0], 0, vex3) + bytearray([0xD6, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_xmm(self.operands[0]) and is_m64(self.operands[1]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(2, op[0].hcode, op[1].address, 0, vex3) + bytearray([0x7E]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b1, 0x81, op[0].hcode, op[1].address) + bytearray([0x6E]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_m64(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(1, op[1].hcode, op[0].address, 0, vex3) + bytearray([0xD6]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp)))
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b1, 0x81, op[1].hcode, op[0].address) + bytearray([0x7E]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_r64(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[1].hcode << 7) | (op[0].ehcode << 5) | (op[1].ecode << 4)) ^ 241, 0xFD, 0x08, 0x7E, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_evex_xmm(self.operands[0]) and is_r64(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFD, 0x08, 0x6E, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_evex_xmm(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFE, 0x08, 0x7E, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[1].hcode << 7) | (op[0].ehcode << 5) | (op[1].ecode << 4)) ^ 241, 0xFD, 0x08, 0xD6, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_evex_xmm(self.operands[0]) and is_m64(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x85, 0b00, op[0].ehcode, op[1].address) + bytearray([0x6E]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=8)))
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x86, 0b00, op[0].ehcode, op[1].address) + bytearray([0x7E]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=8)))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_m64(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x85, 0b00, op[1].ehcode, op[0].address) + bytearray([0x7E]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=8)))
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x85, 0b00, op[1].ehcode, op[0].address) + bytearray([0xD6]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=8)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: VMOVQ " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VMOVDQA(Instruction):
    """Move Aligned Double Quadword"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VMOVDQA(xmm, xmm/m128)    [AVX]
            * VMOVDQA(ymm, ymm/m256)    [AVX]
            * VMOVDQA(xmm/m128, xmm)    [AVX]
            * VMOVDQA(ymm/m256, ymm)    [AVX]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VMOVDQA, self).__init__("VMOVDQA", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VMOVDQA\" requires 2 operands")
        self.out_operands = (True, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(1, op[0].hcode, op[1], 0, vex3) + bytearray([0x6F, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.encodings.append((0x40, lambda op, vex3=False: vex2(1, op[1].hcode, op[0], 0, vex3) + bytearray([0x7F, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
        elif is_xmm(self.operands[0]) and is_m128(self.operands[1]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(1, op[0].hcode, op[1].address, 0, vex3) + bytearray([0x6F]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(5, op[0].hcode, op[1], 0, vex3) + bytearray([0x6F, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.encodings.append((0x40, lambda op, vex3=False: vex2(5, op[1].hcode, op[0], 0, vex3) + bytearray([0x7F, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
        elif is_ymm(self.operands[0]) and is_m256(self.operands[1]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(5, op[0].hcode, op[1].address, 0, vex3) + bytearray([0x6F]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
        elif is_m128(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(1, op[1].hcode, op[0].address, 0, vex3) + bytearray([0x7F]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
        elif is_m256(self.operands[0]) and is_ymm(self.operands[1]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(5, op[1].hcode, op[0].address, 0, vex3) + bytearray([0x7F]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
        else:
            raise SyntaxError("Invalid operand types: VMOVDQA " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VMOVDQA32(Instruction):
    """Move Aligned Doubleword Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VMOVDQA32(m512{k}{z}, zmm)        [AVX512F]
            * VMOVDQA32(zmm{k}{z}, zmm/m512)    [AVX512F]
            * VMOVDQA32(m128{k}{z}, xmm)        [AVX512F and AVX512VL]
            * VMOVDQA32(m256{k}{z}, ymm)        [AVX512F and AVX512VL]
            * VMOVDQA32(xmm{k}{z}, xmm/m128)    [AVX512F and AVX512VL]
            * VMOVDQA32(ymm{k}{z}, ymm/m256)    [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VMOVDQA32, self).__init__("VMOVDQA32", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VMOVDQA32\" requires 2 operands")
        self.out_operands = (True, False)
        self.avx_mode = True
        if is_m512kz(self.operands[0]) and is_zmm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x05, 0b10, op[1].ehcode, op[0].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x7F]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=64)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x6F, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[1].hcode << 7) | (op[0].ehcode << 5) | (op[1].ecode << 4)) ^ 241, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x7F, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_zmmkz(self.operands[0]) and is_m512(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x05, 0b10, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x6F]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=64)))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_m128kz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x05, 0b00, op[1].ehcode, op[0].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x7F]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=16)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x08, 0x6F, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[1].hcode << 7) | (op[0].ehcode << 5) | (op[1].ecode << 4)) ^ 241, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x08, 0x7F, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_m256kz(self.operands[0]) and is_evex_ymm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x05, 0b01, op[1].ehcode, op[0].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x7F]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=32)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x28, 0x6F, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[1].hcode << 7) | (op[0].ehcode << 5) | (op[1].ecode << 4)) ^ 241, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x28, 0x7F, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_m128(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x05, 0b00, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x6F]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=16)))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_m256(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x05, 0b01, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x6F]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=32)))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: VMOVDQA32 " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VMOVDQA64(Instruction):
    """Move Aligned Quadword Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VMOVDQA64(m512{k}{z}, zmm)        [AVX512F]
            * VMOVDQA64(zmm{k}{z}, zmm/m512)    [AVX512F]
            * VMOVDQA64(m128{k}{z}, xmm)        [AVX512F and AVX512VL]
            * VMOVDQA64(m256{k}{z}, ymm)        [AVX512F and AVX512VL]
            * VMOVDQA64(xmm{k}{z}, xmm/m128)    [AVX512F and AVX512VL]
            * VMOVDQA64(ymm{k}{z}, ymm/m256)    [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VMOVDQA64, self).__init__("VMOVDQA64", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VMOVDQA64\" requires 2 operands")
        self.out_operands = (True, False)
        self.avx_mode = True
        if is_m512kz(self.operands[0]) and is_zmm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x85, 0b10, op[1].ehcode, op[0].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x7F]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=64)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFD, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x6F, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[1].hcode << 7) | (op[0].ehcode << 5) | (op[1].ecode << 4)) ^ 241, 0xFD, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x7F, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_zmmkz(self.operands[0]) and is_m512(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x85, 0b10, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x6F]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=64)))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_m128kz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x85, 0b00, op[1].ehcode, op[0].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x7F]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=16)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFD, (op[0].zcode << 7) | op[0].kcode | 0x08, 0x6F, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[1].hcode << 7) | (op[0].ehcode << 5) | (op[1].ecode << 4)) ^ 241, 0xFD, (op[0].zcode << 7) | op[0].kcode | 0x08, 0x7F, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_m256kz(self.operands[0]) and is_evex_ymm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x85, 0b01, op[1].ehcode, op[0].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x7F]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=32)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFD, (op[0].zcode << 7) | op[0].kcode | 0x28, 0x6F, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[1].hcode << 7) | (op[0].ehcode << 5) | (op[1].ecode << 4)) ^ 241, 0xFD, (op[0].zcode << 7) | op[0].kcode | 0x28, 0x7F, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_m128(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x85, 0b00, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x6F]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=16)))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_m256(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x85, 0b01, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x6F]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=32)))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: VMOVDQA64 " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VMOVDQU(Instruction):
    """Move Unaligned Double Quadword"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VMOVDQU(xmm, xmm/m128)    [AVX]
            * VMOVDQU(ymm, ymm/m256)    [AVX]
            * VMOVDQU(xmm/m128, xmm)    [AVX]
            * VMOVDQU(ymm/m256, ymm)    [AVX]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VMOVDQU, self).__init__("VMOVDQU", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VMOVDQU\" requires 2 operands")
        self.out_operands = (True, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(2, op[0].hcode, op[1], 0, vex3) + bytearray([0x6F, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.encodings.append((0x40, lambda op, vex3=False: vex2(2, op[1].hcode, op[0], 0, vex3) + bytearray([0x7F, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
        elif is_xmm(self.operands[0]) and is_m128(self.operands[1]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(2, op[0].hcode, op[1].address, 0, vex3) + bytearray([0x6F]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(6, op[0].hcode, op[1], 0, vex3) + bytearray([0x6F, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.encodings.append((0x40, lambda op, vex3=False: vex2(6, op[1].hcode, op[0], 0, vex3) + bytearray([0x7F, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
        elif is_ymm(self.operands[0]) and is_m256(self.operands[1]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(6, op[0].hcode, op[1].address, 0, vex3) + bytearray([0x6F]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
        elif is_m128(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(2, op[1].hcode, op[0].address, 0, vex3) + bytearray([0x7F]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
        elif is_m256(self.operands[0]) and is_ymm(self.operands[1]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(6, op[1].hcode, op[0].address, 0, vex3) + bytearray([0x7F]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
        else:
            raise SyntaxError("Invalid operand types: VMOVDQU " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VMOVDQU8(Instruction):
    """Move Unaligned Byte Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VMOVDQU8(m512{k}{z}, zmm)        [AVX512BW]
            * VMOVDQU8(zmm{k}{z}, zmm/m512)    [AVX512BW]
            * VMOVDQU8(m128{k}{z}, xmm)        [AVX512BW and AVX512VL]
            * VMOVDQU8(m256{k}{z}, ymm)        [AVX512BW and AVX512VL]
            * VMOVDQU8(xmm{k}{z}, xmm/m128)    [AVX512BW and AVX512VL]
            * VMOVDQU8(ymm{k}{z}, ymm/m256)    [AVX512BW and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VMOVDQU8, self).__init__("VMOVDQU8", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VMOVDQU8\" requires 2 operands")
        self.out_operands = (True, False)
        self.avx_mode = True
        if is_m512kz(self.operands[0]) and is_zmm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x07, 0b10, op[1].ehcode, op[0].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x7F]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=64)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512bw])
        elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7F, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x6F, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[1].hcode << 7) | (op[0].ehcode << 5) | (op[1].ecode << 4)) ^ 241, 0x7F, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x7F, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512bw])
        elif is_zmmkz(self.operands[0]) and is_m512(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x07, 0b10, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x6F]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=64)))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512bw])
        elif is_m128kz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x07, 0b00, op[1].ehcode, op[0].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x7F]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=16)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512bw])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7F, (op[0].zcode << 7) | op[0].kcode | 0x08, 0x6F, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[1].hcode << 7) | (op[0].ehcode << 5) | (op[1].ecode << 4)) ^ 241, 0x7F, (op[0].zcode << 7) | op[0].kcode | 0x08, 0x7F, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512bw])
        elif is_m256kz(self.operands[0]) and is_evex_ymm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x07, 0b01, op[1].ehcode, op[0].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x7F]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=32)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512bw])
        elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7F, (op[0].zcode << 7) | op[0].kcode | 0x28, 0x6F, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[1].hcode << 7) | (op[0].ehcode << 5) | (op[1].ecode << 4)) ^ 241, 0x7F, (op[0].zcode << 7) | op[0].kcode | 0x28, 0x7F, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512bw])
        elif is_xmmkz(self.operands[0]) and is_m128(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x07, 0b00, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x6F]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=16)))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512bw])
        elif is_ymmkz(self.operands[0]) and is_m256(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x07, 0b01, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x6F]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=32)))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512bw])
        else:
            raise SyntaxError("Invalid operand types: VMOVDQU8 " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VMOVDQU16(Instruction):
    """Move Unaligned Word Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VMOVDQU16(m512{k}{z}, zmm)        [AVX512BW]
            * VMOVDQU16(zmm{k}{z}, zmm/m512)    [AVX512BW]
            * VMOVDQU16(m128{k}{z}, xmm)        [AVX512BW and AVX512VL]
            * VMOVDQU16(m256{k}{z}, ymm)        [AVX512BW and AVX512VL]
            * VMOVDQU16(xmm{k}{z}, xmm/m128)    [AVX512BW and AVX512VL]
            * VMOVDQU16(ymm{k}{z}, ymm/m256)    [AVX512BW and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VMOVDQU16, self).__init__("VMOVDQU16", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VMOVDQU16\" requires 2 operands")
        self.out_operands = (True, False)
        self.avx_mode = True
        if is_m512kz(self.operands[0]) and is_zmm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x87, 0b10, op[1].ehcode, op[0].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x7F]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=64)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512bw])
        elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFF, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x6F, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[1].hcode << 7) | (op[0].ehcode << 5) | (op[1].ecode << 4)) ^ 241, 0xFF, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x7F, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512bw])
        elif is_zmmkz(self.operands[0]) and is_m512(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x87, 0b10, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x6F]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=64)))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512bw])
        elif is_m128kz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x87, 0b00, op[1].ehcode, op[0].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x7F]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=16)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512bw])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFF, (op[0].zcode << 7) | op[0].kcode | 0x08, 0x6F, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[1].hcode << 7) | (op[0].ehcode << 5) | (op[1].ecode << 4)) ^ 241, 0xFF, (op[0].zcode << 7) | op[0].kcode | 0x08, 0x7F, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512bw])
        elif is_m256kz(self.operands[0]) and is_evex_ymm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x87, 0b01, op[1].ehcode, op[0].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x7F]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=32)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512bw])
        elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFF, (op[0].zcode << 7) | op[0].kcode | 0x28, 0x6F, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[1].hcode << 7) | (op[0].ehcode << 5) | (op[1].ecode << 4)) ^ 241, 0xFF, (op[0].zcode << 7) | op[0].kcode | 0x28, 0x7F, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512bw])
        elif is_xmmkz(self.operands[0]) and is_m128(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x87, 0b00, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x6F]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=16)))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512bw])
        elif is_ymmkz(self.operands[0]) and is_m256(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x87, 0b01, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x6F]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=32)))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512bw])
        else:
            raise SyntaxError("Invalid operand types: VMOVDQU16 " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VMOVDQU32(Instruction):
    """Move Unaligned Doubleword Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VMOVDQU32(m512{k}{z}, zmm)        [AVX512F]
            * VMOVDQU32(zmm{k}{z}, zmm/m512)    [AVX512F]
            * VMOVDQU32(m128{k}{z}, xmm)        [AVX512F and AVX512VL]
            * VMOVDQU32(m256{k}{z}, ymm)        [AVX512F and AVX512VL]
            * VMOVDQU32(xmm{k}{z}, xmm/m128)    [AVX512F and AVX512VL]
            * VMOVDQU32(ymm{k}{z}, ymm/m256)    [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VMOVDQU32, self).__init__("VMOVDQU32", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VMOVDQU32\" requires 2 operands")
        self.out_operands = (True, False)
        self.avx_mode = True
        if is_m512kz(self.operands[0]) and is_zmm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x06, 0b10, op[1].ehcode, op[0].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x7F]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=64)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7E, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x6F, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[1].hcode << 7) | (op[0].ehcode << 5) | (op[1].ecode << 4)) ^ 241, 0x7E, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x7F, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_zmmkz(self.operands[0]) and is_m512(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x06, 0b10, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x6F]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=64)))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_m128kz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x06, 0b00, op[1].ehcode, op[0].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x7F]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=16)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7E, (op[0].zcode << 7) | op[0].kcode | 0x08, 0x6F, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[1].hcode << 7) | (op[0].ehcode << 5) | (op[1].ecode << 4)) ^ 241, 0x7E, (op[0].zcode << 7) | op[0].kcode | 0x08, 0x7F, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_m256kz(self.operands[0]) and is_evex_ymm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x06, 0b01, op[1].ehcode, op[0].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x7F]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=32)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0x7E, (op[0].zcode << 7) | op[0].kcode | 0x28, 0x6F, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[1].hcode << 7) | (op[0].ehcode << 5) | (op[1].ecode << 4)) ^ 241, 0x7E, (op[0].zcode << 7) | op[0].kcode | 0x28, 0x7F, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_m128(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x06, 0b00, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x6F]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=16)))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_m256(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x06, 0b01, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x6F]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=32)))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: VMOVDQU32 " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VMOVDQU64(Instruction):
    """Move Unaligned Quadword Values"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VMOVDQU64(m512{k}{z}, zmm)        [AVX512F]
            * VMOVDQU64(zmm{k}{z}, zmm/m512)    [AVX512F]
            * VMOVDQU64(m128{k}{z}, xmm)        [AVX512F and AVX512VL]
            * VMOVDQU64(m256{k}{z}, ymm)        [AVX512F and AVX512VL]
            * VMOVDQU64(xmm{k}{z}, xmm/m128)    [AVX512F and AVX512VL]
            * VMOVDQU64(ymm{k}{z}, ymm/m256)    [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VMOVDQU64, self).__init__("VMOVDQU64", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VMOVDQU64\" requires 2 operands")
        self.out_operands = (True, False)
        self.avx_mode = True
        if is_m512kz(self.operands[0]) and is_zmm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x86, 0b10, op[1].ehcode, op[0].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x7F]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=64)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFE, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x6F, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[1].hcode << 7) | (op[0].ehcode << 5) | (op[1].ecode << 4)) ^ 241, 0xFE, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x7F, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_zmmkz(self.operands[0]) and is_m512(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x86, 0b10, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x6F]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=64)))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_m128kz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x86, 0b00, op[1].ehcode, op[0].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x7F]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=16)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFE, (op[0].zcode << 7) | op[0].kcode | 0x08, 0x6F, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[1].hcode << 7) | (op[0].ehcode << 5) | (op[1].ecode << 4)) ^ 241, 0xFE, (op[0].zcode << 7) | op[0].kcode | 0x08, 0x7F, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_m256kz(self.operands[0]) and is_evex_ymm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x86, 0b01, op[1].ehcode, op[0].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x7F]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=32)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 241, 0xFE, (op[0].zcode << 7) | op[0].kcode | 0x28, 0x6F, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[1].hcode << 7) | (op[0].ehcode << 5) | (op[1].ecode << 4)) ^ 241, 0xFE, (op[0].zcode << 7) | op[0].kcode | 0x28, 0x7F, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_m128(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x86, 0b00, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x6F]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=16)))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_m256(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x86, 0b01, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x6F]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=32)))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: VMOVDQU64 " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VLDDQU(Instruction):
    """Load Unaligned Integer 128 Bits"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VLDDQU(xmm, m128)    [AVX]
            * VLDDQU(ymm, m256)    [AVX]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VLDDQU, self).__init__("VLDDQU", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VLDDQU\" requires 2 operands")
        self.in_regs = (False, True)
        self.out_regs = (True, False)
        self.out_operands = (True, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        if is_xmm(self.operands[0]) and is_m128(self.operands[1]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(3, op[0].hcode, op[1].address, 0, vex3) + bytearray([0xF0]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
        elif is_ymm(self.operands[0]) and is_m256(self.operands[1]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(7, op[0].hcode, op[1].address, 0, vex3) + bytearray([0xF0]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
        else:
            raise SyntaxError("Invalid operand types: VLDDQU " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPBROADCASTB(Instruction):
    """Broadcast Byte Integer"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPBROADCASTB(xmm, xmm/m8)          [AVX2]
            * VPBROADCASTB(ymm, xmm/m8)          [AVX2]
            * VPBROADCASTB(zmm{k}{z}, r32)       [AVX512BW]
            * VPBROADCASTB(zmm{k}{z}, xmm/m8)    [AVX512BW]
            * VPBROADCASTB(xmm{k}{z}, r32)       [AVX512BW and AVX512VL]
            * VPBROADCASTB(ymm{k}{z}, r32)       [AVX512BW and AVX512VL]
            * VPBROADCASTB(xmm{k}{z}, xmm/m8)    [AVX512BW and AVX512VL]
            * VPBROADCASTB(ymm{k}{z}, xmm/m8)    [AVX512BW and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPBROADCASTB, self).__init__("VPBROADCASTB", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VPBROADCASTB\" requires 2 operands")
        self.in_regs = (False, True)
        self.out_regs = (True, False)
        self.out_operands = (True, False)
        self.avx_mode = True
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x79, 0x78, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx2])
        elif is_xmm(self.operands[0]) and is_m8(self.operands[1]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x01, op[0].hcode, op[1].address) + bytearray([0x78]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx2])
        elif is_ymm(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x7D, 0x78, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx2])
        elif is_ymm(self.operands[0]) and is_m8(self.operands[1]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x05, op[0].hcode, op[1].address) + bytearray([0x78]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx2])
        elif is_zmmkz(self.operands[0]) and is_r32(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x7A, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512bw])
        elif is_zmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x78, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512bw])
        elif is_zmmkz(self.operands[0]) and is_m8(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b10, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x78]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=1)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512bw])
        elif is_xmmkz(self.operands[0]) and is_r32(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x08, 0x7A, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512bw])
        elif is_ymmkz(self.operands[0]) and is_r32(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x28, 0x7A, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512bw])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x08, 0x78, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512bw])
        elif is_ymmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x28, 0x78, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512bw])
        elif is_xmmkz(self.operands[0]) and is_m8(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b00, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x78]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=1)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512bw])
        elif is_ymmkz(self.operands[0]) and is_m8(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b01, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x78]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=1)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512bw])
        else:
            raise SyntaxError("Invalid operand types: VPBROADCASTB " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPBROADCASTW(Instruction):
    """Broadcast Word Integer"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPBROADCASTW(xmm, xmm/m16)          [AVX2]
            * VPBROADCASTW(ymm, xmm/m16)          [AVX2]
            * VPBROADCASTW(zmm{k}{z}, r32)        [AVX512BW]
            * VPBROADCASTW(zmm{k}{z}, xmm/m16)    [AVX512BW]
            * VPBROADCASTW(xmm{k}{z}, r32)        [AVX512BW and AVX512VL]
            * VPBROADCASTW(ymm{k}{z}, r32)        [AVX512BW and AVX512VL]
            * VPBROADCASTW(xmm{k}{z}, xmm/m16)    [AVX512BW and AVX512VL]
            * VPBROADCASTW(ymm{k}{z}, xmm/m16)    [AVX512BW and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPBROADCASTW, self).__init__("VPBROADCASTW", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VPBROADCASTW\" requires 2 operands")
        self.in_regs = (False, True)
        self.out_regs = (True, False)
        self.out_operands = (True, False)
        self.avx_mode = True
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x79, 0x79, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx2])
        elif is_xmm(self.operands[0]) and is_m16(self.operands[1]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x01, op[0].hcode, op[1].address) + bytearray([0x79]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx2])
        elif is_ymm(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x7D, 0x79, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx2])
        elif is_ymm(self.operands[0]) and is_m16(self.operands[1]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x05, op[0].hcode, op[1].address) + bytearray([0x79]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx2])
        elif is_zmmkz(self.operands[0]) and is_r32(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x7B, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512bw])
        elif is_zmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x79, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512bw])
        elif is_zmmkz(self.operands[0]) and is_m16(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b10, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x79]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=2)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512bw])
        elif is_xmmkz(self.operands[0]) and is_r32(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x08, 0x7B, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512bw])
        elif is_ymmkz(self.operands[0]) and is_r32(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x28, 0x7B, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512bw])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x08, 0x79, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512bw])
        elif is_ymmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x28, 0x79, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512bw])
        elif is_xmmkz(self.operands[0]) and is_m16(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b00, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x79]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=2)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512bw])
        elif is_ymmkz(self.operands[0]) and is_m16(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b01, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x79]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=2)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512bw])
        else:
            raise SyntaxError("Invalid operand types: VPBROADCASTW " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPBROADCASTD(Instruction):
    """Broadcast Doubleword Integer"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPBROADCASTD(xmm, xmm/m32)          [AVX2]
            * VPBROADCASTD(ymm, xmm/m32)          [AVX2]
            * VPBROADCASTD(zmm{k}{z}, xmm)        [AVX512F]
            * VPBROADCASTD(zmm{k}{z}, r32/m32)    [AVX512F]
            * VPBROADCASTD(xmm{k}{z}, xmm)        [AVX512F and AVX512VL]
            * VPBROADCASTD(ymm{k}{z}, xmm)        [AVX512F and AVX512VL]
            * VPBROADCASTD(xmm{k}{z}, r32/m32)    [AVX512F and AVX512VL]
            * VPBROADCASTD(ymm{k}{z}, r32/m32)    [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPBROADCASTD, self).__init__("VPBROADCASTD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VPBROADCASTD\" requires 2 operands")
        self.in_regs = (False, True)
        self.out_regs = (True, False)
        self.out_operands = (True, False)
        self.avx_mode = True
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x79, 0x58, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx2])
        elif is_xmm(self.operands[0]) and is_m32(self.operands[1]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x01, op[0].hcode, op[1].address) + bytearray([0x58]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx2])
        elif is_ymm(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x7D, 0x58, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx2])
        elif is_ymm(self.operands[0]) and is_m32(self.operands[1]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x05, op[0].hcode, op[1].address) + bytearray([0x58]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx2])
        elif is_zmmkz(self.operands[0]) and is_r32(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x7C, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_zmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x58, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_zmmkz(self.operands[0]) and is_m32(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b10, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x58]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=4)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_r32(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x08, 0x7C, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_r32(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x28, 0x7C, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x08, 0x58, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x28, 0x58, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_m32(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b00, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x58]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=4)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_m32(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b01, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x58]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=4)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: VPBROADCASTD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPBROADCASTQ(Instruction):
    """Broadcast Quadword Integer"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPBROADCASTQ(xmm, xmm/m64)          [AVX2]
            * VPBROADCASTQ(ymm, xmm/m64)          [AVX2]
            * VPBROADCASTQ(zmm{k}{z}, xmm)        [AVX512F]
            * VPBROADCASTQ(zmm{k}{z}, r64/m64)    [AVX512F]
            * VPBROADCASTQ(xmm{k}{z}, xmm)        [AVX512F and AVX512VL]
            * VPBROADCASTQ(ymm{k}{z}, xmm)        [AVX512F and AVX512VL]
            * VPBROADCASTQ(xmm{k}{z}, r64/m64)    [AVX512F and AVX512VL]
            * VPBROADCASTQ(ymm{k}{z}, r64/m64)    [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPBROADCASTQ, self).__init__("VPBROADCASTQ", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VPBROADCASTQ\" requires 2 operands")
        self.in_regs = (False, True)
        self.out_regs = (True, False)
        self.out_operands = (True, False)
        self.avx_mode = True
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x79, 0x59, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx2])
        elif is_xmm(self.operands[0]) and is_m64(self.operands[1]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x01, op[0].hcode, op[1].address) + bytearray([0x59]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx2])
        elif is_ymm(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x7D, 0x59, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx2])
        elif is_ymm(self.operands[0]) and is_m64(self.operands[1]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x05, op[0].hcode, op[1].address) + bytearray([0x59]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx2])
        elif is_zmmkz(self.operands[0]) and is_r64(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x7C, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_zmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x59, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_zmmkz(self.operands[0]) and is_m64(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b10, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x59]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=8)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_r64(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD, (op[0].zcode << 7) | op[0].kcode | 0x08, 0x7C, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_r64(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD, (op[0].zcode << 7) | op[0].kcode | 0x28, 0x7C, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD, (op[0].zcode << 7) | op[0].kcode | 0x08, 0x59, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD, (op[0].zcode << 7) | op[0].kcode | 0x28, 0x59, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_m64(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b00, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x59]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=8)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_m64(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b01, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x59]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=8)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: VPBROADCASTQ " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPEXPANDD(Instruction):
    """Load Sparse Packed Doubleword Integer Values from Dense Memory/Register"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPEXPANDD(zmm{k}{z}, zmm/m512)    [AVX512F]
            * VPEXPANDD(xmm{k}{z}, xmm/m128)    [AVX512F and AVX512VL]
            * VPEXPANDD(ymm{k}{z}, ymm/m256)    [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPEXPANDD, self).__init__("VPEXPANDD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VPEXPANDD\" requires 2 operands")
        self.in_regs = (False, True)
        self.out_regs = (True, False)
        self.out_operands = (True, False)
        self.avx_mode = True
        if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x89, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_zmmkz(self.operands[0]) and is_m512(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b10, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x89]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=4)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x08, 0x89, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x28, 0x89, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_m128(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b00, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x89]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=4)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_m256(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b01, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x89]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=4)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: VPEXPANDD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPEXPANDQ(Instruction):
    """Load Sparse Packed Quadword Integer Values from Dense Memory/Register"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPEXPANDQ(zmm{k}{z}, zmm/m512)    [AVX512F]
            * VPEXPANDQ(xmm{k}{z}, xmm/m128)    [AVX512F and AVX512VL]
            * VPEXPANDQ(ymm{k}{z}, ymm/m256)    [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPEXPANDQ, self).__init__("VPEXPANDQ", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VPEXPANDQ\" requires 2 operands")
        self.in_regs = (False, True)
        self.out_regs = (True, False)
        self.out_operands = (True, False)
        self.avx_mode = True
        if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x89, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_zmmkz(self.operands[0]) and is_m512(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b10, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x89]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=8)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD, (op[0].zcode << 7) | op[0].kcode | 0x08, 0x89, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0xFD, (op[0].zcode << 7) | op[0].kcode | 0x28, 0x89, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_m128(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b00, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x89]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=8)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_m256(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b01, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x89]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=8)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: VPEXPANDQ " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPCOMPRESSD(Instruction):
    """Store Sparse Packed Doubleword Integer Values into Dense Memory/Register"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPCOMPRESSD(zmm{k}{z}, zmm)     [AVX512F]
            * VPCOMPRESSD(m512{k}{z}, zmm)    [AVX512F]
            * VPCOMPRESSD(xmm{k}{z}, xmm)     [AVX512F and AVX512VL]
            * VPCOMPRESSD(m128{k}{z}, xmm)    [AVX512F and AVX512VL]
            * VPCOMPRESSD(ymm{k}{z}, ymm)     [AVX512F and AVX512VL]
            * VPCOMPRESSD(m256{k}{z}, ymm)    [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPCOMPRESSD, self).__init__("VPCOMPRESSD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VPCOMPRESSD\" requires 2 operands")
        self.out_operands = (True, False)
        self.avx_mode = True
        if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[1].hcode << 7) | (op[0].ehcode << 5) | (op[1].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x8B, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_m512kz(self.operands[0]) and is_zmm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b10, op[1].ehcode, op[0].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x8B]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=4)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[1].hcode << 7) | (op[0].ehcode << 5) | (op[1].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x08, 0x8B, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_m128kz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b00, op[1].ehcode, op[0].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x8B]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=4)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[1].hcode << 7) | (op[0].ehcode << 5) | (op[1].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x28, 0x8B, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_m256kz(self.operands[0]) and is_evex_ymm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b01, op[1].ehcode, op[0].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x8B]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=4)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: VPCOMPRESSD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPCOMPRESSQ(Instruction):
    """Store Sparse Packed Quadword Integer Values into Dense Memory/Register"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPCOMPRESSQ(zmm{k}{z}, zmm)     [AVX512F]
            * VPCOMPRESSQ(m512{k}{z}, zmm)    [AVX512F]
            * VPCOMPRESSQ(xmm{k}{z}, xmm)     [AVX512F and AVX512VL]
            * VPCOMPRESSQ(m128{k}{z}, xmm)    [AVX512F and AVX512VL]
            * VPCOMPRESSQ(ymm{k}{z}, ymm)     [AVX512F and AVX512VL]
            * VPCOMPRESSQ(m256{k}{z}, ymm)    [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPCOMPRESSQ, self).__init__("VPCOMPRESSQ", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VPCOMPRESSQ\" requires 2 operands")
        self.out_operands = (True, False)
        self.avx_mode = True
        if is_zmmkz(self.operands[0]) and is_zmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[1].hcode << 7) | (op[0].ehcode << 5) | (op[1].ecode << 4)) ^ 242, 0xFD, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x8B, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_m512kz(self.operands[0]) and is_zmm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b10, op[1].ehcode, op[0].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x8B]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=8)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[1].hcode << 7) | (op[0].ehcode << 5) | (op[1].ecode << 4)) ^ 242, 0xFD, (op[0].zcode << 7) | op[0].kcode | 0x08, 0x8B, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_m128kz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b00, op[1].ehcode, op[0].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x8B]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=8)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_evex_ymm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[1].hcode << 7) | (op[0].ehcode << 5) | (op[1].ecode << 4)) ^ 242, 0xFD, (op[0].zcode << 7) | op[0].kcode | 0x28, 0x8B, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_m256kz(self.operands[0]) and is_evex_ymm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x85, 0b01, op[1].ehcode, op[0].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x8B]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=8)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: VPCOMPRESSQ " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPMASKMOVD(Instruction):
    """Conditional Move Packed Doubleword Integers"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPMASKMOVD(xmm, xmm, m128)    [AVX2]
            * VPMASKMOVD(ymm, ymm, m256)    [AVX2]
            * VPMASKMOVD(m128, xmm, xmm)    [AVX2]
            * VPMASKMOVD(m256, ymm, ymm)    [AVX2]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPMASKMOVD, self).__init__("VPMASKMOVD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"VPMASKMOVD\" requires 3 operands")
        self.out_operands = (True, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.avx2])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x01, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x8C]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
            self.in_regs = (False, True, True)
            self.out_regs = (True, False, False)
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x05, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x8C]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
            self.in_regs = (False, True, True)
            self.out_regs = (True, False, False)
        elif is_m128(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x01, op[2].hcode, op[0].address, op[1].hlcode) + bytearray([0x8E]) + modrm_sib_disp(op[2].lcode, op[0].address, sib, min_disp)))
            self.in_regs = (True, True, True)
            self.out_regs = (False, False, False)
        elif is_m256(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x05, op[2].hcode, op[0].address, op[1].hlcode) + bytearray([0x8E]) + modrm_sib_disp(op[2].lcode, op[0].address, sib, min_disp)))
            self.in_regs = (True, True, True)
            self.out_regs = (False, False, False)
        else:
            raise SyntaxError("Invalid operand types: VPMASKMOVD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPMASKMOVQ(Instruction):
    """Conditional Move Packed Quadword Integers"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPMASKMOVQ(xmm, xmm, m128)    [AVX2]
            * VPMASKMOVQ(ymm, ymm, m256)    [AVX2]
            * VPMASKMOVQ(m128, xmm, xmm)    [AVX2]
            * VPMASKMOVQ(m256, ymm, ymm)    [AVX2]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPMASKMOVQ, self).__init__("VPMASKMOVQ", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"VPMASKMOVQ\" requires 3 operands")
        self.out_operands = (True, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.avx2])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x81, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x8C]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
            self.in_regs = (False, True, True)
            self.out_regs = (True, False, False)
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x85, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x8C]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
            self.in_regs = (False, True, True)
            self.out_regs = (True, False, False)
        elif is_m128(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x81, op[2].hcode, op[0].address, op[1].hlcode) + bytearray([0x8E]) + modrm_sib_disp(op[2].lcode, op[0].address, sib, min_disp)))
            self.in_regs = (True, True, True)
            self.out_regs = (False, False, False)
        elif is_m256(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x85, op[2].hcode, op[0].address, op[1].hlcode) + bytearray([0x8E]) + modrm_sib_disp(op[2].lcode, op[0].address, sib, min_disp)))
            self.in_regs = (True, True, True)
            self.out_regs = (False, False, False)
        else:
            raise SyntaxError("Invalid operand types: VPMASKMOVQ " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VMASKMOVDQU(Instruction):
    """Store Selected Bytes of Double Quadword"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VMASKMOVDQU(xmm, xmm)    [AVX]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VMASKMOVDQU, self).__init__("VMASKMOVDQU", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VMASKMOVDQU\" requires 2 operands")
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x40, lambda op, vex3=False: vex2(1, op[0].hcode, op[1], 0, vex3) + bytearray([0xF7, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self._implicit_in_regs = {7: 15}
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.out_operands = (False, False)
            self.avx_mode = True
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        else:
            raise SyntaxError("Invalid operand types: VMASKMOVDQU " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VMOVNTDQ(Instruction):
    """Store Double Quadword Using Non-Temporal Hint"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VMOVNTDQ(m128, xmm)    [AVX]
            * VMOVNTDQ(m256, ymm)    [AVX]
            * VMOVNTDQ(m512, zmm)    [AVX512F]
            * VMOVNTDQ(m128, xmm)    [AVX512F and AVX512VL]
            * VMOVNTDQ(m256, ymm)    [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VMOVNTDQ, self).__init__("VMOVNTDQ", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VMOVNTDQ\" requires 2 operands")
        self.in_regs = (True, True)
        self.out_regs = (False, False)
        self.out_operands = (True, False)
        self.avx_mode = True
        if is_m128(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(1, op[1].hcode, op[0].address, 0, vex3) + bytearray([0xE7]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_m256(self.operands[0]) and is_ymm(self.operands[1]):
            self.encodings.append((0x50, lambda op, vex3=False, sib=False, min_disp=0: vex2(5, op[1].hcode, op[0].address, 0, vex3) + bytearray([0xE7]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_m512(self.operands[0]) and is_zmm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x05, 0b10, op[1].ehcode, op[0].address) + bytearray([0xE7]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=64)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_m128(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x05, 0b00, op[1].ehcode, op[0].address) + bytearray([0xE7]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=16)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_m256(self.operands[0]) and is_evex_ymm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b01, 0x05, 0b01, op[1].ehcode, op[0].address) + bytearray([0xE7]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=32)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: VMOVNTDQ " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VMOVNTDQA(Instruction):
    """Load Double Quadword Non-Temporal Aligned Hint"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VMOVNTDQA(xmm, m128)    [AVX]
            * VMOVNTDQA(ymm, m256)    [AVX2]
            * VMOVNTDQA(zmm, m512)    [AVX512F]
            * VMOVNTDQA(xmm, m128)    [AVX512F and AVX512VL]
            * VMOVNTDQA(ymm, m256)    [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VMOVNTDQA, self).__init__("VMOVNTDQA", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VMOVNTDQA\" requires 2 operands")
        self.in_regs = (False, True)
        self.out_regs = (True, False)
        self.out_operands = (True, False)
        self.avx_mode = True
        if is_xmm(self.operands[0]) and is_m128(self.operands[1]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x01, op[0].hcode, op[1].address) + bytearray([0x2A]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_ymm(self.operands[0]) and is_m256(self.operands[1]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x05, op[0].hcode, op[1].address) + bytearray([0x2A]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx2])
        elif is_zmm(self.operands[0]) and is_m512(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b10, op[0].ehcode, op[1].address) + bytearray([0x2A]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=64)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_evex_xmm(self.operands[0]) and is_m128(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b00, op[0].ehcode, op[1].address) + bytearray([0x2A]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=16)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_evex_ymm(self.operands[0]) and is_m256(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b01, op[0].ehcode, op[1].address) + bytearray([0x2A]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=32)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: VMOVNTDQA " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPMOVSXBW(Instruction):
    """Move Packed Byte Integers to Word Integers with Sign Extension"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPMOVSXBW(xmm, xmm/m64)           [AVX]
            * VPMOVSXBW(ymm, xmm/m128)          [AVX2]
            * VPMOVSXBW(zmm{k}{z}, ymm/m256)    [AVX512BW]
            * VPMOVSXBW(xmm{k}{z}, xmm/m64)     [AVX512BW and AVX512VL]
            * VPMOVSXBW(ymm{k}{z}, xmm/m128)    [AVX512BW and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPMOVSXBW, self).__init__("VPMOVSXBW", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VPMOVSXBW\" requires 2 operands")
        self.in_regs = (False, True)
        self.out_regs = (True, False)
        self.out_operands = (True, False)
        self.avx_mode = True
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x79, 0x20, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_xmm(self.operands[0]) and is_m64(self.operands[1]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x01, op[0].hcode, op[1].address) + bytearray([0x20]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_ymm(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x7D, 0x20, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx2])
        elif is_ymm(self.operands[0]) and is_m128(self.operands[1]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x05, op[0].hcode, op[1].address) + bytearray([0x20]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx2])
        elif is_zmmkz(self.operands[0]) and is_evex_ymm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x20, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512bw])
        elif is_zmmkz(self.operands[0]) and is_m256(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b10, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x20]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=32)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512bw])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x08, 0x20, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512bw])
        elif is_ymmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x28, 0x20, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512bw])
        elif is_xmmkz(self.operands[0]) and is_m64(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b00, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x20]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=8)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512bw])
        elif is_ymmkz(self.operands[0]) and is_m128(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b01, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x20]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=16)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512bw])
        else:
            raise SyntaxError("Invalid operand types: VPMOVSXBW " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPMOVSXBD(Instruction):
    """Move Packed Byte Integers to Doubleword Integers with Sign Extension"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPMOVSXBD(xmm, xmm/m32)           [AVX]
            * VPMOVSXBD(ymm, xmm/m64)           [AVX2]
            * VPMOVSXBD(zmm{k}{z}, xmm/m128)    [AVX512F]
            * VPMOVSXBD(xmm{k}{z}, xmm/m32)     [AVX512F and AVX512VL]
            * VPMOVSXBD(ymm{k}{z}, xmm/m64)     [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPMOVSXBD, self).__init__("VPMOVSXBD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VPMOVSXBD\" requires 2 operands")
        self.in_regs = (False, True)
        self.out_regs = (True, False)
        self.out_operands = (True, False)
        self.avx_mode = True
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x79, 0x21, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_xmm(self.operands[0]) and is_m32(self.operands[1]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x01, op[0].hcode, op[1].address) + bytearray([0x21]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_ymm(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x7D, 0x21, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx2])
        elif is_ymm(self.operands[0]) and is_m64(self.operands[1]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x05, op[0].hcode, op[1].address) + bytearray([0x21]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx2])
        elif is_zmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x21, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_zmmkz(self.operands[0]) and is_m128(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b10, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x21]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=16)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x08, 0x21, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x28, 0x21, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_m32(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b00, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x21]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=4)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_m64(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b01, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x21]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=8)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: VPMOVSXBD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPMOVSXBQ(Instruction):
    """Move Packed Byte Integers to Quadword Integers with Sign Extension"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPMOVSXBQ(xmm, xmm/m16)          [AVX]
            * VPMOVSXBQ(ymm, xmm/m32)          [AVX2]
            * VPMOVSXBQ(zmm{k}{z}, xmm/m64)    [AVX512F]
            * VPMOVSXBQ(xmm{k}{z}, xmm/m16)    [AVX512F and AVX512VL]
            * VPMOVSXBQ(ymm{k}{z}, xmm/m32)    [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPMOVSXBQ, self).__init__("VPMOVSXBQ", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VPMOVSXBQ\" requires 2 operands")
        self.in_regs = (False, True)
        self.out_regs = (True, False)
        self.out_operands = (True, False)
        self.avx_mode = True
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x79, 0x22, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_xmm(self.operands[0]) and is_m16(self.operands[1]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x01, op[0].hcode, op[1].address) + bytearray([0x22]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_ymm(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x7D, 0x22, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx2])
        elif is_ymm(self.operands[0]) and is_m32(self.operands[1]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x05, op[0].hcode, op[1].address) + bytearray([0x22]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx2])
        elif is_zmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x22, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_zmmkz(self.operands[0]) and is_m64(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b10, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x22]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=8)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x08, 0x22, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x28, 0x22, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_m16(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b00, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x22]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=2)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_m32(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b01, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x22]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=4)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: VPMOVSXBQ " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPMOVSXWD(Instruction):
    """Move Packed Word Integers to Doubleword Integers with Sign Extension"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPMOVSXWD(xmm, xmm/m64)           [AVX]
            * VPMOVSXWD(ymm, xmm/m128)          [AVX2]
            * VPMOVSXWD(zmm{k}{z}, ymm/m256)    [AVX512F]
            * VPMOVSXWD(xmm{k}{z}, xmm/m64)     [AVX512F and AVX512VL]
            * VPMOVSXWD(ymm{k}{z}, xmm/m128)    [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPMOVSXWD, self).__init__("VPMOVSXWD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VPMOVSXWD\" requires 2 operands")
        self.in_regs = (False, True)
        self.out_regs = (True, False)
        self.out_operands = (True, False)
        self.avx_mode = True
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x79, 0x23, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_xmm(self.operands[0]) and is_m64(self.operands[1]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x01, op[0].hcode, op[1].address) + bytearray([0x23]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_ymm(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x7D, 0x23, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx2])
        elif is_ymm(self.operands[0]) and is_m128(self.operands[1]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x05, op[0].hcode, op[1].address) + bytearray([0x23]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx2])
        elif is_zmmkz(self.operands[0]) and is_evex_ymm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x23, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_zmmkz(self.operands[0]) and is_m256(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b10, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x23]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=32)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x08, 0x23, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x28, 0x23, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_m64(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b00, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x23]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=8)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_m128(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b01, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x23]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=16)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: VPMOVSXWD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPMOVSXWQ(Instruction):
    """Move Packed Word Integers to Quadword Integers with Sign Extension"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPMOVSXWQ(xmm, xmm/m32)           [AVX]
            * VPMOVSXWQ(ymm, xmm/m64)           [AVX2]
            * VPMOVSXWQ(zmm{k}{z}, xmm/m128)    [AVX512F]
            * VPMOVSXWQ(xmm{k}{z}, xmm/m32)     [AVX512F and AVX512VL]
            * VPMOVSXWQ(ymm{k}{z}, xmm/m64)     [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPMOVSXWQ, self).__init__("VPMOVSXWQ", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VPMOVSXWQ\" requires 2 operands")
        self.in_regs = (False, True)
        self.out_regs = (True, False)
        self.out_operands = (True, False)
        self.avx_mode = True
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x79, 0x24, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_xmm(self.operands[0]) and is_m32(self.operands[1]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x01, op[0].hcode, op[1].address) + bytearray([0x24]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_ymm(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x7D, 0x24, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx2])
        elif is_ymm(self.operands[0]) and is_m64(self.operands[1]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x05, op[0].hcode, op[1].address) + bytearray([0x24]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx2])
        elif is_zmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x24, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_zmmkz(self.operands[0]) and is_m128(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b10, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x24]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=16)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x08, 0x24, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x28, 0x24, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_m32(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b00, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x24]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=4)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_m64(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b01, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x24]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=8)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: VPMOVSXWQ " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPMOVSXDQ(Instruction):
    """Move Packed Doubleword Integers to Quadword Integers with Sign Extension"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPMOVSXDQ(xmm, xmm/m64)           [AVX]
            * VPMOVSXDQ(ymm, xmm/m128)          [AVX2]
            * VPMOVSXDQ(zmm{k}{z}, ymm/m256)    [AVX512F]
            * VPMOVSXDQ(xmm{k}{z}, xmm/m64)     [AVX512F and AVX512VL]
            * VPMOVSXDQ(ymm{k}{z}, xmm/m128)    [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPMOVSXDQ, self).__init__("VPMOVSXDQ", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VPMOVSXDQ\" requires 2 operands")
        self.in_regs = (False, True)
        self.out_regs = (True, False)
        self.out_operands = (True, False)
        self.avx_mode = True
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x79, 0x25, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_xmm(self.operands[0]) and is_m64(self.operands[1]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x01, op[0].hcode, op[1].address) + bytearray([0x25]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_ymm(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x7D, 0x25, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx2])
        elif is_ymm(self.operands[0]) and is_m128(self.operands[1]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x05, op[0].hcode, op[1].address) + bytearray([0x25]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx2])
        elif is_zmmkz(self.operands[0]) and is_evex_ymm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x25, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_zmmkz(self.operands[0]) and is_m256(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b10, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x25]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=32)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x08, 0x25, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x28, 0x25, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_m64(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b00, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x25]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=8)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_m128(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b01, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x25]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=16)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: VPMOVSXDQ " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPMOVZXBW(Instruction):
    """Move Packed Byte Integers to Word Integers with Zero Extension"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPMOVZXBW(xmm, xmm/m64)           [AVX]
            * VPMOVZXBW(ymm, xmm/m128)          [AVX2]
            * VPMOVZXBW(zmm{k}{z}, ymm/m256)    [AVX512BW]
            * VPMOVZXBW(xmm{k}{z}, xmm/m64)     [AVX512BW and AVX512VL]
            * VPMOVZXBW(ymm{k}{z}, xmm/m128)    [AVX512BW and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPMOVZXBW, self).__init__("VPMOVZXBW", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VPMOVZXBW\" requires 2 operands")
        self.in_regs = (False, True)
        self.out_regs = (True, False)
        self.out_operands = (True, False)
        self.avx_mode = True
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x79, 0x30, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_xmm(self.operands[0]) and is_m64(self.operands[1]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x01, op[0].hcode, op[1].address) + bytearray([0x30]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_ymm(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x7D, 0x30, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx2])
        elif is_ymm(self.operands[0]) and is_m128(self.operands[1]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x05, op[0].hcode, op[1].address) + bytearray([0x30]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx2])
        elif is_zmmkz(self.operands[0]) and is_evex_ymm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x30, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512bw])
        elif is_zmmkz(self.operands[0]) and is_m256(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b10, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x30]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=32)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512bw])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x08, 0x30, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512bw])
        elif is_ymmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x28, 0x30, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512bw])
        elif is_xmmkz(self.operands[0]) and is_m64(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b00, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x30]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=8)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512bw])
        elif is_ymmkz(self.operands[0]) and is_m128(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b01, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x30]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=16)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512bw])
        else:
            raise SyntaxError("Invalid operand types: VPMOVZXBW " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPMOVZXBD(Instruction):
    """Move Packed Byte Integers to Doubleword Integers with Zero Extension"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPMOVZXBD(xmm, xmm/m32)           [AVX]
            * VPMOVZXBD(ymm, xmm/m64)           [AVX2]
            * VPMOVZXBD(zmm{k}{z}, xmm/m128)    [AVX512F]
            * VPMOVZXBD(xmm{k}{z}, xmm/m32)     [AVX512F and AVX512VL]
            * VPMOVZXBD(ymm{k}{z}, xmm/m64)     [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPMOVZXBD, self).__init__("VPMOVZXBD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VPMOVZXBD\" requires 2 operands")
        self.in_regs = (False, True)
        self.out_regs = (True, False)
        self.out_operands = (True, False)
        self.avx_mode = True
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x79, 0x31, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_xmm(self.operands[0]) and is_m32(self.operands[1]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x01, op[0].hcode, op[1].address) + bytearray([0x31]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_ymm(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x7D, 0x31, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx2])
        elif is_ymm(self.operands[0]) and is_m64(self.operands[1]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x05, op[0].hcode, op[1].address) + bytearray([0x31]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx2])
        elif is_zmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x31, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_zmmkz(self.operands[0]) and is_m128(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b10, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x31]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=16)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x08, 0x31, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x28, 0x31, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_m32(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b00, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x31]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=4)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_m64(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b01, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x31]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=8)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: VPMOVZXBD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPMOVZXBQ(Instruction):
    """Move Packed Byte Integers to Quadword Integers with Zero Extension"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPMOVZXBQ(xmm, xmm/m16)          [AVX]
            * VPMOVZXBQ(ymm, xmm/m32)          [AVX2]
            * VPMOVZXBQ(zmm{k}{z}, xmm/m64)    [AVX512F]
            * VPMOVZXBQ(xmm{k}{z}, xmm/m16)    [AVX512F and AVX512VL]
            * VPMOVZXBQ(ymm{k}{z}, xmm/m32)    [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPMOVZXBQ, self).__init__("VPMOVZXBQ", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VPMOVZXBQ\" requires 2 operands")
        self.in_regs = (False, True)
        self.out_regs = (True, False)
        self.out_operands = (True, False)
        self.avx_mode = True
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x79, 0x32, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_xmm(self.operands[0]) and is_m16(self.operands[1]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x01, op[0].hcode, op[1].address) + bytearray([0x32]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_ymm(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x7D, 0x32, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx2])
        elif is_ymm(self.operands[0]) and is_m32(self.operands[1]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x05, op[0].hcode, op[1].address) + bytearray([0x32]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx2])
        elif is_zmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x32, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_zmmkz(self.operands[0]) and is_m64(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b10, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x32]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=8)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x08, 0x32, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x28, 0x32, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_m16(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b00, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x32]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=2)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_m32(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b01, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x32]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=4)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: VPMOVZXBQ " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPMOVZXWD(Instruction):
    """Move Packed Word Integers to Doubleword Integers with Zero Extension"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPMOVZXWD(xmm, xmm/m64)           [AVX]
            * VPMOVZXWD(ymm, xmm/m128)          [AVX2]
            * VPMOVZXWD(zmm{k}{z}, ymm/m256)    [AVX512F]
            * VPMOVZXWD(xmm{k}{z}, xmm/m64)     [AVX512F and AVX512VL]
            * VPMOVZXWD(ymm{k}{z}, xmm/m128)    [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPMOVZXWD, self).__init__("VPMOVZXWD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VPMOVZXWD\" requires 2 operands")
        self.in_regs = (False, True)
        self.out_regs = (True, False)
        self.out_operands = (True, False)
        self.avx_mode = True
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x79, 0x33, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_xmm(self.operands[0]) and is_m64(self.operands[1]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x01, op[0].hcode, op[1].address) + bytearray([0x33]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_ymm(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x7D, 0x33, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx2])
        elif is_ymm(self.operands[0]) and is_m128(self.operands[1]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x05, op[0].hcode, op[1].address) + bytearray([0x33]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx2])
        elif is_zmmkz(self.operands[0]) and is_evex_ymm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x33, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_zmmkz(self.operands[0]) and is_m256(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b10, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x33]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=32)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x08, 0x33, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x28, 0x33, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_m64(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b00, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x33]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=8)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_m128(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b01, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x33]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=16)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: VPMOVZXWD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPMOVZXWQ(Instruction):
    """Move Packed Word Integers to Quadword Integers with Zero Extension"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPMOVZXWQ(xmm, xmm/m32)           [AVX]
            * VPMOVZXWQ(ymm, xmm/m64)           [AVX2]
            * VPMOVZXWQ(zmm{k}{z}, xmm/m128)    [AVX512F]
            * VPMOVZXWQ(xmm{k}{z}, xmm/m32)     [AVX512F and AVX512VL]
            * VPMOVZXWQ(ymm{k}{z}, xmm/m64)     [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPMOVZXWQ, self).__init__("VPMOVZXWQ", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VPMOVZXWQ\" requires 2 operands")
        self.in_regs = (False, True)
        self.out_regs = (True, False)
        self.out_operands = (True, False)
        self.avx_mode = True
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x79, 0x34, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_xmm(self.operands[0]) and is_m32(self.operands[1]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x01, op[0].hcode, op[1].address) + bytearray([0x34]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_ymm(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x7D, 0x34, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx2])
        elif is_ymm(self.operands[0]) and is_m64(self.operands[1]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x05, op[0].hcode, op[1].address) + bytearray([0x34]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx2])
        elif is_zmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x34, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_zmmkz(self.operands[0]) and is_m128(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b10, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x34]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=16)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x08, 0x34, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x28, 0x34, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_m32(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b00, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x34]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=4)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_m64(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b01, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x34]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=8)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: VPMOVZXWQ " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPMOVZXDQ(Instruction):
    """Move Packed Doubleword Integers to Quadword Integers with Zero Extension"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPMOVZXDQ(xmm, xmm/m64)           [AVX]
            * VPMOVZXDQ(ymm, xmm/m128)          [AVX2]
            * VPMOVZXDQ(zmm{k}{z}, ymm/m256)    [AVX512F]
            * VPMOVZXDQ(xmm{k}{z}, xmm/m64)     [AVX512F and AVX512VL]
            * VPMOVZXDQ(ymm{k}{z}, xmm/m128)    [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPMOVZXDQ, self).__init__("VPMOVZXDQ", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VPMOVZXDQ\" requires 2 operands")
        self.in_regs = (False, True)
        self.out_regs = (True, False)
        self.out_operands = (True, False)
        self.avx_mode = True
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x79, 0x35, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_xmm(self.operands[0]) and is_m64(self.operands[1]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x01, op[0].hcode, op[1].address) + bytearray([0x35]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx])
        elif is_ymm(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE2 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x7D, 0x35, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx2])
        elif is_ymm(self.operands[0]) and is_m128(self.operands[1]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b10, 0x05, op[0].hcode, op[1].address) + bytearray([0x35]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx2])
        elif is_zmmkz(self.operands[0]) and is_evex_ymm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x35, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_zmmkz(self.operands[0]) and is_m256(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b10, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x35]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=32)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x08, 0x35, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[0].hcode << 7) | (op[1].ehcode << 5) | (op[0].ecode << 4)) ^ 242, 0x7D, (op[0].zcode << 7) | op[0].kcode | 0x28, 0x35, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_m64(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b00, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x35]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=8)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_ymmkz(self.operands[0]) and is_m128(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x05, 0b01, op[0].ehcode, op[1].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x35]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp, disp8xN=16)))
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: VPMOVZXDQ " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPMOVWB(Instruction):
    """Down Convert Packed Word Values to Byte Values with Truncation"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPMOVWB(ymm{k}{z}, zmm)     [AVX512BW]
            * VPMOVWB(m256{k}{z}, zmm)    [AVX512BW]
            * VPMOVWB(xmm{k}{z}, xmm)     [AVX512BW and AVX512VL]
            * VPMOVWB(m64{k}{z}, xmm)     [AVX512BW and AVX512VL]
            * VPMOVWB(xmm{k}{z}, ymm)     [AVX512BW and AVX512VL]
            * VPMOVWB(m128{k}{z}, ymm)    [AVX512BW and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPMOVWB, self).__init__("VPMOVWB", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VPMOVWB\" requires 2 operands")
        self.out_operands = (True, False)
        self.avx_mode = True
        if is_ymmkz(self.operands[0]) and is_zmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[1].hcode << 7) | (op[0].ehcode << 5) | (op[1].ecode << 4)) ^ 242, 0x7E, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x30, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512bw])
        elif is_m256kz(self.operands[0]) and is_zmm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x06, 0b10, op[1].ehcode, op[0].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x30]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=32)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512bw])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[1].hcode << 7) | (op[0].ehcode << 5) | (op[1].ecode << 4)) ^ 242, 0x7E, (op[0].zcode << 7) | op[0].kcode | 0x08, 0x30, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512bw])
        elif is_m64kz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x06, 0b00, op[1].ehcode, op[0].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x30]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=8)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512bw])
        elif is_xmmkz(self.operands[0]) and is_evex_ymm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[1].hcode << 7) | (op[0].ehcode << 5) | (op[1].ecode << 4)) ^ 242, 0x7E, (op[0].zcode << 7) | op[0].kcode | 0x28, 0x30, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512bw])
        elif is_m128kz(self.operands[0]) and is_evex_ymm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x06, 0b01, op[1].ehcode, op[0].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x30]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=16)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512bw])
        else:
            raise SyntaxError("Invalid operand types: VPMOVWB " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPMOVDB(Instruction):
    """Down Convert Packed Doubleword Values to Byte Values with Truncation"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPMOVDB(xmm{k}{z}, zmm)     [AVX512F]
            * VPMOVDB(m128{k}{z}, zmm)    [AVX512F]
            * VPMOVDB(xmm{k}{z}, xmm)     [AVX512F and AVX512VL]
            * VPMOVDB(m32{k}{z}, xmm)     [AVX512F and AVX512VL]
            * VPMOVDB(xmm{k}{z}, ymm)     [AVX512F and AVX512VL]
            * VPMOVDB(m64{k}{z}, ymm)     [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPMOVDB, self).__init__("VPMOVDB", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VPMOVDB\" requires 2 operands")
        self.out_operands = (True, False)
        self.avx_mode = True
        if is_xmmkz(self.operands[0]) and is_zmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[1].hcode << 7) | (op[0].ehcode << 5) | (op[1].ecode << 4)) ^ 242, 0x7E, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x31, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_m128kz(self.operands[0]) and is_zmm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x06, 0b10, op[1].ehcode, op[0].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x31]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=16)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[1].hcode << 7) | (op[0].ehcode << 5) | (op[1].ecode << 4)) ^ 242, 0x7E, (op[0].zcode << 7) | op[0].kcode | 0x08, 0x31, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_m32kz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x06, 0b00, op[1].ehcode, op[0].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x31]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=4)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_ymm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[1].hcode << 7) | (op[0].ehcode << 5) | (op[1].ecode << 4)) ^ 242, 0x7E, (op[0].zcode << 7) | op[0].kcode | 0x28, 0x31, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_m64kz(self.operands[0]) and is_evex_ymm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x06, 0b01, op[1].ehcode, op[0].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x31]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=8)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: VPMOVDB " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPMOVDW(Instruction):
    """Down Convert Packed Doubleword Values to Word Values with Truncation"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPMOVDW(ymm{k}{z}, zmm)     [AVX512F]
            * VPMOVDW(m256{k}{z}, zmm)    [AVX512F]
            * VPMOVDW(xmm{k}{z}, xmm)     [AVX512F and AVX512VL]
            * VPMOVDW(m64{k}{z}, xmm)     [AVX512F and AVX512VL]
            * VPMOVDW(xmm{k}{z}, ymm)     [AVX512F and AVX512VL]
            * VPMOVDW(m128{k}{z}, ymm)    [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPMOVDW, self).__init__("VPMOVDW", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VPMOVDW\" requires 2 operands")
        self.out_operands = (True, False)
        self.avx_mode = True
        if is_ymmkz(self.operands[0]) and is_zmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[1].hcode << 7) | (op[0].ehcode << 5) | (op[1].ecode << 4)) ^ 242, 0x7E, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x33, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_m256kz(self.operands[0]) and is_zmm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x06, 0b10, op[1].ehcode, op[0].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x33]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=32)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[1].hcode << 7) | (op[0].ehcode << 5) | (op[1].ecode << 4)) ^ 242, 0x7E, (op[0].zcode << 7) | op[0].kcode | 0x08, 0x33, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_m64kz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x06, 0b00, op[1].ehcode, op[0].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x33]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=8)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_ymm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[1].hcode << 7) | (op[0].ehcode << 5) | (op[1].ecode << 4)) ^ 242, 0x7E, (op[0].zcode << 7) | op[0].kcode | 0x28, 0x33, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_m128kz(self.operands[0]) and is_evex_ymm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x06, 0b01, op[1].ehcode, op[0].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x33]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=16)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: VPMOVDW " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPMOVQB(Instruction):
    """Down Convert Packed Quadword Values to Byte Values with Truncation"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPMOVQB(xmm{k}{z}, zmm)    [AVX512F]
            * VPMOVQB(m64{k}{z}, zmm)    [AVX512F]
            * VPMOVQB(xmm{k}{z}, xmm)    [AVX512F and AVX512VL]
            * VPMOVQB(m16{k}{z}, xmm)    [AVX512F and AVX512VL]
            * VPMOVQB(xmm{k}{z}, ymm)    [AVX512F and AVX512VL]
            * VPMOVQB(m32{k}{z}, ymm)    [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPMOVQB, self).__init__("VPMOVQB", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VPMOVQB\" requires 2 operands")
        self.out_operands = (True, False)
        self.avx_mode = True
        if is_xmmkz(self.operands[0]) and is_zmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[1].hcode << 7) | (op[0].ehcode << 5) | (op[1].ecode << 4)) ^ 242, 0x7E, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x32, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_m64kz(self.operands[0]) and is_zmm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x06, 0b10, op[1].ehcode, op[0].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x32]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=8)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[1].hcode << 7) | (op[0].ehcode << 5) | (op[1].ecode << 4)) ^ 242, 0x7E, (op[0].zcode << 7) | op[0].kcode | 0x08, 0x32, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_m16kz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x06, 0b00, op[1].ehcode, op[0].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x32]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=2)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_ymm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[1].hcode << 7) | (op[0].ehcode << 5) | (op[1].ecode << 4)) ^ 242, 0x7E, (op[0].zcode << 7) | op[0].kcode | 0x28, 0x32, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_m32kz(self.operands[0]) and is_evex_ymm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x06, 0b01, op[1].ehcode, op[0].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x32]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=4)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: VPMOVQB " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPMOVQW(Instruction):
    """Down Convert Packed Quadword Values to Word Values with Truncation"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPMOVQW(xmm{k}{z}, zmm)     [AVX512F]
            * VPMOVQW(m128{k}{z}, zmm)    [AVX512F]
            * VPMOVQW(xmm{k}{z}, xmm)     [AVX512F and AVX512VL]
            * VPMOVQW(m32{k}{z}, xmm)     [AVX512F and AVX512VL]
            * VPMOVQW(xmm{k}{z}, ymm)     [AVX512F and AVX512VL]
            * VPMOVQW(m64{k}{z}, ymm)     [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPMOVQW, self).__init__("VPMOVQW", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VPMOVQW\" requires 2 operands")
        self.out_operands = (True, False)
        self.avx_mode = True
        if is_xmmkz(self.operands[0]) and is_zmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[1].hcode << 7) | (op[0].ehcode << 5) | (op[1].ecode << 4)) ^ 242, 0x7E, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x34, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_m128kz(self.operands[0]) and is_zmm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x06, 0b10, op[1].ehcode, op[0].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x34]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=16)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[1].hcode << 7) | (op[0].ehcode << 5) | (op[1].ecode << 4)) ^ 242, 0x7E, (op[0].zcode << 7) | op[0].kcode | 0x08, 0x34, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_m32kz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x06, 0b00, op[1].ehcode, op[0].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x34]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=4)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_ymm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[1].hcode << 7) | (op[0].ehcode << 5) | (op[1].ecode << 4)) ^ 242, 0x7E, (op[0].zcode << 7) | op[0].kcode | 0x28, 0x34, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_m64kz(self.operands[0]) and is_evex_ymm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x06, 0b01, op[1].ehcode, op[0].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x34]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=8)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: VPMOVQW " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPMOVQD(Instruction):
    """Down Convert Packed Quadword Values to Doubleword Values with Truncation"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPMOVQD(ymm{k}{z}, zmm)     [AVX512F]
            * VPMOVQD(m256{k}{z}, zmm)    [AVX512F]
            * VPMOVQD(xmm{k}{z}, xmm)     [AVX512F and AVX512VL]
            * VPMOVQD(m64{k}{z}, xmm)     [AVX512F and AVX512VL]
            * VPMOVQD(xmm{k}{z}, ymm)     [AVX512F and AVX512VL]
            * VPMOVQD(m128{k}{z}, ymm)    [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPMOVQD, self).__init__("VPMOVQD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VPMOVQD\" requires 2 operands")
        self.out_operands = (True, False)
        self.avx_mode = True
        if is_ymmkz(self.operands[0]) and is_zmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[1].hcode << 7) | (op[0].ehcode << 5) | (op[1].ecode << 4)) ^ 242, 0x7E, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x35, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_m256kz(self.operands[0]) and is_zmm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x06, 0b10, op[1].ehcode, op[0].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x35]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=32)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[1].hcode << 7) | (op[0].ehcode << 5) | (op[1].ecode << 4)) ^ 242, 0x7E, (op[0].zcode << 7) | op[0].kcode | 0x08, 0x35, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_m64kz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x06, 0b00, op[1].ehcode, op[0].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x35]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=8)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_ymm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[1].hcode << 7) | (op[0].ehcode << 5) | (op[1].ecode << 4)) ^ 242, 0x7E, (op[0].zcode << 7) | op[0].kcode | 0x28, 0x35, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_m128kz(self.operands[0]) and is_evex_ymm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x06, 0b01, op[1].ehcode, op[0].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x35]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=16)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: VPMOVQD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPMOVSWB(Instruction):
    """Down Convert Packed Word Values to Byte Values with Signed Saturation"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPMOVSWB(ymm{k}{z}, zmm)     [AVX512BW]
            * VPMOVSWB(m256{k}{z}, zmm)    [AVX512BW]
            * VPMOVSWB(xmm{k}{z}, xmm)     [AVX512BW and AVX512VL]
            * VPMOVSWB(m64{k}{z}, xmm)     [AVX512BW and AVX512VL]
            * VPMOVSWB(xmm{k}{z}, ymm)     [AVX512BW and AVX512VL]
            * VPMOVSWB(m128{k}{z}, ymm)    [AVX512BW and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPMOVSWB, self).__init__("VPMOVSWB", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VPMOVSWB\" requires 2 operands")
        self.out_operands = (True, False)
        self.avx_mode = True
        if is_ymmkz(self.operands[0]) and is_zmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[1].hcode << 7) | (op[0].ehcode << 5) | (op[1].ecode << 4)) ^ 242, 0x7E, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x20, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512bw])
        elif is_m256kz(self.operands[0]) and is_zmm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x06, 0b10, op[1].ehcode, op[0].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x20]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=32)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512bw])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[1].hcode << 7) | (op[0].ehcode << 5) | (op[1].ecode << 4)) ^ 242, 0x7E, (op[0].zcode << 7) | op[0].kcode | 0x08, 0x20, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512bw])
        elif is_m64kz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x06, 0b00, op[1].ehcode, op[0].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x20]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=8)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512bw])
        elif is_xmmkz(self.operands[0]) and is_evex_ymm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[1].hcode << 7) | (op[0].ehcode << 5) | (op[1].ecode << 4)) ^ 242, 0x7E, (op[0].zcode << 7) | op[0].kcode | 0x28, 0x20, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512bw])
        elif is_m128kz(self.operands[0]) and is_evex_ymm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x06, 0b01, op[1].ehcode, op[0].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x20]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=16)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512bw])
        else:
            raise SyntaxError("Invalid operand types: VPMOVSWB " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPMOVSDB(Instruction):
    """Down Convert Packed Doubleword Values to Byte Values with Signed Saturation"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPMOVSDB(xmm{k}{z}, zmm)     [AVX512F]
            * VPMOVSDB(m128{k}{z}, zmm)    [AVX512F]
            * VPMOVSDB(xmm{k}{z}, xmm)     [AVX512F and AVX512VL]
            * VPMOVSDB(m32{k}{z}, xmm)     [AVX512F and AVX512VL]
            * VPMOVSDB(xmm{k}{z}, ymm)     [AVX512F and AVX512VL]
            * VPMOVSDB(m64{k}{z}, ymm)     [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPMOVSDB, self).__init__("VPMOVSDB", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VPMOVSDB\" requires 2 operands")
        self.out_operands = (True, False)
        self.avx_mode = True
        if is_xmmkz(self.operands[0]) and is_zmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[1].hcode << 7) | (op[0].ehcode << 5) | (op[1].ecode << 4)) ^ 242, 0x7E, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x21, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_m128kz(self.operands[0]) and is_zmm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x06, 0b10, op[1].ehcode, op[0].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x21]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=16)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[1].hcode << 7) | (op[0].ehcode << 5) | (op[1].ecode << 4)) ^ 242, 0x7E, (op[0].zcode << 7) | op[0].kcode | 0x08, 0x21, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_m32kz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x06, 0b00, op[1].ehcode, op[0].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x21]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=4)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_ymm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[1].hcode << 7) | (op[0].ehcode << 5) | (op[1].ecode << 4)) ^ 242, 0x7E, (op[0].zcode << 7) | op[0].kcode | 0x28, 0x21, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_m64kz(self.operands[0]) and is_evex_ymm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x06, 0b01, op[1].ehcode, op[0].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x21]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=8)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: VPMOVSDB " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPMOVSDW(Instruction):
    """Down Convert Packed Doubleword Values to Word Values with Signed Saturation"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPMOVSDW(ymm{k}{z}, zmm)     [AVX512F]
            * VPMOVSDW(m256{k}{z}, zmm)    [AVX512F]
            * VPMOVSDW(xmm{k}{z}, xmm)     [AVX512F and AVX512VL]
            * VPMOVSDW(m64{k}{z}, xmm)     [AVX512F and AVX512VL]
            * VPMOVSDW(xmm{k}{z}, ymm)     [AVX512F and AVX512VL]
            * VPMOVSDW(m128{k}{z}, ymm)    [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPMOVSDW, self).__init__("VPMOVSDW", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VPMOVSDW\" requires 2 operands")
        self.out_operands = (True, False)
        self.avx_mode = True
        if is_ymmkz(self.operands[0]) and is_zmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[1].hcode << 7) | (op[0].ehcode << 5) | (op[1].ecode << 4)) ^ 242, 0x7E, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x23, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_m256kz(self.operands[0]) and is_zmm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x06, 0b10, op[1].ehcode, op[0].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x23]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=32)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[1].hcode << 7) | (op[0].ehcode << 5) | (op[1].ecode << 4)) ^ 242, 0x7E, (op[0].zcode << 7) | op[0].kcode | 0x08, 0x23, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_m64kz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x06, 0b00, op[1].ehcode, op[0].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x23]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=8)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_ymm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[1].hcode << 7) | (op[0].ehcode << 5) | (op[1].ecode << 4)) ^ 242, 0x7E, (op[0].zcode << 7) | op[0].kcode | 0x28, 0x23, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_m128kz(self.operands[0]) and is_evex_ymm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x06, 0b01, op[1].ehcode, op[0].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x23]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=16)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: VPMOVSDW " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPMOVSQB(Instruction):
    """Down Convert Packed Quadword Values to Byte Values with Signed Saturation"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPMOVSQB(xmm{k}{z}, zmm)    [AVX512F]
            * VPMOVSQB(m64{k}{z}, zmm)    [AVX512F]
            * VPMOVSQB(xmm{k}{z}, xmm)    [AVX512F and AVX512VL]
            * VPMOVSQB(m16{k}{z}, xmm)    [AVX512F and AVX512VL]
            * VPMOVSQB(xmm{k}{z}, ymm)    [AVX512F and AVX512VL]
            * VPMOVSQB(m32{k}{z}, ymm)    [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPMOVSQB, self).__init__("VPMOVSQB", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VPMOVSQB\" requires 2 operands")
        self.out_operands = (True, False)
        self.avx_mode = True
        if is_xmmkz(self.operands[0]) and is_zmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[1].hcode << 7) | (op[0].ehcode << 5) | (op[1].ecode << 4)) ^ 242, 0x7E, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x22, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_m64kz(self.operands[0]) and is_zmm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x06, 0b10, op[1].ehcode, op[0].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x22]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=8)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[1].hcode << 7) | (op[0].ehcode << 5) | (op[1].ecode << 4)) ^ 242, 0x7E, (op[0].zcode << 7) | op[0].kcode | 0x08, 0x22, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_m16kz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x06, 0b00, op[1].ehcode, op[0].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x22]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=2)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_ymm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[1].hcode << 7) | (op[0].ehcode << 5) | (op[1].ecode << 4)) ^ 242, 0x7E, (op[0].zcode << 7) | op[0].kcode | 0x28, 0x22, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_m32kz(self.operands[0]) and is_evex_ymm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x06, 0b01, op[1].ehcode, op[0].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x22]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=4)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        else:
            raise SyntaxError("Invalid operand types: VPMOVSQB " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPMOVSQW(Instruction):
    """Down Convert Packed Quadword Values to Word Values with Signed Saturation"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPMOVSQW(xmm{k}{z}, zmm)     [AVX512F]
            * VPMOVSQW(m128{k}{z}, zmm)    [AVX512F]
            * VPMOVSQW(xmm{k}{z}, xmm)     [AVX512F and AVX512VL]
            * VPMOVSQW(m32{k}{z}, xmm)     [AVX512F and AVX512VL]
            * VPMOVSQW(xmm{k}{z}, ymm)     [AVX512F and AVX512VL]
            * VPMOVSQW(m64{k}{z}, ymm)     [AVX512F and AVX512VL]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPMOVSQW, self).__init__("VPMOVSQW", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VPMOVSQW\" requires 2 operands")
        self.out_operands = (True, False)
        self.avx_mode = True
        if is_xmmkz(self.operands[0]) and is_zmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[1].hcode << 7) | (op[0].ehcode << 5) | (op[1].ecode << 4)) ^ 242, 0x7E, (op[0].zcode << 7) | op[0].kcode | 0x48, 0x24, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_m128kz(self.operands[0]) and is_zmm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x06, 0b10, op[1].ehcode, op[0].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x24]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=16)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512f])
        elif is_xmmkz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x62, ((op[1].hcode << 7) | (op[0].ehcode << 5) | (op[1].ecode << 4)) ^ 242, 0x7E, (op[0].zcode << 7) | op[0].kcode | 0x08, 0x24, 0xC0 | op[1].lcode << 3 | op[0].lcode])))
            self.in_regs = (False, True)
            self.out_regs = (True, False)
            self.isa_extensions = frozenset([peachpy.x86_64.isa.avx512vl, peachpy.x86_64.isa.avx512f])
        elif is_m32kz(self.operands[0]) and is_evex_xmm(self.operands[1]):
            self.encodings.append((0x90, lambda op, sib=False, min_disp=0: evex(0b10, 0x06, 0b00, op[1].ehcode, op[0].address, aaa=op[0].kcode, z=op[0].zcode) + bytearray([0x24]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp, disp8xN=4)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            se