/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.time;

import org.jquantlib.Configuration;
import org.jquantlib.Settings;
import org.jquantlib.time.Weekday;
import org.jquantlib.util.Date;
import org.jquantlib.util.DateFactory;
import org.jquantlib.util.Month;

public class IMM {
    private static volatile IMM DEFAULT_IMM;
    private final Configuration configuration;
    private final Settings settings;

    public IMM(Configuration config, Settings settings) {
        this.configuration = config;
        this.settings = settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IMM getDefaultIMM() {
        if (DEFAULT_IMM != null) return DEFAULT_IMM;
        Class<IMM> clazz = IMM.class;
        synchronized (IMM.class) {
            if (DEFAULT_IMM != null) return DEFAULT_IMM;
            DEFAULT_IMM = new IMM(Configuration.getSystemConfiguration(null), Configuration.getSystemConfiguration(null).getGlobalSettings());
            // ** MonitorExit[var0] (shouldn't be in output)
            return DEFAULT_IMM;
        }
    }

    public boolean isIMMdate(Date date) {
        return this.isIMMdate(date, true);
    }

    public boolean isIMMdate(Date date, boolean mainCycle) {
        if (date.getWeekday() != Weekday.WEDNESDAY) {
            return false;
        }
        int d = date.getDayOfMonth();
        if (d < 15 || d > 21) {
            return false;
        }
        if (!mainCycle) {
            return true;
        }
        Month m = date.getMonthEnum();
        return m == Month.MARCH || m == Month.JUNE || m == Month.SEPTEMBER || m == Month.DECEMBER;
    }

    public boolean isIMMcode(String in) {
        return this.isIMMcode(in, true);
    }

    public boolean isIMMcode(String in, boolean mainCycle) {
        if (in.length() != 2) {
            return false;
        }
        if ("0123456789".indexOf(in.charAt(1)) == -1) {
            return false;
        }
        String str1 = mainCycle ? "hmzuHMZU" : "fghjkmnquvxzFGHJKMNQUVXZ";
        return str1.indexOf(in.charAt(0)) != -1;
    }

    public Date date(String immCode) {
        return this.date(immCode, Date.NULL_DATE);
    }

    public Date date(String immCode, Date refDate) {
        if (!this.isIMMcode(immCode, false)) {
            throw new IllegalArgumentException(immCode + " is not a valid IMM code");
        }
        Date referenceDate = Date.NULL_DATE.equals(refDate) ? this.settings.getEvaluationDate() : refDate;
        char code = immCode.charAt(0);
        Month m = Month.valueOf(code);
        int y = immCode.charAt(1) - 48;
        if (y == 0 && referenceDate.getYear() <= 1909) {
            y += 10;
        }
        int yMod = referenceDate.getYear() % 10;
        Date result = this.nextDate(DateFactory.getFactory().getDate(1, m, y += referenceDate.getYear() - yMod), false);
        if (result.lt(referenceDate)) {
            return this.nextDate(DateFactory.getFactory().getDate(1, m, y + 10), false);
        }
        return result;
    }

    public Date nextDate() {
        return this.nextDate(Date.NULL_DATE, true);
    }

    public Date nextDate(Date date) {
        return this.nextDate(date, true);
    }

    public Date nextDate(Date date, boolean mainCycle) {
        Date result;
        int m;
        Date refDate = Date.NULL_DATE.equals(date) ? this.settings.getEvaluationDate() : date;
        int y = refDate.getYear();
        int offset = mainCycle ? 3 : 1;
        int skipMonths = offset - (m = refDate.getMonth()) % offset;
        if (skipMonths != offset || refDate.getDayOfMonth() > 21) {
            if ((skipMonths += m) <= 12) {
                m = skipMonths;
            } else {
                m = skipMonths - 12;
                ++y;
            }
        }
        if ((result = DateFactory.getFactory().getNthWeekday(3, Weekday.WEDNESDAY, Month.valueOf(m), y)).le(refDate)) {
            result = this.nextDate(DateFactory.getFactory().getDate(22, Month.valueOf(m), y), mainCycle);
        }
        return result;
    }

    public Date nextDate(String immCode) {
        return this.nextDate(immCode, true, Date.NULL_DATE);
    }

    public Date nextDate(String immCode, boolean mainCycle) {
        return this.nextDate(immCode, mainCycle, Date.NULL_DATE);
    }

    public Date nextDate(String IMMcode, boolean mainCycle, Date referenceDate) {
        Date immDate = this.date(IMMcode, referenceDate);
        return this.nextDate(immDate.increment(), mainCycle);
    }

    public String nextCode() {
        return this.nextCode(Date.NULL_DATE);
    }

    public String nextCode(Date d) {
        return this.nextCode(d, true);
    }

    public String nextCode(Date d, boolean mainCycle) {
        Date date = this.nextDate(d, mainCycle);
        return this.code(date);
    }

    public String nextCode(String immCode) {
        return this.nextCode(immCode, true);
    }

    public String nextCode(String immCode, boolean mainCycle) {
        return this.nextCode(immCode, mainCycle, Date.NULL_DATE);
    }

    public String nextCode(String immCode, boolean mainCycle, Date referenceDate) {
        Date date = this.nextDate(immCode, mainCycle, referenceDate);
        return this.code(date);
    }

    public String code(Date date) {
        if (!this.isIMMdate(date, false)) {
            throw new IllegalArgumentException(date + " is not an IMM date");
        }
        int y = date.getYear() % 10;
        char code = date.getMonthEnum().getImmChar();
        StringBuilder sb = new StringBuilder();
        sb.append(code).append(y);
        String imm = sb.toString();
        if (this.configuration.isExtraSafetyChecks() && !this.isIMMcode(imm, false)) {
            throw new RuntimeException("the result is an invalid IMM code");
        }
        return imm;
    }
}

