/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.util.filesystem.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.aries.util.IORuntimeException;
import org.apache.aries.util.filesystem.ICloseableDirectory;
import org.apache.aries.util.filesystem.IDirectory;
import org.apache.aries.util.filesystem.IFile;
import org.apache.aries.util.filesystem.impl.ZipCloseableDirectory;
import org.apache.aries.util.filesystem.impl.ZipFileImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipDirectory
extends ZipFileImpl
implements IDirectory {
    private final IDirectory root;
    private final boolean zipRoot;

    public ZipDirectory(File zip1, ZipEntry entry1, ZipDirectory parent, ZipCloseableDirectory cache) {
        super(zip1, entry1, parent, cache);
        this.zipRoot = false;
        this.root = parent.getRoot();
    }

    public ZipDirectory(File fs, IDirectory parent) throws MalformedURLException {
        super(fs, parent);
        this.root = parent == null ? this : parent.getRoot();
        this.zipRoot = true;
    }

    public ZipDirectory(ZipDirectory other, ZipCloseableDirectory cache) {
        super(other, cache);
        this.root = other.root;
        this.zipRoot = other.zipRoot;
    }

    @Override
    public IFile getFile(String name) {
        ZipFileImpl result = null;
        String entryName = this.isZipRoot() ? name : this.getNameInZip() + "/" + name;
        ZipEntry entryFile = this.getEntry(entryName);
        if (entryFile != null) {
            result = !entryFile.isDirectory() ? new ZipFileImpl(this.zip, entryFile, this.buildParent(entryFile), this.cache) : new ZipDirectory(this.zip, entryFile, this.buildParent(entryFile), this.cache);
        }
        return result;
    }

    private ZipDirectory buildParent(ZipEntry foundEntry) {
        ZipDirectory result = this;
        String name = foundEntry.getName();
        name = name.substring(this.getNameInZip().length());
        String[] paths = name.split("/");
        StringBuilder baseBuilderCrapThingToGetRoundFindBugs = new StringBuilder(this.getNameInZip());
        if (!this.isZipRoot()) {
            baseBuilderCrapThingToGetRoundFindBugs.append('/');
        }
        if (paths != null && paths.length > 1) {
            for (int i = 0; i < paths.length - 1; ++i) {
                String path = paths[i];
                baseBuilderCrapThingToGetRoundFindBugs.append(path);
                ZipEntry dirEntry = this.getEntry(baseBuilderCrapThingToGetRoundFindBugs.toString());
                if (dirEntry == null) {
                    result = this;
                    break;
                }
                result = new ZipDirectory(this.zip, dirEntry, result, this.cache);
                baseBuilderCrapThingToGetRoundFindBugs.append('/');
            }
        }
        return result;
    }

    @Override
    public boolean isRoot() {
        return this.getParent() == null;
    }

    @Override
    public List<IFile> listFiles() {
        return this.listFiles(false);
    }

    @Override
    public List<IFile> listAllFiles() {
        return this.listFiles(true);
    }

    private List<IFile> listFiles(boolean includeFilesInNestedSubdirs) {
        ArrayList<IFile> files = new ArrayList<IFile>();
        ZipFile z = this.openZipFile();
        ArrayList<? extends ZipEntry> entries = Collections.list(z.entries());
        for (ZipEntry zipEntry : entries) {
            ZipDirectory parent;
            if (!ZipDirectory.isInDir(this.getNameInZip(), zipEntry, includeFilesInNestedSubdirs)) continue;
            ZipDirectory zipDirectory = parent = includeFilesInNestedSubdirs ? this.buildParent(zipEntry) : this;
            if (zipEntry.isDirectory()) {
                files.add(new ZipDirectory(this.zip, zipEntry, parent, this.cache));
                continue;
            }
            files.add(new ZipFileImpl(this.zip, zipEntry, parent, this.cache));
        }
        this.closeZipFile(z);
        return files;
    }

    protected static boolean isInDir(String parentDir, ZipEntry possibleEntry, boolean allowSubDirs) {
        String name = possibleEntry.getName();
        if (name.endsWith("/")) {
            name = name.substring(0, name.length() - 1);
        }
        boolean result = name.startsWith(parentDir) && !name.equals(parentDir) && (allowSubDirs || name.substring(parentDir.length() + 1).indexOf(47) == -1);
        return result;
    }

    @Override
    public Iterator<IFile> iterator() {
        return this.listFiles().iterator();
    }

    @Override
    public IDirectory convert() {
        return this;
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    @Override
    public boolean isFile() {
        return false;
    }

    @Override
    public InputStream open() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IDirectory getRoot() {
        return this.root;
    }

    public boolean isZipRoot() {
        return this.zipRoot;
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    private ZipEntry getEntry(String entryName) {
        ZipFile z = this.openZipFile();
        ZipEntry entryFile = null;
        if (z != null) {
            entryFile = z.getEntry(entryName);
            this.closeZipFile(z);
        }
        return entryFile;
    }

    @Override
    public ICloseableDirectory toCloseable() {
        try {
            return new ZipCloseableDirectory(this.zip, this);
        }
        catch (IOException e) {
            throw new IORuntimeException("IOException opening zip file: " + this, e);
        }
    }
}

