/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.concurrent;

import com.pi4j.concurrent.ExecutorServiceFactory;
import com.pi4j.concurrent.ScheduledExecutorServiceWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;

public class DefaultExecutorServiceFactory
implements ExecutorServiceFactory {
    public static int MAX_THREADS_IN_POOL = 25;
    private static List<ExecutorService> singleThreadExecutorServices = new ArrayList<ExecutorService>();
    private static ScheduledExecutorService scheduledExecutorService = null;
    private static ScheduledExecutorServiceWrapper executorServiceWrapper = null;

    private ThreadFactory getThreadFactory() {
        return Executors.defaultThreadFactory();
    }

    @Override
    public ScheduledExecutorService getScheduledExecutorService() {
        if (scheduledExecutorService == null) {
            scheduledExecutorService = Executors.newScheduledThreadPool(MAX_THREADS_IN_POOL, this.getThreadFactory());
            executorServiceWrapper = new ScheduledExecutorServiceWrapper(scheduledExecutorService);
        }
        return executorServiceWrapper;
    }

    @Override
    public ExecutorService newSingleThreadExecutorService() {
        ExecutorService singleThreadExecutorService = Executors.newSingleThreadExecutor(this.getThreadFactory());
        singleThreadExecutorServices.add(singleThreadExecutorService);
        return singleThreadExecutorService;
    }

    @Override
    public void shutdown() {
        for (ExecutorService singleThreadExecutorService : singleThreadExecutorServices) {
            if (singleThreadExecutorService == null || singleThreadExecutorService.isShutdown()) continue;
            singleThreadExecutorService.shutdownNow();
        }
        if (scheduledExecutorService != null && !scheduledExecutorService.isShutdown()) {
            scheduledExecutorService.shutdownNow();
        }
    }
}

