/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.obr.plugin;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.felix.obr.plugin.Capability;
import org.apache.felix.obr.plugin.PElement;
import org.apache.felix.obr.plugin.Require;
import org.apache.maven.plugin.MojoExecutionException;
import org.osgi.impl.bundle.obr.resource.BundleInfo;
import org.osgi.impl.bundle.obr.resource.CapabilityImpl;
import org.osgi.impl.bundle.obr.resource.RepositoryImpl;
import org.osgi.impl.bundle.obr.resource.RequirementImpl;
import org.osgi.impl.bundle.obr.resource.ResourceImpl;

public class ExtractBindexInfo {
    private ResourceImpl m_resource = null;
    static /* synthetic */ Class class$org$osgi$impl$bundle$obr$resource$VersionRange;

    public ExtractBindexInfo(URI repoFilename, String outFile) throws MojoExecutionException {
        RepositoryImpl repository = null;
        try {
            repository = new RepositoryImpl(new File(repoFilename).getAbsoluteFile().toURL());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            throw new MojoExecutionException("MalformedURLException");
        }
        BundleInfo info = null;
        try {
            info = new BundleInfo(repository, new File(outFile));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MojoExecutionException("Exception");
        }
        try {
            this.m_resource = info.build();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MojoExecutionException("Exception");
        }
    }

    private String parseFilter(String filter) {
        filter.replaceAll("&", "&amp");
        filter.replaceAll(">=", "&gt");
        return filter;
    }

    public List getCapabilities() {
        ArrayList<Capability> list = new ArrayList<Capability>();
        Collection res = this.m_resource.getCapabilityList();
        Iterator it = res.iterator();
        while (it.hasNext()) {
            Capability capability = new Capability();
            CapabilityImpl ci = (CapabilityImpl)it.next();
            capability.setName(ci.getName());
            if (ci.getName().compareTo("bundle") == 0) continue;
            Map properties = ci.getProperties();
            Iterator k = properties.keySet().iterator();
            while (k.hasNext()) {
                PElement p = new PElement();
                String key = (String)k.next();
                List values = (List)properties.get(key);
                Iterator v = values.iterator();
                while (v.hasNext()) {
                    Object value = v.next();
                    p.setN(key);
                    if (value != null) {
                        p.setV(value.toString());
                    } else {
                        System.out.println("Missing value " + key);
                    }
                    String type = null;
                    if (value instanceof Number) {
                        type = "number";
                    } else if (value.getClass() == (class$org$osgi$impl$bundle$obr$resource$VersionRange == null ? ExtractBindexInfo.class$("org.osgi.impl.bundle.obr.resource.VersionRange") : class$org$osgi$impl$bundle$obr$resource$VersionRange)) {
                        type = "version";
                    }
                    if (type == null) continue;
                    p.setT(type);
                }
                capability.addP(p);
            }
            list.add(capability);
        }
        return list;
    }

    public List getRequirement() {
        ArrayList<Require> list = new ArrayList<Require>();
        Collection res = this.m_resource.getRequirementList();
        Iterator it = res.iterator();
        while (it.hasNext()) {
            RequirementImpl ci = (RequirementImpl)it.next();
            Require require = new Require();
            require.setExtend(String.valueOf(ci.isExtend()));
            require.setMultiple(String.valueOf(ci.isMultiple()));
            require.setOptional(String.valueOf(ci.isOptional()));
            require.setName(ci.getName());
            require.setFilter(this.parseFilter(ci.getFilter()));
            require.setValue(ci.getComment());
            list.add(require);
        }
        return list;
    }

    public String getSymbolicName() {
        return this.m_resource.getSymbolicName();
    }

    public String getVersion() {
        if (this.m_resource.getVersion() != null) {
            return this.m_resource.getVersion().toString();
        }
        return null;
    }

    public String getPresentationName() {
        return this.m_resource.getPresentationName();
    }

    public String getCopyright() {
        return this.m_resource.getCopyright();
    }

    public String getDescription() {
        return this.m_resource.getDescription();
    }

    public String getDocumentation() {
        if (this.m_resource.getDocumentation() != null) {
            return this.m_resource.getDocumentation().toString();
        }
        return null;
    }

    public String getLicense() {
        if (this.m_resource.getLicense() != null) {
            return this.m_resource.getLicense().toString();
        }
        return null;
    }

    public String getSource() {
        if (this.m_resource.getSource() != null) {
            return this.m_resource.getSource().toString();
        }
        return null;
    }

    public String getId() {
        if (this.m_resource.getId() != null) {
            return this.m_resource.getId();
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

