/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tenant;

import com.alibaba.rcm.Constraint;
import com.alibaba.rcm.ResourceContainer;
import com.alibaba.rcm.ResourceContainerFactory;
import com.alibaba.tenant.TenantConfiguration;
import com.alibaba.tenant.TenantContainer;
import com.alibaba.tenant.TenantResourceContainer;

public class TenantContainerFactory
implements ResourceContainerFactory {
    @Override
    public TenantResourceContainer createContainer(Iterable<Constraint> iterable) {
        TenantContainer tenantContainer = TenantContainer.create(new TenantConfiguration(iterable));
        return tenantContainer.resourceContainer;
    }

    public static TenantContainer tenantContainerOf(ResourceContainer resourceContainer) {
        if (!(resourceContainer instanceof TenantResourceContainer)) {
            throw new IllegalArgumentException("Incoming ResourceContainer is not for MultiTenant");
        }
        return ((TenantResourceContainer)resourceContainer).getTenant();
    }

    private TenantContainerFactory() {
    }

    public static TenantContainerFactory instance() {
        return Holder.INSTANCE;
    }

    private static final class Holder {
        private static final TenantContainerFactory INSTANCE = new TenantContainerFactory();

        private Holder() {
        }
    }
}

