/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;

public class LinkedBlockingDeque<E>
extends AbstractQueue<E>
implements BlockingDeque<E>,
Serializable {
    private static final long serialVersionUID = -387911632671998426L;
    transient Node<E> first;
    transient Node<E> last;
    private transient int count;
    private final int capacity;
    final ReentrantLock lock = new ReentrantLock();
    private final Condition notEmpty = this.lock.newCondition();
    private final Condition notFull = this.lock.newCondition();

    int getCapacity() {
        return this.capacity;
    }

    public LinkedBlockingDeque() {
        this(Integer.MAX_VALUE);
    }

    public LinkedBlockingDeque(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.capacity = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedBlockingDeque(Collection<? extends E> collection) {
        this(Integer.MAX_VALUE);
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            for (E e : collection) {
                if (e == null) {
                    throw new NullPointerException();
                }
                if (super.linkLast(new Node<E>(e))) continue;
                throw new IllegalStateException("Deque full");
            }
        }
        finally {
            reentrantLock.unlock();
        }
    }

    private boolean linkFirst(Node<E> node) {
        if (this.count >= this.capacity) {
            return false;
        }
        Node<E> node2 = this.first;
        node.next = node2;
        this.first = node;
        if (this.last == null) {
            this.last = node;
        } else {
            node2.prev = node;
        }
        ++this.count;
        this.notEmpty.signal();
        return true;
    }

    private boolean linkLast(Node<E> node) {
        if (this.count >= this.capacity) {
            return false;
        }
        Node<E> node2 = this.last;
        node.prev = node2;
        this.last = node;
        if (this.first == null) {
            this.first = node;
        } else {
            node2.next = node;
        }
        ++this.count;
        this.notEmpty.signal();
        return true;
    }

    private E unlinkFirst() {
        Node<E> node = this.first;
        if (node == null) {
            return null;
        }
        Node node2 = node.next;
        Object e = node.item;
        node.item = null;
        node.next = node;
        this.first = node2;
        if (node2 == null) {
            this.last = null;
        } else {
            node2.prev = null;
        }
        --this.count;
        this.notFull.signal();
        return e;
    }

    private E unlinkLast() {
        Node<E> node = this.last;
        if (node == null) {
            return null;
        }
        Node node2 = node.prev;
        Object e = node.item;
        node.item = null;
        node.prev = node;
        this.last = node2;
        if (node2 == null) {
            this.first = null;
        } else {
            node2.next = null;
        }
        --this.count;
        this.notFull.signal();
        return e;
    }

    void unlink(Node<E> node) {
        Node node2 = node.prev;
        Node node3 = node.next;
        if (node2 == null) {
            this.unlinkFirst();
        } else if (node3 == null) {
            this.unlinkLast();
        } else {
            node2.next = node3;
            node3.prev = node2;
            node.item = null;
            --this.count;
            this.notFull.signal();
        }
    }

    @Override
    public void addFirst(E e) {
        if (!this.offerFirst(e)) {
            throw new IllegalStateException("Deque full");
        }
    }

    @Override
    public void addLast(E e) {
        if (!this.offerLast(e)) {
            throw new IllegalStateException("Deque full");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offerFirst(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        Node<E> node = new Node<E>(e);
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            boolean bl = this.linkFirst(node);
            return bl;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offerLast(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        Node<E> node = new Node<E>(e);
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            boolean bl = this.linkLast(node);
            return bl;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putFirst(E e) throws InterruptedException {
        if (e == null) {
            throw new NullPointerException();
        }
        Node<E> node = new Node<E>(e);
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            while (!this.linkFirst(node)) {
                this.notFull.await();
            }
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putLast(E e) throws InterruptedException {
        if (e == null) {
            throw new NullPointerException();
        }
        Node<E> node = new Node<E>(e);
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            while (!this.linkLast(node)) {
                this.notFull.await();
            }
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offerFirst(E e, long l, TimeUnit timeUnit) throws InterruptedException {
        if (e == null) {
            throw new NullPointerException();
        }
        Node<E> node = new Node<E>(e);
        long l2 = timeUnit.toNanos(l);
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lockInterruptibly();
        try {
            while (!this.linkFirst(node)) {
                if (l2 <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                l2 = this.notFull.awaitNanos(l2);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offerLast(E e, long l, TimeUnit timeUnit) throws InterruptedException {
        if (e == null) {
            throw new NullPointerException();
        }
        Node<E> node = new Node<E>(e);
        long l2 = timeUnit.toNanos(l);
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lockInterruptibly();
        try {
            while (!this.linkLast(node)) {
                if (l2 <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                l2 = this.notFull.awaitNanos(l2);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public E removeFirst() {
        E e = this.pollFirst();
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e;
    }

    @Override
    public E removeLast() {
        E e = this.pollLast();
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e;
    }

    @Override
    public E pollFirst() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            E e = this.unlinkFirst();
            return e;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public E pollLast() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            E e = this.unlinkLast();
            return e;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E takeFirst() throws InterruptedException {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            E e;
            while ((e = this.unlinkFirst()) == null) {
                this.notEmpty.await();
            }
            E e2 = e;
            return e2;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E takeLast() throws InterruptedException {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            E e;
            while ((e = this.unlinkLast()) == null) {
                this.notEmpty.await();
            }
            E e2 = e;
            return e2;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E pollFirst(long l, TimeUnit timeUnit) throws InterruptedException {
        long l2 = timeUnit.toNanos(l);
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lockInterruptibly();
        try {
            E e;
            while ((e = this.unlinkFirst()) == null) {
                if (l2 <= 0L) {
                    E e2 = null;
                    return e2;
                }
                l2 = this.notEmpty.awaitNanos(l2);
            }
            E e3 = e;
            return e3;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E pollLast(long l, TimeUnit timeUnit) throws InterruptedException {
        long l2 = timeUnit.toNanos(l);
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lockInterruptibly();
        try {
            E e;
            while ((e = this.unlinkLast()) == null) {
                if (l2 <= 0L) {
                    E e2 = null;
                    return e2;
                }
                l2 = this.notEmpty.awaitNanos(l2);
            }
            E e3 = e;
            return e3;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public E getFirst() {
        E e = this.peekFirst();
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e;
    }

    @Override
    public E getLast() {
        E e = this.peekLast();
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e;
    }

    @Override
    public E peekFirst() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            E e = this.first == null ? null : (E)this.first.item;
            return e;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public E peekLast() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            E e = this.last == null ? null : (E)this.last.item;
            return e;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeFirstOccurrence(Object object) {
        if (object == null) {
            return false;
        }
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            Node<E> node = this.first;
            while (node != null) {
                if (object.equals(node.item)) {
                    this.unlink(node);
                    boolean bl = true;
                    return bl;
                }
                node = node.next;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeLastOccurrence(Object object) {
        if (object == null) {
            return false;
        }
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            Node<E> node = this.last;
            while (node != null) {
                if (object.equals(node.item)) {
                    this.unlink(node);
                    boolean bl = true;
                    return bl;
                }
                node = node.prev;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public boolean add(E e) {
        this.addLast(e);
        return true;
    }

    @Override
    public boolean offer(E e) {
        return this.offerLast(e);
    }

    @Override
    public void put(E e) throws InterruptedException {
        this.putLast(e);
    }

    @Override
    public boolean offer(E e, long l, TimeUnit timeUnit) throws InterruptedException {
        return this.offerLast(e, l, timeUnit);
    }

    @Override
    public E remove() {
        return this.removeFirst();
    }

    @Override
    public E poll() {
        return this.pollFirst();
    }

    @Override
    public E take() throws InterruptedException {
        return this.takeFirst();
    }

    @Override
    public E poll(long l, TimeUnit timeUnit) throws InterruptedException {
        return this.pollFirst(l, timeUnit);
    }

    @Override
    public E element() {
        return this.getFirst();
    }

    @Override
    public E peek() {
        return this.peekFirst();
    }

    @Override
    public int remainingCapacity() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            int n = this.capacity - this.count;
            return n;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public int drainTo(Collection<? super E> collection) {
        return this.drainTo(collection, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> collection, int n) {
        if (collection == null) {
            throw new NullPointerException();
        }
        if (collection == this) {
            throw new IllegalArgumentException();
        }
        if (n <= 0) {
            return 0;
        }
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            int n2;
            int n3 = Math.min(n, this.count);
            for (n2 = 0; n2 < n3; ++n2) {
                collection.add(this.first.item);
                this.unlinkFirst();
            }
            n2 = n3;
            return n2;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public void push(E e) {
        this.addFirst(e);
    }

    @Override
    public E pop() {
        return this.removeFirst();
    }

    @Override
    public boolean remove(Object object) {
        return this.removeFirstOccurrence(object);
    }

    @Override
    public int size() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            int n = this.count;
            return n;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object object) {
        if (object == null) {
            return false;
        }
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            Node<E> node = this.first;
            while (node != null) {
                if (object.equals(node.item)) {
                    boolean bl = true;
                    return bl;
                }
                node = node.next;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            Object[] objectArray = new Object[this.count];
            int n = 0;
            Object object = this.first;
            while (object != null) {
                objectArray[n++] = object.item;
                object = object.next;
            }
            object = objectArray;
            return object;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] objectArray) {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            if (objectArray.length < this.count) {
                objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.count);
            }
            int n = 0;
            Object object = this.first;
            while (object != null) {
                objectArray[n++] = object.item;
                object = object.next;
            }
            if (objectArray.length > n) {
                objectArray[n] = null;
            }
            object = objectArray;
            return object;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public String toString() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            Node<E> node = this.first;
            if (node == null) {
                String string = "[]";
                return string;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('[');
            while (true) {
                Object e;
                stringBuilder.append((Object)((e = node.item) == this ? "(this Collection)" : e));
                node = node.next;
                if (node == null) {
                    String string = stringBuilder.append(']').toString();
                    return string;
                }
                stringBuilder.append(',').append(' ');
            }
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            Node<E> node = this.first;
            while (node != null) {
                node.item = null;
                Node node2 = node.next;
                node.prev = null;
                node.next = null;
                node = node2;
            }
            this.last = null;
            this.first = null;
            this.count = 0;
            this.notFull.signalAll();
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr();
    }

    @Override
    public Iterator<E> descendingIterator() {
        return new DescendingItr();
    }

    @Override
    public Spliterator<E> spliterator() {
        return new LBDSpliterator(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            objectOutputStream.defaultWriteObject();
            Node<E> node = this.first;
            while (node != null) {
                objectOutputStream.writeObject(node.item);
                node = node.next;
            }
            objectOutputStream.writeObject(null);
        }
        finally {
            reentrantLock.unlock();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object object;
        objectInputStream.defaultReadObject();
        this.count = 0;
        this.first = null;
        this.last = null;
        while ((object = objectInputStream.readObject()) != null) {
            this.add(object);
        }
    }

    static final class LBDSpliterator<E>
    implements Spliterator<E> {
        static final int MAX_BATCH = 0x2000000;
        final LinkedBlockingDeque<E> queue;
        Node<E> current;
        int batch;
        boolean exhausted;
        long est;

        LBDSpliterator(LinkedBlockingDeque<E> linkedBlockingDeque) {
            this.queue = linkedBlockingDeque;
            this.est = linkedBlockingDeque.size();
        }

        @Override
        public long estimateSize() {
            return this.est;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Spliterator<E> trySplit() {
            Node<E> node;
            int n;
            LinkedBlockingDeque<E> linkedBlockingDeque = this.queue;
            int n2 = this.batch;
            int n3 = n2 <= 0 ? 1 : (n = n2 >= 0x2000000 ? 0x2000000 : n2 + 1);
            if (!(this.exhausted || (node = this.current) == null && (node = linkedBlockingDeque.first) == null || node.next == null)) {
                Object[] objectArray = new Object[n];
                ReentrantLock reentrantLock = linkedBlockingDeque.lock;
                int n4 = 0;
                Node<E> node2 = this.current;
                reentrantLock.lock();
                try {
                    if (node2 != null || (node2 = linkedBlockingDeque.first) != null) {
                        do {
                            if ((objectArray[n4] = node2.item) == null) continue;
                            ++n4;
                        } while ((node2 = node2.next) != null && n4 < n);
                    }
                }
                finally {
                    reentrantLock.unlock();
                }
                this.current = node2;
                if (this.current == null) {
                    this.est = 0L;
                    this.exhausted = true;
                } else if ((this.est -= (long)n4) < 0L) {
                    this.est = 0L;
                }
                if (n4 > 0) {
                    this.batch = n4;
                    return Spliterators.spliterator(objectArray, 0, n4, 4368);
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void forEachRemaining(Consumer<? super E> consumer) {
            if (consumer == null) {
                throw new NullPointerException();
            }
            LinkedBlockingDeque<E> linkedBlockingDeque = this.queue;
            ReentrantLock reentrantLock = linkedBlockingDeque.lock;
            if (!this.exhausted) {
                this.exhausted = true;
                Node<E> node = this.current;
                do {
                    Object t = null;
                    reentrantLock.lock();
                    try {
                        if (node == null) {
                            node = linkedBlockingDeque.first;
                        }
                        while (node != null) {
                            t = node.item;
                            node = node.next;
                            if (t == null) continue;
                            break;
                        }
                    }
                    finally {
                        reentrantLock.unlock();
                    }
                    if (t == null) continue;
                    consumer.accept(t);
                } while (node != null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean tryAdvance(Consumer<? super E> consumer) {
            if (consumer == null) {
                throw new NullPointerException();
            }
            LinkedBlockingDeque<E> linkedBlockingDeque = this.queue;
            ReentrantLock reentrantLock = linkedBlockingDeque.lock;
            if (!this.exhausted) {
                Object t = null;
                reentrantLock.lock();
                try {
                    if (this.current == null) {
                        this.current = linkedBlockingDeque.first;
                    }
                    while (this.current != null) {
                        t = this.current.item;
                        this.current = this.current.next;
                        if (t == null) continue;
                        break;
                    }
                }
                finally {
                    reentrantLock.unlock();
                }
                if (this.current == null) {
                    this.exhausted = true;
                }
                if (t != null) {
                    consumer.accept(t);
                    return true;
                }
            }
            return false;
        }

        @Override
        public int characteristics() {
            return 4368;
        }
    }

    private class DescendingItr
    extends AbstractItr {
        private DescendingItr() {
        }

        @Override
        Node<E> firstNode() {
            return LinkedBlockingDeque.this.last;
        }

        @Override
        Node<E> nextNode(Node<E> node) {
            return node.prev;
        }
    }

    private class Itr
    extends AbstractItr {
        private Itr() {
        }

        @Override
        Node<E> firstNode() {
            return LinkedBlockingDeque.this.first;
        }

        @Override
        Node<E> nextNode(Node<E> node) {
            return node.next;
        }
    }

    private abstract class AbstractItr
    implements Iterator<E> {
        Node<E> next;
        E nextItem;
        private Node<E> lastRet;

        abstract Node<E> firstNode();

        abstract Node<E> nextNode(Node<E> var1);

        AbstractItr() {
            ReentrantLock reentrantLock = LinkedBlockingDeque.this.lock;
            reentrantLock.lock();
            try {
                this.next = this.firstNode();
                this.nextItem = this.next == null ? null : this.next.item;
            }
            finally {
                reentrantLock.unlock();
            }
        }

        private Node<E> succ(Node<E> node) {
            Node node2;
            while ((node2 = this.nextNode(node)) != null) {
                if (node2.item != null) {
                    return node2;
                }
                if (node2 == node) {
                    return this.firstNode();
                }
                node = node2;
            }
            return null;
        }

        void advance() {
            ReentrantLock reentrantLock = LinkedBlockingDeque.this.lock;
            reentrantLock.lock();
            try {
                this.next = this.succ(this.next);
                this.nextItem = this.next == null ? null : this.next.item;
            }
            finally {
                reentrantLock.unlock();
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public E next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            this.lastRet = this.next;
            Object e = this.nextItem;
            this.advance();
            return e;
        }

        @Override
        public void remove() {
            Node node = this.lastRet;
            if (node == null) {
                throw new IllegalStateException();
            }
            this.lastRet = null;
            ReentrantLock reentrantLock = LinkedBlockingDeque.this.lock;
            reentrantLock.lock();
            try {
                if (node.item != null) {
                    LinkedBlockingDeque.this.unlink(node);
                }
            }
            finally {
                reentrantLock.unlock();
            }
        }
    }

    static final class Node<E> {
        E item;
        Node<E> prev;
        Node<E> next;

        Node(E e) {
            this.item = e;
        }
    }
}

