/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch.rdma;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketOption;
import java.net.SocketTimeoutException;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.SocketChannel;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.TimeUnit;
import sun.misc.SharedSecrets;
import sun.nio.ch.ChannelInputStream;
import sun.nio.ch.NetAccess;
import sun.nio.ch.rdma.RdmaSocketChannelImpl;

class RdmaSocketAdaptor
extends Socket {
    private final RdmaSocketChannelImpl sc;
    private volatile int timeout;
    private static final NetAccess NET_ACCESS = SharedSecrets.getNetAccess();
    private InputStream socketInputStream = null;

    private RdmaSocketAdaptor(RdmaSocketChannelImpl rdmaSocketChannelImpl) throws SocketException {
        super((SocketImpl)null);
        this.sc = rdmaSocketChannelImpl;
    }

    public static Socket create(RdmaSocketChannelImpl rdmaSocketChannelImpl) {
        try {
            return new RdmaSocketAdaptor(rdmaSocketChannelImpl);
        }
        catch (SocketException socketException) {
            throw new InternalError("Should not reach here");
        }
    }

    @Override
    public SocketChannel getChannel() {
        return this.sc;
    }

    @Override
    public void connect(SocketAddress socketAddress) throws IOException {
        this.connect(socketAddress, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void connect(SocketAddress socketAddress, int n) throws IOException {
        long l;
        long l2;
        if (socketAddress == null) {
            throw new IllegalArgumentException("connect: The address can't be null");
        }
        if (n < 0) {
            throw new IllegalArgumentException("connect: timeout can't be negative");
        }
        Object object = this.sc.blockingLock();
        // MONITORENTER : object
        if (!this.sc.isBlocking()) {
            throw new IllegalBlockingModeException();
        }
        try {
            block22: {
                if (n == 0) {
                    this.sc.connect(socketAddress);
                    // MONITOREXIT : object
                    return;
                }
                this.sc.configureBlocking(false);
                try {
                    if (!this.sc.connect(socketAddress)) break block22;
                }
                catch (Throwable throwable) {
                    try {
                        this.sc.configureBlocking(true);
                        throw throwable;
                    }
                    catch (ClosedChannelException closedChannelException) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    this.sc.configureBlocking(true);
                    return;
                }
                catch (ClosedChannelException closedChannelException) {
                    // empty catch block
                }
                return;
            }
            try {
                this.sc.configureBlocking(true);
            }
            catch (ClosedChannelException closedChannelException) {}
            l2 = TimeUnit.NANOSECONDS.convert(n, TimeUnit.MILLISECONDS);
            l = n;
        }
        catch (Exception exception) {
            NET_ACCESS.translateException(exception, true);
            return;
        }
        while (true) {
            long l3 = System.nanoTime();
            if (this.sc.pollConnected(l)) {
                boolean bl = this.sc.finishConnect();
                assert (bl);
                return;
            }
            if ((l2 -= System.nanoTime() - l3) <= 0L) {
                try {
                    this.sc.close();
                    throw new SocketTimeoutException();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw new SocketTimeoutException();
            }
            l = TimeUnit.MILLISECONDS.convert(l2, TimeUnit.NANOSECONDS);
        }
    }

    @Override
    public void bind(SocketAddress socketAddress) throws IOException {
        try {
            this.sc.bind(socketAddress);
        }
        catch (Exception exception) {
            NET_ACCESS.translateException(exception);
        }
    }

    @Override
    public InetAddress getInetAddress() {
        InetSocketAddress inetSocketAddress = this.sc.remoteAddress();
        if (inetSocketAddress == null) {
            return null;
        }
        return inetSocketAddress.getAddress();
    }

    @Override
    public InetAddress getLocalAddress() {
        InetSocketAddress inetSocketAddress;
        if (this.sc.isOpen() && (inetSocketAddress = this.sc.localAddress()) != null) {
            return NET_ACCESS.getRevealedLocalAddress(inetSocketAddress).getAddress();
        }
        return new InetSocketAddress(0).getAddress();
    }

    @Override
    public int getPort() {
        InetSocketAddress inetSocketAddress = this.sc.remoteAddress();
        if (inetSocketAddress == null) {
            return 0;
        }
        return inetSocketAddress.getPort();
    }

    @Override
    public int getLocalPort() {
        InetSocketAddress inetSocketAddress = this.sc.localAddress();
        if (inetSocketAddress == null) {
            return -1;
        }
        return inetSocketAddress.getPort();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (!this.sc.isOpen()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.sc.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        if (!this.sc.isInputOpen()) {
            throw new SocketException("Socket input is shutdown");
        }
        if (this.socketInputStream == null) {
            try {
                this.socketInputStream = AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                    @Override
                    public InputStream run() throws IOException {
                        return new SocketInputStream();
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (IOException)privilegedActionException.getException();
            }
        }
        return this.socketInputStream;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (!this.sc.isOpen()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.sc.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        if (!this.sc.isOutputOpen()) {
            throw new SocketException("Socket output is shutdown");
        }
        OutputStream outputStream = null;
        try {
            outputStream = AccessController.doPrivileged(new PrivilegedExceptionAction<OutputStream>(){

                @Override
                public OutputStream run() throws IOException {
                    return Channels.newOutputStream(RdmaSocketAdaptor.this.sc);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
        return outputStream;
    }

    private void setBooleanOption(SocketOption<Boolean> socketOption, boolean bl) throws SocketException {
        try {
            this.sc.setOption((SocketOption)socketOption, (Object)bl);
        }
        catch (IOException iOException) {
            NET_ACCESS.translateToSocketException(iOException);
        }
    }

    private void setIntOption(SocketOption<Integer> socketOption, int n) throws SocketException {
        try {
            this.sc.setOption((SocketOption)socketOption, (Object)n);
        }
        catch (IOException iOException) {
            NET_ACCESS.translateToSocketException(iOException);
        }
    }

    private boolean getBooleanOption(SocketOption<Boolean> socketOption) throws SocketException {
        try {
            return this.sc.getOption(socketOption);
        }
        catch (IOException iOException) {
            NET_ACCESS.translateToSocketException(iOException);
            return false;
        }
    }

    private int getIntOption(SocketOption<Integer> socketOption) throws SocketException {
        try {
            return this.sc.getOption(socketOption);
        }
        catch (IOException iOException) {
            NET_ACCESS.translateToSocketException(iOException);
            return -1;
        }
    }

    @Override
    public void setTcpNoDelay(boolean bl) throws SocketException {
        this.setBooleanOption(StandardSocketOptions.TCP_NODELAY, bl);
    }

    @Override
    public boolean getTcpNoDelay() throws SocketException {
        return this.getBooleanOption(StandardSocketOptions.TCP_NODELAY);
    }

    @Override
    public void sendUrgentData(int n) throws IOException {
        int n2 = this.sc.sendOutOfBandData((byte)n);
        if (n2 == 0) {
            throw new IOException("Socket buffer full");
        }
    }

    @Override
    public void setSoTimeout(int n) throws SocketException {
        if (n < 0) {
            throw new IllegalArgumentException("timeout can't be negative");
        }
        this.timeout = n;
    }

    @Override
    public int getSoTimeout() throws SocketException {
        return this.timeout;
    }

    @Override
    public void setSendBufferSize(int n) throws SocketException {
        if (n <= 0) {
            throw new IllegalArgumentException("Invalid send size");
        }
        this.setIntOption(StandardSocketOptions.SO_SNDBUF, n);
    }

    @Override
    public int getSendBufferSize() throws SocketException {
        return this.getIntOption(StandardSocketOptions.SO_SNDBUF);
    }

    @Override
    public void setReceiveBufferSize(int n) throws SocketException {
        if (n <= 0) {
            throw new IllegalArgumentException("Invalid receive size");
        }
        this.setIntOption(StandardSocketOptions.SO_RCVBUF, n);
    }

    @Override
    public int getReceiveBufferSize() throws SocketException {
        return this.getIntOption(StandardSocketOptions.SO_RCVBUF);
    }

    @Override
    public void setReuseAddress(boolean bl) throws SocketException {
        this.setBooleanOption(StandardSocketOptions.SO_REUSEADDR, bl);
    }

    @Override
    public boolean getReuseAddress() throws SocketException {
        return this.getBooleanOption(StandardSocketOptions.SO_REUSEADDR);
    }

    @Override
    public void close() throws IOException {
        this.sc.close();
    }

    @Override
    public void shutdownInput() throws IOException {
        try {
            this.sc.shutdownInput();
        }
        catch (Exception exception) {
            NET_ACCESS.translateException(exception);
        }
    }

    @Override
    public void shutdownOutput() throws IOException {
        try {
            this.sc.shutdownOutput();
        }
        catch (Exception exception) {
            NET_ACCESS.translateException(exception);
        }
    }

    @Override
    public String toString() {
        if (this.sc.isConnected()) {
            return "RdmaSocket[addr=" + this.getInetAddress() + ",port=" + this.getPort() + ",localport=" + this.getLocalPort() + "]";
        }
        return "RdmaSocket[unconnected]";
    }

    @Override
    public boolean isConnected() {
        return this.sc.isConnected();
    }

    @Override
    public boolean isBound() {
        return this.sc.localAddress() != null;
    }

    @Override
    public boolean isClosed() {
        return !this.sc.isOpen();
    }

    @Override
    public boolean isInputShutdown() {
        return !this.sc.isInputOpen();
    }

    @Override
    public boolean isOutputShutdown() {
        return !this.sc.isOutputOpen();
    }

    private class SocketInputStream
    extends ChannelInputStream {
        private SocketInputStream() {
            super(RdmaSocketAdaptor.this.sc);
        }

        @Override
        protected int read(ByteBuffer byteBuffer) throws IOException {
            Object object = RdmaSocketAdaptor.this.sc.blockingLock();
            synchronized (object) {
                if (!RdmaSocketAdaptor.this.sc.isBlocking()) {
                    throw new IllegalBlockingModeException();
                }
                long l = RdmaSocketAdaptor.this.timeout;
                if (l == 0L) {
                    return RdmaSocketAdaptor.this.sc.read(byteBuffer);
                }
                long l2 = TimeUnit.NANOSECONDS.convert(l, TimeUnit.MILLISECONDS);
                while (true) {
                    long l3 = System.nanoTime();
                    if (RdmaSocketAdaptor.this.sc.pollRead(l)) {
                        return RdmaSocketAdaptor.this.sc.read(byteBuffer);
                    }
                    if ((l2 -= System.nanoTime() - l3) <= 0L) {
                        throw new SocketTimeoutException();
                    }
                    l = TimeUnit.MILLISECONDS.convert(l2, TimeUnit.NANOSECONDS);
                }
            }
        }
    }
}

