#!/bin/bash
# Copyright 2015 gRPC authors.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Builds Java interop server and client in a base image.
set -e

cp -r /var/local/jenkins/grpc-java /tmp/grpc-java

# copy service account keys if available
cp -r /var/local/jenkins/service_account $HOME || true

pushd /tmp/grpc-java
./gradlew --no-daemon :grpc-interop-testing:installDist -PskipCodegen=true

mkdir -p /var/local/git/grpc-java/
cp -r --parents -t /var/local/git/grpc-java/ \
    interop-testing/build/install/ \
    run-test-client.sh \
    run-test-server.sh

popd
rm -r /tmp/grpc-java
rm -r "$HOME/.gradle"

# enable extra java logging
mkdir -p /var/local/grpc_java_logging
echo "handlers = java.util.logging.ConsoleHandler
java.util.logging.ConsoleHandler.level = ALL
.level = FINE
io.grpc.netty.NettyClientHandler = ALL
io.grpc.netty.NettyServerHandler = ALL" > /var/local/grpc_java_logging/logconf.txt
  
